
<figure class="headerCart-body ShowCart ">
    <button class="closed closedCart"><i class="fa-solid fa-xmark"></i></button>

    <figure class="cartProduct-wrapper mb-50">
        <div class="small-tittle mb-40">
            <h2 class="tittle"><?php echo e(__('Cart List items')); ?></h2>
        </div>
        <?php
            $cart = \Gloudemans\Shoppingcart\Facades\Cart::instance("default")->content();
            $cart_subtotal = \Gloudemans\Shoppingcart\Facades\Cart::instance("default")->subtotal();
       ?>
        <?php $__empty_1 = true; $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $product = \Modules\Product\Entities\Product::findOrFail($cart_item->id);
                $details_route = route('tenant.shop.product.details',$product->slug);
            ?>
            <figure class="singleCartproduct">
                <div class="proImg">
                    <a href="<?php echo e($details_route); ?>">
                        <?php echo render_image_markup_by_attachment_id($cart_item?->options?->image); ?>

                    </a>
                </div>
                <figcaption class="proDiscription">
                    <div class="cap">
                        <a href="<?php echo e($details_route); ?>" class="title"><?php echo e(Str::words($cart_item->name, 5)); ?> </a>
                        <span class="price"> <?php echo e(amount_with_currency_symbol($cart_item->price)); ?></span>

                        <div class="cartCap">
                            <span class="name-subtitle d-block mt-2">
                                        <?php if($cart_item?->options?->color_name): ?>
                                    <?php echo e(__('Color:')); ?> <?php echo e($cart_item?->options?->color_name); ?>,
                                <?php endif; ?>

                                <?php if($cart_item?->options?->size_name): ?>
                                    <?php echo e(__('Size:')); ?> <?php echo e($cart_item?->options?->size_name); ?>

                                <?php endif; ?>

                                <?php if($cart_item?->options?->attributes): ?>
                                    <br>
                                    <?php $__currentLoopData = $cart_item?->options?->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($key.':'); ?> <?php echo e($attribute); ?><?php echo e(!$loop->last ? ',' : ''); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                     </span>
                        </div>
                    </div>
                    <div class="deleteProduct top_right_close_table_cart" data-product_hash_id="<?php echo e($cart_item->rowId); ?>">
                        <i class="fa-solid fa-xmark"></i>
                    </div>
                </figcaption>
            </figure>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <figure class="singleCartproduct">
                <p class="text-center"><?php echo e(__('No Item in Cart')); ?></p>
            </figure>
        <?php endif; ?>



        <!-- price -->
        <?php if($cart->count() != 0): ?>
        <div class="totalPriceCart">
            <p class="subtotal"><?php echo e(__('subtotal')); ?></p> <span class="total"><?php echo e(site_currency_symbol().$cart_subtotal); ?> </span>
        </div>
        <?php endif; ?>
        <div class="btn-wrapper">
            <a href="<?php echo e(url('shop')); ?>" class="cmn-btn-outline3 w-100 mb-10"><?php echo e(__('Continue Shopping')); ?></a>
            <a href="<?php echo e(route('tenant.shop.cart')); ?>" class="cmn-btn4 w-100 mb-10"><?php echo e(__('View Shopping Cart')); ?></a>
            <a href="<?php echo e(route('tenant.shop.checkout')); ?>" class="cmn-btn4 w-100"><?php echo e(__('Go to Checkout')); ?></a>
        </div>
    </figure>
</div>
<?php /**PATH /Users/xgenious/Desktop/xgenious/localhost/multisaas-update/core/resources/views/tenant/frontend/partials/pages-portion/navbars/ecommerce-product-partial/cart.blade.php ENDPATH**/ ?>