<?php $__env->startSection('title'); ?>
   <?php echo e(__('Payment Logs')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Payment Logs')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('section'); ?>
    <?php if(count($package_orders) > 0): ?>
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                <tr>
                    <th scope="col"><?php echo e(__('Package Order Info')); ?></th>
                    <th scope="col"><?php echo e(__('Payment Status')); ?></th>
                    <th scope="col"><?php echo e(__('Action')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $package_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <div class="user-dahsboard-order-info-wrap">
                                <h5 class="title"><?php echo e($data->package_name); ?></h5>
                                <div class="div">
                                    <small class="d-block"><strong><?php echo e(__('Order ID')); ?> : </strong> #<?php echo e($data->id); ?></small>
                                    <small class="d-block"><strong><?php echo e(__('Package Price')); ?> : </strong> <?php echo e(amount_with_currency_symbol($data->package_price)); ?></small>
                                    <small class="d-block"><strong><?php echo e(__('Payment Gateway')); ?> : </strong> <?php echo e($data->package_gateway); ?></small>

                                    <small class="d-block mb-2"><strong><?php echo e(__('Domain')); ?> : <span class="text-primary"><?php echo e($data->tenant_id .'.'. env('CENTRAL_DOMAIN')); ?></span></strong>
                                    <small class="d-block"><strong><?php echo e(__('Order Status')); ?> : </strong>
                                        <?php if($data->status == 'pending'): ?>
                                            <span class="alert alert-warning text-capitalize alert-sm alert-small"><?php echo e(__($data->status )); ?></span>
                                        <?php elseif($data->status == 'cancel'): ?>
                                            <span class="alert alert-danger text-capitalize alert-sm alert-small"><?php echo e(__($data->status)); ?></span>
                                        <?php elseif($data->status == 'in_progress'): ?>
                                            <span class="alert alert-info text-capitalize alert-sm alert-small"><?php echo e(str_replace('_',' ',$data->status)); ?></span>
                                        <?php else: ?>
                                            <span class="alert alert-success text-capitalize alert-sm alert-small"><?php echo e($data->status); ?></span>
                                        <?php endif; ?>
                                    </small>

                                    <small class="d-block"><strong><?php echo e(__('Start Date:')); ?></strong> <?php echo e(date('d-m-Y',strtotime($data->start_date))); ?></small>
                                    <?php if($data->status != 'trial'): ?>
                                      <small class="d-block"><strong><?php echo e(__('Expire Date:')); ?></strong> <?php echo e(date('d-m-Y',strtotime($data->expire_date)) ?? 'lifetime'); ?></small>
                                    <?php endif; ?>
                                    <?php if($data->status == 'trial'): ?>
                                        <small class="d-block"><strong><?php echo e(__('Trial Expire Date:')); ?></strong> <?php echo e(date('d-m-Y',strtotime($data->trial_expire_date))); ?></small>
                                    <?php endif; ?>
                                    <small class="d-block"><strong><?php echo e(__('Renew Taken :')); ?></strong> <?php echo e($data->renew_status ?? 0); ?></small>

                                    <?php if($data->payment_status == 'complete' && $data->status != 'trial'): ?>
                                        <form action="<?php echo e(route(route_prefix().'frontend.package.invoice.generate')); ?>"  method="post">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="id" id="invoice_generate_order_field" value="<?php echo e($data->id); ?>">
                                            <button class="btn btn-secondary btn-xs btn-small margin-top-10" type="submit"><?php echo e(__('Invoice')); ?></button>
                                        </form>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        <td class="user-dahsboard-status-info-wrap">
                            <?php if($data->payment_status != 'complete' && $data->status != 'cancel'): ?>

                                <span class="alert alert-warning text-capitalize alert-sm"><?php echo e($data->payment_status); ?></span>
                                <a href="<?php echo e(route('landlord.frontend.plan.order',$data->package_id) . '?log_id='.$data->id.''); ?>" class="btn btn-success btn-sm"><?php echo e(__('Pay Now')); ?></a>

                                <?php if($data->status != 'trial' ): ?>
                                <form action="<?php echo e(route(route_prefix().'user.dashboard.package.order.cancel')); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="order_id" value="<?php echo e($data->id); ?>">
                                    <button type="submit" class="btn btn-danger btn-sm margin-top-10"><?php echo e(__('Cancel')); ?></button>
                                </form>
                                 <?php endif; ?>
                            <?php else: ?>
                                <span class="alert alert-success text-capitalize alert-sm d-inline-block"><?php echo e($data->payment_status); ?></span>
                            <?php endif; ?>
                        </td>

                        <td>
                            <?php if($data->status != 'trial' ): ?>
                                <a href="" data-bs-toggle="modal" data-bs-target="#renew_payment_form"
                                   class="btn btn-info btn-sm renew_btn"
                                   target="_blank"
                                   data-log_id = "<?php echo e($data->id); ?>"
                                   data-package_id = "<?php echo e($data->package_id); ?>"
                                ><?php echo e(__('Renew Now')); ?></a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="blog-pagination">
            <?php echo e($package_orders->links()); ?>

        </div>
    <?php else: ?>
        <div class="alert alert-warning"><?php echo e(__('No Order Found')); ?></div>
    <?php endif; ?>

    <div class="modal fade" id="renew_payment_form" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Select Payment Gateway')); ?></h5>
                    <button type="button" class="close btn btn-danger btn-sm" data-bs-dismiss="modal">X</button>
                </div>

                <div class="modal-body">
                    <form action="<?php echo e(route('landlord.user.package.renew.process')); ?>" method="post" target="_blank">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="package_id" class="order_package_id">
                        <input type="hidden" name="log_id" class="order_log_id">

                        <select name="payment_gateway" class="form-control">
                            <?php $__currentLoopData = \App\Models\PaymentGateway::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($gateway->name == 'manual_payment') break; ?>
                                <option value="<?php echo e($gateway->name); ?>"><?php echo e(str_replace('_', ' ', ucfirst($gateway->name))); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary btn-sm renew_modal"><?php echo e(__('Go To Payment')); ?></button>
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $('.close-bars, .body-overlay').on('click', function() {
            $('.dashboard-close, .dashboard-close-main, .body-overlay').removeClass('active');
        });
        $('.sidebar-icon').on('click', function() {
            $('.dashboard-close, .dashboard-close-main, .body-overlay').addClass('active');
        });

        $(document).on('click','.renew_btn',function(){
            $('.order_package_id').val($(this).data('package_id'));
            $('.order_log_id').val($(this).data('log_id'));
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('landlord.frontend.user.dashboard.user-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/xgenious/Desktop/xgenious/localhost/multisaas-update/core/resources/views/landlord/frontend/user/dashboard/package-order.blade.php ENDPATH**/ ?>