<div class="col-xl-5 col-lg-5 mt-4">
    <div class="checkout-order-summery border-1">
        <div class="order-summery-contents">
            <h2 class="summery-title fw-500"> <?php echo e(__('Order Summery')); ?> </h2>
            <form action="#" class="coupon-contents-form coupon-border pt-4 mt-4">
                <div class="single-input">
                    <input type="hidden" class="coupon-country" name="coupon_country"
                           value="<?php echo e($billing_info ? $billing_info->country_id: ''); ?>">
                    <input type="hidden" class="coupon-state" name="coupon_state"
                           value="<?php echo e($billing_info ? $billing_info->state_id: ''); ?>">
                    <input type="hidden" class="coupon-shipping-method" name="coupon_shipping_method"
                           value="">
                    <input class="form--control coupon-code" type="text" placeholder="<?php echo e(__('Coupon Code')); ?>"
                           name="used_coupon">
                </div>
                <button type="button" class="btn-submit coupon-btn"> <?php echo e(__('Apply Coupon')); ?></button>
            </form>
            <div class="checkout-cart-wrapper coupon-border mt-4 mb-4">
                <?php $__currentLoopData = $cart_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="single-checkout-cart-items mt-3">
                        <div class="single-check-carts">
                            <div class="check-cart-flex-contents">
                                <div class="checkout-cart-thumb">
                                    <a href="javascript:void(0)">
                                        <?php echo render_image_markup_by_attachment_id($data?->options?->image); ?>

                                    </a>
                                </div>
                                <div class="checkout-cart-img-contents">
                                    <h6 class="checkout-cart-title"><a href="javascript:void(0)"> <?php echo e($data->name); ?> </a></h6>
                                    <span class="product-items"> <?php echo e(__('Quantity:')); ?> <?php echo e($data->qty); ?> </span>

                                    <div class="cartCap">
                                        <span class="name-subtitle d-block mt-2">
                                         <?php if($data?->options?->color_name): ?>
                                                <?php echo e(__('Color:')); ?> <?php echo e($data?->options?->color_name); ?>,
                                            <?php endif; ?>

                                            <?php if($data?->options?->size_name): ?>
                                                <?php echo e(__('Size:')); ?> <?php echo e($data?->options?->size_name); ?>

                                            <?php endif; ?>

                                            <?php if($data?->options?->attributes): ?>
                                                <br>
                                                <?php $__currentLoopData = $data?->options?->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo e($key.':'); ?> <?php echo e($attribute); ?><?php echo e(!$loop->last ? ',' : ''); ?>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                             </span>
                                    </div>
                                </div>
                            </div>
                            <span
                                class="checkout-cart-price color-heading fw-500"> <?php echo e(amount_with_currency_symbol($data->price * $data->qty)); ?> </span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="coupon-contents-details mt-4">
                <ul class="coupon-contents-details-list coupon-border">
                    <li class="coupon-contents-details-list-item">
                        <h6 class="coupon-contents-details-list-item-title"> <?php echo e(__('Sub Total')); ?> </h6> <span
                            class="coupon-contents-details-list-item-price fw-500"> <?php echo e(site_currency_symbol().\Gloudemans\Shoppingcart\Facades\Cart::subtotal()); ?> </span>
                    </li>
                </ul>
                <div class="shipping_method_wrapper">
                    <?php
                        $has_delivery_address = false;
                        $user = Auth::guard('web')->user();
                        if ($user != null)
                        {
                            if ($user?->delivery_address != null)
                            {
                                $has_delivery_address = true;
                                $country = (string)($user?->delivery_address?->country_id);
                                $state = (string)($user?->delivery_address?->state_id);

                                $shipping_zones = \Modules\ShippingModule\Entities\ZoneRegion::whereJsonContains('country', $country)->whereJsonContains('state', $state)
                                ->pluck('zone_id')
                                ->toArray();

                                if (empty($shipping_zones))
                                    {
                                        $shipping_zones = \Modules\ShippingModule\Entities\ZoneRegion::whereJsonContains('country', $country)
                                        ->pluck('zone_id')
                                        ->toArray();
                                    }

                                $shipping_methods = \Modules\ShippingModule\Entities\ShippingMethod::with('options')->whereIn('zone_id', $shipping_zones)->get();
                            }
                        }
                    ?>

                    <?php if($user != null): ?>
                        <ul class="coupon-contents-details-list coupon-border">
                            <h6><?php echo e(__('Shipping')); ?></h6>
                            <?php $__currentLoopData = $shipping_methods ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $is_default = false;
                                    if ($key == 0)
                                    {
                                        $is_default = true;
                                        $default_shipping = $method;
                                    }
                                ?>

                                <li class="coupon-contents-details-list-item" data-country="<?php echo e(isset($country) ?? 0); ?>"
                                    data-state="<?php echo e(isset($state) ?? 0); ?>">
                                    <span class="coupon-radio-item">
                                        <input type="radio" class="shipping_methods"
                                               id="shipping-option-<?php echo e($method['id']); ?>"
                                               name="shipping_method" value="<?php echo e($method['id']); ?>">
                                        <label for="shipping-option-<?php echo e($method['id']); ?>"><?php echo e($method['name']); ?></label>
                                    </span>
                                    <span><?php echo e(amount_with_currency_symbol($method['options']['cost'])); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php endif; ?>

                    <div class="shipping_tax_total">
                        <ul class="coupon-contents-details-list coupon-border">
                            <li class="coupon-contents-details-list-item"><span> <?php echo e(__('Tax (Incl)')); ?> </span>
                                <span> <?php echo e($product_tax.'%'); ?> </span></li>
                            <li class="coupon-contents-details-list-item"><span> <?php echo e(__('Coupon Discount (-)')); ?> </span>
                                <span> <?php echo e(amount_with_currency_symbol(0.00)); ?> </span></li>
                            <li class="coupon-contents-details-list-item price-shipping">
                                <span> <?php echo e(__('Shipping Cost (+)')); ?> </span>
                                <span> <?php echo e(isset($is_default) && $is_default ? amount_with_currency_symbol($default_shipping['options']['cost']) : '--'); ?> </span>
                            </li>
                        </ul>
                        <ul class="coupon-contents-details-list coupon-border">
                            <?php
                                $subtotal = (double) \Gloudemans\Shoppingcart\Facades\Cart::subtotal(0, '', '');
                                $taxed_price = ($subtotal * $product_tax) / 100;

                                $shipping_tax = 0;
                                if (Auth::guard('web')->check())
                                {
                                    if ($has_delivery_address)
                                    {
                                        if($default_shipping?->options?->tax_status)
                                        {
                                            $shipping_tax = ($default_shipping['options']['cost'] * $product_tax) / 100;
                                        }
                                            $shipping = isset($is_default) && $is_default ? $default_shipping['options']['cost'] ?? 0 : 0;
                                    } else {
                                        $shipping = 0;
                                    }
                                } else {
                                    $shipping = 0;
                                }

                                $total = $subtotal + ($taxed_price + $shipping_tax) + $shipping;
                            ?>
                            <li class="coupon-contents-details-list-item price-total"
                                data-total="<?php echo e($subtotal+$taxed_price); ?>" <?php echo e(!isset($is_default) ? 'data-total='.$total.'' : ''); ?>

                            ">
                            <h6 class="coupon-title"> <?php echo e(__('Total Amount')); ?> </h6> <span
                                class="coupon-price fw-500 color-heading"> <?php echo e(site_currency_symbol().$total); ?> </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="checkbox-inlines cash-on-delivery mt-2">
                <input class="check-input" type="checkbox" id="cash">
                <label class="checkbox-label" for="cash"> <?php echo e(__('Cash On Delivery')); ?> </label>
            </div>

            <div class="payment-inlines mt-4">
                <h6 class="payment-label fw-500"> <?php echo e(__('Select Payment Method')); ?> </h6>
                <div class="payment-card mt-4">

                    <?php echo render_payment_gateway_for_form(); ?>


                    <div class="form-group d-none manual_transaction_id">
                        <input type="text" name="trasaction_id" class="form-control "
                               placeholder="Transection Id">
                    </div>

                    <input type="hidden" id="site_global_payment_gateway"
                           value="<?php echo e(get_static_option('site_default_payment_gateway')); ?>">
                </div>
            </div>

                      <?php
                            $terms_page_route = get_dynamic_page_name_by_id(get_static_option('terms_condition_page')) ?? '#';
                        ?>

            <div class="checkbox-inlines mt-3">
                <input class="check-input" type="checkbox" id="agree">
                <label class="checkbox-label" for="agree"> <?php echo e(__('I have read and agree to the website')); ?> <a
                        class="terms-condition" href="<?php echo e(route('tenant.dynamic.page',$terms_page_route)); ?>"> <?php echo e(__('terms
                        and conditions*')); ?> </a> </label>
            </div>

            <div class="btn-wrapper mt-3">
                <a href="javascript:void(0)"
                   class="cmn-btn cmn-btn-outline-two w-100 radius-0 checkout_disable proceed_checkout_btn"> <?php echo e(__('Proceed to
                    Checkout')); ?> </a>
            </div>

            <div class="btn-wrapper mt-3">
                <a href="<?php echo e(route('tenant.shop.cart')); ?>" class="cmn-btn-outline3 w-100 radius-0"> <?php echo e(__('Return to Cart')); ?> </a>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /Users/xgenious/Desktop/xgenious/localhost/multisaas-update/core/Modules/Product/Resources/views/frontend/shop/checkout/partials/checkout_right_side.blade.php ENDPATH**/ ?>