<?php $__env->startSection('title'); ?>
    <?php echo e(__('Custom Domain')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Custom Domain')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('section'); ?>
    <?php
        $central_domain = getenv('CENTRAL_DOMAIN');
    ?>
<div class="parent">
    <div class="row">
        <div class="col-12">
            <div class="card card-new-styles">
                <div class="card-header">
                    <h3 class="text-center"><?php echo e(get_static_option_central('custom_domain_settings_title')); ?></h3>
                </div>

                <div class="card-body">
                    <p><?php echo e(get_static_option_central('custom_domain_settings_description')); ?></p>

                    <h5 class="mt-4"><?php echo e(get_static_option_central('custom_domain_table_title')); ?></h5>
                    <div class="table__responsive">
                        <table class="table table-default table-striped table-bordered mt-4">
                            <thead class="text-white bg-dark">
                            <tr>
                                <th><?php echo e(__('Type')); ?></th>
                                <th><?php echo e(__('Host')); ?></th>
                                <th><?php echo e(__('Value')); ?></th>
                                <th><?php echo e(__('TTL')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td>CNAME Record</td>
                                <td>www</td>
                                <td><?php echo e(getenv('CENTRAL_DOMAIN')); ?></td>
                                <td>Automatic</td>
                            </tr>

                            <tr>
                                <td>CNAME Record</td>
                                <td>@</td>
                                <td><?php echo e(getenv('CENTRAL_DOMAIN')); ?></td>
                                <td>Automatic</td>
                            </tr>
                             <tr>
                                <td colspan="4">Use this if you are using cloulflare</td>
                            </tr>
                             <tr>
                                <td>A Record</td>
                                <td>@</td>
                                <td><?php echo e($_SERVER['SERVER_ADDR']); ?></td>
                                <td>Automatic</td>
                            </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-body">
                            <div class="card-body">
                                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.header-wrapper','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.header-wrapper'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                     <?php $__env->slot('left', null, []); ?> 
                                        <h4 class="card-title mb-5"><?php echo e(__('Custom Domain Request')); ?></h4>
                                     <?php $__env->endSlot(); ?>
                                     <?php $__env->slot('right', null, ['class' => 'd-flex']); ?> 
                                        <button class="btn btn-info btn-sm mb-3" data-bs-toggle="modal" data-bs-target="#new_custom_domain"><?php echo e(__('Request Custom Domain')); ?></button>
                                     <?php $__env->endSlot(); ?>
                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                                <div class="table-wrap table-responsive">
                                    <table class="table table-default table-striped table-bordered">
                                        <thead class="text-white" >
                                        <tr>
                                            <th><?php echo e(__('Current Domain')); ?></th>
                                            <th><?php echo e(__('Requested Domain')); ?></th>
                                            <th><?php echo e(__('Requested Domain Status')); ?></th>
                                            <th><?php echo e(__('Date')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $user_domain_infos->tenant_details ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tenant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                                <tr>
                                                <td><?php echo e($tenant->id . '.'. getenv('CENTRAL_DOMAIN')); ?></td>
                                                <td><?php echo e(optional($tenant->custom_domain)->custom_domain); ?></td>
                                                <td class="py-4">
                                                    <?php if(optional($tenant->custom_domain)->custom_domain_status == 'pending'): ?>
                                                        <span class="alert alert-warning text-capitalize"><?php echo e(optional($tenant->custom_domain)->custom_domain_status); ?></span>
                                                    <?php elseif(optional($tenant->custom_domain)->custom_domain_status == 'in_progress'): ?>
                                                        <span class="alert alert-info text-capitalize"><?php echo e(str_replace('_',' ',optional($tenant->custom_domain)->custom_domain_status)); ?></span>
                                                    <?php elseif(optional($tenant->custom_domain)->custom_domain_status == 'connected'): ?>
                                                        <span class="alert alert-success text-capitalize"><?php echo e(optional($tenant->custom_domain)->custom_domain_status); ?></span>
                                                    <?php elseif(optional($tenant->custom_domain)->custom_domain_status == 'rejected'): ?>
                                                        <span class="alert alert-info text-capitalize"><?php echo e(str_replace('_', ' ',ucwords(optional($tenant->custom_domain)->custom_domain_status))); ?></span>
                                                    <?php elseif(optional($tenant->custom_domain)->custom_domain_status == null): ?>

                                                    <?php else: ?>
                                                        <span class="alert alert-danger text-capitalize"><?php echo e(optional($tenant->custom_domain)->custom_domain_status ?? __('Removed')); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(!empty($tenant->custom_domain)): ?>
                                                        <?php echo e(date('d-m-Y',strtotime(optional($tenant->custom_domain)->updated_at))); ?>

                                                    <?php endif; ?>
                                                </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                </div>
            </div>
        </div>
    </div>
 </div>

    <div class="modal fade" id="new_custom_domain" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Request Custom Domain')); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal"><span>×</span></button>
                </div>
                <form action="<?php echo e(route('landlord.user.dashboard.custom.domain')); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">

                        <div class="alert-alert-warning">
                            <?php echo e(__('You already have a custom domain ('.$central_domain.') connected with your portfolio website.
                                if you request another domain now & if it gets connected with our server, then your current domain ('.$central_domain.') will be removed')); ?>

                        </div>

                        <input type="hidden" name="user_id" value="<?php echo e($user_domain_infos->id); ?>">

                        <div class="form-group my-3">
                            <?php
                                $domain_list = optional($user_domain_infos)->tenant_details;
                            ?>
                            <label for="name"><?php echo e(__('Select your domain')); ?></label>
                            <select class="form-control" name="old_domain" id="">
                                <option value="">Select a domain</option>
                                <?php $__currentLoopData = $domain_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $domain): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($domain->id); ?>"><?php echo e($domain->id); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <small><?php echo e(__('Select the domain which you want to change')); ?></small>
                        </div>

                        <div class="form-group mt-3">
                            <label for="name"><?php echo e(__('Enter your custom domain')); ?></label>
                            <input type="text" class="form-control" name="custom_domain" value="<?php echo e($custom_domain_info->custom_domain ?? ''); ?>">
                            <div id="subdomain-wrap"></div>
                        </div>

                        <div class="form-group">
                            <?php echo e(sprintf(__('Do not use http:// or https://
                              The valid format will be exactly like this one - domain.tld, www.domain.tld or subdomain.domain.tld, www.subdomain.domain.tld'))); ?>

                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Send Request')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $('.close-bars, .body-overlay').on('click', function() {
            $('.dashboard-close, .dashboard-close-main, .body-overlay').removeClass('active');
        });
        $('.sidebar-icon').on('click', function() {
            $('.dashboard-close, .dashboard-close-main, .body-overlay').addClass('active');
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('landlord.frontend.user.dashboard.user-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/xgenious/Desktop/xgenious/localhost/multisaas-update/core/resources/views/landlord/frontend/user/dashboard/custom-domain.blade.php ENDPATH**/ ?>