<?php $__env->startSection('title'); ?>
    <?php echo e(__('Edit Profile')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Edit Profile')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('section'); ?>

    <div class="parent">
        <h2 class="title"><?php echo e(__('Edit Profile')); ?></h2>
        <form action="<?php echo e(route('landlord.user.profile.update')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="form-group col-lg-6">
                    <label for="name"><?php echo e(__('Name')); ?></label>
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo e($user_details->name); ?>">
                </div>
                <div class="form-group col-lg-6">
                    <label for="email"><?php echo e(__('Email')); ?></label>
                    <input type="text" class="form-control" id="email" name="email" value="<?php echo e($user_details->email); ?>">
                </div>
                <div class="form-group col-lg-6">
                    <label for="phone"><?php echo e(__('Mobile')); ?></label>
                    <input type="tel" class="form-control" name="mobile" value="<?php echo e($user_details->mobile); ?>">
                </div>
                <div class="form-group col-lg-6">
                    <label for="address"><?php echo e(__('Comapny')); ?></label>
                    <input type="text" class="form-control" id="address" name="company" value="<?php echo e($user_details->company); ?>">
                </div>
                <div class="form-group col-lg-6 mt-4">
                    <select name="country" class="form-control">
                        <option disabled="" selected><?php echo e(__('Select a country')); ?></option>
                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($country->id); ?>" <?php if(old('country',$country->id ) == $user_details->country): echo 'selected'; endif; ?>><?php echo e($country->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="form-group col-lg-6">
                    <label for="address"><?php echo e(__('Address')); ?></label>
                    <input type="text" class="form-control" id="address" name="address" value="<?php echo e($user_details->address); ?>">
                </div>
                <div class="form-group col-lg-6">
                    <label for="state"><?php echo e(__('State')); ?></label>
                    <input type="text" class="form-control" id="state" name="state" value="<?php echo e($user_details->state); ?>">
                </div>


            <div class="btn-wrapper mt-2">
                  <button type="submit" class="btn-default boxed-btn"><?php echo e(__('Save changes')); ?></button>
            </div>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

    <script>

        (function($){
            "use strict"
        $(document).ready(function(){
            var selectdCountry = "<?php echo e($user_details->country); ?>";
            $('#country option[value="'+selectdCountry+'"]').attr('selected',true);
        });

        }(jQuery));
    </script>

    <script>
        $('.close-bars, .body-overlay').on('click', function() {
            $('.dashboard-close, .dashboard-close-main, .body-overlay').removeClass('active');
        });
        $('.sidebar-icon').on('click', function() {
            $('.dashboard-close, .dashboard-close-main, .body-overlay').addClass('active');
        });
    </script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('landlord.frontend.user.dashboard.user-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/resources/views/landlord/frontend/user/dashboard/edit-profile.blade.php ENDPATH**/ ?>