<?php
    $selected_lang = \App\Facades\GlobalLanguage::user_lang_slug();
    if (str_contains($data['title'], '{h}') && str_contains($data['title'], '{/h}'))
    {
        $text = explode('{h}',$data['title']);

        $highlighted_word = explode('{/h}', $text[1])[0];

        $highlighted_text = '<span class="color">'. $highlighted_word .'</span>';
        $final_title = '<h2 class="tittle wow fadeInUp" data-wow-delay="0.0s"">'.str_replace('{h}'.$highlighted_word.'{/h}', $highlighted_text, $data['title']).'</h2>';
    } else {
        $final_title = '  <h2 class="tittle wow fadeInUp" data-wow-delay="0.0s">'.$data['title'].'</h2>';
    }

    $price_plan_type_key = array_keys($data['all_price_plan']->toArray());
?>

<section class="pricingCard section-padding" data-padding-top="<?php echo e($data['padding_top']); ?>" data-padding-bottom="<?php echo e($data['padding_bottom']); ?>">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-7 col-md-10 col-sm-10">
                <div class="section-tittle text-center mb-30">
                  <?php echo $final_title; ?>

                </div>
                <!-- Tab Menu -->
                <div class="tab-menu tabStyleOne text-center mb-40  wow fadeInUp" data-wow-delay="0.1s">
                    <ul>
                       <?php $__currentLoopData = $price_plan_type_key; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $price_plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <li><a href="#" data-rel="tab-<?php echo e($key); ?>" class="<?php echo e($key == 0 ? 'active' : ''); ?>" ><?php echo e(\App\Enums\PricePlanTypEnums::getText($key)); ?></a></li>
                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>


      <?php $__currentLoopData = $data['all_price_plan']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan_type => $plan_items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="singleTab-items" id="tab-<?php echo e($plan_type); ?>" style="<?php echo e($loop->iteration == 1 ? 'display:block;' : ""); ?>">
            <div class="row">
                <?php $__currentLoopData = $plan_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $price_plan_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $active = '';
                        if($key == 1){
                            $active = 'active';
                        }
                    ?>
                <div class="col-lg-4 col-md-6">
                    <div class="singlePrice <?php echo e($active); ?> mb-24">
                        <h4 class="priceTittle"><?php echo e($price_plan_item->getTranslation('title',$selected_lang)); ?></h4>
                        <span class="price"><?php echo e(amount_with_currency_symbol($price_plan_item->price)); ?> <span class="subTittle"> /<?php echo e(\App\Enums\PricePlanTypEnums::getText($price_plan_item->type)); ?></span></span>
                        <p class="pricePera"><?php echo e($price_plan_item->getTranslation('subtitle',$selected_lang)); ?></p>
                        <ul class="listing">

                            <?php if(!empty($price_plan_item->page_permission_feature)): ?>
                                <li class="listItem">
                                    <img src="<?php echo e(asset('assets/landlord/frontend/img/icon/grenIcon.svg')); ?>" class="icon" alt="icon">
                                    <blockquote class="priceTag"><?php echo e(sprintf(__('Page Create %d'),$price_plan_item->page_permission_feature )); ?> </blockquote>
                                </li>
                            <?php endif; ?>

                            <?php if(!empty($price_plan_item->blog_permission_feature)): ?>
                                <li class="listItem">
                                    <img src="<?php echo e(asset('assets/landlord/frontend/img/icon/grenIcon.svg')); ?>" class="icon" alt="icon">
                                    <blockquote class="priceTag"><?php echo e(sprintf(__('Blog Create %d'),$price_plan_item->blog_permission_feature )); ?> </blockquote>
                                </li>
                            <?php endif; ?>

                            <?php if(!empty($price_plan_item->product_permission_feature)): ?>
                                <li class="listItem">
                                    <img src="<?php echo e(asset('assets/landlord/frontend/img/icon/grenIcon.svg')); ?>" class="icon" alt="icon">
                                    <blockquote class="priceTag"><?php echo e(sprintf(__('Product Create %d'),$price_plan_item->product_permission_feature )); ?> </blockquote>
                                </li>
                            <?php endif; ?>

                            <?php if(!empty($price_plan_item->donation_permission_feature)): ?>
                                <li class="listItem">
                                    <img src="<?php echo e(asset('assets/landlord/frontend/img/icon/grenIcon.svg')); ?>" class="icon" alt="icon">
                                    <blockquote class="priceTag"><?php echo e(sprintf(__('Donation Create %d'),$price_plan_item->donation_permission_feature )); ?> </blockquote>
                                </li>
                            <?php endif; ?>

                            <?php if(!empty($price_plan_item->job_permission_feature)): ?>
                                <li class="listItem">
                                    <img src="<?php echo e(asset('assets/landlord/frontend/img/icon/grenIcon.svg')); ?>" class="icon" alt="icon">
                                    <blockquote class="priceTag"><?php echo e(sprintf(__('Job Create %d'),$price_plan_item->job_permission_feature )); ?> </blockquote>
                                </li>
                            <?php endif; ?>

                            <?php if(!empty($price_plan_item->event_permission_feature)): ?>
                                <li class="listItem">
                                    <img src="<?php echo e(asset('assets/landlord/frontend/img/icon/grenIcon.svg')); ?>" class="icon" alt="icon">
                                    <blockquote class="priceTag"><?php echo e(sprintf(__('Event Create %d'),$price_plan_item->event_permission_feature )); ?> </blockquote>
                                </li>
                            <?php endif; ?>

                            <?php if(!empty($price_plan_item->knowledgebase_permission_feature)): ?>
                                <li class="listItem">
                                    <img src="<?php echo e(asset('assets/landlord/frontend/img/icon/grenIcon.svg')); ?>" class="icon" alt="icon">
                                    <blockquote class="priceTag"><?php echo e(sprintf(__('Knowledgebase Create %d'),$price_plan_item->knowledgebase_permission_feature )); ?> </blockquote>
                                </li>
                            <?php endif; ?>

                            <?php if(!empty($price_plan_item->portfolio_permission_feature)): ?>
                                <li class="listItem">
                                    <img src="<?php echo e(asset('assets/landlord/frontend/img/icon/grenIcon.svg')); ?>" class="icon" alt="icon">
                                    <blockquote class="priceTag"><?php echo e(sprintf(__('Portfolio Create %d'),$price_plan_item->portfolio_permission_feature )); ?> </blockquote>
                                </li>
                            <?php endif; ?>

                            <?php $__currentLoopData = $price_plan_item->plan_features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="listItem">
                                    <img src="<?php echo e(asset('assets/landlord/frontend/img/icon/grenIcon.svg')); ?>" class="icon" alt="icon">
                                    <blockquote class="priceTag"><?php echo e(str_replace('_', ' ', ucwords($feature->feature_name))); ?></blockquote>
                                </li>
                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </ul>
                        <div class="price-all-feature">
                            <a href="<?php echo e(route('landlord.frontend.plan.view',$price_plan_item->id)); ?>" class="btn-feature-view"><?php echo e(__('View All Features')); ?></a>
                        </div>
                        <div class="btn-wrapper mt-40">
                            <?php if($price_plan_item->has_trial == true): ?>
                                <div class="d-flex justify-content-center">
                                    <a href="<?php echo e(route('landlord.frontend.plan.order',$price_plan_item->id)); ?>" class="cmn-btn cmn-btn-outline-one color-one w-100 mx-1">
                                        <?php echo e($data['button_text']); ?> </a>

                                    <a href="<?php echo e(route('landlord.frontend.plan.view',[$price_plan_item->id, 'trial'])); ?>" class="cmn-btn cmn-btn-outline-one color-one w-100 mx-1">
                                       <?php echo e($data['trial_text']); ?></a>
                                </div>
                            <?php else: ?>
                                <a href="<?php echo e(route('landlord.frontend.plan.order',$price_plan_item->id)); ?>" class="cmn-btn1 w-100"><?php echo e($price_plan_item->price == 0 ? __('Free Package') : $data['button_text']); ?></a>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</section>




<?php /**PATH /home/multipurposesass/public_html/core/plugins/PageBuilder/views/landlord/addons/common/price-plan.blade.php ENDPATH**/ ?>