
<?php
    $button_text = $data['button_text'];
?>

<div class="allProduct section-padding">
    <div class="container" data-padding-top="<?php echo e($data['padding_top']); ?>" data-padding-bottom="<?php echo e($data['padding_bottom']); ?>">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-7 col-md-10 col-sm-10">
                <div class="section-tittle text-center mb-50">
                    <h2 class="title"><?php echo e($data['title']); ?></h2>
                </div>
            </div>
        </div>
        <div class="row">
            <!-- Left Content -->
            <div class="col-xxl-3  col-xl-3 col-lg-4 col-md-5">
                <div class="cateSidebar mb-40">
                    <!-- All Categories -->
                    <ul class="listing listScroll category_listing">
                        <li class="listItem">
                            <a href="#!" class="items list_item_all_product">
                                <i class="flaticon-product icon"></i> <?php echo e(__('All Product')); ?>

                            </a>
                        </li>
                        <?php $__currentLoopData = $data['all_categories']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="listItem item" data-slug="<?php echo e($category->slug); ?>" data-limit="<?php echo e($data['product_limit']); ?>">
                                <a href="#!" class="items category_item" >
                                    <i class="flaticon-product icon"></i> <?php echo e($category->name); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                </div>

                <?php
                    $deal_product = $data['deal_product'];
                ?>

                <div class="singleCart singleCartTwo singleCartTwoSmoll singleCartSidebar mb-24 bgColorFive tilt-effect wow fadeInUp" data-wow-delay="0.0s">
                    <div class="itemsCaption">
                        <p class="itemsCap"><?php echo e($data['deal_title']); ?></p>
                        <h5><a href="#!" class="itemsTittle"><?php echo e($deal_product->name); ?></a></h5>
                        <span class="price"><?php echo e(amount_with_currency_symbol($deal_product->sale_price)); ?></span>
                        <div class="btn-wrapper">
                            <a href="#!" class="cmn-btn4" tabindex="0"><?php echo e(__('Buy Now')); ?></a>
                        </div>
                    </div>
                    <div class="itemsImg wow fadeInUp" data-wow-delay="0.0s">
                        <?php echo render_image_markup_by_attachment_id($deal_product->image_id); ?>

                    </div>
                </div>

            </div>
            <!-- Right Content -->
            <div class="col-xxl-9 col-xl-9 col-lg-8 col-md-7">
                <div class="row all_product_container">
                    <?php $__currentLoopData = $data['products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $data = get_product_dynamic_price($product);
                            $campaign_name = $data['campaign_name'];
                            $regular_price = $data['regular_price'];
                            $sale_price = $data['sale_price'];
                            $discount = $data['discount'];
                        ?>
                    <div class="col-xl-4">
                        <div class="singleProduct mb-24">
                            <div class="productImg imgEffect2">
                                <a href="<?php echo e(route('tenant.shop.product.details',$product->slug)); ?>">
                                    <?php echo render_image_markup_by_attachment_id($product->image_id); ?>

                                </a>

                                <div class="sticky-wrap">
                                <!-- sticker -->
                                    <?php if(!empty($product->badge)): ?>
                                      <span class="sticky stickyStye ratedStock"><i class="fa-solid fa-medal icon"></i><?php echo e($product?->badge?->getTranslation('name',get_user_lang())); ?></span>
                                    <?php endif; ?>

                                    <?php if($product->inventory?->stock_count < 1): ?>
                                        <span class="sticky stickyStye outStock"><?php echo e(__('Out of stock')); ?></span>
                                    <?php endif; ?>
                                 </div>

                                    <?php echo $__env->make('product::frontend.option-feature', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            </div>

                            <div class="productCap">

                                <h5>
                                    <a href="<?php echo e(route('tenant.shop.product.details', $product->slug)); ?>" class="title"><?php echo e(Str::words($product->getTranslation('name',get_user_lang()), 4)); ?> </a>
                                </h5>

                                <?php echo render_product_star_rating_markup_with_count($product); ?>


                                <?php if($product->inventory?->stock_count > 0): ?>
                                    <span class="quintity avilable"><?php echo e(__('In Stock')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                                <?php else: ?>
                                    <span class="quintity text-danger"><?php echo e(__('Stock Out')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                                <?php endif; ?>


                                <div class="d-flex align-items-center flex-wrap justify-content-between">
                                    <div class="productPrice">
                                        <?php echo product_prices($product, 'color-two'); ?>

                                    </div>
                                    <div class="btn-wrapper mb-15">
                                        <?php if(count($product->inventoryDetail) > 0 ): ?>
                                            <a href="<?php echo e(route('tenant.shop.product.details',$product->slug)); ?>" class="cmn-btn-outline3 w-100"><?php echo e(__('View')); ?></a>
                                        <?php else: ?>
                                            <a href="#!" data-product_id="<?php echo e($product->id); ?>" class="cmn-btn-outline3 w-100 add-to-buy-now-btn"><?php echo e($button_text); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(function (){
            $(document).on('click', '.category_listing .item', function (e){
                e.preventDefault();

                let el = $(this);
                let slug = el.data('slug');
                let limit = el.data('limit');

                    $.ajax({
                        type: 'GET',
                        url: "<?php echo e(route('tenant.category.wise.product')); ?>",
                        data: {
                            category : slug,
                            limit : limit,
                        },
                        beforeSend: function (){
                           CustomLoader.start()
                        },
                        success: function (data){

                            $('.all_product_container').html(data.markup);

                            CustomLoader.end();
                        },
                        error: function (data){
                            console.log('error')
                        }
                    });

            });


            $(document).on('click','.list_item_all_product',function(e){
                    e.preventDefault();

                    CustomLoader.start();
                       $('.all_product_container').load(location.href + " .all_product_container");

                    setInterval(() => {
                        CustomLoader.end();
                    }, 300);
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/multipurposesass/public_html/core/plugins/PageBuilder/views/tenant/eCommerce/all-product.blade.php ENDPATH**/ ?>