<!DOCTYPE html>
<html dir="<?php echo e(\App\Facades\GlobalLanguage::user_lang_dir()); ?>" lang="<?php echo e(\App\Facades\GlobalLanguage::user_lang_slug()); ?>">
<head>
    <?php echo get_static_option('site_third_party_tracking_code_just_after_head'); ?>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php echo SEOMeta::generate(); ?>

    <?php echo OpenGraph::generate(); ?>

    <?php echo Twitter::generate(); ?>

    <?php echo JsonLd::generate(); ?>


    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>


    <?php echo render_favicon_by_id(get_static_option('site_favicon')); ?>


    <title>
        <?php if(!request()->routeIs('landlord.homepage')): ?>
            <?php echo $__env->yieldContent('title'); ?>
            -
            <?php echo e(filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_title',$global_static_field_data)); ?>

        <?php else: ?>
            <?php echo e(filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_title',$global_static_field_data)); ?>

            <?php if(!empty(filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_tag_line',$global_static_field_data))): ?>
                - <?php echo e(filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_tag_line',$global_static_field_data)); ?>

            <?php endif; ?>
        <?php endif; ?>
    </title>

    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/bootstrap.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/plugin.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/css/custom-dashboard.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/main-style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/common/css/helpers.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/developer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/dynamic-style.css')); ?>">

    <?php if(\App\Facades\GlobalLanguage::user_lang_dir() == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/rtl.css')); ?>">
    <?php endif; ?>



    <?php echo $__env->make('landlord.frontend.partials.font-manage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('landlord.frontend.partials.color-font-variable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('style'); ?>

    <?php echo $__env->yieldContent('seo_data'); ?>
    <?php echo get_static_option('site_third_party_tracking_code'); ?>

</head>
<body>
<?php echo get_static_option('site_third_party_tracking_code_just_after_body'); ?>

<?php echo $__env->make('landlord.frontend.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php /**PATH /Users/xgenious/Desktop/xgenious/localhost/multisaas-update/core/resources/views/landlord/frontend/partials/header.blade.php ENDPATH**/ ?>