<?php
    $button_text = $data['button_text'];
?>
<section class="popularProduct">
    <div class="container" data-padding-top="<?php echo e($data['padding_top']); ?>" data-padding-bottom="<?php echo e($data['padding_bottom']); ?>">
        <div class="row mb-40">
            <div class="col-xl-6 col-lg-12 col-md-10 col-sm-10">
                <div class="section-tittle mb-0">
                    <h2 class="title"><?php echo e($data['title']); ?></h2>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-12">

                <div class="global-slick-init slider-inner-margin arrowStyleFour" data-infinite="false" data-arrows="true" data-dots="false" data-slidesToShow="4" data-swipeToSlide="true" data-autoplay="true" data-autoplaySpeed="2500" data-prevArrow='<div class="prev-icon"><i class="las la-angle-left"></i></div>'
                     data-nextArrow='<div class="next-icon"><i class="las la-angle-right"></i></div>' data-responsive='[{"breakpoint": 1800,"settings": {"slidesToShow": 4}},{"breakpoint": 1600,"settings": {"slidesToShow": 4}},{"breakpoint": 1400,"settings": {"slidesToShow": 3}},{"breakpoint": 1200,"settings": {"slidesToShow": 3}},{"breakpoint": 991,"settings": {"slidesToShow": 2}},{"breakpoint": 768, "settings": {"slidesToShow": 2}},{"breakpoint": 576, "settings": {"slidesToShow": 1}}]'>

                    <?php $__currentLoopData = $data['products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $data = get_product_dynamic_price($product);
                            $campaign_name = $data['campaign_name'];
                            $regular_price = $data['regular_price'];
                            $sale_price = $data['sale_price'];
                            $discount = $data['discount'];
                        ?>
                        <div class="singleProduct">
                            <div class="productImg imgEffect2">
                                <a href="<?php echo e(route('tenant.shop.product.details',$product->slug)); ?>">
                                    <?php echo render_image_markup_by_attachment_id($product->image_id); ?>

                                </a>
                                <div class="sticky-wrap">
                                    <?php if(!empty($product->badge)): ?>
                                      <span class="sticky stickyStye "><?php echo e($product?->badge?->name); ?></span>
                                    <?php endif; ?>

                                    <?php if($product->inventory?->stock_count < 1): ?>
                                         <span class="sticky stickyStye outStock"><?php echo e(__('Out of stock')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <?php echo $__env->make('product::frontend.option-feature', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            </div>
                            <div class="productCap">
                                <h5><a href="<?php echo e(route('tenant.shop.product.details', $product->slug)); ?>" class="title"><?php echo e(Str::words($product->name, 4)); ?> </a></h5>

                                <?php echo render_product_star_rating_markup_with_count($product); ?>


                                <?php if($product->inventory?->stock_count > 0): ?>
                                 <span class="quintity avilable"><?php echo e(__('In Stock')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                                <?php else: ?>
                                    <span class="quintity text-danger"><?php echo e(__('Stock Out')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                                <?php endif; ?>
                                <div class="productPrice">
                                    <?php echo product_prices($product, 'color-two'); ?>

                                </div>
                                <div class="btn-wrapper" >
                                    <?php if(count($product->inventoryDetail) > 0 ): ?>
                                        <a href="<?php echo e(route('tenant.shop.product.details',$product->slug)); ?>" class="cmn-btn-outline3 w-100"><?php echo e(__('View')); ?></a>
                                    <?php else: ?>
                                        <a href="#!" data-product_id="<?php echo e($product->id); ?>" class="cmn-btn-outline3 w-100 add-to-buy-now-btn"><?php echo e($button_text); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/multipurposesass/public_html/core/plugins/PageBuilder/views/tenant/eCommerce/product-slider.blade.php ENDPATH**/ ?>