<?php $__env->startSection('title'); ?> <?php echo e(__('Main Page')); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="col-12 grid-margin stretch-card">
        <div class="card">

      <?php if(!empty($current_package)): ?>
            <div class="main">
                <div class="alert border-left border-primary text-white text-center bg-gradient-info">
                    <strong><?php echo e(__('Current Package :')); ?> </strong> <?php echo e($current_package->package_name); ?>

                    <span class="badge badge-warning text-dark">
                        <?php echo e(\App\Enums\PricePlanTypEnums::getText(optional($current_package->package)->type )); ?>

                    </span>

                    <?php if(optional(tenant()->payment_log)->status == 'trial'): ?>
                        <?php
                            $days = get_trial_days_left(tenant());
                        ?>

                        <strong class="text-capitalize"> ( <?php echo e(optional(tenant()->user?->payment_single_log)->status); ?> : <?php echo e($days ?? ''); ?> <?php echo e(__('Days Left')); ?>)</strong>
                    <?php else: ?>
                        <strong> ( <?php echo e(__('Expire Date :')); ?> <?php echo e($current_package->expire_date ?? ''); ?>)</strong>
                    <?php endif; ?>

                    <a class="btn btn-dark btn-sm pull-right" href="<?php echo e(route('landlord.homepage') .'#price_plan_section'); ?>" target="_blank"><?php echo e(__('Buy a Plan')); ?></a>
                </div>

            </div>
      <?php endif; ?>
          <div class="card-body">
              <h4 class="card-title mb-5"><?php echo e(__('Dashboard content')); ?></h4>
                <div class="row">
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-danger card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Page')); ?><i class="las la-user-shield mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_page); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-danger card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Admins')); ?><i class="las la-user-shield mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_admin); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-info card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Users')); ?><i class="las la-user-shield mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_user); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-success card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Blogs')); ?><i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($all_blogs); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-info card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Services')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_services); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-primary card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Language')); ?><i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_language); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-warning card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Brand')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_brand); ?></h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-success card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Products')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_product); ?></h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-info card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Campaign')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_campaign); ?></h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-danger card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Event')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_event); ?></h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-primary card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Job')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_job); ?></h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-warning card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Article')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_article); ?></h2>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('tenant.admin.admin-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/xgenious/Desktop/xgenious/localhost/multisaas-update/core/resources/views/tenant/admin/admin-home.blade.php ENDPATH**/ ?>