<?php
    $userlang = get_user_lang();
?>
<div class="contactArea section-padding" data-padding-top="<?php echo e($data['padding_top']); ?>" data-padding-bottom="<?php echo e($data['padding_bottom']); ?>">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-5 col-lg-7">
                <div class="row">
                <?php
                    $user_lang = default_lang();
                ?>



                 <?php $__currentLoopData = $data['repeater_data']['repeater_title_'.$user_lang] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $title): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-6 col-md-6 col-sm-6">
                            <div class="singleContact text-center mb-24 wow fadeInUp" data-wow-delay="0.0s">
                                <div class="icon-wrap">
                                    <div class="icon"><i class="<?php echo e($data['repeater_data']['repeater_icon_'.$user_lang][$key] ?? ''); ?>"></i> </div>
                                </div>
                                <div class="cat-cap">
                                    <h5><a href="#" class="tittle"><?php echo e($title); ?></a></h5>
                                    <p class="pera"><?php echo e($data['repeater_data']['repeater_info_'.$user_lang][$key] ?? ''); ?></p>
                                </div>
                            </div>
                        </div>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="footer-social mb-40 mt-20">
                            <a href="<?php echo e($data['facebook_url'] ?? ''); ?>" class="wow ladeInUp social" data-wow-delay="0.0s"><i class="fab fa-facebook-f icon"></i></a>
                            <a href="<?php echo e($data['instagram_url'] ?? ''); ?>" class="wow ladeInUp social" data-wow-delay="0.1s"><i class="fab fa-instagram icon"></i></a>
                            <a href="<?php echo e($data['linkedin_url'] ?? ''); ?>" class="wow ladeInUp social" data-wow-delay="0.2s"><i class="fab fa-linkedin-in icon"></i></a>
                            <a href="<?php echo e($data['twitter_url'] ?? ''); ?>" class="wow ladeInUp social" data-wow-delay="0.3s"><i class="fab fa-twitter icon"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <!-- Contact Map -->
                        <div class="mapArea">
                            <div class="mapWrapper-contact">
                                <?php echo $data['location']; ?>

                            </div>
                        </div>
                        <!-- End-of Map -->
                    </div>
                </div>
            </div>

            <?php
                $default_theme = get_static_option('tenant_default_theme');
                $class_condition = '';

                switch ($default_theme){
                    case 'job-find';
                    case 'article-listing';
                    $class_condition = '2';
                    break;
                    default;
                }
            ?>

            <div class="col-xl-7 col-lg-5">
                <div class="simplePresentCart<?php echo e($class_condition); ?> cart mb-24 contact_form">

                        <h2 class="tittle"><?php echo e($data['title']); ?></h2>

                            <?php if(!empty($data['custom_form_id'])): ?>
                                <?php
                                    $form_details = \App\Models\FormBuilder::find($data['custom_form_id']);
                                ?>
                            <?php endif; ?>

                            <?php echo \App\Helpers\FormBuilderCustom::render_form(optional($form_details)->id,null,null,'btn-default'); ?>


                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).on('submit', '.custom-form-builder-ten', function (e) {
            e.preventDefault();
            var btn = $('#contact_form_btn');
            var form = $(this);
            var formID = form.attr('id');
            var msgContainer =  form.find('.error-message');
            var formSelector = document.getElementById(formID);
            var formData = new FormData(formSelector);
            msgContainer.html('');
            $.ajax({
                url: "<?php echo e(route(route_prefix().'frontend.form.builder.custom.submit')); ?>",
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>",
                },
                beforeSend:function (){
                    btn.html('<i class="fas fa-spinner fa-spin mr-1"></i> <?php echo e(__("Submiting..")); ?>');
                },
                processData: false,
                contentType: false,
                data:formData,
                success: function (data) {
                    form.find('.ajax-loading-wrap').removeClass('show').addClass('hide');
                    msgContainer.html('<div class="alert alert-'+data.type+'">' + data.msg + '</div>');
                    btn.text('<?php echo e(__("Submit Message")); ?>');
                    form[0].reset();

                },
                error: function (data) {

                    form.find('.ajax-loading-wrap').removeClass('show').addClass('hide');
                    var errors = data.responseJSON.errors;
                    var markup = '<ul class="alert alert-danger">';

                    $.each(errors,function (index,value){
                        markup += '<li>'+value+'</li>';})
                    markup += '</ul>';


                    msgContainer.html(markup);
                    btn.text('<?php echo e(__("Submit Message")); ?>');
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>


<?php /**PATH /home/multipurposesass/public_html/core/plugins/PageBuilder/views/tenant/Common/contact/contact-area.blade.php ENDPATH**/ ?>