<?php $__env->startSection('title'); ?>
    <?php echo e(__('Payment Success For:')); ?> <?php echo e($payment_details->package_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e($payment_details->package_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php
        $user_lang = get_user_lang();
    ?>

    <div class="error-page-content" data-padding-bottom="100">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="order-success-area margin-bottom-80 text-center pt-5">
                        <h1 class="title"><?php echo e(get_static_option('site_order_success_page_' . $user_select_lang_slug . '_title')); ?></h1>

                        <?php if($payment_details->is_renew == 1): ?>
                            <p class="order-page-description"><?php echo e(__('Package renewed successfully..!')); ?></p>
                         <?php else: ?>
                        <p class="order-page-description"><?php echo e(get_static_option('site_order_success_page_' . $user_select_lang_slug . '_description')); ?></p>
                        <?php endif; ?>

                        <?php if(empty($domain)): ?>
                            <div class="alert alert-warning mt-2"><?php echo e(__('Your website is not ready yet, you will get notified by email when it is ready.')); ?></div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-lg-6">
                    <h2 class="billing-title mb-3"><?php echo e(__('Order Details')); ?></h2>
                    <ul class="billing-details">
                        <li><strong><?php echo e(__('Order ID :')); ?></strong> #<?php echo e($payment_details->id); ?></li>
                        <li><strong><?php echo e(__('Payment Package :')); ?></strong> <?php echo e($payment_details->package_name); ?></li>
                        <li><strong><?php echo e(__('Payment Package Type :')); ?></strong> <?php echo e(\App\Enums\PricePlanTypEnums::getText(optional($payment_details->package)->type)); ?></li>
                        <li><strong><?php echo e(__('Payment Gateway : ')); ?></strong> <?php echo e($payment_details->package_gateway); ?></li>
                        <li><strong><?php echo e(__('Payment Status :')); ?></strong> <?php echo e($payment_details->payment_status); ?></li>
                        <li><strong><?php echo e(__('Transaction id :')); ?></strong> <?php echo e($payment_details->transaction_id); ?></li>
                    </ul>
                    <h2 class="billing-title mt-4 mb-2"><?php echo e(__('Billing Details')); ?></h2>
                    <ul class="billing-details">
                        <li><strong><?php echo e(__('Name :')); ?></strong> <?php echo e($payment_details->name); ?></li>
                        <li><strong><?php echo e(__('Email :')); ?></strong> <?php echo e($payment_details->email); ?></li>
                    </ul>
                    <div class="btn-wrapper margin-top-40">
                        <a href="<?php echo e(route('landlord.homepage')); ?>" class="boxed-btn"><?php echo e(__('Back To Home')); ?></a>
                    </div>
                </div>


                <div class="col-xl-4 col-lg-5 col-md-6">
                    <div class="packageDetails">
                        <div class="text-center mb-60">
                            <span class="infoTitle"><?php echo e(optional($payment_details->package)->getTranslation('title',$user_lang)); ?></span>
                            <span class="pricing"><?php echo e(amount_with_currency_symbol($payment_details->package_price)); ?></span>
                            <h6 class="title text-primary"><?php echo e(__('Start Date : ')); ?><?php echo e($payment_details->start_date ?? ''); ?></h6>
                            <h6 class="title text-danger mt-2"><?php echo e(__('Expire Date : ')); ?><?php echo e($payment_details->expire_date ?? 'Life Time'); ?></h6>
                        </div>
                        <ul>
                            <?php echo get_all_main_feature_create_permission($payment_details->package); ?>

                            <?php $__currentLoopData = optional($payment_details->package)->plan_features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="single"><img src="<?php echo e(asset('assets/landlord/frontend/img/icon/check.svg')); ?>" class="icon" alt="image">
                                    <?php echo e(__(str_replace('_', ' ',ucfirst($item->feature_name))) ?? ''); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('landlord.frontend.frontend-page-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/resources/views/landlord/frontend/payment/payment-success.blade.php ENDPATH**/ ?>