<?php
    $left_blog = $data['left_blog'];
    $blogs = $data['blogs'];
?>

<div class="newspaper_banner newspaper_banner__padding">
    <div class="container" data-padding-top="<?php echo e($data['padding_top']); ?>" data-padding-bottom="<?php echo e($data['padding_bottom']); ?>">

        <div class="row g-4">
            <div class="col-xl-6">
                <div class="newspaper_banner__left">
                    <div class="newspaper_banner__thumb">
                        <a href="<?php echo e(route('tenant.frontend.blog.single',$left_blog->slug)); ?>">
                          <?php echo render_image_markup_by_attachment_id($left_blog->image); ?>

                        </a>
                    </div>
                    <div class="newspaper_banner__content mt-4">
                        <div class="newspaper_banner__content__tag">
                            <a href="<?php echo e(route('tenant.frontend.blog.category',['id'=> $left_blog->category_id, 'any' => \Illuminate\Support\Str::slug($left_blog->category?->title)])); ?>" class="newspaper_banner__content__tag__item"><i class="las la-tags"></i><?php echo e($left_blog->category?->title); ?></a>
                            <a href="<?php echo e(route('tenant.frontend.blog.single',$left_blog->slug)); ?>" class="newspaper_banner__content__tag__item"><i class="las la-clock"></i> <?php echo e(date('d M Y',strtotime($left_blog->created_at))); ?></a>
                        </div>
                        <h2 class="newspaper_banner__content__title mt-3"><a href="<?php echo e(route('tenant.frontend.blog.single',$left_blog->slug)); ?>"><?php echo e($left_blog->title); ?></a></h2>
                        <p class="newspaper_banner__content__para mt-3"><?php echo \Illuminate\Support\Str::words($left_blog->blog_content,85); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-xl-6">
                <div class="newspaper_banner__right">
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="newspaper_banner__news">
                            <div class="newspaper_banner__news__flex">
                                <div class="newspaper_banner__news__thumb">
                                    <a href="<?php echo e(route('tenant.frontend.blog.single',$data->slug)); ?>">
                                        <?php echo render_image_markup_by_attachment_id($data->image); ?>

                                    </a>
                                </div>
                                <div class="newspaper_banner__news__contents">
                                    <div class="newspaper_banner__news__date">
                                        <a href="<?php echo e(route('tenant.frontend.blog.single',$data->slug)); ?>" class="newspaper_banner__news__date__item"><i class="las la-clock"></i> <span><?php echo e(date('d M Y',strtotime($data->created_at))); ?></span></a>
                                    </div>
                                    <h5 class="newspaper_banner__news__title mt-1"><a href="<?php echo e(route('tenant.frontend.blog.single',$data->slug)); ?>"><?php echo e($data->title); ?></a></h5>
                                    <p class="newspaper_banner__news__para mt-2"><?php echo \Illuminate\Support\Str::words($data->blog_content,35); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/multipurposesass/public_html/core/plugins/PageBuilder/views/tenant/newspaper/header.blade.php ENDPATH**/ ?>