<?php

namespace Plugins\WidgetBuilder\Widgets;
use App\Facades\GlobalLanguage;
use App\Helpers\LanguageHelper;
use App\Helpers\SanitizeInput;
use App\PageBuilder\Traits\LanguageFallbackForPageBuilder;
use Plugins\PageBuilder\Fields\Repeater;
use Plugins\PageBuilder\Fields\Text;
use Plugins\PageBuilder\Helpers\RepeaterField;
use Plugins\WidgetBuilder\WidgetBase;
use Mews\Purifier\Facades\Purifier;

class ContactInfoWidget extends WidgetBase
{

    public function admin_render()
    {
        $output = $this->admin_form_before();
        $output .= $this->admin_form_start();
        $output .= $this->default_fields();

        $widget_saved_values = $this->get_settings();
        $output .= $this->admin_language_tab();
        $output .= $this->admin_language_tab_start();

        $all_languages = GlobalLanguage::all_languages();

        foreach ($all_languages as $key => $lang) {
            $output .= $this->admin_language_tab_content_start([
                'class' => $key == 0 ? 'tab-pane fade show active' : 'tab-pane fade',
                'id' => "nav-home-" . $lang->slug
            ]);
            $output .= Text::get([
                'name' => 'title_'.$lang->slug,
                'label' => __('Title'),
                'value' => $widget_saved_values['title_'.$lang->slug] ?? null
            ]);

            $output .= $this->admin_language_tab_content_end();
        }
        $output .= $this->admin_language_tab_end();



        //repeater
        $output .= Repeater::get([
            'settings' => $widget_saved_values,
            'id' => 'footer_contact_info_landlord',
            'fields' => [
                [
                    'type' => RepeaterField::TEXT,
                    'name' => 'repeater_title',
                    'label' => __('Info')
                ],

                [
                    'type' => RepeaterField::ICON_PICKER,
                    'name' => 'repeater_icon',
                    'label' => __('Icon')
                ],
            ]
        ]);


        $output .= $this->admin_form_submit_button();
        $output .= $this->admin_form_end();
        $output .= $this->admin_form_after();

        return $output;
    }

    public function frontend_render()
    {
        // TODO: Implement frontend_render() method.
        $user_selected_language = get_user_lang();
        $widget_saved_values = $this->get_settings();
        $widget_title =  SanitizeInput::esc_html($widget_saved_values['title_' . $user_selected_language] ?? '');

        $repeater_data = $widget_saved_values['footer_contact_info_landlord'] ?? [];

        $repeater_markup = '';
        foreach ($repeater_data['repeater_title_'] as $key => $title){
            $r_title = $title ?? '';
            $r_icon = $repeater_data['repeater_icon_'][$key] ?? '';

   $repeater_markup.= <<<SOCIALITEM
     <li class="listItem wow fadeInUp" data-wow-delay="0.0s">
        <a href="#!" class="singleLinks"><i class="{$r_icon} icon"></i>{$r_title}</a>
     </li>
SOCIALITEM;

}

return <<<HTML
<div class="col-xxl-3 col-xl-3 col-lg-6">
        <div class="footer-widget widget  mb-24">
            <div class="footer-tittle">
                <h4 class="footerTittle">{$widget_title}</h4>
                <ul class="listing-info">
                    {$repeater_markup}
                </ul>
            </div>
        </div>
    </div>
HTML;


    }

    public function widget_title()
    {
        return __('Contact Info');
    }

    public function enable(): bool
    {
        return is_null(tenant()); // TODO: Change the autogenerated stub
    }

}
