<?php

namespace Plugins\WidgetBuilder\Widgets;


use App\Facades\GlobalLanguage;
use App\Helpers\LanguageHelper;
use App\Models\Language;
use App\Models\Widgets;
use Modules\Blog\Entities\BlogCategory;
use Plugins\PageBuilder\Fields\Image;
use Plugins\PageBuilder\Fields\Number;
use Plugins\PageBuilder\Fields\Repeater;
use Plugins\PageBuilder\Fields\Select;
use Plugins\PageBuilder\Fields\Text;
use Plugins\PageBuilder\Fields\Textarea;
use Plugins\PageBuilder\Helpers\RepeaterField;
use Plugins\WidgetBuilder\WidgetBase;
use Mews\Purifier\Facades\Purifier;
use App\Helpers\SanitizeInput;

class AboutUsWidget extends WidgetBase
{
    public function admin_render()
    {
        $output = $this->admin_form_before();
        $output .= $this->admin_form_start();
        $output .= $this->default_fields();

        $widget_saved_values = $this->get_settings();
        $output .= $this->admin_language_tab();
        $output .= $this->admin_language_tab_start();

        $all_languages = GlobalLanguage::all_languages();

        foreach ($all_languages as $key => $lang) {
            $output .= $this->admin_language_tab_content_start([
                'class' => $key == 0 ? 'tab-pane fade show active' : 'tab-pane fade',
                'id' => "nav-home-" . $lang->slug
            ]);

            $output .= Textarea::get([
                'name' => 'description_'.$lang->slug,
                'label' => __('Description'),
                'value' => $widget_saved_values['description_'.$lang->slug] ?? null
            ]);

            $output .= $this->admin_language_tab_content_end();
        }
        $output .= $this->admin_language_tab_end();


        $output .= Image::get([
            'name' => 'logo_image',
            'label' => __('Logo '),
            'value' => $widget_saved_values['logo_image'] ?? null
        ]);


        //repeater
        $output .= Repeater::get([
            'settings' => $widget_saved_values,
            'id' => 'footer_social_about_media',
            'fields' => [
                [
                    'type' => RepeaterField::ICON_PICKER,
                    'name' => 'repeater_icon',
                    'label' => __('Icon')
                ],
                [
                    'type' => RepeaterField::TEXT,
                    'name' => 'repeater_icon_url',
                    'label' => __('Icon URL')
                ],
            ]
        ]);

        $output .= $this->admin_form_submit_button();
        $output .= $this->admin_form_end();
        $output .= $this->admin_form_after();

        return $output;
    }


    public function enable(): bool
    {
        return is_null(tenant()); // TODO: Change the autogenerated stub
    }

    public function frontend_render()
    {
        $user_selected_language = get_user_lang();
        $widget_saved_values = $this->get_settings();
        $description = $widget_saved_values['description_' . $user_selected_language] ?? '';
        $root_url = url('/');
        $logo_image = $widget_saved_values['logo_image'] ?? '';
        $logo = render_image_markup_by_attachment_id($logo_image,'') ?? null;


   $repeater_data = $widget_saved_values['footer_social_about_media'] ?? [];

   $repeater_markup = '';
    foreach ($repeater_data['repeater_icon_url_'] as $key => $url){
        $icon_url = $url ?? '';
        $icon = $repeater_data['repeater_icon_'][$key] ?? '';

$repeater_markup.= <<<SOCIALITEM
   <a href="{$icon_url}" class="wow fadeInUp social" data-wow-delay="0.0s">
         <i class="{$icon} icon"></i>
   </a>
SOCIALITEM;

}

return <<<HTML
    <div class="col-xxl-3 col-xl-3 col-lg-4 col-md-6 col-sm-8">
        <div class="footer-widget widget  mb-24">
            <div class="footer-tittle">
                <div class="footer-logo mb-40">
                    <a href="{$root_url}">
                      {$logo}
                    </a>
                </div>
                <div class="footer-pera">
                    <p class="pera wow fadeInUp" data-wow-delay="0.1s">{$description}</p>
                </div>
                <div class="footer-social">
                   {$repeater_markup}
                </div>
            </div>
        </div>
    </div>
HTML;
}

    public function widget_title(){
        return __('About Us');
    }

}
