<?php

namespace Database\Seeders\Tenant\ModuleData\eCommerce;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class eCommerceDataSeed
{
    public static function execute()
    {
        self::seedStatus();
        self::seedCategories();
        self::seedSubCategories();
        self::seedChildCategories();
        self::seedColors();
        self::seedSize();
        self::seedTags();
        self::seedUnit();
        self::seedCountries();
        self::seedStates();
        self::seedBadge();
        self::seedProduct();
        self::seedDeliveryOption();
        self::seedProductCategory();
        self::seedProductSubCategories();
        self::seedProductChildCategories();
        self::seedProductTags();
        self::seedProductGalleries();
        self::seedProductInventories();
        self::seedProductInventoryDetails();
        self::seedProductUOM();
        self::seedProductCreatedBy();
        self::seedProductDeliveryOption();
        self::seedProductReturnPolicies();
        self::seedCampaign();
        self::seedCampaignProducts();

        if(!Schema::hasTable('product_reviews')){
            Schema::create('product_reviews', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('product_id')->nullable();
                $table->unsignedBigInteger('user_id')->nullable();
                $table->integer('rating')->nullable();
                $table->longText('review_text')->nullable();
                $table->timestamps();

                $table->foreign("product_id")->references("id")->on("products")->cascadeOnDelete();
                $table->foreign("user_id")->references("id")->on("users")->cascadeOnDelete();
            });
        }

        if(!Schema::hasTable('statuses')){
            Schema::create('statuses', function (Blueprint $table) {
                $table->id();
                $table->string("name");
                $table->softDeletes();
            });
        }
    }

    private static function seedStatus()
    {
        DB::statement("INSERT INTO `statuses` (`id`, `name`, `deleted_at`)
        VALUES
            (1,'active',NULL),
            (2,'inactive',NULL)");
    }

    private static function seedCategories()
    {
        DB::statement("INSERT INTO `categories` (`id`, `name`, `slug`, `description`, `image_id`, `status_id`, `created_at`, `updated_at`, `deleted_at`)
    VALUES
        (1,'{\"en_US\":\"Baby\",\"ar\":\"\\\u0637\\\u0641\\\u0644\"}','baby',NULL,NULL,1,'2022-12-19 07:01:10','2023-01-03 12:13:39',NULL),
        (2,'{\"en_US\":\"Woman\",\"ar\":\"\\\u0627\\\u0644\\\u0646\\\u0633\\\u0627\\\u0621\"}','woman',NULL,NULL,1,'2022-12-19 07:01:31','2023-01-03 12:13:27',NULL),
        (3,'{\"en_US\":\"Man\",\"ar\":\"\\\u0631\\\u062c\\\u0644\"}','man',NULL,NULL,1,'2022-12-19 07:01:40','2023-01-03 12:13:09',NULL),
        (4,'{\"en_US\":\"Bag & Laggage\",\"ar\":\"\\\u062d\\\u0642\\\u064a\\\u0628\\\u0629 \\\u0623\\\u0645\\\u062a\\\u0639\\\u0629\"}','bag-laggage',NULL,NULL,1,'2022-12-19 07:01:47','2023-01-03 12:12:55',NULL),
        (5,'{\"en_US\":\"Shoes\",\"ar\":\"\\\u0623\\\u062d\\\u0630\\\u064a\\\u0629\"}','shoes',NULL,NULL,1,'2022-12-19 07:01:57','2023-01-03 12:12:42',NULL),
        (6,'{\"en_US\":\"Beauty\",\"ar\":\"\\\u062c\\\u0645\\\u0627\\\u0644\"}','beauty',NULL,NULL,1,'2022-12-19 07:02:05','2023-01-03 12:12:32',NULL),
        (7,'{\"en_US\":\"Clothing\",\"ar\":\"\\\u0645\\\u0644\\\u0627\\\u0628\\\u0633\"}','clothing',NULL,NULL,1,'2022-12-19 07:02:12','2023-01-03 12:12:20',NULL),
        (8,'{\"en_US\":\"Accessories\",\"ar\":\"\\\u0645\\\u0633\\\u062a\\\u0644\\\u0632\\\u0645\\\u0627\\\u062a\"}','accessories',NULL,NULL,1,'2022-12-19 07:05:10','2023-01-03 12:12:05',NULL),
        (9,'{\"en_US\":\"Al Ahsan\",\"ar\":\"\\\u0642\\\u0627\\\u062f\\\u0645 \\\u062c\\\u062f\\\u064a\\\u062f\"}','theme-1','dfdf',NULL,1,'2023-01-03 12:00:57','2023-01-03 12:06:07','2023-01-03 12:06:07')");
    }

    private static function seedSubCategories()
    {
        DB::statement("INSERT INTO `sub_categories` (`id`, `category_id`, `name`, `slug`, `description`, `image_id`, `created_at`, `updated_at`, `deleted_at`, `status_id`)
    VALUES
        (1,3,'{\"en_US\":\"Man Collection\",\"ar\":\"\\\u062c\\\u0645\\\u0639 \\\u0627\\\u0644\\\u0631\\\u062c\\\u0644\"}','man-collection','{\"en_US\":\"dfg\",\"ar\":\"\\\u062c\\\u0645\\\u0639 \\\u0627\\\u0644\\\u0631\\\u062c\\\u0644\"}',NULL,'2022-12-19 07:02:57','2023-01-03 12:49:22',NULL,1),
        (2,2,'{\"en_US\":\"Women Collection\",\"ar\":\"\\\u062c\\\u0645\\\u0639 \\\u0627\\\u0644\\\u0646\\\u0633\\\u0627\\\u0621\"}','women-collection','{\"en_US\":\"sfdsd\",\"ar\":\"\\\u062c\\\u0645\\\u0639 \\\u0627\\\u0644\\\u0646\\\u0633\\\u0627\\\u0621\"}',NULL,'2022-12-19 07:03:07','2023-01-03 12:47:52',NULL,1),
        (3,1,'{\"en_US\":\"Baby Collection\",\"ar\":\"\\\u062c\\\u0645\\\u0639 \\\u0627\\\u0644\\\u0623\\\u0637\\\u0641\\\u0627\\\u0644\"}','baby-collection','{\"en_US\":\"dd\",\"ar\":\"\\\u062c\\\u0645\\\u0639 \\\u0627\\\u0644\\\u0623\\\u0637\\\u0641\\\u0627\\\u0644\"}',NULL,'2022-12-19 07:03:18','2023-01-03 12:47:38',NULL,1),
        (4,6,'{\"en_US\":\"Women Fashion\",\"ar\":\"\\\u0623\\\u0632\\\u064a\\\u0627\\\u0621 \\\u0646\\\u0633\\\u0627\\\u0626\\\u064a\\\u0629\"}','women-fashion','{\"en_US\":\"ded\",\"ar\":\"\\\u0623\\\u0632\\\u064a\\\u0627\\\u0621 \\\u0646\\\u0633\\\u0627\\\u0626\\\u064a\\\u0629\"}',NULL,'2022-12-19 07:03:33','2023-01-03 12:47:24',NULL,1),
        (5,4,'{\"en_US\":\"Lather Items\",\"ar\":\"\\\u0645\\\u0648\\\u0627\\\u062f \\\u0631\\\u063a\\\u0648\\\u0629\"}','lather-items','{\"en_US\":\"This is description\",\"ar\":\"\\\u0645\\\u0648\\\u0627\\\u062f \\\u0631\\\u063a\\\u0648\\\u0629\"}',NULL,'2022-12-19 07:03:46','2023-01-03 12:47:04',NULL,1),
        (6,5,'{\"en_US\":\"Lofer\",\"ar\":\"\\\u0644\\\u0648\\\u0641\\\u0631\"}','lofer','{\"en_US\":\"This is description\",\"ar\":\"\\u0644\\u0648\\u0641\\u0631\"}',NULL,'2022-12-19 07:03:57','2023-01-03 12:46:50',NULL,1),
        (7,7,'{\"en_US\":\"Indian Cloths\",\"ar\":\"\\\u0645\\\u0644\\\u0627\\\u0628\\\u0633 \\\u0647\\\u0646\\\u062f\\\u064a\\\u0629\"}','indian-cloths','{\"ar\":\"\\\u0645\\\u0644\\\u0627\\\u0628\\\u0633 \\\u0647\\\u0646\\\u062f\\\u064a\\\u0629\"}',NULL,'2022-12-19 07:04:48','2023-01-03 12:46:39',NULL,1),
        (8,3,'{\"en_US\":\"Watch\",\"ar\":\"\\\u0631\\\u0627\\\u0642\\\u0628\"}','watch','{\"en_US\":\"This is description\",\"ar\":\"\\u0631\\u0627\\u0642\\u0628\"}',NULL,'2022-12-19 07:05:02','2023-01-03 12:46:18',NULL,1),
        (9,8,'{\"en_US\":\"Headphones\",\"ar\":\"\\\u0633\\\u0645\\\u0627\\\u0639\\\u0629\"}','headphones','{\"en_US\":\"This is description\",\"ar\":\"\\\u0633\\\u0645\\\u0627\\\u0639\\\u0629\"}',NULL,'2022-12-19 07:05:21','2023-01-03 12:46:07',NULL,1),
        (10,8,'{\"en_US\":\"Test\",\"ar\":\"\\\u0637\\\u0641\\\u0644\"}','test','{\"en_US\":\"sssss\",\"ar\":\"\\\u0647\\\u0630\\\u0627 \\\u0648\\\u0635\\\u0641\"}',NULL,'2023-01-03 12:38:40','2023-01-03 12:43:32',NULL,1)");
    }

    private static function seedChildCategories()
    {
        DB::statement("INSERT INTO `child_categories` (`id`, `category_id`, `sub_category_id`, `name`, `slug`, `description`, `image_id`, `created_at`, `updated_at`, `deleted_at`, `status_id`)
    VALUES
        (1,7,7,'{\"en_US\":\"Indian Cloths\",\"ar\":\"\\\u0645\\\u0644\\\u0627\\\u0628\\\u0633 \\\u0647\\\u0646\\\u062f\\\u064a\\\u0629\"}','indian-cloths',NULL,NULL,'2022-12-19 07:05:42','2023-01-03 13:32:44',NULL,1),
        (2,3,1,'{\"en_US\":\"Pakistani Shirt\",\"ar\":\"\\\u0642\\\u0645\\\u064a\\\u0635 \\\u0628\\\u0627\\\u0643\\\u0633\\\u062a\\\u0627\\\u0646\\\u064a\"}','pakistani-shirt',NULL,NULL,'2022-12-19 07:05:57','2023-01-03 13:32:22',NULL,1),
        (3,5,6,'{\"en_US\":\"Chinese Shoes\",\"ar\":\"\\\u0623\\\u062d\\\u0630\\\u064a\\\u0629 \\\u0635\\\u064a\\\u0646\\\u064a\\\u0629\"}','chinese-shoes',NULL,NULL,'2022-12-19 07:06:12','2023-01-03 13:32:07',NULL,1),
        (4,6,4,'{\"en_US\":\"Fresh creams\",\"ar\":\"\\\u0643\\\u0631\\\u064a\\\u0645\\\u0627\\\u062a \\\u0637\\\u0627\\\u0632\\\u062c\\\u0629\"}','fresh-creams',NULL,NULL,'2022-12-19 07:06:30','2023-01-03 13:31:55',NULL,1),
        (5,8,9,'{\"en_US\":\"Gadgets\",\"ar\":\"\\u0627\\\u0644\\\u0623\\\u062f\\\u0648\\\u0627\\\u062a\"}','gadgets',NULL,NULL,'2022-12-19 07:06:41','2023-01-03 13:31:46',NULL,1),
        (6,6,4,'{\"en_US\":\"Anyway Bag\",\"ar\":\"\\\u0639\\\u0644\\\u0649 \\\u0623\\\u064a \\\u062d\\\u0627\\\u0644 \\\u062d\\\u0642\\\u064a\\\u0628\\\u0629\"}','anyway-bag',NULL,NULL,'2022-12-19 09:37:09','2023-01-03 13:31:36',NULL,1)");
    }

    private static function seedColors()
    {
        DB::statement("INSERT INTO `colors` (`id`, `name`, `color_code`, `slug`, `created_at`, `updated_at`)
    VALUES
        (1,'{\"en\":\"Black\",\"en_US\":\"Black\",\"ar\":\"\\\u0623\\\u0633\\u0648\\\u062f\"}','#000000','black','2022-12-19 07:08:45','2023-01-03 14:45:12'),
        (2,'{\"en\":\"Green Olive\",\"en_US\":\"Green Olive\",\"ar\":\"\\\u0627\\\u0644\\\u0632\\\u064a\\\u062a\\\u0648\\\u0646 \\\u0627\\\u0644\\\u0623\\\u062e\\\u0636\\\u0631\"}','#50cd37','olive','2022-12-19 07:09:20','2023-01-03 14:45:04'),
        (3,'{\"en\":\"Gillian Clemons\",\"en_US\":\"Gillian Clemons\",\"ar\":\"\\\u062c\\\u064a\\\u0644\\\u064a\\\u0627\\\u0646 \\\u0643\\\u0644\\\u064a\\\u0645\\\u0648\\\u0646\\\u0632\"}','#4ba6ce','sky-blue','2022-12-19 07:09:34','2023-01-03 14:44:54'),
        (4,'{\"en\":\"Violet Chen\",\"en_US\":\"Violet Chen\",\"ar\":\"\\\u062a\\\u0634\\\u0646 \\\u0627\\\u0644\\\u0628\\\u0646\\\u0641\\\u0633\\\u062c\"}','#b042b8','purple','2022-12-19 07:09:47','2023-01-03 14:44:44'),
        (5,'{\"en\":\"Yellow\",\"en_US\":\"Yellow\",\"ar\":\"\\\u0623\\\u0635\\\u0641\\\u0631\"}','#e9d816','yellow','2022-12-19 07:10:19','2023-01-03 14:44:01'),
        (6,'{\"en\":\"White\",\"en_US\":\"White\",\"ar\":\"\\\u0623\\\u0628\\\u064a\\\u0636\"}','#ffffff','white','2022-12-19 07:10:30','2023-01-03 14:43:50')");
    }

    private static function seedSize()
    {
        DB::statement("INSERT INTO `sizes` (`id`, `name`, `size_code`, `slug`, `created_at`, `updated_at`)
    VALUES
        (1,'{\"en_US\":\"Extra Large\",\"ar\":\"\\\u0635\\\u063a\\\u064a\\\u0631 \\\u062c\\\u062f\\\u0627\"}','XL','extra-large','2022-12-19 07:10:52','2023-01-03 14:56:38'),
        (2,'{\"en_US\":\"Extra Small\",\"ar\":\"\\\u0635\\\u063a\\\u064a\\\u0631 \\\u062c\\\u062f\\\u0627\"}','XS','extra-small','2022-12-19 07:10:59','2023-01-03 14:56:45'),
        (3,'{\"en_US\":\"Medium\",\"ar\":\"\\u0645\\\u062a\\\u0648\\\u0633\\\u0637\"}','M','medium','2022-12-19 07:11:05','2023-01-03 14:56:01'),
        (4,'{\"en_US\":\"Small\",\"ar\":\"\\\u0635\\\u063a\\\u064a\\\u0631\"}','S','small','2022-12-19 07:11:11','2023-01-03 14:55:51'),
        (5,'{\"en_US\":\"Large\",\"ar\":\"\\\u0643\\\u0628\\\u064a\\\u0631\"}','L','large','2022-12-19 07:11:19','2023-01-03 14:55:40')");
    }

    private static function seedTags()
    {
        DB::statement("INSERT INTO `tags` (`id`, `tag_text`, `created_at`, `updated_at`, `deleted_at`)
    VALUES
        (1,'{\"en_US\":\"saree\",\"ar\":\"\\\u0644\\\u0648\\\u0646 \\\u062a\\\u064a \\\u0634\\\u064a\\\u0631\\\u062a\"}','2022-12-19 07:06:58','2023-01-03 14:00:11',NULL),
        (2,'{\"en_US\":\"kameez\",\"ar\":\"\\\u0644\\\u0648\\\u0646 \\\u062a\\\u064a \\\u0634\\\u064a\\\u0631\\\u062a\"}','2022-12-19 07:07:04','2023-01-03 14:00:08',NULL),
        (3,'{\"en_US\":\"casual t shirt\",\"ar\":\"\\\u0644\\\u0648\\\u0646 \\\u062a\\\u064a \\\u0634\\\u064a\\\u0631\\\u062a\"}','2022-12-19 07:07:09','2023-01-03 14:00:04',NULL),
        (4,'{\"en_US\":\"sun glasses\",\"ar\":\"\\\u0644\\\u0648\\\u0646 \\\u062a\\\u064a \\\u0634\\\u064a\\\u0631\\\u062a\"}','2022-12-19 07:07:15','2023-01-03 14:00:01',NULL),
        (5,'{\"en_US\":\"best dress for kid\",\"ar\":\"\\\u0644\\\u0648\\\u0646 \\\u062a\\\u064a \\\u0634\\\u064a\\\u0631\\\u062a\"}','2022-12-19 07:07:20','2023-01-03 13:59:58',NULL),
        (6,'{\"en_US\":\"denim shirt\",\"ar\":\"\\\u0644\\\u0648\\\u0646 \\\u062a\\\u064a \\\u0634\\\u064a\\\u0631\\\u062a\"}','2022-12-19 07:07:26','2023-01-03 13:59:55',NULL),
        (7,'{\"en_US\":\"stylish hat\",\"ar\":\"\\\u0644\\\u0648\\\u0646 \\\u062a\\\u064a \\\u0634\\\u064a\\\u0631\\\u062a\"}','2022-12-19 07:07:31','2023-01-03 13:59:53',NULL),
        (8,'{\"en_US\":\"color t shirt\",\"ar\":\"\\\u0644\\\u0648\\\u0646 \\\u062a\\\u064a \\\u0634\\\u064a\\\u0631\\\u062a\"}','2022-12-19 07:07:43','2023-01-03 13:59:49',NULL)");
    }


    private static function seedUnit()
    {
        DB::statement("INSERT INTO `units` (`id`, `name`, `created_at`, `updated_at`, `deleted_at`)
    VALUES
        (1,'Pair','2022-12-19 07:07:57','2022-12-19 07:07:57',NULL),
        (2,'Piece','2022-12-19 07:08:01','2022-12-19 07:08:01',NULL),
        (3,'g','2022-12-19 07:08:07','2022-12-19 07:08:07',NULL),
        (4,'Ltr','2022-12-19 07:08:12','2022-12-19 07:08:12',NULL),
        (5,'Dozen','2022-12-19 07:08:17','2022-12-19 07:08:17',NULL),
        (6,'Lb','2022-12-19 07:08:22','2022-12-19 07:08:22',NULL),
        (7,'Kg','2022-12-19 07:08:26','2022-12-19 07:08:26',NULL)");
    }

    private static function seedCountries()
    {
        DB::statement("INSERT INTO `countries` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES
        (1, 'Bangladesh', 'publish', '2022-08-22 06:35:32', '2022-08-22 06:35:32'),
        (2, 'USA', 'publish', '2022-08-22 06:35:38', '2022-08-22 06:35:38'),
        (3, 'Turkey', 'publish', '2022-08-22 06:35:43', '2022-08-22 06:35:43'),
        (4, 'Russia', 'publish', '2022-08-22 06:35:48', '2022-08-22 06:35:48'),
        (5, 'China', 'publish', '2022-08-22 06:35:52', '2022-08-22 06:35:52'),
        (6, 'England', 'publish', '2022-08-22 06:35:59', '2022-08-22 06:35:59'),
        (7, 'Saudi Arabia', 'publish', '2022-08-22 06:41:29', '2022-08-22 06:41:29')");
    }

    private static function seedStates()
    {
        DB::statement("INSERT INTO `states` (`id`, `name`, `country_id`, `status`, `created_at`, `updated_at`) VALUES
        (1, 'Dhaka', 1, 'publish', '2022-08-22 06:36:11', '2022-08-22 06:36:11'),
        (2, 'Chandpur', 1, 'publish', '2022-08-22 06:36:15', '2022-08-22 06:36:15'),
        (3, 'Noakhali', 1, 'publish', '2022-08-22 06:36:21', '2022-08-22 06:36:21'),
        (4, 'Bhola', 1, 'publish', '2022-08-22 06:36:27', '2022-08-22 06:36:27'),
        (5, 'Barishal', 1, 'publish', '2022-08-22 06:36:32', '2022-08-22 06:36:32'),
        (6, 'Nework', 2, 'publish', '2022-08-22 06:36:43', '2022-08-22 06:36:43'),
        (7, 'Chicago', 2, 'publish', '2022-08-22 06:36:54', '2022-08-22 06:36:54'),
        (8, 'Las Vegas', 2, 'publish', '2022-08-22 06:37:05', '2022-08-22 06:37:05'),
        (9, 'Ankara', 3, 'publish', '2022-08-22 06:37:12', '2022-08-22 06:37:12'),
        (10, 'Istanbul', 3, 'publish', '2022-08-22 06:37:19', '2022-08-22 06:37:19'),
        (11, 'Izmir', 3, 'publish', '2022-08-22 06:37:26', '2022-08-22 06:37:26'),
        (12, 'Moscow', 4, 'publish', '2022-08-22 06:37:34', '2022-08-22 06:37:34'),
        (13, 'Lalingard', 4, 'publish', '2022-08-22 06:37:44', '2022-08-22 06:37:44'),
        (14, 'Siberia', 4, 'publish', '2022-08-22 06:37:55', '2022-08-22 06:37:55'),
        (15, 'Shanghai', 5, 'publish', '2022-08-22 06:38:04', '2022-08-22 06:38:04'),
        (16, 'Anuhai', 5, 'publish', '2022-08-22 06:38:13', '2022-08-22 06:38:13'),
        (17, 'Hong Kong', 5, 'publish', '2022-08-22 06:38:29', '2022-08-22 06:38:29'),
        (18, 'London', 6, 'publish', '2022-08-22 06:38:37', '2022-08-22 06:38:37'),
        (19, 'Madina', 7, 'publish', '2022-08-22 06:41:44', '2022-08-22 06:41:44')");
    }

    private static function seedDeliveryOption()
    {
        DB::statement("INSERT INTO `delivery_options` (`id`, `icon`, `title`, `sub_title`, `created_at`, `updated_at`, `deleted_at`)
    VALUES
        (1,'las la-user','{\"en_US\":\"7 Days Return\",\"ar\":\"7 \\\u0623\\\u064a\\\u0627\\\u0645 \\\u0644\\\u0644\\\u0625\\\u0631\\\u062c\\\u0627\\\u0639\"}','{\"en_US\":\"Without any damage\",\"ar\":\"\\\u0628\\\u062f\\\u0648\\\u0646 \\\u0623\\\u064a \\\u0636\\\u0631\\\u0631\"}','2022-12-19 07:30:11','2023-01-03 15:39:51',NULL),
        (2,'las la-user','{\"en_US\":\"Free Shipping\",\"ar\":\"\\\u0627\\u0644\\\u0634\\\u062d\\\u0646 \\\u0645\\\u062c\\\u0627\\\u0646\\\u0627\"}','{\"en_US\":\"Order over 100$\",\"ar\":\"\\\u0627\\\u0637\\\u0644\\\u0628 \\\u0623\\\u0643\\\u062b\\\u0631 \\\u0645\\\u0646 100 \\\u062f\\\u0648\\\u0644\\\u0627\\\u0631\"}','2022-12-19 07:30:26','2023-01-03 15:39:31',NULL),
        (3,'las la-user','{\"en_US\":\"Estimated Delivery\",\"ar\":\"\\\u0627\\\u0644\\\u062a\\\u0648\\\u0635\\\u064a\\\u0644 \\\u0627\\\u0644\\\u0645\\\u062a\\\u0648\\\u0642\\\u0639\"}','{\"en_US\":\"With 4 Days\",\"ar\":\"\\\u0645\\\u0639 4 \\\u0623\\\u064a\\\u0627\\\u0645\"}','2022-12-19 07:30:40','2023-01-03 15:39:12',NULL)");
    }

    private static function seedBadge()
    {
        DB::statement("INSERT INTO `badges` (`id`, `name`, `image`, `for`, `sale_count`, `type`, `status`, `created_at`, `updated_at`, `deleted_at`)
    VALUES
        (1,'{\"en_US\":\"New Arival\",\"ar\":\"\\\u0642\\\u0627\\\u062f\\\u0645 \\\u062c\\\u062f\\\u064a\\\u062f\"}',242,NULL,NULL,NULL,'active','2022-12-19 06:47:34','2023-01-03 11:37:50',NULL),
        (2,'{\"en_US\":\"60 Sales\",\"ar\":\"60 \\\u0645\\\u0628\\\u064a\\\u0639\\\u0627\\\u062a\"}',248,NULL,NULL,NULL,'active','2022-12-19 06:48:00','2023-01-03 11:37:38',NULL),
        (3,'{\"en_US\":\"test\",\"ar\":\"\\\u0642\\\u0627\\\u062f\\\u0645 \\\u062c\\\u062f\\\u064a\\\u062f\"}',255,NULL,NULL,NULL,'active','2023-01-03 11:38:07','2023-01-03 11:38:35','2023-01-03 11:38:35')");
    }

    private static function seedProduct()
    {
        DB::statement("INSERT INTO `products` (`id`, `name`, `slug`, `summary`, `description`, `image_id`, `price`, `sale_price`, `cost`, `badge_id`, `brand_id`, `status_id`, `product_type`, `sold_count`, `min_purchase`, `max_purchase`, `is_refundable`, `is_in_house`, `is_inventory_warn_able`, `created_at`, `updated_at`, `deleted_at`)
    VALUES
        (1,'{\"ar\":\"\\\u0642\\\u0645\\\u064a\\\u0635 \\\u062e\\\u0641\\\u064a\\\u0641\",\"en_US\":\"Light stylest Shirt\"}','light-stylest-shirt','{\"ar\":\"\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\",\"en_US\":\"We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally\"}','{\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; font-weight: initial; text-align: var(--bs-body-text-align);\\\"><br><\\/span><br><\\/p>\",\"en_US\":\"<p><span style=\\\"color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/span><span style=\\\"color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; font-size: 1rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/span><\\/p><p><span style=\\\"color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/span><span style=\\\"color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/span><span style=\\\"color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; font-size: 1rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\"><br><\\/span><br><\\/p>\"}','279',25,30,15,1,1,1,1,NULL,10,10,0,1,1,'2022-12-19 08:15:58','2023-01-04 15:16:06',NULL),
        (7,'{\"ar\":\"\\\u0644\\\u0628\\\u0627\\\u0633 \\\u0627\\\u0644\\\u0645\\\u0631\\\u0623\\\u0629\",\"en_US\":\"Women Beauty Care\"}','women-beauty','{\"ar\":\"\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\",\"en_US\":\"We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally\"}','{\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<br><\\/p>\",\"en_US\":\"<p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationallyWe are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationallyWe are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<br><\\/p>\"}','287',40,50,35,1,1,1,1,NULL,10,10,0,1,1,'2022-12-19 09:29:26','2023-01-04 15:32:28',NULL),
        (8,'{\"en_US\":\"Man Lofer\",\"ar\":\"\\\u062d\\\u0630\\\u0627\\\u0621 \\\u0631\\\u062c\\\u0627\\\u0644\\\u064a\"}','man-lofer','{\"en_US\":\"We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally\",\"ar\":\"\\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\"}','{\"en_US\":\"<p><span style=\\\"color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/span><\\/p><p><span style=\\\"color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/span><\\/p><p><span style=\\\"color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/span><span style=\\\"color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; font-size: 16px;\\\"><br><\\/span><span style=\\\"color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; font-size: 16px;\\\"><br><\\/span><br><\\/p>\",\"ar\":\"<p>&nbsp;\\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/p><p>&nbsp;\\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<br><\\/p>\"}','299',26,30,22,1,1,1,1,NULL,10,10,0,1,1,'2022-12-19 09:32:26','2023-01-04 15:34:52',NULL),
        (9,'{\"ar\":\"\\\u0633\\\u0645\\\u0627\\\u0639\\\u0629 \\\u0631\\\u0623\\\u0633 190\",\"en_US\":\"Sun Protective Glass\"}','sun-glass','{\"ar\":\"\\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\",\"en_US\":\"We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally\"}','{\"ar\":\"<p>&nbsp;\\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; font-weight: initial; text-align: var(--bs-body-text-align);\\\">&nbsp;\\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span><\\/p><p>&nbsp;\\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; font-weight: initial; text-align: var(--bs-body-text-align);\\\"><br><\\/span><br><\\/p>\",\"en_US\":\"<p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationallyWe are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<br><\\/p>\"}','308',120,140,110,1,1,1,1,NULL,10,10,0,1,1,'2022-12-19 09:33:53','2023-01-04 15:33:48',NULL),
        (10,'{\"ar\":\"\\\u062d\\\u0645\\\u0644 \\\u0627\\\u0644\\\u062d\\\u0642\\\u064a\\\u0628\\\u0629\",\"en_US\":\"Carring Bag\"}','carring-bag','{\"ar\":\"\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\",\"en_US\":\"We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally\"}','{\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"font-weight: initial; text-align: var(--bs-body-text-align); background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span><span style=\\\"background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span><span style=\\\"font-weight: initial; text-align: var(--bs-body-text-align); background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"font-weight: initial; text-align: var(--bs-body-text-align); background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span><span style=\\\"font-weight: initial; text-align: var(--bs-body-text-align); background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ;\\\"><br><\\/span><br><\\/p>\",\"en_US\":\"<p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationallyWe are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<br><\\/p>\"}','304',120,140,110,1,1,1,1,NULL,10,10,0,1,1,'2022-12-19 09:35:50','2023-01-04 15:31:32',NULL),
        (11,'{\"ar\":\"\\\u062d\\u0630\\\u0627\\\u0621 \\\u0645\\\u062a\\\u0639\\\u0637\\\u0644\",\"en_US\":\"Indian Lofer\"}','indian-lofer','{\"ar\":\"\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\",\"en_US\":\"We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally\"}','{\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"font-weight: initial; text-align: var(--bs-body-text-align); background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"font-weight: initial; text-align: var(--bs-body-text-align); background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"font-weight: initial; text-align: var(--bs-body-text-align); background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span><span style=\\\"font-weight: initial; text-align: var(--bs-body-text-align); background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ;\\\"><br><\\/span><br><\\/p>\",\"en_US\":\"<p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationallyWe are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<br><\\/p>\"}','302',80,75,50,2,1,1,1,NULL,10,10,0,1,1,'2022-12-26 06:33:45','2023-01-04 15:29:27',NULL),
        (12,'{\"ar\":\"\\\u062d\\\u0630\\\u0627\\\u0621 \\\u0635\\\u064a\\\u0646\\\u064a\",\"en_US\":\"Chinese Shirt\"}','chinese-shoe','{\"ar\":\"\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\",\"en_US\":\"We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally\"}','{\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; font-weight: initial; text-align: var(--bs-body-text-align);\\\"><br><\\/span><br><\\/p>\",\"en_US\":\"<p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationallyWe are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationallyWe are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<br><\\/p>\"}','296',42,38,33,2,1,1,1,NULL,10,10,0,1,1,'2022-12-26 06:35:15','2023-01-04 15:27:55',NULL),
        (13,'{\"en_US\":\"Ladies Shoe\",\"ar\":\"\\\u0644\\\u0644\\\u0646\\\u0638\\\u0627\\\u0645 \\\u060c \\\u0648\\\u0623\\\u0634\\\u0631\\\u062d \\\u0627\\\u0644\\\u062a\\\u0639\\\u0627\"}','ladies-shoe','{\"en_US\":\"Give lady of they such they sure it. Me contained explained my education. Vulgar as hearts by garret. Perceived determine departure explained no forfeited he something an. Contrasted dissimilar get joy you instrument out reasonably. Again keeps at no meant stuff. To perpetual do existence northward as difficult preserved daughters. Continued at up to zealously necessary breakfast. Surrounded sir motionless she end literature. Gay direction neglected but supported yet her.\",\"ar\":\"\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\"}','{\"en_US\":\"<p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span><br><\\/p>\"}','292',42,38,33,1,1,1,1,NULL,10,10,0,1,1,'2022-12-26 06:38:17','2023-01-04 15:27:11',NULL),
        (17,'{\"en\":\"Ladies Shoe\",\"en_US\":\"Jeans blue\",\"ar\":\"\\\u0648\\\u0623\\\u0634\\\u0631\\\u062d \\\u0627\\\u0644\\\u062a\\\u0639\\\u0627\\\u0644\\\u064a\\\u0645 \\\u0627\\\u0644\\\u0641\\\u0639\\\u0644\\\u064a\\\u0629\"}','jeans-blue','{\"en\":\"Give lady of they such they sure it. Me contained explained my education. Vulgar as hearts by garret. Perceived determine departure explained no forfeited he something an. Contrasted dissimilar get joy you instrument out reasonably. Again keeps at no meant stuff. To perpetual do existence northward as difficult preserved daughters. Continued at up to zealously necessary breakfast. Surrounded sir motionless she end literature. Gay direction neglected but supported yet her.\",\"en_US\":\"Give lady of they such they sure it. Me contained explained my education. Vulgar as hearts by garret. Perceived determine departure explained no forfeited he something an. Contrasted dissimilar get joy you instrument out reasonably. Again keeps at no meant stuff. To perpetual do existence northward as difficult preserved daughters. Continued at up to zealously necessary breakfast. Surrounded sir motionless she end literature. Gay direction neglected but supported yet her.\",\"ar\":\"\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\"}','{\"en\":\"<p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"en_US\":\"<p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"ar\":\"<p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\" open=\\\"\\\" sans\\\",=\\\"\\\" sans-serif;=\\\"\\\" hyphens:=\\\"\\\" auto;=\\\"\\\" line-height:=\\\"\\\" 1.6;=\\\"\\\" font-size:=\\\"\\\" 16px;\\\"=\\\"\\\"><font color=\\\"#919191\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/font><span style=\\\"background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; text-align: var(--bs-body-text-align);\\\"><font color=\\\"#919191\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/font><\\/span><span style=\\\"background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; text-align: var(--bs-body-text-align);\\\"><font color=\\\"#919191\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/font><\\/span><\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\" open=\\\"\\\" sans\\\",=\\\"\\\" sans-serif;=\\\"\\\" hyphens:=\\\"\\\" auto;=\\\"\\\" line-height:=\\\"\\\" 1.6;=\\\"\\\" font-size:=\\\"\\\" 16px;\\\"=\\\"\\\"><span style=\\\"background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ; text-align: var(--bs-body-text-align);\\\"><font color=\\\"#919191\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<br><\\/font><\\/span><br><\\/p>\"}','291',42,38,33,1,1,1,1,NULL,10,10,0,1,1,'2023-01-04 15:23:15','2023-01-04 15:42:42',NULL)");
    }

    private static function seedProductCategory()
    {
        DB::statement("INSERT INTO `product_categories` (`id`, `product_id`, `category_id`)
        VALUES
            (1,1,3),
            (5,7,6),
            (6,8,5),
            (7,9,8),
            (8,10,5),
            (9,11,5),
            (10,12,5),
            (11,13,5),
            (15,17,5)");
    }


    private static function seedProductSubCategories()
    {
        DB::statement("INSERT INTO `product_sub_categories` (`id`, `product_id`, `sub_category_id`)
        VALUES
            (1,1,1),
            (5,7,4),
            (6,8,6),
            (7,9,9),
            (8,10,6),
            (9,11,6),
            (10,12,6),
            (11,13,6),
            (15,17,6)");
    }

    private static function seedProductChildCategories()
    {
        DB::statement("INSERT INTO `product_child_categories` (`id`, `product_id`, `child_category_id`)
        VALUES
            (68,1,2),
            (76,13,3),
            (77,12,3),
            (78,11,3),
            (79,10,3),
            (81,7,4),
            (82,9,5),
            (83,8,3),
            (84,17,3)");
    }


    private static function seedProductTags()
    {
        DB::statement("INSERT INTO `product_tags` (`id`, `tag_name`, `product_id`)
        VALUES
            (115,'shirt',1),
            (116,'tshirt',1),
            (131,'shirt',13),
            (132,'tshirt',13),
            (133,'shirt',12),
            (134,'tshirt',12),
            (135,'shirt',11),
            (136,'tshirt',11),
            (137,'shirt',10),
            (138,'tshirt',10),
            (141,'shirt',7),
            (142,'tshirt',7),
            (143,'shirt',9),
            (144,'tshirt',9),
            (145,'shirt',8),
            (146,'tshirt',8),
            (147,'shirt',17),
            (148,'tshirt',17)");
    }

    private static function seedProductGalleries()
    {
        DB::statement("INSERT INTO `product_galleries` (`id`, `product_id`, `image_id`)
        VALUES
            (114,1,282),
            (115,1,280),
            (116,1,279),
            (133,13,294),
            (134,13,293),
            (135,12,298),
            (136,12,297),
            (137,12,295),
            (138,11,302),
            (139,11,301),
            (140,11,300),
            (141,10,305),
            (142,10,304),
            (143,10,303),
            (147,7,286),
            (148,7,285),
            (149,7,284),
            (150,9,309),
            (151,9,307),
            (152,9,306),
            (153,8,267),
            (154,8,255),
            (155,17,290),
            (156,17,289),
            (157,17,288)");
    }

    private static function seedProductInventories()
    {
        DB::statement("INSERT INTO `product_inventories` (`id`, `product_id`, `sku`, `stock_count`, `sold_count`)
        VALUES
            (1,1,'shirt-9999',98,2),
            (5,7,'dress-9999-1-1',96,4),
            (6,8,'dress-9999-1-1-1',160,3),
            (7,9,'headphone',89,11),
            (8,10,'bag-20',88,12),
            (9,11,'indian-loger',153,7),
            (10,12,'indian-loger-1',159,1),
            (11,13,'indian-loger-1-1',115,5),
            (15,17,'indian-loger-1-1-1-1-1-1',115,NULL)");
    }


    private static function seedProductInventoryDetails()
    {
        DB::statement("INSERT INTO `product_inventory_details` (`id`, `product_inventory_id`, `product_id`, `color`, `size`, `hash`, `additional_price`, `add_cost`, `image`, `stock_count`, `sold_count`)
        VALUES
            (13,6,8,'1','3','',5.00,3.00,NULL,80,0),
            (14,6,8,'3','4','',10.00,5.00,NULL,80,0)");
    }


    private static function seedProductUOM()
    {
        DB::statement("INSERT INTO `product_uom` (`id`, `product_id`, `unit_id`, `quantity`)
        VALUES
            (1,1,6,2.00),
            (3,7,6,2.00),
            (4,8,6,2.00),
            (5,9,2,1.00),
            (6,10,2,1.00),
            (7,11,6,2.00),
            (8,12,6,2.00),
            (9,13,6,2.00),
            (13,17,6,2.00)");
    }

    private static function seedProductCreatedBy()
    {
        DB::statement("INSERT INTO `product_created_by` (`id`, `product_id`, `created_by_id`, `guard_name`, `updated_by`, `updated_by_guard`, `deleted_by`, `deleted_by_guard`)
        VALUES
            (1,1,1,'admin',1,'admin',NULL,NULL),
            (7,7,1,'admin',1,'admin',NULL,NULL),
            (8,8,1,'admin',1,'admin',NULL,NULL),
            (9,9,1,'admin',1,'admin',NULL,NULL),
            (10,10,1,'admin',1,'admin',NULL,NULL),
            (11,11,1,'admin',1,'admin',NULL,NULL),
            (12,12,1,'admin',1,'admin',NULL,NULL),
            (13,13,1,'admin',1,'admin',NULL,NULL),
            (17,17,1,'admin',1,'admin',NULL,NULL)");
    }

    private static function seedProductDeliveryOption()
    {
        DB::statement("INSERT INTO `product_delivery_options` (`id`, `product_id`, `delivery_option_id`)
        VALUES
            (105,1,1),
            (119,13,1),
            (120,13,2),
            (121,12,1),
            (122,12,2),
            (123,11,1),
            (124,11,2),
            (125,10,1),
            (127,7,1),
            (128,9,1),
            (129,8,1),
            (130,8,2),
            (131,17,1),
            (132,17,2)");
    }


    private static function seedProductReturnPolicies()
    {
        DB::statement("INSERT INTO `product_shipping_return_policies` (`id`, `product_id`, `shipping_return_description`, `created_at`, `updated_at`)
        VALUES
            (1,1,'{\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<br><\\/p>\",\"en_US\":\"<p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<br><\\/p>\"}','2022-12-19 08:50:30','2023-01-03 19:56:14'),
            (3,7,'{\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<br><\\/p>\",\"en_US\":\"<p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<br><\\/p>\"}','2022-12-19 09:29:26','2023-01-03 19:59:10'),
            (4,8,'{\"en_US\":\"<p><span style=\\\"color: rgb(145, 145, 145); font-family: \\\"Open Sans\\\", sans-serif; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/span><br><\\/p>\",\"ar\":\"<p>&nbsp;\\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<br><\\/p>\"}','2022-12-19 09:32:26','2023-01-04 15:34:52'),
            (5,9,'{\"ar\":\"<p>&nbsp;\\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<br><\\/p>\",\"en_US\":\"<p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<br><\\/p>\"}','2022-12-19 09:33:53','2023-01-03 19:58:32'),
            (6,10,'{\"ar\":\"<p>&nbsp;\\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<br><\\/p>\",\"en_US\":\"<p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<br><\\/p>\"}','2022-12-19 09:35:50','2023-01-03 19:58:08'),
            (7,11,'{\"ar\":\"<p>\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<br><\\/p>\",\"en_US\":\"<p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<br><\\/p>\"}','2022-12-26 06:33:45','2023-01-03 19:57:21'),
            (8,12,'{\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<span style=\\\"font-weight: initial; text-align: var(--bs-body-text-align); background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) ;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<\\/span><br><\\/p>\",\"en_US\":\"<p>We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<br><\\/p>\"}','2022-12-26 06:35:15','2023-01-03 19:56:56'),
            (9,13,'{\"en_US\":\"<p>Give lady of they such they sure it. Me contained explained my education. Vulgar as hearts by garret. Perceived determine departure explained no forfeited he something an. Contrasted dissimilar get joy you instrument out reasonably. Again keeps at no meant stuff. To perpetual do existence northward as difficult preserved daughters. Continued at up to zealously necessary breakfast. Surrounded sir motionless she end literature. Gay direction neglected but supported yet her.<br><\\/p>\",\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<br><\\/p>\"}','2022-12-26 06:38:17','2023-01-03 19:42:53'),
            (12,17,'{\"ar\":\"<p>&nbsp;\\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629.<br><\\/p>\"}','2023-01-04 15:23:15','2023-01-04 15:42:42')");
    }

    private static function seedCampaign()
    {
        DB::statement("INSERT INTO `campaigns` (`id`, `title`, `subtitle`, `image`, `start_date`, `end_date`, `status`, `created_at`, `updated_at`, `admin_id`, `vendor_id`, `type`)
        VALUES
            (1,'{\"en_US\":\"Valantines Special\",\"ar\":\"\\\u0639\\\u064a\\\u062f \\\u0627\\\u0644\\\u062d\\\u0628 \\\u062e\\\u0627\\\u0635\"}','{\"en_US\":\"For couples\",\"ar\":\"\\\u0644\\\u0644\\\u0623\\\u0632\\\u0648\\\u0627\\\u062c\"}',241,'2022-12-19 00:00:00','2022-12-31 00:00:00','publish','2022-12-19 09:48:12','2023-01-03 17:01:40',1,NULL,'admin')");
    }

    private static function seedCampaignProducts()
    {
        DB::statement("INSERT INTO `campaign_products` (`id`, `product_id`, `campaign_id`, `campaign_price`, `units_for_sale`, `start_date`, `end_date`, `created_at`, `updated_at`)
        VALUES
            (19,7,1,40.00,30,'2022-12-19 00:00:00','2022-12-31 00:00:00',NULL,NULL),
            (20,8,1,25.00,30,'2022-12-19 00:00:00','2022-12-31 00:00:00',NULL,NULL),
            (21,9,1,120.00,30,'2022-12-19 00:00:00','2022-12-31 00:00:00',NULL,NULL),
            (22,10,1,130.00,30,'2022-12-19 00:00:00','2022-12-31 00:00:00',NULL,NULL)");
    }



}
