<?php

namespace Database\Seeders\Tenant\ModuleData\Portfolio;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class PortfolioSeed
{
    public static function execute()
    {

        if (!Schema::hasTable('portfolios')) {
            Schema::create('portfolios', function (Blueprint $table) {
                $table->id();
                $table->bigInteger('category_id');
                $table->string('title');
                $table->text('url');
                $table->longText('description');
                $table->text('slug');
                $table->string('image');
                $table->string('image_gallery')->nullable();
                $table->string('client')->nullable();
                $table->string('design')->nullable();
                $table->string('typography')->nullable();
                $table->text('tags')->nullable();
                $table->text('file')->nullable();
                $table->text('download')->nullable();
                $table->boolean('status')->default(1);
                $table->timestamps();
            });
        }


        $package = tenant()->user()->first()?->payment_log()->first()?->package()->first() ?? [];
        $all_features = $package->plan_features ?? [];

        $payment_log = tenant()->user()->first()?->payment_log()?->first() ?? [];
        if(empty($all_features) && $payment_log->status != 'trial'){
            return;
        }

        $check_feature_name = $all_features->pluck('feature_name')->toArray();

        if (in_array('portfolio', $check_feature_name)) {


            DB::statement("INSERT INTO `portfolios` (`id`, `category_id`, `title`, `url`, `description`, `slug`, `image`, `image_gallery`, `client`, `design`, `typography`, `tags`, `file`, `download`, `status`, `created_at`, `updated_at`)
VALUES
	(1,6,'{\"en_US\":\"Testing profile three\",\"ar\":\"\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645\"}','#','{\"en_US\":\"<div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); outline: none; -webkit-font-smoothing: antialiased; color: var(--heading-color);\\\">Project Idea<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"margin-bottom: 0px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); outline: none; -webkit-font-smoothing: antialiased; color: var(--heading-color);\\\">Project Goals<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"margin-bottom: 0px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); outline: none; -webkit-font-smoothing: antialiased; color: var(--heading-color);\\\">Problem<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"margin-bottom: 0px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); outline: none; -webkit-font-smoothing: antialiased; color: var(--heading-color);\\\">Project Details<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"margin-bottom: 0px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div>\",\"ar\":\"<p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\">&nbsp;\\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u0641\\u064a \\u063a\\u0627\\u0628 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643. \\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u062f\\u0647\\u0648\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a\\u0629 \\u0644\\u0644\\u0632\\u0648\\u062c. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u0641\\u064a \\u063a\\u0627\\u0628 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643. \\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u0632\\u0648\\u062c \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a \\u0644\\u0644\\u062f\\u0647\\u0648\\u0646. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u063a\\u0627\\u0628 \\u0639\\u0646 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643.<\\/p>\"}','ut-ea-quaerat-aute-e','89','83|90|80','{\"en_US\":\"Cupiditate totam rep\",\"ar\":\"\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645\"}','{\"en_US\":\"Vel minima voluptate\",\"ar\":\"\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645\"}','{\"en_US\":\"Cupiditate quam sed\",\"ar\":\"\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645\"}','Itaque dolore sunt q','Archive1662553687.zip','0',1,'2022-09-07 12:28:07','2022-11-12 13:12:01'),
	(2,4,'{\"en_US\":\"Digital Agency Website\",\"ar\":\"\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631\"}','https://www.youtube.com/watch?v=EKB-dwwyQ3U','{\"en_US\":\"<div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Idea<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Goals<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Problem<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Details<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div>\",\"ar\":\"<p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">&nbsp;\\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u0641\\u064a \\u063a\\u0627\\u0628 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643. \\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u062f\\u0647\\u0648\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a\\u0629 \\u0644\\u0644\\u0632\\u0648\\u062c. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u0641\\u064a \\u063a\\u0627\\u0628 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643. \\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u0632\\u0648\\u062c \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a \\u0644\\u0644\\u062f\\u0647\\u0648\\u0646. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u063a\\u0627\\u0628 \\u0639\\u0646 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643.<\\/p>\"}','digital-agency-website','87','88|87','{\"en_US\":\"Kevin petersen\",\"ar\":\"\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631\"}','{\"en_US\":\"test\",\"ar\":\"\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631\"}','{\"en_US\":\"test\",\"ar\":\"\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631\"}','blog,new,affiliation','Archive1662554396.zip','0',1,'2022-09-07 12:39:56','2022-11-12 13:11:41'),
	(14,4,'{\"en\":\"Digital Agency Website\",\"en_US\":\"New system color\",\"ar\":\"\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631\"}','#','{\"en_US\":\"<div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Idea<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Goals<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Problem<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Details<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div>\",\"ar\":\"<p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\">\\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u062f\\u0647\\u0648\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a\\u0629 \\u0644\\u0644\\u0632\\u0648\\u062c. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u0641\\u064a \\u063a\\u0627\\u0628 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643. \\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u062f\\u0647\\u0648\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a\\u0629 \\u0644\\u0644\\u0632\\u0648\\u062c. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u0641\\u064a \\u063a\\u0627\\u0628 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643. \\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u0632\\u0648\\u062c \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a \\u0644\\u0644\\u062f\\u0647\\u0648\\u0646. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u063a\\u0627\\u0628 \\u0639\\u0646 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"margin-bottom: 0px; font-size: 16px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a&nbsp;<\\/p>\"}','new-system-color','88','88|87','{\"en\":\"Kevin petersen\",\"en_US\":\"Kevin petersen\",\"ar\":\"\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631\"}','{\"en\":\"test\",\"en_US\":\"test\",\"ar\":\"\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631\"}','{\"en\":\"test\",\"en_US\":\"test\",\"ar\":\"\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631\"}','blog,new,affiliation',NULL,NULL,1,'2022-10-02 12:02:55','2022-11-12 13:11:01'),
	(15,4,'{\"en\":\"New system color\",\"en_US\":\"System analitics tool am\",\"ar\":\"\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u0641\\u064a\"}','#','{\"en_US\":\"<div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Idea<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Goals<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Problem<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Details<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div>\",\"ar\":\"<p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">\\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u062f\\u0647\\u0648\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a\\u0629 \\u0644\\u0644\\u0632\\u0648\\u062c. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u0641\\u064a \\u063a\\u0627\\u0628 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643. \\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u062f\\u0647\\u0648\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a\\u0629 \\u0644\\u0644\\u0632\\u0648\\u062c. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u0641\\u064a \\u063a\\u0627\\u0628 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643. \\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u0632\\u0648\\u062c \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a \\u0644\\u0644\\u062f\\u0647\\u0648\\u0646. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u063a\\u0627\\u0628 \\u0639\\u0646 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a&nbsp;<\\/p>\"}','system-analitics-tool-am','89','88|87','{\"en\":\"Kevin petersen\",\"en_US\":\"Kevin petersen\",\"ar\":\"\\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\"}','{\"en\":\"test\",\"en_US\":\"test\",\"ar\":\"\\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\"}','{\"en\":\"test\",\"en_US\":\"test\",\"ar\":\"\\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\"}','blog,new,affiliation',NULL,NULL,1,'2022-10-03 05:11:21','2022-11-12 13:10:30'),
	(16,1,'{\"en\":\"System analitics tool am\",\"en_US\":\"Test\",\"ar\":\"\\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649.\"}','#','{\"en_US\":\"<div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Idea<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Goals<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Problem<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div><div class=\\\"singleCap mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"small-tittle mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><h3 class=\\\"tittle\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 5px; font-weight: 700; line-height: 1.4; font-size: 20px; font-family: var(--heading-font); color: var(--heading-color);\\\">Project Details<\\/h3><\\/div><p class=\\\"pear\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Sed At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.<\\/p><\\/div>\",\"ar\":\"<p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">&nbsp;\\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u0641\\u064a \\u063a\\u0627\\u0628 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643. \\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u062f\\u0647\\u0648\\u0646 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a\\u0629 \\u0644\\u0644\\u0632\\u0648\\u062c. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u0641\\u064a \\u063a\\u0627\\u0628 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643. \\u0643\\u0627\\u0646 \\u064a\\u0631\\u0633\\u0645 \\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u0627\\u0644\\u0632\\u0648\\u062c \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a \\u0644\\u0644\\u062f\\u0647\\u0648\\u0646. \\u0645\\u0643\\u0627\\u0646 \\u0623\\u062d\\u0645\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0648\\u062f \\u0635\\u0627\\u062e\\u0628\\u0629 \\u0643\\u0645\\u0627 \\u0639\\u0631\\u0636. \\u0647\\u0624\\u0644\\u0627\\u0621 \\u062d\\u0627\\u0648\\u0644\\u0648\\u0627 \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0643\\u062a\\u0628 \\u0628\\u0627\\u0631\\u0639. \\u0641\\u064a \\u0627\\u0644\\u0633\\u064a\\u062f \\u0628\\u062f\\u0623\\u062a \\u0627\\u0644\\u0645\\u0648\\u0633\\u064a\\u0642\\u0649 \\u0628\\u0639\\u062f \\u0623\\u0633\\u0627\\u0628\\u064a\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629. \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0627 \\u062d\\u0632\\u0646 \\u062d\\u062a\\u0649 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0627\\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0647. \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u064a\\u0633\\u0627\\u0641\\u0631 \\u0644\\u0647\\u0627 \\u0623\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0645\\u0634\\u0628\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u062d\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629. \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0635\\u0628\\u0627\\u062d \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u062f\\u0627\\u0626\\u0645\\u0627 \\u062b\\u0631\\u0648\\u0629 \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0646. \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0623\\u0631\\u0648\\u0627\\u062d \\u0627\\u0644\\u0645\\u0642\\u0627\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0644\\u0647\\u0627 \\u063a\\u0637\\u062a \\u0639\\u0644\\u0649 \\u0639\\u062c\\u0644 \\u062c\\u0644\\u0648\\u0633\\u0647\\u0627. \\u0643\\u062a\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0631\\u0639 \\u0648\\u0644\\u0627 \\u0627\\u0628\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u0629. \\u0643\\u0627\\u0646 \\u0639\\u0645\\u0631 \\u0627\\u0644\\u062f\\u062c\\u0627\\u062c \\u064a\\u0624\\u0645\\u0646 \\u0628\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621 \\u0648\\u0644\\u0643\\u0646 \\u064a\\u062a\\u0638\\u0627\\u0647\\u0631 \\u0628\\u0627\\u0644\\u0633\\u064a\\u062f\\u0629. \\u063a\\u0627\\u0628 \\u0639\\u0646 \\u0627\\u0644\\u0646\\u0635\\u064a\\u062d\\u0629 \\u064a\\u0627 \\u0623\\u062e\\u062a\\u064a. \\u0623\\u062e\\u0628\\u0631\\u062a \\u0627\\u0644\\u0622\\u0646\\u0633\\u0629 \\u0644\\u062d\\u0645 \\u0627\\u0644\\u062e\\u0646\\u0632\\u064a\\u0631 \\u0623\\u0646 \\u0645\\u0645\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0641 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u0631\\u0649 \\u0623\\u0646\\u0647\\u0627 \\u0642\\u0631\\u064a\\u0628\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0644\\u0628\\u0629.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\"><br style=\\\"outline: none; -webkit-font-smoothing: antialiased;\\\"><\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px; text-align: justify;\\\">\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 middletons \\u0644\\u064a \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0631\\u0627 \\u0635\\u0627\\u062e\\u0628\\u0627 \\u0627\\u0644\\u0633\\u0641\\u0631. \\u0627\\u0646\\u0647\\u0627 \\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u062a\\u062a\\u0648\\u0633\\u0644 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0631\\u0641\\u0627\\u0642 \\u0644\\u0643\\u0645 \\u0635\\u0627\\u062e\\u0628\\u0629. \\u064a\\u0633\\u0623\\u0644 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0645\\u064a\\u062f\\u0644\\u062a\\u0648\\u0646 \\u0633\\u064a\\u062f\\u064a \\u0627\\u0644\\u0622\\u0646 \\u0628\\u062d\\u0631\\u0627\\u0631\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0627\\u062a. \\u0643\\u0646\\u062a\\u0645 \\u0639\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u0646 \\u0644\\u0622\\u062e\\u0631 \\u0631\\u0623\\u0648\\u0627 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0627 \\u0639\\u062f\\u0627 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0646\\u0627\\u0639. \\u0639\\u0627\\u062f\\u062a \\u0627\\u0628\\u0646\\u0629 \\u0642\\u0644\\u064a\\u0644\\u0629 \\u062a\\u0631\\u0643\\u062a \\u0645\\u062a\\u0641\\u0631\\u0639\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0645\\u062a\\u0642\\u062f\\u0645\\u064b\\u0627. \\u0647\\u0644 \\u0627\\u0644\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0647 \\u0645\\u0639\\u064a\\u0628 \\u0623\\u0648 \\u0627\\u0639\\u062a\\u0631\\u0627\\u0636\\u0646\\u0627 \\u0625\\u0630\\u0627 \\u0641\\u0636\\u0644\\u0646\\u0627. \\u0641\\u064a \\u0639\\u062c\\u0628 \\u062a\\u062d\\u0645\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u0637\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0631\\u0624\\u064a\\u062a\\u0647 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0642\\u0648\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0633\\u062d\\u0631 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649. \\u062d\\u0636\\u0631 \\u0623\\u064a \\u0632\\u0648\\u0627\\u062c \\u0645\\u0646\\u063a\\u0645\\u0633 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0643\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0627\\u0644\\u0643.<\\/p><div class=\\\"row justify-content-between mb-20 mt-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; --bs-gutter-x:1.5rem; --bs-gutter-y:0; margin-top: 20px; margin-right: calc(var(--bs-gutter-x) * -0.5); margin-left: calc(var(--bs-gutter-x) * -0.5); margin-bottom: 20px; color: rgb(154, 156, 159); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><div class=\\\"col-lg-6 col-md-6\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; width: 440px; padding-right: calc(var(--bs-gutter-x) * 0.5); padding-left: calc(var(--bs-gutter-x) * 0.5); margin-top: var(--bs-gutter-y);\\\"><div class=\\\"tagArea mb-20\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 20px;\\\"><\\/div><\\/div><\\/div>\"}','test','80','88|87','{\"en\":\"Kevin petersen\",\"en_US\":\"Kevin petersen\",\"ar\":\"\\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649.\"}','{\"en\":\"test\",\"en_US\":\"test\",\"ar\":\"\\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649.\"}','{\"en\":\"test\",\"en_US\":\"test\",\"ar\":\"\\u0632\\u064a\\u0627\\u0631\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0633\\u0645\\u0639\\u062a \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u062e\\u0631\\u0649.\"}','blog,new,affiliation',NULL,NULL,1,'2022-10-03 05:14:48','2022-11-12 13:09:38')");
        }
    }

}
