<?php

namespace Database\Seeders\Tenant\ModuleData\Knowledgebase;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class KnowledgebaseSeed
{
   public static function execute()
   {

       if (!Schema::hasTable('knowledgebases')) {

           Schema::create('knowledgebases', function (Blueprint $table) {
               $table->id();
               $table->unsignedBigInteger('category_id');
               $table->text('title');
               $table->text('slug');
               $table->longText('description');
               $table->string('image');
               $table->bigInteger('views')->default(0);
               $table->boolean('status')->default(1);
               $table->timestamps();

           });

       }


       $package = tenant()->user()->first()?->payment_log()->first()?->package()->first() ?? [];
       $all_features = $package->plan_features ?? [];

       $payment_log = tenant()->user()->first()?->payment_log()?->first() ?? [];
       if(empty($all_features) && $payment_log->status != 'trial'){
           return;
       }

       $check_feature_name = $all_features->pluck('feature_name')->toArray();

       if (in_array('knowledgebase', $check_feature_name)) {

           DB::statement("INSERT INTO `knowledgebases` (`id`, `category_id`, `title`, `slug`, `description`, `image`, `views`, `status`, `created_at`, `updated_at`)
VALUES
	(2,1,'{\"en_US\":\"What My Popcorn Maker Taught Me About Demand in Business\",\"ar\":\"\\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\"}','what-my-popcorn-maker-taught-me-about-demand-in-business','{\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p>\"}','214',0,1,'2022-11-07 10:37:00','2022-11-12 11:42:05'),
	(6,1,'{\"en\":\"What My Popcorn Maker Taught Me About Demand in Business\",\"en_US\":\"I wanted to know how this company landed and one of the best\",\"ar\":\"\\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643\"}','i-wanted-to-know-how-this-company-landed-and-one-of-the-best','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',1,1,'2022-11-07 11:15:51','2022-11-12 11:39:56'),
	(7,3,'{\"en\":\"What My Popcorn Maker Taught Me About Demand in Business\",\"en_US\":\"Having tried for years to get on these lists with my products\",\"ar\":\"\\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635\"}','having-tried-for-years-to-get-on-these-lists-with-my-products','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',2,1,'2022-11-07 11:15:53','2022-11-12 11:39:39'),
	(8,7,'{\"en\":\"Having tried for years to get on these lists with my products\",\"en_US\":\"December issue of O, The Oprah Magazine is out\",\"ar\":\"\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\"}','december-issue-of-o-the-oprah-magazine-is-out','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',0,1,'2022-11-07 11:30:41','2022-11-12 11:39:15'),
	(9,3,'{\"en\":\"Having tried for years to get on these lists with my products\",\"en_US\":\"Things annual list is said to be a must-have holiday shopping guide\",\"ar\":\"\\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629\"}','things-annual-list-is-said-to-be-a-must-have-holiday-shopping-guide','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',5,1,'2022-11-07 11:30:44','2022-11-12 11:38:47'),
	(10,3,'{\"en\":\"Things annual list is said to be a must-have holiday shopping guide\",\"en_US\":\"Annual list is said to be a must-have holiday shopping guide\",\"ar\":\"\\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629\"}','gs-annual-list-is-said-to-be-a-must-have-holiday-shopping-guide','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',0,1,'2022-11-07 11:33:09','2022-11-12 11:38:27'),
	(11,6,'{\"en\":\"Things annual list is said to be a must-have holiday shopping guide\",\"en_US\":\"The annual list of \'Oprah\'s Favorite Things\', a holiday gift list\",\"ar\":\"\\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\"}','the-annual-list-of-oprahs-favorite-things-a-holiday-gift-list','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',1,1,'2022-11-07 11:33:15','2022-11-12 11:37:40'),
	(12,6,'{\"en\":\"The annual list of \'Oprah\'s Favorite Things\', a holiday gift list\",\"en_US\":\"Having tried for years to get on these lists with my products\",\"ar\":\"\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627\"}','having-tried-for-years-to-get-on-these-lists-with-my-products','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',0,1,'2022-11-07 11:40:39','2022-11-12 11:37:18'),
	(13,6,'{\"en\":\"Monet annual list of &amp;#039;Oprah&amp;#039;s Favorite Things&amp;#039;, a holiday gift list\",\"en_US\":\"Popinsanity encourages you to spend more in the beginning\",\"ar\":\"\\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 &quot;\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\"}','popinsanity-encourages-you-to-spend-more-in-the-beginning','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',0,1,'2022-11-08 06:13:58','2022-11-12 11:36:48'),
	(14,1,'{\"en\":\"I wanted to know how this company landed and one of the best\",\"en_US\":\"New wanted to know how this company landed and one of the best\",\"ar\":\"\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\"}','new-wanted-to-know-how-this-company-landed-and-one-of-the-best','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',0,1,'2022-11-08 06:16:50','2022-11-12 11:36:31'),
	(15,2,'{\"en\":\"New wanted to know how this company landed and one of the best\",\"en_US\":\"Finally wanted to know how this company landed and one of the best\",\"ar\":\"\\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647\"}','finally-wanted-to-know-how-this-company-landed-and-one-of-the-best','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 Popinsanity \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',8,1,'2022-11-08 06:30:14','2022-11-12 11:36:05'),
	(16,2,'{\"en\":\"Finally wanted to know how this company landed and one of the best\",\"en_US\":\"Charecter wanted to know how this company landed and one of the best\",\"ar\":\"\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\"}','charecter-wanted-to-know-how-this-company-landed-and-one-of-the-best','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 Popinsanity \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',3,1,'2022-11-08 06:30:37','2022-11-12 11:42:54'),
	(17,2,'{\"en\":\"Finally wanted to know how this company landed and one of the best\",\"en_US\":\"Kana wanted to know how this company landed and one of the best\",\"ar\":\"\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627\"}','kana-wanted-to-know-how-this-company-landed-and-one-of-the-best','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><span style=\\\"color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif; font-size: 0.9375rem; font-weight: initial; text-align: var(--bs-body-text-align);\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 Popinsanity \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/span><\\/p><\\/div>\"}','214',9,1,'2022-11-08 06:32:02','2022-11-12 11:35:15'),
	(18,4,'{\"en\":\"Monet annual list of ;#039;Oprah&amp;amp;amp;#039;s Favorite Things&amp;amp;amp;#039;, a holiday gift list\",\"en_US\":\"I wanted to know how this company landed\",\"ar\":\"\\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\"}','i-wanted-to-know-how-this-company-landed','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 Popinsanity \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/font><\\/p><\\/div>\"}','214',0,1,'2022-11-08 06:32:45','2022-11-12 11:34:41'),
	(19,4,'{\"en\":\"I wanted to know how this company landed\",\"en_US\":\"They  wanted to know how this company landed\",\"ar\":\"\\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644\"}','they-wanted-to-know-how-this-company-landed','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 Popinsanity \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/font><\\/p><\\/div>\"}','214',0,1,'2022-11-08 06:33:33','2022-11-12 11:34:15'),
	(20,4,'{\"en\":\"They  wanted to know how this company landed\",\"en_US\":\"What any other business can potentially learn from this\",\"ar\":\"\\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a\"}','what-any-other-business-can-potentially-learn-from-this','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 Popinsanity \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/font><\\/p><\\/div>\"}','214',0,1,'2022-11-08 06:34:08','2022-11-12 11:33:54'),
	(21,5,'{\"en\":\"What any other business can potentially learn from this\",\"en_US\":\"Many to any other business can potentially learn from this\",\"ar\":\"\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.\"}','many-to-any-other-business-can-potentially-learn-from-this','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 Popinsanity \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/font><\\/p><\\/div>\"}','214',13,1,'2022-11-08 06:36:35','2022-11-12 11:33:07'),
	(22,5,'{\"en\":\"Many to any other business can potentially learn from this\",\"en_US\":\"Common to any other business can potentially learn from this\",\"ar\":\"\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639\"}','common-to-any-other-business-can-potentially-learn-from-this','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; color: rgb(0, 0, 0); font-family: sans-serif; outline: none; -webkit-font-smoothing: antialiased; hyphens: auto;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 Popinsanity \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/font><\\/p><\\/div>\"}','214',9,1,'2022-11-08 06:37:11','2022-11-12 11:32:43'),
	(23,5,'{\"en\":\"Common to any other business can potentially learn from this\",\"en_US\":\"Flirting to any other business can potentially learn from this\",\"ar\":\"\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a\"}','flirting-to-any-other-business-can-potentially-learn-from-this','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Having tried for years to get on these lists with my products I wanted to know how this company landed and one of the best if not the best. I wanted to know how it landed as the only one in its category of \'gourmet dessert\', and what any other business can potentially learn from this company\'s journey.<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The annual list of \'Oprah\'s Favorite Things\', a holiday gift list featured every year in the December issue of O, The Oprah Magazine is out. The Oprah\'s Favorite Things annual list is said to be a must-have holiday shopping guide where you can find the most decadent desserts, ingenious gadgets, and finest in home, fashion, beauty, and popcorn. Artisanal popcorn to be exact.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: &quot;Open Sans&quot;, sans-serif;\\\"><h5 class=\\\"title title2\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-size: 22px; font-family: var(--heading-font); color: var(--heading-color); text-decoration-line: underline;\\\">I spoke with the partners to learn a little about how they did it.<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Trust the customer\'s experience: at first, other than the founders\' spouses, everyone told them the math didn\'t add up, that no matter how good it is, no one will ever pay $18-20 for a small bag of popcorn. But what Jacob and Aaron discovered was, that if you give someone your product or service in a way that\'s upscale and of high quality, as a trial, - then no matter the price point, they\'ll want it. (the challenge is getting it into their hands). Popinsanity encourages you to spend more in the beginning on \'tastings\', or free trials, rather than on advertising and promotions.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Finding your business partners: Aaron attests to the fact he\'s a phenomenal salesman. Give him 3 minutes in a room with anyone - and you got a sale. But even if his life depended on it, he couldn\'t fathom the ins and outs of the supply chain and manufacturing. \\\"In our case, we had humidity issues, weather challenges, logistics, chocolate melting, so many parts have to come together\\\" - he tells me. What he learned is the value of partnering and entrusting certain business tasks to the experts in those fields.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: decimal; margin-left: 15px; margin-bottom: 26px;\\\">Who are you: Competition is fierce in almost every space. But the way you position yourself and your brand can make all the difference. In the case of Popinsanity, they acknowledge there are plenty of snack and popcorn companies. Yet none of them treat popcorn as gourmet dessert. The moment they redefined their product as a gourmet dessert, it no longer stood in the space of snack, or even chocolate. It now played in a different category altogether.<\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; hyphens: auto; line-height: 1.6;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0628\\u0639\\u062f \\u0623\\u0646 \\u062d\\u0627\\u0648\\u0644\\u062a \\u0644\\u0633\\u0646\\u0648\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0626\\u0645 \\u0645\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u064a \\u060c \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0648\\u0648\\u0627\\u062d\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0625\\u0646 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644. \\u0623\\u0631\\u062f\\u062a \\u0623\\u0646 \\u0623\\u0639\\u0631\\u0641 \\u0643\\u064a\\u0641 \\u0647\\u0628\\u0637\\u062a \\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0648\\u062d\\u064a\\u062f\\u0629 \\u0641\\u064a \\u0641\\u0626\\u062a\\u0647\\u0627 \\\"\\u062d\\u0644\\u0648\\u0649 \\u0627\\u0644\\u0630\\u0648\\u0627\\u0642\\u0629\\\" \\u060c \\u0648\\u0645\\u0627 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0623\\u064a \\u0639\\u0645\\u0644 \\u0622\\u062e\\u0631 \\u0623\\u0646 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0645\\u0646 \\u0631\\u062d\\u0644\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; hyphens: auto; line-height: 1.6;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; hyphens: auto; line-height: 1.6;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\\"\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629\\\" \\u060c \\u0648\\u0647\\u064a \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0623\\u0639\\u064a\\u0627\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0638\\u0647\\u0631 \\u0643\\u0644 \\u0639\\u0627\\u0645 \\u0641\\u064a \\u0639\\u062f\\u062f \\u062f\\u064a\\u0633\\u0645\\u0628\\u0631 \\u0645\\u0646 O \\u060c \\u0645\\u062c\\u0644\\u0629 \\u0623\\u0648\\u0628\\u0631\\u0627. \\u064a\\u064f\\u0642\\u0627\\u0644 \\u0625\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0646\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0634\\u064a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0641\\u064a \\u0623\\u0648\\u0628\\u0631\\u0627 \\u0647\\u064a \\u062f\\u0644\\u064a\\u0644 \\u062a\\u0633\\u0648\\u0642 \\u0644\\u0644\\u0639\\u0637\\u0644\\u0627\\u062a \\u0644\\u0627 \\u0628\\u062f \\u0645\\u0646\\u0647 \\u062d\\u064a\\u062b \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0644\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0631\\u0648\\u0639\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0630\\u0643\\u064a\\u0629 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0623\\u0632\\u064a\\u0627\\u0621 \\u060c \\u0648\\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u060c \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0627\\u0644\\u062d\\u0631\\u0641\\u064a \\u0639\\u0644\\u0649 \\u0648\\u062c\\u0647 \\u0627\\u0644\\u062f\\u0642\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; hyphens: auto; line-height: 1.6;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\"><br><\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; hyphens: auto; line-height: 1.6;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0644\\u0642\\u062f \\u062a\\u062d\\u062f\\u062b\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0644\\u0623\\u062a\\u0639\\u0644\\u0645 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0642\\u064a\\u0627\\u0645\\u0647\\u0645 \\u0628\\u0630\\u0644\\u0643.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; hyphens: auto; line-height: 1.6;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u062b\\u0642 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644: \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u060c \\u0628\\u062e\\u0644\\u0627\\u0641 \\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u064a\\u0646 \\u060c \\u0623\\u062e\\u0628\\u0631\\u0647\\u0645 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646 \\u0627\\u0644\\u0631\\u064a\\u0627\\u0636\\u064a\\u0627\\u062a \\u0644\\u0627 \\u062a\\u0636\\u064a\\u0641 \\u0634\\u064a\\u0626\\u064b\\u0627 \\u060c \\u0648\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0645\\u062f\\u0649 \\u062c\\u0648\\u062f\\u062a\\u0647\\u0627 \\u060c \\u0644\\u0646 \\u064a\\u062f\\u0641\\u0639 \\u0623\\u062d\\u062f \\u0623\\u0628\\u062f\\u064b\\u0627 18-20 \\u062f\\u0648\\u0644\\u0627\\u0631\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0643\\u064a\\u0633 \\u0635\\u063a\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0644\\u0643\\u0646 \\u0645\\u0627 \\u0627\\u0643\\u062a\\u0634\\u0641\\u0647 \\u062c\\u0627\\u0643\\u0648\\u0628 \\u0648\\u0622\\u0631\\u0648\\u0646 \\u0647\\u0648 \\u0623\\u0646\\u0643 \\u0625\\u0630\\u0627 \\u0623\\u0639\\u0637\\u064a\\u062a \\u0634\\u062e\\u0635\\u064b\\u0627 \\u0645\\u0627 \\u0645\\u0646\\u062a\\u062c\\u0643 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u062a\\u0643 \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0631\\u0627\\u0642\\u064a\\u0629 \\u0648\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u060c \\u0643\\u062a\\u062c\\u0631\\u0628\\u0629 \\u060c \\u0641\\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u060c \\u0633\\u064a\\u0631\\u063a\\u0628\\u0648\\u0646 \\u0641\\u064a \\u0630\\u0644\\u0643. (\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a \\u0647\\u0648 \\u0625\\u064a\\u0635\\u0627\\u0644\\u0647 \\u0628\\u0623\\u064a\\u062f\\u064a\\u0647\\u0645). \\u062a\\u0634\\u062c\\u0639\\u0643 Popinsanity \\u0639\\u0644\\u0649 \\u0625\\u0646\\u0641\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0641\\u064a \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629 \\u0639\\u0644\\u0649 \\\"\\u0627\\u0644\\u062a\\u0630\\u0648\\u0642\\\" \\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0646\\u064a\\u0629 \\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; hyphens: auto; line-height: 1.6;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0639\\u0645\\u0644\\u0643: \\u064a\\u0634\\u0647\\u062f \\u0622\\u0631\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0623\\u0646\\u0647 \\u0628\\u0627\\u0626\\u0639 \\u0647\\u0627\\u0626\\u0644. \\u0627\\u0645\\u0646\\u062d\\u0647 3 \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0641\\u064a \\u063a\\u0631\\u0641\\u0629 \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635 - \\u0648\\u062d\\u0635\\u0644\\u062a \\u0639\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0636. \\u0648\\u0644\\u0643\\u0646 \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u062d\\u064a\\u0627\\u062a\\u0647 \\u062a\\u0639\\u062a\\u0645\\u062f \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643 \\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0641\\u0647\\u0645 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0627\\u062a \\u0648\\u0639\\u0645\\u0648\\u0645\\u064a\\u0627\\u062a \\u0633\\u0644\\u0633\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0631\\u064a\\u062f \\u0648\\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0639. \\\"\\u0641\\u064a \\u062d\\u0627\\u0644\\u062a\\u0646\\u0627 \\u060c \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0645\\u0634\\u0627\\u0643\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0637\\u0648\\u0628\\u0629 \\u060c \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0642\\u0633 \\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0644\\u0648\\u062c\\u0633\\u062a\\u064a\\u0629 \\u060c \\u0630\\u0648\\u0628\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629 \\u060c \\u0644\\u0630\\u0644\\u0643 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u062a\\u062c\\u0645\\u0639 \\u0623\\u062c\\u0632\\u0627\\u0621 \\u0643\\u062b\\u064a\\u0631\\u0629\\\" - \\u0642\\u0627\\u0644 \\u0644\\u064a. \\u0645\\u0627 \\u062a\\u0639\\u0644\\u0645\\u0647 \\u0647\\u0648 \\u0642\\u064a\\u0645\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0643\\u0629 \\u0648\\u0625\\u0633\\u0646\\u0627\\u062f \\u0645\\u0647\\u0627\\u0645 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0644\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a.<\\/font><\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; hyphens: auto; line-height: 1.6;\\\"><font color=\\\"#717171\\\" face=\\\"Open Sans, sans-serif\\\">\\u0645\\u0646 \\u0623\\u0646\\u062a: \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0634\\u0631\\u0633\\u0629 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0643\\u0627\\u0646 \\u062a\\u0642\\u0631\\u064a\\u0628\\u064b\\u0627. \\u0644\\u0643\\u0646 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0636\\u0639 \\u0628\\u0647\\u0627 \\u0646\\u0641\\u0633\\u0643 \\u0648\\u0639\\u0644\\u0627\\u0645\\u062a\\u0643 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0641\\u0631\\u0642\\u064b\\u0627 \\u0643\\u0628\\u064a\\u0631\\u064b\\u0627. \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 Popinsanity \\u060c \\u0623\\u0642\\u0631\\u0648\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0634\\u0627\\u0631. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u0627\\u0645\\u0644 \\u0623\\u064a \\u0645\\u0646\\u0647\\u0645 \\u0627\\u0644\\u0641\\u0634\\u0627\\u0631 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629. \\u0641\\u064a \\u0627\\u0644\\u0644\\u062d\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0639\\u0627\\u062f\\u0648\\u0627 \\u0641\\u064a\\u0647\\u0627 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0645\\u0646\\u062a\\u062c\\u0647\\u0645 \\u0643\\u062d\\u0644\\u0648\\u0649 \\u0630\\u0648\\u0627\\u0642\\u0629 \\u060c \\u0644\\u0645 \\u064a\\u0639\\u062f \\u0645\\u0648\\u062c\\u0648\\u062f\\u064b\\u0627 \\u0641\\u064a \\u0645\\u0633\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u0641\\u064a\\u0641\\u0629 \\u0623\\u0648 \\u062d\\u062a\\u0649 \\u0627\\u0644\\u0634\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a\\u0629. \\u0644\\u0639\\u0628\\u062a \\u0627\\u0644\\u0622\\u0646 \\u0641\\u064a \\u0641\\u0626\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0645\\u0627\\u0645\\u0627.<\\/font><\\/p><\\/div>\"}','214',16,1,'2022-11-08 06:37:35','2022-11-12 11:32:06')");
       }
   }
}
