<?php

namespace Database\Seeders\Tenant\ModuleData\Job;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class JobSeed
{


    public static function execute()
    {
        if (!Schema::hasTable('jobs')) {
            Schema::create('jobs', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('category_id');
                $table->text('title');
                $table->text('slug')->nullable();
                $table->longText('description');
                $table->text('experience');
                $table->text('designation');
                $table->string('employee_type');
                $table->string('working_days');
                $table->string('working_type');
                $table->text('job_location');
                $table->text('company_name');
                $table->double('salary_offer');
                $table->string('image')->nullable();
                $table->string('deadline');
                $table->string('application_fee_status')->nullable();
                $table->bigInteger('application_fee')->nullable();
                $table->boolean('status')->default(1);
                $table->timestamps();
            });
        }


        $package = tenant()->user()->first()?->payment_log()->first()?->package()->first() ?? [];
        $all_features = $package->plan_features ?? [];

        $payment_log = tenant()->user()->first()?->payment_log()?->first() ?? [];
        if(empty($all_features) && $payment_log->status != 'trial'){
            return;
        }

        $check_feature_name = $all_features->pluck('feature_name')->toArray();

        if (in_array('job', $check_feature_name)) {


            DB::statement("INSERT INTO `jobs` (`id`, `category_id`, `title`, `slug`, `description`, `experience`, `designation`, `employee_type`, `working_days`, `working_type`, `job_location`, `company_name`, `salary_offer`, `image`, `deadline`, `application_fee_status`, `application_fee`, `status`, `created_at`, `updated_at`)
VALUES
	(1,1,'{\"en_US\":\"Font end developer\",\"ar\":\"\\\u0623\\\u0633\\\u0627\\\u0633 \\\u0627\\\u0644\\\u062a\\\u0641\\\u0631\\\u063a \\\u0627\\\u0644\\\u0643\\\u0627\\\u0645\\\u0644 \\\u0623\\\u0648 \\\u0627\\\u0644\"}','font-end-developer-1','{\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Full Job Description<\\/h5><div class=\\\"heading mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Quality Reviewer<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Insurance Inspection Underwriting<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Full-time opportunities available<\\/p><\\/div><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Millennium Information Services is growing! We are a leading national provider of property inspection services and innovative process management solutions for property and casualty insurance companies.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Opportunity:<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We are looking for detail-oriented individuals to review and process exterior &amp; interior residential property inspections on either a full or part-time basis. This is a work from home position requiring a Windows computer and high-speed internet. Training will be done by webinar.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We offer $3,000 per month depending on experience. Experience working in the property insurance industry preferred, however we will train.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Description:<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The Quality Reviewer\\u2019s primary focus is to review photographs and inspector reports to verify property condition, building type and materials, the home\\u2019s footprint, and any visible hazards before submitting the completed inspection to the client.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Recruitment<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are obsessed with growth, innovation, staying ahead of the trends, and making sure our clients get results.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We love marketing and constantly taking our skills to the next level.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe in giving our team members ownership of their accounts and having the ability to take charge in making an impact for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe communication, attention to detail, and organization are super important to allow us to get the best results possible for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We thrive in rapidly changing environments and we expect all our team members to do the same.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are a fully remote team and love the flexibility &amp; freedom that comes with it.<\\/li><li><\\/li><\\/ul><\\/div>\",\"ar\":\"<h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0627\\u0644\\u0648\\u0635\\u0641 \\u0627\\u0644\\u0648\\u0638\\u064a\\u0641\\u064a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0645\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0625\\u0643\\u062a\\u062a\\u0627\\u0628 \\u0641\\u062d\\u0635 \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0627\\u0644\\u0641\\u0631\\u0635 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0628\\u062f\\u0648\\u0627\\u0645 \\u0643\\u0627\\u0645\\u0644<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0634\\u0631\\u0643\\u0629 \\u0645\\u064a\\u0644\\u064a\\u0646\\u064a\\u0648\\u0645 \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0622\\u062e\\u0630\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0646\\u0645\\u0648! \\u0646\\u062d\\u0646 \\u0645\\u0632\\u0648\\u062f \\u0648\\u0637\\u0646\\u064a \\u0631\\u0627\\u0626\\u062f \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0641\\u062d\\u0635 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0648\\u062d\\u0644\\u0648\\u0644 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u062a\\u0643\\u0631\\u0629 \\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0636\\u062f \\u0627\\u0644\\u062d\\u0648\\u0627\\u062f\\u062b.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0641\\u0631\\u0635\\u0629:<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0623\\u0641\\u0631\\u0627\\u062f \\u0645\\u0647\\u062a\\u0645\\u064a\\u0646 \\u0628\\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0648\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062a\\u0641\\u062a\\u064a\\u0634 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0627\\u0644\\u0633\\u0643\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0631\\u062c\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0627\\u062e\\u0644\\u064a\\u0629 \\u0625\\u0645\\u0627 \\u0639\\u0644\\u0649 \\u0623\\u0633\\u0627\\u0633 \\u0627\\u0644\\u062a\\u0641\\u0631\\u063a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644 \\u0623\\u0648 \\u0627\\u0644\\u062c\\u0632\\u0626\\u064a. \\u0647\\u0630\\u0627 \\u0639\\u0645\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u064a\\u062a\\u0637\\u0644\\u0628 \\u062c\\u0647\\u0627\\u0632 \\u0643\\u0645\\u0628\\u064a\\u0648\\u062a\\u0631 \\u064a\\u0639\\u0645\\u0644 \\u0628\\u0646\\u0638\\u0627\\u0645 Windows \\u0648\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0639\\u0627\\u0644\\u064a \\u0627\\u0644\\u0633\\u0631\\u0639\\u0629. \\u0633\\u064a\\u062a\\u0645 \\u0627\\u0644\\u062a\\u062f\\u0631\\u064a\\u0628 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u0627\\u0644\\u0646\\u062f\\u0648\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0642\\u062f\\u0645 3000 \\u062f\\u0648\\u0644\\u0627\\u0631 \\u0634\\u0647\\u0631\\u064a\\u064b\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062e\\u0628\\u0631\\u0629. \\u064a\\u0641\\u0636\\u0644 \\u062e\\u0628\\u0631\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644 \\u0641\\u064a \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u060c \\u0648\\u0644\\u0643\\u0646\\u0646\\u0627 \\u0633\\u0646\\u062a\\u062f\\u0631\\u0628.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0648\\u0635\\u0641:<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u064a\\u0646\\u0635\\u0628 \\u0627\\u0644\\u062a\\u0631\\u0643\\u064a\\u0632 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0635\\u0648\\u0631 \\u0648\\u062a\\u0642\\u0627\\u0631\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0641\\u062a\\u0634 \\u0644\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u062d\\u0627\\u0644\\u0629 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0648\\u0646\\u0648\\u0639 \\u0627\\u0644\\u0645\\u0628\\u0646\\u0649 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0627\\u062f \\u0648\\u0628\\u0635\\u0645\\u0629 \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u0648\\u0623\\u064a \\u0645\\u062e\\u0627\\u0637\\u0631 \\u0645\\u0631\\u0626\\u064a\\u0629 \\u0642\\u0628\\u0644 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u0641\\u062d\\u0635 \\u0627\\u0644\\u0645\\u0643\\u062a\\u0645\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u062a\\u0648\\u0638\\u064a\\u0641<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0647\\u0648\\u0648\\u0633\\u0648\\u0646 \\u0628\\u0627\\u0644\\u0646\\u0645\\u0648 \\u0648\\u0627\\u0644\\u0627\\u0628\\u062a\\u0643\\u0627\\u0631 \\u0648\\u0627\\u0644\\u0628\\u0642\\u0627\\u0621 \\u0641\\u064a \\u0637\\u0644\\u064a\\u0639\\u0629 \\u0627\\u0644\\u0627\\u062a\\u062c\\u0627\\u0647\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u062d\\u0635\\u0648\\u0644 \\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0646\\u062a\\u0627\\u0626\\u062c.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u062d\\u0628 \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642 \\u0648\\u0646\\u0646\\u0642\\u0644 \\u0645\\u0647\\u0627\\u0631\\u0627\\u062a\\u0646\\u0627 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0645\\u0646\\u062d \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0645\\u0644\\u0643\\u064a\\u0629 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a\\u0647\\u0645 \\u0648\\u0627\\u0644\\u0642\\u062f\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u062a\\u062d\\u0645\\u0644 \\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0629 \\u0641\\u064a \\u0625\\u062d\\u062f\\u0627\\u062b \\u062a\\u0623\\u062b\\u064a\\u0631 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0623\\u0646 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0648\\u0627\\u0644\\u0627\\u0647\\u062a\\u0645\\u0627\\u0645 \\u0628\\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0645\\u0647\\u0645\\u0627\\u0646 \\u0644\\u0644\\u063a\\u0627\\u064a\\u0629 \\u0644\\u0644\\u0633\\u0645\\u0627\\u062d \\u0644\\u0646\\u0627 \\u0628\\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0623\\u0641\\u0636\\u0644 \\u0627\\u0644\\u0646\\u062a\\u0627\\u0626\\u062c \\u0627\\u0644\\u0645\\u0645\\u0643\\u0646\\u0629 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0632\\u062f\\u0647\\u0631 \\u0641\\u064a \\u0628\\u064a\\u0626\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062a\\u063a\\u064a\\u0631 \\u0648\\u0646\\u062a\\u0648\\u0642\\u0639 \\u0645\\u0646 \\u062c\\u0645\\u064a\\u0639 \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0623\\u0646 \\u064a\\u0641\\u0639\\u0644\\u0648\\u0627 \\u0627\\u0644\\u0634\\u064a\\u0621 \\u0646\\u0641\\u0633\\u0647.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0641\\u0631\\u064a\\u0642 \\u0628\\u0639\\u064a\\u062f \\u062a\\u0645\\u0627\\u0645\\u064b\\u0627 \\u0648\\u0646\\u062d\\u0628 \\u0627\\u0644\\u0645\\u0631\\u0648\\u0646\\u0629 \\u0648\\u0627\\u0644\\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0623\\u062a\\u064a \\u0645\\u0639\\u0647\\u0627.<\\/span><\\/font><\\/h5>\"}','3 years','{\"en_US\":\"Web Developer\",\"ar\":\"\\u0623\\u0633\\u0627\\u0633 \\u0627\\u0644\\u062a\\u0641\\u0631\\u063a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644 \\u0623\\u0648 \\u0627\\u0644\"}','0','5','1','{\"en_US\":\"Dhanmondi, Dhaka\",\"ar\":\"\\u0623\\u0633\\u0627\\u0633 \\u0627\\u0644\\u062a\\u0641\\u0631\\u063a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644 \\u0623\\u0648 \\u0627\\u0644\"}','{\"en_US\":\"Demo Company\",\"ar\":\"\\u0623\\u0633\\u0627\\u0633 \\u0627\\u0644\\u062a\\u0641\\u0631\\u063a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644 \\u0623\\u0648 \\u0627\\u0644\"}',35000,'191','2022-11-30','on',20,1,'2022-11-07 04:58:21','2022-11-12 10:53:48'),
	(2,1,'{\"en\":\"Font end developer\",\"en_US\":\"Senior UIUX Designer\",\"ar\":\"\\\u0646 \\\u062c\\\u0645\\\u064a\\u0639 \\u0623\\u0639\\\u0636\\\u0627\\\u0621 \\\u0641\\\u0631\\u064a\\\u0642\\\u0646\\\u0627\"}','senior-uiux-designer-1','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Full Job Description<\\/h5><div class=\\\"heading mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Quality Reviewer<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Insurance Inspection Underwriting<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Full-time opportunities available<\\/p><\\/div><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Millennium Information Services is growing! We are a leading national provider of property inspection services and innovative process management solutions for property and casualty insurance companies.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Opportunity:<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We are looking for detail-oriented individuals to review and process exterior &amp; interior residential property inspections on either a full or part-time basis. This is a work from home position requiring a Windows computer and high-speed internet. Training will be done by webinar.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We offer $3,000 per month depending on experience. Experience working in the property insurance industry preferred, however we will train.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Description:<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The Quality Reviewer\\u2019s primary focus is to review photographs and inspector reports to verify property condition, building type and materials, the home\\u2019s footprint, and any visible hazards before submitting the completed inspection to the client.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Recruitment<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are obsessed with growth, innovation, staying ahead of the trends, and making sure our clients get results.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We love marketing and constantly taking our skills to the next level.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe in giving our team members ownership of their accounts and having the ability to take charge in making an impact for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe communication, attention to detail, and organization are super important to allow us to get the best results possible for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We thrive in rapidly changing environments and we expect all our team members to do the same.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are a fully remote team and love the flexibility &amp; freedom that comes with it.<\\/li><li><\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Full Job Description<\\/h5><div class=\\\"heading mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Quality Reviewer<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Insurance Inspection Underwriting<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Full-time opportunities available<\\/p><\\/div><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Millennium Information Services is growing! We are a leading national provider of property inspection services and innovative process management solutions for property and casualty insurance companies.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Opportunity:<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We are looking for detail-oriented individuals to review and process exterior &amp; interior residential property inspections on either a full or part-time basis. This is a work from home position requiring a Windows computer and high-speed internet. Training will be done by webinar.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We offer $3,000 per month depending on experience. Experience working in the property insurance industry preferred, however we will train.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Description:<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The Quality Reviewer\\u2019s primary focus is to review photographs and inspector reports to verify property condition, building type and materials, the home\\u2019s footprint, and any visible hazards before submitting the completed inspection to the client.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Recruitment<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are obsessed with growth, innovation, staying ahead of the trends, and making sure our clients get results.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We love marketing and constantly taking our skills to the next level.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe in giving our team members ownership of their accounts and having the ability to take charge in making an impact for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe communication, attention to detail, and organization are super important to allow us to get the best results possible for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We thrive in rapidly changing environments and we expect all our team members to do the same.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are a fully remote team and love the flexibility &amp; freedom that comes with it.<\\/li><li><\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0627\\u0644\\u0648\\u0635\\u0641 \\u0627\\u0644\\u0648\\u0638\\u064a\\u0641\\u064a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0645\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0625\\u0643\\u062a\\u062a\\u0627\\u0628 \\u0641\\u062d\\u0635 \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0627\\u0644\\u0641\\u0631\\u0635 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0628\\u062f\\u0648\\u0627\\u0645 \\u0643\\u0627\\u0645\\u0644<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0634\\u0631\\u0643\\u0629 \\u0645\\u064a\\u0644\\u064a\\u0646\\u064a\\u0648\\u0645 \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0622\\u062e\\u0630\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0646\\u0645\\u0648! \\u0646\\u062d\\u0646 \\u0645\\u0632\\u0648\\u062f \\u0648\\u0637\\u0646\\u064a \\u0631\\u0627\\u0626\\u062f \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0641\\u062d\\u0635 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0648\\u062d\\u0644\\u0648\\u0644 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u062a\\u0643\\u0631\\u0629 \\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0636\\u062f \\u0627\\u0644\\u062d\\u0648\\u0627\\u062f\\u062b.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0641\\u0631\\u0635\\u0629:<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0623\\u0641\\u0631\\u0627\\u062f \\u0645\\u0647\\u062a\\u0645\\u064a\\u0646 \\u0628\\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0648\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062a\\u0641\\u062a\\u064a\\u0634 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0627\\u0644\\u0633\\u0643\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0631\\u062c\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0627\\u062e\\u0644\\u064a\\u0629 \\u0625\\u0645\\u0627 \\u0639\\u0644\\u0649 \\u0623\\u0633\\u0627\\u0633 \\u0627\\u0644\\u062a\\u0641\\u0631\\u063a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644 \\u0623\\u0648 \\u0627\\u0644\\u062c\\u0632\\u0626\\u064a. \\u0647\\u0630\\u0627 \\u0639\\u0645\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u064a\\u062a\\u0637\\u0644\\u0628 \\u062c\\u0647\\u0627\\u0632 \\u0643\\u0645\\u0628\\u064a\\u0648\\u062a\\u0631 \\u064a\\u0639\\u0645\\u0644 \\u0628\\u0646\\u0638\\u0627\\u0645 Windows \\u0648\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0639\\u0627\\u0644\\u064a \\u0627\\u0644\\u0633\\u0631\\u0639\\u0629. \\u0633\\u064a\\u062a\\u0645 \\u0627\\u0644\\u062a\\u062f\\u0631\\u064a\\u0628 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u0627\\u0644\\u0646\\u062f\\u0648\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0642\\u062f\\u0645 3000 \\u062f\\u0648\\u0644\\u0627\\u0631 \\u0634\\u0647\\u0631\\u064a\\u064b\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062e\\u0628\\u0631\\u0629. \\u064a\\u0641\\u0636\\u0644 \\u062e\\u0628\\u0631\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644 \\u0641\\u064a \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u060c \\u0648\\u0644\\u0643\\u0646\\u0646\\u0627 \\u0633\\u0646\\u062a\\u062f\\u0631\\u0628.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0648\\u0635\\u0641:<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u064a\\u0646\\u0635\\u0628 \\u0627\\u0644\\u062a\\u0631\\u0643\\u064a\\u0632 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0635\\u0648\\u0631 \\u0648\\u062a\\u0642\\u0627\\u0631\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0641\\u062a\\u0634 \\u0644\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u062d\\u0627\\u0644\\u0629 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0648\\u0646\\u0648\\u0639 \\u0627\\u0644\\u0645\\u0628\\u0646\\u0649 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0627\\u062f \\u0648\\u0628\\u0635\\u0645\\u0629 \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u0648\\u0623\\u064a \\u0645\\u062e\\u0627\\u0637\\u0631 \\u0645\\u0631\\u0626\\u064a\\u0629 \\u0642\\u0628\\u0644 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u0641\\u062d\\u0635 \\u0627\\u0644\\u0645\\u0643\\u062a\\u0645\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u062a\\u0648\\u0638\\u064a\\u0641<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0647\\u0648\\u0648\\u0633\\u0648\\u0646 \\u0628\\u0627\\u0644\\u0646\\u0645\\u0648 \\u0648\\u0627\\u0644\\u0627\\u0628\\u062a\\u0643\\u0627\\u0631 \\u0648\\u0627\\u0644\\u0628\\u0642\\u0627\\u0621 \\u0641\\u064a \\u0637\\u0644\\u064a\\u0639\\u0629 \\u0627\\u0644\\u0627\\u062a\\u062c\\u0627\\u0647\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u062d\\u0635\\u0648\\u0644 \\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0646\\u062a\\u0627\\u0626\\u062c.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u062d\\u0628 \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642 \\u0648\\u0646\\u0646\\u0642\\u0644 \\u0645\\u0647\\u0627\\u0631\\u0627\\u062a\\u0646\\u0627 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0645\\u0646\\u062d \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0645\\u0644\\u0643\\u064a\\u0629 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a\\u0647\\u0645 \\u0648\\u0627\\u0644\\u0642\\u062f\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u062a\\u062d\\u0645\\u0644 \\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0629 \\u0641\\u064a \\u0625\\u062d\\u062f\\u0627\\u062b \\u062a\\u0623\\u062b\\u064a\\u0631 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0623\\u0646 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0648\\u0627\\u0644\\u0627\\u0647\\u062a\\u0645\\u0627\\u0645 \\u0628\\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0645\\u0647\\u0645\\u0627\\u0646 \\u0644\\u0644\\u063a\\u0627\\u064a\\u0629 \\u0644\\u0644\\u0633\\u0645\\u0627\\u062d \\u0644\\u0646\\u0627 \\u0628\\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0623\\u0641\\u0636\\u0644 \\u0627\\u0644\\u0646\\u062a\\u0627\\u0626\\u062c \\u0627\\u0644\\u0645\\u0645\\u0643\\u0646\\u0629 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0632\\u062f\\u0647\\u0631 \\u0641\\u064a \\u0628\\u064a\\u0626\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062a\\u063a\\u064a\\u0631 \\u0648\\u0646\\u062a\\u0648\\u0642\\u0639 \\u0645\\u0646 \\u062c\\u0645\\u064a\\u0639 \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0623\\u0646 \\u064a\\u0641\\u0639\\u0644\\u0648\\u0627 \\u0627\\u0644\\u0634\\u064a\\u0621 \\u0646\\u0641\\u0633\\u0647.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0641\\u0631\\u064a\\u0642 \\u0628\\u0639\\u064a\\u062f \\u062a\\u0645\\u0627\\u0645\\u064b\\u0627 \\u0648\\u0646\\u062d\\u0628 \\u0627\\u0644\\u0645\\u0631\\u0648\\u0646\\u0629 \\u0648\\u0627\\u0644\\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0623\\u062a\\u064a \\u0645\\u0639\\u0647\\u0627.<\\/span><\\/font><\\/h5><\\/div>\"}','3 years','{\"en_US\":\"Police Officer\",\"ar\":\"\\u0646 \\u062c\\u0645\\u064a\\u0639 \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627\"}','0','5','1','{\"en_US\":\"Tele-Trabalho\",\"ar\":\"\\u0646 \\u062c\\u0645\\u064a\\u0639 \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627\"}','{\"en_US\":\"Demo Company\",\"ar\":\"\\u0646 \\u062c\\u0645\\u064a\\u0639 \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627\"}',30000,'202','2022-11-30','on',15,1,'2022-11-07 04:58:27','2022-11-12 10:53:24'),
	(3,3,'{\"en\":\"Senior UIUX Designer\",\"en_US\":\"Mobile App Designer\"}','mobile-app-designer','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Full Job Description<\\/h5><div class=\\\"heading mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Quality Reviewer<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Insurance Inspection Underwriting<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Full-time opportunities available<\\/p><\\/div><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Millennium Information Services is growing! We are a leading national provider of property inspection services and innovative process management solutions for property and casualty insurance companies.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Opportunity:<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We are looking for detail-oriented individuals to review and process exterior &amp; interior residential property inspections on either a full or part-time basis. This is a work from home position requiring a Windows computer and high-speed internet. Training will be done by webinar.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We offer $3,000 per month depending on experience. Experience working in the property insurance industry preferred, however we will train.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Description:<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The Quality Reviewer\\u2019s primary focus is to review photographs and inspector reports to verify property condition, building type and materials, the home\\u2019s footprint, and any visible hazards before submitting the completed inspection to the client.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Recruitment<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are obsessed with growth, innovation, staying ahead of the trends, and making sure our clients get results.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We love marketing and constantly taking our skills to the next level.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe in giving our team members ownership of their accounts and having the ability to take charge in making an impact for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe communication, attention to detail, and organization are super important to allow us to get the best results possible for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We thrive in rapidly changing environments and we expect all our team members to do the same.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are a fully remote team and love the flexibility &amp; freedom that comes with it.<\\/li><li><\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Full Job Description<\\/h5><div class=\\\"heading mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Quality Reviewer<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Insurance Inspection Underwriting<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Full-time opportunities available<\\/p><\\/div><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Millennium Information Services is growing! We are a leading national provider of property inspection services and innovative process management solutions for property and casualty insurance companies.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Opportunity:<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We are looking for detail-oriented individuals to review and process exterior &amp; interior residential property inspections on either a full or part-time basis. This is a work from home position requiring a Windows computer and high-speed internet. Training will be done by webinar.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We offer $3,000 per month depending on experience. Experience working in the property insurance industry preferred, however we will train.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Description:<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The Quality Reviewer\\u2019s primary focus is to review photographs and inspector reports to verify property condition, building type and materials, the home\\u2019s footprint, and any visible hazards before submitting the completed inspection to the client.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Recruitment<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are obsessed with growth, innovation, staying ahead of the trends, and making sure our clients get results.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We love marketing and constantly taking our skills to the next level.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe in giving our team members ownership of their accounts and having the ability to take charge in making an impact for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe communication, attention to detail, and organization are super important to allow us to get the best results possible for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We thrive in rapidly changing environments and we expect all our team members to do the same.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are a fully remote team and love the flexibility &amp; freedom that comes with it.<\\/li><li><\\/li><\\/ul><\\/div>\"}','2 years','{\"en_US\":\"Mobile App Designer\"}','0','5','1','{\"en_US\":\"Dhanmondi, Dhaka\"}','{\"en_US\":\"Demo Company\"}',42000,'194','2022-12-15',NULL,NULL,1,'2022-11-07 05:00:59','2022-11-07 05:02:01'),
	(4,6,'{\"en\":\"Mobile App Designer\",\"en_US\":\"Full Stack Developer\",\"ar\":\"\\u0641\\u064a \\u0628\\u064a\\u0626\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062a\\u063a\\u064a\\u0631\"}','full-stack-developer-1','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Full Job Description<\\/h5><div class=\\\"heading mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Quality Reviewer<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Insurance Inspection Underwriting<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Full-time opportunities available<\\/p><\\/div><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Millennium Information Services is growing! We are a leading national provider of property inspection services and innovative process management solutions for property and casualty insurance companies.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Opportunity:<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We are looking for detail-oriented individuals to review and process exterior &amp; interior residential property inspections on either a full or part-time basis. This is a work from home position requiring a Windows computer and high-speed internet. Training will be done by webinar.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We offer $3,000 per month depending on experience. Experience working in the property insurance industry preferred, however we will train.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Description:<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The Quality Reviewer\\u2019s primary focus is to review photographs and inspector reports to verify property condition, building type and materials, the home\\u2019s footprint, and any visible hazards before submitting the completed inspection to the client.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Recruitment<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are obsessed with growth, innovation, staying ahead of the trends, and making sure our clients get results.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We love marketing and constantly taking our skills to the next level.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe in giving our team members ownership of their accounts and having the ability to take charge in making an impact for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe communication, attention to detail, and organization are super important to allow us to get the best results possible for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We thrive in rapidly changing environments and we expect all our team members to do the same.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are a fully remote team and love the flexibility &amp; freedom that comes with it.<\\/li><li><\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Full Job Description<\\/h5><div class=\\\"heading mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Quality Reviewer<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Insurance Inspection Underwriting<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Full-time opportunities available<\\/p><\\/div><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Millennium Information Services is growing! We are a leading national provider of property inspection services and innovative process management solutions for property and casualty insurance companies.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Opportunity:<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We are looking for detail-oriented individuals to review and process exterior &amp; interior residential property inspections on either a full or part-time basis. This is a work from home position requiring a Windows computer and high-speed internet. Training will be done by webinar.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We offer $3,000 per month depending on experience. Experience working in the property insurance industry preferred, however we will train.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Description:<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The Quality Reviewer\\u2019s primary focus is to review photographs and inspector reports to verify property condition, building type and materials, the home\\u2019s footprint, and any visible hazards before submitting the completed inspection to the client.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Recruitment<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are obsessed with growth, innovation, staying ahead of the trends, and making sure our clients get results.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We love marketing and constantly taking our skills to the next level.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe in giving our team members ownership of their accounts and having the ability to take charge in making an impact for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe communication, attention to detail, and organization are super important to allow us to get the best results possible for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We thrive in rapidly changing environments and we expect all our team members to do the same.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are a fully remote team and love the flexibility &amp; freedom that comes with it.<\\/li><li><\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0627\\u0644\\u0648\\u0635\\u0641 \\u0627\\u0644\\u0648\\u0638\\u064a\\u0641\\u064a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0645\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0625\\u0643\\u062a\\u062a\\u0627\\u0628 \\u0641\\u062d\\u0635 \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0627\\u0644\\u0641\\u0631\\u0635 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0628\\u062f\\u0648\\u0627\\u0645 \\u0643\\u0627\\u0645\\u0644<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0634\\u0631\\u0643\\u0629 \\u0645\\u064a\\u0644\\u064a\\u0646\\u064a\\u0648\\u0645 \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0622\\u062e\\u0630\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0646\\u0645\\u0648! \\u0646\\u062d\\u0646 \\u0645\\u0632\\u0648\\u062f \\u0648\\u0637\\u0646\\u064a \\u0631\\u0627\\u0626\\u062f \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0641\\u062d\\u0635 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0648\\u062d\\u0644\\u0648\\u0644 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u062a\\u0643\\u0631\\u0629 \\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0636\\u062f \\u0627\\u0644\\u062d\\u0648\\u0627\\u062f\\u062b.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0641\\u0631\\u0635\\u0629:<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0623\\u0641\\u0631\\u0627\\u062f \\u0645\\u0647\\u062a\\u0645\\u064a\\u0646 \\u0628\\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0648\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062a\\u0641\\u062a\\u064a\\u0634 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0627\\u0644\\u0633\\u0643\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0631\\u062c\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0627\\u062e\\u0644\\u064a\\u0629 \\u0625\\u0645\\u0627 \\u0639\\u0644\\u0649 \\u0623\\u0633\\u0627\\u0633 \\u0627\\u0644\\u062a\\u0641\\u0631\\u063a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644 \\u0623\\u0648 \\u0627\\u0644\\u062c\\u0632\\u0626\\u064a. \\u0647\\u0630\\u0627 \\u0639\\u0645\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u064a\\u062a\\u0637\\u0644\\u0628 \\u062c\\u0647\\u0627\\u0632 \\u0643\\u0645\\u0628\\u064a\\u0648\\u062a\\u0631 \\u064a\\u0639\\u0645\\u0644 \\u0628\\u0646\\u0638\\u0627\\u0645 Windows \\u0648\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0639\\u0627\\u0644\\u064a \\u0627\\u0644\\u0633\\u0631\\u0639\\u0629. \\u0633\\u064a\\u062a\\u0645 \\u0627\\u0644\\u062a\\u062f\\u0631\\u064a\\u0628 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u0627\\u0644\\u0646\\u062f\\u0648\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0642\\u062f\\u0645 3000 \\u062f\\u0648\\u0644\\u0627\\u0631 \\u0634\\u0647\\u0631\\u064a\\u064b\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062e\\u0628\\u0631\\u0629. \\u064a\\u0641\\u0636\\u0644 \\u062e\\u0628\\u0631\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644 \\u0641\\u064a \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u060c \\u0648\\u0644\\u0643\\u0646\\u0646\\u0627 \\u0633\\u0646\\u062a\\u062f\\u0631\\u0628.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0648\\u0635\\u0641:<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u064a\\u0646\\u0635\\u0628 \\u0627\\u0644\\u062a\\u0631\\u0643\\u064a\\u0632 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0635\\u0648\\u0631 \\u0648\\u062a\\u0642\\u0627\\u0631\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0641\\u062a\\u0634 \\u0644\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u062d\\u0627\\u0644\\u0629 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0648\\u0646\\u0648\\u0639 \\u0627\\u0644\\u0645\\u0628\\u0646\\u0649 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0627\\u062f \\u0648\\u0628\\u0635\\u0645\\u0629 \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u0648\\u0623\\u064a \\u0645\\u062e\\u0627\\u0637\\u0631 \\u0645\\u0631\\u0626\\u064a\\u0629 \\u0642\\u0628\\u0644 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u0641\\u062d\\u0635 \\u0627\\u0644\\u0645\\u0643\\u062a\\u0645\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u062a\\u0648\\u0638\\u064a\\u0641<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0647\\u0648\\u0648\\u0633\\u0648\\u0646 \\u0628\\u0627\\u0644\\u0646\\u0645\\u0648 \\u0648\\u0627\\u0644\\u0627\\u0628\\u062a\\u0643\\u0627\\u0631 \\u0648\\u0627\\u0644\\u0628\\u0642\\u0627\\u0621 \\u0641\\u064a \\u0637\\u0644\\u064a\\u0639\\u0629 \\u0627\\u0644\\u0627\\u062a\\u062c\\u0627\\u0647\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u062d\\u0635\\u0648\\u0644 \\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0646\\u062a\\u0627\\u0626\\u062c.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u062d\\u0628 \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642 \\u0648\\u0646\\u0646\\u0642\\u0644 \\u0645\\u0647\\u0627\\u0631\\u0627\\u062a\\u0646\\u0627 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0645\\u0646\\u062d \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0645\\u0644\\u0643\\u064a\\u0629 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a\\u0647\\u0645 \\u0648\\u0627\\u0644\\u0642\\u062f\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u062a\\u062d\\u0645\\u0644 \\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0629 \\u0641\\u064a \\u0625\\u062d\\u062f\\u0627\\u062b \\u062a\\u0623\\u062b\\u064a\\u0631 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0623\\u0646 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0648\\u0627\\u0644\\u0627\\u0647\\u062a\\u0645\\u0627\\u0645 \\u0628\\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0645\\u0647\\u0645\\u0627\\u0646 \\u0644\\u0644\\u063a\\u0627\\u064a\\u0629 \\u0644\\u0644\\u0633\\u0645\\u0627\\u062d \\u0644\\u0646\\u0627 \\u0628\\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0623\\u0641\\u0636\\u0644 \\u0627\\u0644\\u0646\\u062a\\u0627\\u0626\\u062c \\u0627\\u0644\\u0645\\u0645\\u0643\\u0646\\u0629 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0632\\u062f\\u0647\\u0631 \\u0641\\u064a \\u0628\\u064a\\u0626\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062a\\u063a\\u064a\\u0631 \\u0648\\u0646\\u062a\\u0648\\u0642\\u0639 \\u0645\\u0646 \\u062c\\u0645\\u064a\\u0639 \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0623\\u0646 \\u064a\\u0641\\u0639\\u0644\\u0648\\u0627 \\u0627\\u0644\\u0634\\u064a\\u0621 \\u0646\\u0641\\u0633\\u0647.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0641\\u0631\\u064a\\u0642 \\u0628\\u0639\\u064a\\u062f \\u062a\\u0645\\u0627\\u0645\\u064b\\u0627 \\u0648\\u0646\\u062d\\u0628 \\u0627\\u0644\\u0645\\u0631\\u0648\\u0646\\u0629 \\u0648\\u0627\\u0644\\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0623\\u062a\\u064a \\u0645\\u0639\\u0647\\u0627.<\\/span><\\/font><\\/h5><\\/div>\"}','2 years','{\"en_US\":\"Full Stack Developer\",\"ar\":\"\\u0641\\u064a \\u0628\\u064a\\u0626\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062a\\u063a\\u064a\\u0631\"}','0','5','1','{\"en_US\":\"Tele-Trabalho\",\"ar\":\"\\u0641\\u064a \\u0628\\u064a\\u0626\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062a\\u063a\\u064a\\u0631\"}','{\"en_US\":\"Demo Company\",\"ar\":\"\\u0641\\u064a \\u0628\\u064a\\u0626\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062a\\u063a\\u064a\\u0631\"}',65000,'197','2022-12-15','on',30,1,'2022-11-07 05:02:06','2022-11-12 10:52:49'),
	(6,3,'{\"en\":\"Project Manager\",\"en_US\":\"Senior UI Designer\",\"ar\":\"\\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0635\\u0648\\u0631\"}','senior-ui-designer-1','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Full Job Description<\\/h5><div class=\\\"heading mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Quality Reviewer<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Insurance Inspection Underwriting<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Full-time opportunities available<\\/p><\\/div><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Millennium Information Services is growing! We are a leading national provider of property inspection services and innovative process management solutions for property and casualty insurance companies.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Opportunity:<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We are looking for detail-oriented individuals to review and process exterior &amp; interior residential property inspections on either a full or part-time basis. This is a work from home position requiring a Windows computer and high-speed internet. Training will be done by webinar.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We offer $3,000 per month depending on experience. Experience working in the property insurance industry preferred, however we will train.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Description:<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The Quality Reviewer\\u2019s primary focus is to review photographs and inspector reports to verify property condition, building type and materials, the home\\u2019s footprint, and any visible hazards before submitting the completed inspection to the client.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Recruitment<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are obsessed with growth, innovation, staying ahead of the trends, and making sure our clients get results.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We love marketing and constantly taking our skills to the next level.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe in giving our team members ownership of their accounts and having the ability to take charge in making an impact for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe communication, attention to detail, and organization are super important to allow us to get the best results possible for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We thrive in rapidly changing environments and we expect all our team members to do the same.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are a fully remote team and love the flexibility &amp; freedom that comes with it.<\\/li><li><\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Full Job Description<\\/h5><div class=\\\"heading mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Quality Reviewer<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Insurance Inspection Underwriting<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Full-time opportunities available<\\/p><\\/div><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Millennium Information Services is growing! We are a leading national provider of property inspection services and innovative process management solutions for property and casualty insurance companies.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Opportunity:<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We are looking for detail-oriented individuals to review and process exterior &amp; interior residential property inspections on either a full or part-time basis. This is a work from home position requiring a Windows computer and high-speed internet. Training will be done by webinar.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We offer $3,000 per month depending on experience. Experience working in the property insurance industry preferred, however we will train.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Description:<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The Quality Reviewer\\u2019s primary focus is to review photographs and inspector reports to verify property condition, building type and materials, the home\\u2019s footprint, and any visible hazards before submitting the completed inspection to the client.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Recruitment<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are obsessed with growth, innovation, staying ahead of the trends, and making sure our clients get results.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We love marketing and constantly taking our skills to the next level.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe in giving our team members ownership of their accounts and having the ability to take charge in making an impact for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe communication, attention to detail, and organization are super important to allow us to get the best results possible for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We thrive in rapidly changing environments and we expect all our team members to do the same.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are a fully remote team and love the flexibility &amp; freedom that comes with it.<\\/li><li><\\/li><\\/ul><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0627\\u0644\\u0648\\u0635\\u0641 \\u0627\\u0644\\u0648\\u0638\\u064a\\u0641\\u064a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0645\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0625\\u0643\\u062a\\u062a\\u0627\\u0628 \\u0641\\u062d\\u0635 \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0627\\u0644\\u0641\\u0631\\u0635 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0628\\u062f\\u0648\\u0627\\u0645 \\u0643\\u0627\\u0645\\u0644<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0634\\u0631\\u0643\\u0629 \\u0645\\u064a\\u0644\\u064a\\u0646\\u064a\\u0648\\u0645 \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0622\\u062e\\u0630\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0646\\u0645\\u0648! \\u0646\\u062d\\u0646 \\u0645\\u0632\\u0648\\u062f \\u0648\\u0637\\u0646\\u064a \\u0631\\u0627\\u0626\\u062f \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0641\\u062d\\u0635 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0648\\u062d\\u0644\\u0648\\u0644 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u062a\\u0643\\u0631\\u0629 \\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0636\\u062f \\u0627\\u0644\\u062d\\u0648\\u0627\\u062f\\u062b.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0641\\u0631\\u0635\\u0629:<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0623\\u0641\\u0631\\u0627\\u062f \\u0645\\u0647\\u062a\\u0645\\u064a\\u0646 \\u0628\\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0648\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062a\\u0641\\u062a\\u064a\\u0634 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0627\\u0644\\u0633\\u0643\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0631\\u062c\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0627\\u062e\\u0644\\u064a\\u0629 \\u0625\\u0645\\u0627 \\u0639\\u0644\\u0649 \\u0623\\u0633\\u0627\\u0633 \\u0627\\u0644\\u062a\\u0641\\u0631\\u063a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644 \\u0623\\u0648 \\u0627\\u0644\\u062c\\u0632\\u0626\\u064a. \\u0647\\u0630\\u0627 \\u0639\\u0645\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u064a\\u062a\\u0637\\u0644\\u0628 \\u062c\\u0647\\u0627\\u0632 \\u0643\\u0645\\u0628\\u064a\\u0648\\u062a\\u0631 \\u064a\\u0639\\u0645\\u0644 \\u0628\\u0646\\u0638\\u0627\\u0645 Windows \\u0648\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0639\\u0627\\u0644\\u064a \\u0627\\u0644\\u0633\\u0631\\u0639\\u0629. \\u0633\\u064a\\u062a\\u0645 \\u0627\\u0644\\u062a\\u062f\\u0631\\u064a\\u0628 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u0627\\u0644\\u0646\\u062f\\u0648\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0642\\u062f\\u0645 3000 \\u062f\\u0648\\u0644\\u0627\\u0631 \\u0634\\u0647\\u0631\\u064a\\u064b\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062e\\u0628\\u0631\\u0629. \\u064a\\u0641\\u0636\\u0644 \\u062e\\u0628\\u0631\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644 \\u0641\\u064a \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u060c \\u0648\\u0644\\u0643\\u0646\\u0646\\u0627 \\u0633\\u0646\\u062a\\u062f\\u0631\\u0628.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0648\\u0635\\u0641:<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u064a\\u0646\\u0635\\u0628 \\u0627\\u0644\\u062a\\u0631\\u0643\\u064a\\u0632 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0635\\u0648\\u0631 \\u0648\\u062a\\u0642\\u0627\\u0631\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0641\\u062a\\u0634 \\u0644\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u062d\\u0627\\u0644\\u0629 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0648\\u0646\\u0648\\u0639 \\u0627\\u0644\\u0645\\u0628\\u0646\\u0649 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0627\\u062f \\u0648\\u0628\\u0635\\u0645\\u0629 \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u0648\\u0623\\u064a \\u0645\\u062e\\u0627\\u0637\\u0631 \\u0645\\u0631\\u0626\\u064a\\u0629 \\u0642\\u0628\\u0644 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u0641\\u062d\\u0635 \\u0627\\u0644\\u0645\\u0643\\u062a\\u0645\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u062a\\u0648\\u0638\\u064a\\u0641<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0647\\u0648\\u0648\\u0633\\u0648\\u0646 \\u0628\\u0627\\u0644\\u0646\\u0645\\u0648 \\u0648\\u0627\\u0644\\u0627\\u0628\\u062a\\u0643\\u0627\\u0631 \\u0648\\u0627\\u0644\\u0628\\u0642\\u0627\\u0621 \\u0641\\u064a \\u0637\\u0644\\u064a\\u0639\\u0629 \\u0627\\u0644\\u0627\\u062a\\u062c\\u0627\\u0647\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u062d\\u0635\\u0648\\u0644 \\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0646\\u062a\\u0627\\u0626\\u062c.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u062d\\u0628 \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642 \\u0648\\u0646\\u0646\\u0642\\u0644 \\u0645\\u0647\\u0627\\u0631\\u0627\\u062a\\u0646\\u0627 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0645\\u0646\\u062d \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0645\\u0644\\u0643\\u064a\\u0629 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a\\u0647\\u0645 \\u0648\\u0627\\u0644\\u0642\\u062f\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u062a\\u062d\\u0645\\u0644 \\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0629 \\u0641\\u064a \\u0625\\u062d\\u062f\\u0627\\u062b \\u062a\\u0623\\u062b\\u064a\\u0631 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0623\\u0646 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0648\\u0627\\u0644\\u0627\\u0647\\u062a\\u0645\\u0627\\u0645 \\u0628\\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0645\\u0647\\u0645\\u0627\\u0646 \\u0644\\u0644\\u063a\\u0627\\u064a\\u0629 \\u0644\\u0644\\u0633\\u0645\\u0627\\u062d \\u0644\\u0646\\u0627 \\u0628\\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0623\\u0641\\u0636\\u0644 \\u0627\\u0644\\u0646\\u062a\\u0627\\u0626\\u062c \\u0627\\u0644\\u0645\\u0645\\u0643\\u0646\\u0629 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0632\\u062f\\u0647\\u0631 \\u0641\\u064a \\u0628\\u064a\\u0626\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062a\\u063a\\u064a\\u0631 \\u0648\\u0646\\u062a\\u0648\\u0642\\u0639 \\u0645\\u0646 \\u062c\\u0645\\u064a\\u0639 \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0623\\u0646 \\u064a\\u0641\\u0639\\u0644\\u0648\\u0627 \\u0627\\u0644\\u0634\\u064a\\u0621 \\u0646\\u0641\\u0633\\u0647.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; color: rgb(0, 0, 0); outline: none; -webkit-font-smoothing: antialiased;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0641\\u0631\\u064a\\u0642 \\u0628\\u0639\\u064a\\u062f \\u062a\\u0645\\u0627\\u0645\\u064b\\u0627 \\u0648\\u0646\\u062d\\u0628 \\u0627\\u0644\\u0645\\u0631\\u0648\\u0646\\u0629 \\u0648\\u0627\\u0644\\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0623\\u062a\\u064a \\u0645\\u0639\\u0647\\u0627.<\\/span><\\/font><\\/h5><\\/div>\"}','3 years','{\"en_US\":\"Senior UI Designer\",\"ar\":\"\\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0635\\u0648\\u0631\"}','0','5','1','{\"en_US\":\"Dhanmondi, Dhaka\",\"ar\":\"\\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0635\\u0648\\u0631\"}','{\"en_US\":\"Bender Bernard Traders\",\"ar\":\"\\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0635\\u0648\\u0631\"}',75000,'196','2022-12-15','on',18,1,'2022-11-07 05:04:26','2022-11-12 10:51:42'),
	(14,3,'{\"en\":\"Senior UI Designer\",\"en_US\":\"Senior UI UX Designer\",\"ar\":\"\\u0645\\u0635\\u0645\\u0645 \\u0648\\u0627\\u062c\\u0647\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0627\\u0644\\u0623\\u0648\\u0644\"}','senior-ui-designer-6','{\"en\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Full Job Description<\\/h5><div class=\\\"heading mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Quality Reviewer<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Insurance Inspection Underwriting<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Full-time opportunities available<\\/p><\\/div><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Millennium Information Services is growing! We are a leading national provider of property inspection services and innovative process management solutions for property and casualty insurance companies.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Opportunity:<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We are looking for detail-oriented individuals to review and process exterior &amp; interior residential property inspections on either a full or part-time basis. This is a work from home position requiring a Windows computer and high-speed internet. Training will be done by webinar.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">We offer $3,000 per month depending on experience. Experience working in the property insurance industry preferred, however we will train.<\\/p><p class=\\\"mb-30\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">Description:<\\/p><p style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 0px; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto; line-height: 1.6;\\\">The Quality Reviewer\\u2019s primary focus is to review photographs and inspector reports to verify property condition, building type and materials, the home\\u2019s footprint, and any visible hazards before submitting the completed inspection to the client.<\\/p><\\/div><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); color: var(--heading-color);\\\">Recruitment<\\/h5><ul class=\\\"listing\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are obsessed with growth, innovation, staying ahead of the trends, and making sure our clients get results.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We love marketing and constantly taking our skills to the next level.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe in giving our team members ownership of their accounts and having the ability to take charge in making an impact for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe communication, attention to detail, and organization are super important to allow us to get the best results possible for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We thrive in rapidly changing environments and we expect all our team members to do the same.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are a fully remote team and love the flexibility &amp; freedom that comes with it.<\\/li><li><\\/li><\\/ul><\\/div>\",\"en_US\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><h5 class=\\\"title\\\" style=\\\"box-sizing: border-box; margin-top: 0px; margin-bottom: 30px; font-weight: 600; line-height: 1.2; font-size: 24px; text-shadow: none; font-family: var(--heading-font); outline: none; -webkit-font-smoothing: antialiased; color: var(--heading-color);\\\">Full Job Description<\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><div class=\\\"heading mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><p style=\\\"margin-bottom: 0px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">Quality Reviewer<\\/p><p style=\\\"margin-bottom: 0px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">Insurance Inspection Underwriting<\\/p><p style=\\\"margin-bottom: 0px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">Full-time opportunities available<\\/p><\\/div><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">Millennium Information Services is growing! We are a leading national provider of property inspection services and innovative process management solutions for property and casualty insurance companies.<\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">Opportunity:<\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">We are looking for detail-oriented individuals to review and process exterior &amp; interior residential property inspections on either a full or part-time basis. This is a work from home position requiring a Windows computer and high-speed internet. Training will be done by webinar.<\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">We offer $3,000 per month depending on experience. Experience working in the property insurance industry preferred, however we will train.<\\/p><p class=\\\"mb-30\\\" style=\\\"margin-bottom: 30px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">Description:<\\/p><p style=\\\"margin-bottom: 0px; line-height: 1.6; outline: none; -webkit-font-smoothing: antialiased; color: var(--paragraph-color); font-family: var(--body-font); hyphens: auto;\\\">The Quality Reviewer\\u2019s primary focus is to review photographs and inspector reports to verify property condition, building type and materials, the home\\u2019s footprint, and any visible hazards before submitting the completed inspection to the client.<\\/p><\\/div><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 30px; font-weight: 600; font-size: 24px; font-family: var(--heading-font); outline: none; -webkit-font-smoothing: antialiased; color: var(--heading-color);\\\">Recruitment<\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><div class=\\\"description mb-50\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 50px; color: rgb(113, 113, 113); font-family: Lato, sans-serif;\\\"><ul class=\\\"listing\\\" style=\\\"padding: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; outline: none; -webkit-font-smoothing: antialiased;\\\"><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are obsessed with growth, innovation, staying ahead of the trends, and making sure our clients get results.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We love marketing and constantly taking our skills to the next level.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe in giving our team members ownership of their accounts and having the ability to take charge in making an impact for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We believe communication, attention to detail, and organization are super important to allow us to get the best results possible for our clients.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We thrive in rapidly changing environments and we expect all our team members to do the same.<\\/li><li class=\\\"listItems\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; list-style: disc; margin-left: 15px; margin-bottom: 26px;\\\">We are a fully remote team and love the flexibility &amp; freedom that comes with it.<\\/li><li><\\/li><\\/ul><\\/div><\\/h5><\\/div>\",\"ar\":\"<div class=\\\"description mb-40\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 40px;\\\"><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0627\\u0644\\u0648\\u0635\\u0641 \\u0627\\u0644\\u0648\\u0638\\u064a\\u0641\\u064a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0645\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0625\\u0643\\u062a\\u062a\\u0627\\u0628 \\u0641\\u062d\\u0635 \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0627\\u0644\\u0641\\u0631\\u0635 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0628\\u062f\\u0648\\u0627\\u0645 \\u0643\\u0627\\u0645\\u0644<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0634\\u0631\\u0643\\u0629 \\u0645\\u064a\\u0644\\u064a\\u0646\\u064a\\u0648\\u0645 \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0622\\u062e\\u0630\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0646\\u0645\\u0648! \\u0646\\u062d\\u0646 \\u0645\\u0632\\u0648\\u062f \\u0648\\u0637\\u0646\\u064a \\u0631\\u0627\\u0626\\u062f \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0641\\u062d\\u0635 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0648\\u062d\\u0644\\u0648\\u0644 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u062a\\u0643\\u0631\\u0629 \\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0636\\u062f \\u0627\\u0644\\u062d\\u0648\\u0627\\u062f\\u062b.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0641\\u0631\\u0635\\u0629:<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0623\\u0641\\u0631\\u0627\\u062f \\u0645\\u0647\\u062a\\u0645\\u064a\\u0646 \\u0628\\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0648\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062a\\u0641\\u062a\\u064a\\u0634 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0627\\u0644\\u0633\\u0643\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0631\\u062c\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0627\\u062e\\u0644\\u064a\\u0629 \\u0625\\u0645\\u0627 \\u0639\\u0644\\u0649 \\u0623\\u0633\\u0627\\u0633 \\u0627\\u0644\\u062a\\u0641\\u0631\\u063a \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644 \\u0623\\u0648 \\u0627\\u0644\\u062c\\u0632\\u0626\\u064a. \\u0647\\u0630\\u0627 \\u0639\\u0645\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u064a\\u062a\\u0637\\u0644\\u0628 \\u062c\\u0647\\u0627\\u0632 \\u0643\\u0645\\u0628\\u064a\\u0648\\u062a\\u0631 \\u064a\\u0639\\u0645\\u0644 \\u0628\\u0646\\u0638\\u0627\\u0645 Windows \\u0648\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0639\\u0627\\u0644\\u064a \\u0627\\u0644\\u0633\\u0631\\u0639\\u0629. \\u0633\\u064a\\u062a\\u0645 \\u0627\\u0644\\u062a\\u062f\\u0631\\u064a\\u0628 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u0627\\u0644\\u0646\\u062f\\u0648\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0642\\u062f\\u0645 3000 \\u062f\\u0648\\u0644\\u0627\\u0631 \\u0634\\u0647\\u0631\\u064a\\u064b\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062e\\u0628\\u0631\\u0629. \\u064a\\u0641\\u0636\\u0644 \\u062e\\u0628\\u0631\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644 \\u0641\\u064a \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u060c \\u0648\\u0644\\u0643\\u0646\\u0646\\u0627 \\u0633\\u0646\\u062a\\u062f\\u0631\\u0628.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0648\\u0635\\u0641:<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u064a\\u0646\\u0635\\u0628 \\u0627\\u0644\\u062a\\u0631\\u0643\\u064a\\u0632 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0635\\u0648\\u0631 \\u0648\\u062a\\u0642\\u0627\\u0631\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0641\\u062a\\u0634 \\u0644\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u062d\\u0627\\u0644\\u0629 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0648\\u0646\\u0648\\u0639 \\u0627\\u0644\\u0645\\u0628\\u0646\\u0649 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0627\\u062f \\u0648\\u0628\\u0635\\u0645\\u0629 \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u0648\\u0623\\u064a \\u0645\\u062e\\u0627\\u0637\\u0631 \\u0645\\u0631\\u0626\\u064a\\u0629 \\u0642\\u0628\\u0644 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u0641\\u062d\\u0635 \\u0627\\u0644\\u0645\\u0643\\u062a\\u0645\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u062a\\u0648\\u0638\\u064a\\u0641<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0647\\u0648\\u0648\\u0633\\u0648\\u0646 \\u0628\\u0627\\u0644\\u0646\\u0645\\u0648 \\u0648\\u0627\\u0644\\u0627\\u0628\\u062a\\u0643\\u0627\\u0631 \\u0648\\u0627\\u0644\\u0628\\u0642\\u0627\\u0621 \\u0641\\u064a \\u0637\\u0644\\u064a\\u0639\\u0629 \\u0627\\u0644\\u0627\\u062a\\u062c\\u0627\\u0647\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u062d\\u0635\\u0648\\u0644 \\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0646\\u062a\\u0627\\u0626\\u062c.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u062d\\u0628 \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642 \\u0648\\u0646\\u0646\\u0642\\u0644 \\u0645\\u0647\\u0627\\u0631\\u0627\\u062a\\u0646\\u0627 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0645\\u0646\\u062d \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0645\\u0644\\u0643\\u064a\\u0629 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a\\u0647\\u0645 \\u0648\\u0627\\u0644\\u0642\\u062f\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u062a\\u062d\\u0645\\u0644 \\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0629 \\u0641\\u064a \\u0625\\u062d\\u062f\\u0627\\u062b \\u062a\\u0623\\u062b\\u064a\\u0631 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0623\\u0646 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0648\\u0627\\u0644\\u0627\\u0647\\u062a\\u0645\\u0627\\u0645 \\u0628\\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0645\\u0647\\u0645\\u0627\\u0646 \\u0644\\u0644\\u063a\\u0627\\u064a\\u0629 \\u0644\\u0644\\u0633\\u0645\\u0627\\u062d \\u0644\\u0646\\u0627 \\u0628\\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0623\\u0641\\u0636\\u0644 \\u0627\\u0644\\u0646\\u062a\\u0627\\u0626\\u062c \\u0627\\u0644\\u0645\\u0645\\u0643\\u0646\\u0629 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0646\\u0632\\u062f\\u0647\\u0631 \\u0641\\u064a \\u0628\\u064a\\u0626\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062a\\u063a\\u064a\\u0631 \\u0648\\u0646\\u062a\\u0648\\u0642\\u0639 \\u0645\\u0646 \\u062c\\u0645\\u064a\\u0639 \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0623\\u0646 \\u064a\\u0641\\u0639\\u0644\\u0648\\u0627 \\u0627\\u0644\\u0634\\u064a\\u0621 \\u0646\\u0641\\u0633\\u0647.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px;\\\"><font color=\\\"#717171\\\" face=\\\"Lato, sans-serif\\\"><span style=\\\"font-size: 24px;\\\">\\u0646\\u062d\\u0646 \\u0641\\u0631\\u064a\\u0642 \\u0628\\u0639\\u064a\\u062f \\u062a\\u0645\\u0627\\u0645\\u064b\\u0627 \\u0648\\u0646\\u062d\\u0628 \\u0627\\u0644\\u0645\\u0631\\u0648\\u0646\\u0629 \\u0648\\u0627\\u0644\\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0623\\u062a\\u064a \\u0645\\u0639\\u0647\\u0627.<\\/span><\\/font><\\/h5><\\/div>\"}','3 years','{\"en_US\":\"Police Officer\",\"ar\":\"\\u0627\\u0644\\u062a\\u0648\\u0642\\u064a\\u0639 \\u0641\\u0631\\u0627\\u0646\\u0633\\u064a\\u0633\"}','0','5','1','{\"en_US\":\"Capital do Pa\\u00eds\",\"ar\":\"\\u0645\\u0635\\u0645\\u0645 \\u0648\\u0627\\u062c\\u0647\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0627\\u0644\\u0623\\u0648\\u0644\"}','{\"en_US\":\"Demo Company\",\"ar\":\"\\u0645\\u0635\\u0645\\u0645 \\u0648\\u0627\\u062c\\u0647\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0627\\u0644\\u0623\\u0648\\u0644\"}',75000,'196','2022-12-15','on',18,1,'2022-11-07 12:10:12','2022-11-12 10:51:04')");
        }
    }
}
