<?php

namespace Database\Seeders\Tenant\ModuleData\Event;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class EventSeed
{

    public static function execute()
    {

        if (!Schema::hasTable('events')) {

            Schema::create('events', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('category_id');
                $table->text('title');
                $table->text('slug')->nullable();
                $table->longText('content');
                $table->string('date');
                $table->string('time');
                $table->bigInteger('cost');
                $table->bigInteger('total_ticket');
                $table->bigInteger('available_ticket')->nullable();
                $table->string('image')->nullable();
                $table->string('organizer')->nullable();
                $table->string('organizer_email')->nullable();
                $table->string('organizer_phone')->nullable();
                $table->text('venue_location')->nullable();
                $table->boolean('status')->default(1);
                $table->timestamps();
            });

        }


        $package = tenant()->user()->first()?->payment_log()->first()?->package()->first() ?? [];
        $all_features = $package->plan_features ?? [];

        $payment_log = tenant()->user()->first()?->payment_log()?->first() ?? [];
        if(empty($all_features) && $payment_log->status != 'trial'){
            return;
        }

        $check_feature_name = $all_features->pluck('feature_name')->toArray();

        if (in_array('event', $check_feature_name)) {

            DB::statement("INSERT INTO `events` (`id`, `category_id`, `title`, `slug`, `content`, `date`, `time`, `cost`, `total_ticket`, `available_ticket`, `image`, `organizer`, `organizer_email`, `organizer_phone`, `venue_location`, `status`, `created_at`, `updated_at`)
VALUES
	(1,2,'{\"en_US\":\"Mistaken idea of denouncing pleasure and praising\",\"ar\":\"\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\"}','mistaken-idea-of-denouncing-pleasure-and-praising-1','{\"en_US\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/span><\\/font><\\/h5>\",\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u0627<\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629<\\/p><p><br><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/p><p><br><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/p><p><br><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/p><p><br><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/p>\"}','2023-09-14','09:30 AM',50,57,NULL,'172','Nippon group','betexo@mailinator.com','+1 (977) 785-3536','Dhaka',1,'2022-10-24 11:02:13','2022-11-10 07:52:55'),
	(2,1,'{\"en_US\":\"International Designer and Developer meetup 2022\",\"ar\":\"\\u0644\\u0642\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0635\\u0645\\u0645\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0637\\u0648\\u0631\\u064a\\u0646 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u064a\\u0646\"}','international-designer-and-developer-meetup-2031','{\"en_US\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px; font-weight: 600; font-size: 18px; font-family: var(--heading-font); color: var(--heading-color);\\\">We are very much greatful<\\/h5><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"ar\":\"<p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u0627<\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629<\\/p><p><br><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/p><p><br><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/p><p><br><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/p><p><br><\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/p>\"}','2023-07-12','03:00 PM',46,200,NULL,'170','Pran fruto','kotysegoly@mailinator.com','+1 (372) 798-4313','Mirpur',1,'2022-10-24 11:05:56','2022-11-10 07:52:44'),
	(9,1,'{\"en\":\"International Designer and Developer meetup 2022\",\"en_US\":\"Your little effort help us to change big community life\",\"ar\":\"\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629\"}','your-little-effort-help-us-to-change-big-community-life-1','{\"en\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px; font-weight: 600; font-size: 18px; font-family: var(--heading-font); color: var(--heading-color);\\\">We are very much greatful<\\/h5><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"en_US\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px; font-weight: 600; font-size: 18px; font-family: var(--heading-font); color: var(--heading-color);\\\">We are very much greatful<\\/h5><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"ar\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u0627<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5>\"}','2022-12-29','04:30 PM',20,150,NULL,'166','Pran fruto','kotysegoly@mailinator.com','+1 (372) 798-4313','Chittagong',1,'2022-10-24 13:32:13','2022-10-25 04:14:20'),
	(10,1,'{\"en\":\"Your little effort help us to change big community life\",\"en_US\":\"We are very much greatful to you for your event\",\"ar\":\"\\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647\"}','your-little-effort-help-us-to-change-big-community-life-4','{\"en\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px; font-weight: 600; font-size: 18px; font-family: var(--heading-font); color: var(--heading-color);\\\">We are very much greatful<\\/h5><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"en_US\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px; font-weight: 600; font-size: 18px; font-family: var(--heading-font); color: var(--heading-color);\\\">We are very much greatful<\\/h5><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"ar\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u0627<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5>\"}','2023-09-27','04:30 PM',65,400,NULL,'164','Natao','kotysegoly@mailinator.com','+1 (372) 798-4313','Dhaka',1,'2022-10-24 13:33:42','2022-11-10 07:52:33'),
	(11,2,'{\"en\":\"Blood donation for flood victim\",\"en_US\":\"Author Ocean Vuong on being generous in your work\",\"ar\":\"\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\"}','author-ocean-vuong-on-being-generous-in-your-work-3','{\"en\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px; font-weight: 600; font-size: 18px; font-family: var(--heading-font); color: var(--heading-color);\\\">We are very much greatful<\\/h5><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"en_US\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px; font-weight: 600; font-size: 18px; font-family: var(--heading-font); color: var(--heading-color);\\\">We are very much greatful<\\/h5><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"ar\":\"<h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u0627 \\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629 \\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629. \\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629. \\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629. \\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u0627<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"margin-bottom: 17px; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5>\"}','2024-02-01','11:30 AM',15,210,NULL,'167','Nippon group','betexo@mailinator.com','+1 (977) 785-3536','Sylhet',1,'2022-10-24 13:39:15','2022-11-10 07:52:21'),
	(12,2,'{\"en\":\"Blood donation for flood victim\",\"en_US\":\"Denouncing pleasure and praising pain was born\",\"ar\":\"\\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629\"}','denouncing-pleasure-and-praising-pain-was-born-2','{\"en\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px; font-weight: 600; font-size: 18px; font-family: var(--heading-font); color: var(--heading-color);\\\">We are very much greatful<\\/h5><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"en_US\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px; font-weight: 600; font-size: 18px; font-family: var(--heading-font); color: var(--heading-color);\\\">We are very much greatful<\\/h5><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"ar\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u0627\\r\\n\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629\\r\\n\\r\\n\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.\\r\\n\\r\\n\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.\\r\\n\\r\\n\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.\\r\\n\\r\\n\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<meta http-equiv=\\\"Content-Type\\\" content=\\\"text\\/html;charset=UTF-8\\\"><\\/h5><h5 class=\\\"title\\\" style=\\\"box-sizing: border-box; margin-top: 0px; margin-bottom: 17px; font-weight: 500; line-height: 1.2; font-size: 1rem; text-shadow: none; font-family: ubuntu-medium, sans-serif; color: rgb(0, 0, 0); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\" style=\\\"box-sizing: border-box;\\\"><span style=\\\"box-sizing: border-box; text-shadow: none; font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u0627<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"box-sizing: border-box; margin-top: 0px; margin-bottom: 17px; font-weight: 500; line-height: 1.2; font-size: 1rem; text-shadow: none; font-family: ubuntu-medium, sans-serif; color: rgb(0, 0, 0); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\" style=\\\"box-sizing: border-box;\\\"><span style=\\\"box-sizing: border-box; text-shadow: none; font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"box-sizing: border-box; margin-top: 0px; margin-bottom: 17px; font-weight: 500; line-height: 1.2; font-size: 1rem; text-shadow: none; font-family: ubuntu-medium, sans-serif; color: rgb(0, 0, 0); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\" style=\\\"box-sizing: border-box;\\\"><span style=\\\"box-sizing: border-box; text-shadow: none; font-size: 18px;\\\"><br style=\\\"box-sizing: border-box;\\\"><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"box-sizing: border-box; margin-top: 0px; margin-bottom: 17px; font-weight: 500; line-height: 1.2; font-size: 1rem; text-shadow: none; font-family: ubuntu-medium, sans-serif; color: rgb(0, 0, 0); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\" style=\\\"box-sizing: border-box;\\\"><span style=\\\"box-sizing: border-box; text-shadow: none; font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"box-sizing: border-box; margin-top: 0px; margin-bottom: 17px; font-weight: 500; line-height: 1.2; font-size: 1rem; text-shadow: none; font-family: ubuntu-medium, sans-serif; color: rgb(0, 0, 0); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\" style=\\\"box-sizing: border-box;\\\"><span style=\\\"box-sizing: border-box; text-shadow: none; font-size: 18px;\\\"><br style=\\\"box-sizing: border-box;\\\"><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"box-sizing: border-box; margin-top: 0px; margin-bottom: 17px; font-weight: 500; line-height: 1.2; font-size: 1rem; text-shadow: none; font-family: ubuntu-medium, sans-serif; color: rgb(0, 0, 0); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\" style=\\\"box-sizing: border-box;\\\"><span style=\\\"box-sizing: border-box; text-shadow: none; font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"box-sizing: border-box; margin-top: 0px; margin-bottom: 17px; font-weight: 500; line-height: 1.2; font-size: 1rem; text-shadow: none; font-family: ubuntu-medium, sans-serif; color: rgb(0, 0, 0); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\" style=\\\"box-sizing: border-box;\\\"><span style=\\\"box-sizing: border-box; text-shadow: none; font-size: 18px;\\\"><br style=\\\"box-sizing: border-box;\\\"><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"box-sizing: border-box; margin-top: 0px; margin-bottom: 17px; font-weight: 500; line-height: 1.2; font-size: 1rem; text-shadow: none; font-family: ubuntu-medium, sans-serif; color: rgb(0, 0, 0); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\" style=\\\"box-sizing: border-box;\\\"><span style=\\\"box-sizing: border-box; text-shadow: none; font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"box-sizing: border-box; margin-top: 0px; margin-bottom: 17px; font-weight: 500; line-height: 1.2; font-size: 1rem; text-shadow: none; font-family: ubuntu-medium, sans-serif; color: rgb(0, 0, 0); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\" style=\\\"box-sizing: border-box;\\\"><span style=\\\"box-sizing: border-box; text-shadow: none; font-size: 18px;\\\"><br style=\\\"box-sizing: border-box;\\\"><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"box-sizing: border-box; margin-top: 0px; margin-bottom: 17px; font-weight: 500; line-height: 1.2; font-size: 1rem; text-shadow: none; font-family: ubuntu-medium, sans-serif; color: rgb(0, 0, 0); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; outline: none; -webkit-font-smoothing: antialiased;\\\"><font face=\\\"sans-serif\\\" style=\\\"box-sizing: border-box;\\\"><span style=\\\"box-sizing: border-box; text-shadow: none; font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5>\"}','2023-09-21','09:30 AM',50,57,NULL,'163','Nippon group','betexo@mailinator.com','+1 (977) 785-3536','Sylhet',1,'2022-10-24 13:40:05','2022-11-10 07:52:09'),
	(13,2,'{\"en\":\"Blood donation for flood victim\",\"en_US\":\"Praising pain was born and I will give you a complete\",\"ar\":\"\\u0648\\u0644\\u062f\\u062a \\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u0648\\u0633\\u0623\\u0639\\u0637\\u064a\\u0643 \\u0643\\u0627\\u0645\\u0644\\u0629\"}','praising-pain-was-born-and-i-will-give-you-a-complete-2','{\"en\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px; font-weight: 600; font-size: 18px; font-family: var(--heading-font); color: var(--heading-color);\\\">We are very much greatful<\\/h5><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"en_US\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px; font-weight: 600; font-size: 18px; font-family: var(--heading-font); color: var(--heading-color);\\\">We are very much greatful<\\/h5><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p><p class=\\\"pera\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 30px; color: rgb(145, 145, 145); font-family: &quot;Open Sans&quot;, sans-serif; hyphens: auto; line-height: 1.6; font-size: 16px;\\\">We are very much greatful to you for your donation. Your little effort help us to change big community life I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual . I must explain to you how all this mistaken idea of denouncing pleasure .<\\/p>\",\"ar\":\"<h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u0627<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0627\\u0644\\u062a\\u0639\\u0627\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u0644\\u0639\\u0638\\u064a\\u0645. \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u0629 \\u060c \\u0635\\u0627\\u0646\\u0639 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0631\\u0641\\u0636 \\u0623\\u0648 \\u064a\\u0643\\u0631\\u0647 \\u0623\\u0648 \\u064a\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0646\\u0641\\u0633\\u0647\\u0627 \\u060c \\u0644\\u0623\\u0646\\u0647\\u0627 \\u0645\\u062a\\u0639\\u0629 \\u060c \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0623\\u0646 \\u0623\\u0648\\u0644\\u0626\\u0643 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u0644\\u0627 \\u064a\\u0639\\u0631\\u0641\\u0648\\u0646 \\u0643\\u064a\\u0641 \\u064a\\u0633\\u0639\\u0648\\u0646 \\u0648\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0628\\u0639\\u0642\\u0644\\u0627\\u0646\\u064a\\u0629<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\"><br><\\/span><\\/font><\\/h5><h5 class=\\\"title\\\" style=\\\"outline: none; -webkit-font-smoothing: antialiased; margin-bottom: 17px;\\\"><font face=\\\"sans-serif\\\"><span style=\\\"font-size: 18px;\\\">\\u0646\\u062d\\u0646 \\u0645\\u0645\\u062a\\u0646\\u0648\\u0646 \\u062c\\u062f\\u064b\\u0627 \\u0644\\u0643 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0631\\u0639\\u0643. \\u064a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0645\\u062c\\u0647\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0635\\u063a\\u064a\\u0631 \\u0641\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631\\u0629 \\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0648\\u0644\\u062f\\u062a \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0645\\u062b\\u0644\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0629 \\u0648\\u0645\\u062f\\u062d \\u0627\\u0644\\u0623\\u0644\\u0645 \\u060c \\u0648\\u0633\\u0623\\u0642\\u062f\\u0645 \\u0644\\u0643 \\u0648\\u0635\\u0641\\u064b\\u0627 \\u0643\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0646\\u0638\\u0627\\u0645 \\u060c \\u0648\\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631. \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u0623\\u0634\\u0631\\u062d \\u0644\\u0643 \\u0643\\u064a\\u0641 \\u0643\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0637\\u0626\\u0629 \\u0644\\u0644\\u062a\\u0646\\u062f\\u064a\\u062f \\u0628\\u0627\\u0644\\u0644\\u0630\\u0629.<\\/span><\\/font><\\/h5>\"}','2023-06-21','11:00 AM',50,57,NULL,'172','Nippon group','betexo@mailinator.com','+1 (977) 785-3536','Khulna',1,'2022-10-25 04:08:30','2022-11-10 07:51:58')");
        }
    }
}
