<?php

namespace Database\Seeders\Tenant;

use App\Helpers\SanitizeInput;
use App\Mail\TenantCredentialMail;
use App\Models\Admin;
use App\Models\Language;
use App\Models\Menu;
use App\Models\Page;
use App\Models\PageBuilder;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;

class MediaSeed extends Seeder
{

    public static function run()
    {
        $source_dir = 'assets/tenant/seeder-demo-assets';
        $destination_dir = 'assets/tenant/uploads/media-uploader/'.tenant()->id;
        File::copyDirectory($source_dir,$destination_dir);

       DB::statement("INSERT INTO `media_uploaders` (`id`, `title`, `path`, `alt`, `size`, `user_type`, `user_id`, `dimensions`, `created_at`, `updated_at`)
VALUES
	(1,'bg.png','bg3bba0aa7-27fb-4199-9f31-f2ee613e439c.png',NULL,NULL,0,1,NULL,'2022-08-10 13:05:30','2022-08-10 13:05:30'),
	(5,'donation-logo.png','donation-logo1660125461.png',NULL,'2.68 KB',0,1,'141 x 29 pixels','2022-08-10 15:57:41','2022-08-10 15:57:41'),
	(6,'donation-h1FooterLogo.png','donation-h1footerlogo1660125461.png',NULL,'3.66 KB',0,1,'204 x 40 pixels','2022-08-10 15:57:41','2022-08-10 15:57:41'),
	(11,'76729750.jpg','767297501660193349.jpg',NULL,'17.06 KB',0,1,'720 x 540 pixels','2022-08-11 04:49:09','2022-08-11 04:49:09'),
	(12,'large-pexels-keira-burton-6147207-min1614257627.jpg','large-pexels-keira-burton-6147207-min16142576271661679369.jpg',NULL,'92.32 KB',0,1,'740 x 473 pixels','2022-08-28 09:36:09','2022-08-28 09:36:09'),
	(13,'large-pexels-james-frid-901931-min1613804115.jpg','large-pexels-james-frid-901931-min16138041151661679369.jpg',NULL,'92.64 KB',0,1,'740 x 493 pixels','2022-08-28 09:36:09','2022-08-28 09:36:09'),
	(14,'large-pexels-yogendra-singh-2324637-min1613804155.jpg','large-pexels-yogendra-singh-2324637-min16138041551661679369.jpg',NULL,'122.29 KB',0,1,'740 x 493 pixels','2022-08-28 09:36:09','2022-08-28 09:36:09'),
	(15,'large-pexels-zen-chung-5528986-min1614100245.jpg','large-pexels-zen-chung-5528986-min16141002451661679369.jpg',NULL,'156.78 KB',0,1,'740 x 493 pixels','2022-08-28 09:36:09','2022-08-28 09:36:09'),
	(16,'large-pexels-zhang-kaiyv-3603455-min1613804134.jpg','large-pexels-zhang-kaiyv-3603455-min16138041341661679369.jpg',NULL,'100.65 KB',0,1,'740 x 493 pixels','2022-08-28 09:36:09','2022-08-28 09:36:09'),
	(17,'large-screenshot-20211007-114624-facebook1634103241.jpg','large-screenshot-20211007-114624-facebook16341032411661679369.jpg',NULL,'196.45 KB',0,1,'740 x 1521 pixels','2022-08-28 09:36:09','2022-08-28 09:36:09'),
	(18,'pexels-andrea-piacquadio-3791664-min1614257478.jpg','pexels-andrea-piacquadio-3791664-min16142574781661679369.jpg',NULL,'282.62 KB',0,1,'1920 x 1280 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(19,'pexels-denniz-futalan-1344275-min1614101248.jpg','pexels-denniz-futalan-1344275-min16141012481661679369.jpg',NULL,'690.86 KB',0,1,'1920 x 1279 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(20,'pexels-marius-venter-1659437-min1614257528.jpg','pexels-marius-venter-1659437-min16142575281661679370.jpg',NULL,'565.07 KB',0,1,'1920 x 1281 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(21,'pexels-mart-production-81062611627279410.jpg','pexels-mart-production-810626116272794101661679370.jpg',NULL,'409.25 KB',0,1,'1920 x 1280 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(23,'pexels-plato-terentev-5909876-min1614101301.jpg','pexels-plato-terentev-5909876-min16141013011661679370.jpg',NULL,'787.49 KB',0,1,'1920 x 1280 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(24,'thumb-header-bg-min1627064076.jpg','thumb-header-bg-min16270640761661679370.jpg',NULL,'11.46 KB',0,1,'150 x 150 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(25,'thumb-logo8-6-1316481628270931.png','thumb-logo8-6-13164816282709311661679370.png',NULL,'12.16 KB',0,1,'150 x 150 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(26,'thumb-pexels-james-frid-901931-min1613804115.jpg','thumb-pexels-james-frid-901931-min16138041151661679370.jpg',NULL,'10.15 KB',0,1,'150 x 150 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(27,'thumb-pexels-rodnae-productions-6646875-min1613803411.jpg','thumb-pexels-rodnae-productions-6646875-min16138034111661679370.jpg',NULL,'7.77 KB',0,1,'150 x 150 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(28,'thumb-pexels-roman-carey-734658-min1613803322.jpg','thumb-pexels-roman-carey-734658-min16138033221661679370.jpg',NULL,'11.04 KB',0,1,'150 x 150 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(29,'thumb-bg1614700521.jpg','thumb-bg16147005211661679370.jpg',NULL,'13.76 KB',0,1,'150 x 150 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(30,'thumb-pexels-suraphat-nueaon-933622-min1613803347.jpg','thumb-pexels-suraphat-nueaon-933622-min16138033471661679370.jpg',NULL,'12.52 KB',0,1,'150 x 150 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(31,'thumb-pexels-sergio-omassi-1058068-min1613804051.jpg','thumb-pexels-sergio-omassi-1058068-min16138040511661679370.jpg',NULL,'9.55 KB',0,1,'150 x 150 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(32,'thumb-pexels-zen-chung-5528986-min1614100245.jpg','thumb-pexels-zen-chung-5528986-min16141002451661679370.jpg',NULL,'14.65 KB',0,1,'150 x 150 pixels','2022-08-28 09:36:10','2022-08-28 09:36:10'),
	(33,'event-listEvent4.jpg','event-listevent41661844964.jpg',NULL,'122.19 KB',0,1,'432 x 239 pixels','2022-08-30 07:36:04','2022-08-30 07:36:04'),
	(34,'donation-dosnationList9.jpg','donation-dosnationlist91661844964.jpg',NULL,'73.22 KB',0,1,'412 x 268 pixels','2022-08-30 07:36:04','2022-08-30 07:36:04'),
	(35,'donation-dosnationList8.jpg','donation-dosnationlist81661844964.jpg',NULL,'164.34 KB',0,1,'412 x 268 pixels','2022-08-30 07:36:04','2022-08-30 07:36:04'),
	(36,'donation-dosnationList7.jpg','donation-dosnationlist71661844964.jpg',NULL,'139.27 KB',0,1,'412 x 268 pixels','2022-08-30 07:36:04','2022-08-30 07:36:04'),
	(37,'donation-videoBg2.jpg','donation-videobg21661844964.jpg',NULL,'262.8 KB',0,1,'660 x 440 pixels','2022-08-30 07:36:04','2022-08-30 07:36:04'),
	(38,'donation-sectionBg1.png','donation-sectionbg11661844964.png',NULL,'558.6 KB',0,1,'1920 x 600 pixels','2022-08-30 07:36:04','2022-08-30 07:36:04'),
	(39,'donation-featuredImg2.jpg','donation-featuredimg21661853745.jpg',NULL,'32.87 KB',0,1,'230 x 240 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(40,'donation-featuredImg1.jpg','donation-featuredimg11661853745.jpg',NULL,'28.6 KB',0,1,'230 x 240 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(41,'donation-featuredImg3.jpg','donation-featuredimg31661853745.jpg',NULL,'31.69 KB',0,1,'230 x 240 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(42,'donation-featuredImg4.jpg','donation-featuredimg41661853745.jpg',NULL,'26.08 KB',0,1,'230 x 240 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(43,'donation-commentsUser1.jpg','donation-commentsuser11661853745.jpg',NULL,'1.59 KB',0,1,'40 x 40 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(44,'donation-dosnationList6.jpg','donation-dosnationlist61661853745.jpg',NULL,'35.75 KB',0,1,'412 x 268 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(45,'donation-dosnationList5.jpg','donation-dosnationlist51661853745.jpg',NULL,'61.16 KB',0,1,'412 x 268 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(46,'donation-dosnationList4.jpg','donation-dosnationlist41661853745.jpg',NULL,'48.13 KB',0,1,'412 x 268 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(47,'donation-dosnationList3.jpg','donation-dosnationlist31661853745.jpg',NULL,'35.75 KB',0,1,'412 x 268 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(48,'donation-videoBg.jpg','donation-videobg1661853745.jpg',NULL,'54.15 KB',0,1,'546 x 530 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(49,'donation-paymentUser1.jpg','donation-paymentuser11661853745.jpg',NULL,'4.32 KB',0,1,'80 x 80 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(50,'donation-details1.jpg','donation-details11661853745.jpg',NULL,'101.68 KB',0,1,'774 x 495 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(51,'donation-details2.jpg','donation-details21661853745.jpg',NULL,'67.42 KB',0,1,'774 x 495 pixels','2022-08-30 10:02:25','2022-08-30 10:02:25'),
	(52,'donation-blog3.jpg','donation-blog31661861725.jpg',NULL,'58.18 KB',0,1,'432 x 328 pixels','2022-08-30 12:15:25','2022-08-30 12:15:25'),
	(53,'donation-blog1.jpg','donation-blog11661861725.jpg',NULL,'100.77 KB',0,1,'432 x 328 pixels','2022-08-30 12:15:25','2022-08-30 12:15:25'),
	(54,'donation-blog2.jpg','donation-blog21661861725.jpg',NULL,'73.74 KB',0,1,'432 x 328 pixels','2022-08-30 12:15:25','2022-08-30 12:15:25'),
	(55,'event-client2.jpg','event-client21661863141.jpg',NULL,'4.4 KB',0,1,'40 x 40 pixels','2022-08-30 12:39:01','2022-08-30 12:39:01'),
	(56,'event-client3.jpg','event-client31661863141.jpg',NULL,'3.82 KB',0,1,'40 x 40 pixels','2022-08-30 12:39:01','2022-08-30 12:39:01'),
	(57,'event-client1.jpg','event-client11661863141.jpg',NULL,'4.13 KB',0,1,'40 x 40 pixels','2022-08-30 12:39:01','2022-08-30 12:39:01'),
	(58,'job-find-jobHolder3.jpg','job-find-jobholder31661863141.jpg',NULL,'3.17 KB',0,1,'40 x 40 pixels','2022-08-30 12:39:01','2022-08-30 12:39:01'),
	(59,'job-find-jobHolder4.jpg','job-find-jobholder41661863141.jpg',NULL,'3.64 KB',0,1,'40 x 40 pixels','2022-08-30 12:39:01','2022-08-30 12:39:01'),
	(60,'about-global1.jpg','about-global11661945943.jpg',NULL,'33.95 KB',0,1,'636 x 566 pixels','2022-08-31 11:39:03','2022-08-31 11:39:03'),
	(61,'about-global2.jpg','about-global21661945943.jpg',NULL,'68.46 KB',0,1,'636 x 566 pixels','2022-08-31 11:39:03','2022-08-31 11:39:03'),
	(62,'event-team2.jpg','event-team21661947220.jpg',NULL,'35.88 KB',0,1,'318 x 400 pixels','2022-08-31 12:00:20','2022-08-31 12:00:20'),
	(63,'event-team1.jpg','event-team11661947220.jpg',NULL,'29.87 KB',0,1,'318 x 400 pixels','2022-08-31 12:00:20','2022-08-31 12:00:20'),
	(64,'event-team3.jpg','event-team31661947220.png',NULL,'52.66 KB',0,1,'318 x 400 pixels','2022-08-31 12:00:20','2022-08-31 12:00:20'),
	(65,'event-team4.jpg','event-team41661947220.jpg',NULL,'28.37 KB',0,1,'318 x 400 pixels','2022-08-31 12:00:20','2022-08-31 12:00:20'),
	(66,'event-team5.jpg','event-team51661947220.jpg',NULL,'39.6 KB',0,1,'318 x 400 pixels','2022-08-31 12:00:20','2022-08-31 12:00:20'),
	(67,'article-listing-explore.jpg','article-listing-explore1662177277.jpg',NULL,'47.59 KB',0,1,'416 x 315 pixels','2022-09-03 03:54:37','2022-09-03 03:54:37'),
	(68,'about-global2.jpg','about-global21662177277.jpg',NULL,'68.46 KB',0,1,'636 x 566 pixels','2022-09-03 03:54:37','2022-09-03 03:54:37'),
	(69,'gallery-global2.jpg','gallery-global21662178414.jpg',NULL,'57.5 KB',0,1,'416 x 265 pixels','2022-09-03 04:13:34','2022-09-03 04:13:34'),
	(70,'missin-global1.jpg','missin-global11662179443.jpg',NULL,'55.8 KB',0,1,'856 x 424 pixels','2022-09-03 04:30:43','2022-09-03 04:30:43'),
	(71,'missin-global2.jpg','missin-global21662179443.jpg',NULL,'55.49 KB',0,1,'637 x 567 pixels','2022-09-03 04:30:43','2022-09-03 04:30:43'),
	(72,'job-find-brand2.png','job-find-brand21662206169.png',NULL,'2.85 KB',0,1,'140 x 40 pixels','2022-09-03 11:56:09','2022-09-03 11:56:09'),
	(73,'job-find-brand1.png','job-find-brand11662206169.png',NULL,'2.53 KB',0,1,'148 x 46 pixels','2022-09-03 11:56:09','2022-09-03 11:56:09'),
	(74,'job-find-brand3.png','job-find-brand31662206169.png',NULL,'3.34 KB',0,1,'139 x 46 pixels','2022-09-03 11:56:09','2022-09-03 11:56:09'),
	(75,'job-find-brand4.png','job-find-brand41662206169.png',NULL,'2.34 KB',0,1,'201 x 42 pixels','2022-09-03 11:56:09','2022-09-03 11:56:09'),
	(76,'job-find-brand5.png','job-find-brand51662206169.png',NULL,'3.21 KB',0,1,'184 x 42 pixels','2022-09-03 11:56:09','2022-09-03 11:56:09'),
	(77,'job-find-brand6.png','job-find-brand61662206169.png',NULL,'1.9 KB',0,1,'132 x 40 pixels','2022-09-03 11:56:09','2022-09-03 11:56:09'),
	(78,'gallery-global2.jpg','gallery-global21662460664.jpg',NULL,'57.5 KB',0,1,'416 x 265 pixels','2022-09-06 10:37:44','2022-09-06 10:37:44'),
	(79,'gallery-global1.jpg','gallery-global11662460664.jpg',NULL,'41.3 KB',0,1,'416 x 265 pixels','2022-09-06 10:37:44','2022-09-06 10:37:44'),
	(80,'gallery-global3.jpg','gallery-global31662460664.jpg',NULL,'68.75 KB',0,1,'856 x 554 pixels','2022-09-06 10:37:44','2022-09-06 10:37:44'),
	(81,'gallery-global4.jpg','gallery-global41662460664.jpg',NULL,'30.65 KB',0,1,'416 x 520 pixels','2022-09-06 10:37:44','2022-09-06 10:37:44'),
	(82,'gallery-global5.jpg','gallery-global51662460664.jpg',NULL,'46.91 KB',0,1,'416 x 248 pixels','2022-09-06 10:37:44','2022-09-06 10:37:44'),
	(83,'gallery-global6.jpg','gallery-global61662460664.jpg',NULL,'62.63 KB',0,1,'416 x 248 pixels','2022-09-06 10:37:44','2022-09-06 10:37:44'),
	(84,'gallery-global7.jpg','gallery-global71662460664.jpg',NULL,'21.04 KB',0,1,'416 x 520 pixels','2022-09-06 10:37:44','2022-09-06 10:37:44'),
	(85,'video-main-global1.jpg','video-main-global11662527451.jpg',NULL,'37.59 KB',0,1,'856 x 480 pixels','2022-09-07 05:10:51','2022-09-07 05:10:51'),
	(86,'Screenshot 2022-09-07 at 12.07.10 PM.png','screenshot-2022-09-07-at-120710-pm1662553263.png',NULL,'1.07 MB',0,1,'1404 x 835 pixels','2022-09-07 12:21:03','2022-09-07 12:21:03'),
	(87,'portfolio2.jpg','portfolio21662554379.png',NULL,'37.54 KB',0,1,'588 x 441 pixels','2022-09-07 12:39:39','2022-09-07 12:39:39'),
	(88,'portfolio3.jpg','portfolio31662554379.png',NULL,'53.72 KB',0,1,'588 x 441 pixels','2022-09-07 12:39:39','2022-09-07 12:39:39'),
	(89,'portfolio4.jpg','portfolio41662554379.png',NULL,'44.15 KB',0,1,'588 x 441 pixels','2022-09-07 12:39:39','2022-09-07 12:39:39'),
	(90,'thumb-b9760aea-2c2f-4340-90ef-a4b182cb19cf1654608599.jpg','thumb-b9760aea-2c2f-4340-90ef-a4b182cb19cf16546085991664706645.jpg',NULL,'14.03 KB',0,1,'200 x 200 pixels','2022-10-02 10:30:45','2022-10-02 10:30:45'),
	(91,'stjerome1.jpg','stjerome11665223040.jpg',NULL,'40.22 KB',1,1,'600 x 315 pixels','2022-10-08 09:57:20','2022-10-08 09:57:20'),
	(92,'563281ce79f36784620c206b58cad98b.jpg','563281ce79f36784620c206b58cad98b1665223040.jpg',NULL,'26.7 KB',1,1,'580 x 399 pixels','2022-10-08 09:57:20','2022-10-08 09:57:20'),
	(93,'76729750.jpg','767297501665223573.jpg',NULL,'17.06 KB',1,1,'720 x 540 pixels','2022-10-08 10:06:13','2022-10-08 10:06:13'),
	(94,'happy-smiling-geek-hipster-beard-man-cool-avatar-geek-man-avatar-104871313.jpeg','happy-smiling-geek-hipster-beard-man-cool-avatar-geek-man-avatar-1048713131665224416.jpg',NULL,'33.6 KB',1,2,'800 x 800 pixels','2022-10-08 10:20:16','2022-10-08 10:20:16'),
	(95,'services-global2.jpg','services-global21665566465.png',NULL,'50.27 KB',0,1,'416 x 277 pixels','2022-10-12 09:21:05','2022-10-12 09:21:05'),
	(96,'services-global1.jpg','services-global11665566465.jpg',NULL,'40.64 KB',0,1,'416 x 277 pixels','2022-10-12 09:21:05','2022-10-12 09:21:05'),
	(97,'services-global3.jpg','services-global31665566465.jpg',NULL,'41.97 KB',0,1,'416 x 277 pixels','2022-10-12 09:21:05','2022-10-12 09:21:05'),
	(98,'services-global4.jpg','services-global41665566465.jpg',NULL,'45.1 KB',0,1,'416 x 277 pixels','2022-10-12 09:21:05','2022-10-12 09:21:05'),
	(99,'servicesPopular-global1.jpg','servicespopular-global11665566465.jpg',NULL,'5.85 KB',0,1,'100 x 80 pixels','2022-10-12 09:21:05','2022-10-12 09:21:05'),
	(100,'servicesPopular-global2.jpg','servicespopular-global21665566465.jpg',NULL,'6.52 KB',0,1,'100 x 80 pixels','2022-10-12 09:21:05','2022-10-12 09:21:05'),
	(101,'servicesPopular-global3.jpg','servicespopular-global31665566465.jpg',NULL,'7.73 KB',0,1,'100 x 80 pixels','2022-10-12 09:21:05','2022-10-12 09:21:05'),
	(102,'servicesPopular-global4.jpg','servicespopular-global41665566465.jpg',NULL,'5.95 KB',0,1,'100 x 80 pixels','2022-10-12 09:21:06','2022-10-12 09:21:06'),
	(103,'servicesDiscription-global1.jpg','servicesdiscription-global11665566466.jpg',NULL,'43.66 KB',0,1,'856 x 549 pixels','2022-10-12 09:21:06','2022-10-12 09:21:06'),
	(104,'donation-heroBg2.jpg','donation-herobg21665645074.jpg',NULL,'58.2 KB',0,1,'1913 x 336 pixels','2022-10-13 07:11:14','2022-10-13 07:11:14'),
	(105,'donation-h1_heroBg.png','donation-h1-herobg1665645074.png',NULL,'239.07 KB',0,1,'1920 x 1000 pixels','2022-10-13 07:11:15','2022-10-13 07:11:15'),
	(106,'donation-hero-man1.jpg','donation-hero-man11665645193.jpg',NULL,'54.17 KB',0,1,'660 x 493 pixels','2022-10-13 07:13:13','2022-10-13 07:13:13'),
	(107,'donation-brand4.png','donation-brand41665655719.png',NULL,'2.47 KB',0,1,'231 x 41 pixels','2022-10-13 10:08:39','2022-10-13 10:08:39'),
	(108,'donation-brand5.png','donation-brand51665655719.png',NULL,'1.49 KB',0,1,'231 x 41 pixels','2022-10-13 10:08:39','2022-10-13 10:08:39'),
	(109,'donation-brand3.png','donation-brand31665655719.png',NULL,'2.64 KB',0,1,'232 x 41 pixels','2022-10-13 10:08:39','2022-10-13 10:08:39'),
	(110,'donation-brand2.png','donation-brand21665655719.png',NULL,'1.47 KB',0,1,'231 x 41 pixels','2022-10-13 10:08:39','2022-10-13 10:08:39'),
	(111,'donation-brand1.png','donation-brand11665655719.png',NULL,'2.86 KB',0,1,'231 x 41 pixels','2022-10-13 10:08:39','2022-10-13 10:08:39'),
	(112,'donation-videoBg.jpg','donation-videobg1665814550.jpg',NULL,'54.15 KB',0,1,'546 x 530 pixels','2022-10-15 06:15:50','2022-10-15 06:15:50'),
	(113,'donation-cat1.svg','donation-cat11665830660.svg',NULL,NULL,0,1,NULL,'2022-10-15 10:44:20','2022-10-15 10:44:20'),
	(114,'donation-cat2.svg','donation-cat21665830660.svg',NULL,NULL,0,1,NULL,'2022-10-15 10:44:20','2022-10-15 10:44:20'),
	(115,'donation-cat3.svg','donation-cat31665830660.svg',NULL,NULL,0,1,NULL,'2022-10-15 10:44:20','2022-10-15 10:44:20'),
	(116,'donation-featuredImg1.jpg','donation-featuredimg11665835175.jpg',NULL,'28.6 KB',0,1,'230 x 240 pixels','2022-10-15 11:59:35','2022-10-15 11:59:35'),
	(117,'donation-videoBg2.jpg','donation-videobg21665835253.jpg',NULL,'262.8 KB',0,1,'660 x 440 pixels','2022-10-15 12:00:53','2022-10-15 12:00:53'),
	(138,'5-56308_paytabs-logo-hd-png-download.png','5-56308-paytabs-logo-hd-png-download1666176525.png',NULL,'33.77 KB',0,1,'860 x 303 pixels','2022-10-19 10:48:45','2022-10-19 10:48:45'),
	(139,'zitopay_wallet.png','zitopay-wallet1666176525.png',NULL,'11.87 KB',0,1,'1024 x 512 pixels','2022-10-19 10:48:45','2022-10-19 10:48:45'),
	(140,'logo_facebook_dimension-912ae2521fe6b786a8c78a5cd1a7dfb31434c628a7d03f4377cbeb4707d6e305.png','logo-facebook-dimension-912ae2521fe6b786a8c78a5cd1a7dfb31434c628a7d03f4377cbeb4707d6e3051666176525.png',NULL,'15.13 KB',0,1,'1200 x 630 pixels','2022-10-19 10:48:45','2022-10-19 10:48:45'),
	(141,'cinetpay.jpeg','cinetpay1666176525.jpg',NULL,'9.03 KB',0,1,'400 x 400 pixels','2022-10-19 10:48:45','2022-10-19 10:48:45'),
	(142,'sqaure.png','sqaure1666176525.png',NULL,'4.66 KB',0,1,'960 x 420 pixels','2022-10-19 10:48:45','2022-10-19 10:48:45'),
	(143,'bank-logo1645016001.png','bank-logo16450160011666176525.png',NULL,'11.66 KB',0,1,'900 x 834 pixels','2022-10-19 10:48:45','2022-10-19 10:48:45'),
	(144,'download1615321224.jpeg','download16153212241666176525.jpg',NULL,'10.05 KB',0,1,'277 x 182 pixels','2022-10-19 10:48:45','2022-10-19 10:48:45'),
	(145,'flutterwave-logo-vector1615321957.png','flutterwave-logo-vector16153219571666176525.png',NULL,'4.51 KB',0,1,'900 x 500 pixels','2022-10-19 10:48:45','2022-10-19 10:48:45'),
	(146,'large-stripe1615321788.png','large-stripe16153217881666176525.png',NULL,'148.64 KB',0,1,'740 x 370 pixels','2022-10-19 10:48:45','2022-10-19 10:48:45'),
	(147,'grid-mercadopago-logo1643896370.png','grid-mercadopago-logo16438963701666176525.png',NULL,'21.7 KB',0,1,'350 x 91 pixels','2022-10-19 10:48:45','2022-10-19 10:48:45'),
	(148,'grid-mid1639824012.png','grid-mid16398240121666176526.png',NULL,'8.17 KB',0,1,'350 x 58 pixels','2022-10-19 10:48:46','2022-10-19 10:48:46'),
	(149,'grid-payfast-banner1639823358.jpg','grid-payfast-banner16398233581666176526.jpg',NULL,'8.8 KB',0,1,'350 x 164 pixels','2022-10-19 10:48:46','2022-10-19 10:48:46'),
	(150,'large-cash-free1639823357.png','large-cash-free16398233571666176526.png',NULL,'132.48 KB',0,1,'740 x 389 pixels','2022-10-19 10:48:46','2022-10-19 10:48:46'),
	(151,'instamogo1639823357.jpg','instamogo16398233571666176526.jpg',NULL,'26.18 KB',0,1,'1200 x 675 pixels','2022-10-19 10:48:46','2022-10-19 10:48:46'),
	(152,'grid-paypal1616934784.png','grid-paypal16169347841666176526.png',NULL,'25.53 KB',0,1,'350 x 156 pixels','2022-10-19 10:48:46','2022-10-19 10:48:46'),
	(153,'grid-paystack1616934784.jpeg','grid-paystack16169347841666176526.jpg',NULL,'8.75 KB',0,1,'350 x 97 pixels','2022-10-19 10:48:46','2022-10-19 10:48:46'),
	(154,'grid-razorpay1616934785.png','grid-razorpay16169347851666176526.png',NULL,'16.48 KB',0,1,'350 x 210 pixels','2022-10-19 10:48:46','2022-10-19 10:48:46'),
	(155,'grid-mollie1616934783.png','grid-mollie16169347831666176526.png',NULL,'14.17 KB',0,1,'350 x 194 pixels','2022-10-19 10:48:46','2022-10-19 10:48:46'),
	(156,'grid-payment-getway1616934783.png','grid-payment-getway16169347831666176526.png',NULL,'19.96 KB',0,1,'350 x 292 pixels','2022-10-19 10:48:46','2022-10-19 10:48:46'),
	(157,'grid-paytm1616934784.png','grid-paytm16169347841666176526.png',NULL,'11.57 KB',0,1,'350 x 117 pixels','2022-10-19 10:48:46','2022-10-19 10:48:46'),
	(158,'event-popularEvent1.jpg','event-popularevent11666609535.jpg',NULL,'38.42 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:35','2022-10-24 11:05:35'),
	(159,'event-popularEvent2.jpg','event-popularevent21666609535.jpg',NULL,'91.32 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:35','2022-10-24 11:05:35'),
	(160,'event-popularEvent3.jpg','event-popularevent31666609535.jpg',NULL,'50.13 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:35','2022-10-24 11:05:35'),
	(161,'event-recentEvent1.jpg','event-recentevent11666609535.jpg',NULL,'38.6 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:35','2022-10-24 11:05:35'),
	(162,'event-recentEvent2.jpg','event-recentevent21666609535.jpg',NULL,'45.65 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:35','2022-10-24 11:05:35'),
	(163,'event-recentEvent3.jpg','event-recentevent31666609535.jpg',NULL,'50.13 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:35','2022-10-24 11:05:35'),
	(164,'event-details1.jpg','event-details11666609535.jpg',NULL,'46.88 KB',0,1,'774 x 440 pixels','2022-10-24 11:05:35','2022-10-24 11:05:35'),
	(165,'event-eventsCat1.jpg','event-eventscat11666609536.jpg',NULL,'38.42 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:36','2022-10-24 11:05:36'),
	(166,'event-eventsCat2.jpg','event-eventscat21666609536.jpg',NULL,'91.32 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:36','2022-10-24 11:05:36'),
	(167,'event-eventsCat3.jpg','event-eventscat31666609536.jpg',NULL,'50.13 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:36','2022-10-24 11:05:36'),
	(168,'event-items1.jpg','event-items11666609536.jpg',NULL,'4.51 KB',0,1,'90 x 70 pixels','2022-10-24 11:05:36','2022-10-24 11:05:36'),
	(169,'event-items2.jpg','event-items21666609536.jpg',NULL,'5.41 KB',0,1,'90 x 70 pixels','2022-10-24 11:05:36','2022-10-24 11:05:36'),
	(170,'event-listEvent1.jpg','event-listevent11666609536.jpg',NULL,'42.92 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:36','2022-10-24 11:05:36'),
	(171,'event-listEvent2.jpg','event-listevent21666609536.jpg',NULL,'91.32 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:36','2022-10-24 11:05:36'),
	(172,'event-listEvent3.jpg','event-listevent31666609536.jpg',NULL,'45.68 KB',0,1,'432 x 239 pixels','2022-10-24 11:05:36','2022-10-24 11:05:36'),
	(173,'event-h1_heroBg.jpg','event-h1-herobg1666676931.jpg',NULL,'114.12 KB',0,1,'1920 x 970 pixels','2022-10-25 05:48:51','2022-10-25 05:48:51'),
	(174,'event-hero-man1.png','event-hero-man11666676944.png',NULL,'155.59 KB',0,1,'657 x 814 pixels','2022-10-25 05:49:05','2022-10-25 05:49:05'),
	(175,'event-listing3.svg','event-listing31667117618.svg',NULL,NULL,0,1,NULL,'2022-10-30 08:13:38','2022-10-30 08:13:38'),
	(176,'event-listing4.svg','event-listing41667117618.svg',NULL,NULL,0,1,NULL,'2022-10-30 08:13:38','2022-10-30 08:13:38'),
	(177,'event-listing2.svg','event-listing21667117618.svg',NULL,NULL,0,1,NULL,'2022-10-30 08:13:38','2022-10-30 08:13:38'),
	(178,'event-listing1.svg','event-listing11667117618.svg',NULL,NULL,0,1,NULL,'2022-10-30 08:13:38','2022-10-30 08:13:38'),
	(179,'event-about1.jpeg','event-about11667118891.jpg',NULL,'37.03 KB',0,1,'619 x 598 pixels','2022-10-30 08:34:51','2022-10-30 08:34:51'),
	(180,'job-find-hero-man1.png','job-find-hero-man11667795544.png',NULL,'86.54 KB',0,1,'491 x 636 pixels','2022-11-07 04:32:24','2022-11-07 04:32:24'),
	(181,'job-find-heroBg1.jpg','job-find-herobg11667795544.jpg',NULL,'33.9 KB',0,1,'1920 x 1022 pixels','2022-11-07 04:32:24','2022-11-07 04:32:24'),
	(182,'job-find-cat5.svg','job-find-cat51667796425.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:47:05','2022-11-07 04:47:05'),
	(183,'job-find-cat6.svg','job-find-cat61667796425.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:47:05','2022-11-07 04:47:05'),
	(184,'job-find-cat4.svg','job-find-cat41667796425.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:47:05','2022-11-07 04:47:05'),
	(185,'job-find-cat3.svg','job-find-cat31667796425.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:47:05','2022-11-07 04:47:05'),
	(186,'job-find-cat2.svg','job-find-cat21667796425.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:47:05','2022-11-07 04:47:05'),
	(187,'job-find-cat1.svg','job-find-cat11667796425.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:47:05','2022-11-07 04:47:05'),
	(188,'job-find-cat7.svg','job-find-cat71667796425.png',NULL,'837 ',0,1,'30 x 30 pixels','2022-11-07 04:47:05','2022-11-07 04:47:05'),
	(189,'job-find-cat8.svg','job-find-cat81667796425.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:47:05','2022-11-07 04:47:05'),
	(191,'job-find-companyLogo01.svg','job-find-companylogo011667797031.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:57:12','2022-11-07 04:57:12'),
	(193,'job-find-companyLogo3.svg','job-find-companylogo31667797032.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:57:12','2022-11-07 04:57:12'),
	(194,'job-find-companyLogo4.svg','job-find-companylogo41667797032.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:57:12','2022-11-07 04:57:12'),
	(196,'article-listing-companyLogo4.svg','article-listing-companylogo41667797032.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:57:12','2022-11-07 04:57:12'),
	(197,'job-find-companyLogo5.svg','job-find-companylogo51667797032.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:57:12','2022-11-07 04:57:12'),
	(198,'article-listing-companyLogo5.svg','article-listing-companylogo51667797032.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:57:12','2022-11-07 04:57:12'),
	(199,'job-find-companyLogo6.svg','job-find-companylogo61667797032.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:57:12','2022-11-07 04:57:12'),
	(200,'job-find-companyLogo2.svg','job-find-companylogo21667797032.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:57:12','2022-11-07 04:57:12'),
	(202,'job-find-companyLogo1.svg','job-find-companylogo11667797032.svg',NULL,NULL,0,1,NULL,'2022-11-07 04:57:12','2022-11-07 04:57:12'),
	(204,'job-find-videoBg.jpeg','job-find-videobg1667798052.jpg',NULL,'38.98 KB',0,1,'646 x 552 pixels','2022-11-07 05:14:12','2022-11-07 05:14:12'),
	(205,'article-listing-cat8.svg','article-listing-cat81667805070.svg',NULL,NULL,0,1,NULL,'2022-11-07 07:11:10','2022-11-07 07:11:10'),
	(206,'article-listing-cat7.svg','article-listing-cat71667805070.png',NULL,'837 ',0,1,'30 x 30 pixels','2022-11-07 07:11:10','2022-11-07 07:11:10'),
	(207,'article-listing-favicon.png','article-listing-favicon1667805070.png',NULL,'735 ',0,1,'29 x 30 pixels','2022-11-07 07:11:10','2022-11-07 07:11:10'),
	(208,'article-listing-cat1.svg','article-listing-cat11667805070.svg',NULL,NULL,0,1,NULL,'2022-11-07 07:11:10','2022-11-07 07:11:10'),
	(209,'article-listing-cat2.svg','article-listing-cat21667805070.svg',NULL,NULL,0,1,NULL,'2022-11-07 07:11:10','2022-11-07 07:11:10'),
	(210,'article-listing-cat3.svg','article-listing-cat31667805070.svg',NULL,NULL,0,1,NULL,'2022-11-07 07:11:10','2022-11-07 07:11:10'),
	(211,'article-listing-cat5.svg','article-listing-cat51667805070.svg',NULL,NULL,0,1,NULL,'2022-11-07 07:11:10','2022-11-07 07:11:10'),
	(212,'article-listing-cat6.svg','article-listing-cat61667805070.svg',NULL,NULL,0,1,NULL,'2022-11-07 07:11:10','2022-11-07 07:11:10'),
	(213,'article-listing-cat4.svg','article-listing-cat41667805070.svg',NULL,NULL,0,1,NULL,'2022-11-07 07:11:10','2022-11-07 07:11:10'),
	(214,'article-listing-details1.jpeg','article-listing-details11667816290.jpg',NULL,'200.28 KB',0,1,'966 x 361 pixels','2022-11-07 10:18:10','2022-11-07 10:18:10'),
	(215,'article-listing-heroImg2.png','article-listing-heroimg21667825884.png',NULL,'31.42 KB',0,1,'303 x 280 pixels','2022-11-07 12:58:04','2022-11-07 12:58:04'),
	(216,'article-listing-heroImg1.png','article-listing-heroimg11667825884.png',NULL,'32.28 KB',0,1,'301 x 278 pixels','2022-11-07 12:58:04','2022-11-07 12:58:04'),
	(217,'article-listing-videoBg.jpeg','article-listing-videobg1667892952.jpg',NULL,'46.83 KB',0,1,'684 x 560 pixels','2022-11-08 07:35:52','2022-11-08 07:35:52'),
	(218,'support-ticketing-heroBg1.jpeg','support-ticketing-herobg11667971245.jpg',NULL,'26.57 KB',0,1,'1920 x 940 pixels','2022-11-09 05:20:45','2022-11-09 05:20:45'),
	(219,'support-ticketing-hero-man1.jpeg','support-ticketing-hero-man11667971287.jpg',NULL,'53.47 KB',0,1,'630 x 580 pixels','2022-11-09 05:21:27','2022-11-09 05:21:27'),
	(220,'support-ticketing-cat1.svg','support-ticketing-cat11667974002.svg',NULL,NULL,0,1,NULL,'2022-11-09 06:06:42','2022-11-09 06:06:42'),
	(221,'support-ticketing-cat7.svg','support-ticketing-cat71667974002.png',NULL,'837 ',0,1,'30 x 30 pixels','2022-11-09 06:06:42','2022-11-09 06:06:42'),
	(222,'support-ticketing-cat2.svg','support-ticketing-cat21667974002.svg',NULL,NULL,0,1,NULL,'2022-11-09 06:06:42','2022-11-09 06:06:42'),
	(223,'support-ticketing-cat8.svg','support-ticketing-cat81667974002.svg',NULL,NULL,0,1,NULL,'2022-11-09 06:06:42','2022-11-09 06:06:42'),
	(224,'support-ticketing-cat3.svg','support-ticketing-cat31667974002.svg',NULL,NULL,0,1,NULL,'2022-11-09 06:06:42','2022-11-09 06:06:42'),
	(225,'support-ticketing-cat4.svg','support-ticketing-cat41667974002.svg',NULL,NULL,0,1,NULL,'2022-11-09 06:06:42','2022-11-09 06:06:42'),
	(226,'support-ticketing-cat5.svg','support-ticketing-cat51667974002.svg',NULL,NULL,0,1,NULL,'2022-11-09 06:06:42','2022-11-09 06:06:42'),
	(227,'support-ticketing-cat6.svg','support-ticketing-cat61667974002.svg',NULL,NULL,0,1,NULL,'2022-11-09 06:06:42','2022-11-09 06:06:42'),
	(228,'support-ticketing-tittleShape.svg','support-ticketing-tittleshape1667974002.svg',NULL,NULL,0,1,NULL,'2022-11-09 06:06:42','2022-11-09 06:06:42'),
	(229,'support-ticketing-tittleShape2.svg','support-ticketing-tittleshape21667974002.svg',NULL,NULL,0,1,NULL,'2022-11-09 06:06:42','2022-11-09 06:06:42'),
	(230,'support-ticketing-about1.jpeg','support-ticketing-about11667975475.jpg',NULL,'43.14 KB',0,1,'599 x 560 pixels','2022-11-09 06:31:15','2022-11-09 06:31:15'),
	(231,'support-ticketing-sectionBg1.jpeg','support-ticketing-sectionbg11667984630.jpg',NULL,'21.89 KB',0,1,'1296 x 500 pixels','2022-11-09 09:03:50','2022-11-09 09:03:50'),
	(232,'donation-logo.png','donation-logo1668057414.png',NULL,'2.68 KB',0,1,'141 x 29 pixels','2022-11-10 05:16:55','2022-11-10 05:16:55'),
	(233,'event-logo.png','event-logo1668065082.png',NULL,'2.54 KB',0,1,'104 x 26 pixels','2022-11-10 07:24:42','2022-11-10 07:24:42'),
	(234,'job-find-logo.png','job-find-logo1668071363.png',NULL,'2.75 KB',0,1,'137 x 31 pixels','2022-11-10 09:09:23','2022-11-10 09:09:23'),
	(235,'article-listing-logo.png','article-listing-logo1668076822.png',NULL,'1.86 KB',0,1,'177 x 30 pixels','2022-11-10 10:40:22','2022-11-10 10:40:22'),
	(236,'support-ticketing-logo.png','support-ticketing-logo1668082689.png',NULL,'1.66 KB',0,1,'135 x 35 pixels','2022-11-10 12:18:09','2022-11-10 12:18:09'),
	(237,'eCommerce-favicon.png','ecommerce-favicon1671430170.png',NULL,'579 ',0,1,'24 x 24 pixels','2022-12-19 06:09:30','2022-12-19 06:09:30'),
	(238,'eCommerce-logo.png','ecommerce-logo1671430181.png',NULL,'1.88 KB',0,1,'119 x 32 pixels','2022-12-19 06:09:41','2022-12-19 06:09:41'),
	(239,'eCommerce-hero-man1.png','ecommerce-hero-man11671432385.png',NULL,'987.72 KB',0,1,'1875 x 2462 pixels','2022-12-19 06:46:25','2022-12-19 06:46:25'),
	(240,'eCommerce-hero-man2.png','ecommerce-hero-man21671432385.png',NULL,'1.78 MB',0,1,'2632 x 3452 pixels','2022-12-19 06:46:26','2022-12-19 06:46:26'),
	(241,'support-ticketing-hero-man1.jpg','support-ticketing-hero-man11671432386.jpg',NULL,'53.47 KB',0,1,'630 x 580 pixels','2022-12-19 06:46:26','2022-12-19 06:46:26'),
	(242,'eCommerce-cartImg4.png','ecommerce-cartimg41671432442.png',NULL,'27.39 KB',0,1,'228 x 260 pixels','2022-12-19 06:47:22','2022-12-19 06:47:22'),
	(243,'eCommerce-cartImg3.png','ecommerce-cartimg31671432442.png',NULL,'108.57 KB',0,1,'418 x 736 pixels','2022-12-19 06:47:22','2022-12-19 06:47:22'),
	(244,'eCommerce-cartImg5.png','ecommerce-cartimg51671432442.png',NULL,'24.02 KB',0,1,'206 x 260 pixels','2022-12-19 06:47:22','2022-12-19 06:47:22'),
	(245,'eCommerce-subsCribeShape3.png','ecommerce-subscribeshape31671432443.png',NULL,'2.61 KB',0,1,'99 x 197 pixels','2022-12-19 06:47:23','2022-12-19 06:47:23'),
	(246,'eCommerce-subsCribeShape1.png','ecommerce-subscribeshape11671432443.png',NULL,'2.3 KB',0,1,'181 x 135 pixels','2022-12-19 06:47:23','2022-12-19 06:47:23'),
	(247,'eCommerce-subsCribeShape2.png','ecommerce-subscribeshape21671432443.png',NULL,'1.82 KB',0,1,'133 x 132 pixels','2022-12-19 06:47:23','2022-12-19 06:47:23'),
	(248,'eCommerce-SaleOffers.png','ecommerce-saleoffers1671432443.png',NULL,'2.31 KB',0,1,'146 x 146 pixels','2022-12-19 06:47:23','2022-12-19 06:47:23'),
	(249,'eCommerce-Rectangle 24.jpg','ecommerce-rectangle-241671432443.jpg',NULL,'20.31 KB',0,1,'306 x 241 pixels','2022-12-19 06:47:23','2022-12-19 06:47:23'),
	(250,'eCommerce-proWishList1.jpg','ecommerce-prowishlist11671432443.jpg',NULL,'3.1 KB',0,1,'120 x 120 pixels','2022-12-19 06:47:23','2022-12-19 06:47:23'),
	(251,'eCommerce-productDescription1.jpg','ecommerce-productdescription11671432443.jpg',NULL,'17.83 KB',0,1,'636 x 458 pixels','2022-12-19 06:47:23','2022-12-19 06:47:23'),
	(252,'eCommerce-offerCatImg.png','ecommerce-offercatimg1671432443.png',NULL,'113 KB',0,1,'616 x 598 pixels','2022-12-19 06:47:23','2022-12-19 06:47:23'),
	(253,'eCommerce-cartImg7.png','ecommerce-cartimg71671432443.png',NULL,'302.78 KB',0,1,'1508 x 1616 pixels','2022-12-19 06:47:23','2022-12-19 06:47:23'),
	(254,'eCommerce-cartImg6.png','ecommerce-cartimg61671432443.png',NULL,'25.42 KB',0,1,'236 x 260 pixels','2022-12-19 06:47:23','2022-12-19 06:47:23'),
	(255,'eCommerce-all-product4.jpg','ecommerce-all-product41671432443.jpg',NULL,'15.04 KB',0,1,'306 x 248 pixels','2022-12-19 06:47:23','2022-12-19 06:47:23'),
	(256,'eCommerce-all-product4.png','ecommerce-all-product41671432443.png',NULL,'21.5 KB',0,1,'306 x 248 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(257,'eCommerce-campaignProduct3.jpg','ecommerce-campaignproduct31671432444.jpg',NULL,'20.31 KB',0,1,'306 x 241 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(258,'eCommerce-campaignProduct4.jpg','ecommerce-campaignproduct41671432444.jpg',NULL,'9.45 KB',0,1,'306 x 241 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(259,'eCommerce-cartImg1.png','ecommerce-cartimg11671432444.png',NULL,'33.12 KB',0,1,'231 x 358 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(260,'eCommerce-cartImg2.png','ecommerce-cartimg21671432444.png',NULL,'40.88 KB',0,1,'251 x 351 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(261,'eCommerce-campaignProduct2.jpg','ecommerce-campaignproduct21671432444.jpg',NULL,'26.35 KB',0,1,'306 x 241 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(262,'eCommerce-campaignProduct1.jpg','ecommerce-campaignproduct11671432444.jpg',NULL,'18.18 KB',0,1,'306 x 241 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(263,'eCommerce-all-product5.jpg','ecommerce-all-product51671432444.jpg',NULL,'10.6 KB',0,1,'306 x 248 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(264,'eCommerce-bestSelling1.jpg','ecommerce-bestselling11671432444.jpg',NULL,'6.43 KB',0,1,'306 x 240 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(265,'eCommerce-all-product6.jpg','ecommerce-all-product61671432444.jpg',NULL,'9.12 KB',0,1,'306 x 248 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(266,'eCommerce-bestSelling3.jpg','ecommerce-bestselling31671432444.jpg',NULL,'15.53 KB',0,1,'306 x 240 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(267,'eCommerce-bestSelling2.jpg','ecommerce-bestselling21671432444.jpg',NULL,'11.84 KB',0,1,'306 x 240 pixels','2022-12-19 06:47:24','2022-12-19 06:47:24'),
	(268,'eCommerce-bestSelling4.jpg','ecommerce-bestselling41671432444.jpg',NULL,'4.12 KB',0,1,'306 x 240 pixels','2022-12-19 06:47:25','2022-12-19 06:47:25'),
	(269,'eCommerce-services3.svg','ecommerce-services31671522236.svg',NULL,NULL,0,1,NULL,'2022-12-20 07:43:56','2022-12-20 07:43:56'),
	(270,'eCommerce-services3 (1).svg','ecommerce-services3-11671522236.svg',NULL,NULL,0,1,NULL,'2022-12-20 07:43:56','2022-12-20 07:43:56'),
	(271,'eCommerce-services1.svg','ecommerce-services11671522236.svg',NULL,NULL,0,1,NULL,'2022-12-20 07:43:56','2022-12-20 07:43:56'),
	(272,'eCommerce-services2.svg','ecommerce-services21671522236.svg',NULL,NULL,0,1,NULL,'2022-12-20 07:43:56','2022-12-20 07:43:56'),
	(273,'grid-frame-345441669181210.jpg','grid-frame-3454416691812101672036630.jpg',NULL,'10.79 KB',0,1,'350 x 350 pixels','2022-12-26 06:37:10','2022-12-26 06:37:10'),
	(274,'grid-frame-34510-copy1669034209.jpg','grid-frame-34510-copy16690342091672036630.jpg',NULL,'11.7 KB',0,1,'350 x 350 pixels','2022-12-26 06:37:10','2022-12-26 06:37:10'),
	(275,'missin-global21670413731.jpg','missin-global216704137311672818712.jpg',NULL,'55.49 KB',0,1,'637 x 567 pixels','2023-01-04 13:51:52','2023-01-04 13:51:52'),
	(276,'support-ticketing-about11667975475.jpg','support-ticketing-about116679754751672819076.jpg',NULL,'43.14 KB',0,1,'599 x 560 pixels','2023-01-04 13:57:56','2023-01-04 13:57:56'),
	(277,'pexels-ron-lach-10388756.jpg','pexels-ron-lach-103887561672821121.jpg',NULL,'232.51 KB',0,1,'1080 x 1080 pixels','2023-01-04 14:32:01','2023-01-04 14:32:01'),
	(278,'pexels-rodnae-productions-10376195-min.jpg','pexels-rodnae-productions-10376195-min1672822323.jpg',NULL,'1.15 MB',0,1,'4480 x 6720 pixels','2023-01-04 14:52:05','2023-01-04 14:52:05'),
	(279,'Frame 34546.png','frame-345461672823731.png',NULL,'287.31 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:15:31','2023-01-04 15:15:31'),
	(280,'Frame 34548.png','frame-345481672823741.png',NULL,'480.21 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:15:41','2023-01-04 15:15:41'),
	(281,'Frame 34547.png','frame-345471672823741.png',NULL,'480.21 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:15:41','2023-01-04 15:15:41'),
	(282,'Frame 34549.png','frame-345491672823741.png',NULL,'318.15 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:15:41','2023-01-04 15:15:41'),
	(283,'Frame 34570.png','frame-345701672823932.png',NULL,'47.29 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:18:52','2023-01-04 15:18:52'),
	(284,'Frame 34571.png','frame-345711672823932.png',NULL,'201.88 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:18:52','2023-01-04 15:18:52'),
	(285,'Frame 34573.png','frame-345731672823932.png',NULL,'50.5 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:18:52','2023-01-04 15:18:52'),
	(286,'Frame 34572.png','frame-345721672823932.png',NULL,'245.59 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:18:52','2023-01-04 15:18:52'),
	(287,'Frame 34574.png','frame-345741672823932.png',NULL,'173.36 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:18:52','2023-01-04 15:18:52'),
	(288,'Frame 34542.jpg','frame-345421672824293.jpg',NULL,'265.21 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:24:53','2023-01-04 15:24:53'),
	(289,'Frame 34558.png','frame-345581672824347.png',NULL,'1.16 MB',0,1,'1080 x 1080 pixels','2023-01-04 15:25:47','2023-01-04 15:25:47'),
	(290,'Frame 34556.png','frame-345561672824347.png',NULL,'1.24 MB',0,1,'1080 x 1080 pixels','2023-01-04 15:25:47','2023-01-04 15:25:47'),
	(291,'Frame 34559.png','frame-345591672824347.png',NULL,'1.23 MB',0,1,'1080 x 1080 pixels','2023-01-04 15:25:47','2023-01-04 15:25:47'),
	(292,'Frame 34479.jpg','frame-344791672824418.jpg',NULL,'217.15 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:26:58','2023-01-04 15:26:58'),
	(293,'Frame 34498.jpg','frame-344981672824418.jpg',NULL,'273.71 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:26:58','2023-01-04 15:26:58'),
	(294,'Frame 34526.jpg','frame-345261672824418.jpg',NULL,'266.14 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:26:58','2023-01-04 15:26:58'),
	(295,'Frame 34518.jpg','frame-345181672824462.jpg',NULL,'147.75 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:27:43','2023-01-04 15:27:43'),
	(296,'Frame 34514.jpg','frame-345141672824462.jpg',NULL,'306.63 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:27:43','2023-01-04 15:27:43'),
	(297,'Frame 34482.jpg','frame-344821672824463.jpg',NULL,'222.84 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:27:43','2023-01-04 15:27:43'),
	(298,'Frame 34480.jpg','frame-344801672824463.jpg',NULL,'327.11 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:27:43','2023-01-04 15:27:43'),
	(299,'Frame 34519.jpg','frame-345191672824501.jpg',NULL,'234.1 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:28:22','2023-01-04 15:28:22'),
	(300,'Frame 34510.jpg','frame-345101672824501.jpg',NULL,'174.1 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:28:22','2023-01-04 15:28:22'),
	(301,'Frame 34488.jpg','frame-344881672824502.jpg',NULL,'252.27 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:28:22','2023-01-04 15:28:22'),
	(302,'Frame 34507.jpg','frame-345071672824502.jpg',NULL,'378.76 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:28:22','2023-01-04 15:28:22'),
	(303,'Frame 34490.jpg','frame-344901672824661.jpg',NULL,'225.74 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:31:01','2023-01-04 15:31:01'),
	(304,'Frame 34481.jpg','frame-344811672824661.jpg',NULL,'201.18 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:31:01','2023-01-04 15:31:01'),
	(305,'Frame 34534.jpg','frame-345341672824661.jpg',NULL,'220.05 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:31:01','2023-01-04 15:31:01'),
	(306,'Frame 34536.jpg','frame-345361672824791.jpg',NULL,'164.63 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:33:11','2023-01-04 15:33:11'),
	(307,'Frame 34492.jpg','frame-344921672824791.jpg',NULL,'119.79 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:33:11','2023-01-04 15:33:11'),
	(308,'Frame 34474.jpg','frame-344741672824791.jpg',NULL,'120.73 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:33:11','2023-01-04 15:33:11'),
	(309,'Frame 34483.jpg','frame-344831672824791.jpg',NULL,'171.72 KB',0,1,'1080 x 1080 pixels','2023-01-04 15:33:11','2023-01-04 15:33:11'),
	(310,'logo.png','logo1673525067.png',NULL,'2.3 KB',0,1,'177 x 27 pixels','2023-01-12 12:04:27','2023-01-12 12:04:27'),
	(311,'logo_footer.png','logo-footer1673525137.png',NULL,'1.88 KB',0,1,'177 x 27 pixels','2023-01-12 12:05:37','2023-01-12 12:05:37'),
	(312,'favicon.png','favicon1673525154.png',NULL,'617 ',0,1,'16 x 16 pixels','2023-01-12 12:05:54','2023-01-12 12:05:54'),
	(313,'agency_banner_main.jpg','agency-banner-main1673528784.jpg',NULL,'291.9 KB',0,1,'636 x 592 pixels','2023-01-12 13:06:24','2023-01-12 13:06:24'),
	(314,'agency_about1.jpg','agency-about11673677982.jpg',NULL,'306.19 KB',0,1,'592 x 585 pixels','2023-01-14 06:33:02','2023-01-14 06:33:02'),
	(315,'agency_service1.svg','agency-service11673682790.svg',NULL,NULL,0,1,NULL,'2023-01-14 07:53:10','2023-01-14 07:53:10'),
	(316,'agency_work1.jpg','agency-work11673689013.jpg',NULL,'91.94 KB',0,1,'416 x 312 pixels','2023-01-14 09:36:53','2023-01-14 09:36:53'),
	(317,'agency_testimonial.jpg','agency-testimonial1673694267.jpg',NULL,'235.78 KB',0,1,'570 x 564 pixels','2023-01-14 11:04:27','2023-01-14 11:04:27'),
	(318,'photo-1524169358666-79f22534bc6e.jpg','photo-1524169358666-79f22534bc6e1673783012.jpg',NULL,'78.3 KB',0,1,'1170 x 780 pixels','2023-01-15 11:43:32','2023-01-15 11:43:32'),
	(319,'sidebar_advertise1.jpg','sidebar-advertise11673850662.jpg',NULL,'62.08 KB',0,1,'270 x 290 pixels','2023-01-16 06:31:02','2023-01-16 06:31:02'),
	(320,'newpaper_advertise2.jpg','newpaper-advertise21673850662.jpg',NULL,'236.19 KB',0,1,'1296 x 260 pixels','2023-01-16 06:31:02','2023-01-16 06:31:02'),
	(321,'newpaper_advertise.jpg','newpaper-advertise1673850662.jpg',NULL,'208.91 KB',0,1,'1296 x 293 pixels','2023-01-16 06:31:03','2023-01-16 06:31:03'),
	(322,'11643861795.png','116438617951673851055.png',NULL,'87.96 KB',0,1,'530 x 100 pixels','2023-01-16 06:37:35','2023-01-16 06:37:35'),
	(323,'061642222744.jpg','0616422227441673851055.jpg',NULL,'14.19 KB',0,1,'1370 x 250 pixels','2023-01-16 06:37:35','2023-01-16 06:37:35'),
	(324,'950x1601643197856.png','950x16016431978561673851055.png',NULL,'236.91 KB',0,1,'950 x 160 pixels','2023-01-16 06:37:35','2023-01-16 06:37:35'),
	(325,'950x160-11643197856.png','950x160-116431978561673851055.png',NULL,'211.37 KB',0,1,'950 x 160 pixels','2023-01-16 06:37:35','2023-01-16 06:37:35'),
	(326,'800x1001643285640.png','800x10016432856401673851055.png',NULL,'72.15 KB',0,1,'800 x 100 pixels','2023-01-16 06:37:35','2023-01-16 06:37:35'),
	(327,'530x1001643285648.png','530x10016432856481673851055.png',NULL,'59.5 KB',0,1,'530 x 100 pixels','2023-01-16 06:37:35','2023-01-16 06:37:35'),
	(328,'051642222744.jpg','0516422227441673851055.jpg',NULL,'12.34 KB',0,1,'950 x 200 pixels','2023-01-16 06:37:35','2023-01-16 06:37:35'),
	(329,'071642222744.jpg','0716422227441673851055.jpg',NULL,'26.17 KB',0,1,'1530 x 250 pixels','2023-01-16 06:37:35','2023-01-16 06:37:35'),
	(330,'041642222744.jpg','0416422227441673851055.jpg',NULL,'18.26 KB',0,1,'1370 x 250 pixels','2023-01-16 06:37:35','2023-01-16 06:37:35'),
	(331,'semi-large-031642222744.jpg','semi-large-0316422227441673851763.jpg',NULL,'13.81 KB',0,1,'540 x 114 pixels','2023-01-16 06:49:23','2023-01-16 06:49:23'),
	(332,'box-1400x250-11643287596.png','box-1400x250-116432875961673852764.png',NULL,'51.59 KB',0,1,'527 x 94 pixels','2023-01-16 07:06:04','2023-01-16 07:06:04'),
	(333,'box-1370x2501643799765.png','box-1370x25016437997651673852764.png',NULL,'48.76 KB',0,1,'527 x 96 pixels','2023-01-16 07:06:04','2023-01-16 07:06:04'),
	(334,'box-1530x250-11643793228.png','box-1530x250-116437932281673852764.png',NULL,'32.56 KB',0,1,'527 x 86 pixels','2023-01-16 07:06:04','2023-01-16 07:06:04'),
	(335,'newspaper_entertainment1.jpg','newspaper-entertainment11673863273.jpg',NULL,'69.15 KB',0,1,'306 x 200 pixels','2023-01-16 10:01:13','2023-01-16 10:01:13'),
	(336,'logo.png','logo1673870353.png',NULL,'2.61 KB',0,1,'81 x 55 pixels','2023-01-16 11:59:13','2023-01-16 11:59:13'),
	(337,'logo_footer.png','logo-footer1673870405.png',NULL,'2.28 KB',0,1,'81 x 55 pixels','2023-01-16 12:00:05','2023-01-16 12:00:05'),
	(338,'construction_banner_thumb.png','construction-banner-thumb1674454972.png',NULL,'398.21 KB',0,1,'460 x 669 pixels','2023-01-23 06:22:52','2023-01-23 06:22:52'),
	(339,'construction_bannerbottom4.svg','construction-bannerbottom41674467301.svg',NULL,NULL,0,1,NULL,'2023-01-23 09:48:21','2023-01-23 09:48:21'),
	(340,'construction_bannerbottom3.svg','construction-bannerbottom31674467301.svg',NULL,NULL,0,1,NULL,'2023-01-23 09:48:21','2023-01-23 09:48:21'),
	(341,'construction_bannerbottom1.svg','construction-bannerbottom11674467301.svg',NULL,NULL,0,1,NULL,'2023-01-23 09:48:21','2023-01-23 09:48:21'),
	(342,'construction_bannerbottom2.svg','construction-bannerbottom21674467301.svg',NULL,NULL,0,1,NULL,'2023-01-23 09:48:21','2023-01-23 09:48:21'),
	(343,'construction_offer.jpg','construction-offer1674471813.jpg',NULL,'349.22 KB',0,1,'636 x 572 pixels','2023-01-23 11:03:33','2023-01-23 11:03:33'),
	(344,'construction_project2.jpg','construction-project21674476474.jpg',NULL,'106.83 KB',0,1,'416 x 422 pixels','2023-01-23 12:21:14','2023-01-23 12:21:14'),
	(345,'construction_project3.jpg','construction-project31674476474.jpg',NULL,'209.22 KB',0,1,'416 x 422 pixels','2023-01-23 12:21:14','2023-01-23 12:21:14'),
	(346,'construction_project1.jpg','construction-project11674476474.jpg',NULL,'137.67 KB',0,1,'416 x 422 pixels','2023-01-23 12:21:14','2023-01-23 12:21:14'),
	(347,'construction_client3.jpg','construction-client31674477470.jpg',NULL,'16.07 KB',0,1,'104 x 104 pixels','2023-01-23 12:37:50','2023-01-23 12:37:50'),
	(348,'construction_client2.jpg','construction-client21674477470.jpg',NULL,'10.27 KB',0,1,'104 x 104 pixels','2023-01-23 12:37:50','2023-01-23 12:37:50'),
	(349,'construction_client5.jpg','construction-client51674477470.jpg',NULL,'16.17 KB',0,1,'104 x 104 pixels','2023-01-23 12:37:50','2023-01-23 12:37:50'),
	(350,'construction_client4.jpg','construction-client41674477470.jpg',NULL,'10.25 KB',0,1,'104 x 104 pixels','2023-01-23 12:37:50','2023-01-23 12:37:50'),
	(351,'construction_client1.jpg','construction-client11674477471.jpg',NULL,'6.15 KB',0,1,'104 x 104 pixels','2023-01-23 12:37:51','2023-01-23 12:37:51'),
	(352,'construction_client6.jpg','construction-client61674477471.jpg',NULL,'12.24 KB',0,1,'104 x 104 pixels','2023-01-23 12:37:51','2023-01-23 12:37:51'),
	(353,'construction_blog2.jpg','construction-blog21674537655.jpg',NULL,'107.19 KB',0,1,'416 x 240 pixels','2023-01-24 05:20:55','2023-01-24 05:20:55'),
	(354,'construction_blog3.jpg','construction-blog31674537655.jpg',NULL,'83.32 KB',0,1,'424 x 248 pixels','2023-01-24 05:20:55','2023-01-24 05:20:55'),
	(355,'construction_blog1.jpg','construction-blog11674537655.jpg',NULL,'111.37 KB',0,1,'416 x 240 pixels','2023-01-24 05:20:55','2023-01-24 05:20:55'),
	(356,'logo.png','logo1674565092.png',NULL,'2 KB',0,1,'151 x 35 pixels','2023-01-24 12:58:12','2023-01-24 12:58:12'),
	(357,'consulting_reviewer1.jpg','consulting-reviewer11674709401.jpg',NULL,'3.92 KB',0,1,'40 x 40 pixels','2023-01-26 05:03:21','2023-01-26 05:03:21'),
	(358,'consulting_reviewer2.jpg','consulting-reviewer21674709401.jpg',NULL,'2.94 KB',0,1,'40 x 40 pixels','2023-01-26 05:03:21','2023-01-26 05:03:21'),
	(359,'consulting_reviewer4.jpg','consulting-reviewer41674709401.jpg',NULL,'3.89 KB',0,1,'40 x 40 pixels','2023-01-26 05:03:21','2023-01-26 05:03:21'),
	(360,'consulting_reviewer3.jpg','consulting-reviewer31674709401.jpg',NULL,'3.94 KB',0,1,'40 x 40 pixels','2023-01-26 05:03:21','2023-01-26 05:03:21'),
	(361,'consulting_reviewer5.jpg','consulting-reviewer51674709401.jpg',NULL,'3.94 KB',0,1,'40 x 40 pixels','2023-01-26 05:03:21','2023-01-26 05:03:21'),
	(362,'consulting_banner2.png','consulting-banner21674709401.png',NULL,'129.65 KB',0,1,'375 x 334 pixels','2023-01-26 05:03:21','2023-01-26 05:03:21'),
	(363,'consulting_banner3.png','consulting-banner31674709401.png',NULL,'148.65 KB',0,1,'374 x 334 pixels','2023-01-26 05:03:21','2023-01-26 05:03:21'),
	(364,'consulting_banner1.png','consulting-banner11674709401.png',NULL,'126.96 KB',0,1,'374 x 334 pixels','2023-01-26 05:03:21','2023-01-26 05:03:21'),
	(365,'consulting_banner4.png','consulting-banner41674709401.png',NULL,'59.43 KB',0,1,'214 x 192 pixels','2023-01-26 05:03:21','2023-01-26 05:03:21'),
	(366,'consulting_banner5.png','consulting-banner51674709401.png',NULL,'44.74 KB',0,1,'183 x 163 pixels','2023-01-26 05:03:22','2023-01-26 05:03:22'),
	(367,'consulting_service6.svg','consulting-service61674713568.svg',NULL,NULL,0,1,NULL,'2023-01-26 06:12:48','2023-01-26 06:12:48'),
	(368,'consulting_service5.svg','consulting-service51674713568.svg',NULL,NULL,0,1,NULL,'2023-01-26 06:12:48','2023-01-26 06:12:48'),
	(369,'consulting_service4.svg','consulting-service41674713568.svg',NULL,NULL,0,1,NULL,'2023-01-26 06:12:48','2023-01-26 06:12:48'),
	(370,'consulting_service3.svg','consulting-service31674713568.svg',NULL,NULL,0,1,NULL,'2023-01-26 06:12:48','2023-01-26 06:12:48'),
	(371,'consulting_service1.svg','consulting-service11674713568.svg',NULL,NULL,0,1,NULL,'2023-01-26 06:12:48','2023-01-26 06:12:48'),
	(372,'consulting_service2.svg','consulting-service21674713568.svg',NULL,NULL,0,1,NULL,'2023-01-26 06:12:48','2023-01-26 06:12:48'),
	(373,'consulting_about_shape1.svg','consulting-about-shape11674717471.svg',NULL,NULL,0,1,NULL,'2023-01-26 07:17:51','2023-01-26 07:17:51'),
	(374,'consulting_about_shape2.svg','consulting-about-shape21674717471.svg',NULL,NULL,0,1,NULL,'2023-01-26 07:17:51','2023-01-26 07:17:51'),
	(375,'consulting_team2.jpg','consulting-team21674720458.jpg',NULL,'148.63 KB',0,1,'416 x 416 pixels','2023-01-26 08:07:38','2023-01-26 08:07:38'),
	(376,'consulting_team6.jpg','consulting-team61674720458.jpg',NULL,'102.91 KB',0,1,'416 x 416 pixels','2023-01-26 08:07:38','2023-01-26 08:07:38'),
	(377,'consulting_team5.jpg','consulting-team51674720459.jpg',NULL,'129.83 KB',0,1,'416 x 416 pixels','2023-01-26 08:07:39','2023-01-26 08:07:39'),
	(378,'consulting_team4.jpg','consulting-team41674720459.jpg',NULL,'136.22 KB',0,1,'416 x 416 pixels','2023-01-26 08:07:39','2023-01-26 08:07:39'),
	(379,'consulting_team3.jpg','consulting-team31674720459.jpg',NULL,'128.95 KB',0,1,'416 x 416 pixels','2023-01-26 08:07:39','2023-01-26 08:07:39'),
	(380,'consulting_team1.jpg','consulting-team11674720459.jpg',NULL,'168.16 KB',0,1,'416 x 416 pixels','2023-01-26 08:07:39','2023-01-26 08:07:39'),
	(381,'consulting_blog4.jpg','consulting-blog41674888151.jpg',NULL,'16.98 KB',0,1,'416 x 260 pixels','2023-01-28 06:42:31','2023-01-28 06:42:31'),
	(382,'consulting_blog3.jpg','consulting-blog31674888151.jpg',NULL,'137.05 KB',0,1,'416 x 260 pixels','2023-01-28 06:42:31','2023-01-28 06:42:31'),
	(383,'consulting_blog1.jpg','consulting-blog11674888151.jpg',NULL,'86.85 KB',0,1,'416 x 260 pixels','2023-01-28 06:42:31','2023-01-28 06:42:31'),
	(384,'consulting_blog2.jpg','consulting-blog21674888151.jpg',NULL,'134.65 KB',0,1,'416 x 260 pixels','2023-01-28 06:42:31','2023-01-28 06:42:31'),
	(385,'logo.png','logo1674893740.png',NULL,'2 KB',0,1,'151 x 35 pixels','2023-01-28 08:15:40','2023-01-28 08:15:40'),
	(386,'logo.png','logo1674894052.png',NULL,'2.54 KB',0,1,'143 x 31 pixels','2023-01-28 08:20:52','2023-01-28 08:20:52'),
	(387,'consulting_imgMask.png','consulting-imgmask1675065260.png',NULL,'129.41 KB',0,1,'374 x 334 pixels','2023-01-30 07:54:20','2023-01-30 07:54:20'),
	(388,'consulting_imgMask2.png','consulting-imgmask21675065324.png',NULL,'34.84 KB',0,1,'157 x 140 pixels','2023-01-30 07:55:24','2023-01-30 07:55:24')");

    }
}
