<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\HtmlString;
use Illuminate\Support\Str;

class UserCreated extends Notification
{
    use Queueable;

    public $password;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($password)
    {
        $this->password = $password;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        if (Str::contains($notifiable->email, 'example.com') || ! option('email_config')) {
            return [];
        }

        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject(__('You are added as team member'))
                    ->greeting(__('Hi,').' '.$notifiable->name)
                    ->line(__('You are added as team member'))
                    ->line(__('Please use the following login credentials').':')
                    ->line(new HtmlString(__('Email').': <strong>'.$notifiable->email.'</strong>'))
                    ->line(new HtmlString(__('Password').': <strong>'.$this->password.'</strong>'))
                    ->action(__('Click here to login'), url('/'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
