<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\Rest\Microvisor\V1;

/**
 * @property \Twilio\Rest\Microvisor\V1 $v1
 * @property \Twilio\Rest\Microvisor\V1\AppList $apps
 * @property \Twilio\Rest\Microvisor\V1\DeviceList $devices
 * @method \Twilio\Rest\Microvisor\V1\AppContext apps(string $sid)
 * @method \Twilio\Rest\Microvisor\V1\DeviceContext devices(string $sid)
 */
class Microvisor extends Domain {
    protected $_v1;

    /**
     * Construct the Microvisor Domain
     *
     * @param Client $client Client to communicate with Twilio
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://microvisor.twilio.com';
    }

    /**
     * @return V1 Version v1 of microvisor
     */
    protected function getV1(): V1 {
        if (!$this->_v1) {
            $this->_v1 = new V1($this);
        }
        return $this->_v1;
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     * @return \Twilio\Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get(string $name) {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return \Twilio\InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments) {
        $method = 'context' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return \call_user_func_array([$this, $method], $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    protected function getApps(): \Twilio\Rest\Microvisor\V1\AppList {
        return $this->v1->apps;
    }

    /**
     * @param string $sid A string that uniquely identifies this App.
     */
    protected function contextApps(string $sid): \Twilio\Rest\Microvisor\V1\AppContext {
        return $this->v1->apps($sid);
    }

    protected function getDevices(): \Twilio\Rest\Microvisor\V1\DeviceList {
        return $this->v1->devices;
    }

    /**
     * @param string $sid A string that uniquely identifies this Device.
     */
    protected function contextDevices(string $sid): \Twilio\Rest\Microvisor\V1\DeviceContext {
        return $this->v1->devices($sid);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Microvisor]';
    }
}