@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th scope="col">@lang('Title')</th>
                                    <th scope="col">@lang('Status')</th>
                                    <th scope="col">@lang('Version')</th>
                                    <th scope="col">@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($episodes as $episode)
                                    <tr>
                                        <td>{{ __($episode->title) }}</td>
                                        <td>
                                            @if ($episode->status == 1)
                                                <span class="badge badge--success">@lang('Active')</span>
                                            @else
                                                <span class="badge badge--danger">@lang('Inactive')</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($episode->version == 0)
                                                <span class="badge badge--success">@lang('Free')</span>
                                            @else
                                                <span class="badge badge--primary">@lang('Paid')</span>
                                            @endif
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline--primary editBtn" data-title="{{ $episode->title }}" data-version="{{ $episode->version }}" data-image="{{ getImage(getFilePath('episode') . '/' . $episode->image) }}" data-episode_id="{{ $episode->id }}" data-status="{{ $episode->status }}" data-toggle="tooltip" data-original-title="Edit" title="">
                                                <i class="la la-pencil"></i>@lang('Edit')
                                            </button>
                                            @if ($episode->video)
                                                <a class="btn btn-sm btn-outline--info" href="{{ route('admin.item.episode.updateVideo', $episode->id) }}">
                                                    <i class="la la-cloud-upload-alt"></i>@lang('Update Video')
                                                </a>

                                                <a class="btn btn-sm btn-outline--dark" href="{{ route('admin.item.ads.duration', [$episode->item_id, $episode->id]) }}">
                                                    <i class="lab la-buysellads"></i> @lang('Update Ads')
                                                </a>
                                                <a class="btn btn-sm btn-outline--success" href="{{ route('admin.item.subtitle.list', [$episode->id, $episode->video->id]) }}">
                                                    <i class="las la-file-audio"></i> @lang('Subtitles')
                                                </a>
                                            @else
                                                <a class="btn btn-sm btn-outline--warning" href="{{ route('admin.item.episode.addVideo', $episode->id) }}">
                                                    <i class="la la-cloud-upload-alt"></i>@lang('Upload Video')
                                                </a>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($episodes->hasPages())
                    <div class="card-footer py-4">
                        {{ $episodes->links('admin.partials.paginate') }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="episodeModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Add New Episode')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.item.addEpisode', $item->id) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Thumbnail Image')</label>
                            <div class="image-upload">
                                <div class="thumb">
                                    <div class="avatar-preview">
                                        <div class="profilePicPreview" style="background-image: url({{ getImage('') }})">
                                            <button class="remove-image" type="button"><i class="fa fa-times"></i></button>
                                        </div>
                                    </div>
                                    <div class="avatar-edit">
                                        <input class="profilePicUpload" id="profilePicUpload1" name="image" type="file" accept=".png, .jpg, .jpeg">
                                        <label class="bg--success" for="profilePicUpload1">@lang('Upload Thumbnail Image')</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>@lang('Video Title')</label>
                            <input class="form-control" name="title" type="text" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Version')</label>
                            <select class="form-control" name="version" required>
                                <option value="0">@lang('Free')</option>
                                <option value="1">@lang('Paid')</option>
                            </select>
                        </div>
                        <div class="form-group statusGroup">
                            <label>@lang('Status')</label>
                            <input name="status" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Active')" data-off="@lang('Inactive')" data-width="100%" type="checkbox">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@push('breadcrumb-plugins')
    <button class="btn btn-sm btn-outline--primary addBtn"><i class="las la-plus"></i>@lang('Add New Episode')</button>
@endpush
@push('script')
    <script>
        (function($) {
            "use strict"
            var modal = $('#episodeModal');

            $('.addBtn').click(function() {
                modal.find('form').attr('action', `{{ route('admin.item.addEpisode', $item->id) }}`);
                modal.find('.statusGroup').hide();
                modal.modal('show');
            });

            $('.editBtn').click(function() {
                let data = $(this).data();
                modal.find('input[name=title]').val(data.title);
                modal.find('.profilePicPreview').attr('style', `background-image:url(${data.image})`);
                modal.find('select').val(data.version);
                modal.find('.statusGroup').show();

                if (data.status == 1) {
                    modal.find('input[name=status]').bootstrapToggle('on');
                } else {
                    modal.find('input[name=status]').bootstrapToggle('off');
                }

                modal.find('form').attr('action', `{{ route('admin.item.updateEpisode', '') }}/${data.episode_id}`);

                modal.modal('show');
            });

            modal.on('hidden.bs.modal', function() {
                modal.find('form')[0].reset();
            });

        })(jQuery);
    </script>
@endpush
