<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Episode extends Model
{
    public function video()
    {
    	return $this->hasOne(Video::class);
    }

    public function item()
    {
    	return $this->belongsTo(Item::class);
    }

    public function wishlists()
    {
        return $this->hasMany(Wishlist::class);
    }

    public function scopeHasVideo()
    {
    	return $this->where('status',1)->whereHas('video');
    }
}
