<?php

namespace App\Lib;

use App\Models\GeneralSetting;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class VideoUploader {
    private $general;

    public $path;
    public $file;
    public $oldFile;
    public $oldServer;
    public $uploadedServer;
    public $fileName;
    public $error;

    public function __construct() {
        $this->general = gs();
        $date          = date('Y') . '/' . date('m') . '/' . date('d');
        $this->date    = $date;
    }

    public function upload() {
        $general = $this->general;

        $uploadDisk = $general->server;
        if ($this->oldFile) {
            $this->removeOldFile();
        }
        if ($uploadDisk == 'current') {
            $this->uploadedServer = 0;
            return $this->uploadToCurrentServer();
        }
        if ($uploadDisk == 'custom-ftp') {
            $this->uploadedServer = 1;
            $this->uploadToServer('custom-ftp', 'videos');
        }
        if ($uploadDisk == 'wasabi') {
            $this->uploadedServer = 3;
            $this->uploadToServer('wasabi', 'videos');
        }
    }

    public function uploadToCurrentServer() {
        $file     = $this->file;
        $location = 'assets/videos/';
        $path     = $location . $this->date;

        try {
            $video          = $this->date . '/' . fileUploader($file, $path, null);
            $this->fileName = $video;
        } catch (\Exception$exp) {
            $this->error = true;
        }
    }

    public function uploadToServer($server = null, $param = null) {
        $file     = $this->file;
        $location = $param . '/';
        $path     = $location . $this->date;

        try {
            $fileExtension = $file->getClientOriginalExtension();
            $server == 'wasabi' ? $this->configureWasabi() : $this->configureDisk();

            $file = File::get($file);
            $disk = Storage::disk($server);

            $this->makeDirectory($path, $disk);

            $video = uniqid() . time() . '.' . $fileExtension;
            $disk->put($path . '/' . $video, $file);
            $this->fileName = $path . '/' . $video;

        } catch (\Exception$e) {
            $this->error = true;
        }
    }

    private function makeDirectory($path, $disk) {
        if ($disk->exists($path)) {
            return true;
        }
        $disk->makeDirectory($path);
    }

    public function configureDisk() {
        $general = $this->general;
        //ftp
        Config::set('filesystems.disks.custom-ftp.driver', 'ftp');
        Config::set('filesystems.disks.custom-ftp.host', $general->ftp->host);
        Config::set('filesystems.disks.custom-ftp.username', $general->ftp->username);
        Config::set('filesystems.disks.custom-ftp.password', $general->ftp->password);
        Config::set('filesystems.disks.custom-ftp.port', 21);
        Config::set('filesystems.disks.custom-ftp.root', $general->ftp->root);

    }
    public function configureWasabi() {
        $general = $this->general;
        Config::set('filesystems.disks.wasabi.driver', $general->wasabi->driver);
        Config::set('filesystems.disks.wasabi.key', $general->wasabi->key);
        Config::set('filesystems.disks.wasabi.secret', $general->wasabi->secret);
        Config::set('filesystems.disks.wasabi.region', $general->wasabi->region);
        Config::set('filesystems.disks.wasabi.bucket', $general->wasabi->bucket);
        Config::set('filesystems.disks.wasabi.endpoint', $general->wasabi->endpoint);
    }

    public function removeFtpVideo() {
        $oldFile = $this->oldFile;
        $storage = Storage::disk('custom-ftp');
        if ($storage->exists($oldFile)) {
            $storage->delete($oldFile);
        }

    }

    public function removeOldFile() {
        if ($this->oldServer == 0) {
            $location = 'assets/videos/' . $this->oldFile;
            fileManager()->removeFile($location);
        } elseif ($this->oldServer == 1 || $this->oldServer == 3) {
            try {
                if ($this->oldServer == 3) {
                    $this->configureWasabi();
                    $server = 'wasabi';
                } elseif ($this->oldServer == 1) {
                    $this->configureDisk();
                    $server = 'custom-ftp';
                }
                $disk = Storage::disk($server);
                $disk->delete($this->oldFile);
            } catch (\Exception$e) {

            }
        }
    }

}
