@extends('layouts.app')
@section('css')
	<!-- Sweet Alert CSS -->
	<link href="{{URL::asset('plugins/sweetalert/sweetalert2.min.css')}}" rel="stylesheet" />
	<link href="{{URL::asset('plugins/awselect/awselect.min.css')}}" rel="stylesheet" />
	<!-- RichText CSS -->
	<link href="{{URL::asset('plugins/richtext/richtext.min.css')}}" rel="stylesheet" />
@endsection
@section('page-header')
<!-- PAGE HEADER -->
<div class="page-header mt-5-7">
	<div class="page-leftheader">
		<h4 class="page-title mb-0">{{ __('Product Description') }}</h4>
		<ol class="breadcrumb mb-2">
			<li class="breadcrumb-item"><a href="{{route('user.dashboard')}}"><i class="fa-solid fa-microchip-ai mr-2 fs-12"></i>{{ __('AI Panel') }}</a></li>
			<li class="breadcrumb-item"><a href="{{route('user.templates')}}"> {{ __('Templates') }}</a></li>
			<li class="breadcrumb-item active" aria-current="page"><a href="{{url('#')}}"> {{ __('Product Description') }}</a></li>
		</ol>
	</div>
	<div class="page-rightheader templates-scroller">
		<div id="form-group">
			<select id="template-selection" name="template-selection" data-placeholder="{{ __('Choose your template') }}" data-callback="changeTemplate">
				@foreach ($all_templates as $temp)
					<option data-id="{{ $temp->template_code }}" value="{{ $temp->slug }}" data-icon="{{   $temp->icon }}">{{ $temp->name  }}</option>
				@endforeach																																
			</select>
		</div>
	</div>
</div>
<!-- END PAGE HEADER -->
@endsection
@section('content')

<form id="openai-form" action="" method="post" enctype="multipart/form-data">		
	@csrf
	<div class="row">	
		<div class="col-lg-4 col-md-12 col-sm-12">
			<div class="card border-0" id="template-input">
				<div class="card-body p-5 pb-0">

					<div class="row">
						<div class="template-view">
							<div class="template-icon mb-2 d-flex">
								<div>
									{!! $template->icon !!}
								</div>
								<div>
									<h6 class="mt-1 ml-3 fs-16 number-font">{{ __('Product Description') }} @if($template->professional) <span class="fs-8 btn btn-yellow ml-2"><i class="fa-sharp fa-solid fa-crown mr-2"></i>{{ __('Pro') }}</span> @endif</h6>
								</div>
								<div>
									<a id="{{ $template->template_code }}" @if($favorite) data-tippy-content="{{ __('Remove from favorite') }}" @else data-tippy-content="{{ __('Select as favorite') }}" @endif onclick="favoriteStatus(this.id)"><i id="{{ $template->template_code }}-icon" class="@if($favorite) fa-solid fa-stars @else fa-regular fa-star @endif star"></i></a>
								</div>									
							</div>								
							<div class="template-info">
								<p class="fs-12 text-muted mb-5">{{ __('Write the description about your product and why it worth it') }}</p>
							</div>
						</div>
					</div>

					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">	
								<h6 class="fs-11 mb-2 font-weight-bold">{{ __('Language') }}</h6>								
								<select id="language" name="language" data-placeholder="{{ __('Select input language') }}">		
									@foreach ($languages as $language)
										<option value="{{ $language->language_code }}" data-img="{{ URL::asset($language->language_flag) }}" @if (config('settings.default_language') == $language->language_code) selected @endif> {{ $language->language }}</option>
									@endforeach									
								</select>
								@error('language')
									<p class="text-danger">{{ $errors->first('language') }}</p>
								@enderror	
							</div>
						</div>

						<div class="col-lg-6 col-md-12 col-sm-12">								
							<div class="input-box">								
								<h6 class="fs-11 mb-2 font-weight-bold">{{ __('Product name') }}  <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
								<div class="form-group">							    
									<input type="text" class="form-control @error('title') is-danger @enderror" id="title" name="title" placeholder="e.g. VR, Honda">
									@error('title')
										<p class="text-danger">{{ $errors->first('title') }}</p>
									@enderror
								</div> 
							</div> 
						</div>

						<div class="col-lg-6 col-md-12 col-sm-12">								
							<div class="input-box">								
								<h6 class="fs-11 mb-2 font-weight-bold">{{ __('Audience') }}  <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
								<div class="form-group">							    
									<input type="text" class="form-control @error('audience') is-danger @enderror" id="audience" name="audience" placeholder="e.g. Women, Aliens" required>
									@error('audience')
										<p class="text-danger">{{ $errors->first('audience') }}</p>
									@enderror
								</div> 
							</div> 
						</div>

						<div class="col-sm-12">								
							<div class="input-box">								
								<h6 class="fs-11 mb-2 font-weight-bold">{{ __('Product Description') }}  <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
								<div class="form-group">							    
									<textarea type="text" rows=5 class="form-control @error("description") is-danger @enderror" id="description" name="description" placeholder="e.g. VR is an innovative device that can allow you to be part of virtual world" required></textarea>
									@error('description')
										<p class="text-danger">{{ $errors->first('description') }}</p>
									@enderror
								</div> 
							</div> 
						</div>

						<div class="col-lg-6 col-md-6 col-sm-12">
							<div id="form-group">
								<h6 class="fs-11 mb-2 font-weight-bold">{{ __('Creativity') }} <i class="ml-1 text-dark fs-12 fa-solid fa-circle-info" data-tippy-content="{{ __('Increase or decrease the creativity level to get various results') }}"></i></h6>
								<select id="creativity" name="creativity" data-placeholder="{{ __('Select creativity level') }}">
									<option value=0 @if (config('settings.creativity_default_state') == 'low') selected @endif>{{ __('Low') }}</option>
									<option value=0.5 @if (config('settings.creativity_default_state') == 'average') selected @endif> {{ __('Average') }}</option>																															
									<option value=1 @if (config('settings.creativity_default_state') == 'high') selected @endif> {{ __('High') }}</option>																															
								</select>
							</div>
						</div>

						<div class="col-lg-6 col-md-6 col-sm-12">
							<div id="form-group">
								<h6 class="fs-11 mb-2 font-weight-bold">{{ __('Tone of Voice') }} <i class="ml-1 text-dark fs-12 fa-solid fa-circle-info" data-tippy-content="{{ __('Set result tone of the text as needed') }}"></i></h6>
								<select id="tone" name="tone" data-placeholder="{{ __('Select tone of voice') }}">
									<option value="funny" @if (config('settings.tone_default_state') == 'funny') selected @endif>{{ __('Funny') }}</option>
									<option value="casual" @if (config('settings.tone_default_state') == 'casual') selected @endif> {{ __('Casual') }}</option>																															
									<option value="excited" @if (config('settings.tone_default_state') == 'excited') selected @endif> {{ __('Excited') }}</option>																															
									<option value="professional" @if (config('settings.tone_default_state') == 'professional') selected @endif> {{ __('Professional') }}</option>																															
									<option value="witty" @if (config('settings.tone_default_state') == 'witty') selected @endif> {{ __('Witty') }}</option>																															
									<option value="sarcastic" @if (config('settings.tone_default_state') == 'sarcastic') selected @endif> {{ __('Sarcastic') }}</option>																															
									<option value="feminine" @if (config('settings.tone_default_state') == 'feminine') selected @endif> {{ __('Feminine') }}</option>																															
									<option value="masculine" @if (config('settings.tone_default_state') == 'masculine') selected @endif> {{ __('Masculine') }}</option>																															
									<option value="bold" @if (config('settings.tone_default_state') == 'bold') selected @endif> {{ __('Bold') }}</option>																															
									<option value="dramatic" @if (config('settings.tone_default_state') == 'dramatic') selected @endif> {{ __('Dramatic') }}</option>																															
									<option value="gumpy" @if (config('settings.tone_default_state') == 'gumpy') selected @endif> {{ __('Gumpy') }}</option>																															
									<option value="secretive" @if (config('settings.tone_default_state') == 'secretive') selected @endif> {{ __('Secretive') }}</option>																															
								</select>
							</div>
						</div>
						
						<div class="col-lg-6 col-md-6 col-sm-12">
							<div id="form-group">
								<h6 class="fs-11 mb-2 font-weight-bold">{{ __('Number of Results') }} <i class="ml-1 text-dark fs-12 fa-solid fa-circle-info" data-tippy-content="{{ __('Maximum supported results is 5') }}"></i></h6>
								<select id="max-results" name="max_results" data-placeholder="{{ __('Set max number of results') }}">
									<option value=1 selected>1</option>
									<option value=2>2</option>																															
									<option value=3>3</option>																															
									<option value=4>4</option>																															
									<option value=5>5</option>																															
								</select>
							</div>
						</div>

						<div class="col-lg-6 col-md-6 col-sm-12">								
							<div class="input-box">								
								<h6 class="fs-11 mb-2 font-weight-bold">{{ __('Max Result Length') }} <i class="ml-1 text-dark fs-12 fa-solid fa-circle-info" data-tippy-content="{{ __('Maximum words for each generated text result') }}. {{ __('Maximum allowed length is ') }}{{ $limit }}"></i></h6>
								<div class="form-group">							    
									<input type="number" class="form-control @error('words') is-danger @enderror" id="words" name="words" placeholder="e.g. 100" max="{{ $limit }}" value="200">
									@error('words')
										<p class="text-danger">{{ $errors->first('words') }}</p>
									@enderror
								</div> 
							</div> 
						</div>
					</div>						

					<div class="card-footer border-0 text-center p-0">
						<div class="w-100 pt-2 pb-2">
							<div class="text-center">
								<span id="processing" class="processing-image"><img src="{{ URL::asset('/img/svgs/upgrade.svg') }}" alt=""></span>
								<button type="submit" name="submit" class="btn btn-primary  pl-7 pr-7 fs-11 pt-2 pb-2" id="generate">{{ __('Generate Text') }}</button>
							</div>
						</div>							
					</div>	
					
					<input type="hidden" name="template" value="{{ $template->template_code }}">
			
				</div>
			</div>			
		</div>

		<div class="col-lg-8 col-md-12 col-sm-12">
			<div class="card border-0" id="template-output">
				<div class="card-body">
					<div class="d-flex">
						<div class="w-100">
							<h3 class="card-title fs-16 mt-3 mb-4"><i class="fa-solid fa-scroll mr-4 text-info"></i>{{ __("Generated Result") }}</h3>							
						</div>	
						<div>
							<a id="export-word" class="template-button mr-1" onclick="exportWord();" href="#" data-tippy-content="Export as Word Document"><i class="fa-solid fa-file-word table-action-buttons view-action-button"></i></a>
						</div>	
						<div>
							<a id="export-pdf" class="template-button mr-1" onclick="exportPDF();" href="#" data-tippy-content="Export as PDF Document"><i class="fa-solid fa-file-pdf table-action-buttons view-action-button"></i></a>
						</div>	
						<div>
							<a id="copy-button" class="template-button mr-1" onclick="copyText();" href="#" data-tippy-content="Copy Text"><i class="fa-solid fa-copy table-action-buttons edit-action-button"></i></a>
						</div>
						<div>
							<a id="save-button" class="template-button" target="" onclick="return saveText(this);" href="#" data-tippy-content="Save Changes"><i class="fa-solid fa-floppy-disk-pen table-action-buttons delete-action-button"></i></a>
						</div>					
					</div>

					<div class="row">						
						<div class="col-lg-4 col-md-12 col-sm-12">								
							<div class="input-box mb-2">								
								<div class="form-group">							    
									<input type="text" class="form-control @error('document') is-danger @enderror" id="document" name="document" value="New Document">
									@error('document')
										<p class="text-danger">{{ $errors->first('document') }}</p>
									@enderror
								</div> 
							</div> 
						</div>
						<div class="col-lg-4 col-md-12 col-sm-12">
							<div class="row">
								<div class="col-md-10 col-sm-10 pr-0" id="project-box">
									<div class="form-group">
										<select id="project" name="project" data-placeholder="{{ __('Select Workbook Name') }}">	
											<option value="all"> {{ __('All Workbooks') }}</option>
											@foreach ($workbooks as $workbook)
												<option value="{{ $workbook->name }}" @if (strtolower(auth()->user()->workbook) == strtolower($workbook->name)) selected @endif> {{ ucfirst($workbook->name) }}</option>
											@endforeach											
										</select>
									</div>
								</div>
								<div class="col-md-2 col-sm-2" id="add-project-box">
									<div class="dropdown">
										<button class="btn btn-special create-project" type="button" id="add-project" data-tippy-content="{{ __('Create New Workbook') }}"><i class="fa-solid fa-rectangle-history-circle-plus"></i></button>											
									</div>
								</div>
							</div>
						</div>
					</div>
					<div>						
						<div id="template-textarea">						
							<div class="form-control" name="content" rows="12" id="richtext"></div>
							@error('content')
								<p class="text-danger">{{ $errors->first('content') }}</p>
							@enderror	
						</div>									
					</div>
				</div>
			</div>
		</div>
	</div>
</form>
@endsection

@section('js')
<script src="{{URL::asset('plugins/sweetalert/sweetalert2.all.min.js')}}"></script>
<script src="{{URL::asset('plugins/character-count/jquery-simple-txt-counter.min.js')}}"></script>
<!-- Awselect JS -->
<script src="{{URL::asset('plugins/awselect/awselect-custom.js')}}"></script>
<script src="{{URL::asset('js/export.js')}}"></script>
<script src="{{URL::asset('js/awselect.js')}}"></script>
<!-- RichText JS -->
<script src="{{URL::asset('plugins/richtext/jquery.richtext.min.js')}}"></script>
<script src="{{URL::asset('plugins/pdf/html2canvas.min.js')}}"></script>
<script src="{{URL::asset('plugins/pdf/jspdf.umd.min.js')}}"></script>
<script type="text/javascript">
	$(function () {

		"use strict";

		$('#add-project').on('click', function() {
			$('#projectModal').modal('show');
		});

		$('#richtext').richText({

			// text formatting
			bold: true,
			italic: true,
			underline: true,

			// text alignment
			leftAlign: true,
			centerAlign: true,
			rightAlign: true,
			justify: true,

			// lists
			ol: true,
			ul: true,

			// title
			heading: true,

			// fonts
			fonts: true,
			fontList: [
				"Arial", 
				"Arial Black", 
				"Comic Sans MS", 
				"Courier New", 
				"Geneva", 
				"Georgia", 
				"Helvetica", 
				"Impact", 
				"Lucida Console", 
				"Tahoma", 
				"Times New Roman",
				"Verdana"
			],
			fontColor: true,
			fontSize: true,

			// uploads
			imageUpload: false,
			fileUpload: false,

			// media
			videoEmbed: false,

			// link
			urls: true,

			// tables
			table: true,

			// code
			removeStyles: false,
			code: false,

			// colors
			colors: [],

			// dropdowns
			fileHTML: '',
			imageHTML: '',

			// translations
			translations: {
				'title': 'Title',
				'white': 'White',
				'black': 'Black',
				'brown': 'Brown',
				'beige': 'Beige',
				'darkBlue': 'Dark Blue',
				'blue': 'Blue',
				'lightBlue': 'Light Blue',
				'darkRed': 'Dark Red',
				'red': 'Red',
				'darkGreen': 'Dark Green',
				'green': 'Green',
				'purple': 'Purple',
				'darkTurquois': 'Dark Turquois',
				'turquois': 'Turquois',
				'darkOrange': 'Dark Orange',
				'orange': 'Orange',
				'yellow': 'Yellow',
				'imageURL': 'Image URL',
				'fileURL': 'File URL',
				'linkText': 'Link text',
				'url': 'URL',
				'size': 'Size',
				'responsive': 'Responsive',
				'text': 'Text',
				'openIn': 'Open in',
				'sameTab': 'Same tab',
				'newTab': 'New tab',
				'align': 'Align',
				'left': 'Left',
				'center': 'Center',
				'right': 'Right',
				'rows': 'Rows',
				'columns': 'Columns',
				'add': 'Add',
				'pleaseEnterURL': 'Please enter an URL',
				'videoURLnotSupported': 'Video URL not supported',
				'pleaseSelectImage': 'Please select an image',
				'pleaseSelectFile': 'Please select a file',
				'bold': 'Bold',
				'italic': 'Italic',
				'underline': 'Underline',
				'alignLeft': 'Align left',
				'alignCenter': 'Align centered',
				'alignRight': 'Align right',
				'addOrderedList': 'Add ordered list',
				'addUnorderedList': 'Add unordered list',
				'addHeading': 'Add Heading/title',
				'addFont': 'Add font',
				'addFontColor': 'Add font color',
				'addFontSize' : 'Add font size',
				'addImage': 'Add image',
				'addVideo': 'Add video',
				'addFile': 'Add file',
				'addURL': 'Add URL',
				'addTable': 'Add table',
				'removeStyles': 'Remove styles',
				'code': 'Show HTML code',
				'undo': 'Undo',
				'redo': 'Redo',
				'close': 'Close'
			},
					
			// privacy
			youtubeCookies: false,

			// developer settings
			useSingleQuotes: false,
			height: 0,
			heightPercentage: 0,
			id: "",
			class: "",
			useParagraph: true,
			maxlength: 0,
			callback: undefined,
			useTabForNext: false
		});

		$(document).ready(function() {

			$('#title').simpleTxtCounter({
				maxLength: 100,
				countElem: '<div class="form-text"></div>',
				lineBreak: false,
			});

			$('#audience').simpleTxtCounter({
				maxLength: 100,
				countElem: '<div class="form-text"></div>',
				lineBreak: false,
			});

			$('#description').simpleTxtCounter({
				maxLength: 400,
				countElem: '<div class="form-text"></div>',
				lineBreak: false,
			});

		});	


		// CREATE NEW WORKBOOK
		$(document).on('click', '#add-project', function(e) {

			e.preventDefault();

			Swal.fire({
				title: '{{ __('Create New Workbook') }}',
				showCancelButton: true,
				confirmButtonText: '{{ __('Create') }}',
				reverseButtons: true,
				input: 'text',
			}).then((result) => {
				if (result.value) {
					var formData = new FormData();
					formData.append("new-project", result.value);
					$.ajax({
						headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
						method: 'post',
						url: '/user/workbook',
						data: formData,
						processData: false,
						contentType: false,
						success: function (data) {
							if (data['status'] == 'success') {
								Swal.fire('{{ __('Workbook Created') }}', '{{ __('Workbook has been successfully created') }}', 'success');	
								location.reload();								
							} else {
								Swal.fire('{{ __('Workbook Creation Error') }}', data['message'], 'warning');
							}      
						},
						error: function(data) {
							Swal.fire({ type: 'error', title: 'Oops...', text: 'Something went wrong!' })
						}
					})
				} else if (result.dismiss !== Swal.DismissReason.cancel) {
					Swal.fire('{{ __('No Workbook Name Entered') }}', '{{ __('Make sure to provide a new workbook name before creating') }}', 'warning')
				}
			})
		});
	

		// SUBMIT FORM
		$('#openai-form').on('submit', function(e) {

			e.preventDefault();

			let form = $(this);

			$.ajax({
				headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
				method: 'POST',
				url: 'process',
				data: form.serialize(),
				beforeSend: function() {
					$('#generate').html('');
					$('#generate').prop('disabled', true);
					$('#processing').show().clone().appendTo('#generate'); 
					$('#processing').hide();          
				},
				complete: function() {
					$('#generate').prop('disabled', false);
					$('#processing', '#generate').empty().remove();
					$('#processing').hide();
					$('#generate').html('Generate Text');            
				},
				success: function (data) {		
					
					if (data['status'] == 'success') {
						let formatted_text=nl2br(data['text']);
						let id = document.querySelector('.richText-editor').id;
						let editor = document.getElementById(id);
				
						editor.innerHTML += formatted_text;
						editor.innerHTML += '<br><br><br>';

						let save = document.getElementById('save-button');
						save.setAttribute('target', data['id']);
					
						animateValue("available-words", data['old'], data['current'], 4000);
					} else {						
						Swal.fire('{{ __('Text Generation Error') }}', data['message'], 'warning');
					}
				},
				error: function(data) {
					$('#generate').prop('disabled', false);
            		$('#generate').html('Generate Text'); 
					console.log(data)
				}
			});
		});
	});

	function nl2br (str, is_xhtml) {
     	var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';
     	return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
  	} 

	function favoriteStatus(id) {

		let icon, card;
		let formData = new FormData();
		formData.append("id", id);

		$.ajax({
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
			method: 'post',
			url: 'favorite',
			data: formData,
			processData: false,
			contentType: false,
			success: function (data) {

				if (data['status'] == 'success') {
					if (data['set']) {
						Swal.fire('{{ __('Template Removed from Favorites') }}', '{{ __('Selected template has been successfully removed from favorites') }}', 'success');
						icon = document.getElementById(id + '-icon');
						icon.classList.remove("fa-solid");
						icon.classList.remove("fa-stars");
						icon.classList.add("fa-regular");
						icon.classList.add("fa-star");			
					} else {
						Swal.fire('{{ __('Template Added to Favorites') }}', '{{ __('Selected template has been successfully added to favorites') }}', 'success');
						icon = document.getElementById(id + '-icon');
						icon.classList.remove("fa-regular");
						icon.classList.remove("fa-star");
						icon.classList.add("fa-solid");
						icon.classList.add("fa-stars");
					}
													
				} else {
					Swal.fire('{{ __('Favorite Setting Issue') }}', '{{ __('There as an issue with setting favorite status for this template') }}', 'warning');
				}      
			},
			error: function(data) {
				Swal.fire('Oops...','Something went wrong!', 'error')
			}
		})
	}

	function animateValue(id, start, end, duration) {
		if (start === end) return;
		var range = end - start;
		var current = start;
		var increment = end > start? 1 : -1;
		var stepTime = Math.abs(Math.floor(duration / range));
		var obj = document.getElementById(id);
		var timer = setInterval(function() {
			current += increment;
			obj.innerHTML = current;
			if (current == end) {
				clearInterval(timer);
			}
		}, stepTime);
	}

	function changeTemplate(value) {
		let url = '{{ url('user/templates') }}/' + value;
		window.location.href=url;
	}

	function saveText(event) {

		//let textarea = document.querySelector('.richText-editor').textContent;
		let textarea = document.querySelector('.richText-editor').innerHTML;
		let title = document.getElementById('document').value;
		let workbook = document.getElementById('project').value;


		if (!event.target) {
			toastr.warning('You will need to generate AI text first before saving your changes');
		} else {
			$.ajax({
				headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
				method: 'POST',
				url: '/user/templates/save',
				data: { 'id': event.target, 'text': textarea, 'title': title, 'workbook': workbook },
				success: function (data) {					
					if (data['status'] == 'success') {
						toastr.success('Changes have been successfully saved');
					} else {						
						toastr.warning('There was an issue while saving your changes');
					}
				},
				error: function(data) {
					toastr.warning('There was an issue while saving your changes');
				}
			});

			return false;
		}
		
	}

</script>
@endsection