import { defineConfig, normalizePath } from 'vite';
import { viteStaticCopy } from 'vite-plugin-static-copy';
import laravel from 'laravel-vite-plugin';
import path from 'node:path'



export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/themes/admin/assets/sass/app.scss',
                'resources/themes/canvas/assets/sass/app.scss',
                'resources/themes/default/assets/sass/install.scss',
                'resources/themes/canvas/assets/sass/jsoneditor.scss',
                'resources/themes/canvas/assets/js/jsoneditor.js',
                'resources/themes/admin/assets/js/app.js',
                'resources/themes/canvas/assets/js/app.js',
                'resources/themes/canvas/assets/js/meme/meme.js',
            ],
            refresh: true,
        }),
        viteStaticCopy({
            targets: [
                {
                    src: normalizePath(path.resolve(__dirname, './resources/themes/canvas/assets/images')),
                    dest: normalizePath(path.resolve(__dirname, './public/themes/canvas')),
                },
                {
                    src: normalizePath(path.resolve(__dirname, './resources/themes/default/assets/images')),
                    dest: normalizePath(path.resolve(__dirname, './public/themes/default')),
                },
                {
                    src: normalizePath(path.resolve(__dirname, './resources/themes/default/assets/js')),
                    dest: normalizePath(path.resolve(__dirname, './public/themes/default')),
                },
                // {
                //     src: normalizePath(path.resolve(__dirname, './resources/themes/admin/assets/js/ckeditor')),
                //     dest: normalizePath(path.resolve(__dirname, './public/themes/admin/js')),
                // },
            ]
        })
    ],
});
