<x-application-blog-wrapper>
    <x-page-wrapper>
        <div class="single-content">
            <div class="post">
                @if ($post->getFirstMediaUrl('featured-image'))
                    <div class="blog-img box-shadow p-0">
                        <img class="img-fluid" src="{{ $post->getFirstMediaUrl('featured-image') }}"
                            alt="{{ $post->title }}">
                    </div>
                @endif
                <div class="content">
                    <h1 class="title">{{ $post->title }}</h1>
                    <div class="post-meta d-flex mb-3">
                        <div class="user-pic me-3">
                            @if ($post->author->getFirstMediaUrl('avatar'))
                                <img class="img-fluid" src="{{ $post->author->getFirstMediaUrl('avatar') }}"
                                    alt="Profile-Image">
                            @else
                                <img  class="img-fluid" src="{{ setting('default_user_image') }}"
                                    alt="Profile-Image">
                            @endif
                        </div>
                        <div class="vcard">
                            <span class="d-block">
                                {{ $post->author->name }}
                                @foreach ($post->categories as $category)
                                    @if ($loop->index == 0)
                                        <span>@lang('common.in')</span>
                                    @endif
                                    @if ($loop->index > 0)
                                        <span>,</span>
                                    @endif
                                    <a href="{{ route('blog.category', $category->slug) }}">{{ $category->name }}</a>
                                @endforeach
                            </span>
                            <span class="date-read">{{ $post->created_at->format('M d') }} <span class="mx-1">/</span>
                                {{ $post->created_at->diffForHumans() }}</span>
                        </div>
                    </div>
                    {!! $post->contents !!}
                </div>
                <div class="categories pt-3 pb-3">
                    <span>@lang('admin.tags')</span>
                    @foreach ($post->tags as $tag)
                        <a href="{{ route('blog.tag', $tag->slug) }}"
                            class="badge bg-primary py-2 p-3 mb-2 rounded-pill">{{ $tag->name }}</a>
                    @endforeach
                </div>
                <hr>
                <x-page-social-share :url="route('posts.show', ['slug' => $post->slug])" :title="$post->title" />
                {{-- <hr>
                <div class="pt-3">
                    <div class="hero-title">
                        <h2>6 Comments</h2>
                    </div>
                    <ul class="comment-list">
                        <li class="comment">
                            <div class="vcard">
                                <img src="/assets/admin.jpg" alt="Image">
                            </div>
                            <div class="comment-body">
                                <h3>Jean Doe</h3>
                                <div class="meta">January 9, 2018 at 2:21pm</div>
                                <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur quidem laborum
                                    necessitatibus, ipsam impedit vitae autem, eum officia, fugiat saepe enim sapiente
                                    iste
                                    iure! Quam voluptas earum impedit necessitatibus, nihil?</p>
                                <p><a href="#" class="btn btn-light btn-sm rounded-pill">Reply</a></p>
                            </div>
                        </li>
                        <li class="comment">
                            <div class="vcard">
                                <img src="/assets/admin.jpg" alt="Image">
                            </div>
                            <div class="comment-body">
                                <h3>Jean Doe</h3>
                                <div class="meta">January 9, 2018 at 2:21pm</div>
                                <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur quidem laborum
                                    necessitatibus, ipsam impedit vitae autem, eum officia, fugiat saepe enim sapiente
                                    iste
                                    iure! Quam voluptas earum impedit necessitatibus, nihil?</p>
                                <p><a href="#" class="btn btn-light btn-sm rounded-pill">Reply</a></p>
                            </div>
                            <ul class="children">
                                <li class="comment">
                                    <div class="vcard">
                                        <img src="/assets/admin.jpg" alt="Image">
                                    </div>
                                    <div class="comment-body">
                                        <h3>Jean Doe</h3>
                                        <div class="meta">January 13, 2023 at 2:21pm</div>
                                        <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur quidem
                                            laborum
                                            necessitatibus, ipsam impedit vitae autem, eum officia, fugiat saepe enim
                                            sapiente
                                            iste iure! Quam voluptas earum impedit necessitatibus, nihil?</p>
                                        <p><a href="#" class="btn btn-light btn-sm rounded-pill">Reply</a></p>
                                    </div>
                                    <ul class="children">
                                        <li class="comment">
                                            <div class="vcard">
                                                <img src="/assets/admin.jpg" alt="Image">
                                            </div>
                                            <div class="comment-body">
                                                <h3>Jean Doe</h3>
                                                <div class="meta">January 13, 2023 at 2:21pm</div>
                                                <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
                                                    quidem laborum
                                                    necessitatibus, ipsam impedit vitae autem, eum officia, fugiat saepe
                                                    enim sapiente
                                                    iste iure! Quam voluptas earum impedit necessitatibus, nihil?</p>
                                                <p><a href="#"
                                                        class="btn btn-light btn-sm rounded-pill">Reply</a></p>
                                            </div>
                                            <ul class="children">
                                                <li class="comment">
                                                    <div class="vcard">
                                                        <img src="/assets/admin.jpg" alt="Image">
                                                    </div>
                                                    <div class="comment-body">
                                                        <h3>Jean Doe</h3>
                                                        <div class="meta">January 13, 2023 at 2:21pm</div>
                                                        <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                                                            Pariatur quidem
                                                            laborum necessitatibus, ipsam impedit vitae autem, eum
                                                            officia, fugiat saepe
                                                            enim sapiente iste iure! Quam voluptas earum impedit
                                                            necessitatibus, nihil?
                                                        </p>
                                                        <p><a href="#"
                                                                class="btn btn-light btn-sm rounded-pill">Reply</a></p>
                                                    </div>
                                                </li>
                                            </ul>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="comment">
                            <div class="vcard">
                                <img src="/assets/admin.jpg" alt="Image">
                            </div>
                            <div class="comment-body">
                                <h3>Jean Doe</h3>
                                <div class="meta">January 13, 2023 at 2:21pm</div>
                                <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur quidem laborum
                                    necessitatibus, ipsam impedit vitae autem, eum officia, fugiat saepe enim sapiente
                                    iste
                                    iure! Quam voluptas earum impedit necessitatibus, nihil?</p>
                                <p><a href="#" class="btn btn-light btn-sm rounded-pill">Reply</a></p>
                            </div>
                        </li>
                    </ul>
                    <div class="comment-form-wrap pt-5 bg-light">
                        <div class="hero-title">
                            <h2 class="mb-3 ps-3">Leave a comment</h2>
                        </div>
                        <form class="p-3">
                            <div class="mb-3">
                                <label for="name">Name *</label>
                                <input type="text" class="form-control" id="name">
                            </div>
                            <div class="mb-3">
                                <label for="email">Email *</label>
                                <input type="email" class="form-control" id="email">
                            </div>
                            <div class="mb-3">
                                <label for="website">Website</label>
                                <input type="url" class="form-control" id="website">
                            </div>
                            <div class="mb-3">
                                <label for="message">Message</label>
                                <textarea name="" id="message" cols="30" rows="10" class="form-control"></textarea>
                            </div>
                            <div class="mb-3 text-end">
                                <button type="submit" class="btn btn-primary">Post Comment</button>
                            </div>
                        </form>
                    </div>
                </div> --}}
            </div>
        </div>
    </x-page-wrapper>
</x-application-blog-wrapper>
