<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="@lang('front.direction')"
    theme-mode="{{ (setting('dark_default_theme') == 'dark' && setting('enable_dark_mode') == 1) || request()->cookie('siteMode') === 'dark' ? 'dark' : 'light' }}">

<head>
    <meta name="app-search" content="{{ route('search') }}">
    @vite(['resources/themes/canvas/assets/sass/app.scss', 'resources/themes/canvas/assets/js/app.js'])
    @meta_tags()
    @meta_tags('header')
    @stack('page_header')
</head>

<body>
    <x-application-theme-switch />
    <main class="main-wrapper">
        <x-application-navbar />
        <x-application-breadcrumbs />
        <div class="contant-wrap">
            <div class="container mt-4">
                <div class="row">
                    <div class="col">
                        {{ $slot }}
                    </div>
                    @if (isset($sidebar))
                        {{ $sidebar }}
                    @endif
                </div>
            </div>
        </div>
    </main>
    <x-application-footer />
    <x-application-signout />
    <x-application-messages />
    <x-application-loader />
    @meta_tags('footer')
    @stack('page_scripts')
</body>

</html>
