@props([
    'tool' => false,
])
<div {!! $attributes->merge(['class' => 'wrap-content', 'id']) !!}>
    <div class="hero-title">
        <div class="tool-favorite-btn">
            <button
                class="btn btn-outline-primary rounded-circle add-fav add-favorite-btn @if (Auth::check() && $tool->hasBeenFavoritedBy(Auth::user())) active @endif"
                data-id="{{ $tool->id }}" type="button" id="button" data-url="{{ route('tool.favouriteAction') }}">
                <i class="an an-heart"></i>
            </button>
        </div>
        @if (!empty($tool->name))
            <h1>{{ $tool->name }}</h1>
        @endif
        @if (!empty($tool->description))
            <p>{{ $tool->description ?? '' }}</p>
        @endif
    </div>
    {{ $slot }}
</div>
