@props([
    'tool' => null,
    'name' => null,
    'label' => null,
    'plans' => false,
    'upTo' => null,
])
<div class="row align-items-center">
    <div {{ $attributes->merge(['class' => 'col-md-6']) }}>
        @if (Lang::has("tools.{$label}"))
            <span class="text-primary"> @lang("tools.{$label}", ['count' => $tool->$name])</span>
        @endif
    </div>
    @if ($plans)
        <div {{ $attributes->merge(['class' => 'col-md-6 text-end']) }}>
            @if (Lang::has("tools.{$upTo}"))
                <span class="px-2">@lang("tools.{$upTo}")</span>
            @endif
            <a href="{{ route('plans.list') }}" class="btn btn-primary btn-sm rounded-pill" type="button"
                id="button">@lang('tools.goPro')</a>
        </div>
    @endif
</div>
