@props(['url', 'title'])
<div class="d-flex align-items-center mb-3">
    <div class="fw-bold me-2">
        <h3 class="mb-0">@lang('profile.shareOnSocialMedia')</h3>
    </div>
    <ul class="nav nav-social style2">
        <li>
            <a title="@lang('profile.shareToBrand', ['brand' => 'Facebook'])" data-bs-toggle="tooltip" data-placement="top"
                class="btn-social btn btn-sm social-share btn-facebook"
                href="https://www.facebook.com/share.php?u={{ urlencode($url) }}&amp;quote={{ urlencode($title) }}"
                rel="nofollow noreferrer noopener">
                <svg width="55" height="55" viewBox="0 0 55 55" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M31.416 52H22.0382V30.3835H14V21.1618H21.626V13.9233C21.6556 12.414 21.9992 10.9257 22.6364 9.54623C23.2736 8.16677 24.1915 6.92408 25.3359 5.89148C27.6844 3.89016 30.7565 2.85736 33.8893 3.01589H39.6603H41V10.7502H36.0534C35.3751 10.6962 34.6927 10.7834 34.0525 11.0059C33.4124 11.2283 32.8295 11.5808 32.3435 12.0393C31.5783 12.9247 31.2078 14.0653 31.313 15.2124V21.261H40.8969L38.9389 30.4827H31.313L31.416 52Z" />
                </svg>
            </a>
        </li>
        <li>
            <a title="@lang('profile.shareToBrand', ['brand' => 'Twitter'])" data-bs-toggle="tooltip" data-placement="top"
                class="btn-social btn btn-sm social-share btn-twitter"
                href="https://twitter.com/intent/tweet?text={{ urlencode($title) }} {{ urlencode($url) }}"
                rel="nofollow noreferrer noopener">
                <svg width="55" height="55" viewBox="0 0 55 55" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M48.3 17.0502V18.4676C48.2841 23.583 47.0491 28.6189 44.7 33.1479C42.168 38.3349 38.2252 42.6819 33.3357 45.6772C28.4462 48.6725 22.8133 50.1915 17.1 50.0555C11.053 50.0603 5.12682 48.341 0 45.0946C0.861774 45.2264 1.73823 45.2264 2.6 45.0946C5.14839 45.1022 7.68119 44.6919 10.1 43.8796C12.3812 43.064 14.5108 41.8662 16.4 40.3361C14.0823 40.3291 11.8321 39.546 10 38.1088C8.14637 36.7216 6.77976 34.7703 6.10001 32.5404C6.79491 32.6613 7.50509 32.6613 8.2 32.5404H10.6C8.09584 32.0341 5.83776 30.6767 4.2 28.6931C2.5868 26.7314 1.70237 24.26 1.7 21.7073C3.24356 22.6346 5.00517 23.1242 6.8 23.1248C5.32382 22.0555 4.09535 20.6736 3.2 19.075C2.31604 17.3936 1.86871 15.5124 1.90001 13.6079C2.08966 11.5582 2.89198 9.61572 4.2 8.03951C6.95437 11.4 10.3571 14.156 14.2 16.139C18.0996 18.2086 22.4014 19.3838 26.8 19.5812C26.7367 18.7726 26.7367 17.9601 26.8 17.1514C26.7853 15.1591 27.3036 13.1999 28.3 11.4818C29.3268 9.8191 30.7329 8.43027 32.4 7.43203C34.0597 6.43171 35.9699 5.93942 37.9 6.01463C39.3768 5.93073 40.8518 6.20856 42.2 6.82458C43.5223 7.51633 44.7356 8.40349 45.8 9.45691C48.2828 9.00094 50.6579 8.07343 52.8 6.72333C51.9953 9.33442 50.2449 11.5407 47.9 12.8992C50.113 12.6895 52.2759 12.1078 54.3 11.178C52.5357 13.3681 50.5217 15.3391 48.3 17.0502V17.0502Z" />
                </svg>
            </a>
        </li>
        <li>
            <a title="@lang('profile.shareToBrand', ['brand' => 'Pinterest'])" data-bs-toggle="tooltip" data-placement="top"
                class="btn-social btn btn-sm social-share btn-pinterest"
                href="https://pinterest.com/pin/create/link/?url={{ urlencode($url) }}">
                <svg width="55" height="55" viewBox="0 0 55 55" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M38.8 3.71935C42.5587 5.95578 45.691 9.12704 47.9 12.9325C50.1482 16.7598 51.3236 21.135 51.3 25.5879C51.3495 30.0442 50.1721 34.4264 47.9 38.2433C45.7417 42.1115 42.6008 45.3248 38.8028 47.55C35.0048 49.7753 30.688 50.9315 26.3 50.8987C23.8287 50.9606 21.3638 50.6188 19 49.8863C20.2822 47.7862 21.3223 45.5442 22.1 43.2043L23.6 37.2309C24.1973 38.0809 24.9856 38.7749 25.9 39.2558C26.9964 39.775 28.1896 40.0511 29.3999 40.0657C31.7708 40.1098 34.0902 39.3626 36 37.9396C38.0263 36.4524 39.6441 34.4661 40.7 32.1687C41.8275 29.693 42.4077 26.998 42.4 24.2718C42.4007 21.6427 41.6354 19.0719 40.2 16.881C38.8933 14.6108 36.9891 12.753 34.7 11.5151C32.2535 10.2517 29.5463 9.59248 26.8 9.59147C23.6155 9.5294 20.4729 10.3336 17.7 11.9201C15.3806 13.2085 13.4725 15.1402 12.2 17.4885C10.9173 19.806 10.2618 22.4254 10.2999 25.0817C10.3237 27.0336 10.7316 28.961 11.5 30.7513C12.2046 32.5127 13.5203 33.9528 15.2 34.8011C15.2 34.8011 16 34.8011 16.3 34.8011C16.253 34.296 16.253 33.7875 16.3 33.2824V31.9663C16.3567 31.6993 16.3567 31.4232 16.3 31.1563C15.6964 30.3609 15.2236 29.472 14.9 28.524C14.596 27.505 14.4278 26.4495 14.3999 25.3854C14.4122 23.4738 14.8933 21.5952 15.8 19.9183C16.6542 18.2849 17.9338 16.9194 19.5 15.9698C21.3776 14.8566 23.5247 14.2957 25.7 14.3499C27.0793 14.3164 28.4517 14.5585 29.7386 15.0622C31.0255 15.566 32.2017 16.3217 33.2 17.286C34.1511 18.2559 34.8983 19.4108 35.3967 20.681C35.8951 21.9512 36.1344 23.3104 36.1 24.6767C36.2265 27.6072 35.4583 30.5059 33.9 32.9787C33.3043 33.9458 32.4809 34.7481 31.5035 35.3135C30.5261 35.879 29.4253 36.1899 28.3 36.2185C27.7279 36.2194 27.1625 36.093 26.6441 35.848C26.1256 35.6031 25.6667 35.2456 25.3 34.8011C24.9234 34.385 24.6607 33.8765 24.5379 33.326C24.4151 32.7755 24.4365 32.2021 24.6 31.6625C24.8478 30.4252 25.182 29.2072 25.6 28.0177C26.155 26.4824 26.5244 24.8846 26.7 23.2593C26.7453 22.3142 26.4622 21.3829 25.9 20.627C25.6106 20.2743 25.2411 19.998 24.8231 19.8216C24.4051 19.6453 23.9511 19.5742 23.5 19.6146C22.8561 19.6101 22.2222 19.7759 21.661 20.0955C21.0997 20.4152 20.6306 20.8775 20.3 21.4369C19.3491 22.68 18.8542 24.2188 18.9 25.7904C18.8032 26.699 18.8032 27.6154 18.9 28.524V29.6376L16 42.2931C15.6065 44.5026 15.6065 46.7656 16 48.9751V48.9751C11.2882 47.1564 7.23909 43.9212 4.39674 39.7043C1.55439 35.4873 0.0549846 30.4905 0.099983 25.3854C0.0896413 20.9476 1.22736 16.5844 3.39996 12.73C5.64726 8.92032 8.81275 5.75033 12.6 3.51686C16.39 1.26396 20.705 0.0756683 25.1 0.0745874C29.9182 -0.0731239 34.6759 1.19262 38.8 3.71935V3.71935Z" />
                </svg>
            </a>
        </li>
        <li>
            <a title="@lang('profile.shareToBrand', ['brand' => 'Reddit'])" data-bs-toggle="tooltip" data-placement="top"
                class="btn-social btn btn-sm social-share btn-reddit"
                href="https://www.reddit.com/submit?url={{ urlencode($url) }}&amp;title={{ urlencode($title) }}">
                <svg width="55" height="55" viewBox="0 0 55 55" xmlns="http://www.w3.org/2000/svg"
                    rel="nofollow noreferrer noopener">
                    <path
                        d="M54.0047 29.8068C53.4403 30.7735 52.6049 31.5487 51.6047 32.0341C51.6938 32.5023 51.6938 32.9834 51.6047 33.4515C51.5604 35.7137 50.9031 37.9201 49.7047 39.8299C48.3561 41.9696 46.5435 43.7701 44.4047 45.0945C42.0181 46.6848 39.3799 47.8491 36.6047 48.5368C33.6411 49.3639 30.5788 49.7727 27.5047 49.7517C21.7175 50.0807 15.9668 48.634 11.0047 45.6008C8.81598 44.3067 6.96455 42.5017 5.60474 40.3361C4.41181 38.4293 3.78687 36.2148 3.80474 33.9578V32.3379C2.96257 31.7361 2.27644 30.9372 1.80473 30.0093C1.23878 29.1029 0.959647 28.0433 1.00471 26.972C0.991444 26.1259 1.1446 25.2856 1.45526 24.5C1.76592 23.7144 2.22788 22.9993 2.81421 22.3962C3.40055 21.7932 4.09954 21.3143 4.87049 20.9874C5.64143 20.6606 6.46891 20.4923 7.30472 20.4924C8.78505 20.514 10.2205 21.0103 11.4047 21.9098C13.6402 20.5366 16.0675 19.5126 18.6047 18.8725C21.2961 18.051 24.0937 17.6415 26.9047 17.6576L30.4047 6.52082C30.4144 6.34087 30.4766 6.16789 30.5834 6.02372C30.6902 5.87956 30.8368 5.77068 31.0047 5.71087C31.0047 5.71087 31.7047 5.71087 32.0047 5.71087L40.9047 7.83699C41.4241 6.99289 42.1467 6.29615 43.0047 5.81212C43.8327 5.2551 44.8111 4.97209 45.8047 5.00217C46.5066 4.98246 47.2051 5.10685 47.8582 5.36786C48.5113 5.62886 49.1054 6.02106 49.6047 6.52082C50.124 7.03316 50.5339 7.64794 50.8091 8.3271C51.0843 9.00626 51.219 9.73537 51.2047 10.4693C51.2172 11.188 51.0814 11.9014 50.8059 12.5639C50.5303 13.2264 50.1212 13.8234 49.6047 14.3166C49.1054 14.8163 48.5113 15.2085 47.8582 15.4695C47.2051 15.7305 46.5066 15.8549 45.8047 15.8352C44.4405 15.8437 43.1217 15.3385 42.1047 14.4178C41.587 13.9413 41.1696 13.3639 40.8775 12.7203C40.5854 12.0766 40.4246 11.3799 40.4047 10.6718L32.9047 9.0519L30.0047 18.0626C32.618 18.0625 35.2154 18.4723 37.7047 19.2775C40.0543 19.9169 42.284 20.943 44.3047 22.3148C44.8529 21.7966 45.4982 21.3952 46.2025 21.1343C46.9068 20.8734 47.6557 20.7584 48.4047 20.7961C49.2312 20.7808 50.0513 20.9445 50.8102 21.2763C51.569 21.6081 52.249 22.1002 52.8047 22.7198C53.4296 23.2936 53.9234 23.9985 54.2516 24.7854C54.5797 25.5722 54.7344 26.4221 54.7047 27.2757C54.6419 28.1585 54.4038 29.0193 54.0047 29.8068ZM17.4047 33.3503C18.1343 34.0522 19.0984 34.4499 20.1047 34.464C21.0805 34.4446 22.0115 34.0458 22.7047 33.3503C23.2031 32.8139 23.539 32.1439 23.6724 31.42C23.8059 30.696 23.7313 29.9485 23.4575 29.2662C23.1837 28.5839 22.7223 27.9955 22.1279 27.5709C21.5336 27.1463 20.8314 26.9033 20.1047 26.8707C19.5964 26.8746 19.0943 26.9845 18.6298 27.1935C18.1652 27.4025 17.7482 27.7062 17.4047 28.0857C17.0538 28.4259 16.7746 28.8345 16.5838 29.2869C16.3931 29.7393 16.2947 30.2261 16.2947 30.718C16.2947 31.2099 16.3931 31.6967 16.5838 32.1491C16.7746 32.6015 17.0538 33.0101 17.4047 33.3503V33.3503ZM37.4047 40.4373C37.3641 40.2416 37.28 40.0578 37.1587 39.8999C37.0374 39.742 36.8821 39.6142 36.7047 39.5261C36.4087 39.3259 36.0607 39.2191 35.7047 39.2191C35.3487 39.2191 35.0007 39.3259 34.7047 39.5261C32.7309 40.9473 30.3146 41.5949 27.9047 41.3485C25.5559 41.6121 23.1961 40.9605 21.3047 39.5261C20.9789 39.4246 20.6305 39.4246 20.3047 39.5261C19.947 39.4099 19.5624 39.4099 19.2047 39.5261C19.0903 39.8537 19.0903 40.211 19.2047 40.5386C19.1045 40.8684 19.1045 41.2212 19.2047 41.551C21.6832 43.6525 24.8843 44.6721 28.1047 44.3858C29.7 44.5389 31.3094 44.3669 32.838 43.88C34.3666 43.3931 35.7833 42.6012 37.0047 41.551C37.2107 41.2198 37.2823 40.8208 37.2047 40.4373H37.4047ZM38.8047 33.3503C39.4443 32.6264 39.7979 31.6892 39.7979 30.718C39.7979 29.7467 39.4443 28.8096 38.8047 28.0857C38.4856 27.7022 38.0875 27.394 37.6384 27.1825C37.1893 26.9711 36.7 26.8615 36.2047 26.8615C35.7094 26.8615 35.2201 26.9711 34.771 27.1825C34.3219 27.394 33.9239 27.7022 33.6047 28.0857C33.1978 28.4146 32.8641 28.8267 32.6253 29.2951C32.3865 29.7636 32.248 30.2778 32.2189 30.8041C32.1899 31.3304 32.2709 31.8571 32.4566 32.3495C32.6424 32.842 32.9287 33.2892 33.2969 33.662C33.6651 34.0347 34.1068 34.3246 34.5932 34.5127C35.0797 34.7007 35.5998 34.7827 36.1196 34.7533C36.6395 34.7239 37.1474 34.5837 37.6101 34.342C38.0728 34.1002 38.4799 33.7623 38.8047 33.3503V33.3503ZM44.3047 7.93824C43.862 8.43941 43.6172 9.08821 43.6172 9.7606C43.6172 10.433 43.862 11.0818 44.3047 11.583C44.7997 12.0312 45.4406 12.2791 46.1047 12.2791C46.7689 12.2791 47.4097 12.0312 47.9047 11.583C48.3475 11.0818 48.5923 10.433 48.5923 9.7606C48.5923 9.08821 48.3475 8.43941 47.9047 7.93824C47.4097 7.48997 46.7689 7.24215 46.1047 7.24215C45.4406 7.24215 44.7997 7.48997 44.3047 7.93824V7.93824Z" />
                </svg>
            </a>
        </li>
        <li class="nav-item d-none">
            <a title="@lang('profile.shareToBrand', ['brand' => 'WhatsApp'])" data-bs-toggle="tooltip" data-placement="top" target="_top"
                class="btn-social btn btn-sm btn-whatsapp"
                href="whatsapp://send?text={{ urlencode($title) }}%20%0A{{ urlencode($url) }}">
                <svg width="55" height="55" viewBox="0 0 55 55" xmlns="http://www.w3.org/2000/svg"
                    rel="nofollow noreferrer noopener">
                    <path
                        d="M49.0503 15.708C50.3052 18.7881 50.9666 22.0751 51 25.398C50.9856 29.8469 49.7815 34.212 47.5111 38.046C45.2878 41.8176 42.1476 44.9741 38.3783 47.226C34.4755 49.5632 30.0051 50.7975 25.4487 50.796C21.1792 50.7521 16.9858 49.6663 13.2374 47.634L0 51L3.8994 38.046C1.64671 34.1884 0.460215 29.8074 0.460215 25.347C0.460215 20.8866 1.64671 16.5056 3.8994 12.648C6.10265 8.82673 9.29047 5.65803 13.1348 3.468C17.0239 1.19826 21.4519 0.00108892 25.9618 0C29.2704 0.0435105 32.5418 0.700781 35.6076 1.93801C38.6945 3.24255 41.4861 5.1503 43.8169 7.548C46.1201 9.87123 47.9035 12.652 49.0503 15.708ZM36.2233 43.452C39.3679 41.5512 42.0072 38.9277 43.9195 35.802C45.7336 32.6999 46.7225 29.1894 46.7928 25.602C46.7741 22.8358 46.2165 20.0994 45.1509 17.544C44.0949 14.9777 42.5237 12.6524 40.5332 10.71C38.6007 8.70577 36.2554 7.14009 33.6579 6.12C31.1198 5.07119 28.4025 4.51714 25.6539 4.48801C22.0307 4.55617 18.4902 5.57675 15.3924 7.446C12.2478 9.34679 9.60845 11.9703 7.69618 15.096C5.88624 18.1998 4.89768 21.7092 4.82294 25.296C4.81338 29.2396 5.95396 33.1014 8.10664 36.414L8.61972 37.23L6.46479 45.084L14.4688 42.738L15.2897 43.248C18.5368 45.2059 22.2667 46.2299 26.0644 46.206C29.6296 46.1501 33.1232 45.203 36.2233 43.452V43.452ZM37.5574 30.6C37.9164 30.7641 38.2325 31.0085 38.4809 31.314V32.436C38.577 33.0443 38.577 33.6637 38.4809 34.272C38.067 35.0822 37.4253 35.7554 36.6338 36.21C35.9529 36.7729 35.1418 37.1585 34.2736 37.332C32.959 37.6519 31.5862 37.6519 30.2716 37.332C28.967 37.0093 27.6958 36.5653 26.4749 36.006C23.549 34.7787 20.9497 32.8932 18.8813 30.498C17.696 29.2486 16.5988 27.9195 15.5976 26.52V26.52C14.1281 24.7219 13.2663 22.509 13.1348 20.196C13.156 18.3379 13.8067 16.5412 14.9819 15.096V15.096C15.2181 14.8427 15.5037 14.6398 15.8212 14.4996C16.1387 14.3593 16.4816 14.2846 16.829 14.28H18.163H18.8813C19.157 14.533 19.3681 14.8477 19.497 15.198C20.0171 16.8452 20.6691 18.4483 21.4467 19.992C21.551 20.3934 21.551 20.8146 21.4467 21.216C21.2879 21.5816 21.0808 21.9247 20.831 22.236L19.8048 23.358V23.868C19.7109 24.132 19.7109 24.42 19.8048 24.684C20.1544 25.2709 20.5673 25.8181 21.0362 26.316C21.6757 27.2893 22.434 28.1801 23.2938 28.968C24.7329 30.1513 26.3194 31.1455 28.0141 31.926V31.926C28.7324 31.926 29.2455 31.926 29.5533 31.926L31.6056 29.376C31.7534 29.1473 31.9684 28.9693 32.2213 28.866H33.0423L35.1972 29.886L37.3521 30.804L37.5574 30.6Z" />
                </svg>
            </a>
        </li>
        <li>
            <a title="@lang('profile.emailThisPage')" data-bs-toggle="tooltip" data-placement="top"
                class="btn-social btn btn-sm btn-email"
                href="mailto:?body={{ __('profile.shareToEmailText', ['title' => $title, 'url' => $url]) }}"
                rel="nofollow noreferrer noopener">
                <svg width="55" height="55" viewBox="0 0 55 55" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M52 52.6291H2V22.2561C2.03494 21.8376 2.21156 21.4442 2.49999 21.1424L24.7 3.01985C25.0147 2.67164 25.4029 2.39977 25.8358 2.22448C26.2686 2.04919 26.7349 1.97499 27.2 2.00741C27.6239 1.99745 28.0455 2.07287 28.4403 2.22929C28.8352 2.38572 29.1954 2.62003 29.5 2.9186L51.8 21.0412C51.9148 21.4033 51.9148 21.7927 51.8 22.1548L52 52.6291ZM47.2 25.5971L28.9 37.0376C28.4066 37.1542 27.8934 37.1542 27.4 37.0376C26.8716 37.1414 26.3284 37.1414 25.8 37.0376L7.2 25.5971V28.8369L25.3 40.1762C25.7695 40.5071 26.3279 40.6846 26.9 40.6846C27.4721 40.6846 28.0305 40.5071 28.5 40.1762L47.2 28.8369V25.5971Z" />
                </svg>
            </a>
        </li>
    </ul>
</div>
@push('page_scripts')
    <script>
        const SocialApp = function() {
            const popupSize = {
                width: 780,
                height: 550
            };
            const initEvents = function() {
                document.querySelectorAll('.social-share').forEach(element => {
                    element.addEventListener('click', e => {
                        e.preventDefault()
                        var verticalPos = Math.floor(($(window).width() - popupSize.width) / 2),
                            horisontalPos = Math.floor(($(window).height() - popupSize.height) / 2),
                            url = e.target.href;

                        var popup = window.open(url, 'social',
                            'width=' + popupSize.width + ',height=' + popupSize.height +
                            ',left=' + verticalPos + ',top=' + horisontalPos +
                            ',location=0,menubar=0,toolbar=0,status=0,scrollbars=1,resizable=1');
                        if (popup) {
                            popup.focus();
                        } else {
                            var win = window.open(url, '_blank');
                            win.focus();
                        }
                    });
                });
            }

            return {
                init: function() {
                    initEvents()
                }
            }
        }()

        document.addEventListener("DOMContentLoaded", function(event) {
            SocialApp.init();
        });
    </script>
@endpush
