import{g as It}from"./_commonjsHelpers.712cc82f.js";var ft={exports:{}};/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2022 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 9.9.2
 * @date    2022-09-20
 */(function(Ct,At){(function(ze,st){Ct.exports=st()})(self,function(){return st={897:function(ie,g,V){V.d(g,{x:function(){return D}});var X=V(2602),k=V(9791),G=V(7907);function O(N,M){for(var L=0;L<M.length;L++){var C=M[L];C.enumerable=C.enumerable||!1,C.configurable=!0,"value"in C&&(C.writable=!0),Object.defineProperty(N,C.key,C)}}var D=function(){function N(C,x){if(!(this instanceof N))throw new TypeError("Cannot call a class as a function");this.dom={};var A=this,a=this.dom,x=(this.anchor=void 0,this.items=C,this.eventListeners={},this.selection=void 0,this.onClose=x?x.close:void 0,this.limitHeight=!!x&&x.limitHeight,document.createElement("div")),p=(x.className="jsoneditor-contextmenu-root",a.root=x,document.createElement("div")),x=(p.className="jsoneditor-contextmenu",a.menu=p,x.appendChild(p),document.createElement("ul")),p=(x.className="jsoneditor-menu",p.appendChild(x),a.list=x,a.items=[],document.createElement("button")),a=(p.type="button",a.focusButton=p,document.createElement("li"));a.style.overflow="hidden",a.style.height="0",a.appendChild(p),x.appendChild(a),function l(n,i,t){t.forEach(function(e){var r,s,o,c,d,b;e.type==="separator"?((d=document.createElement("div")).className="jsoneditor-separator",(s=document.createElement("li")).appendChild(d),n.appendChild(s)):(r={},d=document.createElement("li"),n.appendChild(d),(s=document.createElement("button")).type="button",s.className=e.className,r.button=s,e.title&&(s.title=e.title),e.click&&(s.onclick=function(I){I.preventDefault(),A.hide(),e.click()}),d.appendChild(s),e.submenu?((c=document.createElement("div")).className="jsoneditor-icon",s.appendChild(c),(c=document.createElement("div")).className="jsoneditor-text"+(e.click?"":" jsoneditor-right-margin"),c.appendChild(document.createTextNode(e.text)),s.appendChild(c),(o=e.click?(s.className+=" jsoneditor-default",(c=document.createElement("button")).type="button",(r.buttonExpand=c).className="jsoneditor-expand",(b=document.createElement("div")).className="jsoneditor-expand",c.appendChild(b),d.appendChild(c),e.submenuTitle&&(c.title=e.submenuTitle),c):((b=document.createElement("div")).className="jsoneditor-expand",s.appendChild(b),s)).onclick=function(I){I.preventDefault(),A._onExpandItem(r),o.focus()},r.subItems=c=[],b=document.createElement("ul"),(r.ul=b).className="jsoneditor-menu",b.style.height="0",d.appendChild(b),l(b,c,e.submenu)):((d=document.createElement("div")).className="jsoneditor-icon",s.appendChild(d),(b=document.createElement("div")).className="jsoneditor-text",b.appendChild(document.createTextNode((0,G.Iu)(e.text))),s.appendChild(b)),i.push(r))})}(x,this.dom.items,C),this.maxHeight=0,C.forEach(function(l){l=24*(C.length+(l.submenu?l.submenu.length:0)),A.maxHeight=Math.max(A.maxHeight,l)})}var M,L;return M=N,(L=[{key:"_getVisibleButtons",value:function(){var C=[],m=this;return this.dom.items.forEach(function(A){C.push(A.button),A.buttonExpand&&C.push(A.buttonExpand),A.subItems&&A===m.expandedItem&&A.subItems.forEach(function(x){C.push(x.button),x.buttonExpand&&C.push(x.buttonExpand)})}),C}},{key:"show",value:function(C,i,A){this.hide();var x=!0,a=C.parentNode,p=C.getBoundingClientRect(),a=a.getBoundingClientRect(),l=i.getBoundingClientRect(),n=this,i=(this.dom.absoluteAnchor=(0,X.w)(C,i,function(){n.hide()}),p.bottom+this.maxHeight<l.bottom||p.top-this.maxHeight>l.top&&(x=!1),A?0:p.top-a.top);x?(A=C.offsetHeight,this.dom.menu.style.left="0",this.dom.menu.style.top=i+A+"px",this.dom.menu.style.bottom=""):(this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px"),this.limitHeight&&(a=x?l.bottom-p.bottom-10:p.top-l.top-10,this.dom.list.style.maxHeight=a+"px",this.dom.list.style.overflowY="auto"),this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=(0,k.getSelection)(),this.anchor=C,setTimeout(function(){n.dom.focusButton.focus()},0),N.visibleMenu&&N.visibleMenu.hide(),N.visibleMenu=this}},{key:"hide",value:function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose&&this.onClose()),N.visibleMenu===this&&(N.visibleMenu=void 0)}},{key:"_onExpandItem",value:function(C){var m,A=this,x=C===this.expandedItem,p=this.expandedItem;p&&(p.ul.style.height="0",p.ul.style.padding="",setTimeout(function(){A.expandedItem!==p&&(p.ul.style.display="",k.removeClassName)(p.ul.parentNode,"jsoneditor-selected")},300),this.expandedItem=void 0),x||((m=C.ul).style.display="block",m.clientHeight,setTimeout(function(){if(A.expandedItem===C){for(var a=0,l=0;l<m.childNodes.length;l++)a+=m.childNodes[l].clientHeight;m.style.height=a+"px",m.style.padding="5px 10px"}},0),(0,k.addClassName)(m.parentNode,"jsoneditor-selected"),this.expandedItem=C)}},{key:"_onKeyDown",value:function(C){var m,A,x,p,a=C.target,l=C.which,n=!1;l===27?(this.selection&&(0,k.setSelection)(this.selection),this.anchor&&this.anchor.focus(),this.hide(),n=!0):l===9?C.shiftKey?(A=(m=this._getVisibleButtons()).indexOf(a))===0&&(m[m.length-1].focus(),n=!0):(A=(m=this._getVisibleButtons()).indexOf(a))===m.length-1&&(m[0].focus(),n=!0):l===37?(a.className==="jsoneditor-expand"&&(A=(m=this._getVisibleButtons()).indexOf(a),(x=m[A-1])&&x.focus()),n=!0):l===38?(A=(m=this._getVisibleButtons()).indexOf(a),(x=(x=(x=m[A-1])&&x.className==="jsoneditor-expand"?m[A-2]:x)||m[m.length-1])&&x.focus(),n=!0):l===39?(A=(m=this._getVisibleButtons()).indexOf(a),(p=m[A+1])&&p.className==="jsoneditor-expand"&&p.focus(),n=!0):l===40&&(A=(m=this._getVisibleButtons()).indexOf(a),(p=(p=(p=m[A+1])&&p.className==="jsoneditor-expand"?m[A+2]:p)||m[0])&&(p.focus(),n=!0),n=!0),n&&(C.stopPropagation(),C.preventDefault())}}])&&O(M.prototype,L),Object.defineProperty(M,"prototype",{writable:!1}),N}();D.visibleMenu=void 0},6436:function(ie,g,V){function X(G,O){for(var D=0;D<O.length;D++){var N=O[D];N.enumerable=N.enumerable||!1,N.configurable=!0,"value"in N&&(N.writable=!0),Object.defineProperty(G,N.key,N)}}V.d(g,{Q:function(){return k}});var k=function(){function G(M){if(!(this instanceof G))throw new TypeError("Cannot call a class as a function");this.errorTableVisible=M.errorTableVisible,this.onToggleVisibility=M.onToggleVisibility,this.onFocusLine=M.onFocusLine||function(){},this.onChangeHeight=M.onChangeHeight,this.dom={};var M=document.createElement("div"),L=(M.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=M,document.createElement("div")),M=(L.style.display="none",L.className="jsoneditor-additional-errors fadein",L.textContent="Scroll for more \u25BF",this.dom.additionalErrorsIndication=L,M.appendChild(L),document.createElement("span")),L=(M.className="jsoneditor-validation-error-icon",M.style.display="none",this.dom.validationErrorIcon=M,document.createElement("span"));L.className="jsoneditor-validation-error-count",L.style.display="none",this.dom.validationErrorCount=L,this.dom.parseErrorIndication=document.createElement("span"),this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon",this.dom.parseErrorIndication.style.display="none"}var O,D;return O=G,(D=[{key:"getErrorTable",value:function(){return this.dom.validationErrorsContainer}},{key:"getErrorCounter",value:function(){return this.dom.validationErrorCount}},{key:"getWarningIcon",value:function(){return this.dom.validationErrorIcon}},{key:"getErrorIcon",value:function(){return this.dom.parseErrorIndication}},{key:"toggleTableVisibility",value:function(){this.errorTableVisible=!this.errorTableVisible,this.onToggleVisibility(this.errorTableVisible)}},{key:"setErrors",value:function(N,M){var L,C,m=this,A=(this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none"),this.errorTableVisible&&0<N.length?((A=document.createElement("div")).className="jsoneditor-validation-errors",(C=document.createElement("table")).className="jsoneditor-text-errors",A.appendChild(C),L=document.createElement("tbody"),C.appendChild(L),N.forEach(function(x){isNaN(x.line)?x.dataPath&&(a=M.find(function(i){return i.path===x.dataPath}))&&(p=a.line+1):p=x.line;var p,a=document.createElement("tr"),l=(a.className=isNaN(p)?"":"jump-to-line",x.type==="error"?a.className+=" parse-error":a.className+=" validation-error",document.createElement("td")),n=document.createElement("button"),n=(n.className="jsoneditor-schema-error",l.appendChild(n),a.appendChild(l),document.createElement("td"));n.style="white-space: nowrap;",n.textContent=isNaN(p)?"":"Ln "+p,a.appendChild(n),typeof x=="string"?((l=document.createElement("td")).colSpan=2,(n=document.createElement("pre")).appendChild(document.createTextNode(x)),l.appendChild(n),a.appendChild(l)):((n=document.createElement("td")).appendChild(document.createTextNode(x.dataPath||"")),a.appendChild(n),l=document.createElement("td"),(n=document.createElement("pre")).appendChild(document.createTextNode(x.message.replace(/<br>/gi,`
`))),l.appendChild(n),a.appendChild(l)),a.onclick=function(){m.onFocusLine(p)},L.appendChild(a)}),this.dom.validationErrors=A,this.dom.validationErrorsContainer.appendChild(A),this.dom.additionalErrorsIndication.title=N.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){m.dom.additionalErrorsIndication.style.display=0<m.dom.validationErrorsContainer.clientHeight&&m.dom.validationErrorsContainer.scrollTop===0?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0,C=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0),this.onChangeHeight(C)):this.onChangeHeight(0),N.filter(function(x){return x.type!=="error"}).length);0<A?(this.dom.validationErrorCount.style.display="inline",this.dom.validationErrorCount.innerText=A,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=A+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none"),N.some(function(x){return x.type==="error"})?(C=N[0].line,this.dom.parseErrorIndication.style.display="block",this.dom.parseErrorIndication.title=isNaN(C)?"parse error - check that the json is valid":"parse error on line "+C,this.dom.parseErrorIndication.onclick=this.toggleTableVisibility.bind(this)):this.dom.parseErrorIndication.style.display="none"}}])&&X(O.prototype,D),Object.defineProperty(O,"prototype",{writable:!1}),G}()},2474:function(ie,g,V){function X(G,O){for(var D=0;D<O.length;D++){var N=O[D];N.enumerable=N.enumerable||!1,N.configurable=!0,"value"in N&&(N.writable=!0),Object.defineProperty(G,N.key,N)}}V.d(g,{R:function(){return k}});var k=function(){function G(N){if(!(this instanceof G))throw new TypeError("Cannot call a class as a function");if(this.target=N.target||null,!this.target)throw new Error('FocusTracker constructor called without a "target" to track.');this.onFocus=typeof N.onFocus=="function"?N.onFocus:null,this.onBlur=typeof N.onBlur=="function"?N.onBlur:null,this._onClick=this._onEvent.bind(this),this._onKeyUp=function(M){M.which!==9&&M.keyCode!==9||this._onEvent(M)}.bind(this),this._onBlur=this._onEvent.bind(this),this.focusFlag=!1,this.firstEventFlag=!0,(this.onFocus||this.onBlur)&&(document.addEventListener("click",this._onClick),document.addEventListener("keyup",this._onKeyUp),document.addEventListener("blur",this._onBlur))}var O,D;return O=G,(D=[{key:"destroy",value:function(){document.removeEventListener("click",this._onClick),document.removeEventListener("keyup",this._onKeyUp),document.removeEventListener("blur",this._onBlur),this._onEvent({target:document.body})}},{key:"_onEvent",value:function(N){N=N.target,N=N===this.target||!(!this.target.contains(N)&&!this.target.contains(document.activeElement)),N?this.focusFlag||(this.onFocus&&this.onFocus({type:"focus",target:this.target}),this.focusFlag=!0):(this.focusFlag||this.firstEventFlag)&&(this.onBlur&&this.onBlur({type:"blur",target:this.target}),this.focusFlag=!1,this.firstEventFlag&&(this.firstEventFlag=!1))}}])&&X(O.prototype,D),Object.defineProperty(O,"prototype",{writable:!1}),G}()},3161:function(ie,g,V){var X=V(8170),k=V(8037),G=V(8038).treeModeMixins,O=V(8458).textModeMixins,D=V(341).previewModeMixins,A=V(9791),N=A.clear,M=A.extend,L=A.getInnerText,C=A.getInternetExplorerVersion,m=A.parse,A=V(2744).tryRequireAjv,x=V(2558).showTransformModal,p=V(6210).showSortModal,a=A();function l(n,i,t){if(!(this instanceof l))throw new Error('JSONEditor constructor called without "new".');var e=C();if(e!==-1&&e<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");i&&(i.error&&(console.warn('Option "error" has been renamed to "onError"'),i.onError=i.error,delete i.error),i.change&&(console.warn('Option "change" has been renamed to "onChange"'),i.onChange=i.change,delete i.change),i.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),i.onEditable=i.editable,delete i.editable),i.onChangeJSON&&(i.mode==="text"||i.mode==="code"||i.modes&&(i.modes.indexOf("text")!==-1||i.modes.indexOf("code")!==-1))&&console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.'),i&&Object.keys(i).forEach(function(r){l.VALID_OPTIONS.indexOf(r)===-1&&console.warn('Unknown option "'+r+'". This option will be ignored')})),arguments.length&&this._create(n,i,t)}typeof Promise>"u"&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),l.modes={},l.prototype.DEBOUNCE_INTERVAL=150,l.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onExpand","onEditable","onError","onEvent","onModeChange","onNodeName","onValidate","onCreateMenu","onSelectionChange","onTextSelectionChange","onClassName","onFocus","onBlur","colorPicker","onColorPicker","timestampTag","timestampFormat","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","mainMenuBar","languages","language","enableSort","enableTransform","limitDragging","maxVisibleChilds","onValidationError","modalAnchor","popupAnchor","createQuery","executeQuery","queryDescription","allowSchemaSuggestions"],l.prototype._create=function(n,i,t){this.container=n,this.options=i||{},this.json=t||{},n=this.options.mode||this.options.modes&&this.options.modes[0]||"tree",this.setMode(n)},l.prototype.destroy=function(){},l.prototype.set=function(n){this.json=n},l.prototype.get=function(){return this.json},l.prototype.setText=function(n){this.json=m(n)},l.prototype.getText=function(){return JSON.stringify(this.json)},l.prototype.setName=function(n){this.options||(this.options={}),this.options.name=n},l.prototype.getName=function(){return this.options&&this.options.name},l.prototype.setMode=function(n){if(n!==this.options.mode||!this.create){var i=this.container,t=M({},this.options),e=t.mode,r=(t.mode=n,l.modes[n]);if(!r)throw new Error('Unknown mode "'+t.mode+'"');var s=r.data==="text",o=this.getName(),c=this[s?"getText":"get"]();if(this.destroy(),N(this),M(this,r.mixin),this.create(i,t),this.setName(o),this[s?"setText":"set"](c),typeof r.load=="function")try{r.load.call(this)}catch(d){console.error(d)}if(typeof t.onModeChange=="function"&&n!==e)try{t.onModeChange(n,e)}catch(d){console.error(d)}}},l.prototype.getMode=function(){return this.options.mode},l.prototype._onError=function(n){this.options&&typeof this.options.onError=="function"?this.options.onError(n):window.alert(n.toString())},l.prototype.setSchema=function(n,i){if(n){var t;try{this.options.ajv?t=this.options.ajv:((t=a({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0})).addMetaSchema(V(7171)),t.addMetaSchema(V(6273)))}catch{console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(t){if(i){for(var e in i)t.removeSchema(e),i[e]&&t.addSchema(i[e],e);this.options.schemaRefs=i}this.validateSchema=t.compile(n),this.options.schema=n,this.options.schemaRefs=i,this.validate()}}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate();this.refresh(),typeof this._onSchemaChange=="function"&&this._onSchemaChange(n,i)},l.prototype.validate=function(){},l.prototype.refresh=function(){},(l.registerMode=function(n){var i;if(Array.isArray(n))for(r=0;r<n.length;r++)l.registerMode(n[r]);else{if(!("mode"in n))throw new Error('Property "mode" missing');if(!("mixin"in n))throw new Error('Property "mixin" missing');if(!("data"in n))throw new Error('Property "data" missing');var t=n.mode;if(t in l.modes)throw new Error('Mode "'+t+'" already registered');if(typeof n.mixin.create!="function")throw new Error('Required function "create" missing on mixin');for(var e=["setMode","registerMode","modes"],r=0;r<e.length;r++)if((i=e[r])in n.mixin)throw new Error('Reserved property "'+i+'" not allowed in mixin');l.modes[t]=n}})(G),l.registerMode(O),l.registerMode(D),l.ace=X,l.Ajv=a,l.VanillaPicker=k,l.showTransformModal=x,l.showSortModal=p,l.getInnerText=L,ie.exports=l.default=l},6617:function(ie,g,V){V.d(g,{x:function(){return O}});var X=V(897),k=V(7907);function G(D,N){for(var M=0;M<N.length;M++){var L=N[M];L.enumerable=L.enumerable||!1,L.configurable=!0,"value"in L&&(L.writable=!0),Object.defineProperty(D,L.key,L)}}var O=function(){function D(L,C,m,A){if(!(this instanceof D))throw new TypeError("Cannot call a class as a function");for(var x={code:{text:(0,k.Iu)("modeCodeText"),title:(0,k.Iu)("modeCodeTitle"),click:function(){A("code")}},form:{text:(0,k.Iu)("modeFormText"),title:(0,k.Iu)("modeFormTitle"),click:function(){A("form")}},text:{text:(0,k.Iu)("modeTextText"),title:(0,k.Iu)("modeTextTitle"),click:function(){A("text")}},tree:{text:(0,k.Iu)("modeTreeText"),title:(0,k.Iu)("modeTreeTitle"),click:function(){A("tree")}},view:{text:(0,k.Iu)("modeViewText"),title:(0,k.Iu)("modeViewTitle"),click:function(){A("view")}},preview:{text:(0,k.Iu)("modePreviewText"),title:(0,k.Iu)("modePreviewTitle"),click:function(){A("preview")}}},p=[],a=0;a<C.length;a++){var l=C[a],n=x[l];if(!n)throw new Error('Unknown mode "'+l+'"');n.className="jsoneditor-type-modes"+(m===l?" jsoneditor-selected":""),p.push(n)}var t=x[m];if(!t)throw new Error('Unknown mode "'+m+'"');var t=t.text,i=document.createElement("button"),t=(i.type="button",i.className="jsoneditor-modes jsoneditor-separator",i.textContent=t+" \u25BE",i.title=(0,k.Iu)("modeEditorTitle"),i.onclick=function(){new X.x(p).show(i,L)},document.createElement("div"));t.className="jsoneditor-modes",t.style.position="relative",t.appendChild(i),L.appendChild(t),this.dom={container:L,box:i,frame:t}}var N,M;return N=D,(M=[{key:"focus",value:function(){this.dom.box.focus()}},{key:"destroy",value:function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null}}])&&G(N.prototype,M),Object.defineProperty(N,"prototype",{writable:!1}),D}()},8170:function(ie,g,V){var X;if(window.ace)X=window.ace;else try{X=V(6225),V(4091),V(3330),V(4317);var k=V(7923);X.config.setModuleUrl("ace/mode/json_worker",k)}catch{}ie.exports=X},4864:function(){window.ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(ie,g,V){g.isDark=!1,g.cssClass="ace-jsoneditor",g.cssText=`.ace-jsoneditor .ace_gutter {
background: #ebebeb;
color: #333
}

.ace-jsoneditor.ace_editor {
line-height: 1.3;
background-color: #fff;
}
.ace-jsoneditor .ace_print-margin {
width: 1px;
background: #e8e8e8
}
.ace-jsoneditor .ace_scroller {
background-color: #FFFFFF
}
.ace-jsoneditor .ace_text-layer {
color: gray
}
.ace-jsoneditor .ace_variable {
color: #1a1a1a
}
.ace-jsoneditor .ace_cursor {
border-left: 2px solid #000000
}
.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {
border-left: 0px;
border-bottom: 1px solid #000000
}
.ace-jsoneditor .ace_marker-layer .ace_selection {
background: lightgray
}
.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {
box-shadow: 0 0 3px 0px #FFFFFF;
border-radius: 2px
}
.ace-jsoneditor .ace_marker-layer .ace_step {
background: rgb(255, 255, 0)
}
.ace-jsoneditor .ace_marker-layer .ace_bracket {
margin: -1px 0 0 -1px;
border: 1px solid #BFBFBF
}
.ace-jsoneditor .ace_marker-layer .ace_active-line {
background: #FFFBD1
}
.ace-jsoneditor .ace_gutter-active-line {
background-color : #dcdcdc
}
.ace-jsoneditor .ace_marker-layer .ace_selected-word {
border: 1px solid lightgray
}
.ace-jsoneditor .ace_invisible {
color: #BFBFBF
}
.ace-jsoneditor .ace_keyword,
.ace-jsoneditor .ace_meta,
.ace-jsoneditor .ace_support.ace_constant.ace_property-value {
color: #AF956F
}
.ace-jsoneditor .ace_keyword.ace_operator {
color: #484848
}
.ace-jsoneditor .ace_keyword.ace_other.ace_unit {
color: #96DC5F
}
.ace-jsoneditor .ace_constant.ace_language {
color: darkorange
}
.ace-jsoneditor .ace_constant.ace_numeric {
color: red
}
.ace-jsoneditor .ace_constant.ace_character.ace_entity {
color: #BF78CC
}
.ace-jsoneditor .ace_invalid {
color: #FFFFFF;
background-color: #FF002A;
}
.ace-jsoneditor .ace_fold {
background-color: #AF956F;
border-color: #000000
}
.ace-jsoneditor .ace_storage,
.ace-jsoneditor .ace_support.ace_class,
.ace-jsoneditor .ace_support.ace_function,
.ace-jsoneditor .ace_support.ace_other,
.ace-jsoneditor .ace_support.ace_type {
color: #C52727
}
.ace-jsoneditor .ace_string {
color: green
}
.ace-jsoneditor .ace_comment {
color: #BCC8BA
}
.ace-jsoneditor .ace_entity.ace_name.ace_tag,
.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {
color: #606060
}
.ace-jsoneditor .ace_markup.ace_underline {
text-decoration: underline
}
.ace-jsoneditor .ace_indent-guide {
background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y
}`,ie("../lib/dom").importCssString(g.cssText,g.cssClass)})},6589:function(ie,g){(V={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(X,k,G,O,D,N,M){var L=N.length-1;switch(D){case 1:this.$=X.replace(/\\(\\|")/g,"$1").replace(/\\n/g,`
`).replace(/\\r/g,"\r").replace(/\\t/g,"	").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(X);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=N[L-1];case 13:this.$={};break;case 14:this.$=N[L-1];break;case 15:this.$=[N[L-2],N[L]];break;case 16:this.$={},this.$[N[L][0]]=N[L][1];break;case 17:this.$=N[L-2],N[L-2][N[L][0]]=N[L][1];break;case 18:this.$=[];break;case 19:this.$=N[L-1];break;case 20:this.$=[N[L]];break;case 21:this.$=N[L-2],N[L-2].push(N[L])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(X,k){throw new Error(X)},parse:function(X){var k=this,G=[0],O=[null],D=[],N=this.table,M="",L=0,C=0,m=0,A=(this.lexer.setInput(X),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,this.lexer.yylloc===void 0&&(this.lexer.yylloc={}),this.lexer.yylloc);function x(){var d=k.lexer.lex()||1;return d=typeof d!="number"&&k.symbols_[d]||d}D.push(A),typeof this.yy.parseError=="function"&&(this.parseError=this.yy.parseError);for(var p,a,l,n,i,t,e,r,s,o={};;){if(l=G[G.length-1],(n=this.defaultActions[l]||(p==null&&(p=x()),N[l]&&N[l][p]))===void 0||!n.length||!n[0]){if(!m){for(i in r=[],N[l])this.terminals_[i]&&2<i&&r.push("'"+this.terminals_[i]+"'");var c="",c=this.lexer.showPosition?"Parse error on line "+(L+1)+`:
`+this.lexer.showPosition()+`
Expecting `+r.join(", ")+", got '"+this.terminals_[p]+"'":"Parse error on line "+(L+1)+": Unexpected "+(p==1?"end of input":"'"+(this.terminals_[p]||p)+"'");this.parseError(c,{text:this.lexer.match,token:this.terminals_[p]||p,line:this.lexer.yylineno,loc:A,expected:r})}if(m==3){if(p==1)throw new Error(c||"Parsing halted.");C=this.lexer.yyleng,M=this.lexer.yytext,L=this.lexer.yylineno,A=this.lexer.yylloc,p=x()}for(;!(2 .toString()in N[l]);){if(l==0)throw new Error(c||"Parsing halted.");s=1,G.length=G.length-2*s,O.length=O.length-s,D.length=D.length-s,l=G[G.length-1]}a=p,p=2,n=N[l=G[G.length-1]]&&N[l][2],m=3}if(n[0]instanceof Array&&1<n.length)throw new Error("Parse Error: multiple actions possible at state: "+l+", token: "+p);switch(n[0]){case 1:G.push(p),O.push(this.lexer.yytext),D.push(this.lexer.yylloc),G.push(n[1]),p=null,a?(p=a,a=null):(C=this.lexer.yyleng,M=this.lexer.yytext,L=this.lexer.yylineno,A=this.lexer.yylloc,0<m&&m--);break;case 2:if(t=this.productions_[n[1]][1],o.$=O[O.length-t],o._$={first_line:D[D.length-(t||1)].first_line,last_line:D[D.length-1].last_line,first_column:D[D.length-(t||1)].first_column,last_column:D[D.length-1].last_column},(e=this.performAction.call(o,M,C,L,this.yy,n[1],O,D))!==void 0)return e;t&&(G=G.slice(0,-1*t*2),O=O.slice(0,-1*t),D=D.slice(0,-1*t)),G.push(this.productions_[n[1]][0]),O.push(o.$),D.push(o._$),e=N[G[G.length-2]][G[G.length-1]],G.push(e);break;case 3:return!0}}return!0}}).lexer={EOF:1,parseError:function(X,k){if(!this.yy.parseError)throw new Error(X);this.yy.parseError(X,k)},setInput:function(X){return this._input=X,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var X=this._input[0];return this.yytext+=X,this.yyleng++,this.match+=X,this.matched+=X,X.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),X},unput:function(X){return this._input=X+this._input,this},more:function(){return this._more=!0,this},less:function(X){this._input=this.match.slice(X)+this._input},pastInput:function(){var X=this.matched.substr(0,this.matched.length-this.match.length);return(20<X.length?"...":"")+X.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var X=this.match;return X.length<20&&(X+=this._input.substr(0,20-X.length)),(X.substr(0,20)+(20<X.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var X=this.pastInput(),k=new Array(X.length+1).join("-");return X+this.upcomingInput()+`
`+k+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var X,k,G,O,D=this._currentRules(),N=0;N<D.length&&(!(k=this._input.match(this.rules[D[N]]))||X&&!(k[0].length>X[0].length)||(X=k,G=N,this.options.flex));N++);return X?((O=X[0].match(/\n.*/g))&&(this.yylineno+=O.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:O?O[O.length-1].length-1:this.yylloc.last_column+X[0].length},this.yytext+=X[0],this.match+=X[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(X[0].length),this.matched+=X[0],O=this.performAction.call(this,this.yy,this,D[G],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),O||void 0):this._input===""?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+`. Unrecognized text.
`+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var X=this.next();return X!==void 0?X:this.lex()},begin:function(X){this.conditionStack.push(X)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(X){this.begin(X)},options:{},performAction:function(X,k,G,O){switch(G){case 0:break;case 1:return 6;case 2:return k.yytext=k.yytext.substr(1,k.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}};var V;g.parser=V,g.parse=V.parse.bind(V)},3879:function(ie){function g(){}g.prototype={on:function(L,C){this._events=this._events||{},this._events[L]=this._events[L]||[],this._events[L].push(C)},off:function(L,C){this._events=this._events||{},L in this._events&&this._events[L].splice(this._events[L].indexOf(C),1)},emit:function(L){if(this._events=this._events||{},L in this._events)for(var C=0;C<this._events[L].length;C++)this._events[L][C].apply(this,Array.prototype.slice.call(arguments,1))}},g.mixin=function(L){for(var C=["on","off","emit"],m=0;m<C.length;m++)typeof L=="function"?L.prototype[C[m]]=g.prototype[C[m]]:L[C[m]]=g.prototype[C[m]];return L};var V={escapeRegExp:function(L){var C=/[\\^$.*+?()[\]{}|]/g,m=new RegExp(C.source);return L&&m.test(L)?L.replace(C,"\\$&"):L},extend:function(L,C){for(var m in C){var A;C.hasOwnProperty(m)&&((A=C[m])&&Object.prototype.toString.call(A)==="[object Object]"?(L[m]=L[m]||{},V.extend(L[m],A)):L[m]=A)}return L},each:function(L,C,m){if(Object.prototype.toString.call(L)==="[object Object]")for(var A in L)Object.prototype.hasOwnProperty.call(L,A)&&C.call(m,A,L[A],L);else for(var x=0,p=L.length;x<p;x++)C.call(m,x,L[x],L)},createElement:function(L,C){var m,A=document.createElement(L);if(C&&Object.prototype.toString.call(C)==="[object Object]")for(m in C)m in A?A[m]=C[m]:m==="html"?A.innerHTML=C[m]:A.setAttribute(m,C[m]);return A},hasClass:function(L,C){if(L)return L.classList?L.classList.contains(C):!!L.className&&!!L.className.match(new RegExp("(\\s|^)"+C+"(\\s|$)"))},addClass:function(L,C){V.hasClass(L,C)||(L.classList?L.classList.add(C):L.className=L.className.trim()+" "+C)},removeClass:function(L,C){V.hasClass(L,C)&&(L.classList?L.classList.remove(C):L.className=L.className.replace(new RegExp("(^|\\s)"+C.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(L,C){return L&&L!==document.body&&(C(L)?L:V.closest(L.parentNode,C))},isInt:function(L){return typeof L=="number"&&isFinite(L)&&Math.floor(L)===L},debounce:function(L,C,m){var A;return function(){var x=this,p=arguments,a=m&&!A;clearTimeout(A),A=setTimeout(function(){A=null,m||L.apply(x,p)},C),a&&L.apply(x,p)}},rect:function(A,p){var m=window,A=A.getBoundingClientRect(),x=p?m.pageXOffset:0,p=p?m.pageYOffset:0;return{bottom:A.bottom+p,height:A.height,left:A.left+x,right:A.right+x,top:A.top+p,width:A.width}},includes:function(L,C){return-1<L.indexOf(C)},startsWith:function(L,C){return L.substr(0,C.length)===C},truncate:function(L){for(;L.firstChild;)L.removeChild(L.firstChild)}};function X(L,C){return L.hasOwnProperty(C)&&(L[C]===!0||L[C].length)}function k(L,C,m){L.parentNode?L.parentNode.parentNode||C.appendChild(L.parentNode):C.appendChild(L),V.removeClass(L,"excluded"),m||(L.textContent=L.textContent)}function G(){var L,C;this.items.length&&(L=document.createDocumentFragment(),this.config.pagination?(C=this.pages.slice(0,this.pageIndex),V.each(C,function(m,A){V.each(A,function(x,p){k(p,L,this.customOption)},this)},this)):V.each(this.items,function(m,A){k(A,L,this.customOption)},this),L.childElementCount&&(V.removeClass(this.items[this.navIndex],"active"),this.navIndex=(L.querySelector(".selectr-option.selected")||L.querySelector(".selectr-option")).idx,V.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(L))}function O(L,C){C=C||L;var m={class:"selectr-option",role:"treeitem","aria-selected":!1};return this.customOption?m.html=this.config.renderOption(C):m.textContent=L.textContent,(C=V.createElement("li",m)).idx=L.idx,this.items.push(C),L.defaultSelected&&this.defaultSelected.push(L.idx),L.disabled&&(C.disabled=!0,V.addClass(C,"disabled")),C}function D(){var L,C=this.tree,m=C.scrollTop;C.scrollHeight-C.offsetHeight<=m&&this.pageIndex<this.pages.length&&(L=document.createDocumentFragment(),V.each(this.pages[this.pageIndex],function(A,x){k(x,L,this.customOption)},this),C.appendChild(L),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length}))}function N(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&V.removeClass(this.inputContainer,"active"),V.hasClass(this.container,"notice")&&(V.removeClass(this.container,"notice"),V.addClass(this.container,"open"),this.input.focus()),V.each(this.items,function(L,C){V.removeClass(C,"excluded"),this.customOption||(C.textContent=C.textContent)},this))}function M(L,C){if(!L)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if(typeof(this.el=L)=="string"&&(this.el=document.querySelector(L)),this.el===null)throw new Error("The element you passed to Selectr can not be found.");if(this.el.nodeName.toLowerCase()!=="select")throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(C)}M.prototype.render=function(L){var C;this.rendered||((this.el.selectr=this).config=V.extend({defaultSelected:!0,width:"auto",disabled:!1,disabledMobile:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,nativeKeyboard:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag...",messages:{noResults:"No results.",noOptions:"No options available.",maxSelections:"A maximum of {max} items can be selected.",tagDuplicate:"That tag is already in use.",searchPlaceholder:"Search options..."}},L),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=X(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,!this.config.disabledMobile&&/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&typeof this.config.renderOption=="function",this.customSelected=this.config.hasOwnProperty("renderSelection")&&typeof this.config.renderSelection=="function",this.supportsEventPassiveOption=this.detectEventPassiveOption(),g.mixin(this),function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination,X(this.config,"width")&&(V.isInt(this.config.width)?this.width=this.config.width+"px":this.config.width==="auto"?this.width="100%":V.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=V.createElement("div",{class:"selectr-container"}),this.config.customClass&&V.addClass(this.container,this.config.customClass),this.mobileDevice?V.addClass(this.container,"selectr-mobile"):V.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?V.addClass(this.el,"selectr-visible"):V.addClass(this.el,"selectr-hidden"),this.selected=V.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:0,"aria-expanded":!1}),this.label=V.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var m=V.createElement("div",{class:"selectr-options-container"});if(this.tree=V.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=V.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple?(V.addClass(this.label,"selectr-tags"),V.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.config.defaultSelected?this.getSelectedProperties("value"):[],this.selectedIndexes=this.getSelectedProperties("idx")):(this.selectedValue=null,this.selectedIndex=-1),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=V.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),V.addClass(this.container,"clearable")),this.config.taggable){var A=V.createElement("li",{class:"input-tag"});if(this.input=V.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),A.appendChild(this.input),this.label.appendChild(A),V.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators){this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators);for(var x=[],p=0;p<this.tagSeperators.length;p++)x.push(V.escapeRegExp(this.tagSeperators[p]));this.tagSeperatorsRegex=new RegExp(x.join("|"),"i")}else this.tagSeperatorsRegex=new RegExp(",","i")}this.config.searchable&&(this.input=V.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search",placeholder:this.config.messages.searchPlaceholder}),this.inputClear=V.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=V.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),m.appendChild(this.inputContainer)),m.appendChild(this.notice),m.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var a,l,n,i=!1,t=0;this.el.children.length&&V.each(this.el.children,function(r,s){s.nodeName==="OPTGROUP"?(i=V.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+s.label+"</li>"}),V.each(s.children,function(o,c){c.idx=t,i.appendChild(O.call(this,c,i)),t++},this)):(s.idx=t,O.call(this,s),t++)},this),this.config.data&&Array.isArray(this.config.data)&&(a=!(this.data=[]),i=!1,t=0,V.each(this.config.data,function(r,s){X(s,"children")?(a=V.createElement("optgroup",{label:s.text}),i=V.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+s.text+"</li>"}),V.each(s.children,function(o,c){(l=new Option(c.text,c.value,!1,c.hasOwnProperty("selected")&&c.selected===!0)).disabled=X(c,"disabled"),this.options.push(l),a.appendChild(l),l.idx=t,i.appendChild(O.call(this,l,c)),this.data[t]=c,t++},this),this.el.appendChild(a)):((l=new Option(s.text,s.value,!1,s.hasOwnProperty("selected")&&s.selected===!0)).disabled=X(s,"disabled"),this.options.push(l),l.idx=t,O.call(this,l,s),this.data[t]=s,t++)},this)),this.setSelected(!0);for(var e=this.navIndex=0;e<this.items.length;e++)if(n=this.items[e],!V.hasClass(n,"disabled")){V.addClass(n,"active"),this.navIndex=e;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(m),this.placeEl=V.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)}.call(this),this.bindEvents(),this.update(),this.optsRect=V.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex),C=this,setTimeout(function(){C.emit("selectr.init")},20))},M.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},M.prototype.getSelectedProperties=function(L){var C=this.getSelected();return[].slice.call(C).map(function(m){return m[L]}).filter(function(m){return m!=null})},M.prototype.detectEventPassiveOption=function(){var L=!1;try{var C=Object.defineProperty({},"passive",{get:function(){L=!0}});window.addEventListener("test",null,C)}catch{}return L},M.prototype.bindEvents=function(){var L,C=this;this.events={},this.events.dismiss=function(m){m=m.target,this.container.contains(m)||!this.opened&&!V.hasClass(this.container,"notice")||this.close()}.bind(this),this.events.navigate=function(m){if(m=m||window.event,this.items.length&&this.opened&&V.includes([13,38,40],m.which)){if(m.preventDefault(),m.which===13)return!(this.noResults||this.config.taggable&&0<this.input.value.length)&&this.change(this.navIndex);var A,x=this.items[this.navIndex],p=this.navIndex;switch(m.which){case 38:(A=0)<this.navIndex&&this.navIndex--;break;case 40:this.navIndex<this.items.length-(A=1)&&this.navIndex++}for(this.navigating=!0;V.hasClass(this.items[this.navIndex],"disabled")||V.hasClass(this.items[this.navIndex],"excluded");){if(!(0<this.navIndex&&this.navIndex<this.items.length-1)){this.navIndex=p;break}if(A?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}}m=V.rect(this.items[this.navIndex]),A?(this.navIndex===0?this.tree.scrollTop=0:m.top+m.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(m.top+m.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&D.call(this)):this.navIndex===0?this.tree.scrollTop=0:m.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(m.top-this.optsRect.top)),x&&V.removeClass(x,"active"),V.addClass(this.items[this.navIndex],"active")}else this.navigating=!1}.bind(this),this.events.reset=this.reset.bind(this),(this.config.nativeDropdown||this.mobileDevice)&&(this.container.addEventListener("touchstart",function(m){m.changedTouches[0].target===C.el&&C.toggle()},!!this.supportsEventPassiveOption&&{passive:!0}),this.container.addEventListener("click",function(m){m.target===C.el&&C.toggle()}),this.el.addEventListener("change",function(m){m.__selfTriggered||(C.el.multiple?(m=C.getSelectedProperties("idx"),m=function(A,x){for(var p,a=[],l=A.slice(0),n=0;n<x.length;n++)-1<(p=l.indexOf(x[n]))?l.splice(p,1):a.push(x[n]);return[a,l]}(C.selectedIndexes,m),V.each(m[0],function(A,x){C.select(x)},C),V.each(m[1],function(A,x){C.deselect(x)},C)):-1<C.el.selectedIndex&&C.select(C.el.selectedIndex))})),this.config.nativeDropdown&&this.container.addEventListener("keydown",function(m){m.key==="Enter"&&C.selected===document.activeElement&&(C.toggle(),setTimeout(function(){C.el.focus()},200))}),this.selected.addEventListener("click",function(m){C.disabled||C.toggle(),m.preventDefault()}),this.config.nativeKeyboard&&(L="",this.selected.addEventListener("keydown",function(m){var A;C.disabled||C.selected!==document.activeElement||m.altKey||m.ctrlKey||m.metaKey||(m.key===" "||!C.opened&&-1<["Enter","ArrowUp","ArrowDown"].indexOf(m.key)?(C.toggle(),m.preventDefault(),m.stopPropagation()):m.key.length<=2&&String[String.fromCodePoint?"fromCodePoint":"fromCharCode"](m.key[String.codePointAt?"codePointAt":"charCodeAt"](0))===m.key&&(C.config.multiple?(C.open(),C.config.searchable&&(C.input.value=m.key,C.input.focus(),C.search(null,!0))):(L+=m.key,(A=C.search(L,!0))&&A.length&&(C.clear(),C.setValue(A[0].value)),setTimeout(function(){L=""},1e3)),m.preventDefault(),m.stopPropagation()))}),this.container.addEventListener("keyup",function(m){C.opened&&m.key==="Escape"&&(C.close(),m.stopPropagation(),C.selected.focus())})),this.label.addEventListener("click",function(m){V.hasClass(m.target,"selectr-tag-remove")&&C.deselect(m.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(m){m.preventDefault()}),this.tree.addEventListener("click",function(m){var A=V.closest(m.target,function(x){return x&&V.hasClass(x,"selectr-option")});A&&!V.hasClass(A,"disabled")&&(V.hasClass(A,"selected")?(C.el.multiple||!C.el.multiple&&C.config.allowDeselect)&&C.deselect(A.idx):C.select(A.idx),C.opened&&!C.el.multiple&&C.close()),m.preventDefault(),m.stopPropagation()}),this.tree.addEventListener("mouseover",function(m){!V.hasClass(m.target,"selectr-option")||V.hasClass(m.target,"disabled")||(V.removeClass(C.items[C.navIndex],"active"),V.addClass(m.target,"active"),C.navIndex=[].slice.call(C.items).indexOf(m.target))}),this.config.searchable&&(this.input.addEventListener("focus",function(m){C.searching=!0}),this.input.addEventListener("blur",function(m){C.searching=!1}),this.input.addEventListener("keyup",function(m){C.search(),C.config.taggable||(this.value.length?V.addClass(this.parentNode,"active"):V.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(m){C.input.value=null,N.call(C),C.tree.childElementCount||G.call(C)})),this.config.taggable&&this.input.addEventListener("keyup",function(m){var A,x;C.search(),C.config.taggable&&this.value.length&&(A=this.value.trim()).length&&(m.which===13||C.tagSeperatorsRegex.test(A))&&(m=A.replace(C.tagSeperatorsRegex,""),(x=(m=(m=V.escapeRegExp(m)).trim()).length?C.add({value:m,textContent:m,selected:!0},!0):x)?(C.close(),N.call(C)):(this.value="",C.setMessage(C.config.messages.tagDuplicate)))}),this.update=V.debounce(function(){C.opened&&C.config.closeOnScroll&&C.close(),C.width&&(C.container.style.width=C.width),C.invert()},50),this.requiresPagination&&(this.paginateItems=V.debounce(function(){D.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.on("selectr.destroy",function(){document.removeEventListener("click",this.events.dismiss),window.removeEventListener("keydown",this.events.navigate),window.removeEventListener("resize",this.update),window.removeEventListener("scroll",this.update)}),this.el.form&&(this.el.form.addEventListener("reset",this.events.reset),this.on("selectr.destroy",function(){this.el.form.removeEventListener("reset",this.events.reset)}))},M.prototype.setSelected=function(L){var C;this.config.data||this.el.multiple||!this.el.options.length||(this.el.selectedIndex!==0||this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex)),this.config.multiple&&this.originalType==="select-one"&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),V.each(this.options,function(m,A){A.selected&&A.defaultSelected&&this.select(A.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data&&(!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&0<this.config.data.length&&this.select(0),C=0,V.each(this.config.data,function(m,A){X(A,"children")?V.each(A.children,function(x,p){p.hasOwnProperty("selected")&&p.selected===!0&&this.select(C),C++},this):(A.hasOwnProperty("selected")&&A.selected===!0&&this.select(C),C++)},this))},M.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),this.originalType==="select-one"&&(this.el.multiple=!1),this.config.data&&(this.el.innerHTML=""),V.removeClass(this.el,"selectr-hidden"),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1,delete this.el.selectr)},M.prototype.change=function(L){var C=this.items[L],m=this.options[L];m.disabled||(m.selected&&V.hasClass(C,"selected")?this.deselect(L):this.select(L),this.opened&&!this.el.multiple&&this.close())},M.prototype.select=function(L){var C=this.items[L],m=[].slice.call(this.el.options),A=this.options[L];if(this.el.multiple){if(V.includes(this.selectedIndexes,L))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage(this.config.messages.maxSelections.replace("{max}",this.config.maxSelections),!0),!1;this.selectedValues.push(A.value),this.selectedIndexes.push(L),function(p){var a,l=this,n=document.createDocumentFragment(),i=this.options[p.idx],t=this.data?this.data[p.idx]:i,e={class:"selectr-tag"},t=(this.customSelected?e.html=this.config.renderSelection(t):e.textContent=i.textContent,V.createElement("li",e)),e=V.createElement("button",{class:"selectr-tag-remove",type:"button"});t.appendChild(e),t.idx=p.idx,t.tag=i.value,this.tags.push(t),this.config.sortSelected?(e=this.tags.slice(),a=function(r,s){r.replace(/(\d+)|(\D+)/g,function(o,c,d){s.push([c||1/0,d||""])})},e.sort(function(r,s){var o,c,d=[],b=[];for(l.config.sortSelected===!0?(o=r.tag,c=s.tag):l.config.sortSelected==="text"&&(o=r.textContent,c=s.textContent),a(o,d),a(c,b);d.length&&b.length;){var h=d.shift(),I=b.shift(),h=h[0]-I[0]||h[1].localeCompare(I[1]);if(h)return h}return d.length-b.length}),V.each(e,function(r,s){n.appendChild(s)}),this.label.innerHTML=""):n.appendChild(t),this.config.taggable?this.label.insertBefore(n,this.input.parentNode):this.label.appendChild(n)}.call(this,C)}else{var x=this.data?this.data[L]:A;this.customSelected?this.label.innerHTML=this.config.renderSelection(x):this.label.textContent=A.textContent,this.selectedValue=A.value,this.selectedIndex=L,V.each(this.options,function(p,a){var l=this.items[p];p!==L&&(l&&V.removeClass(l,"selected"),a.selected=!1,a.removeAttribute("selected"))},this)}V.includes(m,A)||this.el.add(A),C.setAttribute("aria-selected",!0),V.addClass(C,"selected"),V.addClass(this.container,"has-selected"),A.selected=!0,A.setAttribute("selected",""),this.emit("selectr.change",A),this.emit("selectr.select",A),"createEvent"in document?((x=document.createEvent("HTMLEvents")).initEvent("change",!0,!0),x.__selfTriggered=!0,this.el.dispatchEvent(x)):this.el.fireEvent("onchange")},M.prototype.deselect=function(L,C){var m=this.items[L],A=this.options[L];if(this.el.multiple){var x=this.selectedIndexes.indexOf(L),x=(this.selectedIndexes.splice(x,1),this.selectedValues.indexOf(A.value));this.selectedValues.splice(x,1),function(p){var a=!1;V.each(this.tags,function(l,n){n.idx===p.idx&&(a=n)},this),a&&(this.label.removeChild(a),this.tags.splice(this.tags.indexOf(a),1))}.call(this,m),this.tags.length||V.removeClass(this.container,"has-selected")}else{if(!C&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.innerHTML="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,V.removeClass(this.container,"has-selected")}this.items[L].setAttribute("aria-selected",!1),V.removeClass(this.items[L],"selected"),A.selected=!1,A.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",A),"createEvent"in document?((x=document.createEvent("HTMLEvents")).initEvent("change",!0,!0),x.__selfTriggered=!0,this.el.dispatchEvent(x)):this.el.fireEvent("onchange")},M.prototype.setValue=function(L){var C=Array.isArray(L);if(C||(L=L.toString().trim()),!this.el.multiple&&C)return!1;V.each(this.options,function(m,A){(C&&-1<L.indexOf(A.value)||A.value===L)&&this.change(A.idx)},this)},M.prototype.getValue=function(L,C){var m,A;return this.el.multiple?L?this.selectedIndexes.length&&(A={values:[]},V.each(this.selectedIndexes,function(x,p){p=this.options[p],A.values[x]={value:p.value,text:p.textContent}},this)):A=this.selectedValues.slice():A=L?{value:(m=this.options[this.selectedIndex]).value,text:m.textContent}:this.selectedValue,A=L&&C?JSON.stringify(A):A},M.prototype.add=function(L,C){if(L){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(L))V.each(L,function(x,p){this.add(p,C)},this);else if(Object.prototype.toString.call(L)==="[object Object]"){if(C){var m=!1;if(V.each(this.options,function(x,p){p.value.toLowerCase()===L.value.toLowerCase()&&(m=!0)}),m)return!1}var A=V.createElement("option",L);return this.data.push(L),this.mobileDevice&&this.el.add(A),this.options.push(A),A.idx=0<this.options.length?this.options.length-1:0,O.call(this,A),L.selected&&this.select(A.idx),this.setPlaceholder(),A}return this.config.pagination&&this.paginate(),!0}},M.prototype.remove=function(L){var C,m=[];Array.isArray(L)?V.each(L,function(A,x){V.isInt(x)?m.push(this.getOptionByIndex(x)):typeof x=="string"&&m.push(this.getOptionByValue(x))},this):V.isInt(L)?m.push(this.getOptionByIndex(L)):typeof L=="string"&&m.push(this.getOptionByValue(L)),m.length&&(V.each(m,function(A,x){C=x.idx,this.el.remove(x),this.options.splice(C,1),x=this.items[C].parentNode,x&&x.removeChild(this.items[C]),this.items.splice(C,1),V.each(this.options,function(p,a){a.idx=p,this.items[p].idx=p},this)},this),this.setPlaceholder(),this.config.pagination&&this.paginate())},M.prototype.removeAll=function(){this.clear(!0),V.each(this.el.options,function(L,C){this.el.remove(C)},this),V.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},M.prototype.search=function(L,C){var m,A,x,p,a;if(!this.navigating)return m=!1,L||(L=this.input.value,m=!0,this.removeMessage(),V.truncate(this.tree)),A=[],x=document.createDocumentFragment(),0<(L=L.trim().toLowerCase()).length?(p=C?V.startsWith:V.includes,V.each(this.options,function(l,n){var i,t,e,r,s=this.items[n.idx];p(n.textContent.trim().toLowerCase(),L)&&!n.disabled?(A.push({text:n.textContent,value:n.value}),m&&(k(s,x,this.customOption),V.removeClass(s,"excluded"),this.customOption||(i=L,e=(n=n).textContent,i=new RegExp(i,"ig"),(r=i.exec(e))&&(n.innerHTML="",(t=document.createElement("span")).classList.add("selectr-match"),t.textContent=r[0],n.appendChild(document.createTextNode(e.substring(0,r.index))),n.appendChild(t),n.appendChild(document.createTextNode(e.substring(i.lastIndex))))))):m&&V.addClass(s,"excluded")},this),m&&(x.childElementCount?(C=this.items[this.navIndex],a=x.querySelector(".selectr-option:not(.excluded)"),this.noResults=!1,V.removeClass(C,"active"),this.navIndex=a.idx,V.addClass(a,"active")):this.config.taggable||(this.noResults=!0,this.setMessage(this.config.messages.noResults)),this.tree.appendChild(x))):G.call(this),A},M.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},M.prototype.open=function(){var L=this;if(!this.options.length)return!1;this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(V.addClass(this.container,"native-open"),this.config.data&&V.each(this.options,function(C,m){this.el.add(m)},this)):(V.addClass(this.container,"open"),G.call(this),this.invert(),this.tree.scrollTop=0,V.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),this.config.searchable&&!this.config.taggable&&setTimeout(function(){L.input.focus(),L.input.tabIndex=0},10))},M.prototype.close=function(){var L;this.opened&&this.emit("selectr.close"),this.opened=!1,this.navigating=!1,this.mobileDevice||this.config.nativeDropdown?V.removeClass(this.container,"native-open"):(L=V.hasClass(this.container,"notice"),this.config.searchable&&!L&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),L&&(V.removeClass(this.container,"notice"),this.notice.textContent=""),V.removeClass(this.container,"open"),V.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),V.truncate(this.tree),N.call(this))},M.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&V.each(this.tags,function(L,C){C.lastElementChild.tabIndex=0}),V.removeClass(this.container,"selectr-disabled")},M.prototype.disable=function(L){L||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&V.each(this.tags,function(C,m){m.lastElementChild.tabIndex=-1}),this.disabled=!0,V.addClass(this.container,"selectr-disabled")},M.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),V.each(this.defaultSelected,function(L,C){this.select(C)},this),this.emit("selectr.reset"))},M.prototype.clear=function(L,C){var m;this.el.multiple?this.selectedIndexes.length&&(m=this.selectedIndexes.slice(),C?this.deselect(m.slice(-1)[0]):V.each(m,function(A,x){this.deselect(x)},this)):-1<this.selectedIndex&&this.deselect(this.selectedIndex,L),this.emit("selectr.clear")},M.prototype.serialise=function(L){var C=[];return V.each(this.options,function(m,A){var x={value:A.value,text:A.textContent};A.selected&&(x.selected=!0),A.disabled&&(x.disabled=!0),C[m]=x}),L?JSON.stringify(C):C},M.prototype.serialize=function(L){return this.serialise(L)},M.prototype.setPlaceholder=function(L){L=L||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(L=this.config.messages.noOptions),this.placeEl.innerHTML=L},M.prototype.paginate=function(){var L;if(this.items.length)return(L=this).pages=this.items.map(function(C,m){return m%L.config.pagination==0?L.items.slice(m,m+L.config.pagination):null}).filter(function(C){return C}),this.pages},M.prototype.setMessage=function(L,C){C&&this.close(),V.addClass(this.container,"notice"),this.notice.textContent=L},M.prototype.removeMessage=function(){V.removeClass(this.container,"notice"),this.notice.innerHTML=""},M.prototype.invert=function(){var L=V.rect(this.selected),C=this.tree.parentNode.offsetHeight,m=window.innerHeight;L.top+L.height+C>m?(V.addClass(this.container,"inverted"),this.isInverted=!0):(V.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=V.rect(this.tree)},M.prototype.getOptionByIndex=function(L){return this.options[L]},M.prototype.getOptionByValue=function(L){for(var C=!1,m=0,A=this.options.length;m<A;m++)if(this.options[m].value.trim()===L.toString().trim()){C=this.options[m];break}return C},ie.exports=M},4188:function(ie,g,V){V.d(g,{EX:function(){return k},WF:function(){return G},oW:function(){return O},qD:function(){return X}});var X=document.body,k=10485760,G=2e4,O=2147483648},2602:function(ie,g,V){V.d(g,{w:function(){return k}});var X=V(9791);function k(G,O,D){var N,M=3<arguments.length&&arguments[3]!==void 0&&arguments[3],L=typeof(m=G).getRootNode=="function"?m.getRootNode():window,C={},m=G.getBoundingClientRect(),A=O.getBoundingClientRect(),x=document.createElement("div");function p(){if(x&&x.parentNode){for(var l in x.parentNode.removeChild(x),C)n=l,Object.prototype.hasOwnProperty.call(C,n)&&((n=C[l])&&(0,X.removeEventListener)(L,l,n),delete C[l]);typeof D=="function"&&D(G)}var n}function a(l){(l=l.target)===x||(0,X.isChildOf)(l,x)||p()}return x.className="jsoneditor-anchor",x.style.position="absolute",x.style.left=m.left-A.left+"px",x.style.top=m.top-A.top+"px",x.style.width=m.width-2+"px",x.style.height=m.height-2+"px",x.style.boxSizing="border-box",O.appendChild(x),C.mousedown=(0,X.addEventListener)(L,"mousedown",a),C.mousewheel=(0,X.addEventListener)(L,"mousewheel",a),M&&(N=null,x.onmouseover=function(){clearTimeout(N),N=null},x.onmouseout=function(){N=N||setTimeout(p,200)}),x.destroy=p,x}},7923:function(ie){ie.exports="data:application/javascript;base64,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"},7907:function(ie,g,V){V.d(g,{Iu:function(){return L},cC:function(){return M},m0:function(){return N}}),V(4987);var X={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",collapseAll:"Collapse all fields",compactTitle:"Compact JSON data, remove all whitespaces (Ctrl+Shift+I)",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",empty:"empty",expandAll:"Expand all fields",expandTitle:`Click to expand/collapse this field (Ctrl+E). 
Ctrl+Click to expand/collapse including all childs.`,formatTitle:"Format JSON data, with proper indentation and line feeds (Ctrl+I)",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",repairTitle:"Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",searchTitle:"Search fields and values",searchNextResultTitle:"Next result (Enter)",searchPreviousResultTitle:"Previous result (Shift + Enter)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeEditorTitle:"Switch Editor Mode",modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",examples:"Examples",default:"Default",containsInvalidProperties:"Contains invalid properties",containsInvalidItems:"Contains invalid items"},es:{array:"Matriz",auto:"Auto",appendText:"Agregar",appendTitle:"Agregue un nuevo campo con el tipo 'auto' despu\xE9s de este campo (Ctrl + Shift + Ins)",appendSubmenuTitle:"Seleccione el tipo de campo que se agregar\xE1",appendTitleAuto:"Agregue un nuevo campo con el tipo 'auto' (Ctrl + Shift + Ins)",ascending:"Ascendente",ascendingTitle:"Ordene los elementos secundarios de este ${type} en orden ascendente",actionsMenu:"Haga clic para abrir el men\xFA de acciones (Ctrl + M)",cannotParseFieldError:"No se puede parsear el campo en JSON",cannotParseValueError:"No se puede parsear el valor en JSON",collapseAll:"Contraer todos los campos",compactTitle:"Compactar datos JSON, eliminar todos los espacios en blanco (Ctrl + Shift + I)",descending:"Descendente",descendingTitle:"Ordene los hijos de este ${type} en orden descendente",drag:"Arrastre para mover este campo (Alt + May\xFAs + Flechas)",duplicateKey:"llave duplicada",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos seleccionados (Ctrl + D)",duplicateField:"Duplicar este campo (Ctrl + D)",duplicateFieldError:"Nombre de campo duplicado",empty:"vacio",expandAll:"Expandir todos los campos",expandTitle:`Haga clic para expandir/contraer este campo (Ctrl + E). 
  Ctrl+Clic para expandir/contraer incluyendo todos los ni\xF1os.`,formatTitle:"Formatee los datos JSON, con la sangr\xEDa y los avances de l\xEDnea adecuados (Ctrl + I)",insert:"Insertar",insertTitle:"Inserte un nuevo campo con el tipo 'auto' antes de este campo (Ctrl + Ins)",insertSub:"Seleccione el tipo de campo a insertar",object:"Objeto",ok:"Ok",redo:"Rehacer (Ctrl+May\xFAs+Z)",removeText:"Eliminar",removeTitle:"Eliminar campos seleccionados (Ctrl+Supr)",removeField:"Eliminar este campo (Ctrl+Supr)",repairTitle:"Reparar JSON: corrija comillas y caracteres de escape, elimine comentarios y notaci\xF3n JSONP, convierta objetos JavaScript en JSON.",searchTitle:"Campos de b\xFAsqueda y valores",searchNextResultTitle:"Siguiente resultado (Entrar)",searchPreviousResultTitle:"Resultado anterior (Shift + Enter)",selectNode:"Seleccione un nodo...",showAll:"mostrar todo",showMore:"mostrar m\xE1s",showMoreStatus:"mostrando ${visibleChilds} de ${totalChilds} elementos.",sort:"Ordenar",sortTitle:"Ordene los hijos de este ${type}",sortTitleShort:"Ordenar contenidos",sortFieldLabel:"Campo:",sortDirectionLabel:"Direcci\xF3n:",sortFieldTitle:"Seleccione el campo anidado por el cual ordenar la matriz u objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar el campo seleccionado en orden ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar por el campo seleccionado, en orden descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar o transformar los hijos de este ${type}",transformTitleShort:"Filtrar, ordenar o transformar contenidos",extract:"Extraer",extractTitle:"Extrae este ${type}",transformQueryTitle:"Ingrese una consulta JMESPath",transformWizardLabel:"Wizard",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Seleccione un campo",transformQueryLabel:"Consulta",transformPreviewLabel:"Vista Previa",type:"Tipo",typeTitle:"Cambiar el tipo de campo",openUrl:"Ctrl+Click o Ctrl+Enter para abrir la URL en una nueva ventana",undo:"Deshacer la \xFAltima acci\xF3n (Ctrl+Z)",validationCannotMove:"No se puede mover un campo a un hijo de s\xED mismo.",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Tipo de campo "objeto".  Un objeto contiene un conjunto desordenado de pares clave/valor.',arrayType:'Tipo de campo "matriz".  Una matriz contiene una colecci\xF3n ordenada de valores.',stringType:'Tipo de campo "cadena".  El tipo de campo no se determina a partir del valor,  pero siempre se devuelve como una cadena.',modeEditorTitle:"Cambiar modo de editor",modeCodeText:"Codigo",modeCodeTitle:"Cambiar al resaltador de c\xF3digo",modeFormText:"Formulario",modeFormTitle:"Cambiar al editor de formularios",modeTextText:"Texto",modeTextTitle:"Cambiar al editor de texto sin formato",modeTreeText:"Arbol",modeTreeTitle:"Cambiar al editor de \xE1rbol",modeViewText:"Vista",modeViewTitle:"Cambiar a la vista de \xE1rbol",modePreviewText:"Vista Previa",modePreviewTitle:"Cambiar al modo de vista previa",examples:"Ejemplos",default:"Predeterminado",containsInvalidProperties:"Contiene propiedades no validas",containsInvalidItems:"Contiene items no validos"},"zh-CN":{array:"\u6570\u7EC4",auto:"\u81EA\u52A8",appendText:"\u8FFD\u52A0",appendTitle:"\u5728\u6B64\u5B57\u6BB5\u540E\u8FFD\u52A0\u4E00\u4E2A\u7C7B\u578B\u4E3A\u201Cauto\u201D\u7684\u65B0\u5B57\u6BB5 (Ctrl+Shift+Ins)",appendSubmenuTitle:"\u9009\u62E9\u8981\u8FFD\u52A0\u7684\u5B57\u6BB5\u7C7B\u578B",appendTitleAuto:"\u8FFD\u52A0\u7C7B\u578B\u4E3A\u201Cauto\u201D\u7684\u65B0\u5B57\u6BB5 (Ctrl+Shift+Ins)",ascending:"\u5347\u5E8F",ascendingTitle:"\u5347\u5E8F\u6392\u5217${type}\u7684\u5B50\u8282\u70B9",actionsMenu:"\u70B9\u51FB\u6253\u5F00\u52A8\u4F5C\u83DC\u5355(Ctrl+M)",cannotParseFieldError:"\u65E0\u6CD5\u5C06\u5B57\u6BB5\u89E3\u6790\u4E3AJSON",cannotParseValueError:"\u65E0\u6CD5\u5C06\u503C\u89E3\u6790\u4E3AJSON",collapseAll:"\u7F29\u8FDB\u6240\u6709\u5B57\u6BB5",compactTitle:"\u538B\u7F29JSON\u6570\u636E\uFF0C\u5220\u9664\u6240\u6709\u7A7A\u683C (Ctrl+Shift+I)",descending:"\u964D\u5E8F",descendingTitle:"\u964D\u5E8F\u6392\u5217${type}\u7684\u5B50\u8282\u70B9",drag:"\u62D6\u62FD\u79FB\u52A8\u8BE5\u8282\u70B9(Alt+Shift+Arrows)",duplicateKey:"\u91CD\u590D\u952E",duplicateText:"\u590D\u5236",duplicateTitle:"\u590D\u5236\u9009\u4E2D\u5B57\u6BB5(Ctrl+D)",duplicateField:"\u590D\u5236\u8BE5\u5B57\u6BB5(Ctrl+D)",duplicateFieldError:"\u91CD\u590D\u7684\u5B57\u6BB5\u540D\u79F0",empty:"\u6E05\u7A7A",expandAll:"\u5C55\u5F00\u6240\u6709\u5B57\u6BB5",expandTitle:`\u70B9\u51FB \u5C55\u5F00/\u6536\u7F29 \u8BE5\u5B57\u6BB5(Ctrl+E). 
Ctrl+Click \u5C55\u5F00/\u6536\u7F29 \u5305\u542B\u6240\u6709\u5B50\u8282\u70B9.`,formatTitle:"\u4F7F\u7528\u9002\u5F53\u7684\u7F29\u8FDB\u548C\u6362\u884C\u7B26\u683C\u5F0F\u5316JSON\u6570\u636E (Ctrl+I)",insert:"\u63D2\u5165",insertTitle:"\u5728\u6B64\u5B57\u6BB5\u524D\u63D2\u5165\u7C7B\u578B\u4E3A\u201Cauto\u201D\u7684\u65B0\u5B57\u6BB5 (Ctrl+Ins)",insertSub:"\u9009\u62E9\u8981\u63D2\u5165\u7684\u5B57\u6BB5\u7C7B\u578B",object:"\u5BF9\u8C61",ok:"Ok",redo:"\u91CD\u505A (Ctrl+Shift+Z)",removeText:"\u79FB\u9664",removeTitle:"\u79FB\u9664\u9009\u4E2D\u5B57\u6BB5 (Ctrl+Del)",removeField:"\u79FB\u9664\u8BE5\u5B57\u6BB5 (Ctrl+Del)",repairTitle:"\u4FEE\u590DJSON\uFF1A\u4FEE\u590D\u5F15\u53F7\u548C\u8F6C\u4E49\u7B26\uFF0C\u5220\u9664\u6CE8\u91CA\u548CJSONP\u8868\u793A\u6CD5\uFF0C\u5C06JavaScript\u5BF9\u8C61\u8F6C\u6362\u4E3AJSON\u3002",selectNode:"\u9009\u62E9\u4E00\u4E2A\u8282\u70B9...",showAll:"\u5C55\u793A\u5168\u90E8",showMore:"\u5C55\u793A\u66F4\u591A",showMoreStatus:"\u663E\u793A${totalChilds}\u7684${visibleChilds}\u9879\u76EE.",sort:"\u6392\u5E8F",sortTitle:"\u6392\u5E8F${type}\u7684\u5B50\u8282\u70B9",sortTitleShort:"\u5185\u5BB9\u6392\u5E8F",sortFieldLabel:"\u5B57\u6BB5\uFF1A",sortDirectionLabel:"\u65B9\u5411\uFF1A",sortFieldTitle:"\u9009\u62E9\u7528\u4E8E\u5BF9\u6570\u7EC4\u6216\u5BF9\u8C61\u6392\u5E8F\u7684\u5D4C\u5957\u5B57\u6BB5",sortAscending:"\u5347\u5E8F\u6392\u5E8F",sortAscendingTitle:"\u6309\u7167\u8BE5\u5B57\u6BB5\u5347\u5E8F\u6392\u5E8F",sortDescending:"\u964D\u5E8F\u6392\u5E8F",sortDescendingTitle:"\u6309\u7167\u8BE5\u5B57\u6BB5\u964D\u5E8F\u6392\u5E8F",string:"\u5B57\u7B26\u4E32",transform:"\u53D8\u6362",transformTitle:"\u7B5B\u9009\uFF0C\u6392\u5E8F\uFF0C\u6216\u8005\u8F6C\u6362${type}\u7684\u5B50\u8282\u70B9",transformTitleShort:"\u7B5B\u9009\uFF0C\u6392\u5E8F\uFF0C\u6216\u8005\u8F6C\u6362\u5185\u5BB9",extract:"\u63D0\u53D6",extractTitle:"\u63D0\u53D6\u8FD9\u4E2A ${type}",transformQueryTitle:"\u8F93\u5165JMESPath\u67E5\u8BE2",transformWizardLabel:"\u5411\u5BFC",transformWizardFilter:"\u7B5B\u9009",transformWizardSortBy:"\u6392\u5E8F",transformWizardSelectFields:"\u9009\u62E9\u5B57\u6BB5",transformQueryLabel:"\u67E5\u8BE2",transformPreviewLabel:"\u9884\u89C8",type:"\u7C7B\u578B",typeTitle:"\u66F4\u6539\u5B57\u6BB5\u7C7B\u578B",openUrl:"Ctrl+Click \u6216\u8005 Ctrl+Enter \u5728\u65B0\u7A97\u53E3\u6253\u5F00\u94FE\u63A5",undo:"\u64A4\u9500\u4E0A\u6B21\u52A8\u4F5C (Ctrl+Z)",validationCannotMove:"\u65E0\u6CD5\u5C06\u5B57\u6BB5\u79FB\u5165\u5176\u5B50\u8282\u70B9",autoType:'\u5B57\u6BB5\u7C7B\u578B "auto". \u5B57\u6BB5\u7C7B\u578B\u7531\u503C\u81EA\u52A8\u786E\u5B9A \u53EF\u4EE5\u4E3A string\uFF0Cnumber\uFF0Cboolean\uFF0C\u6216\u8005 null.',objectType:'\u5B57\u6BB5\u7C7B\u578B "object". \u5BF9\u8C61\u5305\u542B\u4E00\u7EC4\u65E0\u5E8F\u7684\u952E/\u503C\u5BF9.',arrayType:'\u5B57\u6BB5\u7C7B\u578B "array". \u6570\u7EC4\u5305\u542B\u503C\u7684\u6709\u5E8F\u96C6\u5408.',stringType:'\u5B57\u6BB5\u7C7B\u578B "string". \u5B57\u6BB5\u7C7B\u578B\u7531\u503C\u81EA\u52A8\u786E\u5B9A\uFF0C\u4F46\u59CB\u7EC8\u4F5C\u4E3A\u5B57\u7B26\u4E32\u8FD4\u56DE.',modeCodeText:"\u4EE3\u7801",modeCodeTitle:"\u5207\u6362\u81F3\u4EE3\u7801\u9AD8\u4EAE",modeFormText:"\u8868\u5355",modeFormTitle:"\u5207\u6362\u81F3\u8868\u5355\u7F16\u8F91",modeTextText:"\u6587\u672C",modeTextTitle:"\u5207\u6362\u81F3\u6587\u672C\u7F16\u8F91",modeTreeText:"\u6811",modeTreeTitle:"\u5207\u6362\u81F3\u6811\u7F16\u8F91",modeViewText:"\u89C6\u56FE",modeViewTitle:"\u5207\u6362\u81F3\u6811\u89C6\u56FE",modePreviewText:"\u9884\u89C8",modePreviewTitle:"\u5207\u6362\u81F3\u9884\u89C8\u6A21\u5F0F",examples:"\u4F8B\u5B50",default:"\u7F3A\u7701",containsInvalidProperties:"\u5305\u542B\u65E0\u6548\u7684\u5C5E\u6027",containsInvalidItems:"\u5305\u542B\u65E0\u6548\u9879\u76EE"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de a\xE7\xF5es (Ctrl+M)",cannotParseFieldError:"N\xE3o \xE9 poss\xEDvel analisar o campo no JSON",cannotParseValueError:"N\xE3o \xE9 poss\xEDvel analisar o valor em JSON",collapseAll:"Fechar todos campos",compactTitle:"Dados JSON compactos, remova todos os espa\xE7os em branco (Ctrl+Shift+I)",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:`Clique para expandir/encolher este campo (Ctrl+E). 
Ctrl+Click para expandir/encolher incluindo todos os filhos.`,formatTitle:"Formate dados JSON, com recuo e feeds de linha adequados (Ctrl+I)",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",repairTitle:"Repare JSON: corrija aspas e caracteres de escape, remova coment\xE1rios e nota\xE7\xE3o JSONP, transforme objetos JavaScript em JSON.",selectNode:"Selecione um n\xF3dulo...",showAll:"mostrar todos",showMore:"mostrar mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Campo:",sortDirectionLabel:"Dire\xE7\xE3o:",sortFieldTitle:"Selecione um campo filho pelo qual ordenar o array ou objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar o campo selecionado por ordem ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar o campo selecionado por ordem descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar ou transformar os filhos deste ${type}",transformTitleShort:"Filtrar, ordenar ou transformar conte\xFAdos",transformQueryTitle:"Insira uma express\xE3o JMESPath",transformWizardLabel:"Assistente",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Selecionar campos",transformQueryLabel:"Express\xE3o",transformPreviewLabel:"Visualizar",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer \xFAltimo a\xE7\xE3o (Ctrl+Z)",validationCannotMove:"N\xE3o pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo \xE9 determinao automaticamente a partir do seu valor e pode ser texto, n\xFAmero, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto cont\xE9m uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma cole\xE7\xE3o de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao \xE9 determinado atrav\xE9s do seu valor, mas sempre retornara um texto.',examples:"Exemplos",default:"Revelia",containsInvalidProperties:"Cont\xE9m propriedades inv\xE1lidas",containsInvalidItems:"Cont\xE9m itens inv\xE1lidos"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alan\u0131n alt\u0131na 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alan\u0131n tipini se\xE7",appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'\u0131n alt tiplerini artan d\xFCzende s\u0131rala",actionsMenu:"Aksiyon men\xFCs\xFCn\xFC a\xE7mak i\xE7in t\u0131klay\u0131n (Ctrl+M)",collapseAll:"T\xFCm alanlar\u0131 kapat",descending:"Azalan",descendingTitle:"${type}'\u0131n alt tiplerini azalan d\xFCzende s\u0131rala",drag:"Bu alan\u0131 ta\u015F\u0131mak i\xE7in s\xFCr\xFCkleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",duplicateText:"A\u015Fa\u011F\u0131ya kopyala",duplicateTitle:"Se\xE7ili alanlardan bir daha olu\u015Ftur (Ctrl+D)",duplicateField:"Bu alandan bir daha olu\u015Ftur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayr\u0131\u015Ft\u0131r\u0131lam\u0131yor",cannotParseValueError:"JSON'a de\u011Fer ayr\u0131\u015Ft\u0131r\u0131lam\u0131yor",empty:"bo\u015F",expandAll:"T\xFCm alanlar\u0131 a\xE7",expandTitle:`Bu alan\u0131 a\xE7mak/kapatmak i\xE7in t\u0131kla (Ctrl+E). 
Alt alanlarda dahil t\xFCm alanlar\u0131 a\xE7mak i\xE7in Ctrl+Click `,insert:"Ekle",insertTitle:"Bu alan\u0131n \xFCst\xFCne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alan\u0131n tipini se\xE7",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kald\u0131r",removeTitle:"Se\xE7ilen alanlar\u0131 kald\u0131r (Ctrl+Del)",removeField:"Bu alan\u0131 kald\u0131r (Ctrl+Del)",selectNode:"Bir nesne se\xE7...",showAll:"t\xFCm\xFCn\xFC g\xF6ster",showMore:"daha fazla g\xF6ster",showMoreStatus:"${totalChilds} alan\u0131n ${visibleChilds} alt alanlar\u0131 g\xF6steriliyor",sort:"S\u0131rala",sortTitle:"${type}'\u0131n alt alanlar\u0131n\u0131 s\u0131rala",sortTitleShort:"\u0130\xE7erikleri s\u0131rala",sortFieldLabel:"Alan:",sortDirectionLabel:"Y\xF6n:",sortFieldTitle:"Diziyi veya nesneyi s\u0131ralamak i\xE7in i\xE7 i\xE7e ge\xE7mi\u015F alan\u0131 se\xE7in",sortAscending:"Artan",sortAscendingTitle:"Se\xE7ili alan\u0131 artan d\xFCzende s\u0131rala",sortDescending:"Azalan",sortDescendingTitle:"Se\xE7ili alan\u0131 azalan d\xFCzende s\u0131rala",string:"Karakter Dizisi",transform:"D\xF6n\xFC\u015Ft\xFCr",transformTitle:"${type}'\u0131n alt alanlar\u0131n\u0131 filtrele, s\u0131rala veya d\xF6n\xFC\u015Ft\xFCr",transformTitleShort:"\u0130\xE7erikleri filterele, s\u0131rala veya d\xF6n\xFC\u015Ft\xFCr",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"S\u0131rala",transformWizardSelectFields:"Alanlar\u0131 se\xE7",transformQueryLabel:"Sorgu",transformPreviewLabel:"\xD6nizleme",type:"Tip",typeTitle:"Bu alan\u0131n tipini de\u011Fi\u015Ftir",openUrl:"URL'i yeni bir pencerede a\xE7mak i\xE7in Ctrl+Click veya Ctrl+Enter",undo:"Son de\u011Fi\u015Fikli\u011Fi geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak ta\u015F\u0131nam\u0131yor",autoType:'Alan tipi "otomatik". Alan t\xFCr\xFC otomatik olarak de\u011Ferden belirlenirve bir dize, say\u0131, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, s\u0131ralanmam\u0131\u015F bir anahtar / de\u011Fer \xE7ifti k\xFCmesi i\xE7erir.',arrayType:'Alan tipi "dizi". Bir dizi, d\xFCzenli de\u011Ferler koleksiyonu i\xE7erir.',stringType:'Alan tipi "karakter dizisi". Alan t\xFCr\xFC de\u011Ferden belirlenmez,ancak her zaman karakter dizisi olarak d\xF6nd\xFCr\xFCl\xFCr.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulay\u0131c\u0131ya ge\xE7",modeFormText:"Form",modeFormTitle:"Form d\xFCzenleyiciye ge\xE7",modeTextText:"Metin",modeTextTitle:"D\xFCz metin d\xFCzenleyiciye ge\xE7",modeTreeText:"A\u011Fa\xE7",modeTreeTitle:"A\u011Fa\xE7 d\xFCzenleyiciye ge\xE7",modeViewText:"G\xF6r\xFCn\xFCm",modeViewTitle:"A\u011Fa\xE7 g\xF6r\xFCn\xFCm\xFCne ge\xE7",examples:"\xD6rnekler",default:"Varsay\u0131lan",containsInvalidProperties:"Ge\xE7ersiz \xF6zellikler i\xE7eriyor",containsInvalidItems:"Ge\xE7ersiz \xF6\u011Feler i\xE7eriyor"},ja:{array:"\u914D\u5217",auto:"\u30AA\u30FC\u30C8",appendText:"\u8FFD\u52A0",appendTitle:'\u6B21\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u306B"\u30AA\u30FC\u30C8"\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u8FFD\u52A0 (Ctrl+Shift+Ins)',appendSubmenuTitle:"\u8FFD\u52A0\u3059\u308B\u30D5\u30A3\u30FC\u30EB\u30C9\u306E\u578B\u3092\u9078\u629E\u3057\u3066\u304F\u3060\u3055\u3044",appendTitleAuto:'"\u30AA\u30FC\u30C8"\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u8FFD\u52A0 (Ctrl+Shift+Ins)',ascending:"\u6607\u9806",ascendingTitle:"${type}\u306E\u5B50\u8981\u7D20\u3092\u6607\u9806\u306B\u4E26\u3079\u66FF\u3048",actionsMenu:"\u30AF\u30EA\u30C3\u30AF\u3057\u3066\u30A2\u30AF\u30B7\u30E7\u30F3\u30E1\u30CB\u30E5\u30FC\u3092\u958B\u304F (Ctrl+M)",collapseAll:"\u3059\u3079\u3066\u3092\u6298\u308A\u305F\u305F\u3080",descending:"\u964D\u9806",descendingTitle:"${type}\u306E\u5B50\u8981\u7D20\u3092\u964D\u9806\u306B\u4E26\u3079\u66FF\u3048",drag:"\u30C9\u30E9\u30C3\u30B0\u3057\u3066\u9078\u629E\u4E2D\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u79FB\u52D5 (Alt+Shift+Arrows)",duplicateKey:"\u8907\u88FD\u30AD\u30FC",duplicateText:"\u8907\u88FD",duplicateTitle:"\u9078\u629E\u4E2D\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u8907\u88FD (Ctrl+D)",duplicateField:"\u9078\u629E\u4E2D\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u8907\u88FD (Ctrl+D)",duplicateFieldError:"\u30D5\u30A3\u30FC\u30EB\u30C9\u540D\u304C\u91CD\u8907\u3057\u3066\u3044\u307E\u3059",cannotParseFieldError:"JSON\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u89E3\u6790\u3067\u304D\u307E\u305B\u3093",cannotParseValueError:"JSON\u306E\u5024\u3092\u89E3\u6790\u3067\u304D\u307E\u305B\u3093",empty:"\u7A7A",expandAll:"\u3059\u3079\u3066\u3092\u5C55\u958B",expandTitle:`\u30AF\u30EA\u30C3\u30AF\u3057\u3066\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u5C55\u958B/\u6298\u308A\u305F\u305F\u3080 (Ctrl+E). 
Ctrl+Click \u3067\u3059\u3079\u3066\u306E\u5B50\u8981\u7D20\u3092\u5C55\u958B/\u6298\u308A\u305F\u305F\u3080`,insert:"\u633F\u5165",insertTitle:"\u9078\u629E\u4E2D\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u306E\u524D\u306B\u65B0\u3057\u3044\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u633F\u5165 (Ctrl+Ins)",insertSub:"\u633F\u5165\u3059\u308B\u30D5\u30A3\u30FC\u30EB\u30C9\u306E\u578B\u3092\u9078\u629E",object:"\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8",ok:"\u5B9F\u884C",redo:"\u3084\u308A\u76F4\u3059 (Ctrl+Shift+Z)",removeText:"\u524A\u9664",removeTitle:"\u9078\u629E\u4E2D\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u524A\u9664 (Ctrl+Del)",removeField:"\u9078\u629E\u4E2D\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u524A\u9664 (Ctrl+Del)",selectNode:"\u30CE\u30FC\u30C9\u3092\u9078\u629E...",showAll:"\u3059\u3079\u3066\u3092\u8868\u793A",showMore:"\u3082\u3063\u3068\u898B\u308B",showMoreStatus:"${totalChilds}\u500B\u306E\u30A2\u30A4\u30C6\u30E0\u306E\u3046\u3061 ${visibleChilds}\u500B\u3092\u8868\u793A\u3057\u3066\u3044\u307E\u3059\u3002",sort:"\u4E26\u3079\u66FF\u3048",sortTitle:"${type}\u306E\u5B50\u8981\u7D20\u3092\u4E26\u3079\u66FF\u3048",sortTitleShort:"\u4E26\u3079\u66FF\u3048",sortFieldLabel:"\u30D5\u30A3\u30FC\u30EB\u30C9:",sortDirectionLabel:"\u9806\u5E8F:",sortFieldTitle:"\u914D\u5217\u307E\u305F\u306F\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u3092\u4E26\u3073\u66FF\u3048\u308B\u305F\u3081\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u9078\u629E",sortAscending:"\u6607\u9806",sortAscendingTitle:"\u9078\u629E\u4E2D\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u6607\u9806\u306B\u4E26\u3073\u66FF\u3048",sortDescending:"\u964D\u9806",sortDescendingTitle:"\u9078\u629E\u4E2D\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u964D\u9806\u306B\u4E26\u3073\u66FF\u3048",string:"\u6587\u5B57\u5217",transform:"\u5909\u63DB",transformTitle:"${type}\u306E\u5B50\u8981\u7D20\u3092\u30D5\u30A3\u30EB\u30BF\u30FC\u30FB\u4E26\u3073\u66FF\u3048\u30FB\u5909\u63DB\u3059\u308B",transformTitleShort:"\u5185\u5BB9\u3092\u30D5\u30A3\u30EB\u30BF\u30FC\u30FB\u4E26\u3073\u66FF\u3048\u30FB\u5909\u63DB\u3059\u308B",extract:"\u62BD\u51FA",extractTitle:"${type}\u3092\u62BD\u51FA",transformQueryTitle:"JMESPath\u30AF\u30A8\u30EA\u3092\u5165\u529B",transformWizardLabel:"\u30A6\u30A3\u30B6\u30FC\u30C9",transformWizardFilter:"\u30D5\u30A3\u30EB\u30BF\u30FC",transformWizardSortBy:"\u4E26\u3073\u66FF\u3048",transformWizardSelectFields:"\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u9078\u629E",transformQueryLabel:"\u30AF\u30A8\u30EA",transformPreviewLabel:"\u30D7\u30EC\u30D3\u30E5\u30FC",type:"\u578B",typeTitle:"\u9078\u629E\u4E2D\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u306E\u578B\u3092\u5909\u66F4",openUrl:"Ctrl+Click \u307E\u305F\u306F Ctrl+Enter \u3067 \u65B0\u898F\u30A6\u30A3\u30F3\u30C9\u30A6\u3067URL\u3092\u958B\u304F",undo:"\u5143\u306B\u623B\u3059 (Ctrl+Z)",validationCannotMove:"\u5B50\u8981\u7D20\u306B\u79FB\u52D5\u3067\u304D\u307E\u305B\u3093 ",autoType:"\u30AA\u30FC\u30C8\uFF1A \u30D5\u30A3\u30FC\u30EB\u30C9\u306E\u578B\u306F\u5024\u304B\u3089\u81EA\u52D5\u7684\u306B\u6C7A\u5B9A\u3055\u308C\u307E\u3059\u3002 (\u6587\u5B57\u5217\u30FB\u6570\u5024\u30FB\u30D6\u30FC\u30EB\u30FBnull)",objectType:"\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\uFF1A \u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u306F\u9806\u5E8F\u304C\u6C7A\u307E\u3063\u3066\u3044\u306A\u3044\u30AD\u30FC\u3068\u5024\u306E\u30DA\u30A2\u7D44\u307F\u5408\u308F\u305B\u3067\u3059\u3002",arrayType:"\u914D\u5217\uFF1A \u914D\u5217\u306F\u9806\u5E8F\u304C\u6C7A\u307E\u3063\u3066\u3044\u308B\u5024\u306E\u96C6\u5408\u4F53\u3067\u3059\u3002",stringType:"\u6587\u5B57\u5217\uFF1A \u30D5\u30A3\u30FC\u30EB\u30C9\u578B\u306F\u5024\u304B\u3089\u6C7A\u5B9A\u3055\u308C\u307E\u305B\u3093\u304C\u3001\u5E38\u306B\u6587\u5B57\u5217\u3068\u3057\u3066\u8FD4\u3055\u308C\u307E\u3059\u3002",modeCodeText:"\u30B3\u30FC\u30C9\u30E2\u30FC\u30C9",modeCodeTitle:"\u30CF\u30A4\u30E9\u30A4\u30C8\u30E2\u30FC\u30C9\u306B\u5207\u308A\u66FF\u3048",modeFormText:"\u30D5\u30A9\u30FC\u30E0\u30E2\u30FC\u30C9",modeFormTitle:"\u30D5\u30A9\u30FC\u30E0\u30E2\u30FC\u30C9\u306B\u5207\u308A\u66FF\u3048",modeTextText:"\u30C6\u30AD\u30B9\u30C8\u30E2\u30FC\u30C9",modeTextTitle:"\u30C6\u30AD\u30B9\u30C8\u30E2\u30FC\u30C9\u306B\u5207\u308A\u66FF\u3048",modeTreeText:"\u30C4\u30EA\u30FC\u30E2\u30FC\u30C9",modeTreeTitle:"\u30C4\u30EA\u30FC\u30E2\u30FC\u30C9\u306B\u5207\u308A\u66FF\u3048",modeViewText:"\u30D3\u30E5\u30FC\u30E2\u30FC\u30C9",modeViewTitle:"\u30D3\u30E5\u30FC\u30E2\u30FC\u30C9\u306B\u5207\u308A\u66FF\u3048",modePreviewText:"\u30D7\u30EC\u30D3\u30E5\u30FC",modePreviewTitle:"\u30D7\u30EC\u30D3\u30E5\u30FC\u306B\u5207\u308A\u66FF\u3048",examples:"\u4F8B",default:"\u30C7\u30D5\u30A9\u30EB\u30C8",containsInvalidProperties:"\u7121\u52B9\u306A\u30D7\u30ED\u30D1\u30C6\u30A3\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059",containsInvalidItems:"\u7121\u52B9\u306A\u30A2\u30A4\u30C6\u30E0\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059"},"fr-FR":{array:"Liste",auto:"Auto",appendText:"Ajouter",appendTitle:"Ajouter un champ de type 'auto' apr\xE8s ce champ (Ctrl+Shift+Ins)",appendSubmenuTitle:"S\xE9lectionner le type du champ \xE0 ajouter",appendTitleAuto:"Ajouter un champ de type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendant",ascendingTitle:"Trier les enfants de ce ${type} par ordre ascendant",actionsMenu:"Ouvrir le menu des actions (Ctrl+M)",collapseAll:"Regrouper",descending:"Descendant",descendingTitle:"Trier les enfants de ce ${type} par ordre descendant",drag:"D\xE9placer (Alt+Shift+Arrows)",duplicateKey:"Dupliquer la cl\xE9",duplicateText:"Dupliquer",duplicateTitle:"Dupliquer les champs s\xE9lectionn\xE9s (Ctrl+D)",duplicateField:"Dupliquer ce champ (Ctrl+D)",duplicateFieldError:"Dupliquer le nom de champ",cannotParseFieldError:"Champ impossible \xE0 parser en JSON",cannotParseValueError:"Valeur impossible \xE0 parser en JSON",empty:"vide",expandAll:"\xC9tendre",expandTitle:`\xC9tendre/regrouper ce champ (Ctrl+E). 
Ctrl+Click pour \xE9tendre/regrouper avec tous les champs.`,insert:"Ins\xE9rer",insertTitle:"Ins\xE9rer un champ de type 'auto' avant ce champ (Ctrl+Ins)",insertSub:"S\xE9lectionner le type de champ \xE0 ins\xE9rer",object:"Objet",ok:"Ok",redo:"Rejouer (Ctrl+Shift+Z)",removeText:"Supprimer",removeTitle:"Supprimer les champs s\xE9lectionn\xE9s (Ctrl+Del)",removeField:"Supprimer ce champ (Ctrl+Del)",searchTitle:"Rechercher champs et valeurs",searchNextResultTitle:"R\xE9sultat suivant (Enter)",searchPreviousResultTitle:"R\xE9sultat pr\xE9c\xE9dent (Shift + Enter)",selectNode:"S\xE9lectionner un n\u0153ud...",showAll:"voir tout",showMore:"voir plus",showMoreStatus:"${visibleChilds} \xE9l\xE9ments affich\xE9s de ${totalChilds}.",sort:"Trier",sortTitle:"Trier les champs de ce ${type}",sortTitleShort:"Trier",sortFieldLabel:"Champ:",sortDirectionLabel:"Direction:",sortFieldTitle:"S\xE9lectionner les champs permettant de trier les listes et objet",sortAscending:"Ascendant",sortAscendingTitle:"Trier les champs s\xE9lectionn\xE9s par ordre ascendant",sortDescending:"Descendant",sortDescendingTitle:"Trier les champs s\xE9lectionn\xE9s par ordre descendant",string:"Cha\xEEne",transform:"Transformer",transformTitle:"Filtrer, trier, or transformer les enfants de ce ${type}",transformTitleShort:"Filtrer, trier ou transformer le contenu",extract:"Extraire",extractTitle:"Extraire ce ${type}",transformQueryTitle:"Saisir une requ\xEAte JMESPath",transformWizardLabel:"Assistant",transformWizardFilter:"Filtrer",transformWizardSortBy:"Trier par",transformWizardSelectFields:"S\xE9lectionner les champs",transformQueryLabel:"Requ\xEAte",transformPreviewLabel:"Pr\xE9visualisation",type:"Type",typeTitle:"Changer le type de ce champ",openUrl:"Ctrl+Click ou Ctrl+Enter pour ouvrir l'url dans une autre fen\xEAtre",undo:"Annuler la derni\xE8re action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Champe de type "auto". Ce type de champ est automatiquement d\xE9termin\xE9 en fonction de la valeur et peut \xEAtre de type "cha\xEEne", "nombre", "bool\xE9en" ou null.',objectType:'Champ de type "objet". Un objet contient un ensemble non ordonn\xE9 de paires cl\xE9/valeur.',arrayType:'Champ de type "liste". Une liste contient une collection ordonn\xE9e de valeurs.',stringType:`Champ de type "cha\xEEne". Ce type de champ n'est pas d\xE9termin\xE9 en fonction de la valeur, mais retourne syst\xE9matiquement une cha\xEEne de caract\xE8res.`,modeEditorTitle:"Changer mode d'\xE9dition",modeCodeText:"Code",modeCodeTitle:"Activer surlignage code",modeFormText:"Formulaire",modeFormTitle:"Activer formulaire",modeTextText:"Texte",modeTextTitle:"Activer \xE9diteur texte",modeTreeText:"Arbre",modeTreeTitle:"Activer \xE9diteur arbre",modeViewText:"Lecture seule",modeViewTitle:"Activer vue arbre",modePreviewText:"Pr\xE9visualisation",modePreviewTitle:"Activer mode pr\xE9visualiser",examples:"Exemples",default:"D\xE9faut",containsInvalidProperties:"Contient des propri\xE9t\xE9s non valides",containsInvalidItems:"Contient des \xE9l\xE9ments invalides"},de:{array:"Auflistung",auto:"Auto",appendText:"anh\xE4ngen",appendTitle:"F\xFCgen Sie nach diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Umschalt+Ein)",appendSubmenuTitle:"W\xE4hlen Sie den Typ des neuen Feldes",appendTitleAuto:"Ein neues Feld vom Typ 'auto' hinzuf\xFCgen (Strg+Umschalt+Ein)",ascending:"Aufsteigend",ascendingTitle:"Sortieren Sie die Elemente dieses ${type} in aufsteigender Reihenfolge",actionsMenu:"Klicken Sie zum \xD6ffnen des Aktionsmen\xFCs (Strg+M)",cannotParseFieldError:"Feld kann nicht in JSON geparst werden",cannotParseValueError:"Wert kann nicht in JSON geparst werden",collapseAll:"Alle Felder zuklappen",compactTitle:"JSON-Daten verdichten, alle Leerzeichen entfernen (Strg+Umschalt+\\)",descending:"Absteigend",descendingTitle:"Sortieren Sie die Elemente dieses ${type} in absteigender Reihenfolge",drag:"Ziehen, um dieses Feld zu verschieben (Alt+Umschalt+Pfeile)",duplicateKey:"Doppelter Schl\xFCssel",duplicateText:"Duplikat",duplicateTitle:"Ausgew\xE4hlte Felder duplizieren (Strg+D)",duplicateField:"Dieses Feld duplizieren (Strg+D)",duplicateFieldError:"Doppelter Feldname",empty:"leer",expandAll:"Alle Felder anzeigen",expandTitle:`Klicken Sie, um dieses Feld zu erweitern/zu kollabieren (Strg+E). 
Strg+Klicken Sie, um dieses Feld einschlie\xDFlich aller Elemente zu erweitern/zu kollabieren.`,formatTitle:"JSON-Daten mit korrekter Einr\xFCckung und Zeilenvorsch\xFCben formatieren (Strg+\\)",insert:"einf\xFCgen",insertTitle:"F\xFCgen Sie vor diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Einfg)",insertSub:"W\xE4hlen Sie den Typ des neuen Feldes",object:"Objekt",ok:"Ok",redo:"Wiederholen (Strg+Umschalt+Z)",removeText:"entfernen",removeTitle:"Ausgew\xE4hlte Felder entfernen (Strg+Entf)",removeField:"Dieses Feld entfernen (Strg+Entf)",repairTitle:"JSON reparieren: Anf\xFChrungszeichen und Escape-Zeichen korrigieren, Kommentare und JSONP-Notation entfernen, JavaScript-Objekte in JSON umwandeln.",searchTitle:"Suchfelder und Werte",searchNextResultTitle:"N\xE4chstes Ergebnis (Enter)",searchPreviousResultTitle:"Vorheriges Ergebnis (Umschalt + Eingabe)",selectNode:"W\xE4hlen Sie einen Knoten aus...",showAll:"alle anzeigen",showMore:"mehr anzeigen",showMoreStatus:"Anzeige von ${visibleChilds} von ${totalChilds}-Elementen.",sort:"Sortieren",sortTitle:"Sortieren Sie die Elemente dieses ${type}",sortTitleShort:"Inhalt sortieren",sortFieldLabel:"Feld:",sortDirectionLabel:"Richtung:",sortFieldTitle:"W\xE4hlen Sie das verschachtelte Feld, nach dem das Array oder Objekt sortiert werden soll.",sortAscending:"Aufsteigend",sortAscendingTitle:"Sortieren Sie das ausgew\xE4hlte Feld in aufsteigender Reihenfolge",sortDescending:"Absteigend",sortDescendingTitle:"Sortieren Sie das ausgew\xE4hlte Feld in absteigender Reihenfolge",string:"Zeichenfolge",transform:"Verwandeln",transformTitle:"Die Elemente dieses ${type} filtern, sortieren oder transformieren",transformTitleShort:"Inhalte filtern, sortieren oder transformieren",extract:"Auszug",extractTitle:"Extrahieren Sie diesen ${type}",transformQueryTitle:"Eine JMESPath-Abfrage eingeben",transformWizardLabel:"Zauberer",transformWizardFilter:"Filter",transformWizardSortBy:"Sortieren nach",transformWizardSelectFields:"Felder ausw\xE4hlen",transformQueryLabel:"Anfrage",transformPreviewLabel:"Vorschau",type:"Geben Sie  ein.",typeTitle:"\xC4ndern Sie den Typ dieses Feldes",openUrl:"Strg+Klicken oder Strg+Eingabe, um die URL in einem neuen Fenster zu \xF6ffnen",undo:"Letzte Aktion r\xFCckg\xE4ngig machen (Strg+Z)",validationCannotMove:"Kann ein Feld nicht in ein Kind seiner selbst verschieben",autoType:'Feldtyp "auto". Der Feldtyp wird automatisch aus dem Wert bestimmt und kann ein String, eine Zahl, boolesch oder null sein.',objectType:'Feldtyp "Objekt". Ein Objekt enth\xE4lt eine ungeordnete Menge von Schl\xFCssel/Wert-Paaren.',arrayType:'Feldtyp "Array". Ein Array enth\xE4lt eine geordnete Sammlung von Werten.',stringType:'Feldtyp "Zeichenfolge". Der Feldtyp wird nicht aus dem Wert bestimmt, sondern immer als Zeichenfolge zur\xFCckgegeben.',modeEditorTitle:"Editor-Modus umschalten",modeCodeText:"Code",modeCodeTitle:"Umschalten auf Code-Highlighter",modeFormText:"Formular",modeFormTitle:"Zum Formular-Editor wechseln",modeTextText:"Text",modeTextTitle:"Zum Editor f\xFCr einfachen Text wechseln",modeTreeText:"Baum",modeTreeTitle:"Zum Baum-Editor wechseln",modeViewText:"Siehe",modeViewTitle:"Zur Baumansicht wechseln",modePreviewText:"Vorschau",modePreviewTitle:"In den Vorschau-Modus wechseln",examples:"Beispiele",default:"Standardm\xE4\xDFig",containsInvalidProperties:"Enth\xE4lt ung\xFCltige Eigenschaften",containsInvalidItems:"Enth\xE4lt ung\xFCltige Elemente"},ru:{array:"\u041C\u0430\u0441\u0441\u0438\u0432",auto:"\u0410\u0432\u0442\u043E",appendText:"\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C",appendTitle:"\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C \u043D\u043E\u0432\u043E\u0435 \u043F\u043E\u043B\u0435 \u0441 \u0442\u0438\u043F\u043E\u043C '\u0430\u0432\u0442\u043E' \u043F\u043E\u0441\u043B\u0435 \u044D\u0442\u043E\u0433\u043E \u043F\u043E\u043B\u044F (Ctrl+Shift+Ins)",appendSubmenuTitle:"\u0412\u044B\u0431\u0440\u0430\u0442\u044C \u0442\u0438\u043F \u043F\u043E\u043B\u044F \u0434\u043B\u044F \u0434\u043E\u0431\u0430\u0432\u043B\u0435\u043D\u0438\u044F",appendTitleAuto:"\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C \u043D\u043E\u0432\u043E\u0435 \u043F\u043E\u043B\u0435 \u0441 \u0442\u0438\u043F\u043E\u043C '\u0430\u0432\u0442\u043E' (Ctrl+Shift+Ins)",ascending:"\u041F\u043E \u0432\u043E\u0437\u0440\u0430\u0441\u0442\u0430\u043D\u0438\u044E",ascendingTitle:"\u0421\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u0430\u0442\u044C ${type} \u043F\u043E \u0432\u043E\u0437\u0440\u0430\u0441\u0442\u0430\u043D\u0438\u044E",actionsMenu:"\u041D\u0430\u0436\u043C\u0438\u0442\u0435 \u0434\u043B\u044F \u043E\u0442\u043A\u0440\u044B\u0442\u0438\u044F \u043C\u0435\u043D\u044E \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439 (Ctrl+M)",cannotParseFieldError:"\u041D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u043D\u043E \u043F\u0440\u0435\u043E\u0431\u0440\u0430\u0437\u043E\u0432\u0430\u0442\u044C \u043F\u043E\u043B\u0435 \u0432 JSON",cannotParseValueError:"\u041D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u043D\u043E \u043F\u0440\u0435\u043E\u0431\u0440\u0430\u0437\u043E\u0432\u0430\u0442\u044C \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \u0432 JSON",collapseAll:"\u0421\u0432\u0435\u0440\u043D\u0443\u0442\u044C \u0432\u0441\u0435",compactTitle:"\u041C\u0438\u043D\u0438\u0444\u0438\u043A\u0430\u0446\u0438\u044F JSON (Ctrl+Shift+I)",descending:"\u041F\u043E \u0443\u0431\u044B\u0432\u0430\u043D\u0438\u044E",descendingTitle:"\u0421\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u0430\u0442\u044C ${type} \u043F\u043E \u0443\u0431\u044B\u0432\u0430\u043D\u0438\u044E",drag:"\u041F\u043E\u0442\u044F\u043D\u0438\u0442\u0435 \u0434\u043B\u044F \u043F\u0435\u0440\u0435\u043C\u0435\u0449\u0435\u043D\u0438\u044F \u044D\u0442\u043E\u0433\u043E \u043F\u043E\u043B\u044F (Alt+Shift+Arrows)",duplicateKey:"\u043F\u043E\u0432\u0442\u043E\u0440\u044F\u044E\u0449\u0438\u0439\u0441\u044F \u043A\u043B\u044E\u0447",duplicateText:"\u0414\u0443\u0431\u043B\u0438\u0440\u043E\u0432\u0430\u0442\u044C",duplicateTitle:"\u0414\u0443\u0431\u043B\u0438\u0440\u043E\u0432\u0430\u043D\u0438\u0435 \u043F\u043E\u043B\u0435\u0439 (Ctrl+D)",duplicateField:"\u0414\u0443\u0431\u043B\u0438\u0440\u043E\u0432\u0430\u0442\u044C \u043F\u043E\u043B\u0435 (Ctrl+D)",duplicateFieldError:"\u0414\u0443\u0431\u043B\u0438\u0440\u043E\u0432\u0430\u043D\u0438\u0435 \u043D\u0430\u0437\u0432\u0430\u043D\u0438\u044F \u043F\u043E\u043B\u044F",empty:"\u043F\u0443\u0441\u0442\u043E\u0439",expandAll:"\u0420\u0430\u0437\u0432\u0435\u0440\u043D\u0443\u0442\u044C \u0432\u0441\u0435",expandTitle:`\u041D\u0430\u0436\u043C\u0438\u0442\u0435 \u0434\u043B\u044F \u0440\u0430\u0441\u043A\u0440\u044B\u0442\u0438\u044F/\u0441\u043A\u0440\u044B\u0442\u0438\u044F \u043F\u043E\u043B\u044F (Ctrl+E)
\u0438\u043B\u0438 Ctrl+Click \u0434\u043B\u044F \u0440\u0430\u0441\u043A\u0440\u044B\u0442\u0438\u044F/\u0441\u043A\u0440\u044B\u0442\u0438\u044F \u0432\u0441\u0435\u0445 \u043F\u043E\u0442\u043E\u043C\u043A\u043E\u0432.`,formatTitle:"\u0424\u043E\u0440\u043C\u0430\u0442\u0438\u0440\u043E\u0432\u0430\u043D\u0438\u0435 JSON (Ctrl+I)",insert:"\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044C",insertTitle:"\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044C \u043D\u043E\u0432\u043E\u0435 \u043F\u043E\u043B\u0435 \u0441 \u0442\u0438\u043F\u043E\u043C '\u0430\u0432\u0442\u043E' \u043F\u0435\u0440\u0435\u0434 \u044D\u0442\u0438\u043C \u043F\u043E\u043B\u0435\u043C (Ctrl+Ins)",insertSub:"\u0412\u044B\u0431\u0440\u0430\u0442\u044C \u0442\u0438\u043F \u043F\u043E\u043B\u044F \u0434\u043B\u044F \u0432\u0441\u0442\u0430\u0432\u043A\u0438",object:"\u041E\u0431\u044A\u0435\u043A\u0442",ok:"\u041E\u041A",redo:"\u041F\u043E\u0432\u0442\u043E\u0440\u0438\u0442\u044C (Ctrl+Shift+Z)",removeText:"\u0423\u0434\u0430\u043B\u0438\u0442\u044C",removeTitle:"\u0423\u0434\u0430\u043B\u0438\u0442\u044C \u0432\u044B\u0431\u0440\u0430\u043D\u043D\u044B\u0435 \u043F\u043E\u043B\u044F (Ctrl+Del)",removeField:"\u0423\u0434\u0430\u043B\u0438\u0442\u044C \u043F\u043E\u043B\u0435 (Ctrl+Del)",repairTitle:"\u0412\u043E\u0441\u0441\u0442\u0430\u043D\u043E\u0432\u0438\u0442\u0435 JSON: \u0438\u0441\u043F\u0440\u0430\u0432\u044C\u0442\u0435 \u043A\u0430\u0432\u044B\u0447\u043A\u0438 \u0438 escape-\u0441\u0438\u043C\u0432\u043E\u043B\u044B, \u0443\u0434\u0430\u043B\u0438\u0442\u0435 \u043A\u043E\u043C\u043C\u0435\u043D\u0442\u0430\u0440\u0438\u0438 \u0438 \u043D\u043E\u0442\u0430\u0446\u0438\u044E JSONP, \u043C\u043E\u0434\u0438\u0444\u0438\u0446\u0438\u0440\u0443\u0439\u0442\u0435 \u043E\u0431\u044A\u0435\u043A\u0442\u044B JavaScript \u0432 JSON.",searchTitle:"\u041F\u043E\u0438\u0441\u043A",searchNextResultTitle:"\u0421\u043B\u0435\u0434\u0443\u044E\u0449\u0438\u0439 \u0440\u0435\u0437\u0443\u043B\u044C\u0442\u0430\u0442 (Enter)",searchPreviousResultTitle:"\u041F\u0440\u0435\u0434\u044B\u0434\u0443\u0449\u0438\u0439 \u0440\u0435\u0437\u0443\u043B\u044C\u0442\u0430\u0442 (Shift + Enter)",selectNode:"\u0412\u044B\u0431\u043E\u0440 \u0443\u0437\u043B\u0430...",showAll:"\u043F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u0432\u0441\u0435",showMore:"\u0431\u043E\u043B\u044C\u0448\u0435",showMoreStatus:"${visibleChilds} \u0438\u0437 ${totalChilds}",sort:"\u0421\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u043A\u0430",sortTitle:"\u0421\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u043A\u0430 \u043F\u043E\u0442\u043E\u043C\u043A\u043E\u0432 \u0442\u0438\u043F\u0430 ${type}",sortTitleShort:"\u0421\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u043A\u0430 \u0441\u043E\u0434\u0435\u0440\u0436\u0438\u043C\u043E\u0433\u043E",sortFieldLabel:"\u041F\u043E\u043B\u0435:",sortDirectionLabel:"\u041D\u0430\u043F\u0440\u0430\u0432\u043B\u0435\u043D\u0438\u0435:",sortFieldTitle:"\u0412\u044B\u0431\u0435\u0440\u0438\u0442\u0435 \u043F\u043E\u043B\u0435 \u0434\u043B\u044F \u0441\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u043A\u0438 \u043C\u0430\u0441\u0441\u0438\u0432\u0430 \u0438\u043B\u0438 \u043E\u0431\u044A\u0435\u043A\u0442\u0430",sortAscending:"\u041F\u043E \u0432\u043E\u0437\u0440\u0430\u0441\u0442\u0430\u043D\u0438\u044E",sortAscendingTitle:"\u0421\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u043A\u0430 \u0432\u044B\u0431\u0440\u0430\u043D\u043D\u043E\u0433\u043E \u043F\u043E\u0440\u044F \u043F\u043E \u0432\u043E\u0437\u0440\u0430\u0441\u0442\u0430\u043D\u0438\u044E",sortDescending:"\u041F\u043E \u0443\u0431\u044B\u0432\u0430\u043D\u0438\u044E",sortDescendingTitle:"\u0421\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u043A\u0430 \u0432\u044B\u0431\u0440\u0430\u043D\u043D\u043E\u0433\u043E \u043F\u043E\u0440\u044F \u043F\u043E \u0443\u0431\u044B\u0432\u0430\u043D\u0438\u044E",string:"\u0421\u0442\u0440\u043E\u043A\u0430",transform:"\u041C\u043E\u0434\u0438\u0444\u0438\u043A\u0430\u0446\u0438\u044F",transformTitle:"\u0424\u0438\u043B\u044C\u0442\u0440\u0430\u0446\u0438\u044F, \u0441\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u043A\u0430 \u0438\u043B\u0438 \u043C\u043E\u0434\u0438\u0444\u0438\u043A\u0430\u0446\u0438\u044F \u0434\u0430\u043D\u043D\u044B\u0445 \u0442\u0438\u043F\u0430 ${type}",transformTitleShort:"\u0424\u0438\u043B\u044C\u0442\u0440\u0430\u0446\u0438\u044F, \u0441\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u043A\u0430 \u0438\u043B\u0438 \u043C\u043E\u0434\u0438\u0444\u0438\u043A\u0430\u0446\u0438\u044F \u0434\u0430\u043D\u043D\u044B\u0445",extract:"\u0418\u0437\u0432\u043B\u0435\u0447\u0435\u043D\u0438\u0435",extractTitle:"\u0418\u0437\u0432\u043B\u0435\u0447\u044C \u0442\u0438\u043F ${type}",transformQueryTitle:"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 JMESpath \u0437\u0430\u043F\u0440\u043E\u0441",transformWizardLabel:"\u041C\u0430\u0441\u0442\u0435\u0440",transformWizardFilter:"\u0424\u0438\u043B\u044C\u0442\u0440",transformWizardSortBy:"\u0421\u043E\u0440\u0442\u0438\u0440\u043E\u0432\u043A\u0430",transformWizardSelectFields:"\u041F\u043E\u043B\u044F",transformQueryLabel:"\u0417\u0430\u043F\u0440\u043E\u0441",transformPreviewLabel:"\u041F\u0440\u043E\u0441\u043C\u043E\u0442\u0440",type:"\u0422\u0438\u043F",typeTitle:"\u0418\u0437\u043C\u0435\u043D\u0438\u0442\u044C \u0442\u0438\u043F \u044D\u0442\u043E\u0433\u043E \u043F\u043E\u043B\u044F",openUrl:"Ctrl+Click \u0438\u043B\u0438 Ctrl+Enter \u0434\u043B\u044F \u043E\u0442\u043A\u0440\u044B\u0442\u0438\u044F url \u0432 \u043D\u043E\u0432\u043E\u043C \u043E\u043A\u043D\u0435",undo:"\u041E\u0442\u043C\u0435\u043D\u0438\u0442\u044C (Ctrl+Z)",validationCannotMove:"\u041F\u043E\u043B\u0435 \u043D\u0435 \u043C\u043E\u0436\u0435\u0442 \u0431\u044B\u0442\u044C \u043F\u0435\u0440\u0435\u043C\u0435\u0449\u0435\u043D\u043E \u0432 \u043F\u043E\u0442\u043E\u043C\u043A\u0430",autoType:"\u0422\u0438\u043F \u043F\u043E\u043B\u044F \u0430\u0432\u0442\u043E\u043C\u0430\u0442\u0438\u0447\u0435\u0441\u043A\u0438 \u043E\u043F\u0440\u0435\u0434\u0435\u043B\u044F\u0435\u0442\u0441\u044F \u043F\u043E \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u044E \u0438 \u043C\u043E\u0436\u0435\u0442 \u0431\u044B\u0442\u044C \u0441\u0442\u0440\u043E\u043A\u043E\u0439, \u0447\u0438\u0441\u043B\u043E\u043C, \u043B\u043E\u0433\u0438\u0447\u0435\u0441\u043A\u0438\u043C \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0435\u043C \u0438\u043B\u0438 null.",objectType:"\u041E\u0431\u044A\u0435\u043A\u0442 \u0441\u043E\u0434\u0435\u0440\u0436\u0438\u0442 \u043D\u0435\u0443\u043F\u043E\u0440\u044F\u0434\u043E\u0447\u0435\u043D\u043D\u044B\u0439 \u043D\u0430\u0431\u043E\u0440 \u043F\u0430\u0440 \u043A\u043B\u044E\u0447/\u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0435.",arrayType:"\u041C\u0430\u0441\u0441\u0438\u0432 \u0441\u043E\u0434\u0435\u0440\u0436\u0438\u0442 \u0443\u043F\u043E\u0440\u044F\u0434\u043E\u0447\u0435\u043D\u043D\u044B\u0439 \u043D\u0430\u0431\u043E\u0440 \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0439.",stringType:"\u0422\u0438\u043F \u043F\u043E\u043B\u044F \u043D\u0435 \u043E\u043F\u0440\u0435\u0434\u0435\u043B\u044F\u0435\u0442\u0441\u044F \u0438\u0437 \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u044F, \u043D\u043E \u0432\u0441\u0435\u0433\u0434\u0430 \u0432\u043E\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u0442\u0441\u044F \u043A\u0430\u043A \u0441\u0442\u0440\u043E\u043A\u0430.",modeEditorTitle:"\u041F\u0435\u0440\u0435\u043A\u043B\u044E\u0447\u0435\u043D\u0438\u0435 \u0440\u0435\u0436\u0438\u043C\u0430 \u0440\u0435\u0434\u0430\u043A\u0442\u043E\u0440\u0430",modeCodeText:"\u041A\u043E\u0434",modeCodeTitle:"\u041F\u0435\u0440\u0435\u043A\u043B\u044E\u0447\u0438\u0442\u044C \u0432 \u0440\u0435\u0436\u0438\u043C \u0440\u0435\u0434\u0430\u043A\u0442\u043E\u0440\u0430 \u043A\u043E\u0434\u0430",modeFormText:"\u0424\u043E\u0440\u043C\u0430",modeFormTitle:"\u041F\u0435\u0440\u0435\u043A\u043B\u044E\u0447\u0438\u0442\u044C \u0432 \u0440\u0435\u0436\u0438\u043C \u0444\u043E\u0440\u043C\u044B",modeTextText:"\u0422\u0435\u043A\u0441\u0442",modeTextTitle:"\u041F\u0435\u0440\u0435\u043A\u043B\u044E\u0447\u0438\u0442\u044C \u0432 \u0440\u0435\u0436\u0438\u043C \u0440\u0435\u0434\u0430\u043A\u0442\u043E\u0440\u0430 \u0442\u0435\u043A\u0441\u0442\u0430",modeTreeText:"\u0414\u0435\u0440\u0435\u0432\u043E",modeTreeTitle:"\u041F\u0435\u0440\u0435\u043A\u043B\u044E\u0447\u0438\u0442\u044C \u0432 \u0440\u0435\u0436\u0438\u043C \u0440\u0435\u0434\u0430\u043A\u0442\u043E\u0440\u0430 \u0434\u0435\u0440\u0435\u0432\u0430",modeViewText:"\u041F\u0440\u043E\u0441\u043C\u043E\u0442\u0440 \u0434\u0435\u0440\u0435\u0432\u0430",modeViewTitle:"\u041F\u0435\u0440\u0435\u043A\u043B\u044E\u0447\u0438\u0442\u044C \u0432 \u0440\u0435\u0436\u0438\u043C \u043F\u0440\u043E\u0441\u043C\u043E\u0442\u0440\u0430 \u0434\u0435\u0440\u0435\u0432\u0430",modePreviewText:"\u041F\u0440\u043E\u0441\u043C\u043E\u0442\u0440",modePreviewTitle:"\u041F\u0435\u0440\u0435\u043A\u043B\u044E\u0447\u0438\u0442\u044C \u0432 \u0440\u0435\u0436\u0438\u043C \u043F\u0440\u043E\u0441\u043C\u043E\u0442\u0440\u0430",examples:"\u041F\u0440\u0438\u043C\u0435\u0440\u044B",default:"\u041F\u043E \u0443\u043C\u043E\u043B\u0447\u0430\u043D\u0438\u044E",containsInvalidProperties:"\u0421\u043E\u0434\u0435\u0440\u0436\u0438\u0442 \u043D\u0435\u0434\u043E\u043F\u0443\u0441\u0442\u0438\u043C\u044B\u0435 \u0441\u0432\u043E\u0439\u0441\u0442\u0432\u0430",containsInvalidItems:"\u0421\u043E\u0434\u0435\u0440\u0436\u0438\u0442 \u043D\u0435\u0434\u043E\u043F\u0443\u0441\u0442\u0438\u043C\u044B\u0435 \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u044B"},ko:{array:"\uBC30\uC5F4",auto:"\uC790\uB3D9",appendText:"\uCD94\uAC00",appendTitle:'\uC120\uD0DD\uD55C \uC694\uC18C \uC544\uB798\uC5D0 "\uC790\uB3D9" \uC694\uC18C\uB97C \uCD94\uAC00\uD569\uB2C8\uB2E4. (Ctrl + Shift + Ins)',appendSubmenuTitle:"\uCD94\uAC00\uD560 \uC694\uC18C\uC758 \uC720\uD615\uC744 \uC120\uD0DD\uD574\uC8FC\uC138\uC694.",appendTitleAuto:'"\uC790\uB3D9" \uC694\uC18C\uB97C \uCD94\uAC00\uD569\uB2C8\uB2E4. (Ctrl + Shift + Ins)',ascending:"\uC624\uB984\uCC28\uC21C",ascendingTitle:"\uC120\uD0DD\uD55C ${type}\uC758 \uD558\uC704 \uC694\uC18C\uB97C \uC624\uB984\uCC28\uC21C \uC815\uB82C\uD569\uB2C8\uB2E4.",actionsMenu:"\uBA54\uB274 \uC5F4\uAE30 (Ctrl + M)",cannotParseFieldError:"JSON\uC758 \uC694\uC18C\uB97C \uD574\uC11D\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",cannotParseValueError:"JSON\uC758 \uAC12\uC744 \uD574\uC11D\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",collapseAll:"\uBAA8\uB450 \uC811\uAE30",compactTitle:"\uBAA8\uB4E0 \uACF5\uBC31\uC744 \uC81C\uAC70\uD558\uC5EC JSON \uB370\uC774\uD130\uB97C \uC791\uAC8C \uB9CC\uB4ED\uB2C8\uB2E4. (Ctrl + Shift + I)",descending:"\uB0B4\uB9BC\uCC28\uC21C",descendingTitle:"\uC120\uD0DD\uD55C ${type}\uC758 \uD558\uC704 \uC694\uC18C\uB97C \uB0B4\uB9BC\uCC28\uC21C\uC73C\uB85C \uC815\uB82C",drag:"\uB4DC\uB798\uADF8\uD558\uC5EC \uC694\uC18C\uB97C \uC774\uB3D9\uD569\uB2C8\uB2E4. (Alt + Shift + Arrows)",duplicateKey:"\uBCF5\uC81C\uD0A4",duplicateText:"\uBCF5\uC81C",duplicateTitle:"\uC120\uD0DD\uD55C \uC694\uC18C\uB97C \uBCF5\uC81C\uD569\uB2C8\uB2E4. (Ctrl + D)",duplicateField:"\uC120\uD0DD\uD55C \uC694\uC18C\uB97C \uBCF5\uC81C\uD569\uB2C8\uB2E4. (Ctrl + D)",duplicateFieldError:"\uC694\uC18C \uC774\uB984\uC774 \uC911\uBCF5\uB418\uC5C8\uC2B5\uB2C8\uB2E4.",empty:"\uBE44\uC5B4\uC788\uC74C",expandAll:"\uBAA8\uB450 \uC5F4\uAE30",expandTitle:`\uD074\uB9AD\uD558\uC5EC \uC694\uC18C\uB97C \uC5F4\uAC70\uB098 \uB2EB\uC2B5\uB2C8\uB2E4. (Ctrl + E) 
Ctrl + Click\uC73C\uB85C \uBAA8\uB4E0 \uD558\uC704 \uC694\uC18C\uB97C \uC5F4\uAC70\uB098 \uB2EB\uC2B5\uB2C8\uB2E4.`,formatTitle:"\uC801\uC808\uD55C \uB4E4\uC5EC\uC4F0\uAE30 \uBC0F \uC904\uBC14\uAFC8\uC73C\uB85C JSON \uB370\uC774\uD130\uB97C \uC815\uD615\uD654\uD569\uB2C8\uB2E4. (Ctrl + I)",insert:"\uC0BD\uC785",insertTitle:"\uC120\uD0DD\uD55C \uC694\uC18C \uC704\uC5D0 \uC0C8\uC694\uC18C\uB97C \uC0BD\uC785\uD569\uB2C8\uB2E4. (Ctrl + Ins)",insertSub:"\uC0BD\uC785\uD560 \uC694\uC18C\uC758 \uC720\uD615\uC744 \uC120\uD0DD\uD574\uC8FC\uC138\uC694.",object:"\uAC1D\uCCB4",ok:"\uD655\uC778",redo:"\uB2E4\uC2DC \uC2E4\uD589 (Ctrl + Shift + Z)",removeText:"\uC0AD\uC81C",removeTitle:"\uC120\uD0DD\uD55C \uC694\uC18C\uB97C \uC0AD\uC81C\uD569\uB2C8\uB2E4. (Ctrl + Del)",removeField:"\uC120\uD0DD\uD55C \uC694\uC18C\uB97C \uC0AD\uC81C\uD569\uB2C8\uB2E4. (Ctrl + Del)",repairTitle:"JSON \uAD50\uC815: JSON \uB0B4\uC758 \uC8FC\uC11D\uACFC JSONP \uD45C\uAE30\uBC95\uC744 \uC9C0\uC6B0\uACE0 \uB530\uC634\uD45C\uC640 \uC774\uC2A4\uCF00\uC774\uD504 \uBB38\uC790\uB97C \uC218\uC815\uD569\uB2C8\uB2E4.",searchTitle:"\uC694\uC18C \uB610\uB294 \uAC12 \uCC3E\uAE30",searchNextResultTitle:"\uB2E4\uC74C\uC73C\uB85C \uCC3E\uAE30 (Enter)",searchPreviousResultTitle:"\uC774\uC804\uC73C\uB85C \uCC3E\uAE30 (Shift + Enter)",selectNode:"\uC694\uC18C\uB97C \uC120\uD0DD\uD574\uC8FC\uC138\uC694...",showAll:"\uBAA8\uB450\uBCF4\uAE30",showMore:"\uB354\uBCF4\uAE30",showMoreStatus:"${totalChilds} \uAC1C\uC758 \uD56D\uBAA9 \uC911 ${visibleChilds} \uAC1C\uB97C \uD45C\uC2DC\uD569\uB2C8\uB2E4.",sort:"\uC815\uB82C",sortTitle:"\uC120\uD0DD\uD55C ${type}\uC758 \uD558\uC704 \uC694\uC18C\uB97C \uC815\uB82C\uD569\uB2C8\uB2E4.",sortTitleShort:"\uC815\uB82C",sortFieldLabel:"\uC694\uC18C:",sortDirectionLabel:"\uC21C\uC11C:",sortFieldTitle:"\uBC30\uC5F4\uC774\uB098 \uAC1D\uCCB4\uB97C \uC815\uB82C\uD558\uB294 \uC694\uC18C\uB97C \uC120\uD0DD\uD574\uC8FC\uC138\uC694.",sortAscending:"\uC624\uB984\uCC28\uC21C",sortAscendingTitle:"\uC120\uD0DD\uD55C \uC694\uC18C\uB97C \uC624\uB984\uCC28\uC21C\uC73C\uB85C \uC815\uB82C\uD569\uB2C8\uB2E4.",sortDescending:"\uB0B4\uB9BC\uCC28\uC21C",sortDescendingTitle:"\uC120\uD0DD\uD55C \uC694\uC18C\uB97C \uB0B4\uB9BC\uCC28\uC21C\uC73C\uB85C \uC815\uB82C\uD569\uB2C8\uB2E4.",string:"\uBB38\uC790",transform:"\uBCC0\uD658",transformTitle:"\uC120\uD0DD\uD55C ${type}\uC758 \uD558\uC704 \uC694\uC18C\uB97C \uD544\uD130\uD558\uAC70\uB098 \uC815\uB82C \uB610\uB294 \uBCC0\uD658\uD569\uB2C8\uB2E4.",transformTitleShort:"\uB0B4\uC6A9\uC744 \uD544\uD130\uD558\uAC70\uB098 \uC815\uB82C \uB610\uB294 \uBCC0\uD658\uD569\uB2C8\uB2E4.",extract:"\uCD94\uCD9C",extractTitle:"\uC120\uD0DD\uD55C ${type}\uC758 \uAC12\uC744 \uCD5C\uC0C1\uC704\uC5D0 \uC704\uCE58\uC2DC\uD0B5\uB2C8\uB2E4.",transformQueryTitle:"JMESPath \uCFFC\uB9AC\uB97C \uC785\uB825\uD574\uC8FC\uC138\uC694.",transformWizardLabel:"\uB9C8\uBC95\uC0AC",transformWizardFilter:"\uD544\uD130",transformWizardSortBy:"\uC815\uB82C",transformWizardSelectFields:"\uC694\uC18C\uB97C \uC120\uD0DD\uD574\uC8FC\uC138\uC694.",transformQueryLabel:"\uCFFC\uB9AC",transformPreviewLabel:"\uBBF8\uB9AC\uBCF4\uAE30",type:"\uC720\uD615",typeTitle:"\uC120\uD0DD\uD55C \uC694\uC18C\uC758 \uC720\uD615\uC744 \uBCC0\uACBD\uD569\uB2C8\uB2E4.",openUrl:"Ctrl + Click \uB610\uB294 Ctrl + Enter\uB85C \uC0C8 \uCC3D\uC5D0\uC11C URL \uC5F4\uAE30",undo:"\uC2E4\uD589 \uCDE8\uC18C (Ctrl + Z)",validationCannotMove:"\uD558\uC704 \uC694\uC18C\uB85C \uC774\uB3D9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",autoType:"\uC790\uB3D9: \uC694\uC18C\uC758 \uD615\uC2DD\uC774 \uAC12\uC758 \uC720\uD615\uC73C\uB85C \uACB0\uC815\uB429\uB2C8\uB2E4. \uBB38\uC790, \uC22B\uC790, \uBD80\uC6B8, \uB610\uB294 null\uB9CC \uD5C8\uC6A9\uB429\uB2C8\uB2E4.",objectType:"\uAC1D\uCCB4: \uC21C\uC11C\uB300\uB85C \uB098\uC5F4\uB418\uC9C0 \uC54A\uC740 \uC774\uB984/\uAC12 \uC30D\uC73C\uB85C \uC774\uB8E8\uC5B4\uC9C4 \uC9D1\uD569\uC785\uB2C8\uB2E4.",arrayType:"\uBC30\uC5F4: \uC21C\uC11C\uB300\uB85C \uB098\uC5F4\uB41C \uAC12\uC758 \uC9D1\uD569\uC785\uB2C8\uB2E4.",stringType:"\uBB38\uC790: \uC694\uC18C\uC758 \uC720\uD615\uC774 \uAC12\uC5D0\uC11C \uACB0\uC815\uB418\uC9C0 \uC54A\uC9C0\uB9CC \uD56D\uC0C1 \uBB38\uC790\uB85C \uBC18\uD658\uB429\uB2C8\uB2E4.",modeEditorTitle:"\uD3B8\uC9D1\uAE30 \uC720\uD615 \uBCC0\uACBD",modeCodeText:"\uCF54\uB4DC",modeCodeTitle:"\uD615\uC2DD \uAD50\uC815\uC744 \uB3C4\uC640\uC8FC\uB294 \uAE30\uB2A5\uC774 \uD3EC\uD568\uB41C \uBB38\uC790 \uD3B8\uC9D1\uAE30",modeFormText:"\uC785\uB825 \uC591\uC2DD",modeFormTitle:"\uC815\uD574\uC9C4 \uC694\uC18C\uC5D0 \uAC12\uC744 \uC785\uB825\uD558\uB294 \uD3B8\uC9D1\uAE30",modeTextText:"\uBB38\uC790",modeTextTitle:"\uB2E8\uC21C \uBB38\uC790 \uD3B8\uC9D1\uAE30",modeTreeText:"\uD2B8\uB9AC",modeTreeTitle:"\uD2B8\uB9AC \uAD6C\uC870\uB85C \uD45C\uC2DC\uB418\uB294 \uD3B8\uC9D1\uAE30",modeViewText:"\uBCF4\uAE30",modeViewTitle:"\uC77D\uAE30\uC804\uC6A9 \uD2B8\uB9AC \uAD6C\uC870\uB85C JSON\uC744 \uD45C\uC2DC",modePreviewText:"\uBBF8\uB9AC\uBCF4\uAE30",modePreviewTitle:"\uC77D\uAE30\uC804\uC6A9 \uBB38\uC790\uB85C JSON\uC744 \uD45C\uC2DC",examples:"\uC608\uC81C",default:"\uAE30\uBCF8\uAC12",containsInvalidProperties:"\uC798\uBABB\uB41C \uC18D\uC131\uC774 \uD3EC\uD568\uB418\uC5B4 \uC788\uC2B5\uB2C8\uB2E4.",containsInvalidItems:"\uC798\uBABB\uB41C \uD56D\uBAA9\uC774 \uD3EC\uD568\uB418\uC5B4 \uC788\uC2B5\uB2C8\uB2E4"}},k=Object.keys(X),G="en",O=typeof navigator<"u"?navigator.language||navigator.userLanguage:void 0,D=k.find(function(C){return C===O})||G;function N(C){var m;C&&((m=k.find(function(A){return A===C}))?D=m:console.error("Language not found"))}function M(C){if(C)for(var m in C)(function(A){k.find(function(x){return x===A})||k.push(A),X[A]=Object.assign({},X[G],X[A],C[A])})(m)}function L(C,m,A){var x=X[A=A||D][C]||X[G][C]||C;if(m)for(var p in m)x=x.replace("${"+p+"}",m[p]);return x}},6056:function(ie,X,V){V.d(X,{J:function(){return D},r:function(){return O}});var X=V(5156),k=V.n(X),G=V(9791);function O(N,A){var L,C=A.sort,m=A.filter,A=A.projection,x="";return m?(L=m.field!=="@"?["0"].concat((0,G.parsePath)("."+m.field)):["0"],L=typeof(0,G.get)(N,L)=="string"?m.value:(0,G.parseString)(m.value),x+="[? "+m.field+" "+m.relation+" `"+JSON.stringify(L)+"`]"):x+=Array.isArray(N)?"[*]":"@",C&&(C.direction==="desc"?x+=" | reverse(sort_by(@, &"+C.field+"))":x+=" | sort_by(@, &"+C.field+")"),A&&(x[x.length-1]!=="]"&&(x+=" | [*]"),A.fields.length===1?x+="."+A.fields[0]:1<A.fields.length&&(x+=".{"+A.fields.map(function(p){var a=p.split(".");return a[a.length-1]+": "+p}).join(", ")+"}")),x}function D(N,M){return k().search(N,M)}},4987:function(){function ie(g){g===void 0||"remove"in g||Object.defineProperty(g,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){this.parentNode!==void 0&&this.parentNode.removeChild(this)}})}typeof Element<"u"&&(window.Element!==void 0&&ie(window.Element.prototype),window.CharacterData!==void 0&&ie(window.CharacterData.prototype),window.DocumentType!==void 0&&ie(window.DocumentType.prototype)),Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(g){for(var V=0;V<this.length;V++){var X=this[V];if(g.call(this,X,V,this))return V}return-1},configurable:!0,writable:!0}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(g){return g=this.findIndex(g),this[g]},configurable:!0,writable:!0}),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},341:function(ie,a,p){p.r(a),p.d(a,{previewModeMixins:function(){return l}});var a=p(3860),X=p.n(a),k=p(4188),G=p(6436),O=p(2474);function D(n,i){for(var t=0;t<i.length;t++){var e=i[t];e.enumerable=e.enumerable||!1,e.configurable=!0,"value"in e&&(e.writable=!0),Object.defineProperty(n,e.key,e)}}var N=function(){function n(e,r,s){if(!(this instanceof n))throw new TypeError("Cannot call a class as a function");this.onChange=e,this.calculateItemSize=r||function(){return 1},this.limit=s,this.items=[],this.index=-1}var i,t;return i=n,(t=[{key:"add",value:function(e){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1),this.items.push(e),this.index++,this.onChange()}},{key:"_calculateHistorySize",value:function(){var e=this.calculateItemSize,r=0;return this.items.forEach(function(s){r+=e(s)}),r}},{key:"undo",value:function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]}},{key:"redo",value:function(){if(this.canRedo())return this.index++,this.onChange(),this.items[this.index]}},{key:"canUndo",value:function(){return 0<this.index}},{key:"canRedo",value:function(){return this.index<this.items.length-1}},{key:"clear",value:function(){this.items=[],this.index=-1,this.onChange()}}])&&D(i.prototype,t),Object.defineProperty(i,"prototype",{writable:!1}),n}(),M=p(7907),L=p(6056),C=p(6617),m=p(6210),A=p(2558),a=p(8458),x=p(9791),p=a.textModeMixins[0].mixin,a={create:function(e){var i=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{},t=(i.statusBar===void 0&&(i.statusBar=!0),i.mainMenuBar=i.mainMenuBar!==!1,i.enableSort=i.enableSort!==!1,i.enableTransform=i.enableTransform!==!1,i.createQuery=i.createQuery||L.r,i.executeQuery=i.executeQuery||L.J,typeof(this.options=i).indentation=="number"?this.indentation=Number(i.indentation):this.indentation=2,(0,M.cC)(this.options.languages),(0,M.m0)(this.options.language),this.mode="preview",this),e=(this.container=e,this.dom={},this.json=void 0,this.text="",this._debouncedValidate=(0,x.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-preview",this.frame.onclick=function(r){r.preventDefault()},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null});this.frameFocusTracker=new O.R(e),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.dom.busy=document.createElement("div"),this.dom.busy.className="jsoneditor-busy",this.dom.busyContent=document.createElement("span"),this.dom.busyContent.textContent="busy...",this.dom.busy.appendChild(this.dom.busyContent),this.content.appendChild(this.dom.busy),this.dom.previewContent=document.createElement("pre"),this.dom.previewContent.className="jsoneditor-preview",this.dom.previewText=document.createTextNode(""),this.dom.previewContent.appendChild(this.dom.previewText),this.content.appendChild(this.dom.previewContent),this.options.mainMenuBar&&((0,x.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(e=document.createElement("button")).type="button",e.className="jsoneditor-format",e.title=(0,M.Iu)("formatTitle"),this.menu.appendChild(e),e.onclick=function(){t.executeWithBusyMessage(function(){try{t.format()}catch(r){t._onError(r)}},"formatting...")},(e=document.createElement("button")).type="button",e.className="jsoneditor-compact",e.title=(0,M.Iu)("compactTitle"),this.menu.appendChild(e),e.onclick=function(){t.executeWithBusyMessage(function(){try{t.compact()}catch(r){t._onError(r)}},"compacting...")},this.options.enableSort&&((e=document.createElement("button")).type="button",e.className="jsoneditor-sort",e.title=(0,M.Iu)("sortTitleShort"),e.onclick=function(){t._showSortModal()},this.menu.appendChild(e)),this.options.enableTransform&&((e=document.createElement("button")).type="button",e.title=(0,M.Iu)("transformTitleShort"),e.className="jsoneditor-transform",e.onclick=function(){t._showTransformModal()},this.dom.transform=e,this.menu.appendChild(e)),(e=document.createElement("button")).type="button",e.className="jsoneditor-repair",e.title=(0,M.Iu)("repairTitle"),this.menu.appendChild(e),!(e.onclick=function(){t.json===void 0&&t.executeWithBusyMessage(function(){try{t.repair()}catch(r){t._onError(r)}},"repairing...")})!==this.options.history&&(this.history=new N(function(){t.dom.undo.disabled=!t.history.canUndo(),t.dom.redo.disabled=!t.history.canRedo()},function(r){return 2*r.text.length},k.oW),(e=document.createElement("button")).type="button",e.className="jsoneditor-undo jsoneditor-separator",e.title=(0,M.Iu)("undo"),e.onclick=function(){var r=t.history.undo();r&&t._applyHistory(r)},this.menu.appendChild(e),this.dom.undo=e,(e=document.createElement("button")).type="button",e.className="jsoneditor-redo",e.title=(0,M.Iu)("redo"),e.onclick=function(){var r=t.history.redo();r&&t._applyHistory(r)},this.menu.appendChild(e),this.dom.redo=e,this.history.onChange()),this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new C.x(this.menu,this.options.modes,this.options.mode,function(r){try{t.setMode(r),t.modeSwitcher.focus()}catch(s){t._onError(s)}}))),this.errorTable=new G.Q({errorTableVisible:!0,onToggleVisibility:function(){t.validate()},onFocusLine:null,onChangeHeight:function(r){r=r+(t.dom.statusBar?t.dom.statusBar.clientHeight:0)+1,t.content.style.marginBottom=-r+"px",t.content.style.paddingBottom=r+"px"}}),this.frame.appendChild(this.content),this.frame.appendChild(this.errorTable.getErrorTable()),this.container.appendChild(this.frame),i.statusBar&&((0,x.addClassName)(this.content,"has-status-bar"),e=document.createElement("div"),(this.dom.statusBar=e).className="jsoneditor-statusbar",this.frame.appendChild(e),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",e.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText="",e.appendChild(this.dom.arrayInfo),e.appendChild(this.errorTable.getErrorCounter()),e.appendChild(this.errorTable.getWarningIcon()),e.appendChild(this.errorTable.getErrorIcon())),this._renderPreview(),this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var n=this.getText();this.dom.previewText.nodeValue=(0,x.limitCharacters)(n,k.WF),this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+(0,x.formatSize)(n.length)),this.dom.arrayInfo&&(Array.isArray(this.json)?this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(n){console.error("Error in onChange callback: ",n)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(n){console.error("Error in onChangeJSON callback: ",n)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(n){console.error("Error in onChangeText callback: ",n)}}},l=(a._showSortModal=function(){var n=this;this.executeWithBusyMessage(function(){var i=n.options.modalAnchor||k.qD,t=n.get();n._renderPreview(),(0,m.showSortModal)(i,t,function(e){n.executeWithBusyMessage(function(){var r,s,o;r=t,s=e,Array.isArray(r)&&(o=(0,x.sort)(r,s.path,s.direction),n.sortedBy=s,n._setAndFireOnChange(o)),(0,x.isObject)(r)&&(o=(0,x.sortObjectKeys)(r,s.direction),n.sortedBy=s,n._setAndFireOnChange(o))},"sorting...")},n.sortedBy)},"parsing...")},a._showTransformModal=function(){var n=this;this.executeWithBusyMessage(function(){var r=n.options,i=r.createQuery,t=r.executeQuery,e=r.modalAnchor,r=r.queryDescription,s=n.get();n._renderPreview(),(0,A.showTransformModal)({container:e||k.qD,json:s,queryDescription:r,createQuery:i,executeQuery:t,onTransform:function(o){n.executeWithBusyMessage(function(){var c=t(s,o);n._setAndFireOnChange(c)},"transforming...")}})},"parsing...")},a.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this._debouncedValidate=null,this.history&&(this.history.clear(),this.history=null),this.frameFocusTracker.destroy()},a.compact=function(){var n=this.get(),i=JSON.stringify(n);this._setTextAndFireOnChange(i,n)},a.format=function(){var n=this.get(),i=JSON.stringify(n,null,this.indentation);this._setTextAndFireOnChange(i,n)},a.repair=function(){var n=this.getText();try{var i=X()(n);this._setTextAndFireOnChange(i)}catch{}},a.focus=function(){this.dom.transform.focus()},a.set=function(n){this.history&&this.history.clear(),this._set(n)},a.update=function(n){this._set(n)},a._set=function(n){this.text=void 0,this.json=n,this._renderPreview(),this._pushHistory(),this._debouncedValidate()},a._setAndFireOnChange=function(n){this._set(n),this._onChange()},a.get=function(){var n;return this.json===void 0&&(n=this.getText(),this.json=(0,x.parse)(n)),this.json},a.getText=function(){return this.text===void 0&&(this.text=JSON.stringify(this.json,null,this.indentation),this.options.escapeUnicode===!0&&(this.text=(0,x.escapeUnicodeChars)(this.text))),this.text},a.setText=function(n){this.history&&this.history.clear(),this._setText(n)},a.updateText=function(n){this.getText()!==n&&this._setText(n)},a._setText=function(n,i){var t;this.options.escapeUnicode===!0?this.text=(0,x.escapeUnicodeChars)(n):this.text=n,this.json=i,this._renderPreview(),this.json===void 0?(t=this).executeWithBusyMessage(function(){try{t.json=t.get(),t._renderPreview(),t._pushHistory()}catch{}},"parsing..."):this._pushHistory(),this._debouncedValidate()},a._setTextAndFireOnChange=function(n,i){this._setText(n,i),this._onChange()},a._applyHistory=function(n){this.json=n.json,this.text=n.text,this._renderPreview(),this._debouncedValidate()},a._pushHistory=function(){var n;this.history&&(n={text:this.text,json:this.json},this.history.add(n))},a.executeWithBusyMessage=function(n,i){var t;this.getText().length>k.EX?((0,x.addClassName)((t=this).frame,"busy"),t.dom.busyContent.innerText=i,setTimeout(function(){n(),(0,x.removeClassName)(t.frame,"busy"),t.dom.busyContent.innerText=""},100)):n()},a.validate=p.validate,a._renderErrors=p._renderErrors,[{mode:"preview",mixin:a,data:"json"}])},6210:function(ie,X,V){V.r(X),V.d(X,{showSortModal:function(){return D}});var X=V(483),k=V.n(X),G=V(7907),O=V(9791);function D(N,p,L,C){var m=Array.isArray(p)?(0,O.getChildPaths)(p):[""],A=C&&C.path&&(0,O.contains)(m,C.path)?C.path:m[0],x=C&&C.direction||"asc",p='<div class="pico-modal-contents"><div class="pico-modal-header">'+(0,G.Iu)("sort")+"</div><form><table><tbody><tr>  <td>"+(0,G.Iu)("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+(0,G.Iu)("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+(0,G.Iu)("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+(0,G.Iu)("sortAscending")+'" title="'+(0,G.Iu)("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+(0,G.Iu)("sortDescending")+'" title="'+(0,G.Iu)("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,G.Iu)("ok")+'" /></td></tr></tbody></table></form></div>';k()({parent:N,content:p,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(a){var l=a.modalElem().querySelector("form"),n=a.modalElem().querySelector("#ok"),i=a.modalElem().querySelector("#field"),t=a.modalElem().querySelector("#direction");function e(r){t.value=r,t.className="jsoneditor-button-group jsoneditor-button-group-value-"+t.value}m.forEach(function(r){var s,o=document.createElement("option");o.text=(s=r)===""?"@":s[0]==="."?s.slice(1):s,o.value=r,i.appendChild(o)}),i.value=A||m[0],e(x||"asc"),t.onclick=function(r){e(r.target.getAttribute("data-value"))},n.onclick=function(r){r.preventDefault(),r.stopPropagation(),a.close(),L({path:i.value,direction:t.value})},l&&(l.onsubmit=n.onclick)}).afterClose(function(a){a.destroy()}).show()}},2558:function(ie,k,V){V.r(k),V.d(k,{showTransformModal:function(){return A}});var k=V(483),X=V.n(k),k=V(3879),G=V.n(k),O=V(7907);function D(x){return(D=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(p){return typeof p}:function(p){return p&&typeof Symbol=="function"&&p.constructor===Symbol&&p!==Symbol.prototype?"symbol":typeof p})(x)}function N(x,p,a,l){if(typeof x=="boolean"||x instanceof Boolean||x===null||typeof x=="number"||x instanceof Number||typeof x=="string"||x instanceof String||x instanceof Date)return JSON.stringify(x);if(Array.isArray(x)){for(var n=x,i=p,t=a,e=l,r=i?t+i:void 0,s=i?`[
`:"[",o=0;o<n.length;o++){var c=n[o];if(i&&(s+=r),s+=c!==void 0&&typeof c!="function"?N(c,i,r,e):"null",o<n.length-1&&(s+=i?`,
`:","),s.length>e)return s+"..."}return s+=i?`
`+t+"]":"]"}if(x&&D(x)==="object"){var d,b=x,I=p,t=a,h=l,u=I?t+I:void 0,y=!0,w=I?`{
`:"{";if(typeof b.toJSON=="function")return N(b.toJSON(),I,t,h);for(d in b)if(function(B,E){return Object.prototype.hasOwnProperty.call(B,E)}(b,d)){var v=b[d];if(y?y=!1:w+=I?`,
`:",",(w=(w+=I?u+'"'+d+'": ':'"'+d+'":')+N(v,I,u,h)).length>h)return w+"..."}return w+=I?`
`+t+"}":"}"}}function M(x,p){for(var a="";0<p--;)a+=x;return a}var L=V(9791),C=V(4188),m='Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.';function A(r){var p=r.container,a=r.json,l=r.queryDescription,l=l===void 0?m:l,n=r.createQuery,i=r.executeQuery,t=r.onTransform,e=a,r='<label class="pico-modal-contents"><div class="pico-modal-header">'+(0,O.Iu)("transform")+"</div><p>"+l+'</p><div class="jsoneditor-jmespath-label">'+(0,O.Iu)("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+(0,O.Iu)("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input type="text" class="value" placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+(0,O.Iu)("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+(0,O.Iu)("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+(0,O.Iu)("transformQueryLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+(0,O.Iu)("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+(0,O.Iu)("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,O.Iu)("ok")+'" autofocus /></div></div>';X()({parent:p,content:r,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(s){var o=s.modalElem(),T=o.querySelector("#wizard"),c=o.querySelector("#ok"),d=o.querySelector("#filterField"),b=o.querySelector("#filterRelation"),I=o.querySelector("#filterValue"),h=o.querySelector("#sortField"),u=o.querySelector("#sortOrder"),y=o.querySelector("#selectFields"),w=o.querySelector("#query"),v=o.querySelector("#preview");Array.isArray(e)||(T.style.fontStyle="italic",T.textContent="(wizard not available for objects, only for arrays)"),(0,L.getChildPaths)(a).forEach(function(Z){var Z=H(Z),W=document.createElement("option"),W=(W.text=Z,W.value=Z,d.appendChild(W),document.createElement("option"));W.text=Z,W.value=Z,h.appendChild(W)});var T=(0,L.getChildPaths)(a,!0).filter(function(R){return R!==""}),T=(0<T.length?T.forEach(function(Z){var Z=H(Z),W=document.createElement("option");W.text=Z,W.value=Z,y.appendChild(W)}):(T=o.querySelector("#selectFieldsPart"))&&(T.style.display="none"),new(G())(d,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."})),B=new(G())(b,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),E=new(G())(h,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),_=new(G())(u,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),P=new(G())(y,{multiple:!0,clearable:!0,defaultSelected:!1,placeholder:"select fields..."});function H(R){return R===""?"@":R[0]==="."?R.slice(1):R}T.on("selectr.change",Y),B.on("selectr.change",Y),I.oninput=Y,E.on("selectr.change",Y),_.on("selectr.change",Y),P.on("selectr.change",Y),o.querySelector(".pico-modal-contents").onclick=function(R){R.target.nodeName!=="A"&&R.preventDefault()};var z=(0,L.debounce)(function(){try{var R=i(e,w.value);v.className="jsoneditor-transform-preview",v.value=(Z=R,W=2,f=C.WF,typeof W=="number"?10<W?S=M(" ",10):1<=W&&(S=M(" ",W)):typeof W=="string"&&W!==""&&(S=W),(W=N(Z,S,"",f)).length>f?(Z=W,(typeof(S=f)=="number"?Z.slice(0,S):Z)+"..."):W),c.disabled=!1}catch($){v.className="jsoneditor-transform-preview jsoneditor-error",v.value=$.toString(),c.disabled=!0}var Z,W,f,S},300);function K(R,Z){try{w.value=n(R,Z),c.disabled=!1,z()}catch(W){R='Error: an error happened when executing "createQuery": '+(W.message||W.toString()),w.value="",c.disabled=!0,v.className="jsoneditor-transform-preview jsoneditor-error",v.value=R}}function Y(){var R={};if(d.value&&b.value&&I.value&&(R.filter={field:d.value,relation:b.value,value:I.value}),h.value&&u.value&&(R.sort={field:h.value,direction:u.value}),y.value){for(var Z,W=[],f=0;f<y.options.length;f++)y.options[f].selected&&(Z=y.options[f].value,W.push(Z));R.projection={fields:W}}K(a,R)}w.oninput=z,c.onclick=function(R){R.preventDefault(),R.stopPropagation(),s.close(),t(w.value)},K(a,{}),setTimeout(function(){w.select(),w.focus(),w.selectionStart=3,w.selectionEnd=3})}).afterClose(function(s){s.destroy()}).show()}},8458:function(ie,i,V){V.r(i),V.d(i,{textModeMixins:function(){return r}});var i=V(3860),X=V.n(i),i=V(8170),k=V.n(i),G=V(4188),O=V(6436),D=V(2474),N=V(7907),M=V(6056),L=V(6617),C=V(6210),m=V(2558),A=V(9125),x=V(7026),p=V(9791);function a(s,o){for(var c=0;c<o.length;c++){var d=o[c];d.enumerable=d.enumerable||!1,d.configurable=!0,"value"in d&&(d.writable=!0),Object.defineProperty(s,d.key,d)}}var l=function(){function s(d,b){if(!(this instanceof s))throw new TypeError("Cannot call a class as a function");this.schema=d,this.schemaRefs=b||{},this.suggestions={},this.suggestionsRefs={},this._buildSuggestions()}var o,c;return o=s,(c=[{key:"_buildSuggestions",value:function(){for(var d in this._handleSchemaEntry("",this.schema,this.suggestions),this.schemaRefs)this.suggestionsRefs[d]={},this._handleSchemaEntry("",this.schemaRefs[d],this.suggestionsRefs[d])}},{key:"_handleRef",value:function(d,b,I){I[d]=I[d]||{},I[d].refs=I[d].refs||[],I[d].refs=(0,p.uniqueMergeArrays)(I[d].refs,[b])}},{key:"_handleSchemaEntry",value:function(d,b,I){if(b)if(b.$ref)this._handleRef(d,b.$ref,I);else{var h=this._checkOfConditon(b);if(h)this._handleOfCondition(d,b[h],I);else switch(b.type){case"object":this._handleObject(d,b,I);break;case"string":case"number":case"integer":this._handlePrimitive(d,b,I);break;case"boolean":this._handleBoolean(d,b,I);break;case"array":this._handleArray(d,b,I)}}else console.error("SchemaTextCompleter: schema node is missing for path",d)}},{key:"_handleObject",value:function(d,b,I){var h,u=this;(0,p.isObject)(b.properties)&&(h=Object.keys(b.properties),I[d]=I[d]||{},I[d].props=I[d].props||[],I[d].props=(0,p.uniqueMergeArrays)(I[d].props,h),h.forEach(function(y){(0,p.asyncExec)(function(){u._handleSchemaEntry("".concat(d,"/").concat(y),b.properties[y],I)})}))}},{key:"_handlePrimitive",value:function(d,b,I){I[d]=I[d]||{},(0,p.isArray)(b.examples)&&(I[d].examples=I[d].examples||[],I[d].examples=(0,p.uniqueMergeArrays)(I[d].examples,b.examples)),(0,p.isArray)(b.enum)&&(I[d].enum=I[d].enum||[],I[d].enum=(0,p.uniqueMergeArrays)(I[d].enum,b.enum))}},{key:"_handleBoolean",value:function(d,b,I){I[d]||(I[d]={bool:[!0,!1]})}},{key:"_handleArray",value:function(d,b,I){var h=this;b.items&&(0,p.asyncExec)(function(){h._handleSchemaEntry("".concat(d,"/\\d+"),b.items,I)})}},{key:"_handleOfCondition",value:function(d,b,I){var h=this;b&&b.length&&b.forEach(function(u){(0,p.asyncExec)(function(){h._handleSchemaEntry(d,u,I)})})}},{key:"_checkOfConditon",value:function(d){if(d)return d.oneOf?"oneOf":d.anyOf?"anyOf":d.allOf?"allOf":void 0}},{key:"getCompletions",value:function(d,b,I,h,u){var y=this;try{var w=x.parse(b.getValue()).pointers||{},v=function(T){function B(P){var H,z={props:"property",enum:"enum",bool:"boolean",examples:"examples"};T&&(H=T[P])!=null&&H.length&&(E=E.concat(T[P].map(function(K){return{caption:K+"",meta:"schema [".concat(z[P],"]"),score:_++,value:K+""}})))}var E=[],_=0;B("props"),B("enum"),B("bool"),B("examples"),E.length&&u(null,E)};Object.keys(w).forEach(function(T){(0,p.asyncExec)(function(){function B(P,H,z){var K,Y=Object.keys(H).reduce(function(f,S){return new RegExp("^".concat(z).concat(S)).test(P)&&(!f||f.length<S.length)?S:f});if(typeof Y=="string"){if((K=H[Y])!=null&&(K=K.refs)!=null&&K.length){var R,Z={};for(R in H[Y].refs){var W=H[Y].refs[R];y.suggestionsRefs[W]&&((W=B(P,y.suggestionsRefs[W],"".concat(z).concat(Y)))!=null&&W.enum&&(Z.enum=(0,p.uniqueMergeArrays)(Z.enum,W.enum)),W!=null&&W.examples&&(Z.examples=(0,p.uniqueMergeArrays)(Z.examples,W.examples)),W!=null&&W.bool&&(Z.bool=(0,p.uniqueMergeArrays)(Z.bool,W.bool)),W!=null&&W.props&&(Z.props=(0,p.uniqueMergeArrays)(Z.props,W.props)))}return Z}if(new RegExp("^".concat(z).concat(Y,"$")).test(P))return console.log("SchemaTextCompleter: Text suggestion match",{path:P,schemaPath:"".concat(z).concat(Y),suggestions:H[Y]}),H[Y]}}var E,_;((_=w[T].key)==null?void 0:_.line)===I.row&&I.column>=w[T].key.column&&I.column<=w[T].keyEnd.column&&(E=T.slice(0,T.lastIndexOf("/"))),(E=((_=w[T].value)==null?void 0:_.line)===I.row&&((_=w[T].value)==null?void 0:_.line)===((_=w[T].valueEnd)==null?void 0:_.line)&&I.column>=w[T].value.column&&I.column<=w[T].valueEnd.column?T:E)&&(_=B(E,y.suggestions,""),v(_))})})}catch{}}}])&&a(o.prototype,c),Object.defineProperty(o,"prototype",{writable:!1}),s}();function n(s){return(n=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(o){return typeof o}:function(o){return o&&typeof Symbol=="function"&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o})(s)}var i={},t="ace/theme/jsoneditor";function e(){try{this.format()}catch{}}i.create=function(y){var o,c,d,b=this,I=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{},h=(I.statusBar===void 0&&(I.statusBar=!0),I.mainMenuBar=I.mainMenuBar!==!1,I.enableSort=I.enableSort!==!1,I.enableTransform=I.enableTransform!==!1,I.createQuery=I.createQuery||M.r,I.executeQuery=I.executeQuery||M.J,typeof(this.options=I).indentation=="number"?this.indentation=Number(I.indentation):this.indentation=2,(0,N.cC)(this.options.languages),(0,N.m0)(this.options.language),I.ace||k()),u=(this.mode=I.mode==="code"?"code":"text",this.mode==="code"&&h===void 0&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=I.theme||t,this.theme===t&&h&&(0,A.O)(),I.onTextSelectionChange&&this.onTextSelectionChange(I.onTextSelectionChange),this),y=(this.container=y,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.annotations=[],this.lastSchemaErrors=void 0,this._debouncedValidate=(0,p.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),this.width=y.clientWidth,this.height=y.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(w){w.preventDefault()},this.frame.onkeydown=function(w){u._onKeyDown(w)},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null}),y=(this.frameFocusTracker=new D.R(y),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.options.mainMenuBar&&((0,p.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(y=document.createElement("button")).type="button",y.className="jsoneditor-format",y.title=(0,N.Iu)("formatTitle"),this.menu.appendChild(y),y.onclick=function(){try{u.format(),u._onChange()}catch(w){u._onError(w)}},(y=document.createElement("button")).type="button",y.className="jsoneditor-compact",y.title=(0,N.Iu)("compactTitle"),this.menu.appendChild(y),y.onclick=function(){try{u.compact(),u._onChange()}catch(w){u._onError(w)}},this.options.enableSort&&((y=document.createElement("button")).type="button",y.className="jsoneditor-sort",y.title=(0,N.Iu)("sortTitleShort"),y.onclick=function(){u._showSortModal()},this.menu.appendChild(y)),this.options.enableTransform&&((y=document.createElement("button")).type="button",y.title=(0,N.Iu)("transformTitleShort"),y.className="jsoneditor-transform",y.onclick=function(){u._showTransformModal()},this.menu.appendChild(y)),(y=document.createElement("button")).type="button",y.className="jsoneditor-repair",y.title=(0,N.Iu)("repairTitle"),this.menu.appendChild(y),y.onclick=function(){try{u.repair(),u._onChange()}catch(w){u._onError(w)}},this.mode==="code"&&((y=document.createElement("button")).type="button",y.className="jsoneditor-undo jsoneditor-separator",y.title=(0,N.Iu)("undo"),y.onclick=function(){b.aceEditor.getSession().getUndoManager().undo()},this.menu.appendChild(y),this.dom.undo=y,(y=document.createElement("button")).type="button",y.className="jsoneditor-redo",y.title=(0,N.Iu)("redo"),y.onclick=function(){b.aceEditor.getSession().getUndoManager().redo()},this.menu.appendChild(y),this.dom.redo=y),this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new L.x(this.menu,this.options.modes,this.options.mode,function(w){try{u.setMode(w),u.modeSwitcher.focus()}catch(v){u._onError(v)}})),this.mode==="code"&&((o=document.createElement("a")).appendChild(document.createTextNode("powered by ace")),o.href="https://ace.c9.io/",o.target="_blank",o.className="jsoneditor-poweredBy",o.onclick=function(){window.open(o.href,o.target,"noreferrer")},this.menu.appendChild(o))),this.options.onEditable&&n(this.options.onEditable==="function")&&!this.options.onEditable({}));this.frame.appendChild(this.content),this.container.appendChild(this.frame),this.mode==="code"?(this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom),d=(h=h.edit(this.editorDom)).getSession(),h.$blockScrolling=1/0,h.setTheme(this.theme),h.setOptions({readOnly:y}),h.setShowPrintMargin(!1),h.setFontSize("14px"),d.setMode("ace/mode/json"),d.setTabSize(this.indentation),d.setUseSoftTabs(!0),d.setUseWrapMode(!0),c=d.setAnnotations,d.setAnnotations=function(w){c.call(this,w&&w.length?w:u.annotations)},h.commands.bindKey("Ctrl-L",null),h.commands.bindKey("Command-L",null),h.commands.bindKey("Ctrl-\\",null),h.commands.bindKey("Command-\\",null),h.commands.bindKey("Ctrl-Shift-\\",null),h.commands.bindKey("Command-Shift-\\",null),(this.aceEditor=h).on("change",this._onChange.bind(this)),h.on("changeSelection",this._onSelect.bind(this))):((d=document.createElement("textarea")).className="jsoneditor-text",d.spellcheck=!1,this.content.appendChild(d),this.textarea=d,this.textarea.readOnly=y,this.textarea.oninput===null?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),d.onselect=this._onSelect.bind(this),d.onmousedown=this._onMouseDown.bind(this),d.onblur=this._onBlur.bind(this)),this._updateHistoryButtons(),this.errorTable=new O.Q({errorTableVisible:this.mode==="text",onToggleVisibility:function(){u._validateAndCatch()},onFocusLine:function(w){u.isFocused=!0,isNaN(w)||u.setTextSelection({row:w,column:1},{row:w,column:1e3})},onChangeHeight:function(w){w=w+(u.dom.statusBar?u.dom.statusBar.clientHeight:0)+1,u.content.style.marginBottom=-w+"px",u.content.style.paddingBottom=w+"px"}}),this.frame.appendChild(this.errorTable.getErrorTable()),I.statusBar&&((0,p.addClassName)(this.content,"has-status-bar"),this.curserInfoElements={},h=document.createElement("div"),(this.dom.statusBar=h).className="jsoneditor-statusbar",this.frame.appendChild(h),(y=document.createElement("span")).className="jsoneditor-curserinfo-label",y.innerText="Ln:",(d=document.createElement("span")).className="jsoneditor-curserinfo-val",d.innerText="1",h.appendChild(y),h.appendChild(d),(I=document.createElement("span")).className="jsoneditor-curserinfo-label",I.innerText="Col:",(y=document.createElement("span")).className="jsoneditor-curserinfo-val",y.innerText="1",h.appendChild(I),h.appendChild(y),this.curserInfoElements.colVal=y,this.curserInfoElements.lnVal=d,(I=document.createElement("span")).className="jsoneditor-curserinfo-label",I.innerText="characters selected",I.style.display="none",(y=document.createElement("span")).className="jsoneditor-curserinfo-count",y.innerText="0",y.style.display="none",this.curserInfoElements.countLabel=I,this.curserInfoElements.countVal=y,h.appendChild(y),h.appendChild(I),h.appendChild(this.errorTable.getErrorCounter()),h.appendChild(this.errorTable.getWarningIcon()),h.appendChild(this.errorTable.getErrorIcon())),this.setSchema(this.options.schema,this.options.schemaRefs)},i._onSchemaChange=function(s,o){this.aceEditor&&(this.options.allowSchemaSuggestions&&s?(this.aceEditor.setOption("enableBasicAutocompletion",[new l(s,o)]),this.aceEditor.setOption("enableLiveAutocompletion",!0)):(this.aceEditor.setOption("enableBasicAutocompletion",void 0),this.aceEditor.setOption("enableLiveAutocompletion",!1)))},i._onChange=function(){var s=this;if(!this.onChangeDisabled){if(setTimeout(function(){s._updateHistoryButtons&&s._updateHistoryButtons()}),this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(o){console.error("Error in onChange callback: ",o)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(o){console.error("Error in onChangeText callback: ",o)}}},i._updateHistoryButtons=function(){var s;this.aceEditor&&this.dom.undo&&this.dom.redo&&(s=this.aceEditor.getSession().getUndoManager())&&s.hasUndo&&s.hasRedo&&(this.dom.undo.disabled=!s.hasUndo(),this.dom.redo.disabled=!s.hasRedo())},i._showSortModal=function(){try{var s=this,o=this.options.modalAnchor||G.qD,c=this.get();(0,C.showSortModal)(o,c,function(d){var b;Array.isArray(c)&&(b=(0,p.sort)(c,d.path,d.direction),s.sortedBy=d,s.update(b)),(0,p.isObject)(c)&&(b=(0,p.sortObjectKeys)(c,d.direction),s.sortedBy=d,s.update(b))},s.sortedBy)}catch(d){this._onError(d)}},i._showTransformModal=function(){var s=this;try{var o=this.options,c=o.modalAnchor,d=o.createQuery,b=o.executeQuery,I=o.queryDescription,h=this.get();(0,m.showTransformModal)({container:c||G.qD,json:h,queryDescription:I,createQuery:d,executeQuery:b,onTransform:function(u){u=b(h,u),s.update(u)}})}catch(u){this._onError(u)}},i._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},i._onKeyDown=function(s){var o=!1;(s.which||s.keyCode)===73&&s.ctrlKey&&(s.shiftKey?this.compact():this.format(),this._onChange(),o=!0),o&&(s.preventDefault(),s.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},i._onMouseDown=function(){this._updateCursorInfo(),this._emitSelectionChange()},i._onBlur=function(){var s=this;setTimeout(function(){s.isFocused||(s._updateCursorInfo(),s._emitSelectionChange()),s.isFocused=!1})},i._updateCursorInfo=function(){var s,o,c,d,b,I=this;function h(){I.curserInfoElements.countVal.innerText!==b&&(I.curserInfoElements.countVal.innerText=b,I.curserInfoElements.countVal.style.display=b?"inline":"none",I.curserInfoElements.countLabel.style.display=b?"inline":"none"),I.curserInfoElements.lnVal.innerText=c,I.curserInfoElements.colVal.innerText=d}this.textarea?setTimeout(function(){var u=(0,p.getInputSelection)(I.textarea);u.startIndex!==u.endIndex&&(b=u.endIndex-u.startIndex),d=(b&&I.cursorInfo&&I.cursorInfo.line===u.end.row&&I.cursorInfo.column===u.end.column?(c=u.start.row,u.start):(c=u.end.row,u.end)).column,I.cursorInfo={line:c,column:d,count:b},I.options.statusBar&&h()},0):this.aceEditor&&this.curserInfoElements&&(s=this.aceEditor.getCursorPosition(),o=this.aceEditor.getSelectedText(),c=s.row+1,d=s.column+1,b=o.length,I.cursorInfo={line:c,column:d,count:b},this.options.statusBar&&h())},i._emitSelectionChange=function(){var s;this._selectionChangedHandler&&(s=this.getTextSelection(),this._selectionChangedHandler(s.start,s.end,s.text))},i._refreshAnnotations=function(){var s,o=this.aceEditor&&this.aceEditor.getSession();o&&(s=o.getAnnotations().filter(function(c){return c.type==="error"}),o.setAnnotations(s))},i.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null,this.frameFocusTracker.destroy()},i.compact=function(){var s=this.get(),s=JSON.stringify(s);this.updateText(s)},i.format=function(){var s=this.get(),s=JSON.stringify(s,null,this.indentation);this.updateText(s)},i.repair=function(){var s=this.getText();try{var o=X()(s);this.updateText(o)}catch{}},i.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},i.resize=function(){this.aceEditor&&this.aceEditor.resize(!1)},i.set=function(s){this.setText(JSON.stringify(s,null,this.indentation))},i.update=function(s){this.updateText(JSON.stringify(s,null,this.indentation))},i.get=function(){var s=this.getText();return(0,p.parse)(s)},i.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},i._setText=function(b,o){var c,d=this,b=this.options.escapeUnicode===!0?(0,p.escapeUnicodeChars)(b):b;this.textarea&&(this.textarea.value=b),this.aceEditor&&(this.onChangeDisabled=!0,this.aceEditor.setValue(b,-1),this.onChangeDisabled=!1,o&&(c=this,setTimeout(function(){c.aceEditor&&c.aceEditor.session.getUndoManager().reset()})),setTimeout(function(){d._updateHistoryButtons&&d._updateHistoryButtons()})),this._debouncedValidate()},i.setText=function(s){this._setText(s,!0)},i.updateText=function(s){this.getText()!==s&&this._setText(s,!1)},i.validate=function(){var s,o=this,c=[],d=[];try{var b=this.get(),I=(this.validateSchema&&!this.validateSchema(b)&&(c=this.validateSchema.errors.map(function(u){return u.type="validation",(0,p.improveSchemaError)(u)})),this.validationSequence=(this.validationSequence||0)+1,this),h=this.validationSequence;return function(u,y){if(!y)return Promise.resolve([]);try{var w=y(u);return((0,p.isPromise)(w)?w:Promise.resolve(w)).then(function(v){return Array.isArray(v)?v.filter(function(T){var B=(0,p.isValidValidationError)(T);return B||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',T),B}).map(function(T){return{dataPath:(0,p.stringifyPath)(T.path),message:T.message,type:"customValidation"}}):[]})}catch(v){return Promise.reject(v)}}(b,this.options.onValidate).then(function(u){return h===I.validationSequence&&(u=c.concat(d).concat(u),I._renderErrors(u),typeof o.options.onValidationError=="function"&&(0,p.isValidationErrorChanged)(u,o.lastSchemaErrors)&&o.options.onValidationError.call(o,u),o.lastSchemaErrors=u),o.lastSchemaErrors})}catch(u){return this.getText()&&((b=/\w*line\s*(\d+)\w*/g.exec(u.message))&&(s=+b[1]),d=[{type:"error",message:u.message.replace(/\n/g,"<br>"),line:s}]),this._renderErrors(d),typeof this.options.onValidationError=="function"&&(0,p.isValidationErrorChanged)(d,this.lastSchemaErrors)&&this.options.onValidationError.call(this,d),this.lastSchemaErrors=d,Promise.resolve(this.lastSchemaErrors)}},i._validateAndCatch=function(){this.validate().catch(function(s){console.error("Error running validation:",s)})},i._renderErrors=function(s){var c=this.getText(),o=[],c=(s.reduce(function(d,b){return typeof b.dataPath=="string"&&d.indexOf(b.dataPath)===-1&&d.push(b.dataPath),d},o),(0,p.getPositionForPath)(c,o));this.aceEditor&&(this.annotations=c.map(function(d){var b=s.filter(function(h){return h.dataPath===d.path}),I=b.map(function(h){return h.message}).join(`
`);return I?{row:d.line,column:d.column,text:"Schema validation error"+(b.length!==1?"s":"")+`: 
`+I,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations()),this.errorTable.setErrors(s,c),this.aceEditor&&this.aceEditor.resize(!1)},i.getTextSelection=function(){var s,o,c,d={};return this.textarea?(c=(0,p.getInputSelection)(this.textarea),this.cursorInfo&&this.cursorInfo.line===c.end.row&&this.cursorInfo.column===c.end.column?(d.start=c.end,d.end=c.start):d=c,{start:d.start,end:d.end,text:this.textarea.value.substring(c.startIndex,c.endIndex)}):this.aceEditor?(c=this.aceEditor.getSelection(),s=this.aceEditor.getSelectedText(),o=c.getRange(),(c=c.getSelectionLead()).row===o.end.row&&c.column===o.end.column?d=o:(d.start=o.end,d.end=o.start),{start:{row:d.start.row+1,column:d.start.column+1},end:{row:d.end.row+1,column:d.end.column+1},text:s}):void 0},i.onTextSelectionChange=function(s){typeof s=="function"&&(this._selectionChangedHandler=(0,p.debounce)(s,this.DEBOUNCE_INTERVAL))},i.setTextSelection=function(s,o){var c,d,b;s&&o&&(this.textarea?(c=(0,p.getIndexForPosition)(this.textarea,s.row,s.column),b=(0,p.getIndexForPosition)(this.textarea,o.row,o.column),-1<c&&-1<b&&(this.textarea.setSelectionRange?(this.textarea.focus(),this.textarea.setSelectionRange(c,b)):this.textarea.createTextRange&&((d=this.textarea.createTextRange()).collapse(!0),d.moveEnd("character",b),d.moveStart("character",c),d.select()),b=(this.textarea.value.match(/\n/g)||[]).length+1,c=this.textarea.scrollHeight/b,d=s.row*c,this.textarea.scrollTop=d>this.textarea.clientHeight?d-this.textarea.clientHeight/2:0)):this.aceEditor&&(b={start:{row:s.row-1,column:s.column-1},end:{row:o.row-1,column:o.column-1}},this.aceEditor.selection.setRange(b),this.aceEditor.scrollToLine(s.row-1,!0)))};var r=[{mode:"text",mixin:i,data:"text",load:e},{mode:"code",mixin:i,data:"text",load:e}]},8038:function(ie,H,K){K.r(H),K.d(H,{treeModeMixins:function(){return Y}});var X={start:function(R,Z,W){return Z.indexOf(R)===0},contain:function(R,Z,W){return-1<Z.indexOf(R)}},k=K(897),G=K(2474);function O(R,Z){for(var W=0;W<Z.length;W++){var f=Z[W];f.enumerable=f.enumerable||!1,f.configurable=!0,"value"in f&&(f.writable=!0),Object.defineProperty(R,f.key,f)}}var D=function(){function R(){if(!(this instanceof R))throw new TypeError("Cannot call a class as a function");this.locked=!1}var Z,W;return Z=R,(W=[{key:"highlight",value:function(f){this.locked||(this.node!==f&&(this.node&&this.node.setHighlight(!1),this.node=f,this.node.setHighlight(!0)),this._cancelUnhighlight())}},{key:"unhighlight",value:function(){var f;this.locked||(f=this).node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){f.node.setHighlight(!1),f.node=void 0,f.unhighlightTimer=void 0},0))}},{key:"_cancelUnhighlight",value:function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)}},{key:"lock",value:function(){this.locked=!0}},{key:"unlock",value:function(){this.locked=!1}}])&&O(Z.prototype,W),Object.defineProperty(Z,"prototype",{writable:!1}),R}(),N=K(7907),M=K(6056),L=K(6617),H=K(233),C=K.n(H),m=K(2602),A=K(9791),x=K(6210),p=K(2558),a=K(4188);function l(R){return function(Z){if(Array.isArray(Z))return e(Z)}(R)||function(Z){if(typeof Symbol<"u"&&Z[Symbol.iterator]!=null||Z["@@iterator"]!=null)return Array.from(Z)}(R)||t(R)||function(){throw new TypeError(`Invalid attempt to spread non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}()}function n(R,Z){return function(W){if(Array.isArray(W))return W}(R)||function(W,f){var S=W==null?null:typeof Symbol<"u"&&W[Symbol.iterator]||W["@@iterator"];if(S!=null){var $,F,j=[],Q=!0,te=!1;try{for(S=S.call(W);!(Q=($=S.next()).done)&&(j.push($.value),!f||j.length!==f);Q=!0);}catch(he){te=!0,F=he}finally{try{Q||S.return==null||S.return()}finally{if(te)throw F}}return j}}(R,Z)||t(R,Z)||function(){throw new TypeError(`Invalid attempt to destructure non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}()}function i(R,Z){var W,f,S,$,F=typeof Symbol<"u"&&R[Symbol.iterator]||R["@@iterator"];if(F)return f=!(W=!0),{s:function(){F=F.call(R)},n:function(){var j=F.next();return W=j.done,j},e:function(j){f=!0,S=j},f:function(){try{W||F.return==null||F.return()}finally{if(f)throw S}}};if(Array.isArray(R)||(F=t(R))||Z&&R&&typeof R.length=="number")return F&&(R=F),$=0,{s:Z=function(){},n:function(){return $>=R.length?{done:!0}:{done:!1,value:R[$++]}},e:function(j){throw j},f:Z};throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}function t(R,Z){var W;if(R)return typeof R=="string"?e(R,Z):(W=(W=Object.prototype.toString.call(R).slice(8,-1))==="Object"&&R.constructor?R.constructor.name:W)==="Map"||W==="Set"?Array.from(R):W==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(W)?e(R,Z):void 0}function e(R,Z){(Z==null||Z>R.length)&&(Z=R.length);for(var W=0,f=new Array(Z);W<Z;W++)f[W]=R[W];return f}function r(R){return(r=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(Z){return typeof Z}:function(Z){return Z&&typeof Symbol=="function"&&Z.constructor===Symbol&&Z!==Symbol.prototype?"symbol":typeof Z})(R)}function s(R,Z){for(var W=0;W<Z.length;W++){var f=Z[W];f.enumerable=f.enumerable||!1,f.configurable=!0,"value"in f&&(f.writable=!0),Object.defineProperty(R,f.key,f)}}var o=function(){function R(f,S){if(!(this instanceof R))throw new TypeError("Cannot call a class as a function");this.editor=f,this.dom={},this.expanded=!1,S&&S instanceof Object?(this.setField(S.field,S.fieldEditable),"value"in S&&this.setValue(S.value,S.type),"internalValue"in S&&this.setInternalValue(S.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=(0,A.debounce)(this._onChangeValue.bind(this),R.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=(0,A.debounce)(this._onChangeField.bind(this),R.prototype.DEBOUNCE_INTERVAL),this.visibleChilds=this.getMaxVisibleChilds()}var Z,W;return Z=R,(W=[{key:"getMaxVisibleChilds",value:function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:c}},{key:"_updateEditability",value:function(){var f,S;this.editable={field:!0,value:!0},this.editor&&(this.editable.field=this.editor.options.mode==="tree",this.editable.value=this.editor.options.mode!=="view",this.editor.options.mode!=="tree"&&this.editor.options.mode!=="form"||typeof this.editor.options.onEditable!="function"||(f=this.getValue.bind(this),typeof(S=this.editor.options.onEditable({field:this.field,get value(){return f()},path:this.getPath()}))=="boolean"?(this.editable.field=S,this.editable.value=S):r(S)==="object"&&S!==null?(typeof S.field=="boolean"&&(this.editable.field=S.field),typeof S.value=="boolean"&&(this.editable.value=S.value)):(console.error("Invalid return value for function onEditable.","Actual value:",S,".","Either a boolean or object { field: boolean, value: boolean } expected."),this.editable.field=!1,this.editable.value=!1)))}},{key:"getPath",value:function(){for(var f=this,S=[];f;){var $=f.getName();$!==void 0&&S.unshift($),f=f.parent}return S}},{key:"getInternalPath",value:function(){for(var f=this,S=[];f;)f.parent&&S.unshift(f.getIndex()),f=f.parent;return S}},{key:"getName",value:function(){return this.parent?this.parent.type!=="array"?this.field:this.index:void 0}},{key:"findNodeByPath",value:function(f){if(f){if(f.length===0)return this;if(f.length&&this.childs&&this.childs.length){for(var S=0;S<this.childs.length;++S)if(""+f[0]==""+this.childs[S].getName())return this.childs[S].findNodeByPath(f.slice(1))}}}},{key:"findNodeByInternalPath",value:function(f){if(f){for(var F=this,S=0;S<f.length&&F;S++)var $=f[S],F=F.childs[$];return F}}},{key:"serialize",value:function(){return{value:this.getValue(),path:this.getPath()}}},{key:"findNode",value:function(f){for(var S=(0,A.parsePath)(f),$=this;$&&0<S.length;)(function(){var F=S.shift();if(typeof F=="number"){if($.type!=="array")throw new Error("Cannot get child node at index "+F+": node is no array");$=$.childs[F]}else{if($.type!=="object")throw new Error("Cannot get child node "+F+": node is no object");$=$.childs.filter(function(j){return j.field===F})[0]}})();return $}},{key:"findParents",value:function(){for(var f=[],S=this.parent;S;)f.unshift(S),S=S.parent;return f}},{key:"setError",value:function(f,S){this.error=f,this.errorChild=S,this.dom&&this.dom.tr&&this.updateError()}},{key:"updateError",value:function(){var f=this,S=this.fieldError||this.valueError||this.error,$=this.dom.tdError;if(S&&this.dom&&this.dom.tr){(0,A.addClassName)(this.dom.tr,"jsoneditor-validation-error"),$||($=document.createElement("td"),this.dom.tdError=$,this.dom.tdValue.parentNode.appendChild($));var F=document.createElement("button"),j=(F.type="button",F.className="jsoneditor-button jsoneditor-schema-error",function(){f.dom.popupAnchor&&f.dom.popupAnchor.destroy()}),Q=function(){delete f.dom.popupAnchor},te=function(fe){var ue=f.editor.frame,fe=(f.dom.popupAnchor=(0,m.w)(F,f.editor.getPopupAnchor(),Q,fe),F.getBoundingClientRect()),ue=120<ue.getBoundingClientRect().width-fe.x?"jsoneditor-above":"jsoneditor-left",fe=document.createElement("div");fe.className="jsoneditor-popover "+ue,fe.appendChild(document.createTextNode(S.message)),f.dom.popupAnchor.appendChild(fe)},he=(F.onmouseover=function(){f.dom.popupAnchor||te(!0)},F.onfocus=function(){j(),te(!1)},F.onblur=function(){j()},this.errorChild);for(he&&(F.onclick=function(){he.findParents().forEach(function(ve){ve.expand(!1)}),he.scrollTo(function(){he.focus()})});$.firstChild;)$.removeChild($.firstChild);$.appendChild(F)}else this.dom.tr&&(0,A.removeClassName)(this.dom.tr,"jsoneditor-validation-error"),$&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)}},{key:"getIndex",value:function(){var f;return this.parent?(f=this.parent.childs.indexOf(this))!==-1?f:null:-1}},{key:"setParent",value:function(f){this.parent=f}},{key:"setField",value:function(f,S){this.field=f,this.previousField=f,this.fieldEditable=S===!0}},{key:"getField",value:function(){return this.field===void 0&&this._getDomField(),this.field}},{key:"setValue",value:function(f,S){var $,F,j,Q,te,he,ve=this.childs;if(this.type=this._getType(f),S&&S!==this.type){if(S!=="string"||this.type!=="auto")throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+S+'"');this.type=S}if(this.type==="array"){for(this.childs||(this.childs=[]),$=0;$<f.length;$++)(te=f[$])===void 0||te instanceof Function||($<this.childs.length?((j=this.childs[$]).fieldEditable=!1,j.index=$,j.setValue(te)):(j=new R(this.editor,{value:te}),Q=$<this.getMaxVisibleChilds(),this.appendChild(j,Q,!1)));for(F=this.childs.length;F>=f.length;F--)this.removeChild(this.childs[F],!1)}else if(this.type==="object"){for(this.childs||(this.childs=[]),F=this.childs.length-1;0<=F;F--)I(f,this.childs[F].field)||this.removeChild(this.childs[F],!1);for(var ue in $=0,f)I(f,ue)&&((te=f[ue])===void 0||te instanceof Function||((he=this.findChildByProperty(ue))?(he.setField(ue,!0),he.setValue(te)):(he=new R(this.editor,{field:ue,value:te}),ue=$<this.getMaxVisibleChilds(),this.appendChild(he,ue,!1))),$++);!(this.value="")===this.editor.options.sortObjectKeys&&this.sort([],"asc",!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=f;Array.isArray(ve)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"setInternalValue",value:function(f){var S,$,F,j,Q,te=this.childs;if(this.type=f.type,f.type==="array"){for(this.childs||(this.childs=[]),j=0;j<f.childs.length;j++)(S=f.childs[j])===void 0||S instanceof Function||(j<this.childs.length?(($=this.childs[j]).fieldEditable=!1,$.index=j,$.setInternalValue(S)):($=new R(this.editor,{internalValue:S}),F=j<this.getMaxVisibleChilds(),this.appendChild($,F,!1)));for(Q=this.childs.length;Q>=f.childs.length;Q--)this.removeChild(this.childs[Q],!1)}else if(f.type==="object"){for(this.childs||(this.childs=[]),j=0;j<f.childs.length;j++)(S=f.childs[j])===void 0||S instanceof Function||(j<this.childs.length?(delete($=this.childs[j]).index,$.setField(S.field,!0),$.setInternalValue(S.value)):($=new R(this.editor,{field:S.field,internalValue:S.value}),F=j<this.getMaxVisibleChilds(),this.appendChild($,F,!1)));for(Q=this.childs.length;Q>=f.childs.length;Q--)this.removeChild(this.childs[Q],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=f.value;Array.isArray(te)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"recreateDom",value:function(){var f;this.dom&&this.dom.tr&&this.dom.tr.parentNode?(f=this._detachFromDom(),this.clearDom(),this._attachToDom(f)):this.clearDom()}},{key:"getValue",value:function(){var f,S;return this.type==="array"?(f=[],this.childs.forEach(function($){f.push($.getValue())}),f):this.type==="object"?(S={},this.childs.forEach(function($){S[$.getField()]=$.getValue()}),S):(this.value===void 0&&this._getDomValue(),this.value)}},{key:"getInternalValue",value:function(){return this.type==="array"?{type:this.type,childs:this.childs.map(function(f){return f.getInternalValue()})}:this.type==="object"?{type:this.type,childs:this.childs.map(function(f){return{field:f.getField(),value:f.getInternalValue()}})}:(this.value===void 0&&this._getDomValue(),{type:this.type,value:this.value})}},{key:"getLevel",value:function(){return this.parent?this.parent.getLevel()+1:0}},{key:"getNodePath",value:function(){var f=this.parent?this.parent.getNodePath():[];return f.push(this),f}},{key:"clone",value:function(){var f,S;return(f=new R(this.editor)).type=this.type,f.field=this.field,f.fieldInnerText=this.fieldInnerText,f.fieldEditable=this.fieldEditable,f.previousField=this.previousField,f.value=this.value,f.valueInnerText=this.valueInnerText,f.previousValue=this.previousValue,f.expanded=this.expanded,f.visibleChilds=this.visibleChilds,this.childs?(S=[],this.childs.forEach(function($){$=$.clone(),$.setParent(f),S.push($)}),f.childs=S):f.childs=void 0,f}},{key:"expand",value:function(f){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),f!==!1&&this.childs.forEach(function(S){S.expand(f)}),this.updateDom({recurse:!1}))}},{key:"collapse",value:function(f){this.childs&&(this.hideChilds(),f!==!1&&this.childs.forEach(function(S){S.collapse(f)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1,this.updateDom({recurse:!1}))}},{key:"showChilds",value:function(){var f=this.childs;if(f&&this.expanded){var f=this.dom.tr,S=f?f.parentNode:void 0;if(S){for(var $=this.getAppendDom(),F=($.parentNode||((j=f.nextSibling)?S.insertBefore($,j):S.appendChild($)),Math.min(this.childs.length,this.visibleChilds)),j=this._getNextTr(),Q=0;Q<F;Q++){var te=this.childs[Q];te.getDom().parentNode||S.insertBefore(te.getDom(),j),te.showChilds()}f=this.getShowMoreDom(),j=this._getNextTr(),f.parentNode||S.insertBefore(f,j),this.showMore.updateDom()}}}},{key:"_getNextTr",value:function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0}},{key:"hide",value:function(f){var S=this.dom.tr,$=S?S.parentNode:void 0;$&&$.removeChild(S),this.dom.popupAnchor&&this.dom.popupAnchor.destroy(),this.hideChilds(f)}},{key:"hideChilds",value:function(f){var S;this.childs&&this.expanded&&((S=this.getAppendDom()).parentNode&&S.parentNode.removeChild(S),this.childs.forEach(function($){$.hide()}),(S=this.getShowMoreDom()).parentNode&&S.parentNode.removeChild(S),f&&!f.resetVisibleChilds||(this.visibleChilds=this.getMaxVisibleChilds()))}},{key:"_updateCssClassName",value:function(){var f,S;this.dom.field&&this.editor&&this.editor.options&&typeof this.editor.options.onClassName=="function"&&this.dom.tree&&((0,A.removeAllClassNames)(this.dom.tree),f=this.getValue.bind(this),S=this.editor.options.onClassName({path:this.getPath(),field:this.field,get value(){return f()}})||"",(0,A.addClassName)(this.dom.tree,"jsoneditor-values "+S))}},{key:"recursivelyUpdateCssClassesOnNodes",value:function(){if(this._updateCssClassName(),Array.isArray(this.childs))for(var f=0;f<this.childs.length;f++)this.childs[f].recursivelyUpdateCssClassesOnNodes()}},{key:"expandTo",value:function(){for(var f=this.parent;f;)f.expanded||f.expand(),f=f.parent}},{key:"appendChild",value:function(f,S,$){var F,j;this._hasChilds()&&(f.setParent(this),f.fieldEditable=this.type==="object",this.type==="array"&&(f.index=this.childs.length),this.type==="object"&&f.field===void 0&&f.setField(""),this.childs.push(f),this.expanded&&S!==!1&&(S=f.getDom(),j=(F=this._getNextTr())?F.parentNode:void 0,F&&j&&j.insertBefore(S,F),f.showChilds(),this.visibleChilds++),$!==!1&&(this.updateDom({updateIndexes:!0}),f.updateDom({recurse:!0})))}},{key:"moveBefore",value:function(f,S,$){var F,j,Q;this._hasChilds()&&((F=this.dom.tr?this.dom.tr.parentNode:void 0)&&((j=document.createElement("tr")).style.height=F.clientHeight+"px",F.appendChild(j)),f.parent&&f.parent.removeChild(f),S instanceof h||!S?this.childs.length+1>this.visibleChilds?(Q=this.childs[this.visibleChilds-1],this.insertBefore(f,Q,$)):this.appendChild(f,!0,$):this.insertBefore(f,S,$),F&&j&&F.removeChild(j))}},{key:"insertBefore",value:function(f,S,$){if(this._hasChilds()){if(this.visibleChilds++,this.type==="object"&&f.field===void 0&&f.setField(""),S===this.append)f.setParent(this),f.fieldEditable=this.type==="object",this.childs.push(f);else{var F=this.childs.indexOf(S);if(F===-1)throw new Error("Node not found");f.setParent(this),f.fieldEditable=this.type==="object",this.childs.splice(F,0,f)}var j;this.expanded&&(F=f.getDom(),j=(S=S.getDom())?S.parentNode:void 0,S&&j&&j.insertBefore(F,S),f.showChilds(),this.showChilds()),$!==!1&&(this.updateDom({updateIndexes:!0}),f.updateDom({recurse:!0}))}}},{key:"insertAfter",value:function(f,S){this._hasChilds()&&(S=this.childs.indexOf(S),(S=this.childs[S+1])?this.insertBefore(f,S):this.appendChild(f))}},{key:"search",value:function(f,S){Array.isArray(S)||(S=[]);var $=f?f.toLowerCase():void 0;return delete this.searchField,delete this.searchValue,this.field!==void 0&&S.length<=this.MAX_SEARCH_RESULTS&&(String(this.field).toLowerCase().indexOf($)!==-1&&(this.searchField=!0,S.push({node:this,elem:"field"})),this._updateDomField()),this._hasChilds()?this.childs&&this.childs.forEach(function(F){F.search(f,S)}):this.value!==void 0&&S.length<=this.MAX_SEARCH_RESULTS&&(String(this.value).toLowerCase().indexOf($)!==-1&&(this.searchValue=!0,S.push({node:this,elem:"value"})),this._updateDomValue()),S}},{key:"scrollTo",value:function(f){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,f)}},{key:"expandPathToNode",value:function(){for(var f=this;f&&f.parent;){for(var S=f.parent.type==="array"?f.index:f.parent.childs.indexOf(f);f.parent.visibleChilds<S+1;)f.parent.visibleChilds+=this.getMaxVisibleChilds();f.parent.expand(!1),f=f.parent}}},{key:"focus",value:function(f){if(R.focusElement=f,this.dom.tr&&this.dom.tr.parentNode){var S=this.dom;switch(f){case"drag":(S.drag||S.menu).focus();break;case"menu":S.menu.focus();break;case"expand":this._hasChilds()?S.expand.focus():S.field&&this.fieldEditable?(S.field.focus(),(0,A.selectContentEditable)(S.field)):S.value&&!this._hasChilds()?(S.value.focus(),(0,A.selectContentEditable)(S.value)):S.menu.focus();break;case"field":S.field&&this.fieldEditable?(S.field.focus(),(0,A.selectContentEditable)(S.field)):S.value&&!this._hasChilds()?(S.value.focus(),(0,A.selectContentEditable)(S.value)):(this._hasChilds()?S.expand:S.menu).focus();break;default:S.select?S.select.focus():S.value&&!this._hasChilds()?(S.value.focus(),(0,A.selectContentEditable)(S.value)):S.field&&this.fieldEditable?(S.field.focus(),(0,A.selectContentEditable)(S.field)):(this._hasChilds()?S.expand:S.menu).focus()}}}},{key:"containsNode",value:function(f){if(this===f)return!0;var S=this.childs;if(S){for(var $=0,F=S.length;$<F;$++)if(S[$].containsNode(f))return!0}return!1}},{key:"removeChild",value:function(f,S){if(this.childs){var $=this.childs.indexOf(f);if($!==-1)return $<this.visibleChilds&&this.expanded&&this.visibleChilds--,f.hide(),delete f.searchField,delete f.searchValue,(f=this.childs.splice($,1)[0]).parent=null,S!==!1&&this.updateDom({updateIndexes:!0}),f}}},{key:"_remove",value:function(f){this.removeChild(f)}},{key:"changeType",value:function(f){var S,$=this.type;$!==f&&(f!=="string"&&f!=="auto"||$!=="string"&&$!=="auto"?(S=this._detachFromDom(),this.clearDom(),(this.type=f)==="object"?(this.childs||(this.childs=[]),this.childs.forEach(function(F){F.clearDom(),delete F.index,F.fieldEditable=!0,F.field===void 0&&(F.field="")}),$!=="string"&&$!=="auto"||(this.expanded=!0)):f==="array"?(this.childs||(this.childs=[]),this.childs.forEach(function(F,j){F.clearDom(),F.fieldEditable=!1,F.index=j}),$!=="string"&&$!=="auto"||(this.expanded=!0)):this.expanded=!1,this._attachToDom(S)):this.type=f,f!=="auto"&&f!=="string"||(this.value=f==="string"?String(this.value):(0,A.parseString)(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0}))}},{key:"deepEqual",value:function(f){var S;if(this.type==="array"){if(!Array.isArray(f)||this.childs.length!==f.length)return!1;for(S=0;S<this.childs.length;S++)if(!this.childs[S].deepEqual(f[S]))return!1}else if(this.type==="object"){if(r(f)!=="object"||!f)return!1;var $=Object.keys(f);if(this.childs.length!==$.length)return!1;for(S=0;S<$.length;S++){var F=this.childs[S];if(F.field!==$[S]||!F.deepEqual(f[F.field]))return!1}}else if(this.value!==f)return!1;return!0}},{key:"_getDomValue",value:function(){if(this._clearValueError(),this.dom.value&&this.type!=="array"&&this.type!=="object"&&(this.valueInnerText=(0,A.getInnerText)(this.dom.value),this.valueInnerText===""&&this.dom.value.innerHTML!==""&&(this.dom.value.textContent="")),this.valueInnerText!==void 0)try{var f,S;(S=this.type==="string"?this._unescapeHTML(this.valueInnerText):(f=this._unescapeHTML(this.valueInnerText),(0,A.parseString)(f)))!==this.value&&(this.value=S,this._debouncedOnChangeValue())}catch{this._setValueError((0,N.Iu)("cannotParseValueError"))}}},{key:"_setValueError",value:function(f){this.valueError={message:f},this.updateError()}},{key:"_clearValueError",value:function(){this.valueError&&(this.valueError=null,this.updateError())}},{key:"_setFieldError",value:function(f){this.fieldError={message:f},this.updateError()}},{key:"_clearFieldError",value:function(){this.fieldError&&(this.fieldError=null,this.updateError())}},{key:"_onChangeValue",value:function(){var f,S=this.editor.getDomSelection(),$=(S.range&&($=(0,A.textDiff)(String(this.value),String(this.previousValue)),S.range.startOffset=$.start,S.range.endOffset=$.end),this.editor.getDomSelection());$.range&&(f=(0,A.textDiff)(String(this.previousValue),String(this.value)),$.range.startOffset=f.start,$.range.endOffset=f.end),this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:S,newSelection:$}),this.previousValue=this.value}},{key:"_onChangeField",value:function(){var f=this.editor.getDomSelection(),S=this.previousField||"",$=(f.range&&($=(0,A.textDiff)(this.field,S),f.range.startOffset=$.start,f.range.endOffset=$.end),this.editor.getDomSelection());$.range&&(S=(0,A.textDiff)(S,this.field),$.range.startOffset=S.start,$.range.endOffset=S.end),this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:f,newSelection:$}),this.previousField=this.field}},{key:"_updateDomValue",value:function(){var f=this.dom.value;if(f){var S=["jsoneditor-value"],$=this.value,F=this.type==="auto"?(0,A.getType)($):this.type,j=F==="string"&&(0,A.isUrl)($);if(S.push("jsoneditor-"+F),j&&S.push("jsoneditor-url"),String(this.value)===""&&this.type!=="array"&&this.type!=="object"&&S.push("jsoneditor-empty"),this.searchValueActive&&S.push("jsoneditor-highlight-active"),this.searchValue&&S.push("jsoneditor-highlight"),f.className=S.join(" "),F==="array"||F==="object"?(S=this.childs?this.childs.length:0,f.title=this.type+" containing "+S+" items"):j&&this.editable.value?f.title=(0,N.Iu)("openUrl"):f.title="",F==="boolean"&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value?(this.dom.select||(this.dom.select=document.createElement("select"),this.id=this.field+"_"+new Date().getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,(S=document.createElement("option")).value="",S.textContent="--",this.dom.select.appendChild(S),this._updateEnumOptions(),this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)),this.dom.select.value=this.enum.indexOf(this.value)!==-1?this.value:"",!this.schema||I(this.schema,"oneOf")||I(this.schema,"anyOf")||I(this.schema,"allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.textContent="")):this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML,this.dom.tdValue.appendChild(this.dom.value)),this.editor.options.colorPicker&&typeof $=="string"&&(0,A.isValidColor)($)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue)),(0,A.addClassName)(this.dom.value,"jsoneditor-color-value"),(this.editable.value?A.removeClassName:A.addClassName)(this.dom.color,"jsoneditor-color-readonly"),this.dom.color.style.backgroundColor=$):this._deleteDomColor(),this._showTimestampTag()){if(this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date)),j=null,j=typeof this.editor.options.timestampFormat=="function"?this.editor.options.timestampFormat({field:this.field,value:this.value,path:this.getPath()}):j){for(;this.dom.date.firstChild;)this.dom.date.removeChild(this.dom.date.firstChild);this.dom.date.appendChild(document.createTextNode(j))}else this.dom.date.textContent=new Date($).toISOString();this.dom.date.title=new Date($).toString()}else this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date);(0,A.stripFormatting)(f),this._updateDomDefault()}}},{key:"_updateEnumOptions",value:function(){if(this.enum&&this.dom.select){this.dom.select.innerHTML="";for(var f=0;f<this.enum.length;f++){var S=document.createElement("option");S.value=this.enum[f],S.textContent=this.enum[f],this.dom.select.appendChild(S)}}}},{key:"_deleteDomColor",value:function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,(0,A.removeClassName)(this.dom.value,"jsoneditor-color-value"))}},{key:"_updateDomField",value:function(){var f,S=this.dom.field;S&&((f=(0,A.makeFieldTooltip)(this.schema,this.editor.options.language))&&(S.title=f),(String(this.field)===""&&this.parent&&this.parent.type!=="array"?A.addClassName:A.removeClassName)(S,"jsoneditor-empty"),(this.searchFieldActive?A.addClassName:A.removeClassName)(S,"jsoneditor-highlight-active"),(this.searchField?A.addClassName:A.removeClassName)(S,"jsoneditor-highlight"),(0,A.stripFormatting)(S))}},{key:"_getDomField",value:function(f){if(this._clearFieldError(),this.dom.field&&this.fieldEditable&&(this.fieldInnerText=(0,A.getInnerText)(this.dom.field),this.fieldInnerText===""&&this.dom.field.innerHTML!==""&&(this.dom.field.textContent="")),this.fieldInnerText!==void 0)try{var S=this._unescapeHTML(this.fieldInnerText),$=this.parent.getFieldNames(this);$.indexOf(S)!==-1?f?(S=(0,A.findUniqueName)(S,$))!==this.field&&(this.field=S,this._debouncedOnChangeField()):this._setFieldError((0,N.Iu)("duplicateFieldError")):S!==this.field&&(this.field=S,this._debouncedOnChangeField())}catch{this._setFieldError((0,N.Iu)("cannotParseFieldError"))}}},{key:"_updateDomDefault",value:function(){var f;this.schema&&this.schema.default!==void 0&&!this._hasChilds()&&(f=this.dom.select||this.dom.value)&&(this.value===this.schema.default?(f.title=(0,N.Iu)("default"),(0,A.addClassName)(f,"jsoneditor-is-default"),A.removeClassName):(f.removeAttribute("title"),(0,A.removeClassName)(f,"jsoneditor-is-default"),A.addClassName))(f,"jsoneditor-is-not-default")}},{key:"_showTimestampTag",value:function(){var f,S;return typeof this.value=="number"&&(typeof(f=this.editor.options.timestampTag)=="function"?typeof(S=f({field:this.field,value:this.value,path:this.getPath()}))=="boolean"?S:(0,A.isTimestamp)(this.field,this.value):f===!0&&(0,A.isTimestamp)(this.field,this.value))}},{key:"clearDom",value:function(){this.dom={}}},{key:"getDom",value:function(){var f,S,$=this.dom;return $.tr||(this._updateEditability(),$.tr=document.createElement("tr"),($.tr.node=this).editor.options.mode==="tree"&&(S=document.createElement("td"),this.editable.field&&this.parent&&((f=document.createElement("button")).type="button",($.drag=f).className="jsoneditor-button jsoneditor-dragarea",f.title=(0,N.Iu)("drag"),S.appendChild(f)),$.tr.appendChild(S),f=document.createElement("td"),(S=document.createElement("button")).type="button",($.menu=S).className="jsoneditor-button jsoneditor-contextmenu-button",S.title=(0,N.Iu)("actionsMenu"),f.appendChild($.menu),$.tr.appendChild(f)),S=document.createElement("td"),$.tr.appendChild(S),$.tree=this._createDomTree(),S.appendChild($.tree),this.updateDom({updateIndexes:!0})),$.tr}},{key:"isVisible",value:function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1}},{key:"isDescendantOf",value:function(f){for(var S=this.parent;S;){if(S===f)return!0;S=S.parent}return!1}},{key:"_createDomField",value:function(){return document.createElement("div")}},{key:"setHighlight",value:function(f){this.dom.tr&&((f?A.addClassName:A.removeClassName)(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(f),this.childs&&this.childs.forEach(function(S){S.setHighlight(f)}))}},{key:"setSelected",value:function(f,S){this.selected=f,this.dom.tr&&((f?A.addClassName:A.removeClassName)(this.dom.tr,"jsoneditor-selected"),(S?A.addClassName:A.removeClassName)(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(f),this.showMore&&this.showMore.setSelected(f),this.childs&&this.childs.forEach(function($){$.setSelected(f)}))}},{key:"updateValue",value:function(f){this.value=f,this.previousValue=f,this.valueError=void 0,this.updateDom()}},{key:"updateField",value:function(f){this.field=f,this.previousField=f,this.fieldError=void 0,this.updateDom()}},{key:"updateDom",value:function(f){var S,$=this.dom.tree,$=($&&($.style.marginLeft=24*this.getLevel()+"px"),this.dom.field),$=($&&(this.fieldEditable?($.contentEditable=this.editable.field,$.spellcheck=!1,$.className="jsoneditor-field"):($.contentEditable=!1,$.className="jsoneditor-readonly"),S=this.index!==void 0?this.index:this.field!==void 0?this.field:(S=this.editor.options.schema?R._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0)&&S.title?S.title:this._hasChilds()?this.type:"",S=this._escapeHTML(S),document.activeElement!==$&&S!==this._unescapeHTML((0,A.getInnerText)($))&&($.innerHTML=S),this._updateSchema(),this._updateEnumOptions()),this.dom.value),$=($&&(this.type==="array"||this.type==="object"?this.updateNodeName():(S=this._escapeHTML(this.value),document.activeElement!==$&&S!==this._unescapeHTML((0,A.getInnerText)($))&&($.innerHTML=S))),this.dom.tr);$&&(this.type==="array"||this.type==="object"?((0,A.addClassName)($,"jsoneditor-expandable"),this.expanded?((0,A.addClassName)($,"jsoneditor-expanded"),(0,A.removeClassName)($,"jsoneditor-collapsed")):((0,A.addClassName)($,"jsoneditor-collapsed"),(0,A.removeClassName)($,"jsoneditor-expanded"))):((0,A.removeClassName)($,"jsoneditor-expandable"),(0,A.removeClassName)($,"jsoneditor-expanded"),(0,A.removeClassName)($,"jsoneditor-collapsed"))),this._updateDomField(),this._updateDomValue(),f&&f.updateIndexes===!0&&this._updateDomIndexes(),f&&f.recurse===!0&&this.childs&&this.childs.forEach(function(F){F.updateDom(f)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom(),this._updateCssClassName()}},{key:"_updateSchema",value:function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?R._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null,this.schema?this.enum=R._findEnum(this.schema):delete this.enum)}},{key:"_updateDomIndexes",value:function(){var f=this.dom.value,S=this.childs;f&&S&&(this.type==="array"?S.forEach(function($,F){$.index=F,$=$.dom.field,$&&($.textContent=F)}):this.type==="object"&&S.forEach(function($){$.index!==void 0&&(delete $.index,$.field===void 0&&($.field=""))}))}},{key:"_createDomValue",value:function(){var f;return this.type==="array"?(f=document.createElement("div")).textContent="[...]":this.type==="object"?(f=document.createElement("div")).textContent="{...}":(!this.editable.value&&(0,A.isUrl)(this.value)?(f=document.createElement("a")).href=this.value:((f=document.createElement("div")).contentEditable=this.editable.value,f.spellcheck=!1),f.innerHTML=this._escapeHTML(this.value)),f}},{key:"_createDomExpandButton",value:function(){var f=document.createElement("button");return f.type="button",this._hasChilds()?(f.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",f.title=(0,N.Iu)("expandTitle")):(f.className="jsoneditor-button jsoneditor-invisible",f.title=""),f}},{key:"_createDomTree",value:function(){var f=this.dom,S=document.createElement("table"),F=document.createElement("tbody"),$=(S.style.borderCollapse="collapse",S.className="jsoneditor-values",S.appendChild(F),document.createElement("tr")),F=(F.appendChild($),document.createElement("td")),F=(F.className="jsoneditor-tree",$.appendChild(F),f.expand=this._createDomExpandButton(),F.appendChild(f.expand),f.tdExpand=F,document.createElement("td")),F=(F.className="jsoneditor-tree",$.appendChild(F),f.field=this._createDomField(),F.appendChild(f.field),f.tdField=F,document.createElement("td")),F=(F.className="jsoneditor-tree",$.appendChild(F),this.type!=="object"&&this.type!=="array"&&(F.appendChild(document.createTextNode(":")),F.className="jsoneditor-separator"),f.tdSeparator=F,document.createElement("td"));return F.className="jsoneditor-tree",$.appendChild(F),f.value=this._createDomValue(),F.appendChild(f.value),f.tdValue=F,S}},{key:"onEvent",value:function(f){var S,$=f.type,F=f.target||f.srcElement,j=this.dom,Q=this,te=this._hasChilds(),he=(F!==j.drag&&F!==j.menu||($==="mouseover"?this.editor.highlighter.highlight(this):$==="mouseout"&&this.editor.highlighter.unhighlight()),$==="click"&&F===j.menu&&((S=Q.editor.highlighter).highlight(Q),S.lock(),(0,A.addClassName)(j.menu,"jsoneditor-selected"),this.showContextMenu(j.menu,function(){(0,A.removeClassName)(j.menu,"jsoneditor-selected"),S.unlock(),S.unhighlight()})),$==="click"&&F===j.expand&&te&&(Ce=f.ctrlKey,this._onExpand(Ce)),$!=="click"||f.target!==Q.dom.tdColor&&f.target!==Q.dom.color||!this.editable.value||this._showColorPicker(),$==="change"&&F===j.checkbox&&(this.dom.value.textContent=String(!this.value),this._getDomValue(),this._updateDomDefault()),$==="change"&&F===j.select&&(this.dom.value.innerHTML=this._escapeHTML(j.select.value),this._getDomValue(),this._updateDomValue()),j.value);if(F===he)switch($){case"blur":case"change":this._getDomValue(),this._clearValueError(),this._updateDomValue();var ve=this._escapeHTML(this.value);ve!==this._unescapeHTML((0,A.getInnerText)(he))&&(he.innerHTML=ve);break;case"input":this._getDomValue(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":f.ctrlKey&&this.editable.value&&(0,A.isUrl)(this.value)&&(f.preventDefault(),window.open(this.value,"_blank","noreferrer"));break;case"keyup":this._getDomValue(),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){Q._getDomValue(),Q._updateDomValue()},1)}var ue=j.field;if(F===ue)switch($){case"blur":this._getDomField(!0),this._updateDomField();var fe=this._escapeHTML(this.field);fe!==this._unescapeHTML((0,A.getInnerText)(ue))&&(ue.innerHTML=fe);break;case"input":this._getDomField(),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){Q._getDomField(),Q._updateDomField()},1)}var Ce=j.tree;Ce&&F===Ce.parentNode&&$==="click"&&!f.hasMoved&&((f.offsetX!==void 0?f.offsetX<24*(this.getLevel()+1):f.pageX<(0,A.getAbsoluteLeft)(j.tdSeparator))||te?ue&&((0,A.setEndOfContentEditable)(ue),ue.focus()):he&&!this.enum&&((0,A.setEndOfContentEditable)(he),he.focus())),(F!==j.tdExpand||te)&&F!==j.tdField&&F!==j.tdSeparator||$!=="click"||f.hasMoved||ue&&((0,A.setEndOfContentEditable)(ue),ue.focus()),$==="keydown"&&this.onKeyDown(f),typeof this.editor.options.onEvent=="function"&&this._onEvent(f)}},{key:"_onEvent",value:function(f){var $=f.target,S=$===this.dom.field,$=$===this.dom.value||$===this.dom.checkbox||$===this.dom.select;(S||$)&&(S={field:this.getField(),path:this.getPath()},$&&!this._hasChilds()&&(S.value=this.getValue()),this.editor.options.onEvent(S,f))}},{key:"onKeyDown",value:function(f){var S,$,F,j,Q,te,he,ve,ue,fe,Ce,Ae,Ee,Re,we=f.which||f.keyCode,de=f.target||f.srcElement,Te=f.ctrlKey,ae=f.shiftKey,ge=f.altKey,le=!1,ce=this.editor.options.mode==="tree",me=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],Ie=me[0],xe=me[me.length-1];we===13?de===this.dom.value?this.editable.value&&!f.ctrlKey||(0,A.isUrl)(this.value)&&(window.open(this.value,"_blank","noreferrer"),le=!0):de===this.dom.expand&&this._hasChilds()&&(Ee=f.ctrlKey,this._onExpand(Ee),de.focus(),le=!0):we===68?Te&&ce&&(R.onDuplicate(me),le=!0):we===69?Te&&(this._onExpand(ae),de.focus(),le=!0):we===77&&ce?Te&&(this.showContextMenu(de),le=!0):we===46&&ce?Te&&(R.onRemove(me),le=!0):we===45&&ce?Te&&!ae?(this._onInsertBefore(),le=!0):Te&&ae&&(this._onInsertAfter(),le=!0):we===35?ge&&((Ee=this._lastNode())&&Ee.focus(R.focusElement||this._getElementName(de)),le=!0):we===36?ge&&((Ee=this._firstNode())&&Ee.focus(R.focusElement||this._getElementName(de)),le=!0):we===37?ge&&!ae?((Ee=this._previousElement(de))&&this.focus(this._getElementName(Ee)),le=!0):ge&&ae&&ce&&(Ee=xe.expanded?(Ee=xe.getAppendDom())?Ee.nextSibling:void 0:xe.getDom().nextSibling)&&(Ce=R.getNodeFromTarget(Ee),Ee=Ee.nextSibling,Ae=R.getNodeFromTarget(Ee),Ce&&Ce instanceof h&&xe.parent.childs.length!==1&&Ae&&Ae.parent&&($=this.editor.getDomSelection(),F=(j=Ie.parent).childs[xe.getIndex()+1]||j.append,Q=Ie.getIndex(),te=Ae.getIndex(),he=j.getInternalPath(),ve=Ae.parent.getInternalPath(),me.forEach(function(Ge){Ae.parent.moveBefore(Ge,Ae)}),this.focus(R.focusElement||this._getElementName(de)),this.editor._onAction("moveNodes",{count:me.length,fieldNames:me.map(b),oldParentPath:j.getInternalPath(),newParentPath:Ie.parent.getInternalPath(),oldIndex:F.getIndex(),newIndex:Ie.getIndex(),oldIndexRedo:Q,newIndexRedo:te,oldParentPathRedo:he,newParentPathRedo:ve,oldSelection:$,newSelection:this.editor.getDomSelection()}))):we===38?ge&&!ae?((S=this._previousNode())&&(this.editor.deselect(!0),S.focus(R.focusElement||this._getElementName(de))),le=!0):!ge&&Te&&ae&&ce?((S=this._previousNode())&&((fe=this.editor.multiselection).start=fe.start||this,fe.end=S,ue=this.editor._findTopLevelNodes(fe.start,fe.end),this.editor.select(ue),S.focus("field")),le=!0):ge&&ae&&ce&&((S=Ie._previousNode())&&S.parent&&($=this.editor.getDomSelection(),F=(j=Ie.parent).childs[xe.getIndex()+1]||j.append,Q=Ie.getIndex(),te=S.getIndex(),he=j.getInternalPath(),ve=S.parent.getInternalPath(),me.forEach(function(Ge){S.parent.moveBefore(Ge,S)}),this.focus(R.focusElement||this._getElementName(de)),this.editor._onAction("moveNodes",{count:me.length,fieldNames:me.map(b),oldParentPath:j.getInternalPath(),newParentPath:Ie.parent.getInternalPath(),oldIndex:F.getIndex(),newIndex:Ie.getIndex(),oldIndexRedo:Q,newIndexRedo:te,oldParentPathRedo:he,newParentPathRedo:ve,oldSelection:$,newSelection:this.editor.getDomSelection()})),le=!0):we===39?ge&&!ae?((Ee=this._nextElement(de))&&this.focus(this._getElementName(Ee)),le=!0):ge&&ae&&ce&&(Ee=Ie.getDom().previousSibling)&&(S=R.getNodeFromTarget(Ee))&&S.parent&&!S.isVisible()&&($=this.editor.getDomSelection(),F=(j=Ie.parent).childs[xe.getIndex()+1]||j.append,Q=Ie.getIndex(),te=S.getIndex(),he=j.getInternalPath(),ve=S.parent.getInternalPath(),me.forEach(function(Ge){S.parent.moveBefore(Ge,S)}),this.focus(R.focusElement||this._getElementName(de)),this.editor._onAction("moveNodes",{count:me.length,fieldNames:me.map(b),oldParentPath:j.getInternalPath(),newParentPath:Ie.parent.getInternalPath(),oldIndex:F.getIndex(),newIndex:Ie.getIndex(),oldIndexRedo:Q,newIndexRedo:te,oldParentPathRedo:he,newParentPathRedo:ve,oldSelection:$,newSelection:this.editor.getDomSelection()})):we===40&&(ge&&!ae?((Ce=this._nextNode())&&(this.editor.deselect(!0),Ce.focus(R.focusElement||this._getElementName(de))),le=!0):!ge&&Te&&ae&&ce?((Ce=this._nextNode())&&((fe=this.editor.multiselection).start=fe.start||this,fe.end=Ce,ue=this.editor._findTopLevelNodes(fe.start,fe.end),this.editor.select(ue),Ce.focus("field")),le=!0):ge&&ae&&ce&&((Re=(Ce=(Ce=(Ce=xe.expanded?xe.append?xe.append._nextNode():void 0:xe._nextNode())&&!Ce.isVisible()?Ce.parent.showMore:Ce)&&Ce instanceof h?xe:Ce)&&(Ce._nextNode()||Ce.parent.append))&&Re.parent&&($=this.editor.getDomSelection(),F=(j=Ie.parent).childs[xe.getIndex()+1]||j.append,Q=Ie.getIndex(),te=Re.getIndex(),he=j.getInternalPath(),ve=Re.parent.getInternalPath(),me.forEach(function(Ge){Re.parent.moveBefore(Ge,Re)}),this.focus(R.focusElement||this._getElementName(de)),this.editor._onAction("moveNodes",{count:me.length,fieldNames:me.map(b),oldParentPath:j.getInternalPath(),newParentPath:Ie.parent.getInternalPath(),oldParentPathRedo:he,newParentPathRedo:ve,oldIndexRedo:Q,newIndexRedo:te,oldIndex:F.getIndex(),newIndex:Ie.getIndex(),oldSelection:$,newSelection:this.editor.getDomSelection()})),le=!0)),le&&(f.preventDefault(),f.stopPropagation())}},{key:"_onExpand",value:function(f){var S,$,F;f&&(F=($=(S=this.dom.tr.parentNode).parentNode).scrollTop,$.removeChild(S)),this.expanded?this.collapse(f):this.expand(f),f&&($.appendChild(S),$.scrollTop=F),typeof this.editor.options.onExpand=="function"&&this.editor.options.onExpand({path:this.getPath(),isExpand:this.expanded,recursive:f})}},{key:"_showColorPicker",value:function(){var f,S;typeof this.editor.options.onColorPicker=="function"&&this.dom.color&&((f=this)._deleteDomColor(),f.updateDom(),S=(0,m.w)(this.dom.color,this.editor.getPopupAnchor()),this.editor.options.onColorPicker(S,this.value,function($){typeof $=="string"&&$!==f.value&&(f._deleteDomColor(),f.value=$,f.updateDom(),f._debouncedOnChangeValue())}))}},{key:"getFieldNames",value:function(f){return this.type==="object"?this.childs.filter(function(S){return S!==f}).map(function(S){return S.field}):[]}},{key:"_onInsertBefore",value:function(j,Q,te){var F=this.editor.getDomSelection(),j=new R(this.editor,{field:j!==void 0?j:"",value:Q!==void 0?Q:"",type:te}),Q=(j.expand(!0),this.getInternalPath()),te=(this.parent.insertBefore(j,this),this.editor.highlighter.unhighlight(),j.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertBeforeNodes",{nodes:[j],paths:[j.getInternalPath()],beforePath:Q,parentPath:this.parent.getInternalPath(),oldSelection:F,newSelection:te})}},{key:"_onInsertAfter",value:function(j,Q,$){var F=this.editor.getDomSelection(),j=new R(this.editor,{field:j!==void 0?j:"",value:Q!==void 0?Q:"",type:$}),Q=(j.expand(!0),this.parent.insertAfter(j,this),this.editor.highlighter.unhighlight(),j.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertAfterNodes",{nodes:[j],paths:[j.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:F,newSelection:Q})}},{key:"_onAppend",value:function(j,Q,$){var F=this.editor.getDomSelection(),j=new R(this.editor,{field:j!==void 0?j:"",value:Q!==void 0?Q:"",type:$}),Q=(j.expand(!0),this.parent.appendChild(j),this.editor.highlighter.unhighlight(),j.focus("field"),this.editor.getDomSelection());this.editor._onAction("appendNodes",{nodes:[j],paths:[j.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:F,newSelection:Q})}},{key:"_onChangeType",value:function(f){var S,$,F=this.type;f!==F&&(S=this.editor.getDomSelection(),this.changeType(f),$=this.editor.getDomSelection(),this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:F,newType:f,oldSelection:S,newSelection:$}))}},{key:"sort",value:function(f,S){var $,F,j=!(2<arguments.length&&arguments[2]!==void 0)||arguments[2];typeof f=="string"&&(f=(0,A.parsePath)(f)),this._hasChilds()&&(this.hideChilds(),$=this.childs,this.childs=this.childs.concat(),F=S==="desc"?-1:1,this.type==="object"?this.childs.sort(function(Q,te){return F*C()(Q.field,te.field)}):this.childs.sort(function(he,ve){var he=he.getNestedChild(f),ve=ve.getNestedChild(f);return he?ve?(he=he.value,ve=ve.value,typeof he!="string"&&typeof ve!="string"?ve<he?F:he<ve?-F:0:F*C()(he,ve)):-F:F}),this._updateDomIndexes(),this.showChilds(),j===!0&&this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:$,newChilds:this.childs}))}},{key:"update",value:function(f){var S=this.getInternalValue();this.setValue(f),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:S,newValue:this.getInternalValue()})}},{key:"_detachFromDom",value:function(){var f=this.dom.tr?this.dom.tr.parentNode:void 0,S=this.expanded?this.getAppendDom():this.getDom(),S=S&&S.parentNode?S.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:f,nextTr:S}}},{key:"_attachToDom",value:function(f){f.table&&(f.nextTr?f.table.insertBefore(this.getDom(),f.nextTr):f.table.appendChild(this.getDom())),this.expanded&&this.showChilds()}},{key:"transform",value:function(f){if(this._hasChilds()){this.hideChilds();try{var S=this.getInternalValue(),$=this.getValue(),F=this.editor.options.executeQuery($,f),j=(this.setValue(F),this.getInternalValue());this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:S,newValue:j}),this.showChilds()}catch(Q){this.showChilds(),this.editor._onError(Q)}}}},{key:"extract",value:function(){this.editor.node.hideChilds(),this.hideChilds();try{var f=this.editor.node.getInternalValue(),S=(this.editor._setRoot(this),this.editor.node.getInternalValue());this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:f,newValue:S})}catch($){this.editor._onError($)}finally{this.updateDom({recurse:!0}),this.showChilds()}}},{key:"getNestedChild",value:function(f){for(var S=0,$=this;$&&S<f.length;)$=$.findChildByProperty(f[S]),S++;return $}},{key:"findChildByProperty",value:function(f){if(this.type==="object")return this.childs.find(function(S){return S.field===f})}},{key:"getAppendDom",value:function(){return this.append||(this.append=new h(this.editor),this.append.setParent(this)),this.append.getDom()}},{key:"getShowMoreDom",value:function(){return this.showMore||(this.showMore=new y(this.editor,this)),this.showMore.getDom()}},{key:"nextSibling",value:function(){var f=this.parent.childs.indexOf(this);return this.parent.childs[f+1]||this.parent.append}},{key:"_previousNode",value:function(){var f=null,S=this.getDom();if(S&&S.parentNode)for(var $=S;$=$.previousSibling,f=R.getNodeFromTarget($),$&&f&&f instanceof h&&!f.isVisible(););return f}},{key:"_nextNode",value:function(){var f=null,S=this.getDom();if(S&&S.parentNode)for(var $=S;$=$.nextSibling,f=R.getNodeFromTarget($),$&&f&&f instanceof h&&!f.isVisible(););return f}},{key:"_firstNode",value:function(){var f=null,S=this.getDom();return S&&S.parentNode&&(S=S.parentNode.firstChild,f=R.getNodeFromTarget(S)),f}},{key:"_lastNode",value:function(){var f=null,S=this.getDom();if(S&&S.parentNode)for(var $=S.parentNode.lastChild,f=R.getNodeFromTarget($);$&&f&&!f.isVisible();)$=$.previousSibling,f=R.getNodeFromTarget($);return f}},{key:"_previousElement",value:function(f){var S=this.dom;switch(f){case S.value:if(this.fieldEditable)return S.field;case S.field:if(this._hasChilds())return S.expand;case S.expand:return S.menu;case S.menu:if(S.drag)return S.drag;default:return null}}},{key:"_nextElement",value:function(f){var S=this.dom;switch(f){case S.drag:return S.menu;case S.menu:if(this._hasChilds())return S.expand;case S.expand:if(this.fieldEditable)return S.field;case S.field:if(!this._hasChilds())return S.value;default:return null}}},{key:"_getElementName",value:function(f){var S=this;return Object.keys(this.dom).find(function($){return S.dom[$]===f})}},{key:"_hasChilds",value:function(){return this.type==="array"||this.type==="object"}},{key:"addTemplates",value:function(f,S){var $=this,F=$.editor.options.templates;F!=null&&(F.length&&f.push({type:"separator"}),F.forEach(function(j){f.push({text:j.text,className:j.className||"jsoneditor-type-object",title:j.title,click:(S?function(Q,te){$._onAppend(Q,te)}:function(Q,te){$._onInsertBefore(Q,te)}).bind(this,j.field,j.value)})}))}},{key:"showContextMenu",value:function(f,S){var $,F=this,j=[];this.editable.value&&j.push({text:(0,N.Iu)("type"),title:(0,N.Iu)("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:(0,N.Iu)("auto"),className:"jsoneditor-type-auto"+(this.type==="auto"?" jsoneditor-selected":""),title:(0,N.Iu)("autoType"),click:function(){F._onChangeType("auto")}},{text:(0,N.Iu)("array"),className:"jsoneditor-type-array"+(this.type==="array"?" jsoneditor-selected":""),title:(0,N.Iu)("arrayType"),click:function(){F._onChangeType("array")}},{text:(0,N.Iu)("object"),className:"jsoneditor-type-object"+(this.type==="object"?" jsoneditor-selected":""),title:(0,N.Iu)("objectType"),click:function(){F._onChangeType("object")}},{text:(0,N.Iu)("string"),className:"jsoneditor-type-string"+(this.type==="string"?" jsoneditor-selected":""),title:(0,N.Iu)("stringType"),click:function(){F._onChangeType("string")}}]}),this._hasChilds()&&(this.editor.options.enableSort&&j.push({text:(0,N.Iu)("sort"),title:(0,N.Iu)("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){F.showSortModal()}}),this.editor.options.enableTransform&&j.push({text:(0,N.Iu)("transform"),title:(0,N.Iu)("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){F.showTransformModal()}}),this.parent&&j.push({text:(0,N.Iu)("extract"),title:(0,N.Iu)("extractTitle",{type:this.type}),className:"jsoneditor-extract",click:function(){F.extract()}})),this.parent&&this.parent._hasChilds()&&(j.length&&j.push({type:"separator"}),$=F.parent.childs,F===$[$.length-1]&&($=[{text:(0,N.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,N.Iu)("autoType"),click:function(){F._onAppend("","","auto")}},{text:(0,N.Iu)("array"),className:"jsoneditor-type-array",title:(0,N.Iu)("arrayType"),click:function(){F._onAppend("",[])}},{text:(0,N.Iu)("object"),className:"jsoneditor-type-object",title:(0,N.Iu)("objectType"),click:function(){F._onAppend("",{})}},{text:(0,N.Iu)("string"),className:"jsoneditor-type-string",title:(0,N.Iu)("stringType"),click:function(){F._onAppend("","","string")}}],F.addTemplates($,!0),j.push({text:(0,N.Iu)("appendText"),title:(0,N.Iu)("appendTitle"),submenuTitle:(0,N.Iu)("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){F._onAppend("","","auto")},submenu:$})),$=[{text:(0,N.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,N.Iu)("autoType"),click:function(){F._onInsertBefore("","","auto")}},{text:(0,N.Iu)("array"),className:"jsoneditor-type-array",title:(0,N.Iu)("arrayType"),click:function(){F._onInsertBefore("",[])}},{text:(0,N.Iu)("object"),className:"jsoneditor-type-object",title:(0,N.Iu)("objectType"),click:function(){F._onInsertBefore("",{})}},{text:(0,N.Iu)("string"),className:"jsoneditor-type-string",title:(0,N.Iu)("stringType"),click:function(){F._onInsertBefore("","","string")}}],F.addTemplates($,!1),j.push({text:(0,N.Iu)("insert"),title:(0,N.Iu)("insertTitle"),submenuTitle:(0,N.Iu)("insertSub"),className:"jsoneditor-insert",click:function(){F._onInsertBefore("","","auto")},submenu:$}),this.editable.field&&(j.push({text:(0,N.Iu)("duplicateText"),title:(0,N.Iu)("duplicateField"),className:"jsoneditor-duplicate",click:function(){R.onDuplicate(F)}}),j.push({text:(0,N.Iu)("removeText"),title:(0,N.Iu)("removeField"),className:"jsoneditor-remove",click:function(){R.onRemove(F)}}))),this.editor.options.onCreateMenu&&($=F.getPath(),j=this.editor.options.onCreateMenu(j,{type:"single",path:$,paths:[$]})),new k.x(j,{close:S}).show(f,this.editor.getPopupAnchor())}},{key:"showSortModal",value:function(){var f=this,S=this.editor.options.modalAnchor||a.qD,$=this.getValue();(0,x.showSortModal)(S,$,function(F){var j=F.path,j=(0,A.parsePath)(j);f.sortedBy=F,f.sort(j,F.direction)},f.sortedBy)}},{key:"showTransformModal",value:function(){var f=this,j=this.editor.options,S=j.modalAnchor,$=j.createQuery,F=j.executeQuery,j=j.queryDescription,Q=this.getValue();(0,p.showTransformModal)({container:S||a.qD,json:Q,queryDescription:j,createQuery:$,executeQuery:F,onTransform:function(te){f.transform(te)}})}},{key:"_getType",value:function(f){return f instanceof Array?"array":f instanceof Object?"object":typeof f=="string"&&typeof(0,A.parseString)(f)!="string"?"string":"auto"}},{key:"_escapeHTML",value:function(f){return typeof f!="string"?String(f):(f=String(f).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/ {2}/g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),f=(f=JSON.stringify(f)).substring(1,f.length-1),this.editor.options.escapeUnicode===!0?(0,A.escapeUnicodeChars)(f):f)}},{key:"_unescapeHTML",value:function(f){return f='"'+this._escapeJSON(f)+'"',(0,A.parse)(f).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")}},{key:"_escapeJSON",value:function(f){for(var S="",$=0;$<f.length;){var F=f.charAt($);F===`
`?S+="\\n":F==="\\"?(S+=F,$++,(F=f.charAt($))!==""&&'"\\/bfnrtu'.indexOf(F)!==-1||(S+="\\"),S+=F):S+=F==='"'?'\\"':F,$++}return S}},{key:"updateNodeName",value:function(){var f=this.childs?this.childs.length:0;if(this.type==="object"||this.type==="array"){if(this.editor.options.onNodeName)try{var S=this.getValue.bind(this),$=this.editor.options.onNodeName({path:this.getPath(),size:f,type:this.type,get value(){return S()}})}catch(F){console.error("Error in onNodeName callback: ",F)}this.dom.value.textContent=this.type==="object"?"{"+($||f)+"}":"["+($||f)+"]"}}},{key:"recursivelyUpdateNodeName",value:function(){if(this.expanded&&(this.updateNodeName(),this.childs!=="undefined"))for(var f in this.childs)this.childs[f].recursivelyUpdateNodeName()}}])&&s(Z.prototype,W),Object.defineProperty(Z,"prototype",{writable:!1}),R}(),c=(o.prototype.DEBOUNCE_INTERVAL=150,o.prototype.MAX_SEARCH_RESULTS=999,100);function d(R){return R.getInternalPath()}function b(R){return R.getField()}function I(R,Z){return Object.prototype.hasOwnProperty.call(R,Z)}o.focusElement=void 0,o.select=function(R){setTimeout(function(){(0,A.selectContentEditable)(R)},0)},o.onDragStart=function(R,Z){if(!Array.isArray(R))return o.onDragStart([R],Z);var W,f,S,$,F;R.length!==0&&(W=R[0],f=R[R.length-1],S=W.parent,F=o.getNodeFromTarget(Z.target),$=W.editor,F=(0,A.getAbsoluteTop)(F.dom.tr)-(0,A.getAbsoluteTop)(W.dom.tr),$.mousemove||($.mousemove=(0,A.addEventListener)(Z.view,"mousemove",function(j){o.onDrag(R,j)})),$.mouseup||($.mouseup=(0,A.addEventListener)(Z.view,"mouseup",function(j){o.onDragEnd(R,j)})),$.highlighter.lock(),$.drag={oldCursor:document.body.style.cursor,oldSelection:$.getDomSelection(),oldPaths:R.map(d),oldParent:S,oldNextNode:S.childs[f.getIndex()+1]||S.append,oldParentPathRedo:S.getInternalPath(),oldIndexRedo:W.getIndex(),mouseX:Z.pageX,offsetY:F,level:W.getLevel()},document.body.style.cursor="move",Z.preventDefault())},o.onDrag=function(R,Z){if(!Array.isArray(R))return o.onDrag([R],Z);if(R.length!==0){var W,f,S,$,F,j=R[0].editor,Q=Z.pageY-j.drag.offsetY,te=Z.pageX,he=!1,ve=R[0],ue=ve.dom.tr,fe=(0,A.getAbsoluteTop)(ue),Ce=ue.offsetHeight;if(Q<fe){for(we=ue;we=we.previousSibling,de=o.getNodeFromTarget(we),S=we?(0,A.getAbsoluteTop)(we):0,we&&Q<S;);(de=de&&!de.parent?void 0:de)||(we=(ue=ue.parentNode.firstChild)?ue.nextSibling:void 0,(de=o.getNodeFromTarget(we))===ve&&(de=void 0)),!(de=de&&de.isVisible()&&(S=(we=de.dom.tr)?(0,A.getAbsoluteTop)(we):0)+Ce<Q?void 0:de)||j.options.limitDragging!==!1&&de.parent!==R[0].parent||(R.forEach(function(ae){de.parent.moveBefore(ae,de)}),he=!0)}else{var Ae=R[R.length-1];if(Ce=(ue=Ae.expanded&&Ae.append?Ae.append.getDom():Ae.dom.tr)?ue.nextSibling:void 0){for($=(0,A.getAbsoluteTop)(Ce),W=Ce;f=o.getNodeFromTarget(W),W&&(F=W.nextSibling?(0,A.getAbsoluteTop)(W.nextSibling):0,F=W?F-$:0,f&&f.parent.childs.length===R.length&&f.parent.childs[R.length-1]===Ae&&(fe+=27),W=W.nextSibling),W&&fe+F<Q;);if(f&&f.parent){for(var Ce=te-j.drag.mouseX,Ce=Math.round(Ce/24/2),Ee=j.drag.level+Ce,Re=f.getLevel(),we=f.dom.tr&&f.dom.tr.previousSibling;Re<Ee&&we;){var de=o.getNodeFromTarget(we),Te=R.some(function(ge){return ge===de||de.isDescendantOf(ge)});if(!Te){if(!(de instanceof h)||(Te=de.parent.childs,Te.length===R.length&&Te[R.length-1]===Ae))break;Re=(f=o.getNodeFromTarget(we)).getLevel()}we=we.previousSibling}(f=f instanceof h&&!f.isVisible()&&f.parent.showMore.isVisible()?f._nextNode():f)&&(j.options.limitDragging===!1||f.parent===R[0].parent)&&f.dom.tr&&f.dom.tr!==ue.nextSibling&&(R.forEach(function(ae){f.parent.moveBefore(ae,f)}),he=!0)}}}he&&(j.drag.mouseX=te,j.drag.level=ve.getLevel()),j.startAutoScroll(Q),Z.preventDefault()}},o.onDragEnd=function(R,Z){if(!Array.isArray(R))return o.onDrag([R],Z);var W,f,S,$,F,j,Q,te,he;R.length!==0&&(j=R[0],W=j.editor,j&&j.dom.menu&&j.dom.menu.focus(),f=W.drag.oldParent.getInternalPath(),S=j.parent.getInternalPath(),$=W.drag.oldParent===j.parent,F=W.drag.oldNextNode.getIndex(),j=j.getIndex(),Q=W.drag.oldParentPathRedo,te=W.drag.oldIndexRedo,he=$&&te<j?j+R.length:j,$&&te===j||W._onAction("moveNodes",{count:R.length,fieldNames:R.map(b),oldParentPath:f,newParentPath:S,oldIndex:F,newIndex:j,oldIndexRedo:te,newIndexRedo:he,oldParentPathRedo:Q,newParentPathRedo:null,oldSelection:W.drag.oldSelection,newSelection:W.getDomSelection()}),document.body.style.cursor=W.drag.oldCursor,W.highlighter.unlock(),R.forEach(function(ve){ve.updateDom(),Z.target!==ve.dom.drag&&Z.target!==ve.dom.menu&&W.highlighter.unhighlight()}),delete W.drag,W.mousemove&&((0,A.removeEventListener)(Z.view,"mousemove",W.mousemove),delete W.mousemove),W.mouseup&&((0,A.removeEventListener)(Z.view,"mouseup",W.mouseup),delete W.mouseup),W.stopAutoScroll(),Z.preventDefault())},o._findEnum=function(R){return R.enum?R.enum:(R=R.oneOf||R.anyOf||R.allOf,R&&(R=R.filter(function(Z){return Z.enum}),0<R.length)?R[0].enum:null)},o._findSchema=function(R,Z,W){for(var f=3<arguments.length&&arguments[3]!==void 0?arguments[3]:R,S=W.slice(1,W.length),$=W[0],F=[f],j=0,Q=[f.oneOf,f.anyOf,f.allOf];j<Q.length;j++){var te=Q[j];Array.isArray(te)&&(F=F.concat(te))}var he,ve=i(F);try{for(ve.s();!(he=ve.n()).done;){if("$ref"in(f=he.value)&&typeof f.$ref=="string"){var ue,fe=f.$ref;if(fe in Z)f=Z[fe];else{if(!fe.startsWith("#/")){if(((ue=fe.match(/#\//g))==null?void 0:ue.length)===1){var Ce,Ae,Ee,Re=n(fe.split("#/"),2),we=Re[0],de=Re[1];if(we in Z)return Ce=Z[we],Ae={$ref:"#/".concat(de)},(Ee=[]).push($),0<S.length&&Ee.push.apply(Ee,l(S)),o._findSchema(Ce,Z,Ee,Ae)}throw Error("Unable to resolve reference ".concat(fe))}var Te,ae=fe.substring(2).split("/"),f=R,ge=i(ae);try{for(ge.s();!(Te=ge.n()).done;){var le=Te.value;if(!(le in f))throw Error("Unable to resolve reference ".concat(fe));f=f[le]}}catch(Ie){ge.e(Ie)}finally{ge.f()}}}if($===void 0)return f;if(typeof $=="string"){if(r(f.properties)==="object"&&f.properties!==null&&$ in f.properties)return f=f.properties[$],o._findSchema(R,Z,S,f);if(r(f.patternProperties)==="object"&&f.patternProperties!==null){for(var ce in f.patternProperties)if($.match(ce))return f=f.patternProperties[ce],o._findSchema(R,Z,S,f)}if(r(f.additionalProperties)==="object")return f=f.additionalProperties,o._findSchema(R,Z,S,f)}else if(typeof $=="number"&&r(f.items)==="object"&&f.items!==null)return f=f.items,o._findSchema(R,Z,S,f)}}catch(me){ve.e(me)}finally{ve.f()}return null},o.onRemove=function(R){if(!Array.isArray(R))return o.onRemove([R]);var Z,W,f,S,$,F;R&&0<R.length&&(Z=(f=R[0]).parent,W=f.editor,f=f.getIndex(),W.highlighter.unhighlight(),S=W.getDomSelection(),o.blurNodes(R),$=W.getDomSelection(),F=R.map(d),R.forEach(function(j){j.parent._remove(j)}),W._onAction("removeNodes",{nodes:R,paths:F,parentPath:Z.getInternalPath(),index:f,oldSelection:S,newSelection:$}))},o.onDuplicate=function(R){if(!Array.isArray(R))return o.onDuplicate([R]);var Z,W,f,S,$,F,j;R&&0<R.length&&(Z=R[R.length-1],W=Z.parent,(f=Z.editor).deselect(f.multiselection.nodes),S=f.getDomSelection(),$=Z,F=R.map(function(Q){var te,he=Q.clone();return Q.parent.type==="object"&&(te=Q.parent.getFieldNames(),he.field=(0,A.findUniqueName)(Q.field,te)),W.insertAfter(he,$),$=he}),R.length===1?F[0].parent.type==="object"?(F[0].dom.field.innerHTML=R[0]._escapeHTML(R[0].field),F[0].focus("field")):F[0].focus():f.select(F),j=f.getDomSelection(),f._onAction("duplicateNodes",{paths:R.map(d),clonePaths:F.map(d),afterPath:Z.getInternalPath(),parentPath:W.getInternalPath(),oldSelection:S,newSelection:j}))},o.getNodeFromTarget=function(R){for(;R;){if(R.node)return R.node;R=R.parentNode}},o.targetIsColorPicker=function(R){var Z=o.getNodeFromTarget(R);if(Z)for(var W=R&&R.parentNode;W;){if(W===Z.dom.color)return!0;W=W.parentNode}return!1},o.blurNodes=function(R){var Z,W;Array.isArray(R)?(Z=(W=R[0]).parent,W=W.getIndex(),(Z.childs[W+R.length]?Z.childs[W+R.length]:Z.childs[W-1]||Z).focus()):o.blurNodes([R])},(u.prototype=new o).getDom=function(){var R=this.dom;if(R.tr)return R.tr;this._updateEditability();var Z=document.createElement("tr"),W=(Z.className="jsoneditor-append",Z.node=this,R.tr=Z,this.editor.options.mode==="tree"&&(R.tdDrag=document.createElement("td"),f=document.createElement("td"),R.tdMenu=f,(W=document.createElement("button")).type="button",W.className="jsoneditor-button jsoneditor-contextmenu-button",W.title="Click to open the actions menu (Ctrl+M)",R.menu=W,f.appendChild(R.menu)),document.createElement("td")),f=document.createElement("div");return f.appendChild(document.createTextNode("("+(0,N.Iu)("empty")+")")),f.className="jsoneditor-readonly",W.appendChild(f),R.td=W,R.text=f,this.updateDom(),Z},u.prototype.getPath=function(){return null},u.prototype.getIndex=function(){return null},u.prototype.updateDom=function(R){var Z=this.dom,W=Z.td,f=(W&&(W.style.paddingLeft=24*this.getLevel()+26+"px"),Z.text),f=(f&&(f.firstChild.nodeValue="("+(0,N.Iu)("empty")+" "+this.parent.type+")"),Z.tr);this.isVisible()?Z.tr.firstChild||(Z.tdDrag&&f.appendChild(Z.tdDrag),Z.tdMenu&&f.appendChild(Z.tdMenu),f.appendChild(W)):Z.tr.firstChild&&(Z.tdDrag&&f.removeChild(Z.tdDrag),Z.tdMenu&&f.removeChild(Z.tdMenu),f.removeChild(W))},u.prototype.isVisible=function(){return this.parent.childs.length===0},u.prototype.showContextMenu=function(R,Z){var W,f=this,S=[{text:(0,N.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,N.Iu)("autoType"),click:function(){f._onAppend("","","auto")}},{text:(0,N.Iu)("array"),className:"jsoneditor-type-array",title:(0,N.Iu)("arrayType"),click:function(){f._onAppend("",[])}},{text:(0,N.Iu)("object"),className:"jsoneditor-type-object",title:(0,N.Iu)("objectType"),click:function(){f._onAppend("",{})}},{text:(0,N.Iu)("string"),className:"jsoneditor-type-string",title:(0,N.Iu)("stringType"),click:function(){f._onAppend("","","string")}}],S=(f.addTemplates(S,!0),[{text:(0,N.Iu)("appendText"),title:(0,N.Iu)("appendTitleAuto"),submenuTitle:(0,N.Iu)("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){f._onAppend("","","auto")},submenu:S}]);this.editor.options.onCreateMenu&&(W=f.parent.getPath(),S=this.editor.options.onCreateMenu(S,{type:"append",path:W,paths:[W]})),new k.x(S,{close:Z}).show(R,this.editor.getPopupAnchor())},u.prototype.onEvent=function(R){var Z,W=R.type,f=R.target||R.srcElement,S=this.dom;f===S.menu&&(W==="mouseover"?this.editor.highlighter.highlight(this.parent):W==="mouseout"&&this.editor.highlighter.unhighlight()),W==="click"&&f===S.menu&&((Z=this.editor.highlighter).highlight(this.parent),Z.lock(),(0,A.addClassName)(S.menu,"jsoneditor-selected"),this.showContextMenu(S.menu,function(){(0,A.removeClassName)(S.menu,"jsoneditor-selected"),Z.unlock(),Z.unhighlight()})),W==="keydown"&&this.onKeyDown(R)};var h=u;function u(R){this.editor=R,this.dom={}}(w.prototype=new o).getDom=function(){var R,Z,W,f,S,$;return this.dom.tr||(this._updateEditability(),this.dom.tr||(Z=(R=this).parent,(S=document.createElement("a")).appendChild(document.createTextNode((0,N.Iu)("showMore"))),S.href="#",S.onclick=function(F){return Z.visibleChilds=Math.floor(Z.visibleChilds/Z.getMaxVisibleChilds()+1)*Z.getMaxVisibleChilds(),R.updateDom(),Z.showChilds(),F.preventDefault(),!1},($=document.createElement("a")).appendChild(document.createTextNode((0,N.Iu)("showAll"))),$.href="#",$.onclick=function(F){return Z.visibleChilds=1/0,R.updateDom(),Z.showChilds(),F.preventDefault(),!1},W=document.createElement("div"),f=document.createTextNode(this._getShowMoreText()),W.className="jsoneditor-show-more",W.appendChild(f),W.appendChild(S),W.appendChild(document.createTextNode(". ")),W.appendChild($),W.appendChild(document.createTextNode(". ")),(S=document.createElement("td")).appendChild(W),$=document.createElement("tr"),this.editor.options.mode==="tree"&&($.appendChild(document.createElement("td")),$.appendChild(document.createElement("td"))),$.appendChild(S),$.className="jsoneditor-show-more",this.dom.tr=$,this.dom.moreContents=W,this.dom.moreText=f),this.updateDom()),this.dom.tr},w.prototype.updateDom=function(R){var Z;this.isVisible()?(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],this.dom.tr.parentNode||(Z=this.parent._getNextTr())&&Z.parentNode.insertBefore(this.dom.tr,Z),this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"):this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},w.prototype._getShowMoreText=function(){return(0,N.Iu)("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},w.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},w.prototype.onEvent=function(R){R.type==="keydown"&&this.onKeyDown(R)};var y=w;function w(R,Z){this.editor=R,this.parent=Z,this.dom={}}function v(R,Z){for(var W=0;W<Z.length;W++){var f=Z[W];f.enumerable=f.enumerable||!1,f.configurable=!0,"value"in f&&(f.writable=!0),Object.defineProperty(R,f.key,f)}}var T=function(){function R(f){if(!(this instanceof R))throw new TypeError("Cannot call a class as a function");function S($){return f.node.findNodeByInternalPath($)}this.editor=f,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function($){S($.parentPath).childs[$.index].updateField($.oldValue)},redo:function($){S($.parentPath).childs[$.index].updateField($.newValue)}},editValue:{undo:function($){S($.path).updateValue($.oldValue)},redo:function($){S($.path).updateValue($.newValue)}},changeType:{undo:function($){S($.path).changeType($.oldType)},redo:function($){S($.path).changeType($.newType)}},appendNodes:{undo:function($){var F=S($.parentPath);$.paths.map(S).forEach(function(j){F.removeChild(j)})},redo:function($){var F=S($.parentPath);$.nodes.forEach(function(j){F.appendChild(j)})}},insertBeforeNodes:{undo:function($){var F=S($.parentPath);$.paths.map(S).forEach(function(j){F.removeChild(j)})},redo:function($){var F=S($.parentPath),j=S($.beforePath);$.nodes.forEach(function(Q){F.insertBefore(Q,j)})}},insertAfterNodes:{undo:function($){var F=S($.parentPath);$.paths.map(S).forEach(function(j){F.removeChild(j)})},redo:function($){var F=S($.parentPath),j=S($.afterPath);$.nodes.forEach(function(Q){F.insertAfter(Q,j),j=Q})}},removeNodes:{undo:function($){var F=S($.parentPath),j=F.childs[$.index]||F.append;$.nodes.forEach(function(Q){F.insertBefore(Q,j)})},redo:function($){var F=S($.parentPath);$.paths.map(S).forEach(function(j){F.removeChild(j)})}},duplicateNodes:{undo:function($){var F=S($.parentPath);$.clonePaths.map(S).forEach(function(j){F.removeChild(j)})},redo:function($){var F=S($.parentPath),j=S($.afterPath);$.paths.map(S).forEach(function(Q){var te,he=Q.clone();F.type==="object"&&(te=F.getFieldNames(),he.field=(0,A.findUniqueName)(Q.field,te)),F.insertAfter(he,j),j=he})}},moveNodes:{undo:function($){var F=S($.oldParentPath),j=S($.newParentPath),Q=F.childs[$.oldIndex]||F.append;j.childs.slice($.newIndex,$.newIndex+$.count).forEach(function(te,he){te.field=$.fieldNames[he],F.moveBefore(te,Q)}),$.newParentPathRedo===null&&($.newParentPathRedo=j.getInternalPath())},redo:function($){var F=S($.oldParentPathRedo),j=S($.newParentPathRedo),Q=j.childs[$.newIndexRedo]||j.append;F.childs.slice($.oldIndexRedo,$.oldIndexRedo+$.count).forEach(function(te,he){te.field=$.fieldNames[he],j.moveBefore(te,Q)})}},sort:{undo:function($){var F=S($.path);F.hideChilds(),F.childs=$.oldChilds,F.updateDom({updateIndexes:!0}),F.showChilds()},redo:function($){var F=S($.path);F.hideChilds(),F.childs=$.newChilds,F.updateDom({updateIndexes:!0}),F.showChilds()}},transform:{undo:function($){S($.path).setInternalValue($.oldValue)},redo:function($){S($.path).setInternalValue($.newValue)}}}}var Z,W;return Z=R,(W=[{key:"onChange",value:function(){}},{key:"add",value:function(f,S){this.index++,this.history[this.index]={action:f,params:S,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()}},{key:"clear",value:function(){this.history=[],this.index=-1,this.onChange()}},{key:"canUndo",value:function(){return 0<=this.index}},{key:"canRedo",value:function(){return this.index<this.history.length-1}},{key:"undo",value:function(){if(this.canUndo()){var f=this.history[this.index];if(f){var S=this.actions[f.action];if(S&&S.undo){if(S.undo(f.params),f.params.oldSelection)try{this.editor.setDomSelection(f.params.oldSelection)}catch($){console.error($)}}else console.error(new Error('unknown action "'+f.action+'"'))}this.index--,this.onChange()}}},{key:"redo",value:function(){if(this.canRedo()){this.index++;var f=this.history[this.index];if(f){var S=this.actions[f.action];if(S&&S.redo){if(S.redo(f.params),f.params.newSelection)try{this.editor.setDomSelection(f.params.newSelection)}catch($){console.error($)}}else console.error(new Error('unknown action "'+f.action+'"'))}this.onChange()}}},{key:"destroy",value:function(){this.editor=null,this.history=[],this.index=-1}}])&&v(Z.prototype,W),Object.defineProperty(Z,"prototype",{writable:!1}),R}();function B(R,Z){for(var W=0;W<Z.length;W++){var f=Z[W];f.enumerable=f.enumerable||!1,f.configurable=!0,"value"in f&&(f.writable=!0),Object.defineProperty(R,f.key,f)}}var E=function(){function R(Q,F){if(!(this instanceof R))throw new TypeError("Cannot call a class as a function");var $=this,Q=(this.editor=Q,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.results=null,this.dom={},this.dom.container=F,document.createElement("div")),F=((this.dom.wrapper=Q).className="jsoneditor-search",F.appendChild(Q),document.createElement("div")),F=((this.dom.results=F).className="jsoneditor-results",Q.appendChild(F),document.createElement("div")),Q=((this.dom.input=F).className="jsoneditor-frame",F.title=(0,N.Iu)("searchTitle"),Q.appendChild(F),document.createElement("button")),j=(Q.type="button",Q.className="jsoneditor-refresh",F.appendChild(Q),document.createElement("input")),Q=(j.type="text",(this.dom.search=j).oninput=function(te){$._onDelayedSearch(te)},j.onchange=function(te){$._onSearch()},j.onkeydown=function(te){$._onKeyDown(te)},j.onkeyup=function(te){$._onKeyUp(te)},Q.onclick=function(te){j.select()},F.appendChild(j),document.createElement("button")),Q=(Q.type="button",Q.title=(0,N.Iu)("searchNextResultTitle"),Q.className="jsoneditor-next",Q.onclick=function(){$.next()},F.appendChild(Q),document.createElement("button"));Q.type="button",Q.title=(0,N.Iu)("searchPreviousResultTitle"),Q.className="jsoneditor-previous",Q.onclick=function(){$.previous()},F.appendChild(Q)}var Z,W;return Z=R,(W=[{key:"next",value:function(f){var S;this.results&&((S=this.resultIndex!==null?this.resultIndex+1:0)>this.results.length-1&&(S=0),this._setActiveResult(S,f))}},{key:"previous",value:function(f){var S,$;this.results&&(S=this.results.length-1,$=this.resultIndex!==null?this.resultIndex-1:S,this._setActiveResult($=$<0?S:$,f))}},{key:"_setActiveResult",value:function(f,S){var $,F,j;this.activeResult&&($=this.activeResult.node,this.activeResult.elem==="field"?delete $.searchFieldActive:delete $.searchValueActive,$.updateDom()),this.results&&this.results[f]?(this.resultIndex=f,F=this.results[this.resultIndex].node,(j=this.results[this.resultIndex].elem)==="field"?F.searchFieldActive=!0:F.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],F.updateDom(),F.scrollTo(function(){S&&F.focus(j)})):(this.resultIndex=void 0,this.activeResult=void 0)}},{key:"_clearDelay",value:function(){this.timeout!==void 0&&(clearTimeout(this.timeout),delete this.timeout)}},{key:"_onDelayedSearch",value:function(f){this._clearDelay();var S=this;this.timeout=setTimeout(function($){S._onSearch()},this.delay)}},{key:"_onSearch",value:function(f){this._clearDelay();var S=this.dom.search.value,S=0<S.length?S:void 0;if(S!==this.lastText||f){this.lastText=S,this.results=this.editor.search(S);var f=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,$=0;if(this.activeResult){for(var F=0;F<this.results.length;F++)if(this.results[F].node===this.activeResult.node){$=F;break}}this._setActiveResult($,!1),S!==void 0?(S=this.results.length,this.dom.results.textContent=S===0?"no\xA0results":S===1?"1\xA0result":f<S?f+"+\xA0results":S+"\xA0results"):this.dom.results.textContent=""}}},{key:"_onKeyDown",value:function(f){var S=f.which;S===27?(this.dom.search.value="",this._onSearch(),f.preventDefault(),f.stopPropagation()):S===13&&(f.ctrlKey?this._onSearch(!0):f.shiftKey?this.previous():this.next(),f.preventDefault(),f.stopPropagation())}},{key:"_onKeyUp",value:function(f){var S=f.keyCode;S!==27&&S!==13&&this._onDelayedSearch(f)}},{key:"clear",value:function(){this.dom.search.value="",this._onSearch()}},{key:"forceSearch",value:function(){this._onSearch(!0)}},{key:"isEmpty",value:function(){return this.dom.search.value===""}},{key:"destroy",value:function(){this.editor=null,this.dom.container.removeChild(this.dom.wrapper),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()}}])&&B(Z.prototype,W),Object.defineProperty(Z,"prototype",{writable:!1}),R}();function _(R,Z){for(var W=0;W<Z.length;W++){var f=Z[W];f.enumerable=f.enumerable||!1,f.configurable=!0,"value"in f&&(f.writable=!0),Object.defineProperty(R,f.key,f)}}var P=function(){function R(f,S){if(!(this instanceof R))throw new TypeError("Cannot call a class as a function");f&&(this.root=S,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked=!1,f.appendChild(this.path),this.reset())}var Z,W;return Z=R,(W=[{key:"reset",value:function(){this.path.textContent=(0,N.Iu)("selectNode")}},{key:"setPath",value:function(f){var S=this;this.path.textContent="",f&&f.length&&f.forEach(function($,F){var j,Q=document.createElement("span");Q.className="jsoneditor-treepath-element",Q.innerText=$.name,Q.onclick=function(te){this.selectionCallback&&this.selectionCallback(te)}.bind(S,$),S.path.appendChild(Q),$.children.length&&((j=document.createElement("span")).className="jsoneditor-treepath-seperator",j.textContent="\u25BA",j.onclick=function(){S.contentMenuClicked=!0;var te=[];$.children.forEach(function(he){te.push({text:he.name,className:"jsoneditor-type-modes"+(f[F+1]+1&&f[F+1].name===he.name?" jsoneditor-selected":""),click:function(ve,ue){this.contextMenuCallback&&this.contextMenuCallback(ve,ue)}.bind(S,$,he.name)})}),new k.x(te,{limitHeight:!0}).show(j,S.root,!0)},S.path.appendChild(j)),F===f.length-1&&(Q=(j||Q).getBoundingClientRect().right,S.path.offsetWidth<Q&&(S.path.scrollLeft=Q),S.path.scrollLeft&&((Q=document.createElement("span")).className="jsoneditor-treepath-show-all-btn",Q.title="show all path",Q.textContent="...",Q.onclick=function(te){(S.contentMenuClicked=!1,A.addClassName)(S.path,"show-all"),S.path.style.width=S.path.parentNode.getBoundingClientRect().width-10+"px",S.path.onblur=function(){S.contentMenuClicked?(S.contentMenuClicked=!1,S.path.focus()):((0,A.removeClassName)(S.path,"show-all"),S.path.onblur=void 0,S.path.style.width="",S.setPath(te))}}.bind(S,f),S.path.insertBefore(Q,S.path.firstChild)))})}},{key:"onSectionSelected",value:function(f){typeof f=="function"&&(this.selectionCallback=f)}},{key:"onContextMenuItemSelected",value:function(f){typeof f=="function"&&(this.contextMenuCallback=f)}}])&&_(Z.prototype,W),Object.defineProperty(Z,"prototype",{writable:!1}),R}(),H=K(8037),z=K.n(H),K={},Y=(K.create=function(R,Z){if(!R)throw new Error("No container element provided.");function W(le){var ce,me;document.createRange?((ce=document.createRange()).selectNodeContents(le),ce.collapse(!1),(me=window.getSelection()).removeAllRanges(),me.addRange(ce)):document.selection&&((ce=document.body.createTextRange()).moveToElementText(le),ce.collapse(!1),ce.select())}function f(le){return Q===void 0&&((Q=document.createElement("span")).style.visibility="hidden",Q.style.position="fixed",Q.style.outline="0",Q.style.margin="0",Q.style.padding="0",Q.style.border="0",Q.style.left="0",Q.style.whiteSpace="pre",Q.style.fontSize=he,Q.style.fontFamily=ve,Q.style.fontWeight="normal",document.body.appendChild(Q)),Q.textContent=le,Q.getBoundingClientRect().right}function S(){this.style.backgroundColor="#ddd"}function $(){this.style.backgroundColor=""}function F(){we.hide(),we.onmouseselection(this.__hint,we.rs)}var j,Q,te,he,ve,ue,fe,Ce,Ae,Ee,Re,we,de,Te,ae,ge;this.container=R,this.dom={},this.highlighter=new D,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.lastSchemaErrors=void 0,this.node=null,this.focusTarget=null,this._setOptions(Z),Z.autocomplete&&(this.autocomplete=((j=(j=Z.autocomplete)||{}).filter=j.filter||"start",j.trigger=j.trigger||"keydown",j.confirmKeys=j.confirmKeys||[39,35,9],j.caseSensitive=j.caseSensitive||!1,ve=he="",(ue=document.createElement("div")).style.position="relative",ue.style.outline="0",ue.style.border="0",ue.style.margin="0",ue.style.padding="0",(fe=document.createElement("div")).className="autocomplete dropdown",fe.style.position="absolute",fe.style.visibility="hidden",Ce=fe,Ae=[],Re=-1,Te=we={rs:de={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:Ee=0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:ue,show:function(le,ce,me){var Ie=this;this.startFrom=ce,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),he===""&&(he=window.getComputedStyle(le).getPropertyValue("font-size")),ve===""&&(ve=window.getComputedStyle(le).getPropertyValue("font-family")),fe.style.marginLeft="0",fe.style.marginTop=le.getBoundingClientRect().height+"px",this.options=me.map(String),this.element!==le&&(this.element=le,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=le.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){Ie.element.focus()},this.element.addEventListener&&(this.element.removeEventListener("keydown",ae),this.element.addEventListener("keydown",ae,!1),this.element.removeEventListener("blur",ge),this.element.addEventListener("blur",ge,!1)),ue.appendChild(this.elementHint),ue.appendChild(fe),le.parentElement.appendChild(ue),this.repaint(le)},setText:function(le){this.element.innerText=le},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,Te.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(ce){var ce=(ce=ce.innerText).replace(`
`,""),me=this.options.length,Ie=ce.substring(this.startFrom);te=ce.substring(0,this.startFrom);for(var xe=0;xe<me;xe++){var Ge=this.options[xe];if(!j.caseSensitive&&Ge.toLowerCase().indexOf(Ie.toLowerCase())===0||j.caseSensitive&&Ge.indexOf(Ie)===0){this.elementHint.innerText=te+Ie+Ge.substring(Ie.length),this.elementHint.realInnerText=te+Ge;break}}fe.style.left=f(te)+"px",Te.refresh(Ie,this.options),this.elementHint.style.width=f(this.elementHint.innerText)+10+"px",fe.style.visibility!=="hidden"&&(this.elementHint.style.width=f(this.elementHint.innerText)+fe.clientWidth+"px")}},hide:function(){Ce.style.visibility="hidden"},refresh:function(le,ce){Ce.style.visibility="hidden",Ee=0,Ce.textContent="";var Ie=window.innerHeight||document.documentElement.clientHeight,Ge=Ce.parentNode.getBoundingClientRect(),me=Ge.top-6,Ie=Ie-Ge.bottom-6,xe=(Ae=[],typeof j.filter=="function"?j.filter:X[j.filter]),Ge=xe?ce.filter(function(De){return xe(j.caseSensitive?le:le.toLowerCase(),j.caseSensitive?De:De.toLowerCase(),j)}):[];(Ae=Ge.map(function(De){var We=document.createElement("div"),je=(We.className="item",We.onmouseover=S,We.onmouseout=$,We.onmousedown=F,We.__hint=De,We.textContent="",We.appendChild(document.createTextNode(De.substring(0,le.length))),document.createElement("b"));return je.appendChild(document.createTextNode(De.substring(le.length))),We.appendChild(je),Ce.appendChild(We),We})).length===0||Ae.length===1&&(le.toLowerCase()===Ae[0].__hint.toLowerCase()&&!j.caseSensitive||le===Ae[0].__hint&&j.caseSensitive)||Ae.length<2||(we.highlight(0),3*Ie<me?(Ce.style.maxHeight=me+"px",Ce.style.top="",Ce.style.bottom="100%"):(Ce.style.top="100%",Ce.style.bottom="",Ce.style.maxHeight=Ie+"px"),Ce.style.visibility="visible")},highlight:function(le){Re!==-1&&Ae[Re]&&(Ae[Re].className="item"),Ae[le].className="item hover",Re=le},move:function(le){return Ce.style.visibility==="hidden"?"":(Ee+le!==-1&&Ee+le!==Ae.length&&(Ee+=le,we.highlight(Ee)),Ae[Ee].__hint)},onmouseselection:function(){}},ae=function(le){var ce=(le=le||window.event).keyCode;if(this.elementHint!=null&&ce!==33&&ce!==34)if(ce===27)de.hideDropDown(),de.element.focus(),le.preventDefault(),le.stopPropagation();else{var me,Ie=(Ie=this.element.innerText).replace(`
`,"");if(0<=j.confirmKeys.indexOf(ce))ce===9&&this.elementHint.innerText.length===0&&de.onTab(),0<this.elementHint.innerText.length&&this.element.innerText!==this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,de.hideDropDown(),W(this.element),ce===9&&(de.element.focus(),le.preventDefault(),le.stopPropagation()));else if(ce===13)if(this.elementHint.innerText.length===0)de.onEnter();else{var xe=fe.style.visibility==="hidden";if(Te.hide(),xe)return de.hideDropDown(),de.element.focus(),void de.onEnter();this.element.innerText=this.elementHint.realInnerText,de.hideDropDown(),W(this.element),le.preventDefault(),le.stopPropagation()}else ce===40?(xe=Ie.substring(this.startFrom),(me=Te.move(1))===""&&de.onArrowDown(),this.elementHint.innerText=te+xe+me.substring(xe.length),this.elementHint.realInnerText=te+me,le.preventDefault(),le.stopPropagation()):ce===38&&(xe=Ie.substring(this.startFrom),(me=Te.move(-1))===""&&de.onArrowUp(),this.elementHint.innerText=te+xe+me.substring(xe.length),this.elementHint.realInnerText=te+me,le.preventDefault(),le.stopPropagation())}}.bind(de),ge=function(le){de.hideDropDown()},Te.onmouseselection=function(le,ce){ce.element.innerText=ce.elementHint.innerText=te+le,ce.hideDropDown(),window.setTimeout(function(){ce.element.focus(),W(ce.element)},1)},de)),this.options.history&&this.options.mode!=="view"&&(this.history=new T(this)),this._createFrame(),this._createTable()},K.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.frameFocusTracker.destroy()},K._setOptions=function(R){var Z=this;this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,limitDragging:!1,onSelectionChange:null,colorPicker:!0,onColorPicker:function(W,f,S){var $;z()?($=W.getBoundingClientRect().top,$=(0,A.getWindow)(W).innerHeight-$<300&&300<$,new(z())({parent:W,color:f,popup:$?"top":"bottom",onDone:function(F){F=F.rgba[3]===1?F.hex.substr(0,7):F.hex,S(F)}}).show()):console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,timestampFormat:null,createQuery:M.r,executeQuery:M.J,onEvent:null,enableSort:!0,enableTransform:!0},R&&(Object.keys(R).forEach(function(W){Z.options[W]=R[W]}),R.limitDragging==null&&R.schema!=null&&(this.options.limitDragging=!0)),this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=(0,A.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),R.onSelectionChange&&this.onSelectionChange(R.onSelectionChange),(0,N.cC)(this.options.languages),(0,N.m0)(this.options.language)},K.set=function(R){R instanceof Function||R===void 0?this.clear():(this.content.removeChild(this.table),R={field:this.options.name,value:R},R=new o(this,R),this._setRoot(R),this._validateAndCatch(),this.node.expand(!1),this.content.appendChild(this.table)),this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},K.update=function(R){var Z,W;this.node.deepEqual(R)||(Z=this.getSelection(),this.onChangeDisabled=!0,this.node.update(R),this.onChangeDisabled=!1,this._validateAndCatch(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),Z&&Z.start&&Z.end&&(R=this.node.findNodeByPath(Z.start.path),W=this.node.findNodeByPath(Z.end.path),R&&W)?this.setSelection(Z.start,Z.end):this.setSelection({},{}))},K.get=function(){if(this.node)return this.node.getValue()},K.getText=function(){return JSON.stringify(this.get())},K.setText=function(R){try{this.set((0,A.parse)(R))}catch{R=(0,A.tryJsonRepair)(R),this.set((0,A.parse)(R))}},K.updateText=function(R){try{this.update((0,A.parse)(R))}catch{R=(0,A.tryJsonRepair)(R),this.update((0,A.parse)(R))}},K.setName=function(R){this.options.name=R,this.node&&this.node.updateField(this.options.name)},K.getName=function(){return this.options.name},K.focus=function(){var R=this.scrollableContent.querySelector("[contenteditable=true]");R?R.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(R=this.frame.querySelector("button"))&&R.focus()},K.clear=function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},K._setRoot=function(R){this.clear(),(this.node=R).setParent(null),R.setField(this.getName(),!1),delete R.index,this.tbody.appendChild(R.getDom())},K.search=function(R){var Z;return this.node?(this.content.removeChild(this.table),Z=this.node.search(R),this.content.appendChild(this.table)):Z=[],Z},K.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},K.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},K.expand=function(R){var Z;!R||(Z=this.node?this.node.findNodeByPath(R.path):null)&&(R.isExpand?Z.expand(R.recursive):Z.collapse(R.recursive))},K._onAction=function(R,Z){this.history&&this.history.add(R,Z),this._onChange()},K._onChange=function(){if(!this.onChangeDisabled){var R;if(this.selection=this.getDomSelection(),this._debouncedValidate(),this.treePath&&((R=this.node&&this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0)?this._updateTreePath(R.getNodePath()):this.treePath.reset()),this.options.onChange)try{this.options.onChange()}catch(Z){console.error("Error in onChange callback: ",Z)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(Z){console.error("Error in onChangeJSON callback: ",Z)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(Z){console.error("Error in onChangeText callback: ",Z)}if(this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes(),this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(Z){console.error("Error in onNodeName callback: ",Z)}}},K.validate=function(){var R=this,Z=this.node;if(Z){var W=Z.getValue(),f=[];this.validateSchema&&!this.validateSchema(W)&&(f=this.validateSchema.errors.map(function(F){return(0,A.improveSchemaError)(F)}).map(function(F){return{node:Z.findNode(F.dataPath),error:F,type:"validation"}}).filter(function(F){return F.node!=null}));try{this.validationSequence++;var S=this,$=this.validationSequence;return this._validateCustom(W).then(function(F){return $===S.validationSequence&&(F=[].concat(f,F||[]),S._renderValidationErrors(F),typeof R.options.onValidationError=="function"&&(0,A.isValidationErrorChanged)(F,R.lastSchemaErrors)&&R.options.onValidationError.call(R,F),R.lastSchemaErrors=F),R.lastSchemaErrors})}catch(F){return Promise.reject(F)}}},K._validateAndCatch=function(){this.validate().catch(function(R){console.error("Error running validation:",R)})},K._renderValidationErrors=function(R){this.errorNodes&&this.errorNodes.forEach(function(W){W.setError(null)});var Z=R.reduce(function(W,f){return f.node.findParents().filter(function(S){return!W.some(function($){return $[0]===S})}).map(function(S){return[S,f.node]}).concat(W)},[]);this.errorNodes=Z.map(function(W){return{node:W[0],child:W[1],error:{message:W[0].type==="object"?(0,N.Iu)("containsInvalidProperties"):(0,N.Iu)("containsInvalidItems")}}}).concat(R).map(function(W){return W.node.setError(W.error,W.child),W.node})},K._validateCustom=function(R){try{var Z,W;if(this.options.onValidate)return Z=this.node,W=this.options.onValidate(R),((0,A.isPromise)(W)?W:Promise.resolve(W)).then(function(f){return Array.isArray(f)?f.filter(function(S){var $=(0,A.isValidValidationError)(S);return $||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',S),$}).map(function(S){var $;try{$=S&&S.path?Z.findNodeByPath(S.path):null}catch{}return $||console.warn("Ignoring validation error: node not found. Path:",S.path,"Error:",S),{node:$,error:S,type:"customValidation"}}).filter(function(S){return S&&S.node&&S.error&&S.error.message}):null})}catch(f){return Promise.reject(f)}return Promise.resolve(null)},K.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},K.startAutoScroll=function(R){var Z=this,W=this.scrollableContent,f=(0,A.getAbsoluteTop)(W),S=W.clientHeight,$=f+S;R<f+24&&0<W.scrollTop?this.autoScrollStep=(f+24-R)/3:$-24<R&&S+W.scrollTop<W.scrollHeight?this.autoScrollStep=($-24-R)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){Z.autoScrollStep?W.scrollTop-=Z.autoScrollStep:Z.stopAutoScroll()},50)):this.stopAutoScroll()},K.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},K.setDomSelection=function(R){var Z,W,f;R&&("scrollTop"in R&&this.scrollableContent&&(this.scrollableContent.scrollTop=R.scrollTop),R.paths?(Z=this,W=R.paths.map(function(S){return Z.node.findNodeByInternalPath(S)}),this.select(W)):(f=(W=R.path?this.node.findNodeByInternalPath(R.path):null)&&R.domName?W.dom[R.domName]:null,R.range&&f?(R=Object.assign({},R.range,{container:f}),(0,A.setSelectionOffset)(R)):W&&W.focus()))},K.getDomSelection=function(){var R=o.getNodeFromTarget(this.focusTarget),Z=this.focusTarget,W=R?Object.keys(R.dom).find(function(S){return R.dom[S]===Z}):null,f=(0,A.getSelectionOffset)();return(f=(f=f&&f.container.nodeName!=="DIV"?null:f)&&f.container!==Z?null:f)&&delete f.container,{path:R?R.getInternalPath():null,domName:W,range:f,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(S){return S.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},K.scrollTo=function(R,Z){var W,f,S,$,F=this.scrollableContent;F?((W=this).animateTimeout&&(clearTimeout(W.animateTimeout),delete W.animateTimeout),W.animateCallback&&(W.animateCallback(!1),delete W.animateCallback),f=F.clientHeight,S=F.scrollHeight-f,$=Math.min(Math.max(R-f/4,0),S),function j(){var Q=F.scrollTop,Q=$-Q;3<Math.abs(Q)?(F.scrollTop+=Q/3,W.animateCallback=Z,W.animateTimeout=setTimeout(j,50)):(Z&&Z(!0),F.scrollTop=$,delete W.animateTimeout,delete W.animateCallback)}()):Z&&Z(!1)},K._createFrame=function(){var R=this,Z=(this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame),this.contentOuter=document.createElement("div"),this.contentOuter.className="jsoneditor-outer",this);function W(j){Z._onEvent&&Z._onEvent(j)}var f,S,$,F={target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null};this.frameFocusTracker=new G.R(F),this.frame.onclick=function(j){var Q=j.target;W(j),Q.nodeName==="BUTTON"&&j.preventDefault()},this.frame.oninput=W,this.frame.onchange=W,this.frame.onkeydown=W,this.frame.onkeyup=W,this.frame.oncut=W,this.frame.onpaste=W,this.frame.onmousedown=W,this.frame.onmouseup=W,this.frame.onmouseover=W,this.frame.onmouseout=W,(0,A.addEventListener)(this.frame,"focus",W,!0),(0,A.addEventListener)(this.frame,"blur",W,!0),this.frame.onfocusin=W,this.frame.onfocusout=W,this.options.mainMenuBar&&((0,A.addClassName)(this.contentOuter,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(F=document.createElement("button")).type="button",F.className="jsoneditor-expand-all",F.title=(0,N.Iu)("expandAll"),F.onclick=function(){Z.expandAll(),typeof R.options.onExpand=="function"&&R.options.onExpand({path:[],isExpand:!0,recursive:!0})},this.menu.appendChild(F),(F=document.createElement("button")).type="button",F.title=(0,N.Iu)("collapseAll"),F.className="jsoneditor-collapse-all",F.onclick=function(){Z.collapseAll(),typeof R.options.onExpand=="function"&&R.options.onExpand({path:[],isExpand:!1,recursive:!0})},this.menu.appendChild(F),this.options.enableSort&&((F=document.createElement("button")).type="button",F.className="jsoneditor-sort",F.title=(0,N.Iu)("sortTitleShort"),F.onclick=function(){Z.node.showSortModal()},this.menu.appendChild(F)),this.options.enableTransform&&((F=document.createElement("button")).type="button",F.title=(0,N.Iu)("transformTitleShort"),F.className="jsoneditor-transform",F.onclick=function(){Z.node.showTransformModal()},this.menu.appendChild(F)),this.history&&((f=document.createElement("button")).type="button",f.className="jsoneditor-undo jsoneditor-separator",f.title=(0,N.Iu)("undo"),f.onclick=function(){Z._onUndo()},this.menu.appendChild(f),this.dom.undo=f,(S=document.createElement("button")).type="button",S.className="jsoneditor-redo",S.title=(0,N.Iu)("redo"),S.onclick=function(){Z._onRedo()},this.menu.appendChild(S),this.dom.redo=S,this.history.onChange=function(){f.disabled=!Z.history.canUndo(),S.disabled=!Z.history.canRedo()},this.history.onChange()),this.options&&this.options.modes&&this.options.modes.length&&(($=this).modeSwitcher=new L.x(this.menu,this.options.modes,this.options.mode,function(j){try{$.setMode(j),$.modeSwitcher.focus()}catch(Q){$._onError(Q)}})),this.options.search&&(this.searchBox=new E(this,this.menu))),this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new P(this.navBar,this.getPopupAnchor()),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},K._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},K._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},K._onEvent=function(R){if(!o.targetIsColorPicker(R.target)){var Z,W=o.getNodeFromTarget(R.target);if(R.type==="keydown"&&this._onKeyDown(R),W&&R.type==="focus"&&(this.focusTarget=R.target,this.options.autocomplete&&this.options.autocomplete.trigger==="focus"&&this._showAutoComplete(R.target)),R.type==="mousedown"&&this._startDragDistance(R),R.type!=="mousemove"&&R.type!=="mouseup"&&R.type!=="click"||this._updateDragDistance(R),W&&this.options&&this.options.navigationBar&&W&&(R.type==="keydown"||R.type==="mousedown")&&(Z=this,setTimeout(function(){Z._updateTreePath(W.getNodePath())})),W&&W.selected){if(R.type==="click"){if(R.target===W.dom.menu)return void this.showContextMenu(R.target);R.hasMoved||this.deselect()}R.type==="mousedown"&&o.onDragStart(this.multiselection.nodes,R)}else R.type==="mousedown"&&(0,A.hasParentNode)(R.target,this.content)&&(this.deselect(),W&&R.target===W.dom.drag?o.onDragStart(W,R):W&&(R.target===W.dom.field||R.target===W.dom.value||R.target===W.dom.select)||this._onMultiSelectStart(R));W&&W.onEvent(R)}},K._updateTreePath=function(R){var Z;function W(f){return f.parent?f.parent.type==="array"?f.index:f.field:f.field||f.type}R&&R.length?((0,A.removeClassName)(this.navBar,"nav-bar-empty"),Z=[],R.forEach(function(f){var S={name:W(f),node:f,children:[]};f.childs&&f.childs.length&&f.childs.forEach(function($){S.children.push({name:W($),node:$})}),Z.push(S)}),this.treePath.setPath(Z)):(0,A.addClassName)(this.navBar,"nav-bar-empty")},K._onTreePathSectionSelected=function(R){R&&R.node&&(R.node.expandTo(),R.node.focus())},K._onTreePathMenuItemSelected=function(R,Z){R&&R.children.length&&(R=R.children.find(function(W){return W.name===Z}))&&R.node&&(this._updateTreePath(R.node.getNodePath()),R.node.expandTo(),R.node.focus())},K._startDragDistance=function(R){this.dragDistanceEvent={initialTarget:R.target,initialPageX:R.pageX,initialPageY:R.pageY,dragDistance:0,hasMoved:!1}},K._updateDragDistance=function(R){this.dragDistanceEvent||this._startDragDistance(R);var Z=R.pageX-this.dragDistanceEvent.initialPageX,W=R.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(Z*Z+W*W),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance,R.dragDistance=this.dragDistanceEvent.dragDistance,R.hasMoved=this.dragDistanceEvent.hasMoved,R.dragDistance},K._onMultiSelectStart=function(R){var Z,W=o.getNodeFromTarget(R.target);this.options.mode==="tree"&&this.options.onEditable===void 0&&(this.multiselection={start:W||null,end:null,nodes:[]},this._startDragDistance(R),(Z=this).mousemove||(this.mousemove=(0,A.addEventListener)(R.view,"mousemove",function(f){Z._onMultiSelect(f)})),this.mouseup||(this.mouseup=(0,A.addEventListener)(R.view,"mouseup",function(f){Z._onMultiSelectEnd(f)})),R.preventDefault())},K._onMultiSelect=function(R){var Z;R.preventDefault(),this._updateDragDistance(R),R.hasMoved&&((R=o.getNodeFromTarget(R.target))&&(this.multiselection.start==null&&(this.multiselection.start=R),this.multiselection.end=R),this.deselect(),R=this.multiselection.start,Z=this.multiselection.end||this.multiselection.start,R&&Z&&(this.multiselection.nodes=this._findTopLevelNodes(R,Z),this.multiselection.nodes&&this.multiselection.nodes.length&&(R=this.multiselection.nodes[0],this.multiselection.start===R||this.multiselection.start.isDescendantOf(R)?this.multiselection.direction="down":this.multiselection.direction="up"),this.select(this.multiselection.nodes)))},K._onMultiSelectEnd=function(R){var Z=this.multiselection.nodes[0];Z&&Z.dom.menu&&Z.dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&((0,A.removeEventListener)(R.view,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&((0,A.removeEventListener)(R.view,"mouseup",this.mouseup),delete this.mouseup)},K.deselect=function(R){var Z=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(W){W.setSelected(!1)}),this.multiselection.nodes=[],R&&(this.multiselection.start=null,this.multiselection.end=null),Z&&this._selectionChangedHandler&&this._selectionChangedHandler()},K.select=function(R){if(!Array.isArray(R))return this.select([R]);var Z;R&&(this.deselect(),this.multiselection.nodes=R.slice(0),Z=R[0],R.forEach(function(W){W.expandPathToNode(),W.setSelected(!0,W===Z)}),this._selectionChangedHandler&&(R=this.getSelection(),this._selectionChangedHandler(R.start,R.end)))},K._findTopLevelNodes=function(F,j){for(var W=F.getNodePath(),f=j.getNodePath(),S=0;S<W.length&&W[S]===f[S];)S++;var $,F=W[S-1],j=W[S],Q=f[S];return j&&Q||(F.parent?F=(Q=j=F).parent:(j=F.childs[0],Q=F.childs[F.childs.length-1])),F&&j&&Q?(j=F.childs.indexOf(j),Q=F.childs.indexOf(Q),$=Math.min(j,Q),j=Math.max(j,Q),F.childs.slice($,j+1)):[]},K._showAutoComplete=function(R){var Z,W=o.getNodeFromTarget(R),f="";0<=R.className.indexOf("jsoneditor-value")&&(f="value"),(f=0<=R.className.indexOf("jsoneditor-field")?"field":f)!==""&&(Z=this,setTimeout(function(){var S;!W||!(Z.options.autocomplete.trigger==="focus"||0<R.innerText.length)||(S=Z.options.autocomplete.getOptions(R.innerText,W.getPath(),f,W.editor))===null?Z.autocomplete.hideDropDown():typeof S.then=="function"?S.then(function($){$===null?Z.autocomplete.hideDropDown():$.options?Z.autocomplete.show(R,$.startFrom,$.options):Z.autocomplete.show(R,0,$)}).catch(function($){console.error($)}):S.options?Z.autocomplete.show(R,S.startFrom,S.options):Z.autocomplete.show(R,0,S)},50))},K._onKeyDown=function(R){var Z,W=R.which||R.keyCode,f=R.altKey,S=R.ctrlKey,$=R.metaKey,F=R.shiftKey,j=!1,Q=this.focusTarget;W===9&&(Z=this,setTimeout(function(){Z.focusTarget!==Q&&(0,A.selectContentEditable)(Z.focusTarget)},0)),this.searchBox&&(S&&W===70?(this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),j=!0):(W===114||S&&W===71)&&(F?this.searchBox.previous(!0):this.searchBox.next(!0),j=!0)),this.history&&(S&&!F&&W===90?(this._onUndo(),j=!0):S&&F&&W===90&&(this._onRedo(),j=!0)),!this.options.autocomplete||j||S||f||$||R.key.length!==1&&W!==8&&W!==46||(j=!1,this._showAutoComplete(R.target)),j&&(R.preventDefault(),R.stopPropagation())},K._createTable=function(){var R;this.options.navigationBar&&(0,A.addClassName)(this.contentOuter,"has-nav-bar"),this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",this.contentOuter.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table),this.colgroupContent=document.createElement("colgroup"),this.options.mode==="tree"&&((R=document.createElement("col")).width="24px",this.colgroupContent.appendChild(R)),(R=document.createElement("col")).width="24px",this.colgroupContent.appendChild(R),R=document.createElement("col"),this.colgroupContent.appendChild(R),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(this.contentOuter)},K.showContextMenu=function(R,Z){var W,f=[],S=this.multiselection.nodes.slice();f.push({text:(0,N.Iu)("duplicateText"),title:(0,N.Iu)("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){o.onDuplicate(S)}}),f.push({text:(0,N.Iu)("remove"),title:(0,N.Iu)("removeTitle"),className:"jsoneditor-remove",click:function(){o.onRemove(S)}}),this.options.onCreateMenu&&(W=S.map(function($){return $.getPath()}),f=this.options.onCreateMenu(f,{type:"multiple",path:W[0],paths:W})),new k.x(f,{close:Z}).show(R,this.getPopupAnchor())},K.getPopupAnchor=function(){return this.options.popupAnchor||this.frame},K.getSelection=function(){var R,Z,W={start:null,end:null};return this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length&&(R=this.multiselection.nodes[0],Z=this.multiselection.nodes[this.multiselection.nodes.length-1],this.multiselection.direction==="down"?(W.start=R.serialize(),W.end=Z.serialize()):(W.start=Z.serialize(),W.end=R.serialize())),W},K.onSelectionChange=function(R){typeof R=="function"&&(this._selectionChangedHandler=(0,A.debounce)(R,this.DEBOUNCE_INTERVAL))},K.setSelection=function(R,Z){R&&R.dom&&R.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(R)),R=this._getNodeInstancesByRange(R,Z),R.forEach(function(W){W.expandTo()}),this.select(R)},K._getNodeInstancesByRange=function(R,Z){R&&R.path&&(W=this.node.findNodeByPath(R.path),Z&&Z.path&&(f=this.node.findNodeByPath(Z.path)));var W,f,S=[];if(W instanceof o)if(f instanceof o&&f!==W)if(W.parent===f.parent){Z=W.getIndex()<f.getIndex()?(R=W,f):(R=f,W);var $=R;for(S.push($);$=$.nextSibling(),S.push($),$&&$!==Z;);}else S=this._findTopLevelNodes(W,f);else S.push(W);return S},K.getNodesByRange=function(W,Z){var W=this._getNodeInstancesByRange(W,Z),f=[];return W.forEach(function(S){f.push(S.serialize())}),f},[{mode:"tree",mixin:K,data:"json"},{mode:"view",mixin:K,data:"json"},{mode:"form",mixin:K,data:"json"}])},2744:function(ie,g,V){g.tryRequireAjv=function(){try{return V(8903)}catch{}}},9125:function(ie,g,V){g.O=function(){try{V(4864)}catch(X){console.error(X)}}},9791:function(ie,k,V){V.r(k),V.d(k,{addClassName:function(){return b},addEventListener:function(){return R},asyncExec:function(){return je},clear:function(){return i},compileJSONPointer:function(){return Ce},contains:function(){return Ge},debounce:function(){return te},escapeUnicodeChars:function(){return a},extend:function(){return n},findUniqueName:function(){return de},formatSize:function(){return me},get:function(){return we},getAbsoluteLeft:function(){return c},getAbsoluteTop:function(){return d},getChildPaths:function(){return Te},getColorCSS:function(){return Ae},getIndexForPosition:function(){return ue},getInnerText:function(){return _},getInputSelection:function(){return ve},getInternetExplorerVersion:function(){return z},getPositionForPath:function(){return fe},getSelection:function(){return v},getSelectionOffset:function(){return B},getType:function(){return t},getWindow:function(){return o},hasParentNode:function(){return H},improveSchemaError:function(){return $},insideRect:function(){return Q},isArray:function(){return s},isChildOf:function(){return W},isFirefox:function(){return Y},isObject:function(){return xe},isPromise:function(){return F},isTimestamp:function(){return ce},isUrl:function(){return r},isValidColor:function(){return Ee},isValidValidationError:function(){return j},isValidationErrorChanged:function(){return De},limitCharacters:function(){return Ie},makeFieldTooltip:function(){return Re},parse:function(){return x},parsePath:function(){return f},parseString:function(){return le},removeAllClassNames:function(){return I},removeClassName:function(){return h},removeEventListener:function(){return Z},removeReturnsAndSurroundingWhitespace:function(){return P},selectContentEditable:function(){return w},setEndOfContentEditable:function(){return y},setSelection:function(){return T},setSelectionOffset:function(){return E},sort:function(){return ae},sortObjectKeys:function(){return ge},stringifyPath:function(){return S},stripFormatting:function(){return u},textDiff:function(){return he},tryJsonRepair:function(){return p},uniqueMergeArrays:function(){return We},validate:function(){return l}}),V(4987);var k=V(233),X=V.n(k),k=V(3860),G=V.n(k),O=V(6589),D=V(7026),N=V(7907);function M(J){return function(ne){if(Array.isArray(ne))return L(ne)}(J)||function(ne){if(typeof Symbol<"u"&&ne[Symbol.iterator]!=null||ne["@@iterator"]!=null)return Array.from(ne)}(J)||function(ne,oe){var pe;if(ne)return typeof ne=="string"?L(ne,oe):(pe=(pe=Object.prototype.toString.call(ne).slice(8,-1))==="Object"&&ne.constructor?ne.constructor.name:pe)==="Map"||pe==="Set"?Array.from(ne):pe==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(pe)?L(ne,oe):void 0}(J)||function(){throw new TypeError(`Invalid attempt to spread non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}()}function L(J,ne){(ne==null||ne>J.length)&&(ne=J.length);for(var oe=0,pe=new Array(ne);oe<ne;oe++)pe[oe]=J[oe];return pe}function C(J){return(C=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(ne){return typeof ne}:function(ne){return ne&&typeof Symbol=="function"&&ne.constructor===Symbol&&ne!==Symbol.prototype?"symbol":typeof ne})(J)}var m=1e4,A=9466848e5;function x(J){try{return JSON.parse(J)}catch(ne){throw l(J),ne}}function p(J){try{return G()(J)}catch{return J}}function a(J){return J.replace(/[\u007F-\uFFFF]/g,function(ne){return"\\u"+("0000"+ne.charCodeAt(0).toString(16)).slice(-4)})}function l(J){(O!==void 0?O:JSON).parse(J)}function n(J,ne){for(var oe in ne)at(ne,oe)&&(J[oe]=ne[oe]);return J}function i(J){for(var ne in J)at(J,ne)&&delete J[ne];return J}function t(J){return J===null?"null":J===void 0?"undefined":J instanceof Number||typeof J=="number"?"number":J instanceof String||typeof J=="string"?"string":J instanceof Boolean||typeof J=="boolean"?"boolean":J instanceof RegExp?"regexp":s(J)?"array":"object"}var e=/^https?:\/\/\S+$/;function r(J){return(typeof J=="string"||J instanceof String)&&e.test(J)}function s(J){return Object.prototype.toString.call(J)==="[object Array]"}function o(J){return J.ownerDocument.defaultView}function c(J){return J.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0}function d(J){return J.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0}function b(J,ne){var oe=J.className.split(" ");oe.indexOf(ne)===-1&&(oe.push(ne),J.className=oe.join(" "))}function I(J){J.className=""}function h(J,pe){var oe=J.className.split(" "),pe=oe.indexOf(pe);pe!==-1&&(oe.splice(pe,1),J.className=oe.join(" "))}function u(J){for(var ne=J.childNodes,oe=0,pe=ne.length;oe<pe;oe++){var ye=ne[oe],be=(ye.style&&ye.removeAttribute("style"),ye.attributes);if(be)for(var Le=be.length-1;0<=Le;Le--){var He=be[Le];He.specified===!0&&ye.removeAttribute(He.name)}u(ye)}}function y(J){var ne;document.createRange&&((ne=document.createRange()).selectNodeContents(J),ne.collapse(!1),(J=window.getSelection()).removeAllRanges(),J.addRange(ne))}function w(J){var ne;J&&J.nodeName==="DIV"&&window.getSelection&&document.createRange&&((ne=document.createRange()).selectNodeContents(J),(J=window.getSelection()).removeAllRanges(),J.addRange(ne))}function v(){if(window.getSelection){var J=window.getSelection();if(J.getRangeAt&&J.rangeCount)return J.getRangeAt(0)}return null}function T(J){var ne;J&&window.getSelection&&((ne=window.getSelection()).removeAllRanges(),ne.addRange(J))}function B(){var J=v();return J&&"startOffset"in J&&"endOffset"in J&&J.startContainer&&J.startContainer===J.endContainer?{startOffset:J.startOffset,endOffset:J.endOffset,container:J.startContainer.parentNode}:null}function E(J){var ne;document.createRange&&window.getSelection&&window.getSelection()&&(ne=document.createRange(),J.container.firstChild||J.container.appendChild(document.createTextNode("")),ne.setStart(J.container.firstChild,J.startOffset),ne.setEnd(J.container.firstChild,J.endOffset),T(ne))}function _(J,ne){var oe;if(ne===void 0&&(ne={_text:"",flush:function(){var Qe=this._text;return this._text="",Qe},set:function(Qe){this._text=Qe}}),J.nodeValue)return(oe=P(J.nodeValue))!==""?ne.flush()+oe:"";if(J.hasChildNodes()){for(var pe=J.childNodes,ye="",be=0,Le=pe.length;be<Le;be++){var He,Ke=pe[be];Ke.nodeName==="DIV"||Ke.nodeName==="P"?((He=(He=pe[be-1])?He.nodeName:void 0)&&He!=="DIV"&&He!=="P"&&He!=="BR"&&(ye!==""&&(ye+=`
`),ne.flush()),ye+=_(Ke,ne),ne.set(`
`)):Ke.nodeName==="BR"?(ye+=ne.flush(),ne.set(`
`)):ye+=_(Ke,ne)}return ye}return""}function P(J){return J.replace(/(\b|^)\s*(\b|$)/g,function(ne){return/\n/.exec(ne)?"":ne})}function H(J,ne){for(var oe=J?J.parentNode:void 0;oe;){if(oe===ne)return!0;oe=oe.parentNode}return!1}function z(){var J;return K===-1&&(J=-1,typeof navigator<"u"&&navigator.appName==="Microsoft Internet Explorer"&&/MSIE ([0-9]+[.0-9]+)/.exec(navigator.userAgent)!=null&&(J=parseFloat(RegExp.$1)),K=J),K}var K=-1;function Y(){return typeof navigator<"u"&&navigator.userAgent.indexOf("Firefox")!==-1}function R(J,ne,oe,pe){return J.addEventListener?(pe===void 0&&(pe=!1),ne==="mousewheel"&&Y()&&(ne="DOMMouseScroll"),J.addEventListener(ne,oe,pe),oe):J.attachEvent?(J.attachEvent("on"+ne,pe=function(){return oe.call(J,window.event)}),pe):void 0}function Z(J,ne,oe,pe){J.removeEventListener?(pe===void 0&&(pe=!1),ne==="mousewheel"&&Y()&&(ne="DOMMouseScroll"),J.removeEventListener(ne,oe,pe)):J.detachEvent&&J.detachEvent("on"+ne,oe)}function W(J,ne){for(var oe=J.parentNode;oe;){if(oe===ne)return!0;oe=oe.parentNode}return!1}function f(J){var ne=[],oe=0;function pe(be){for(var Le="";J[oe]!==void 0&&J[oe]!==be;)Le+=J[oe],oe++;if(J[oe]!==be)throw new Error("Invalid JSON path: unexpected end, character "+be+" expected");return Le}for(;J[oe]!==void 0;)if(J[oe]===".")oe++,ne.push(function(){for(var be="";J[oe]!==void 0&&/[\w$]/.test(J[oe]);)be+=J[oe],oe++;if(be==="")throw new Error("Invalid JSON path: property name expected at index "+oe);return be}());else{if(J[oe]!=="[")throw new Error('Invalid JSON path: unexpected character "'+J[oe]+'" at index '+oe);if(J[++oe]==="'"||J[oe]==='"'){var ye=J[oe];if(oe++,ne.push(pe(ye)),J[oe]!==ye)throw new Error("Invalid JSON path: closing quote ' expected at index "+oe);oe++}else{if(ye=pe("]").trim(),ye.length===0)throw new Error("Invalid JSON path: array value expected at index "+oe);ye=ye==="*"?ye:JSON.parse(ye),ne.push(ye)}if(J[oe]!=="]")throw new Error("Invalid JSON path: closing bracket ] expected at index "+oe);oe++}return ne}function S(J){return J.map(function(ne){return typeof ne=="number"?"["+ne+"]":typeof ne=="string"&&ne.match(/^[A-Za-z0-9_$]+$/)?"."+ne:'["'+ne+'"]'}).join("")}function $(J){var ne,oe;return J.keyword==="enum"&&Array.isArray(J.schema)&&(oe=J.schema)&&(5<(oe=oe.map(function(pe){return JSON.stringify(pe)})).length&&(ne=["("+(oe.length-5)+" more...)"],(oe=oe.slice(0,5)).push(ne)),J.message="should be equal to one of: "+oe.join(", ")),J.keyword==="additionalProperties"&&(J.message="should NOT have additional property: "+J.params.additionalProperty),J}function F(J){return J&&typeof J.then=="function"&&typeof J.catch=="function"}function j(J){return C(J)==="object"&&Array.isArray(J.path)&&typeof J.message=="string"}function Q(J,ne,oe){return oe=oe!==void 0?oe:0,ne.left-oe>=J.left&&ne.right+oe<=J.right&&ne.top-oe>=J.top&&ne.bottom+oe<=J.bottom}function te(J,ne,oe){var pe;return function(){var ye=this,be=arguments,Le=oe&&!pe;clearTimeout(pe),pe=setTimeout(function(){pe=null,oe||J.apply(ye,be)},ne),Le&&J.apply(ye,be)}}function he(J,ne){for(var oe=ne.length,pe=0,ye=J.length,be=ne.length;ne.charAt(pe)===J.charAt(pe)&&pe<oe;)pe++;for(;ne.charAt(be-1)===J.charAt(ye-1)&&pe<be&&0<ye;)be--,ye--;return{start:pe,end:be}}function ve(J){var ne,oe,pe,ye,be=0,Le=0;return typeof J.selectionStart=="number"&&typeof J.selectionEnd=="number"?(be=J.selectionStart,Le=J.selectionEnd):(ye=document.selection.createRange())&&ye.parentElement()===J&&(pe=J.value.length,ne=J.value.replace(/\r\n/g,`
`),(oe=J.createTextRange()).moveToBookmark(ye.getBookmark()),(ye=J.createTextRange()).collapse(!1),-1<oe.compareEndPoints("StartToEnd",ye)?be=Le=pe:(be=-oe.moveStart("character",-pe),be+=ne.slice(0,be).split(`
`).length-1,-1<oe.compareEndPoints("EndToEnd",ye)?Le=pe:(Le=-oe.moveEnd("character",-pe),Le+=ne.slice(0,Le).split(`
`).length-1))),{startIndex:be,endIndex:Le,start:He(be),end:He(Le)};function He(Ke){return Ke=J.value.substring(0,Ke),{row:(Ke.match(/\n/g)||[]).length+1,column:Ke.length-Ke.lastIndexOf(`
`)}}}function ue(pe,ne,oe){var pe=pe.value||"";return 0<ne&&0<oe?(pe=pe.split(`
`,ne),ne=Math.min(pe.length,ne),oe=Math.min(pe[ne-1].length,oe-1),oe=ne===1?oe:oe+1,pe.slice(0,ne-1).join(`
`).length+oe):-1}function fe(J,ne){var oe,pe=[];if(ne&&ne.length){try{oe=D.parse(J)}catch{return pe}ne.forEach(function(ye){var be=Ce(f(ye)),be=oe.pointers[be];be&&pe.push({path:ye,line:be.key?be.key.line:be.value?be.value.line:0,column:be.key?be.key.column:be.value?be.value.column:0})})}return pe}function Ce(J){return J.map(function(ne){return"/"+String(ne).replace(/~/g,"~0").replace(/\//g,"~1")}).join("")}function Ae(J){var ne=document.createElement("div");return ne.style.color=J,ne.style.color.split(/\s+/).join("").toLowerCase()||null}function Ee(J){return!!Ae(J)}function Re(J,ne){var oe;return J?(oe="",J.title&&(oe+=J.title),J.description&&(0<oe.length&&(oe+=`
`),oe+=J.description),J.default&&(0<oe.length&&(oe+=`

`),oe=(oe+=(0,N.Iu)("default",void 0,ne)+`
`)+JSON.stringify(J.default,null,2)),Array.isArray(J.examples)&&0<J.examples.length&&(0<oe.length&&(oe+=`

`),oe+=(0,N.Iu)("examples",void 0,ne)+`
`,J.examples.forEach(function(pe,ye){oe+=JSON.stringify(pe,null,2),ye!==J.examples.length-1&&(oe+=`
`)})),oe):""}function we(J,ne){for(var oe=J,pe=0;pe<ne.length&&oe!=null;pe++)oe=oe[ne[pe]];return oe}function de(J,ne){for(var oe=J.replace(/ \(copy( \d+)?\)$/,""),pe=oe,ye=1;ne.indexOf(pe)!==-1;)pe=oe+" ("+("copy"+(1<ye?" "+ye:""))+")",ye++;return pe}function Te(J,ne){var oe={};if(Array.isArray(J))for(var pe=Math.min(J.length,m),ye=0;ye<pe;ye++)(function be(Le,He,Ke,Qe){(Array.isArray(Le)||xe(Le))&&!Qe||(He[Ke||""]=!0),xe(Le)&&Object.keys(Le).forEach(function(q){be(Le[q],He,Ke+"."+q,Qe)})})(J[ye],oe,"",ne);else oe[""]=!0;return Object.keys(oe).sort()}function ae(J,be,oe){var pe=be&&be!=="."?f(be):[],ye=oe==="desc"?-1:1,be=J.slice();return be.sort(function(Le,He){return Le=we(Le,pe),He=we(He,pe),ye*(He<Le?1:Le<He?-1:0)}),be}function ge(J,pe){var oe=pe==="desc"?-1:1,pe=Object.keys(J).sort(function(be,Le){return oe*X()(be,Le)}),ye={};return pe.forEach(function(be){ye[be]=J[be]}),ye}function le(J){var ne,oe;return J===""?"":(ne=J.toLowerCase())==="null"?null:ne==="true"||ne!=="false"&&(ne=Number(J),oe=parseFloat(J),isNaN(ne)||isNaN(oe)?J:ne)}function ce(J,ne){return typeof ne=="number"&&A<ne&&isFinite(ne)&&Math.floor(ne)===ne&&!isNaN(new Date(ne).valueOf())}function me(J){return J<900?J.toFixed()+" B":(J=J/1e3)<900?J.toFixed(1)+" KB":(J=J/1e3)<900?J.toFixed(1)+" MB":(J=J/1e3)<900?J.toFixed(1)+" GB":(J/1e3).toFixed(1)+" TB"}function Ie(J,ne){return J.length<=ne?J:J.slice(0,ne)+"..."}function xe(J){return C(J)==="object"&&J!==null&&!Array.isArray(J)}function Ge(J,ne){return J.indexOf(ne)!==-1}function De(J,ne){if(ne||J){if(ne&&!J||!ne&&J||ne.length!==J.length)return!0;for(var oe=0;oe<J.length;++oe){var pe=function(ye){if(!(J[ye].type==="error"?ne.find(function(be){return be.line===J[ye].line}):ne.find(function(be){return be.dataPath===J[ye].dataPath&&be.schemaPath===J[ye].schemaPath})))return{v:!0}}(oe);if(C(pe)==="object")return pe.v}}return!1}function We(J,ne){return J=J!=null&&J.length?J:[],ne=ne!=null&&ne.length?ne:[],M(new Set(J.concat(ne)))}function je(J){setTimeout(J)}function at(J,ne){return Object.prototype.hasOwnProperty.call(J,ne)}},8037:function(ie,g,V){var X;if(window.Picker)X=window.Picker;else try{X=V(4049)}catch{}ie.exports=X},6225:function(ie,g,V){function X(C,m){var A,x;return m=L(C,m),(C=D.modules[m])||(typeof(C=D.payloads[m])=="function"&&(A={id:m,uri:"",exports:x={},packaged:!0},x=C(function(p,a){return N(m,p,a)},x,A)||A.exports,D.modules[m]=x,delete D.payloads[m]),C=D.modules[m]=x||C),C}var k,G,O,D,N,M,L;ie=V.nmd(ie),(O=function(){return this}())||typeof window>"u"||(O=window),(D=function(C,m,A){typeof C!="string"?D.original?D.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace()):(arguments.length==2&&(A=m),D.modules[C]||(D.payloads[C]=A,D.modules[C]=null))}).modules={},D.payloads={},N=function(C,m,A){if(typeof m=="string"){var x=X(C,m);if(x!=null)return A&&A(),x}else if(Object.prototype.toString.call(m)==="[object Array]"){for(var p=[],a=0,l=m.length;a<l;++a){var n=X(C,m[a]);if(n==null&&M.original)return;p.push(n)}return A&&A.apply(null,p)||!0}},M=function(C,m){var A=N("",C,m);return A==null&&M.original?M.original.apply(this,arguments):A},L=function(C,m){var A;if(m.indexOf("!")!==-1)return A=m.split("!"),L(C,A[0])+"!"+L(C,A[1]);if(m.charAt(0)==".")for(m=C.split("/").slice(0,-1).join("/")+"/"+m;m.indexOf(".")!==-1&&x!=m;){var x=m;m=m.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}return m},G=O,(k="ace")&&(O[k]||(O[k]={}),G=O[k]),G.define&&G.define.packaged||(D.original=G.define,G.define=D,G.define.packaged=!0),G.require&&G.require.packaged||(M.original=G.require,G.require=M,G.require.packaged=!0),ace.define("ace/lib/es6-shim",["require","exports","module"],function(C,m,A){function x(p,a,l){Object.defineProperty(p,a,{value:l,enumerable:!1,writable:!0,configurable:!0})}String.prototype.startsWith||x(String.prototype,"startsWith",function(p,a){return this.lastIndexOf(p,a=a||0)===a}),String.prototype.endsWith||x(String.prototype,"endsWith",function(p,a){return(a===void 0||a>this.length)&&(a=this.length),a-=p.length,p=this.indexOf(p,a),p!==-1&&p===a}),String.prototype.repeat||x(String.prototype,"repeat",function(p){for(var a="",l=this;0<p;)1&p&&(a+=l),(p>>=1)&&(l+=l);return a}),String.prototype.includes||x(String.prototype,"includes",function(p,a){return this.indexOf(p,a)!=-1}),Object.assign||(Object.assign=function(p){if(p==null)throw new TypeError("Cannot convert undefined or null to object");for(var a=Object(p),l=1;l<arguments.length;l++){var n=arguments[l];n!=null&&Object.keys(n).forEach(function(i){a[i]=n[i]})}return a}),Object.values||(Object.values=function(p){return Object.keys(p).map(function(a){return p[a]})}),Array.prototype.find||x(Array.prototype,"find",function(p){for(var a=this.length,l=arguments[1],n=0;n<a;n++){var i=this[n];if(p.call(l,i,n,this))return i}}),Array.prototype.findIndex||x(Array.prototype,"findIndex",function(p){for(var a=this.length,l=arguments[1],n=0;n<a;n++){var i=this[n];if(p.call(l,i,n,this))return n}}),Array.prototype.includes||x(Array.prototype,"includes",function(p,a){return this.indexOf(p,a)!=-1}),Array.prototype.fill||x(Array.prototype,"fill",function(p){for(var a=this.length>>>0,n=arguments[1]>>0,l=n<0?Math.max(a+n,0):Math.min(n,a),n=arguments[2],n=n===void 0?a:n>>0,i=n<0?Math.max(a+n,0):Math.min(n,a);l<i;)this[l]=p,l++;return this}),Array.of||x(Array,"of",function(){return Array.prototype.slice.call(arguments)})}),ace.define("ace/lib/fixoldbrowsers",["require","exports","module","ace/lib/es6-shim"],function(C,m,A){C("./es6-shim")}),ace.define("ace/lib/lang",["require","exports","module"],function(C,m,A){m.last=function(a){return a[a.length-1]},m.stringReverse=function(a){return a.split("").reverse().join("")},m.stringRepeat=function(a,l){for(var n="";0<l;)1&l&&(n+=a),(l>>=1)&&(a+=a);return n};var x=/^\s\s*/,p=/\s\s*$/;m.stringTrimLeft=function(a){return a.replace(x,"")},m.stringTrimRight=function(a){return a.replace(p,"")},m.copyObject=function(a){var l,n={};for(l in a)n[l]=a[l];return n},m.copyArray=function(a){for(var l=[],n=0,i=a.length;n<i;n++)a[n]&&typeof a[n]=="object"?l[n]=this.copyObject(a[n]):l[n]=a[n];return l},m.deepCopy=function a(l){if(typeof l!="object"||!l)return l;if(Array.isArray(l))for(var n=[],i=0;i<l.length;i++)n[i]=a(l[i]);else{if(Object.prototype.toString.call(l)!=="[object Object]")return l;for(var i in n={},l)n[i]=a(l[i])}return n},m.arrayToMap=function(a){for(var l={},n=0;n<a.length;n++)l[a[n]]=1;return l},m.createMap=function(a){var l,n=Object.create(null);for(l in a)n[l]=a[l];return n},m.arrayRemove=function(a,l){for(var n=0;n<=a.length;n++)l===a[n]&&a.splice(n,1)},m.escapeRegExp=function(a){return a.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},m.escapeHTML=function(a){return(""+a).replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},m.getMatchOffsets=function(a,l){var n=[];return a.replace(l,function(i){n.push({offset:arguments[arguments.length-2],length:i.length})}),n},m.deferredCall=function(a){function l(){i=null,a()}function n(t){return n.cancel(),i=setTimeout(l,t||0),n}var i=null;return(n.schedule=n).call=function(){return this.cancel(),a(),n},n.cancel=function(){return clearTimeout(i),i=null,n},n.isPending=function(){return i},n},m.delayedCall=function(a,l){function n(){t=null,a()}function i(e){t==null&&(t=setTimeout(n,e||l))}var t=null;return i.delay=function(e){t&&clearTimeout(t),t=setTimeout(n,e||l)},(i.schedule=i).call=function(){this.cancel(),a()},i.cancel=function(){t&&clearTimeout(t),t=null},i.isPending=function(){return t},i}}),ace.define("ace/lib/oop",["require","exports","module"],function(C,m,A){m.inherits=function(x,p){x.super_=p,x.prototype=Object.create(p.prototype,{constructor:{value:x,enumerable:!1,writable:!0,configurable:!0}})},m.mixin=function(x,p){for(var a in p)x[a]=p[a];return x},m.implement=function(x,p){m.mixin(x,p)}}),ace.define("ace/lib/useragent",["require","exports","module"],function(C,m,A){m.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},m.getOS=function(){return m.isMac?m.OS.MAC:m.isLinux?m.OS.LINUX:m.OS.WINDOWS};var a=typeof navigator=="object"?navigator:{},x=(/mac|win|linux/i.exec(a.platform)||["other"])[0].toLowerCase(),p=a.userAgent||"",a=a.appName||"";m.isWin=x=="win",m.isMac=x=="mac",m.isLinux=x=="linux",m.isIE=a=="Microsoft Internet Explorer"||0<=a.indexOf("MSAppHost")?parseFloat((p.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((p.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),m.isOldIE=m.isIE&&m.isIE<9,m.isGecko=m.isMozilla=p.match(/ Gecko\/\d+/),m.isOpera=typeof opera=="object"&&Object.prototype.toString.call(window.opera)=="[object Opera]",m.isWebKit=parseFloat(p.split("WebKit/")[1])||void 0,m.isChrome=parseFloat(p.split(" Chrome/")[1])||void 0,m.isEdge=parseFloat(p.split(" Edge/")[1])||void 0,m.isAIR=0<=p.indexOf("AdobeAIR"),m.isAndroid=0<=p.indexOf("Android"),m.isChromeOS=0<=p.indexOf(" CrOS "),m.isIOS=/iPad|iPhone|iPod/.test(p)&&!window.MSStream,m.isIOS&&(m.isMac=!0),m.isMobile=m.isIOS||m.isAndroid}),ace.define("ace/lib/dom",["require","exports","module","ace/lib/useragent"],function(a,m,A){var x,p,a=a("./useragent"),l=(m.buildDom=function t(e,r,s){if(typeof e=="string"&&e)return h=document.createTextNode(e),r&&r.appendChild(h),h;if(!Array.isArray(e))return e&&e.appendChild&&r&&r.appendChild(e),e;if(typeof e[0]!="string"||!e[0]){for(var o=[],c=0;c<e.length;c++){var d=t(e[c],r,s);d&&o.push(d)}return o}for(var b=document.createElement(e[0]),I=e[1],h=1,c=h=I&&typeof I=="object"&&!Array.isArray(I)?2:h;c<e.length;c++)t(e[c],b,s);return h==2&&Object.keys(I).forEach(function(u){var y=I[u];u==="class"?b.className=Array.isArray(y)?y.join(" "):y:typeof y=="function"||u=="value"||u[0]=="$"?b[u]=y:u==="ref"?s&&(s[y]=b):u==="style"?typeof y=="string"&&(b.style.cssText=y):y!=null&&b.setAttribute(u,y)}),r&&r.appendChild(b),b},m.getDocumentHead=function(t){return(t=t||document).head||t.getElementsByTagName("head")[0]||t.documentElement},m.createElement=function(t,e){return document.createElementNS?document.createElementNS(e||"http://www.w3.org/1999/xhtml",t):document.createElement(t)},m.removeChildren=function(t){t.innerHTML=""},m.createTextNode=function(t,e){return(e?e.ownerDocument:document).createTextNode(t)},m.createFragment=function(t){return(t?t.ownerDocument:document).createDocumentFragment()},m.hasCssClass=function(t,e){return(t.className+"").split(/\s+/g).indexOf(e)!==-1},m.addCssClass=function(t,e){m.hasCssClass(t,e)||(t.className+=" "+e)},m.removeCssClass=function(t,e){for(var r=t.className.split(/\s+/g);;){var s=r.indexOf(e);if(s==-1)break;r.splice(s,1)}t.className=r.join(" ")},m.toggleCssClass=function(t,e){for(var r=t.className.split(/\s+/g),s=!0;;){var o=r.indexOf(e);if(o==-1)break;s=!1,r.splice(o,1)}return s&&r.push(e),t.className=r.join(" "),s},m.setCssClass=function(t,e,r){r?m.addCssClass(t,e):m.removeCssClass(t,e)},m.hasCssString=function(t,e){var r,s=0;if(r=(e=e||document).querySelectorAll("style")){for(;s<r.length;)if(r[s++].id===t)return!0}},m.removeElementById=function(t,e){(e=e||document).getElementById(t)&&e.getElementById(t).remove()},[]);function n(){var t=l;l=null,t&&t.forEach(function(e){i(e[0],e[1])})}function i(t,e,r){if(typeof document<"u"){if(l){if(r)n();else if(r===!1)return l.push([t,e])}if(!x){var s=r,r=(s=r&&r.getRootNode&&(s=r.getRootNode())&&s!=r?s:document).ownerDocument||s;if(e&&m.hasCssString(e,s))return null;e&&(t+=`
/*# sourceURL=ace/css/`+e+" */");var o=m.createElement("style");o.appendChild(r.createTextNode(t)),e&&(o.id=e),(s=s==r?m.getDocumentHead(r):s).insertBefore(o,s.firstChild)}}}m.useStrictCSP=function(t){(x=t)==0?n():l=l||[]},m.importCssString=i,m.importCssStylsheet=function(t,e){m.buildDom(["link",{rel:"stylesheet",href:t}],m.getDocumentHead(e))},m.scrollbarWidth=function(s){var e=m.createElement("ace_inner"),r=(e.style.width="100%",e.style.minWidth="0px",e.style.height="200px",e.style.display="block",m.createElement("ace_outer")),c=r.style,s=(c.position="absolute",c.left="-10000px",c.overflow="hidden",c.width="200px",c.minWidth="0px",c.height="150px",c.display="block",r.appendChild(e),s.documentElement),o=(s.appendChild(r),e.offsetWidth),c=(c.overflow="scroll",e.offsetWidth);return o==c&&(c=r.clientWidth),s.removeChild(r),o-c},m.computedStyle=function(t,e){return window.getComputedStyle(t,"")||{}},m.setStyle=function(t,e,r){t[e]!==r&&(t[e]=r)},m.HAS_CSS_ANIMATION=!1,m.HAS_CSS_TRANSFORMS=!1,m.HI_DPI=!a.isWin||typeof window<"u"&&1.5<=window.devicePixelRatio,a.isChromeOS&&(m.HI_DPI=!1),typeof document<"u"&&(p=document.createElement("div"),m.HI_DPI&&p.style.transform!==void 0&&(m.HAS_CSS_TRANSFORMS=!0),a.isEdge||p.style.animationName===void 0||(m.HAS_CSS_ANIMATION=!0),p=null),m.HAS_CSS_TRANSFORMS?m.translate=function(t,e,r){t.style.transform="translate("+Math.round(e)+"px, "+Math.round(r)+"px)"}:m.translate=function(t,e,r){t.style.top=Math.round(r)+"px",t.style.left=Math.round(e)+"px"}}),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],function(C,m,A){var x=C("./dom");m.get=function(p,a){var l=new XMLHttpRequest;l.open("GET",p,!0),l.onreadystatechange=function(){l.readyState===4&&a(l.responseText)},l.send(null)},m.loadScript=function(p,a){var l=x.getDocumentHead(),n=document.createElement("script");n.src=p,l.appendChild(n),n.onload=n.onreadystatechange=function(i,t){!t&&n.readyState&&n.readyState!="loaded"&&n.readyState!="complete"||(n=n.onload=n.onreadystatechange=null,t||a())}},m.qualifyURL=function(p){var a=document.createElement("a");return a.href=p,a.href}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(C,m,A){function x(){this.propagationStopped=!0}function p(){this.defaultPrevented=!0}var a={};a._emit=a._dispatchEvent=function(l,n){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var i=this._eventRegistry[l]||[],t=this._defaultHandlers[l];if(i.length||t){(n=typeof n=="object"&&n?n:{}).type||(n.type=l),n.stopPropagation||(n.stopPropagation=x),n.preventDefault||(n.preventDefault=p);for(var i=i.slice(),e=0;e<i.length&&(i[e](n,this),!n.propagationStopped);e++);return t&&!n.defaultPrevented?t(n,this):void 0}},a._signal=function(l,n){if(i=(this._eventRegistry||{})[l])for(var i=i.slice(),t=0;t<i.length;t++)i[t](n,this)},a.once=function(l,n){var i=this;if(this.on(l,function t(){i.off(l,t),n.apply(null,arguments)}),!n)return new Promise(function(t){n=t})},a.setDefaultHandler=function(l,n){var i,t,e=this._defaultHandlers;(e=e||(this._defaultHandlers={_disabled_:{}}))[l]&&(t=e[l],(i=e._disabled_[l])||(e._disabled_[l]=i=[]),i.push(t),(t=i.indexOf(n))!=-1&&i.splice(t,1)),e[l]=n},a.removeDefaultHandler=function(l,n){var i,t=this._defaultHandlers;t&&(i=t._disabled_[l],t[l]==n?i&&this.setDefaultHandler(l,i.pop()):i&&(t=i.indexOf(n))!=-1&&i.splice(t,1))},a.on=a.addEventListener=function(l,n,i){this._eventRegistry=this._eventRegistry||{};var t=this._eventRegistry[l];return(t=t||(this._eventRegistry[l]=[])).indexOf(n)==-1&&t[i?"unshift":"push"](n),n},a.off=a.removeListener=a.removeEventListener=function(l,n){this._eventRegistry=this._eventRegistry||{},l=this._eventRegistry[l],!l||(n=l.indexOf(n))!==-1&&l.splice(n,1)},a.removeAllListeners=function(l){l||(this._eventRegistry=this._defaultHandlers=void 0),this._eventRegistry&&(this._eventRegistry[l]=void 0),this._defaultHandlers&&(this._defaultHandlers[l]=void 0)},m.EventEmitter=a}),ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(C,m,A){var x=C("./oop"),p=C("./event_emitter").EventEmitter,a={setOptions:function(t){Object.keys(t).forEach(function(e){this.setOption(e,t[e])},this)},getOptions:function(t){var e,r={};return t?Array.isArray(t)||(r=t,t=Object.keys(r)):(e=this.$options,t=Object.keys(e).filter(function(s){return!e[s].hidden})),t.forEach(function(s){r[s]=this.getOption(s)},this),r},setOption:function(t,e){var r;if(this["$"+t]!==e)return(r=this.$options[t])?r.forwardTo?this[r.forwardTo]&&this[r.forwardTo].setOption(t,e):(r.handlesSet||(this["$"+t]=e),void(r&&r.set&&r.set.call(this,e))):l('misspelled option "'+t+'"')},getOption:function(t){var e=this.$options[t];return e?e.forwardTo?this[e.forwardTo]&&this[e.forwardTo].getOption(t):e&&e.get?e.get.call(this):this["$"+t]:l('misspelled option "'+t+'"')}};function l(t){typeof console<"u"&&console.warn&&console.warn.apply(console,arguments)}function n(t,e){var r=new Error(t);r.data=e,typeof console=="object"&&console.error&&console.error(r),setTimeout(function(){throw r})}function i(){this.$defaultOptions={}}(function(){x.implement(this,p),this.defineOptions=function(t,e,r){return t.$options||(this.$defaultOptions[e]=t.$options={}),Object.keys(r).forEach(function(s){var o=r[s];(o=typeof o=="string"?{forwardTo:o}:o).name||(o.name=s),"initialValue"in(t.$options[o.name]=o)&&(t["$"+o.name]=o.initialValue)}),x.implement(t,a),this},this.resetOptions=function(t){Object.keys(t.$options).forEach(function(e){var r=t.$options[e];"value"in r&&t.setOption(e,r.value)})},this.setDefaultValue=function(t,e,r){if(!t){for(t in this.$defaultOptions)if(this.$defaultOptions[t][e])break;if(!this.$defaultOptions[t][e])return!1}var s=this.$defaultOptions[t]||(this.$defaultOptions[t]={});s[e]&&(s.forwardTo?this.setDefaultValue(s.forwardTo,e,r):s[e].value=r)},this.setDefaultValues=function(t,e){Object.keys(e).forEach(function(r){this.setDefaultValue(t,r,e[r])},this)},this.warn=l,this.reportError=n}).call(i.prototype),m.AppConfig=i}),ace.define("ace/theme/textmate.css",["require","exports","module"],function(C,m,A){A.exports=`.ace-tm .ace_gutter {
  background: #f0f0f0;
  color: #333;
}

.ace-tm .ace_print-margin {
  width: 1px;
  background: #e8e8e8;
}

.ace-tm .ace_fold {
    background-color: #6B72E6;
}

.ace-tm {
  background-color: #FFFFFF;
  color: black;
}

.ace-tm .ace_cursor {
  color: black;
}
        
.ace-tm .ace_invisible {
  color: rgb(191, 191, 191);
}

.ace-tm .ace_storage,
.ace-tm .ace_keyword {
  color: blue;
}

.ace-tm .ace_constant {
  color: rgb(197, 6, 11);
}

.ace-tm .ace_constant.ace_buildin {
  color: rgb(88, 72, 246);
}

.ace-tm .ace_constant.ace_language {
  color: rgb(88, 92, 246);
}

.ace-tm .ace_constant.ace_library {
  color: rgb(6, 150, 14);
}

.ace-tm .ace_invalid {
  background-color: rgba(255, 0, 0, 0.1);
  color: red;
}

.ace-tm .ace_support.ace_function {
  color: rgb(60, 76, 114);
}

.ace-tm .ace_support.ace_constant {
  color: rgb(6, 150, 14);
}

.ace-tm .ace_support.ace_type,
.ace-tm .ace_support.ace_class {
  color: rgb(109, 121, 222);
}

.ace-tm .ace_keyword.ace_operator {
  color: rgb(104, 118, 135);
}

.ace-tm .ace_string {
  color: rgb(3, 106, 7);
}

.ace-tm .ace_comment {
  color: rgb(76, 136, 107);
}

.ace-tm .ace_comment.ace_doc {
  color: rgb(0, 102, 255);
}

.ace-tm .ace_comment.ace_doc.ace_tag {
  color: rgb(128, 159, 191);
}

.ace-tm .ace_constant.ace_numeric {
  color: rgb(0, 0, 205);
}

.ace-tm .ace_variable {
  color: rgb(49, 132, 149);
}

.ace-tm .ace_xml-pe {
  color: rgb(104, 104, 91);
}

.ace-tm .ace_entity.ace_name.ace_function {
  color: #0000A2;
}


.ace-tm .ace_heading {
  color: rgb(12, 7, 255);
}

.ace-tm .ace_list {
  color:rgb(185, 6, 144);
}

.ace-tm .ace_meta.ace_tag {
  color:rgb(0, 22, 142);
}

.ace-tm .ace_string.ace_regex {
  color: rgb(255, 0, 0)
}

.ace-tm .ace_marker-layer .ace_selection {
  background: rgb(181, 213, 255);
}
.ace-tm.ace_multiselect .ace_selection.ace_start {
  box-shadow: 0 0 3px 0px white;
}
.ace-tm .ace_marker-layer .ace_step {
  background: rgb(252, 255, 0);
}

.ace-tm .ace_marker-layer .ace_stack {
  background: rgb(164, 229, 101);
}

.ace-tm .ace_marker-layer .ace_bracket {
  margin: -1px 0 0 -1px;
  border: 1px solid rgb(192, 192, 192);
}

.ace-tm .ace_marker-layer .ace_active-line {
  background: rgba(0, 0, 0, 0.07);
}

.ace-tm .ace_gutter-active-line {
    background-color : #dcdcdc;
}

.ace-tm .ace_marker-layer .ace_selected-word {
  background: rgb(250, 250, 255);
  border: 1px solid rgb(200, 200, 250);
}

.ace-tm .ace_indent-guide {
  background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;
}

.ace-tm .ace_indent-guide-active {
  background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAAZSURBVHjaYvj///9/hivKyv8BAAAA//8DACLqBhbvk+/eAAAAAElFTkSuQmCC") right repeat-y;
}
`}),ace.define("ace/theme/textmate",["require","exports","module","ace/theme/textmate.css","ace/lib/dom"],function(C,m,A){m.isDark=!1,m.cssClass="ace-tm",m.cssText=C("./textmate.css"),m.$id="ace/theme/textmate",C("../lib/dom").importCssString(m.cssText,m.cssClass,!1)}),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/lib/net","ace/lib/dom","ace/lib/app_config","ace/theme/textmate"],function(C,m,A){var x=C("./lib/lang"),p=(C("./lib/oop"),C("./lib/net")),a=C("./lib/dom"),l=C("./lib/app_config").AppConfig,n=(A.exports=m=new l,{packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{},loadWorkerFromBlob:!0,sharedPopups:!1,useStrictCSP:null}),i=(m.get=function(e){if(n.hasOwnProperty(e))return n[e];throw new Error("Unknown config key: "+e)},m.set=function(e,r){if(n.hasOwnProperty(e))n[e]=r;else if(this.setDefaultValue("",e,r)==0)throw new Error("Unknown config key: "+e);e=="useStrictCSP"&&a.useStrictCSP(r)},m.all=function(){return x.copyObject(n)},m.$modes={},m.moduleUrl=function(e,r){var s,o,c;return n.$moduleUrls[e]||(e=e.split("/"),s=(r=r||e[e.length-2]||"")=="snippets"?"/":"-",o=e[e.length-1],r=="worker"&&s=="-"&&(c=new RegExp("^"+r+"[\\-_]|[\\-_]"+r+"$","g"),o=o.replace(c,"")),(!o||o==r)&&1<e.length&&(o=e[e.length-2]),(c=n[r+"Path"])==null?c=n.basePath:s=="/"&&(r=s=""),c&&c.slice(-1)!="/"&&(c+="/"),c+r+s+o+this.get("suffix"))},m.setModuleUrl=function(e,r){return n.$moduleUrls[e]=r},function(e,r){return e=="ace/theme/textmate"?r(null,C("./theme/textmate")):console.error("loader is not configured")}),t=(m.setLoader=function(e){i=e},m.$loading={},m.loadModule=function(e,r){var s,o;Array.isArray(e)&&(o=e[0],e=e[1]);try{s=C(e)}catch{}if(s&&!m.$loading[e])return r&&r(s);if(m.$loading[e]||(m.$loading[e]=[]),m.$loading[e].push(r),!(1<m.$loading[e].length)){let c=function(){i(e,function(d,b){m._emit("load.module",{name:e,module:b});var I=m.$loading[e];m.$loading[e]=null,I.forEach(function(h){h&&h(b)})})};if(!m.get("packaged"))return c();p.loadScript(m.moduleUrl(e,o),c),t()}},function(){n.basePath||n.workerPath||n.modePath||n.themePath||Object.keys(n.$moduleUrls).length||(console.error("Unable to infer path to ace from script src,","use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes","or with webpack use ace/webpack-resolver"),t=function(){})});m.version="1.10.1"}),ace.define("ace/loader_build",["require","exports","module","ace/lib/fixoldbrowsers","ace/config"],function(C,m,A){C("./lib/fixoldbrowsers");var x=C("./config"),p=(x.setLoader(function(l,n){C([l],function(i){n(null,i)})}),function(){return this||typeof window<"u"&&window}());function a(l){if(p&&p.document){x.set("packaged",l||C.packaged||A.packaged||p.define&&V.amdD.packaged);for(var n,i={},t="",l=document.currentScript||document._currentScript,e=(l&&l.ownerDocument||document).getElementsByTagName("script"),r=0;r<e.length;r++){var s=e[r],o=s.src||s.getAttribute("src");if(o){for(var c=s.attributes,d=0,b=c.length;d<b;d++){var I=c[d];I.name.indexOf("data-ace-")===0&&(i[I.name.replace(/^data-ace-/,"").replace(/-(.)/g,function(u,y){return y.toUpperCase()})]=I.value)}s=o.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/),s&&(t=s[1])}}for(n in t&&(i.base=i.base||t,i.packaged=!0),i.basePath=i.base,i.workerPath=i.workerPath||i.base,i.modePath=i.modePath||i.base,i.themePath=i.themePath||i.base,delete i.base,i)i[n]!==void 0&&x.set(n,i[n])}}A.exports=function(l){x.init=a,l.require=C,l.define=V.amdD},a(!0)}),ace.define("ace/lib/keys",["require","exports","module","ace/lib/oop"],function(C,m,A){var x=C("./oop"),p=function(){var a,l,n={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta",91:"MetaLeft",92:"MetaRight",93:"ContextMenu"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,super:8,meta:8,command:8,cmd:8,control:1},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}};for(l in n.FUNCTION_KEYS)a=n.FUNCTION_KEYS[l].toLowerCase(),n[a]=parseInt(l,10);for(l in n.PRINTABLE_KEYS)a=n.PRINTABLE_KEYS[l].toLowerCase(),n[a]=parseInt(l,10);x.mixin(n,n.MODIFIER_KEYS),x.mixin(n,n.PRINTABLE_KEYS),x.mixin(n,n.FUNCTION_KEYS),n.enter=n.return,n.escape=n.esc,n.del=n.delete,n[173]="-";for(var i=["cmd","ctrl","alt","shift"],t=Math.pow(2,i.length);t--;)n.KEY_MODS[t]=i.filter(function(e){return t&n.KEY_MODS[e]}).join("-")+"-";return n.KEY_MODS[0]="",n.KEY_MODS[-1]="input-",n}();x.mixin(m,p),m.keyCodeToString=function(a){var l=p[a];return(l=typeof l!="string"?String.fromCharCode(a):l).toLowerCase()}}),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(C,m,A){var x,p=C("./keys"),a=C("./useragent"),l=null,n=0;function i(){if(x==null){x=!1;try{document.createComment("").addEventListener("test",function(){},{get passive(){x={passive:!1}}})}catch{}}return x}function t(b,I,h){this.elem=b,this.type=I,this.callback=h}t.prototype.destroy=function(){o(this.elem,this.type,this.callback),this.elem=this.type=this.callback=void 0};function e(b){return 0|(b.ctrlKey?1:0)|(b.altKey?2:0)|(b.shiftKey?4:0)|(b.metaKey?8:0)}var r,s=m.addListener=function(b,I,h,u){b.addEventListener(I,h,i()),u&&u.$toDestroy.push(new t(b,I,h))},o=m.removeListener=function(b,I,h){b.removeEventListener(I,h,i())};m.stopEvent=function(b){return m.stopPropagation(b),m.preventDefault(b),!1},m.stopPropagation=function(b){b.stopPropagation&&b.stopPropagation()},m.preventDefault=function(b){b.preventDefault&&b.preventDefault()},m.getButton=function(b){return b.type=="dblclick"?0:b.type=="contextmenu"||a.isMac&&b.ctrlKey&&!b.altKey&&!b.shiftKey?2:b.button},m.capture=function(b,I,h){var u=b&&b.ownerDocument||document;function y(w){I&&I(w),h&&h(w),o(u,"mousemove",I),o(u,"mouseup",y),o(u,"dragstart",y)}return s(u,"mousemove",I),s(u,"mouseup",y),s(u,"dragstart",y),y},m.addMouseWheelListener=function(b,I,h){s(b,"wheel",function(u){var y=u.deltaX||0,w=u.deltaY||0;switch(u.deltaMode){case u.DOM_DELTA_PIXEL:u.wheelX=.15*y,u.wheelY=.15*w;break;case u.DOM_DELTA_LINE:u.wheelX=15*y,u.wheelY=15*w;break;case u.DOM_DELTA_PAGE:u.wheelX=150*y,u.wheelY=150*w}I(u)},h)},m.addMultiMouseDownListener=function(b,I,h,u,y){var w,v,T,B=0,E={2:"dblclick",3:"tripleclick",4:"quadclick"};function _(P){var H;if(m.getButton(P)!==0?B=0:1<P.detail&&!(4<++B)||(B=1),a.isIE&&(H=5<Math.abs(P.clientX-w)||5<Math.abs(P.clientY-v),T&&!H||(B=1),T&&clearTimeout(T),T=setTimeout(function(){T=null},I[B-1]||600),B==1&&(w=P.clientX,v=P.clientY)),P._clicks=B,h[u]("mousedown",P),4<B)B=0;else if(1<B)return h[u](E[B],P)}(b=Array.isArray(b)?b:[b]).forEach(function(P){s(P,"mousedown",_,y)})};function c(b,I,h){var u=e(I);if(!a.isMac&&l){if(I.getModifierState&&(I.getModifierState("OS")||I.getModifierState("Win"))&&(u|=8),l.altGr){if((3&u)==3)return;l.altGr=0}h!==18&&h!==17||(y="location"in I?I.location:I.keyLocation,h===17&&y===1?l[h]==1&&(n=I.timeStamp):h===18&&u===3&&y===2&&I.timeStamp-n<50&&(l.altGr=!0))}if(h in p.MODIFIER_KEYS&&(h=-1),!u&&h===13){var y="location"in I?I.location:I.keyLocation;if(y===3&&(b(I,u,-h),I.defaultPrevented))return}if(a.isChromeOS&&8&u){if(b(I,u,h),I.defaultPrevented)return;u&=-9}return!!(u||h in p.FUNCTION_KEYS||h in p.PRINTABLE_KEYS)&&b(I,u,h)}function d(){l=Object.create(null)}m.getModifierString=function(b){return p.KEY_MODS[e(b)]},m.addCommandKeyListener=function(b,I,h){var u,y;a.isOldGecko||a.isOpera&&!("KeyboardEvent"in window)?(u=null,s(b,"keydown",function(w){u=w.keyCode},h),s(b,"keypress",function(w){return c(I,w,u)},h)):(y=null,s(b,"keydown",function(w){l[w.keyCode]=(l[w.keyCode]||0)+1;var v=c(I,w,w.keyCode);return y=w.defaultPrevented,v},h),s(b,"keypress",function(w){y&&(w.ctrlKey||w.altKey||w.shiftKey||w.metaKey)&&(m.stopEvent(w),y=null)},h),s(b,"keyup",function(w){l[w.keyCode]=null},h),l||(d(),s(window,"focus",d)))},typeof window=="object"&&window.postMessage&&!a.isOldIE&&(r=1,m.nextTick=function(b,I){I=I||window;function h(y){y.data==u&&(m.stopPropagation(y),o(I,"message",h),b())}var u="zero-timeout-message-"+r++;s(I,"message",h),I.postMessage(u,"*")}),m.$idleBlocked=!1,m.onIdle=function(b,I){return setTimeout(function h(){m.$idleBlocked?setTimeout(h,100):b()},I)},m.$idleBlockId=null,m.blockIdle=function(b){m.$idleBlockId&&clearTimeout(m.$idleBlockId),m.$idleBlocked=!0,m.$idleBlockId=setTimeout(function(){m.$idleBlocked=!1},b||100)},m.nextFrame=typeof window=="object"&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame),m.nextFrame?m.nextFrame=m.nextFrame.bind(window):m.nextFrame=function(b){setTimeout(b,17)}}),ace.define("ace/range",["require","exports","module"],function(C,m,A){function x(p,a,l,n){this.start={row:p,column:a},this.end={row:l,column:n}}(function(){this.isEqual=function(p){return this.start.row===p.start.row&&this.end.row===p.end.row&&this.start.column===p.start.column&&this.end.column===p.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(p,a){return this.compare(p,a)==0},this.compareRange=function(a){var l=a.end,a=a.start,l=this.compare(l.row,l.column);return l==1?(l=this.compare(a.row,a.column))==1?2:l==0?1:0:l==-1?-2:(l=this.compare(a.row,a.column))==-1?-1:l==1?42:0},this.comparePoint=function(p){return this.compare(p.row,p.column)},this.containsRange=function(p){return this.comparePoint(p.start)==0&&this.comparePoint(p.end)==0},this.intersects=function(p){return p=this.compareRange(p),p==-1||p==0||p==1},this.isEnd=function(p,a){return this.end.row==p&&this.end.column==a},this.isStart=function(p,a){return this.start.row==p&&this.start.column==a},this.setStart=function(p,a){typeof p=="object"?(this.start.column=p.column,this.start.row=p.row):(this.start.row=p,this.start.column=a)},this.setEnd=function(p,a){typeof p=="object"?(this.end.column=p.column,this.end.row=p.row):(this.end.row=p,this.end.column=a)},this.inside=function(p,a){return this.compare(p,a)==0&&!this.isEnd(p,a)&&!this.isStart(p,a)},this.insideStart=function(p,a){return this.compare(p,a)==0&&!this.isEnd(p,a)},this.insideEnd=function(p,a){return this.compare(p,a)==0&&!this.isStart(p,a)},this.compare=function(p,a){return this.isMultiLine()||p!==this.start.row?p<this.start.row?-1:p>this.end.row?1:this.start.row===p?a>=this.start.column?0:-1:this.end.row!==p||a<=this.end.column?0:1:a<this.start.column?-1:a>this.end.column?1:0},this.compareStart=function(p,a){return this.start.row==p&&this.start.column==a?-1:this.compare(p,a)},this.compareEnd=function(p,a){return this.end.row==p&&this.end.column==a?1:this.compare(p,a)},this.compareInside=function(p,a){return this.end.row==p&&this.end.column==a?1:this.start.row==p&&this.start.column==a?-1:this.compare(p,a)},this.clipRows=function(p,a){var l,n;return this.end.row>a?l={row:a+1,column:0}:this.end.row<p&&(l={row:p,column:0}),this.start.row>a?n={row:a+1,column:0}:this.start.row<p&&(n={row:p,column:0}),x.fromPoints(n||this.start,l||this.end)},this.extend=function(p,a){var l,n,i=this.compare(p,a);return i==0?this:(i==-1?l={row:p,column:a}:n={row:p,column:a},x.fromPoints(l||this.start,n||this.end))},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return x.fromPoints(this.start,this.end)},this.collapseRows=function(){return this.end.column==0?new x(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new x(this.start.row,0,this.end.row,0)},this.toScreenRange=function(l){var a=l.documentToScreenPosition(this.start),l=l.documentToScreenPosition(this.end);return new x(a.row,a.column,l.row,l.column)},this.moveBy=function(p,a){this.start.row+=p,this.start.column+=a,this.end.row+=p,this.end.column+=a}}).call(x.prototype),x.fromPoints=function(p,a){return new x(p.row,p.column,a.row,a.column)},x.comparePoints=function(p,a){return p.row-a.row||p.column-a.column},x.comparePoints=function(p,a){return p.row-a.row||p.column-a.column},m.Range=x}),ace.define("ace/clipboard",["require","exports","module"],function(C,m,A){var x;A.exports={lineMode:!1,pasteCancelled:function(){return!!(x&&x>Date.now()-50)||(x=!1)},cancel:function(){x=Date.now()}}}),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/clipboard","ace/lib/keys"],function(C,m,A){var x=C("../lib/event"),p=C("../lib/useragent"),a=C("../lib/dom"),l=C("../lib/lang"),n=C("../clipboard"),i=p.isChrome<18,t=p.isIE,e=63<p.isChrome,r=C("../lib/keys"),s=r.KEY_MODS,o=p.isIOS,c=o?/\s/:/\n/,d=p.isMobile;m.TextInput=function(b,I){var h=a.createElement("textarea"),u=(h.className="ace_text-input",h.setAttribute("wrap","off"),h.setAttribute("autocorrect","off"),h.setAttribute("autocapitalize","off"),h.setAttribute("spellcheck",!1),h.style.opacity="0",b.insertBefore(h,b.firstChild),!1),y=!1,w=!1,v=!1,T="",B=(d||(h.style.fontSize="1px"),!1),E=!1,_="",P=0,H=0,z=0;try{var K=document.activeElement===h}catch{}x.addListener(h,"blur",function(ae){E||(I.onBlur(ae),K=!1)},I),x.addListener(h,"focus",function(ae){if(!E){if(K=!0,p.isEdge)try{if(!document.hasFocus())return}catch{}I.onFocus(ae),p.isEdge?setTimeout(W):W()}},I),this.$focusScroll=!1,this.focus=function(){if(T||e||this.$focusScroll=="browser")return h.focus({preventScroll:!0});var ae=h.style.top;h.style.position="fixed",h.style.top="0px";try{var ge=h.getBoundingClientRect().top!=0}catch{return}var le=[];if(ge)for(var ce=h.parentElement;ce&&ce.nodeType==1;)le.push(ce),ce.setAttribute("ace_nocontext",!0),ce=!ce.parentElement&&ce.getRootNode?ce.getRootNode().host:ce.parentElement;h.focus({preventScroll:!0}),ge&&le.forEach(function(me){me.removeAttribute("ace_nocontext")}),setTimeout(function(){h.style.position="",h.style.top=="0px"&&(h.style.top=ae)},0)},this.blur=function(){h.blur()},this.isFocused=function(){return K},I.on("beforeEndOperation",function(){var ae=I.curOp,ge=ae&&ae.command&&ae.command.name;ge!="insertstring"&&(ge=ge&&(ae.docChanged||ae.selectionChanged),w&&ge&&(_=h.value="",ve()),W())});function Y(ae){te(ae,!0)}function R(ae){te(ae,!1)}function Z(ae){var ge=Q(ae);n.pasteCancelled()||(typeof ge=="string"?(ge&&I.onPaste(ge,ae),p.isIE&&setTimeout(W),x.preventDefault(ae)):(h.value="",y=!0))}var W=o?function(ae){var ge;!K||u&&!ae||v||((ge=`
 ab`+(ae=ae||"")+`cde fg
`)!=h.value&&(h.value=_=ge),ge=4+(ae.length||(I.selection.isEmpty()?0:1)),P==4&&H==ge||h.setSelectionRange(4,ge),P=4,H=ge)}:function(){if(!w&&!v&&(K||$)){w=!0;var ae,ge,le=0,ce=0,me="",Ie=(I.session&&(Ie=(ae=I.selection).getRange(),ae=ae.cursor.row,le=Ie.start.column,ce=Ie.end.column,me=I.session.getLine(ae),Ie.start.row!=ae?(ge=I.session.getLine(ae-1),le=Ie.start.row<ae-1?0:le,ce+=ge.length+1,me=ge+`
`+me):Ie.end.row!=ae?(ge=I.session.getLine(ae+1),ce=Ie.end.row>ae+1?ge.length:ce,ce+=me.length+1,me=me+`
`+ge):d&&0<ae&&(me=`
`+me,ce+=1,le+=1),400<me.length&&(le<400&&ce<400?me=me.slice(0,400):(me=`
`,le==ce?le=ce=0:(le=0,ce=1)))),me+`

`);if(Ie!=_&&(h.value=_=Ie,P=H=Ie.length),$&&(P=h.selectionStart,H=h.selectionEnd),H!=ce||P!=le||h.selectionEnd!=H)try{h.setSelectionRange(le,ce),P=le,H=ce}catch{}w=!1}},f=(this.resetSelection=W,K&&I.onFocus(),function(ae){return ae.selectionStart===0&&ae.selectionEnd>=_.length&&ae.value===_&&_&&ae.selectionEnd!==H}),S=null,$=(this.setInputHandler=function(ae){S=ae},!(this.getInputHandler=function(){return S})),F=function(ae,ge){if($=$&&!1,y)return W(),ae&&I.onPaste(ae),y=!1,"";for(var le=h.selectionStart,ce=h.selectionEnd,me=P,Ie=_.length-H,xe=ae,Ge=ae.length-le,De=ae.length-ce,We=0;0<me&&_[We]==ae[We];)We++,me--;for(xe=xe.slice(We),We=1;0<Ie&&_.length-We>P-1&&_[_.length-We]==ae[ae.length-We];)We++,Ie--;Ge-=We-1,De-=We-1;var je=xe.length-We+1;return je<0&&(me=-je,je=0),xe=xe.slice(0,je),ge||xe||Ge||me||Ie||De?(je=!(v=!0),p.isAndroid&&xe==". "&&(xe="  ",je=!0),xe&&!me&&!Ie&&!Ge&&!De||B?I.onTextInput(xe):I.onTextInput(xe,{extendLeft:me,extendRight:Ie,restoreStart:Ge,restoreEnd:De}),v=!1,_=ae,P=le,H=ce,z=De,je?`
`:xe):""},j=function(ge){if(w)return he();if(ge&&ge.inputType){if(ge.inputType=="historyUndo")return I.execCommand("undo");if(ge.inputType=="historyRedo")return I.execCommand("redo")}var ge=h.value,le=F(ge,!0);(500<ge.length||c.test(le)||d&&P<1&&P==H)&&W()},Q=function(ae,ge,le){var ce=ae.clipboardData||window.clipboardData;if(ce&&!i){var me=t||le?"Text":"text/plain";try{return ge?ce.setData(me,ge)!==!1:ce.getData(me)}catch(Ie){if(!le)return Q(Ie,ge,!0)}}},te=function(ae,ge){var le=I.getCopyText();if(!le)return x.preventDefault(ae);Q(ae,le)?(o&&(W(le),u=le,setTimeout(function(){u=!1},10)),ge?I.onCut():I.onCopy(),x.preventDefault(ae)):(u=!0,h.value=le,h.select(),setTimeout(function(){u=!1,W(),ge?I.onCut():I.onCopy()}))},he=(x.addCommandKeyListener(h,I.onCommandKey.bind(I),I),x.addListener(h,"select",function(ae){w||(u?u=!1:f(h)?(I.selectAll(),W()):d&&h.selectionStart!=P&&W())},I),x.addListener(h,"input",j,I),x.addListener(h,"cut",Y,I),x.addListener(h,"copy",R,I),x.addListener(h,"paste",Z,I),"oncut"in h&&"oncopy"in h&&"onpaste"in h||x.addListener(b,"keydown",function(ae){if((!p.isMac||ae.metaKey)&&ae.ctrlKey)switch(ae.keyCode){case 67:R(ae);break;case 86:Z(ae);break;case 88:Y(ae)}},I),function(){var ae;if(w&&I.onCompositionUpdate&&!I.$readOnly)return B?ue():void(w.useTextareaForIME?I.onCompositionUpdate(h.value):(ae=h.value,F(ae),w.markerRange&&(w.context&&(w.markerRange.start.column=w.selectionStart=w.context.compositionStartOffset),w.markerRange.end.column=w.markerRange.start.column+H-w.selectionStart+z)))}),ve=function(ae){I.onCompositionEnd&&!I.$readOnly&&(w=!1,I.onCompositionEnd(),I.off("mousedown",ue),ae&&j())};function ue(){E=!0,h.blur(),h.focus(),E=!1}var fe,Ce=l.delayedCall(he,50).schedule.bind(null,null);function Ae(){clearTimeout(fe),fe=setTimeout(function(){T&&(h.style.cssText=T,T=""),I.renderer.$isMousePressed=!1,I.renderer.$keepTextAreaAtCursor&&I.renderer.$moveTextAreaToCursor()},0)}x.addListener(h,"compositionstart",function(ae){w||!I.onCompositionStart||I.$readOnly||(w={},B||(ae.data&&(w.useTextareaForIME=!1),setTimeout(he,0),I._signal("compositionStart"),I.on("mousedown",ue),(ae=I.getSelectionRange()).end.row=ae.start.row,ae.end.column=ae.start.column,w.markerRange=ae,w.selectionStart=P,I.onCompositionStart(w),w.useTextareaForIME?(_=h.value="",H=P=0):(h.msGetInputContext&&(w.context=h.msGetInputContext()),h.getInputContext&&(w.context=h.getInputContext()))))},I),x.addListener(h,"compositionupdate",he,I),x.addListener(h,"keyup",function(ae){ae.keyCode==27&&h.value.length<h.selectionStart&&(w||(_=h.value),P=H=-1,W()),Ce()},I),x.addListener(h,"keydown",Ce,I),x.addListener(h,"compositionend",ve,I),this.getElement=function(){return h},this.setCommandMode=function(ae){B=ae,h.readOnly=!1},this.setReadOnly=function(ae){B||(h.readOnly=ae)},this.setCopyWithEmptySelection=function(ae){},this.onContextMenu=function(ae){$=!0,W(),I._emit("nativecontextmenu",{target:I,domEvent:ae}),this.moveToMouse(ae,!0)},this.moveToMouse=function(ae,ce){T=T||h.style.cssText,h.style.cssText=(ce?"z-index:100000;":"")+(p.isIE?"opacity:0.1;":"")+"text-indent: -"+(P+H)*I.renderer.characterWidth*.5+"px;";function le(De){a.translate(h,De.clientX-xe-2,Math.min(De.clientY-Ie-2,Ge))}var ce=I.container.getBoundingClientRect(),me=a.computedStyle(I.container),Ie=ce.top+(parseInt(me.borderTopWidth)||0),xe=ce.left+(parseInt(ce.borderLeftWidth)||0),Ge=ce.bottom-Ie-h.clientHeight-2;le(ae),ae.type=="mousedown"&&(I.renderer.$isMousePressed=!0,clearTimeout(fe),p.isWin&&x.capture(I.container,le,Ae))},this.onContextMenuClose=Ae;function Ee(ae){I.textInput.onContextMenu(ae),Ae()}if(x.addListener(h,"mouseup",Ee,I),x.addListener(h,"mousedown",function(ae){ae.preventDefault(),Ae()},I),x.addListener(I.renderer.scroller,"contextmenu",Ee,I),x.addListener(h,"contextmenu",Ee,I),o){let ae=function(ge){var le,ce,me,Ie;document.activeElement!==we||Te||w||Re.$mouseHandler.isMousePressed||u||(le=we.selectionStart,ce=we.selectionEnd,me=null,(Ie=0)==le?me=r.up:le==1?me=r.home:H<ce&&_[ce]==`
`?me=r.end:le<P&&_[le-1]==" "?(me=r.left,Ie=s.option):le<P||le==P&&H!=P&&le==ce?me=r.left:H<ce&&2<_.slice(0,ce).split(`
`).length?me=r.down:H<ce&&_[ce-1]==" "?(me=r.right,Ie=s.option):(H<ce||ce==H&&H!=P&&le==ce)&&(me=r.right),le!==ce&&(Ie|=s.shift),me&&(!Re.onCommandKey({},Ie,me)&&Re.commands&&(me=r.keyCodeToString(me),(Ie=Re.commands.findKeyCommand(Ie,me))&&Re.execCommand(Ie)),P=le,H=ce,W("")))};var Re=I,we=h,de=null,Te=!1;we.addEventListener("keydown",function(ge){de&&clearTimeout(de),Te=!0},!0),we.addEventListener("keyup",function(ge){de=setTimeout(function(){Te=!1},100)},!0),document.addEventListener("selectionchange",ae),Re.on("destroy",function(){document.removeEventListener("selectionchange",ae)})}this.destroy=function(){h.parentElement&&h.parentElement.removeChild(h)}},m.$setUserAgentForTests=function(b,I){d=b,o=I}}),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/useragent"],function(C,m,A){var x=C("../lib/useragent");function p(l){l.$clickSelection=null;var n=l.editor;n.setDefaultHandler("mousedown",this.onMouseDown.bind(l)),n.setDefaultHandler("dblclick",this.onDoubleClick.bind(l)),n.setDefaultHandler("tripleclick",this.onTripleClick.bind(l)),n.setDefaultHandler("quadclick",this.onQuadClick.bind(l)),n.setDefaultHandler("mousewheel",this.onMouseWheel.bind(l)),["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"].forEach(function(i){l[i]=this[i]},this),l.selectByLines=this.extendSelectionBy.bind(l,"getLineRange"),l.selectByWords=this.extendSelectionBy.bind(l,"getWordRange")}function a(l,n){return(l.start.row==l.end.row?2*n.column-l.start.column-l.end.column:l.start.row!=l.end.row-1||l.start.column||l.end.column?2*n.row-l.start.row-l.end.row:n.column-4)<0?{cursor:l.start,anchor:l.end}:{cursor:l.end,anchor:l.start}}(function(){this.onMouseDown=function(l){var n=l.inSelection(),i=l.getDocumentPosition(),t=(this.mousedownEvent=l,this.editor),e=l.getButton();if(e!==0)!t.getSelectionRange().isEmpty()&&e!=1||t.selection.moveToPosition(i),e==2&&(t.textInput.onContextMenu(l.domEvent),x.isMozilla||l.preventDefault());else{if(this.mousedownEvent.time=Date.now(),!n||t.isFocused()||(t.focus(),!this.$focusTimeout||this.$clickSelection||t.inMultiSelectMode))return this.captureMouse(l),this.startSelect(i,1<l.domEvent._clicks),l.preventDefault();this.setState("focusWait"),this.captureMouse(l)}},this.startSelect=function(l,n){l=l||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var i=this.editor;this.mousedownEvent&&(this.mousedownEvent.getShiftKey()?i.selection.selectToPosition(l):n||i.selection.moveToPosition(l),n||this.select(),i.renderer.scroller.setCapture&&i.renderer.scroller.setCapture(),i.setStyle("ace_selecting"),this.setState("select"))},this.select=function(){var l,n=this.editor,i=n.renderer.screenToTextCoordinates(this.x,this.y);this.$clickSelection&&(l=(l=this.$clickSelection.comparePoint(i))==-1?this.$clickSelection.end:l==1?this.$clickSelection.start:(i=(l=a(this.$clickSelection,i)).cursor,l.anchor),n.selection.setSelectionAnchor(l.row,l.column)),n.selection.selectToPosition(i),n.renderer.scrollCursorIntoView()},this.extendSelectionBy=function(s){var n,i,t,e=this.editor,r=e.renderer.screenToTextCoordinates(this.x,this.y),s=e.selection[s](r.row,r.column);this.$clickSelection&&(i=this.$clickSelection.comparePoint(s.start),n=this.$clickSelection.comparePoint(s.end),i==-1&&n<=0?(t=this.$clickSelection.end,s.end.row==r.row&&s.end.column==r.column||(r=s.start)):n==1&&0<=i?(t=this.$clickSelection.start,s.start.row==r.row&&s.start.column==r.column||(r=s.end)):t=i==-1&&n==1?(r=s.end,s.start):(r=(i=a(this.$clickSelection,r)).cursor,i.anchor),e.selection.setSelectionAnchor(t.row,t.column)),e.selection.selectToPosition(r),e.renderer.scrollCursorIntoView()},this.selectEnd=this.selectAllEnd=this.selectByWordsEnd=this.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting"),this.editor.renderer.scroller.releaseCapture&&this.editor.renderer.scroller.releaseCapture()},this.focusWait=function(){t=this.mousedownEvent.x,l=this.mousedownEvent.y,i=this.x,n=this.y;var l,n,i=Math.sqrt(Math.pow(i-t,2)+Math.pow(n-l,2)),t=Date.now();(0<i||t-this.mousedownEvent.time>this.$focusTimeout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},this.onDoubleClick=function(n){var n=n.getDocumentPosition(),i=this.editor,t=i.session.getBracketRange(n);t?(t.isEmpty()&&(t.start.column--,t.end.column++),this.setState("select")):(t=i.selection.getWordRange(n.row,n.column),this.setState("selectByWords")),this.$clickSelection=t,this.select()},this.onTripleClick=function(n){var n=n.getDocumentPosition(),i=this.editor,t=(this.setState("selectByLines"),i.getSelectionRange());t.isMultiLine()&&t.contains(n.row,n.column)?(this.$clickSelection=i.selection.getLineRange(t.start.row),this.$clickSelection.end=i.selection.getLineRange(t.end.row).end):this.$clickSelection=i.selection.getLineRange(n.row),this.select()},this.onQuadClick=function(l){var n=this.editor;n.selectAll(),this.$clickSelection=n.getSelectionRange(),this.setState("selectAll")},this.onMouseWheel=function(l){var n,i,t,e,r,s,o;if(!l.getAccelKey())return l.getShiftKey()&&l.wheelY&&!l.wheelX&&(l.wheelX=l.wheelY,l.wheelY=0),n=this.editor,this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0}),i=this.$lastScroll,e=(o=(t=l.domEvent.timeStamp)-i.t)?l.wheelX/o:i.vx,r=o?l.wheelY/o:i.vy,o<550&&(e=(e+i.vx)/2,r=(r+i.vy)/2),o=!1,1<=(s=Math.abs(e/r))&&n.renderer.isScrollableBy(l.wheelX*l.speed,0)&&(o=!0),(o=s<=1&&n.renderer.isScrollableBy(0,l.wheelY*l.speed)?!0:o)?i.allowed=t:t-i.allowed<550&&(Math.abs(e)<=1.5*Math.abs(i.vx)&&Math.abs(r)<=1.5*Math.abs(i.vy)?(o=!0,i.allowed=t):i.allowed=0),i.t=t,i.vx=e,i.vy=r,o?(n.renderer.scrollBy(l.wheelX*l.speed,l.wheelY*l.speed),l.stop()):void 0}}).call(p.prototype),m.DefaultHandlers=p}),ace.define("ace/tooltip",["require","exports","module","ace/lib/oop","ace/lib/dom"],function(C,m,A){C("./lib/oop");var x=C("./lib/dom"),p="ace_tooltip";function a(l){this.isOpen=!1,this.$element=null,this.$parentNode=l}(function(){this.$init=function(){return this.$element=x.createElement("div"),this.$element.className=p,this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},this.getElement=function(){return this.$element||this.$init()},this.setText=function(l){this.getElement().textContent=l},this.setHtml=function(l){this.getElement().innerHTML=l},this.setPosition=function(l,n){this.getElement().style.left=l+"px",this.getElement().style.top=n+"px"},this.setClassName=function(l){x.addCssClass(this.getElement(),l)},this.show=function(l,n,i){l!=null&&this.setText(l),n!=null&&i!=null&&this.setPosition(n,i),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},this.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.getElement().className=p,this.isOpen=!1)},this.getHeight=function(){return this.getElement().offsetHeight},this.getWidth=function(){return this.getElement().offsetWidth},this.destroy=function(){this.isOpen=!1,this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)}}).call(a.prototype),m.Tooltip=a}),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event","ace/tooltip"],function(C,m,A){var x=C("../lib/dom"),p=C("../lib/oop"),a=C("../lib/event"),l=C("../tooltip").Tooltip;function n(i){l.call(this,i)}p.inherits(n,l),function(){this.setPosition=function(i,t){var e=window.innerWidth||document.documentElement.clientWidth,r=window.innerHeight||document.documentElement.clientHeight,s=this.getWidth(),o=this.getHeight();e<(i+=15)+s&&(i-=i+s-e),r<(t+=15)+o&&(t-=20+o),l.prototype.setPosition.call(this,i,t)}}.call(n.prototype),m.GutterHandler=function(i){var t,e,r,s=i.editor,o=s.renderer.$gutterLayer,c=new n(s.container);function d(){t=t&&clearTimeout(t),r&&(c.hide(),r=null,s._signal("hideGutterTooltip",c),s.off("mousewheel",d))}function b(I){c.setPosition(I.x,I.y)}i.editor.setDefaultHandler("guttermousedown",function(I){if(s.isFocused()&&I.getButton()==0){var h=o.getRegion(I);if(h!="foldWidgets"){var h=I.getDocumentPosition().row,u=s.session.selection;if(I.getShiftKey())u.selectTo(h,0);else{if(I.domEvent.detail==2)return s.selectAll(),I.preventDefault();i.$clickSelection=s.selection.getLineRange(h)}return i.setState("selectByLines"),i.captureMouse(I),I.preventDefault()}}}),i.editor.setDefaultHandler("guttermousemove",function(I){var h=I.domEvent.target||I.domEvent.srcElement;if(x.hasCssClass(h,"ace_fold-widget"))return d();r&&i.$tooltipFollowsMouse&&b(I),e=I,t=t||setTimeout(function(){if(t=null,e&&!i.isMousePressed){var u=e.getDocumentPosition().row,y=o.$annotations[u];if(y){if(u==s.session.getLength()){var u=s.renderer.pixelToScreenCoordinates(0,e.y).row,w=e.$pos;if(u>s.session.documentToScreenRow(w.row,w.column))return void d()}r!=y&&(r=y.text.join("<br/>"),c.setHtml(r),(u=y.className)&&c.setClassName(u.trim()),c.show(),s._signal("showGutterTooltip",c),s.on("mousewheel",d),i.$tooltipFollowsMouse?b(e):(w=e.domEvent.target.getBoundingClientRect(),(y=c.getElement().style).left=w.right+"px",y.top=w.bottom+"px"))}else d()}else d()},50)}),a.addListener(s.renderer.$gutter,"mouseout",function(I){e=null,r&&!t&&(t=setTimeout(function(){t=null,d()},50))},s),s.on("changeSession",d)}}),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(a,m,A){var x=a("../lib/event"),p=a("../lib/useragent"),a=m.MouseEvent=function(l,n){this.domEvent=l,this.editor=n,this.x=this.clientX=l.clientX,this.y=this.clientY=l.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1};(function(){this.stopPropagation=function(){x.stopPropagation(this.domEvent),this.propagationStopped=!0},this.preventDefault=function(){x.preventDefault(this.domEvent),this.defaultPrevented=!0},this.stop=function(){this.stopPropagation(),this.preventDefault()},this.getDocumentPosition=function(){return this.$pos||(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY)),this.$pos},this.inSelection=function(){var l,n;return this.$inSelection===null&&((l=this.editor.getSelectionRange()).isEmpty()?this.$inSelection=!1:(n=this.getDocumentPosition(),this.$inSelection=l.contains(n.row,n.column))),this.$inSelection},this.getButton=function(){return x.getButton(this.domEvent)},this.getShiftKey=function(){return this.domEvent.shiftKey},this.getAccelKey=p.isMac?function(){return this.domEvent.metaKey}:function(){return this.domEvent.ctrlKey}}).call(a.prototype)}),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(C,m,A){var x=C("../lib/dom"),p=C("../lib/event"),a=C("../lib/useragent");function l(i){var t,e,r,s,o,c,d,b,I,h,u,y=i.editor,w=x.createElement("div"),v=(w.style.cssText="top:-100px;position:absolute;z-index:2147483647;opacity:0.5",w.textContent="\xA0",["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"].forEach(function(Y){i[Y]=this[Y]},this),y.on("mousedown",this.onMouseDown.bind(i)),y.container),T=0;function B(){var Y,R,Z,W,f,S,$,F,j=c;c=y.renderer.screenToTextCoordinates(e,r),Z=c,R=j,W=Date.now(),Y=!R||Z.row!=R.row,R=!R||Z.column!=R.column,!h||Y||R?(y.moveCursorToPosition(Z),h=W,u={x:e,y:r}):5<n(u.x,u.y,e,r)?h=null:200<=W-h&&(y.renderer.scrollCursorIntoView(),h=null),Y=c,R=j,Z=Date.now(),W=y.renderer.layerConfig.lineHeight,j=y.renderer.layerConfig.characterWidth,f=y.renderer.scroller.getBoundingClientRect(),f={x:{left:e-f.left,right:f.right-e},y:{top:r-f.top,bottom:f.bottom-r}},S=Math.min(f.x.left,f.x.right),$=Math.min(f.y.top,f.y.bottom),F={row:Y.row,column:Y.column},S/j<=2&&(F.column+=f.x.left<f.x.right?-3:2),$/W<=1&&(F.row+=f.y.top<f.y.bottom?-1:1),S=Y.row!=F.row,j=Y.column!=F.column,$=!R||Y.row!=R.row,S||j&&!$?I?200<=Z-I&&y.renderer.scrollCursorIntoView(F):I=Z:I=null}function E(){o=y.selection.toOrientedRange(),t=y.session.addMarker(o,"ace_selection",y.getSelectionStyle()),y.clearSelection(),y.isFocused()&&y.renderer.$cursorLayer.setBlinking(!1),clearInterval(s),B(),s=setInterval(B,20),T=0,p.addListener(document,"mousemove",H)}function _(){clearInterval(s),y.session.removeMarker(t),t=null,y.selection.fromOrientedRange(o),y.isFocused()&&!b&&y.$resetCursorStyle(),T=0,h=I=c=o=null,p.removeListener(document,"mousemove",H)}this.onDragStart=function(Y){var R;if(this.cancelDrag||!v.draggable)return R=this,setTimeout(function(){R.startSelect(),R.captureMouse(Y)},0),Y.preventDefault();o=y.getSelectionRange();var Z=Y.dataTransfer;Z.effectAllowed=y.getReadOnly()?"copy":"copyMove",y.container.appendChild(w),Z.setDragImage&&Z.setDragImage(w,0,0),setTimeout(function(){y.container.removeChild(w)}),Z.clearData(),Z.setData("Text",y.session.getTextRange()),b=!0,this.setState("drag")},this.onDragEnd=function(Y){v.draggable=!1,b=!1,this.setState(null),y.getReadOnly()||(Y=Y.dataTransfer.dropEffect,d||Y!="move"||y.session.remove(y.getSelectionRange()),y.$resetCursorStyle()),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(Y){if(!y.getReadOnly()&&z(Y.dataTransfer))return e=Y.clientX,r=Y.clientY,t||E(),T++,Y.dataTransfer.dropEffect=d=K(Y),p.preventDefault(Y)},this.onDragOver=function(Y){if(!y.getReadOnly()&&z(Y.dataTransfer))return e=Y.clientX,r=Y.clientY,t||(E(),T++),P!==null&&(P=null),Y.dataTransfer.dropEffect=d=K(Y),p.preventDefault(Y)},this.onDragLeave=function(Y){if(--T<=0&&t)return _(),d=null,p.preventDefault(Y)},this.onDrop=function(Y){if(c){var R=Y.dataTransfer;if(b)switch(d){case"move":o=o.contains(c.row,c.column)?{start:c,end:c}:y.moveText(o,c);break;case"copy":o=y.moveText(o,c,!0)}else R=R.getData("Text"),o={start:c,end:y.session.insert(c,R)},y.focus(),d=null;return _(),p.preventDefault(Y)}},p.addListener(v,"dragstart",this.onDragStart.bind(i),y),p.addListener(v,"dragend",this.onDragEnd.bind(i),y),p.addListener(v,"dragenter",this.onDragEnter.bind(i),y),p.addListener(v,"dragover",this.onDragOver.bind(i),y),p.addListener(v,"dragleave",this.onDragLeave.bind(i),y),p.addListener(v,"drop",this.onDrop.bind(i),y);var P=null;function H(){P==null&&(P=setTimeout(function(){P!=null&&t&&_()},20))}function z(Y){return Y=Y.types,!Y||Array.prototype.some.call(Y,function(R){return R=="text/plain"||R=="Text"})}function K(Y){var R=["copy","copymove","all","uninitialized"],Z=a.isMac?Y.altKey:Y.ctrlKey,W="uninitialized";try{W=Y.dataTransfer.effectAllowed.toLowerCase()}catch{}var f="none";return Z&&0<=R.indexOf(W)?f="copy":0<=["move","copymove","linkmove","all","uninitialized"].indexOf(W)?f="move":0<=R.indexOf(W)&&(f="copy"),f}}function n(i,t,e,r){return Math.sqrt(Math.pow(e-i,2)+Math.pow(r-t,2))}(function(){this.dragWait=function(){Date.now()-this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){this.editor.container.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(i){this.editor.$resetCursorStyle(),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var i=this.editor,t=(i.container.draggable=!0,i.renderer.$cursorLayer.setBlinking(!1),i.setStyle("ace_dragging"),a.isWin?"default":"move");i.renderer.setCursorStyle(t),this.setState("dragReady")},this.onMouseDrag=function(i){var t=this.editor.container;a.isIE&&this.state=="dragReady"&&3<n(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&t.dragDrop(),this.state==="dragWait"&&0<n(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&(t.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()))},this.onMouseDown=function(i){var t,e,r;this.$dragEnabled&&(this.mousedownEvent=i,t=this.editor,e=i.inSelection(),r=i.getButton(),(i.domEvent.detail||1)!==1||r!==0||!e||i.editor.inMultiSelectMode&&(i.getAccelKey()||i.getShiftKey())||(this.mousedownEvent.time=Date.now(),"unselectable"in(r=i.domEvent.target||i.domEvent.srcElement)&&(r.unselectable="on"),t.getDragDelay()?(a.isWebKit&&(this.cancelDrag=!0,t.container.draggable=!0),this.setState("dragWait")):this.startDrag(),this.captureMouse(i,this.onMouseDrag.bind(this)),i.defaultPrevented=!0))}}).call(l.prototype),m.DragdropHandler=l}),ace.define("ace/mouse/touch_handler",["require","exports","module","ace/mouse/mouse_event","ace/lib/event","ace/lib/dom"],function(C,m,A){var x=C("./mouse_event").MouseEvent,p=C("../lib/event"),a=C("../lib/dom");m.addTouchListeners=function(l,n){var i,t,e,r,s,o,c,d,b,I="scroll",h=0,u=0,y=0,w=0;function v(){function _(z){var K,Y=z.target.getAttribute("action");Y!="more"&&H?(Y=="paste"?P.readText().then(function(R){n.execCommand(Y,R)}):Y&&(Y!="cut"&&Y!="copy"||(P?P.writeText(n.getCopyText()):document.execCommand("copy")),n.execCommand(Y)),b.firstChild.style.display="none",H=!1,Y!="openCommandPallete"&&n.focus()):(H=!H,z=n.getCopyText(),K=n.session.getUndoManager().hasUndo(),b.replaceChild(a.buildDom(H?["span",!z&&["span",{class:"ace_mobile-button",action:"selectall"},"Select All"],z&&["span",{class:"ace_mobile-button",action:"copy"},"Copy"],z&&["span",{class:"ace_mobile-button",action:"cut"},"Cut"],P&&["span",{class:"ace_mobile-button",action:"paste"},"Paste"],K&&["span",{class:"ace_mobile-button",action:"undo"},"Undo"],["span",{class:"ace_mobile-button",action:"find"},"Find"],["span",{class:"ace_mobile-button",action:"openCommandPallete"},"Palette"]]:["span"]),b.firstChild))}var P=window.navigator&&window.navigator.clipboard,H=!1;b=a.buildDom(["div",{class:"ace_mobile-menu",ontouchstart:function(z){I="menu",z.stopPropagation(),z.preventDefault(),n.textInput.focus()},ontouchend:function(z){z.stopPropagation(),z.preventDefault(),_(z)},onclick:_},["span"],["span",{class:"ace_mobile-button",action:"more"},"..."]],n.container)}function T(){b||v();var _=n.selection.cursor,_=n.renderer.textToScreenCoordinates(_.row,_.column),P=n.renderer.textToScreenCoordinates(0,0).pageX,H=n.renderer.scrollLeft,z=n.container.getBoundingClientRect();b.style.top=_.pageY-z.top-3+"px",_.pageX-z.left<z.width-70?(b.style.left="",b.style.right="10px"):(b.style.right="",b.style.left=P+H-z.left+"px"),b.style.display="",b.firstChild.style.display="none",n.on("input",B)}function B(_){b&&(b.style.display="none"),n.off("input",B)}function E(){s=null,clearTimeout(s);var _=n.selection.getRange(),P=_.contains(c.row,c.column);!_.isEmpty()&&P||(n.selection.moveToPosition(c),n.selection.selectWord()),I="wait",T()}p.addListener(l,"contextmenu",function(_){d&&n.textInput.getElement().focus()},n),p.addListener(l,"touchstart",function(_){var P=_.touches;if(s||1<P.length)clearTimeout(s),s=null,e=-1,I="zoom";else{d=n.$mouseHandler.isMousePressed=!0;var H=n.renderer.layerConfig.lineHeight,z=n.renderer.layerConfig.lineHeight,K=_.timeStamp,Y=(r=K,P[0]),R=Y.clientX,Y=Y.clientY,R=(Math.abs(i-R)+Math.abs(t-Y)>H&&(e=-1),i=_.clientX=R,t=_.clientY=Y,y=w=0,new x(_,n));if(c=R.getDocumentPosition(),K-e<500&&P.length==1&&!h)u++,_.preventDefault(),_.button=0,s=null,clearTimeout(s),n.selection.moveToPosition(c),(Y=2<=u?n.selection.getLineRange(c.row):n.session.getBracketRange(c))&&!Y.isEmpty()?n.selection.setRange(Y):n.selection.selectWord(),I="wait";else{u=0;var R=n.selection.cursor,P=n.selection.isEmpty()?R:n.selection.anchor,Y=n.renderer.$cursorLayer.getPixelPosition(R,!0),R=n.renderer.$cursorLayer.getPixelPosition(P,!0),P=n.renderer.scroller.getBoundingClientRect(),Z=n.renderer.layerConfig.offset,W=n.renderer.scrollLeft,f=function(j,Q){return(j/=z)*j+(Q=Q/H-.75)*Q};if(_.clientX<P.left)return void(I="zoom");Y=f(_.clientX-P.left-Y.left+W,_.clientY-P.top-Y.top+Z),f=f(_.clientX-P.left-R.left+W,_.clientY-P.top-R.top+Z),Y<3.5&&f<3.5&&(I=f<Y?"cursor":"anchor"),I=f<3.5?"anchor":Y<3.5?"cursor":"scroll",s=setTimeout(E,450)}e=K}},n),p.addListener(l,"touchend",function(_){d=n.$mouseHandler.isMousePressed=!1,o&&clearInterval(o),I=="zoom"?(I="",h=0):(s?(n.selection.moveToPosition(c),h=0,T):I=="scroll"?(h+=60,o=setInterval(function(){h--<=0&&(clearInterval(o),o=null),Math.abs(y)<.01&&(y=0),Math.abs(w)<.01&&(w=0),h<20&&(y*=.9),h<20&&(w*=.9);var P=n.session.getScrollTop();n.renderer.scrollBy(10*y,10*w),P==n.session.getScrollTop()&&(h=0)},10),B):T)(),clearTimeout(s),s=null},n),p.addListener(l,"touchmove",function(_){s&&(clearTimeout(s),s=null);var P=_.touches;if(!(1<P.length||I=="zoom")){var P=P[0],H=i-P.clientX,z=t-P.clientY;if(I=="wait"){if(!(4<H*H+z*z))return _.preventDefault();I="cursor"}i=P.clientX,t=P.clientY,_.clientX=P.clientX,_.clientY=P.clientY;var P=_.timeStamp,K=P-r;r=P,I=="scroll"?((P=new x(_,n)).speed=1,P.wheelX=H,P.wheelY=z,10*Math.abs(H)<Math.abs(z)&&(H=0),10*Math.abs(z)<Math.abs(H)&&(z=0),K!=0&&(y=H/K,w=z/K),n._emit("mousewheel",P),P.propagationStopped||(y=w=0)):(H=new x(_,n).getDocumentPosition(),I=="cursor"?n.selection.moveCursorToPosition(H):I=="anchor"&&n.selection.setSelectionAnchor(H.row,H.column),n.renderer.scrollCursorIntoView(H),_.preventDefault())}},n)}}),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/mouse/touch_handler","ace/config"],function(r,m,A){function x(s){function o(I){document.hasFocus&&document.hasFocus()&&(s.isFocused()||document.activeElement!=(s.textInput&&s.textInput.getElement()))||window.focus(),s.focus(),setTimeout(function(){s.isFocused()||s.focus()})}var c=this,d=(this.editor=s,new l(this),new n(this),new t(this),s.renderer.getMouseEventTarget()),b=(p.addListener(d,"click",this.onMouseEvent.bind(this,"click"),s),p.addListener(d,"mousemove",this.onMouseMove.bind(this,"mousemove"),s),p.addMultiMouseDownListener([d,s.renderer.scrollBarV&&s.renderer.scrollBarV.inner,s.renderer.scrollBarH&&s.renderer.scrollBarH.inner,s.textInput&&s.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent",s),p.addMouseWheelListener(s.container,this.onMouseWheel.bind(this,"mousewheel"),s),e(s.container,s),s.renderer.$gutter);p.addListener(b,"mousedown",this.onMouseEvent.bind(this,"guttermousedown"),s),p.addListener(b,"click",this.onMouseEvent.bind(this,"gutterclick"),s),p.addListener(b,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick"),s),p.addListener(b,"mousemove",this.onMouseEvent.bind(this,"guttermousemove"),s),p.addListener(d,"mousedown",o,s),p.addListener(b,"mousedown",o,s),a.isIE&&s.renderer.scrollBarV&&(p.addListener(s.renderer.scrollBarV.element,"mousedown",o,s),p.addListener(s.renderer.scrollBarH.element,"mousedown",o,s)),s.on("mousemove",function(I){var h,u;c.state||c.$dragDelay||!c.$dragEnabled||(I=s.renderer.screenToTextCoordinates(I.x,I.y),h=s.session.selection.getRange(),u=s.renderer,!h.isEmpty()&&h.insideStart(I.row,I.column)?u.setCursorStyle("default"):u.setCursorStyle(""))},s)}var p=r("../lib/event"),a=r("../lib/useragent"),l=r("./default_handlers").DefaultHandlers,n=r("./default_gutter_handler").GutterHandler,i=r("./mouse_event").MouseEvent,t=r("./dragdrop_handler").DragdropHandler,e=r("./touch_handler").addTouchListeners,r=r("../config");(function(){this.onMouseEvent=function(s,o){this.editor.session&&this.editor._emit(s,new i(o,this.editor))},this.onMouseMove=function(s,o){var c=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;c&&c.length&&this.editor._emit(s,new i(o,this.editor))},this.onMouseWheel=function(s,o){var c=new i(o,this.editor);c.speed=2*this.$scrollSpeed,c.wheelX=o.wheelX,c.wheelY=o.wheelY,this.editor._emit(s,c)},this.setState=function(s){this.state=s},this.captureMouse=function(s,o){this.x=s.x,this.y=s.y,this.isMousePressed=!0;function c(v){if(v){if(a.isWebKit&&!v.which&&u.releaseMouse)return u.releaseMouse();u.x=v.clientX,u.y=v.clientY,o&&o(v),u.mouseEvent=new i(v,u.editor),u.$mouseMoved=!0}}function d(v){I.off("beforeEndOperation",y),clearInterval(w),I.session&&b(),u[u.state+"End"]&&u[u.state+"End"](v),u.state="",u.isMousePressed=h.$isMousePressed=!1,h.$keepTextAreaAtCursor&&h.$moveTextAreaToCursor(),u.$onCaptureMouseMove=u.releaseMouse=null,v&&u.onMouseEvent("mouseup",v),I.endOperation()}function b(){u[u.state]&&u[u.state](),u.$mouseMoved=!1}var I=this.editor,h=this.editor.renderer,u=(h.$isMousePressed=!0,this);if(a.isOldIE&&s.domEvent.type=="dblclick")return setTimeout(function(){d(s)});var y=function(v){u.releaseMouse&&I.curOp.command.name&&I.curOp.selectionChanged&&(u[u.state+"End"]&&u[u.state+"End"](),u.state="",u.releaseMouse())},w=(I.on("beforeEndOperation",y),I.startOperation({command:{name:"mouse"}}),u.$onCaptureMouseMove=c,u.releaseMouse=p.capture(this.editor.container,c,d),setInterval(b,20))},this.releaseMouse=null,this.cancelContextMenu=function(){var s=function(o){o&&o.domEvent&&o.domEvent.type!="contextmenu"||(this.editor.off("nativecontextmenu",s),o&&o.domEvent&&p.stopEvent(o.domEvent))}.bind(this);setTimeout(s,10),this.editor.on("nativecontextmenu",s)},this.destroy=function(){this.releaseMouse&&this.releaseMouse()}}).call(x.prototype),r.defineOptions(x.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:a.isMac?150:0},dragEnabled:{initialValue:!0},focusTimeout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),m.MouseHandler=x}),ace.define("ace/mouse/fold_handler",["require","exports","module","ace/lib/dom"],function(C,m,A){var x=C("../lib/dom");m.FoldHandler=function(p){p.on("click",function(a){var n=a.getDocumentPosition(),l=p.session,n=l.getFoldAt(n.row,n.column,1),n=(n&&(a.getAccelKey()?l.removeFold(n):l.expandFold(n),a.stop()),a.domEvent&&a.domEvent.target);n&&x.hasCssClass(n,"ace_inline_button")&&x.hasCssClass(n,"ace_toggle_wrap")&&(l.setOption("wrap",!l.getUseWrapMode()),p.renderer.scrollCursorIntoView())}),p.on("gutterclick",function(a){var l,n;p.renderer.$gutterLayer.getRegion(a)=="foldWidgets"&&(l=a.getDocumentPosition().row,(n=p.session).foldWidgets&&n.foldWidgets[l]&&p.session.onFoldWidgetClick(l,a),p.isFocused()||p.focus(),a.stop())}),p.on("gutterdblclick",function(a){var l,n,i;p.renderer.$gutterLayer.getRegion(a)=="foldWidgets"&&(i=a.getDocumentPosition().row,(n=(n=(l=p.session).getParentFoldRangeData(i,!0)).range||n.firstRange)&&(i=n.start.row,(i=l.getFoldAt(i,l.getLine(i).length,1))?l.removeFold(i):(l.addFold("...",n),p.renderer.scrollCursorIntoView({row:n.start.row,column:0}))),a.stop())})}}),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],function(C,m,A){function x(l){this.$editor=l,this.$data={editor:l},this.$handlers=[],this.setDefaultHandler(l.commands)}var p=C("../lib/keys"),a=C("../lib/event");(function(){this.setDefaultHandler=function(l){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=l,this.addKeyboardHandler(l,0)},this.setKeyboardHandler=function(l){var n=this.$handlers;if(n[n.length-1]!=l){for(;n[n.length-1]&&n[n.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(n[n.length-1]);this.addKeyboardHandler(l,1)}},this.addKeyboardHandler=function(l,n){var i;l&&(typeof l!="function"||l.handleKeyboard||(l.handleKeyboard=l),(i=this.$handlers.indexOf(l))!=-1&&this.$handlers.splice(i,1),n==null?this.$handlers.push(l):this.$handlers.splice(n,0,l),i==-1&&l.attach&&l.attach(this.$editor))},this.removeKeyboardHandler=function(l){var n=this.$handlers.indexOf(l);return n!=-1&&(this.$handlers.splice(n,1),l.detach&&l.detach(this.$editor),!0)},this.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},this.getStatusText=function(){var l=this.$data,n=l.editor;return this.$handlers.map(function(i){return i.getStatusText&&i.getStatusText(n,l)||""}).filter(Boolean).join(" ")},this.$callKeyboardHandlers=function(l,n,i,t){for(var e,r=!1,s=this.$editor.commands,o=this.$handlers.length;o--&&!((e=this.$handlers[o].handleKeyboard(this.$data,l,n,i,t))&&e.command&&((r=e.command=="null"||s.exec(e.command,this.$editor,e.args,t))&&t&&l!=-1&&e.passEvent!=1&&e.command.passEvent!=1&&a.stopEvent(t),r)););return r||l!=-1||(e={command:"insertstring"},r=s.exec("insertstring",this.$editor,n)),r&&this.$editor._signal&&this.$editor._signal("keyboardActivity",e),r},this.onCommandKey=function(l,n,i){var t=p.keyCodeToString(i);return this.$callKeyboardHandlers(n,t,i,l)},this.onTextInput=function(l){return this.$callKeyboardHandlers(-1,l)}}).call(x.prototype),m.KeyBinding=x}),ace.define("ace/lib/bidiutil",["require","exports","module"],function(C,m,A){var x=0,p=0,a=!1,l=!1,n=!1,i=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],t=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],e=0,r=1,s=2,o=3,c=4,d=5,b=6,I=7,h=8,u=9,y=10,w=11,v=12,T=13,B=14,E=15,_=16,P=17,H=18,z=[H,H,H,H,H,H,H,H,H,b,d,b,h,d,H,H,H,H,H,H,H,H,H,H,H,H,H,H,d,d,d,b,h,c,c,w,w,w,c,c,c,c,c,y,u,y,u,u,s,s,s,s,s,s,s,s,s,s,u,c,c,c,c,c,c,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,c,c,c,c,c,c,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,c,c,c,c,H,H,H,H,H,H,d,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,H,u,c,w,w,w,w,c,c,c,c,e,c,c,H,c,c,w,w,s,s,c,e,c,c,c,s,e,c,c,c,c,c],K=[h,h,h,h,h,h,h,h,h,h,h,H,H,H,e,r,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,h,d,T,B,E,_,P,u,w,w,w,w,w,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,u,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,h];function Y(W,f,S,$){var F,j,Q,te=x?t:i,he=0,ve=-1,ue=null,fe=null,Ce=[];if(!$)for(ue=0,$=[];ue<S;ue++)$[ue]=Z(W[ue]);for(p=x,n=l=a=!1,fe=0;fe<S;fe++){if(Q=he,Ce[fe]=F=function(Ee,Re,we,de){var Te,ae,ge,le=Re[de];switch(le){case e:case r:a=!1;case c:case o:return le;case s:return a?o:s;case I:return a=!0,r;case h:return c;case u:return de<1||de+1>=Re.length||(Te=we[de-1])!=s&&Te!=o||(ce=Re[de+1])!=s&&ce!=o?c:(ce=a?o:ce)==Te?ce:c;case y:return(Te=0<de?we[de-1]:d)==s&&de+1<Re.length&&Re[de+1]==s?s:c;case w:if(0<de&&we[de-1]==s)return s;if(a)return c;for(ge=de+1,ae=Re.length;ge<ae&&Re[ge]==w;)ge++;return ge<ae&&Re[ge]==s?s:c;case v:for(ae=Re.length,ge=de+1;ge<ae&&Re[ge]==v;)ge++;if(ge<ae){var ce=Ee[de],ce=1425<=ce&&ce<=2303||ce==64286;if(Te=Re[ge],ce&&(Te==r||Te==I))return r}return de<1||(Te=Re[de-1])==d?c:we[de-1];case d:return l=!(a=!1),x;case b:return n=!0,c;case T:case B:case _:case P:case E:a=!1;case H:return c}}(W,$,Ce,fe),Q=240&(he=te[Q][F]),he&=15,f[fe]=j=te[he][5],0<Q){if(Q==16)for(ue=ve;ue<fe;ue++)f[ue]=1;ve=-1}if(te[he][6])ve==-1&&(ve=fe);else if(-1<ve){for(ue=ve;ue<fe;ue++)f[ue]=j;ve=-1}$[fe]==d&&(f[fe]=0),p|=j}if(n){for(ue=0;ue<S;ue++)if($[ue]==b){f[ue]=x;for(var Ae=ue-1;0<=Ae&&$[Ae]==h;Ae--)f[Ae]=x}}}function R(W,f,S){if(!(p<W))if(W!=1||x!=1||l)for(var $,F,j,Q,te=S.length,he=0;he<te;){if(f[he]>=W){for($=he+1;$<te&&f[$]>=W;)$++;for(F=he,j=$-1;F<j;F++,j--)Q=S[F],S[F]=S[j],S[j]=Q;he=$}he++}else S.reverse()}function Z(W){var f=W.charCodeAt(0),S=f>>8;return S==0?191<f?e:z[f]:S==5?/[\u0591-\u05f4]/.test(W)?r:e:S==6?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(W)?v:/[\u0660-\u0669\u066b-\u066c]/.test(W)?o:f==1642?w:/[\u06f0-\u06f9]/.test(W)?s:I:S==32&&f<=8287?K[255&f]:S==254&&65136<=f?I:c}m.L=e,m.R=r,m.EN=s,m.ON_R=3,m.AN=4,m.R_H=5,m.B=6,m.RLE=7,m.DOT="\xB7",m.doBidiReorder=function(W,f,S){if(W.length<2)return{};var $=W.split(""),F=new Array($.length),j=new Array($.length),Q=[];x=S?1:0,Y($,Q,$.length,f);for(var te=0;te<F.length;F[te]=te,te++);for(R(2,Q,F),R(1,Q,F),te=0;te<F.length-1;te++)f[te]===o?Q[te]=m.AN:Q[te]===r&&(f[te]>I&&f[te]<T||f[te]===c||f[te]===H)?Q[te]=m.ON_R:0<te&&$[te-1]==="\u0644"&&/\u0622|\u0623|\u0625|\u0627/.test($[te])&&(Q[te-1]=Q[te]=m.R_H,te++);for($[$.length-1]===m.DOT&&(Q[$.length-1]=m.B),$[0]==="\u202B"&&(Q[0]=m.RLE),te=0;te<F.length;te++)j[te]=Q[F[te]];return{logicalFromVisual:F,bidiLevels:j}},m.hasBidiCharacters=function(W,f){for(var S=!1,$=0;$<W.length;$++)f[$]=Z(W.charAt($)),S||f[$]!=r&&f[$]!=I&&f[$]!=o||(S=!0);return S},m.getVisualFromLogicalIdx=function(W,f){for(var S=0;S<f.logicalFromVisual.length;S++)if(f.logicalFromVisual[S]==W)return S;return 0}}),ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang"],function(C,m,A){function x(n){this.session=n,this.bidiMap={},this.currentRow=null,this.bidiUtil=p,this.charWidths=[],this.EOL="\xAC",this.showInvisibles=!0,this.isRtlDir=!1,this.$isRtl=!1,this.line="",this.wrapIndent=0,this.EOF="\xB6",this.RLE="\u202B",this.contentWidth=0,this.fontMetrics=null,this.rtlLineOffset=0,this.wrapOffset=0,this.isMoveLeftOperation=!1,this.seenBidi=l.test(n.getValue())}var p=C("./lib/bidiutil"),a=C("./lib/lang"),l=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\u202B]/;(function(){this.isBidiRow=function(n,i,t){return!!this.seenBidi&&(n!==this.currentRow&&(this.currentRow=n,this.updateRowLine(i,t),this.updateBidiMap()),this.bidiMap.bidiLevels)},this.onChange=function(n){this.seenBidi?this.currentRow=null:n.action=="insert"&&l.test(n.lines.join(`
`))&&(this.seenBidi=!0,this.currentRow=null)},this.getDocumentRow=function(){var n=0,i=this.session.$screenRowCache;return n=i.length&&0<=(i=this.session.$getRowCacheIndex(i,this.currentRow))?this.session.$docRowCache[i]:n},this.getSplitIndex=function(){var n=0,i=this.session.$screenRowCache;if(i.length)for(var t,e=this.session.$getRowCacheIndex(i,this.currentRow);0<this.currentRow-n&&(t=this.session.$getRowCacheIndex(i,this.currentRow-n-1))===e;)e=t,n++;else n=this.currentRow;return n},this.updateRowLine=function(n,i){var t,e=(n=n===void 0?this.getDocumentRow():n)===this.session.getLength()-1?this.EOF:this.EOL,r=(this.wrapIndent=0,this.line=this.session.getLine(n),this.isRtlDir=this.$isRtl||this.line.charAt(0)===this.RLE,this.session.$useWrapMode?(n=this.session.$wrapData[n])&&(0<(i=i===void 0?this.getSplitIndex():i)&&n.length?(this.wrapIndent=n.indent,this.wrapOffset=this.wrapIndent*this.charWidths[p.L],this.line=i<n.length?this.line.substring(n[i-1],n[i]):this.line.substring(n[n.length-1])):this.line=this.line.substring(0,n[i]),i==n.length&&(this.line+=this.showInvisibles?e:p.DOT)):this.line+=this.showInvisibles?e:p.DOT,this.session),s=0;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,function(o,c){return o==="	"||r.isFullWidth(o.charCodeAt(0))?(t=o==="	"?r.getScreenTabSize(c+s):2,s+=t-1,a.stringRepeat(p.DOT,t)):o}),this.isRtlDir&&(this.fontMetrics.$main.textContent=this.line.charAt(this.line.length-1)==p.DOT?this.line.substr(0,this.line.length-1):this.line,this.rtlLineOffset=this.contentWidth-this.fontMetrics.$main.getBoundingClientRect().width)},this.updateBidiMap=function(){var n=[];p.hasBidiCharacters(this.line,n)||this.isRtlDir?this.bidiMap=p.doBidiReorder(this.line,n,this.isRtlDir):this.bidiMap={}},this.markAsDirty=function(){this.currentRow=null},this.updateCharacterWidths=function(n){var i;this.characterWidth!==n.$characterSize.width&&(this.fontMetrics=n,i=this.characterWidth=n.$characterSize.width,n=n.$measureCharWidth("\u05D4"),this.charWidths[p.L]=this.charWidths[p.EN]=this.charWidths[p.ON_R]=i,this.charWidths[p.R]=this.charWidths[p.AN]=n,this.charWidths[p.R_H]=.45*n,this.charWidths[p.B]=this.charWidths[p.RLE]=0,this.currentRow=null)},this.setShowInvisibles=function(n){this.showInvisibles=n,this.currentRow=null},this.setEolChar=function(n){this.EOL=n},this.setContentWidth=function(n){this.contentWidth=n},this.isRtlLine=function(n){return!!this.$isRtl||(n!=null?this.session.getLine(n).charAt(0)==this.RLE:this.isRtlDir)},this.setRtlDirection=function(n,i){for(var t=n.getCursorPosition(),e=n.selection.getSelectionAnchor().row;e<=t.row;e++)i||n.session.getLine(e).charAt(0)!==n.session.$bidiHandler.RLE?i&&n.session.getLine(e).charAt(0)!==n.session.$bidiHandler.RLE&&n.session.doc.insert({column:0,row:e},n.session.$bidiHandler.RLE):n.session.doc.removeInLine(e,0,1)},this.getPosLeft=function(n){n-=this.wrapIndent;var i=this.line.charAt(0)===this.RLE?1:0,t=i<n?this.session.getOverwrite()?n:n-1:i,e=p.getVisualFromLogicalIdx(t,this.bidiMap),r=this.bidiMap.bidiLevels,s=0;!this.session.getOverwrite()&&n<=i&&r[e]%2!=0&&e++;for(var o=0;o<e;o++)s+=this.charWidths[r[o]];return!this.session.getOverwrite()&&i<n&&r[e]%2==0&&(s+=this.charWidths[r[e]]),this.wrapIndent&&(s+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset),this.isRtlDir&&(s+=this.rtlLineOffset),s},this.getSelections=function(n,i){var t,e=this.bidiMap,r=e.bidiLevels,s=[],o=0,c=Math.min(n,i)-this.wrapIndent,d=Math.max(n,i)-this.wrapIndent,b=!1,I=!1,h=0;this.wrapIndent&&(o+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);for(var u,y=0;y<r.length;y++)u=e.logicalFromVisual[y],t=r[y],(b=c<=u&&u<d)&&!I?h=o:!b&&I&&s.push({left:h,width:o-h}),o+=this.charWidths[t],I=b;if(b&&y===r.length&&s.push({left:h,width:o-h}),this.isRtlDir)for(var w=0;w<s.length;w++)s[w].left+=this.rtlLineOffset;return s},this.offsetToCol=function(t){this.isRtlDir&&(t-=this.rtlLineOffset);var i=0,t=Math.max(t,0),e=0,r=0,s=this.bidiMap.bidiLevels,o=this.charWidths[s[r]];for(this.wrapIndent&&(t-=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);e+o/2<t;){if(e+=o,r===s.length-1){o=0;break}o=this.charWidths[s[++r]]}return(i=0<r&&s[r-1]%2!=0&&s[r]%2==0?(t<e&&r--,this.bidiMap.logicalFromVisual[r]):0<r&&s[r-1]%2==0&&s[r]%2!=0?1+(e<t?this.bidiMap.logicalFromVisual[r]:this.bidiMap.logicalFromVisual[r-1]):this.isRtlDir&&r===s.length-1&&o===0&&s[r-1]%2==0||!this.isRtlDir&&r===0&&s[r]%2!=0?1+this.bidiMap.logicalFromVisual[r]:(0<r&&s[r-1]%2!=0&&o!==0&&r--,this.bidiMap.logicalFromVisual[r]))===0&&this.isRtlDir&&i++,i+this.wrapIndent}}).call(x.prototype),m.BidiHandler=x}),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],function(C,m,A){function x(i){this.session=i,this.doc=i.getDocument(),this.clearSelection(),this.cursor=this.lead=this.doc.createAnchor(0,0),this.anchor=this.doc.createAnchor(0,0),this.$silent=!1;var t=this;this.cursor.on("change",function(e){t.$cursorChanged=!0,t.$silent||t._emit("changeCursor"),t.$isEmpty||t.$silent||t._emit("changeSelection"),t.$keepDesiredColumnOnChange||e.old.column==e.value.column||(t.$desiredColumn=null)}),this.anchor.on("change",function(){t.$anchorChanged=!0,t.$isEmpty||t.$silent||t._emit("changeSelection")})}var p=C("./lib/oop"),a=C("./lib/lang"),l=C("./lib/event_emitter").EventEmitter,n=C("./range").Range;(function(){p.implement(this,l),this.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},this.isMultiLine=function(){return!this.$isEmpty&&this.anchor.row!=this.cursor.row},this.getCursor=function(){return this.lead.getPosition()},this.setSelectionAnchor=function(i,t){this.$isEmpty=!1,this.anchor.setPosition(i,t)},this.getAnchor=this.getSelectionAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},this.getSelectionLead=function(){return this.lead.getPosition()},this.isBackwards=function(){var i=this.anchor,t=this.lead;return i.row>t.row||i.row==t.row&&i.column>t.column},this.getRange=function(){var i=this.anchor,t=this.lead;return this.$isEmpty?n.fromPoints(t,t):this.isBackwards()?n.fromPoints(t,i):n.fromPoints(i,t)},this.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},this.selectAll=function(){this.$setSelection(0,0,Number.MAX_VALUE,Number.MAX_VALUE)},this.setRange=this.setSelectionRange=function(i,r){var e=r?i.end:i.start,r=r?i.start:i.end;this.$setSelection(e.row,e.column,r.row,r.column)},this.$setSelection=function(i,t,e,r){var s,o;this.$silent||(s=this.$isEmpty,o=this.inMultiSelectMode,this.$silent=!0,this.$cursorChanged=this.$anchorChanged=!1,this.anchor.setPosition(i,t),this.cursor.setPosition(e,r),this.$isEmpty=!n.comparePoints(this.anchor,this.cursor),this.$silent=!1,this.$cursorChanged&&this._emit("changeCursor"),(this.$cursorChanged||this.$anchorChanged||s!=this.$isEmpty||o)&&this._emit("changeSelection"))},this.$moveSelection=function(i){var t=this.lead;this.$isEmpty&&this.setSelectionAnchor(t.row,t.column),i.call(this)},this.selectTo=function(i,t){this.$moveSelection(function(){this.moveCursorTo(i,t)})},this.selectToPosition=function(i){this.$moveSelection(function(){this.moveCursorToPosition(i)})},this.moveTo=function(i,t){this.clearSelection(),this.moveCursorTo(i,t)},this.moveToPosition=function(i){this.clearSelection(),this.moveCursorToPosition(i)},this.selectUp=function(){this.$moveSelection(this.moveCursorUp)},this.selectDown=function(){this.$moveSelection(this.moveCursorDown)},this.selectRight=function(){this.$moveSelection(this.moveCursorRight)},this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},this.getWordRange=function(i,t){var e;return t===void 0&&(i=(e=i||this.lead).row,t=e.column),this.session.getWordRange(i,t)},this.selectWord=function(){this.setSelectionRange(this.getWordRange())},this.selectAWord=function(){var i=this.getCursor(),i=this.session.getAWordRange(i.row,i.column);this.setSelectionRange(i)},this.getLineRange=function(e,t){var e=typeof e=="number"?e:this.lead.row,r=this.session.getFoldLine(e),r=r?(e=r.start.row,r.end.row):e;return t===!0?new n(e,0,r,this.session.getLine(r).length):new n(e,0,r+1,0)},this.selectLine=function(){this.setSelectionRange(this.getLineRange())},this.moveCursorUp=function(){this.moveCursorBy(-1,0)},this.moveCursorDown=function(){this.moveCursorBy(1,0)},this.wouldMoveIntoSoftTab=function(i,t,e){var r=i.column,s=i.column+t;return e<0&&(r=i.column-t,s=i.column),this.session.isTabStop(i)&&this.doc.getLine(i.row).slice(r,s).split(" ").length-1==t},this.moveCursorLeft=function(){var i,t=this.lead.getPosition();(i=this.session.getFoldAt(t.row,t.column,-1))?this.moveCursorTo(i.start.row,i.start.column):t.column===0?0<t.row&&this.moveCursorTo(t.row-1,this.doc.getLine(t.row-1).length):(i=this.session.getTabSize(),this.wouldMoveIntoSoftTab(t,i,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-i):this.moveCursorBy(0,-1))},this.moveCursorRight=function(){var i,t=this.lead.getPosition();(i=this.session.getFoldAt(t.row,t.column,1))?this.moveCursorTo(i.end.row,i.end.column):this.lead.column==this.doc.getLine(this.lead.row).length?this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0):(i=this.session.getTabSize(),t=this.lead,this.wouldMoveIntoSoftTab(t,i,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,i):this.moveCursorBy(0,1))},this.moveCursorLineStart=function(){var e=this.lead.row,i=this.lead.column,t=this.session.documentToScreenRow(e,i),t=this.session.screenToDocumentPosition(t,0),e=this.session.getDisplayLine(e,null,t.row,t.column).match(/^\s*/);e[0].length==i||this.session.$useEmacsStyleLineStart||(t.column+=e[0].length),this.moveCursorToPosition(t)},this.moveCursorLineEnd=function(){var i,t=this.lead,t=this.session.getDocumentLastRowColumnPosition(t.row,t.column);this.lead.column==t.column&&(i=this.session.getLine(t.row),t.column==i.length&&0<(i=i.search(/\s+$/))&&(t.column=i)),this.moveCursorTo(t.row,t.column)},this.moveCursorFileEnd=function(){var i=this.doc.getLength()-1,t=this.doc.getLine(i).length;this.moveCursorTo(i,t)},this.moveCursorFileStart=function(){this.moveCursorTo(0,0)},this.moveCursorLongWordRight=function(){var i=this.lead.row,t=this.lead.column,e=this.doc.getLine(i),r=e.substring(t),s=(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.getFoldAt(i,t,1));s?this.moveCursorTo(s.end.row,s.end.column):(this.session.nonTokenRe.exec(r)&&(t+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,r=e.substring(t)),t>=e.length?(this.moveCursorTo(i,e.length),this.moveCursorRight(),i<this.doc.getLength()-1&&this.moveCursorWordRight()):(this.session.tokenRe.exec(r)&&(t+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(i,t)))},this.moveCursorLongWordLeft=function(){var i,t=this.lead.row,e=this.lead.column;(i=this.session.getFoldAt(t,e,-1))?this.moveCursorTo(i.start.row,i.start.column):((i=this.session.getFoldStringAt(t,e,-1))==null&&(i=this.doc.getLine(t).substring(0,e)),i=a.stringReverse(i),this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(i)&&(e-=this.session.nonTokenRe.lastIndex,i=i.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),e<=0?(this.moveCursorTo(t,0),this.moveCursorLeft(),0<t&&this.moveCursorWordLeft()):(this.session.tokenRe.exec(i)&&(e-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(t,e)))},this.$shortWordEndIndex=function(i){var t,e=0,r=/\s/,s=this.session.tokenRe;if(s.lastIndex=0,this.session.tokenRe.exec(i))e=this.session.tokenRe.lastIndex;else{for(;(t=i[e])&&r.test(t);)e++;if(e<1){for(s.lastIndex=0;(t=i[e])&&!s.test(t);)if(s.lastIndex=0,e++,r.test(t)){if(2<e){e--;break}for(;(t=i[e])&&r.test(t);)e++;if(2<e)break}}}return s.lastIndex=0,e},this.moveCursorShortWordRight=function(){var i=this.lead.row,t=this.lead.column,e=this.doc.getLine(i),r=e.substring(t),s=this.session.getFoldAt(i,t,1);if(s)return this.moveCursorTo(s.end.row,s.end.column);if(t==e.length){for(var o=this.doc.getLength();r=this.doc.getLine(++i),i<o&&/^\s*$/.test(r););/^\s+/.test(r)||(r=""),t=0}s=this.$shortWordEndIndex(r),this.moveCursorTo(i,t+s)},this.moveCursorShortWordLeft=function(){var i=this.lead.row,t=this.lead.column;if(r=this.session.getFoldAt(i,t,-1))return this.moveCursorTo(r.start.row,r.start.column);var e=this.session.getLine(i).substring(0,t);if(t===0){for(;e=this.doc.getLine(--i),0<i&&/^\s*$/.test(e););t=e.length,/\s+$/.test(e)||(e="")}var r=a.stringReverse(e),r=this.$shortWordEndIndex(r);return this.moveCursorTo(i,t-r)},this.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},this.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},this.moveCursorBy=function(i,t){var e,r=this.session.documentToScreenPosition(this.lead.row,this.lead.column),s=(t===0&&(i!==0&&(this.session.$bidiHandler.isBidiRow(r.row,this.lead.row)?(e=this.session.$bidiHandler.getPosLeft(r.column),r.column=Math.round(e/this.session.$bidiHandler.charWidths[0])):e=r.column*this.session.$bidiHandler.charWidths[0]),this.$desiredColumn?r.column=this.$desiredColumn:this.$desiredColumn=r.column),i!=0&&this.session.lineWidgets&&this.session.lineWidgets[this.lead.row]&&(s=this.session.lineWidgets[this.lead.row],i<0?i-=s.rowsAbove||0:0<i&&(i+=s.rowCount-(s.rowsAbove||0))),this.session.screenToDocumentPosition(r.row+i,r.column,e));i!==0&&t===0&&s.row===this.lead.row&&(s.column,this.lead.column),this.moveCursorTo(s.row,s.column+t,t===0)},this.moveCursorToPosition=function(i){this.moveCursorTo(i.row,i.column)},this.moveCursorTo=function(i,t,e){var r=this.session.getFoldAt(i,t,1),r=(r&&(i=r.start.row,t=r.start.column),this.$keepDesiredColumnOnChange=!0,this.session.getLine(i));/[\uDC00-\uDFFF]/.test(r.charAt(t))&&r.charAt(t-1)&&(this.lead.row==i&&this.lead.column==t+1?t-=1:t+=1),this.lead.setPosition(i,t),this.$keepDesiredColumnOnChange=!1,e||(this.$desiredColumn=null)},this.moveCursorToScreen=function(i,t,e){i=this.session.screenToDocumentPosition(i,t),this.moveCursorTo(i.row,i.column,e)},this.detach=function(){this.lead.detach(),this.anchor.detach()},this.fromOrientedRange=function(i){this.setSelectionRange(i,i.cursor==i.start),this.$desiredColumn=i.desiredColumn||this.$desiredColumn},this.toOrientedRange=function(i){var t=this.getRange();return i?(i.start.column=t.start.column,i.start.row=t.start.row,i.end.column=t.end.column,i.end.row=t.end.row):i=t,i.cursor=this.isBackwards()?i.start:i.end,i.desiredColumn=this.$desiredColumn,i},this.getRangeOfMovements=function(i){var t=this.getCursor();try{i(this);var e=this.getCursor();return n.fromPoints(t,e)}catch{return n.fromPoints(t,t)}finally{this.moveCursorToPosition(t)}},this.toJSON=function(){var i;return this.rangeCount?i=this.ranges.map(function(t){var e=t.clone();return e.isBackwards=t.cursor==t.start,e}):(i=this.getRange()).isBackwards=this.isBackwards(),i},this.fromJSON=function(i){if(i.start==null){if(this.rangeList&&1<i.length){this.toSingleRange(i[0]);for(var t=i.length;t--;){var e=n.fromPoints(i[t].start,i[t].end);i[t].isBackwards&&(e.cursor=e.start),this.addRange(e,!0)}return}i=i[0]}this.rangeList&&this.toSingleRange(i),this.setSelectionRange(i,i.isBackwards)},this.isEqual=function(i){if((i.length||this.rangeCount)&&i.length!=this.rangeCount)return!1;if(!i.length||!this.ranges)return this.getRange().isEqual(i);for(var t=this.ranges.length;t--;)if(!this.ranges[t].isEqual(i[t]))return!1;return!0}}).call(x.prototype),m.Selection=x}),ace.define("ace/tokenizer",["require","exports","module","ace/config"],function(C,m,A){function x(l){for(var n in this.states=l,this.regExps={},this.matchMappings={},this.states){for(var i=this.states[n],t=[],e=0,r=this.matchMappings[n]={defaultToken:"text"},s="g",o=[],c=0;c<i.length;c++){var d,b,I=i[c];I.defaultToken&&(r.defaultToken=I.defaultToken),I.caseInsensitive&&s.indexOf("i")===-1&&(s+="i"),I.unicode&&s.indexOf("u")===-1&&(s+="u"),I.regex!=null&&(I.regex instanceof RegExp&&(I.regex=I.regex.toString().slice(1,-1)),d=I.regex,b=new RegExp("(?:("+d+")|(.))").exec("a").length-2,Array.isArray(I.token)?I.token.length==1||b==1?I.token=I.token[0]:b-1!=I.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:I,groupCount:b-1}),I.token=I.token[0]):(I.tokenArray=I.token,I.token=null,I.onMatch=this.$arrayTokens):typeof I.token!="function"||I.onMatch||(I.onMatch=1<b?this.$applyToken:I.token),1<b&&(d=/\\\d/.test(I.regex)?I.regex.replace(/\\([0-9]+)/g,function(h,u){return"\\"+(parseInt(u,10)+e+1)}):(b=1,this.removeCapturingGroups(I.regex)),I.splitRegex||typeof I.token=="string"||o.push(I)),r[e]=c,e+=b,t.push(d),I.onMatch||(I.onMatch=null))}t.length||(r[0]=0,t.push("$")),o.forEach(function(h){h.splitRegex=this.createSplitterRegexp(h.regex,s)},this),this.regExps[n]=new RegExp("("+t.join(")|(")+")|($)",s)}}var p=C("./config"),a=2e3;(function(){this.$setMaxTokenCount=function(l){a=0|l},this.$applyToken=function(l){var n=this.splitRegex.exec(l).slice(1),i=this.token.apply(this,n);if(typeof i=="string")return[{type:i,value:l}];for(var t=[],e=0,r=i.length;e<r;e++)n[e]&&(t[t.length]={type:i[e],value:n[e]});return t},this.$arrayTokens=function(l){if(!l)return[];var n=this.splitRegex.exec(l);if(!n)return"text";for(var i=[],t=this.tokenArray,e=0,r=t.length;e<r;e++)n[e+1]&&(i[i.length]={type:t[e],value:n[e+1]});return i},this.removeCapturingGroups=function(l){return l.replace(/\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!<]|(\()/g,function(n,i){return i?"(?:":n})},this.createSplitterRegexp=function(l,n){var i,t,e;return l.indexOf("(?=")!=-1&&(i=0,t=!1,e={},l.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(r,s,o,c,d,b){return t?t=d!="]":d?t=!0:c?(i==e.stack&&(e.end=b+1,e.stack=-1),i--):o&&(i++,o.length!=1&&(e.stack=i,e.start=b)),r}),e.end!=null&&/^\)*$/.test(l.substr(e.end))&&(l=l.substring(0,e.start)+l.substr(e.end))),(l=l.charAt(0)!="^"?"^"+l:l).charAt(l.length-1)!="$"&&(l+="$"),new RegExp(l,(n||"").replace("g",""))},this.getLineTokens=function(l,n){n&&typeof n!="string"?(n=(i=n.slice(0))[0])==="#tmp"&&(i.shift(),n=i.shift()):i=[];for(var i,t,e=n||"start",r=(r=this.states[e])||this.states[e="start"],s=this.matchMappings[e],o=this.regExps[e],c=[],d=o.lastIndex=0,b=0,I={type:null,value:""};t=o.exec(l);){var h,u=s.defaultToken,y=null,w=t[0],v=o.lastIndex;v-w.length>d&&(h=l.substring(d,v-w.length),I.type==u?I.value+=h:(I.type&&c.push(I),I={type:u,value:h}));for(var T=0;T<t.length-2;T++)if(t[T+1]!==void 0){u=(y=r[s[T]]).onMatch?y.onMatch(w,e,i,l):y.token,y.next&&(e=typeof y.next=="string"?y.next:y.next(e,i),(r=this.states[e])||(this.reportError("state doesn't exist",e),r=this.states[e="start"]),s=this.matchMappings[e],(o=this.regExps[e]).lastIndex=d=v),y.consumeLineEnd&&(d=v);break}if(w){if(typeof u=="string")y&&y.merge===!1||I.type!==u?(I.type&&c.push(I),I={type:u,value:w}):I.value+=w;else if(u)for(I.type&&c.push(I),I={type:null,value:""},T=0;T<u.length;T++)c.push(u[T])}if(d==l.length)break;if(d=v,b++>a){for(b>2*l.length&&this.reportError("infinite loop with in ace tokenizer",{startState:n,line:l});d<l.length;)I.type&&c.push(I),I={value:l.substring(d,d+=500),type:"overflow"};e="start",i=[];break}}return I.type&&c.push(I),1<i.length&&i[0]!==e&&i.unshift("#tmp",e),{tokens:c,state:i.length?i:e}},this.reportError=p.reportError}).call(x.prototype),m.Tokenizer=x}),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/lang"],function(C,m,A){function x(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}}var p=C("../lib/lang");(function(){this.addRules=function(n,i){if(i)for(var t in n){for(var e=n[t],r=0;r<e.length;r++){var s=e[r];(s.next||s.onMatch)&&(typeof s.next=="string"&&s.next.indexOf(i)!==0&&(s.next=i+s.next),s.nextState&&s.nextState.indexOf(i)!==0&&(s.nextState=i+s.nextState))}this.$rules[i+t]=e}else for(var t in n)this.$rules[t]=n[t]},this.getRules=function(){return this.$rules},this.embedRules=function(n,i,t,e,r){if(n=typeof n=="function"?new n().getRules():n,e)for(var s=0;s<e.length;s++)e[s]=i+e[s];else for(var o in e=[],n)e.push(i+o);if(this.addRules(n,i),t)for(var c=Array.prototype[r?"push":"unshift"],s=0;s<e.length;s++)c.apply(this.$rules[e[s]],p.deepCopy(t));this.$embeds||(this.$embeds=[]),this.$embeds.push(i)},this.getEmbeds=function(){return this.$embeds};function a(n,i){return n=="start"&&!i.length||i.unshift(this.nextState,n),this.nextState}function l(n,i){return i.shift(),i.shift()||"start"}this.normalizeRules=function(){var n=0,i=this.$rules;Object.keys(i).forEach(function t(e){var r=i[e];r.processed=!0;for(var s=0;s<r.length;s++){var o=r[s],c=null,d=(Array.isArray(o)&&(c=o,o={}),!o.regex&&o.start&&(o.regex=o.start,o.next||(o.next=[]),o.next.push({defaultToken:o.token},{token:o.token+".end",regex:o.end||o.start,next:"pop"}),o.token=o.token+".start",o.push=!0),o.next||o.push);if(d&&Array.isArray(d)?((I=o.stateName)||(typeof(I=o.token)!="string"&&(I=I[0]||""),i[I]&&(I+=n++)),i[I]=d,t(o.next=I)):d=="pop"&&(o.next=l),o.push&&(o.nextState=o.next||o.push,o.next=a,delete o.push),o.rules)for(var b in o.rules)i[b]?i[b].push&&i[b].push.apply(i[b],o.rules[b]):i[b]=o.rules[b];var I=typeof o=="string"?o:o.include;(c=I?Array.isArray(I)?I.map(function(h){return i[h]}):i[I]:c)&&(d=[s,1].concat(c),o.noEscape&&(d=d.filter(function(h){return!h.next})),r.splice.apply(r,d),s--),o.keywordMap&&(o.token=this.createKeywordMapper(o.keywordMap,o.defaultToken||"text",o.caseInsensitive),delete o.defaultToken)}},this)},this.createKeywordMapper=function(n,i,t,e){var r=Object.create(null);return this.$keywordList=[],Object.keys(n).forEach(function(s){for(var o=n[s].split(e||"|"),c=o.length;c--;){var d=o[c];this.$keywordList.push(d),t&&(d=d.toLowerCase()),r[d]=s}},this),n=null,t?function(s){return r[s.toLowerCase()]||i}:function(s){return r[s]||i}},this.getKeywords=function(){return this.$keywords}}).call(x.prototype),m.TextHighlightRules=x}),ace.define("ace/mode/behaviour",["require","exports","module"],function(C,m,A){function x(){this.$behaviours={}}(function(){this.add=function(p,a,l){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[p]:this.$behaviours[p]={}}this.$behaviours[p][a]=l},this.addBehaviours=function(p){for(var a in p)for(var l in p[a])this.add(a,l,p[a][l])},this.remove=function(p){this.$behaviours&&this.$behaviours[p]&&delete this.$behaviours[p]},this.inherit=function(p,a){p=(typeof p=="function"?new p:p).getBehaviours(a),this.addBehaviours(p)},this.getBehaviours=function(p){if(p){for(var a={},l=0;l<p.length;l++)this.$behaviours[p[l]]&&(a[p[l]]=this.$behaviours[p[l]]);return a}return this.$behaviours}}).call(x.prototype),m.Behaviour=x}),ace.define("ace/token_iterator",["require","exports","module","ace/range"],function(C,m,A){function x(a,l,n){this.$session=a,this.$row=l,this.$rowTokens=a.getTokens(l),a=a.getTokenAt(l,n),this.$tokenIndex=a?a.index:-1}var p=C("./range").Range;(function(){this.stepBackward=function(){for(--this.$tokenIndex;this.$tokenIndex<0;){if(--this.$row,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},this.stepForward=function(){var a;for(this.$tokenIndex+=1;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,a=a||this.$session.getLength(),this.$row>=a)return this.$row=a-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},this.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},this.getCurrentTokenRow=function(){return this.$row},this.getCurrentTokenColumn=function(){var a=this.$rowTokens,l=this.$tokenIndex,n=a[l].start;if(n===void 0)for(n=0;0<l;)n+=a[--l].value.length;return n},this.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}},this.getCurrentTokenRange=function(){var a=this.$rowTokens[this.$tokenIndex],l=this.getCurrentTokenColumn();return new p(this.$row,l,this.$row,l+a.value.length)}}).call(x.prototype),m.TokenIterator=x}),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(C,m,A){function x(d){var b=-1;if(d.multiSelect&&(b=d.selection.index,o.rangeCount!=d.multiSelect.rangeCount&&(o={rangeCount:d.multiSelect.rangeCount})),o[b])return l=o[b];l=o[b]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}}function p(d,b,I,h){var u=d.end.row-d.start.row;return{text:I+b+h,selection:[0,d.start.column+1,u,d.end.column+(u?0:1)]}}function a(d){this.add("braces","insertion",function(b,I,h,u,y){var w=h.getCursorPosition(),v=u.doc.getLine(w.row);if(y=="{")return x(h),B=h.getSelectionRange(),(E=u.doc.getTextRange(B))!==""&&E!=="{"&&h.getWrapBehavioursEnabled()?p(B,E,"{","}"):a.isSaneInsertion(h,u)?/[\]\}\)]/.test(v[w.column])||h.inMultiSelectMode||d&&d.braces?(a.recordAutoInsert(h,u,"}"),{text:"{}",selection:[1,1]}):(a.recordMaybeInsert(h,u,"{"),{text:"{",selection:[1,1]}):void 0;if(y=="}"){x(h);var T=v.substring(w.column,w.column+1);if(T=="}"&&u.$findOpeningBracket("}",{column:w.column+1,row:w.row})!==null&&a.isAutoInsertedClosing(w,v,y))return a.popAutoInsertedClosing(),{text:"",selection:[1,1]}}else{if(y==`
`||y==`\r
`){x(h);var B="";if(a.isMaybeInsertedClosing(w,v)&&(B=e.stringRepeat("}",l.maybeInsertedBrackets),a.clearMaybeInsertedClosing()),(T=v.substring(w.column,w.column+1))==="}"){var E=u.findMatchingBracket({row:w.row,column:w.column+1},"}");if(!E)return null;var _=this.$getIndent(u.getLine(E.row))}else{if(!B)return void a.clearMaybeInsertedClosing();_=this.$getIndent(v)}return y=_+u.getTabString(),{text:`
`+y+`
`+_+B,selection:[1,y.length,1,y.length]}}a.clearMaybeInsertedClosing()}}),this.add("braces","deletion",function(b,I,h,u,y){var w=u.doc.getTextRange(y);if(!y.isMultiLine()&&w=="{"){if(x(h),u.doc.getLine(y.start.row).substring(y.end.column,y.end.column+1)=="}")return y.end.column++,y;l.maybeInsertedBrackets--}}),this.add("parens","insertion",function(b,I,h,u,y){if(y=="(")return x(h),w=h.getSelectionRange(),(v=u.doc.getTextRange(w))!==""&&h.getWrapBehavioursEnabled()?p(w,v,"(",")"):a.isSaneInsertion(h,u)?(a.recordAutoInsert(h,u,")"),{text:"()",selection:[1,1]}):void 0;if(y==")"){x(h);var w=h.getCursorPosition(),v=u.doc.getLine(w.row),h=v.substring(w.column,w.column+1);if(h==")"&&u.$findOpeningBracket(")",{column:w.column+1,row:w.row})!==null&&a.isAutoInsertedClosing(w,v,y))return a.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("parens","deletion",function(b,I,h,u,y){var w=u.doc.getTextRange(y);if(!y.isMultiLine()&&w=="("&&(x(h),u.doc.getLine(y.start.row).substring(y.start.column+1,y.start.column+2)==")"))return y.end.column++,y}),this.add("brackets","insertion",function(b,I,h,u,y){if(y=="[")return x(h),w=h.getSelectionRange(),(v=u.doc.getTextRange(w))!==""&&h.getWrapBehavioursEnabled()?p(w,v,"[","]"):a.isSaneInsertion(h,u)?(a.recordAutoInsert(h,u,"]"),{text:"[]",selection:[1,1]}):void 0;if(y=="]"){x(h);var w=h.getCursorPosition(),v=u.doc.getLine(w.row),h=v.substring(w.column,w.column+1);if(h=="]"&&u.$findOpeningBracket("]",{column:w.column+1,row:w.row})!==null&&a.isAutoInsertedClosing(w,v,y))return a.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("brackets","deletion",function(b,I,h,u,y){var w=u.doc.getTextRange(y);if(!y.isMultiLine()&&w=="["&&(x(h),u.doc.getLine(y.start.row).substring(y.start.column+1,y.start.column+2)=="]"))return y.end.column++,y}),this.add("string_dquotes","insertion",function(b,I,h,u,y){var w=u.$mode.$quotes||c;if(y.length==1&&w[y]&&(!this.lineCommentStart||this.lineCommentStart.indexOf(y)==-1)){x(h);var v=h.getSelectionRange(),T=u.doc.getTextRange(v);if(!(T===""||T.length==1&&w[T])&&h.getWrapBehavioursEnabled())return p(v,T,y,y);if(!T){var w=h.getCursorPosition(),v=u.doc.getLine(w.row),T=v.substring(w.column-1,w.column),h=v.substring(w.column,w.column+1),_=u.getTokenAt(w.row,w.column),B=u.getTokenAt(w.row,w.column+1);if(T=="\\"&&_&&/escape/.test(_.type))return null;var E,_=_&&/string|escape/.test(_.type),P=!B||/string|escape/.test(B.type);if(h==y)(E=_!==P)&&/string\.end/.test(B.type)&&(E=!1);else{if(_&&!P||_&&P||(B=u.$mode.tokenRe,_=(B.lastIndex=0,B.test(T)),P=(B.lastIndex=0,B.test(T)),_||P)||h&&!/[\s;,.})\]\\]/.test(h)||(u=v[w.column-2],T==y&&(u==y||B.test(u))))return null;E=!0}return{text:E?y+y:"",selection:[1,1]}}}}),this.add("string_dquotes","deletion",function(b,I,h,u,y){var w=u.$mode.$quotes||c,v=u.doc.getTextRange(y);if(!y.isMultiLine()&&w.hasOwnProperty(v)&&(x(h),u.doc.getLine(y.start.row).substring(y.start.column+1,y.start.column+2)==v))return y.end.column++,y})}var l,n=C("../../lib/oop"),i=C("../behaviour").Behaviour,t=C("../../token_iterator").TokenIterator,e=C("../../lib/lang"),r=["text","paren.rparen","rparen","paren","punctuation.operator"],s=["text","paren.rparen","rparen","paren","punctuation.operator","comment"],o={},c={'"':'"',"'":"'"};a.isSaneInsertion=function(d,b){var I=d.getCursorPosition(),h=new t(b,I.row,I.column);if(!this.$matchTokenType(h.getCurrentToken()||"text",r)){if(/[)}\]]/.test(d.session.getLine(I.row)[I.column]))return!0;if(d=new t(b,I.row,I.column+1),!this.$matchTokenType(d.getCurrentToken()||"text",r))return!1}return h.stepForward(),h.getCurrentTokenRow()!==I.row||this.$matchTokenType(h.getCurrentToken()||"text",s)},a.$matchTokenType=function(d,b){return-1<b.indexOf(d.type||d)},a.recordAutoInsert=function(d,b,I){d=d.getCursorPosition(),b=b.doc.getLine(d.row),this.isAutoInsertedClosing(d,b,l.autoInsertedLineEnd[0])||(l.autoInsertedBrackets=0),l.autoInsertedRow=d.row,l.autoInsertedLineEnd=I+b.substr(d.column),l.autoInsertedBrackets++},a.recordMaybeInsert=function(d,b,I){d=d.getCursorPosition(),b=b.doc.getLine(d.row),this.isMaybeInsertedClosing(d,b)||(l.maybeInsertedBrackets=0),l.maybeInsertedRow=d.row,l.maybeInsertedLineStart=b.substr(0,d.column)+I,l.maybeInsertedLineEnd=b.substr(d.column),l.maybeInsertedBrackets++},a.isAutoInsertedClosing=function(d,b,I){return 0<l.autoInsertedBrackets&&d.row===l.autoInsertedRow&&I===l.autoInsertedLineEnd[0]&&b.substr(d.column)===l.autoInsertedLineEnd},a.isMaybeInsertedClosing=function(d,b){return 0<l.maybeInsertedBrackets&&d.row===l.maybeInsertedRow&&b.substr(d.column)===l.maybeInsertedLineEnd&&b.substr(0,d.column)==l.maybeInsertedLineStart},a.popAutoInsertedClosing=function(){l.autoInsertedLineEnd=l.autoInsertedLineEnd.substr(1),l.autoInsertedBrackets--},a.clearMaybeInsertedClosing=function(){l&&(l.maybeInsertedBrackets=0,l.maybeInsertedRow=-1)},n.inherits(a,i),m.CstyleBehaviour=a}),ace.define("ace/unicode",["require","exports","module"],function(C,m,A){for(var x=[48,9,8,25,5,0,2,25,48,0,11,0,5,0,6,22,2,30,2,457,5,11,15,4,8,0,2,0,18,116,2,1,3,3,9,0,2,2,2,0,2,19,2,82,2,138,2,4,3,155,12,37,3,0,8,38,10,44,2,0,2,1,2,1,2,0,9,26,6,2,30,10,7,61,2,9,5,101,2,7,3,9,2,18,3,0,17,58,3,100,15,53,5,0,6,45,211,57,3,18,2,5,3,11,3,9,2,1,7,6,2,2,2,7,3,1,3,21,2,6,2,0,4,3,3,8,3,1,3,3,9,0,5,1,2,4,3,11,16,2,2,5,5,1,3,21,2,6,2,1,2,1,2,1,3,0,2,4,5,1,3,2,4,0,8,3,2,0,8,15,12,2,2,8,2,2,2,21,2,6,2,1,2,4,3,9,2,2,2,2,3,0,16,3,3,9,18,2,2,7,3,1,3,21,2,6,2,1,2,4,3,8,3,1,3,2,9,1,5,1,2,4,3,9,2,0,17,1,2,5,4,2,2,3,4,1,2,0,2,1,4,1,4,2,4,11,5,4,4,2,2,3,3,0,7,0,15,9,18,2,2,7,2,2,2,22,2,9,2,4,4,7,2,2,2,3,8,1,2,1,7,3,3,9,19,1,2,7,2,2,2,22,2,9,2,4,3,8,2,2,2,3,8,1,8,0,2,3,3,9,19,1,2,7,2,2,2,22,2,15,4,7,2,2,2,3,10,0,9,3,3,9,11,5,3,1,2,17,4,23,2,8,2,0,3,6,4,0,5,5,2,0,2,7,19,1,14,57,6,14,2,9,40,1,2,0,3,1,2,0,3,0,7,3,2,6,2,2,2,0,2,0,3,1,2,12,2,2,3,4,2,0,2,5,3,9,3,1,35,0,24,1,7,9,12,0,2,0,2,0,5,9,2,35,5,19,2,5,5,7,2,35,10,0,58,73,7,77,3,37,11,42,2,0,4,328,2,3,3,6,2,0,2,3,3,40,2,3,3,32,2,3,3,6,2,0,2,3,3,14,2,56,2,3,3,66,5,0,33,15,17,84,13,619,3,16,2,25,6,74,22,12,2,6,12,20,12,19,13,12,2,2,2,1,13,51,3,29,4,0,5,1,3,9,34,2,3,9,7,87,9,42,6,69,11,28,4,11,5,11,11,39,3,4,12,43,5,25,7,10,38,27,5,62,2,28,3,10,7,9,14,0,89,75,5,9,18,8,13,42,4,11,71,55,9,9,4,48,83,2,2,30,14,230,23,280,3,5,3,37,3,5,3,7,2,0,2,0,2,0,2,30,3,52,2,6,2,0,4,2,2,6,4,3,3,5,5,12,6,2,2,6,67,1,20,0,29,0,14,0,17,4,60,12,5,0,4,11,18,0,5,0,3,9,2,0,4,4,7,0,2,0,2,0,2,3,2,10,3,3,6,4,5,0,53,1,2684,46,2,46,2,132,7,6,15,37,11,53,10,0,17,22,10,6,2,6,2,6,2,6,2,6,2,6,2,6,2,6,2,31,48,0,470,1,36,5,2,4,6,1,5,85,3,1,3,2,2,89,2,3,6,40,4,93,18,23,57,15,513,6581,75,20939,53,1164,68,45,3,268,4,27,21,31,3,13,13,1,2,24,9,69,11,1,38,8,3,102,3,1,111,44,25,51,13,68,12,9,7,23,4,0,5,45,3,35,13,28,4,64,15,10,39,54,10,13,3,9,7,22,4,1,5,66,25,2,227,42,2,1,3,9,7,11171,13,22,5,48,8453,301,3,61,3,105,39,6,13,4,6,11,2,12,2,4,2,0,2,1,2,1,2,107,34,362,19,63,3,53,41,11,5,15,17,6,13,1,25,2,33,4,2,134,20,9,8,25,5,0,2,25,12,88,4,5,3,5,3,5,3,2],p=0,a=[],l=0;l<x.length;l+=2)a.push(p+=x[l]),x[l+1]&&a.push(45,p+=x[l+1]);m.wordChars=String.fromCharCode.apply(null,a)}),ace.define("ace/mode/text",["require","exports","module","ace/config","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],function(C,m,A){function x(){this.HighlightRules=l}var p=C("../config"),a=C("../tokenizer").Tokenizer,l=C("./text_highlight_rules").TextHighlightRules,n=C("./behaviour/cstyle").CstyleBehaviour,i=C("../unicode"),t=C("../lib/lang"),e=C("../token_iterator").TokenIterator,r=C("../range").Range;(function(){this.$defaultBehaviour=new n,this.tokenRe=new RegExp("^["+i.wordChars+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+i.wordChars+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new a(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(s,o,c,d){var b=o.doc,I=!0,h=!0,u=1/0,y=o.getTabSize(),w=!1;if(this.lineCommentStart){P=Array.isArray(this.lineCommentStart)?(z=this.lineCommentStart.map(t.escapeRegExp).join("|"),this.lineCommentStart[0]):(z=t.escapeRegExp(this.lineCommentStart),this.lineCommentStart),z=new RegExp("^(\\s*)(?:"+z+") ?"),w=o.getUseSoftTabs();var v=function(Z,W){var f,S,$=Z.match(z);$&&(f=$[1].length,S=$[0].length,_(Z,f,S)||$[0][S-1]!=" "||S--,b.removeInLine(W,f,S))},T=P+" ",B=function(Z,W){I&&!/\S/.test(Z)||(_(Z,u,u)?b.insertInLine({row:W,column:u},T):b.insertInLine({row:W,column:u},P))},E=function(Z,W){return z.test(Z)},_=function(Z,W,f){for(var S=0;W--&&Z.charAt(W)==" ";)S++;if(S%y!=0)return!1;for(S=0;Z.charAt(f++)==" ";)S++;return 2<y?S%y!=y-1:S%y==0}}else{if(!this.blockComment)return!1;var P=this.blockComment.start,H=this.blockComment.end,z=new RegExp("^(\\s*)(?:"+t.escapeRegExp(P)+")"),K=new RegExp("(?:"+t.escapeRegExp(H)+")\\s*$"),B=function(S,$){E(S,$)||I&&!/\S/.test(S)||(b.insertInLine({row:$,column:S.length},H),b.insertInLine({row:$,column:u},P))},v=function(S,$){var F;(F=S.match(K))&&b.removeInLine($,S.length-F[0].length,S.length),(F=S.match(z))&&b.removeInLine($,F[1].length,F[0].length)},E=function(S,$){if(z.test(S))return!0;for(var F=o.getTokens($),j=0;j<F.length;j++)if(F[j].type==="comment")return!0}}function Y(Z){for(var W=c;W<=d;W++)Z(b.getLine(W),W)}var R=1/0;Y(function(Z,W){var f=Z.search(/\S/);f!==-1?(f<u&&(u=f),h&&!E(Z,W)&&(h=!1)):R>Z.length&&(R=Z.length)}),u==1/0&&(u=R,h=I=!1),w&&u%y!=0&&(u=Math.floor(u/y)*y),Y(h?v:B)},this.toggleBlockComment=function(s,o,c,d){var b=this.blockComment;if(b){!b.start&&b[0]&&(b=b[0]);var I,h,u=(B=new e(o,d.row,d.column)).getCurrentToken(),y=(o.selection,o.selection.toOrientedRange());if(u&&/comment/.test(u.type)){for(;u&&/comment/.test(u.type);){if((E=u.value.indexOf(b.start))!=-1){var w=B.getCurrentTokenRow(),v=B.getCurrentTokenColumn()+E,T=new r(w,v,w,v+b.start.length);break}u=B.stepBackward()}for(var B,E,u=(B=new e(o,d.row,d.column)).getCurrentToken();u&&/comment/.test(u.type);){if((E=u.value.indexOf(b.end))!=-1){var w=B.getCurrentTokenRow(),v=B.getCurrentTokenColumn()+E,_=new r(w,v,w,v+b.end.length);break}u=B.stepForward()}_&&o.remove(_),T&&(o.remove(T),I=T.start.row,h=-b.start.length)}else h=b.start.length,I=c.start.row,o.insert(c.end,b.end),o.insert(c.start,b.start);y.start.row==I&&(y.start.column+=h),y.end.row==I&&(y.end.column+=h),o.selection.fromOrientedRange(y)}},this.getNextLineIndent=function(s,o,c){return this.$getIndent(o)},this.checkOutdent=function(s,o,c){return!1},this.autoOutdent=function(s,o,c){},this.$getIndent=function(s){return s.match(/^\s*/)[0]},this.createWorker=function(s){return null},this.createModeDelegates=function(s){for(var o in this.$embeds=[],this.$modes={},s){var c,d,b;s[o]&&(d=(c=s[o]).prototype.$id,(b=p.$modes[d])||(p.$modes[d]=b=new c),p.$modes[o]||(p.$modes[o]=b),this.$embeds.push(o),this.$modes[o]=b)}for(var I=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"],o=0;o<I.length;o++)(function(u){var y=I[o],w=u[y];u[I[o]]=function(){return this.$delegator(y,arguments,w)}})(this)},this.$delegator=function(s,o,c){var d=o[0]||"start";if(typeof d!="string"){if(Array.isArray(d[2])){var b=d[2][d[2].length-1];if(h=this.$modes[b])return h[s].apply(h,[d[1]].concat([].slice.call(o,1)))}d=d[0]||"start"}for(var I=0;I<this.$embeds.length;I++)if(this.$modes[this.$embeds[I]]){var h,u=d.split(this.$embeds[I]);if(!u[0]&&u[1])return o[0]=u[1],(h=this.$modes[this.$embeds[I]])[s].apply(h,o)}return b=c.apply(this,o),c?b:void 0},this.transformAction=function(s,o,c,d,b){if(this.$behaviour){var I,h=this.$behaviour.getBehaviours();for(I in h)if(h[I][o]){var u=h[I][o].apply(this,arguments);if(u)return u}}},this.getKeywords=function(s){if(!this.completionKeywords){var o=this.$tokenizer.rules,c=[];for(h in o)for(var d=o[h],b=0,I=d.length;b<I;b++)if(typeof d[b].token=="string")/keyword|support|storage/.test(d[b].token)&&c.push(d[b].regex);else if(typeof d[b].token=="object")for(var h,u=0,y=d[b].token.length;u<y;u++)/keyword|support|storage/.test(d[b].token[u])&&(h=d[b].regex.match(/\(.+?\)/g)[u],c.push(h.substr(1,h.length-2)));this.completionKeywords=c}return s?c.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(s,o,c,d){return(this.$keywordList||this.$createKeywordList()).map(function(b){return{name:b,value:b,score:0,meta:"keyword"}})},this.$id="ace/mode/text"}).call(x.prototype),m.Mode=x}),ace.define("ace/apply_delta",["require","exports","module"],function(C,m,A){m.applyDelta=function(x,p,a){var l=p.start.row,n=p.start.column,i=x[l]||"";switch(p.action){case"insert":p.lines.length===1?x[l]=i.substring(0,n)+p.lines[0]+i.substring(n):(t=[l,1].concat(p.lines),x.splice.apply(x,t),x[l]=i.substring(0,n)+x[l],x[l+p.lines.length-1]+=i.substring(n));break;case"remove":var t=p.end.column,e=p.end.row;l===e?x[l]=i.substring(0,n)+i.substring(t):x.splice(l,e-l+1,i.substring(0,n)+x[e].substring(t))}}}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(a,m,A){var x=a("./lib/oop"),p=a("./lib/event_emitter").EventEmitter,a=m.Anchor=function(l,n,i){this.$onChange=this.onChange.bind(this),this.attach(l),i===void 0?this.setPosition(n.row,n.column):this.setPosition(n,i)};(function(){function l(n,i,t){return t=t?n.column<=i.column:n.column<i.column,n.row<i.row||n.row==i.row&&t}x.implement(this,p),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(n){n.start.row==n.end.row&&n.start.row!=this.row||n.start.row>this.row||(n=function(i,t,e){var c=i.action=="insert",r=(c?1:-1)*(i.end.row-i.start.row),s=(c?1:-1)*(i.end.column-i.start.column),o=i.start,c=c?o:i.end;return l(t,o,e)?{row:t.row,column:t.column}:l(c,t,!e)?{row:t.row+r,column:t.column+(t.row==c.row?s:0)}:{row:o.row,column:o.column}}(n,{row:this.row,column:this.column},this.$insertRight),this.setPosition(n.row,n.column,!0))},this.setPosition=function(n,i,t){t=t?{row:n,column:i}:this.$clipPositionToDocument(n,i),this.row==t.row&&this.column==t.column||(n={row:this.row,column:this.column},this.row=t.row,this.column=t.column,this._signal("change",{old:n,value:t}))},this.detach=function(){this.document.off("change",this.$onChange)},this.attach=function(n){this.document=n||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(n,i){var t={};return n>=this.document.getLength()?(t.row=Math.max(0,this.document.getLength()-1),t.column=this.document.getLine(t.row).length):n<0?(t.row=0,t.column=0):(t.row=n,t.column=Math.min(this.document.getLine(t.row).length,Math.max(0,i))),i<0&&(t.column=0),t}}).call(a.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(C,m,A){function x(t){this.$lines=[""],t.length===0?this.$lines=[""]:Array.isArray(t)?this.insertMergedLines({row:0,column:0},t):this.insert({row:0,column:0},t)}var p=C("./lib/oop"),a=C("./apply_delta").applyDelta,l=C("./lib/event_emitter").EventEmitter,n=C("./range").Range,i=C("./anchor").Anchor;(function(){p.implement(this,l),this.setValue=function(t){var e=this.getLength()-1;this.remove(new n(0,0,e,this.getLine(e).length)),this.insert({row:0,column:0},t)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(t,e){return new i(this,t,e)},"aaa".split(/a/).length===0?this.$split=function(t){return t.replace(/\r\n|\r/g,`
`).split(`
`)}:this.$split=function(t){return t.split(/\r\n|\r|\n/)},this.$detectNewLine=function(t){t=t.match(/^.*?(\r\n|\r|\n)/m),this.$autoNewLine=t?t[1]:`
`,this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return`\r
`;case"unix":return`
`;default:return this.$autoNewLine||`
`}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(t){this.$newLineMode!==t&&(this.$newLineMode=t,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(t){return t==`\r
`||t=="\r"||t==`
`},this.getLine=function(t){return this.$lines[t]||""},this.getLines=function(t,e){return this.$lines.slice(t,e+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(t){return this.getLinesForRange(t).join(this.getNewLineCharacter())},this.getLinesForRange=function(t){var e,r;return t.start.row===t.end.row?e=[this.getLine(t.start.row).substring(t.start.column,t.end.column)]:((e=this.getLines(t.start.row,t.end.row))[0]=(e[0]||"").substring(t.start.column),r=e.length-1,t.end.row-t.start.row==r&&(e[r]=e[r].substring(0,t.end.column))),e},this.insertLines=function(t,e){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(t,e)},this.removeLines=function(t,e){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(t,e)},this.insertNewLine=function(t){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead."),this.insertMergedLines(t,["",""])},this.insert=function(t,e){return this.getLength()<=1&&this.$detectNewLine(e),this.insertMergedLines(t,this.$split(e))},this.insertInLine=function(s,e){var r=this.clippedPos(s.row,s.column),s=this.pos(s.row,s.column+e.length);return this.applyDelta({start:r,end:s,action:"insert",lines:[e]},!0),this.clonePos(s)},this.clippedPos=function(t,e){var r=this.getLength(),r=(t===void 0?t=r:t<0?t=0:r<=t&&(t=r-1,e=void 0),this.getLine(t));return e==null&&(e=r.length),{row:t,column:e=Math.min(Math.max(e,0),r.length)}},this.clonePos=function(t){return{row:t.row,column:t.column}},this.pos=function(t,e){return{row:t,column:e}},this.$clipPosition=function(t){var e=this.getLength();return t.row>=e?(t.row=Math.max(0,e-1),t.column=this.getLine(e-1).length):(t.row=Math.max(0,t.row),t.column=Math.min(Math.max(t.column,0),this.getLine(t.row).length)),t},this.insertFullLines=function(t,e){var r=0,r=(t=Math.min(Math.max(t,0),this.getLength()))<this.getLength()?(e=e.concat([""]),0):(e=[""].concat(e),this.$lines[--t].length);this.insertMergedLines({row:t,column:r},e)},this.insertMergedLines=function(r,e){var r=this.clippedPos(r.row,r.column),s={row:r.row+e.length-1,column:(e.length==1?r.column:0)+e[e.length-1].length};return this.applyDelta({start:r,end:s,action:"insert",lines:e}),this.clonePos(s)},this.remove=function(r){var e=this.clippedPos(r.start.row,r.start.column),r=this.clippedPos(r.end.row,r.end.column);return this.applyDelta({start:e,end:r,action:"remove",lines:this.getLinesForRange({start:e,end:r})}),this.clonePos(e)},this.removeInLine=function(t,e,r){return e=this.clippedPos(t,e),t=this.clippedPos(t,r),this.applyDelta({start:e,end:t,action:"remove",lines:this.getLinesForRange({start:e,end:t})},!0),this.clonePos(e)},this.removeFullLines=function(t,e){t=Math.min(Math.max(0,t),this.getLength()-1);var c=(e=Math.min(Math.max(0,e),this.getLength()-1))==this.getLength()-1&&0<t,s=e<this.getLength()-1,o=c?t-1:t,c=c?this.getLine(o).length:0,r=s?e+1:e,s=s?0:this.getLine(r).length,o=new n(o,c,r,s),c=this.$lines.slice(t,e+1);return this.applyDelta({start:o.start,end:o.end,action:"remove",lines:this.getLinesForRange(o)}),c},this.removeNewLine=function(t){t<this.getLength()-1&&0<=t&&this.applyDelta({start:this.pos(t,this.getLine(t).length),end:this.pos(t+1,0),action:"remove",lines:["",""]})},this.replace=function(t,e){return t instanceof n||(t=n.fromPoints(t.start,t.end)),e.length===0&&t.isEmpty()?t.start:e==this.getTextRange(t)?t.end:(this.remove(t),e?this.insert(t.start,e):t.start)},this.applyDeltas=function(t){for(var e=0;e<t.length;e++)this.applyDelta(t[e])},this.revertDeltas=function(t){for(var e=t.length-1;0<=e;e--)this.revertDelta(t[e])},this.applyDelta=function(t,e){var r=t.action=="insert";(r?t.lines.length<=1&&!t.lines[0]:!n.comparePoints(t.start,t.end))||(r&&2e4<t.lines.length?this.$splitAndapplyLargeDelta(t,2e4):(a(this.$lines,t,e),this._signal("change",t)))},this.$safeApplyDelta=function(t){var e=this.$lines.length;(t.action=="remove"&&t.start.row<e&&t.end.row<e||t.action=="insert"&&t.start.row<=e)&&this.applyDelta(t)},this.$splitAndapplyLargeDelta=function(t,e){for(var r=t.lines,s=r.length-e+1,o=t.start.row,c=t.start.column,d=0,b=0;d<s;d=b){b+=e-1;var I=r.slice(d,b);I.push(""),this.applyDelta({start:this.pos(o+d,c),end:this.pos(o+b,c=0),action:t.action,lines:I},!0)}t.lines=r.slice(d),t.start.row=o+d,t.start.column=c,this.applyDelta(t,!0)},this.revertDelta=function(t){this.$safeApplyDelta({start:this.clonePos(t.start),end:this.clonePos(t.end),action:t.action=="insert"?"remove":"insert",lines:t.lines.slice()})},this.indexToPosition=function(t,e){for(var r=this.$lines||this.getAllLines(),s=this.getNewLineCharacter().length,o=e||0,c=r.length;o<c;o++)if((t-=r[o].length+s)<0)return{row:o,column:t+r[o].length+s};return{row:c-1,column:t+r[c-1].length+s}},this.positionToIndex=function(t,e){for(var r=this.$lines||this.getAllLines(),s=this.getNewLineCharacter().length,o=0,c=Math.min(t.row,r.length),d=e||0;d<c;++d)o+=r[d].length+s;return o+t.column}}).call(x.prototype),m.Document=x}),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(C,m,A){function x(l,n){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=l;var i=this;this.$worker=function(){if(i.running){for(var t=new Date,e=i.currentLine,r=-1,s=i.doc,o=e;i.lines[e];)e++;var c=s.getLength(),d=0;for(i.running=!1;e<c;){for(i.$tokenizeRow(e),r=e;e++,i.lines[e];);if(++d%5==0&&20<new Date-t){i.running=setTimeout(i.$worker,20);break}}i.currentLine=e,o<=(r=r==-1?e:r)&&i.fireUpdateEvent(o,r)}}}var p=C("./lib/oop"),a=C("./lib/event_emitter").EventEmitter;(function(){p.implement(this,a),this.setTokenizer=function(l){this.tokenizer=l,this.lines=[],this.states=[],this.start(0)},this.setDocument=function(l){this.doc=l,this.lines=[],this.states=[],this.stop()},this.fireUpdateEvent=function(l,n){this._signal("update",{data:{first:l,last:n}})},this.start=function(l){this.currentLine=Math.min(l||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},this.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},this.$updateOnChange=function(l){var n=l.start.row,i=l.end.row-n;i==0?this.lines[n]=null:l.action=="remove"?(this.lines.splice(n,1+i,null),this.states.splice(n,1+i,null)):((l=Array(1+i)).unshift(n,1),this.lines.splice.apply(this.lines,l),this.states.splice.apply(this.states,l)),this.currentLine=Math.min(n,this.currentLine,this.doc.getLength()),this.stop()},this.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},this.getTokens=function(l){return this.lines[l]||this.$tokenizeRow(l)},this.getState=function(l){return this.currentLine==l&&this.$tokenizeRow(l),this.states[l]||"start"},this.$tokenizeRow=function(l){var i=this.doc.getLine(l),n=this.states[l-1],i=this.tokenizer.getLineTokens(i,n,l);return this.states[l]+""!=i.state+""?(this.states[l]=i.state,this.lines[l+1]=null,this.currentLine>l+1&&(this.currentLine=l+1)):this.currentLine==l&&(this.currentLine=l+1),this.lines[l]=i.tokens},this.cleanup=function(){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.removeAllListeners()}}).call(x.prototype),m.BackgroundTokenizer=x}),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(C,m,A){function x(l,n,i){this.setRegexp(l),this.clazz=n,this.type=i||"text"}var p=C("./lib/lang"),a=(C("./lib/oop"),C("./range").Range);(function(){this.MAX_RANGES=500,this.setRegexp=function(l){this.regExp+""!=l+""&&(this.regExp=l,this.cache=[])},this.update=function(l,n,i,t){if(this.regExp)for(var e=t.firstRow,r=t.lastRow,s={},o=e;o<=r;o++){var c=this.cache[o];c==null&&(c=(c=(c=p.getMatchOffsets(i.getLine(o),this.regExp)).length>this.MAX_RANGES?c.slice(0,this.MAX_RANGES):c).map(function(h){return new a(o,h.offset,o,h.offset+h.length)}),this.cache[o]=c.length?c:"");for(var d=c.length;d--;){var b=c[d].toScreenRange(i),I=b.toString();s[I]||(s[I]=!0,n.drawSingleLineMarker(l,b,this.clazz,t))}}}}).call(x.prototype),m.SearchHighlight=x}),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],function(C,m,A){var x=C("../range").Range;function p(a,l){this.foldData=a,Array.isArray(l)?this.folds=l:l=this.folds=[l],a=l[l.length-1],this.range=new x(l[0].start.row,l[0].start.column,a.end.row,a.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach(function(n){n.setFoldLine(this)},this)}(function(){this.shiftRow=function(a){this.start.row+=a,this.end.row+=a,this.folds.forEach(function(l){l.start.row+=a,l.end.row+=a})},this.addFold=function(a){if(a.sameRow){if(a.start.row<this.startRow||a.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(a),this.folds.sort(function(l,n){return-l.range.compareEnd(n.start.row,n.start.column)}),0<this.range.compareEnd(a.start.row,a.start.column)?(this.end.row=a.end.row,this.end.column=a.end.column):this.range.compareStart(a.end.row,a.end.column)<0&&(this.start.row=a.start.row,this.start.column=a.start.column)}else if(a.start.row==this.end.row)this.folds.push(a),this.end.row=a.end.row,this.end.column=a.end.column;else{if(a.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(a),this.start.row=a.start.row,this.start.column=a.start.column}a.foldLine=this},this.containsRow=function(a){return a>=this.start.row&&a<=this.end.row},this.walk=function(a,l,n){var i,t,e=0,r=this.folds,s=!0;l==null&&(l=this.end.row,n=this.end.column);for(var o=0;o<r.length;o++){if((t=(i=r[o]).range.compareStart(l,n))==-1)return void a(null,l,n,e,s);if(!a(null,i.start.row,i.start.column,e,s)&&a(i.placeholder,i.start.row,i.start.column,e)||t===0)return;s=!i.sameRow,e=i.end.column}a(null,l,n,e,s)},this.getNextFoldTo=function(a,l){for(var n,i,t=0;t<this.folds.length;t++){if((i=(n=this.folds[t]).range.compareEnd(a,l))==-1)return{fold:n,kind:"after"};if(i===0)return{fold:n,kind:"inside"}}return null},this.addRemoveChars=function(a,l,n){var i,t=this.getNextFoldTo(a,l);if(t){if(i=t.fold,t.kind=="inside"&&i.start.column!=l&&i.start.row!=a)window.console&&window.console.log(a,l,i);else if(i.start.row==a){var e,r=(e=this.folds).indexOf(i);for(r===0&&(this.start.column+=n);r<e.length;r++){if((i=e[r]).start.column+=n,!i.sameRow)return;i.end.column+=n}this.end.column+=n}}},this.split=function(t,l){var n,i,t=this.getNextFoldTo(t,l);return t&&t.kind!="inside"?(l=t.fold,t=this.folds,n=this.foldData,l=t.indexOf(l),i=t[l-1],this.end.row=i.end.row,this.end.column=i.end.column,i=new p(n,t=t.splice(l,t.length-l)),n.splice(n.indexOf(this)+1,0,i),i):null},this.merge=function(a){for(var l=a.folds,n=0;n<l.length;n++)this.addFold(l[n]);var i=this.foldData;i.splice(i.indexOf(a),1)},this.toString=function(){var a=[this.range.toString()+": ["];return this.folds.forEach(function(l){a.push("  "+l.toString())}),a.push("]"),a.join(`
`)},this.idxToPosition=function(a){for(var l=0,n=0;n<this.folds.length;n++){var i=this.folds[n];if((a-=i.start.column-l)<0)return{row:i.start.row,column:i.start.column+a};if((a-=i.placeholder.length)<0)return i.start;l=i.end.column}return{row:this.end.row,column:this.end.column+a}}}).call(p.prototype),m.FoldLine=p}),ace.define("ace/range_list",["require","exports","module","ace/range"],function(C,m,A){function x(){this.ranges=[],this.$bias=1}var p=C("./range").Range.comparePoints;(function(){this.comparePoints=p,this.pointIndex=function(a,l,n){for(var i=this.ranges,t=n||0;t<i.length;t++){var e=i[t],r=p(a,e.end);if(!(0<r))return e=p(a,e.start),r===0?l&&e!==0?-t-2:t:0<e||e===0&&!l?t:-t-1}return-t-1},this.add=function(a){var n=!a.isEmpty(),l=this.pointIndex(a.start,n),n=this.pointIndex(a.end,n,l=l<0?-l-1:l);return n<0?n=-n-1:n++,this.ranges.splice(l,n-l,a)},this.addList=function(a){for(var l=[],n=a.length;n--;)l.push.apply(l,this.add(a[n]));return l},this.substractPoint=function(a){if(a=this.pointIndex(a),0<=a)return this.ranges.splice(a,1)},this.merge=function(){for(var a=[],l=this.ranges,n=(l=l.sort(function(r,s){return p(r.start,s.start)}))[0],i=1;i<l.length;i++){var t=n,n=l[i],e=p(t.end,n.start);e<0||(e!=0||t.isEmpty()||n.isEmpty())&&(p(t.end,n.end)<0&&(t.end.row=n.end.row,t.end.column=n.end.column),l.splice(i,1),a.push(n),n=t,i--)}return this.ranges=l,a},this.contains=function(a,l){return 0<=this.pointIndex({row:a,column:l})},this.containsPoint=function(a){return 0<=this.pointIndex(a)},this.rangeAtPoint=function(a){if(a=this.pointIndex(a),0<=a)return this.ranges[a]},this.clipRows=function(a,l){var n=this.ranges;if(n[0].start.row>l||n[n.length-1].start.row<a)return[];for(var a=this.pointIndex({row:a,column:0}),i=this.pointIndex({row:l,column:0},a=a<0?-a-1:a),t=(i<0&&(i=-i-1),[]),e=a;e<i;e++)t.push(n[e]);return t},this.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},this.attach=function(a){this.session&&this.detach(),this.session=a,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},this.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},this.$onChange=function(a){for(var l=a.start,n=a.end,i=l.row,t=n.row,e=this.ranges,r=0,s=e.length;r<s&&!((d=e[r]).end.row>=i);r++);if(a.action=="insert")for(var o=t-i,c=-l.column+n.column;r<s&&!((d=e[r]).start.row>i);r++)d.start.row==i&&d.start.column>=l.column&&(d.start.column==l.column&&this.$bias<=0||(d.start.column+=c,d.start.row+=o)),d.end.row==i&&d.end.column>=l.column&&(d.end.column==l.column&&this.$bias<0||(d.end.column==l.column&&0<c&&r<s-1&&d.end.column>d.start.column&&d.end.column==e[r+1].start.column&&(d.end.column-=c),d.end.column+=c,d.end.row+=o));else for(var d,o=i-t,c=l.column-n.column;r<s&&!((d=e[r]).start.row>t);r++)d.end.row<t&&(i<d.end.row||i==d.end.row&&l.column<d.end.column)?(d.end.row=i,d.end.column=l.column):d.end.row==t?d.end.column<=n.column?(o||d.end.column>l.column)&&(d.end.column=l.column,d.end.row=l.row):(d.end.column+=c,d.end.row+=o):d.end.row>t&&(d.end.row+=o),d.start.row<t&&(i<d.start.row||i==d.start.row&&l.column<d.start.column)?(d.start.row=i,d.start.column=l.column):d.start.row==t?d.start.column<=n.column?(o||d.start.column>l.column)&&(d.start.column=l.column,d.start.row=l.row):(d.start.column+=c,d.start.row+=o):d.start.row>t&&(d.start.row+=o);if(o!=0&&r<s)for(;r<s;r++)(d=e[r]).start.row+=o,d.end.row+=o}}).call(x.prototype),m.RangeList=x}),ace.define("ace/edit_session/fold",["require","exports","module","ace/range_list","ace/lib/oop"],function(p,m,A){var x=p("../range_list").RangeList,p=p("../lib/oop"),a=m.Fold=function(i,t){this.foldLine=null,this.placeholder=t,this.range=i,this.start=i.start,this.end=i.end,this.sameRow=i.start.row==i.end.row,this.subFolds=this.ranges=[]};function l(i,t){i.row-=t.row,i.row==0&&(i.column-=t.column)}function n(i,t){i.row==0&&(i.column+=t.column),i.row+=t.row}p.inherits(a,x),function(){this.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},this.setFoldLine=function(i){this.foldLine=i,this.subFolds.forEach(function(t){t.setFoldLine(i)})},this.clone=function(){var i=this.range.clone(),t=new a(i,this.placeholder);return this.subFolds.forEach(function(e){t.subFolds.push(e.clone())}),t.collapseChildren=this.collapseChildren,t},this.addSubFold=function(i){if(!this.range.isEqual(i)){o=i,c=this.start,l(o.start,c),l(o.end,c);for(var t=i.start.row,e=i.start.column,r=0,s=-1;r<this.subFolds.length&&(s=this.subFolds[r].range.compare(t,e))==1;r++);var o=this.subFolds[r],c=0;if(s==0){if(o.range.containsRange(i))return o.addSubFold(i);c=1}for(var t=i.range.end.row,e=i.range.end.column,d=r,s=-1;d<this.subFolds.length&&(s=this.subFolds[d].range.compare(t,e))==1;d++);s==0&&d++;for(var b=this.subFolds.splice(r,d-r,i),I=s==0?b.length-1:b.length,h=c;h<I;h++)i.addSubFold(b[h]);return i.setFoldLine(this.foldLine),i}},this.restoreRange=function(i){return i=i,t=this.start,n(i.start,t),void n(i.end,t);var t}}.call(a.prototype)}),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator"],function(C,m,A){var x=C("../range").Range,p=C("./fold_line").FoldLine,a=C("./fold").Fold,l=C("../token_iterator").TokenIterator;m.Folding=function(){this.getFoldAt=function(n,i,t){var e=this.getFoldLine(n);if(!e)return null;for(var r=e.folds,s=0;s<r.length;s++){var o=r[s].range;if(o.contains(n,i)&&(t!=1||!o.isEnd(n,i)||o.isEmpty())&&(t!=-1||!o.isStart(n,i)||o.isEmpty()))return r[s]}},this.getFoldsInRange=function(n){var i=n.start,t=n.end,e=this.$foldData,r=[];i.column+=1,--t.column;for(var s=0;s<e.length;s++){var o=e[s].range.compareRange(n);if(o!=2){if(o==-2)break;for(var c=e[s].folds,d=0;d<c.length;d++){var b=c[d];if((o=b.range.compareRange(n))==-2)break;if(o!=2){if(o==42)break;r.push(b)}}}}return--i.column,t.column+=1,r},this.getFoldsInRangeList=function(n){var i;return Array.isArray(n)?(i=[],n.forEach(function(t){i=i.concat(this.getFoldsInRange(t))},this)):i=this.getFoldsInRange(n),i},this.getAllFolds=function(){for(var n=[],i=this.$foldData,t=0;t<i.length;t++)for(var e=0;e<i[t].folds.length;e++)n.push(i[t].folds[e]);return n},this.getFoldStringAt=function(n,i,t,e){if(!(e=e||this.getFoldLine(n)))return null;for(var r,s={end:{column:0}},o=0;o<e.folds.length;o++){var c,d=(c=e.folds[o]).range.compareEnd(n,i);if(d==-1){r=this.getLine(c.start.row).substring(s.end.column,c.start.column);break}if(d===0)return null;s=c}return r=r||this.getLine(c.start.row).substring(s.end.column),t==-1?r.substring(0,i-s.end.column):t==1?r.substring(i-s.end.column):r},this.getFoldLine=function(n,i){var t=this.$foldData,e=0;for((e=i?t.indexOf(i):e)==-1&&(e=0);e<t.length;e++){var r=t[e];if(r.start.row<=n&&r.end.row>=n)return r;if(r.end.row>n)return null}return null},this.getNextFoldLine=function(n,i){var t=this.$foldData,e=0;for((e=i?t.indexOf(i):e)==-1&&(e=0);e<t.length;e++){var r=t[e];if(r.end.row>=n)return r}return null},this.getFoldedRowCount=function(n,i){for(var t=this.$foldData,e=i-n+1,r=0;r<t.length;r++){var o=t[r],s=o.end.row,o=o.start.row;if(i<=s){o<i&&(n<=o?e-=i-o:e=0);break}n<=s&&(e-=n<=o?s-o:s-n+1)}return e},this.$addFoldLine=function(n){return this.$foldData.push(n),this.$foldData.sort(function(i,t){return i.start.row-t.start.row}),n},this.addFold=function(o,d){var t,e=this.$foldData,r=!1,s=(o instanceof a?t=o:(t=new a(d,o)).collapseChildren=d.collapseChildren,this.$clipRangeToDocument(t.range),t.start.row),o=t.start.column,c=t.end.row,d=t.end.column,b=this.getFoldAt(s,o,1),I=this.getFoldAt(c,d,-1);if(b&&I==b)return b.addSubFold(t);b&&!b.range.isStart(s,o)&&this.removeFold(b),I&&!I.range.isEnd(c,d)&&this.removeFold(I),o=this.getFoldsInRange(t.range),0<o.length&&(this.removeFolds(o),t.collapseChildren||o.forEach(function(w){t.addSubFold(w)}));for(var h=0;h<e.length;h++){var u=e[h];if(c==u.start.row){u.addFold(t),r=!0;break}if(s==u.end.row){if(u.addFold(t),r=!0,!t.sameRow){var y=e[h+1];if(y&&y.start.row==c){u.merge(y);break}}break}if(c<=u.start.row)break}return r||(u=this.$addFoldLine(new p(this.$foldData,t))),this.$useWrapMode?this.$updateWrapData(u.start.row,u.start.row):this.$updateRowLengthCache(u.start.row,u.start.row),this.$modified=!0,this._signal("changeFold",{data:t,action:"add"}),t},this.addFolds=function(n){n.forEach(function(i){this.addFold(i)},this)},this.removeFold=function(n){var i=n.foldLine,t=i.start.row,e=i.end.row,r=this.$foldData,s=i.folds;s.length==1?r.splice(r.indexOf(i),1):i.range.isEnd(n.end.row,n.end.column)?(s.pop(),i.end.row=s[s.length-1].end.row,i.end.column=s[s.length-1].end.column):i.range.isStart(n.start.row,n.start.column)?(s.shift(),i.start.row=s[0].start.row,i.start.column=s[0].start.column):n.sameRow?s.splice(s.indexOf(n),1):((s=(r=i.split(n.start.row,n.start.column)).folds).shift(),r.start.row=s[0].start.row,r.start.column=s[0].start.column),this.$updating||(this.$useWrapMode?this.$updateWrapData(t,e):this.$updateRowLengthCache(t,e)),this.$modified=!0,this._signal("changeFold",{data:n,action:"remove"})},this.removeFolds=function(n){for(var i=[],t=0;t<n.length;t++)i.push(n[t]);i.forEach(function(e){this.removeFold(e)},this),this.$modified=!0},this.expandFold=function(n){this.removeFold(n),n.subFolds.forEach(function(i){n.restoreRange(i),this.addFold(i)},this),0<n.collapseChildren&&this.foldAll(n.start.row+1,n.end.row,n.collapseChildren-1),n.subFolds=[]},this.expandFolds=function(n){n.forEach(function(i){this.expandFold(i)},this)},this.unfold=function(n,i){var t;if(n==null)t=new x(0,0,this.getLength(),0),i==null&&(i=!0);else if(typeof n=="number")t=new x(n,0,n,this.getLine(n).length);else if("row"in n)t=x.fromPoints(n,n);else{if(Array.isArray(n))return e=[],n.forEach(function(r){e=e.concat(this.unfold(r))},this),e;t=n}for(var e,n=e=this.getFoldsInRangeList(t);e.length==1&&x.comparePoints(e[0].start,t.start)<0&&0<x.comparePoints(e[0].end,t.end);)this.expandFolds(e),e=this.getFoldsInRangeList(t);if(i!=0?this.removeFolds(e):this.expandFolds(e),n.length)return n},this.isRowFolded=function(n,i){return!!this.getFoldLine(n,i)},this.getRowFoldEnd=function(n,i){return i=this.getFoldLine(n,i),i?i.end.row:n},this.getRowFoldStart=function(n,i){return i=this.getFoldLine(n,i),i?i.start.row:n},this.getFoldDisplayLine=function(n,i,t,e,r){e==null&&(e=n.start.row),r==null&&(r=0),i==null&&(i=n.end.row),t==null&&(t=this.getLine(i).length);var s=this.doc,o="";return n.walk(function(c,d,b,I){if(!(d<e)){if(d==e){if(b<r)return;I=Math.max(r,I)}o+=c!=null?c:s.getLine(d).substring(I,b)}},i,t),o},this.getDisplayLine=function(n,i,t,e){var r=this.getFoldLine(n);return r?this.getFoldDisplayLine(r,n,i,t,e):(r=this.doc.getLine(n)).substring(e||0,i||r.length)},this.$cloneFoldData=function(){var n=[];return n=this.$foldData.map(function(i){return i=i.folds.map(function(t){return t.clone()}),new p(n,i)})},this.toggleFold=function(n){var i=this.selection.getRange();if(i.isEmpty()){var t,e=i.start;if(t=this.getFoldAt(e.row,e.column))return void this.expandFold(t);(r=this.findMatchingBracket(e))?i.comparePoint(r)==1?i.end=r:(i.start=r,i.start.column++,i.end.column--):(r=this.findMatchingBracket({row:e.row,column:e.column+1}))?(i.comparePoint(r)==1?i.end=r:i.start=r,i.start.column++):i=this.getCommentFoldRange(e.row,e.column)||i}else{var r=this.getFoldsInRange(i);if(n&&r.length)return void this.expandFolds(r);r.length==1&&(t=r[0])}if((t=t||this.getFoldAt(i.start.row,i.start.column))&&t.range.toString()==i.toString())this.expandFold(t);else{if(e="...",!i.isMultiLine()){if((e=this.getTextRange(i)).length<4)return;e=e.trim().substring(0,2)+".."}this.addFold(e,i)}},this.getCommentFoldRange=function(n,i,t){var e=new l(this,n,i),r=e.getCurrentToken(),s=r&&r.type;if(r&&/^comment|string/.test(s)){(s=s.match(/comment|string/)[0])=="comment"&&(s+="|doc-start");var o=new RegExp(s),s=new x;if(t!=1){for(;(r=e.stepBackward())&&o.test(r.type););e.stepForward()}if(s.start.row=e.getCurrentTokenRow(),s.start.column=e.getCurrentTokenColumn()+2,e=new l(this,n,i),t!=-1){var c=-1;do if(r=e.stepForward(),c==-1){var d=this.getState(e.$row);o.test(d)||(c=e.$row)}else if(e.$row>c)break;while(r&&o.test(r.type));r=e.stepBackward()}else r=e.getCurrentToken();return s.end.row=e.getCurrentTokenRow(),s.end.column=e.getCurrentTokenColumn()+r.value.length-2,s}},this.foldAll=function(n,i,t,e){t==null&&(t=1e5);var r=this.foldWidgets;if(r){i=i||this.getLength();for(var s,o=n=n||0;o<i;o++)r[o]==null&&(r[o]=this.getFoldWidget(o)),r[o]!="start"||e&&!e(o)||(s=this.getFoldWidgetRange(o))&&s.isMultiLine()&&s.end.row<=i&&s.start.row>=n&&(o=s.end.row,s.collapseChildren=t,this.addFold("...",s))}},this.foldToLevel=function(n){for(this.foldAll();0<n--;)this.unfold(null,!1)},this.foldAllComments=function(){var n=this;this.foldAll(null,null,null,function(i){for(var t=n.getTokens(i),e=0;e<t.length;e++){var r=t[e];if(r.type!="text"||!/^\s+$/.test(r.value))return!!/comment/.test(r.type)}})},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(n){if(!this.$foldStyles[n])throw new Error("invalid fold style: "+n+"["+Object.keys(this.$foldStyles).join(", ")+"]");this.$foldStyle!=n&&((this.$foldStyle=n)=="manual"&&this.unfold(),n=this.$foldMode,this.$setFolding(null),this.$setFolding(n))},this.$setFolding=function(n){this.$foldMode!=n&&(this.$foldMode=n,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),n&&this.$foldStyle!="manual"?(this.foldWidgets=[],this.getFoldWidget=n.getFoldWidget.bind(n,this,this.$foldStyle),this.getFoldWidgetRange=n.getFoldWidgetRange.bind(n,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)):this.foldWidgets=null)},this.getParentFoldRangeData=function(n,i){var t=this.foldWidgets;if(!t||i&&t[n])return{};for(var e=n-1;0<=e;){var r=t[e];if((r=r==null?t[e]=this.getFoldWidget(e):r)=="start"){var s=this.getFoldWidgetRange(e),o=o||s;if(s&&s.end.row>=n)break}e--}return{range:e!==-1&&s,firstRange:o}},this.onFoldWidgetClick=function(n,i){var t={children:(i=i.domEvent).shiftKey,all:i.ctrlKey||i.metaKey,siblings:i.altKey};this.$toggleFoldWidget(n,t)||(n=i.target||i.srcElement)&&/ace_fold-widget/.test(n.className)&&(n.className+=" ace_invalid")},this.$toggleFoldWidget=function(n,i){var t,e,r,s;if(this.getFoldWidget)return t=this.getFoldWidget(n),e=this.getLine(n),(e=this.getFoldAt(n,(t=t==="end"?-1:1)==-1?0:e.length,t))?(i.children||i.all?this.removeFold(e):this.expandFold(e),e):(t=this.getFoldWidgetRange(n,!0))&&!t.isMultiLine()&&(e=this.getFoldAt(t.start.row,t.start.column,1))&&t.isEqual(e.range)?(this.removeFold(e),e):(i.siblings?((e=this.getParentFoldRangeData(n)).range&&(r=e.range.start.row+1,s=e.range.end.row),this.foldAll(r,s,i.all?1e4:0)):i.children?(s=t?t.end.row:this.getLength(),this.foldAll(n+1,s,i.all?1e4:0)):t&&(i.all&&(t.collapseChildren=1e4),this.addFold("...",t)),t)},this.toggleFoldWidget=function(n){var i,t=this.selection.getCursor().row;t=this.getRowFoldStart(t),this.$toggleFoldWidget(t,{})||(i=(i=this.getParentFoldRangeData(t,!0)).range||i.firstRange)&&(t=i.start.row,(t=this.getFoldAt(t,this.getLine(t).length,1))?this.removeFold(t):this.addFold("...",i))},this.updateFoldWidgets=function(n){var i=n.start.row,t=n.end.row-i;t==0?this.foldWidgets[i]=null:n.action=="remove"?this.foldWidgets.splice(i,1+t,null):((n=Array(1+t)).unshift(i,1),this.foldWidgets.splice.apply(this.foldWidgets,n))},this.tokenizerUpdateFoldWidgets=function(n){n=n.data,n.first!=n.last&&this.foldWidgets.length>n.first&&this.foldWidgets.splice(n.first,this.foldWidgets.length)}}}),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],function(C,m,A){var x=C("../token_iterator").TokenIterator,p=C("../range").Range;m.BracketMatch=function(){this.findMatchingBracket=function(a,l){return a.column!=0&&(l=l||this.getLine(a.row).charAt(a.column-1))!=""&&(l=l.match(/([\(\[\{])|([\)\]\}])/))?l[1]?this.$findClosingBracket(l[1],a):this.$findOpeningBracket(l[2],a):null},this.getBracketRange=function(a){var l,n,i=this.getLine(a.row),t=!0,e=i.charAt(a.column-1),r=e&&e.match(/([\(\[\{])|([\)\]\}])/);if(r||(e=i.charAt(a.column),a={row:a.row,column:a.column+1},r=e&&e.match(/([\(\[\{])|([\)\]\}])/),t=!1),!r)return null;if(r[1]){if(!(n=this.$findClosingBracket(r[1],a)))return null;l=p.fromPoints(a,n),t||(l.end.column++,l.start.column--),l.cursor=l.end}else{if(!(n=this.$findOpeningBracket(r[2],a)))return null;l=p.fromPoints(n,a),t||(l.start.column++,l.end.column--),l.cursor=l.start}return l},this.getMatchingBracketRanges=function(a){var l=this.getLine(a.row),n=l.charAt(a.column-1),i=n&&n.match(/([\(\[\{])|([\)\]\}])/);return i||(n=l.charAt(a.column),a={row:a.row,column:a.column+1},i=n&&n.match(/([\(\[\{])|([\)\]\}])/)),i?(l=new p(a.row,a.column-1,a.row,a.column),(n=i[1]?this.$findClosingBracket(i[1],a):this.$findOpeningBracket(i[2],a))?[l,new p(n.row,n.column,n.row,n.column+1)]:[l]):null},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{","<":">",">":"<"},this.$findOpeningBracket=function(a,l,n){var i=this.$brackets[a],t=1,e=new x(this,l.row,l.column),r=e.getCurrentToken();if(r=r||e.stepForward()){n=n||new RegExp("(\\.?"+r.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)")+")+");for(var s=l.column-e.getCurrentTokenColumn()-2,o=r.value;;){for(;0<=s;){var c=o.charAt(s);if(c==i){if(--t==0)return{row:e.getCurrentTokenRow(),column:s+e.getCurrentTokenColumn()}}else c==a&&(t+=1);--s}for(;(r=e.stepBackward())&&!n.test(r.type););if(r==null)break;s=(o=r.value).length-1}return null}},this.$findClosingBracket=function(a,l,n){var i=this.$brackets[a],t=1,e=new x(this,l.row,l.column),r=e.getCurrentToken();if(r=r||e.stepForward()){n=n||new RegExp("(\\.?"+r.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)")+")+");for(var s=l.column-e.getCurrentTokenColumn();;){for(var o=r.value,c=o.length;s<c;){var d=o.charAt(s);if(d==i){if(--t==0)return{row:e.getCurrentTokenRow(),column:s+e.getCurrentTokenColumn()}}else d==a&&(t+=1);s+=1}for(;(r=e.stepForward())&&!n.test(r.type););if(r==null)break;s=0}return null}}}}),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/bidihandler","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document","ace/background_tokenizer","ace/search_highlight","ace/edit_session/folding","ace/edit_session/bracket_match"],function(C,m,A){function x(d,b){this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.id="session"+ ++x.$uid,this.$foldData.toString=function(){return this.join(`
`)},this.bgTokenizer=new o(new e().getTokenizer(),this);var I=this;this.bgTokenizer.on("update",function(h){I._signal("tokenizerUpdate",h)}),this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),typeof d=="object"&&d.getLine||(d=new s(d)),this.setDocument(d),this.selection=new t(this),this.$bidiHandler=new l(this),n.resetOptions(this),this.setMode(b),n._signal("session",this),this.destroyed=!1}var p=C("./lib/oop"),a=C("./lib/lang"),l=C("./bidihandler").BidiHandler,n=C("./config"),i=C("./lib/event_emitter").EventEmitter,t=C("./selection").Selection,e=C("./mode/text").Mode,r=C("./range").Range,s=C("./document").Document,o=C("./background_tokenizer").BackgroundTokenizer,c=C("./search_highlight").SearchHighlight;x.$uid=0,function(){p.implement(this,i),this.setDocument=function(h){this.doc&&this.doc.off("change",this.$onChange),(this.doc=h).on("change",this.$onChange,!0),this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},this.getDocument=function(){return this.doc},this.$resetRowCache=function(h){var u;h?(u=this.$docRowCache.length,(h=this.$getRowCacheIndex(this.$docRowCache,h)+1)<u&&(this.$docRowCache.splice(h,u),this.$screenRowCache.splice(h,u))):(this.$docRowCache=[],this.$screenRowCache=[])},this.$getRowCacheIndex=function(h,u){for(var y=0,w=h.length-1;y<=w;){var v=y+w>>1,T=h[v];if(T<u)y=1+v;else{if(!(u<T))return v;w=v-1}}return y-1},this.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.destroyed||this.bgTokenizer.start(0)},this.onChangeFold=function(h){h=h.data,this.$resetRowCache(h.start.row)},this.onChange=function(h){this.$modified=!0,this.$bidiHandler.onChange(h),this.$resetRowCache(h.start.row);var u=this.$updateInternalDataOnChange(h);!this.$fromUndo&&this.$undoManager&&(u&&u.length&&(this.$undoManager.add({action:"removeFolds",folds:u},this.mergeUndoDeltas),this.mergeUndoDeltas=!0),this.$undoManager.add(h,this.mergeUndoDeltas),this.mergeUndoDeltas=!0,this.$informUndoManager.schedule()),this.bgTokenizer.$updateOnChange(h),this._signal("change",h)},this.setValue=function(h){this.doc.setValue(h),this.selection.moveTo(0,0),this.$resetRowCache(0),this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},this.getValue=this.toString=function(){return this.doc.getValue()},this.getSelection=function(){return this.selection},this.getState=function(h){return this.bgTokenizer.getState(h)},this.getTokens=function(h){return this.bgTokenizer.getTokens(h)},this.getTokenAt=function(h,u){var y=this.bgTokenizer.getTokens(h),v=0;if(u==null)var w=y.length-1,v=this.getLine(h).length;else for(w=0;w<y.length&&!(u<=(v+=y[w].value.length));w++);return(h=y[w])?(h.index=w,h.start=v-h.value.length,h):null},this.setUndoManager=function(h){var u;this.$undoManager=h,this.$informUndoManager&&this.$informUndoManager.cancel(),h?(h.addSession(u=this),this.$syncInformUndoManager=function(){u.$informUndoManager.cancel(),u.mergeUndoDeltas=!1},this.$informUndoManager=a.delayedCall(this.$syncInformUndoManager)):this.$syncInformUndoManager=function(){}},this.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},this.$defaultUndoManager={undo:function(){},redo:function(){},hasUndo:function(){},hasRedo:function(){},reset:function(){},add:function(){},addSelection:function(){},startNewGroup:function(){},addSession:function(){}},this.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},this.getTabString=function(){return this.getUseSoftTabs()?a.stringRepeat(" ",this.getTabSize()):"	"},this.setUseSoftTabs=function(h){this.setOption("useSoftTabs",h)},this.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},this.setTabSize=function(h){this.setOption("tabSize",h)},this.getTabSize=function(){return this.$tabSize},this.isTabStop=function(h){return this.$useSoftTabs&&h.column%this.$tabSize==0},this.setNavigateWithinSoftTabs=function(h){this.setOption("navigateWithinSoftTabs",h)},this.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs},this.$overwrite=!1,this.setOverwrite=function(h){this.setOption("overwrite",h)},this.getOverwrite=function(){return this.$overwrite},this.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},this.addGutterDecoration=function(h,u){this.$decorations[h]||(this.$decorations[h]=""),this.$decorations[h]+=" "+u,this._signal("changeBreakpoint",{})},this.removeGutterDecoration=function(h,u){this.$decorations[h]=(this.$decorations[h]||"").replace(" "+u,""),this._signal("changeBreakpoint",{})},this.getBreakpoints=function(){return this.$breakpoints},this.setBreakpoints=function(h){this.$breakpoints=[];for(var u=0;u<h.length;u++)this.$breakpoints[h[u]]="ace_breakpoint";this._signal("changeBreakpoint",{})},this.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},this.setBreakpoint=function(h,u){(u=u===void 0?"ace_breakpoint":u)?this.$breakpoints[h]=u:delete this.$breakpoints[h],this._signal("changeBreakpoint",{})},this.clearBreakpoint=function(h){delete this.$breakpoints[h],this._signal("changeBreakpoint",{})},this.addMarker=function(T,u,y,w){var v=this.$markerId++,T={range:T,type:y||"line",renderer:typeof y=="function"?y:null,clazz:u,inFront:!!w,id:v};return w?(this.$frontMarkers[v]=T,this._signal("changeFrontMarker")):(this.$backMarkers[v]=T,this._signal("changeBackMarker")),v},this.addDynamicMarker=function(h,u){var y;if(h.update)return y=this.$markerId++,h.id=y,h.inFront=!!u,u?(this.$frontMarkers[y]=h,this._signal("changeFrontMarker")):(this.$backMarkers[y]=h,this._signal("changeBackMarker")),h},this.removeMarker=function(h){var u=this.$frontMarkers[h]||this.$backMarkers[h];u&&(delete(u.inFront?this.$frontMarkers:this.$backMarkers)[h],this._signal(u.inFront?"changeFrontMarker":"changeBackMarker"))},this.getMarkers=function(h){return h?this.$frontMarkers:this.$backMarkers},this.highlight=function(h){var u;this.$searchHighlight||(u=new c(null,"ace_selected-word","text"),this.$searchHighlight=this.addDynamicMarker(u)),this.$searchHighlight.setRegexp(h)},this.highlightLines=function(h,u,y,w){return typeof u!="number"&&(y=u,u=h),y=y||"ace_step",h=new r(h,0,u,1/0),h.id=this.addMarker(h,y,"fullLine",w),h},this.setAnnotations=function(h){this.$annotations=h,this._signal("changeAnnotation",{})},this.getAnnotations=function(){return this.$annotations||[]},this.clearAnnotations=function(){this.setAnnotations([])},this.$detectNewLine=function(h){h=h.match(/^.*?(\r?\n)/m),this.$autoNewLine=h?h[1]:`
`},this.getWordRange=function(h,u){var y,w=this.getLine(h),v=!1,T=(y=(v=(v=0<u?!!w.charAt(u-1).match(this.tokenRe):v)||!!w.charAt(u).match(this.tokenRe))?this.tokenRe:/^\s+$/.test(w.slice(u-1,u+1))?/\s/:this.nonTokenRe,u);if(0<T){for(;0<=--T&&w.charAt(T).match(y););T++}for(var B=u;B<w.length&&w.charAt(B).match(y);)B++;return new r(h,T,h,B)},this.getAWordRange=function(h,u){for(var y=this.getWordRange(h,u),w=this.getLine(y.end.row);w.charAt(y.end.column).match(/[ \t]/);)y.end.column+=1;return y},this.setNewLineMode=function(h){this.doc.setNewLineMode(h)},this.getNewLineMode=function(){return this.doc.getNewLineMode()},this.setUseWorker=function(h){this.setOption("useWorker",h)},this.getUseWorker=function(){return this.$useWorker},this.onReloadTokenizer=function(h){var u=h.data;this.bgTokenizer.start(u.first),this._signal("tokenizerUpdate",h)},this.$modes=n.$modes,this.$mode=null,this.$modeId=null,this.setMode=function(h,u){if(h&&typeof h=="object"){if(h.getTokenizer)return this.$onChangeMode(h);var y=h,w=y.path}else w=h||"ace/mode/text";this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new e),this.$modes[w]&&!y?(this.$onChangeMode(this.$modes[w]),u&&u()):(this.$modeId=w,n.loadModule(["mode",w],function(v){if(this.$modeId!==w)return u&&u();this.$modes[w]&&!y?this.$onChangeMode(this.$modes[w]):v&&v.Mode&&(v=new v.Mode(y),y||((this.$modes[w]=v).$id=w),this.$onChangeMode(v)),u&&u()}.bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0))},this.$onChangeMode=function(h,u){var y,w,v;u||(this.$modeId=h.$id),this.$mode!==h&&(y=this.$mode,this.$mode=h,this.$stopWorker(),this.$useWorker&&this.$startWorker(),(w=h.getTokenizer()).on!==void 0&&(v=this.onReloadTokenizer.bind(this),w.on("update",v)),this.bgTokenizer.setTokenizer(w),this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=h.tokenRe,this.nonTokenRe=h.nonTokenRe,u||(h.attachToSession&&h.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(h.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode",{oldMode:y,mode:h})))},this.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},this.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(h){n.warn("Could not load worker",h),this.$worker=null}},this.getMode=function(){return this.$mode},this.$scrollTop=0,this.setScrollTop=function(h){this.$scrollTop===h||isNaN(h)||(this.$scrollTop=h,this._signal("changeScrollTop",h))},this.getScrollTop=function(){return this.$scrollTop},this.$scrollLeft=0,this.setScrollLeft=function(h){this.$scrollLeft===h||isNaN(h)||(this.$scrollLeft=h,this._signal("changeScrollLeft",h))},this.getScrollLeft=function(){return this.$scrollLeft},this.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},this.getLineWidgetMaxWidth=function(){var h;return this.lineWidgetsWidth!=null?this.lineWidgetsWidth:(h=0,this.lineWidgets.forEach(function(u){u&&u.screenWidth>h&&(h=u.screenWidth)}),this.lineWidgetWidth=h)},this.$computeWidth=function(h){if(this.$modified||h){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var u=this.doc.getAllLines(),y=this.$rowLengthCache,w=0,v=0,T=this.$foldData[v],B=T?T.start.row:1/0,E=u.length,_=0;_<E;_++){if(B<_){if(E<=(_=T.end.row+1))break;B=(T=this.$foldData[v++])?T.start.row:1/0}y[_]==null&&(y[_]=this.$getStringScreenWidth(u[_])[0]),y[_]>w&&(w=y[_])}this.screenWidth=w}},this.getLine=function(h){return this.doc.getLine(h)},this.getLines=function(h,u){return this.doc.getLines(h,u)},this.getLength=function(){return this.doc.getLength()},this.getTextRange=function(h){return this.doc.getTextRange(h||this.selection.getRange())},this.insert=function(h,u){return this.doc.insert(h,u)},this.remove=function(h){return this.doc.remove(h)},this.removeFullLines=function(h,u){return this.doc.removeFullLines(h,u)},this.undoChanges=function(h,u){if(h.length){this.$fromUndo=!0;for(var y=h.length-1;y!=-1;y--){var w=h[y];w.action=="insert"||w.action=="remove"?this.doc.revertDelta(w):w.folds&&this.addFolds(w.folds)}!u&&this.$undoSelect&&(h.selectionBefore?this.selection.fromJSON(h.selectionBefore):this.selection.setRange(this.$getUndoSelection(h,!0))),this.$fromUndo=!1}},this.redoChanges=function(h,u){if(h.length){this.$fromUndo=!0;for(var y=0;y<h.length;y++){var w=h[y];w.action!="insert"&&w.action!="remove"||this.doc.$safeApplyDelta(w)}!u&&this.$undoSelect&&(h.selectionAfter?this.selection.fromJSON(h.selectionAfter):this.selection.setRange(this.$getUndoSelection(h,!1))),this.$fromUndo=!1}},this.setUndoSelect=function(h){this.$undoSelect=h},this.$getUndoSelection=function(h,u){function y(E){return u?E.action!=="insert":E.action==="insert"}for(var w,v,T=0;T<h.length;T++){var B=h[T];B.start&&(w?y(B)?(v=B.start,w.compare(v.row,v.column)==-1&&w.setStart(v),v=B.end,w.compare(v.row,v.column)==1&&w.setEnd(v)):(v=B.start,w.compare(v.row,v.column)==-1&&(w=r.fromPoints(B.start,B.start))):w=y(B)?r.fromPoints(B.start,B.end):r.fromPoints(B.start,B.start))}return w},this.replace=function(h,u){return this.doc.replace(h,u)},this.moveText=function(h,_,y){var w,v,T,B=this.getTextRange(h),E=this.getFoldsInRange(h),_=r.fromPoints(_,_);return y||(this.remove(h),v=h.start.row-h.end.row,(T=v?-h.end.column:h.start.column-h.end.column)&&(_.start.row==h.end.row&&_.start.column>h.end.column&&(_.start.column+=T),_.end.row==h.end.row&&_.end.column>h.end.column&&(_.end.column+=T)),v&&_.start.row>=h.end.row&&(_.start.row+=v,_.end.row+=v)),_.end=this.insert(_.start,B),E.length&&(w=h.start,y=_.start,v=y.row-w.row,T=y.column-w.column,this.addFolds(E.map(function(P){return(P=P.clone()).start.row==w.row&&(P.start.column+=T),P.end.row==w.row&&(P.end.column+=T),P.start.row+=v,P.end.row+=v,P}))),_},this.indentRows=function(h,u,y){y=y.replace(/\t/g,this.getTabString());for(var w=h;w<=u;w++)this.doc.insertInLine({row:w,column:0},y)},this.outdentRows=function(h){for(var u=h.collapseRows(),y=new r(0,0,0,0),w=this.getTabSize(),v=u.start.row;v<=u.end.row;++v){var T=this.getLine(v);y.start.row=v,y.end.row=v;for(var B=0;B<w&&T.charAt(B)==" ";++B);B<w&&T.charAt(B)=="	"?(y.start.column=B,y.end.column=B+1):(y.start.column=0,y.end.column=B),this.remove(y)}},this.$moveLines=function(h,u,T){if(h=this.getRowFoldStart(h),u=this.getRowFoldEnd(u),T<0){if((v=this.getRowFoldStart(h+T))<0)return 0;var w=v-h}else if(0<T){if((v=this.getRowFoldEnd(u+T))>this.doc.getLength()-1)return 0;w=v-u}else h=this.$clipRowToDocument(h),w=(u=this.$clipRowToDocument(u))-h+1;var v=new r(h,0,u,Number.MAX_VALUE),v=this.getFoldsInRange(v).map(function(B){return(B=B.clone()).start.row+=w,B.end.row+=w,B}),T=T==0?this.doc.getLines(h,u):this.doc.removeFullLines(h,u);return this.doc.insertFullLines(h+w,T),v.length&&this.addFolds(v),w},this.moveLinesUp=function(h,u){return this.$moveLines(h,u,-1)},this.moveLinesDown=function(h,u){return this.$moveLines(h,u,1)},this.duplicateLines=function(h,u){return this.$moveLines(h,u,0)},this.$clipRowToDocument=function(h){return Math.max(0,Math.min(h,this.doc.getLength()-1))},this.$clipColumnToRow=function(h,u){return u<0?0:Math.min(this.doc.getLine(h).length,u)},this.$clipPositionToDocument=function(h,u){var y;return u=Math.max(0,u),u=h<0?h=0:(y=this.doc.getLength())<=h?this.doc.getLine(h=y-1).length:Math.min(this.doc.getLine(h).length,u),{row:h,column:u}},this.$clipRangeToDocument=function(h){h.start.row<0?(h.start.row=0,h.start.column=0):h.start.column=this.$clipColumnToRow(h.start.row,h.start.column);var u=this.doc.getLength()-1;return h.end.row>u?(h.end.row=u,h.end.column=this.doc.getLine(u).length):h.end.column=this.$clipColumnToRow(h.end.row,h.end.column),h},this.$wrapLimit=80,this.$useWrapMode=!1,this.$wrapLimitRange={min:null,max:null},this.setUseWrapMode=function(h){h!=this.$useWrapMode&&(this.$useWrapMode=h,this.$modified=!0,this.$resetRowCache(0),h&&(h=this.getLength(),this.$wrapData=Array(h),this.$updateWrapData(0,h-1)),this._signal("changeWrapMode"))},this.getUseWrapMode=function(){return this.$useWrapMode},this.setWrapLimitRange=function(h,u){this.$wrapLimitRange.min===h&&this.$wrapLimitRange.max===u||(this.$wrapLimitRange={min:h,max:u},this.$modified=!0,this.$bidiHandler.markAsDirty(),this.$useWrapMode&&this._signal("changeWrapMode"))},this.adjustWrapLimit=function(h,w){var y=this.$wrapLimitRange,w=(y.max<0&&(y={min:w,max:w}),this.$constrainWrapLimit(h,y.min,y.max));return w!=this.$wrapLimit&&1<w&&(this.$wrapLimit=w,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0)},this.$constrainWrapLimit=function(h,u,y){return u&&(h=Math.max(u,h)),h=y?Math.min(y,h):h},this.getWrapLimit=function(){return this.$wrapLimit},this.setWrapLimit=function(h){this.setWrapLimitRange(h,h)},this.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},this.$updateInternalDataOnChange=function(h){var u=this.$useWrapMode,y=h.action,w=h.start,v=h.end,T=w.row,B=v.row,E=B-T,_=null;if(this.$updating=!0,E!=0)if(y==="remove"){this[u?"$wrapData":"$rowLengthCache"].splice(T,E);var P=this.$foldData,_=this.getFoldsInRange(h);this.removeFolds(_);var H=0;for((Y=this.getFoldLine(v.row))&&(Y.addRemoveChars(v.row,v.column,w.column-v.column),Y.shiftRow(-E),(z=this.getFoldLine(T))&&z!==Y&&(z.merge(Y),Y=z),H=P.indexOf(Y)+1);H<P.length;H++)(Y=P[H]).start.row>=v.row&&Y.shiftRow(-E);B=T}else{var z=Array(E),K=(z.unshift(T,0),u?this.$wrapData:this.$rowLengthCache),P=(K.splice.apply(K,z),this.$foldData),H=0;for((Y=this.getFoldLine(T))&&((K=Y.range.compareInside(w.row,w.column))==0?(Y=Y.split(w.row,w.column))&&(Y.shiftRow(E),Y.addRemoveChars(B,0,v.column-w.column)):K==-1&&(Y.addRemoveChars(T,0,v.column-w.column),Y.shiftRow(E)),H=P.indexOf(Y)+1);H<P.length;H++)(Y=P[H]).start.row>=T&&Y.shiftRow(E)}else{var Y,E=Math.abs(h.start.column-h.end.column);y==="remove"&&(_=this.getFoldsInRange(h),this.removeFolds(_),E=-E),(Y=this.getFoldLine(T))&&Y.addRemoveChars(T,w.column,E)}return u&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,u?this.$updateWrapData(T,B):this.$updateRowLengthCache(T,B),_},this.$updateRowLengthCache=function(h,u,y){this.$rowLengthCache[h]=null,this.$rowLengthCache[u]=null},this.$updateWrapData=function(h,u){var y,w,v=this.doc.getAllLines(),T=this.getTabSize(),B=this.$wrapData,E=this.$wrapLimit,_=h;for(u=Math.min(u,v.length-1);_<=u;)(w=this.getFoldLine(_,w))?(y=[],w.walk(function(P,H,z,K){var Y;if(P!=null){(Y=this.$getDisplayTokens(P,y.length))[0]=d;for(var R=1;R<Y.length;R++)Y[R]=b}else Y=this.$getDisplayTokens(v[H].substring(K,z),y.length);y=y.concat(Y)}.bind(this),w.end.row,v[w.end.row].length+1),B[w.start.row]=this.$computeWrapSplits(y,E,T),_=w.end.row+1):(y=this.$getDisplayTokens(v[_]),B[_]=this.$computeWrapSplits(y,E,T),_++)};var d=3,b=4;function I(h){return!(h<4352)&&(4352<=h&&h<=4447||4515<=h&&h<=4519||4602<=h&&h<=4607||9001<=h&&h<=9002||11904<=h&&h<=11929||11931<=h&&h<=12019||12032<=h&&h<=12245||12272<=h&&h<=12283||12288<=h&&h<=12350||12353<=h&&h<=12438||12441<=h&&h<=12543||12549<=h&&h<=12589||12593<=h&&h<=12686||12688<=h&&h<=12730||12736<=h&&h<=12771||12784<=h&&h<=12830||12832<=h&&h<=12871||12880<=h&&h<=13054||13056<=h&&h<=19903||19968<=h&&h<=42124||42128<=h&&h<=42182||43360<=h&&h<=43388||44032<=h&&h<=55203||55216<=h&&h<=55238||55243<=h&&h<=55291||63744<=h&&h<=64255||65040<=h&&h<=65049||65072<=h&&h<=65106||65108<=h&&h<=65126||65128<=h&&h<=65131||65281<=h&&h<=65376||65504<=h&&h<=65510)}this.$computeWrapSplits=function(h,u,y){if(h.length==0)return[];var w=[],v=h.length,T=0,B=0,E=this.$wrapAsCode,_=this.$indentedSoftWrap,P=u<=Math.max(2*y,8)||_===!1?0:Math.floor(u/2);function H(R){for(var Z=R-T,W=T;W<R;W++){var f=h[W];f!==12&&f!==2||--Z}w.length||(z=function(){var S=0;if(P===0)return S;if(_)for(var $=0;$<h.length;$++){var F=h[$];if(F==10)S+=1;else if(F==11)S+=y;else if(F!=12)break}return E&&_!==!1&&(S+=y),Math.min(S,P)}(),w.indent=z),B+=Z,w.push(B),T=R}for(var z=0;u-z<v-T;){var K=T+u-z;if(10<=h[K-1]&&10<=h[K])H(K);else if(h[K]==d||h[K]==b){for(;K!=T-1&&h[K]!=d;K--);if(!(T<K)){for(K=T+u;K<h.length&&h[K]==b;K++);if(K==h.length)break}H(K)}else{for(var Y=Math.max(K-(u-(u>>2)),T-1);Y<K&&h[K]<d;)K--;if(E){for(;Y<K&&h[K]<d;)K--;for(;Y<K&&h[K]==9;)K--}else for(;Y<K&&h[K]<10;)K--;Y<K?H(++K):(h[K=T+u]==2&&K--,H(K-z))}}return w},this.$getDisplayTokens=function(h,u){var y,w=[];u=u||0;for(var v=0;v<h.length;v++){var T=h.charCodeAt(v);if(T==9){y=this.getScreenTabSize(w.length+u),w.push(11);for(var B=1;B<y;B++)w.push(12)}else T==32?w.push(10):39<T&&T<48||57<T&&T<64?w.push(9):4352<=T&&I(T)?w.push(1,2):w.push(1)}return w},this.$getStringScreenWidth=function(h,u,y){if(u==0)return[0,0];var w,v;for(u==null&&(u=1/0),y=y||0,v=0;v<h.length&&((w=h.charCodeAt(v))==9?y+=this.getScreenTabSize(y):4352<=w&&I(w)?y+=2:y+=1,!(u<y));v++);return[y,v]},this.lineWidgets=null,this.getRowLength=function(h){var u=1;return this.lineWidgets&&(u+=this.lineWidgets[h]&&this.lineWidgets[h].rowCount||0),this.$useWrapMode&&this.$wrapData[h]?this.$wrapData[h].length+u:u},this.getRowLineCount=function(h){return this.$useWrapMode&&this.$wrapData[h]?this.$wrapData[h].length+1:1},this.getRowWrapIndent=function(h){var u;return this.$useWrapMode&&(h=this.screenToDocumentPosition(h,Number.MAX_VALUE),(u=this.$wrapData[h.row]).length&&u[0]<h.column)?u.indent:0},this.getScreenLastRowColumn=function(h){return h=this.screenToDocumentPosition(h,Number.MAX_VALUE),this.documentToScreenColumn(h.row,h.column)},this.getDocumentLastRowColumn=function(h,u){return h=this.documentToScreenRow(h,u),this.getScreenLastRowColumn(h)},this.getDocumentLastRowColumnPosition=function(h,u){return h=this.documentToScreenRow(h,u),this.screenToDocumentPosition(h,Number.MAX_VALUE/10)},this.getRowSplitData=function(h){if(this.$useWrapMode)return this.$wrapData[h]},this.getScreenTabSize=function(h){return this.$tabSize-(h%this.$tabSize|0)},this.screenToDocumentRow=function(h,u){return this.screenToDocumentPosition(h,u).row},this.screenToDocumentColumn=function(h,u){return this.screenToDocumentPosition(h,u).column},this.screenToDocumentPosition=function(h,u,y){if(h<0)return{row:0,column:0};for(var w,v,T,B=0,E=0,_=0,P=0,H=this.$screenRowCache,z=this.$getRowCacheIndex(H,h),K=H.length,Y=(T=K&&0<=z?(_=H[z],B=this.$docRowCache[z],h>H[K-1]):!K,this.getLength()-1),R=this.getNextFoldLine(B),Z=R?R.start.row:1/0;_<=h&&!(h<_+(P=this.getRowLength(B))||Y<=B);)_+=P,Z<++B&&(B=R.end.row+1,Z=(R=this.getNextFoldLine(B,R))?R.start.row:1/0),T&&(this.$docRowCache.push(B),this.$screenRowCache.push(_));if(R&&R.start.row<=B)w=this.getFoldDisplayLine(R),B=R.start.row;else{if(_+P<=h||Y<B)return{row:Y,column:this.getLine(Y).length};w=this.getLine(B),R=null}return z=0,H=Math.floor(h-_),this.$useWrapMode&&(K=this.$wrapData[B])&&(v=K[H],0<H&&K.length&&(z=K.indent,E=K[H-1]||K[K.length-1],w=w.substring(E))),y!==void 0&&this.$bidiHandler.isBidiRow(_+H,B,H)&&(u=this.$bidiHandler.offsetToCol(y)),E+=this.$getStringScreenWidth(w,u-z)[1],this.$useWrapMode&&v<=E&&(E=v-1),R?R.idxToPosition(E):{row:B,column:E}},this.documentToScreenPosition=function(h,u){var z=u===void 0?this.$clipPositionToDocument(h.row,h.column):this.$clipPositionToDocument(h,u),y=(h=z.row,u=z.column,0),z=null;(B=this.getFoldAt(h,u,1))&&(h=B.start.row,u=B.start.column);for(var w,v,T=0,B=this.$docRowCache,K=this.$getRowCacheIndex(B,h),E=B.length,_=(v=E&&0<=K?(T=B[K],y=this.$screenRowCache[K],h>B[E-1]):!E,this.getNextFoldLine(T)),P=_?_.start.row:1/0;T<h;){if(P<=T){if(h<(w=_.end.row+1))break;P=(_=this.getNextFoldLine(w,_))?_.start.row:1/0}else w=T+1;y+=this.getRowLength(T),T=w,v&&(this.$docRowCache.push(T),this.$screenRowCache.push(y))}var H="",z=_&&P<=T?(H=this.getFoldDisplayLine(_,h,u),_.start.row):(H=this.getLine(h).substring(0,u),h),K=0;if(this.$useWrapMode){var Y=this.$wrapData[z];if(Y){for(var R=0;H.length>=Y[R];)y++,R++;H=H.substring(Y[R-1]||0,H.length),K=0<R?Y.indent:0}}return this.lineWidgets&&this.lineWidgets[T]&&this.lineWidgets[T].rowsAbove&&(y+=this.lineWidgets[T].rowsAbove),{row:y,column:K+this.$getStringScreenWidth(H)[0]}},this.documentToScreenColumn=function(h,u){return this.documentToScreenPosition(h,u).column},this.documentToScreenRow=function(h,u){return this.documentToScreenPosition(h,u).row},this.getScreenLength=function(){var h=0,u=null;if(this.$useWrapMode)for(var y=this.$wrapData.length,w=0,v=0,T=(u=this.$foldData[v++])?u.start.row:1/0;w<y;){var B=this.$wrapData[w];h+=B?B.length+1:1,T<++w&&(w=u.end.row+1,T=(u=this.$foldData[v++])?u.start.row:1/0)}else for(var h=this.getLength(),E=this.$foldData,v=0;v<E.length;v++)h-=(u=E[v]).end.row-u.start.row;return this.lineWidgets&&(h+=this.$getWidgetScreenLength()),h},this.$setFontMetrics=function(h){this.$enableVarChar&&(this.$getStringScreenWidth=function(u,y,w){if(y===0)return[0,0];var v,T;for(y=y||1/0,w=w||0,T=0;T<u.length&&!(y<(w+=(v=u.charAt(T))==="	"?this.getScreenTabSize(w):h.getCharacterWidth(v)));T++);return[w,T]})},this.destroy=function(){this.destroyed||(this.bgTokenizer.setDocument(null),this.bgTokenizer.cleanup(),this.destroyed=!0),this.$stopWorker(),this.removeAllListeners(),this.doc&&this.doc.off("change",this.$onChange),this.selection.detach()},this.isFullWidth=I}.call(x.prototype),C("./edit_session/folding").Folding.call(x.prototype),C("./edit_session/bracket_match").BracketMatch.call(x.prototype),n.defineOptions(x.prototype,"session",{wrap:{set:function(d){d&&d!="off"?d=="free"?d=!0:d=="printMargin"?d=-1:typeof d=="string"&&(d=parseInt(d,10)||!1):d=!1,this.$wrap!=d&&((this.$wrap=d)?(this.setWrapLimitRange(d=typeof d=="number"?d:null,d),this.setUseWrapMode(!0)):this.setUseWrapMode(!1))},get:function(){return this.getUseWrapMode()?this.$wrap==-1?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(d){(d=d=="auto"?this.$mode.type!="text":d!="text")!=this.$wrapAsCode&&(this.$wrapAsCode=d,this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0)))},initialValue:"auto"},indentedSoftWrap:{set:function(){this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(d){this.$useWorker=d,this.$stopWorker(),d&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(d){0<(d=parseInt(d))&&this.$tabSize!==d&&(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=d,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},foldStyle:{set:function(d){this.setFoldStyle(d)},handlesSet:!0},overwrite:{set:function(d){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(d){this.doc.setNewLineMode(d)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(d){this.setMode(d)},get:function(){return this.$modeId},handlesSet:!0}}),m.EditSession=x}),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(C,m,A){function x(){this.$options={}}var p=C("./lib/lang"),a=C("./lib/oop"),l=C("./range").Range;(function(){this.set=function(n){return a.mixin(this.$options,n),this},this.getOptions=function(){return p.copyObject(this.$options)},this.setOptions=function(n){this.$options=n},this.find=function(e){var i,t=this.$options,e=this.$matchIterator(e,t);return!!e&&(i=null,e.forEach(function(r,s,o,c){return i=new l(r,s,o,c),!(s==c&&t.start&&t.start.start&&t.skipCurrent!=0&&i.isEqual(t.start))||(i=null,!1)}),i)},this.findAll=function(n){var i=this.$options;if(!i.needle)return[];this.$assembleRegExp(i);var t=i.range,e=t?n.getLines(t.start.row,t.end.row):n.doc.getAllLines(),r=[],s=i.re;if(i.$isMultiLine){var o,c=s.length,d=e.length-c;e:for(var b=s.offset||0;b<=d;b++){for(var I=0;I<c;I++)if(e[b+I].search(s[I])==-1)continue e;var h=e[b],u=e[b+c-1],h=h.length-h.match(s[0])[0].length,u=u.match(s[c-1])[0].length;o&&o.end.row===b&&o.end.column>h||(r.push(o=new l(b,h,b+c-1,u)),2<c&&(b=b+c-2))}}else for(var y=0;y<e.length;y++)for(var w=p.getMatchOffsets(e[y],s),I=0;I<w.length;I++){var v=w[I];r.push(new l(y,v.offset,y,v.offset+v.length))}if(t){for(var T=t.start.column,B=t.start.column,y=0,I=r.length-1;y<I&&r[y].start.column<T&&r[y].start.row==t.start.row;)y++;for(;y<I&&r[I].end.column>B&&r[I].end.row==t.end.row;)I--;for(r=r.slice(y,I+1),y=0,I=r.length;y<I;y++)r[y].start.row+=t.start.row,r[y].end.row+=t.start.row}return r},this.replace=function(n,i){var t=this.$options,e=this.$assembleRegExp(t);if(t.$isMultiLine)return i;if(e){var r=e.exec(n);if(!r||r[0].length!=n.length)return null;if(i=n.replace(e,i),t.preserveCase){i=i.split("");for(var s=Math.min(n.length,n.length);s--;){var o=n[s];o&&o.toLowerCase()!=o?i[s]=i[s].toUpperCase():i[s]=i[s].toLowerCase()}i=i.join("")}return i}},this.$assembleRegExp=function(n,i){if(n.needle instanceof RegExp)return n.re=n.needle;var t,e=n.needle;if(!n.needle)return n.re=!1;function r(c){return/\w/.test(c)||t.regExp?"\\b":""}n.regExp||(e=p.escapeRegExp(e)),n.wholeWord&&(t=n,e=r((s=e)[0])+s+r(s[s.length-1]));var s=n.caseSensitive?"gm":"gmi";if(n.$isMultiLine=!i&&/[\n\r]/.test(e),n.$isMultiLine)return n.re=this.$assembleMultilineRegExp(e,s);try{var o=new RegExp(e,s)}catch{o=!1}return n.re=o},this.$assembleMultilineRegExp=function(n,i){for(var t=n.replace(/\r\n|\r|\n/g,`$
^`).split(`
`),e=[],r=0;r<t.length;r++)try{e.push(new RegExp(t[r],i))}catch{return!1}return e},this.$matchIterator=function(n,i){var t,e,r,s,o,c,d,b,I=this.$assembleRegExp(i);return!!I&&(t=i.backwards==1,e=i.skipCurrent!=0,r=i.range,(s=(s=i.start)||(r?r[t?"end":"start"]:n.selection.getRange())).start&&(s=s[e!=t?"end":"start"]),o=r?r.start.row:0,c=r?r.end.row:n.getLength()-1,b=i.$isMultiLine?(d=I.length,function(h,u,y){var w=t?h-d+1:h;if(!(w<0||w+d>n.getLength())){var v=n.getLine(w),h=v.search(I[0]);if(!(!t&&h<u||h===-1)){for(var T=1;T<d;T++)if((v=n.getLine(w+T)).search(I[T])==-1)return;var B=v.match(I[d-1])[0].length;if(!(t&&u<B))return!!y(w,h,w+d-1,B)||void 0}}}):t?function(h,u,y){var w,v=n.getLine(h),T=[];for(I.lastIndex=0;w=I.exec(v);){var B=w[0].length,E=w.index;if(!B){if(E>=v.length)break;I.lastIndex=E+=1}if(w.index+B>u)break;T.push(w.index,B)}for(var _=T.length-1;0<=_;_-=2){var P=T[_-1];if(y(h,P,h,P+(B=T[_])))return!0}}:function(h,u,y){var w=n.getLine(h);for(I.lastIndex=u;v=I.exec(w);){var v,T=v[0].length;if(y(h,v=v.index,h,v+T))return!0;if(!T&&(I.lastIndex=v+=1,v>=w.length))return!1}},{forEach:t?function(h){var u=s.row;if(!b(u,s.column,h)){for(u--;o<=u;u--)if(b(u,Number.MAX_VALUE,h))return;if(i.wrap!=0){for(u=c,o=s.row;o<=u;u--)if(b(u,Number.MAX_VALUE,h))return}}}:function(h){var u=s.row;if(!b(u,s.column,h)){for(u+=1;u<=c;u++)if(b(u,0,h))return;if(i.wrap!=0){for(u=o,c=s.row;u<=c;u++)if(b(u,0,h))return}}}})}}).call(x.prototype),m.Search=x}),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(C,m,A){var x=C("../lib/keys"),p=C("../lib/useragent"),a=x.KEY_MODS;function l(i,t){this.platform=t||(p.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(i),this.$singleCommand=!0}function n(i,t){l.call(this,i,t),this.$singleCommand=!1}n.prototype=l.prototype,function(){function i(t){return typeof t=="object"&&t.bindKey&&t.bindKey.position||(t.isDefault?-100:0)}this.addCommand=function(t){this.commands[t.name]&&this.removeCommand(t),(this.commands[t.name]=t).bindKey&&this._buildKeyHash(t)},this.removeCommand=function(t,e){var r,s=t&&(typeof t=="string"?t:t.name),o=(t=this.commands[s],e||delete this.commands[s],this.commandKeyBinding);for(r in o){var c,d=o[r];d==t?delete o[r]:Array.isArray(d)&&(c=d.indexOf(t))!=-1&&(d.splice(c,1),d.length==1&&(o[r]=d[0]))}},this.bindKey=function(t,e,r){if(typeof t=="object"&&t&&(r==null&&(r=t.position),t=t[this.platform]),t)return typeof e=="function"?this.addCommand({exec:e,bindKey:t,name:e.name||t}):void t.split("|").forEach(function(d){var o="",c=(d.indexOf(" ")!=-1&&(d=(c=d.split(/\s+/)).pop(),c.forEach(function(b){b=this.parseKeys(b),b=a[b.hashId]+b.key,o+=(o?" ":"")+b,this._addCommandToBinding(o,"chainKeys")},this),o+=" "),this.parseKeys(d)),d=a[c.hashId]+c.key;this._addCommandToBinding(o+d,e,r)},this)},this._addCommandToBinding=function(t,e,r){var s=this.commandKeyBinding;if(e)if(!s[t]||this.$singleCommand)s[t]=e;else{Array.isArray(s[t])?(c=s[t].indexOf(e))!=-1&&s[t].splice(c,1):s[t]=[s[t]],typeof r!="number"&&(r=i(e));for(var o=s[t],c=0;c<o.length&&!(r<i(o[c]));c++);o.splice(c,0,e)}else delete s[t]},this.addCommands=function(t){t&&Object.keys(t).forEach(function(e){var r=t[e];if(r){if(typeof r=="string")return this.bindKey(r,e);typeof(r=typeof r=="function"?{exec:r}:r)=="object"&&(r.name||(r.name=e),this.addCommand(r))}},this)},this.removeCommands=function(t){Object.keys(t).forEach(function(e){this.removeCommand(t[e])},this)},this.bindKeys=function(t){Object.keys(t).forEach(function(e){this.bindKey(e,t[e])},this)},this._buildKeyHash=function(t){this.bindKey(t.bindKey,t)},this.parseKeys=function(t){var e=t.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(b){return b}),r=e.pop(),s=x[r];if(x.FUNCTION_KEYS[s])r=x.FUNCTION_KEYS[s].toLowerCase();else{if(!e.length)return{key:r,hashId:-1};if(e.length==1&&e[0]=="shift")return{key:r.toUpperCase(),hashId:-1}}for(var o=0,c=e.length;c--;){var d=x.KEY_MODS[e[c]];if(d==null)return typeof console<"u"&&console.error("invalid modifier "+e[c]+" in "+t),!1;o|=d}return{key:r,hashId:o}},this.findKeyCommand=function(t,e){return t=a[t]+e,this.commandKeyBinding[t]},this.handleKeyboard=function(t,e,r,s){var o,c;if(!(s<0))return o=a[e]+r,c=this.commandKeyBinding[o],t.$keyChain&&(t.$keyChain+=" "+o,c=this.commandKeyBinding[t.$keyChain]||c),!c||c!="chainKeys"&&c[c.length-1]!="chainKeys"?(t.$keyChain&&(e&&e!=4||r.length!=1?(e==-1||0<s)&&(t.$keyChain=""):t.$keyChain=t.$keyChain.slice(0,-o.length-1)),{command:c}):(t.$keyChain=t.$keyChain||o,{command:"null"})},this.getStatusText=function(t,e){return e.$keyChain||""}}.call(l.prototype),m.HashHandler=l,m.MultiHashHandler=n}),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],function(C,m,A){function x(n,i){a.call(this,i,n),this.byName=this.commands,this.setDefaultHandler("exec",function(t){return t.args?t.command.exec(t.editor,t.args,t.event,!1):t.command.exec(t.editor,{},t.event,!0)})}var p=C("../lib/oop"),a=C("../keyboard/hash_handler").MultiHashHandler,l=C("../lib/event_emitter").EventEmitter;p.inherits(x,a),function(){p.implement(this,l),this.exec=function(n,i,t){if(Array.isArray(n)){for(var e=n.length;e--;)if(this.exec(n[e],i,t))return!0;return!1}var r;return!!(n=typeof n=="string"?this.commands[n]:n)&&!(i&&i.$readOnly&&!n.readOnly)&&!(this.$checkCommandState!=0&&n.isAvailable&&!n.isAvailable(i))&&((r={editor:i,command:n,args:t}).returnValue=this._emit("exec",r),this._signal("afterExec",r),r.returnValue!==!1)},this.toggleRecording=function(n){if(!this.$inReplay)return n&&n._emit("changeStatus"),this.recording?(this.macro.pop(),this.off("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=function(i){this.macro.push([i.command,i.args])}.bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0)},this.replay=function(n){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(n);try{this.$inReplay=!0,this.macro.forEach(function(i){typeof i=="string"?this.exec(i,n):this.exec(i[0],n,i[1])},this)}finally{this.$inReplay=!1}}},this.trimMacro=function(n){return n.map(function(i){return typeof i[0]!="string"&&(i[0]=i[0].name),i=i[1]?i:i[0]})}}.call(x.prototype),m.CommandManager=x}),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],function(C,m,A){var x=C("../lib/lang"),p=C("../config"),a=C("../range").Range;function l(i,t){return{win:i,mac:t}}m.commands=[{name:"showSettingsMenu",description:"Show settings menu",bindKey:l("Ctrl-,","Command-,"),exec:function(i){p.loadModule("ace/ext/settings_menu",function(t){t.init(i),i.showSettingsMenu()})},readOnly:!0},{name:"goToNextError",description:"Go to next error",bindKey:l("Alt-E","F4"),exec:function(i){p.loadModule("./ext/error_marker",function(t){t.showErrorMarker(i,1)})},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",description:"Go to previous error",bindKey:l("Alt-Shift-E","Shift-F4"),exec:function(i){p.loadModule("./ext/error_marker",function(t){t.showErrorMarker(i,-1)})},scrollIntoView:"animate",readOnly:!0},{name:"selectall",description:"Select all",bindKey:l("Ctrl-A","Command-A"),exec:function(i){i.selectAll()},readOnly:!0},{name:"centerselection",description:"Center selection",bindKey:l(null,"Ctrl-L"),exec:function(i){i.centerSelection()},readOnly:!0},{name:"gotoline",description:"Go to line...",bindKey:l("Ctrl-L","Command-L"),exec:function(i,t){typeof t!="number"||isNaN(t)||i.gotoLine(t),i.prompt({$type:"gotoLine"})},readOnly:!0},{name:"fold",bindKey:l("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(i){i.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:l("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(i){i.session.toggleFold(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",description:"Toggle fold widget",bindKey:l("F2","F2"),exec:function(i){i.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",description:"Toggle parent fold widget",bindKey:l("Alt-F2","Alt-F2"),exec:function(i){i.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",description:"Fold all",bindKey:l(null,"Ctrl-Command-Option-0"),exec:function(i){i.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldAllComments",description:"Fold all comments",bindKey:l(null,"Ctrl-Command-Option-0"),exec:function(i){i.session.foldAllComments()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",description:"Fold other",bindKey:l("Alt-0","Command-Option-0"),exec:function(i){i.session.foldAll(),i.session.unfold(i.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",description:"Unfold all",bindKey:l("Alt-Shift-0","Command-Option-Shift-0"),exec:function(i){i.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",description:"Find next",bindKey:l("Ctrl-K","Command-G"),exec:function(i){i.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",description:"Find previous",bindKey:l("Ctrl-Shift-K","Command-Shift-G"),exec:function(i){i.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",description:"Select or find next",bindKey:l("Alt-K","Ctrl-G"),exec:function(i){i.selection.isEmpty()?i.selection.selectWord():i.findNext()},readOnly:!0},{name:"selectOrFindPrevious",description:"Select or find previous",bindKey:l("Alt-Shift-K","Ctrl-Shift-G"),exec:function(i){i.selection.isEmpty()?i.selection.selectWord():i.findPrevious()},readOnly:!0},{name:"find",description:"Find",bindKey:l("Ctrl-F","Command-F"),exec:function(i){p.loadModule("ace/ext/searchbox",function(t){t.Search(i)})},readOnly:!0},{name:"overwrite",description:"Overwrite",bindKey:"Insert",exec:function(i){i.toggleOverwrite()},readOnly:!0},{name:"selecttostart",description:"Select to start",bindKey:l("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(i){i.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",description:"Go to start",bindKey:l("Ctrl-Home","Command-Home|Command-Up"),exec:function(i){i.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",description:"Select up",bindKey:l("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(i){i.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",description:"Go line up",bindKey:l("Up","Up|Ctrl-P"),exec:function(i,t){i.navigateUp(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",description:"Select to end",bindKey:l("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(i){i.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",description:"Go to end",bindKey:l("Ctrl-End","Command-End|Command-Down"),exec:function(i){i.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",description:"Select down",bindKey:l("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(i){i.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",description:"Go line down",bindKey:l("Down","Down|Ctrl-N"),exec:function(i,t){i.navigateDown(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",description:"Select word left",bindKey:l("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(i){i.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",description:"Go to word left",bindKey:l("Ctrl-Left","Option-Left"),exec:function(i){i.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",description:"Select to line start",bindKey:l("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(i){i.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",description:"Go to line start",bindKey:l("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(i){i.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",description:"Select left",bindKey:l("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(i){i.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",description:"Go to left",bindKey:l("Left","Left|Ctrl-B"),exec:function(i,t){i.navigateLeft(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",description:"Select word right",bindKey:l("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(i){i.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",description:"Go to word right",bindKey:l("Ctrl-Right","Option-Right"),exec:function(i){i.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",description:"Select to line end",bindKey:l("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(i){i.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",description:"Go to line end",bindKey:l("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(i){i.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",description:"Select right",bindKey:l("Shift-Right","Shift-Right"),exec:function(i){i.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",description:"Go to right",bindKey:l("Right","Right|Ctrl-F"),exec:function(i,t){i.navigateRight(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",description:"Select page down",bindKey:"Shift-PageDown",exec:function(i){i.selectPageDown()},readOnly:!0},{name:"pagedown",description:"Page down",bindKey:l(null,"Option-PageDown"),exec:function(i){i.scrollPageDown()},readOnly:!0},{name:"gotopagedown",description:"Go to page down",bindKey:l("PageDown","PageDown|Ctrl-V"),exec:function(i){i.gotoPageDown()},readOnly:!0},{name:"selectpageup",description:"Select page up",bindKey:"Shift-PageUp",exec:function(i){i.selectPageUp()},readOnly:!0},{name:"pageup",description:"Page up",bindKey:l(null,"Option-PageUp"),exec:function(i){i.scrollPageUp()},readOnly:!0},{name:"gotopageup",description:"Go to page up",bindKey:"PageUp",exec:function(i){i.gotoPageUp()},readOnly:!0},{name:"scrollup",description:"Scroll up",bindKey:l("Ctrl-Up",null),exec:function(i){i.renderer.scrollBy(0,-2*i.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",description:"Scroll down",bindKey:l("Ctrl-Down",null),exec:function(i){i.renderer.scrollBy(0,2*i.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",description:"Select line start",bindKey:"Shift-Home",exec:function(i){i.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",description:"Select line end",bindKey:"Shift-End",exec:function(i){i.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",description:"Toggle recording",bindKey:l("Ctrl-Alt-E","Command-Option-E"),exec:function(i){i.commands.toggleRecording(i)},readOnly:!0},{name:"replaymacro",description:"Replay macro",bindKey:l("Ctrl-Shift-E","Command-Shift-E"),exec:function(i){i.commands.replay(i)},readOnly:!0},{name:"jumptomatching",description:"Jump to matching",bindKey:l("Ctrl-\\|Ctrl-P","Command-\\"),exec:function(i){i.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"selecttomatching",description:"Select to matching",bindKey:l("Ctrl-Shift-\\|Ctrl-Shift-P","Command-Shift-\\"),exec:function(i){i.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",description:"Expand to matching",bindKey:l("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(i){i.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",description:"Pass keys to browser",bindKey:l(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",description:"Copy",exec:function(i){},readOnly:!0},{name:"cut",description:"Cut",exec:function(i){var t=i.$copyWithEmptySelection&&i.selection.isEmpty()?i.selection.getLineRange():i.selection.getRange();i._emit("cut",t),t.isEmpty()||i.session.remove(t),i.clearSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",description:"Paste",exec:function(i,t){i.$handlePaste(t)},scrollIntoView:"cursor"},{name:"removeline",description:"Remove line",bindKey:l("Ctrl-D","Command-D"),exec:function(i){i.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",description:"Duplicate selection",bindKey:l("Ctrl-Shift-D","Command-Shift-D"),exec:function(i){i.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",description:"Sort lines",bindKey:l("Ctrl-Alt-S","Command-Alt-S"),exec:function(i){i.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",description:"Toggle comment",bindKey:l("Ctrl-/","Command-/"),exec:function(i){i.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",description:"Toggle block comment",bindKey:l("Ctrl-Shift-/","Command-Shift-/"),exec:function(i){i.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",description:"Modify number up",bindKey:l("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(i){i.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",description:"Modify number down",bindKey:l("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(i){i.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",description:"Replace",bindKey:l("Ctrl-H","Command-Option-F"),exec:function(i){p.loadModule("ace/ext/searchbox",function(t){t.Search(i,!0)})}},{name:"undo",description:"Undo",bindKey:l("Ctrl-Z","Command-Z"),exec:function(i){i.undo()}},{name:"redo",description:"Redo",bindKey:l("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(i){i.redo()}},{name:"copylinesup",description:"Copy lines up",bindKey:l("Alt-Shift-Up","Command-Option-Up"),exec:function(i){i.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",description:"Move lines up",bindKey:l("Alt-Up","Option-Up"),exec:function(i){i.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",description:"Copy lines down",bindKey:l("Alt-Shift-Down","Command-Option-Down"),exec:function(i){i.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",description:"Move lines down",bindKey:l("Alt-Down","Option-Down"),exec:function(i){i.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",description:"Delete",bindKey:l("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(i){i.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",description:"Backspace",bindKey:l("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(i){i.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",description:"Cut or delete",bindKey:l("Shift-Delete",null),exec:function(i){if(!i.selection.isEmpty())return!1;i.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",description:"Remove to line start",bindKey:l("Alt-Backspace","Command-Backspace"),exec:function(i){i.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",description:"Remove to line end",bindKey:l("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(i){i.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",description:"Remove to line start hard",bindKey:l("Ctrl-Shift-Backspace",null),exec:function(i){var t=i.selection.getRange();t.start.column=0,i.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",description:"Remove to line end hard",bindKey:l("Ctrl-Shift-Delete",null),exec:function(i){var t=i.selection.getRange();t.end.column=Number.MAX_VALUE,i.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",description:"Remove word left",bindKey:l("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(i){i.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",description:"Remove word right",bindKey:l("Ctrl-Delete","Alt-Delete"),exec:function(i){i.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",description:"Outdent",bindKey:l("Shift-Tab","Shift-Tab"),exec:function(i){i.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",description:"Indent",bindKey:l("Tab","Tab"),exec:function(i){i.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",description:"Block outdent",bindKey:l("Ctrl-[","Ctrl-["),exec:function(i){i.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",description:"Block indent",bindKey:l("Ctrl-]","Ctrl-]"),exec:function(i){i.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",description:"Insert string",exec:function(i,t){i.insert(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",description:"Insert text",exec:function(i,t){i.insert(x.stringRepeat(t.text||"",t.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",description:"Split line",bindKey:l(null,"Ctrl-O"),exec:function(i){i.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",description:"Transpose letters",bindKey:l("Alt-Shift-X","Ctrl-T"),exec:function(i){i.transposeLetters()},multiSelectAction:function(i){i.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",description:"To uppercase",bindKey:l("Ctrl-U","Ctrl-U"),exec:function(i){i.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",description:"To lowercase",bindKey:l("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(i){i.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"autoindent",description:"Auto Indent",bindKey:l(null,null),exec:function(i){i.autoIndent()},multiSelectAction:"forEachLine",scrollIntoView:"animate"},{name:"expandtoline",description:"Expand to line",bindKey:l("Ctrl-Shift-L","Command-Shift-L"),exec:function(i){var t=i.selection.getRange();t.start.column=t.end.column=0,t.end.row++,i.selection.setRange(t,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"joinlines",description:"Join lines",bindKey:l(null,null),exec:function(i){for(var r=i.selection.isBackwards(),t=r?i.selection.getSelectionLead():i.selection.getSelectionAnchor(),e=r?i.selection.getSelectionAnchor():i.selection.getSelectionLead(),r=i.session.doc.getLine(t.row).length,s=i.session.doc.getTextRange(i.selection.getRange()).replace(/\n\s*/," ").length,o=i.session.doc.getLine(t.row),c=t.row+1;c<=e.row+1;c++){var d=x.stringTrimLeft(x.stringTrimRight(i.session.doc.getLine(c)));o+=d=d.length!==0?" "+d:d}e.row+1<i.session.doc.getLength()-1&&(o+=i.session.doc.getNewLineCharacter()),i.clearSelection(),i.session.doc.replace(new a(t.row,0,e.row+2,0),o),0<s?(i.selection.moveCursorTo(t.row,t.column),i.selection.selectTo(t.row,t.column+s)):(r=i.session.doc.getLine(t.row).length>r?r+1:r,i.selection.moveCursorTo(t.row,r))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",description:"Invert selection",bindKey:l(null,null),exec:function(i){var t=i.session.doc.getLength()-1,e=i.session.doc.getLine(t).length,r=i.selection.rangeList.ranges,s=[];r.length<1&&(r=[i.selection.getRange()]);for(var o=0;o<r.length;o++)o!=r.length-1||r[o].end.row===t&&r[o].end.column===e||s.push(new a(r[o].end.row,r[o].end.column,t,e)),o===0?r[o].start.row===0&&r[o].start.column===0||s.push(new a(0,0,r[o].start.row,r[o].start.column)):s.push(new a(r[o-1].end.row,r[o-1].end.column,r[o].start.row,r[o].start.column));for(i.exitMultiSelectMode(),i.clearSelection(),o=0;o<s.length;o++)i.selection.addRange(s[o],!1)},readOnly:!0,scrollIntoView:"none"},{name:"addLineAfter",description:"Add new line after the current line",exec:function(i){i.selection.clearSelection(),i.navigateLineEnd(),i.insert(`
`)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"addLineBefore",description:"Add new line before the current line",exec:function(i){i.selection.clearSelection();var t=i.getCursorPosition();i.selection.moveTo(t.row-1,Number.MAX_VALUE),i.insert(`
`),t.row===0&&i.navigateUp()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"openCommandPallete",description:"Open command palette",bindKey:l("F1","F1"),exec:function(i){i.prompt({$type:"commands"})},readOnly:!0},{name:"modeSelect",description:"Change language mode...",bindKey:l(null,null),exec:function(i){i.prompt({$type:"modes"})},readOnly:!0}];for(var n=1;n<9;n++)m.commands.push({name:"foldToLevel"+n,description:"Fold To Level "+n,level:n,exec:function(i){i.session.foldToLevel(this.level)},scrollIntoView:"center",readOnly:!0})}),ace.define("ace/editor",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator","ace/clipboard"],function(C,m,A){function x(v,T,B){this.$toDestroy=[];var E=v.getContainerElement();this.container=E,this.renderer=v,this.id="editor"+ ++x.$uid,this.commands=new b(n.isMac?"mac":"win",I),typeof document=="object"&&(this.textInput=new i(v.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new t(this),new e(this)),this.keyBinding=new r(this),this.$search=new o().set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=l.delayedCall(function(){this._signal("input",{}),this.session&&!this.session.destroyed&&this.session.bgTokenizer.scheduleStart()}.bind(this)),this.on("change",function(_,P){P._$emitInputEvent.schedule(31)}),this.setSession(T||B&&B.session||new s("")),h.resetOptions(this),B&&this.setOptions(B),h._signal("editor",this)}var p=C("./lib/oop"),a=C("./lib/dom"),l=C("./lib/lang"),n=C("./lib/useragent"),i=C("./keyboard/textinput").TextInput,t=C("./mouse/mouse_handler").MouseHandler,e=C("./mouse/fold_handler").FoldHandler,r=C("./keyboard/keybinding").KeyBinding,s=C("./edit_session").EditSession,o=C("./search").Search,c=C("./range").Range,d=C("./lib/event_emitter").EventEmitter,b=C("./commands/command_manager").CommandManager,I=C("./commands/default_commands").commands,h=C("./config"),u=C("./token_iterator").TokenIterator,y=C("./clipboard"),w=(x.$uid=0,function(){p.implement(this,d),this.$initOperationListeners=function(){this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=l.delayedCall(this.endOperation.bind(this,!0)),this.on("change",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.docChanged=!0}.bind(this),!0),this.on("changeSelection",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.selectionChanged=!0}.bind(this),!0)},this.curOp=null,this.prevOp={},this.startOperation=function(v){if(this.curOp){if(!v||this.curOp.command)return;this.prevOp=this.curOp}v||(this.previousCommand=null,v={}),this.$opResetTimer.schedule(),this.curOp=this.session.curOp={command:v.command||{},args:v.args,scrollTop:this.renderer.scrollTop},this.curOp.selectionBefore=this.selection.toJSON()},this.endOperation=function(v){if(this.curOp&&this.session){if(v&&v.returnValue===!1||!this.session)return this.curOp=null;if((v!=1||!this.curOp.command||this.curOp.command.name!="mouse")&&(this._signal("beforeEndOperation"),this.curOp)){var v=this.curOp.command,T=v&&v.scrollIntoView;if(T){switch(T){case"center-animate":T="animate";case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var B=this.selection.getRange(),E=this.renderer.layerConfig;(B.start.row>=E.lastRow||B.end.row<=E.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}T=="animate"&&this.renderer.animateScrolling(this.curOp.scrollTop)}v=this.selection.toJSON(),this.curOp.selectionAfter=v,this.$lastSel=this.selection.toJSON(),this.session.getUndoManager().addSelection(v),this.prevOp=this.curOp,this.curOp=null}}},this.$mergeableCommands=["backspace","del","insertstring"],this.$historyTracker=function(v){var T,B,E,_;this.$mergeUndoDeltas&&(T=this.prevOp,B=this.$mergeableCommands,E=T.command&&v.command.name==T.command.name,v.command.name=="insertstring"?(_=v.args,this.mergeNextCommand===void 0&&(this.mergeNextCommand=!0),E=E&&this.mergeNextCommand&&(!/\s/.test(_)||/\s/.test(T.args)),this.mergeNextCommand=!0):E=E&&B.indexOf(v.command.name)!==-1,(E=this.$mergeUndoDeltas!="always"&&2e3<Date.now()-this.sequenceStartTime?!1:E)?this.session.mergeUndoDeltas=!0:B.indexOf(v.command.name)!==-1&&(this.sequenceStartTime=Date.now()))},this.setKeyboardHandler=function(v,T){var B;v&&typeof v=="string"&&v!="ace"?(this.$keybindingId=v,B=this,h.loadModule(["keybinding",v],function(E){B.$keybindingId==v&&B.keyBinding.setKeyboardHandler(E&&E.handler),T&&T()})):(this.$keybindingId=null,this.keyBinding.setKeyboardHandler(v),T&&T())},this.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},this.setSession=function(v){var T,B;this.session!=v&&(this.curOp&&this.endOperation(),this.curOp={},(T=this.session)&&(this.session.off("change",this.$onDocumentChange),this.session.off("changeMode",this.$onChangeMode),this.session.off("tokenizerUpdate",this.$onTokenizerUpdate),this.session.off("changeTabSize",this.$onChangeTabSize),this.session.off("changeWrapLimit",this.$onChangeWrapLimit),this.session.off("changeWrapMode",this.$onChangeWrapMode),this.session.off("changeFold",this.$onChangeFold),this.session.off("changeFrontMarker",this.$onChangeFrontMarker),this.session.off("changeBackMarker",this.$onChangeBackMarker),this.session.off("changeBreakpoint",this.$onChangeBreakpoint),this.session.off("changeAnnotation",this.$onChangeAnnotation),this.session.off("changeOverwrite",this.$onCursorChange),this.session.off("changeScrollTop",this.$onScrollTopChange),this.session.off("changeScrollLeft",this.$onScrollLeftChange),(B=this.session.getSelection()).off("changeCursor",this.$onCursorChange),B.off("changeSelection",this.$onSelectionChange)),(this.session=v)?(this.$onDocumentChange=this.onDocumentChange.bind(this),v.on("change",this.$onDocumentChange),this.renderer.setSession(v),this.$onChangeMode=this.onChangeMode.bind(this),v.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),v.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),v.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),v.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),v.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),v.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=v.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.onCursorChange(),this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(v)),this._signal("changeSession",{session:v,oldSession:T}),this.curOp=null,T&&T._signal("changeEditor",{oldEditor:this}),v&&v._signal("changeEditor",{editor:this}),v&&!v.destroyed&&v.bgTokenizer.scheduleStart())},this.getSession=function(){return this.session},this.setValue=function(v,T){return this.session.doc.setValue(v),T?T==1?this.navigateFileEnd():T==-1&&this.navigateFileStart():this.selectAll(),v},this.getValue=function(){return this.session.getValue()},this.getSelection=function(){return this.selection},this.resize=function(v){this.renderer.onResize(v)},this.setTheme=function(v,T){this.renderer.setTheme(v,T)},this.getTheme=function(){return this.renderer.getTheme()},this.setStyle=function(v){this.renderer.setStyle(v)},this.unsetStyle=function(v){this.renderer.unsetStyle(v)},this.getFontSize=function(){return this.getOption("fontSize")||a.computedStyle(this.container).fontSize},this.setFontSize=function(v){this.setOption("fontSize",v)},this.$highlightBrackets=function(){var v;this.$highlightPending||((v=this).$highlightPending=!0,setTimeout(function(){v.$highlightPending=!1;var T,B,E=v.session;E&&!E.destroyed&&(E.$bracketHighlight&&(E.$bracketHighlight.markerIds.forEach(function(_){E.removeMarker(_)}),E.$bracketHighlight=null),(T=!(T=E.getMatchingBracketRanges(v.getCursorPosition()))&&E.$mode.getMatching?E.$mode.getMatching(v.session):T)&&(B="ace_bracket",Array.isArray(T)?T.length==1&&(B="ace_error_bracket"):T=[T],T.length==2&&(c.comparePoints(T[0].end,T[1].start)==0?T=[c.fromPoints(T[0].start,T[1].end)]:c.comparePoints(T[0].start,T[1].end)==0&&(T=[c.fromPoints(T[1].start,T[0].end)])),E.$bracketHighlight={ranges:T,markerIds:T.map(function(_){return E.addMarker(_,B,"text")})}),v.getHighlightIndentGuides()&&v.renderer.$textLayer.$highlightIndentGuide())},50))},this.$highlightTags=function(){var v;this.$highlightTagPending||((v=this).$highlightTagPending=!0,setTimeout(function(){v.$highlightTagPending=!1;var T=v.session;if(T&&!T.destroyed){var B=v.getCursorPosition(),E=new u(v.session,B.row,B.column),_=E.getCurrentToken();if(_&&/\b(?:tag-open|tag-name)/.test(_.type)){if(_.type.indexOf("tag-open")===-1||(_=E.stepForward())){var P,H=_.value,z=_.value,K=0,Y=E.stepBackward();if(Y.value==="<")for(;Y=_,(_=E.stepForward())&&(_.type.indexOf("tag-name")!==-1?H===(z=_.value)&&(Y.value==="<"?K++:Y.value==="</"&&K--):H===z&&_.value==="/>"&&K--),_&&0<=K;);else{do if(_=Y,Y=E.stepBackward(),_){if(_.type.indexOf("tag-name")!==-1)H===_.value&&(Y.value==="<"?K++:Y.value==="</"&&K--);else if(_.value==="/>"){for(var R=0,Z=Y;Z;){if(Z.type.indexOf("tag-name")!==-1&&Z.value===H){K--;break}if(Z.value==="<")break;Z=E.stepBackward(),R++}for(var W=0;W<R;W++)E.stepForward()}}while(Y&&K<=0);E.stepForward()}_?(B=E.getCurrentTokenRow(),P=E.getCurrentTokenColumn(),B=new c(B,P,B,P+_.value.length),P=T.$backMarkers[T.$tagHighlight],T.$tagHighlight&&P!=null&&B.compareRange(P.range)!==0&&(T.removeMarker(T.$tagHighlight),T.$tagHighlight=null),T.$tagHighlight||(T.$tagHighlight=T.addMarker(B,"ace_bracket","text"))):(T.removeMarker(T.$tagHighlight),T.$tagHighlight=null)}}else T.removeMarker(T.$tagHighlight),T.$tagHighlight=null}},50))},this.focus=function(){this.textInput.focus()},this.isFocused=function(){return this.textInput.isFocused()},this.blur=function(){this.textInput.blur()},this.onFocus=function(v){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",v))},this.onBlur=function(v){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",v))},this.$cursorChange=function(){this.renderer.updateCursor(),this.$highlightBrackets(),this.$highlightTags(),this.$updateHighlightActiveLine()},this.onDocumentChange=function(v){var T=this.session.$useWrapMode,B=v.start.row==v.end.row?v.end.row:1/0;this.renderer.updateLines(v.start.row,B,T),this._signal("change",v),this.$cursorChange()},this.onTokenizerUpdate=function(v){v=v.data,this.renderer.updateLines(v.first,v.last)},this.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},this.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},this.onCursorChange=function(){this.$cursorChange(),this._signal("changeSelection")},this.$updateHighlightActiveLine=function(){var v,T,B=this.getSession();this.$highlightActiveLine&&(this.$selectionStyle=="line"&&this.selection.isMultiLine()||(v=this.getCursorPosition()),this.renderer.theme&&this.renderer.theme.$selectionColorConflict&&!this.selection.isEmpty()&&(v=!1),!this.renderer.$maxLines||this.session.getLength()!==1||1<this.renderer.$minLines||(v=!1)),B.$highlightLineMarker&&!v?(B.removeMarker(B.$highlightLineMarker.id),B.$highlightLineMarker=null):!B.$highlightLineMarker&&v?((T=new c(v.row,v.column,v.row,1/0)).id=B.addMarker(T,"ace_active-line","screenLine"),B.$highlightLineMarker=T):v&&(B.$highlightLineMarker.start.row=v.row,B.$highlightLineMarker.end.row=v.row,B.$highlightLineMarker.start.column=v.column,B._signal("changeBackMarker"))},this.onSelectionChange=function(v){var T,B,E=this.session,E=(E.$selectionMarker&&E.removeMarker(E.$selectionMarker),E.$selectionMarker=null,this.selection.isEmpty()?this.$updateHighlightActiveLine():(T=this.selection.getRange(),B=this.getSelectionStyle(),E.$selectionMarker=E.addMarker(T,"ace_selection",B)),this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp());this.session.highlight(E),this._signal("changeSelection")},this.$getSelectionHighLightRegexp=function(){var v=this.session,T=this.getSelectionRange();if(!T.isEmpty()&&!T.isMultiLine()){var B=T.start.column,E=T.end.column,v=v.getLine(T.start.row),T=v.substring(B,E);if(!(5e3<T.length)&&/[\w\d]/.test(T)&&(T=this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:T}),v=v.substring(B-1,E+1),T.test(v)))return T}},this.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},this.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},this.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},this.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},this.onChangeMode=function(v){this.renderer.updateText(),this._emit("changeMode",v)},this.onChangeWrapLimit=function(){this.renderer.updateFull()},this.onChangeWrapMode=function(){this.renderer.onResize(!0)},this.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},this.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},this.getCopyText=function(){var v=this.getSelectedText(),T=this.session.doc.getNewLineCharacter(),B=!1;if(!v&&this.$copyWithEmptySelection)for(var B=!0,E=this.selection.getAllRanges(),_=0;_<E.length;_++){var P=E[_];_&&E[_-1].start.row==P.start.row||(v+=this.session.getLine(P.start.row)+T)}var H={text:v};return this._signal("copy",H),y.lineMode=!!B&&H.text,H.text},this.onCopy=function(){this.commands.exec("copy",this)},this.onCut=function(){this.commands.exec("cut",this)},this.onPaste=function(v,T){this.commands.exec("paste",this,{text:v,event:T})},this.$handlePaste=function(B){this._signal("paste",B=typeof B=="string"?{text:B}:B);var T=B.text,B=T===y.lineMode,E=this.session;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)B?E.insert({row:this.selection.lead.row,column:0},T):this.insert(T);else if(B)this.selection.rangeList.ranges.forEach(function(K){E.insert({row:K.start.row,column:0},T)});else{var _=T.split(/\r\n|\r|\n/),P=this.selection.rangeList.ranges,B=!(_.length!=2||_[0]&&_[1]);if(_.length!=P.length||B)return this.commands.exec("insertstring",this,T);for(var H=P.length;H--;){var z=P[H];z.isEmpty()||E.remove(z),E.insert(z.start,_[H])}}},this.execCommand=function(v,T){return this.commands.exec(v,this,T)},this.insert=function(v,z){var B,E=this.session,_=E.getMode(),P=this.getCursorPosition(),H=(!this.getBehavioursEnabled()||z||(B=_.transformAction(E.getState(P.row),"insertion",this,E,v))&&(v===B.text||this.inVirtualSelectionMode||(this.session.mergeUndoDeltas=!1,this.mergeNextCommand=!1),v=B.text),v=="	"&&(v=this.session.getTabString()),this.selection.isEmpty()?this.session.getOverwrite()&&v.indexOf(`
`)==-1&&((H=new c.fromPoints(P,P)).end.column+=v.length,this.session.remove(H)):(H=this.getSelectionRange(),P=this.session.remove(H),this.clearSelection()),v!=`
`&&v!=`\r
`||(K=E.getLine(P.row),P.column>K.search(/\S|$/)&&(z=K.substr(P.column).search(/\S|$/),E.doc.removeInLine(P.row,P.column,P.column+z))),this.clearSelection(),P.column),z=E.getState(P.row),K=E.getLine(P.row),Y=_.checkOutdent(z,K,v);E.insert(P,v),B&&B.selection&&(B.selection.length==2?this.selection.setSelectionRange(new c(P.row,H+B.selection[0],P.row,H+B.selection[1])):this.selection.setSelectionRange(new c(P.row+B.selection[0],B.selection[1],P.row+B.selection[2],B.selection[3]))),this.$enableAutoIndent&&(E.getDocument().isNewLine(v)&&(H=_.getNextLineIndent(z,K.slice(0,P.column),E.getTabString()),E.insert({row:P.row+1,column:0},H)),Y&&_.autoOutdent(z,E,P.row))},this.autoIndent=function(){for(var v,T,B,E,_,P=this.session,H=P.getMode(),z=(B=this.selection.isEmpty()?(T=0,P.doc.getLength()-1):(T=(v=this.getSelectionRange()).start.row,v.end.row),""),K="",Y=P.getTabString(),R=T;R<=B;R++)0<R&&(z=P.getState(R-1),E=P.getLine(R-1),K=H.getNextLineIndent(z,E,Y)),E=P.getLine(R),K!==(_=H.$getIndent(E))&&(0<_.length&&(_=new c(R,0,R,_.length),P.remove(_)),0<K.length&&P.insert({row:R,column:0},K)),H.autoOutdent(z,P,R)},this.onTextInput=function(v,T){if(!T)return this.keyBinding.onTextInput(v);this.startOperation({command:{name:"insertstring"}}),v=this.applyComposition.bind(this,v,T),this.selection.rangeCount?this.forEachSelection(v):v(),this.endOperation()},this.applyComposition=function(v,T){var B;(T.extendLeft||T.extendRight)&&((B=this.selection.getRange()).start.column-=T.extendLeft,B.end.column+=T.extendRight,B.start.column<0&&(B.start.row--,B.start.column+=this.session.getLine(B.start.row).length+1),this.selection.setRange(B),v||B.isEmpty()||this.remove()),!v&&this.selection.isEmpty()||this.insert(v,!0),(T.restoreStart||T.restoreEnd)&&((B=this.selection.getRange()).start.column-=T.restoreStart,B.end.column-=T.restoreEnd,this.selection.setRange(B))},this.onCommandKey=function(v,T,B){return this.keyBinding.onCommandKey(v,T,B)},this.setOverwrite=function(v){this.session.setOverwrite(v)},this.getOverwrite=function(){return this.session.getOverwrite()},this.toggleOverwrite=function(){this.session.toggleOverwrite()},this.setScrollSpeed=function(v){this.setOption("scrollSpeed",v)},this.getScrollSpeed=function(){return this.getOption("scrollSpeed")},this.setDragDelay=function(v){this.setOption("dragDelay",v)},this.getDragDelay=function(){return this.getOption("dragDelay")},this.setSelectionStyle=function(v){this.setOption("selectionStyle",v)},this.getSelectionStyle=function(){return this.getOption("selectionStyle")},this.setHighlightActiveLine=function(v){this.setOption("highlightActiveLine",v)},this.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},this.setHighlightGutterLine=function(v){this.setOption("highlightGutterLine",v)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.setHighlightSelectedWord=function(v){this.setOption("highlightSelectedWord",v)},this.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},this.setAnimatedScroll=function(v){this.renderer.setAnimatedScroll(v)},this.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},this.setShowInvisibles=function(v){this.renderer.setShowInvisibles(v)},this.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},this.setDisplayIndentGuides=function(v){this.renderer.setDisplayIndentGuides(v)},this.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},this.setHighlightIndentGuides=function(v){this.renderer.setHighlightIndentGuides(v)},this.getHighlightIndentGuides=function(){return this.renderer.getHighlightIndentGuides()},this.setShowPrintMargin=function(v){this.renderer.setShowPrintMargin(v)},this.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},this.setPrintMarginColumn=function(v){this.renderer.setPrintMarginColumn(v)},this.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},this.setReadOnly=function(v){this.setOption("readOnly",v)},this.getReadOnly=function(){return this.getOption("readOnly")},this.setBehavioursEnabled=function(v){this.setOption("behavioursEnabled",v)},this.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},this.setWrapBehavioursEnabled=function(v){this.setOption("wrapBehavioursEnabled",v)},this.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},this.setShowFoldWidgets=function(v){this.setOption("showFoldWidgets",v)},this.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},this.setFadeFoldWidgets=function(v){this.setOption("fadeFoldWidgets",v)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.remove=function(_){this.selection.isEmpty()&&(_=="left"?this.selection.selectLeft():this.selection.selectRight());var T,B,E,_=this.getSelectionRange();this.getBehavioursEnabled()&&(B=(T=this.session).getState(_.start.row),B=T.getMode().transformAction(B,"deletion",this,T,_),_.end.column===0&&(E=T.getTextRange(_))[E.length-1]==`
`&&(E=T.getLine(_.end.row),/^\s+$/.test(E)&&(_.end.column=E.length)),B&&(_=B)),this.session.remove(_),this.clearSelection()},this.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.selection.isEmpty()&&this.selection.selectLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var v=this.getSelectionRange();v.start.column==v.end.column&&v.start.row==v.end.row&&(v.end.column=0,v.end.row++),this.session.remove(v),this.clearSelection()},this.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var v=this.getCursorPosition();this.insert(`
`),this.moveCursorToPosition(v)},this.transposeLetters=function(){var v,T,B,E;!this.selection.isEmpty()||(T=(v=this.getCursorPosition()).column)!==0&&(E=T<(E=this.session.getLine(v.row)).length?(B=E.charAt(T)+E.charAt(T-1),new c(v.row,T-1,v.row,T+1)):(B=E.charAt(T-1)+E.charAt(T-2),new c(v.row,T-2,v.row,T)),this.session.replace(E,B),this.session.selection.moveToPosition(E.end))},this.toLowerCase=function(){var v=this.getSelectionRange(),T=(this.selection.isEmpty()&&this.selection.selectWord(),this.getSelectionRange()),B=this.session.getTextRange(T);this.session.replace(T,B.toLowerCase()),this.selection.setSelectionRange(v)},this.toUpperCase=function(){var v=this.getSelectionRange(),T=(this.selection.isEmpty()&&this.selection.selectWord(),this.getSelectionRange()),B=this.session.getTextRange(T);this.session.replace(T,B.toUpperCase()),this.selection.setSelectionRange(v)},this.indent=function(){var v=this.session,T=this.getSelectionRange();if(!(T.start.row<T.end.row)){if(T.start.column<T.end.column){var B,P=v.getTextRange(T);if(!/^\s+$/.test(P))return B=this.$getSelectedRows(),void v.indentRows(B.first,B.last,"	")}var E=v.getLine(T.start.row),P=T.start,_=v.getTabSize(),P=v.documentToScreenColumn(P.row,P.column);if(this.session.getUseSoftTabs())var H=_-P%_,z=l.stringRepeat(" ",H);else{for(H=P%_;E[T.start.column-1]==" "&&H;)T.start.column--,H--;this.selection.setSelectionRange(T),z="	"}return this.insert(z)}B=this.$getSelectedRows(),v.indentRows(B.first,B.last,"	")},this.blockIndent=function(){var v=this.$getSelectedRows();this.session.indentRows(v.first,v.last,"	")},this.blockOutdent=function(){var v=this.session.getSelection();this.session.outdentRows(v.getRange())},this.sortLines=function(){for(var v=this.$getSelectedRows(),T=this.session,B=[],E=v.first;E<=v.last;E++)B.push(T.getLine(E));B.sort(function(H,z){return H.toLowerCase()<z.toLowerCase()?-1:H.toLowerCase()>z.toLowerCase()?1:0});for(var _=new c(0,0,0,0),E=v.first;E<=v.last;E++){var P=T.getLine(E);_.start.row=E,_.end.row=E,_.end.column=P.length,T.replace(_,B[E-v.first])}},this.toggleCommentLines=function(){var v=this.session.getState(this.getCursorPosition().row),T=this.$getSelectedRows();this.session.getMode().toggleCommentLines(v,this.session,T.first,T.last)},this.toggleBlockComment=function(){var v=this.getCursorPosition(),T=this.session.getState(v.row),B=this.getSelectionRange();this.session.getMode().toggleBlockComment(T,this.session,B,v)},this.getNumberAt=function(v,T){for(var B=/[\-]?[0-9]+(?:\.[0-9]+)?/g,E=(B.lastIndex=0,this.session.getLine(v));B.lastIndex<T;){var _=B.exec(E);if(_.index<=T&&_.index+_[0].length>=T)return{value:_[0],start:_.index,end:_.index+_[0].length}}return null},this.modifyNumber=function(v){var T,B,E,_=this.selection.getCursor().row,P=this.selection.getCursor().column,H=new c(_,P-1,_,P),H=this.session.getTextRange(H);!isNaN(parseFloat(H))&&isFinite(H)?(H=this.getNumberAt(_,P))&&(E=0<=H.value.indexOf(".")?H.start+H.value.indexOf(".")+1:H.end,T=H.start+H.value.length-E,B=parseFloat(H.value),B*=Math.pow(10,T),E!==H.end&&P<E?v*=Math.pow(10,H.end-P-1):v*=Math.pow(10,H.end-P),E=(B=(B+=v)/Math.pow(10,T)).toFixed(T),v=new c(_,H.start,_,H.end),this.session.replace(v,E),this.moveCursorTo(_,Math.max(H.start+1,P+E.length-H.value.length))):this.toggleWord()},this.$toggleWordPairs=[["first","last"],["true","false"],["yes","no"],["width","height"],["top","bottom"],["right","left"],["on","off"],["x","y"],["get","set"],["max","min"],["horizontal","vertical"],["show","hide"],["add","remove"],["up","down"],["before","after"],["even","odd"],["in","out"],["inside","outside"],["next","previous"],["increase","decrease"],["attach","detach"],["&&","||"],["==","!="]],this.toggleWord=function(){for(var v,T=this.selection.getCursor().row,B=this.selection.getCursor().column,E=(this.selection.selectWord(),this.getSelectedText()),_=this.selection.getWordRange().start.column,P=E.replace(/([a-z]+|[A-Z]+)(?=[A-Z_]|$)/g,"$1 ").split(/\s/),H=B-_-1,z=(H<0&&(H=0),0),K=this,Y=(E.match(/[A-Za-z0-9_]+/)&&P.forEach(function($,F){v=z+$.length,z<=H&&H<=v&&(E=$,K.selection.clearSelection(),K.moveCursorTo(T,z+_),K.selection.selectTo(T,v+_)),z=v}),this.$toggleWordPairs),R=0;R<Y.length;R++)for(var Z=Y[R],W=0;W<=1;W++){var f=+!W,S=E.match(new RegExp("^\\s?_?("+l.escapeRegExp(Z[W])+")\\s?$","i"));S&&E.match(new RegExp("([_]|^|\\s)("+l.escapeRegExp(S[1])+")($|\\s)","g"))&&(S=E.replace(new RegExp(l.escapeRegExp(Z[W]),"i"),function($){var F=Z[f];return $.toUpperCase()==$?F=F.toUpperCase():$.charAt(0).toUpperCase()==$.charAt(0)&&(F=F.substr(0,0)+Z[f].charAt(0).toUpperCase()+F.substr(1)),F}),this.insert(S))}},this.removeLines=function(){var v=this.$getSelectedRows();this.session.removeFullLines(v.first,v.last),this.clearSelection()},this.duplicateSelection=function(){var v,T=this.selection,B=this.session,E=T.getRange(),_=T.isBackwards();E.isEmpty()?(v=E.start.row,B.duplicateLines(v,v)):(v=_?E.start:E.end,B=B.insert(v,B.getTextRange(E),!1),E.start=v,E.end=B,T.setSelectionRange(E,_))},this.moveLinesDown=function(){this.$moveLines(1,!1)},this.moveLinesUp=function(){this.$moveLines(-1,!1)},this.moveText=function(v,T,B){return this.session.moveText(v,T,B)},this.copyLinesUp=function(){this.$moveLines(-1,!0)},this.copyLinesDown=function(){this.$moveLines(1,!0)},this.$moveLines=function(v,T){var B=this.selection;if(!B.inMultiSelectMode||this.inVirtualSelectionMode){var E=B.toOrientedRange(),_=this.$getSelectedRows(E),P=this.session.$moveLines(_.first,_.last,T?0:v);E.moveBy(P=T&&v==-1?0:P,0),B.fromOrientedRange(E)}else{for(var H=B.rangeList.ranges,z=(B.rangeList.detach(this.session),this.inVirtualSelectionMode=!0,0),K=0,Y=H.length,R=0;R<Y;R++){for(var Z=R,W=(H[R].moveBy(z,0),(_=this.$getSelectedRows(H[R])).first),f=_.last;++R<Y;){K&&H[R].moveBy(K,0);var S=this.$getSelectedRows(H[R]);if(T&&S.first!=f||!T&&S.first>f+1)break;f=S.last}for(R--,z=this.session.$moveLines(W,f,T?0:v),T&&v==-1&&(Z=R+1);Z<=R;)H[Z].moveBy(z,0),Z++;K+=z=T?z:0}B.fromOrientedRange(B.ranges[0]),B.rangeList.attach(this.session),this.inVirtualSelectionMode=!1}},this.$getSelectedRows=function(v){return v=(v||this.getSelectionRange()).collapseRows(),{first:this.session.getRowFoldStart(v.start.row),last:this.session.getRowFoldEnd(v.end.row)}},this.onCompositionStart=function(v){this.renderer.showComposition(v)},this.onCompositionUpdate=function(v){this.renderer.setCompositionText(v)},this.onCompositionEnd=function(){this.renderer.hideComposition()},this.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},this.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},this.isRowVisible=function(v){return v>=this.getFirstVisibleRow()&&v<=this.getLastVisibleRow()},this.isRowFullyVisible=function(v){return v>=this.renderer.getFirstFullyVisibleRow()&&v<=this.renderer.getLastFullyVisibleRow()},this.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},this.$moveByPage=function(P,T){var B=this.renderer,E=this.renderer.layerConfig,_=P*Math.floor(E.height/E.lineHeight),P=(T===!0?this.selection.$moveSelection(function(){this.moveCursorBy(_,0)}):T===!1&&(this.selection.moveCursorBy(_,0),this.selection.clearSelection()),B.scrollTop);B.scrollBy(0,_*E.lineHeight),T!=null&&B.scrollCursorIntoView(null,.5),B.animateScrolling(P)},this.selectPageDown=function(){this.$moveByPage(1,!0)},this.selectPageUp=function(){this.$moveByPage(-1,!0)},this.gotoPageDown=function(){this.$moveByPage(1,!1)},this.gotoPageUp=function(){this.$moveByPage(-1,!1)},this.scrollPageDown=function(){this.$moveByPage(1)},this.scrollPageUp=function(){this.$moveByPage(-1)},this.scrollToRow=function(v){this.renderer.scrollToRow(v)},this.scrollToLine=function(v,T,B,E){this.renderer.scrollToLine(v,T,B,E)},this.centerSelection=function(){var v=this.getSelectionRange(),v={row:Math.floor(v.start.row+(v.end.row-v.start.row)/2),column:Math.floor(v.start.column+(v.end.column-v.start.column)/2)};this.renderer.alignCursor(v,.5)},this.getCursorPosition=function(){return this.selection.getCursor()},this.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},this.getSelectionRange=function(){return this.selection.getRange()},this.selectAll=function(){this.selection.selectAll()},this.clearSelection=function(){this.selection.clearSelection()},this.moveCursorTo=function(v,T){this.selection.moveCursorTo(v,T)},this.moveCursorToPosition=function(v){this.selection.moveCursorToPosition(v)},this.jumpToMatching=function(v,T){var B=this.getCursorPosition(),E=new u(this.session,B.row,B.column),_=E.getCurrentToken(),P=_||E.stepForward();if(P){var H,z,K,Y=!1,R={},Z=B.column-P.start,W={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do if(P.value.match(/[{}()\[\]]/g)){for(;Z<P.value.length&&!Y;Z++)if(W[P.value[Z]])switch(z=W[P.value[Z]]+"."+P.type.replace("rparen","lparen"),isNaN(R[z])&&(R[z]=0),P.value[Z]){case"(":case"[":case"{":R[z]++;break;case")":case"]":case"}":R[z]--,R[z]===-1&&(H="bracket",Y=!0)}}else P.type.indexOf("tag-name")!==-1&&(isNaN(R[P.value])&&(R[P.value]=0),_.value==="<"?R[P.value]++:_.value==="</"&&R[P.value]--,R[P.value]===-1&&(H="tag",Y=!0));while(Y||(_=P,P=E.stepForward(),Z=0),P&&!Y);if(H){if(H==="bracket")(f=this.session.getBracketRange(B))||(K=(f=new c(E.getCurrentTokenRow(),E.getCurrentTokenColumn()+Z-1,E.getCurrentTokenRow(),E.getCurrentTokenColumn()+Z-1)).start,(T||K.row===B.row&&Math.abs(K.column-B.column)<2)&&(f=this.session.getBracketRange(K)));else if(H==="tag"){if(!P||P.type.indexOf("tag-name")===-1)return;var f,S=P.value;if((f=new c(E.getCurrentTokenRow(),E.getCurrentTokenColumn()-2,E.getCurrentTokenRow(),E.getCurrentTokenColumn()-2)).compare(B.row,B.column)===0)for(Y=!1;P=_,(_=E.stepBackward())&&(_.type.indexOf("tag-close")!==-1&&f.setEnd(E.getCurrentTokenRow(),E.getCurrentTokenColumn()+1),P.value===S&&P.type.indexOf("tag-name")!==-1&&(_.value==="<"?R[S]++:_.value==="</"&&R[S]--,R[S]===0&&(Y=!0))),_&&!Y;);P&&P.type.indexOf("tag-name")&&(K=f.start).row==B.row&&Math.abs(K.column-B.column)<2&&(K=f.end)}(K=f&&f.cursor||K)&&(v?f&&T?this.selection.setRange(f):f&&f.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(K.row,K.column):this.selection.moveTo(K.row,K.column))}}},this.gotoLine=function(v,T,B){this.selection.clearSelection(),this.session.unfold({row:v-1,column:T||0}),this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(v-1,T||0),this.isRowFullyVisible(v-1)||this.scrollToLine(v-1,!0,B)},this.navigateTo=function(v,T){this.selection.moveTo(v,T)},this.navigateUp=function(v){var T;if(this.selection.isMultiLine()&&!this.selection.isBackwards())return T=this.selection.anchor.getPosition(),this.moveCursorToPosition(T);this.selection.clearSelection(),this.selection.moveCursorBy(-v||-1,0)},this.navigateDown=function(v){var T;if(this.selection.isMultiLine()&&this.selection.isBackwards())return T=this.selection.anchor.getPosition(),this.moveCursorToPosition(T);this.selection.clearSelection(),this.selection.moveCursorBy(v||1,0)},this.navigateLeft=function(v){if(this.selection.isEmpty())for(v=v||1;v--;)this.selection.moveCursorLeft();else{var T=this.getSelectionRange().start;this.moveCursorToPosition(T)}this.clearSelection()},this.navigateRight=function(v){if(this.selection.isEmpty())for(v=v||1;v--;)this.selection.moveCursorRight();else{var T=this.getSelectionRange().end;this.moveCursorToPosition(T)}this.clearSelection()},this.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},this.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},this.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},this.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},this.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},this.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},this.replace=function(v,B){B&&this.$search.set(B);var B=this.$search.find(this.session),E=0;return B&&(this.$tryReplace(B,v)&&(E=1),this.selection.setSelectionRange(B),this.renderer.scrollSelectionIntoView(B.start,B.end)),E},this.replaceAll=function(v,T){T&&this.$search.set(T);var B=this.$search.findAll(this.session),E=0;if(B.length){T=this.getSelectionRange(),this.selection.moveTo(0,0);for(var _=B.length-1;0<=_;--_)this.$tryReplace(B[_],v)&&E++;this.selection.setSelectionRange(T)}return E},this.$tryReplace=function(v,T){var B=this.session.getTextRange(v);return(T=this.$search.replace(B,T))!==null?(v.end=this.session.replace(v,T),v):null},this.getLastSearchOptions=function(){return this.$search.getOptions()},this.find=function(_,T,B){T=T||{},typeof _=="string"||_ instanceof RegExp?T.needle=_:typeof _=="object"&&p.mixin(T,_);var E=this.selection.getRange(),_=(T.needle==null&&((_=this.session.getTextRange(E)||this.$search.$options.needle)||(E=this.session.getWordRange(E.start.row,E.start.column),_=this.session.getTextRange(E)),this.$search.set({needle:_})),this.$search.set(T),T.start||this.$search.set({start:E}),this.$search.find(this.session));return T.preventScroll?_:_?(this.revealRange(_,B),_):(T.backwards?E.start=E.end:E.end=E.start,void this.selection.setRange(E))},this.findNext=function(v,T){this.find({skipCurrent:!0,backwards:!1},v,T)},this.findPrevious=function(v,T){this.find(v,{skipCurrent:!0,backwards:!0},T)},this.revealRange=function(v,T){this.session.unfold(v),this.selection.setSelectionRange(v);var B=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(v.start,v.end,.5),T!==!1&&this.renderer.animateScrolling(B)},this.undo=function(){this.session.getUndoManager().undo(this.session),this.renderer.scrollCursorIntoView(null,.5)},this.redo=function(){this.session.getUndoManager().redo(this.session),this.renderer.scrollCursorIntoView(null,.5)},this.destroy=function(){this.$toDestroy&&(this.$toDestroy.forEach(function(v){v.destroy()}),this.$toDestroy=null),this.$mouseHandler&&this.$mouseHandler.destroy(),this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy(),this._$emitInputEvent&&this._$emitInputEvent.cancel(),this.removeAllListeners()},this.setAutoScrollEditorIntoView=function(v){var T,B,E,_,P,H,z;v&&(E=!1,(B=this).$scrollAnchor||(this.$scrollAnchor=document.createElement("div")),(_=this.$scrollAnchor).style.cssText="position:absolute",this.container.insertBefore(_,this.container.firstChild),P=this.on("changeSelection",function(){E=!0}),H=this.renderer.on("beforeRender",function(){E&&(T=B.renderer.container.getBoundingClientRect())}),z=this.renderer.on("afterRender",function(){var K,Y,R;E&&T&&(B.isFocused()||B.searchBox&&B.searchBox.isFocused())&&(K=(Y=B.renderer).$cursorLayer.$pixelPos,Y=Y.layerConfig,R=K.top-Y.offset,(E=0<=K.top&&R+T.top<0||!(K.top<Y.height&&K.top+T.top+Y.lineHeight>window.innerHeight)&&null)!=null&&(_.style.top=R+"px",_.style.left=K.left+"px",_.style.height=Y.lineHeight+"px",_.scrollIntoView(E)),E=T=null)}),this.setAutoScrollEditorIntoView=function(K){K||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",P),this.renderer.off("afterRender",z),this.renderer.off("beforeRender",H))})},this.$resetCursorStyle=function(){var v=this.$cursorStyle||"ace",T=this.renderer.$cursorLayer;T&&(T.setSmoothBlinking(/smooth/.test(v)),T.isBlinking=!this.$readOnly&&v!="wide",a.setCssClass(T.element,"ace_slim-cursors",/slim/.test(v)))},this.prompt=function(v,T,B){var E=this;h.loadModule("./ext/prompt",function(_){_.prompt(E,v,T,B)})}}.call(x.prototype),h.defineOptions(x.prototype,"editor",{selectionStyle:{set:function(v){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:v})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(v){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(v){this.textInput.setReadOnly(v),this.$resetCursorStyle()},initialValue:!1},copyWithEmptySelection:{set:function(v){this.textInput.setCopyWithEmptySelection(v)},initialValue:!1},cursorStyle:{set:function(v){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},enableAutoIndent:{initialValue:!0},autoScrollEditorIntoView:{set:function(v){this.setAutoScrollEditorIntoView(v)}},keyboardHandler:{set:function(v){this.setKeyboardHandler(v)},get:function(){return this.$keybindingId},handlesSet:!0},value:{set:function(v){this.session.setValue(v)},get:function(){return this.getValue()},handlesSet:!0,hidden:!0},session:{set:function(v){this.setSession(v)},get:function(){return this.session},handlesSet:!0,hidden:!0},showLineNumbers:{set:function(v){this.renderer.$gutterLayer.setShowLineNumbers(v),this.renderer.$loop.schedule(this.renderer.CHANGE_GUTTER),v&&this.$relativeLineNumbers?w.attach(this):w.detach(this)},initialValue:!0},relativeLineNumbers:{set:function(v){this.$showLineNumbers&&v?w.attach(this):w.detach(this)}},placeholder:{set:function(v){this.$updatePlaceholder||(this.$updatePlaceholder=function(){var T=this.session&&(this.renderer.$composition||this.getValue());T&&this.renderer.placeholderNode?(this.renderer.off("afterRender",this.$updatePlaceholder),a.removeCssClass(this.container,"ace_hasPlaceholder"),this.renderer.placeholderNode.remove(),this.renderer.placeholderNode=null):T||this.renderer.placeholderNode?!T&&this.renderer.placeholderNode&&(this.renderer.placeholderNode.textContent=this.$placeholder||""):(this.renderer.on("afterRender",this.$updatePlaceholder),a.addCssClass(this.container,"ace_hasPlaceholder"),(T=a.createElement("div")).className="ace_placeholder",T.textContent=this.$placeholder||"",this.renderer.placeholderNode=T,this.renderer.content.appendChild(this.renderer.placeholderNode))}.bind(this),this.on("input",this.$updatePlaceholder)),this.$updatePlaceholder()}},hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",displayIndentGuides:"renderer",highlightIndentGuides:"renderer",showGutter:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",hasCssTransforms:"renderer",maxPixelHeight:"renderer",useTextareaForIME:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimeout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",navigateWithinSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"}),{getText:function(v,T){return(Math.abs(v.selection.lead.row-T)||T+1+(T<9?"\xB7":""))+""},getWidth:function(v,T,B){return Math.max(T.toString().length,(B.lastRow+1).toString().length,2)*B.characterWidth},update:function(v,T){T.renderer.$loop.schedule(T.renderer.CHANGE_GUTTER)},attach:function(v){v.renderer.$gutterLayer.$renderer=this,v.on("changeSelection",this.update),this.update(null,v)},detach:function(v){v.renderer.$gutterLayer.$renderer==this&&(v.renderer.$gutterLayer.$renderer=null),v.off("changeSelection",this.update),this.update(null,v)}});m.Editor=x}),ace.define("ace/undomanager",["require","exports","module","ace/range"],function(C,m,A){function x(){this.$maxRev=0,this.$fromUndo=!1,this.$undoDepth=1/0,this.reset()}(function(){this.addSession=function(o){this.$session=o},this.add=function(o,c,d){this.$fromUndo||o!=this.$lastDelta&&(this.$keepRedoStack||(this.$redoStack.length=0),c!==!1&&this.lastDeltas||(this.lastDeltas=[],(c=this.$undoStack.length)>this.$undoDepth-1&&this.$undoStack.splice(0,c-this.$undoDepth+1),this.$undoStack.push(this.lastDeltas),o.id=this.$rev=++this.$maxRev),o.action!="remove"&&o.action!="insert"||(this.$lastDelta=o),this.lastDeltas.push(o))},this.addSelection=function(o,c){this.selections.push({value:o,rev:c||this.$rev})},this.startNewGroup=function(){return this.lastDeltas=null,this.$rev},this.markIgnored=function(o,c){c==null&&(c=this.$rev+1);for(var d=this.$undoStack,b=d.length;b--;){var I=d[b][0];if(I.id<=o)break;I.id<c&&(I.ignore=!0)}this.lastDeltas=null},this.getSelection=function(o,c){for(var d=this.selections,b=d.length;b--;){var I=d[b];if(I.rev<o)return I=c?d[b+1]:I}},this.getRevision=function(){return this.$rev},this.getDeltas=function(o,c){c==null&&(c=this.$rev+1);for(var d=this.$undoStack,b=null,I=0,h=d.length;h--;){var u=d[h][0];if(u.id<c&&!b&&(b=h+1),u.id<=o){I=h+1;break}}return d.slice(I,b)},this.getChangedRanges=function(o,c){c==null&&this.$rev},this.getChangedLines=function(o,c){c==null&&this.$rev},this.undo=function(o,c){this.lastDeltas=null;var d,b=this.$undoStack;if(function(I,h){for(var u=h;u--;){var y=I[u];if(y&&!y[0].ignore){for(;u<h-1;){var w=function(v,T){for(var B=v.length;B--;)for(var E=0;E<T.length;E++)if(!t(v[B],T[E])){for(;B<v.length;){for(;E--;)t(T[E],v[B]);E=T.length,B++}return[v,T]}return v.selectionBefore=T.selectionBefore=v.selectionAfter=T.selectionAfter=null,[T,v]}(I[u],I[u+1]);I[u]=w[0],I[u+1]=w[1],u++}return 1}}}(b,b.length))return o=o||this.$session,this.$redoStackBaseRev!==this.$rev&&this.$redoStack.length&&(this.$redoStack=[]),this.$fromUndo=!0,d=null,(b=b.pop())&&(d=o.undoChanges(b,c),this.$redoStack.push(b),this.$syncRev()),this.$fromUndo=!1,d},this.redo=function(o,c){if(this.lastDeltas=null,o=o||this.$session,this.$fromUndo=!0,this.$redoStackBaseRev!=this.$rev){for(var _=this.getDeltas(this.$redoStackBaseRev,this.$rev+1),d=this.$redoStack,b=_,I=0;I<b.length;I++)for(var h=b[I],u=0;u<h.length;u++){y=void 0,w=void 0,v=void 0,T=void 0,B=void 0,E=void 0;var y=d,w=h[u];w=function(z){return{start:l(z.start),end:l(z.end),action:z.action,lines:z.lines.slice()}}(w);for(var v=y.length;v--;){for(var T=y[v],B=0;B<T.length;B++){var E=function(z,K){var Y,R,Z=z.action=="insert",W=K.action=="insert";if(Z&&W)a(z.start,K.start)<0?e(K,z,1):e(z,K,1);else if(Z&&!W)0<=a(z.start,K.end)?e(z,K,-1):(a(z.start,K.start)<=0||e(z,p.fromPoints(K.start,z.start),-1),e(K,z,1));else if(!Z&&W)0<=a(K.start,z.end)?e(K,z,-1):(a(K.start,z.start)<=0||e(K,p.fromPoints(z.start,K.start),-1),e(z,K,1));else if(!Z&&!W)if(0<=a(K.start,z.end))e(K,z,-1);else{if(!(a(K.end,z.start)<=0))return a(z.start,K.start)<0&&(z=s(Y=z,K.start)),0<a(z.end,K.end)&&(R=s(z,K.end)),r(K.end,z.start,z.end,-1),R&&!Y&&(z.lines=R.lines,z.start=R.start,z.end=R.end,R=z),[K,Y,R].filter(Boolean);e(z,K,-1)}return[K,z]}(T[B],w);w=E[0],E.length!=2&&(E[2]?(T.splice(B+1,1,E[1],E[2]),B++):E[1]||(T.splice(B,1),B--))}T.length||y.splice(v,1)}}this.$redoStackBaseRev=this.$rev,this.$redoStack.forEach(function(H){H[0].id=++this.$maxRev},this)}var _=this.$redoStack.pop(),P=null;return _&&(P=o.redoChanges(_,c),this.$undoStack.push(_),this.$syncRev()),this.$fromUndo=!1,P},this.$syncRev=function(){var o=this.$undoStack,o=o[o.length-1],o=o&&o[0].id||0;this.$redoStackBaseRev=o,this.$rev=o},this.reset=function(){this.lastDeltas=null,this.$lastDelta=null,this.$undoStack=[],this.$redoStack=[],this.$rev=0,this.mark=0,this.$redoStackBaseRev=this.$rev,this.selections=[]},this.canUndo=function(){return 0<this.$undoStack.length},this.canRedo=function(){return 0<this.$redoStack.length},this.bookmark=function(o){o==null&&(o=this.$rev),this.mark=o},this.isAtBookmark=function(){return this.$rev===this.mark},this.toJSON=function(){},this.fromJSON=function(){},this.hasUndo=this.canUndo,this.hasRedo=this.canRedo,this.isClean=this.isAtBookmark,this.markClean=this.bookmark,this.$prettyPrint=function(o){return o?n(o):n(this.$undoStack)+`
---
`+n(this.$redoStack)}}).call(x.prototype);var p=C("./range").Range,a=p.comparePoints;p.comparePoints;function l(o){return{row:o.row,column:o.column}}function n(o){var c;return o=o||this,Array.isArray(o)?o.map(n).join(`
`):(c="",o.action?(c=o.action=="insert"?"+":"-",c+="["+o.lines+"]"):o.value&&(c=Array.isArray(o.value)?o.value.map(i).join(`
`):i(o.value)),o.start&&(c+=i(o)),(o.id||o.rev)&&(c+="	("+(o.id||o.rev)+")"),c)}function i(o){return o.start.row+":"+o.start.column+"=>"+o.end.row+":"+o.end.column}function t(o,c){var d=o.action=="insert",b=c.action=="insert";if(d&&b)if(0<=a(c.start,o.end))e(c,o,-1);else{if(!(a(c.start,o.start)<=0))return;e(o,c,1)}else if(d&&!b)if(0<=a(c.start,o.end))e(c,o,-1);else{if(!(a(c.end,o.start)<=0))return;e(o,c,-1)}else if(!d&&b)if(0<=a(c.start,o.start))e(c,o,1);else{if(!(a(c.start,o.start)<=0))return;e(o,c,1)}else if(!d&&!b)if(0<=a(c.start,o.start))e(c,o,1);else{if(!(a(c.end,o.start)<=0))return;e(o,c,-1)}return 1}function e(o,c,d){r(o.start,c.start,c.end,d),r(o.end,c.start,c.end,d)}function r(o,c,d,b){o.row==(b==1?c:d).row&&(o.column+=b*(d.column-c.column)),o.row+=b*(d.row-c.row)}function s(o,c){var d=o.lines,b=o.end,h=(o.end=l(c),o.end.row-o.start.row),I=d.splice(h,d.length),h=h?c.column:c.column-o.start.column;return d.push(I[0].substring(0,h)),I[0]=I[0].substr(h),{start:l(c),end:b,lines:I,action:o.action}}m.UndoManager=x}),ace.define("ace/layer/lines",["require","exports","module","ace/lib/dom"],function(C,m,A){function x(a,l){this.element=a,this.canvasHeight=l||5e5,this.element.style.height=2*this.canvasHeight+"px",this.cells=[],this.cellCache=[],this.$offsetCoefficient=0}var p=C("../lib/dom");(function(){this.moveContainer=function(a){p.translate(this.element,0,-(a.firstRowScreen*a.lineHeight%this.canvasHeight)-a.offset*this.$offsetCoefficient)},this.pageChanged=function(a,l){return Math.floor(a.firstRowScreen*a.lineHeight/this.canvasHeight)!==Math.floor(l.firstRowScreen*l.lineHeight/this.canvasHeight)},this.computeLineTop=function(a,l,n){var i=l.firstRowScreen*l.lineHeight,i=Math.floor(i/this.canvasHeight);return n.documentToScreenRow(a,0)*l.lineHeight-i*this.canvasHeight},this.computeLineHeight=function(a,l,n){return l.lineHeight*n.getRowLineCount(a)},this.getLength=function(){return this.cells.length},this.get=function(a){return this.cells[a]},this.shift=function(){this.$cacheCell(this.cells.shift())},this.pop=function(){this.$cacheCell(this.cells.pop())},this.push=function(a){if(Array.isArray(a)){this.cells.push.apply(this.cells,a);for(var l=p.createFragment(this.element),n=0;n<a.length;n++)l.appendChild(a[n].element);this.element.appendChild(l)}else this.cells.push(a),this.element.appendChild(a.element)},this.unshift=function(a){if(Array.isArray(a)){this.cells.unshift.apply(this.cells,a);for(var l=p.createFragment(this.element),n=0;n<a.length;n++)l.appendChild(a[n].element);this.element.firstChild?this.element.insertBefore(l,this.element.firstChild):this.element.appendChild(l)}else this.cells.unshift(a),this.element.insertAdjacentElement("afterbegin",a.element)},this.last=function(){return this.cells.length?this.cells[this.cells.length-1]:null},this.$cacheCell=function(a){a&&(a.element.remove(),this.cellCache.push(a))},this.createCell=function(a,l,n,i){var t,e=this.cellCache.pop();return e||(t=p.createElement("div"),i&&i(t),this.element.appendChild(t),e={element:t,text:"",row:a}),e.row=a,e}}).call(x.prototype),m.Lines=x}),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/layer/lines"],function(C,m,A){function x(e){this.element=p.createElement("div"),this.element.className="ace_layer ace_gutter-layer",e.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$lines=new i(this.element),this.$lines.$offsetCoefficient=1}var p=C("../lib/dom"),a=C("../lib/oop"),l=C("../lib/lang"),n=C("../lib/event_emitter").EventEmitter,i=C("./lines").Lines;function t(e){var r=document.createTextNode(""),r=(e.appendChild(r),p.createElement("span"));return e.appendChild(r),e}(function(){a.implement(this,n),this.setSession=function(e){this.session&&this.session.off("change",this.$updateAnnotations),(this.session=e)&&e.on("change",this.$updateAnnotations)},this.addGutterDecoration=function(e,r){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(e,r)},this.removeGutterDecoration=function(e,r){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(e,r)},this.setAnnotations=function(e){this.$annotations=[];for(var r=0;r<e.length;r++){var c=e[r],o=c.row,s=(s=this.$annotations[o])||(this.$annotations[o]={text:[]}),o=(o=c.text)?l.escapeHTML(o):c.html||"",o=(s.text.indexOf(o)===-1&&s.text.push(o),c.type),c=c.className;c?s.className=c:o=="error"?s.className=" ace_error":o=="warning"&&s.className!=" ace_error"?s.className=" ace_warning":o!="info"||s.className||(s.className=" ace_info")}},this.$updateAnnotations=function(e){var r,s;this.$annotations.length&&(r=e.start.row,(s=e.end.row-r)!=0&&(e.action=="remove"?this.$annotations.splice(r,1+s,null):((e=new Array(1+s)).unshift(r,1),this.$annotations.splice.apply(this.$annotations,e))))},this.update=function(e){this.config=e;for(var r=this.session,s=e.firstRow,o=Math.min(e.lastRow+e.gutterOffset,r.getLength()-1),c=(this.oldLastRow=o,this.config=e,this.$lines.moveContainer(e),this.$updateCursorRow(),r.getNextFoldLine(s)),d=c?c.start.row:1/0,b=null,I=-1,h=s;;){if(d<h&&(h=c.end.row+1,d=(c=r.getNextFoldLine(h,c))?c.start.row:1/0),o<h){for(;this.$lines.getLength()>I+1;)this.$lines.pop();break}(b=this.$lines.get(++I))?b.row=h:(b=this.$lines.createCell(h,e,this.session,t),this.$lines.push(b)),this.$renderCell(b,e,c,h),h++}this._signal("afterRender"),this.$updateGutterWidth(e)},this.$updateGutterWidth=function(e){var r=this.session,c=r.gutterRenderer||this.$renderer,o=r.$firstLineNumber,s=this.$lines.last()?this.$lines.last().text:"",o=((this.$fixedWidth||r.$useWrapMode)&&(s=r.getLength()+o-1),c?c.getWidth(r,s,e):s.toString().length*e.characterWidth),c=this.$padding||this.$computePadding();(o+=c.left+c.right)===this.gutterWidth||isNaN(o)||(this.gutterWidth=o,this.element.parentNode.style.width=this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._signal("changeGutterWidth",o))},this.$updateCursorRow=function(){var e;this.$highlightGutterLine&&(e=this.session.selection.getCursor(),this.$cursorRow!==e.row&&(this.$cursorRow=e.row))},this.updateLineHighlight=function(){if(this.$highlightGutterLine){var e=this.session.selection.cursor.row;if(this.$cursorRow=e,!this.$cursorCell||this.$cursorCell.row!=e){this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ",""));var r=this.$lines.cells;this.$cursorCell=null;for(var s=0;s<r.length;s++){var o=r[s];if(o.row>=this.$cursorRow){if(o.row>this.$cursorRow){var c=this.session.getFoldLine(this.$cursorRow);if(!(0<s&&c&&c.start.row==r[s-1].row))break;o=r[s-1]}o.element.className="ace_gutter-active-line "+o.element.className,this.$cursorCell=o;break}}}}},this.scrollLines=function(e){var r=this.config;if(this.config=e,this.$updateCursorRow(),this.$lines.pageChanged(r,e))return this.update(e);this.$lines.moveContainer(e);var s=Math.min(e.lastRow+e.gutterOffset,this.session.getLength()-1),o=this.oldLastRow;if(this.oldLastRow=s,!r||o<e.firstRow)return this.update(e);if(s<r.firstRow)return this.update(e);if(r.firstRow<e.firstRow)for(var c=this.session.getFoldedRowCount(r.firstRow,e.firstRow-1);0<c;c--)this.$lines.shift();if(s<o)for(c=this.session.getFoldedRowCount(s+1,o);0<c;c--)this.$lines.pop();e.firstRow<r.firstRow&&this.$lines.unshift(this.$renderLines(e,e.firstRow,r.firstRow-1)),o<s&&this.$lines.push(this.$renderLines(e,o+1,s)),this.updateLineHighlight(),this._signal("afterRender"),this.$updateGutterWidth(e)},this.$renderLines=function(e,r,s){for(var o=[],c=r,d=this.session.getNextFoldLine(c),b=d?d.start.row:1/0;b<c&&(c=d.end.row+1,b=(d=this.session.getNextFoldLine(c,d))?d.start.row:1/0),!(s<c);){var I=this.$lines.createCell(c,e,this.session,t);this.$renderCell(I,e,d,c),o.push(I),c++}return o},this.$renderCell=function(e,r,s,o){var c,d=e.element,b=this.session,I=d.childNodes[0],h=d.childNodes[1],u=b.$firstLineNumber,y=b.$breakpoints,E=b.$decorations,w=b.gutterRenderer||this.$renderer,v=this.$showFoldWidgets&&b.foldWidgets,T=s?s.start.row:Number.MAX_VALUE,B="ace_gutter-cell ",E=(this.$highlightGutterLine&&(o==this.$cursorRow||s&&o<this.$cursorRow&&T<=o&&this.$cursorRow<=s.end.row)&&(B+="ace_gutter-active-line ",this.$cursorCell!=e&&(this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ","")),this.$cursorCell=e)),y[o]&&(B+=y[o]),E[o]&&(B+=E[o]),this.$annotations[o]&&(B+=this.$annotations[o].className),d.className!=B&&(d.className=B),!v||(c=v[o])==null&&(c=v[o]=b.getFoldWidget(o)),c?(B="ace_fold-widget ace_"+c,c=="start"&&o==T&&o<s.end.row?B+=" ace_closed":B+=" ace_open",h.className!=B&&(h.className=B),y=r.lineHeight+"px",p.setStyle(h.style,"height",y),p.setStyle(h.style,"display","inline-block")):h&&p.setStyle(h.style,"display","none"),(w?w.getText(b,o):o+u).toString());return E!==I.data&&(I.data=E),p.setStyle(e.element.style,"height",this.$lines.computeLineHeight(o,r,b)+"px"),p.setStyle(e.element.style,"top",this.$lines.computeLineTop(o,r,b)+"px"),e.text=E,e},this.$fixedWidth=!1,this.$highlightGutterLine=!0,this.$renderer="",this.setHighlightGutterLine=function(e){this.$highlightGutterLine=e},this.$showLineNumbers=!0,this.$renderer="",this.setShowLineNumbers=function(e){this.$renderer=!e&&{getWidth:function(){return 0},getText:function(){return""}}},this.getShowLineNumbers=function(){return this.$showLineNumbers},this.$showFoldWidgets=!0,this.setShowFoldWidgets=function(e){e?p.addCssClass(this.element,"ace_folding-enabled"):p.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=e,this.$padding=null},this.getShowFoldWidgets=function(){return this.$showFoldWidgets},this.$computePadding=function(){var e;return this.element.firstChild?(e=p.computedStyle(this.element.firstChild),this.$padding={},this.$padding.left=(parseInt(e.borderLeftWidth)||0)+(parseInt(e.paddingLeft)||0)+1,this.$padding.right=(parseInt(e.borderRightWidth)||0)+(parseInt(e.paddingRight)||0),this.$padding):{left:0,right:0}},this.getRegion=function(e){var r=this.$padding||this.$computePadding(),s=this.element.getBoundingClientRect();return e.x<r.left+s.left?"markers":this.$showFoldWidgets&&e.x>s.right-r.right?"foldWidgets":void 0}}).call(x.prototype),m.Gutter=x}),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],function(C,m,A){function x(l){this.element=a.createElement("div"),this.element.className="ace_layer ace_marker-layer",l.appendChild(this.element)}var p=C("../range").Range,a=C("../lib/dom");(function(){this.$padding=0,this.setPadding=function(l){this.$padding=l},this.setSession=function(l){this.session=l},this.setMarkers=function(l){this.markers=l},this.elt=function(l,n){var i=this.i!=-1&&this.element.childNodes[this.i];i?this.i++:(i=document.createElement("div"),this.element.appendChild(i),this.i=-1),i.style.cssText=n,i.className=l},this.update=function(l){if(l){var n,i;for(i in this.config=l,this.i=0,this.markers){var t,e,r,s=this.markers[i];s.range?(r=s.range.clipRows(l.firstRow,l.lastRow)).isEmpty()||(r=r.toScreenRange(this.session),s.renderer?(t=this.$getTop(r.start.row,l),e=this.$padding+r.start.column*l.characterWidth,s.renderer(n,r,e,t,l)):s.type=="fullLine"?this.drawFullLineMarker(n,r,s.clazz,l):s.type=="screenLine"?this.drawScreenLineMarker(n,r,s.clazz,l):r.isMultiLine()?s.type=="text"?this.drawTextMarker(n,r,s.clazz,l):this.drawMultiLineMarker(n,r,s.clazz,l):this.drawSingleLineMarker(n,r,s.clazz+" ace_start ace_br15",l)):s.update(n,this,this.session,l)}if(this.i!=-1)for(;this.i<this.element.childElementCount;)this.element.removeChild(this.element.lastChild)}},this.$getTop=function(l,n){return(l-n.firstRowScreen)*n.lineHeight},this.drawTextMarker=function(l,n,i,t,e){for(var r,s=this.session,o=n.start.row,c=n.end.row,d=o,b=0,I=s.getScreenLastRowColumn(d),h=new p(d,n.start.column,d,b);d<=c;d++)h.start.row=h.end.row=d,h.start.column=d==o?n.start.column:s.getRowWrapIndent(d),h.end.column=I,r=b,b=I,I=d+1<c?s.getScreenLastRowColumn(d+1):d==c?0:n.end.column,this.drawSingleLineMarker(l,h,i+(d==o?" ace_start":"")+" ace_br"+((d==o||d==o+1&&n.start.column?1:0)|(r<b?2:0)|(I<b?4:0)|(d==c?8:0)),t,d==c?0:1,e)},this.drawMultiLineMarker=function(l,n,i,t,e){var r,s=this.$padding,o=t.lineHeight,c=this.$getTop(n.start.row,t),d=s+n.start.column*t.characterWidth;e=e||"",this.session.$bidiHandler.isBidiRow(n.start.row)?((r=n.clone()).end.row=r.start.row,r.end.column=this.session.getLine(r.start.row).length,this.drawBidiSingleLineMarker(l,r,i+" ace_br1 ace_start",t,null,e)):this.elt(i+" ace_br1 ace_start","height:"+o+"px;right:0;top:"+c+"px;left:"+d+"px;"+(e||"")),this.session.$bidiHandler.isBidiRow(n.end.row)?((r=n.clone()).start.row=r.end.row,r.start.column=0,this.drawBidiSingleLineMarker(l,r,i+" ace_br12",t,null,e)):(c=this.$getTop(n.end.row,t),d=n.end.column*t.characterWidth,this.elt(i+" ace_br12","height:"+o+"px;width:"+d+"px;top:"+c+"px;left:"+s+"px;"+(e||""))),(o=(n.end.row-n.start.row-1)*t.lineHeight)<=0||(c=this.$getTop(n.start.row+1,t),l=(n.start.column?1:0)|(n.end.column?0:8),this.elt(i+(l?" ace_br"+l:""),"height:"+o+"px;right:0;top:"+c+"px;left:"+s+"px;"+(e||"")))},this.drawSingleLineMarker=function(s,d,i,t,o,r){if(this.session.$bidiHandler.isBidiRow(d.start.row))return this.drawBidiSingleLineMarker(s,d,i,t,o,r);var s=t.lineHeight,o=(d.end.column+(o||0)-d.start.column)*t.characterWidth,c=this.$getTop(d.start.row,t),d=this.$padding+d.start.column*t.characterWidth;this.elt(i,"height:"+s+"px;width:"+o+"px;top:"+c+"px;left:"+d+"px;"+(r||""))},this.drawBidiSingleLineMarker=function(l,n,i,t,e,r){var s=t.lineHeight,o=this.$getTop(n.start.row,t),c=this.$padding;this.session.$bidiHandler.getSelections(n.start.column,n.end.column).forEach(function(d){this.elt(i,"height:"+s+"px;width:"+d.width+(e||0)+"px;top:"+o+"px;left:"+(c+d.left)+"px;"+(r||""))},this)},this.drawFullLineMarker=function(l,n,i,t,e){var r=this.$getTop(n.start.row,t),s=t.lineHeight;n.start.row!=n.end.row&&(s+=this.$getTop(n.end.row,t)-r),this.elt(i,"height:"+s+"px;top:"+r+"px;left:0;right:0;"+(e||""))},this.drawScreenLineMarker=function(l,n,i,t,e){n=this.$getTop(n.start.row,t),t=t.lineHeight,this.elt(i,"height:"+t+"px;top:"+n+"px;left:0;right:0;"+(e||""))}}).call(x.prototype),m.Marker=x}),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/layer/lines","ace/lib/event_emitter"],function(C,m,A){function x(t){this.dom=a,this.element=this.dom.createElement("div"),this.element.className="ace_layer ace_text-layer",t.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this),this.$lines=new n(this.element)}var p=C("../lib/oop"),a=C("../lib/dom"),l=C("../lib/lang"),n=C("./lines").Lines,i=C("../lib/event_emitter").EventEmitter;(function(){p.implement(this,i),this.EOF_CHAR="\xB6",this.EOL_CHAR_LF="\xAC",this.EOL_CHAR_CRLF="\xA4",this.EOL_CHAR=this.EOL_CHAR_LF,this.TAB_CHAR="\u2014",this.SPACE_CHAR="\xB7",this.$padding=0,this.MAX_LINE_LENGTH=1e4,this.$updateEolChar=function(){var t=this.session.doc,t=t.getNewLineCharacter()==`
`&&t.getNewLineMode()!="windows"?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=t)return this.EOL_CHAR=t,!0},this.setPadding=function(t){this.$padding=t,this.element.style.margin="0 "+t+"px"},this.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},this.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},this.$setFontMetrics=function(t){this.$fontMetrics=t,this.$fontMetrics.on("changeCharacterSize",function(e){this._signal("changeCharacterSize",e)}.bind(this)),this.$pollSizeChanges()},this.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},this.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},this.setSession=function(t){(this.session=t)&&this.$computeTabString()},this.showInvisibles=!1,this.showSpaces=!1,this.showTabs=!1,this.showEOL=!1,this.setShowInvisibles=function(t){return this.showInvisibles!=t&&(typeof(this.showInvisibles=t)=="string"?(this.showSpaces=/tab/i.test(t),this.showTabs=/space/i.test(t),this.showEOL=/eol/i.test(t)):this.showSpaces=this.showTabs=this.showEOL=t,this.$computeTabString(),!0)},this.displayIndentGuides=!0,this.setDisplayIndentGuides=function(t){return this.displayIndentGuides!=t&&(this.displayIndentGuides=t,this.$computeTabString(),!0)},this.$highlightIndentGuides=!0,this.setHighlightIndentGuides=function(t){return this.$highlightIndentGuides!==t&&(this.$highlightIndentGuides=t)},this.$tabStrings=[],this.onChangeTabSize=this.$computeTabString=function(){for(var t,e,r,s,o,c,d=this.session.getTabSize(),b=(this.tabSize=d,this.$tabStrings=[0]),I=1;I<d+1;I++)this.showTabs?((c=this.dom.createElement("span")).className="ace_invisible ace_invisible_tab",c.textContent=l.stringRepeat(this.TAB_CHAR,I),b.push(c)):b.push(this.dom.createTextNode(l.stringRepeat(" ",I),this.element));this.displayIndentGuides&&(this.$indentGuideRe=/\s\S| \t|\t |\s$/,t="ace_indent-guide",e=this.showSpaces?" ace_invisible ace_invisible_space":"",r=this.showSpaces?l.stringRepeat(this.SPACE_CHAR,this.tabSize):l.stringRepeat(" ",this.tabSize),s=this.showTabs?" ace_invisible ace_invisible_tab":"",o=this.showTabs?l.stringRepeat(this.TAB_CHAR,this.tabSize):r,(c=this.dom.createElement("span")).className=t+e,c.textContent=r,this.$tabStrings[" "]=c,(c=this.dom.createElement("span")).className=t+s,c.textContent=o,this.$tabStrings["	"]=c)},this.updateLines=function(t,e,r){if(this.config.lastRow!=t.lastRow||this.config.firstRow!=t.firstRow)return this.update(t);this.config=t;for(var s=Math.max(e,t.firstRow),o=Math.min(r,t.lastRow),c=this.element.childNodes,d=0,b=t.firstRow;b<s;b++){if(I=this.session.getFoldLine(b)){if(I.containsRow(s)){s=I.start.row;break}b=I.end.row}d++}for(var I,h=!1,b=s,u=(I=this.session.getNextFoldLine(b))?I.start.row:1/0;u<b&&(b=I.end.row+1,u=(I=this.session.getNextFoldLine(b,I))?I.start.row:1/0),!(o<b);){var y,w=c[d++];w&&(this.dom.removeChildren(w),this.$renderLine(w,b,b==u&&I),h&&(w.style.top=this.$lines.computeLineTop(b,t,this.session)+"px"),y=t.lineHeight*this.session.getRowLength(b)+"px",w.style.height!=y&&(h=!0,w.style.height=y)),b++}if(h)for(;d<this.$lines.cells.length;){var v=this.$lines.cells[d++];v.element.style.top=this.$lines.computeLineTop(v.row,t,this.session)+"px"}},this.scrollLines=function(t){var e=this.config;if(this.config=t,this.$lines.pageChanged(e,t))return this.update(t);this.$lines.moveContainer(t);var r=t.lastRow,s=e?e.lastRow:-1;if(!e||s<t.firstRow)return this.update(t);if(r<e.firstRow)return this.update(t);if(!e||e.lastRow<t.firstRow)return this.update(t);if(t.lastRow<e.firstRow)return this.update(t);if(e.firstRow<t.firstRow)for(var o=this.session.getFoldedRowCount(e.firstRow,t.firstRow-1);0<o;o--)this.$lines.shift();if(e.lastRow>t.lastRow)for(o=this.session.getFoldedRowCount(t.lastRow+1,e.lastRow);0<o;o--)this.$lines.pop();t.firstRow<e.firstRow&&this.$lines.unshift(this.$renderLinesFragment(t,t.firstRow,e.firstRow-1)),t.lastRow>e.lastRow&&this.$lines.push(this.$renderLinesFragment(t,e.lastRow+1,t.lastRow)),this.$highlightIndentGuide()},this.$renderLinesFragment=function(t,e,r){for(var s=[],o=e,c=this.session.getNextFoldLine(o),d=c?c.start.row:1/0;d<o&&(o=c.end.row+1,d=(c=this.session.getNextFoldLine(o,c))?c.start.row:1/0),!(r<o);){var b=this.$lines.createCell(o,t,this.session),I=b.element;this.dom.removeChildren(I),a.setStyle(I.style,"height",this.$lines.computeLineHeight(o,t,this.session)+"px"),a.setStyle(I.style,"top",this.$lines.computeLineTop(o,t,this.session)+"px"),this.$renderLine(I,o,o==d&&c),this.$useLineGroups()?I.className="ace_line_group":I.className="ace_line",s.push(b),o++}return s},this.update=function(t){this.$lines.moveContainer(t);for(var e=(this.config=t).firstRow,r=t.lastRow,s=this.$lines;s.getLength();)s.pop();s.push(this.$renderLinesFragment(t,e,r))},this.$textToken={text:!0,rparen:!0,lparen:!0},this.$renderToken=function(t,e,r,s){for(var o,c,d=this,b=/(\t)|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\uFEFF\uFFF9-\uFFFC\u2066\u2067\u2068\u202A\u202B\u202D\u202E\u202C\u2069]+)|(\u3000)|([\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF])/g,I=this.dom.createFragment(this.element),h=0;o=b.exec(s);){var u,y,w=o[1],v=o[2],T=o[3],B=o[4],E=o[5];!d.showSpaces&&v||(u=h!=o.index?s.slice(h,o.index):"",h=o.index+o[0].length,u&&I.appendChild(this.dom.createTextNode(u,this.element)),w?(u=d.session.getScreenTabSize(e+o.index),I.appendChild(d.$tabStrings[u].cloneNode(!0)),e+=u-1):v?d.showSpaces?((y=this.dom.createElement("span")).className="ace_invisible ace_invisible_space",y.textContent=l.stringRepeat(d.SPACE_CHAR,v.length),I.appendChild(y)):I.appendChild(this.com.createTextNode(v,this.element)):T?((y=this.dom.createElement("span")).className="ace_invisible ace_invisible_space ace_invalid",y.textContent=l.stringRepeat(d.SPACE_CHAR,T.length),I.appendChild(y)):B?(e+=1,(y=this.dom.createElement("span")).style.width=2*d.config.characterWidth+"px",y.className=d.showSpaces?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",y.textContent=d.showSpaces?d.SPACE_CHAR:B,I.appendChild(y)):E&&(e+=1,(y=this.dom.createElement("span")).style.width=2*d.config.characterWidth+"px",y.className="ace_cjk",y.textContent=E,I.appendChild(y)))}return I.appendChild(this.dom.createTextNode(h?s.slice(h):s,this.element)),this.$textToken[r.type]?t.appendChild(I):(c="ace_"+r.type.replace(/\./g," ace_"),y=this.dom.createElement("span"),r.type=="fold"&&(y.style.width=r.value.length*this.config.characterWidth+"px"),y.className=c,y.appendChild(I),t.appendChild(y)),e+s.length},this.renderIndentGuide=function(t,e,r){var s=e.search(this.$indentGuideRe);if(!(s<=0||r<=s)){if(e[0]==" "){for(var o=(s-=s%this.tabSize)/this.tabSize,c=0;c<o;c++)t.appendChild(this.$tabStrings[" "].cloneNode(!0));return this.$highlightIndentGuide(),e.substr(s)}if(e[0]=="	"){for(c=0;c<s;c++)t.appendChild(this.$tabStrings["	"].cloneNode(!0));return this.$highlightIndentGuide(),e.substr(s)}this.$highlightIndentGuide()}return e},this.$highlightIndentGuide=function(){if(this.$highlightIndentGuides&&this.displayIndentGuides){this.$highlightIndentGuideMarker={indentLevel:void 0,start:void 0,end:void 0,dir:void 0};var t=this.session.doc.$lines,e=this.session.selection.getCursor(),r=/^\s*/.exec(this.session.doc.getLine(e.row))[0].length,s=Math.floor(r/this.tabSize);if(this.$highlightIndentGuideMarker={indentLevel:s,start:e.row},this.session.$bracketHighlight){for(var o=this.session.$bracketHighlight.ranges,c=0;c<o.length;c++)if(e.row!==o[c].start.row){this.$highlightIndentGuideMarker.end=o[c].start.row,e.row>o[c].start.row?this.$highlightIndentGuideMarker.dir=-1:this.$highlightIndentGuideMarker.dir=1;break}}if(!this.$highlightIndentGuideMarker.end&&t[e.row]!==""&&e.column===t[e.row].length)for(this.$highlightIndentGuideMarker.dir=1,c=e.row+1;c<t.length;c++){var d=t[c],b=/^\s*/.exec(d)[0].length;if(d!==""&&(this.$highlightIndentGuideMarker.end=c,b<=r))break}this.$renderHighlightIndentGuide()}},this.$clearActiveIndentGuide=function(){for(var t=this.$lines.cells,e=0;e<t.length;e++){var r=t[e].element.childNodes;if(0<r.length){for(var s=0;s<r.length;s++)if(r[s].classList&&r[s].classList.contains("ace_indent-guide-active")){r[s].classList.remove("ace_indent-guide-active");break}}}},this.$setIndentGuideActive=function(t,e){this.session.doc.getLine(t.row)!==""&&(t=t.element.childNodes)&&t[e-1]&&t[e-1].classList&&t[e-1].classList.add("ace_indent-guide-active")},this.$renderHighlightIndentGuide=function(){if(this.$lines){var t=this.$lines.cells,e=(this.$clearActiveIndentGuide(),this.$highlightIndentGuideMarker.indentLevel);if(e!==0){if(this.$highlightIndentGuideMarker.dir===1)for(var r=0;r<t.length;r++){var s=t[r];if(this.$highlightIndentGuideMarker.end&&s.row>=this.$highlightIndentGuideMarker.start+1){if(s.row>=this.$highlightIndentGuideMarker.end)break;this.$setIndentGuideActive(s,e)}}else for(r=t.length-1;0<=r;r--)if(s=t[r],this.$highlightIndentGuideMarker.end&&s.row<this.$highlightIndentGuideMarker.start){if(s.row<=this.$highlightIndentGuideMarker.end)break;this.$setIndentGuideActive(s,e)}}}},this.$createLineElement=function(t){var e=this.dom.createElement("div");return e.className="ace_line",e.style.height=this.config.lineHeight+"px",e},this.$renderWrappedLine=function(t,e,r){var s=0,o=0,c=r[0],d=0,b=this.$createLineElement();t.appendChild(b);for(var I=0;I<e.length;I++){var h=e[I],u=h.value;if(I==0&&this.displayIndentGuides){if(s=u.length,!(u=this.renderIndentGuide(b,u,c)))continue;s-=u.length}if(s+u.length<c)d=this.$renderToken(b,d,h,u),s+=u.length;else{for(;s+u.length>=c;)d=this.$renderToken(b,d,h,u.substring(0,c-s)),u=u.substring(c-s),s=c,b=this.$createLineElement(),t.appendChild(b),b.appendChild(this.dom.createTextNode(l.stringRepeat("\xA0",r.indent),this.element)),d=0,c=r[++o]||Number.MAX_VALUE;u.length!=0&&(s+=u.length,d=this.$renderToken(b,d,h,u))}}r[r.length-1]>this.MAX_LINE_LENGTH&&this.$renderOverflowMessage(b,d,null,"",!0)},this.$renderSimpleLine=function(t,e){for(var r=0,s=0;s<e.length;s++){var o=e[s],c=o.value;if(s!=0||!this.displayIndentGuides||(c=this.renderIndentGuide(t,c))){if(r+c.length>this.MAX_LINE_LENGTH)return this.$renderOverflowMessage(t,r,o,c);r=this.$renderToken(t,r,o,c)}}},this.$renderOverflowMessage=function(t,e,r,s,o){r&&this.$renderToken(t,e,r,s.slice(0,this.MAX_LINE_LENGTH-e)),r=this.dom.createElement("span"),r.className="ace_inline_button ace_keyword ace_toggle_wrap",r.textContent=o?"<hide>":"<click to see more...>",t.appendChild(r)},this.$renderLine=function(t,e,r){var s,o,c=t;(s=(r=r||r==0?r:this.session.getFoldLine(e))?this.$getFoldLineTokens(e,r):this.session.getTokens(e)).length?(o=this.session.getRowSplitData(e))&&o.length?(this.$renderWrappedLine(t,s,o),c=t.lastChild):(c=t,this.$useLineGroups()&&(c=this.$createLineElement(),t.appendChild(c)),this.$renderSimpleLine(c,s)):this.$useLineGroups()&&(c=this.$createLineElement(),t.appendChild(c)),this.showEOL&&c&&(r&&(e=r.end.row),(o=this.dom.createElement("span")).className="ace_invisible ace_invisible_eol",o.textContent=e==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,c.appendChild(o))},this.$getFoldLineTokens=function(t,e){var r=this.session,s=[],o=r.getTokens(t);return e.walk(function(c,d,b,I,h){if(c!=null)s.push({type:"fold",value:c});else if((o=h?r.getTokens(d):o).length){for(var u,y=o,w=I,v=b,T=0,B=0;B+y[T].value.length<w;)if(B+=y[T].value.length,++T==y.length)return;for(B!=w&&((u=y[T].value.substring(w-B)).length>v-w&&(u=u.substring(0,v-w)),s.push({type:y[T].type,value:u}),B=w+u.length,T+=1);B<v&&T<y.length;)(u=y[T].value).length+B>v?s.push({type:y[T].type,value:u.substring(0,v-B)}):s.push(y[T]),B+=u.length,T+=1}},e.end.row,this.session.getLine(e.end.row).length),s},this.$useLineGroups=function(){return this.session.getUseWrapMode()},this.destroy=function(){}}).call(x.prototype),m.Text=x}),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],function(C,m,A){function x(a){this.element=p.createElement("div"),this.element.className="ace_layer ace_cursor-layer",a.appendChild(this.element),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),p.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=this.$updateOpacity.bind(this)}var p=C("../lib/dom");(function(){this.$updateOpacity=function(a){for(var l=this.cursors,n=l.length;n--;)p.setStyle(l[n].style,"opacity",a?"":"0")},this.$startCssAnimation=function(){for(var a=this.cursors,l=a.length;l--;)a[l].style.animationDuration=this.blinkInterval+"ms";this.$isAnimating=!0,setTimeout(function(){this.$isAnimating&&p.addCssClass(this.element,"ace_animate-blinking")}.bind(this))},this.$stopCssAnimation=function(){this.$isAnimating=!1,p.removeCssClass(this.element,"ace_animate-blinking")},this.$padding=0,this.setPadding=function(a){this.$padding=a},this.setSession=function(a){this.session=a},this.setBlinking=function(a){a!=this.isBlinking&&(this.isBlinking=a,this.restartTimer())},this.setBlinkInterval=function(a){a!=this.blinkInterval&&(this.blinkInterval=a,this.restartTimer())},this.setSmoothBlinking=function(a){a!=this.smoothBlinking&&(this.smoothBlinking=a,p.setCssClass(this.element,"ace_smooth-blinking",a),this.$updateCursors(!0),this.restartTimer())},this.addCursor=function(){var a=p.createElement("div");return a.className="ace_cursor",this.element.appendChild(a),this.cursors.push(a),a},this.removeCursor=function(){var a;if(1<this.cursors.length)return(a=this.cursors.pop()).parentNode.removeChild(a),a},this.hideCursor=function(){this.isVisible=!1,p.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.showCursor=function(){this.isVisible=!0,p.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.restartTimer=function(){var a,l=this.$updateCursors;clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.$stopCssAnimation(),this.smoothBlinking&&(this.$isSmoothBlinking=!1,p.removeCssClass(this.element,"ace_smooth-blinking")),l(!0),this.isBlinking&&this.blinkInterval&&this.isVisible?(this.smoothBlinking&&(this.$isSmoothBlinking=!0,setTimeout(function(){this.$isSmoothBlinking&&p.addCssClass(this.element,"ace_smooth-blinking")}.bind(this))),p.HAS_CSS_ANIMATION?this.$startCssAnimation():(a=function(){this.timeoutId=setTimeout(function(){l(!1)},.6*this.blinkInterval)}.bind(this),this.intervalId=setInterval(function(){l(!0),a()},this.blinkInterval),a())):this.$stopCssAnimation()},this.getPixelPosition=function(a,l){if(!this.config||!this.session)return{left:0,top:0};a=a||this.session.selection.getCursor();var n=this.session.documentToScreenPosition(a);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(n.row,a.row)?this.session.$bidiHandler.getPosLeft(n.column):n.column*this.config.characterWidth),top:(n.row-(l?this.config.firstRowScreen:0))*this.config.lineHeight}},this.isCursorInView=function(a,l){return 0<=a.top&&a.top<l.maxHeight},this.update=function(a){this.config=a;for(var l=this.session.$selectionMarkers,i=0,n=0,i=0,t=(l=l!==void 0&&l.length!==0?l:[{cursor:null}]).length;i<t;i++){var e,r,s=this.getPixelPosition(l[i].cursor,!0);(s.top>a.height+a.offset||s.top<0)&&1<i||(r=(e=this.cursors[n++]||this.addCursor()).style,this.drawCursor?this.drawCursor(e,s,a,l[i],this.session):this.isCursorInView(s,a)?(p.setStyle(r,"display","block"),p.translate(e,s.left,s.top),p.setStyle(r,"width",Math.round(a.characterWidth)+"px"),p.setStyle(r,"height",a.lineHeight+"px")):p.setStyle(r,"display","none"))}for(;this.cursors.length>n;)this.removeCursor();var o=this.session.getOverwrite();this.$setOverwrite(o),this.$pixelPos=s,this.restartTimer()},this.drawCursor=null,this.$setOverwrite=function(a){a!=this.overwrite&&((this.overwrite=a)?p.addCssClass(this.element,"ace_overwrite-cursors"):p.removeCssClass(this.element,"ace_overwrite-cursors"))},this.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)}}).call(x.prototype),m.Cursor=x}),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(C,m,A){function x(e){this.element=n.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+this.classSuffix,this.inner=n.createElement("div"),this.inner.className="ace_scrollbar-inner",this.inner.textContent="\xA0",this.element.appendChild(this.inner),e.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,i.addListener(this.element,"scroll",this.onScroll.bind(this)),i.addListener(this.element,"mousedown",i.preventDefault)}function p(e,r){x.call(this,e),this.scrollTop=0,this.scrollHeight=0,r.$scrollbarWidth=this.width=n.scrollbarWidth(e.ownerDocument),this.inner.style.width=this.element.style.width=(this.width||15)+5+"px",this.$minWidth=0}function a(e,r){x.call(this,e),this.scrollLeft=0,this.height=r.$scrollbarWidth,this.inner.style.height=this.element.style.height=(this.height||15)+5+"px"}var l=C("./lib/oop"),n=C("./lib/dom"),i=C("./lib/event"),t=C("./lib/event_emitter").EventEmitter;(function(){l.implement(this,t),this.setVisible=function(e){this.element.style.display=e?"":"none",this.isVisible=e,this.coeff=1}}).call(x.prototype),l.inherits(p,x),function(){this.classSuffix="-v",this.onScroll=function(){var e;this.skipEvent||(this.scrollTop=this.element.scrollTop,this.coeff!=1&&(e=this.element.clientHeight/this.scrollHeight,this.scrollTop=this.scrollTop*(1-e)/(this.coeff-e)),this._emit("scroll",{data:this.scrollTop})),this.skipEvent=!1},this.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},this.setHeight=function(e){this.element.style.height=e+"px"},this.setInnerHeight=this.setScrollHeight=function(e){32768<(this.scrollHeight=e)?(this.coeff=32768/e,e=32768):this.coeff!=1&&(this.coeff=1),this.inner.style.height=e+"px"},this.setScrollTop=function(e){this.scrollTop!=e&&(this.skipEvent=!0,this.scrollTop=e,this.element.scrollTop=e*this.coeff)}}.call(p.prototype),l.inherits(a,x),function(){this.classSuffix="-h",this.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},this.getHeight=function(){return this.isVisible?this.height:0},this.setWidth=function(e){this.element.style.width=e+"px"},this.setInnerWidth=function(e){this.inner.style.width=e+"px"},this.setScrollWidth=function(e){this.inner.style.width=e+"px"},this.setScrollLeft=function(e){this.scrollLeft!=e&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=e)}}.call(a.prototype),m.ScrollBar=p,m.ScrollBarV=p,m.ScrollBarH=a,m.VScrollBar=p,m.HScrollBar=a}),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],function(C,m,A){function x(a,l){this.onRender=a,this.pending=!1,this.changes=0,this.$recursionLimit=2,this.window=l||window;var n=this;this._flush=function(i){n.pending=!1;var t=n.changes;t&&(p.blockIdle(100),n.changes=0,n.onRender(t)),n.changes?n.$recursionLimit--<0||n.schedule():n.$recursionLimit=2}}var p=C("./lib/event");(function(){this.schedule=function(a){this.changes=this.changes|a,this.changes&&!this.pending&&(p.nextFrame(this._flush),this.pending=!0)},this.clear=function(a){var l=this.changes;return this.changes=0,l}}).call(x.prototype),m.RenderLoop=x}),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/lib/useragent","ace/lib/event_emitter"],function(e,m,A){var x=e("../lib/oop"),p=e("../lib/dom"),a=e("../lib/lang"),l=e("../lib/event"),n=e("../lib/useragent"),i=e("../lib/event_emitter").EventEmitter,t=typeof ResizeObserver=="function",e=m.FontMetrics=function(r){this.el=p.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=p.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=p.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),r.appendChild(this.el),this.$measureNode.textContent=a.stringRepeat("X",256),this.$characterSize={width:0,height:0},t?this.$addObserver():this.checkForSizeChanges()};(function(){x.implement(this,i),this.$characterSize={width:0,height:0},this.$setMeasureNodeStyles=function(r,s){r.width=r.height="auto",r.left=r.top="0px",r.visibility="hidden",r.position="absolute",r.whiteSpace="pre",n.isIE<8?r["font-family"]="inherit":r.font="inherit",r.overflow=s?"hidden":"visible"},this.checkForSizeChanges=function(r){var s;!(r=r===void 0?this.$measureSizes():r)||this.$characterSize.width===r.width&&this.$characterSize.height===r.height||(this.$measureNode.style.fontWeight="bold",s=this.$measureSizes(),this.$measureNode.style.fontWeight="",this.$characterSize=r,this.charSizes=Object.create(null),this.allowBoldFonts=s&&s.width===r.width&&s.height===r.height,this._emit("changeCharacterSize",{data:r}))},this.$addObserver=function(){var r=this;this.$observer=new window.ResizeObserver(function(s){r.checkForSizeChanges()}),this.$observer.observe(this.$measureNode)},this.$pollSizeChanges=function(){var r;return this.$pollSizeChangesTimer||this.$observer?this.$pollSizeChangesTimer:(r=this).$pollSizeChangesTimer=l.onIdle(function s(){r.checkForSizeChanges(),l.onIdle(s,500)},500)},this.setPolling=function(r){r?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)},this.$measureSizes=function(r){return r={height:(r||this.$measureNode).clientHeight,width:(r||this.$measureNode).clientWidth/256},r.width===0||r.height===0?null:r},this.$measureCharWidth=function(r){return this.$main.textContent=a.stringRepeat(r,256),this.$main.getBoundingClientRect().width/256},this.getCharacterWidth=function(r){var s=this.charSizes[r];return s=s===void 0?this.charSizes[r]=this.$measureCharWidth(r)/this.$characterSize.width:s},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$observer&&this.$observer.disconnect(),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)},this.$getZoom=function r(s){return s&&s.parentElement?(window.getComputedStyle(s).zoom||1)*r(s.parentElement):1},this.$initTransformMeasureNodes=function(){function r(s,o){return["div",{style:"position: absolute;top:"+s+"px;left:"+o+"px;"}]}this.els=p.buildDom([r(0,0),r(200,0),r(0,200),r(200,200)],this.el)},this.transformCoordinates=function(r,s){function o(T,B,E){var _=T[1]*B[0]-T[0]*B[1];return[(-B[1]*E[0]+B[0]*E[1])/_,(+T[1]*E[0]-T[0]*E[1])/_]}function c(T,B){return[T[0]-B[0],T[1]-B[1]]}function d(T,B){return[T[0]+B[0],T[1]+B[1]]}function b(T,B){return[T*B[0],T*B[1]]}function I(T){return T=T.getBoundingClientRect(),[T.left,T.top]}r=r&&b(1/this.$getZoom(this.el),r),this.els||this.$initTransformMeasureNodes();var h,u=I(this.els[0]),w=I(this.els[1]),v=I(this.els[2]),y=I(this.els[3]),y=o(c(y,w),c(y,v),c(d(w,v),d(y,u))),w=b(1+y[0],c(w,u)),v=b(1+y[1],c(v,u));return s?(h=y[0]*s[0]/200+y[1]*s[1]/200+1,s=d(b(s[0],w),b(s[1],v)),d(b(1/h/200,s),u)):(h=c(r,u),s=o(c(w,b(y[0],h)),c(v,b(y[1],h)),h),b(200,s))}}).call(e.prototype)}),ace.define("ace/css/editor.css",["require","exports","module"],function(C,m,A){A.exports=`/*
styles = []
for (var i = 1; i < 16; i++) {
    styles.push(".ace_br" + i + "{" + (
        ["top-left", "top-right", "bottom-right", "bottom-left"]
    ).map(function(x, j) {
        return i & (1<<j) ? "border-" + x + "-radius: 3px;" : "" 
    }).filter(Boolean).join(" ") + "}")
}
styles.join("\\n")
*/
.ace_br1 {border-top-left-radius    : 3px;}
.ace_br2 {border-top-right-radius   : 3px;}
.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}
.ace_br4 {border-bottom-right-radius: 3px;}
.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}
.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}
.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}
.ace_br8 {border-bottom-left-radius : 3px;}
.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}
.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}
.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}
.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}
.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}
.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}
.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}


.ace_editor {
    position: relative;
    overflow: hidden;
    padding: 0;
    font: 12px/normal 'Monaco', 'Menlo', 'Ubuntu Mono', 'Consolas', 'source-code-pro', monospace;
    direction: ltr;
    text-align: left;
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
}

.ace_scroller {
    position: absolute;
    overflow: hidden;
    top: 0;
    bottom: 0;
    background-color: inherit;
    -ms-user-select: none;
    -moz-user-select: none;
    -webkit-user-select: none;
    user-select: none;
    cursor: text;
}

.ace_content {
    position: absolute;
    box-sizing: border-box;
    min-width: 100%;
    contain: style size layout;
    font-variant-ligatures: no-common-ligatures;
}

.ace_dragging .ace_scroller:before{
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    content: '';
    background: rgba(250, 250, 250, 0.01);
    z-index: 1000;
}
.ace_dragging.ace_dark .ace_scroller:before{
    background: rgba(0, 0, 0, 0.01);
}

.ace_gutter {
    position: absolute;
    overflow : hidden;
    width: auto;
    top: 0;
    bottom: 0;
    left: 0;
    cursor: default;
    z-index: 4;
    -ms-user-select: none;
    -moz-user-select: none;
    -webkit-user-select: none;
    user-select: none;
    contain: style size layout;
}

.ace_gutter-active-line {
    position: absolute;
    left: 0;
    right: 0;
}

.ace_scroller.ace_scroll-left {
    box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;
}

.ace_gutter-cell {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    padding-left: 19px;
    padding-right: 6px;
    background-repeat: no-repeat;
}

.ace_gutter-cell.ace_error {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");
    background-repeat: no-repeat;
    background-position: 2px center;
}

.ace_gutter-cell.ace_warning {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");
    background-position: 2px center;
}

.ace_gutter-cell.ace_info {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");
    background-position: 2px center;
}
.ace_dark .ace_gutter-cell.ace_info {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");
}

.ace_scrollbar {
    contain: strict;
    position: absolute;
    right: 0;
    bottom: 0;
    z-index: 6;
}

.ace_scrollbar-inner {
    position: absolute;
    cursor: text;
    left: 0;
    top: 0;
}

.ace_scrollbar-v{
    overflow-x: hidden;
    overflow-y: scroll;
    top: 0;
}

.ace_scrollbar-h {
    overflow-x: scroll;
    overflow-y: hidden;
    left: 0;
}

.ace_print-margin {
    position: absolute;
    height: 100%;
}

.ace_text-input {
    position: absolute;
    z-index: 0;
    width: 0.5em;
    height: 1em;
    opacity: 0;
    background: transparent;
    -moz-appearance: none;
    appearance: none;
    border: none;
    resize: none;
    outline: none;
    overflow: hidden;
    font: inherit;
    padding: 0 1px;
    margin: 0 -1px;
    contain: strict;
    -ms-user-select: text;
    -moz-user-select: text;
    -webkit-user-select: text;
    user-select: text;
    /*with \`pre-line\` chrome inserts &nbsp; instead of space*/
    white-space: pre!important;
}
.ace_text-input.ace_composition {
    background: transparent;
    color: inherit;
    z-index: 1000;
    opacity: 1;
}
.ace_composition_placeholder { color: transparent }
.ace_composition_marker { 
    border-bottom: 1px solid;
    position: absolute;
    border-radius: 0;
    margin-top: 1px;
}

[ace_nocontext=true] {
    transform: none!important;
    filter: none!important;
    clip-path: none!important;
    mask : none!important;
    contain: none!important;
    perspective: none!important;
    mix-blend-mode: initial!important;
    z-index: auto;
}

.ace_layer {
    z-index: 1;
    position: absolute;
    overflow: hidden;
    /* workaround for chrome bug https://github.com/ajaxorg/ace/issues/2312*/
    word-wrap: normal;
    white-space: pre;
    height: 100%;
    width: 100%;
    box-sizing: border-box;
    /* setting pointer-events: auto; on node under the mouse, which changes
        during scroll, will break mouse wheel scrolling in Safari */
    pointer-events: none;
}

.ace_gutter-layer {
    position: relative;
    width: auto;
    text-align: right;
    pointer-events: auto;
    height: 1000000px;
    contain: style size layout;
}

.ace_text-layer {
    font: inherit !important;
    position: absolute;
    height: 1000000px;
    width: 1000000px;
    contain: style size layout;
}

.ace_text-layer > .ace_line, .ace_text-layer > .ace_line_group {
    contain: style size layout;
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
}

.ace_hidpi .ace_text-layer,
.ace_hidpi .ace_gutter-layer,
.ace_hidpi .ace_content,
.ace_hidpi .ace_gutter {
    contain: strict;
    will-change: transform;
}
.ace_hidpi .ace_text-layer > .ace_line, 
.ace_hidpi .ace_text-layer > .ace_line_group {
    contain: strict;
}

.ace_cjk {
    display: inline-block;
    text-align: center;
}

.ace_cursor-layer {
    z-index: 4;
}

.ace_cursor {
    z-index: 4;
    position: absolute;
    box-sizing: border-box;
    border-left: 2px solid;
    /* workaround for smooth cursor repaintng whole screen in chrome */
    transform: translatez(0);
}

.ace_multiselect .ace_cursor {
    border-left-width: 1px;
}

.ace_slim-cursors .ace_cursor {
    border-left-width: 1px;
}

.ace_overwrite-cursors .ace_cursor {
    border-left-width: 0;
    border-bottom: 1px solid;
}

.ace_hidden-cursors .ace_cursor {
    opacity: 0.2;
}

.ace_hasPlaceholder .ace_hidden-cursors .ace_cursor {
    opacity: 0;
}

.ace_smooth-blinking .ace_cursor {
    transition: opacity 0.18s;
}

.ace_animate-blinking .ace_cursor {
    animation-duration: 1000ms;
    animation-timing-function: step-end;
    animation-name: blink-ace-animate;
    animation-iteration-count: infinite;
}

.ace_animate-blinking.ace_smooth-blinking .ace_cursor {
    animation-duration: 1000ms;
    animation-timing-function: ease-in-out;
    animation-name: blink-ace-animate-smooth;
}
    
@keyframes blink-ace-animate {
    from, to { opacity: 1; }
    60% { opacity: 0; }
}

@keyframes blink-ace-animate-smooth {
    from, to { opacity: 1; }
    45% { opacity: 1; }
    60% { opacity: 0; }
    85% { opacity: 0; }
}

.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {
    position: absolute;
    z-index: 3;
}

.ace_marker-layer .ace_selection {
    position: absolute;
    z-index: 5;
}

.ace_marker-layer .ace_bracket {
    position: absolute;
    z-index: 6;
}

.ace_marker-layer .ace_error_bracket {
    position: absolute;
    border-bottom: 1px solid #DE5555;
    border-radius: 0;
}

.ace_marker-layer .ace_active-line {
    position: absolute;
    z-index: 2;
}

.ace_marker-layer .ace_selected-word {
    position: absolute;
    z-index: 4;
    box-sizing: border-box;
}

.ace_line .ace_fold {
    box-sizing: border-box;

    display: inline-block;
    height: 11px;
    margin-top: -2px;
    vertical-align: middle;

    background-image:
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");
    background-repeat: no-repeat, repeat-x;
    background-position: center center, top left;
    color: transparent;

    border: 1px solid black;
    border-radius: 2px;

    cursor: pointer;
    pointer-events: auto;
}

.ace_dark .ace_fold {
}

.ace_fold:hover{
    background-image:
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");
}

.ace_tooltip {
    background-color: #FFF;
    background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));
    border: 1px solid gray;
    border-radius: 1px;
    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
    color: black;
    max-width: 100%;
    padding: 3px 4px;
    position: fixed;
    z-index: 999999;
    box-sizing: border-box;
    cursor: default;
    white-space: pre;
    word-wrap: break-word;
    line-height: normal;
    font-style: normal;
    font-weight: normal;
    letter-spacing: normal;
    pointer-events: none;
}

.ace_folding-enabled > .ace_gutter-cell {
    padding-right: 13px;
}

.ace_fold-widget {
    box-sizing: border-box;

    margin: 0 -12px 0 1px;
    display: none;
    width: 11px;
    vertical-align: top;

    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");
    background-repeat: no-repeat;
    background-position: center;

    border-radius: 3px;
    
    border: 1px solid transparent;
    cursor: pointer;
}

.ace_folding-enabled .ace_fold-widget {
    display: inline-block;   
}

.ace_fold-widget.ace_end {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");
}

.ace_fold-widget.ace_closed {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");
}

.ace_fold-widget:hover {
    border: 1px solid rgba(0, 0, 0, 0.3);
    background-color: rgba(255, 255, 255, 0.2);
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);
}

.ace_fold-widget:active {
    border: 1px solid rgba(0, 0, 0, 0.4);
    background-color: rgba(0, 0, 0, 0.05);
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);
}
/**
 * Dark version for fold widgets
 */
.ace_dark .ace_fold-widget {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");
}
.ace_dark .ace_fold-widget.ace_end {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");
}
.ace_dark .ace_fold-widget.ace_closed {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");
}
.ace_dark .ace_fold-widget:hover {
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);
    background-color: rgba(255, 255, 255, 0.1);
}
.ace_dark .ace_fold-widget:active {
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);
}

.ace_inline_button {
    border: 1px solid lightgray;
    display: inline-block;
    margin: -1px 8px;
    padding: 0 5px;
    pointer-events: auto;
    cursor: pointer;
}
.ace_inline_button:hover {
    border-color: gray;
    background: rgba(200,200,200,0.2);
    display: inline-block;
    pointer-events: auto;
}

.ace_fold-widget.ace_invalid {
    background-color: #FFB4B4;
    border-color: #DE5555;
}

.ace_fade-fold-widgets .ace_fold-widget {
    transition: opacity 0.4s ease 0.05s;
    opacity: 0;
}

.ace_fade-fold-widgets:hover .ace_fold-widget {
    transition: opacity 0.05s ease 0.05s;
    opacity:1;
}

.ace_underline {
    text-decoration: underline;
}

.ace_bold {
    font-weight: bold;
}

.ace_nobold .ace_bold {
    font-weight: normal;
}

.ace_italic {
    font-style: italic;
}


.ace_error-marker {
    background-color: rgba(255, 0, 0,0.2);
    position: absolute;
    z-index: 9;
}

.ace_highlight-marker {
    background-color: rgba(255, 255, 0,0.2);
    position: absolute;
    z-index: 8;
}

.ace_mobile-menu {
    position: absolute;
    line-height: 1.5;
    border-radius: 4px;
    -ms-user-select: none;
    -moz-user-select: none;
    -webkit-user-select: none;
    user-select: none;
    background: white;
    box-shadow: 1px 3px 2px grey;
    border: 1px solid #dcdcdc;
    color: black;
}
.ace_dark > .ace_mobile-menu {
    background: #333;
    color: #ccc;
    box-shadow: 1px 3px 2px grey;
    border: 1px solid #444;

}
.ace_mobile-button {
    padding: 2px;
    cursor: pointer;
    overflow: hidden;
}
.ace_mobile-button:hover {
    background-color: #eee;
    opacity:1;
}
.ace_mobile-button:active {
    background-color: #ddd;
}

.ace_placeholder {
    font-family: arial;
    transform: scale(0.9);
    transform-origin: left;
    white-space: pre;
    opacity: 0.7;
    margin: 0 10px;
}`}),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/config","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter","ace/css/editor.css","ace/lib/useragent"],function(C,m,A){function x(v,y){var w=this,v=(this.container=v||a.createElement("div"),a.addCssClass(this.container,"ace_editor"),a.HI_DPI&&a.addCssClass(this.container,"ace_hidpi"),this.setTheme(y),l.get("useStrictCSP")==null&&l.set("useStrictCSP",!1),this.$gutter=a.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.$gutter.setAttribute("aria-hidden",!0),this.scroller=a.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=a.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new n(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new i(this.content),this.$textLayer=new t(this.content));this.canvas=v.element,this.$markerFront=new i(this.content),this.$cursorLayer=new e(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new s(this.container,this),this.scrollBarH=new r(this.container,this),this.scrollBarV.on("scroll",function(T){w.$scrollAnimation||w.session.setScrollTop(T.data-w.scrollMargin.top)}),this.scrollBarH.on("scroll",function(T){w.$scrollAnimation||w.session.setScrollLeft(T.data-w.scrollMargin.left)}),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new c(this.container),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.on("changeCharacterSize",function(T){w.updateCharacterSize(),w.onResize(!0,w.gutterWidth,w.$size.width,w.$size.height),w._signal("changeCharacterSize",T)}),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.margin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.$keepTextAreaAtCursor=!I.isIOS,this.$loop=new o(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),l.resetOptions(this),l._signal("renderer",this)}var p=C("./lib/oop"),a=C("./lib/dom"),l=C("./config"),n=C("./layer/gutter").Gutter,i=C("./layer/marker").Marker,t=C("./layer/text").Text,e=C("./layer/cursor").Cursor,r=C("./scrollbar").HScrollBar,s=C("./scrollbar").VScrollBar,o=C("./renderloop").RenderLoop,c=C("./layer/font_metrics").FontMetrics,d=C("./lib/event_emitter").EventEmitter,b=C("./css/editor.css"),I=C("./lib/useragent"),h=I.isIE;a.importCssString(b,"ace_editor.css",!1),function(){this.CHANGE_CURSOR=1,this.CHANGE_MARKER=2,this.CHANGE_GUTTER=4,this.CHANGE_SCROLL=8,this.CHANGE_LINES=16,this.CHANGE_TEXT=32,this.CHANGE_SIZE=64,this.CHANGE_MARKER_BACK=128,this.CHANGE_MARKER_FRONT=256,this.CHANGE_FULL=512,this.CHANGE_H_SCROLL=1024,p.implement(this,d),this.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin(),a.setStyle(this.scroller.style,"line-height",this.lineHeight+"px")},this.setSession=function(u){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),(this.session=u)&&this.scrollMargin.top&&u.getScrollTop()<=0&&u.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(u),this.$markerBack.setSession(u),this.$markerFront.setSession(u),this.$gutterLayer.setSession(u),this.$textLayer.setSession(u),u&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},this.updateLines=function(u,y,w){if(y===void 0&&(y=1/0),this.$changedLines?(this.$changedLines.firstRow>u&&(this.$changedLines.firstRow=u),this.$changedLines.lastRow<y&&(this.$changedLines.lastRow=y)):this.$changedLines={firstRow:u,lastRow:y},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!w)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},this.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar(),this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)},this.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},this.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},this.updateFull=function(u){u?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},this.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},this.$changes=0,this.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},this.onResize=function(u,y,w,v){if(!(2<this.resizing)){0<this.resizing?this.resizing++:this.resizing=u?1:0;var T=this.container,T=(v=v||T.clientHeight||T.scrollHeight,w=w||T.clientWidth||T.scrollWidth,this.$updateCachedSize(u,y,w,v));if(!this.$size.scrollerHeight||!w&&!v)return this.resizing=0;u&&(this.$gutterLayer.$padding=null),u?this.$renderChanges(T|this.$changes,!0):this.$loop.schedule(T|this.$changes),this.resizing&&(this.resizing=0),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null}},this.$updateCachedSize=function(u,y,w,v){v-=this.$extraHeight||0;var T=0,B=this.$size,E={width:B.width,height:B.height,scrollerHeight:B.scrollerHeight,scrollerWidth:B.scrollerWidth};return v&&(u||B.height!=v)&&(B.height=v,T|=this.CHANGE_SIZE,B.scrollerHeight=B.height,this.$horizScroll&&(B.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",T|=this.CHANGE_SCROLL),w&&(u||B.width!=w)&&(T|=this.CHANGE_SIZE,B.width=w,y==null&&(y=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=y,a.setStyle(this.scrollBarH.element.style,"left",y+"px"),a.setStyle(this.scroller.style,"left",y+this.margin.left+"px"),B.scrollerWidth=Math.max(0,w-y-this.scrollBarV.getWidth()-this.margin.h),a.setStyle(this.$gutter.style,"left",this.margin.left+"px"),y=this.scrollBarV.getWidth()+"px",a.setStyle(this.scrollBarH.element.style,"right",y),a.setStyle(this.scroller.style,"right",y),a.setStyle(this.scroller.style,"bottom",this.scrollBarH.getHeight()),(this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||u)&&(T|=this.CHANGE_FULL)),B.$dirty=!w||!v,T&&this._signal("resize",E),T},this.onGutterResize=function(u){u=this.$showGutter?u:0,u!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,u,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()||this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):this.$computeLayerConfig()},this.adjustWrapLimit=function(){var u=this.$size.scrollerWidth-2*this.$padding,u=Math.floor(u/this.characterWidth);return this.session.adjustWrapLimit(u,this.$showPrintMargin&&this.$printMarginColumn)},this.setAnimatedScroll=function(u){this.setOption("animatedScroll",u)},this.getAnimatedScroll=function(){return this.$animatedScroll},this.setShowInvisibles=function(u){this.setOption("showInvisibles",u),this.session.$bidiHandler.setShowInvisibles(u)},this.getShowInvisibles=function(){return this.getOption("showInvisibles")},this.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")},this.setDisplayIndentGuides=function(u){this.setOption("displayIndentGuides",u)},this.getHighlightIndentGuides=function(){return this.getOption("highlightIndentGuides")},this.setHighlightIndentGuides=function(u){this.setOption("highlightIndentGuides",u)},this.setShowPrintMargin=function(u){this.setOption("showPrintMargin",u)},this.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},this.setPrintMarginColumn=function(u){this.setOption("printMarginColumn",u)},this.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},this.getShowGutter=function(){return this.getOption("showGutter")},this.setShowGutter=function(u){return this.setOption("showGutter",u)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.setFadeFoldWidgets=function(u){this.setOption("fadeFoldWidgets",u)},this.setHighlightGutterLine=function(u){this.setOption("highlightGutterLine",u)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.$updatePrintMargin=function(){var u;(this.$showPrintMargin||this.$printMarginEl)&&(this.$printMarginEl||((u=a.createElement("div")).className="ace_layer ace_print-margin-layer",this.$printMarginEl=a.createElement("div"),this.$printMarginEl.className="ace_print-margin",u.appendChild(this.$printMarginEl),this.content.insertBefore(u,this.content.firstChild)),(u=this.$printMarginEl.style).left=Math.round(this.characterWidth*this.$printMarginColumn+this.$padding)+"px",u.visibility=this.$showPrintMargin?"visible":"hidden",this.session&&this.session.$wrap==-1&&this.adjustWrapLimit())},this.getContainerElement=function(){return this.container},this.getMouseEventTarget=function(){return this.scroller},this.getTextAreaContainer=function(){return this.container},this.$moveTextAreaToCursor=function(){var u,y,w,v,T,B,E;this.$isMousePressed||(u=this.textarea.style,B=this.$composition,this.$keepTextAreaAtCursor||B?(w=this.$cursorLayer.$pixelPos)&&(B&&B.markerRange&&(w=this.$cursorLayer.getPixelPosition(B.markerRange.start,!0)),E=this.layerConfig,y=w.top,w=w.left,y-=E.offset,v=B&&B.useTextareaForIME?this.lineHeight:h?0:1,y<0||y>E.height-v?a.translate(this.textarea,0,0):(E=1,T=this.$size.height-v,B?B.useTextareaForIME?(B=this.textarea.value,E=this.characterWidth*this.session.$getStringScreenWidth(B)[0]):y+=this.lineHeight+2:y+=this.lineHeight,(w-=this.scrollLeft)>this.$size.scrollerWidth-E&&(w=this.$size.scrollerWidth-E),w+=this.gutterWidth+this.margin.left,a.setStyle(u,"height",v+"px"),a.setStyle(u,"width",E+"px"),a.translate(this.textarea,Math.min(w,this.$size.scrollerWidth-E),Math.min(y,T)))):a.translate(this.textarea,-100,0))},this.getFirstVisibleRow=function(){return this.layerConfig.firstRow},this.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(this.layerConfig.offset===0?0:1)},this.getLastFullyVisibleRow=function(){var u=this.layerConfig,y=u.lastRow;return this.session.documentToScreenRow(y,0)*u.lineHeight-this.session.getScrollTop()>u.height-u.lineHeight?y-1:y},this.getLastVisibleRow=function(){return this.layerConfig.lastRow},this.$padding=null,this.setPadding=function(u){this.$padding=u,this.$textLayer.setPadding(u),this.$cursorLayer.setPadding(u),this.$markerFront.setPadding(u),this.$markerBack.setPadding(u),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},this.setScrollMargin=function(u,y,w,v){var T=this.scrollMargin;T.top=0|u,T.bottom=0|y,T.right=0|v,T.left=0|w,T.v=T.top+T.bottom,T.h=T.left+T.right,T.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-T.top),this.updateFull()},this.setMargin=function(u,y,w,v){var T=this.margin;T.top=0|u,T.bottom=0|y,T.right=0|v,T.left=0|w,T.v=T.top+T.bottom,T.h=T.left+T.right,this.$updateCachedSize(!0,this.gutterWidth,this.$size.width,this.$size.height),this.updateFull()},this.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},this.setHScrollBarAlwaysVisible=function(u){this.setOption("hScrollBarAlwaysVisible",u)},this.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible},this.setVScrollBarAlwaysVisible=function(u){this.setOption("vScrollBarAlwaysVisible",u)},this.$updateScrollBarV=function(){var u=this.layerConfig.maxHeight,y=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(u-=(y-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>u-y&&(u=this.scrollTop+y,this.scrollBarV.scrollTop=null)),this.scrollBarV.setScrollHeight(u+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},this.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},this.$frozen=!1,this.freeze=function(){this.$frozen=!0},this.unfreeze=function(){this.$frozen=!1},this.$renderChanges=function(u,y){if(this.$changes&&(u|=this.$changes,this.$changes=0),this.session&&this.container.offsetWidth&&!this.$frozen&&(u||y)){if(this.$size.$dirty)return this.$changes|=u,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender",u),this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var w,v,y=this.layerConfig;(u&this.CHANGE_FULL||u&this.CHANGE_SIZE||u&this.CHANGE_TEXT||u&this.CHANGE_LINES||u&this.CHANGE_SCROLL||u&this.CHANGE_H_SCROLL)&&(u|=this.$computeLayerConfig()|this.$loop.clear(),y.firstRow!=this.layerConfig.firstRow&&y.firstRowScreen==this.layerConfig.firstRowScreen&&0<(w=this.scrollTop+(y.firstRow-this.layerConfig.firstRow)*this.lineHeight)&&(this.scrollTop=w,u=(u|=this.CHANGE_SCROLL)|(this.$computeLayerConfig()|this.$loop.clear())),y=this.layerConfig,this.$updateScrollBarV(),u&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),a.translate(this.content,-this.scrollLeft,-y.offset),w=y.width+2*this.$padding+"px",v=y.minHeight+"px",a.setStyle(this.content.style,"width",w),a.setStyle(this.content.style,"height",v)),u&this.CHANGE_H_SCROLL&&(a.translate(this.content,-this.scrollLeft,-y.offset),this.scroller.className=this.scrollLeft<=0?"ace_scroller":"ace_scroller ace_scroll-left"),u&this.CHANGE_FULL?(this.$changedLines=null,this.$textLayer.update(y),this.$showGutter&&this.$gutterLayer.update(y),this.$markerBack.update(y),this.$markerFront.update(y),this.$cursorLayer.update(y),this.$moveTextAreaToCursor()):u&this.CHANGE_SCROLL?(this.$changedLines=null,u&this.CHANGE_TEXT||u&this.CHANGE_LINES?this.$textLayer.update(y):this.$textLayer.scrollLines(y),this.$showGutter&&(u&this.CHANGE_GUTTER||u&this.CHANGE_LINES?this.$gutterLayer.update(y):this.$gutterLayer.scrollLines(y)),this.$markerBack.update(y),this.$markerFront.update(y),this.$cursorLayer.update(y),this.$moveTextAreaToCursor()):(u&this.CHANGE_TEXT?(this.$changedLines=null,this.$textLayer.update(y),this.$showGutter&&this.$gutterLayer.update(y)):u&this.CHANGE_LINES?(this.$updateLines()||u&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(y):u&this.CHANGE_TEXT||u&this.CHANGE_GUTTER?this.$showGutter&&this.$gutterLayer.update(y):u&this.CHANGE_CURSOR&&this.$highlightGutterLine&&this.$gutterLayer.updateLineHighlight(y),u&this.CHANGE_CURSOR&&(this.$cursorLayer.update(y),this.$moveTextAreaToCursor()),u&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(y),u&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(y)),this._signal("afterRender",u)}else this.$changes|=u},this.$autosize=function(){var u=this.session.getScreenLength()*this.lineHeight,y=this.$maxLines*this.lineHeight,w=Math.min(y,Math.max((this.$minLines||1)*this.lineHeight,u))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(w+=this.scrollBarH.getHeight()),y=!((w=this.$maxPixelHeight&&w>this.$maxPixelHeight?this.$maxPixelHeight:w)<=2*this.lineHeight)&&y<u,w==this.desiredHeight&&this.$size.height==this.desiredHeight&&y==this.$vScroll||(y!=this.$vScroll&&(this.$vScroll=y,this.scrollBarV.setVisible(y)),u=this.container.clientWidth,this.container.style.height=w+"px",this.$updateCachedSize(!0,this.$gutterWidth,u,w),this.desiredHeight=w,this._signal("autosize"))},this.$computeLayerConfig=function(){var u,Y=this.session,y=this.$size,z=y.height<=2*this.lineHeight,w=this.session.getScreenLength()*this.lineHeight,v=this.$getLongestLine(),P=!z&&(this.$hScrollBarAlwaysVisible||y.scrollerWidth-v-2*this.$padding<0),T=this.$horizScroll!==P,P=(T&&(this.$horizScroll=P,this.scrollBarH.setVisible(P)),this.$vScroll),B=(this.$maxLines&&1<this.lineHeight&&this.$autosize(),y.scrollerHeight+this.lineHeight),E=!this.$maxLines&&this.$scrollPastEnd?(y.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0,_=(w+=E,this.scrollMargin),z=(this.session.setScrollTop(Math.max(-_.top,Math.min(this.scrollTop,w-y.scrollerHeight+_.bottom))),this.session.setScrollLeft(Math.max(-_.left,Math.min(this.scrollLeft,v+2*this.$padding-y.scrollerWidth+_.right))),!z&&(this.$vScrollBarAlwaysVisible||y.scrollerHeight-w+E<0||this.scrollTop>_.top)),E=P!==z,_=(E&&(this.$vScroll=z,this.scrollBarV.setVisible(z)),this.scrollTop%this.lineHeight),P=Math.ceil(B/this.lineHeight)-1,P=(z=Math.max(0,Math.round((this.scrollTop-_)/this.lineHeight)))+P,H=this.lineHeight,z=Y.screenToDocumentRow(z,0),K=Y.getFoldLine(z),Y=(K&&(z=K.start.row),K=Y.documentToScreenRow(z,0),u=Y.getRowLength(z)*H,P=Math.min(Y.screenToDocumentRow(P,0),Y.getLength()-1),B=y.scrollerHeight+Y.getRowLength(P)*H+u,_=this.scrollTop-K*H,0);return this.layerConfig.width==v&&!T||(Y=this.CHANGE_H_SCROLL),(T||E)&&(Y|=this.$updateCachedSize(!0,this.gutterWidth,y.width,y.height),this._signal("scrollbarVisibilityChanged"),E&&(v=this.$getLongestLine())),this.layerConfig={width:v,padding:this.$padding,firstRow:z,firstRowScreen:K,lastRow:P,lineHeight:H,characterWidth:this.characterWidth,minHeight:B,maxHeight:w,offset:_,gutterOffset:H?Math.max(0,Math.ceil((_+y.height-y.scrollerHeight)/H)):0,height:this.$size.scrollerHeight},this.session.$bidiHandler&&this.session.$bidiHandler.setContentWidth(v-this.$padding),Y},this.$updateLines=function(){if(this.$changedLines){var u=this.$changedLines.firstRow,y=this.$changedLines.lastRow,w=(this.$changedLines=null,this.layerConfig);if(!(u>w.lastRow+1||y<w.firstRow)){if(y!==1/0)return this.$textLayer.updateLines(w,u,y),!0;this.$showGutter&&this.$gutterLayer.update(w),this.$textLayer.update(w)}}},this.$getLongestLine=function(){var u=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(u+=1),this.$textLayer&&u>this.$textLayer.MAX_LINE_LENGTH&&(u=this.$textLayer.MAX_LINE_LENGTH+30),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(u*this.characterWidth))},this.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},this.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},this.addGutterDecoration=function(u,y){this.$gutterLayer.addGutterDecoration(u,y)},this.removeGutterDecoration=function(u,y){this.$gutterLayer.removeGutterDecoration(u,y)},this.updateBreakpoints=function(u){this.$loop.schedule(this.CHANGE_GUTTER)},this.setAnnotations=function(u){this.$gutterLayer.setAnnotations(u),this.$loop.schedule(this.CHANGE_GUTTER)},this.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},this.hideCursor=function(){this.$cursorLayer.hideCursor()},this.showCursor=function(){this.$cursorLayer.showCursor()},this.scrollSelectionIntoView=function(u,y,w){this.scrollCursorIntoView(u,w),this.scrollCursorIntoView(y,w)},this.scrollCursorIntoView=function(u,y,w){var v,T,B;this.$size.scrollerHeight!==0&&(v=(u=this.$cursorLayer.getPixelPosition(u)).left,u=u.top,B=w&&w.top||0,w=w&&w.bottom||0,u<(T=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop)+B?(y&&T+B>u+this.lineHeight&&(u-=y*this.$size.scrollerHeight),u===0&&(u=-this.scrollMargin.top),this.session.setScrollTop(u)):T+this.$size.scrollerHeight-w<u+this.lineHeight&&(y&&T+this.$size.scrollerHeight-w<u-this.lineHeight&&(u+=y*this.$size.scrollerHeight),this.session.setScrollTop(u+this.lineHeight+w-this.$size.scrollerHeight)),v<(B=this.scrollLeft)?(v<this.$padding+2*this.layerConfig.characterWidth&&(v=-this.scrollMargin.left),this.session.setScrollLeft(v)):B+this.$size.scrollerWidth<v+this.characterWidth?this.session.setScrollLeft(Math.round(v+this.characterWidth-this.$size.scrollerWidth)):B<=this.$padding&&v-B<this.characterWidth&&this.session.setScrollLeft(0))},this.getScrollTop=function(){return this.session.getScrollTop()},this.getScrollLeft=function(){return this.session.getScrollLeft()},this.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},this.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},this.scrollToRow=function(u){this.session.setScrollTop(u*this.lineHeight)},this.alignCursor=function(v,y){var v=this.$cursorLayer.getPixelPosition(v=typeof v=="number"?{row:v,column:0}:v),w=this.$size.scrollerHeight-this.lineHeight,v=v.top-w*(y||0);return this.session.setScrollTop(v),v},this.STEPS=8,this.$calcSteps=function(u,y){for(var w,v,E=0,T=this.STEPS,B=[],E=0;E<T;++E)B.push((w=E/this.STEPS,(y-(v=u))*(Math.pow(w-1,3)+1)+v));return B},this.scrollToLine=function(u,y,w,v){u=this.$cursorLayer.getPixelPosition({row:u,column:0}).top,y&&(u-=this.$size.scrollerHeight/2),y=this.scrollTop,this.session.setScrollTop(u),w!==!1&&this.animateScrolling(y,v)},this.animateScrolling=function(u,y){var w=this.scrollTop;if(this.$animatedScroll){var v=this;if(u!=w){if(this.$scrollAnimation){var T=this.$scrollAnimation.steps;if(T.length&&(u=T[0])==w)return}var B=v.$calcSteps(u,w);this.$scrollAnimation={from:u,to:w,steps:B},clearInterval(this.$timer),v.session.setScrollTop(B.shift()),v.session.$scrollTop=w,this.$timer=setInterval(function(){if(!v.session)return clearInterval(v.$timer);B.length?(v.session.setScrollTop(B.shift()),v.session.$scrollTop=w):w!=null?(v.session.$scrollTop=-1,v.session.setScrollTop(w),w=null):(v.$timer=clearInterval(v.$timer),v.$scrollAnimation=null,y&&y())},10)}}},this.scrollToY=function(u){this.scrollTop!==u&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=u)},this.scrollToX=function(u){this.scrollLeft!==u&&(this.scrollLeft=u),this.$loop.schedule(this.CHANGE_H_SCROLL)},this.scrollTo=function(u,y){this.session.setScrollTop(y),this.session.setScrollLeft(u)},this.scrollBy=function(u,y){y&&this.session.setScrollTop(this.session.getScrollTop()+y),u&&this.session.setScrollLeft(this.session.getScrollLeft()+u)},this.isScrollableBy=function(u,y){return y<0&&this.session.getScrollTop()>=1-this.scrollMargin.top||0<y&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||u<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left||0<u&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right||void 0},this.pixelToScreenCoordinates=function(v,T){this.$hasCssTransforms?(B={top:0,left:0},v=(w=this.$fontMetrics.transformCoordinates([v,T]))[1]-this.gutterWidth-this.margin.left,T=w[0]):B=this.scroller.getBoundingClientRect();var w=v+this.scrollLeft-B.left-this.$padding,v=w/this.characterWidth,T=Math.floor((T+this.scrollTop-B.top)/this.lineHeight),B=this.$blockCursor?Math.floor(v):Math.round(v);return{row:T,column:B,side:0<v-B?1:-1,offsetX:w}},this.screenToTextCoordinates=function(T,B){this.$hasCssTransforms?(w={top:0,left:0},T=(v=this.$fontMetrics.transformCoordinates([T,B]))[1]-this.gutterWidth-this.margin.left,B=v[0]):w=this.scroller.getBoundingClientRect();var w,v=T+this.scrollLeft-w.left-this.$padding,T=v/this.characterWidth,T=this.$blockCursor?Math.floor(T):Math.round(T),B=Math.floor((B+this.scrollTop-w.top)/this.lineHeight);return this.session.screenToDocumentPosition(B,Math.max(T,0),v)},this.textToScreenCoordinates=function(v,T){var w=this.scroller.getBoundingClientRect(),T=this.session.documentToScreenPosition(v,T),v=this.$padding+(this.session.$bidiHandler.isBidiRow(T.row,v)?this.session.$bidiHandler.getPosLeft(T.column):Math.round(T.column*this.characterWidth)),T=T.row*this.lineHeight;return{pageX:w.left+v-this.scrollLeft,pageY:w.top+T-this.scrollTop}},this.visualizeFocus=function(){a.addCssClass(this.container,"ace_focus")},this.visualizeBlur=function(){a.removeCssClass(this.container,"ace_focus")},this.showComposition=function(u){(this.$composition=u).cssText||(u.cssText=this.textarea.style.cssText),u.useTextareaForIME==null&&(u.useTextareaForIME=this.$useTextareaForIME),this.$useTextareaForIME?(a.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor(),this.$cursorLayer.element.style.display="none"):u.markerId=this.session.addMarker(u.markerRange,"ace_composition_marker","text")},this.setCompositionText=function(u){var y=this.session.selection.cursor;this.addToken(u,"composition_placeholder",y.row,y.column),this.$moveTextAreaToCursor()},this.hideComposition=function(){var u;this.$composition&&(this.$composition.markerId&&this.session.removeMarker(this.$composition.markerId),a.removeCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText=this.$composition.cssText,u=this.session.selection.cursor,this.removeExtraToken(u.row,u.column),this.$composition=null,this.$cursorLayer.element.style.display="")},this.addToken=function(u,y,w,v){var T=this.session,B=(T.bgTokenizer.lines[w]=null,{type:y,value:u}),E=T.getTokens(w);if(v==null)E.push(B);else for(var _=0,P=0;P<E.length;P++){var H=E[P];if(v<=(_+=H.value.length)){var K=H.value.length-(_-v),z=H.value.slice(0,K),K=H.value.slice(K);E.splice(P,1,{type:H.type,value:z},B,{type:H.type,value:K});break}}this.updateLines(w,w)},this.removeExtraToken=function(u,y){this.updateLines(u,u)},this.setTheme=function(u,y){var w,v=this;function T(B){if(v.$themeId!=u)return y&&y();if(!B||!B.cssClass)throw new Error("couldn't load module "+u+" or it didn't call define");B.$id&&(v.$themeId=B.$id),a.importCssString(B.cssText,B.cssClass,v.container),v.theme&&a.removeCssClass(v.container,v.theme.cssClass);var E="padding"in B?B.padding:"padding"in(v.theme||{})?4:v.$padding;v.$padding&&E!=v.$padding&&v.setPadding(E),v.$theme=B.cssClass,v.theme=B,a.addCssClass(v.container,B.cssClass),a.setCssClass(v.container,"ace_dark",B.isDark),v.$size&&(v.$size.width=0,v.$updateSizeAsync()),v._dispatchEvent("themeLoaded",{theme:B}),y&&y()}this.$themeId=u,v._dispatchEvent("themeChange",{theme:u}),u&&typeof u!="string"?T(u):(w=u||this.$options.theme.initialValue,l.loadModule(["theme",w],T))},this.getTheme=function(){return this.$themeId},this.setStyle=function(u,y){a.setCssClass(this.container,u,y!==!1)},this.unsetStyle=function(u){a.removeCssClass(this.container,u)},this.setCursorStyle=function(u){a.setStyle(this.scroller.style,"cursor",u)},this.setMouseCursor=function(u){a.setStyle(this.scroller.style,"cursor",u)},this.attachToShadowRoot=function(){a.importCssString(b,"ace_editor.css",this.container)},this.destroy=function(){this.freeze(),this.$fontMetrics.destroy(),this.$cursorLayer.destroy(),this.removeAllListeners(),this.container.textContent=""}}.call(x.prototype),l.defineOptions(x.prototype,"renderer",{animatedScroll:{initialValue:!1},showInvisibles:{set:function(u){this.$textLayer.setShowInvisibles(u)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{set:function(u){typeof u=="number"&&(this.$printMarginColumn=u),this.$showPrintMargin=!!u,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(u){this.$gutter.style.display=u?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},fadeFoldWidgets:{set:function(u){a.setCssClass(this.$gutter,"ace_fade-fold-widgets",u)},initialValue:!1},showFoldWidgets:{set:function(u){this.$gutterLayer.setShowFoldWidgets(u),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(u){this.$textLayer.setDisplayIndentGuides(u)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightIndentGuides:{set:function(u){this.$textLayer.setHighlightIndentGuides(u)==1?this.$textLayer.$highlightIndentGuide():this.$textLayer.$clearActiveIndentGuide(this.$textLayer.$lines.cells)},initialValue:!0},highlightGutterLine:{set:function(u){this.$gutterLayer.setHighlightGutterLine(u),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},hScrollBarAlwaysVisible:{set:function(u){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(u){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(u){typeof u=="number"&&(u+="px"),this.container.style.fontSize=u,this.updateFontSize()},initialValue:12},fontFamily:{set:function(u){this.container.style.fontFamily=u,this.updateFontSize()}},maxLines:{set:function(u){this.updateFull()}},minLines:{set:function(u){this.$minLines<562949953421311||(this.$minLines=0),this.updateFull()}},maxPixelHeight:{set:function(u){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(u){this.$scrollPastEnd!=(u=+u||0)&&(this.$scrollPastEnd=u,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(u){this.$gutterLayer.$fixedWidth=!!u,this.$loop.schedule(this.CHANGE_GUTTER)}},theme:{set:function(u){this.setTheme(u)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0},hasCssTransforms:{},useTextareaForIME:{initialValue:!I.isMobile&&!I.isIE}}),m.VirtualRenderer=x}),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],function(C,m,A){var x=C("../lib/oop"),p=C("../lib/net"),a=C("../lib/event_emitter").EventEmitter,l=C("../config");function n(t){var e;return typeof Worker>"u"?{postMessage:function(){},terminate:function(){}}:l.get("loadWorkerFromBlob")?(e=function(r){r="importScripts('"+p.qualifyURL(r)+"');";try{return new Blob([r],{type:"application/javascript"})}catch{var s=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder);return s.append(r),s.getBlob("application/javascript")}}(t),e=(window.URL||window.webkitURL).createObjectURL(e),new Worker(e)):new Worker(t)}function i(t){t.postMessage||(t=this.$createWorkerFromOldConfig.apply(this,arguments)),this.$worker=t,this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage}(function(){x.implement(this,a),this.$createWorkerFromOldConfig=function(t,e,r,s,o){var c,d;return C.nameToUrl&&!C.toUrl&&(C.toUrl=C.nameToUrl),l.get("packaged")||!C.toUrl?s=s||l.moduleUrl(e,"worker"):(c=this.$normalizePath,s=s||c(C.toUrl("ace/worker/worker.js",null,"_")),d={},t.forEach(function(b){d[b]=c(C.toUrl(b,null,"_").replace(/(\.js)?(\?.*)?$/,""))})),this.$worker=n(s),o&&this.send("importScripts",o),this.$worker.postMessage({init:!0,tlns:d,module:e,classname:r}),this.$worker},this.onMessage=function(t){var e=t.data;switch(e.type){case"event":this._signal(e.name,{data:e.data});break;case"call":var r=this.callbacks[e.id];r&&(r(e.data),delete this.callbacks[e.id]);break;case"error":this.reportError(e.data);break;case"log":window.console&&console.log&&console.log.apply(console,e.data)}},this.reportError=function(t){window.console&&console.error&&console.error(t)},this.$normalizePath=function(t){return p.qualifyURL(t)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(t,e){this.$worker.postMessage({command:t,args:e})},this.call=function(t,e,r){var s;r&&(s=this.callbackId++,this.callbacks[s]=r,e.push(s)),this.send(t,e)},this.emit=function(t,e){try{e.data&&e.data.err&&(e.data.err={message:e.data.err.message,stack:e.data.err.stack,code:e.data.err.code}),this.$worker&&this.$worker.postMessage({event:t,data:{data:e.data}})}catch(r){console.error(r.stack)}},this.attachToDocument=function(t){this.$doc&&this.terminate(),this.$doc=t,this.call("setValue",[t.getValue()]),t.on("change",this.changeListener,!0)},this.changeListener=function(t){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0)),t.action=="insert"?this.deltaQueue.push(t.start,t.lines):this.deltaQueue.push(t.start,t.end)},this.$sendDeltaQueue=function(){var t=this.deltaQueue;t&&(this.deltaQueue=null,50<t.length&&t.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:t}))}}).call(i.prototype),m.UIWorkerClient=function(t,e,r){var s=null,o=!1,c=Object.create(a),d=[],b=new i({messageBuffer:d,terminate:function(){},postMessage:function(h){d.push(h),s&&(o?setTimeout(I):I())}}),I=(b.setEmitSync=function(h){o=h},function(){var h=d.shift();h.command?s[h.command].apply(s,h.args):h.event&&c._signal(h.event,h.data)});return c.postMessage=function(h){b.onMessage({data:h})},c.callback=function(h,u){this.postMessage({type:"call",id:u,data:h})},c.emit=function(h,u){this.postMessage({type:"event",name:h,data:u})},l.loadModule(["worker",e],function(h){for(s=new h[r](c);d.length;)I()}),b},m.WorkerClient=i,m.createWorker=n}),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],function(C,m,A){function x(n,c,t,e,r,s){var o=this,c=(this.length=c,this.session=n,this.doc=n.getDocument(),this.mainClass=r,this.othersClass=s,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate,!0),this.$others=e,this.$onCursorChange=function(){setTimeout(function(){o.onCursorChange()})},this.$pos=t,n.getUndoManager().$undoStack||n.getUndoManager().$undostack||{length:-1});this.$undoStackDepth=c.length,this.setup(),n.selection.on("changeCursor",this.$onCursorChange)}var p=C("./range").Range,a=C("./lib/event_emitter").EventEmitter,l=C("./lib/oop");(function(){l.implement(this,a),this.setup=function(){var n=this,i=this.doc,t=this.session,e=(this.selectionBefore=t.selection.toJSON(),t.selection.inMultiSelectMode&&t.selection.toSingleRange(),this.pos=i.createAnchor(this.$pos.row,this.$pos.column),this.pos);e.$insertRight=!0,e.detach(),e.markerId=t.addMarker(new p(e.row,e.column,e.row,e.column+this.length),this.mainClass,null,!1),this.others=[],this.$others.forEach(function(r){r=i.createAnchor(r.row,r.column),r.$insertRight=!0,r.detach(),n.others.push(r)}),t.setUndoSelect(!1)},this.showOtherMarkers=function(){var n,i;this.othersActive||(n=this.session,(i=this).othersActive=!0,this.others.forEach(function(t){t.markerId=n.addMarker(new p(t.row,t.column,t.row,t.column+i.length),i.othersClass,null,!1)}))},this.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var n=0;n<this.others.length;n++)this.session.removeMarker(this.others[n].markerId)}},this.onUpdate=function(n){if(this.$updating)return this.updateAnchors(n);var i=n;if(i.start.row===i.end.row&&i.start.row===this.pos.row){this.$updating=!0;var t=n.action==="insert"?i.end.column-i.start.column:i.start.column-i.end.column,e=i.start.column>=this.pos.column&&i.start.column<=this.pos.column+this.length+1,r=i.start.column-this.pos.column;if(this.updateAnchors(n),e&&(this.length+=t),e&&!this.session.$fromUndo){if(n.action==="insert")for(var s=this.others.length-1;0<=s;s--){var o={row:(c=this.others[s]).row,column:c.column+r};this.doc.insertMergedLines(o,n.lines)}else if(n.action==="remove")for(s=this.others.length-1;0<=s;s--){var c,o={row:(c=this.others[s]).row,column:c.column+r};this.doc.remove(new p(o.row,o.column,o.row,o.column-t))}}this.$updating=!1,this.updateMarkers()}},this.updateAnchors=function(n){this.pos.onChange(n);for(var i=this.others.length;i--;)this.others[i].onChange(n);this.updateMarkers()},this.updateMarkers=function(){if(!this.$updating){var n=this,i=this.session,t=function(r,s){i.removeMarker(r.markerId),r.markerId=i.addMarker(new p(r.row,r.column,r.row,r.column+n.length),s,null,!1)};t(this.pos,this.mainClass);for(var e=this.others.length;e--;)t(this.others[e],this.othersClass)}},this.onCursorChange=function(n){var i;!this.$updating&&this.session&&((i=this.session.selection.getCursor()).row===this.pos.row&&i.column>=this.pos.column&&i.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",n)):(this.hideOtherMarkers(),this._emit("cursorLeave",n)))},this.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId),this.hideOtherMarkers(),this.doc.off("change",this.$onUpdate),this.session.selection.off("changeCursor",this.$onCursorChange),this.session.setUndoSelect(!0),this.session=null},this.cancel=function(){if(this.$undoStackDepth!==-1){for(var n=this.session.getUndoManager(),i=(n.$undoStack||n.$undostack).length-this.$undoStackDepth,t=0;t<i;t++)n.undo(this.session,!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}}}).call(x.prototype),m.PlaceHolder=x}),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(C,m,A){var x=C("../lib/event"),p=C("../lib/useragent");function a(l,n){return l.row==n.row&&l.column==n.column}m.onMouseDown=function(l){var n=l.domEvent,i=n.altKey,t=n.shiftKey,e=n.ctrlKey,r=l.getAccelKey(),s=l.getButton();if(e&&p.isMac&&(s=n.button),l.editor.inMultiSelectMode&&s==2)l.editor.textInput.onContextMenu(l.domEvent);else if(e||i||r){if(s===0){var o,c,d,b,I,h,u,y,w=l.editor,v=w.selection,T=w.inMultiSelectMode,B=l.getDocumentPosition(),E=v.getCursor(),E=l.inSelection()||v.isEmpty()&&a(B,E),_=l.x,P=l.y,H=w.session,z=w.renderer.pixelToScreenCoordinates(_,P),K=z;if(w.$mouseHandler.$enableJumpToDef)e&&i||r&&i?o=t?"block":"add":i&&w.$blockSelectEnabled&&(o="block");else if(r&&!i){if(o="add",!T&&t)return}else i&&w.$blockSelectEnabled&&(o="block");if(o&&p.isMac&&n.ctrlKey&&w.$mouseHandler.cancelContextMenu(),o=="add")!T&&E||(T||(c=v.toOrientedRange(),w.addSelectionMarker(c)),d=v.rangeList.rangeAtPoint(B),w.inVirtualSelectionMode=!0,t&&(d=null,c=v.ranges[0]||c,w.removeSelectionMarker(c)),w.once("mouseup",function(){var Y=v.toOrientedRange();d&&Y.isEmpty()&&a(d.cursor,Y.cursor)?v.substractPoint(Y.cursor):(t?v.substractPoint(c.cursor):c&&(w.removeSelectionMarker(c),v.addRange(c)),v.addRange(Y)),w.inVirtualSelectionMode=!1}));else if(o=="block")return l.stop(),w.inVirtualSelectionMode=!0,I=[],h=function(){var Y=w.renderer.pixelToScreenCoordinates(_,P),R=H.screenToDocumentPosition(Y.row,Y.column,Y.offsetX);a(K,Y)&&a(R,v.lead)||(K=Y,w.selection.moveToPosition(R),w.renderer.scrollCursorIntoView(),w.removeSelectionMarkers(I),I=v.rectangularRangeBlock(K,z),w.$mouseHandler.$clickSelection&&I.length==1&&I[0].isEmpty()&&(I[0]=w.$mouseHandler.$clickSelection.clone()),I.forEach(w.addSelectionMarker,w),w.updateSelectionMarkers())},T&&!r?v.toSingleRange():!T&&r&&(b=v.toOrientedRange(),w.addSelectionMarker(b)),t?z=H.documentToScreenPosition(v.lead):v.moveToPosition(B),K={row:-1,column:-1},u=h,x.capture(w.container,function(Y){_=Y.clientX,P=Y.clientY},function(Y){h(),clearInterval(y),w.removeSelectionMarkers(I),I.length||(I=[v.toOrientedRange()]),b&&(w.removeSelectionMarker(b),v.toSingleRange(b));for(var R=0;R<I.length;R++)v.addRange(I[R]);w.inVirtualSelectionMode=!1,w.$mouseHandler.$clickSelection=null}),y=setInterval(function(){u()},20),l.preventDefault()}}else s===0&&l.editor.inMultiSelectMode&&l.editor.exitMultiSelectMode()}}),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],function(C,m,A){m.defaultCommands=[{name:"addCursorAbove",description:"Add cursor above",exec:function(x){x.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",description:"Add cursor below",exec:function(x){x.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",description:"Add cursor above (skip current)",exec:function(x){x.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",description:"Add cursor below (skip current)",exec:function(x){x.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",description:"Select more before",exec:function(x){x.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",description:"Select more after",exec:function(x){x.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",description:"Select next before",exec:function(x){x.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",description:"Select next after",exec:function(x){x.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"toggleSplitSelectionIntoLines",description:"Split into lines",exec:function(x){1<x.multiSelect.rangeCount?x.multiSelect.joinSelections():x.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:!0},{name:"splitSelectionIntoLines",description:"Split into lines",exec:function(x){x.multiSelect.splitIntoLines()},readOnly:!0},{name:"alignCursors",description:"Align cursors",exec:function(x){x.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",description:"Find all",exec:function(x){x.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}],m.multiSelectCommands=[{name:"singleSelection",description:"Single selection",bindKey:"esc",exec:function(x){x.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(x){return x&&x.inMultiSelectMode}}],C=C("../keyboard/hash_handler").HashHandler,m.keyboardHandler=new C(m.multiSelectCommands)}),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],function(C,m,A){var x=C("./range_list").RangeList,p=C("./range").Range,a=C("./selection").Selection,l=C("./mouse/multi_select_handler").onMouseDown,n=C("./lib/event"),i=C("./lib/lang"),t=C("./commands/multi_select_commands");m.commands=t.defaultCommands.concat(t.multiSelectCommands);var e=new(C("./search")).Search,r=C("./edit_session").EditSession,r=(function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}.call(r.prototype),function(){this.ranges=null,this.rangeList=null,this.addRange=function(o,c){if(o){if(!this.inMultiSelectMode&&this.rangeCount===0){var d=this.toOrientedRange();if(this.rangeList.add(d),this.rangeList.add(o),this.rangeList.ranges.length!=2)return this.rangeList.removeAll(),c||this.fromOrientedRange(o);this.rangeList.removeAll(),this.rangeList.add(d),this.$onAddRange(d)}return o.cursor||(o.cursor=o.end),d=this.rangeList.add(o),this.$onAddRange(o),d.length&&this.$onRemoveRange(d),1<this.rangeCount&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),c||this.fromOrientedRange(o)}},this.toSingleRange=function(o){o=o||this.ranges[0];var c=this.rangeList.removeAll();c.length&&this.$onRemoveRange(c),o&&this.fromOrientedRange(o)},this.substractPoint=function(o){if(o=this.rangeList.substractPoint(o),o)return this.$onRemoveRange(o),o[0]},this.mergeOverlappingRanges=function(){var o=this.rangeList.merge();o.length&&this.$onRemoveRange(o)},this.$onAddRange=function(o){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(o),this._signal("addRange",{range:o})},this.$onRemoveRange=function(o){var c;this.rangeCount=this.rangeList.ranges.length,this.rangeCount==1&&this.inMultiSelectMode&&(c=this.rangeList.ranges.pop(),o.push(c),this.rangeCount=0);for(var d=o.length;d--;){var b=this.ranges.indexOf(o[d]);this.ranges.splice(b,1)}this._signal("removeRange",{ranges:o}),this.rangeCount===0&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),(c=c||this.ranges[0])&&!c.isEqual(this.getRange())&&this.fromOrientedRange(c)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new x,this.ranges=[],this.rangeCount=0)},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){for(var o=this.ranges.length?this.ranges:[this.getRange()],c=[],d=0;d<o.length;d++){var b=o[d],I=b.start.row,h=b.end.row;if(I===h)c.push(b.clone());else{for(c.push(new p(I,b.start.column,I,this.session.getLine(I).length));++I<h;)c.push(this.getLineRange(I,!0));c.push(new p(h,0,h,b.end.column))}d!=0||this.isBackwards()||(c=c.reverse())}for(this.toSingleRange(),d=c.length;d--;)this.addRange(c[d])},this.joinSelections=function(){var c=this.rangeList.ranges,o=c[c.length-1],c=p.fromPoints(c[0].start,o.end);this.toSingleRange(),this.setSelectionRange(c,o.cursor==o.start)},this.toggleBlockSelection=function(){var o,c;1<this.rangeCount?(c=(o=this.rangeList.ranges)[o.length-1],o=p.fromPoints(o[0].start,c.end),this.toSingleRange(),this.setSelectionRange(o,c.cursor==c.start)):(o=this.session.documentToScreenPosition(this.cursor),c=this.session.documentToScreenPosition(this.anchor),this.rectangularRangeBlock(o,c).forEach(this.addRange,this))},this.rectangularRangeBlock=function(o,c,d){var b,I,h,u,y,w,v,T=[],B=o.column<c.column,E=(u=(B?(b=o.column,I=c.column,h=o.offsetX,c):(b=c.column,I=o.column,h=c.offsetX,o)).offsetX,o.row<c.row);w=(E?(y=o.row,c):(y=c.row,o)).row,b<0&&(b=0),(y=y<0?0:y)==w&&(d=!0);for(var _,P,H=y;H<=w;H++){var z=p.fromPoints(this.session.screenToDocumentPosition(H,b,h),this.session.screenToDocumentPosition(H,I,u));if(z.isEmpty()){if(v&&(_=z.end,P=v,_.row==P.row&&_.column==P.column))break;v=z.end}z.cursor=B?z.start:z.end,T.push(z)}if(E&&T.reverse(),!d){for(var K=T.length-1;T[K].isEmpty()&&0<K;)K--;if(0<K)for(var Y=0;T[Y].isEmpty();)Y++;for(var R=K;Y<=R;R--)T[R].isEmpty()&&T.splice(R,1)}return T}}.call(a.prototype),C("./editor").Editor);function s(o){var c,d;function b(I){d&&(c.renderer.setMouseCursor(""),d=!1)}o.$multiselectOnSessionChange||(o.$onAddRange=o.$onAddRange.bind(o),o.$onRemoveRange=o.$onRemoveRange.bind(o),o.$onMultiSelect=o.$onMultiSelect.bind(o),o.$onSingleSelect=o.$onSingleSelect.bind(o),o.$multiselectOnSessionChange=m.onSessionChange.bind(o),o.$checkMultiselectChange=o.$checkMultiselectChange.bind(o),o.$multiselectOnSessionChange(o),o.on("changeSession",o.$multiselectOnSessionChange),o.on("mousedown",l),o.commands.addCommands(t.defaultCommands),(c=o).textInput&&(o=c.textInput.getElement(),d=!1,n.addListener(o,"keydown",function(I){I=I.keyCode==18&&!(I.ctrlKey||I.shiftKey||I.metaKey),c.$blockSelectEnabled&&I?d||(c.renderer.setMouseCursor("crosshair"),d=!0):d&&b()},c),n.addListener(o,"keyup",b,c),n.addListener(o,"blur",b,c)))}(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(o){o.cursor||(o.cursor=o.end);var c=this.getSelectionStyle();return o.marker=this.session.addMarker(o,"ace_selection",c),this.session.$selectionMarkers.push(o),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,o},this.removeSelectionMarker=function(o){o.marker&&(this.session.removeMarker(o.marker),(o=this.session.$selectionMarkers.indexOf(o))!=-1&&this.session.$selectionMarkers.splice(o,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length)},this.removeSelectionMarkers=function(o){for(var c=this.session.$selectionMarkers,d=o.length;d--;){var b=o[d];b.marker&&(this.session.removeMarker(b.marker),(b=c.indexOf(b))!=-1&&c.splice(b,1))}this.session.selectionMarkerCount=c.length},this.$onAddRange=function(o){this.addSelectionMarker(o.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(o){this.removeSelectionMarkers(o.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(o){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(t.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(o){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(t.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(o){var c,d=o.command,b=o.editor;if(b.multiSelect)return d.multiSelectAction?c=d.multiSelectAction=="forEach"?b.forEachSelection(d,o.args):d.multiSelectAction=="forEachLine"?b.forEachSelection(d,o.args,!0):d.multiSelectAction=="single"?(b.exitMultiSelectMode(),d.exec(b,o.args||{})):d.multiSelectAction(b,o.args||{}):(c=d.exec(b,o.args||{}),b.multiSelect.addRange(b.multiSelect.toOrientedRange()),b.multiSelect.mergeOverlappingRanges()),c},this.forEachSelection=function(o,c,d){if(!this.inVirtualSelectionMode){var b,w=d&&d.keepOrder,I=d==1||d&&d.$byLines,h=this.session,d=this.selection,u=d.rangeList,y=(w?d:u).ranges;if(!y.length)return o.exec?o.exec(this,c||{}):o(this,c||{});var w=d._eventRegistry,v=(d._eventRegistry={},new a(h));this.inVirtualSelectionMode=!0;for(var T=y.length;T--;){if(I)for(;0<T&&y[T].start.row==y[T-1].end.row;)T--;v.fromOrientedRange(y[T]),v.index=T,this.selection=h.selection=v;var B=o.exec?o.exec(this,c||{}):o(this,c||{});b||B===void 0||(b=B),v.toOrientedRange(y[T])}return v.detach(),this.selection=h.selection=d,this.inVirtualSelectionMode=!1,d._eventRegistry=w,d.mergeOverlappingRanges(),d.ranges[0]&&d.fromOrientedRange(d.ranges[0]),u=this.renderer.$scrollAnimation,this.onCursorChange(),this.onSelectionChange(),u&&u.from==u.to&&this.renderer.animateScrolling(u.from),b}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var o="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var c=this.multiSelect.rangeList.ranges,d=[],b=0;b<c.length;b++)d.push(this.session.getTextRange(c[b]));var I=this.session.getDocument().getNewLineCharacter();(o=d.join(I)).length==(d.length-1)*I.length&&(o="")}else this.selection.isEmpty()||(o=this.session.getTextRange(this.getSelectionRange()));return o},this.$checkMultiselectChange=function(o,c){var d;this.inMultiSelectMode&&!this.inVirtualSelectionMode&&(d=this.multiSelect.ranges[0],this.multiSelect.isEmpty()&&c==this.multiSelect.anchor||((d=c==this.multiSelect.anchor?d.cursor==d.start?d.end:d.start:d.cursor).row!=c.row||this.session.$clipPositionToDocument(d.row,d.column).column!=c.column?this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange()):this.multiSelect.mergeOverlappingRanges()))},this.findAll=function(o,c,d){(c=c||{}).needle=o||c.needle,c.needle==null&&(b=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange(),c.needle=this.session.getTextRange(b)),this.$search.set(c);var b,I=this.$search.findAll(this.session);if(!I.length)return 0;var h=this.multiSelect;d||h.toSingleRange(I[0]);for(var u=I.length;u--;)h.addRange(I[u],!0);return b&&h.rangeList.rangeAtPoint(b.start)&&h.addRange(b,!0),I.length},this.selectMoreLines=function(o,c){var d,b,I,h=this.selection.toOrientedRange(),u=h.cursor==h.end,y=this.session.documentToScreenPosition(h.cursor),w=(this.selection.$desiredColumn&&(y.column=this.selection.$desiredColumn),this.session.screenToDocumentPosition(y.row+o,y.column));o=h.isEmpty()?w:(d=this.session.documentToScreenPosition(u?h.end:h.start),this.session.screenToDocumentPosition(d.row+o,d.column)),u?(b=p.fromPoints(w,o)).cursor=b.start:(b=p.fromPoints(o,w)).cursor=b.end,b.desiredColumn=y.column,this.selection.inMultiSelectMode?c&&(I=h.cursor):this.selection.addRange(h),this.selection.addRange(b),I&&this.selection.substractPoint(I)},this.transposeSelections=function(o){for(var c=this.session,d=c.multiSelect,b=d.ranges,I=b.length;I--;)(u=b[I]).isEmpty()&&(y=c.getWordRange(u.start.row,u.start.column),u.start.row=y.start.row,u.start.column=y.start.column,u.end.row=y.end.row,u.end.column=y.end.column);d.mergeOverlappingRanges();for(var h=[],I=b.length;I--;){var u=b[I];h.unshift(c.getTextRange(u))}for(o<0?h.unshift(h.pop()):h.push(h.shift()),I=b.length;I--;){var y=(u=b[I]).clone();c.replace(u,h[I]),u.start.row=y.start.row,u.start.column=y.start.column}d.fromOrientedRange(d.ranges[0])},this.selectMore=function(o,c,d){var b,I=this.session,h=I.multiSelect.toOrientedRange();h.isEmpty()&&((h=I.getWordRange(h.start.row,h.start.column)).cursor=o==-1?h.start:h.end,this.multiSelect.addRange(h),d)||(d=I.getTextRange(h),I=I,d=d,b=o,e.$options.wrap=!0,e.$options.needle=d,e.$options.backwards=b==-1,(d=e.find(I))&&(d.cursor=o==-1?d.start:d.end,this.session.unfold(d),this.multiSelect.addRange(d),this.renderer.scrollCursorIntoView(null,.5)),c&&this.multiSelect.substractPoint(h.cursor))},this.alignCursors=function(){var o=this.session,c=o.multiSelect,d=c.ranges,b=-1,I=d.filter(function(_){if(_.cursor.row==b)return!0;b=_.cursor.row});if(d.length&&I.length!=d.length-1){I.forEach(function(_){c.substractPoint(_.cursor)});var h=0,u=1/0,y=d.map(function(P){var P=P.cursor,H=o.getLine(P.row).substr(P.column).search(/\S/g);return P.column>h&&(h=P.column),(H=H==-1?0:H)<u&&(u=H),H});d.forEach(function(_,K){var H=_.cursor,z=h-H.column,K=y[K]-u;K<z?o.insert(H,i.stringRepeat(" ",z-K)):o.remove(new p(H.row,H.column,H.row,H.column-z+K)),_.start.column=_.end.column=h,_.start.row=_.end.row=H.row,_.cursor=_.end}),c.fromOrientedRange(d[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var I=this.selection.getRange(),w=I.start.row,v=I.end.row,d=w==v;if(d){for(var T,B=this.session.getLength();T=this.session.getLine(v),/[=:]/.test(T)&&++v<B;);for(;T=this.session.getLine(w),/[=:]/.test(T)&&0<--w;);w<0&&(w=0),B<=v&&(v=B-1)}var E=this.session.removeFullLines(w,v),E=this.$reAlignText(E,d);this.session.insert({row:w,column:0},E.join(`
`)+`
`),d||(I.start.column=0,I.end.column=E[E.length-1].length),this.selection.setRange(I)}},this.$reAlignText=function(o,c){var d,b,I,h=!0,u=!0;return o.map(function(v){var T=v.match(/(\s*)(.*?)(\s*)([=:].*)/);return T?(d==null?(d=T[1].length,b=T[2].length,I=T[3].length):(d+b+I!=T[1].length+T[2].length+T[3].length&&(u=!1),d!=T[1].length&&(h=!1),d>T[1].length&&(d=T[1].length),b<T[2].length&&(b=T[2].length),I>T[3].length&&(I=T[3].length)),T):[v]}).map(c?w:h?u?function(v){return v[2]?y(d+b-v[2].length)+v[2]+y(I)+v[4].replace(/^([=:])\s+/,"$1 "):v[0]}:w:function(v){return v[2]?y(d)+v[2]+y(I)+v[4].replace(/^([=:])\s+/,"$1 "):v[0]});function y(v){return i.stringRepeat(" ",v)}function w(v){return v[2]?y(d)+v[2]+y(b-v[2].length+I)+v[4].replace(/^([=:])\s+/,"$1 "):v[0]}}}).call(r.prototype),m.onSessionChange=function(d){var c=d.session,d=(c&&!c.multiSelect&&(c.$selectionMarkers=[],c.selection.$initRangeList(),c.multiSelect=c.selection),this.multiSelect=c&&c.multiSelect,d.oldSession);d&&(d.multiSelect.off("addRange",this.$onAddRange),d.multiSelect.off("removeRange",this.$onRemoveRange),d.multiSelect.off("multiSelect",this.$onMultiSelect),d.multiSelect.off("singleSelect",this.$onSingleSelect),d.multiSelect.lead.off("change",this.$checkMultiselectChange),d.multiSelect.anchor.off("change",this.$checkMultiselectChange)),c&&(c.multiSelect.on("addRange",this.$onAddRange),c.multiSelect.on("removeRange",this.$onRemoveRange),c.multiSelect.on("multiSelect",this.$onMultiSelect),c.multiSelect.on("singleSelect",this.$onSingleSelect),c.multiSelect.lead.on("change",this.$checkMultiselectChange),c.multiSelect.anchor.on("change",this.$checkMultiselectChange)),c&&this.inMultiSelectMode!=c.selection.inMultiSelectMode&&(c.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},m.MultiSelect=s,C("./config").defineOptions(r.prototype,"editor",{enableMultiselect:{set:function(o){s(this),o?(this.on("changeSession",this.$multiselectOnSessionChange),this.on("mousedown",l)):(this.off("changeSession",this.$multiselectOnSessionChange),this.off("mousedown",l))},value:!0},enableBlockSelect:{set:function(o){this.$blockSelectEnabled=o},value:!0}})}),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(p,m,A){var x=p("../../range").Range,p=m.FoldMode=function(){};(function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(a,l,n){return a=a.getLine(n),this.foldingStartMarker.test(a)?"start":l=="markbeginend"&&this.foldingStopMarker&&this.foldingStopMarker.test(a)?"end":""},this.getFoldWidgetRange=function(a,l,n){return null},this.indentationBlock=function(a,l,n){var i=/\S/,t=a.getLine(l),e=t.search(i);if(e!=-1){for(var r,n=n||t.length,s=a.getLength(),t=l,o=l;++l<s;){var c=a.getLine(l).search(i);if(c!=-1){if(c<=e&&(c=a.getTokenAt(l,0),!c||c.type!=="string"))break;o=l}}return t<o?(r=a.getLine(o).length,new x(t,n,o,r)):void 0}},this.openingBracketBlock=function(a,l,n,i,t){if(n={row:n,column:i+1},i=a.$findClosingBracket(l,n,t),i)return(l=(l=a.foldWidgets[i.row])==null?a.getFoldWidget(i.row):l)=="start"&&i.row>n.row&&(i.row--,i.column=a.getLine(i.row).length),x.fromPoints(n,i)},this.closingBracketBlock=function(a,l,n,i,t){if(n={row:n,column:i},i=a.$findOpeningBracket(l,n),i)return i.column++,n.column--,x.fromPoints(i,n)}}).call(p.prototype)}),ace.define("ace/line_widgets",["require","exports","module","ace/lib/dom"],function(C,m,A){var x=C("./lib/dom");function p(a){this.session=a,(this.session.widgetManager=this).session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeFold",this.updateOnFold),this.session.on("changeEditor",this.$onChangeEditor)}(function(){this.getRowLength=function(a){var l=this.lineWidgets&&this.lineWidgets[a]&&this.lineWidgets[a].rowCount||0;return this.$useWrapMode&&this.$wrapData[a]?this.$wrapData[a].length+1+l:1+l},this.$getWidgetScreenLength=function(){var a=0;return this.lineWidgets.forEach(function(l){l&&l.rowCount&&!l.hidden&&(a+=l.rowCount)}),a},this.$onChangeEditor=function(a){this.attach(a.editor)},this.attach=function(a){a&&a.widgetManager&&a.widgetManager!=this&&a.widgetManager.detach(),this.editor!=a&&(this.detach(),(this.editor=a)&&(a.widgetManager=this,a.renderer.on("beforeRender",this.measureWidgets),a.renderer.on("afterRender",this.renderWidgets)))},this.detach=function(a){var l=this.editor;l&&(this.editor=null,l.widgetManager=null,l.renderer.off("beforeRender",this.measureWidgets),l.renderer.off("afterRender",this.renderWidgets),(l=this.session.lineWidgets)&&l.forEach(function(n){n&&n.el&&n.el.parentNode&&(n._inDocument=!1,n.el.parentNode.removeChild(n.el))}))},this.updateOnFold=function(a,l){var n=l.lineWidgets;if(n&&a.action){for(var l=a.data,i=l.start.row,t=l.end.row,e=a.action=="add",r=i+1;r<t;r++)n[r]&&(n[r].hidden=e);n[t]&&(e?n[i]?n[t].hidden=e:n[i]=n[t]:(n[i]==n[t]&&(n[i]=void 0),n[t].hidden=e))}},this.updateOnChange=function(a){var l,n,i,t=this.session.lineWidgets;t&&(l=a.start.row,(n=a.end.row-l)!=0&&(a.action=="remove"?(i=t.splice(l+1,n),!t[l]&&i[i.length-1]&&(t[l]=i.pop()),i.forEach(function(e){e&&this.removeLineWidget(e)},this)):(i=new Array(n),t[l]&&t[l].column!=null&&a.start.column>t[l].column&&l++,i.unshift(l,0),t.splice.apply(t,i)),this.$updateRows()))},this.$updateRows=function(){var a,l=this.session.lineWidgets;l&&(a=!0,l.forEach(function(n,i){if(n)for(a=!1,n.row=i;n.$oldWidget;)n.$oldWidget.row=i,n=n.$oldWidget}),a&&(this.session.lineWidgets=null))},this.$registerLineWidget=function(a){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength()));var l=this.session.lineWidgets[a.row];return l&&(a.$oldWidget=l).el&&l.el.parentNode&&(l.el.parentNode.removeChild(l.el),l._inDocument=!1),this.session.lineWidgets[a.row]=a},this.addLineWidget=function(a){var l,n,i;return this.$registerLineWidget(a),a.session=this.session,this.editor&&(l=this.editor.renderer,a.html&&!a.el&&(a.el=x.createElement("div"),a.el.innerHTML=a.html),a.el&&(x.addCssClass(a.el,"ace_lineWidgetContainer"),a.el.style.position="absolute",a.el.style.zIndex=5,l.container.appendChild(a.el),a._inDocument=!0,a.coverGutter||(a.el.style.zIndex=3),a.pixelHeight==null&&(a.pixelHeight=a.el.offsetHeight)),a.rowCount==null&&(a.rowCount=a.pixelHeight/l.layerConfig.lineHeight),n=this.session.getFoldAt(a.row,0),(a.$fold=n)&&(i=this.session.lineWidgets,a.row!=n.end.row||i[n.start.row]?a.hidden=!0:i[n.start.row]=a),this.session._emit("changeFold",{data:{start:{row:a.row}}}),this.$updateRows(),this.renderWidgets(null,l),this.onWidgetChanged(a)),a},this.removeLineWidget=function(a){if(a._inDocument=!1,a.session=null,a.el&&a.el.parentNode&&a.el.parentNode.removeChild(a.el),a.editor&&a.editor.destroy)try{a.editor.destroy()}catch{}if(this.session.lineWidgets){var l=this.session.lineWidgets[a.row];if(l==a)this.session.lineWidgets[a.row]=a.$oldWidget,a.$oldWidget&&this.onWidgetChanged(a.$oldWidget);else for(;l;){if(l.$oldWidget==a){l.$oldWidget=a.$oldWidget;break}l=l.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:a.row}}}),this.$updateRows()},this.getWidgetsAtRow=function(a){for(var l=this.session.lineWidgets,n=l&&l[a],i=[];n;)i.push(n),n=n.$oldWidget;return i},this.onWidgetChanged=function(a){this.session._changedWidgets.push(a),this.editor&&this.editor.renderer.updateFull()},this.measureWidgets=function(a,l){var n=this.session._changedWidgets,i=l.layerConfig;if(n&&n.length){for(var t=1/0,e=0;e<n.length;e++){var r=n[e];if(r&&r.el&&r.session==this.session){if(!r._inDocument){if(this.session.lineWidgets[r.row]!=r)continue;r._inDocument=!0,l.container.appendChild(r.el)}r.h=r.el.offsetHeight,r.fixedWidth||(r.w=r.el.offsetWidth,r.screenWidth=Math.ceil(r.w/i.characterWidth));var s=r.h/i.lineHeight;r.coverLine&&(s-=this.session.getRowLineCount(r.row))<0&&(s=0),r.rowCount!=s&&(r.rowCount=s,r.row<t&&(t=r.row))}}t!=1/0&&(this.session._emit("changeFold",{data:{start:{row:t}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},this.renderWidgets=function(a,l){var n=l.layerConfig,i=this.session.lineWidgets;if(i){for(var t=Math.min(this.firstRow,n.firstRow),e=Math.max(this.lastRow,n.lastRow,i.length);0<t&&!i[t];)t--;this.firstRow=n.firstRow,this.lastRow=n.lastRow,l.$cursorLayer.config=n;for(var r=t;r<=e;r++){var s,o=i[r];o&&o.el&&(o.hidden?o.el.style.top=-100-(o.pixelHeight||0)+"px":(o._inDocument||(o._inDocument=!0,l.container.appendChild(o.el)),s=l.$cursorLayer.getPixelPosition({row:r,column:0},!0).top,o.coverLine||(s+=n.lineHeight*this.session.getRowLineCount(o.row)),o.el.style.top=s-n.offset+"px",s=o.coverGutter?0:l.gutterWidth,o.fixedWidth||(s-=l.scrollLeft),o.el.style.left=s+"px",o.fullWidth&&o.screenWidth&&(o.el.style.minWidth=n.width+2*n.padding+"px"),o.fixedWidth?o.el.style.right=l.scrollBar.getWidth()+"px":o.el.style.right=""))}}}}).call(p.prototype),m.LineWidgets=p}),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range"],function(C,m,A){var x=C("../line_widgets").LineWidgets,p=C("../lib/dom"),a=C("../range").Range;function l(n,i,t){var e=n.getAnnotations().sort(a.comparePoints);if(e.length){var r=function(c,d,b){for(var I=0,h=c.length-1;I<=h;){var u=I+h>>1,y=b(d,c[u]);if(0<y)I=1+u;else{if(!(y<0))return u;h=u-1}}return-(I+1)}(e,{row:i,column:-1},a.comparePoints),s=((r=r<0?-r-1:r)>=e.length?r=0<t?0:e.length-1:r===0&&t<0&&(r=e.length-1),e[r]);if(s&&t){if(s.row===i){for(;(s=e[r+=t])&&s.row===i;);if(!s)return e.slice()}var o=[];for(i=s.row;o[t<0?"unshift":"push"](s),(s=e[r+=t])&&s.row==i;);return o.length&&o}}}m.showErrorMarker=function(n,d){var t,e=n.session,r=(e.widgetManager||(e.widgetManager=new x(e),e.widgetManager.attach(n)),n.getCursorPosition()),c=r.row,b=e.widgetManager.getWidgetsAtRow(c).filter(function(I){return I.type=="errorMarker"})[0],c=(b?b.destroy():c-=d,l(e,c,d));if(c)d=c[0],r.column=(d.pos&&typeof d.column!="number"?d.pos.sc:d.column)||0,r.row=d.row,t=n.renderer.$gutterLayer.$annotations[r.row];else{if(b)return;t={text:["Looks good!"],className:"ace_ok"}}n.session.unfold(r.row),n.selection.moveToPosition(r);function s(I,h,u){if(h===0&&(u==="esc"||u==="return"))return o.destroy(),{command:"null"}}var o={row:r.row,fixedWidth:!0,coverGutter:!0,el:p.createElement("div"),type:"errorMarker"},c=o.el.appendChild(p.createElement("div")),d=o.el.appendChild(p.createElement("div")),b=(d.className="error_widget_arrow "+t.className,n.renderer.$cursorLayer.getPixelPosition(r).left);d.style.left=b+n.renderer.gutterWidth-5+"px",o.el.className="error_widget_wrapper",c.className="error_widget "+t.className,c.innerHTML=t.text.join("<br>"),c.appendChild(p.createElement("div")),o.destroy=function(){n.$mouseHandler.isMousePressed||(n.keyBinding.removeKeyboardHandler(s),e.widgetManager.removeLineWidget(o),n.off("changeSelection",o.destroy),n.off("changeSession",o.destroy),n.off("mouseup",o.destroy),n.off("change",o.destroy))},n.keyBinding.addKeyboardHandler(s),n.on("changeSelection",o.destroy),n.on("changeSession",o.destroy),n.on("mouseup",o.destroy),n.on("change",o.destroy),n.session.widgetManager.addLineWidget(o),o.el.onmousedown=n.focus.bind(n),n.renderer.scrollCursorIntoView(null,.5,{bottom:o.el.offsetHeight})},p.importCssString(`
    .error_widget_wrapper {
        background: inherit;
        color: inherit;
        border:none
    }
    .error_widget {
        border-top: solid 2px;
        border-bottom: solid 2px;
        margin: 5px 0;
        padding: 10px 40px;
        white-space: pre-wrap;
    }
    .error_widget.ace_error, .error_widget_arrow.ace_error{
        border-color: #ff5a5a
    }
    .error_widget.ace_warning, .error_widget_arrow.ace_warning{
        border-color: #F1D817
    }
    .error_widget.ace_info, .error_widget_arrow.ace_info{
        border-color: #5a5a5a
    }
    .error_widget.ace_ok, .error_widget_arrow.ace_ok{
        border-color: #5aaa5a
    }
    .error_widget_arrow {
        position: absolute;
        border: solid 5px;
        border-top-color: transparent!important;
        border-right-color: transparent!important;
        border-left-color: transparent!important;
        top: -5px;
    }
`,"error_marker.css",!1)}),ace.define("ace/ace",["require","exports","module","ace/lib/dom","ace/lib/event","ace/range","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config","ace/loader_build"],function(C,m,A){C("./loader_build")(m);var x=C("./lib/dom"),p=C("./lib/event"),a=C("./range").Range,l=C("./editor").Editor,n=C("./edit_session").EditSession,i=C("./undomanager").UndoManager,t=C("./virtual_renderer").VirtualRenderer;C("./worker/worker_client"),C("./keyboard/hash_handler"),C("./placeholder"),C("./multi_select"),C("./mode/folding/fold_mode"),C("./theme/textmate"),C("./ext/error_marker"),m.config=C("./config"),m.edit=function(e,r){if(typeof e=="string"){var s=e;if(!(e=document.getElementById(s)))throw new Error("ace.edit can't find div #"+s)}var o,c;return e&&e.env&&e.env.editor instanceof l?e.env.editor:(s="",e&&/input|textarea/i.test(e.tagName)?(s=(o=e).value,e=x.createElement("pre"),o.parentNode.replaceChild(e,o)):e&&(s=e.textContent,e.innerHTML=""),s=m.createEditSession(s),e=new l(new t(e),s,r),c={document:s,editor:e,onResize:e.resize.bind(e,null)},o&&(c.textarea=o),p.addListener(window,"resize",c.onResize),e.on("destroy",function(){p.removeListener(window,"resize",c.onResize),c.editor.container.env=null}),e.container.env=e.env=c,e)},m.createEditSession=function(e,r){return e=new n(e,r),e.setUndoManager(new i),e},m.Range=a,m.Editor=l,m.EditSession=n,m.UndoManager=i,m.VirtualRenderer=t,m.version=m.config.version}),ace.require(["ace/ace"],function(C){for(var m in C&&(C.config.init(!0),C.define=ace.define),window.ace||(window.ace=C),C)C.hasOwnProperty(m)&&(window.ace[m]=C[m]);window.ace.default=window.ace,ie&&(ie.exports=window.ace)})},4317:function(ie,g,V){ie=V.nmd(ie),ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(X,k,G){var t=X("./lib/dom"),O=X("./lib/oop"),D=X("./lib/event_emitter").EventEmitter,N=X("./lib/lang"),M=X("./range").Range,L=X("./range_list").RangeList,C=X("./keyboard/hash_handler").HashHandler,m=X("./tokenizer").Tokenizer,A=X("./clipboard"),x={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,r,s){return e=e.session.getTextRange(),s?e.replace(/\n\r?([ \t]*\S)/g,`
`+s+"$1"):e},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return A.getText&&A.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){return e=e.session.$mode||{},e.blockComment&&e.blockComment.start||""},BLOCK_COMMENT_END:function(e){return e=e.session.$mode||{},e.blockComment&&e.blockComment.end||""},LINE_COMMENT:function(e){return(e.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:p.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:p.bind(null,{year:"2-digit"}),CURRENT_MONTH:p.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:p.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:p.bind(null,{month:"short"}),CURRENT_DATE:p.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:p.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:p.bind(null,{weekday:"short"}),CURRENT_HOUR:p.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:p.bind(null,{minute:"2-digit"}),CURRENT_SECOND:p.bind(null,{second:"2-digit"})};function p(e){return e=new Date().toLocaleString("en-us",e),e.length==1?"0"+e:e}x.SELECTED_TEXT=x.SELECTION;function a(){this.snippetMap={},this.snippetNameMap={}}(function(){O.implement(this,D),this.getTokenizer=function(){return a.$tokenizer||this.createTokenizer()},this.createTokenizer=function(){function e(o){return o=o.substr(1),/^\d+$/.test(o)?[{tabstopId:parseInt(o,10)}]:[{text:o}]}function r(o){return"(?:[^\\\\"+o+"]|\\\\.)"}var s={regex:"/("+r("/")+"+)/",onMatch:function(o,c,d){return d=d[0],d.fmtString=!0,d.guard=o.slice(1,-1),d.flag=""},next:"formatString"};return a.$tokenizer=new m({start:[{regex:/\\./,onMatch:function(o,c,d){var b=o[1];return[o=b=="}"&&d.length||"`$\\".indexOf(b)!=-1?b:o]}},{regex:/}/,onMatch:function(o,c,d){return[d.length?d.shift():o]}},{regex:/\$(?:\d+|\w+)/,onMatch:e},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(o,c,d){return o=e(o.substr(1)),d.unshift(o[0]),o},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+r("\\|")+"*\\|",onMatch:function(o,c,d){return o=o.slice(1,-1).replace(/\\[,|\\]|,/g,function(b){return b.length==2?b[1]:"\0"}).split("\0").map(function(b){return{value:b}}),[(d[0].choices=o)[0]]},next:"start"},s,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(o,c,d){return d.length&&d[0].expectElse?(d[0].expectElse=!1,d[0].ifEnd={elseEnd:d[0]},[d[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(o,c,d){var b=o[1];return b=="}"&&d.length||"`$\\".indexOf(b)!=-1?o=b:b=="n"?o=`
`:b=="t"?o="	":"ulULE".indexOf(b)!=-1&&(o={changeCase:b,local:"a"<b}),[o]}},{regex:"/\\w*}",onMatch:function(o,c,d){return d=d.shift(),d&&(d.flag=o.slice(1,-1)),this.next=d&&d.tabstopId?"start":"",[d||o]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(o,c,d){return[{text:o.slice(1)}]}},{regex:/\${\w+/,onMatch:function(o,c,d){return o={text:o.slice(2)},d.unshift(o),[o]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(o,c,d){return d=d.shift(),this.next=d&&d.tabstopId?"start":"",[d||o]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(o,c,d){return d[0].formatFunction=o.slice(2,-1),[d.shift()]},next:"formatString"},s,{regex:/:[\?\-+]?/,onMatch:function(o,c,d){o[1]=="+"&&(d[0].ifEnd=d[0]),o[1]=="?"&&(d[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},this.tokenizeTmSnippet=function(e,r){return this.getTokenizer().getLineTokens(e,r).tokens.map(function(s){return s.value||s})},this.getVariableValue=function(e,r,s){var o;return/^\d+$/.test(r)?(this.variables.__||{})[r]||"":/^[A-Z]\d+$/.test(r)?(this.variables[r[0]+"__"]||{})[r.substr(1)]||"":(r=r.replace(/^TM_/,""),!this.variables.hasOwnProperty(r)||(o=typeof(o=this.variables[r])=="function"?this.variables[r](e,r,s):o)==null?"":o)},this.variables=x,this.tmStrFormat=function(e,r,s){var o,c,d,b;return r.fmt?(o=r.flag||"",c=r.guard,c=new RegExp(c,o.replace(/[^gim]/g,"")),d=typeof r.fmt=="string"?this.tokenizeTmSnippet(r.fmt,"formatString"):r.fmt,b=this,e.replace(c,function(){for(var I=b.variables.__,h=(b.variables.__=[].slice.call(arguments),b.resolveVariables(d,s)),u="E",y=0;y<h.length;y++){var w,v=h[y];typeof v=="object"?(h[y]="",v.changeCase&&v.local?(w=h[y+1])&&typeof w=="string"&&(v.changeCase=="u"?h[y]=w[0].toUpperCase():h[y]=w[0].toLowerCase(),h[y+1]=w.substr(1)):v.changeCase&&(u=v.changeCase)):u=="U"?h[y]=v.toUpperCase():u=="L"&&(h[y]=v.toLowerCase())}return b.variables.__=I,h.join("")})):e},this.tmFormatFunction=function(e,r,s){return r.formatFunction=="upcase"?e.toUpperCase():r.formatFunction=="downcase"?e.toLowerCase():e},this.resolveVariables=function(e,r){for(var s=[],o="",c=!0,d=0;d<e.length;d++){var b,I=e[d];typeof I=="string"?(s.push(I),I==`
`?(c=!0,o=""):c&&(o=/^\t*/.exec(I)[0],c=/\S/.test(I))):I&&(c=!1,I.fmtString&&((b=e.indexOf(I,d+1))==-1&&(b=e.length),I.fmt=e.slice(d+1,b),d=b),I.text?(b=this.getVariableValue(r,I.text,o)+"",I.fmtString&&(b=this.tmStrFormat(b,I,r)),(b=I.formatFunction?this.tmFormatFunction(b,I,r):b)&&!I.ifEnd?(s.push(b),h(I)):!b&&I.ifEnd&&h(I.ifEnd)):I.elseEnd?h(I.elseEnd):I.tabstopId==null&&I.changeCase==null||s.push(I))}function h(u){u=e.indexOf(u,d+1),u!=-1&&(d=u)}return s},this.insertSnippetForSelection=function(e,P){for(var _=e.getCursorPosition(),E=e.session.getLine(_.row),s=e.session.getTabString(),o=E.match(/^\s*/)[0],c=(_.column<o.length&&(o=o.slice(0,_.column)),P=P.replace(/\r/g,""),this.tokenizeTmSnippet(P)),d=(c=(c=this.resolveVariables(c,e)).map(function(z){return z==`
`?z+o:typeof z=="string"?z.replace(/\t/g,s):z}),[]),b=(c.forEach(function(z,K){var Y,R;typeof z=="object"&&(R=z.tabstopId,(Y=d[R])||((Y=d[R]=[]).index=R,Y.value="",Y.parents={}),Y.indexOf(z)===-1&&(z.choices&&!Y.choices&&(Y.choices=z.choices),Y.push(z),(R=c.indexOf(z,K+1))!==-1&&((z=c.slice(K+1,R)).some(function(Z){return typeof Z=="object"})&&!Y.value?Y.value=z:!z.length||Y.value&&typeof Y.value=="string"||(Y.value=z.join("")))))}),d.forEach(function(z){z.length=0}),{}),I=0;I<c.length;I++){var h,u,y,w=c[I];typeof w=="object"&&(y=w.tabstopId,h=d[y],u=c.indexOf(w,I+1),b[y]?b[y]===w&&(delete b[y],Object.keys(b).forEach(function(z){h.parents[z]=!0})):(b[y]=w,typeof(y=h.value)!="string"?y=function(z){for(var K=[],Y=0;Y<z.length;Y++){if(typeof(R=z[Y])=="object"){if(b[R.tabstopId])continue;var R=K[z.lastIndexOf(R,Y-1)]||{tabstopId:R.tabstopId}}K[Y]=R}return K}(y):w.fmt&&(y=this.tmStrFormat(y,w,e)),c.splice.apply(c,[I+1,Math.max(0,u-I)].concat(y,w)),h.indexOf(w)===-1&&h.push(w)))}var v=0,T=0,B="",E=(c.forEach(function(z){var K;typeof z=="string"?(1<(K=z.split(`
`)).length?(T=K[K.length-1].length,v+=K.length-1):T+=z.length,B+=z):z&&(z.start?z.end={row:v,column:T}:z.start={row:v,column:T})}),e.getSelectionRange()),_=e.session.replace(E,B),P=new l(e),H=e.inVirtualSelectionMode&&e.selection.index;P.addTabstops(d,E.start,_,H)},this.insertSnippet=function(e,r){var s=this;if(e.inVirtualSelectionMode)return s.insertSnippetForSelection(e,r);e.forEachSelection(function(){s.insertSnippetForSelection(e,r)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},this.$getScope=function(e){var r,s=e.session.$mode.$id||"";return(s=s.split("/").pop())!=="html"&&s!=="php"||(s!=="php"||e.session.$mode.inlinePhp||(s="html"),r=e.getCursorPosition(),(e=typeof(e=e.session.getState(r.row))=="object"?e[0]:e).substring&&(e.substring(0,3)=="js-"?s="javascript":e.substring(0,4)=="css-"?s="css":e.substring(0,4)=="php-"&&(s="php"))),s},this.getActiveScopes=function(r){var r=this.$getScope(r),s=[r],o=this.snippetMap;return o[r]&&o[r].includeScopes&&s.push.apply(s,o[r].includeScopes),s.push("_"),s},this.expandWithTab=function(e,r){var s=this,o=e.forEachSelection(function(){return s.expandSnippetForSelection(e,r)},null,{keepOrder:!0});return o&&e.tabstopManager&&e.tabstopManager.tabNext(),o},this.expandSnippetForSelection=function(e,r){var s,o=e.getCursorPosition(),c=e.session.getLine(o.row),d=c.substring(0,o.column),b=c.substr(o.column),I=this.snippetMap;return this.getActiveScopes(e).some(function(h){return h=I[h],!!(s=h?this.findMatchingSnippet(h,d,b):s)},this),!!s&&(r&&r.dryRun||(e.session.doc.removeInLine(o.row,o.column-s.replaceBefore.length,o.column+s.replaceAfter.length),this.variables.M__=s.matchBefore,this.variables.T__=s.matchAfter,this.insertSnippetForSelection(e,s.content),this.variables.M__=this.variables.T__=null),!0)},this.findMatchingSnippet=function(e,r,s){for(var o=e.length;o--;){var c=e[o];if((!c.startRe||c.startRe.test(r))&&(!c.endRe||c.endRe.test(s))&&(c.startRe||c.endRe))return c.matchBefore=c.startRe?c.startRe.exec(r):[""],c.matchAfter=c.endRe?c.endRe.exec(s):[""],c.replaceBefore=c.triggerRe?c.triggerRe.exec(r)[0]:"",c.replaceAfter=c.endTriggerRe?c.endTriggerRe.exec(s)[0]:"",c}},this.snippetMap={},this.snippetNameMap={},this.register=function(e,r){var s=this.snippetMap,o=this.snippetNameMap,c=this;function d(h){return(h=h&&!/^\^?\(.*\)\$?$|^\\b$/.test(h)?"(?:"+h+")":h)||""}function b(h,u,y){return h=d(h),u=d(u),y?(h=u+h)&&h[h.length-1]!="$"&&(h+="$"):(h+=u)&&h[0]!="^"&&(h="^"+h),new RegExp(h)}function I(h){h.scope||(h.scope=r||"_"),r=h.scope,s[r]||(s[r]=[],o[r]={});var u,y=o[r];h.name&&((u=y[h.name])&&c.unregister(u),y[h.name]=h),s[r].push(h),h.prefix&&(h.tabTrigger=h.prefix),!h.content&&h.body&&(h.content=Array.isArray(h.body)?h.body.join(`
`):h.body),h.tabTrigger&&!h.trigger&&(!h.guard&&/^\w/.test(h.tabTrigger)&&(h.guard="\\b"),h.trigger=N.escapeRegExp(h.tabTrigger)),(h.trigger||h.guard||h.endTrigger||h.endGuard)&&(h.startRe=b(h.trigger,h.guard,!0),h.triggerRe=new RegExp(h.trigger),h.endRe=b(h.endTrigger,h.endGuard,!0),h.endTriggerRe=new RegExp(h.endTrigger))}e=e||[],Array.isArray(e)?e.forEach(I):Object.keys(e).forEach(function(h){I(e[h])}),this._signal("registerSnippets",{scope:r})},this.unregister=function(e,r){var s=this.snippetMap,o=this.snippetNameMap;function c(d){var b=o[d.scope||r];b&&b[d.name]&&(delete b[d.name],0<=(d=(b=s[d.scope||r])&&b.indexOf(d))&&b.splice(d,1))}e.content?c(e):Array.isArray(e)&&e.forEach(c)},this.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var r,s,o,c=[],d={},b=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;s=b.exec(e);){if(s[1])try{d=JSON.parse(s[1]),c.push(d)}catch{}s[4]?(d.content=s[4].replace(/^\t/gm,""),c.push(d),d={}):(r=s[2],s=s[3],r=="regex"?(d.guard=(o=/\/((?:[^\/\\]|\\.)*)|$/g).exec(s)[1],d.trigger=o.exec(s)[1],d.endTrigger=o.exec(s)[1],d.endGuard=o.exec(s)[1]):r=="snippet"?(d.tabTrigger=s.match(/^\S*/)[0],d.name||(d.name=s)):r&&(d[r]=s))}return c},this.getSnippetByName=function(e,r){var s,o=this.snippetNameMap;return this.getActiveScopes(r).some(function(c){return c=o[c],!!(s=c?c[e]:s)},this),s}}).call(a.prototype);var l=function(e){if(e.tabstopManager)return e.tabstopManager;(e.tabstopManager=this).$onChange=this.onChange.bind(this),this.$onChangeSelection=N.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(e)},n=(function(){this.attach=function(e){this.index=0,this.ranges=[],this.tabstops=[],this.$openTabstops=null,this.selectedTabstop=null,this.editor=e,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},this.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges=null,this.tabstops=null,this.selectedTabstop=null,this.editor.removeListener("change",this.$onChange),this.editor.removeListener("changeSelection",this.$onChangeSelection),this.editor.removeListener("changeSession",this.$onChangeSession),this.editor.commands.removeListener("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.editor=null},this.onChange=function(e){for(var r=e.action[0]=="r",s=this.selectedTabstop||{},o=s.parents||{},c=(this.tabstops||[]).slice(),d=0;d<c.length;d++){var b=c[d],I=b==s||o[b.index];if(b.rangeList.$bias=I?0:1,e.action=="remove"&&b!==s)for(var I=b.parents&&b.parents[s.index],h=(h=b.rangeList.pointIndex(e.start,I))<0?-h-1:h+1,I=(I=b.rangeList.pointIndex(e.end,I))<0?-I-1:I-1,u=b.rangeList.ranges.slice(h,I),y=0;y<u.length;y++)this.removeRange(u[y]);b.rangeList.$onChange(e)}var w=this.editor.session;this.$inChange||!r||w.getLength()!=1||w.getValue()||this.detach()},this.updateLinkedFields=function(){var e=this.selectedTabstop;if(e&&e.hasLinkedRanges&&e.firstNonLinked){this.$inChange=!0;for(var r=this.editor.session,s=r.getTextRange(e.firstNonLinked),o=0;o<e.length;o++){var c,d=e[o];d.linked&&(c=d.original,c=k.snippetManager.tmStrFormat(s,c,this.editor),r.replace(d,c))}this.$inChange=!1}},this.onAfterExec=function(e){e.command&&!e.command.readOnly&&this.updateLinkedFields()},this.onChangeSelection=function(){if(this.editor){for(var e=this.editor.selection.lead,r=this.editor.selection.anchor,s=this.editor.selection.isEmpty(),o=0;o<this.ranges.length;o++)if(!this.ranges[o].linked){var c=this.ranges[o].contains(e.row,e.column),d=s||this.ranges[o].contains(r.row,r.column);if(c&&d)return}this.detach()}},this.onChangeSession=function(){this.detach()},this.tabNext=function(s){var r=this.tabstops.length,s=this.index+(s||1),s=Math.min(Math.max(s,1),r);this.selectTabstop(s=s==r?0:s),s===0&&this.detach()},this.selectTabstop=function(e){this.$openTabstops=null;var r=this.tabstops[this.index];if(r&&this.addTabstopMarkers(r),this.index=e,(r=this.tabstops[this.index])&&r.length){if(e=(this.selectedTabstop=r).firstNonLinked||r,r.choices&&(e.cursor=e.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(e);else{var s=this.editor.multiSelect;s.toSingleRange(e);for(var o=0;o<r.length;o++)r.hasLinkedRanges&&r[o].linked||s.addRange(r[o].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},this.addTabstops=function(e,r,s){var o=this.useLink||!this.editor.getOption("enableMultiselect");this.$openTabstops||(this.$openTabstops=[]),e[0]||(s=M.fromPoints(s,s),i(s.start,r),i(s.end,r),e[0]=[s],e[0].index=0);var c=[this.index+1,0],d=this.ranges;e.forEach(function(b,I){for(var h=this.$openTabstops[I]||b,u=0;u<b.length;u++){var y=b[u],w=M.fromPoints(y.start,y.end||y.start);n(w.start,r),n(w.end,r),w.original=y,w.tabstop=h,d.push(w),h!=b?h.unshift(w):h[u]=w,y.fmtString||h.firstNonLinked&&o?(w.linked=!0,h.hasLinkedRanges=!0):h.firstNonLinked||(h.firstNonLinked=w)}h.firstNonLinked||(h.hasLinkedRanges=!1),h===b&&(c.push(h),this.$openTabstops[I]=h),this.addTabstopMarkers(h),h.rangeList=h.rangeList||new L,h.rangeList.$bias=0,h.rangeList.addList(h)},this),2<c.length&&(this.tabstops.length&&c.push(c.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,c))},this.addTabstopMarkers=function(e){var r=this.editor.session;e.forEach(function(s){s.markerId||(s.markerId=r.addMarker(s,"ace_snippet-marker","text"))})},this.removeTabstopMarkers=function(e){var r=this.editor.session;e.forEach(function(s){r.removeMarker(s.markerId),s.markerId=null})},this.removeRange=function(e){var r=e.tabstop.indexOf(e);r!=-1&&e.tabstop.splice(r,1),(r=this.ranges.indexOf(e))!=-1&&this.ranges.splice(r,1),(r=e.tabstop.rangeList.ranges.indexOf(e))!=-1&&e.tabstop.splice(r,1),this.editor.session.removeMarker(e.markerId),e.tabstop.length||((r=this.tabstops.indexOf(e.tabstop))!=-1&&this.tabstops.splice(r,1),this.tabstops.length||this.detach())},this.keyboardHandler=new C,this.keyboardHandler.bindKeys({Tab:function(e){k.snippetManager&&k.snippetManager.expandWithTab(e)||(e.tabstopManager.tabNext(1),e.renderer.scrollCursorIntoView())},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1),e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}})}.call(l.prototype),function(e,r){e.row==0&&(e.column+=r.column),e.row+=r.row}),i=function(e,r){e.row==r.row&&(e.column-=r.column),e.row-=r.row},t=(t.importCssString(`
.ace_snippet-marker {
    -moz-box-sizing: border-box;
    box-sizing: border-box;
    background: rgba(194, 193, 208, 0.09);
    border: 1px dotted rgba(211, 208, 235, 0.62);
    position: absolute;
}`,"snippets.css",!1),k.snippetManager=new a,X("./editor").Editor);(function(){this.insertSnippet=function(e,r){return k.snippetManager.insertSnippet(this,e,r)},this.expandSnippet=function(e){return k.snippetManager.expandWithTab(this,e)}}).call(t.prototype)}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom"],function(X,k,G){function O(A){return(A=new D(A)).$maxLines=4,(A=new N(A)).setHighlightActiveLine(!1),A.setShowPrintMargin(!1),A.renderer.setShowGutter(!1),A.renderer.setHighlightGutterLine(!1),A.$mouseHandler.$focusTimeout=0,A.$highlightTagPending=!0,A}var D=X("../virtual_renderer").VirtualRenderer,N=X("../editor").Editor,M=X("../range").Range,L=X("../lib/event"),C=X("../lib/lang"),m=X("../lib/dom");m.importCssString(`
.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {
    background-color: #CAD6FA;
    z-index: 1;
}
.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {
    background-color: #3a674e;
}
.ace_editor.ace_autocomplete .ace_line-hover {
    border: 1px solid #abbffe;
    margin-top: -1px;
    background: rgba(233,233,253,0.4);
    position: absolute;
    z-index: 2;
}
.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {
    border: 1px solid rgba(109, 150, 13, 0.8);
    background: rgba(58, 103, 78, 0.62);
}
.ace_completion-meta {
    opacity: 0.5;
    margin: 0.9em;
}
.ace_completion-message {
    color: blue;
}
.ace_editor.ace_autocomplete .ace_completion-highlight{
    color: #2d69c7;
}
.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{
    color: #93ca12;
}
.ace_editor.ace_autocomplete {
    width: 300px;
    z-index: 200000;
    border: 1px lightgray solid;
    position: fixed;
    box-shadow: 2px 3px 5px rgba(0,0,0,.2);
    line-height: 1.4;
    background: #fefefe;
    color: #111;
}
.ace_dark.ace_editor.ace_autocomplete {
    border: 1px #484747 solid;
    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);
    line-height: 1.4;
    background: #25282c;
    color: #c1c1c1;
}`,"autocompletion.css",!1),k.AcePopup=function(r){function x(){}function p(){e(-1)}var a,l=m.createElement("div"),n=new O(l),i=(r&&r.appendChild(l),l.style.display="none",n.renderer.content.style.cursor="default",n.renderer.setStyle("ace_autocomplete"),n.setOption("displayIndentGuides",!1),n.setOption("dragDelay",150),n.focus=x,n.$isFocused=!0,n.renderer.$cursorLayer.restartTimer=x,n.renderer.$cursorLayer.element.style.opacity=0,n.renderer.$maxLines=8,n.renderer.$keepTextAreaAtCursor=!1,n.setHighlightActiveLine(!1),n.session.highlight(""),n.session.$searchHighlight.clazz="ace_highlight-marker",n.on("mousedown",function(s){var o=s.getDocumentPosition();n.selection.moveToPosition(o),t.start.row=t.end.row=o.row,s.stop()}),new M(-1,0,-1,1/0)),t=new M(-1,0,-1,1/0),e=(t.id=n.session.addMarker(t,"ace_active-line","fullLine"),n.setSelectOnHover=function(s){s?i.id&&(n.session.removeMarker(i.id),i.id=null):i.id=n.session.addMarker(i,"ace_line-hover","fullLine")},n.setSelectOnHover(!1),n.on("mousemove",function(s){var o;a?a.x==s.x&&a.y==s.y||((a=s).scrollTop=n.renderer.scrollTop,o=a.getDocumentPosition().row,i.start.row!=o&&(i.id||n.setRow(o),e(o))):a=s}),n.renderer.on("beforeRender",function(){var s;a&&i.start.row!=-1&&(a.$pos=null,s=a.getDocumentPosition().row,i.id||n.setRow(s),e(s,!0))}),n.renderer.on("afterRender",function(){var o=n.getRow(),s=n.renderer.$textLayer,o=s.element.childNodes[o-s.config.firstRow];o!==s.selectedNode&&s.selectedNode&&m.removeCssClass(s.selectedNode,"ace_selected"),(s.selectedNode=o)&&m.addCssClass(o,"ace_selected")}),function(s,o){s!==i.start.row&&(i.start.row=i.end.row=s,o||n.session._emit("changeBackMarker"),n._emit("changeHoverMarker"))}),r=(n.getHoveredRow=function(){return i.start.row},L.addListener(n.container,"mouseout",p),n.on("hide",p),n.on("changeSelection",p),n.session.doc.getLength=function(){return n.data.length},n.session.doc.getLine=function(s){return s=n.data[s],typeof s=="string"?s:s&&s.value||""},n.session.bgTokenizer);return r.$tokenizeRow=function(s){var o=n.data[s],c=[];if(o){for(var d,b,I=(o=typeof o=="string"?{value:o}:o).caption||o.value||o.name,h=I.toLowerCase(),u=(n.filterText||"").toLowerCase(),y=0,w=0,v=0;v<=u.length;v++)v!=w&&(o.matchMask&1<<v||v==u.length)&&(d=u.slice(w,v),w=v,(b=h.indexOf(d,y))!=-1&&(T(I.slice(y,b),""),y=b+d.length,T(I.slice(b,y),"completion-highlight")));T(I.slice(y,I.length),""),o.meta&&c.push({type:"completion-meta",value:o.meta}),o.message&&c.push({type:"completion-message",value:o.message})}return c;function T(B,E){B&&c.push({type:(o.className||"")+(E||""),value:B})}},r.$updateOnChange=x,r.start=x,n.session.$computeWidth=function(){return this.screenWidth=0},n.isOpen=!1,n.isTopdown=!1,n.autoSelect=!0,n.filterText="",n.data=[],n.setData=function(s,o){n.filterText=o||"",n.setValue(C.stringRepeat(`
`,s.length),-1),n.data=s||[],n.setRow(0)},n.getData=function(s){return n.data[s]},n.getRow=function(){return t.start.row},n.setRow=function(s){s=Math.max(this.autoSelect?0:-1,Math.min(this.data.length,s)),t.start.row!=s&&(n.selection.clearSelection(),t.start.row=t.end.row=s||0,n.session._emit("changeBackMarker"),n.moveCursorTo(s||0,0),n.isOpen&&n._signal("select"))},n.on("changeSelection",function(){n.isOpen&&n.setRow(n.selection.lead.row),n.renderer.scrollCursorIntoView()}),n.hide=function(){this.container.style.display="none",this._signal("hide"),n.isOpen=!1},n.show=function(s,o,w){var d=this.container,b=window.innerHeight,I=window.innerWidth,h=this.renderer,u=h.$maxLines*o*1.4,y=s.top+this.$borderSize,w=(b/2<y&&!w&&b<y+o+u?(h.$maxPixelHeight=y-2*this.$borderSize,d.style.top="",d.style.bottom=b-y+"px",n.isTopdown=!1):(h.$maxPixelHeight=b-(y+=o)-.2*o,d.style.top=y+"px",d.style.bottom="",n.isTopdown=!0),d.style.display="",s.left);w+d.offsetWidth>I&&(w=I-d.offsetWidth),d.style.left=w+"px",this._signal("show"),a=null,n.isOpen=!0},n.goTo=function(s){var o=this.getRow(),c=this.session.getLength()-1;switch(s){case"up":o=o<=0?c:o-1;break;case"down":o=c<=o?-1:o+1;break;case"start":o=0;break;case"end":o=c}this.setRow(o)},n.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},n.$imageSize=0,n.$borderSize=1,n},k.$singleLineEditor=O}),ace.define("ace/autocomplete/util",["require","exports","module"],function(X,k,G){k.parForEach=function(D,N,M){var L=0,C=D.length;C===0&&M();for(var m=0;m<C;m++)N(D[m],function(A,x){++L===C&&M(A,x)})};var O=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;k.retrievePrecedingIdentifier=function(D,N,M){M=M||O;for(var L=[],C=N-1;0<=C&&M.test(D[C]);C--)L.push(D[C]);return L.reverse().join("")},k.retrieveFollowingIdentifier=function(D,N,M){M=M||O;for(var L=[],C=N;C<D.length&&M.test(D[C]);C++)L.push(D[C]);return L},k.getCompletionPrefix=function(D){var N,M=D.getCursorPosition(),L=D.session.getLine(M.row);return D.completers.forEach(function(C){C.identifierRegexps&&C.identifierRegexps.forEach(function(m){!N&&m&&(N=this.retrievePrecedingIdentifier(L,M.column,m))}.bind(this))}.bind(this)),N||this.retrievePrecedingIdentifier(L,M.column)}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config"],function(X,k,G){function O(){this.autoInsert=!1,this.autoSelect=!0,this.exactMatch=!1,this.gatherCompletionsId=0,this.keyboardHandler=new D,this.keyboardHandler.bindKeys(this.commands),this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.changeTimer=L.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=L.delayedCall(this.updateDocTooltip.bind(this),50)}var D=X("./keyboard/hash_handler").HashHandler,N=X("./autocomplete/popup").AcePopup,M=X("./autocomplete/util"),L=X("./lib/lang"),C=X("./lib/dom"),m=X("./snippets").snippetManager,A=X("./config"),x=(function(){this.$init=function(){return this.popup=new N(document.body||document.documentElement),this.popup.on("click",function(p){this.insertMatch(),p.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.tooltipTimer.bind(null,null)),this.popup.on("select",this.tooltipTimer.bind(null,null)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup},this.getPopup=function(){return this.popup||this.$init()},this.openPopup=function(p,a,l){this.popup||this.$init(),this.popup.autoSelect=this.autoSelect,this.popup.setData(this.completions.filtered,this.completions.filterText),p.keyBinding.addKeyboardHandler(this.keyboardHandler);var n,i=p.renderer;this.popup.setRow(this.autoSelect?0:-1),l?a||this.detach():(this.popup.setTheme(p.getTheme()),this.popup.setFontSize(p.getFontSize()),l=i.layerConfig.lineHeight,(a=i.$cursorLayer.getPixelPosition(this.base,!0)).left-=this.popup.getTextLeftOffset(),n=p.container.getBoundingClientRect(),a.top+=n.top-i.layerConfig.offset,a.left+=n.left-p.renderer.scrollLeft,a.left+=i.gutterWidth,this.popup.show(a,l)),this.changeTimer.cancel()},this.detach=function(){this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener),this.changeTimer.cancel(),this.hideDocTooltip(),this.gatherCompletionsId+=1,this.popup&&this.popup.isOpen&&this.popup.hide(),this.base&&this.base.detach(),this.activated=!1,this.completions=this.base=null},this.changeListener=function(p){var a=this.editor.selection.lead;(a.row!=this.base.row||a.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},this.blurListener=function(p){var a=document.activeElement,l=this.editor.textInput.getElement(),n=p.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(p.relatedTarget),i=this.popup&&this.popup.container;a==l||a.parentNode==i||n||a==this.tooltipNode||p.relatedTarget==l||this.detach()},this.mousedownListener=function(p){this.detach()},this.mousewheelListener=function(p){this.detach()},this.goTo=function(p){this.popup.goTo(p)},this.insertMatch=function(p,a){if(!(p=p||this.popup.getData(this.popup.getRow())))return!1;var l=this.completions;if(this.editor.startOperation({command:{name:"insertMatch"}}),p.completer&&p.completer.insertMatch)p.completer.insertMatch(this.editor,p);else{if(!l)return!1;if(l.filterText)for(var n,i=this.editor.selection.getAllRanges(),t=0;n=i[t];t++)n.start.column-=l.filterText.length,this.editor.session.remove(n);p.snippet?m.insertSnippet(this.editor,p.snippet):this.editor.execCommand("insertstring",p.value||p)}this.completions==l&&this.detach(),this.editor.endOperation()},this.commands={Up:function(p){p.completer.goTo("up")},Down:function(p){p.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(p){p.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(p){p.completer.goTo("end")},Esc:function(p){p.completer.detach()},Return:function(p){return p.completer.insertMatch()},"Shift-Return":function(p){p.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(p){var a=p.completer.insertMatch();if(a||p.tabstopManager)return a;p.completer.goTo("down")},PageUp:function(p){p.completer.popup.gotoPageUp()},PageDown:function(p){p.completer.popup.gotoPageDown()}},this.gatherCompletions=function(p,a){var l=p.getSession(),n=p.getCursorPosition(),i=M.getCompletionPrefix(p),t=(this.base=l.doc.createAnchor(n.row,n.column-i.length),this.base.$insertRight=!0,[]),e=p.completers.length;return p.completers.forEach(function(r,s){r.getCompletions(p,l,n,i,function(o,c){!o&&c&&(t=t.concat(c)),a(null,{prefix:M.getCompletionPrefix(p),matches:t,finished:--e==0})})}),!0},this.showPopup=function(p,a){this.editor&&this.detach(),this.activated=!0,(this.editor=p).completer!=this&&(p.completer&&p.completer.detach(),p.completer=this),p.on("changeSelection",this.changeListener),p.on("blur",this.blurListener),p.on("mousedown",this.mousedownListener),p.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,a)},this.updateCompletions=function(p,a){var l,n,i,t,e,r,s;return p&&this.base&&this.completions?(l=this.editor.getCursorPosition(),(r=this.editor.session.getTextRange({start:this.base,end:l}))==this.completions.filterText?void 0:(this.completions.setFilter(r),this.completions.filtered.length&&(this.completions.filtered.length!=1||this.completions.filtered[0].value!=r||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,r,p):this.detach())):a&&a.matches?(l=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(l.row,l.column),this.base.$insertRight=!0,this.completions=new x(a.matches),this.openPopup(this.editor,"",p)):(n=this.gatherCompletionsId,i=function(o){if(o.finished)return this.detach()}.bind(this),t=function(o){var c=o.prefix,d=o.matches,d=(this.completions=new x(d),this.exactMatch&&(this.completions.exactMatch=!0),this.completions.setFilter(c),this.completions.filtered);return d.length&&(d.length!=1||d[0].value!=c||d[0].snippet)?this.autoInsert&&d.length==1&&o.finished?this.insertMatch(d[0]):void this.openPopup(this.editor,c,p):i(o)}.bind(this),e=!0,s=null,this.gatherCompletions(this.editor,function(o,c){var d=c.prefix,b=c&&c.matches;if(!b||!b.length)return i(c);d.indexOf(c.prefix)===0&&n==this.gatherCompletionsId&&(e?s=c:t(c))}.bind(this)),e=!1,void(s&&(r=s,s=null,t(r))))},this.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},this.updateDocTooltip=function(){var p=this.popup,a=p.data,l=a&&(a[p.getHoveredRow()]||a[p.getRow()]),n=null;return l&&this.editor&&this.popup.isOpen&&(this.editor.completers.some(function(i){return n=i.getDocTooltip?i.getDocTooltip(l):n}),(n=typeof(n=n||typeof l=="string"?n:l)=="string"?{docText:n}:n)&&(n.docHTML||n.docText))?void this.showDocTooltip(n):this.hideDocTooltip()},this.showDocTooltip=function(l){this.tooltipNode||(this.tooltipNode=C.createElement("div"),this.tooltipNode.className="ace_tooltip ace_doc-tooltip",this.tooltipNode.style.margin=0,this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this));var a=this.tooltipNode,l=(l.docHTML?a.innerHTML=l.docHTML:l.docText&&(a.textContent=l.docText),a.parentNode||document.body.appendChild(a),this.popup),n=l.container.getBoundingClientRect();a.style.top=l.container.style.top,a.style.bottom=l.container.style.bottom,a.style.display="block",window.innerWidth-n.right<320?n.left<320?(l.isTopdown?a.style.top=n.bottom+"px":a.style.top=l.container.offsetTop-a.offsetHeight+"px",a.style.left=n.left+"px",a.style.right="",a.style.bottom=""):(a.style.right=window.innerWidth-n.left+"px",a.style.left=""):(a.style.left=n.right+1+"px",a.style.right="")},this.hideDocTooltip=function(){var p;this.tooltipTimer.cancel(),this.tooltipNode&&(p=this.tooltipNode,this.editor.isFocused()||document.activeElement!=p||this.editor.focus(),this.tooltipNode=null,p.parentNode&&p.parentNode.removeChild(p))},this.onTooltipClick=function(p){for(var a=p.target;a&&a!=this.tooltipNode;){if(a.nodeName=="A"&&a.href){a.rel="noreferrer",a.target="_blank";break}a=a.parentNode}},this.destroy=function(){var p;this.detach(),this.popup&&(this.popup.destroy(),(p=this.popup.container)&&p.parentNode&&p.parentNode.removeChild(p)),this.editor&&this.editor.completer==this&&this.editor.completer,this.popup=null}}.call(O.prototype),O.for=function(p){return p.completer||(A.get("sharedPopups")?(O.$shared||(O.$sharedInstance=new O),p.completer=O.$sharedInstance):(p.completer=new O,p.once("destroy",function(a,l){l.completer.destroy()}))),p.completer},O.startCommand={name:"startAutocomplete",exec:function(p,a){var l=O.for(p);l.autoInsert=!1,l.autoSelect=!0,l.showPopup(p,a),l.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"},function(p,a){this.all=p,this.filtered=p,this.filterText=a||"",this.exactMatch=!1});(function(){this.setFilter=function(p){a=p.length>this.filterText&&p.lastIndexOf(this.filterText,0)===0?this.filtered:this.all,this.filterText=p,a=(a=this.filterCompletions(a,this.filterText)).sort(function(n,i){return i.exactMatch-n.exactMatch||i.$score-n.$score||(n.caption||n.value).localeCompare(i.caption||i.value)});var a,l=null;a=a.filter(function(n){return n=n.snippet||n.caption||n.value,n!==l&&(l=n,!0)}),this.filtered=a},this.filterCompletions=function(p,a){var l=[],n=a.toUpperCase(),i=a.toLowerCase();e:for(var t,e=0;t=p[e];e++){var r=t.caption||t.value||t.snippet;if(r){var s=-1,o=0,c=0;if(this.exactMatch){if(a!==r.substr(0,a.length))continue}else{var d=r.toLowerCase().indexOf(i);if(-1<d)c=d;else for(var b=0;b<a.length;b++){var I=r.indexOf(i[b],s+1),h=r.indexOf(n[b],s+1);if((I=0<=I&&(h<0||I<h)?I:h)<0)continue e;0<(h=I-s-1)&&(s===-1&&(c+=10),c+=h,o|=1<<b),s=I}}t.matchMask=o,t.exactMatch=c?0:1,t.$score=(t.score||0)-c,l.push(t)}}return l}}).call(x.prototype),k.Autocomplete=O,k.FilteredList=x}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(X,k,G){var O=X("../range").Range,D=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;function N(M,L){var C=M.getTextRange(O.fromPoints({row:0,column:0},L)).split(D).length-1,m=M.getValue().split(D),A=Object.create(null),x=m[C];return m.forEach(function(p,a){p&&p!==x&&(a=Math.abs(C-a),a=m.length-a,A[p]?A[p]=Math.max(a,A[p]):A[p]=a)}),A}k.getCompletions=function(M,L,C,m,A){var x=N(L,C);A(null,Object.keys(x).map(function(p){return{caption:p,value:p,score:x[p],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(X,k,G){function O(t,e){l(e.session.$mode)}function D(t){var e=t.editor,r=e.completer&&e.completer.activated;t.command.name==="backspace"?r&&!m.getCompletionPrefix(e)&&e.completer.detach():t.command.name==="insertstring"&&m.getCompletionPrefix(e)&&!r&&((t=M.for(e)).autoInsert=!1,t.showPopup(e))}var N=X("../snippets").snippetManager,M=X("../autocomplete").Autocomplete,L=X("../config"),C=X("../lib/lang"),m=X("../autocomplete/util"),i=X("../autocomplete/text_completer"),A={getCompletions:function(t,e,r,s,o){if(e.$mode.completer)return e.$mode.completer.getCompletions(t,e,r,s,o);t=t.session.getState(r.row),o(null,e.$mode.getCompletions(t,e,r,s))}},x={getCompletions:function(t,d,r,s,o){var c=[],d=d.getTokenAt(r.row,r.column),b=(d&&d.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?c.push("html-tag"):c=N.getActiveScopes(t),N.snippetMap),I=[];c.forEach(function(h){for(var u=b[h]||[],y=u.length;y--;){var w=u[y],v=w.name||w.tabTrigger;v&&I.push({caption:v,snippet:w.content,meta:w.tabTrigger&&!w.name?w.tabTrigger+"\u21E5 ":"snippet",type:"snippet"})}},this),o(null,I)},getDocTooltip:function(t){var e;t.type!="snippet"||t.docHTML||(t.docHTML=["<b>",C.escapeHTML(t.caption),"</b>","<hr></hr>",C.escapeHTML((t=t.snippet,e={},t.replace(/\${(\d+)(:(.*?))?}/g,function(r,s,o,c){return e[s]=c||""}).replace(/\$(\d+?)/g,function(r,s){return e[s]})))].join(""))}},p=[x,i,A],a=(k.setCompleters=function(t){p.length=0,t&&p.push.apply(p,t)},k.addCompleter=function(t){p.push(t)},k.textCompleter=i,k.keyWordCompleter=A,k.snippetCompleter=x,{name:"expandSnippet",exec:function(t){return N.expandWithTab(t)},bindKey:"Tab"}),l=function(t){(t=typeof t=="string"?L.$modes[t]:t)&&(N.files||(N.files={}),n(t.$id,t.snippetFileId),t.modes&&t.modes.forEach(l))},n=function(t,e){e&&t&&!N.files[t]&&(N.files[t]={},L.loadModule(e,function(r){r&&(!(N.files[t]=r).snippets&&r.snippetText&&(r.snippets=N.parseSnippetFile(r.snippetText)),N.register(r.snippets||[],r.scope),r.includeScopes&&(N.snippetMap[r.scope].includeScopes=r.includeScopes,r.includeScopes.forEach(function(s){l("ace/mode/"+s)})))}))},i=X("../editor").Editor;X("../config").defineOptions(i.prototype,"editor",{enableBasicAutocompletion:{set:function(t){t?(this.completers||(this.completers=Array.isArray(t)?t:p),this.commands.addCommand(M.startCommand)):this.commands.removeCommand(M.startCommand)},value:!1},enableLiveAutocompletion:{set:function(t){t?(this.completers||(this.completers=Array.isArray(t)?t:p),this.commands.on("afterExec",D)):this.commands.removeListener("afterExec",D)},value:!1},enableSnippets:{set:function(t){t?(this.commands.addCommand(a),this.on("changeMode",O),O(0,this)):(this.commands.removeCommand(a),this.off("changeMode",O))},value:!1}})}),ace.require(["ace/ext/language_tools"],function(X){ie&&(ie.exports=X)})},3330:function(ie,g,V){ie=V.nmd(ie),ace.define("ace/ext/searchbox.css",["require","exports","module"],function(X,k,G){G.exports=`

/* ------------------------------------------------------------------------------------------
 * Editor Search Form
 * --------------------------------------------------------------------------------------- */
.ace_search {
    background-color: #ddd;
    color: #666;
    border: 1px solid #cbcbcb;
    border-top: 0 none;
    overflow: hidden;
    margin: 0;
    padding: 4px 6px 0 4px;
    position: absolute;
    top: 0;
    z-index: 99;
    white-space: normal;
}
.ace_search.left {
    border-left: 0 none;
    border-radius: 0px 0px 5px 0px;
    left: 0;
}
.ace_search.right {
    border-radius: 0px 0px 0px 5px;
    border-right: 0 none;
    right: 0;
}

.ace_search_form, .ace_replace_form {
    margin: 0 20px 4px 0;
    overflow: hidden;
    line-height: 1.9;
}
.ace_replace_form {
    margin-right: 0;
}
.ace_search_form.ace_nomatch {
    outline: 1px solid red;
}

.ace_search_field {
    border-radius: 3px 0 0 3px;
    background-color: white;
    color: black;
    border: 1px solid #cbcbcb;
    border-right: 0 none;
    outline: 0;
    padding: 0;
    font-size: inherit;
    margin: 0;
    line-height: inherit;
    padding: 0 6px;
    min-width: 17em;
    vertical-align: top;
    min-height: 1.8em;
    box-sizing: content-box;
}
.ace_searchbtn {
    border: 1px solid #cbcbcb;
    line-height: inherit;
    display: inline-block;
    padding: 0 6px;
    background: #fff;
    border-right: 0 none;
    border-left: 1px solid #dcdcdc;
    cursor: pointer;
    margin: 0;
    position: relative;
    color: #666;
}
.ace_searchbtn:last-child {
    border-radius: 0 3px 3px 0;
    border-right: 1px solid #cbcbcb;
}
.ace_searchbtn:disabled {
    background: none;
    cursor: default;
}
.ace_searchbtn:hover {
    background-color: #eef1f6;
}
.ace_searchbtn.prev, .ace_searchbtn.next {
     padding: 0px 0.7em
}
.ace_searchbtn.prev:after, .ace_searchbtn.next:after {
     content: "";
     border: solid 2px #888;
     width: 0.5em;
     height: 0.5em;
     border-width:  2px 0 0 2px;
     display:inline-block;
     transform: rotate(-45deg);
}
.ace_searchbtn.next:after {
     border-width: 0 2px 2px 0 ;
}
.ace_searchbtn_close {
    background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;
    border-radius: 50%;
    border: 0 none;
    color: #656565;
    cursor: pointer;
    font: 16px/16px Arial;
    padding: 0;
    height: 14px;
    width: 14px;
    top: 9px;
    right: 7px;
    position: absolute;
}
.ace_searchbtn_close:hover {
    background-color: #656565;
    background-position: 50% 100%;
    color: white;
}

.ace_button {
    margin-left: 2px;
    cursor: pointer;
    -webkit-user-select: none;
    -moz-user-select: none;
    -o-user-select: none;
    -ms-user-select: none;
    user-select: none;
    overflow: hidden;
    opacity: 0.7;
    border: 1px solid rgba(100,100,100,0.23);
    padding: 1px;
    box-sizing:    border-box!important;
    color: black;
}

.ace_button:hover {
    background-color: #eee;
    opacity:1;
}
.ace_button:active {
    background-color: #ddd;
}

.ace_button.checked {
    border-color: #3399ff;
    opacity:1;
}

.ace_search_options{
    margin-bottom: 3px;
    text-align: right;
    -webkit-user-select: none;
    -moz-user-select: none;
    -o-user-select: none;
    -ms-user-select: none;
    user-select: none;
    clear: both;
}

.ace_search_counter {
    float: left;
    font-family: arial;
    padding: 0 8px;
}`}),ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/ext/searchbox.css","ace/keyboard/hash_handler","ace/lib/keys"],function(X,k,G){function O(A,x,p){var a=D.createElement("div");D.buildDom(["div",{class:"ace_search right"},["span",{action:"hide",class:"ace_searchbtn_close"}],["div",{class:"ace_search_form"},["input",{class:"ace_search_field",placeholder:"Search for",spellcheck:"false"}],["span",{action:"findPrev",class:"ace_searchbtn prev"},"\u200B"],["span",{action:"findNext",class:"ace_searchbtn next"},"\u200B"],["span",{action:"findAll",class:"ace_searchbtn",title:"Alt-Enter"},"All"]],["div",{class:"ace_replace_form"},["input",{class:"ace_search_field",placeholder:"Replace with",spellcheck:"false"}],["span",{action:"replaceAndFindNext",class:"ace_searchbtn"},"Replace"],["span",{action:"replaceAll",class:"ace_searchbtn"},"All"]],["div",{class:"ace_search_options"},["span",{action:"toggleReplace",class:"ace_button",title:"Toggle Replace mode",style:"float:left;margin-top:-2px;padding:0 5px;"},"+"],["span",{class:"ace_search_counter"}],["span",{action:"toggleRegexpMode",class:"ace_button",title:"RegExp Search"},".*"],["span",{action:"toggleCaseSensitive",class:"ace_button",title:"CaseSensitive Search"},"Aa"],["span",{action:"toggleWholeWords",class:"ace_button",title:"Whole Word Search"},"\\b"],["span",{action:"searchInSelection",class:"ace_button",title:"Search In Selection"},"S"]]],a),this.element=a.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(A),D.importCssString(L,"ace_searchbox",A.container)}var D=X("../lib/dom"),N=X("../lib/lang"),M=X("../lib/event"),L=X("./searchbox.css"),C=X("../keyboard/hash_handler").HashHandler,m=X("../lib/keys");D.importCssString(L,"ace_searchbox",!1),function(){this.setEditor=function(A){A.searchBox=this,A.renderer.scroller.appendChild(this.element),this.editor=A},this.setSession=function(A){this.searchRange=null,this.$syncOptions(!0)},this.$initElements=function(A){this.searchBox=A.querySelector(".ace_search_form"),this.replaceBox=A.querySelector(".ace_replace_form"),this.searchOption=A.querySelector("[action=searchInSelection]"),this.replaceOption=A.querySelector("[action=toggleReplace]"),this.regExpOption=A.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=A.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=A.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=A.querySelector(".ace_search_counter")},this.$init=function(){var A=this.element,x=(this.$initElements(A),this);M.addListener(A,"mousedown",function(p){setTimeout(function(){x.activeInput.focus()},0),M.stopPropagation(p)}),M.addListener(A,"click",function(p){var a=(p.target||p.srcElement).getAttribute("action");a&&x[a]?x[a]():x.$searchBarKb.commands[a]&&x.$searchBarKb.commands[a].exec(x),M.stopPropagation(p)}),M.addCommandKeyListener(A,function(p,a,l){l=m.keyCodeToString(l),a=x.$searchBarKb.findKeyCommand(a,l),a&&a.exec&&(a.exec(x),M.stopEvent(p))}),this.$onChange=N.delayedCall(function(){x.find(!1,!1)}),M.addListener(this.searchInput,"input",function(){x.$onChange.schedule(20)}),M.addListener(this.searchInput,"focus",function(){x.activeInput=x.searchInput,x.searchInput.value&&x.highlight()}),M.addListener(this.replaceInput,"focus",function(){x.activeInput=x.replaceInput,x.searchInput.value&&x.highlight()})},this.$closeSearchBarKb=new C([{bindKey:"Esc",name:"closeSearchBar",exec:function(A){A.searchBox.hide()}}]),this.$searchBarKb=new C,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(A){var x=A.isReplace=!A.isReplace;A.replaceBox.style.display=x?"":"none",A.replaceOption.checked=!1,A.$syncOptions(),A.searchInput.focus()},"Ctrl-H|Command-Option-F":function(A){A.editor.getReadOnly()||(A.replaceOption.checked=!0,A.$syncOptions(),A.replaceInput.focus())},"Ctrl-G|Command-G":function(A){A.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(A){A.findPrev()},esc:function(A){setTimeout(function(){A.hide()})},Return:function(A){A.activeInput==A.replaceInput&&A.replace(),A.findNext()},"Shift-Return":function(A){A.activeInput==A.replaceInput&&A.replace(),A.findPrev()},"Alt-Return":function(A){A.activeInput==A.replaceInput&&A.replaceAll(),A.findAll()},Tab:function(A){(A.activeInput==A.replaceInput?A.searchInput:A.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(A){A.regExpOption.checked=!A.regExpOption.checked,A.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(A){A.caseSensitiveOption.checked=!A.caseSensitiveOption.checked,A.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(A){A.wholeWordOption.checked=!A.wholeWordOption.checked,A.$syncOptions()}},{name:"toggleReplace",exec:function(A){A.replaceOption.checked=!A.replaceOption.checked,A.$syncOptions()}},{name:"searchInSelection",exec:function(A){A.searchOption.checked=!A.searchRange,A.setSearchRange(A.searchOption.checked&&A.editor.getSelectionRange()),A.$syncOptions()}}]),this.setSearchRange=function(A){(this.searchRange=A)?this.searchRangeMarker=this.editor.session.addMarker(A,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},this.$syncOptions=function(A){D.setCssClass(this.replaceOption,"checked",this.searchRange),D.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",D.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),D.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),D.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked);var x=this.editor.getReadOnly();this.replaceOption.style.display=x?"none":"",this.replaceBox.style.display=this.replaceOption.checked&&!x?"":"none",this.find(!1,!1,A)},this.highlight=function(A){this.editor.session.highlight(A||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(A,x,p){A=!this.editor.find(this.searchInput.value,{skipCurrent:A,backwards:x,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:p,range:this.searchRange})&&this.searchInput.value,D.setCssClass(this.searchBox,"ace_nomatch",A),this.editor._emit("findSearchBox",{match:!A}),this.highlight(),this.updateCounter()},this.updateCounter=function(){var A=this.editor,x=A.$search.$options.re,p=0,a=0;if(x){var l,n,i=this.searchRange?A.session.getTextRange(this.searchRange):A.getValue(),t=A.session.doc.positionToIndex(A.selection.anchor);for(this.searchRange&&(t-=A.session.doc.positionToIndex(this.searchRange.start)),x.lastIndex=0;(n=x.exec(i))&&((l=n.index)<=t&&a++,!(999<++p))&&(n[0]||(x.lastIndex=l+=1,!(l>=i.length))););}this.searchCounter.textContent=a+" of "+(999<p?"999+":p)},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){var A=!this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked})&&this.searchInput.value;D.setCssClass(this.searchBox,"ace_nomatch",A),this.editor._emit("findSearchBox",{match:!A}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(A,x){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=x,A&&(this.searchInput.value=A),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},this.isFocused=function(){var A=document.activeElement;return A==this.searchInput||A==this.replaceInput}}.call(O.prototype),k.SearchBox=O,k.Search=function(A,x){(A.searchBox||new O(A)).show(A.session.getTextRange(),x)}}),ace.require(["ace/ext/searchbox"],function(X){ie&&(ie.exports=X)})},4091:function(ie,g,V){ie=V.nmd(ie),ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(N,k,G){function O(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"punctuation.operator",regex:/[,]/},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}}var D=N("../lib/oop"),N=N("./text_highlight_rules").TextHighlightRules;D.inherits(O,N),k.JsonHighlightRules=O}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(X,k,G){function O(){}var D=X("../range").Range;(function(){this.checkOutdent=function(N,M){return!!/^\s+$/.test(N)&&/^\s*\}/.test(M)},this.autoOutdent=function(N,M){var L,C=N.getLine(M).match(/^(\s*\})/);return C&&(C=C[1].length,(L=N.findMatchingBracket({row:M,column:C}))&&L.row!=M)?(L=this.$getIndent(N.getLine(L.row)),void N.replace(new D(M,0,M,C-1),L)):0},this.$getIndent=function(N){return N.match(/^\s*/)[0]}}).call(O.prototype),k.MatchingBraceOutdent=O}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(N,M,G){var O=N("../../lib/oop"),D=N("../../range").Range,N=N("./fold_mode").FoldMode,M=M.FoldMode=function(L){L&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+L.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+L.end)))};O.inherits(M,N),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(L,C,m){var A=L.getLine(m);return!this.singleLineBlockCommentRe.test(A)||this.startRegionRe.test(A)||this.tripleStarBlockCommentRe.test(A)?!(L=this._getFoldWidgetBase(L,C,m))&&this.startRegionRe.test(A)?"start":L:""},this.getFoldWidgetRange=function(L,C,m,A){var x,p,a,l=L.getLine(m);return this.startRegionRe.test(l)?this.getCommentRegionBlock(L,l,m):(p=l.match(this.foldingStartMarker))?(a=p.index,p[1]?this.openingBracketBlock(L,p[1],m,a):((x=L.getCommentFoldRange(m,a+p[0].length,1))&&!x.isMultiLine()&&(A?x=this.getSectionRange(L,m):C!="all"&&(x=null)),x)):C!=="markbegin"&&(p=l.match(this.foldingStopMarker))?(a=p.index+p[0].length,p[1]?this.closingBracketBlock(L,p[1],m,a):L.getCommentFoldRange(m,a,-1)):void 0},this.getSectionRange=function(L,C){for(var m=(l=L.getLine(C)).search(/\S/),A=C,x=l.length,p=C+=1,a=L.getLength();++C<a;){var l,n=(l=L.getLine(C)).search(/\S/);if(n!==-1){if(n<m)break;var i=this.getFoldWidgetRange(L,"all",C);if(i){if(i.start.row<=A)break;if(i.isMultiLine())C=i.end.row;else if(m==n)break}p=C}}return new D(A,x,p,L.getLine(p).length)},this.getCommentRegionBlock=function(L,C,m){for(var A=C.search(/\s*$/),x=L.getLength(),p=m,a=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,l=1;++m<x;){C=L.getLine(m);var n=a.exec(C);if(n&&(n[1]?l--:l++,!l))break}if(p<m)return new D(p,A,m,C.length)}}.call(M.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(X,k,G){function O(){this.HighlightRules=M,this.$outdent=new L,this.$behaviour=new C,this.foldingRules=new m}var D=X("../lib/oop"),N=X("./text").Mode,M=X("./json_highlight_rules").JsonHighlightRules,L=X("./matching_brace_outdent").MatchingBraceOutdent,C=X("./behaviour/cstyle").CstyleBehaviour,m=X("./folding/cstyle").FoldMode,A=X("../worker/worker_client").WorkerClient;D.inherits(O,N),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(x,p,a){var l=this.$getIndent(p);return x=="start"&&p.match(/^.*[\{\(\[]\s*$/)&&(l+=a),l},this.checkOutdent=function(x,p,a){return this.$outdent.checkOutdent(p,a)},this.autoOutdent=function(x,p,a){this.$outdent.autoOutdent(p,a)},this.createWorker=function(x){var p=new A(["ace"],"ace/mode/json_worker","JsonWorker");return p.attachToDocument(x.getDocument()),p.on("annotate",function(a){x.setAnnotations(a.data)}),p.on("terminate",function(){x.clearAnnotations()}),p},this.$id="ace/mode/json"}.call(O.prototype),k.Mode=O}),ace.require(["ace/mode/json"],function(X){ie&&(ie.exports=X)})},8903:function(m,g,V){var X=V(5689),k=V(3969),G=V(5255),O=V(4293),D=V(3508),N=V(3368),M=V(742),L=V(9394),C=V(3724),m=((m.exports=a).prototype.validate=function(o,c){var d;if(typeof o=="string"){if(!(d=this.getSchema(o)))throw new Error('no schema with key or ref "'+o+'"')}else o=this._addSchema(o),d=o.validate||this._compile(o);return o=d(c),d.$async!==!0&&(this.errors=d.errors),o},a.prototype.compile=function(o,c){return o=this._addSchema(o,void 0,c),o.validate||this._compile(o)},a.prototype.addSchema=function(o,c,d,b){if(Array.isArray(o))for(var I=0;I<o.length;I++)this.addSchema(o[I],void 0,d,b);else{var h=this._getId(o);if(h!==void 0&&typeof h!="string")throw new Error("schema id must be string");r(this,c=k.normalizeId(c||h)),this._schemas[c]=this._addSchema(o,d,b,!0)}return this},a.prototype.addMetaSchema=function(o,c,d){return this.addSchema(o,c,d,!0),this},a.prototype.validateSchema=function(o,c){var d=o.$schema;if(d!==void 0&&typeof d!="string")throw new Error("$schema must be a string");if(!(d=d||this._opts.defaultMeta||function(b){var I=b._opts.meta;return b._opts.defaultMeta=typeof I=="object"?b._getId(I)||I:b.getSchema(A)?A:void 0,b._opts.defaultMeta}(this)))return this.logger.warn("meta-schema not available"),!(this.errors=null);if(d=this.validate(d,o),!d&&c){if(o="schema is invalid: "+this.errorsText(),this._opts.validateSchema!="log")throw new Error(o);this.logger.error(o)}return d},a.prototype.getSchema=function(o){var c=l(this,o);switch(typeof c){case"object":return c.validate||this._compile(c);case"string":return this.getSchema(c);case"undefined":return function(d,b){var I=k.schema.call(d,{schema:{}},b);{var h,u,y;if(I)return h=I.schema,u=I.root,I=I.baseId,y=X.call(d,h,u,void 0,I),d._fragments[b]=new O({ref:b,fragment:!0,schema:h,root:u,baseId:I,validate:y}),y}}(this,o)}},a.prototype.removeSchema=function(o){if(o instanceof RegExp)n(this,this._schemas,o),n(this,this._refs,o);else switch(typeof o){case"undefined":return n(this,this._schemas),n(this,this._refs),this._cache.clear(),this;case"string":var c=l(this,o);return c&&this._cache.del(c.cacheKey),delete this._schemas[o],delete this._refs[o],this;case"object":c=this._opts.serialize,c=c?c(o):o,c=(this._cache.del(c),this._getId(o)),c&&(c=k.normalizeId(c),delete this._schemas[c],delete this._refs[c])}return this},a.prototype.addFormat=function(o,c){return typeof c=="string"&&(c=new RegExp(c)),this._formats[o]=c,this},a.prototype.errorsText=function(o,c){if(!(o=o||this.errors))return"No errors";for(var d=(c=c||{}).separator===void 0?", ":c.separator,b=c.dataVar===void 0?"data":c.dataVar,I="",h=0;h<o.length;h++){var u=o[h];u&&(I+=b+u.dataPath+" "+u.message+d)}return I.slice(0,-d.length)},a.prototype._addSchema=function(o,y,d,b){if(typeof o!="object"&&typeof o!="boolean")throw new Error("schema should be object or boolean");var I=this._opts.serialize,I=I?I(o):o,h=this._cache.get(I);if(h)return h;b=b||this._opts.addUsedSchema!==!1,h=k.normalizeId(this._getId(o)),h&&b&&r(this,h);var u,y=this._opts.validateSchema!==!1&&!y;y&&!(u=h&&h==k.normalizeId(o.$schema))&&this.validateSchema(o,!0);var w=k.ids.call(this,o),w=new O({id:h,schema:o,localRefs:w,cacheKey:I,meta:d});return h[0]!="#"&&b&&(this._refs[h]=w),this._cache.put(I,w),y&&u&&this.validateSchema(o,!0),w},a.prototype._compile=function(o,c){if(o.compiling)return(o.validate=I).schema=o.schema,I.errors=null,I.root=c||I,o.schema.$async===!0&&(I.$async=!0),I;var d,b;o.compiling=!0,o.meta&&(d=this._opts,this._opts=this._metaOpts);try{b=X.call(this,o.schema,c,o.localRefs)}catch(h){throw delete o.validate,h}finally{o.compiling=!1,o.meta&&(this._opts=d)}return o.validate=b,o.refs=b.refs,o.refVal=b.refVal,o.root=b.root,b;function I(){var h=o.validate,u=h.apply(this,arguments);return I.errors=h.errors,u}},a.prototype.compileAsync=V(9677),V(7931)),m=(a.prototype.addKeyword=m.add,a.prototype.getKeyword=m.get,a.prototype.removeKeyword=m.remove,a.prototype.validateKeyword=m.validate,V(5359)),A=(a.ValidationError=m.Validation,a.MissingRefError=m.MissingRef,a.$dataMetaSchema=L,"http://json-schema.org/draft-07/schema"),x=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],p=["/properties"];function a(o){if(!(this instanceof a))return new a(o);o=this._opts=C.copy(o)||{};var v=this,c=v._opts.logger;if(c===!1)v.logger={log:s,warn:s,error:s};else{if(!(typeof(c=c===void 0?console:c)=="object"&&c.log&&c.warn&&c.error))throw new Error("logger must implement log, warn and error methods");v.logger=c}if(this._schemas={},this._refs={},this._fragments={},this._formats=N(o.format),this._cache=o.cache||new G,this._loadingSchemas={},this._compilations=[],this.RULES=M(),this._getId=function(_){switch(_.schemaId){case"auto":return e;case"id":return i;default:return t}}(o),o.loopRequired=o.loopRequired||1/0,o.errorDataPath=="property"&&(o._errorDataPathProperty=!0),o.serialize===void 0&&(o.serialize=D),this._metaOpts=function(_){for(var P=C.copy(_._opts),H=0;H<x.length;H++)delete P[x[H]];return P}(this),o.formats){var d,b=this;for(d in b._opts.formats){var I=b._opts.formats[d];b.addFormat(d,I)}}if(o.keywords){var h,u=this;for(h in u._opts.keywords){var y=u._opts.keywords[h];u.addKeyword(h,y)}}var w,v=this,T=(v._opts.$data&&(w=V(894),v.addMetaSchema(w,w.$id,!0)),v._opts.meta!==!1&&(w=V(6680),v._opts.$data&&(w=L(w,p)),v.addMetaSchema(w,A,!0),v._refs["http://json-schema.org/schema"]=A),typeof o.meta=="object"&&this.addMetaSchema(o.meta),o.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}}),this),B=T._opts.schemas;if(B)if(Array.isArray(B))T.addSchema(B);else for(var E in B)T.addSchema(B[E],E)}function l(o,c){return c=k.normalizeId(c),o._schemas[c]||o._refs[c]||o._fragments[c]}function n(o,c,d){for(var b in c){var I=c[b];I.meta||d&&!d.test(b)||(o._cache.del(I.cacheKey),delete c[b])}}function i(o){return o.$id&&this.logger.warn("schema $id ignored",o.$id),o.id}function t(o){return o.id&&this.logger.warn("schema id ignored",o.id),o.$id}function e(o){if(o.$id&&o.id&&o.$id!=o.id)throw new Error("schema $id is different from id");return o.$id||o.id}function r(o,c){if(o._schemas[c]||o._refs[c])throw new Error('schema with key or id "'+c+'" already exists')}function s(){}},5255:function(ie){ie=ie.exports=function(){this._cache={}},ie.prototype.put=function(g,V){this._cache[g]=V},ie.prototype.get=function(g){return this._cache[g]},ie.prototype.del=function(g){delete this._cache[g]},ie.prototype.clear=function(){this._cache={}}},9677:function(ie,g,V){var X=V(5359).MissingRef;function k(G,O,D){var N=this;if(typeof this._opts.loadSchema!="function")throw new Error("options.loadSchema should be a function");typeof O=="function"&&(D=O,O=void 0);var M=L(G).then(function(){var C=N._addSchema(G,void 0,O);return C.validate||function m(A){try{return N._compile(A)}catch(p){if(p instanceof X)return x(p);throw p}function x(p){var a=p.missingSchema;if(n(a))throw new Error("Schema "+a+" is loaded but "+p.missingRef+" cannot be resolved");return p=N._loadingSchemas[a],p||(p=N._loadingSchemas[a]=N._opts.loadSchema(a)).then(l,l),p.then(function(i){if(!n(a))return L(i).then(function(){n(a)||N.addSchema(i,a,void 0,O)})}).then(function(){return m(A)});function l(){delete N._loadingSchemas[a]}function n(i){return N._refs[i]||N._schemas[i]}}}(C)});return D&&M.then(function(C){D(null,C)},D),M;function L(C){return C=C.$schema,C&&!N.getSchema(C)?k.call(N,{$ref:C},!0):Promise.resolve()}}ie.exports=k},5359:function(ie,g,V){var X=V(3969);function k(O,D,N){this.message=N||k.message(O,D),this.missingRef=X.url(O,D),this.missingSchema=X.normalizeId(X.fullPath(this.missingRef))}function G(O){return O.prototype=Object.create(Error.prototype),O.prototype.constructor=O}ie.exports={Validation:G(function(O){this.message="validation failed",this.errors=O,this.ajv=this.validation=!0}),MissingRef:G(k)},k.message=function(O,D){return"can't resolve reference "+D+" from id "+O}},3368:function(ie,g,D){var X=D(3724),k=/^(\d\d\d\d)-(\d\d)-(\d\d)$/,G=[0,31,28,31,30,31,30,31,31,30,31,30,31],O=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i,D=/^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i,N=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,M=/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,L=/^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i,C=/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,m=/^(?:\/(?:[^~/]|~0|~1)*)*$/,A=/^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,x=/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;function p(r){return X.copy(p[r=r=="full"?"full":"fast"])}function a(c){var s,o,c=c.match(k);return!!c&&(s=+c[1],o=+c[2],c=+c[3],1<=o&&o<=12&&1<=c&&c<=(o!=2||(c=s)%4!=0||c%100==0&&c%400!=0?G[o]:29))}function l(b,s){var o,c,d,b=b.match(O);return!!b&&(o=b[1],c=b[2],d=b[3],b=b[5],(o<=23&&c<=59&&d<=59||o==23&&c==59&&d==60)&&(!s||b))}(ie.exports=p).fast={date:/^\d\d\d\d-[0-1]\d-[0-3]\d$/,time:/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,"date-time":/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,uri:/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,"uri-reference":/^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,"uri-template":M,url:L,email:/^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,hostname:D,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:e,uuid:C,"json-pointer":m,"json-pointer-uri-fragment":A,"relative-json-pointer":x},p.full={date:a,time:l,"date-time":function(r){return r=r.split(n),r.length==2&&a(r[0])&&l(r[1],!0)},uri:function(r){return i.test(r)&&N.test(r)},"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,"uri-template":M,url:L,email:/^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:D,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:e,uuid:C,"json-pointer":m,"json-pointer-uri-fragment":A,"relative-json-pointer":x};var n=/t|\s/i,i=/\/|:/,t=/[^\\]\\Z/;function e(r){if(t.test(r))return!1;try{return new RegExp(r),!0}catch{return!1}}},5689:function(ie,g,V){var X=V(3969),k=V(3724),G=V(5359),O=V(3508),D=V(1869),N=k.ucs2length,M=V(2303),L=G.Validation;function C(n,i,t,e){var r=this,s=this._opts,o=[void 0],c={},d=[],b={},I=[],h={},u=[],y=(i=i||{schema:n,refVal:o,refs:c},function(W,f,S){var $=m.call(this,W,f,S);return 0<=$?{index:$,compiling:!0}:($=this._compilations.length,this._compilations[$]={schema:W,root:f,baseId:S},{index:$,compiling:!1})}.call(this,n,i,e)),w=this._compilations[y.index];if(y.compiling)return w.callValidate=_;var v=this._formats,T=this.RULES;try{var B=P(n,i,t,e),E=(w.validate=B,w.callValidate);return E&&(E.schema=B.schema,E.errors=null,E.refs=B.refs,E.refVal=B.refVal,E.root=B.root,E.$async=B.$async,s.sourceCode&&(E.source=B.source)),B}finally{(function(W,f,S){W=m.call(this,W,f,S),0<=W&&this._compilations.splice(W,1)}).call(this,n,i,e)}function _(){var W=w.validate,f=W.apply(this,arguments);return _.errors=W.errors,f}function P(W,f,S,$){var F=!f||f.schema==W;if(f.schema!=i.schema)return C.call(r,W,f,S,$);S=W.$async===!0,$=D({isTop:!0,schema:W,isRoot:F,baseId:$,root:f,schemaPath:"",errSchemaPath:"#",errorPath:'""',MissingRefError:G.MissingRef,RULES:T,validate:D,util:k,resolve:X,resolveRef:H,usePattern:Y,useDefault:R,useCustomRule:Z,opts:s,formats:v,logger:r.logger,self:r}),$=l(o,p)+l(d,A)+l(I,x)+l(u,a)+$,s.processCode&&($=s.processCode($,W));try{var j=new Function("self","RULES","formats","root","refVal","defaults","customRules","equal","ucs2length","ValidationError",$)(r,T,v,i,o,I,u,M,N,L);o[0]=j}catch(Q){throw r.logger.error("Error compiling schema, function code:",$),Q}return j.schema=W,j.errors=null,j.refs=c,j.refVal=o,j.root=F?j:f,S&&(j.$async=!0),s.sourceCode===!0&&(j.source={code:$,patterns:d,defaults:I}),j}function H(W,f,Q){f=X.url(W,f);var $=c[f];if($!==void 0)return K(F=o[$],j="refVal["+$+"]");if(!Q&&i.refs&&($=i.refs[f],$!==void 0))return K(F=i.refVal[$],j=z(f,F));var F,j=z(f),Q=X.call(r,P,i,f);if(Q!==void 0||($=t&&t[f])&&(Q=X.inlineRef($,s.inlineRefs)?$:C.call(r,$,i,t,W)),Q!==void 0)return F=Q,$=c[$=f],o[$]=F,K(Q,j);delete c[f]}function z(W,f){var S=o.length;return o[S]=f,"refVal"+(c[W]=S)}function K(W,f){return typeof W=="object"||typeof W=="boolean"?{code:f,schema:W,inline:!0}:{code:f,$async:W&&!!W.$async}}function Y(W){var f=b[W];return f===void 0&&(f=b[W]=d.length,d[f]=W),"pattern"+f}function R(W){switch(typeof W){case"boolean":case"number":return""+W;case"string":return k.toQuotedString(W);case"object":var f,S;return W===null?"null":(f=O(W),(S=h[f])===void 0&&(S=h[f]=I.length,I[S]=W),"default"+S)}}function Z(W,f,S,$){if(r._opts.validateSchema!==!1){var j=W.definition.dependencies;if(j&&!j.every(function(ve){return Object.prototype.hasOwnProperty.call(S,ve)}))throw new Error("parent schema must have all required keywords: "+j.join(","));if(j=W.definition.validateSchema,j&&!j(f)){if(j="keyword schema is invalid: "+r.errorsText(j.errors),r._opts.validateSchema!="log")throw new Error(j);r.logger.error(j)}}var F,j=W.definition.compile,Q=W.definition.inline,te=W.definition.macro;if(j)F=j.call(r,f,S,$);else if(te)F=te.call(r,f,S,$),s.validateSchema!==!1&&r.validateSchema(F,!0);else if(Q)F=Q.call(r,$,W.keyword,f,S);else if(!(F=W.definition.validate))return;if(F===void 0)throw new Error('custom keyword "'+W.keyword+'"failed to compile');return j=u.length,{code:"customRule"+j,validate:u[j]=F}}}function m(n,i,t){for(var e=0;e<this._compilations.length;e++){var r=this._compilations[e];if(r.schema==n&&r.root==i&&r.baseId==t)return e}return-1}function A(n,i){return"var pattern"+n+" = new RegExp("+k.toQuotedString(i[n])+");"}function x(n){return"var default"+n+" = defaults["+n+"];"}function p(n,i){return i[n]===void 0?"":"var refVal"+n+" = refVal["+n+"];"}function a(n){return"var customRule"+n+" = customRules["+n+"];"}function l(n,i){if(!n.length)return"";for(var t="",e=0;e<n.length;e++)t+=i(e,n);return t}ie.exports=C},3969:function(ie,g,V){var X=V(7533),k=V(2303),G=V(3724),O=V(4293),D=V(500);function N(i,t,e){var r,s,o,c=this._refs[e];if(typeof c=="string"){if(!this._refs[c])return N.call(this,i,t,c);c=this._refs[c]}return(c=c||this._schemas[e])instanceof O?A(c.schema,this._opts.inlineRefs)?c.schema:c.validate||this._compile(c):((c=M.call(this,t,e))&&(r=c.schema,t=c.root,o=c.baseId),r instanceof O?s=r.validate||i.call(this,r.schema,t,void 0,o):r!==void 0&&(s=A(r,this._opts.inlineRefs)?r:i.call(this,r,t,void 0,o)),s)}function M(i,t){var e=X.parse(t),r=p(e),s=x(this._getId(i.schema));if(Object.keys(i.schema).length===0||r!==s){var r=l(r),o=this._refs[r];if(typeof o=="string")return function(d,b,I){b=M.call(this,d,b);{var h,u;if(b)return h=b.schema,u=b.baseId,d=b.root,(b=this._getId(h))&&(u=n(u,b)),C.call(this,I,u,h,d)}}.call(this,i,o,e);if(o instanceof O)o.validate||this._compile(o);else{if(!((o=this._schemas[r])instanceof O))return;if(o.validate||this._compile(o),r==l(t))return{schema:o,root:i,baseId:s}}if(!(i=o).schema)return;s=x(this._getId(i.schema))}return C.call(this,e,s,i.schema,i)}(ie.exports=N).normalizeId=l,N.fullPath=x,N.url=n,N.ids=function(i){var t=l(this._getId(i)),e={"":t},r={"":x(t,!1)},s={},o=this;return D(i,{allKeys:!0},function(c,d,b,I,h,u,y){if(d!==""){var w=o._getId(c),v=e[I],I=r[I]+"/"+h;if(y!==void 0&&(I+="/"+(typeof y=="number"?y:G.escapeFragment(y))),typeof w=="string"){if(w=v=l(v?X.resolve(v,w):w),h=o._refs[w],(h=typeof h=="string"?o._refs[h]:h)&&h.schema){if(!k(c,h.schema))throw new Error('id "'+w+'" resolves to more than one schema')}else if(w!=l(I))if(w[0]=="#"){if(s[w]&&!k(c,s[w]))throw new Error('id "'+w+'" resolves to more than one schema');s[w]=c}else o._refs[w]=I}e[d]=v,r[d]=I}}),s},N.inlineRef=A,N.schema=M;var L=G.toHash(["properties","patternProperties","enum","dependencies","definitions"]);function C(i,t,e,r){if(i.fragment=i.fragment||"",i.fragment.slice(0,1)=="/"){for(var s=i.fragment.split("/"),o=1;o<s.length;o++){var c=s[o];if(c){if((e=e[c=G.unescapeFragment(c)])===void 0)break;L[c]||((c=this._getId(e))&&(t=n(t,c)),e.$ref&&(c=n(t,e.$ref),(c=M.call(this,r,c))&&(e=c.schema,r=c.root,t=c.baseId)))}}return e!==void 0&&e!==r.schema?{schema:e,root:r,baseId:t}:void 0}}var m=G.toHash(["type","format","pattern","maxLength","minLength","maxProperties","minProperties","maxItems","minItems","maximum","minimum","uniqueItems","multipleOf","required","enum"]);function A(i,t){return t!==!1&&(t===void 0||t===!0?function e(r){var s;if(Array.isArray(r)){for(var o=0;o<r.length;o++)if(typeof(s=r[o])=="object"&&!e(s))return!1}else for(var c in r)if(c=="$ref"||typeof(s=r[c])=="object"&&!e(s))return!1;return!0}(i):t?function e(r){var s,o=0;if(Array.isArray(r)){for(var c=0;c<r.length;c++)if(typeof(s=r[c])=="object"&&(o+=e(s)),o==1/0)return 1/0}else for(var d in r){if(d=="$ref")return 1/0;if(m[d])o++;else if(typeof(s=r[d])=="object"&&(o+=e(s)+1),o==1/0)return 1/0}return o}(i)<=t:void 0)}function x(i,t){return t!==!1&&(i=l(i)),p(X.parse(i))}function p(i){return X.serialize(i).split("#")[0]+"#"}var a=/#\/?$/;function l(i){return i?i.replace(a,""):""}function n(i,t){return t=l(t),X.resolve(i,t)}},742:function(ie,g,V){var X=V(9646),k=V(3724).toHash;ie.exports=function(){var G=[{type:"number",rules:[{maximum:["exclusiveMaximum"]},{minimum:["exclusiveMinimum"]},"multipleOf","format"]},{type:"string",rules:["maxLength","minLength","pattern","format"]},{type:"array",rules:["maxItems","minItems","items","contains","uniqueItems"]},{type:"object",rules:["maxProperties","minProperties","required","dependencies","propertyNames",{properties:["additionalProperties","patternProperties"]}]},{rules:["$ref","const","enum","not","anyOf","oneOf","allOf","if"]}],O=["type","$comment"];return G.all=k(O),G.types=k(["number","integer","string","array","object","boolean","null"]),G.forEach(function(D){D.rules=D.rules.map(function(N){var M,L;return typeof N=="object"&&(L=N[M=Object.keys(N)[0]],N=M,L.forEach(function(C){O.push(C),G.all[C]=!0})),O.push(N),G.all[N]={keyword:N,code:X[N],implements:L}}),G.all.$comment={keyword:"$comment",code:X.$comment},D.type&&(G.types[D.type]=D)}),G.keywords=k(O.concat(["$schema","$id","id","$data","$async","title","description","default","definitions","examples","readOnly","writeOnly","contentMediaType","contentEncoding","additionalItems","then","else"])),G.custom={},G}},4293:function(ie,g,V){var X=V(3724);ie.exports=function(k){X.copy(k,this)}},6887:function(ie){ie.exports=function(g){for(var V,X=0,k=g.length,G=0;G<k;)X++,55296<=(V=g.charCodeAt(G++))&&V<=56319&&G<k&&(64512&(V=g.charCodeAt(G)))==56320&&G++;return X}},3724:function(ie,g,V){function X(a,l,n,i){var t=i?" !== ":" === ",e=i?" || ":" && ",r=i?"!":"",s=i?"":"!";switch(a){case"null":return l+t+"null";case"array":return r+"Array.isArray("+l+")";case"object":return"("+r+l+e+"typeof "+l+t+'"object"'+e+s+"Array.isArray("+l+"))";case"integer":return"(typeof "+l+t+'"number"'+e+s+"("+l+" % 1)"+e+l+t+l+(n?e+r+"isFinite("+l+")":"")+")";case"number":return"(typeof "+l+t+'"'+a+'"'+(n?e+r+"isFinite("+l+")":"")+")";default:return"typeof "+l+t+'"'+a+'"'}}ie.exports={copy:function(a,l){for(var n in l=l||{},a)l[n]=a[n];return l},checkDataType:X,checkDataTypes:function(a,l,n){{if(a.length===1)return X(a[0],l,n,!0);var i,t="",a=G(a);for(i in a.array&&a.object&&(t=a.null?"(":"(!"+l+" || ",t+="typeof "+l+' !== "object")',delete a.null,delete a.array,delete a.object),a.number&&delete a.integer,a)t+=(t?" && ":"")+X(i,l,n,!0);return t}},coerceToTypes:function(a,l){{if(!Array.isArray(l))return k[l]?[l]:a==="array"&&l==="array"?["array"]:void 0;for(var n=[],i=0;i<l.length;i++){var t=l[i];(k[t]||a==="array"&&t==="array")&&(n[n.length]=t)}return n.length?n:void 0}},toHash:G,getProperty:N,escapeQuotes:M,equal:V(2303),ucs2length:V(6887),varOccurences:function(a,l){return l+="[^0-9]",a=a.match(new RegExp(l,"g")),a?a.length:0},varReplace:function(a,l,n){return l+="([^0-9])",n=n.replace(/\$/g,"$$$$"),a.replace(new RegExp(l,"g"),n+"$1")},schemaHasRules:function(a,l){if(typeof a=="boolean")return!a;for(var n in a)if(l[n])return!0},schemaHasRulesExcept:function(a,l,n){if(typeof a=="boolean")return!a&&n!="not";for(var i in a)if(i!=n&&l[i])return!0},schemaUnknownRules:function(a,l){if(typeof a!="boolean"){for(var n in a)if(!l[n])return n}},toQuotedString:L,getPathExpr:function(a,l,n,i){return A(a,n?"'/' + "+l+(i?"":".replace(/~/g, '~0').replace(/\\//g, '~1')"):i?"'[' + "+l+" + ']'":"'[\\'' + "+l+" + '\\']'")},getPath:function(a,l,n){return n=L(n?"/"+x(l):N(l)),A(a,n)},getData:function(a,l,n){var i,t,e;if(a==="")return"rootData";if(a[0]=="/"){if(!C.test(a))throw new Error("Invalid JSON-pointer: "+a);i=a,t="rootData"}else{if(!(e=a.match(m)))throw new Error("Invalid JSON-pointer: "+a);if(a=+e[1],(i=e[2])=="#"){if(l<=a)throw new Error("Cannot access property/index "+a+" levels up, current level is "+l);return n[l-a]}if(l<a)throw new Error("Cannot access data "+a+" levels up, current level is "+l);if(t="data"+(l-a||""),!i)return t}for(var r=t,s=i.split("/"),o=0;o<s.length;o++){var c=s[o];c&&(t+=N(p(c)),r+=" && "+t)}return r},unescapeFragment:function(a){return p(decodeURIComponent(a))},unescapeJsonPointer:p,escapeFragment:function(a){return encodeURIComponent(x(a))},escapeJsonPointer:x};var k=G(["string","number","integer","boolean","null"]);function G(a){for(var l={},n=0;n<a.length;n++)l[a[n]]=!0;return l}var O=/^[a-z$_][a-z$_0-9]*$/i,D=/'|\\/g;function N(a){return typeof a=="number"?"["+a+"]":O.test(a)?"."+a:"['"+M(a)+"']"}function M(a){return a.replace(D,"\\$&").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\f/g,"\\f").replace(/\t/g,"\\t")}function L(a){return"'"+M(a)+"'"}var C=/^\/(?:[^~]|~0|~1)*$/,m=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;function A(a,l){return a=='""'?l:(a+" + "+l).replace(/([^\\])' \+ '/g,"$1")}function x(a){return a.replace(/~/g,"~0").replace(/\//g,"~1")}function p(a){return a.replace(/~1/g,"/").replace(/~0/g,"~")}},9394:function(ie){var g=["multipleOf","maximum","exclusiveMaximum","minimum","exclusiveMinimum","maxLength","minLength","pattern","additionalItems","maxItems","minItems","uniqueItems","maxProperties","minProperties","required","additionalProperties","enum","format","const"];ie.exports=function(V,X){for(var k=0;k<X.length;k++){V=JSON.parse(JSON.stringify(V));for(var G=X[k].split("/"),O=V,D=1;D<G.length;D++)O=O[G[D]];for(D=0;D<g.length;D++){var N=g[D],M=O[N];M&&(O[N]={anyOf:[M,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]})}}return V}},5868:function(ie,g,V){V=V(6680),ie.exports={$id:"https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js",definitions:{simpleTypes:V.definitions.simpleTypes},type:"object",dependencies:{schema:["validate"],$data:["validate"],statements:["inline"],valid:{not:{required:["macro"]}}},properties:{type:V.properties.type,schema:{type:"boolean"},statements:{type:"boolean"},dependencies:{type:"array",items:{type:"string"}},metaSchema:{type:"object"},modifying:{type:"boolean"},valid:{type:"boolean"},$data:{type:"boolean"},async:{type:"boolean"},errors:{anyOf:[{type:"boolean"},{const:"full"}]}}}},1796:function(ie){ie.exports=function(g,V,X){var k,G,O,D,N,M=" ",L=g.level,C=g.dataLevel,m=g.schema[V],A=g.schemaPath+g.util.getProperty(V),x=g.errSchemaPath+"/"+V,p=!g.opts.allErrors,a="data"+(C||""),l=g.opts.$data&&m&&m.$data,n=l?(M+=" var schema"+L+" = "+g.util.getData(m.$data,C,g.dataPathArr)+"; ","schema"+L):m,i=V=="maximum",t=i?"exclusiveMaximum":"exclusiveMinimum",e=g.schema[t],r=g.opts.$data&&e&&e.$data,s=i?"<":">",o=i?">":"<",c=void 0;if(!l&&typeof m!="number"&&m!==void 0)throw new Error(V+" must be number");if(!r&&e!==void 0&&typeof e!="number"&&typeof e!="boolean")throw new Error(t+" must be number or boolean");r?(C=g.util.getData(e.$data,C,g.dataPathArr),O="exclIsNumber"+L,D="' + "+(N="op"+L)+" + '",c=t,(d=d||[]).push(M=M+(" var schemaExcl"+L+" = "+C+"; ")+(" var "+(k="exclusive"+L)+"; var "+(G="exclType"+L)+" = typeof "+(C="schemaExcl"+L)+"; if ("+G+" != 'boolean' && "+G+" != 'undefined' && "+G+" != 'number') { ")),M="",g.createErrors!==!1?(M+=" { keyword: '"+(c||"_exclusiveLimit")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(x)+" , params: {} ",g.opts.messages!==!1&&(M+=" , message: '"+t+" should be boolean' "),g.opts.verbose&&(M+=" , schema: validate.schema"+A+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+a+" "),M+=" } "):M+=" {} ",b=M,M=d.pop(),!g.compositeRule&&p?g.async?M+=" throw new ValidationError(["+b+"]); ":M+=" validate.errors = ["+b+"]; return false; ":M+=" var err = "+b+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",M+=" } else if ( ",l&&(M+=" ("+n+" !== undefined && typeof "+n+" != 'number') || "),M+=" "+G+" == 'number' ? ( ("+k+" = "+n+" === undefined || "+C+" "+s+"= "+n+") ? "+a+" "+o+"= "+C+" : "+a+" "+o+" "+n+" ) : ( ("+k+" = "+C+" === true) ? "+a+" "+o+"= "+n+" : "+a+" "+o+" "+n+" ) || "+a+" !== "+a+") { var op"+L+" = "+k+" ? '"+s+"' : '"+s+"='; ",m===void 0&&(x=g.errSchemaPath+"/"+(c=t),n=C,l=r)):(D=s,(O=typeof e=="number")&&l?(N="'"+D+"'",M+=" if ( ",l&&(M+=" ("+n+" !== undefined && typeof "+n+" != 'number') || "),M+=" ( "+n+" === undefined || "+e+" "+s+"= "+n+" ? "+a+" "+o+"= "+e+" : "+a+" "+o+" "+n+" ) || "+a+" !== "+a+") { "):(O&&m===void 0?(k=!0,x=g.errSchemaPath+"/"+(c=t),n=e,o+="="):(O&&(n=Math[i?"min":"max"](e,m)),e===(!O||n)?(k=!0,x=g.errSchemaPath+"/"+(c=t),o+="="):(k=!1,D+="=")),N="'"+D+"'",M+=" if ( ",l&&(M+=" ("+n+" !== undefined && typeof "+n+" != 'number') || "),M+=" "+a+" "+o+" "+n+" || "+a+" !== "+a+") { ")),c=c||V,(d=d||[]).push(M),M="",g.createErrors!==!1?(M+=" { keyword: '"+(c||"_limit")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(x)+" , params: { comparison: "+N+", limit: "+n+", exclusive: "+k+" } ",g.opts.messages!==!1&&(M=M+" , message: 'should be "+D+" "+(l?"' + "+n:n+"'")),g.opts.verbose&&(M=(M+=" , schema:  ")+(l?"validate.schema"+A:""+m)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+a+" "),M+=" } "):M+=" {} ";var d,b=M;return M=d.pop(),!g.compositeRule&&p?g.async?M+=" throw new ValidationError(["+b+"]); ":M+=" validate.errors = ["+b+"]; return false; ":M+=" var err = "+b+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",M+=" } ",p&&(M+=" else { "),M}},2407:function(ie){ie.exports=function(g,V,X){var k,G=" ",O=g.level,A=g.dataLevel,D=g.schema[V],N=g.schemaPath+g.util.getProperty(V),M=g.errSchemaPath+"/"+V,L=!g.opts.allErrors,C="data"+(A||""),m=g.opts.$data&&D&&D.$data,A=m?(G+=" var schema"+O+" = "+g.util.getData(D.$data,A,g.dataPathArr)+"; ","schema"+O):D;if(m||typeof D=="number")return G+="if ( ",m&&(G+=" ("+A+" !== undefined && typeof "+A+" != 'number') || "),(O=[]).push(G+=" "+C+".length "+((k=V)=="maxItems"?">":"<")+" "+A+") { "),G="",g.createErrors!==!1?(G+=" { keyword: '"+(k||"_limitItems")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(M)+" , params: { limit: "+A+" } ",g.opts.messages!==!1&&(G=(G=(G+=" , message: 'should NOT have ")+(V=="maxItems"?"more":"fewer")+" than ")+(m?"' + "+A+" + '":""+D)+" items' "),g.opts.verbose&&(G=(G+=" , schema:  ")+(m?"validate.schema"+N:""+D)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+C+" "),G+=" } "):G+=" {} ",k=G,G=O.pop(),!g.compositeRule&&L?g.async?G+=" throw new ValidationError(["+k+"]); ":G+=" validate.errors = ["+k+"]; return false; ":G+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G+="} ",L&&(G+=" else { "),G;throw new Error(V+" must be number")}},1250:function(ie){ie.exports=function(g,V,X){var k,G=" ",O=g.level,A=g.dataLevel,D=g.schema[V],N=g.schemaPath+g.util.getProperty(V),M=g.errSchemaPath+"/"+V,L=!g.opts.allErrors,C="data"+(A||""),m=g.opts.$data&&D&&D.$data,A=m?(G+=" var schema"+O+" = "+g.util.getData(D.$data,A,g.dataPathArr)+"; ","schema"+O):D;if(m||typeof D=="number")return G+="if ( ",m&&(G+=" ("+A+" !== undefined && typeof "+A+" != 'number') || "),g.opts.unicode===!1?G+=" "+C+".length ":G+=" ucs2length("+C+") ",(O=[]).push(G+=" "+((k=V)=="maxLength"?">":"<")+" "+A+") { "),G="",g.createErrors!==!1?(G+=" { keyword: '"+(k||"_limitLength")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(M)+" , params: { limit: "+A+" } ",g.opts.messages!==!1&&(G=(G=(G+=" , message: 'should NOT be ")+(V=="maxLength"?"longer":"shorter")+" than ")+(m?"' + "+A+" + '":""+D)+" characters' "),g.opts.verbose&&(G=(G+=" , schema:  ")+(m?"validate.schema"+N:""+D)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+C+" "),G+=" } "):G+=" {} ",k=G,G=O.pop(),!g.compositeRule&&L?g.async?G+=" throw new ValidationError(["+k+"]); ":G+=" validate.errors = ["+k+"]; return false; ":G+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G+="} ",L&&(G+=" else { "),G;throw new Error(V+" must be number")}},2596:function(ie){ie.exports=function(g,V,X){var k,G=" ",O=g.level,A=g.dataLevel,D=g.schema[V],N=g.schemaPath+g.util.getProperty(V),M=g.errSchemaPath+"/"+V,L=!g.opts.allErrors,C="data"+(A||""),m=g.opts.$data&&D&&D.$data,A=m?(G+=" var schema"+O+" = "+g.util.getData(D.$data,A,g.dataPathArr)+"; ","schema"+O):D;if(m||typeof D=="number")return G+="if ( ",m&&(G+=" ("+A+" !== undefined && typeof "+A+" != 'number') || "),(O=[]).push(G+=" Object.keys("+C+").length "+((k=V)=="maxProperties"?">":"<")+" "+A+") { "),G="",g.createErrors!==!1?(G+=" { keyword: '"+(k||"_limitProperties")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(M)+" , params: { limit: "+A+" } ",g.opts.messages!==!1&&(G=(G=(G+=" , message: 'should NOT have ")+(V=="maxProperties"?"more":"fewer")+" than ")+(m?"' + "+A+" + '":""+D)+" properties' "),g.opts.verbose&&(G=(G+=" , schema:  ")+(m?"validate.schema"+N:""+D)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+C+" "),G+=" } "):G+=" {} ",k=G,G=O.pop(),!g.compositeRule&&L?g.async?G+=" throw new ValidationError(["+k+"]); ":G+=" validate.errors = ["+k+"]; return false; ":G+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G+="} ",L&&(G+=" else { "),G;throw new Error(V+" must be number")}},9486:function(ie){ie.exports=function(g,V,X){var k=" ",G=g.schema[V],O=g.schemaPath+g.util.getProperty(V),D=g.errSchemaPath+"/"+V,N=!g.opts.allErrors,M=g.util.copy(g),L="",C=(M.level++,"valid"+M.level),m=M.baseId,A=!0,x=G;if(x)for(var p,a=-1,l=x.length-1;a<l;)p=x[a+=1],(g.opts.strictKeywords?typeof p=="object"&&0<Object.keys(p).length||p===!1:g.util.schemaHasRules(p,g.RULES.all))&&(A=!1,M.schema=p,M.schemaPath=O+"["+a+"]",M.errSchemaPath=D+"/"+a,k+="  "+g.validate(M)+" ",M.baseId=m,N&&(k+=" if ("+C+") { ",L+="}"));return N&&(k+=A?" if (true) { ":" "+L.slice(0,-1)+" "),k}},5347:function(ie){ie.exports=function(g,N,X){var k=" ",C=g.level,M=g.dataLevel,G=g.schema[N],O=g.schemaPath+g.util.getProperty(N),D=g.errSchemaPath+"/"+N,N=!g.opts.allErrors,M="data"+(M||""),L="valid"+C,C="errs__"+C,m=g.util.copy(g),A="",x=(m.level++,"valid"+m.level);if(G.every(function(e){return g.opts.strictKeywords?typeof e=="object"&&0<Object.keys(e).length||e===!1:g.util.schemaHasRules(e,g.RULES.all)})){var p=m.baseId,a=(k+=" var "+C+" = errors; var "+L+" = false;  ",g.compositeRule),l=(g.compositeRule=m.compositeRule=!0,G);if(l)for(var n,i=-1,t=l.length-1;i<t;)n=l[i+=1],m.schema=n,m.schemaPath=O+"["+i+"]",m.errSchemaPath=D+"/"+i,k+="  "+g.validate(m)+" ",m.baseId=p,k+=" "+L+" = "+L+" || "+x+"; if (!"+L+") { ",A+="}";g.compositeRule=m.compositeRule=a,k+=" "+A+" if (!"+L+") {   var err =   ",g.createErrors!==!1?(k+=" { keyword: 'anyOf' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(D)+" , params: {} ",g.opts.messages!==!1&&(k+=" , message: 'should match some schema in anyOf' "),g.opts.verbose&&(k+=" , schema: validate.schema"+O+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+M+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!g.compositeRule&&N&&(g.async?k+=" throw new ValidationError(vErrors); ":k+=" validate.errors = vErrors; return false; "),k+=" } else {  errors = "+C+"; if (vErrors !== null) { if ("+C+") vErrors.length = "+C+"; else vErrors = null; } ",g.opts.allErrors&&(k+=" } ")}else N&&(k+=" if (true) { ");return k}},923:function(ie){ie.exports=function(g,G,X){var k=" ",O=g.schema[G],G=g.errSchemaPath+"/"+G,O=(g.opts.allErrors,g.util.toQuotedString(O));return g.opts.$comment===!0?k+=" console.log("+O+");":typeof g.opts.$comment=="function"&&(k+=" self._opts.$comment("+O+", "+g.util.toQuotedString(G)+", validate.root.schema);"),k}},2617:function(ie){ie.exports=function(g,O,X){var A=" ",k=g.level,m=g.dataLevel,C=g.schema[O],G=g.schemaPath+g.util.getProperty(O),O=g.errSchemaPath+"/"+O,D=!g.opts.allErrors,N="data"+(m||""),M="valid"+k,L=g.opts.$data&&C&&C.$data,C=(L&&(A+=" var schema"+k+" = "+g.util.getData(C.$data,m,g.dataPathArr)+"; "),L||(A+=" var schema"+k+" = validate.schema"+G+";"),[]),m=(C.push(A+="var "+M+" = equal("+N+", schema"+k+"); if (!"+M+") {   "),A="",g.createErrors!==!1?(A+=" { keyword: 'const' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(O)+" , params: { allowedValue: schema"+k+" } ",g.opts.messages!==!1&&(A+=" , message: 'should be equal to constant' "),g.opts.verbose&&(A+=" , schema: validate.schema"+G+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+N+" "),A+=" } "):A+=" {} ",A),A=C.pop();return!g.compositeRule&&D?g.async?A+=" throw new ValidationError(["+m+"]); ":A+=" validate.errors = ["+m+"]; return false; ":A+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",A+=" }",D&&(A+=" else { "),A}},2119:function(ie){ie.exports=function(g,O,X){var n=" ",a=g.level,N=g.dataLevel,k=g.schema[O],G=g.schemaPath+g.util.getProperty(O),O=g.errSchemaPath+"/"+O,D=!g.opts.allErrors,N="data"+(N||""),M="valid"+a,L="errs__"+a,C=g.util.copy(g),m=(C.level++,"valid"+C.level),a="i"+a,A=C.dataLevel=g.dataLevel+1,x="data"+A,l=g.baseId,p=g.opts.strictKeywords?typeof k=="object"&&0<Object.keys(k).length||k===!1:g.util.schemaHasRules(k,g.RULES.all),a=(n+="var "+L+" = errors;var "+M+";",p?(M=g.compositeRule,g.compositeRule=C.compositeRule=!0,C.schema=k,C.schemaPath=G,C.errSchemaPath=O,n+=" var "+m+" = false; for (var "+a+" = 0; "+a+" < "+N+".length; "+a+"++) { ",C.errorPath=g.util.getPathExpr(g.errorPath,a,g.opts.jsonPointers,!0),k=N+"["+a+"]",C.dataPathArr[A]=a,A=g.validate(C),C.baseId=l,g.util.varOccurences(A,x)<2?n+=" "+g.util.varReplace(A,x,k)+" ":n+=" var "+x+" = "+k+"; "+A+" ",n+=" if ("+m+") break; }  ",g.compositeRule=C.compositeRule=M,n+="  if (!"+m+") {"):n+=" if ("+N+".length == 0) {",[]),l=(a.push(n),n="",g.createErrors!==!1?(n+=" { keyword: 'contains' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(O)+" , params: {} ",g.opts.messages!==!1&&(n+=" , message: 'should contain a valid item' "),g.opts.verbose&&(n+=" , schema: validate.schema"+G+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+N+" "),n+=" } "):n+=" {} ",n),n=a.pop();return!g.compositeRule&&D?g.async?n+=" throw new ValidationError(["+l+"]); ":n+=" validate.errors = ["+l+"]; return false; ":n+=" var err = "+l+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } else { ",p&&(n+="  errors = "+L+"; if (vErrors !== null) { if ("+L+") vErrors.length = "+L+"; else vErrors = null; } "),g.opts.allErrors&&(n+=" } "),n}},1793:function(ie){ie.exports=function(g,I,X){var k,G,O,D=" ",N=g.level,M=g.dataLevel,h=g.schema[I],L=g.schemaPath+g.util.getProperty(I),C=g.errSchemaPath+"/"+I,m=!g.opts.allErrors,A="data"+(M||""),x="valid"+N,p="errs__"+N,a=g.opts.$data&&h&&h.$data,l=a?(D+=" var schema"+N+" = "+g.util.getData(h.$data,M,g.dataPathArr)+"; ","schema"+N):h,n="definition"+N,i=this.definition,t="";if(a&&i.$data){var e="keywordValidate"+N,r=i.validateSchema;D+=" var "+n+" = RULES.custom['"+I+"'].definition; var "+e+" = "+n+".validate;"}else{if(!(d=g.useCustomRule(this,h,g.schema,g)))return;l="validate.schema"+L,e=d.code,k=i.compile,G=i.inline,O=i.macro}var s,o,c,d,b,I=e+".errors",h="i"+N,u="ruleErr"+N,y=i.async;if(y&&!g.async)throw new Error("async keyword in sync schema");return G||O||(D+=I+" = null;"),D+="var "+p+" = errors;var "+x+";",a&&i.$data&&(t+="}",D+=" if ("+l+" === undefined) { "+x+" = true; } else { ",r&&(t+="}",D+=" "+x+" = "+n+".validateSchema("+l+"); if ("+x+") { ")),G?i.statements?D+=" "+d.validate+" ":D+=" "+x+" = "+d.validate+"; ":O?(t="",(a=g.util.copy(g)).level++,s="valid"+a.level,a.schema=d.validate,a.schemaPath="",r=g.compositeRule,g.compositeRule=a.compositeRule=!0,n=g.validate(a).replace(/validate\.schema/g,e),g.compositeRule=a.compositeRule=r,D+=" "+n):((b=b||[]).push(D),D="",D+="  "+e+".call( ",g.opts.passContext?D+="this":D+="self",k||i.schema===!1?D+=" , "+A+" ":D+=" , "+l+" , "+A+" , validate.schema"+g.schemaPath+" ",D+=" , (dataPath || '')",g.errorPath!='""'&&(D+=" + "+g.errorPath),d=D+=" , "+(o=M?"data"+(M-1||""):"parentData")+" , "+(c=M?g.dataPathArr[M]:"parentDataProperty")+" , rootData )  ",D=b.pop(),i.errors===!1?(D+=" "+x+" = ",y&&(D+="await "),D+=d+"; "):D+=y?" var "+(I="customErrors"+N)+" = null; try { "+x+" = await "+d+"; } catch (e) { "+x+" = false; if (e instanceof ValidationError) "+I+" = e.errors; else throw e; } ":" "+I+" = null; "+x+" = "+d+"; "),i.modifying&&(D+=" if ("+o+") "+A+" = "+o+"["+c+"];"),D+=""+t,i.valid?m&&(D+=" if (true) { "):(D+=" if ( ",i.valid===void 0?D=D+" !"+(O?""+s:x):D+=" "+!i.valid+" ",a=this.keyword,(b=b||[]).push(D+=") { "),(b=b||[]).push(D=""),D="",g.createErrors!==!1?(D+=" { keyword: '"+(a||"custom")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(C)+" , params: { keyword: '"+this.keyword+"' } ",g.opts.messages!==!1&&(D+=` , message: 'should pass "`+this.keyword+`" keyword validation' `),g.opts.verbose&&(D+=" , schema: validate.schema"+L+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),D+=" } "):D+=" {} ",r=D,D=b.pop(),!g.compositeRule&&m?g.async?D+=" throw new ValidationError(["+r+"]); ":D+=" validate.errors = ["+r+"]; return false; ":D+=" var err = "+r+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n=D,D=b.pop(),G?i.errors?i.errors!="full"&&(D+="  for (var "+h+"="+p+"; "+h+"<errors; "+h+"++) { var "+u+" = vErrors["+h+"]; if ("+u+".dataPath === undefined) "+u+".dataPath = (dataPath || '') + "+g.errorPath+"; if ("+u+".schemaPath === undefined) { "+u+'.schemaPath = "'+C+'"; } ',g.opts.verbose&&(D+=" "+u+".schema = "+l+"; "+u+".data = "+A+"; "),D+=" } "):i.errors===!1?D+=" "+n+" ":(D+=" if ("+p+" == errors) { "+n+" } else {  for (var "+h+"="+p+"; "+h+"<errors; "+h+"++) { var "+u+" = vErrors["+h+"]; if ("+u+".dataPath === undefined) "+u+".dataPath = (dataPath || '') + "+g.errorPath+"; if ("+u+".schemaPath === undefined) { "+u+'.schemaPath = "'+C+'"; } ',g.opts.verbose&&(D+=" "+u+".schema = "+l+"; "+u+".data = "+A+"; "),D+=" } } "):O?(D+="   var err =   ",g.createErrors!==!1?(D+=" { keyword: '"+(a||"custom")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(C)+" , params: { keyword: '"+this.keyword+"' } ",g.opts.messages!==!1&&(D+=` , message: 'should pass "`+this.keyword+`" keyword validation' `),g.opts.verbose&&(D+=" , schema: validate.schema"+L+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),D+=" } "):D+=" {} ",D+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!g.compositeRule&&m&&(g.async?D+=" throw new ValidationError(vErrors); ":D+=" validate.errors = vErrors; return false; ")):i.errors===!1?D+=" "+n+" ":(D+=" if (Array.isArray("+I+")) { if (vErrors === null) vErrors = "+I+"; else vErrors = vErrors.concat("+I+"); errors = vErrors.length;  for (var "+h+"="+p+"; "+h+"<errors; "+h+"++) { var "+u+" = vErrors["+h+"]; if ("+u+".dataPath === undefined) "+u+".dataPath = (dataPath || '') + "+g.errorPath+";  "+u+'.schemaPath = "'+C+'";  ',g.opts.verbose&&(D+=" "+u+".schema = "+l+"; "+u+".data = "+A+"; "),D+=" } } else { "+n+" } "),D+=" } ",m&&(D+=" else { ")),D}},9115:function(ie){ie.exports=function(g,A,X){var k,G=" ",O=g.level,D=g.dataLevel,N=g.schema[A],M=g.schemaPath+g.util.getProperty(A),L=g.errSchemaPath+"/"+A,C=!g.opts.allErrors,m="data"+(D||""),A="errs__"+O,x=g.util.copy(g),p="",a=(x.level++,"valid"+x.level),l={},n={},i=g.opts.ownProperties;for(v in N)v!="__proto__"&&(B=N[v],(k=Array.isArray(B)?n:l)[v]=B);var t=g.errorPath;for(v in G=G+("var "+A+" = errors;")+("var missing"+O+";"),n)if((k=n[v]).length){if(G+=" if ( "+m+g.util.getProperty(v)+" !== undefined ",i&&(G+=" && Object.prototype.hasOwnProperty.call("+m+", '"+g.util.escapeQuotes(v)+"') "),C){G+=" && ( ";var e=k;if(e)for(var r=-1,s=e.length-1;r<s;)I=e[r+=1],r&&(G+=" || "),G+=" ( ( "+(w=m+(y=g.util.getProperty(I)))+" === undefined ",i&&(G+=" || ! Object.prototype.hasOwnProperty.call("+m+", '"+g.util.escapeQuotes(I)+"') "),G+=") && (missing"+O+" = "+g.util.toQuotedString(g.opts.jsonPointers?I:y)+") ) ";G+=")) {  ";var d="missing"+O,o="' + "+d+" + '",c=(g.opts._errorDataPathProperty&&(g.errorPath=g.opts.jsonPointers?g.util.getPathExpr(t,d,!0):t+" + "+d),c||[]),d=(c.push(G),G="",g.createErrors!==!1?(G+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(L)+" , params: { property: '"+g.util.escapeQuotes(v)+"', missingProperty: '"+o+"', depsCount: "+k.length+", deps: '"+g.util.escapeQuotes(k.length==1?k[0]:k.join(", "))+"' } ",g.opts.messages!==!1&&(G+=" , message: 'should have ",k.length==1?G+="property "+g.util.escapeQuotes(k[0]):G+="properties "+g.util.escapeQuotes(k.join(", ")),G+=" when property "+g.util.escapeQuotes(v)+" is present' "),g.opts.verbose&&(G+=" , schema: validate.schema"+M+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+m+" "),G+=" } "):G+=" {} ",G),G=c.pop();!g.compositeRule&&C?g.async?G+=" throw new ValidationError(["+d+"]); ":G+=" validate.errors = ["+d+"]; return false; ":G+=" var err = "+d+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else{G+=" ) { ";var b=k;if(b)for(var I,h=-1,u=b.length-1;h<u;){I=b[h+=1];var y=g.util.getProperty(I),o=g.util.escapeQuotes(I),w=m+y;g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPath(t,I,g.opts.jsonPointers)),G+=" if ( "+w+" === undefined ",i&&(G+=" || ! Object.prototype.hasOwnProperty.call("+m+", '"+g.util.escapeQuotes(I)+"') "),G+=") {  var err =   ",g.createErrors!==!1?(G+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(L)+" , params: { property: '"+g.util.escapeQuotes(v)+"', missingProperty: '"+o+"', depsCount: "+k.length+", deps: '"+g.util.escapeQuotes(k.length==1?k[0]:k.join(", "))+"' } ",g.opts.messages!==!1&&(G+=" , message: 'should have ",k.length==1?G+="property "+g.util.escapeQuotes(k[0]):G+="properties "+g.util.escapeQuotes(k.join(", ")),G+=" when property "+g.util.escapeQuotes(v)+" is present' "),g.opts.verbose&&(G+=" , schema: validate.schema"+M+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+m+" "),G+=" } "):G+=" {} ",G+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}G+=" }   ",C&&(p+="}",G+=" else { ")}g.errorPath=t;var v,T=x.baseId;for(v in l){var B=l[v];(g.opts.strictKeywords?typeof B=="object"&&0<Object.keys(B).length||B===!1:g.util.schemaHasRules(B,g.RULES.all))&&(G+=" "+a+" = true; if ( "+m+g.util.getProperty(v)+" !== undefined ",i&&(G+=" && Object.prototype.hasOwnProperty.call("+m+", '"+g.util.escapeQuotes(v)+"') "),G+=") { ",x.schema=B,x.schemaPath=M+g.util.getProperty(v),x.errSchemaPath=L+"/"+g.util.escapeFragment(v),G+="  "+g.validate(x)+" ",x.baseId=T,G+=" }  ",C&&(G+=" if ("+a+") { ",p+="}"))}return C&&(G+="   "+p+" if ("+A+" == errors) {"),G}},9317:function(ie){ie.exports=function(g,O,X){var A=" ",k=g.level,C=g.dataLevel,m=g.schema[O],G=g.schemaPath+g.util.getProperty(O),O=g.errSchemaPath+"/"+O,D=!g.opts.allErrors,N="data"+(C||""),M="valid"+k,L=g.opts.$data&&m&&m.$data,m=(L&&(A+=" var schema"+k+" = "+g.util.getData(m.$data,C,g.dataPathArr)+"; "),"i"+k),C="schema"+k,C=(L||(A+=" var "+C+" = validate.schema"+G+";"),A+="var "+M+";",L&&(A+=" if (schema"+k+" === undefined) "+M+" = true; else if (!Array.isArray(schema"+k+")) "+M+" = false; else {"),A+=M+" = false;for (var "+m+"=0; "+m+"<"+C+".length; "+m+"++) if (equal("+N+", "+C+"["+m+"])) { "+M+" = true; break; }",L&&(A+="  }  "),[]),m=(C.push(A+=" if (!"+M+") {   "),A="",g.createErrors!==!1?(A+=" { keyword: 'enum' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(O)+" , params: { allowedValues: schema"+k+" } ",g.opts.messages!==!1&&(A+=" , message: 'should be equal to one of the allowed values' "),g.opts.verbose&&(A+=" , schema: validate.schema"+G+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+N+" "),A+=" } "):A+=" {} ",A),A=C.pop();return!g.compositeRule&&D?g.async?A+=" throw new ValidationError(["+m+"]); ":A+=" validate.errors = ["+m+"]; return false; ":A+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",A+=" }",D&&(A+=" else { "),A}},8327:function(ie){ie.exports=function(g,M,X){var k=" ",G=g.level,O=g.dataLevel,D=g.schema[M],N=g.schemaPath+g.util.getProperty(M),M=g.errSchemaPath+"/"+M,L=!g.opts.allErrors,C="data"+(O||"");if(g.opts.format===!1)L&&(k+=" if (true) { ");else{var m,A=g.opts.$data&&D&&D.$data,O=A?(k+=" var schema"+G+" = "+g.util.getData(D.$data,O,g.dataPathArr)+"; ","schema"+G):D,x=g.opts.unknownFormats,p=Array.isArray(x);if(A)k+=" var "+(m="format"+G)+" = formats["+O+"]; var "+(a="isObject"+G)+" = typeof "+m+" == 'object' && !("+m+" instanceof RegExp) && "+m+".validate; var "+(n="formatType"+G)+" = "+a+" && "+m+".type || 'string'; if ("+a+") { ",g.async&&(k+=" var async"+G+" = "+m+".async; "),k+=" "+m+" = "+m+".validate; } if (  ",A&&(k+=" ("+O+" !== undefined && typeof "+O+" != 'string') || "),k+=" (",x!="ignore"&&(k+=" ("+O+" && !"+m+" ",p&&(k+=" && self._opts.unknownFormats.indexOf("+O+") == -1 "),k+=") || "),k+=" ("+m+" && "+n+" == '"+X+"' && !(typeof "+m+" == 'function' ? ",g.async?k+=" (async"+G+" ? await "+m+"("+C+") : "+m+"("+C+")) ":k+=" "+m+"("+C+") ",k+=" : "+m+".test("+C+"))))) {";else{if(!(m=g.formats[D])){if(x=="ignore")return g.logger.warn('unknown format "'+D+'" ignored in schema at path "'+g.errSchemaPath+'"'),L&&(k+=" if (true) { "),k;if(p&&0<=x.indexOf(D))return L&&(k+=" if (true) { "),k;throw new Error('unknown format "'+D+'" is used in schema at path "'+g.errSchemaPath+'"')}var a,l,n=(a=typeof m=="object"&&!(m instanceof RegExp)&&m.validate)&&m.type||"string";if(a&&(l=m.async===!0,m=m.validate),n!=X)return L&&(k+=" if (true) { "),k;if(l){if(!g.async)throw new Error("async format in sync schema");k+=" if (!(await "+(i="formats"+g.util.getProperty(D)+".validate")+"("+C+"))) { "}else{k+=" if (! ";var i="formats"+g.util.getProperty(D);a&&(i+=".validate"),k=k+(typeof m=="function"?" "+i+"("+C+") ":" "+i+".test("+C+") ")+") { "}}G=[],p=(G.push(k),k="",g.createErrors!==!1?(k=(k+=" { keyword: 'format' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(M)+" , params: { format:  ")+(A?""+O:""+g.util.toQuotedString(D))+"  } ",g.opts.messages!==!1&&(k=(k+=` , message: 'should match format "`)+(A?"' + "+O+" + '":""+g.util.escapeQuotes(D))+`"' `),g.opts.verbose&&(k=(k=(k+=" , schema:  ")+(A?"validate.schema"+N:""+g.util.toQuotedString(D)))+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+C+" "),k+=" } "):k+=" {} ",k),k=G.pop(),!g.compositeRule&&L?g.async?k+=" throw new ValidationError(["+p+"]); ":k+=" validate.errors = ["+p+"]; return false; ":k+=" var err = "+p+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } ",L&&(k+=" else { ")}return k}},5926:function(ie){ie.exports=function(g,M,X){var k,G=" ",O=g.level,C=g.dataLevel,D=g.schema[M],N=g.schemaPath+g.util.getProperty(M),M=g.errSchemaPath+"/"+M,L=!g.opts.allErrors,C="data"+(C||""),m="valid"+O,A="errs__"+O,x=g.util.copy(g),p=(x.level++,"valid"+x.level),a=g.schema.then,l=g.schema.else,a=a!==void 0&&(g.opts.strictKeywords?typeof a=="object"&&0<Object.keys(a).length||a===!1:g.util.schemaHasRules(a,g.RULES.all)),l=l!==void 0&&(g.opts.strictKeywords?typeof l=="object"&&0<Object.keys(l).length||l===!1:g.util.schemaHasRules(l,g.RULES.all)),n=x.baseId;return a||l?(x.createErrors=!1,x.schema=D,x.schemaPath=N,x.errSchemaPath=M,G+=" var "+A+" = errors; var "+m+" = true;  ",D=g.compositeRule,g.compositeRule=x.compositeRule=!0,G+="  "+g.validate(x)+" ",x.baseId=n,x.createErrors=!0,G+="  errors = "+A+"; if (vErrors !== null) { if ("+A+") vErrors.length = "+A+"; else vErrors = null; }  ",g.compositeRule=x.compositeRule=D,a?(G+=" if ("+p+") {  ",x.schema=g.schema.then,x.schemaPath=g.schemaPath+".then",x.errSchemaPath=g.errSchemaPath+"/then",G+="  "+g.validate(x)+" ",x.baseId=n,G+=" "+m+" = "+p+"; ",a&&l?G+=" var "+(k="ifClause"+O)+" = 'then'; ":k="'then'",G+=" } ",l&&(G+=" else { ")):G+=" if (!"+p+") { ",l&&(x.schema=g.schema.else,x.schemaPath=g.schemaPath+".else",x.errSchemaPath=g.errSchemaPath+"/else",G+="  "+g.validate(x)+" ",x.baseId=n,G+=" "+m+" = "+p+"; ",a&&l?G+=" var "+(k="ifClause"+O)+" = 'else'; ":k="'else'",G+=" } "),G+=" if (!"+m+") {   var err =   ",g.createErrors!==!1?(G+=" { keyword: 'if' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(M)+" , params: { failingKeyword: "+k+" } ",g.opts.messages!==!1&&(G+=` , message: 'should match "' + `+k+` + '" schema' `),g.opts.verbose&&(G+=" , schema: validate.schema"+N+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+C+" "),G+=" } "):G+=" {} ",G+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!g.compositeRule&&L&&(g.async?G+=" throw new ValidationError(vErrors); ":G+=" validate.errors = vErrors; return false; "),G+=" }   ",L&&(G+=" else { ")):L&&(G+=" if (true) { "),G}},9646:function(ie,g,V){ie.exports={$ref:V(2331),allOf:V(9486),anyOf:V(5347),$comment:V(923),const:V(2617),contains:V(2119),dependencies:V(9115),enum:V(9317),format:V(8327),if:V(5926),items:V(392),maximum:V(1796),minimum:V(1796),maxItems:V(2407),minItems:V(2407),maxLength:V(1250),minLength:V(1250),maxProperties:V(2596),minProperties:V(2596),multipleOf:V(6039),not:V(7946),oneOf:V(9344),pattern:V(9737),properties:V(2537),propertyNames:V(2127),required:V(1204),uniqueItems:V(1985),validate:V(1869)}},392:function(ie){ie.exports=function(g,L,X){var k=" ",p=g.level,C=g.dataLevel,G=g.schema[L],O=g.schemaPath+g.util.getProperty(L),D=g.errSchemaPath+"/"+L,N=!g.opts.allErrors,M="data"+(C||""),L="valid"+p,C="errs__"+p,m=g.util.copy(g),A="",x=(m.level++,"valid"+m.level),p="i"+p,a=m.dataLevel=g.dataLevel+1,l="data"+a,n=g.baseId;if(k+="var "+C+" = errors;var "+L+";",Array.isArray(G)){var i,t,e=g.schema.additionalItems,r=(e===!1&&(k+=" "+L+" = "+M+".length <= "+G.length+"; ",i=D,D=g.errSchemaPath+"/additionalItems",(t=t||[]).push(k+="  if (!"+L+") {   "),k="",g.createErrors!==!1?(k+=" { keyword: 'additionalItems' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(D)+" , params: { limit: "+G.length+" } ",g.opts.messages!==!1&&(k+=" , message: 'should NOT have more than "+G.length+" items' "),g.opts.verbose&&(k+=" , schema: false , parentSchema: validate.schema"+g.schemaPath+" , data: "+M+" "),k+=" } "):k+=" {} ",L=k,k=t.pop(),!g.compositeRule&&N?g.async?k+=" throw new ValidationError(["+L+"]); ":k+=" validate.errors = ["+L+"]; return false; ":k+=" var err = "+L+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } ",D=i,N&&(A+="}",k+=" else { ")),G);if(r)for(var s=-1,o=r.length-1;s<o;){var c,d,b=r[s+=1];(g.opts.strictKeywords?typeof b=="object"&&0<Object.keys(b).length||b===!1:g.util.schemaHasRules(b,g.RULES.all))&&(k+=" "+x+" = true; if ("+M+".length > "+s+") { ",c=M+"["+s+"]",m.schema=b,m.schemaPath=O+"["+s+"]",m.errSchemaPath=D+"/"+s,m.errorPath=g.util.getPathExpr(g.errorPath,s,g.opts.jsonPointers,!0),m.dataPathArr[a]=s,d=g.validate(m),m.baseId=n,g.util.varOccurences(d,l)<2?k+=" "+g.util.varReplace(d,l,c)+" ":k+=" var "+l+" = "+c+"; "+d+" ",k+=" }  ",N&&(k+=" if ("+x+") { ",A+="}"))}typeof e=="object"&&(g.opts.strictKeywords?typeof e=="object"&&0<Object.keys(e).length||e===!1:g.util.schemaHasRules(e,g.RULES.all))&&(m.schema=e,m.schemaPath=g.schemaPath+".additionalItems",m.errSchemaPath=g.errSchemaPath+"/additionalItems",k+=" "+x+" = true; if ("+M+".length > "+G.length+") {  for (var "+p+" = "+G.length+"; "+p+" < "+M+".length; "+p+"++) { ",m.errorPath=g.util.getPathExpr(g.errorPath,p,g.opts.jsonPointers,!0),c=M+"["+p+"]",m.dataPathArr[a]=p,d=g.validate(m),m.baseId=n,g.util.varOccurences(d,l)<2?k+=" "+g.util.varReplace(d,l,c)+" ":k+=" var "+l+" = "+c+"; "+d+" ",N&&(k+=" if (!"+x+") break; "),k+=" } }  ",N&&(k+=" if ("+x+") { ",A+="}"))}else(g.opts.strictKeywords?typeof G=="object"&&0<Object.keys(G).length||G===!1:g.util.schemaHasRules(G,g.RULES.all))&&(m.schema=G,m.schemaPath=O,m.errSchemaPath=D,k+="  for (var "+p+" = 0; "+p+" < "+M+".length; "+p+"++) { ",m.errorPath=g.util.getPathExpr(g.errorPath,p,g.opts.jsonPointers,!0),c=M+"["+p+"]",m.dataPathArr[a]=p,d=g.validate(m),m.baseId=n,g.util.varOccurences(d,l)<2?k+=" "+g.util.varReplace(d,l,c)+" ":k+=" var "+l+" = "+c+"; "+d+" ",N&&(k+=" if (!"+x+") break; "),k+=" }");return N&&(k+=" "+A+" if ("+C+" == errors) {"),k}},6039:function(ie){ie.exports=function(g,V,X){var k=" ",G=g.level,m=g.dataLevel,O=g.schema[V],D=g.schemaPath+g.util.getProperty(V),N=g.errSchemaPath+"/"+V,M=!g.opts.allErrors,L="data"+(m||""),C=g.opts.$data&&O&&O.$data,m=C?(k+=" var schema"+G+" = "+g.util.getData(O.$data,m,g.dataPathArr)+"; ","schema"+G):O;if(!C&&typeof O!="number")throw new Error(V+" must be number");return k+="var division"+G+";if (",C&&(k+=" "+m+" !== undefined && ( typeof "+m+" != 'number' || "),k+=" (division"+G+" = "+L+" / "+m+", ",g.opts.multipleOfPrecision?k+=" Math.abs(Math.round(division"+G+") - division"+G+") > 1e-"+g.opts.multipleOfPrecision+" ":k+=" division"+G+" !== parseInt(division"+G+") ",k+=" ) ",C&&(k+="  )  "),V=[],V.push(k+=" ) {   "),k="",g.createErrors!==!1?(k+=" { keyword: 'multipleOf' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(N)+" , params: { multipleOf: "+m+" } ",g.opts.messages!==!1&&(k=k+" , message: 'should be multiple of "+(C?"' + "+m:m+"'")),g.opts.verbose&&(k=(k+=" , schema:  ")+(C?"validate.schema"+D:""+O)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ",G=k,k=V.pop(),!g.compositeRule&&M?g.async?k+=" throw new ValidationError(["+G+"]); ":k+=" validate.errors = ["+G+"]; return false; ":k+=" var err = "+G+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+="} ",M&&(k+=" else { "),k}},7946:function(ie){ie.exports=function(g,M,X){var k,G,O=" ",m=g.level,C=g.dataLevel,D=g.schema[M],N=g.schemaPath+g.util.getProperty(M),M=g.errSchemaPath+"/"+M,L=!g.opts.allErrors,C="data"+(C||""),m="errs__"+m,A=g.util.copy(g),x=(A.level++,"valid"+A.level);return(g.opts.strictKeywords?typeof D=="object"&&0<Object.keys(D).length||D===!1:g.util.schemaHasRules(D,g.RULES.all))?(A.schema=D,A.schemaPath=N,A.errSchemaPath=M,O+=" var "+m+" = errors;  ",D=g.compositeRule,g.compositeRule=A.compositeRule=!0,A.createErrors=!1,A.opts.allErrors&&(G=A.opts.allErrors,A.opts.allErrors=!1),O+=" "+g.validate(A)+" ",A.createErrors=!0,G&&(A.opts.allErrors=G),g.compositeRule=A.compositeRule=D,(k=k||[]).push(O+=" if ("+x+") {   "),O="",g.createErrors!==!1?(O+=" { keyword: 'not' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(M)+" , params: {} ",g.opts.messages!==!1&&(O+=" , message: 'should NOT be valid' "),g.opts.verbose&&(O+=" , schema: validate.schema"+N+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+C+" "),O+=" } "):O+=" {} ",G=O,O=k.pop(),!g.compositeRule&&L?g.async?O+=" throw new ValidationError(["+G+"]); ":O+=" validate.errors = ["+G+"]; return false; ":O+=" var err = "+G+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",O+=" } else {  errors = "+m+"; if (vErrors !== null) { if ("+m+") vErrors.length = "+m+"; else vErrors = null; } ",g.opts.allErrors&&(O+=" } ")):(O+="  var err =   ",g.createErrors!==!1?(O+=" { keyword: 'not' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(M)+" , params: {} ",g.opts.messages!==!1&&(O+=" , message: 'should NOT be valid' "),g.opts.verbose&&(O+=" , schema: validate.schema"+N+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+C+" "),O+=" } "):O+=" {} ",O+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",L&&(O+=" if (false) { ")),O}},9344:function(ie){ie.exports=function(g,N,X){var k=" ",n=g.level,M=g.dataLevel,G=g.schema[N],O=g.schemaPath+g.util.getProperty(N),D=g.errSchemaPath+"/"+N,N=!g.opts.allErrors,M="data"+(M||""),L="valid"+n,C="errs__"+n,m=g.util.copy(g),A="",x=(m.level++,"valid"+m.level),p=m.baseId,a="prevValid"+n,l="passingSchemas"+n,n=(k+="var "+C+" = errors , "+a+" = false , "+L+" = false , "+l+" = null; ",g.compositeRule),i=(g.compositeRule=m.compositeRule=!0,G);if(i)for(var t,e=-1,r=i.length-1;e<r;)t=i[e+=1],(g.opts.strictKeywords?typeof t=="object"&&0<Object.keys(t).length||t===!1:g.util.schemaHasRules(t,g.RULES.all))?(m.schema=t,m.schemaPath=O+"["+e+"]",m.errSchemaPath=D+"/"+e,k+="  "+g.validate(m)+" ",m.baseId=p):k+=" var "+x+" = true; ",e&&(k+=" if ("+x+" && "+a+") { "+L+" = false; "+l+" = ["+l+", "+e+"]; } else { ",A+="}"),k+=" if ("+x+") { "+L+" = "+a+" = true; "+l+" = "+e+"; }";return g.compositeRule=m.compositeRule=n,k+=A+"if (!"+L+") {   var err =   ",g.createErrors!==!1?(k+=" { keyword: 'oneOf' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(D)+" , params: { passingSchemas: "+l+" } ",g.opts.messages!==!1&&(k+=" , message: 'should match exactly one schema in oneOf' "),g.opts.verbose&&(k+=" , schema: validate.schema"+O+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+M+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!g.compositeRule&&N&&(g.async?k+=" throw new ValidationError(vErrors); ":k+=" validate.errors = vErrors; return false; "),k+="} else {  errors = "+C+"; if (vErrors !== null) { if ("+C+") vErrors.length = "+C+"; else vErrors = null; }",g.opts.allErrors&&(k+=" } "),k}},9737:function(ie){ie.exports=function(g,O,X){var A=" ",m=g.level,L=g.dataLevel,k=g.schema[O],G=g.schemaPath+g.util.getProperty(O),O=g.errSchemaPath+"/"+O,D=!g.opts.allErrors,N="data"+(L||""),M=g.opts.$data&&k&&k.$data,L=M?(A+=" var schema"+m+" = "+g.util.getData(k.$data,L,g.dataPathArr)+"; ","schema"+m):k,m=M?"(new RegExp("+L+"))":g.usePattern(k),C=(A+="if ( ",M&&(A+=" ("+L+" !== undefined && typeof "+L+" != 'string') || "),[]),m=(C.push(A+=" !"+m+".test("+N+") ) {   "),A="",g.createErrors!==!1?(A=(A+=" { keyword: 'pattern' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(O)+" , params: { pattern:  ")+(M?""+L:""+g.util.toQuotedString(k))+"  } ",g.opts.messages!==!1&&(A=(A+=` , message: 'should match pattern "`)+(M?"' + "+L+" + '":""+g.util.escapeQuotes(k))+`"' `),g.opts.verbose&&(A=(A=(A+=" , schema:  ")+(M?"validate.schema"+G:""+g.util.toQuotedString(k)))+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+N+" "),A+=" } "):A+=" {} ",A),A=C.pop();return!g.compositeRule&&D?g.async?A+=" throw new ValidationError(["+m+"]); ":A+=" validate.errors = ["+m+"]; return false; ":A+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",A+="} ",D&&(A+=" else { "),A}},2537:function(ie){ie.exports=function(g,m,X){var k,G=" ",O=g.level,e=g.dataLevel,D=g.schema[m],N=g.schemaPath+g.util.getProperty(m),M=g.errSchemaPath+"/"+m,L=!g.opts.allErrors,C="data"+(e||""),m="errs__"+O,A=g.util.copy(g),x="",p=(A.level++,"valid"+A.level),a="key"+O,l="idx"+O,n=A.dataLevel=g.dataLevel+1,i="data"+n,t="dataProperties"+O,e=Object.keys(D||{}).filter(v),r=g.schema.patternProperties||{},s=Object.keys(r).filter(v),o=g.schema.additionalProperties,c=e.length||s.length,d=o===!1,b=typeof o=="object"&&Object.keys(o).length,I=g.opts.removeAdditional,h=d||b||I,u=g.opts.ownProperties,y=g.baseId,w=g.schema.required;function v(Ee){return Ee!=="__proto__"}if(w&&(!g.opts.$data||!w.$data)&&w.length<g.opts.loopRequired&&(k=g.util.toHash(w)),G+="var "+m+" = errors;var "+p+" = true;",u&&(G+=" var "+t+" = undefined;"),h){if(G+=u?" "+t+" = "+t+" || Object.keys("+C+"); for (var "+l+"=0; "+l+"<"+t+".length; "+l+"++) { var "+a+" = "+t+"["+l+"]; ":" for (var "+a+" in "+C+") { ",c){if(G+=" var isAdditional"+O+" = !(false ",e.length)if(8<e.length)G+=" || validate.schema"+N+".hasOwnProperty("+a+") ";else{var T=e;if(T)for(var B=-1,E=T.length-1;B<E;)Y=T[B+=1],G+=" || "+a+" == "+g.util.toQuotedString(Y)+" "}if(s.length){var _=s;if(_)for(var P=-1,H=_.length-1;P<H;)ve=_[P+=1],G+=" || "+g.usePattern(ve)+".test("+a+") "}G+=" ); if (isAdditional"+O+") { "}I=="all"?G+=" delete "+C+"["+a+"]; ":(S=g.errorPath,w="' + "+a+" + '",g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPathExpr(g.errorPath,a,g.opts.jsonPointers)),d?I?G+=" delete "+C+"["+a+"]; ":($=M,M=g.errSchemaPath+"/additionalProperties",(j=j||[]).push(G+=" "+p+" = false; "),G="",g.createErrors!==!1?(G+=" { keyword: 'additionalProperties' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(M)+" , params: { additionalProperty: '"+w+"' } ",g.opts.messages!==!1&&(G+=" , message: '",g.opts._errorDataPathProperty?G+="is an invalid additional property":G+="should NOT have additional properties",G+="' "),g.opts.verbose&&(G+=" , schema: false , parentSchema: validate.schema"+g.schemaPath+" , data: "+C+" "),G+=" } "):G+=" {} ",Q=G,G=j.pop(),!g.compositeRule&&L?g.async?G+=" throw new ValidationError(["+Q+"]); ":G+=" validate.errors = ["+Q+"]; return false; ":G+=" var err = "+Q+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",M=$,L&&(G+=" break; ")):b&&(I=="failing"?(G+=" var "+m+" = errors;  ",h=g.compositeRule,g.compositeRule=A.compositeRule=!0,A.schema=o,A.schemaPath=g.schemaPath+".additionalProperties",A.errSchemaPath=g.errSchemaPath+"/additionalProperties",A.errorPath=g.opts._errorDataPathProperty?g.errorPath:g.util.getPathExpr(g.errorPath,a,g.opts.jsonPointers),Ce=C+"["+a+"]",A.dataPathArr[n]=a,Ae=g.validate(A),A.baseId=y,g.util.varOccurences(Ae,i)<2?G+=" "+g.util.varReplace(Ae,i,Ce)+" ":G+=" var "+i+" = "+Ce+"; "+Ae+" ",G+=" if (!"+p+") { errors = "+m+"; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete "+C+"["+a+"]; }  ",g.compositeRule=A.compositeRule=h):(A.schema=o,A.schemaPath=g.schemaPath+".additionalProperties",A.errSchemaPath=g.errSchemaPath+"/additionalProperties",A.errorPath=g.opts._errorDataPathProperty?g.errorPath:g.util.getPathExpr(g.errorPath,a,g.opts.jsonPointers),Ce=C+"["+a+"]",A.dataPathArr[n]=a,Ae=g.validate(A),A.baseId=y,g.util.varOccurences(Ae,i)<2?G+=" "+g.util.varReplace(Ae,i,Ce)+" ":G+=" var "+i+" = "+Ce+"; "+Ae+" ",L&&(G+=" if (!"+p+") break; "))),g.errorPath=S),c&&(G+=" } "),G+=" }  ",L&&(G+=" if ("+p+") { ",x+="}")}var z=g.opts.useDefaults&&!g.compositeRule;if(e.length){var K=e;if(K)for(var Y,R=-1,Z=K.length-1;R<Z;){var W,f,S,$,F,j,Q,te=D[Y=K[R+=1]];(g.opts.strictKeywords?typeof te=="object"&&0<Object.keys(te).length||te===!1:g.util.schemaHasRules(te,g.RULES.all))&&(Ce=C+(F=g.util.getProperty(Y)),W=z&&te.default!==void 0,A.schema=te,A.schemaPath=N+F,A.errSchemaPath=M+"/"+g.util.escapeFragment(Y),A.errorPath=g.util.getPath(g.errorPath,Y,g.opts.jsonPointers),A.dataPathArr[n]=g.util.toQuotedString(Y),Ae=g.validate(A),A.baseId=y,g.util.varOccurences(Ae,i)<2?(Ae=g.util.varReplace(Ae,i,Ce),f=Ce):G+=" var "+(f=i)+" = "+Ce+"; ",W?G+=" "+Ae+" ":(k&&k[Y]?(G+=" if ( "+f+" === undefined ",u&&(G+=" || ! Object.prototype.hasOwnProperty.call("+C+", '"+g.util.escapeQuotes(Y)+"') "),G+=") { "+p+" = false; ",S=g.errorPath,$=M,F=g.util.escapeQuotes(Y),g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPath(S,Y,g.opts.jsonPointers)),M=g.errSchemaPath+"/required",(j=j||[]).push(G),G="",g.createErrors!==!1?(G+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(M)+" , params: { missingProperty: '"+F+"' } ",g.opts.messages!==!1&&(G+=" , message: '",g.opts._errorDataPathProperty?G+="is a required property":G+="should have required property \\'"+F+"\\'",G+="' "),g.opts.verbose&&(G+=" , schema: validate.schema"+N+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+C+" "),G+=" } "):G+=" {} ",Q=G,G=j.pop(),!g.compositeRule&&L?g.async?G+=" throw new ValidationError(["+Q+"]); ":G+=" validate.errors = ["+Q+"]; return false; ":G+=" var err = "+Q+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",M=$,g.errorPath=S,G+=" } else { "):L?(G+=" if ( "+f+" === undefined ",u&&(G+=" || ! Object.prototype.hasOwnProperty.call("+C+", '"+g.util.escapeQuotes(Y)+"') "),G+=") { "+p+" = true; } else { "):(G+=" if ("+f+" !== undefined ",u&&(G+=" &&   Object.prototype.hasOwnProperty.call("+C+", '"+g.util.escapeQuotes(Y)+"') "),G+=" ) { "),G+=" "+Ae+" } ")),L&&(G+=" if ("+p+") { ",x+="}")}}if(s.length){var he=s;if(he)for(var ve,ue=-1,fe=he.length-1;ue<fe;){var Ce,Ae,te=r[ve=he[ue+=1]];(g.opts.strictKeywords?typeof te=="object"&&0<Object.keys(te).length||te===!1:g.util.schemaHasRules(te,g.RULES.all))&&(A.schema=te,A.schemaPath=g.schemaPath+".patternProperties"+g.util.getProperty(ve),A.errSchemaPath=g.errSchemaPath+"/patternProperties/"+g.util.escapeFragment(ve),G=(G+=u?" "+t+" = "+t+" || Object.keys("+C+"); for (var "+l+"=0; "+l+"<"+t+".length; "+l+"++) { var "+a+" = "+t+"["+l+"]; ":" for (var "+a+" in "+C+") { ")+" if ("+g.usePattern(ve)+".test("+a+")) { ",A.errorPath=g.util.getPathExpr(g.errorPath,a,g.opts.jsonPointers),Ce=C+"["+a+"]",A.dataPathArr[n]=a,Ae=g.validate(A),A.baseId=y,g.util.varOccurences(Ae,i)<2?G+=" "+g.util.varReplace(Ae,i,Ce)+" ":G+=" var "+i+" = "+Ce+"; "+Ae+" ",L&&(G+=" if (!"+p+") break; "),G+=" } ",L&&(G+=" else "+p+" = true; "),G+=" }  ",L&&(G+=" if ("+p+") { ",x+="}"))}}return L&&(G+=" "+x+" if ("+m+" == errors) {"),G}},2127:function(ie){ie.exports=function(g,p,X){var k,G,O,D,N,M,L,C=" ",m=g.level,l=g.dataLevel,A=g.schema[p],x=g.schemaPath+g.util.getProperty(p),p=g.errSchemaPath+"/"+p,a=!g.opts.allErrors,l="data"+(l||""),n="errs__"+m,i=g.util.copy(g),t=(i.level++,"valid"+i.level);return C+="var "+n+" = errors;",(g.opts.strictKeywords?typeof A=="object"&&0<Object.keys(A).length||A===!1:g.util.schemaHasRules(A,g.RULES.all))&&(i.schema=A,i.schemaPath=x,i.errSchemaPath=p,A="idx"+m,G="i"+m,O="' + "+(k="key"+m)+" + '",D="data"+(i.dataLevel=g.dataLevel+1),L="dataProperties"+m,M=g.opts.ownProperties,N=g.baseId,M&&(C+=" var "+L+" = undefined; "),C=C+(M?" "+L+" = "+L+" || Object.keys("+l+"); for (var "+A+"=0; "+A+"<"+L+".length; "+A+"++) { var "+k+" = "+L+"["+A+"]; ":" for (var "+k+" in "+l+") { ")+" var startErrs"+m+" = errors; ",M=k,L=g.compositeRule,g.compositeRule=i.compositeRule=!0,A=g.validate(i),i.baseId=N,g.util.varOccurences(A,D)<2?C+=" "+g.util.varReplace(A,D,M)+" ":C+=" var "+D+" = "+M+"; "+A+" ",g.compositeRule=i.compositeRule=L,C+=" if (!"+t+") { for (var "+G+"=startErrs"+m+"; "+G+"<errors; "+G+"++) { vErrors["+G+"].propertyName = "+k+"; }   var err =   ",g.createErrors!==!1?(C+=" { keyword: 'propertyNames' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(p)+" , params: { propertyName: '"+O+"' } ",g.opts.messages!==!1&&(C+=" , message: 'property name \\'"+O+"\\' is invalid' "),g.opts.verbose&&(C+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+l+" "),C+=" } "):C+=" {} ",C+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!g.compositeRule&&a&&(g.async?C+=" throw new ValidationError(vErrors); ":C+=" validate.errors = vErrors; return false; "),a&&(C+=" break; "),C+=" } }"),a&&(C+="  if ("+n+" == errors) {"),C}},2331:function(ie){ie.exports=function(g,M,X){var k,G,O=" ",m=g.level,D=g.dataLevel,N=g.schema[M],M=g.errSchemaPath+"/"+M,L=!g.opts.allErrors,C="data"+(D||""),m="valid"+m;if(N=="#"||N=="#/")G=g.isRoot?(k=g.async,"validate"):(k=g.root.schema.$async===!0,"root.refVal[0]");else{var A=g.resolveRef(g.baseId,N,g.isRoot);if(A===void 0){var x=g.MissingRefError.message(g.baseId,N);if(g.opts.missingRefs=="fail")g.logger.error(x),(p=p||[]).push(O),O="",g.createErrors!==!1?(O+=" { keyword: '$ref' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(M)+" , params: { ref: '"+g.util.escapeQuotes(N)+"' } ",g.opts.messages!==!1&&(O+=" , message: 'can\\'t resolve reference "+g.util.escapeQuotes(N)+"' "),g.opts.verbose&&(O+=" , schema: "+g.util.toQuotedString(N)+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+C+" "),O+=" } "):O+=" {} ",M=O,O=p.pop(),!g.compositeRule&&L?g.async?O+=" throw new ValidationError(["+M+"]); ":O+=" validate.errors = ["+M+"]; return false; ":O+=" var err = "+M+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",L&&(O+=" if (false) { ");else{if(g.opts.missingRefs!="ignore")throw new g.MissingRefError(g.baseId,N,x);g.logger.warn(x),L&&(O+=" if (true) { ")}}else A.inline?((M=g.util.copy(g)).level++,x="valid"+M.level,M.schema=A.schema,M.schemaPath="",M.errSchemaPath=N,O+=" "+g.validate(M).replace(/validate\.schema/g,A.code)+" ",L&&(O+=" if ("+x+") { ")):(k=A.$async===!0||g.async&&A.$async!==!1,G=A.code)}if(G){(p=p||[]).push(O),O="",g.opts.passContext?O+=" "+G+".call(this, ":O+=" "+G+"( ",O+=" "+C+", (dataPath || '')",g.errorPath!='""'&&(O+=" + "+g.errorPath);var p,N=D?"data"+(D-1||""):"parentData",M=O+=" , "+N+" , "+(D?g.dataPathArr[D]:"parentDataProperty")+", rootData)  ";if(O=p.pop(),k){if(!g.async)throw new Error("async schema referenced by sync schema");L&&(O+=" var "+m+"; "),O+=" try { await "+M+"; ",L&&(O+=" "+m+" = true; "),O+=" } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ",L&&(O+=" "+m+" = false; "),O+=" } ",L&&(O+=" if ("+m+") { ")}else O+=" if (!"+M+") { if (vErrors === null) vErrors = "+G+".errors; else vErrors = vErrors.concat("+G+".errors); errors = vErrors.length; } ",L&&(O+=" else { ")}return O}},1204:function(ie){ie.exports=function(g,M,X){var k=" ",G=g.level,A=g.dataLevel,O=g.schema[M],D=g.schemaPath+g.util.getProperty(M),N=g.errSchemaPath+"/"+M,M=!g.opts.allErrors,L="data"+(A||""),C="valid"+G,m=g.opts.$data&&O&&O.$data,A=(m&&(k+=" var schema"+G+" = "+g.util.getData(O.$data,A,g.dataPathArr)+"; "),"schema"+G);if(!m)if(O.length<g.opts.loopRequired&&g.schema.properties&&Object.keys(g.schema.properties).length){var x=[],p=O;if(p)for(var a=-1,l=p.length-1;a<l;){var n=p[a+=1],i=g.schema.properties[n];i&&(g.opts.strictKeywords?typeof i=="object"&&0<Object.keys(i).length||i===!1:g.util.schemaHasRules(i,g.RULES.all))||(x[x.length]=n)}}else x=O;if(m||x.length){var t=g.errorPath,O=m||x.length>=g.opts.loopRequired,e=g.opts.ownProperties;if(M){if(k+=" var missing"+G+"; ",O){m||(k+=" var "+A+" = validate.schema"+D+"; ");var r="' + "+(I="schema"+G+"["+(c="i"+G)+"]")+" + '";g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPathExpr(t,I,g.opts.jsonPointers)),k+=" var "+C+" = true; ",m&&(k+=" if (schema"+G+" === undefined) "+C+" = true; else if (!Array.isArray(schema"+G+")) "+C+" = false; else {"),k+=" for (var "+c+" = 0; "+c+" < "+A+".length; "+c+"++) { "+C+" = "+L+"["+A+"["+c+"]] !== undefined ",e&&(k+=" &&   Object.prototype.hasOwnProperty.call("+L+", "+A+"["+c+"]) "),k+="; if (!"+C+") break; } ",m&&(k+="  }  "),(b=b||[]).push(k+="  if (!"+C+") {   "),k="",g.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(N)+" , params: { missingProperty: '"+r+"' } ",g.opts.messages!==!1&&(k+=" , message: '",g.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+r+"\\'",k+="' "),g.opts.verbose&&(k+=" , schema: validate.schema"+D+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ";var s=k,k=b.pop()}else{k+=" if ( ";var o=x;if(o)for(var c=-1,d=o.length-1;c<d;)u=o[c+=1],c&&(k+=" || "),k+=" ( ( "+(T=L+(v=g.util.getProperty(u)))+" === undefined ",e&&(k+=" || ! Object.prototype.hasOwnProperty.call("+L+", '"+g.util.escapeQuotes(u)+"') "),k+=") && (missing"+G+" = "+g.util.toQuotedString(g.opts.jsonPointers?u:v)+") ) ";k+=") {  ",r="' + "+(I="missing"+G)+" + '",g.opts._errorDataPathProperty&&(g.errorPath=g.opts.jsonPointers?g.util.getPathExpr(t,I,!0):t+" + "+I),(b=b||[]).push(k),k="",g.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(N)+" , params: { missingProperty: '"+r+"' } ",g.opts.messages!==!1&&(k+=" , message: '",g.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+r+"\\'",k+="' "),g.opts.verbose&&(k+=" , schema: validate.schema"+D+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ";var b,s=k;k=b.pop()}!g.compositeRule&&M?g.async?k+=" throw new ValidationError(["+s+"]); ":k+=" validate.errors = ["+s+"]; return false; ":k+=" var err = "+s+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } else { "}else if(O){m||(k+=" var "+A+" = validate.schema"+D+"; ");var I,r="' + "+(I="schema"+G+"["+(c="i"+G)+"]")+" + '";g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPathExpr(t,I,g.opts.jsonPointers)),m&&(k+=" if ("+A+" && !Array.isArray("+A+")) {  var err =   ",g.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(N)+" , params: { missingProperty: '"+r+"' } ",g.opts.messages!==!1&&(k+=" , message: '",g.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+r+"\\'",k+="' "),g.opts.verbose&&(k+=" , schema: validate.schema"+D+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if ("+A+" !== undefined) { "),k+=" for (var "+c+" = 0; "+c+" < "+A+".length; "+c+"++) { if ("+L+"["+A+"["+c+"]] === undefined ",e&&(k+=" || ! Object.prototype.hasOwnProperty.call("+L+", "+A+"["+c+"]) "),k+=") {  var err =   ",g.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(N)+" , params: { missingProperty: '"+r+"' } ",g.opts.messages!==!1&&(k+=" , message: '",g.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+r+"\\'",k+="' "),g.opts.verbose&&(k+=" , schema: validate.schema"+D+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ",m&&(k+="  }  ")}else{var h=x;if(h)for(var u,y=-1,w=h.length-1;y<w;){u=h[y+=1];var v=g.util.getProperty(u),r=g.util.escapeQuotes(u),T=L+v;g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPath(t,u,g.opts.jsonPointers)),k+=" if ( "+T+" === undefined ",e&&(k+=" || ! Object.prototype.hasOwnProperty.call("+L+", '"+g.util.escapeQuotes(u)+"') "),k+=") {  var err =   ",g.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(N)+" , params: { missingProperty: '"+r+"' } ",g.opts.messages!==!1&&(k+=" , message: '",g.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+r+"\\'",k+="' "),g.opts.verbose&&(k+=" , schema: validate.schema"+D+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}g.errorPath=t}else M&&(k+=" if (true) {");return k}},1985:function(ie){ie.exports=function(g,M,X){var k,G=" ",O=g.level,x=g.dataLevel,D=g.schema[M],N=g.schemaPath+g.util.getProperty(M),M=g.errSchemaPath+"/"+M,L=!g.opts.allErrors,C="data"+(x||""),m="valid"+O,A=g.opts.$data&&D&&D.$data,x=A?(G+=" var schema"+O+" = "+g.util.getData(D.$data,x,g.dataPathArr)+"; ","schema"+O):D;return(D||A)&&g.opts.uniqueItems!==!1?(A&&(G+=" var "+m+"; if ("+x+" === false || "+x+" === undefined) "+m+" = true; else if (typeof "+x+" != 'boolean') "+m+" = false; else { "),G+=" var i = "+C+".length , "+m+" = true , j; if (i > 1) { ",O=g.schema.items&&g.schema.items.type,x=Array.isArray(O),!O||O=="object"||O=="array"||x&&(0<=O.indexOf("object")||0<=O.indexOf("array"))?G+=" outer: for (;i--;) { for (j = i; j--;) { if (equal("+C+"[i], "+C+"[j])) { "+m+" = false; break outer; } } } ":(G=(G+=" var itemIndices = {}, item; for (;i--;) { var item = "+C+"[i]; ")+" if ("+g.util["checkDataType"+(x?"s":"")](O,"item",g.opts.strictNumbers,!0)+") continue; ",x&&(G+=` if (typeof item == 'string') item = '"' + item; `),G+=" if (typeof itemIndices[item] == 'number') { "+m+" = false; j = itemIndices[item]; break; } itemIndices[item] = i; } "),G+=" } ",A&&(G+="  }  "),(k=k||[]).push(G+=" if (!"+m+") {   "),G="",g.createErrors!==!1?(G+=" { keyword: 'uniqueItems' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(M)+" , params: { i: i, j: j } ",g.opts.messages!==!1&&(G+=" , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' "),g.opts.verbose&&(G=(G+=" , schema:  ")+(A?"validate.schema"+N:""+D)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+C+" "),G+=" } "):G+=" {} ",O=G,G=k.pop(),!g.compositeRule&&L?g.async?G+=" throw new ValidationError(["+O+"]); ":G+=" validate.errors = ["+O+"]; return false; ":G+=" var err = "+O+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G+=" } ",L&&(G+=" else { ")):L&&(G+=" if (true) { "),G}},1869:function(ie){ie.exports=function(g,V,X){var k="",G=g.schema.$async===!0,O=g.util.schemaHasRulesExcept(g.schema,g.RULES.all,"$ref"),D=g.self._getId(g.schema);if(g.opts.strictKeywords){var N=g.util.schemaUnknownRules(g.schema,g.RULES.keywords);if(N){if(N="unknown keyword: "+N,g.opts.strictKeywords!=="log")throw new Error(N);g.logger.warn(N)}}if(g.isTop&&(k+=" var validate = ",G&&(g.async=!0,k+="async "),k+="function(data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ",D&&(g.opts.sourceCode||g.opts.processCode)&&(k+=" /*# sourceURL="+D+" */ ")),typeof g.schema=="boolean"||!O&&!g.schema.$ref)L=g.level,C=g.dataLevel,T=g.schema[V="false schema"],r=g.schemaPath+g.util.getProperty(V),s=g.errSchemaPath+"/"+V,p=!g.opts.allErrors,m="data"+(C||""),x="valid"+L,g.schema===!1?(g.isTop?p=!0:k+=" var "+x+" = false; ",(R=R||[]).push(k),k="",g.createErrors!==!1?(k+=" { keyword: 'false schema' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(s)+" , params: {} ",g.opts.messages!==!1&&(k+=" , message: 'boolean schema is false' "),g.opts.verbose&&(k+=" , schema: false , parentSchema: validate.schema"+g.schemaPath+" , data: "+m+" "),k+=" } "):k+=" {} ",u=k,k=R.pop(),!g.compositeRule&&p?g.async?k+=" throw new ValidationError(["+u+"]); ":k+=" validate.errors = ["+u+"]; return false; ":k+=" var err = "+u+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "):g.isTop?k+=G?" return data; ":" validate.errors = null; return true; ":k+=" var "+x+" = true; ",g.isTop&&(k+=" }; return validate; ");else{if(g.isTop){var M=g.isTop,L=g.level=0,C=g.dataLevel=0,m="data";if(g.rootId=g.resolve.fullPath(g.self._getId(g.root.schema)),g.baseId=g.baseId||g.rootId,delete g.isTop,g.dataPathArr=[""],g.schema.default!==void 0&&g.opts.useDefaults&&g.opts.strictDefaults){var A="default is ignored in the schema root";if(g.opts.strictDefaults!=="log")throw new Error(A);g.logger.warn(A)}k=(k+=" var vErrors = null; ")+" var errors = 0;      if (rootData === undefined) rootData = data; "}else{if(L=g.level,m="data"+((C=g.dataLevel)||""),D&&(g.baseId=g.resolve.url(g.baseId,D)),G&&!g.async)throw new Error("async schema in sync schema");k+=" var errs_"+L+" = errors;"}var x="valid"+L,p=!g.opts.allErrors,a="",l="",n=g.schema.type,i=Array.isArray(n);if(n&&g.opts.nullable&&g.schema.nullable===!0&&(i?n.indexOf("null")==-1&&(n=n.concat("null")):n!="null"&&(n=[n,"null"],i=!0)),i&&n.length==1&&(n=n[0],i=!1),g.schema.$ref&&O){if(g.opts.extendRefs=="fail")throw new Error('$ref: validation keywords used in schema at path "'+g.errSchemaPath+'" (see option extendRefs)');g.opts.extendRefs!==!0&&(O=!1,g.logger.warn('$ref: keywords ignored in schema at path "'+g.errSchemaPath+'"'))}if(g.schema.$comment&&g.opts.$comment&&(k+=" "+g.RULES.all.$comment.code(g,"$comment")),n){g.opts.coerceTypes&&(t=g.util.coerceToTypes(g.opts.coerceTypes,n));var t,e=g.RULES.types[n];if(t||i||e===!0||e&&!$(e)){var r=g.schemaPath+".type",s=g.errSchemaPath+"/type",r=g.schemaPath+".type",s=g.errSchemaPath+"/type";if(k+=" if ("+g.util[i?"checkDataTypes":"checkDataType"](n,m,g.opts.strictNumbers,!0)+") { ",t){var o="dataType"+L,c="coerced"+L,d=(k+=" var "+o+" = typeof "+m+"; var "+c+" = undefined; ",g.opts.coerceTypes=="array"&&(k+=" if ("+o+" == 'object' && Array.isArray("+m+") && "+m+".length == 1) { "+m+" = "+m+"[0]; "+o+" = typeof "+m+"; if ("+g.util.checkDataType(g.schema.type,m,g.opts.strictNumbers)+") "+c+" = "+m+"; } "),k+=" if ("+c+" !== undefined) ; ",t);if(d)for(var b,I=-1,h=d.length-1;I<h;)(b=d[I+=1])=="string"?k+=" else if ("+o+" == 'number' || "+o+" == 'boolean') "+c+" = '' + "+m+"; else if ("+m+" === null) "+c+" = ''; ":b=="number"||b=="integer"?(k+=" else if ("+o+" == 'boolean' || "+m+" === null || ("+o+" == 'string' && "+m+" && "+m+" == +"+m+" ",b=="integer"&&(k+=" && !("+m+" % 1)"),k+=")) "+c+" = +"+m+"; "):b=="boolean"?k+=" else if ("+m+" === 'false' || "+m+" === 0 || "+m+" === null) "+c+" = false; else if ("+m+" === 'true' || "+m+" === 1) "+c+" = true; ":b=="null"?k+=" else if ("+m+" === '' || "+m+" === 0 || "+m+" === false) "+c+" = null; ":g.opts.coerceTypes=="array"&&b=="array"&&(k+=" else if ("+o+" == 'string' || "+o+" == 'number' || "+o+" == 'boolean' || "+m+" == null) "+c+" = ["+m+"]; ");(R=R||[]).push(k+=" else {   "),k="",g.createErrors!==!1?(k=(k+=" { keyword: 'type' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(s)+" , params: { type: '")+(i?""+n.join(","):""+n)+"' } ",g.opts.messages!==!1&&(k=(k+=" , message: 'should be ")+(i?""+n.join(","):""+n)+"' "),g.opts.verbose&&(k+=" , schema: validate.schema"+r+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+m+" "),k+=" } "):k+=" {} ";var u=k,N=(k=R.pop(),!g.compositeRule&&p?g.async?k+=" throw new ValidationError(["+u+"]); ":k+=" validate.errors = ["+u+"]; return false; ":k+=" var err = "+u+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",C?"data"+(C-1||""):"parentData");k=k+(" } if ("+c+" !== undefined) {  ")+(" "+m+" = "+c+"; "),C||(k+="if ("+N+" !== undefined)"),k+=" "+N+"["+(C?g.dataPathArr[C]:"parentDataProperty")+"] = "+c+"; } "}else u=((R=R||[]).push(k),k="",g.createErrors!==!1?(k=(k+=" { keyword: 'type' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(s)+" , params: { type: '")+(i?""+n.join(","):""+n)+"' } ",g.opts.messages!==!1&&(k=(k+=" , message: 'should be ")+(i?""+n.join(","):""+n)+"' "),g.opts.verbose&&(k+=" , schema: validate.schema"+r+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+m+" "),k+=" } "):k+=" {} ",k),k=R.pop(),!g.compositeRule&&p?g.async?k+=" throw new ValidationError(["+u+"]); ":k+=" validate.errors = ["+u+"]; return false; ":k+=" var err = "+u+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";k+=" } "}}if(g.schema.$ref&&!O)k+=" "+g.RULES.all.$ref.code(g,"$ref")+" ",p&&(k=(k+=" } if (errors === ")+(M?"0":"errs_"+L)+") { ",l+="}");else{var y=g.RULES;if(y){for(var w=-1,v=y.length-1;w<v;)if($(e=y[w+=1])){if(e.type&&(k+=" if ("+g.util.checkDataType(e.type,m,g.opts.strictNumbers)+") { "),g.opts.useDefaults){if(e.type=="object"&&g.schema.properties){var T=g.schema.properties,B=Object.keys(T);if(B){for(var E,_=-1,P=B.length-1;_<P;)if((K=T[E=B[_+=1]]).default!==void 0){var H=m+g.util.getProperty(E);if(g.compositeRule){if(g.opts.strictDefaults){if(A="default is ignored for: "+H,g.opts.strictDefaults!=="log")throw new Error(A);g.logger.warn(A)}}else k+=" if ("+H+" === undefined ",g.opts.useDefaults=="empty"&&(k+=" || "+H+" === null || "+H+" === '' "),k+=" ) "+H+" = ",g.opts.useDefaults=="shared"?k+=" "+g.useDefault(K.default)+" ":k+=" "+JSON.stringify(K.default)+" ",k+="; "}}}else if(e.type=="array"&&Array.isArray(g.schema.items)){var z=g.schema.items;if(z){for(var K,I=-1,Y=z.length-1;I<Y;)if((K=z[I+=1]).default!==void 0)if(H=m+"["+I+"]",g.compositeRule){if(g.opts.strictDefaults){if(A="default is ignored for: "+H,g.opts.strictDefaults!=="log")throw new Error(A);g.logger.warn(A)}}else k+=" if ("+H+" === undefined ",g.opts.useDefaults=="empty"&&(k+=" || "+H+" === null || "+H+" === '' "),k+=" ) "+H+" = ",g.opts.useDefaults=="shared"?k+=" "+g.useDefault(K.default)+" ":k+=" "+JSON.stringify(K.default)+" ",k+="; "}}}var R,Z=e.rules;if(Z)for(var W,f=-1,S=Z.length-1;f<S;)!F(W=Z[f+=1])||(W=W.code(g,W.keyword,e.type))&&(k+=" "+W+" ",p&&(a+="}"));p&&(k+=" "+a+" ",a=""),e.type&&(k+=" } ",n&&n===e.type&&!t&&(k+=" else { ",r=g.schemaPath+".type",s=g.errSchemaPath+"/type",(R=R||[]).push(k),k="",g.createErrors!==!1?(k=(k+=" { keyword: 'type' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(s)+" , params: { type: '")+(i?""+n.join(","):""+n)+"' } ",g.opts.messages!==!1&&(k=(k+=" , message: 'should be ")+(i?""+n.join(","):""+n)+"' "),g.opts.verbose&&(k+=" , schema: validate.schema"+r+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+m+" "),k+=" } "):k+=" {} ",u=k,k=R.pop(),!g.compositeRule&&p?g.async?k+=" throw new ValidationError(["+u+"]); ":k+=" validate.errors = ["+u+"]; return false; ":k+=" var err = "+u+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } ")),p&&(k=(k+=" if (errors === ")+(M?"0":"errs_"+L)+") { ",l+="}")}}}p&&(k+=" "+l+" "),M?k=k+(G?" if (errors === 0) return data;            else throw new ValidationError(vErrors); ":" validate.errors = vErrors;  return errors === 0;       ")+" }; return validate;":k+=" var "+x+" = errors === errs_"+L+";"}return k;function $(j){for(var Q=j.rules,te=0;te<Q.length;te++)if(F(Q[te]))return 1}function F(j){return g.schema[j.keyword]!==void 0||j.implements&&function(Q){for(var te=Q.implements,he=0;he<te.length;he++)if(g.schema[te[he]]!==void 0)return 1}(j)}}},7931:function(ie,g,V){var X=/^[a-z_$][a-z0-9_$-]*$/i,k=V(1793),G=V(5868);function O(D,N){O.errors=null;var M=this._validateKeyword=this._validateKeyword||this.compile(G,!0);if(M(D))return!0;if(O.errors=M.errors,N)throw new Error("custom keyword definition is invalid: "+this.errorsText(M.errors));return!1}ie.exports={add:function(D,N){var M=this.RULES;if(M.keywords[D])throw new Error("Keyword "+D+" is already defined");if(!X.test(D))throw new Error("Keyword "+D+" is not a valid identifier");if(N){this.validateKeyword(N,!0);var L=N.type;if(Array.isArray(L))for(var C=0;C<L.length;C++)A(D,L[C],N);else A(D,L,N);var m=N.metaSchema;m&&(N.$data&&this._opts.$data&&(m={anyOf:[m,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]}),N.validateSchema=this.compile(m,!0))}function A(x,p,a){for(var l,n=0;n<M.length;n++){var i=M[n];if(i.type==p){l=i;break}}l||M.push(l={type:p,rules:[]}),a={keyword:x,definition:a,custom:!0,code:k,implements:a.implements},l.rules.push(a),M.custom[x]=a}return M.keywords[D]=M.all[D]=!0,this},get:function(D){var N=this.RULES.custom[D];return N?N.definition:this.RULES.keywords[D]||!1},remove:function(D){var N=this.RULES;delete N.keywords[D],delete N.all[D],delete N.custom[D];for(var M=0;M<N.length;M++)for(var L=N[M].rules,C=0;C<L.length;C++)if(L[C].keyword==D){L.splice(C,1);break}return this},validate:O}},2303:function(ie){ie.exports=function g(V,X){if(V===X)return!0;if(V&&X&&typeof V=="object"&&typeof X=="object"){if(V.constructor!==X.constructor)return!1;var k,G,O;if(Array.isArray(V)){if((k=V.length)!=X.length)return!1;for(G=k;G--!=0;)if(!g(V[G],X[G]))return!1}else{if(V.constructor===RegExp)return V.source===X.source&&V.flags===X.flags;if(V.valueOf!==Object.prototype.valueOf)return V.valueOf()===X.valueOf();if(V.toString!==Object.prototype.toString)return V.toString()===X.toString();if((k=(O=Object.keys(V)).length)!==Object.keys(X).length)return!1;for(G=k;G--!=0;)if(!Object.prototype.hasOwnProperty.call(X,O[G]))return!1;for(G=k;G--!=0;){var D=O[G];if(!g(V[D],X[D]))return!1}}return!0}return V!=V&&X!=X}},3508:function(ie){ie.exports=function(g,V){var X,k=typeof(V=typeof(V=V||{})=="function"?{cmp:V}:V).cycles=="boolean"&&V.cycles,G=V.cmp&&(X=V.cmp,function(D){return function(N,M){return N={key:N,value:D[N]},M={key:M,value:D[M]},X(N,M)}}),O=[];return function D(N){if((N=N&&N.toJSON&&typeof N.toJSON=="function"?N.toJSON():N)!==void 0){if(typeof N=="number")return isFinite(N)?""+N:"null";if(typeof N!="object")return JSON.stringify(N);if(Array.isArray(N)){for(C="[",m=0;m<N.length;m++)m&&(C+=","),C+=D(N[m])||"null";return C+"]"}if(N===null)return"null";if(O.indexOf(N)!==-1){if(k)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}for(var M=O.push(N)-1,L=Object.keys(N).sort(G&&G(N)),C="",m=0;m<L.length;m++){var A=L[m],x=D(N[A]);x&&(C&&(C+=","),C+=JSON.stringify(A)+":"+x)}return O.splice(M,1),"{"+C+"}"}}(g)}},233:function(ie){ie.exports=function g(L,C){function k(n){return g.insensitive&&(""+n).toLowerCase()||""+n}var G,O,p=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,x=/(^[ ]*|[ ]*$)/g,D=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,N=/^0x[0-9a-f]+$/i,M=/^0/,L=k(L).replace(x,"")||"",C=k(C).replace(x,"")||"",m=L.replace(p,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),A=C.replace(p,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),x=parseInt(L.match(N),16)||m.length!==1&&L.match(D)&&Date.parse(L),p=parseInt(C.match(N),16)||x&&C.match(D)&&Date.parse(C)||null;if(p){if(x<p)return-1;if(p<x)return 1}for(var a=0,l=Math.max(m.length,A.length);a<l;a++){if(G=!(m[a]||"").match(M)&&parseFloat(m[a])||m[a]||0,O=!(A[a]||"").match(M)&&parseFloat(A[a])||A[a]||0,isNaN(G)!==isNaN(O))return isNaN(G)?1:-1;if(typeof G!=typeof O&&(G+="",O+=""),G<O)return-1;if(O<G)return 1}return 0}},5156:function(ie,g){(function(V){function X(E){return E!==null&&Object.prototype.toString.call(E)==="[object Array]"}function k(E){return E!==null&&Object.prototype.toString.call(E)==="[object Object]"}function G(E,_){if(E!==_){if(Object.prototype.toString.call(E)!==Object.prototype.toString.call(_))return!1;if(X(E)===!0){if(E.length!==_.length)return!1;for(var P=0;P<E.length;P++)if(G(E[P],_[P])===!1)return!1}else{if(k(E)!==!0)return!1;var H,z,K={};for(H in E)if(hasOwnProperty.call(E,H)){if(G(E[H],_[H])===!1)return!1;K[H]=!0}for(z in _)if(hasOwnProperty.call(_,z)&&K[z]!==!0)return!1}}return!0}function O(E){if(E===""||E===!1||E===null||X(E)&&E.length===0)return!0;if(k(E)){for(var _ in E)if(E.hasOwnProperty(_))return!1;return!0}return!1}var D=typeof String.prototype.trimLeft=="function"?function(E){return E.trimLeft()}:function(E){return E.match(/^\s*(.*)/)[1]},N={0:"number",1:"any",2:"string",3:"array",4:"object",5:"boolean",6:"expression",7:"null",8:"Array<number>",9:"Array<string>"},M="UnquotedIdentifier",L="QuotedIdentifier",C="Rbracket",m="Rparen",A="Comma",x="Colon",p="Rbrace",a="Number",l="Current",n="Expref",i="Pipe",t="Flatten",e="Star",r="Filter",s="Lbrace",o="Lbracket",c="Lparen",d="Literal",b={".":"Dot","*":e,",":A,":":x,"{":s,"}":p,"]":C,"(":c,")":m,"@":l},I={"<":!0,">":!0,"=":!0,"!":!0},h={" ":!0,"	":!0,"\n":!0};function u(E){return"0"<=E&&E<="9"||E==="-"}function y(){}y.prototype={tokenize:function(E){var _,P,H=[];for(this._current=0;this._current<E.length;)if("a"<=(K=E[this._current])&&K<="z"||"A"<=K&&K<="Z"||K==="_")z=this._current,_=this._consumeUnquotedIdentifier(E),H.push({type:M,value:_,start:z});else if(b[E[this._current]]!==void 0)H.push({type:b[E[this._current]],value:E[this._current],start:this._current}),this._current++;else if(u(E[this._current]))P=this._consumeNumber(E),H.push(P);else if(E[this._current]==="[")P=this._consumeLBracket(E),H.push(P);else if(E[this._current]==='"')z=this._current,_=this._consumeQuotedIdentifier(E),H.push({type:L,value:_,start:z});else if(E[this._current]==="'")z=this._current,_=this._consumeRawStringLiteral(E),H.push({type:d,value:_,start:z});else if(E[this._current]==="`"){var z=this._current,K=this._consumeLiteral(E);H.push({type:d,value:K,start:z})}else if(I[E[this._current]]!==void 0)H.push(this._consumeOperator(E));else if(h[E[this._current]]!==void 0)this._current++;else if(E[this._current]==="&")z=this._current,this._current++,E[this._current]==="&"?(this._current++,H.push({type:"And",value:"&&",start:z})):H.push({type:n,value:"&",start:z});else{if(E[this._current]!=="|")throw(K=new Error("Unknown character:"+E[this._current])).name="LexerError",K;z=this._current,this._current++,E[this._current]==="|"?(this._current++,H.push({type:"Or",value:"||",start:z})):H.push({type:i,value:"|",start:z})}return H},_consumeUnquotedIdentifier:function(E){var _,P=this._current;for(this._current++;this._current<E.length&&("a"<=(_=E[this._current])&&_<="z"||"A"<=_&&_<="Z"||"0"<=_&&_<="9"||_==="_");)this._current++;return E.slice(P,this._current)},_consumeQuotedIdentifier:function(E){for(var _=this._current,P=(this._current++,E.length);E[this._current]!=='"'&&this._current<P;){var H=this._current;E[H]!=="\\"||E[H+1]!=="\\"&&E[H+1]!=='"'?H++:H+=2,this._current=H}return this._current++,JSON.parse(E.slice(_,this._current))},_consumeRawStringLiteral:function(E){for(var _=this._current,P=(this._current++,E.length);E[this._current]!=="'"&&this._current<P;){var H=this._current;E[H]!=="\\"||E[H+1]!=="\\"&&E[H+1]!=="'"?H++:H+=2,this._current=H}return this._current++,E.slice(_+1,this._current-1).replace("\\'","'")},_consumeNumber:function(E){for(var _=this._current,P=(this._current++,E.length);u(E[this._current])&&this._current<P;)this._current++;var H=parseInt(E.slice(_,this._current));return{type:a,value:H,start:_}},_consumeLBracket:function(E){var _=this._current;return this._current++,E[this._current]==="?"?(this._current++,{type:r,value:"[?",start:_}):E[this._current]==="]"?(this._current++,{type:t,value:"[]",start:_}):{type:o,value:"[",start:_}},_consumeOperator:function(E){var _=this._current,P=E[_];return this._current++,P==="!"?E[this._current]==="="?(this._current++,{type:"NE",value:"!=",start:_}):{type:"Not",value:"!",start:_}:P==="<"?E[this._current]==="="?(this._current++,{type:"LTE",value:"<=",start:_}):{type:"LT",value:"<",start:_}:P===">"?E[this._current]==="="?(this._current++,{type:"GTE",value:">=",start:_}):{type:"GT",value:">",start:_}:P==="="&&E[this._current]==="="?(this._current++,{type:"EQ",value:"==",start:_}):void 0},_consumeLiteral:function(E){this._current++;for(var _=this._current,P=E.length;E[this._current]!=="`"&&this._current<P;){var H=this._current;E[H]!=="\\"||E[H+1]!=="\\"&&E[H+1]!=="`"?H++:H+=2,this._current=H}return _=(_=D(E.slice(_,this._current))).replace("\\`","`"),_=this._looksLikeJSON(_)?JSON.parse(_):JSON.parse('"'+_+'"'),this._current++,_},_looksLikeJSON:function(E){if(E==="")return!1;if(0<='[{"'.indexOf(E[0])||0<=["true","false","null"].indexOf(E))return!0;if(!(0<="-0123456789".indexOf(E[0])))return!1;try{return JSON.parse(E),!0}catch{return!1}}};var w={};function v(){}function T(E){this.runtime=E}function B(E){this._interpreter=E,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[0]}]},avg:{_func:this._functionAvg,_signature:[{types:[8]}]},ceil:{_func:this._functionCeil,_signature:[{types:[0]}]},contains:{_func:this._functionContains,_signature:[{types:[2,3]},{types:[1]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[2]},{types:[2]}]},floor:{_func:this._functionFloor,_signature:[{types:[0]}]},length:{_func:this._functionLength,_signature:[{types:[2,3,4]}]},map:{_func:this._functionMap,_signature:[{types:[6]},{types:[3]}]},max:{_func:this._functionMax,_signature:[{types:[8,9]}]},merge:{_func:this._functionMerge,_signature:[{types:[4],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[3]},{types:[6]}]},sum:{_func:this._functionSum,_signature:[{types:[8]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[2]},{types:[2]}]},min:{_func:this._functionMin,_signature:[{types:[8,9]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[3]},{types:[6]}]},type:{_func:this._functionType,_signature:[{types:[1]}]},keys:{_func:this._functionKeys,_signature:[{types:[4]}]},values:{_func:this._functionValues,_signature:[{types:[4]}]},sort:{_func:this._functionSort,_signature:[{types:[9,8]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[3]},{types:[6]}]},join:{_func:this._functionJoin,_signature:[{types:[2]},{types:[9]}]},reverse:{_func:this._functionReverse,_signature:[{types:[2,3]}]},to_array:{_func:this._functionToArray,_signature:[{types:[1]}]},to_string:{_func:this._functionToString,_signature:[{types:[1]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[1]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[1],variadic:!0}]}}}w.EOF=0,w[M]=0,w[L]=0,w[C]=0,w[m]=0,w[A]=0,w[p]=0,w[a]=0,w[l]=0,w[n]=0,w.Pipe=1,w.Or=2,w.And=3,w.EQ=5,w.GT=5,w.LT=5,w.GTE=5,w.LTE=5,w.NE=5,w[t]=9,w.Star=20,w[r]=21,w.Dot=40,w.Not=45,w[s]=50,w[o]=55,w[c]=60,v.prototype={parse:function(P){this._loadTokens(P),this.index=0;var _,P=this.expression(0);if(this._lookahead(0)!=="EOF")throw _=this._lookaheadToken(0),(_=new Error("Unexpected token type: "+_.type+", value: "+_.value)).name="ParserError",_;return P},_loadTokens:function(E){var _=new y().tokenize(E);_.push({type:"EOF",value:"",start:E.length}),this.tokens=_},expression:function(E){for(var _=this._lookaheadToken(0),P=(this._advance(),this.nud(_)),H=this._lookahead(0);E<w[H];)this._advance(),P=this.led(H,P),H=this._lookahead(0);return P},_lookahead:function(E){return this.tokens[this.index+E].type},_lookaheadToken:function(E){return this.tokens[this.index+E]},_advance:function(){this.index++},nud:function(E){var _,P;switch(E.type){case d:return{type:"Literal",value:E.value};case M:return{type:"Field",name:E.value};case L:var H={type:"Field",name:E.value};if(this._lookahead(0)===c)throw new Error("Quoted identifier not allowed for function names.");return H;case"Not":return{type:"NotExpression",children:[_=this.expression(w.Not)]};case e:return _=null,{type:"ValueProjection",children:[{type:"Identity"},_=this._lookahead(0)===C?{type:"Identity"}:this._parseProjectionRHS(w.Star)]};case r:return this.led(E.type,{type:"Identity"});case s:return this._parseMultiselectHash();case t:return{type:"Projection",children:[{type:t,children:[{type:"Identity"}]},_=this._parseProjectionRHS(w.Flatten)]};case o:return this._lookahead(0)===a||this._lookahead(0)===x?(_=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},_)):this._lookahead(0)===e&&this._lookahead(1)===C?(this._advance(),this._advance(),{type:"Projection",children:[{type:"Identity"},_=this._parseProjectionRHS(w.Star)]}):this._parseMultiselectList();case l:return{type:l};case n:return{type:"ExpressionReference",children:[P=this.expression(w.Expref)]};case c:for(var z=[];this._lookahead(0)!==m;)this._lookahead(0)===l?(P={type:l},this._advance()):P=this.expression(0),z.push(P);return this._match(m),z[0];default:this._errorToken(E)}},led:function(E,_){var P;switch(E){case"Dot":var H=w.Dot;return this._lookahead(0)!==e?{type:"Subexpression",children:[_,P=this._parseDotRHS(H)]}:(this._advance(),{type:"ValueProjection",children:[_,P=this._parseProjectionRHS(H)]});case i:return P=this.expression(w.Pipe),{type:i,children:[_,P]};case"Or":return{type:"OrExpression",children:[_,P=this.expression(w.Or)]};case"And":return{type:"AndExpression",children:[_,P=this.expression(w.And)]};case c:for(var z,H=_.name,K=[];this._lookahead(0)!==m;)this._lookahead(0)===l?(z={type:l},this._advance()):z=this.expression(0),this._lookahead(0)===A&&this._match(A),K.push(z);return this._match(m),{type:"Function",name:H,children:K};case r:return H=this.expression(0),this._match(C),{type:"FilterProjection",children:[_,P=this._lookahead(0)===t?{type:"Identity"}:this._parseProjectionRHS(w.Filter),H]};case t:return{type:"Projection",children:[{type:t,children:[_]},this._parseProjectionRHS(w.Flatten)]};case"EQ":case"NE":case"GT":case"GTE":case"LT":case"LTE":return this._parseComparator(_,E);case o:return H=this._lookaheadToken(0),H.type===a||H.type===x?(P=this._parseIndexExpression(),this._projectIfSlice(_,P)):(this._match(e),this._match(C),{type:"Projection",children:[_,P=this._parseProjectionRHS(w.Star)]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(E){var _;if(this._lookahead(0)!==E)throw _=this._lookaheadToken(0),(E=new Error("Expected "+E+", got: "+_.type)).name="ParserError",E;this._advance()},_errorToken:function(E){throw E=new Error("Invalid token ("+E.type+'): "'+E.value+'"'),E.name="ParserError",E},_parseIndexExpression:function(){var E;return this._lookahead(0)===x||this._lookahead(1)===x?this._parseSliceExpression():(E={type:"Index",value:this._lookaheadToken(0).value},this._advance(),this._match(C),E)},_projectIfSlice:function(E,_){return E={type:"IndexExpression",children:[E,_]},_.type==="Slice"?{type:"Projection",children:[E,this._parseProjectionRHS(w.Star)]}:E},_parseSliceExpression:function(){for(var E,_=[null,null,null],P=0,H=this._lookahead(0);H!==C&&P<3;){if(H===x)P++;else{if(H!==a)throw E=this._lookahead(0),(E=new Error("Syntax error, unexpected token: "+E.value+"("+E.type+")")).name="Parsererror",E;_[P]=this._lookaheadToken(0).value}this._advance(),H=this._lookahead(0)}return this._match(C),{type:"Slice",children:_}},_parseComparator:function(E,_){return{type:"Comparator",name:_,children:[E,this.expression(w[_])]}},_parseDotRHS:function(E){var _=this._lookahead(0);return 0<=[M,L,e].indexOf(_)?this.expression(E):_===o?(this._match(o),this._parseMultiselectList()):_===s?(this._match(s),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(E){var _,P;if(w[this._lookahead(0)]<10)_={type:"Identity"};else if(this._lookahead(0)===o)_=this.expression(E);else if(this._lookahead(0)===r)_=this.expression(E);else{if(this._lookahead(0)!=="Dot")throw P=this._lookaheadToken(0),(P=new Error("Sytanx error, unexpected token: "+P.value+"("+P.type+")")).name="ParserError",P;this._match("Dot"),_=this._parseDotRHS(E)}return _},_parseMultiselectList:function(){for(var E=[];this._lookahead(0)!==C;){var _=this.expression(0);if(E.push(_),this._lookahead(0)===A&&(this._match(A),this._lookahead(0)===C))throw new Error("Unexpected token Rbracket")}return this._match(C),{type:"MultiSelectList",children:E}},_parseMultiselectHash:function(){for(var E,_,P=[],H=[M,L];;){if(E=this._lookaheadToken(0),H.indexOf(E.type)<0)throw new Error("Expecting an identifier token, got: "+E.type);if(E=E.value,this._advance(),this._match(x),_=this.expression(0),P.push({type:"KeyValuePair",name:E,value:_}),this._lookahead(0)===A)this._match(A);else if(this._lookahead(0)===p){this._match(p);break}}return{type:"MultiSelectHash",children:P}}},T.prototype={search:function(E,_){return this.visit(E,_)},visit:function(E,_){var P,H,z,K,Y,R;switch(E.type){case"Field":return _!==null&&k(_)?(Z=_[E.name])===void 0?null:Z:null;case"Subexpression":for($=this.visit(E.children[0],_),te=1;te<E.children.length;te++)if(($=this.visit(E.children[1],$))===null)return null;return $;case"IndexExpression":return Y=this.visit(E.children[0],_),this.visit(E.children[1],Y);case"Index":return X(_)?($=_[Z=(Z=E.value)<0?_.length+Z:Z])===void 0?null:$:null;case"Slice":if(!X(_))return null;var Z=E.children.slice(0),Z=this.computeSliceParams(_.length,Z),W=Z[0],f=Z[1],S=Z[2],$=[];if(0<S)for(te=W;te<f;te+=S)$.push(_[te]);else for(te=W;f<te;te+=S)$.push(_[te]);return $;case"Projection":var F=this.visit(E.children[0],_);if(!X(F))return null;for(j=[],te=0;te<F.length;te++)(H=this.visit(E.children[1],F[te]))!==null&&j.push(H);return j;case"ValueProjection":if(!k(F=this.visit(E.children[0],_)))return null;for(var j=[],Q=function(Ee){for(var Re=Object.keys(Ee),we=[],de=0;de<Re.length;de++)we.push(Ee[Re[de]]);return we}(F),te=0;te<Q.length;te++)(H=this.visit(E.children[1],Q[te]))!==null&&j.push(H);return j;case"FilterProjection":if(!X(F=this.visit(E.children[0],_)))return null;var he=[],ve=[];for(te=0;te<F.length;te++)O(P=this.visit(E.children[2],F[te]))||he.push(F[te]);for(var ue=0;ue<he.length;ue++)(H=this.visit(E.children[1],he[ue]))!==null&&ve.push(H);return ve;case"Comparator":switch(z=this.visit(E.children[0],_),K=this.visit(E.children[1],_),E.name){case"EQ":$=G(z,K);break;case"NE":$=!G(z,K);break;case"GT":$=K<z;break;case"GTE":$=K<=z;break;case"LT":$=z<K;break;case"LTE":$=z<=K;break;default:throw new Error("Unknown comparator: "+E.name)}return $;case t:var fe=this.visit(E.children[0],_);if(!X(fe))return null;var Ce=[];for(te=0;te<fe.length;te++)X(H=fe[te])?Ce.push.apply(Ce,H):Ce.push(H);return Ce;case"Identity":return _;case"MultiSelectList":if(_===null)return null;for(j=[],te=0;te<E.children.length;te++)j.push(this.visit(E.children[te],_));return j;case"MultiSelectHash":if(_===null)return null;for(j={},te=0;te<E.children.length;te++)j[(R=E.children[te]).name]=this.visit(R.value,_);return j;case"OrExpression":return P=O(P=this.visit(E.children[0],_))?this.visit(E.children[1],_):P;case"AndExpression":return O(z=this.visit(E.children[0],_))===!0?z:this.visit(E.children[1],_);case"NotExpression":return O(z=this.visit(E.children[0],_));case"Literal":return E.value;case i:return Y=this.visit(E.children[0],_),this.visit(E.children[1],Y);case l:return _;case"Function":var Ae=[];for(te=0;te<E.children.length;te++)Ae.push(this.visit(E.children[te],_));return this.runtime.callFunction(E.name,Ae);case"ExpressionReference":return Z=E.children[0],Z.jmespathType=n,Z;default:throw new Error("Unknown node type: "+E.type)}},computeSliceParams:function(E,P){var K=P[0],Y=P[1],P=P[2],H=[null,null,null];if(P===null)P=1;else if(P===0)throw(z=new Error("Invalid slice, step cannot be 0")).name="RuntimeError",z;var z=P<0,K=K===null?z?E-1:0:this.capSliceRange(E,K,P),Y=Y===null?z?-1:E:this.capSliceRange(E,Y,P);return H[0]=K,H[1]=Y,H[2]=P,H},capSliceRange:function(E,_,P){return _<0?(_+=E)<0&&(_=P<0?-1:0):E<=_&&(_=P<0?E-1:E),_}},B.prototype={callFunction:function(E,_){var P=this.functionTable[E];if(P===void 0)throw new Error("Unknown function: "+E+"()");return this._validateArgs(E,_,P._signature),P._func.call(this,_)},_validateArgs:function(E,_,P){var H;if(P[P.length-1].variadic){if(_.length<P.length)throw H=P.length===1?" argument":" arguments",new Error("ArgumentError: "+E+"() takes at least"+P.length+H+" but received "+_.length)}else if(_.length!==P.length)throw H=P.length===1?" argument":" arguments",new Error("ArgumentError: "+E+"() takes "+P.length+H+" but received "+_.length);for(var z=0;z<P.length;z++){for(var K,Y=!1,R=P[z].types,Z=this._getTypeName(_[z]),W=0;W<R.length;W++)if(this._typeMatches(Z,R[W],_[z])){Y=!0;break}if(!Y)throw K=R.map(function(f){return N[f]}).join(","),new Error("TypeError: "+E+"() expected argument "+(z+1)+" to be type "+K+" but received type "+N[Z]+" instead.")}},_typeMatches:function(E,_,P){if(_===1)return!0;if(_!==9&&_!==8&&_!==3)return E===_;if(_===3)return E===3;if(E===3){var H;_===8?H=0:_===9&&(H=2);for(var z=0;z<P.length;z++)if(!this._typeMatches(this._getTypeName(P[z]),H,P[z]))return!1;return!0}},_getTypeName:function(E){switch(Object.prototype.toString.call(E)){case"[object String]":return 2;case"[object Number]":return 0;case"[object Array]":return 3;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return E.jmespathType===n?6:4}},_functionStartsWith:function(E){return E[0].lastIndexOf(E[1])===0},_functionEndsWith:function(P){var _=P[0],P=P[1];return _.indexOf(P,_.length-P.length)!==-1},_functionReverse:function(E){var _;if(this._getTypeName(E[0])!==2)return(_=E[0].slice(0)).reverse(),_;for(var P=E[0],H="",z=P.length-1;0<=z;z--)H+=P[z];return H},_functionAbs:function(E){return Math.abs(E[0])},_functionCeil:function(E){return Math.ceil(E[0])},_functionAvg:function(E){for(var _=0,P=E[0],H=0;H<P.length;H++)_+=P[H];return _/P.length},_functionContains:function(E){return 0<=E[0].indexOf(E[1])},_functionFloor:function(E){return Math.floor(E[0])},_functionLength:function(E){return(k(E[0])?Object.keys(E[0]):E[0]).length},_functionMap:function(E){for(var _=[],P=this._interpreter,H=E[0],z=E[1],K=0;K<z.length;K++)_.push(P.visit(H,z[K]));return _},_functionMerge:function(E){for(var _={},P=0;P<E.length;P++){var H,z=E[P];for(H in z)_[H]=z[H]}return _},_functionMax:function(E){if(0<E[0].length){if(this._getTypeName(E[0][0])===0)return Math.max.apply(Math,E[0]);for(var _=E[0],P=_[0],H=1;H<_.length;H++)P.localeCompare(_[H])<0&&(P=_[H]);return P}return null},_functionMin:function(E){if(0<E[0].length){if(this._getTypeName(E[0][0])===0)return Math.min.apply(Math,E[0]);for(var _=E[0],P=_[0],H=1;H<_.length;H++)_[H].localeCompare(P)<0&&(P=_[H]);return P}return null},_functionSum:function(E){for(var _=0,P=E[0],H=0;H<P.length;H++)_+=P[H];return _},_functionType:function(E){switch(this._getTypeName(E[0])){case 0:return"number";case 2:return"string";case 3:return"array";case 4:return"object";case 5:return"boolean";case 6:return"expref";case 7:return"null"}},_functionKeys:function(E){return Object.keys(E[0])},_functionValues:function(E){for(var _=E[0],P=Object.keys(_),H=[],z=0;z<P.length;z++)H.push(_[P[z]]);return H},_functionJoin:function(E){var _=E[0];return E[1].join(_)},_functionToArray:function(E){return this._getTypeName(E[0])===3?E[0]:[E[0]]},_functionToString:function(E){return this._getTypeName(E[0])===2?E[0]:JSON.stringify(E[0])},_functionToNumber:function(E){var _=this._getTypeName(E[0]);return _===0?E[0]:_!==2||(_=+E[0],isNaN(_))?null:_},_functionNotNull:function(E){for(var _=0;_<E.length;_++)if(this._getTypeName(E[_])!==7)return E[_];return null},_functionSort:function(E){return E=E[0].slice(0),E.sort(),E},_functionSortBy:function(E){var _=E[0].slice(0);if(_.length!==0){var P=this._interpreter,H=E[1],z=this._getTypeName(P.visit(H,_[0]));if([0,2].indexOf(z)<0)throw new Error("TypeError");for(var K=this,Y=[],R=0;R<_.length;R++)Y.push([R,_[R]]);Y.sort(function(W,f){var S=P.visit(H,W[1]),$=P.visit(H,f[1]);if(K._getTypeName(S)!==z)throw new Error("TypeError: expected "+z+", received "+K._getTypeName(S));if(K._getTypeName($)!==z)throw new Error("TypeError: expected "+z+", received "+K._getTypeName($));return $<S?1:S<$?-1:W[0]-f[0]});for(var Z=0;Z<Y.length;Z++)_[Z]=Y[Z][1]}return _},_functionMaxBy:function(E){for(var _,P,H=E[1],z=E[0],K=this.createKeyFunction(H,[0,2]),Y=-1/0,R=0;R<z.length;R++)Y<(P=K(z[R]))&&(Y=P,_=z[R]);return _},_functionMinBy:function(E){for(var _,P,H=E[1],z=E[0],K=this.createKeyFunction(H,[0,2]),Y=1/0,R=0;R<z.length;R++)(P=K(z[R]))<Y&&(Y=P,_=z[R]);return _},createKeyFunction:function(E,_){var P=this,H=this._interpreter;return function(Y){var K,Y=H.visit(E,Y);if(_.indexOf(P._getTypeName(Y))<0)throw K="TypeError: expected one of "+_+", received "+P._getTypeName(Y),new Error(K);return Y}}},V.tokenize=function(E){return new y().tokenize(E)},V.compile=function(E){return new v().parse(E)},V.search=function(E,_){var P=new v,H=new T(z=new B),z=(z._interpreter=H,P.parse(_));return H.search(z,E)},V.strictDeepEqual=G})(g)},500:function(ie){var g=ie.exports=function(X,k,G){typeof k=="function"&&(G=k,k={}),function O(D,N,M,L,C,m,A,x,p,a){if(L&&typeof L=="object"&&!Array.isArray(L)){for(var l in N(L,C,m,A,x,p,a),L){var n=L[l];if(Array.isArray(n)){if(l in g.arrayKeywords)for(var i=0;i<n.length;i++)O(D,N,M,n[i],C+"/"+l+"/"+i,m,C,l,L,i)}else if(l in g.propsKeywords){if(n&&typeof n=="object")for(var t in n)O(D,N,M,n[t],C+"/"+l+"/"+V(t),m,C,l,L,t)}else(l in g.keywords||D.allKeys&&!(l in g.skipKeywords))&&O(D,N,M,n,C+"/"+l,m,C,l,L)}M(L,C,m,A,x,p,a)}}(k,typeof(G=k.cb||G)=="function"?G:G.pre||function(){},G.post||function(){},X,"",X)};function V(X){return X.replace(/~/g,"~0").replace(/\//g,"~1")}g.keywords={additionalItems:!0,items:!0,contains:!0,additionalProperties:!0,propertyNames:!0,not:!0},g.arrayKeywords={items:!0,allOf:!0,anyOf:!0,oneOf:!0},g.propsKeywords={definitions:!0,properties:!0,patternProperties:!0,dependencies:!0},g.skipKeywords={default:!0,enum:!0,const:!0,required:!0,maximum:!0,minimum:!0,exclusiveMaximum:!0,exclusiveMinimum:!0,multipleOf:!0,maxLength:!0,minLength:!0,pattern:!0,format:!0,maxItems:!0,minItems:!0,uniqueItems:!0,maxProperties:!0,minProperties:!0}},7026:function(ie,g){var V={b:"\b",f:"\f",n:`
`,r:"\r",t:"	",'"':'"',"/":"/","\\":"\\"},X="a".charCodeAt(),k=(g.parse=function(a,l,n){var i={},t=0,e=0,r=0,s=n&&n.bigint&&typeof BigInt<"u";return{data:o("",!0),pointers:i};function o(_,P){c(),y(_,"value");var H,z=I();switch(z){case"t":b("rue"),H=!0;break;case"f":b("alse"),H=!1;break;case"n":b("ull"),H=null;break;case'"':H=d();break;case"[":H=function(K){c();var Y=[],R=0;if(I()!="]")for(h();;){var Z=K+"/"+R,Z=(Y.push(o(Z)),c(),I());if(Z=="]")break;Z!=","&&B(),c(),R++}return Y}(_);break;case"{":H=function(K){c();var Y={};if(I()!="}")for(h();;){var W=v(),R=(I()!='"'&&B(),d()),Z=K+"/"+p(R),W=(w(Z,"key",W),y(Z,"keyEnd"),c(),I()!=":"&&B(),c(),Y[R]=o(Z),c(),I());if(W=="}")break;W!=","&&B(),c()}return Y}(_);break;default:h(),0<="-0123456789".indexOf(z)?H=function(){var K="",Y=!0;a[r]=="-"&&(K+=I()),K+=(a[r]=="0"?I:u)(),a[r]=="."&&(K+=I()+u(),Y=!1),a[r]!="e"&&a[r]!="E"||(K+=I(),a[r]!="+"&&a[r]!="-"||(K+=I()),K+=u(),Y=!1);var R=+K;return s&&Y&&(R>Number.MAX_SAFE_INTEGER||R<Number.MIN_SAFE_INTEGER)?BigInt(K):R}():T()}return y(_,"valueEnd"),c(),P&&r<a.length&&T(),H}function c(){e:for(;r<a.length;){switch(a[r]){case" ":e++;break;case"	":e+=4;break;case"\r":e=0;break;case`
`:e=0,t++;break;default:break e}r++}}function d(){for(var _,P="";(_=I())!='"';)_=="\\"?(_=I())in V?P+=V[_]:_=="u"?P+=function(){for(var H=4,z=0;H--;){z<<=4;var K=I().toLowerCase();"a"<=K&&K<="f"?z+=K.charCodeAt()-X+10:"0"<=K&&K<="9"?z+=+K:B()}return String.fromCharCode(z)}():B():P+=_;return P}function b(_){for(var P=0;P<_.length;P++)I()!==_[P]&&B()}function I(){E();var _=a[r];return r++,e++,_}function h(){r--,e--}function u(){for(var _="";"0"<=a[r]&&a[r]<="9";)_+=I();if(_.length)return _;E(),T()}function y(_,P){w(_,P,v())}function w(_,P,H){i[_]=i[_]||{},i[_][P]=H}function v(){return{line:t,column:e,pos:r}}function T(){throw new SyntaxError("Unexpected token "+a[r]+" in JSON at position "+r)}function B(){h(),T()}function E(){if(r>=a.length)throw new SyntaxError("Unexpected end of JSON input")}},g.stringify=function(a,l,n){if(G(a)){var i=0;switch(typeof(e=typeof n=="object"?n.space:n)){case"number":var t=10<e?10:e<0?0:Math.floor(e),e=t&&T(t," "),r=t,s=t;break;case"string":e=e.slice(0,10);for(var o=s=r=0;o<e.length;o++){switch(e[o]){case" ":s++;break;case"	":s+=4;break;case"\r":s=0;break;case`
`:s=0,i++;break;default:throw new Error("whitespace characters not allowed in JSON")}r++}break;default:e=void 0}var c="",d={},b=0,I=0,h=0,u=n&&n.es6&&typeof Map=="function";return function B(E,_,P){switch(v(P,"value"),typeof E){case"number":case"bigint":case"boolean":y(""+E);break;case"string":y(m(E));break;case"object":E===null?y("null"):typeof E.toJSON=="function"?y(m(E.toJSON())):Array.isArray(E)?H():u?E.constructor.BYTES_PER_ELEMENT?H():E instanceof Map?K():E instanceof Set?K(!0):z():z()}v(P,"valueEnd");function H(){if(E.length){y("[");for(var Y=_+1,R=0;R<E.length;R++){R&&y(","),w(Y);var Z=G(E[R])?E[R]:null,W=P+"/"+R;B(Z,Y,W)}w(_),y("]")}else y("[]")}function z(){var Y=Object.keys(E);if(Y.length){y("{");for(var R=_+1,Z=0;Z<Y.length;Z++){var W,f=Y[Z],S=E[f];G(S)&&(Z&&y(","),W=P+"/"+p(f),w(R),v(W,"key"),y(m(f)),v(W,"keyEnd"),y(":"),e&&y(" "),B(S,R,W))}w(_),y("}")}else y("{}")}function K(Y){if(E.size){y("{");for(var R=_+1,Z=!0,W=E.entries(),f=W.next();!f.done;){var S,F=f.value,$=F[0],F=!!Y||F[1];G(F)&&(Z||y(","),Z=!1,S=P+"/"+p($),w(R),v(S,"key"),y(m($)),v(S,"keyEnd"),y(":"),e&&y(" "),B(F,R,S)),f=W.next()}w(_),y("}")}else y("{}")}}(a,0,""),{json:c,pointers:d}}function y(B){I+=B.length,h+=B.length,c+=B}function w(B){if(e){for(c+=`
`+T(B,e),b++,I=0;B--;)i?(b+=i,I=s):I+=s,h+=r;h+=1}}function v(B,E){d[B]=d[B]||{},d[B][E]={line:b,column:I,pos:h}}function T(B,E){return Array(B+1).join(E)}},["number","bigint","boolean","string","object"]);function G(a){return 0<=k.indexOf(typeof a)}var O=/"|\\/g,D=/[\b]/g,N=/\f/g,M=/\n/g,L=/\r/g,C=/\t/g;function m(a){return'"'+(a=a.replace(O,"\\$&").replace(N,"\\f").replace(D,"\\b").replace(M,"\\n").replace(L,"\\r").replace(C,"\\t"))+'"'}var A=/~/g,x=/\//g;function p(a){return a.replace(A,"~0").replace(x,"~1")}},483:function(ie,g){var V,X;(function(){X=[],(X=typeof(V=function(){function k(n){return typeof Node=="object"?n instanceof Node:n&&typeof n=="object"&&typeof n.nodeType=="number"}function G(n){return typeof n=="string"}function O(){var n=[];return{watch:n.push.bind(n),trigger:function(i,t){for(var e=!0,r={detail:t,preventDefault:function(){e=!1}},s=0;s<n.length;s++)n[s](i,r);return e}}}function D(n){return window.getComputedStyle(n).display==="none"}function N(n){this.elem=n}function M(n,i){return N.make(n("parent")).clazz("pico-overlay").clazz(n("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(n("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){n("overlayClose",!0)&&i()})}N.make=function(n,i){typeof n=="string"&&(n=document.querySelector(n));var t=document.createElement(i||"div");return(n||document.body).appendChild(t),new N(t)},N.prototype={child:function(n){return N.make(this.elem,n)},stylize:function(n){n=n||{},typeof n.opacity<"u"&&(n.filter="alpha(opacity="+n.opacity*100+")");for(var i in n)n.hasOwnProperty(i)&&(this.elem.style[i]=n[i]);return this},clazz:function(n){return this.elem.className+=" "+n,this},html:function(n){return k(n)?this.elem.appendChild(n):this.elem.innerHTML=n,this},onClick:function(n){return this.elem.addEventListener("click",n),this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(n,i){return i!==void 0&&this.elem.setAttribute(n,i),this},anyAncestor:function(n){for(var i=this.elem;i;){if(n(new N(i)))return!0;i=i.parentNode}return!1},isVisible:function(){return!D(this.elem)}};var L=1;function C(n,i){var t=n("width","auto");typeof t=="number"&&(t=""+t+"px");var e=n("modalId","pico-"+L++),r=N.make(n("parent")).clazz("pico-content").clazz(n("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:t,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(n("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(n("content")).attr("id",e).attr("role","dialog").attr("aria-labelledby",n("ariaLabelledBy")).attr("aria-describedby",n("ariaDescribedBy",e)).onClick(function(s){var o=new N(s.target).anyAncestor(function(c){return/\bpico-close\b/.test(c.elem.className)});o&&i()});return r}function m(n,i){if(i("closeButton",!0))return n.child("button").html(i("closeHtml","&#xD7;")).clazz("pico-close").clazz(i("closeClass","")).stylize(i("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",i("close-label","Close"))}function A(n){return function(){return n().elem}}var x=O(),p=O();function a(n,i){function t(c,d){var b=c.msMatchesSelector||c.webkitMatchesSelector||c.matches;return b.call(c,d)}function e(c){return D(c)||t(c,":disabled")||c.hasAttribute("contenteditable")?!1:c.hasAttribute("tabindex")||t(c,"input,select,textarea,button,a[href],area[href],iframe")}function r(c){for(var d=c.getElementsByTagName("*"),b=0;b<d.length;b++)if(e(d[b]))return d[b]}function s(c){for(var d=c.getElementsByTagName("*"),b=d.length;b--;)if(e(d[b]))return d[b]}var o;n.beforeShow(function(){o=document.activeElement}),n.afterShow(function(){if(i()){var d=r(n.modalElem());d&&d.focus()}}),n.afterClose(function(){i()&&o&&o.focus(),o=null}),p.watch(function(d){if(i()&&n.isVisible()){var b=r(n.modalElem()),I=s(n.modalElem()),h=d.shiftKey?b:I;h===document.activeElement&&((d.shiftKey?I:b).focus(),d.preventDefault())}})}function l(n,i){var t,e=new N(document.body);n.beforeShow(function(){t=e.elem.style.overflow,i()&&e.stylize({overflow:"hidden"})}),n.afterClose(function(){e.stylize({overflow:t})})}return document.documentElement.addEventListener("keydown",function(i){var t=i.which||i.keyCode;t===27?x.trigger():t===9&&p.trigger(i)}),function(i){(G(i)||k(i))&&(i={content:i});var t=O(),e=O(),r=O(),s=O(),o=O();function c(B,E){var _=i[B];return typeof _=="function"&&(_=_(E)),_===void 0?E:_}var d=T.bind(window,"modal"),b=T.bind(window,"overlay"),I=T.bind(window,"close"),h;function u(B){b().hide(),d().hide(),o.trigger(h,B)}function y(B){s.trigger(h,B)&&u(B)}function w(B){return function(){return B.apply(this,arguments),h}}var v;function T(B,E){if(!v){var _=C(c,y);v={modal:_,overlay:M(c,y),close:m(_,c)},t.trigger(h,E)}return v[B]}return h={modalElem:A(d),closeElem:A(I),overlayElem:A(b),buildDom:w(T.bind(null,null)),isVisible:function(){return!!(v&&d&&d().isVisible())},show:function(B){return e.trigger(h,B)&&(b().show(),I(),d().show(),r.trigger(h,B)),this},close:w(y),forceClose:w(u),destroy:function(){d().destroy(),b().destroy(),b=d=I=void 0},options:function(B){Object.keys(B).map(function(E){i[E]=B[E]})},afterCreate:w(t.watch),beforeShow:w(e.watch),afterShow:w(r.watch),beforeClose:w(s.watch),afterClose:w(o.watch)},a(h,c.bind(null,"focus",!0)),l(h,c.bind(null,"bodyOverflow",!0)),x.watch(function(){c("escCloses",!0)&&h.isVisible()&&h.close()}),h}})=="function"?V.apply(g,X):V)!==void 0&&(ie.exports=X)})()},7533:function(ie,g){/** @license URI.js v4.4.1 (c) 2011 Gary Court. License: http://github.com/garycourt/uri-js */(function(V){function X(){for(var q=arguments.length,U=Array(q),ee=0;ee<q;ee++)U[ee]=arguments[ee];if(U.length>1){U[0]=U[0].slice(0,-1);for(var se=U.length-1,re=1;re<se;++re)U[re]=U[re].slice(1,-1);return U[se]=U[se].slice(1),U.join("")}else return U[0]}function k(q){return"(?:"+q+")"}function G(q){return q===void 0?"undefined":q===null?"null":Object.prototype.toString.call(q).split(" ").pop().split("]").shift().toLowerCase()}function O(q){return q.toUpperCase()}function D(q){return q!=null?q instanceof Array?q:typeof q.length!="number"||q.split||q.setInterval||q.call?[q]:Array.prototype.slice.call(q):[]}function N(q,U){var ee=q;if(U)for(var se in U)ee[se]=U[se];return ee}function M(q){var U="[A-Za-z]",ee="[0-9]",se=X(ee,"[A-Fa-f]"),re=k(k("%[EFef]"+se+"%"+se+se+"%"+se+se)+"|"+k("%[89A-Fa-f]"+se+"%"+se+se)+"|"+k("%"+se+se)),Se="[\\:\\/\\?\\#\\[\\]\\@]",ke="[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",Be=X(Se,ke),Pe=q?"[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]":"[]",Ve=q?"[\\uE000-\\uF8FF]":"[]",$e=X(U,ee,"[\\-\\.\\_\\~]",Pe);k(U+X(U,ee,"[\\+\\-\\.]")+"*"),k(k(re+"|"+X($e,ke,"[\\:]"))+"*");var Ne=k(k("25[0-5]")+"|"+k("2[0-4]"+ee)+"|"+k("1"+ee+ee)+"|"+k("0?[1-9]"+ee)+"|0?0?"+ee),Ze=k(Ne+"\\."+Ne+"\\."+Ne+"\\."+Ne),_e=k(se+"{1,4}"),Fe=k(k(_e+"\\:"+_e)+"|"+Ze),Oe=k(k(_e+"\\:")+"{6}"+Fe),Me=k("\\:\\:"+k(_e+"\\:")+"{5}"+Fe),et=k(k(_e)+"?\\:\\:"+k(_e+"\\:")+"{4}"+Fe),Ye=k(k(k(_e+"\\:")+"{0,1}"+_e)+"?\\:\\:"+k(_e+"\\:")+"{3}"+Fe),Je=k(k(k(_e+"\\:")+"{0,2}"+_e)+"?\\:\\:"+k(_e+"\\:")+"{2}"+Fe),nt=k(k(k(_e+"\\:")+"{0,3}"+_e)+"?\\:\\:"+_e+"\\:"+Fe),tt=k(k(k(_e+"\\:")+"{0,4}"+_e)+"?\\:\\:"+Fe),Xe=k(k(k(_e+"\\:")+"{0,5}"+_e)+"?\\:\\:"+_e),Ue=k(k(k(_e+"\\:")+"{0,6}"+_e)+"?\\:\\:"),it=k([Oe,Me,et,Ye,Je,nt,tt,Xe,Ue].join("|")),qe=k(k($e+"|"+re)+"+");k("[vV]"+se+"+\\."+X($e,ke,"[\\:]")+"+"),k(k(re+"|"+X($e,ke))+"*");var ot=k(re+"|"+X($e,ke,"[\\:\\@]"));return k(k(re+"|"+X($e,ke,"[\\@]"))+"+"),k(k(ot+"|"+X("[\\/\\?]",Ve))+"*"),{NOT_SCHEME:new RegExp(X("[^]",U,ee,"[\\+\\-\\.]"),"g"),NOT_USERINFO:new RegExp(X("[^\\%\\:]",$e,ke),"g"),NOT_HOST:new RegExp(X("[^\\%\\[\\]\\:]",$e,ke),"g"),NOT_PATH:new RegExp(X("[^\\%\\/\\:\\@]",$e,ke),"g"),NOT_PATH_NOSCHEME:new RegExp(X("[^\\%\\/\\@]",$e,ke),"g"),NOT_QUERY:new RegExp(X("[^\\%]",$e,ke,"[\\:\\@\\/\\?]",Ve),"g"),NOT_FRAGMENT:new RegExp(X("[^\\%]",$e,ke,"[\\:\\@\\/\\?]"),"g"),ESCAPE:new RegExp(X("[^]",$e,ke),"g"),UNRESERVED:new RegExp($e,"g"),OTHER_CHARS:new RegExp(X("[^\\%]",$e,Be),"g"),PCT_ENCODED:new RegExp(re,"g"),IPV4ADDRESS:new RegExp("^("+Ze+")$"),IPV6ADDRESS:new RegExp("^\\[?("+it+")"+k(k("\\%25|\\%(?!"+se+"{2})")+"("+qe+")")+"?\\]?$")}}var L=M(!1),C=M(!0),m=function(){function q(U,ee){var se=[],re=!0,Se=!1,ke=void 0;try{for(var Be=U[Symbol.iterator](),Pe;!(re=(Pe=Be.next()).done)&&(se.push(Pe.value),!(ee&&se.length===ee));re=!0);}catch(Ve){Se=!0,ke=Ve}finally{try{!re&&Be.return&&Be.return()}finally{if(Se)throw ke}}return se}return function(U,ee){if(Array.isArray(U))return U;if(Symbol.iterator in Object(U))return q(U,ee);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),A=function(q){if(Array.isArray(q)){for(var U=0,ee=Array(q.length);U<q.length;U++)ee[U]=q[U];return ee}else return Array.from(q)},x=2147483647,p=36,a=1,l=26,n=38,i=700,t=72,e=128,r="-",s=/^xn--/,o=/[^\0-\x7E]/,c=/[\x2E\u3002\uFF0E\uFF61]/g,d={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},b=p-a,I=Math.floor,h=String.fromCharCode;function u(q){throw new RangeError(d[q])}function y(q,U){for(var ee=[],se=q.length;se--;)ee[se]=U(q[se]);return ee}function w(q,U){var ee=q.split("@"),se="";ee.length>1&&(se=ee[0]+"@",q=ee[1]),q=q.replace(c,".");var re=q.split("."),Se=y(re,U).join(".");return se+Se}function v(q){for(var U=[],ee=0,se=q.length;ee<se;){var re=q.charCodeAt(ee++);if(re>=55296&&re<=56319&&ee<se){var Se=q.charCodeAt(ee++);(Se&64512)==56320?U.push(((re&1023)<<10)+(Se&1023)+65536):(U.push(re),ee--)}else U.push(re)}return U}var T=function(U){return U-48<10?U-22:U-65<26?U-65:U-97<26?U-97:p},B=function(U,ee){return U+22+75*(U<26)-((ee!=0)<<5)},E=function(U,ee,se){var re=0;for(U=se?I(U/i):U>>1,U+=I(U/ee);U>b*l>>1;re+=p)U=I(U/b);return I(re+(b+1)*U/(U+n))},_=function(U){var ee=[],se=U.length,re=0,Se=e,ke=t,Be=U.lastIndexOf(r);Be<0&&(Be=0);for(var Pe=0;Pe<Be;++Pe)U.charCodeAt(Pe)>=128&&u("not-basic"),ee.push(U.charCodeAt(Pe));for(var Ve=Be>0?Be+1:0;Ve<se;){for(var $e=re,Ne=1,Ze=p;;Ze+=p){Ve>=se&&u("invalid-input");var _e=T(U.charCodeAt(Ve++));(_e>=p||_e>I((x-re)/Ne))&&u("overflow"),re+=_e*Ne;var Fe=Ze<=ke?a:Ze>=ke+l?l:Ze-ke;if(_e<Fe)break;var Oe=p-Fe;Ne>I(x/Oe)&&u("overflow"),Ne*=Oe}var Me=ee.length+1;ke=E(re-$e,Me,$e==0),I(re/Me)>x-Se&&u("overflow"),Se+=I(re/Me),re%=Me,ee.splice(re++,0,Se)}return String.fromCodePoint.apply(String,ee)},P=function(U){var ee=[];U=v(U);var se=U.length,re=e,Se=0,ke=t,Be=!0,Pe=!1,Ve=void 0;try{for(var $e=U[Symbol.iterator](),Ne;!(Be=(Ne=$e.next()).done);Be=!0){var Ze=Ne.value;Ze<128&&ee.push(h(Ze))}}catch(rt){Pe=!0,Ve=rt}finally{try{!Be&&$e.return&&$e.return()}finally{if(Pe)throw Ve}}var _e=ee.length,Fe=_e;for(_e&&ee.push(r);Fe<se;){var Oe=x,Me=!0,et=!1,Ye=void 0;try{for(var Je=U[Symbol.iterator](),nt;!(Me=(nt=Je.next()).done);Me=!0){var tt=nt.value;tt>=re&&tt<Oe&&(Oe=tt)}}catch(rt){et=!0,Ye=rt}finally{try{!Me&&Je.return&&Je.return()}finally{if(et)throw Ye}}var Xe=Fe+1;Oe-re>I((x-Se)/Xe)&&u("overflow"),Se+=(Oe-re)*Xe,re=Oe;var Ue=!0,it=!1,qe=void 0;try{for(var ot=U[Symbol.iterator](),ut;!(Ue=(ut=ot.next()).done);Ue=!0){var gt=ut.value;if(gt<re&&++Se>x&&u("overflow"),gt==re){for(var lt=Se,ct=p;;ct+=p){var ht=ct<=ke?a:ct>=ke+l?l:ct-ke;if(lt<ht)break;var pt=lt-ht,mt=p-ht;ee.push(h(B(ht+pt%mt,0))),lt=I(pt/mt)}ee.push(h(B(lt,0))),ke=E(Se,Xe,Fe==_e),Se=0,++Fe}}}catch(rt){it=!0,qe=rt}finally{try{!Ue&&ot.return&&ot.return()}finally{if(it)throw qe}}++Se,++re}return ee.join("")},H={version:"2.1.0",ucs2:{decode:v,encode:function(U){return String.fromCodePoint.apply(String,A(U))}},decode:_,encode:P,toASCII:function(U){return w(U,function(ee){return o.test(ee)?"xn--"+P(ee):ee})},toUnicode:function(U){return w(U,function(ee){return s.test(ee)?_(ee.slice(4).toLowerCase()):ee})}},z={};function K(q){var U=q.charCodeAt(0),ee=void 0;return U<16?ee="%0"+U.toString(16).toUpperCase():U<128?ee="%"+U.toString(16).toUpperCase():U<2048?ee="%"+(U>>6|192).toString(16).toUpperCase()+"%"+(U&63|128).toString(16).toUpperCase():ee="%"+(U>>12|224).toString(16).toUpperCase()+"%"+(U>>6&63|128).toString(16).toUpperCase()+"%"+(U&63|128).toString(16).toUpperCase(),ee}function Y(q){for(var U="",ee=0,se=q.length;ee<se;){var re=parseInt(q.substr(ee+1,2),16);if(re<128)U+=String.fromCharCode(re),ee+=3;else if(re>=194&&re<224){if(se-ee>=6){var Se=parseInt(q.substr(ee+4,2),16);U+=String.fromCharCode((re&31)<<6|Se&63)}else U+=q.substr(ee,6);ee+=6}else if(re>=224){if(se-ee>=9){var ke=parseInt(q.substr(ee+4,2),16),Be=parseInt(q.substr(ee+7,2),16);U+=String.fromCharCode((re&15)<<12|(ke&63)<<6|Be&63)}else U+=q.substr(ee,9);ee+=9}else U+=q.substr(ee,3),ee+=3}return U}function R(q,U){function ee(se){var re=Y(se);return re.match(U.UNRESERVED)?re:se}return q.scheme&&(q.scheme=String(q.scheme).replace(U.PCT_ENCODED,ee).toLowerCase().replace(U.NOT_SCHEME,"")),q.userinfo!==void 0&&(q.userinfo=String(q.userinfo).replace(U.PCT_ENCODED,ee).replace(U.NOT_USERINFO,K).replace(U.PCT_ENCODED,O)),q.host!==void 0&&(q.host=String(q.host).replace(U.PCT_ENCODED,ee).toLowerCase().replace(U.NOT_HOST,K).replace(U.PCT_ENCODED,O)),q.path!==void 0&&(q.path=String(q.path).replace(U.PCT_ENCODED,ee).replace(q.scheme?U.NOT_PATH:U.NOT_PATH_NOSCHEME,K).replace(U.PCT_ENCODED,O)),q.query!==void 0&&(q.query=String(q.query).replace(U.PCT_ENCODED,ee).replace(U.NOT_QUERY,K).replace(U.PCT_ENCODED,O)),q.fragment!==void 0&&(q.fragment=String(q.fragment).replace(U.PCT_ENCODED,ee).replace(U.NOT_FRAGMENT,K).replace(U.PCT_ENCODED,O)),q}function Z(q){return q.replace(/^0*(.*)/,"$1")||"0"}function W(q,U){var ee=q.match(U.IPV4ADDRESS)||[],se=m(ee,2),re=se[1];return re?re.split(".").map(Z).join("."):q}function f(q,U){var ee=q.match(U.IPV6ADDRESS)||[],se=m(ee,3),re=se[1],Se=se[2];if(re){for(var ke=re.toLowerCase().split("::").reverse(),Be=m(ke,2),Pe=Be[0],Ve=Be[1],$e=Ve?Ve.split(":").map(Z):[],Ne=Pe.split(":").map(Z),Ze=U.IPV4ADDRESS.test(Ne[Ne.length-1]),_e=Ze?7:8,Fe=Ne.length-_e,Oe=Array(_e),Me=0;Me<_e;++Me)Oe[Me]=$e[Me]||Ne[Fe+Me]||"";Ze&&(Oe[_e-1]=W(Oe[_e-1],U));var et=Oe.reduce(function(Xe,Ue,it){if(!Ue||Ue==="0"){var qe=Xe[Xe.length-1];qe&&qe.index+qe.length===it?qe.length++:Xe.push({index:it,length:1})}return Xe},[]),Ye=et.sort(function(Xe,Ue){return Ue.length-Xe.length})[0],Je=void 0;if(Ye&&Ye.length>1){var nt=Oe.slice(0,Ye.index),tt=Oe.slice(Ye.index+Ye.length);Je=nt.join(":")+"::"+tt.join(":")}else Je=Oe.join(":");return Se&&(Je+="%"+Se),Je}else return q}var S=/^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i,$="".match(/(){0}/)[1]===void 0;function F(q){var U=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},ee={},se=U.iri!==!1?C:L;U.reference==="suffix"&&(q=(U.scheme?U.scheme+":":"")+"//"+q);var re=q.match(S);if(re){$?(ee.scheme=re[1],ee.userinfo=re[3],ee.host=re[4],ee.port=parseInt(re[5],10),ee.path=re[6]||"",ee.query=re[7],ee.fragment=re[8],isNaN(ee.port)&&(ee.port=re[5])):(ee.scheme=re[1]||void 0,ee.userinfo=q.indexOf("@")!==-1?re[3]:void 0,ee.host=q.indexOf("//")!==-1?re[4]:void 0,ee.port=parseInt(re[5],10),ee.path=re[6]||"",ee.query=q.indexOf("?")!==-1?re[7]:void 0,ee.fragment=q.indexOf("#")!==-1?re[8]:void 0,isNaN(ee.port)&&(ee.port=q.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/)?re[4]:void 0)),ee.host&&(ee.host=f(W(ee.host,se),se)),ee.scheme===void 0&&ee.userinfo===void 0&&ee.host===void 0&&ee.port===void 0&&!ee.path&&ee.query===void 0?ee.reference="same-document":ee.scheme===void 0?ee.reference="relative":ee.fragment===void 0?ee.reference="absolute":ee.reference="uri",U.reference&&U.reference!=="suffix"&&U.reference!==ee.reference&&(ee.error=ee.error||"URI is not a "+U.reference+" reference.");var Se=z[(U.scheme||ee.scheme||"").toLowerCase()];if(!U.unicodeSupport&&(!Se||!Se.unicodeSupport)){if(ee.host&&(U.domainHost||Se&&Se.domainHost))try{ee.host=H.toASCII(ee.host.replace(se.PCT_ENCODED,Y).toLowerCase())}catch(ke){ee.error=ee.error||"Host's domain name can not be converted to ASCII via punycode: "+ke}R(ee,L)}else R(ee,se);Se&&Se.parse&&Se.parse(ee,U)}else ee.error=ee.error||"URI can not be parsed.";return ee}function j(q,U){var ee=U.iri!==!1?C:L,se=[];return q.userinfo!==void 0&&(se.push(q.userinfo),se.push("@")),q.host!==void 0&&se.push(f(W(String(q.host),ee),ee).replace(ee.IPV6ADDRESS,function(re,Se,ke){return"["+Se+(ke?"%25"+ke:"")+"]"})),(typeof q.port=="number"||typeof q.port=="string")&&(se.push(":"),se.push(String(q.port))),se.length?se.join(""):void 0}var Q=/^\.\.?\//,te=/^\/\.(\/|$)/,he=/^\/\.\.(\/|$)/,ve=/^\/?(?:.|\n)*?(?=\/|$)/;function ue(q){for(var U=[];q.length;)if(q.match(Q))q=q.replace(Q,"");else if(q.match(te))q=q.replace(te,"/");else if(q.match(he))q=q.replace(he,"/"),U.pop();else if(q==="."||q==="..")q="";else{var ee=q.match(ve);if(ee){var se=ee[0];q=q.slice(se.length),U.push(se)}else throw new Error("Unexpected dot segment condition")}return U.join("")}function fe(q){var U=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},ee=U.iri?C:L,se=[],re=z[(U.scheme||q.scheme||"").toLowerCase()];if(re&&re.serialize&&re.serialize(q,U),q.host&&!ee.IPV6ADDRESS.test(q.host)){if(U.domainHost||re&&re.domainHost)try{q.host=U.iri?H.toUnicode(q.host):H.toASCII(q.host.replace(ee.PCT_ENCODED,Y).toLowerCase())}catch(Be){q.error=q.error||"Host's domain name can not be converted to "+(U.iri?"Unicode":"ASCII")+" via punycode: "+Be}}R(q,ee),U.reference!=="suffix"&&q.scheme&&(se.push(q.scheme),se.push(":"));var Se=j(q,U);if(Se!==void 0&&(U.reference!=="suffix"&&se.push("//"),se.push(Se),q.path&&q.path.charAt(0)!=="/"&&se.push("/")),q.path!==void 0){var ke=q.path;!U.absolutePath&&(!re||!re.absolutePath)&&(ke=ue(ke)),Se===void 0&&(ke=ke.replace(/^\/\//,"/%2F")),se.push(ke)}return q.query!==void 0&&(se.push("?"),se.push(q.query)),q.fragment!==void 0&&(se.push("#"),se.push(q.fragment)),se.join("")}function Ce(q,U){var ee=arguments.length>2&&arguments[2]!==void 0?arguments[2]:{},se=arguments[3],re={};return se||(q=F(fe(q,ee),ee),U=F(fe(U,ee),ee)),ee=ee||{},!ee.tolerant&&U.scheme?(re.scheme=U.scheme,re.userinfo=U.userinfo,re.host=U.host,re.port=U.port,re.path=ue(U.path||""),re.query=U.query):(U.userinfo!==void 0||U.host!==void 0||U.port!==void 0?(re.userinfo=U.userinfo,re.host=U.host,re.port=U.port,re.path=ue(U.path||""),re.query=U.query):(U.path?(U.path.charAt(0)==="/"?re.path=ue(U.path):((q.userinfo!==void 0||q.host!==void 0||q.port!==void 0)&&!q.path?re.path="/"+U.path:q.path?re.path=q.path.slice(0,q.path.lastIndexOf("/")+1)+U.path:re.path=U.path,re.path=ue(re.path)),re.query=U.query):(re.path=q.path,U.query!==void 0?re.query=U.query:re.query=q.query),re.userinfo=q.userinfo,re.host=q.host,re.port=q.port),re.scheme=q.scheme),re.fragment=U.fragment,re}function Ae(q,U,ee){var se=N({scheme:"null"},ee);return fe(Ce(F(q,se),F(U,se),se,!0),se)}function Ee(q,U){return typeof q=="string"?q=fe(F(q,U),U):G(q)==="object"&&(q=F(fe(q,U),U)),q}function Re(q,U,ee){return typeof q=="string"?q=fe(F(q,ee),ee):G(q)==="object"&&(q=fe(q,ee)),typeof U=="string"?U=fe(F(U,ee),ee):G(U)==="object"&&(U=fe(U,ee)),q===U}function we(q,U){return q&&q.toString().replace(!U||!U.iri?L.ESCAPE:C.ESCAPE,K)}function de(q,U){return q&&q.toString().replace(!U||!U.iri?L.PCT_ENCODED:C.PCT_ENCODED,Y)}var Te={scheme:"http",domainHost:!0,parse:function(U,ee){return U.host||(U.error=U.error||"HTTP URIs must have a host."),U},serialize:function(U,ee){var se=String(U.scheme).toLowerCase()==="https";return(U.port===(se?443:80)||U.port==="")&&(U.port=void 0),U.path||(U.path="/"),U}},ae={scheme:"https",domainHost:Te.domainHost,parse:Te.parse,serialize:Te.serialize};function ge(q){return typeof q.secure=="boolean"?q.secure:String(q.scheme).toLowerCase()==="wss"}var le={scheme:"ws",domainHost:!0,parse:function(U,ee){var se=U;return se.secure=ge(se),se.resourceName=(se.path||"/")+(se.query?"?"+se.query:""),se.path=void 0,se.query=void 0,se},serialize:function(U,ee){if((U.port===(ge(U)?443:80)||U.port==="")&&(U.port=void 0),typeof U.secure=="boolean"&&(U.scheme=U.secure?"wss":"ws",U.secure=void 0),U.resourceName){var se=U.resourceName.split("?"),re=m(se,2),Se=re[0],ke=re[1];U.path=Se&&Se!=="/"?Se:void 0,U.query=ke,U.resourceName=void 0}return U.fragment=void 0,U}},ce={scheme:"wss",domainHost:le.domainHost,parse:le.parse,serialize:le.serialize},me={},Ie="[A-Za-z0-9\\-\\.\\_\\~\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]",xe="[0-9A-Fa-f]",Ge=k(k("%[EFef]"+xe+"%"+xe+xe+"%"+xe+xe)+"|"+k("%[89A-Fa-f]"+xe+"%"+xe+xe)+"|"+k("%"+xe+xe)),De="[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]",We=X("[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]",'[\\"\\\\]'),je="[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]",at=new RegExp(Ie,"g"),J=new RegExp(Ge,"g"),ne=new RegExp(X("[^]",De,"[\\.]",'[\\"]',We),"g"),oe=new RegExp(X("[^]",Ie,je),"g"),pe=oe;function ye(q){var U=Y(q);return U.match(at)?U:q}var be={scheme:"mailto",parse:function(U,ee){var se=U,re=se.to=se.path?se.path.split(","):[];if(se.path=void 0,se.query){for(var Se=!1,ke={},Be=se.query.split("&"),Pe=0,Ve=Be.length;Pe<Ve;++Pe){var $e=Be[Pe].split("=");switch($e[0]){case"to":for(var Ne=$e[1].split(","),Ze=0,_e=Ne.length;Ze<_e;++Ze)re.push(Ne[Ze]);break;case"subject":se.subject=de($e[1],ee);break;case"body":se.body=de($e[1],ee);break;default:Se=!0,ke[de($e[0],ee)]=de($e[1],ee);break}}Se&&(se.headers=ke)}se.query=void 0;for(var Fe=0,Oe=re.length;Fe<Oe;++Fe){var Me=re[Fe].split("@");if(Me[0]=de(Me[0]),ee.unicodeSupport)Me[1]=de(Me[1],ee).toLowerCase();else try{Me[1]=H.toASCII(de(Me[1],ee).toLowerCase())}catch(et){se.error=se.error||"Email address's domain name can not be converted to ASCII via punycode: "+et}re[Fe]=Me.join("@")}return se},serialize:function(U,ee){var se=U,re=D(U.to);if(re){for(var Se=0,ke=re.length;Se<ke;++Se){var Be=String(re[Se]),Pe=Be.lastIndexOf("@"),Ve=Be.slice(0,Pe).replace(J,ye).replace(J,O).replace(ne,K),$e=Be.slice(Pe+1);try{$e=ee.iri?H.toUnicode($e):H.toASCII(de($e,ee).toLowerCase())}catch(Fe){se.error=se.error||"Email address's domain name can not be converted to "+(ee.iri?"Unicode":"ASCII")+" via punycode: "+Fe}re[Se]=Ve+"@"+$e}se.path=re.join(",")}var Ne=U.headers=U.headers||{};U.subject&&(Ne.subject=U.subject),U.body&&(Ne.body=U.body);var Ze=[];for(var _e in Ne)Ne[_e]!==me[_e]&&Ze.push(_e.replace(J,ye).replace(J,O).replace(oe,K)+"="+Ne[_e].replace(J,ye).replace(J,O).replace(pe,K));return Ze.length&&(se.query=Ze.join("&")),se}},Le=/^([^\:]+)\:(.*)/,He={scheme:"urn",parse:function(U,ee){var se=U.path&&U.path.match(Le),re=U;if(se){var Se=ee.scheme||re.scheme||"urn",ke=se[1].toLowerCase(),Be=se[2],Pe=Se+":"+(ee.nid||ke),Ve=z[Pe];re.nid=ke,re.nss=Be,re.path=void 0,Ve&&(re=Ve.parse(re,ee))}else re.error=re.error||"URN can not be parsed.";return re},serialize:function(U,ee){var se=ee.scheme||U.scheme||"urn",re=U.nid,Se=se+":"+(ee.nid||re),ke=z[Se];ke&&(U=ke.serialize(U,ee));var Be=U,Pe=U.nss;return Be.path=(re||ee.nid)+":"+Pe,Be}},Ke=/^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/,Qe={scheme:"urn:uuid",parse:function(U,ee){var se=U;return se.uuid=se.nss,se.nss=void 0,!ee.tolerant&&(!se.uuid||!se.uuid.match(Ke))&&(se.error=se.error||"UUID is not valid."),se},serialize:function(U,ee){var se=U;return se.nss=(U.uuid||"").toLowerCase(),se}};z[Te.scheme]=Te,z[ae.scheme]=ae,z[le.scheme]=le,z[ce.scheme]=ce,z[be.scheme]=be,z[He.scheme]=He,z[Qe.scheme]=Qe,V.SCHEMES=z,V.pctEncChar=K,V.pctDecChars=Y,V.parse=F,V.removeDotSegments=ue,V.serialize=fe,V.resolveComponents=Ce,V.resolve=Ae,V.normalize=Ee,V.equal=Re,V.escapeComponent=we,V.unescapeComponent=de,Object.defineProperty(V,"__esModule",{value:!0})})(g)},4049:function(ie){ie.exports=function(){var g=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")},V=function(){function t(e,r){for(var s=0;s<r.length;s++){var o=r[s];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}return function(e,r,s){return r&&t(e.prototype,r),s&&t(e,s),e}}(),X=function(){function t(e,r){var s=[],o=!0,c=!1,d=void 0;try{for(var b=e[Symbol.iterator](),I;!(o=(I=b.next()).done)&&(s.push(I.value),!(r&&s.length===r));o=!0);}catch(h){c=!0,d=h}finally{try{!o&&b.return&&b.return()}finally{if(c)throw d}}return s}return function(e,r){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e))return t(e,r);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),k=(String.prototype.startsWith=String.prototype.startsWith||function(t){return this.indexOf(t)===0},String.prototype.padStart=String.prototype.padStart||function(t,e){for(var r=this;r.length<t;)r=e+r;return r},{cb:"0f8ff",tqw:"aebd7",q:"-ffff",qmrn:"7fffd4",zr:"0ffff",bg:"5f5dc",bsq:"e4c4",bck:"---",nch:"ebcd",b:"--ff",bvt:"8a2be2",brwn:"a52a2a",brw:"deb887",ctb:"5f9ea0",hrt:"7fff-",chcT:"d2691e",cr:"7f50",rnw:"6495ed",crns:"8dc",crms:"dc143c",cn:"-ffff",Db:"--8b",Dcn:"-8b8b",Dgnr:"b8860b",Dgr:"a9a9a9",Dgrn:"-64-",Dkhk:"bdb76b",Dmgn:"8b-8b",Dvgr:"556b2f",Drng:"8c-",Drch:"9932cc",Dr:"8b--",Dsmn:"e9967a",Dsgr:"8fbc8f",DsTb:"483d8b",DsTg:"2f4f4f",Dtrq:"-ced1",Dvt:"94-d3",ppnk:"1493",pskb:"-bfff",mgr:"696969",grb:"1e90ff",rbrc:"b22222",rwht:"af0",stg:"228b22",chs:"-ff",gnsb:"dcdcdc",st:"8f8ff",g:"d7-",gnr:"daa520",gr:"808080",grn:"-8-0",grnw:"adff2f",hnw:"0fff0",htpn:"69b4",nnr:"cd5c5c",ng:"4b-82",vr:"0",khk:"0e68c",vnr:"e6e6fa",nrb:"0f5",wngr:"7cfc-",mnch:"acd",Lb:"add8e6",Lcr:"08080",Lcn:"e0ffff",Lgnr:"afad2",Lgr:"d3d3d3",Lgrn:"90ee90",Lpnk:"b6c1",Lsmn:"a07a",Lsgr:"20b2aa",Lskb:"87cefa",LsTg:"778899",Lstb:"b0c4de",Lw:"e0",m:"-ff-",mgrn:"32cd32",nn:"af0e6",mgnt:"-ff",mrn:"8--0",mqm:"66cdaa",mmb:"--cd",mmrc:"ba55d3",mmpr:"9370db",msg:"3cb371",mmsT:"7b68ee","":"-fa9a",mtr:"48d1cc",mmvt:"c71585",mnLb:"191970",ntc:"5fffa",mstr:"e4e1",mccs:"e4b5",vjw:"dead",nv:"--80",c:"df5e6",v:"808-0",vrb:"6b8e23",rng:"a5-",rngr:"45-",rch:"da70d6",pgnr:"eee8aa",pgrn:"98fb98",ptrq:"afeeee",pvtr:"db7093",ppwh:"efd5",pchp:"dab9",pr:"cd853f",pnk:"c0cb",pm:"dda0dd",pwrb:"b0e0e6",prp:"8-080",cc:"663399",r:"--",sbr:"bc8f8f",rb:"4169e1",sbrw:"8b4513",smn:"a8072",nbr:"4a460",sgrn:"2e8b57",ssh:"5ee",snn:"a0522d",svr:"c0c0c0",skb:"87ceeb",sTb:"6a5acd",sTgr:"708090",snw:"afa",n:"-ff7f",stb:"4682b4",tn:"d2b48c",t:"-8080",thst:"d8bfd8",tmT:"6347",trqs:"40e0d0",vt:"ee82ee",whT:"5deb3",wht:"",hts:"5f5f5",w:"-",wgrn:"9acd32"});function G(t){var e=arguments.length>1&&arguments[1]!==void 0?arguments[1]:1,r=e>0?t.toFixed(e).replace(/0+$/,"").replace(/\.$/,""):t.toString();return r||"0"}var O=function(){function t(e,r,s,o){g(this,t);var c=this;function d(I){if(I.startsWith("hsl")){var h=I.match(/([\-\d\.e]+)/g).map(Number),u=X(h,4),y=u[0],w=u[1],v=u[2],T=u[3];T===void 0&&(T=1),y/=360,w/=100,v/=100,c.hsla=[y,w,v,T]}else if(I.startsWith("rgb")){var B=I.match(/([\-\d\.e]+)/g).map(Number),E=X(B,4),_=E[0],P=E[1],H=E[2],z=E[3];z===void 0&&(z=1),c.rgba=[_,P,H,z]}else I.startsWith("#")?c.rgba=t.hexToRgb(I):c.rgba=t.nameToRgb(I)||t.hexToRgb(I)}if(e!==void 0)if(Array.isArray(e))this.rgba=e;else if(s===void 0){var b=e&&""+e;b&&d(b.toLowerCase())}else this.rgba=[e,r,s,o===void 0?1:o]}return V(t,[{key:"printRGB",value:function(r){var s=r?this.rgba:this.rgba.slice(0,3),o=s.map(function(c,d){return G(c,d===3?3:0)});return r?"rgba("+o+")":"rgb("+o+")"}},{key:"printHSL",value:function(r){var s=[360,100,100,1],o=["","%","%",""],c=r?this.hsla:this.hsla.slice(0,3),d=c.map(function(b,I){return G(b*s[I],I===3?3:1)+o[I]});return r?"hsla("+d+")":"hsl("+d+")"}},{key:"printHex",value:function(r){var s=this.hex;return r?s:s.substring(0,7)}},{key:"rgba",get:function(){if(this._rgba)return this._rgba;if(!this._hsla)throw new Error("No color is set");return this._rgba=t.hslToRgb(this._hsla)},set:function(r){r.length===3&&(r[3]=1),this._rgba=r,this._hsla=null}},{key:"rgbString",get:function(){return this.printRGB()}},{key:"rgbaString",get:function(){return this.printRGB(!0)}},{key:"hsla",get:function(){if(this._hsla)return this._hsla;if(!this._rgba)throw new Error("No color is set");return this._hsla=t.rgbToHsl(this._rgba)},set:function(r){r.length===3&&(r[3]=1),this._hsla=r,this._rgba=null}},{key:"hslString",get:function(){return this.printHSL()}},{key:"hslaString",get:function(){return this.printHSL(!0)}},{key:"hex",get:function(){var r=this.rgba,s=r.map(function(o,c){return c<3?o.toString(16):Math.round(o*255).toString(16)});return"#"+s.map(function(o){return o.padStart(2,"0")}).join("")},set:function(r){this.rgba=t.hexToRgb(r)}}],[{key:"hexToRgb",value:function(r){var s=(r.startsWith("#")?r.slice(1):r).replace(/^(\w{3})$/,"$1F").replace(/^(\w)(\w)(\w)(\w)$/,"$1$1$2$2$3$3$4$4").replace(/^(\w{6})$/,"$1FF");if(!s.match(/^([0-9a-fA-F]{8})$/))throw new Error("Unknown hex color; "+r);var o=s.match(/^(\w\w)(\w\w)(\w\w)(\w\w)$/).slice(1).map(function(c){return parseInt(c,16)});return o[3]=o[3]/255,o}},{key:"nameToRgb",value:function(r){var s=r.toLowerCase().replace("at","T").replace(/[aeiouyldf]/g,"").replace("ght","L").replace("rk","D").slice(-5,4),o=k[s];return o===void 0?o:t.hexToRgb(o.replace(/\-/g,"00").padStart(6,"f"))}},{key:"rgbToHsl",value:function(r){var s=X(r,4),o=s[0],c=s[1],d=s[2],b=s[3];o/=255,c/=255,d/=255;var I=Math.max(o,c,d),h=Math.min(o,c,d),u=void 0,y=void 0,w=(I+h)/2;if(I===h)u=y=0;else{var v=I-h;switch(y=w>.5?v/(2-I-h):v/(I+h),I){case o:u=(c-d)/v+(c<d?6:0);break;case c:u=(d-o)/v+2;break;case d:u=(o-c)/v+4;break}u/=6}return[u,y,w,b]}},{key:"hslToRgb",value:function(r){var s=X(r,4),o=s[0],c=s[1],d=s[2],b=s[3],I=void 0,h=void 0,u=void 0;if(c===0)I=h=u=d;else{var y=function(E,_,P){return P<0&&(P+=1),P>1&&(P-=1),P<.16666666666666666?E+(_-E)*6*P:P<.5?_:P<.6666666666666666?E+(_-E)*(.6666666666666666-P)*6:E},w=d<.5?d*(1+c):d+c-d*c,v=2*d-w;I=y(v,w,o+1/3),h=y(v,w,o),u=y(v,w,o-1/3)}var T=[I*255,h*255,u*255].map(Math.round);return T[3]=b,T}}]),t}(),D=function(){function t(){g(this,t),this._events=[]}return V(t,[{key:"add",value:function(r,s,o){r.addEventListener(s,o,!1),this._events.push({target:r,type:s,handler:o})}},{key:"remove",value:function(r,s,o){this._events=this._events.filter(function(c){var d=!0;return r&&r!==c.target&&(d=!1),s&&s!==c.type&&(d=!1),o&&o!==c.handler&&(d=!1),d&&t._doRemove(c.target,c.type,c.handler),!d})}},{key:"destroy",value:function(){this._events.forEach(function(r){return t._doRemove(r.target,r.type,r.handler)}),this._events=[]}}],[{key:"_doRemove",value:function(r,s,o){r.removeEventListener(s,o,!1)}}]),t}();function N(t){var e=document.createElement("div");return e.innerHTML=t,e.firstElementChild}function M(t,e,r){var s=!1;function o(I,h,u){return Math.max(h,Math.min(I,u))}function c(I,h,u){if(u&&(s=!0),!!s){I.preventDefault();var y=e.getBoundingClientRect(),w=y.width,v=y.height,T=h.clientX,B=h.clientY,E=o(T-y.left,0,w),_=o(B-y.top,0,v);r(E/w,_/v)}}function d(I,h){var u=I.buttons===void 0?I.which:I.buttons;u===1?c(I,I,h):s=!1}function b(I,h){I.touches.length===1?c(I,I.touches[0],h):s=!1}t.add(e,"mousedown",function(I){d(I,!0)}),t.add(e,"touchstart",function(I){b(I,!0)}),t.add(window,"mousemove",d),t.add(e,"touchmove",b),t.add(window,"mouseup",function(I){s=!1}),t.add(e,"touchend",function(I){s=!1}),t.add(e,"touchcancel",function(I){s=!1})}var L=`linear-gradient(45deg, lightgrey 25%, transparent 25%, transparent 75%, lightgrey 75%) 0 0 / 2em 2em,
                   linear-gradient(45deg, lightgrey 25%,       white 25%,       white 75%, lightgrey 75%) 1em 1em / 2em 2em`,C=360,m="keydown",A="mousedown",x="focusin";function p(t,e){return(e||document).querySelector(t)}function a(t){t.preventDefault(),t.stopPropagation()}function l(t,e,r,s,o){t.add(e,m,function(c){r.indexOf(c.key)>=0&&(o&&a(c),s(c))})}var n=function(){function t(e){g(this,t),this.settings={popup:"right",layout:"default",alpha:!0,editor:!0,editorFormat:"hex",cancelButton:!1,defaultColor:"#0cf"},this._events=new D,this.onChange=null,this.onDone=null,this.onOpen=null,this.onClose=null,this.setOptions(e)}return V(t,[{key:"setOptions",value:function(r){var s=this;if(!r)return;var o=this.settings;function c(h,u,y){for(var w in h)y&&y.indexOf(w)>=0||(u[w]=h[w])}if(r instanceof HTMLElement)o.parent=r;else{o.parent&&r.parent&&o.parent!==r.parent&&(this._events.remove(o.parent),this._popupInited=!1),c(r,o),r.onChange&&(this.onChange=r.onChange),r.onDone&&(this.onDone=r.onDone),r.onOpen&&(this.onOpen=r.onOpen),r.onClose&&(this.onClose=r.onClose);var d=r.color||r.colour;d&&this._setColor(d)}var b=o.parent;if(b&&o.popup&&!this._popupInited){var I=function(u){return s.openHandler(u)};this._events.add(b,"click",I),l(this._events,b,[" ","Spacebar","Enter"],I),this._popupInited=!0}else r.parent&&!o.popup&&this.show()}},{key:"openHandler",value:function(r){if(this.show()){r&&r.preventDefault(),this.settings.parent.style.pointerEvents="none";var s=r&&r.type===m?this._domEdit:this.domElement;setTimeout(function(){return s.focus()},100),this.onOpen&&this.onOpen(this.colour)}}},{key:"closeHandler",value:function(r){var s=r&&r.type,o=!1;if(!r)o=!0;else if(s===A||s===x){var c=(this.__containedEvent||0)+100;r.timeStamp>c&&(o=!0)}else a(r),o=!0;o&&this.hide()&&(this.settings.parent.style.pointerEvents="",s!==A&&this.settings.parent.focus(),this.onClose&&this.onClose(this.colour))}},{key:"movePopup",value:function(r,s){this.closeHandler(),this.setOptions(r),s&&this.openHandler()}},{key:"setColor",value:function(r,s){this._setColor(r,{silent:s})}},{key:"_setColor",value:function(r,s){if(typeof r=="string"&&(r=r.trim()),!!r){s=s||{};var o=void 0;try{o=new O(r)}catch(d){if(s.failSilently)return;throw d}if(!this.settings.alpha){var c=o.hsla;c[3]=1,o.hsla=c}this.colour=this.color=o,this._setHSLA(null,null,null,null,s)}}},{key:"setColour",value:function(r,s){this.setColor(r,s)}},{key:"show",value:function(){var r=this.settings.parent;if(!r)return!1;if(this.domElement){var s=this._toggleDOM(!0);return this._setPosition(),s}var o=this.settings.template||'<div class="picker_wrapper" tabindex="-1"><div class="picker_arrow"></div><div class="picker_hue picker_slider"><div class="picker_selector"></div></div><div class="picker_sl"><div class="picker_selector"></div></div><div class="picker_alpha picker_slider"><div class="picker_selector"></div></div><div class="picker_editor"><input aria-label="Type a color name or hex value"/></div><div class="picker_sample"></div><div class="picker_done"><button>Ok</button></div><div class="picker_cancel"><button>Cancel</button></div></div>',c=N(o);return this.domElement=c,this._domH=p(".picker_hue",c),this._domSL=p(".picker_sl",c),this._domA=p(".picker_alpha",c),this._domEdit=p(".picker_editor input",c),this._domSample=p(".picker_sample",c),this._domOkay=p(".picker_done button",c),this._domCancel=p(".picker_cancel button",c),c.classList.add("layout_"+this.settings.layout),this.settings.alpha||c.classList.add("no_alpha"),this.settings.editor||c.classList.add("no_editor"),this.settings.cancelButton||c.classList.add("no_cancel"),this._ifPopup(function(){return c.classList.add("popup")}),this._setPosition(),this.colour?this._updateUI():this._setColor(this.settings.defaultColor),this._bindEvents(),!0}},{key:"hide",value:function(){return this._toggleDOM(!1)}},{key:"destroy",value:function(){this._events.destroy(),this.domElement&&this.settings.parent.removeChild(this.domElement)}},{key:"_bindEvents",value:function(){var r=this,s=this,o=this.domElement,c=this._events;function d(h,u,y){c.add(h,u,y)}d(o,"click",function(h){return h.preventDefault()}),M(c,this._domH,function(h,u){return s._setHSLA(h)}),M(c,this._domSL,function(h,u){return s._setHSLA(null,h,1-u)}),this.settings.alpha&&M(c,this._domA,function(h,u){return s._setHSLA(null,null,null,1-u)});var b=this._domEdit;d(b,"input",function(h){s._setColor(this.value,{fromEditor:!0,failSilently:!0})}),d(b,"focus",function(h){var u=this;u.selectionStart===u.selectionEnd&&u.select()}),this._ifPopup(function(){var h=function(w){return r.closeHandler(w)};d(window,A,h),d(window,x,h),l(c,o,["Esc","Escape"],h);var u=function(w){r.__containedEvent=w.timeStamp};d(o,A,u),d(o,x,u),d(r._domCancel,"click",h)});var I=function(u){r._ifPopup(function(){return r.closeHandler(u)}),r.onDone&&r.onDone(r.colour)};d(this._domOkay,"click",I),l(c,o,["Enter"],I)}},{key:"_setPosition",value:function(){var r=this.settings.parent,s=this.domElement;r!==s.parentNode&&r.appendChild(s),this._ifPopup(function(o){getComputedStyle(r).position==="static"&&(r.style.position="relative");var c=o===!0?"popup_right":"popup_"+o;["popup_top","popup_bottom","popup_left","popup_right"].forEach(function(d){d===c?s.classList.add(d):s.classList.remove(d)}),s.classList.add(c)})}},{key:"_setHSLA",value:function(r,s,o,c,d){d=d||{};var b=this.colour,I=b.hsla;[r,s,o,c].forEach(function(h,u){(h||h===0)&&(I[u]=h)}),b.hsla=I,this._updateUI(d),this.onChange&&!d.silent&&this.onChange(b)}},{key:"_updateUI",value:function(r){if(!this.domElement)return;r=r||{};var s=this.colour,o=s.hsla,c="hsl("+o[0]*C+", 100%, 50%)",d=s.hslString,b=s.hslaString,I=this._domH,h=this._domSL,u=this._domA,y=p(".picker_selector",I),w=p(".picker_selector",h),v=p(".picker_selector",u);function T(Y,R,Z){R.style.left=Z*100+"%"}function B(Y,R,Z){R.style.top=Z*100+"%"}T(I,y,o[0]),this._domSL.style.backgroundColor=this._domH.style.color=c,T(h,w,o[1]),B(h,w,1-o[2]),h.style.color=d,B(u,v,1-o[3]);var E=d,_=E.replace("hsl","hsla").replace(")",", 0)"),P="linear-gradient("+[E,_]+")";if(this._domA.style.background=P+", "+L,!r.fromEditor){var H=this.settings.editorFormat,z=this.settings.alpha,K=void 0;switch(H){case"rgb":K=s.printRGB(z);break;case"hsl":K=s.printHSL(z);break;default:K=s.printHex(z)}this._domEdit.value=K}this._domSample.style.color=b}},{key:"_ifPopup",value:function(r,s){this.settings.parent&&this.settings.popup?r&&r(this.settings.popup):s&&s()}},{key:"_toggleDOM",value:function(r){var s=this.domElement;if(!s)return!1;var o=r?"":"none",c=s.style.display!==o;return c&&(s.style.display=o),c}}]),t}(),i=document.createElement("style");return i.textContent='.picker_wrapper.no_alpha .picker_alpha{display:none}.picker_wrapper.no_editor .picker_editor{position:absolute;z-index:-1;opacity:0}.picker_wrapper.no_cancel .picker_cancel{display:none}.layout_default.picker_wrapper{display:flex;flex-flow:row wrap;justify-content:space-between;align-items:stretch;font-size:10px;width:25em;padding:.5em}.layout_default.picker_wrapper input,.layout_default.picker_wrapper button{font-size:1rem}.layout_default.picker_wrapper>*{margin:.5em}.layout_default.picker_wrapper::before{content:"";display:block;width:100%;height:0;order:1}.layout_default .picker_slider,.layout_default .picker_selector{padding:1em}.layout_default .picker_hue{width:100%}.layout_default .picker_sl{flex:1 1 auto}.layout_default .picker_sl::before{content:"";display:block;padding-bottom:100%}.layout_default .picker_editor{order:1;width:6.5rem}.layout_default .picker_editor input{width:100%;height:100%}.layout_default .picker_sample{order:1;flex:1 1 auto}.layout_default .picker_done,.layout_default .picker_cancel{order:1}.picker_wrapper{box-sizing:border-box;background:#f2f2f2;box-shadow:0 0 0 1px silver;cursor:default;font-family:sans-serif;color:#444;pointer-events:auto}.picker_wrapper:focus{outline:none}.picker_wrapper button,.picker_wrapper input{box-sizing:border-box;border:none;box-shadow:0 0 0 1px silver;outline:none}.picker_wrapper button:focus,.picker_wrapper button:active,.picker_wrapper input:focus,.picker_wrapper input:active{box-shadow:0 0 2px 1px #1e90ff}.picker_wrapper button{padding:.4em .6em;cursor:pointer;background-color:#f5f5f5;background-image:linear-gradient(0deg, gainsboro, transparent)}.picker_wrapper button:active{background-image:linear-gradient(0deg, transparent, gainsboro)}.picker_wrapper button:hover{background-color:#fff}.picker_selector{position:absolute;z-index:1;display:block;-webkit-transform:translate(-50%, -50%);transform:translate(-50%, -50%);border:2px solid #fff;border-radius:100%;box-shadow:0 0 3px 1px #67b9ff;background:currentColor;cursor:pointer}.picker_slider .picker_selector{border-radius:2px}.picker_hue{position:relative;background-image:linear-gradient(90deg, red, yellow, lime, cyan, blue, magenta, red);box-shadow:0 0 0 1px silver}.picker_sl{position:relative;box-shadow:0 0 0 1px silver;background-image:linear-gradient(180deg, white, rgba(255, 255, 255, 0) 50%),linear-gradient(0deg, black, rgba(0, 0, 0, 0) 50%),linear-gradient(90deg, #808080, rgba(128, 128, 128, 0))}.picker_alpha,.picker_sample{position:relative;background:linear-gradient(45deg, lightgrey 25%, transparent 25%, transparent 75%, lightgrey 75%) 0 0/2em 2em,linear-gradient(45deg, lightgrey 25%, white 25%, white 75%, lightgrey 75%) 1em 1em/2em 2em;box-shadow:0 0 0 1px silver}.picker_alpha .picker_selector,.picker_sample .picker_selector{background:none}.picker_editor input{font-family:monospace;padding:.2em .4em}.picker_sample::before{content:"";position:absolute;display:block;width:100%;height:100%;background:currentColor}.picker_arrow{position:absolute;z-index:-1}.picker_wrapper.popup{position:absolute;z-index:2;margin:1.5em}.picker_wrapper.popup,.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{background:#f2f2f2;box-shadow:0 0 10px 1px rgba(0,0,0,.4)}.picker_wrapper.popup .picker_arrow{width:3em;height:3em;margin:0}.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{content:"";display:block;position:absolute;top:0;left:0;z-index:-99}.picker_wrapper.popup .picker_arrow::before{width:100%;height:100%;-webkit-transform:skew(45deg);transform:skew(45deg);-webkit-transform-origin:0 100%;transform-origin:0 100%}.picker_wrapper.popup .picker_arrow::after{width:150%;height:150%;box-shadow:none}.popup.popup_top{bottom:100%;left:0}.popup.popup_top .picker_arrow{bottom:0;left:0;-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.popup.popup_bottom{top:100%;left:0}.popup.popup_bottom .picker_arrow{top:0;left:0;-webkit-transform:rotate(90deg) scale(1, -1);transform:rotate(90deg) scale(1, -1)}.popup.popup_left{top:0;right:100%}.popup.popup_left .picker_arrow{top:0;right:0;-webkit-transform:scale(-1, 1);transform:scale(-1, 1)}.popup.popup_right{top:0;left:100%}.popup.popup_right .picker_arrow{top:0;left:0}',document.documentElement.firstElementChild.appendChild(i),n.StyleElement=i,n}()},402:function(ie,g){function V(X,k){if(!(this instanceof V))throw new SyntaxError("Constructor must be called with the new operator");this.message=X+" (char "+k+")",this.char=k,this.stack=new Error().stack}Object.defineProperty(g,"__esModule",{value:!0}),((g.default=V).prototype=new Error).constructor=Error},3860:function(ie,g,V){ie.exports=V(7490).default},7490:function(ie,g,V){g.default=function(u){n="",i=0,t=(l=u).charAt(0),e="",r=C,d();var y=r;if(h(),b(),e==="")return n;if(y===r&&c()){for(var w="";y===r&&c();)n=(0,k.insertBeforeLastWhitespace)(n,","),w+=n,n="",h(),b();return`[
`.concat(w).concat(n,`
]`)}throw new X.default("Unexpected characters",i-e.length)};var X=(g=V(402))&&g.__esModule?g:{default:g},k=V(9422),G=0,O=1,D=2,N=3,M=4,L=5,C=6,m={"":!0,"{":!0,"}":!0,"[":!0,"]":!0,":":!0,",":!0,"(":!0,")":!0,";":!0,"+":!0},A={'"':'"',"\\":"\\","/":"/",b:"\b",f:"\f",n:`
`,r:"\r",t:"	"},x={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","	":"\\t"},p={null:"null",true:"true",false:"false"},a={None:"null",True:"true",False:"false"},l="",n="",i=0,t="",e="",r=C;function s(){i++,t=l.charAt(i)}function o(){s(),t==="\\"&&s()}function c(){return r===G&&(e==="["||e==="{")||r===D||r===O||r===N}function d(){if(n+=e,r=C,e="",m[t])r=G,e=t,s();else if((0,k.isDigit)(t)||t==="-"){if(r=O,t==="-"){if(e+=t,s(),!(0,k.isDigit)(t))throw new X.default("Invalid number, digit expected",i)}else t==="0"&&(e+=t,s());for(;(0,k.isDigit)(t);)e+=t,s();if(t==="."){if(e+=t,s(),!(0,k.isDigit)(t))throw new X.default("Invalid number, digit expected",i);for(;(0,k.isDigit)(t);)e+=t,s()}if(t==="e"||t==="E"){if(e+=t,s(),t!=="+"&&t!=="-"||(e+=t,s()),!(0,k.isDigit)(t))throw new X.default("Invalid number, digit expected",i);for(;(0,k.isDigit)(t);)e+=t,s()}}else t==="\\"&&l.charAt(i+1)==='"'?(s(),I(o)):I(s);r===M&&(e=(0,k.normalizeWhitespace)(e),d()),r===L&&(r=C,e="",d())}function b(){e===","&&(e="",r=C,d())}function I(u){if((0,k.isQuote)(t)){var y=(0,k.normalizeQuote)(t),w=(0,k.isSingleQuote)(t)?k.isSingleQuote:k.isDoubleQuote;for(e+='"',r=D,u();t!==""&&!w(t);)if(t==="\\")if(u(),A[t]!==void 0)e+="\\"+t,u();else if(t==="u"){e+="\\u",u();for(var v=0;v<4;v++){if(!(0,k.isHex)(t))throw new X.default("Invalid unicode character",i-e.length);e+=t,u()}}else{if(t!=="'")throw new X.default('Invalid escape character "\\'+t+'"',i);e+="'",u()}else x[t]?e+=x[t]:e+=t==='"'?'\\"':t,u();if((0,k.normalizeQuote)(t)!==y)throw new X.default("End of string expected",i-e.length);e+='"',u()}else if((0,k.isAlpha)(t))for(r=N;(0,k.isAlpha)(t)||(0,k.isDigit)(t)||t==="$";)e+=t,s();else if((0,k.isWhitespace)(t)||(0,k.isSpecialWhitespace)(t))for(r=M;(0,k.isWhitespace)(t)||(0,k.isSpecialWhitespace)(t);)e+=t,s();else if(t==="/"&&l[i+1]==="*"){for(r=L;t!==""&&(t!=="*"||t==="*"&&l[i+1]!=="/");)e+=t,s();t==="*"&&l[i+1]==="/"&&(e+=t,s(),e+=t,s())}else if(t==="/"&&l[i+1]==="/")for(r=L;t!==""&&t!==`
`;)e+=t,s();else{for(r=C;t!=="";)e+=t,s();throw new X.default('Syntax error in part "'+e+'"',i-e.length)}}function h(){if(r===G&&e==="{")if(d(),r===G&&e==="}")d();else{for(;;){if(r!==N&&r!==O||(r=D,e='"'.concat(e,'"')),r!==D)throw new X.default("Object key expected",i-e.length);if(d(),r===G&&e===":")d();else{if(!c())throw new X.default("Colon expected",i-e.length);n=(0,k.insertBeforeLastWhitespace)(n,":")}if(h(),r===G&&e===","){if(d(),r===G&&e==="}"){n=(0,k.stripLastOccurrence)(n,",");break}if(e===""){n=(0,k.stripLastOccurrence)(n,",");break}}else{if(r!==D&&r!==O&&r!==N)break;n=(0,k.insertBeforeLastWhitespace)(n,",")}}r===G&&e==="}"?d():n=(0,k.insertBeforeLastWhitespace)(n,"}")}else if(r===G&&e==="[")if(d(),r===G&&e==="]")d();else{for(;;)if(h(),r===G&&e===","){if(d(),r===G&&e==="]"){n=(0,k.stripLastOccurrence)(n,",");break}if(e===""){n=(0,k.stripLastOccurrence)(n,",");break}}else{if(!c())break;n=(0,k.insertBeforeLastWhitespace)(n,",")}r===G&&e==="]"?d():n=(0,k.insertBeforeLastWhitespace)(n,"]")}else if(r===D)for(d();r===G&&e==="+";){var u;e="",d(),r===D&&(u=n.lastIndexOf('"'),n=n.substring(0,u)+e.substring(1),e="",d())}else if(r===O)d();else{if(r!==N)throw e===""?new X.default("Unexpected end of json string",i-e.length):new X.default("Value expected",i-e.length);if(p[e])d();else if(a[e])e=a[e],d();else{var y=e,w=n.length;if(e="",d(),r===G&&e==="(")e="",d(),h(),r===G&&e===")"&&(e="",d(),r===G&&e===";"&&(e="",d()));else{for(n=(0,k.insertAtIndex)(n,'"'.concat(y),w);r===N||r===O;)d();n+='"'}}}}},9422:function(ie,g){Object.defineProperty(g,"__esModule",{value:!0}),g.isAlpha=function(M){return k.test(M)},g.isHex=function(M){return G.test(M)},g.isDigit=function(M){return O.test(M)},g.isWhitespace=D,g.isSpecialWhitespace=N,g.normalizeWhitespace=function(M){for(var L="",C=0;C<M.length;C++){var m=M[C];L+=N(m)?" ":m}return L},g.isQuote=function(M){return V[M]===!0||X[M]===!0},g.isSingleQuote=function(M){return V[M]===!0},g.isDoubleQuote=function(M){return X[M]===!0},g.normalizeQuote=function(M){return V[M]!==!0?X[M]!==!0?M:'"':"'"},g.stripLastOccurrence=function(M,L){return L=M.lastIndexOf(L),L!==-1?M.substring(0,L)+M.substring(L+1):M},g.insertBeforeLastWhitespace=function(M,L){var C=M.length;if(!D(M[C-1]))return M+L;for(;D(M[C-1]);)C--;return M.substring(0,C)+L+M.substring(C)},g.insertAtIndex=function(M,L,C){return M.substring(0,C)+L+M.substring(C)};var V={"'":!0,"\u2018":!0,"\u2019":!0,"`":!0,"\xB4":!0},X={'"':!0,"\u201C":!0,"\u201D":!0},k=/^[a-zA-Z_]$/,G=/^[0-9a-fA-F]$/,O=/^[0-9]$/;function D(M){return M===" "||M==="	"||M===`
`||M==="\r"}function N(M){return M==="\xA0"||"\u2000"<=M&&M<="\u200A"||M==="\u202F"||M==="\u205F"||M==="\u3000"}},894:function(ie){ie.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#","description":"Meta-schema for $data reference (JSON Schema extension proposal)","type":"object","required":["$data"],"properties":{"$data":{"type":"string","anyOf":[{"format":"relative-json-pointer"},{"format":"json-pointer"}]}},"additionalProperties":false}')},7171:function(ie){ie.exports=JSON.parse('{"id":"http://json-schema.org/draft-04/schema#","$schema":"http://json-schema.org/draft-04/schema#","description":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"positiveInteger":{"type":"integer","minimum":0},"positiveIntegerDefault0":{"allOf":[{"$ref":"#/definitions/positiveInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"minItems":1,"uniqueItems":true}},"type":"object","properties":{"id":{"type":"string"},"$schema":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"multipleOf":{"type":"number","minimum":0,"exclusiveMinimum":true},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"boolean","default":false},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"boolean","default":false},"maxLength":{"$ref":"#/definitions/positiveInteger"},"minLength":{"$ref":"#/definitions/positiveIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/positiveInteger"},"minItems":{"$ref":"#/definitions/positiveIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"maxProperties":{"$ref":"#/definitions/positiveInteger"},"minProperties":{"$ref":"#/definitions/positiveIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"dependencies":{"exclusiveMaximum":["maximum"],"exclusiveMinimum":["minimum"]},"default":{}}')},6273:function(ie){ie.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-06/schema#","$id":"http://json-schema.org/draft-06/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"examples":{"type":"array","items":{}},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":{},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":{}}')},6680:function(ie){ie.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"http://json-schema.org/draft-07/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"$comment":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":true,"readOnly":{"type":"boolean","default":false},"examples":{"type":"array","items":true},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":true},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"propertyNames":{"format":"regex"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":true,"enum":{"type":"array","items":true,"minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"contentMediaType":{"type":"string"},"contentEncoding":{"type":"string"},"if":{"$ref":"#"},"then":{"$ref":"#"},"else":{"$ref":"#"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":true}')}},dt={},ze.amdD=function(){throw new Error("define cannot be used indirect")},ze.n=function(ie){var g=ie&&ie.__esModule?function(){return ie.default}:function(){return ie};return ze.d(g,{a:g}),g},ze.d=function(ie,g){for(var V in g)ze.o(g,V)&&!ze.o(ie,V)&&Object.defineProperty(ie,V,{enumerable:!0,get:g[V]})},ze.o=function(ie,g){return Object.prototype.hasOwnProperty.call(ie,g)},ze.r=function(ie){typeof Symbol<"u"&&Symbol.toStringTag&&Object.defineProperty(ie,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(ie,"__esModule",{value:!0})},ze.nmd=function(ie){return ie.paths=[],ie.children||(ie.children=[]),ie},ze(3161);function ze(ie){var g=dt[ie];return g!==void 0||(g=dt[ie]={id:ie,loaded:!1,exports:{}},st[ie].call(g.exports,g,g.exports,ze),g.loaded=!0),g.exports}var st,dt})})(ft);const vt=It(ft.exports);window.JSONEditor=vt;
