<?php

namespace App\Tools;

use App\Models\Tool;
use Illuminate\Http\Request;
use App\Contracts\ToolInterface;
use App\Helpers\Classes\WordpressThemeEngine;

class WordPressThemeDetector implements ToolInterface
{
    public function render(Request $request, Tool $tool)
    {
        return view('tools.word-press-theme-detector', compact('tool'));
    }

    public function handle(Request $request, Tool $tool)
    {
        $validated = $request->validate([
            'url' => 'required|url',
        ]);

        $themeEngine = new WordpressThemeEngine($request->url);
        $themeEngine->fetch();
        $theme = $themeEngine->theme;
        $plugins = $themeEngine->plugins->toArray();

        if ($error = $themeEngine->lastError()) {
            return redirect()->back()->withError($error);
        }

        if (!$theme && !$plugins) {
            return redirect()->back()->withError(__('tools.noWPThemeDetected', ['url' => $themeEngine->url]));
        }

        $results = $themeEngine->results();

        return view('tools.word-press-theme-detector', compact('results', 'tool', 'theme', 'plugins'));
    }
}
