<?php

namespace App\Tools;

use App\Models\Tool;
use Illuminate\Http\Request;
use App\Components\ToolsManager;
use App\Contracts\ToolInterface;


class WhatIsMyIp implements ToolInterface
{
    public function render(Request $request, Tool $tool)
    {
        $ip = $request->ip();
        $driver = (new ToolsManager($tool))->driver();
        $results = $driver->parse($ip);
        $content = $results['content'] ?? false;

        return view('tools.what-is-my-ip', compact('tool', 'content', 'ip'));
    }

    public function handle(Request $request, Tool $tool)
    {
        $ip = $request->ip();
        $driver = (new ToolsManager($tool))->driver();
        $results = $driver->parse($ip);
        $content = $results['content'] ?? false;

        if (!$content) {
            return redirect()->back()->withError(__('common.somethingWentWrong'));
        }

        return view('tools.what-is-my-ip', compact('results', 'content', 'tool', 'ip'));
    }

    public static function getFileds()
    {
        $array = [
            'title' => "Drivers",
            'fields' => [
                [
                    'id' => "driver",
                    'field' => "tool-options-select",
                    'placeholder' => "Driver",
                    'label' => "Driver",
                    'required' => true,
                    'options' => [['text' => "IP Api", 'value' => "IpApi"], ['text' => "Free IP API", 'value' => "FreeIpApi"]],
                    'validation' => "required",
                    'type' => 'dropdown',
                    'classes' => "",
                    'dependant' => null,
                ],
            ]
        ];

        return $array;
    }
}
