<?php

namespace App\Tools;

use App\Models\Tool;
use Illuminate\Http\Request;
use App\Contracts\ToolInterface;

class SmallTextGenerator implements ToolInterface
{

    protected $tinytext = array(
        "a" => "ᵃ",
        "b" => "ᵇ",
        "c" => "ᶜ",
        "d" => "ᵈ",
        "e" => "ᵉ",
        "f" => "ᶠ",
        "g" => "ᵍ",
        "h" => "ʰ",
        "i" => "ⁱ",
        "j" => "ʲ",
        "k" => "ᵏ",
        "l" => "ˡ",
        "m" => "ᵐ",
        "n" => "ⁿ",
        "o" => "ᵒ",
        "p" => "ᵖ",
        "q" => "ᑫ",
        "r" => "ʳ",
        "s" => "ˢ",
        "t" => "ᵗ",
        "u" => "ᵘ",
        "v" => "ᵛ",
        "w" => "ʷ",
        "x" => "ˣ",
        "y" => "ʸ",
        "z" => "ᶻ",
        "A" => "ᵃ",
        "B" => "ᵇ",
        "C" => "ᶜ",
        "D" => "ᵈ",
        "E" => "ᵉ",
        "F" => "ᶠ",
        "G" => "ᵍ",
        "H" => "ʰ",
        "I" => "ⁱ",
        "J" => "ʲ",
        "K" => "ᵏ",
        "L" => "ˡ",
        "M" => "ᵐ",
        "N" => "ⁿ",
        "O" => "ᵒ",
        "P" => "ᵖ",
        "Q" => "ᵠ",
        "R" => "ʳ",
        "S" => "ˢ",
        "T" => "ᵗ",
        "U" => "ᵘ",
        "V" => "ᵛ",
        "X" => "ˣ",
        "W" => "ʷ",
        "Y" => "ʸ",
        "Z" => "ᶻ",
        "`" => "`",
        "~" => "~",
        "!" => "﹗",
        "@" => "@",
        "#" => "#",
        "$" => "﹩",
        "%" => "﹪",
        "^" => "^",
        "&" => "﹠",
        "*" => "﹡",
        "(" => "⁽",
        ")" => "⁾",
        "_" => "⁻",
        "-" => "⁻",
        "=" => "⁼",
        "+" => "+",
        "{" => "{",
        "[" => "[",
        "}" => "}",
        "]" => "]",
        "=>" => "﹕",
        ";" => "﹔",
        "?" => "﹖",
        "0" => "⁰",
        "1" => "¹",
        "2" => "²",
        "3" => "³",
        "4" => "⁴",
        "5" => "⁵",
        "6" => "⁶",
        "7" => "⁷",
        "8" => "⁸",
        "9" => "⁹",
    );

    protected $smallcapstext = array(
        "a" => "ᴀ",
        "b" => "ʙ",
        "c" => "ᴄ",
        "d" => "ᴅ",
        "e" => "ᴇ",
        "f" => "ꜰ",
        "g" => "ɢ",
        "h" => "ʜ",
        "i" => "ɪ",
        "j" => "ᴊ",
        "k" => "ᴋ",
        "l" => "ʟ",
        "m" => "ᴍ",
        "n" => "ɴ",
        "o" => "ᴏ",
        "p" => "ᴘ",
        "q" => "q",
        "r" => "ʀ",
        "s" => "s",
        "t" => "ᴛ",
        "u" => "ᴜ",
        "v" => "ᴠ",
        "w" => "ᴡ",
        "x" => "x",
        "y" => "ʏ",
        "z" => "ᴢ",
        "A" => "A",
        "B" => "B",
        "C" => "C",
        "D" => "D",
        "E" => "E",
        "F" => "F",
        "G" => "G",
        "H" => "H",
        "I" => "I",
        "J" => "J",
        "K" => "K",
        "L" => "L",
        "M" => "M",
        "N" => "N",
        "O" => "O",
        "P" => "P",
        "Q" => "Q",
        "R" => "R",
        "S" => "S",
        "T" => "T",
        "U" => "U",
        "V" => "V",
        "W" => "W",
        "X" => "X",
        "Y" => "Y",
        "Z" => "Z",
        "`" => "`",
        "~" => "~",
        "!" => "﹗",
        "@" => "@",
        "#" => "#",
        "$" => "﹩",
        "%" => "﹪",
        "^" => "^",
        "&" => "﹠",
        "*" => "﹡",
        "(" => "⁽",
        ")" => "⁾",
        "_" => "⁻",
        "-" => "⁻",
        "=" => "⁼",
        "+" => "+",
        "{" => "{",
        "[" => "[",
        "}" => "}",
        "]" => "]",
        "=>" => "﹕",
        ";" => "﹔",
        "?" => "﹖",
        "0" => "0",
        "1" => "1",
        "2" => "2",
        "3" => "3",
        "4" => "4",
        "5" => "5",
        "6" => "6",
        "7" => "7",
        "8" => "8",
        "9" => "9",
    );
    protected $boldtext = array(
        "a" => "𝐚",
        "b" => "𝐛",
        "c" => "𝐜",
        "d" => "𝐝",
        "e" => "𝐞",
        "f" => "𝐟",
        "g" => "𝐠",
        "h" => "𝐡",
        "i" => "𝐢",
        "j" => "𝐣",
        "k" => "𝐤",
        "l" => "𝐥",
        "m" => "𝐦",
        "n" => "𝐧",
        "o" => "𝐨",
        "p" => "𝐩",
        "q" => "𝐪",
        "r" => "𝐫",
        "s" => "𝐬",
        "t" => "𝐭",
        "u" => "𝐮",
        "v" => "𝐯",
        "w" => "𝐰",
        "x" => "𝐱",
        "y" => "𝐲",
        "z" => "𝐳",
        "A" => "𝐀",
        "B" => "𝐁",
        "C" => "𝐂",
        "D" => "𝐃",
        "E" => "𝐄",
        "F" => "𝐅",
        "G" => "𝐆",
        "H" => "𝐇",
        "I" => "𝐈",
        "J" => "𝐉",
        "K" => "𝐊",
        "L" => "𝐋",
        "M" => "𝐌",
        "N" => "𝐍",
        "O" => "𝐎",
        "P" => "𝐏",
        "Q" => "𝐐",
        "R" => "𝐑",
        "S" => "𝐒",
        "T" => "𝐓",
        "U" => "𝐔",
        "V" => "𝐕",
        "X" => "𝐗",
        "W" => "𝐖",
        "Y" => "𝐘",
        "Z" => "𝐙",
        "`" => "`",
        "~" => "~",
        "!" => "!",
        "@" => "@",
        "#" => "#",
        "$" => "$",
        "%" => "%",
        "^" => "^",
        "&" => "&",
        "*" => "*",
        "(" => "(",
        ")" => ")",
        "_" => "_",
        "-" => "-",
        "=" => "=",
        "+" => "+",
        "{" => "{",
        "[" => "[",
        "}" => "}",
        "]" => "]",
        "=>" => "=>",
        ";" => ";",
        "?" => "?",
        "0" => "𝟎",
        "1" => "𝟏",
        "2" => "𝟐",
        "3" => "𝟑",
        "4" => "𝟒",
        "5" => "𝟓",
        "6" => "𝟔",
        "7" => "𝟕",
        "8" => "𝟖",
        "9" => "𝟗",
    );
    protected $circledtext = array(
        "a" => "ⓐ",
        "b" => "ⓑ",
        "c" => "ⓒ",
        "d" => "ⓓ",
        "e" => "ⓔ",
        "f" => "ⓕ",
        "g" => "ⓖ",
        "h" => "ⓗ",
        "i" => "ⓘ",
        "j" => "ⓙ",
        "k" => "ⓚ",
        "l" => "ⓛ",
        "m" => "ⓜ",
        "n" => "ⓝ",
        "o" => "ⓞ",
        "p" => "ⓟ",
        "q" => "ⓠ",
        "r" => "ⓡ",
        "s" => "ⓢ",
        "t" => "ⓣ",
        "u" => "ⓤ",
        "v" => "ⓥ",
        "w" => "ⓦ",
        "x" => "ⓧ",
        "y" => "ⓨ",
        "z" => "ⓩ",
        "A" => "Ⓐ",
        "B" => "Ⓑ",
        "C" => "Ⓒ",
        "D" => "Ⓓ",
        "E" => "Ⓔ",
        "F" => "Ⓕ",
        "G" => "Ⓖ",
        "H" => "Ⓗ",
        "I" => "Ⓘ",
        "J" => "Ⓙ",
        "K" => "Ⓚ",
        "L" => "Ⓛ",
        "M" => "Ⓜ",
        "N" => "Ⓝ",
        "O" => "Ⓞ",
        "P" => "Ⓟ",
        "Q" => "Ⓠ",
        "R" => "Ⓡ",
        "S" => "Ⓢ",
        "T" => "Ⓣ",
        "U" => "Ⓤ",
        "V" => "Ⓥ",
        "X" => "Ⓧ",
        "W" => "Ⓦ",
        "Y" => "Ⓨ",
        "Z" => "Ⓩ",
        "`" => "`",
        "~" => "~",
        "!" => "!",
        "@" => "@",
        "#" => "#",
        "$" => "$",
        "%" => "%",
        "^" => "^",
        "&" => "&",
        "*" => "⊛",
        "(" => "(",
        ")" => ")",
        "_" => "_",
        "-" => "⊖",
        "=" => "=",
        "+" => "+",
        "{" => "{",
        "[" => "[",
        "}" => "}",
        "]" => "]",
        ":" => ":",
        ";" => ";",
        "?" => "?",
        "0" => "0",
        "1" => "①",
        "2" => "②",
        "3" => "③",
        "4" => "④",
        "5" => "⑤",
        "6" => "⑥",
        "7" => "⑦",
        "8" => "⑧",
        "9" => "⑨",
    );
    protected $invertedtext = array(
        "a" => "ɐ",
        "b" => "q",
        "c" => "ɔ",
        "d" => "p",
        "e" => "ǝ",
        "f" => "ɟ",
        "g" => "ƃ",
        "h" => "ɥ",
        "i" => "ı",
        "j" => "ɾ",
        "k" => "ʞ",
        "l" => "ן",
        "m" => "ɯ",
        "n" => "u",
        "o" => "o",
        "p" => "d",
        "q" => "b",
        "r" => "ɹ",
        "s" => "s",
        "t" => "ʇ",
        "u" => "n",
        "v" => "ʌ",
        "w" => "ʍ",
        "x" => "x",
        "y" => "ʎ",
        "z" => "z",
        "A" => "ɐ",
        "B" => "q",
        "C" => "ɔ",
        "D" => "p",
        "E" => "ǝ",
        "F" => "ɟ",
        "G" => "ƃ",
        "H" => "ɥ",
        "I" => "ı",
        "J" => "ɾ",
        "K" => "ʞ",
        "L" => "ן",
        "M" => "ɯ",
        "N" => "u",
        "O" => "o",
        "P" => "d",
        "Q" => "b",
        "R" => "ɹ",
        "S" => "s",
        "T" => "ʇ",
        "U" => "n",
        "V" => "𐌡",
        "X" => "x",
        "W" => "ʍ",
        "Y" => "ʎ",
        "Z" => "z",
        "`" => "`",
        "~" => "~",
        "!" => "¡",
        "@" => "@",
        "#" => "#",
        "$" => "﹩",
        "%" => "﹪",
        "^" => "^",
        "&" => "⅋",
        "*" => "*",
        "(" => ")",
        ")" => "(",
        "_" => "⁻",
        "-" => "-",
        "=" => "=",
        "+" => "+",
        "{" => "}",
        "[" => "]",
        "}" => "{",
        "]" => "[",
        ":" => ":",
        ";" => ";",
        "?" => "¿",
        "0" => "0",
        "1" => "1",
        "2" => "2",
        "3" => "3",
        "4" => "4",
        "5" => "5",
        "6" => "6",
        "7" => "7",
        "8" => "8",
        "9" => "9",
    );
    protected $backwardstext = array(
        "a" => "a",
        "b" => "d",
        "c" => "ↄ",
        "d" => "b",
        "e" => "ɘ",
        "f" => "ꟻ",
        "g" => "g",
        "h" => "h",
        "i" => "i",
        "j" => "j",
        "k" => "k",
        "l" => "l",
        "m" => "m",
        "n" => "ᴎ",
        "o" => "o",
        "p" => "q",
        "q" => "p",
        "r" => "ᴙ",
        "s" => "ꙅ",
        "t" => "t",
        "u" => "u",
        "v" => "v",
        "w" => "w",
        "x" => "x",
        "y" => "y",
        "z" => "z",
        "A" => "A",
        "B" => "d",
        "C" => "Ↄ",
        "D" => "b",
        "E" => "Ǝ",
        "F" => "ꟻ",
        "G" => "G",
        "H" => "H",
        "I" => "I",
        "J" => "J",
        "K" => "K",
        "L" => "⅃",
        "M" => "M",
        "N" => "ᴎ",
        "O" => "O",
        "P" => "ꟼ",
        "Q" => "p",
        "R" => "ᴙ",
        "S" => "Ꙅ",
        "T" => "T",
        "U" => "U",
        "V" => "V",
        "X" => "X",
        "W" => "W",
        "Y" => "Y",
        "Z" => "Z",
        "`" => "`",
        "~" => "~",
        "!" => "﹗",
        "@" => "@",
        "#" => "#",
        "$" => "﹩",
        "%" => "﹪",
        "^" => "^",
        "&" => "&",
        "*" => "*",
        "(" => "(",
        ")" => ")",
        "_" => "⁻",
        "-" => "⁻",
        "=" => "=",
        "+" => "+",
        "{" => "{",
        "[" => "[",
        "}" => "}",
        "]" => "]",
        ":" => "﹕",
        ";" => "﹔",
        "?" => "﹖",
        "0" => "0",
        "1" => "߁",
        "2" => "2",
        "3" => "3",
        "4" => "4",
        "5" => "5",
        "6" => "6",
        "7" => "7",
        "8" => "8",
        "9" => "9",
    );

    public function render(Request $request, Tool $tool)
    {
        $type = 1;

        return view('tools.small-text-generator', compact('tool', 'type'));
    }

    public function handle(Request $request, Tool $tool)
    {
        $validated = $request->validate([
            'string' => "required|min:1|max_words:{$tool->wc_tool}",
            'type' => 'required',
        ]);

        $string = $request->input('string');
        $type = $request->input('type');
        $converted_text = "";
        switch ($type) {
            case ('1'):
                $converted_text  = $this->replaceString($string, "tinytext");
                break;
            case ('2'):
                $converted_text  = $this->replaceString($string, "invertedtext");
                break;
            case ('3'):
                $converted_text  = $this->replaceString($string, "smallcapstext");
                break;
            case ('4'):
                $converted_text  = $this->replaceString($string, "boldtext");
                break;
            case ('5'):
                $converted_text  = $this->replaceString($string, "circledtext");
                break;
            case ('6'):
                $converted_text  = $this->replaceString($string, "backwardstext");
                break;
            default:
        }
        $results = [
            'original_text' => $string,
            'converted_text' => $converted_text
        ];

        return view('tools.small-text-generator', compact('results', 'tool', 'type'));
    }

    public function replaceString($string, $array)
    {
        $tmp = "";
        for ($i = 0; $i < strlen($string); $i++) {
            if (isset($this->$array[$string[$i]])) {
                $tmp .= $this->$array[$string[$i]];
            } else {
                $tmp .= $string[$i];
            }
        }

        return $tmp;
    }
}
