<?php

namespace App\Tools;

use App\Models\Tool;
use App\Helpers\Facads\SEO;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Contracts\ToolInterface;
use Illuminate\Support\Facades\Cache;

class SEOReport implements ToolInterface
{
    public function render(Request $request, Tool $tool)
    {
        return view('tools.seo-report', compact('tool'));
    }

    public function handle(Request $request, Tool $tool)
    {
        $request->validate([
            'url' => 'required|url',
        ]);

        try {
            $result = SEO::analyze($request->url)->report()->get();
            $uuid = Str::uuid()->toString();
            Cache::put($uuid . "-seo-report", $result, job_cache_time());
            $results = [
                'result' => $result,
                'url' => $request->url,
                'uuid' => $uuid
            ];

            return view('tools.seo-report', compact('results', 'tool'));
        } catch (\Exception $e) {
            return redirect()->back()->withError($e->getMessage());
        }
    }

    public function postAction(Request $request, Tool $tool)
    {
        $validator = $request->validate([
            'process_id' => 'required|uuid',
        ]);

        if (!Cache::has($request->process_id . "-seo-report")) {
            return redirect()->back();
        }

        $result = Cache::get($request->process_id . "-seo-report");
        $results = [
            'result' => $result,
            'hostname' => $result['url'],
            'uuid' => $request->process_id
        ];

        // $view = view('tools.pdf.seo-tool-pdf', compact('results', 'tool'));
        // return $view;
        $pdf = PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->setBasePath(url('/'))
            ->loadView('tools.pdf.seo-tool-pdf', compact('results', 'tool'))
            ->setPaper('a4');

        return $pdf->download($result['domainname'] . 'seo-report.pdf');
    }

    public static function getFileds()
    {
        $array =  [
            'title' => "Drivers",
            'fields' => [
                [
                    'id' => "driver",
                    'field' => "tool-options-select",
                    'placeholder' => "Driver",
                    'label' => "Driver",
                    'required' => true,
                    'options' => [['text' => "Thum", 'value' => "thum"], ['text' => "MicroLink", 'value' => "microlink"]],
                    'validation' => "required",
                    'type' => 'dropdown',
                    'classes' => "",
                    'dependant' => null,
                ],
                [
                    'id' => "thumio_auth_code",
                    'field' => "tool-options-textfield",
                    'placeholder' => "please enter api key here....",
                    'label' => "Thum Auth Code",
                    'required' => true,
                    'options' => null,
                    'validation' => "nullable",
                    'type' => 'text',
                    'min' => null,
                    'max' => null,
                    'classes' => "",
                    'dependant' => ['settings[driver]', "thum"],
                ],
            ]
        ];

        return $array;
    }
}
