<?php

namespace App\Tools;

use App\Models\Tool;
use Illuminate\Http\Request;
use App\Components\ToolsManager;
use App\Contracts\ToolInterface;

class RewriteArticle implements ToolInterface
{
    public function render(Request $request, Tool $tool)
    {
        return view('tools.rewrite-article', compact('tool'));
    }

    public function handle(Request $request, Tool $tool)
    {
        $validated = $request->validate([
            'string' => "required|min:1|max:{$tool->wc_tool}",
        ]);

        $article = $request->input('string');

        // parse with driver
        $driver = (new ToolsManager($tool))->driver();
        $result = $driver->parse($article);

        if (!$result['success']) {
            return redirect()->back()->withError($result['message']);
        }

        $results = [
            'original_article' => $article,
            'article_rewrite' => $result['text']
        ];

        return view('tools.rewrite-article', compact('results', 'tool'));
    }

    public static function getFileds()
    {
        $array = [
            'title' => "Drivers",
            'fields' => [
                [
                    'id' => "driver",
                    'field' => "tool-options-select",
                    'placeholder' => "Driver",
                    'label' => "Driver",
                    'required' => true,
                    'options' => [['text' => "Default", 'value' => "DefaultRewriter"], ['text' => "Open  AI", 'value' => "OpenAiRewriter"]],
                    'validation' => "required",
                    'type' => 'dropdown',
                    'classes' => "",
                    'dependant' => null,
                ],
                [
                    'id' => "openai_apikey",
                    'field' => "tool-options-textfield",
                    'placeholder' => "please enter api key here....",
                    'label' => "OpenAi Driver Api Key",
                    'required' => true,
                    'options' => null,
                    'validation' => "required_if:driver,OpenAiRewriter",
                    'type' => 'text',
                    'min' => null,
                    'max' => null,
                    'classes' => "",
                    'dependant' => ['settings[driver]', "OpenAiRewriter"],
                ],
            ]
        ];

        return $array;
    }
}
