<?php

namespace App\Tools;

use App\Models\Tool;
use Illuminate\Http\Request;
use App\Components\ToolsManager;
use App\Contracts\ToolInterface;
use Illuminate\Support\Facades\Cache;

class ImageToText implements ToolInterface
{
    public function render(Request $request, Tool $tool)
    {
        return view('tools.image-to-text', compact('tool'));
    }

    public function handle(Request $request, Tool $tool)
    {
        $validated = $request->validate([
            'image' => "required|max:" . $tool->fs_tool*1024,
        ]);
        $file = $request->file('image');

        $driver = (new ToolsManager($tool))->driver();
        $results = $driver->parse($file);

        $results['download_url'] = route('tool.action', ['tool' => $tool->slug, 'action' => 'download', 'process_id' => $results['process_id']]);

        if (empty($results['text'])) {
            return redirect()->back()->withError(__('tools.noTextFoundOnImg'));
        }

        return view('tools.image-to-text', compact('tool', 'results'));
    }

    public function action(Request $request)
    {
        list($content, $filename) = Cache::get($request->process_id);
        $headers = array(
            "Content-type" => "text/plain",
            "Content-Disposition" => "attachment;Filename={$filename}.txt"
        );

        return response($content, 200, $headers);
    }

    public static function getFileds()
    {
        $array = [
            'title' => "Drivers",
            'fields' => [
                [
                    'id' => "driver",
                    'field' => "tool-options-select",
                    'placeholder' => "Driver",
                    'label' => "Driver",
                    'required' => true,
                    'options' => [['text' => "Tesseract", 'value' => "TesseractOCR"], ['text' => "OCR Space", 'value' => "OcrSpace"]],
                    'validation' => "required",
                    'type' => 'dropdown',
                    'classes' => "",
                    'dependant' => null,
                ],
                [
                    'id' => "ocr_space_key",
                    'field' => "tool-options-textfield",
                    'placeholder' => "please enter api key here....",
                    'label' => "OCRSpace Driver Api Key",
                    'required' => true,
                    'options' => null,
                    'validation' => "required_if:driver,OcrSpace",
                    'type' => 'text',
                    'min' => null,
                    'max' => null,
                    'classes' => "",
                    'dependant' => ['settings[driver]', "OcrSpace"],
                ],
            ]
        ];

        return $array;
    }
}
