<?php

namespace App\Tools;

use App\Models\Tool;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Contracts\ToolInterface;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Cache;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Validator;

class ImageResizer implements ToolInterface
{
    public function render(Request $request, Tool $tool)
    {
        return view('tools.image-resizer', compact('tool'));
    }

    public function handle(Request $request, Tool $tool)
    {
        $validated = $request->validate([
            'image' => "image|max:" . $tool->fs_tool * 1024
        ]);

        $horizontal = $request->input('flip_horizontal');
        $vertical = $request->input('flip_vertical');
        $rotate = $request->input('rotate');
        $resize = $request->input('resize');
        $width = $request->input('width');
        $height = $request->input('height');
        $percentage = $request->input('percentage');
        $format = $request->input('format');
        $file = $request->file('image');
        $filename = $file->getClientOriginalName();
        $image = Image::make($file)->rotate($rotate, '#ffffff');

        if (in_array($format, ['png', 'jpg', 'webp'])) {
            $filename = pathinfo($filename, PATHINFO_FILENAME) . '.' . $format;
        } else {
            $format = $file->getClientOriginalExtension();
        }

        if ($resize == 1) {
            $height = round(($percentage * $image->height() / 100), 0);
            $width = round(($percentage * $image->width() / 100), 0);
        }

        if ($horizontal == 'true') {
            $image->flip('h');
        }
        if ($vertical == 'true') {
            $image->flip('h');
        }

        $image->fit($width, $height, function ($constraint) {
            $constraint->upsize();
        });

        $image->encode($format);
        $resource = UploadedFile::fake()->createWithContent($filename, $image);
        $results = tempFileUpload($resource, true);

        return view('tools.image-resizer', compact('results', 'tool'));
    }
}
