<?php

namespace App\Tools;

use App\Models\Tool;
use Illuminate\Http\Request;
use App\Contracts\ToolInterface;


class FindDnsRecord implements ToolInterface
{
    public function render(Request $request, Tool $tool)
    {
        return view('tools.find-dns-record', compact('tool'));
    }

    public function handle(Request $request, Tool $tool)
    {
        $validated = $request->validate([
            'domain' => 'required|fqdn',
        ]);

        $hostname = extractHostname($request->domain, true);
        $content = dns_get_record($hostname, DNS_A);

        $results = [
            'domain' => $request->domain,
            'content' => $content[0] ?? null
        ];

        return view('tools.find-dns-record', compact('results', 'tool'));
    }

    public static function getFileds()
    {
        $array = [
            'title' => "Drivers",
            'fields' => [
                [
                    'id' => "driver",
                    'field' => "tool-options-select",
                    'placeholder' => "Driver",
                    'label' => "Driver",
                    'required' => true,
                    'options' => [['text' => "Default", 'value' => "WhoisDomainChecker"]],
                    'validation' => "required",
                    'type' => 'dropdown',
                    'classes' => "",
                    'dependant' => null,
                ],
            ]
        ];

        return $array;
    }
}
