<?php

namespace App\Http\Controllers;

use Exception;
use App\Models\Tool;
use Illuminate\Http\Request;
use Butschster\Head\Facades\Meta;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Diglactic\Breadcrumbs\Breadcrumbs;
use Illuminate\Support\Facades\Validator;

class ToolController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, $tool)
    {
        $tool = Tool::withTranslation()->withCount('usageToday')->with('category')->slug($tool)->active()->firstOrFail();
        if (!class_exists($tool->class_name) && (!method_exists($tool->class_name, 'render') || !method_exists($tool->class_name, 'handle'))) {
            abort(404);
        }
        $instance = new $tool->class_name();

        record_page_visit($tool);
        Meta::setMeta($tool);
        Breadcrumbs::setCurrentRoute(Route::current()->getName(), $tool);

        return  $instance->render($request, $tool);
    }

    /**
     *
     */
    public function handle(Request $request, $tool)
    {
        $tool = Tool::withTranslation()->withCount('usageToday')->slug($tool)->active()->firstOrFail();
        if (!class_exists($tool->class_name) && (!method_exists($tool->class_name, 'render') || !method_exists($tool->class_name, 'handle'))) {
            abort(404);
        }

        if (!$this->checkUsage($tool)) {
            return redirect()->back()->withErrors(__('tools.limitExceed'));
        }

        $tool->load('category');
        $instance = new $tool->class_name();
        $tool->createVisitLog(auth()->user());
        Breadcrumbs::setCurrentRoute(Route::current()->getName(), $tool);

        return  $instance->handle($request, $tool);
    }

    public function action(Request $request, $tool)
    {
        $tool = Tool::withTranslation()->withCount('usageToday')->slug($tool)->active()->firstOrFail();
        if (!class_exists($tool->class_name) && (!method_exists($tool->class_name, 'render') || !method_exists($tool->class_name, 'handle'))) {
            abort(404);
        }

        if (!$this->checkUsage($tool)) {
            return redirect()->back()->withErrors(__('tools.limitExceed'));
        }
        $instance = new $tool->class_name();

        return $instance->action($request);
    }

    public function postAction(Request $request, $tool)
    {
        $tool = Tool::withTranslation()->withCount('usageToday')->slug($tool)->active()->firstOrFail();
        if (!class_exists($tool->class_name) && (!method_exists($tool->class_name, 'render') || !method_exists($tool->class_name, 'handle'))) {
            abort(404);
        }
        if (!$this->checkUsage($tool)) {
            return redirect()->back()->withErrors(__('tools.limitExceed'));
        }
        $instance = new $tool->class_name();

        return $instance->postAction($request, $tool);
    }

    public function favouriteAction(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'message' => __('tools.invalidRequest')]);
        }

        try {
            $user = Auth::user();
            $tool = Tool::find($request->id);
            $hasFavorited = $user->hasFavorited($tool);

            $hasFavorited ? $user->unfavorite($tool) : $user->favorite($tool);
            $message =  $hasFavorited ?  __('tools.favouriteRemoved') : __('tools.favouriteAdded');

            return response()->json(['success' => true, 'message' => $message]);
        } catch (Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()]);
        }
    }

    public function checkUsage($tool)
    {
        if ($tool->du_tool  <= $tool->usage_today_count) {
            return false;
        }

        return true;
    }
}
