<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Butschster\Head\Facades\Meta;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    public function index()
    {
        $favorties = Auth::check() ? Auth::user()->favorite_tools : null;
        $tools = Category::query()
            ->active()
            ->tool()
            ->with('translations')
            ->with(['tools' => function ($query) {
                $query->active()->with('translations')->orderBy('display');
            }])
            ->get();

        Meta::setMeta();

        return view('index', compact('tools', 'favorties'));
    }
}
