<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Helpers\Classes\UpdatesManager;

class UpdateController extends Controller
{
    protected $manager;

    public function __construct(UpdatesManager $manager)
    {
        $this->manager = $manager;
    }

    /**
     * Update the application.
     *
     * @PermissionAnnotation(name="Run Update Application")
     */
    public function update()
    {
        $this->manager->runUpdate();

        return redirect()->route('admin.dashboard')->withSuccess('Application updated successfully!');
    }

    public function checkUpdates()
    {
        $this->manager->checkUpdates();

        return redirect()->route('admin.dashboard');
    }

    public function verifyUpdates()
    {
        $this->manager->validateAndPerformUpdate();

        return redirect()->route('admin.dashboard');
    }
}
