<?php

namespace App\Http\Controllers\Admin;

use Hash;
use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;
use Session;
use Google2FA;
use App\Http\Requests\Admin\ProfileRequest;

class ProfileController extends Controller
{
    public function __construct()
    {
        // if (!Session::get('twofa_key')) {
        //     Session::put('twofa_key', Google2FA::generateSecretKey());
        // }
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::User();

        return view('users.profile.index', compact('user'));
    }

    public function password()
    {
        $user = Auth::User();

        return view('users.profile.password', compact('user'));
    }

    /**
     */
    public function update(ProfileRequest $request)
    {
        $data = $request->input();
        $user = User::find($request->id);

        if (isset($data['name'])) {
            $data_arry = [
                'name' => $data['name'],
                'username' => $data['username'],
                'about' => $data['about'],
                'email' => $data['email'],
                'picture' => 'default.png',
            ];
        }

        if ($request->password != null || $request->password != "") {
            $data_arry['password'] = Hash::make($data['password']);
        }
        $user->update($data_arry);

        return redirect()->route('admin.profile')->withSuccess(__('admin.profileUpdated'));
    }

    /**
     * Show 2fa form to user.
     *
     * @param  Request $request
     * @return \Illuminate\Http\Response
     */
    public function enable2fa(Request $request, User $user)
    {
        $twofa_key = Session::get('twofa_key');
        $twofa_image = $this->getInlineUrl($twofa_key);

        return view('users.profile.mfa', compact('user'));
    }

    /**
     * @param  $key
     * @return mixed
     */
    private function getInlineUrl($key)
    {
        $user = Auth::user();
        return Google2FA::getQRCodeInline(
            __('admin.twoFAApp', ['name' => $user->name]),
            $user->email,
            $key
        );
    }
}
