<?php

namespace App\Components\Drivers;

use GuzzleHttp\Client;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Cache;
use App\Contracts\ToolDriverInterface;
use Iodev\Whois\Factory;

class MozApiDriver implements ToolDriverInterface
{

    public function parse($domain)
    {
        $cacheKey = empty($domain) ? (string) Str::uuid() : Str::slug($domain);
        $content = Cache::rememberForever($cacheKey, function () use ($domain)
        {
            // Get your access id and secret key here: https://moz.com/products/api/keys
            $accessID  = "";
            $secretKey = "";
            $expires = time() + 300;
            $stringToSign = $accessID . "\n" . $expires;
            $binarySignature = hash_hmac('sha1', $stringToSign, $secretKey, true);
            $urlSafeSignature = urlencode(base64_encode($binarySignature));
            $cols = "103079233568";
            $endpoint = "http://lsapi.seomoz.com/linkscape/url-metrics/" . urlencode($domain) . "?Cols=" . $cols . "&AccessID=" . $accessID . "&Expires=" . $expires . "&Signature=" . $urlSafeSignature;
            $client = new \GuzzleHttp\Client();
            $response = $client->request('GET', $endpoint);
            $xml_string = $response->getBody()->getContents();
            $xml = simplexml_load_string($xml_string);
            $json = json_encode($xml);
            $info = json_decode($json, TRUE);
            return $this->results($info);
        });
        return compact('domain', 'content');
    }

    protected function results($info)
    {
        return  [
            'ip' => "",
            'da' => "",
            'pa' => "",
            'mr' => "",
            'linking' => "",
        ];
    }
}
