<?php

namespace App\Components\Drivers;

use App\Contracts\ToolDriverInterface;

class DefaultRewriter implements ToolDriverInterface
{
    public function parse($article)
	{
        try {
            $article = urldecode($article);
            $artarray = $article;
            $step1 = array("(", ")", "[", "]", "?", ".", ",", "|", "\$", "*", "+", "^","{", "}");
            $artarray = str_replace($step1," ",$artarray);
            $artarray = str_replace("  "," ",$artarray);
            $words_artarray = explode(" ",$artarray);

            if (sizeof($words_artarray)>0)
            {
                for($i=0;$i<sizeof($words_artarray);$i++)
                {
                    $to_be_replaced = $words_artarray[$i];
                    $to_be_replaced = str_replace(" ","",$to_be_replaced);
                    if(($to_be_replaced!="")&&(strlen($to_be_replaced)>=4))
                    {
                        $to_be_replaced = " ".$to_be_replaced." ";
                        if ( $this->hasWord($to_be_replaced) ) {
                            $to_be_replaced_with = $this->get($to_be_replaced);
                            if(($to_be_replaced!="")&&($to_be_replaced!=" ")&&($to_be_replaced_with!=""))
                            {
                                $article = str_replace($to_be_replaced,$to_be_replaced_with,$article);
                                $article = str_replace(" ".ucfirst(trim($to_be_replaced))." "," ".ucfirst(trim($to_be_replaced_with))." ",$article);
                            }
                        }
                    }
                }
            }

            $article = str_replace("\'", "'", $article);
            $article = str_replace('\"', '"', $article);

            return ['success' => true, 'text' => $article];
        } catch (\Exception $e) {
            return ['success' => false, 'message' => $e->getMessage()];
        }
	}

    public function hasWord($word)
    {
        $arry = $this->dictionary();

        return isset($arry[$word]);
    }

    public function get($word)
    {
        $arry = $this->dictionary();

        return $arry[$word] ?? '';
    }

    public function dictionary()
    {
     $dic = array(
        " aback "                   => " ashamed ",
        " abacus "                  => " abacus ",
        " abaft "                   => " aback ",
        " abalienate "              => " abalienate ",
        " abandon "                 => " carelessness ",
        " abandoned "               => " alone ",
        " abandoning "              => " abandoning ",
        " abandonment "             => " abandonment ",
        " abase "                   => " abase ",
        " abased "                  => " abandoned ",
        " abasement "               => " abasement ",
        " abash "                   => " abash ",
        " abashed "                 => " ashamed ",
        " abashing "                => " abashing ",
        " abashment "               => " abashing ",
        " abasing "                 => " abasing ",
        " abate "                   => " allay ",
        " abatement "               => " abatement ",
        " abating "                 => " abating ",
        " abbey "                   => " abbey ",
        " abbot "                   => " abbot ",
        " abbreviate "              => " abridge ",
        " abbreviated "             => " abbreviated ",
        " abbreviating "            => " abbreviating ",
        " abbreviation "            => " abridgement ",
        " abdicate "                => " abandon ",
        " abdomen "                 => " belly ",
        " abdominal "               => " belly ",
        " abdominals "              => " abdominals ",
        " abduction "               => " abduction ",
        " abecedarian "             => " abecedarian ",
        " abecedary "               => " abecedary ",
        " aberancy "                => " aberancy ",
        " aberant "                 => " aberant ",
        " aberrant "                => " abnormal ",
        " aberrate "                => " aberrate ",
        " aberration "              => " abnormality ",
        " abet "                    => " advocate ",
        " abetment "                => " abetment ",
        " abetting "                => " abetting ",
        " abettor "                 => " abettor ",
        " abeyance "                => " cessation ",
        " abeyancy "                => " abeyance ",
        " abeyant "                 => " abeyant ",
        " abhor "                   => " abominate ",
        " abhorred "                => " abhorred ",
        " abhorrence "              => " abhorrence ",
        " abhorrent "               => " abhorrent ",
        " abide "                   => " accept ",
        " abiding "                 => " constant ",
        " abidingness "             => " abidingness ",
        " abilities "               => " abilities ",
        " ability "                 => " adeptness ",
        " abiogenetic "             => " abiogenetic ",
        " abject "                  => " base ",
        " abjection "               => " abasement ",
        " abjectness "              => " abasement ",
        " abjuration "              => " abandonment ",
        " abjure "                  => " abandon ",
        " ablaze "                  => " afire ",
        " able "                    => " able ",
        " able-bodied "             => " able ",
        " ableness "                => " ability ",
        " ablution "                => " ablution ",
        " abnegate "                => " abandon ",
        " abnegating "              => " abnegating ",
        " abnegation "              => " abandonment ",
        " abnormal "                => " aberrant ",
        " abnormality "             => " aberancy ",
        " abnormally "              => " abnormally ",
        " abode "                   => " address ",
        " aboideau "                => " aboideau ",
        " abolish "                 => " abate ",
        " abolished "               => " abolished ",
        " abolishing "              => " abandoning ",
        " abolishment "             => " abolishment ",
        " abolition "               => " abolishment ",
        " abolitionism "            => " abolition ",
        " abolitionist "            => " abolitionist ",
        " abominable "              => " abhorrent ",
        " abominably "              => " abominably ",
        " abominate "               => " abominate ",
        " abomination "             => " abhorrence ",
        " aboriginal "              => " ancient ",
        " aborigine "               => " aborigine ",
        " abort "                   => " arrest ",
        " aborticide "              => " aborticide ",
        " aborting "                => " aborticide ",
        " abortion "                => " aborticide ",
        " abortive "                => " bootless ",
        " abounding "               => " abounding ",
        " about-face "              => " changeabout ",
        " above "                   => " aloft ",
        " above-board "             => " above-board ",
        " above-mentioned "         => " above-mentioned ",
        " above-named "             => " above-mentioned ",
        " aboveboard "              => " candid ",
        " abrade "                  => " abrade ",
        " abrading "                => " abrading ",
        " abrasion "                => " chafe ",
        " abrasive "                => " annoying ",
        " abreaction "              => " ablution ",
        " abreast "                 => " beside ",
        " abridge "                 => " abbreviate ",
        " abridged "                => " abridged ",
        " abridgement "             => " abbreviation ",
        " abridging "               => " abbreviating ",
        " abridgment "              => " abridgment ",
        " abroad "                  => " away ",
        " abrogate "                => " abate ",
        " abrogating "              => " abrogating ",
        " abrogation "              => " abolishment ",
        " abrupt "                  => " brusque ",
        " abruptly "                => " abruptly ",
        " abruptness "              => " abruptness ",
        " abscess "                 => " abscess ",
        " abscessed "               => " abscessed ",
        " absconding "              => " abrogation ",
        " absent-minded "           => " absent ",
        " absent-mindedness "       => " absent-mindedness ",
        " absenteeism "             => " absence ",
        " absentminded "            => " absent ",
        " absinthian "              => " absinthian ",
        " absitively "              => " absitively ",
        " absolute "                => " complete ",
        " absolutely "              => " actually ",
        " absoluteness "            => " absoluteness ",
        " absolution "              => " absolution ",
        " absolutism "              => " ability ",
        " absolutist "              => " absolutist ",
        " absolve "                 => " acquit ",
        " absolved "                => " absolved ",
        " absonant "                => " absonant ",
        " absorb "                  => " blot ",
        " absorbed "                => " captivated ",
        " absorbent "               => " absorptive ",
        " absorber "                => " cushion ",
        " absorbing "               => " arresting ",
        " absorption "              => " assimilation ",
        " absorptive "              => " absorptive ",
        " abstain "                 => " abjure ",
        " abstaining "              => " abnegation ",
        " abstemious "              => " abstinent ",
        " abstemiousness "          => " abnegation ",
        " abstention "              => " abnegation ",
        " abstentious "             => " abstemious ",
        " absterge "                => " absterge ",
        " abstergent "              => " abrasive ",
        " abstersion "              => " abolition ",
        " abstinence "              => " abnegation ",
        " abstinent "               => " abstinent ",
        " abstract "                => " abstruse ",
        " abstracted "              => " absent ",
        " abstraction "             => " absorption ",
        " abstracts "               => " abstracts ",
        " abstruse "                => " abstract ",
        " abstruseness "            => " abstruseness ",
        " absurd "                  => " cool ",
        " absurdity "               => " applesauce ",
        " absurdly "                => " absurdly ",
        " absurdness "              => " absurdity ",
        " abundance "               => " affluence ",
        " abundant "                => " abounding ",
        " abundantly "              => " abundantly ",
        " abusage "                 => " abusage ",
        " abuse "                   => " corruption ",
        " abusive "                 => " calumniating ",
        " abusiveness "             => " abuse ",
        " abut "                    => " adjoin ",
        " abutment "                => " abutment ",
        " abuttals "                => " abuttals ",
        " abutting "                => " abutting ",
        " abysm "                   => " abysm ",
        " abysmal "                 => " bottomless ",
        " abyss "                   => " abysm ",
        " abyssal "                 => " abysmal ",
        " academic "                => " bookish ",
        " academician "             => " academician ",
        " academism "               => " academism ",
        " accede "                  => " accept ",
        " accedence "               => " accedence ",
        " acceding "                => " acceding ",
        " accelerate "              => " advance ",
        " accelerated "             => " accelerated ",
        " accelerating "            => " accelerating ",
        " acceleration "            => " dispatch ",
        " accelerator "             => " accelerator ",
        " accent "                  => " emphasis ",
        " accented "                => " absolute ",
        " accentuate "              => " accentuate ",
        " accentuation "            => " accentuation ",
        " accept "                  => " acquire ",
        " acceptability "           => " acceptability ",
        " acceptable "              => " adequate ",
        " acceptably "              => " abundantly ",
        " acceptance "              => " accepting ",
        " acceptant "               => " acceptant ",
        " acceptation "             => " acceptation ",
        " accepted "                => " accustomed ",
        " accepter "                => " accepter ",
        " accepting "               => " accepting ",
        " acceptive "               => " acceptant ",
        " access "                  => " admission ",
        " accessibility "           => " accessibility ",
        " accessible "              => " attainable ",
        " accession "               => " accretion ",
        " accessories "             => " accessories ",
        " accessory "               => " accent ",
        " accident "                => " blow ",
        " accidental "              => " adventitious ",
        " accidentally "            => " accidentally ",
        " acclaim "                 => " acclamation ",
        " acclaimed "               => " acclaimed ",
        " acclamation "             => " acclaim ",
        " acclimate "               => " acclimatize ",
        " acclimated "              => " acclimated ",
        " acclimation "             => " acclimation ",
        " acclimatization "         => " acclimatization ",
        " acclimatize "             => " acclimatize ",
        " acclimatized "            => " acclimatized ",
        " acclivity "               => " acclivity ",
        " acclivous "               => " acclivous ",
        " accolade "                => " approval ",
        " accommodate "             => " board ",
        " accommodated "            => " accommodated ",
        " accommodating "           => " all-around ",
        " accommodation "           => " adaptation ",
        " accommodations "          => " apartment ",
        " accommodativeness "       => " accommodativeness ",
        " accompaniment "           => " accessory ",
        " accompaniments "          => " accessories ",
        " accompanist "             => " accompanist ",
        " accompanying "            => " accompanying ",
        " accomplice "              => " abettor ",
        " accomplish "              => " achieve ",
        " accomplishable "          => " accessible ",
        " accomplished "            => " able ",
        " accomplishing "           => " accomplishing ",
        " accomplishment "          => " ability ",
        " accomplishments "         => " accomplishments ",
        " accord "                  => " accordance ",
        " accordance "              => " accordance ",
        " accordant "               => " accordant ",
        " accordingly "             => " appropriately ",
        " accost "                  => " address ",
        " accouchement "            => " accouchement ",
        " account "                 => " annual ",
        " accountability "          => " accountability ",
        " accountable "             => " answerable ",
        " accountableness "         => " accountability ",
        " accounts "                => " accounts ",
        " accouter "                => " accouter ",
        " accouterment "            => " accouterment ",
        " accouterments "           => " accouterments ",
        " accoutrement "            => " accoutrement ",
        " accoutrements "           => " accoutrements ",
        " accredit "                => " ascribe ",
        " accreditation "           => " accreditation ",
        " accredited "              => " accepted ",
        " accretion "               => " accession ",
        " accroach "                => " accroach ",
        " accrual "                 => " accretion ",
        " accrue "                  => " accumulate ",
        " accrument "               => " accession ",
        " acculturate "             => " acclimatize ",
        " acculturation "           => " acculturation ",
        " accumbent "               => " accumbent ",
        " accumulate "              => " accrue ",
        " accumulated "             => " accumulated ",
        " accumulating "            => " accumulating ",
        " accumulation "            => " accession ",
        " accumulative "            => " accumulative ",
        " accumulator "             => " accumulator ",
        " accuracy "                => " accurateness ",
        " accurate "                => " authentic ",
        " accurately "              => " accurately ",
        " accurateness "            => " accurateness ",
        " accurse "                 => " abhor ",
        " accursed "                => " accursed ",
        " accusable "               => " accusable ",
        " accusation "              => " allegation ",
        " accusatory "              => " accusatory ",
        " accuse "                  => " allege ",
        " accuser "                 => " accuser ",
        " accustom "                => " acclimatize ",
        " accustomed "              => " acclimatized ",
        " accustomedness "          => " acclimatization ",
        " acerb "                   => " absinthian ",
        " acerbate "                => " acerbate ",
        " acerbic "                 => " acerbic ",
        " acerbity "                => " acidity ",
        " aces "                    => " aces ",
        " acetic "                  => " acerb ",
        " acetose "                 => " acerbic ",
        " acetous "                 => " acerb ",
        " ache "                    => " anguish ",
        " achene "                  => " achene ",
        " achievability "           => " achievability ",
        " achievable "              => " accessible ",
        " achieve "                 => " accomplish ",
        " achieved "                => " accomplished ",
        " achievement "             => " accomplishment ",
        " achieving "               => " accomplishing ",
        " achromatic "              => " achromatic ",
        " achromatize "             => " achromatize ",
        " achromic "                => " achromatic ",
        " acicular "                => " acicular ",
        " aciculate "               => " acicular ",
        " acid "                    => " acerbic ",
        " acidic "                  => " acerb ",
        " acidify "                 => " acerbate ",
        " acidity "                 => " acidity ",
        " acidulate "               => " acerbate ",
        " acidulated "              => " acerb ",
        " acidulous "               => " acerbic ",
        " acknowledge "             => " accede ",
        " acknowledged "            => " accustomed ",
        " acknowledgement "         => " accepting ",
        " acknowledging "           => " acknowledging ",
        " acknowledgment "          => " acceptance ",
        " acme "                    => " apogee ",
        " acne "                    => " abscess ",
        " acquaint "                => " accustom ",
        " acquaintance "            => " associate ",
        " acquaintanceship "        => " acquaintance ",
        " acquainted "              => " acquainted ",
        " acquiesce "               => " accede ",
        " acquiescence "            => " acceptance ",
        " acquiescent "             => " acknowledging ",
        " acquiescently "           => " acquiescently ",
        " acquire "                 => " access ",
        " acquirement "             => " accomplishment ",
        " acquirements "            => " acquirements ",
        " acquiring "               => " accepting ",
        " acquisition "             => " accretion ",
        " acquisitive "             => " avaricious ",
        " acquisitiveness "         => " acquisitiveness ",
        " acquit "                  => " absolve ",
        " acquittal "               => " absolution ",
        " acquittance "             => " acknowledgment ",
        " acquitting "              => " absolution ",
        " acreage "                 => " acreage ",
        " acres "                   => " acreage ",
        " acrid "                   => " acid ",
        " acridity "                => " acerbity ",
        " acrimonious "             => " acerbic ",
        " acrimony "                => " acerbity ",
        " acroamatic "              => " abstruse ",
        " acropolis "               => " acropolis ",
        " across "                  => " beyond ",
        " across-the-board "        => " all-embracing ",
        " acrylic "                 => " acrylic ",
        " acted "                   => " acted ",
        " actinic "                 => " actinic ",
        " action "                  => " activity ",
        " actionable "              => " actionable ",
        " actions "                 => " accomplishments ",
        " activate "                => " actuate ",
        " activated "               => " activated ",
        " activating "              => " activating ",
        " activation "              => " activation ",
        " active "                  => " alive ",
        " actively "                => " actively ",
        " activist "                => " activist ",
        " activity "                => " action ",
        " actor "                   => " amateur ",
        " actress "                 => " extra ",
        " actual "                  => " absolute ",
        " actuality "               => " achievement ",
        " actualization "           => " accomplishment ",
        " actualize "               => " accomplish ",
        " actualized "              => " accomplished ",
        " actually "                => " absolutely ",
        " actuate "                 => " activate ",
        " actuating "               => " actuating ",
        " actuation "               => " actuation ",
        " acuate "                  => " aciculate ",
        " acumen "                  => " accuracy ",
        " acuminate "               => " acicular ",
        " acuminous "               => " acicular ",
        " acute "                   => " astute ",
        " acutely "                 => " acutely ",
        " acuteness "               => " activity ",
        " ad-lib "                  => " extemporaneous ",
        " adage "                   => " aphorism ",
        " adamant "                 => " determined ",
        " adamantine "              => " adamantine ",
        " adapt "                   => " acclimate ",
        " adaptability "            => " ability ",
        " adaptable "               => " adjustable ",
        " adaptation "              => " adjustment ",
        " adapted "                 => " acclimatized ",
        " adapter "                 => " adapter ",
        " added "                   => " added ",
        " addendum "                => " addition ",
        " addict "                  => " aficionado ",
        " addicted "                => " absorbed ",
        " addicting "               => " accepted ",
        " addictive "               => " addictive ",
        " adding "                  => " abacus ",
        " addition "                => " accession ",
        " additional "              => " added ",
        " additionally "            => " additionally ",
        " additive "                => " accretion ",
        " additory "                => " accumulative ",
        " addle "                   => " addle ",
        " addle-brain "             => " addle-brain ",
        " addle-head "              => " addle-brain ",
        " addle-pate "              => " addle-pate ",
        " addled "                  => " befuddled ",
        " addling "                 => " abashing ",
        " address "                 => " abode ",
        " addressee "               => " aborigine ",
        " addressing "              => " acclamation ",
        " adduce "                  => " adduce ",
        " adenoids "                => " adenoids ",
        " adept "                   => " accomplished ",
        " adeptness "               => " adeptness ",
        " adequacy "                => " capability ",
        " adequate "                => " able ",
        " adequately "              => " abundantly ",
        " adequateness "            => " adequateness ",
        " adequation "              => " adequation ",
        " adhere "                  => " attach ",
        " adherence "               => " adherence ",
        " adherent "                => " adherent ",
        " adhering "                => " adhering ",
        " adhesion "                => " adherence ",
        " adhesive "                => " adhering ",
        " adieu "                   => " conge ",
        " adieus "                  => " adieu ",
        " adieux "                  => " adieu ",
        " adios "                   => " adieu ",
        " adipose "                 => " adipose ",
        " adiposity "               => " adiposity ",
        " adit "                    => " access ",
        " adjacency "               => " adjacency ",
        " adjacent "                => " adjoining ",
        " adjoin "                  => " abut ",
        " adjoining "               => " abutting ",
        " adjourn "                 => " curb ",
        " adjourned "               => " adjourned ",
        " adjournment "             => " break ",
        " adjudge "                 => " adjudge ",
        " adjudicate "              => " adjudge ",
        " adjudication "            => " acknowledgment ",
        " adjudicator "             => " adjudicator ",
        " adjudicature "            => " accommodation ",
        " adjunct "                 => " accessory ",
        " adjunctive "              => " accessory ",
        " adjuration "              => " address ",
        " adjure "                  => " address ",
        " adjust "                  => " acclimatize ",
        " adjustability "           => " adaptability ",
        " adjustable "              => " adjustable ",
        " adjusted "                => " adapted ",
        " adjustment "              => " acclimation ",
        " adjutant "                => " aide ",
        " adjuvant "                => " accessory ",
        " adjy "                    => " addle ",
        " admeasure "               => " admeasure ",
        " admeasurement "           => " admeasurement ",
        " admensuration "           => " admeasurement ",
        " administer "              => " administrate ",
        " administering "           => " administering ",
        " administrate "            => " administrate ",
        " administration "          => " administering ",
        " administrative "          => " authoritative ",
        " administrator "           => " ambassador ",
        " admiral "                 => " admiral ",
        " admiration "              => " account ",
        " admire "                  => " adore ",
        " admired "                 => " admired ",
        " admirer "                 => " adherent ",
        " admirers "                => " admirers ",
        " admiring "                => " admiring ",
        " admissibility "           => " accommodation ",
        " admissible "              => " acceptable ",
        " admissibly "              => " abundantly ",
        " admission "               => " acceptance ",
        " admit "                   => " accept ",
        " admittance "              => " admission ",
        " admitted "                => " accepted ",
        " admittedly "              => " absolutely ",
        " admitting "               => " acceptance ",
        " admix "                   => " admix ",
        " admixed "                 => " admixed ",
        " admixture "               => " admixture ",
        " admonish "                => " advise ",
        " admonishing "             => " admonishing ",
        " admonishment "            => " admonishment ",
        " admonition "              => " admonition ",
        " admonitory "              => " admonishing ",
        " adobe "                   => " adobe ",
        " adolescence "             => " boyhood ",
        " adolescent "              => " boyish ",
        " adopt "                   => " accept ",
        " adopted "                 => " adopted ",
        " adopting "                => " adopting ",
        " adoption "                => " acceptance ",
        " adorable "                => " ambrosial ",
        " adorableness "            => " adorableness ",
        " adoration "               => " admiration ",
        " adore "                   => " admire ",
        " adored "                  => " adored ",
        " adoring "                 => " adherent ",
        " adorn "                   => " beautify ",
        " adorned "                 => " adorned ",
        " adorning "                => " adorning ",
        " adornment "               => " beautification ",
        " adrift "                  => " afloat ",
        " adroit "                  => " able ",
        " adroitness "              => " adeptness ",
        " adulate "                 => " adulate ",
        " adulation "               => " applause ",
        " adulator "                => " adulator ",
        " adulatory "               => " adulatory ",
        " adult "                   => " developed ",
        " adulterant "              => " admixture ",
        " adulterate "              => " attenuated ",
        " adulterated "             => " adulterated ",
        " adulteration "            => " admixture ",
        " adulterine "              => " adulterine ",
        " adulterous "              => " cheating ",
        " adultery "                => " affair ",
        " adulthood "               => " adolescence ",
        " adultness "               => " adultness ",
        " adumbrate "               => " adumbrate ",
        " adumbrated "              => " adumbrated ",
        " adumbration "             => " adumbration ",
        " adumbrative "             => " adumbrative ",
        " adusk "                   => " adusk ",
        " advance "                 => " beforehand ",
        " advanced "                => " avant-garde ",
        " advancement "             => " advance ",
        " advancing "               => " advancing ",
        " advantaged "              => " advantaged ",
        " advantageous "            => " advantageous ",
        " advantageously "          => " advantageously ",
        " advantageousness "        => " advantage ",
        " advent "                  => " appearance ",
        " adventitious "            => " adventitious ",
        " adventure "               => " chance ",
        " adventurer "              => " charlatan ",
        " adventures "              => " adventures ",
        " adventuresome "           => " adventuresome ",
        " adventuresomeness "       => " adventuresomeness ",
        " adventurous "             => " adventuresome ",
        " adventurousness "         => " adventurousness ",
        " adversary "               => " antagonist ",
        " adversely "               => " abnormally ",
        " adversity "               => " affliction ",
        " advertence "              => " advertence ",
        " advertent "               => " advertent ",
        " advertise "               => " acquaint ",
        " advertiser "              => " advertiser ",
        " advertising "             => " announcement ",
        " advice "                  => " admonition ",
        " advisability "            => " advantage ",
        " advisable "               => " appropriate ",
        " advise "                  => " admonish ",
        " advised "                 => " brash ",
        " advisedly "               => " carefully ",
        " advisement "              => " admonition ",
        " adviser "                 => " adviser ",
        " advisers "                => " admiral ",
        " advising "                => " advising ",
        " advisor "                 => " adviser ",
        " advisors "                => " admiral ",
        " advisory "                => " advising ",
        " advocacy "                => " advancement ",
        " advocate "                => " apostle ",
        " aegis "                   => " advocacy ",
        " aeon "                    => " aeon ",
        " aerate "                  => " aerate ",
        " aerated "                 => " aerated ",
        " aerial "                  => " aeriform ",
        " aerialist "               => " aerialist ",
        " aeriform "                => " aeriform ",
        " aerify "                  => " aerate ",
        " aerobatics "              => " aerobatics ",
        " aerodrome "               => " aerodrome ",
        " aerodynamics "            => " aerodynamics ",
        " aeroembolism "            => " aeroembolism ",
        " aeronautical "            => " aeriform ",
        " aeronautics "             => " aerodynamics ",
        " aeroplane "               => " aeroplane ",
        " aesthete "                => " adept ",
        " aesthetic "               => " artful ",
        " aestheticism "            => " advancement ",
        " aesthetics "              => " aesthetics ",
        " afar "                    => " distant ",
        " affability "              => " affability ",
        " affable "                 => " amiable ",
        " affably "                 => " affably ",
        " affair "                  => " activity ",
        " affaire "                 => " affaire ",
        " affairs "                 => " diplomacy ",
        " affectable "              => " affectable ",
        " affected "                => " afflicted ",
        " affectedness "            => " affectedness ",
        " affectibility "           => " acuteness ",
        " affecting "               => " affecting ",
        " affectingly "             => " acutely ",
        " affection "               => " amore ",
        " affectionately "          => " affectionately ",
        " affections "              => " angel ",
        " affective "               => " melancholia ",
        " affectivity "             => " affect ",
        " affiance "                => " affiance ",
        " affianced "               => " affianced ",
        " affiancing "              => " affiancing ",
        " affiche "                 => " advertisement ",
        " affidavit "               => " affirmation ",
        " affiliate "               => " associate ",
        " affiliated "              => " affiliated ",
        " affiliation "             => " amalgamation ",
        " affinity "                => " affection ",
        " affirm "                  => " assert ",
        " affirmative "             => " acknowledging ",
        " affirmatively "           => " affably ",
        " affirmatory "             => " acknowledging ",
        " affirmed "                => " affirmed ",
        " affirming "               => " acknowledging ",
        " affixed "                 => " added ",
        " affixing "                => " accession ",
        " afflatus "                => " afflatus ",
        " afflication "             => " afflication ",
        " afflict "                 => " agonize ",
        " afflicted "               => " afflicted ",
        " afflicting "              => " afflicting ",
        " affliction "              => " adversity ",
        " afflictive "              => " afflictive ",
        " affluence "               => " affluence ",
        " affluent "                => " flush ",
        " afford "                  => " allow ",
        " affranchise "             => " affranchise ",
        " affranchisement "         => " accomplishment ",
        " affray "                  => " affray ",
        " affricate "               => " affricate ",
        " affright "                => " abash ",
        " affrighted "              => " abashed ",
        " affront "                 => " abuse ",
        " affronted "               => " affronted ",
        " aficionado "              => " aficionado ",
        " afield "                  => " afield ",
        " afire "                   => " afire ",
        " aflame "                  => " afire ",
        " afloat "                  => " afloat ",
        " aflush "                  => " aflush ",
        " aflutter "                => " aflutter ",
        " afoot "                   => " accepted ",
        " afore "                   => " afore ",
        " aforeknown "              => " above-mentioned ",
        " aforementioned "          => " above ",
        " aforesaid "               => " above ",
        " aforestated "             => " above ",
        " aforetime "               => " afore ",
        " afoul "                   => " afield ",
        " afraid "                  => " abashed ",
        " afresh "                  => " again ",
        " after "                   => " afterwards ",
        " after-effects "           => " after-effects ",
        " aftereffect "             => " aftereffect ",
        " afterglow "               => " afterglow ",
        " afterimage "              => " afterimage ",
        " afterlife "               => " afterlife ",
        " afterlight "              => " afterlight ",
        " aftermath "               => " after-effects ",
        " aftermost "               => " aftermost ",
        " afterpiece "              => " afterpiece ",
        " aftertaste "              => " aftereffect ",
        " afterthought "            => " reconsideration ",
        " aftertime "               => " aftertime ",
        " afterward "               => " after ",
        " afterwards "              => " afterwards ",
        " afterwhile "              => " after ",
        " again "                   => " afresh ",
        " against "                 => " adjoin ",
        " agape "                   => " afraid ",
        " age-old "                 => " age-old ",
        " aged "                    => " age-old ",
        " agee "                    => " agee ",
        " ageism "                  => " ageism ",
        " ageless "                 => " abiding ",
        " agency "                  => " bureau ",
        " agenda "                  => " calendar ",
        " agendum "                 => " agenda ",
        " agent "                   => " abettor ",
        " agents "                  => " agents ",
        " ages "                    => " ages ",
        " agglomerate "             => " accrue ",
        " agglomeration "           => " accession ",
        " agglutinant "             => " adhering ",
        " agglutinate "             => " agglutinate ",
        " agglutination "           => " abutment ",
        " agglutinative "           => " adhesive ",
        " aggrandize "              => " acclaim ",
        " aggrandized "             => " aggrandized ",
        " aggrandizement "          => " accession ",
        " aggravating "             => " aggravating ",
        " aggravation "             => " affliction ",
        " aggregate "               => " accumulated ",
        " aggregating "             => " accumulation ",
        " aggregation "             => " accession ",
        " aggress "                 => " advance ",
        " aggression "              => " assailment ",
        " aggressive "              => " advancing ",
        " aggressiveness "          => " aggressiveness ",
        " aggressor "               => " aggressor ",
        " aggrieve "                => " afflict ",
        " aggrieved "               => " afflicted ",
        " aggro "                   => " aggro ",
        " aghast "                  => " afraid ",
        " agile "                   => " active ",
        " agilely "                 => " agilely ",
        " agility "                 => " activity ",
        " agin "                    => " adverse ",
        " aging "                   => " crumbling ",
        " agitable "                => " agitable ",
        " agitate "                 => " beat ",
        " agitated "                => " agitated ",
        " agitating "               => " agitating ",
        " agitation "               => " agitation ",
        " agitative "               => " agitative ",
        " agitator "                => " advocate ",
        " agitprop "                => " advertising ",
        " agleam "                  => " agleam ",
        " aglow "                   => " aflame ",
        " agnate "                  => " affiliated ",
        " agnostic "                => " doubter ",
        " agog "                    => " afraid ",
        " agonize "                 => " afflict ",
        " agonized "                => " aching ",
        " agonizing "               => " disturbing ",
        " agonizingly "             => " agonizingly ",
        " agony "                   => " affliction ",
        " agree "                   => " accede ",
        " agreeability "            => " affability ",
        " agreeable "               => " acceptable ",
        " agreeableness "           => " affability ",
        " agreeably "               => " affably ",
        " agreed "                  => " agreed ",
        " agreeing "                => " accordant ",
        " agreement "               => " acceding ",
        " agrestal "                => " agrarian ",
        " agricultural "            => " agronomical ",
        " agriculturalist "         => " agriculturalist ",
        " agriculture "             => " agronomics ",
        " agriculturist "           => " agriculturist ",
        " agronomical "             => " agronomical ",
        " agronomics "              => " agronomics ",
        " agronomist "              => " agriculturalist ",
        " agronomy "                => " agronomics ",
        " aground "                 => " ashore ",
        " ahead "                   => " advanced ",
        " aholic "                  => " aholic ",
        " aide "                    => " abettor ",
        " aiding "                  => " acceptable ",
        " aigrette "                => " aigrette ",
        " aiguille "                => " aiguille ",
        " aimless "                 => " accidental ",
        " air-condition "           => " aerate ",
        " air-conditioned "         => " air-conditioned ",
        " airborne "                => " aerial ",
        " airdrome "                => " aerodrome ",
        " airedale "                => " airedale ",
        " airfield "                => " aerodrome ",
        " airhead "                 => " airhead ",
        " airheaded "               => " absorbed ",
        " airheadedness "           => " airheadedness ",
        " airily "                  => " agilely ",
        " airiness "                => " airiness ",
        " airish "                  => " airish ",
        " airless "                 => " airless ",
        " airliner "                => " aeroplane ",
        " airmanship "              => " aerodynamics ",
        " airplane "                => " aeroplane ",
        " airs "                    => " affectedness ",
        " airship "                 => " aeroplane ",
        " airstrip "                => " aerodrome ",
        " airtight "                => " closed ",
        " airy "                    => " aerial ",
        " aisle "                   => " alley ",
        " ajar "                    => " open ",
        " akin "                    => " affiliated ",
        " alabaster "               => " alabaster ",
        " alacritous "              => " accelerated ",
        " alacrity "                => " alertness ",
        " alarm "                   => " anxiety ",
        " alarmable "               => " agitable ",
        " alarmed "                 => " abashed ",
        " alarming "                => " alarming ",
        " alarmingly "              => " alarmingly ",
        " alarmist "                => " alarmist ",
        " alarum "                  => " alarum ",
        " albatross "               => " accountability ",
        " albeit "                  => " admitting ",
        " albino "                  => " albino ",
        " album "                   => " anthology ",
        " alcazar "                 => " alcazar ",
        " alchemical "              => " actinic ",
        " alchemistic "             => " abstruse ",
        " alchemy "                 => " abracadabra ",
        " alcohol "                 => " booze ",
        " alcove "                  => " anteroom ",
        " alderman "                => " administrator ",
        " aldermanic "              => " aldermanic ",
        " alee "                    => " ahead ",
        " alehouse "                => " alehouse ",
        " alembic "                 => " alembic ",
        " alert "                   => " active ",
        " alertness "               => " activity ",
        " alfresco "                => " alfresco ",
        " algae "                   => " algae ",
        " algebraic "               => " algebraic ",
        " algid "                   => " algid ",
        " algidity "                => " algidity ",
        " algor "                   => " algidity ",
        " algorithmic "             => " algebraic ",
        " alibi "                   => " account ",
        " alien "                   => " conflicting ",
        " alienated "               => " alienated ",
        " alienation "              => " breach ",
        " alight "                  => " afire ",
        " alighting "               => " accession ",
        " align "                   => " adjust ",
        " aligned "                 => " accumbent ",
        " aligning "                => " adjustment ",
        " alignment "               => " alignment ",
        " alike "                   => " akin ",
        " alikeness "               => " alikeness ",
        " aliment "                 => " aliment ",
        " alimental "               => " alimental ",
        " alimentary "              => " comestible ",
        " alimentation "            => " alimentation ",
        " alimentative "            => " alimentative ",
        " alimony "                 => " keep ",
        " alive "                   => " animate ",
        " aliveness "               => " acquaintance ",
        " alkali "                  => " acrid ",
        " alkaline "                => " acrid ",
        " all-a-quiver "            => " all-a-quiver ",
        " all-around "              => " all-around ",
        " all-comprehensive "       => " all-comprehensive ",
        " all-consuming "           => " all-consuming ",
        " all-embracing "           => " all-embracing ",
        " all-encompassing "        => " all-embracing ",
        " all-fired "               => " absolute ",
        " all-inclusive "           => " all-embracing ",
        " all-knowing "             => " all-knowing ",
        " all-out "                 => " absolute ",
        " all-over "                => " all-over ",
        " all-overs "               => " all-overs ",
        " all-pervading "           => " all-comprehensive ",
        " all-powerful "            => " absolute ",
        " all-purpose "             => " advantageous ",
        " all-seeing "              => " all-knowing ",
        " all-time "                => " best ",
        " allay "                   => " abate ",
        " allaying "                => " abating ",
        " allayment "               => " abatement ",
        " allegation "              => " accusation ",
        " allege "                  => " adduce ",
        " alleged "                 => " declared ",
        " allegedly "               => " allegedly ",
        " allegiance "              => " adherence ",
        " allegiant "               => " allegiant ",
        " allegorical "             => " emblematic ",
        " allegorize "              => " allegorize ",
        " allegory "                => " apologue ",
        " allergy "                 => " abhorrence ",
        " alleviate "               => " allay ",
        " alleviating "             => " abating ",
        " alleviation "             => " advancement ",
        " alleviative "             => " alleviative ",
        " alley "                   => " alleyway ",
        " alleyway "                => " alleyway ",
        " alliance "                => " accord ",
        " allied "                  => " affiliated ",
        " allineate "               => " adjust ",
        " alliteration "            => " adumbration ",
        " alliterative "            => " alliterative ",
        " allness "                 => " absoluteness ",
        " allocate "                => " admeasure ",
        " allocation "              => " allocation ",
        " allocution "              => " address ",
        " allonym "                 => " alias ",
        " allot "                   => " admeasure ",
        " allotment "               => " allocation ",
        " allotting "               => " allocation ",
        " allover "                 => " accepted ",
        " allow "                   => " acquiesce ",
        " allowable "               => " acceptable ",
        " allowances "              => " allowances ",
        " allowed "                 => " accustomed ",
        " allowing "                => " acceptance ",
        " alloy "                   => " admixture ",
        " alloyed "                 => " adulterated ",
        " allure "                  => " attraction ",
        " allurement "              => " allure ",
        " alluring "                => " adorable ",
        " alluringly "              => " alluringly ",
        " allusive "                => " allusive ",
        " alluvial "                => " alluvial ",
        " alluvion "                => " accident ",
        " alluvium "                => " alluvium ",
        " ally "                    => " accessory ",
        " almanac "                 => " annual ",
        " almighty "                => " absolute ",
        " almost "                  => " about ",
        " alms "                    => " alms ",
        " alms-giving "             => " alms ",
        " almsman "                 => " almsman ",
        " aloft "                   => " aloft ",
        " alone "                   => " abandoned ",
        " aloneness "               => " aloneness ",
        " along "                   => " forth ",
        " aloof "                   => " above ",
        " aloofness "               => " absorption ",
        " alphabetize "             => " index ",
        " alpine "                  => " aerial ",
        " also "                    => " additionally ",
        " altar "                   => " chantry ",
        " alter "                   => " adapt ",
        " alterable "               => " adjustable ",
        " alteration "              => " about-face ",
        " altercate "               => " altercate ",
        " altercation "             => " argument ",
        " altered "                 => " adapted ",
        " altering "                => " altering ",
        " alterity "                => " alterity ",
        " alternate "               => " alternating ",
        " alternating "             => " alternating ",
        " alternation "             => " alternation ",
        " alternative "             => " another ",
        " altitude "                => " distance ",
        " altitudinous "            => " aerial ",
        " altruism "                => " altruism ",
        " alum "                    => " alum ",
        " alumna "                  => " alum ",
        " alumnus "                 => " alum ",
        " alveolate "               => " alveolate ",
        " always "                  => " consistently ",
        " amalgam "                 => " admixture ",
        " amalgamate "              => " admix ",
        " amalgamated "             => " affiliated ",
        " amalgamation "            => " amalgamation ",
        " amanuensis "              => " agent ",
        " amaranthine "             => " amaranthine ",
        " amaroidal "               => " absinthian ",
        " amass "                   => " aggregate ",
        " amassed "                 => " accumulated ",
        " amassing "                => " accession ",
        " amassment "               => " accession ",
        " amateur "                 => " abecedarian ",
        " amateurishness "          => " amateurishness ",
        " amative "                 => " amative ",
        " amatory "                 => " admiring ",
        " amaurosis "               => " amaurosis ",
        " amaze "                   => " affect ",
        " amazed "                  => " afraid ",
        " amazement "               => " admiration ",
        " amazon "                  => " amazon ",
        " ambagious "               => " ambagious ",
        " ambassador "              => " agent ",
        " ambiance "                => " ambiance ",
        " ambidexterity "           => " ambidexterity ",
        " ambidextrous "            => " ambidextrous ",
        " ambidextrousness "        => " ambidexterity ",
        " ambience "                => " ambient ",
        " ambient "                 => " ambient ",
        " ambiguous "               => " cryptic ",
        " ambit "                   => " abuttals ",
        " ambition "                => " appetite ",
        " ambitious "               => " aggressive ",
        " ambivalence "             => " ambiguity ",
        " ambivalent "              => " clashing ",
        " amble "                   => " ankle ",
        " ambler "                  => " ambler ",
        " ambrosia "                => " ambrosia ",
        " ambrosial "               => " ambrosial ",
        " ambulant "                => " ambulant ",
        " ambulation "              => " airing ",
        " ambulatory "              => " ambulant ",
        " ambuscade "               => " ambuscade ",
        " ambush "                  => " ambuscade ",
        " ambushment "              => " ambuscade ",
        " ameliorate "              => " alleviate ",
        " amelioration "            => " advancement ",
        " ameliorative "            => " ameliorative ",
        " amen "                    => " abbey ",
        " amenability "             => " acquiescence ",
        " amenable "                => " acquiescent ",
        " amenableness "            => " accountability ",
        " amend "                   => " alter ",
        " amende "                  => " atonement ",
        " amended "                 => " adapted ",
        " amending "                => " alteration ",
        " amendment "               => " alteration ",
        " amends "                  => " apology ",
        " amenity "                 => " advantage ",
        " amentia "                 => " amentia ",
        " amerce "                  => " alienate ",
        " amercement "              => " amende ",
        " amethyst "                => " amethyst ",
        " amiability "              => " affability ",
        " amiable "                 => " affable ",
        " amiably "                 => " affably ",
        " amicability "             => " accord ",
        " amicable "                => " accordant ",
        " amicableness "            => " amicableness ",
        " amicably "                => " affably ",
        " amid "                    => " amidst ",
        " amidst "                  => " amidst ",
        " amigo "                   => " accompaniment ",
        " amiss "                   => " awry ",
        " amity "                   => " amicableness ",
        " ammo "                    => " ammo ",
        " ammunition "              => " armament ",
        " amnemonic "               => " absent ",
        " amnesia "                 => " absent-mindedness ",
        " amnesic "                 => " absent ",
        " amnesty "                 => " absolution ",
        " amnion "                  => " amnion ",
        " amoeba "                  => " amoeba ",
        " amoebic "                 => " amoebic ",
        " among "                   => " amid ",
        " amongst "                 => " amidst ",
        " amoral "                  => " amoral ",
        " amore "                   => " admiration ",
        " amoroso "                 => " amoroso ",
        " amorous "                 => " amative ",
        " amorousness "             => " adulation ",
        " amorphic "                => " abnormal ",
        " amorphous "               => " baggy ",
        " amortization "            => " acquittal ",
        " amount "                  => " bulk ",
        " amour "                   => " affair ",
        " amphibian "               => " amphibian ",
        " amphibiology "            => " ambiguity ",
        " amphibious "              => " amphibian ",
        " amphibological "          => " ambiguous ",
        " amphibology "             => " ambiguity ",
        " amphitheater "            => " amphitheater ",
        " amphitheatre "            => " amphitheatre ",
        " amphora "                 => " amphora ",
        " ample "                   => " abounding ",
        " ampleness "               => " affluence ",
        " amplification "           => " addition ",
        " amplified "               => " amplified ",
        " amplitude "               => " amplitude ",
        " amply "                   => " abundantly ",
        " ampulla "                 => " alembic ",
        " amulet "                  => " amulet ",
        " amuse "                   => " charm ",
        " amusement "               => " action ",
        " amusing "                 => " agreeable ",
        " anabasis "                => " advance ",
        " anachronistic "           => " anachronistic ",
        " anachronous "             => " anachronous ",
        " anaesthesia "             => " amazement ",
        " analecta "                => " album ",
        " analeptic "               => " abating ",
        " analgesic "               => " analgesic ",
        " analogize "               => " adduce ",
        " analogizing "             => " allegory ",
        " analogous "               => " akin ",
        " analogously "             => " analogously ",
        " analogousness "           => " affinity ",
        " analogue "                => " alternation ",
        " analogy "                 => " affinity ",
        " analysis "                => " assay ",
        " analytic "                => " analytic ",
        " analytical "              => " analytic ",
        " analyze "                 => " assay ",
        " analyzer "                => " analyzer ",
        " analyzing "               => " allegory ",
        " anamnesis "               => " anamnesis ",
        " anamorphosis "            => " anamorphosis ",
        " ananym "                  => " alias ",
        " anapestic "               => " anapestic ",
        " anaphora "                => " adumbration ",
        " anaplasty "               => " anaplasty ",
        " anarchic "                => " anarchic ",
        " anarchical "              => " anarchical ",
        " anarchism "               => " agitation ",
        " anarchist "               => " agitator ",
        " anarchistic "             => " anarchic ",
        " anarchy "                 => " chaos ",
        " anathema "                => " abomination ",
        " anathematize "            => " abuse ",
        " anathematized "           => " accursed ",
        " anatomic "                => " anatomic ",
        " anatomical "              => " anatomical ",
        " anatomization "           => " anatomization ",
        " anatomize "               => " anatomize ",
        " anatomy "                 => " analysis ",
        " ancestor "                => " antecedent ",
        " ancestors "               => " ancestors ",
        " ancestral "               => " affiliated ",
        " ancestry "                => " ancestor ",
        " anchor "                  => " ballast ",
        " anchorage "               => " anchorage ",
        " anchored "                => " anchored ",
        " anchoress "               => " anchoress ",
        " anchoret "                => " anchoress ",
        " anchorite "               => " anchoress ",
        " anchorman "               => " anchorman ",
        " anchorperson "            => " anchorperson ",
        " anchorwoman "             => " anchorman ",
        " ancient "                 => " age-old ",
        " anciently "               => " aforetime ",
        " ancillary "               => " accessory ",
        " anecdotal "               => " anecdotal ",
        " anecdote "                => " chestnut ",
        " anecdotic "               => " anecdotic ",
        " anemic "                  => " bloodless ",
        " anesthetic "              => " analgesic ",
        " anesthetized "            => " anesthetized ",
        " anew "                    => " afresh ",
        " anfractuous "             => " agee ",
        " angary "                  => " angary ",
        " angelic "                 => " adorable ",
        " angelus "                 => " angelus ",
        " anger "                   => " acrimony ",
        " angered "                 => " angered ",
        " angishore "               => " angishore ",
        " angle "                   => " bend ",
        " angled "                  => " angled ",
        " angries "                 => " adversary ",
        " angrily "                 => " angrily ",
        " angry "                   => " affronted ",
        " angst "                   => " all-overs ",
        " anguish "                 => " affliction ",
        " anguished "               => " afflicted ",
        " anhydrate "               => " anhydrate ",
        " anhydrous "               => " anhydrous ",
        " anile "                   => " aged ",
        " anima "                   => " anima ",
        " animadversion "           => " abuse ",
        " animadvert "              => " abuse ",
        " animal "                  => " beastly ",
        " animalism "               => " abandon ",
        " animalistic "             => " animal ",
        " animate "                 => " breathing ",
        " animated "                => " activated ",
        " animatedly "              => " agilely ",
        " animating "               => " activation ",
        " animation "               => " action ",
        " animative "               => " animating ",
        " animosity "               => " acrimony ",
        " animus "                  => " acrimony ",
        " ankle "                   => " abate ",
        " anklet "                  => " adornment ",
        " annal "                   => " account ",
        " annals "                  => " account ",
        " anneal "                  => " amalgamate ",
        " annealed "                => " annealed ",
        " annex "                   => " addendum ",
        " annexation "              => " addition ",
        " annexing "                => " addition ",
        " annihilate "              => " abate ",
        " annihilation "            => " abolishment ",
        " annihilative "            => " annihilative ",
        " anniversary "             => " ceremony ",
        " annotate "                => " comment ",
        " annotation "              => " comment ",
        " annotative "              => " allegorical ",
        " annotator "               => " analyst ",
        " announce "                => " advertise ",
        " announced "               => " appear ",
        " announcement "            => " advertisement ",
        " announcer "               => " anchorperson ",
        " announcing "              => " announcement ",
        " annoy "                   => " abrade ",
        " annoyance "               => " acrimony ",
        " annoyed "                 => " affronted ",
        " annoyer "                 => " annoyer ",
        " annoying "                => " annoying ",
        " annual "                  => " anniversary ",
        " annuity "                 => " accomplishment ",
        " annul "                   => " abate ",
        " annular "                 => " annular ",
        " annulled "                => " annulled ",
        " annulling "               => " abrogating ",
        " annulment "               => " abatement ",
        " annunciate "              => " advertise ",
        " anodyne "                 => " analgesic ",
        " anoint "                  => " bless ",
        " anointed "                => " all-powerful ",
        " anomalism "               => " aberancy ",
        " anomalistic "             => " aberrant ",
        " anomalous "               => " aberrant ",
        " anomaly "                 => " aberration ",
        " anon "                    => " afresh ",
        " anonymous "               => " bearding ",
        " anopsia "                 => " amaurosis ",
        " anorak "                  => " anorak ",
        " another "                 => " addition ",
        " anschluss "               => " affiliation ",
        " answer "                  => " acknowledgment ",
        " answerability "           => " accountability ",
        " answerable "              => " accountable ",
        " antacid "                 => " acrid ",
        " antagonism "              => " animosity ",
        " antagonist "              => " adversary ",
        " antagonistic "            => " afraid ",
        " antagonistically "        => " abnormally ",
        " antagonization "          => " alienation ",
        " antagonize "              => " alienate ",
        " antagonized "             => " affronted ",
        " antagonizer "             => " annoyer ",
        " antecedence "             => " antecedence ",
        " antecedent "              => " anterior ",
        " antecedently "            => " advanced ",
        " antecedents "             => " antecedents ",
        " antecessor "              => " antecedent ",
        " antechamber "             => " alcove ",
        " antedate "                => " accelerate ",
        " antediluvian "            => " age-old ",
        " anteposition "            => " antecedence ",
        " anterior "                => " antecedent ",
        " anteriorly "              => " afore ",
        " anteroom "                => " anteroom ",
        " anthem "                  => " canticle ",
        " anthologize "             => " abridge ",
        " anthologized "            => " anthologized ",
        " anthology "               => " album ",
        " anthrophagite "           => " aborigine ",
        " anthropoid "              => " animal ",
        " anthropological "         => " animal ",
        " anthropomorphic "         => " animal ",
        " anthropophaginian "       => " aborigine ",
        " anthropophagus "          => " aborigine ",
        " antibacterial "           => " antibacterial ",
        " antibiotic "              => " antibacterial ",
        " antibody "                => " antibiotic ",
        " antic "                   => " caper ",
        " anticipate "              => " ahead ",
        " anticipated "             => " advancing ",
        " anticipation "            => " apprehension ",
        " anticipative "            => " advanced ",
        " anticipatory "            => " advanced ",
        " anticlimactic "           => " abortive ",
        " anticlimax "              => " bathos ",
        " antidotal "               => " antidotal ",
        " antidote "                => " antitoxin ",
        " antinomy "                => " action ",
        " antiodontalgic "          => " analgesic ",
        " antipasto "               => " antipasto ",
        " antipathetic "            => " advancing ",
        " antipathy "               => " abhorrence ",
        " antiphon "                => " acknowledgment ",
        " antipodal "               => " adverse ",
        " antipode "                => " antipode ",
        " antipodean "              => " adverse ",
        " antipoison "              => " antibiotic ",
        " antipole "                => " antipode ",
        " antiquarian "             => " antique ",
        " antiquated "              => " aged ",
        " antique "                 => " aged ",
        " antiquity "               => " antique ",
        " antiseptic "              => " antibacterial ",
        " antisepticize "           => " antisepticize ",
        " antiserum "               => " antibiotic ",
        " antisocial "              => " alienated ",
        " antistrophe "             => " adumbration ",
        " antithesis "              => " antipode ",
        " antithetic "              => " adverse ",
        " antithetical "            => " adverse ",
        " antithetically "          => " abnormally ",
        " antitoxin "               => " antibiotic ",
        " antivenin "               => " antitoxin ",
        " antonym "                 => " antithesis ",
        " antonymous "              => " antithetical ",
        " ants "                    => " all-overs ",
        " antsy "                   => " afraid ",
        " anxiety "                 => " all-overs ",
        " anxious "                 => " afraid ",
        " anxiously "               => " anxiously ",
        " anxiousness "             => " agitation ",
        " anyhow "                  => " about ",
        " anything "                => " annihilation ",
        " anyway "                  => " anyhow ",
        " apache "                  => " apache ",
        " apart "                   => " afar ",
        " apartheid "               => " ageism ",
        " apartment "               => " accommodation ",
        " apathetic "               => " blah ",
        " apathy "                  => " aloofness ",
        " apercu "                  => " abstract ",
        " aperitif "                => " antipasto ",
        " aperitive "               => " aperitive ",
        " aperture "                => " breach ",
        " apery "                   => " apery ",
        " apex "                    => " acme ",
        " aphasiac "                => " aphasiac ",
        " aphasic "                 => " aphasiac ",
        " aphonic "                 => " aphasiac ",
        " aphorism "                => " adage ",
        " aphoristic "              => " absolute ",
        " aphotic "                 => " aphotic ",
        " aphrodisia "              => " aphrodisia ",
        " aphrodisiac "             => " amative ",
        " apical "                  => " aciculate ",
        " aping "                   => " apery ",
        " apish "                   => " apish ",
        " aplenty "                 => " ample ",
        " aplomb "                  => " aggressiveness ",
        " apocalypse "              => " apocalypse ",
        " apocalyptic "             => " apocalyptic ",
        " apocryphal "              => " counterfeit ",
        " apodeictic "              => " accurate ",
        " apodictic "               => " acceptable ",
        " apogee "                  => " apogee ",
        " apologetic "              => " atoning ",
        " apologetics "             => " answer ",
        " apologia "                => " answer ",
        " apologies "               => " affliction ",
        " apologizing "             => " answer ",
        " apologue "                => " apologue ",
        " apology "                 => " acknowledgment ",
        " apophthegm "              => " aphorism ",
        " apophthegmatic "          => " absolute ",
        " apoplectic "              => " apoplectic ",
        " apoplexy "                => " occlusion ",
        " aporetic "                => " aporetic ",
        " aposiopesis "             => " adumbration ",
        " apostasy "                => " alienation ",
        " apostate "                => " backslider ",
        " apostatize "              => " abandon ",
        " apostle "                 => " advocate ",
        " apostrophe "              => " apostrophe ",
        " apothegm "                => " adage ",
        " apotheosis "              => " advance ",
        " apotheosize "             => " apotheosize ",
        " appal "                   => " alarm ",
        " appall "                  => " alarm ",
        " appalled "                => " afraid ",
        " appalling "               => " alarming ",
        " appanage "                => " advantage ",
        " apparatus "               => " accoutrement ",
        " apparel "                 => " accoutrement ",
        " apparent "                => " credible ",
        " apparently "              => " allegedly ",
        " apparition "              => " bogeyman ",
        " apparitional "            => " apparitional ",
        " appeal "                  => " address ",
        " appealing "               => " ambrosial ",
        " appealingly "             => " alluringly ",
        " appear "                  => " arise ",
        " appearance "              => " actualization ",
        " appearing "               => " actualization ",
        " appease "                 => " allay ",
        " appeased "                => " agreeable ",
        " appeasement "             => " abatement ",
        " appeaser "                => " appeaser ",
        " appeasing "               => " appeasing ",
        " appellant "               => " appellant ",
        " appellation "             => " appellation ",
        " appellative "             => " appellation ",
        " append "                  => " adjoin ",
        " appendage "               => " addendum ",
        " appended "                => " added ",
        " appendix "                => " addendum ",
        " apperceive "              => " apperceive ",
        " apperception "            => " apperception ",
        " apperceptive "            => " acquainted ",
        " appertain "               => " apply ",
        " appetence "               => " appetence ",
        " appetency "               => " appetence ",
        " appetent "                => " acquisitive ",
        " appetite "                => " appetence ",
        " appetition "              => " appetence ",
        " appetizing "              => " aperitive ",
        " applaud "                 => " acclaim ",
        " applauded "               => " acclaimed ",
        " applause "                => " acclaim ",
        " apple "                   => " angel ",
        " apple-polish "            => " apple-polish ",
        " apple-polishing "         => " abject ",
        " applesauce "              => " applesauce ",
        " appliance "               => " apparatus ",
        " appliances "              => " accessories ",
        " applicability "           => " account ",
        " applicable "              => " applicative ",
        " applicant "               => " appellant ",
        " application "             => " appliance ",
        " applicative "             => " applicative ",
        " applicatory "             => " applicative ",
        " applied "                 => " activated ",
        " applique "                => " applique ",
        " apply "                   => " administer ",
        " appoint "                 => " accredit ",
        " appointed "               => " appointed ",
        " appointee "               => " appointee ",
        " appointment "             => " arrangement ",
        " appointments "            => " accessories ",
        " apportion "               => " accord ",
        " apportioned "             => " apportioned ",
        " apportioning "            => " appointment ",
        " apportionment "           => " agreement ",
        " apposite "                => " applicative ",
        " appositeness "            => " appliance ",
        " apposition "              => " accord ",
        " appraisal "               => " appraisement ",
        " appraise "                => " adjudge ",
        " appraised "               => " acquainted ",
        " appraisement "            => " appraisement ",
        " appraiser "               => " adjudicator ",
        " appreciable "             => " apparent ",
        " appreciably "             => " appreciably ",
        " appreciate "              => " acknowledge ",
        " appreciated "             => " accepted ",
        " appreciating "            => " affectionate ",
        " appreciation "            => " acknowledgment ",
        " appreciative "            => " beholden ",
        " appreciativeness "        => " acknowledgment ",
        " appreciator "             => " adept ",
        " apprehending "            => " acumen ",
        " apprehensible "           => " apprehensible ",
        " apprehension "            => " alarm ",
        " apprehensive "            => " afraid ",
        " apprehensiveness "        => " alarm ",
        " apprentice "              => " amateur ",
        " apprenticed "             => " apprenticed ",
        " apprenticeship "          => " apprenticeship ",
        " apprise "                 => " accustom ",
        " apprised "                => " acquainted ",
        " apprize "                 => " acquaint ",
        " apprized "                => " abreast ",
        " approach "                => " access ",
        " approachable "            => " attainable ",
        " approaching "             => " abutting ",
        " approbate "               => " acknowledge ",
        " approbation "             => " admiration ",
        " approbative "             => " adulatory ",
        " approbatory "             => " adulatory ",
        " appropinquity "           => " adjacency ",
        " appropriate "             => " adapted ",
        " appropriated "            => " appointed ",
        " appropriately "           => " appropriately ",
        " appropriateness "         => " account ",
        " appropriating "           => " abduction ",
        " appropriation "           => " allotment ",
        " approve "                 => " accept ",
        " approved "                => " accustomed ",
        " approving "               => " acknowledging ",
        " approvingly "             => " agreeably ",
        " approximal "              => " abutting ",
        " approximate "             => " almost ",
        " approximately "           => " about ",
        " approximation "           => " approximation ",
        " appulse "                 => " appulse ",
        " appurtenance "            => " accent ",
        " appurtenances "           => " accouterments ",
        " appurtenant "             => " accessory ",
        " apricot "                 => " apricot ",
        " apriorism "               => " apriorism ",
        " apriority "               => " antecedent ",
        " apron "                   => " accessory ",
        " apropos "                 => " applicable ",
        " apse "                    => " alcove ",
        " aptitude "                => " bent ",
        " aptly "                   => " appropriately ",
        " aptness "                 => " adequacy ",
        " apurpose "                => " advisedly ",
        " aquake "                  => " all-a-quiver ",
        " aquatic "                 => " amphibian ",
        " aqueduct "                => " channel ",
        " aqueous "                 => " aqueous ",
        " aquiver "                 => " all-a-quiver ",
        " arabesque "               => " applique ",
        " arable "                  => " abundant ",
        " arbiter "                 => " adjudicator ",
        " arbitrament "             => " adjudication ",
        " arbitrarily "             => " arbitrarily ",
        " arbitrary "               => " approximate ",
        " arbitrate "               => " adjudge ",
        " arbitration "             => " adjudication ",
        " arbitrator "              => " adjudicator ",
        " arbor "                   => " arbor ",
        " arboretum "               => " acreage ",
        " arcade "                  => " arcade ",
        " arcane "                  => " cabalistic ",
        " arced "                   => " angled ",
        " arch "                    => " accomplished ",
        " archaeologian "           => " archaeologian ",
        " archaic "                 => " ancient ",
        " archangelic "             => " adorable ",
        " archbishop "              => " abbey ",
        " archdeacon "              => " abbot ",
        " archdiocese "             => " archdiocese ",
        " arched "                  => " angled ",
        " archenemy "               => " adversary ",
        " archetypal "              => " archetypal ",
        " archetype "               => " classic ",
        " archetypical "            => " archetypal ",
        " archilochian "            => " acerb ",
        " archimage "               => " archimage ",
        " architect "               => " artist ",
        " architectonics "          => " architectonics ",
        " architecture "            => " architectonics ",
        " archival "                => " archival ",
        " archive "                 => " annal ",
        " archives "                => " athenaeum ",
        " archness "                => " archness ",
        " archway "                 => " entrance ",
        " arciform "                => " angled ",
        " arctic "                  => " chill ",
        " ardency "                 => " activity ",
        " ardent "                  => " agog ",
        " ardently "                => " agilely ",
        " ardor "                   => " avidity ",
        " arduous "                 => " backbreaking ",
        " arduously "               => " agilely ",
        " arduousness "             => " adversity ",
        " area "                    => " breadth ",
        " arena "                   => " amphitheatre ",
        " arenaceous "              => " arenaceous ",
        " arenose "                 => " arenaceous ",
        " arete "                   => " arete ",
        " argent "                  => " ablaze ",
        " argentate "               => " argent ",
        " argil "                   => " adobe ",
        " argosy "                  => " argosy ",
        " argot "                   => " argot ",
        " arguable "                => " arguable ",
        " argue "                   => " altercate ",
        " arguer "                  => " agitator ",
        " argufy "                  => " altercate ",
        " argument "                => " altercation ",
        " argumentation "           => " argumentation ",
        " argumentative "           => " belligerent ",
        " argute "                  => " acute ",
        " aria "                    => " aria ",
        " arid "                    => " barren ",
        " aridity "                 => " altitude ",
        " arise "                   => " appear ",
        " arising "                 => " arising ",
        " aristocracy "             => " elite ",
        " aristocrat "              => " blueblood ",
        " aristocratic "            => " aloof ",
        " arithmetic "              => " addition ",
        " arm-twist "               => " allure ",
        " armada "                  => " fleet ",
        " armament "                => " ammunition ",
        " armamentarium "           => " armamentarium ",
        " armaments "               => " accoutrements ",
        " armchair "                => " armchair ",
        " armistice "               => " ceasefire ",
        " armlet "                  => " armlet ",
        " armory "                  => " arsenal ",
        " armpit "                  => " armpit ",
        " arms "                    => " accoutrements ",
        " aroma "                   => " balm ",
        " aromal "                  => " ambrosial ",
        " aromatic "                => " ambrosial ",
        " around "                  => " about ",
        " around-the-clock "        => " around-the-clock ",
        " arousal "                 => " activation ",
        " arouse "                  => " agitate ",
        " aroused "                 => " angry ",
        " arousing "                => " agitative ",
        " arraign "                 => " blame ",
        " arraignment "             => " allegation ",
        " arrange "                 => " align ",
        " arranged "                => " abiding ",
        " arrangement "             => " adjustment ",
        " arrangements "            => " arrange ",
        " arranger "                => " arranger ",
        " arranging "               => " alignment ",
        " arrant "                  => " apparent ",
        " array "                   => " arrangement ",
        " arrayal "                 => " affectation ",
        " arrect "                  => " arrect ",
        " arrestation "             => " apprehension ",
        " arrested "                => " arrested ",
        " arresting "               => " arresting ",
        " arrestive "               => " arresting ",
        " arrestment "              => " apprehension ",
        " arride "                  => " allure ",
        " arrival "                 => " accession ",
        " arrive "                  => " access ",
        " arrived "                 => " accustomed ",
        " arriver "                 => " addition ",
        " arriving "                => " accession ",
        " arrogance "               => " airs ",
        " arrogant "                => " aloof ",
        " arrogate "                => " appropriate ",
        " arrogation "              => " acceptance ",
        " arrondi "                 => " arced ",
        " arroyo "                  => " approach ",
        " arsenal "                 => " armory ",
        " arsonist "                => " agitator ",
        " art-twist "               => " alignment ",
        " artefact "                => " achievement ",
        " artery "                  => " avenue ",
        " artful "                  => " adept ",
        " artfulness "              => " artfulness ",
        " arthritic "               => " arthritic ",
        " article "                 => " commodity ",
        " articles "                => " accessories ",
        " articulacy "              => " articulacy ",
        " articular "               => " articular ",
        " articulate "              => " clear ",
        " articulated "             => " articulate ",
        " articulateness "          => " articulacy ",
        " articulation "            => " delivery ",
        " artifact "                => " antiquity ",
        " artificial "              => " bogus ",
        " artillery "               => " arms ",
        " artisan "                 => " artisan ",
        " artisanship "             => " achievement ",
        " artist "                  => " artisan ",
        " artiste "                 => " artisan ",
        " artistic "                => " aesthetic ",
        " artistry "                => " ability ",
        " artless "                 => " direct ",
        " artlessly "               => " artlessly ",
        " artlessness "             => " amateurishness ",
        " artsy "                   => " apish ",
        " artsy-craftsy "           => " apish ",
        " arty "                    => " affected ",
        " ascend "                  => " arise ",
        " ascendance "              => " ascendance ",
        " ascendancy "              => " advantage ",
        " ascendant "               => " antecedent ",
        " ascending "               => " ascendance ",
        " ascension "               => " ascent ",
        " ascent "                  => " ascendance ",
        " ascertainable "           => " apparent ",
        " ascertained "             => " absolute ",
        " ascertainment "           => " analysis ",
        " ascetic "                 => " abstinent ",
        " asceticism "              => " abnegation ",
        " ascribe "                 => " accredit ",
        " aseptic "                 => " antibacterial ",
        " aseptify "                => " alter ",
        " aseptize "                => " alter ",
        " asexualize "              => " alter ",
        " ashake "                  => " all-a-quiver ",
        " ashamed "                 => " abashed ",
        " ashen "                   => " anemic ",
        " ashes "                   => " ashes ",
        " ashore "                  => " aground ",
        " ashy "                    => " achromatic ",
        " aside "                   => " abreast ",
        " asininity "               => " asininity ",
        " askance "                 => " askance ",
        " askant "                  => " askance ",
        " askew "                   => " askance ",
        " asking "                  => " allurement ",
        " aslant "                  => " askance ",
        " asleep "                  => " comatose ",
        " aslope "                  => " alongside ",
        " asocial "                 => " alienated ",
        " asomatous "               => " aerial ",
        " aspartame "               => " aspartame ",
        " asperity "                => " acerbity ",
        " asperous "                => " acrid ",
        " asperse "                 => " admit ",
        " asperser "                => " adversary ",
        " aspersing "               => " aspersing ",
        " aspersion "               => " abuse ",
        " aspersive "               => " aspersive ",
        " asphalt "                 => " city ",
        " asphyxia "                => " amazement ",
        " asphyxiate "              => " choke ",
        " aspirant "                => " abecedarian ",
        " aspiring "                => " ambitious ",
        " ass-kisser "              => " ass-kisser ",
        " assail "                  => " abuse ",
        " assailant "               => " aggressor ",
        " assailing "               => " advancing ",
        " assailment "              => " assailment ",
        " assart "                  => " allowance ",
        " assassin "                => " apache ",
        " assassinating "           => " abolition ",
        " assault "                 => " advance ",
        " assaulter "               => " aggressor ",
        " assay "                   => " appraisal ",
        " assemblage "              => " aggregation ",
        " assemble "                => " accumulate ",
        " assembled "               => " accumulated ",
        " assembling "              => " accumulating ",
        " assembly "                => " accumulation ",
        " assemblyman "             => " agent ",
        " assent "                  => " acceptance ",
        " assenting "               => " acceding ",
        " assert "                  => " advance ",
        " assertion "               => " affirmation ",
        " assertive "               => " absolute ",
        " assertory "               => " active ",
        " asservation "             => " acceptance ",
        " assess "                  => " appraise ",
        " assessable "              => " assessable ",
        " assessed "                => " adjourned ",
        " assessment "              => " appraisal ",
        " assessor "                => " adjudicator ",
        " asseverate "              => " assert ",
        " assiduities "             => " amenity ",
        " assiduity "               => " assiduity ",
        " assiduous "               => " active ",
        " assiduously "             => " assiduously ",
        " assiduousness "           => " activity ",
        " assign "                  => " accredit ",
        " assignation "             => " affair ",
        " assigned "                => " assigned ",
        " assignee "                => " abettor ",
        " assigning "               => " allotment ",
        " assignment "              => " appointment ",
        " assimilate "              => " digest ",
        " assimilated "             => " alloyed ",
        " assimilation "            => " assimilation ",
        " assist "                  => " abetment ",
        " assistance "              => " abetment ",
        " assistant "               => " abettor ",
        " assistants "              => " administration ",
        " assisting "               => " acceptable ",
        " assistive "               => " advantageous ",
        " assize "                  => " assize ",
        " associable "              => " applicative ",
        " associate "               => " accessory ",
        " associates "              => " assembly ",
        " associating "             => " advertence ",
        " association "             => " affiliation ",
        " associative "             => " akin ",
        " assonant "                => " accordant ",
        " assort "                  => " assort ",
        " assorted "                => " different ",
        " assortment "              => " array ",
        " assuage "                 => " allay ",
        " assuagement "             => " abatement ",
        " assuaging "               => " abating ",
        " assuasive "               => " allowing ",
        " assumably "               => " assumably ",
        " assume "                  => " accept ",
        " assumed "                 => " affected ",
        " assuming "                => " bold ",
        " assumpsit "               => " accusation ",
        " assumption "              => " acceptance ",
        " assumptive "              => " academic ",
        " assurance "               => " affirmation ",
        " assuredly "               => " absolutely ",
        " assuredness "             => " aggressiveness ",
        " assuring "                => " acceptable ",
        " astern "                  => " aback ",
        " asthmatic "               => " asthmatic ",
        " astigmatic "              => " astigmatic ",
        " astigmatism "             => " amaurosis ",
        " astir "                   => " active ",
        " astonish "                => " amaze ",
        " astonished "              => " afraid ",
        " astonishing "             => " amazing ",
        " astonishment "            => " amazement ",
        " astound "                 => " astonish ",
        " astounded "               => " afraid ",
        " astounding "              => " alarming ",
        " astoundment "             => " amazement ",
        " astral "                  => " astral ",
        " astray "                  => " adrift ",
        " astrict "                 => " astrict ",
        " astriction "              => " astriction ",
        " astringe "                => " astringe ",
        " astringence "             => " acerbity ",
        " astringency "             => " acidity ",
        " astringent "              => " acid ",
        " astrochemistry "          => " astrochemistry ",
        " astrography "             => " astrochemistry ",
        " astrolithology "          => " astrochemistry ",
        " astrologer "              => " astrologer ",
        " astrological "            => " abstruse ",
        " astrology "               => " astrometry ",
        " astrometry "              => " astrometry ",
        " astronomic "              => " astronomic ",
        " astronomical "            => " ample ",
        " astronomy "               => " astrochemistry ",
        " astrophysics "            => " astrochemistry ",
        " astucious "               => " artful ",
        " astucity "                => " acumen ",
        " astute "                  => " adroit ",
        " astuteness "              => " accuracy ",
        " asudden "                 => " aback ",
        " asunder "                 => " disconnected ",
        " asylum "                  => " cover ",
        " asymmetric "              => " agee ",
        " asymmetrical "            => " absurd ",
        " asymmetrically "          => " abnormally ",
        " asymmetry "               => " aberration ",
        " asyndeton "               => " adumbration ",
        " at-home "                 => " calm ",
        " ataraxia "                => " affluence ",
        " ataraxy "                 => " aplomb ",
        " ataxia "                  => " anarchy ",
        " atelier "                 => " atelier ",
        " atheist "                 => " agnostic ",
        " atheistic "               => " agnostic ",
        " athenaeum "               => " athenaeum ",
        " athirst "                 => " ardent ",
        " athlete "                 => " amateur ",
        " athletic "                => " able-bodied ",
        " athletics "               => " contest ",
        " athrill "                 => " athrill ",
        " athwart "                 => " angular ",
        " atlas "                   => " album ",
        " atmospherics "            => " altercation ",
        " atomic "                  => " diminutive ",
        " atomization "             => " atomization ",
        " atomize "                 => " anatomize ",
        " atonal "                  => " absonant ",
        " atone "                   => " absolve ",
        " atonement "               => " amends ",
        " atonic "                  => " arthritic ",
        " atoning "                 => " atoning ",
        " atop "                    => " aloft ",
        " atrabilious "             => " abject ",
        " atramentous "             => " atramentous ",
        " atrium "                  => " atrium ",
        " atrocious "               => " awful ",
        " atrociously "             => " atrociously ",
        " atrociousness "           => " atrociousness ",
        " atrocity "                => " atrociousness ",
        " atrophied "               => " atrophied ",
        " atrophy "                 => " decline ",
        " attache "                 => " attache ",
        " attached "                => " absorbed ",
        " attaching "               => " adhering ",
        " attachment "              => " adapter ",
        " attachments "             => " accessories ",
        " attack "                  => " advance ",
        " attacker "                => " antagonist ",
        " attacking "               => " advancing ",
        " attainable "              => " accessible ",
        " attainableness "          => " achievability ",
        " attained "                => " accomplished ",
        " attainment "              => " accomplishment ",
        " attainments "             => " ability ",
        " attar "                   => " aroma ",
        " attempt "                 => " attack ",
        " attend "                  => " appear ",
        " attendance "              => " appearance ",
        " attendant "               => " accessory ",
        " attendants "              => " associates ",
        " attended "                => " abounding ",
        " attending "               => " accessory ",
        " attention "               => " absorption ",
        " attentive "               => " alert ",
        " attentively "             => " anxiously ",
        " attentiveness "           => " assiduity ",
        " attenuate "               => " abate ",
        " attenuated "              => " attenuated ",
        " attenuation "             => " abrasion ",
        " attest "                  => " adjure ",
        " attestable "              => " ascertainable ",
        " attestant "               => " attestant ",
        " attestation "             => " accession ",
        " attested "                => " accurate ",
        " attestor "                => " attestant ",
        " attire "                  => " accoutrements ",
        " attitudinizer "           => " actor ",
        " attitudinizing "          => " affectation ",
        " attorney "                => " advocate ",
        " attorney-at-law "         => " advocate ",
        " attorneys "               => " attorneys ",
        " attract "                 => " allure ",
        " attracted "               => " admiring ",
        " attracting "              => " alluring ",
        " attraction "              => " allure ",
        " attractive "              => " adorable ",
        " attractively "            => " alluringly ",
        " attractiveness "          => " affability ",
        " attribute "               => " aspect ",
        " attributes "              => " attributes ",
        " attributing "             => " advertence ",
        " attribution "             => " allegation ",
        " attrition "               => " abrasion ",
        " attritional "             => " atoning ",
        " attune "                  => " acclimatize ",
        " attunement "              => " accord ",
        " atypical "                => " aberant ",
        " atypicalness "            => " aberancy ",
        " auberge "                 => " auberge ",
        " auburn "                  => " chestnut ",
        " auction "                 => " bargain ",
        " auctioneer "              => " agent ",
        " auctioning "              => " auctioning ",
        " audacious "               => " adventurous ",
        " audaciousness "           => " adventurousness ",
        " audacity "                => " adventurousness ",
        " audible "                 => " aural ",
        " audibly "                 => " audibly ",
        " audience "                => " admirers ",
        " audio-visual "            => " acoustic ",
        " audit "                   => " analysis ",
        " audition "                => " audience ",
        " auditor "                 => " accountant ",
        " auditorium "              => " amphitheater ",
        " auditory "                => " audition ",
        " auger "                   => " auger ",
        " aught "                   => " annihilation ",
        " augmentation "            => " accession ",
        " augmented "               => " aggrandized ",
        " augmenting "              => " assiduity ",
        " augur "                   => " diviner ",
        " augural "                 => " apocalyptic ",
        " auguration "              => " anticipation ",
        " augurer "                 => " astrologer ",
        " augury "                  => " auspice ",
        " august "                  => " baronial ",
        " augustness "              => " amplitude ",
        " aura "                    => " ambience ",
        " aural "                   => " aural ",
        " aureate "                 => " aureate ",
        " aureola "                 => " aura ",
        " aureole "                 => " amphitheater ",
        " auric "                   => " aureate ",
        " auricomous "              => " albino ",
        " auricular "               => " aural ",
        " auriferous "              => " aureate ",
        " aurify "                  => " adorn ",
        " aurora "                  => " aurora ",
        " auroral "                 => " ablaze ",
        " aurous "                  => " aureate ",
        " aurulent "                => " aureate ",
        " auscult "                 => " accept ",
        " auscultate "              => " apprehend ",
        " auspex "                  => " astrologer ",
        " auspicate "               => " adumbrate ",
        " auspice "                 => " auspice ",
        " auspices "                => " advocacy ",
        " auspicious "              => " advantageous ",
        " auspiciously "            => " auspiciously ",
        " auspiciousness "          => " accommodation ",
        " austere "                 => " ascetic ",
        " austerity "               => " acerbity ",
        " austral "                 => " arid ",
        " autarchical "             => " absolute ",
        " autarchy "                => " abolition ",
        " authentic "               => " accurate ",
        " authentically "           => " absolutely ",
        " authenticate "            => " accredit ",
        " authenticated "           => " accurate ",
        " authenticating "          => " acceptance ",
        " authentication "          => " affidavit ",
        " authenticity "            => " actuality ",
        " author "                  => " columnist ",
        " authoring "               => " assembly ",
        " authoritarian "           => " absolute ",
        " authoritarianism "        => " absolutism ",
        " authoritative "           => " accurate ",
        " authoritativeness "       => " authoritativeness ",
        " authority "               => " ascendancy ",
        " authorization "           => " allotment ",
        " authorize "               => " accredit ",
        " authorized "              => " accustomed ",
        " authorizing "             => " acceding ",
        " authorship "              => " antecedent ",
        " autist "                  => " autist ",
        " auto "                    => " auto ",
        " autobiography "           => " adventures ",
        " autocade "                => " array ",
        " autochthon "              => " aborigine ",
        " autochthonous "           => " aboriginal ",
        " autoclave "               => " alter ",
        " autocracy "               => " absolution ",
        " autocrat "                => " absolutist ",
        " autocratic "              => " absolute ",
        " autogenetic "             => " autogenetic ",
        " autogenous "              => " autogenous ",
        " autography "              => " autography ",
        " automat "                 => " automat ",
        " automated "               => " automatic ",
        " automatic "               => " automated ",
        " automaton "               => " apparatus ",
        " automobile "              => " auto ",
        " autonomous "              => " free ",
        " autonomously "            => " apart ",
        " autonomy "                => " freedom ",
        " autopsy "                 => " dissection ",
        " autoroute "               => " artery ",
        " auxiliary "               => " abetting ",
        " avail "                   => " account ",
        " available "               => " accessible ",
        " avails "                  => " assets ",
        " avalanche "               => " barrage ",
        " avant-garde "             => " beat ",
        " avarice "                 => " avidity ",
        " avaricious "              => " avaricious ",
        " avariciousness "          => " acquisitiveness ",
        " avengement "              => " avengement ",
        " avenging "                => " avenging ",
        " avenue "                  => " access ",
        " aver "                    => " assert ",
        " average "                 => " boilerplate ",
        " averagely "               => " abundantly ",
        " averment "                => " accession ",
        " averse "                  => " afraid ",
        " averseness "              => " averseness ",
        " aversion "                => " abhorrence ",
        " aversive "                => " aloof ",
        " avert "                   => " avoid ",
        " averting "                => " arresting ",
        " avian "                   => " aerial ",
        " aviary "                  => " asylum ",
        " aviate "                  => " aviate ",
        " aviation "                => " aerodynamics ",
        " avid "                    => " ardent ",
        " avidity "                 => " alertness ",
        " avocation "               => " amusement ",
        " avoid "                   => " abstain ",
        " avoidable "               => " accidental ",
        " avoidance "               => " abstention ",
        " avoided "                 => " abhorred ",
        " avoiding "                => " alienated ",
        " avoirdupois "             => " adipose ",
        " avouch "                  => " assert ",
        " avow "                    => " acknowledge ",
        " avowal "                  => " acceptance ",
        " avowed "                  => " accepted ",
        " await "                   => " anticipate ",
        " awaited "                 => " accessible ",
        " awaiting "                => " apprehension ",
        " awake "                   => " alive ",
        " awaken "                  => " activate ",
        " awakened "                => " alive ",
        " awakening "               => " activation ",
        " awaking "                 => " activation ",
        " award "                   => " accolade ",
        " award-winning "           => " award-winning ",
        " awarding "                => " application ",
        " aware "                   => " acquainted ",
        " awareness "               => " acquaintance ",
        " awash "                   => " ample ",
        " away "                    => " abroad ",
        " awe-inspiring "           => " alarming ",
        " awe-struck "              => " addled ",
        " awed "                    => " addled ",
        " aweless "                 => " adventurous ",
        " awesome "                 => " alarming ",
        " awestruck "               => " afraid ",
        " awful "                   => " abominable ",
        " awfully "                 => " clumsily ",
        " awkwardly "               => " abominably ",
        " awkwardness "             => " amateurishness ",
        " awless "                  => " adventurous ",
        " awning "                  => " covering ",
        " awry "                    => " afield ",
        " axiological "             => " axiological ",
        " axiom "                   => " adage ",
        " axiomatic "               => " absolute ",
        " axis "                    => " arbor ",
        " axle "                    => " arbor ",
        " azoic "                   => " azoic ",
        " azure "                   => " azure ",
        " babble "                  => " blubbering ",
        " babbler "                 => " babbler ",
        " babe "                    => " bairn ",
        " babel "                   => " agitation ",
        " baby "                    => " babyish ",
        " baby-like "               => " baby-like ",
        " baby-sit "                => " guard ",
        " babyhood "                => " childhood ",
        " babying "                 => " allowance ",
        " babyish "                 => " baby ",
        " babyminding "             => " babyminding ",
        " babysitter "              => " aide ",
        " babysitting "             => " babyminding ",
        " bacchanalia "             => " bacchanal ",
        " bachelor "                => " available ",
        " bacilli "                 => " bacilli ",
        " bacillus "                => " bacillus ",
        " back "                    => " aback ",
        " back-bite "               => " back-bite ",
        " back-number "             => " back-number ",
        " back-slapping "           => " back-slapping ",
        " back-trail "              => " accompany ",
        " back-up "                 => " back ",
        " backbite "                => " abuse ",
        " backbiter "               => " adversary ",
        " backbiting "              => " abuse ",
        " backbone "                => " courage ",
        " backbreaker "             => " ambitious ",
        " backbreaking "            => " backbreaking ",
        " backcountry "             => " backcountry ",
        " backdown "                => " acquiescence ",
        " backdrop "                => " accomplishments ",
        " backer "                  => " advocate ",
        " backfire "                => " backlash ",
        " backflow "                => " abatement ",
        " background "              => " accomplishments ",
        " backhanded "              => " abuse ",
        " backing "                 => " abetment ",
        " backlash "                => " backfire ",
        " backlog "                 => " excess ",
        " backpack "                => " haversack ",
        " backpedal "               => " abandon ",
        " backroom "                => " backroom ",
        " backside "                => " behind ",
        " backslapper "             => " adulator ",
        " backslide "               => " abate ",
        " backslider "              => " backslider ",
        " backsliding "             => " abatement ",
        " backstab "                => " backstab ",
        " backstabber "             => " backstabber ",
        " backstabbing "            => " abuse ",
        " backstairs "              => " backdoor ",
        " backtalk "                => " animadversion ",
        " backtrack "               => " backtrack ",
        " backup "                  => " advancement ",
        " backward "                => " astern ",
        " backwardness "            => " backwardness ",
        " backwash "                => " aftermath ",
        " backwater "               => " abjure ",
        " backwoods "               => " backcountry ",
        " backwoodsman "            => " agriculturist ",
        " bacteria "                => " bacilli ",
        " bactericidal "            => " antibacterial ",
        " bactericide "             => " bactericide ",
        " bacterium "               => " bacillus ",
        " bad-humored "             => " bad-humored ",
        " bad-looking "             => " animal ",
        " bad-mannered "            => " awkward ",
        " bad-mouth "               => " back-bite ",
        " bad-natured "             => " bad-natured ",
        " bad-tempered "            => " bad-tempered ",
        " badge "                   => " brand ",
        " badger "                  => " annoy ",
        " badgered "                => " afraid ",
        " badgerer "                => " annoyance ",
        " badinage "                => " badinage ",
        " badly "                   => " abominably ",
        " badly-timed "             => " awkward ",
        " badman "                  => " badman ",
        " baffle "                  => " addle ",
        " baffled "                 => " baffled ",
        " baffling "                => " abstract ",
        " bagatelle "               => " bagatelle ",
        " baggage "                 => " accoutrements ",
        " bagged "                  => " bagged ",
        " bagginess "               => " appendage ",
        " baggy "                   => " billowing ",
        " bagman "                  => " bagman ",
        " bags "                    => " accoutrements ",
        " bail "                    => " bond ",
        " bailiwick "               => " activity ",
        " bairn "                   => " bairn ",
        " bait "                    => " allurement ",
        " baiter "                  => " baiter ",
        " baitskiff "               => " baiter ",
        " bake "                    => " broil ",
        " bake-apple "              => " bake-apple ",
        " baked "                   => " broiled ",
        " baker "                   => " chef ",
        " balance "                 => " antithesis ",
        " balanced "                => " counterbalanced ",
        " balancer "                => " aerialist ",
        " balancing "               => " acclimation ",
        " balcony "                 => " balustrade ",
        " bald "                    => " baldheaded ",
        " balderdash "              => " aureate ",
        " baldheaded "              => " baldheaded ",
        " baldness "                => " alopecia ",
        " bale "                    => " array ",
        " balefire "                => " alarm ",
        " baleful "                 => " calamitous ",
        " bales "                   => " bales ",
        " balk "                    => " cramp ",
        " balked "                  => " aghast ",
        " balking "                 => " arresting ",
        " balky "                   => " averse ",
        " ball "                    => " brawl ",
        " ball-and-socket "         => " articulation ",
        " ball-breaker "            => " ambitious ",
        " ball-buster "             => " backbreaking ",
        " ballad "                  => " carol ",
        " balladist "               => " artist ",
        " balladry "                => " balladry ",
        " ballast "                 => " balance ",
        " ballerina "               => " ballerina ",
        " balletic "                => " adroit ",
        " ballgame "                => " abortion ",
        " balling "                 => " action ",
        " ballista "                => " ballista ",
        " balloon "                 => " airship ",
        " ballot "                  => " election ",
        " balloting "               => " acclamation ",
        " ballroom "                => " amphitheater ",
        " balls "                   => " assurance ",
        " ballsy "                  => " aggressive ",
        " ballyhoo "                => " adduce ",
        " ballyhooing "             => " announcement ",
        " balm "                    => " analgesic ",
        " balminess "               => " aroma ",
        " balmy "                   => " mild ",
        " baloney "                 => " adulation ",
        " balsam "                  => " analgesic ",
        " balustrade "              => " balustrade ",
        " bamboozle "               => " baffle ",
        " bamboozled "              => " agape ",
        " bamboozlement "           => " artifice ",
        " bamboozling "             => " artifice ",
        " banal "                   => " blah ",
        " banality "                => " boiler ",
        " banana "                  => " assistant ",
        " bananas "                 => " bananas ",
        " banausic "                => " banausic ",
        " band "                    => " bandage ",
        " bandage "                 => " cast ",
        " bandbox "                 => " active ",
        " bandeau "                 => " bandage ",
        " banded "                  => " affiliated ",
        " banderole "               => " banderole ",
        " bandido "                 => " badman ",
        " banding "                 => " amalgamation ",
        " bandit "                  => " brigand ",
        " bandwagon "               => " appearance ",
        " bandy "                   => " altercate ",
        " bane "                    => " affliction ",
        " baneful "                 => " baleful ",
        " banefulness "             => " abuse ",
        " bang "                    => " blast ",
        " bang-up "                 => " bang-up ",
        " bangle "                  => " armlet ",
        " banished "                => " abandoned ",
        " banishment "              => " adjournment ",
        " banister "                => " balustrade ",
        " bank "                    => " coffer ",
        " bankable "                => " bankable ",
        " banker "                  => " broker ",
        " banking "                 => " cyberbanking ",
        " banknote "                => " banknote ",
        " bankroll "                => " backing ",
        " bankrupt "                => " broke ",
        " bankruptcy "              => " defalcation ",
        " banned "                  => " banned ",
        " banner "                  => " banderole ",
        " bannerol "                => " banderole ",
        " banquet "                 => " feast ",
        " banshee "                 => " apparition ",
        " bantam "                  => " diminutive ",
        " banter "                  => " badinage ",
        " bantering "               => " affable ",
        " banty "                   => " banty ",
        " baptism "                 => " ablution ",
        " baptize "                 => " admit ",
        " barb "                    => " affront ",
        " barbarian "               => " barbaric ",
        " barbaric "                => " barbarian ",
        " barbarically "            => " atrociously ",
        " barbarism "               => " atrocity ",
        " barbarity "               => " boorishness ",
        " barbarous "               => " atrocious ",
        " barbarously "             => " atrociously ",
        " barbarousness "           => " atrociousness ",
        " barbate "                 => " barbate ",
        " barbed "                  => " acid ",
        " barber "                  => " beautician ",
        " bard "                    => " artist ",
        " bare "                    => " bald ",
        " bare-faced "              => " arrant ",
        " bare-skinned "            => " bald ",
        " bared "                   => " apparent ",
        " barefaced "               => " apparent ",
        " barely "                  => " almost ",
        " bareness "                => " dishabille ",
        " barf "                    => " barf ",
        " bargain "                 => " arrangement ",
        " bargain-basement "        => " bargain ",
        " bargain-counter "         => " bargain ",
        " bargainer "               => " adjudicator ",
        " bargaining "              => " acceding ",
        " bargello "                => " adornment ",
        " barillet "                => " barillet ",
        " baring "                  => " acknowledgment ",
        " bark "                    => " case ",
        " barm "                    => " balloon ",
        " barnacle "                => " barnacle ",
        " barnstorm "               => " agitate ",
        " barnstormer "             => " amateur ",
        " barnyard "                => " awkward ",
        " barometer "               => " barometer ",
        " baroness "                => " adult ",
        " baronial "                => " baronial ",
        " baroque "                 => " bizarre ",
        " barrack "                 => " banter ",
        " barracks "                => " billet ",
        " barrage "                 => " battery ",
        " barrel "                  => " butt ",
        " barrelling "              => " agile ",
        " barren "                  => " arid ",
        " barrio "                  => " barrio ",
        " barrister "               => " advocate ",
        " barristers "              => " attorneys ",
        " barroom "                 => " alehouse ",
        " barrow "                  => " barrow ",
        " bars "                    => " confined ",
        " barter "                  => " bargain ",
        " bartering "               => " bartering ",
        " basal "                   => " basal ",
        " base "                    => " abject ",
        " baseborn "                => " adulterated ",
        " baseless "                => " bottomless ",
        " basement "                => " basement ",
        " baseness "                => " abandonment ",
        " baser "                   => " accessory ",
        " bash "                    => " back-bite ",
        " bashed "                  => " bashed ",
        " bashful "                 => " abashed ",
        " bashfulness "             => " bashfulness ",
        " basic "                   => " basal ",
        " basilica "                => " basilica ",
        " basis "                   => " base ",
        " bask "                    => " insolate ",
        " basket "                  => " bassinet ",
        " bass "                    => " bass ",
        " basset "                  => " basset ",
        " bassinet "                => " bassinet ",
        " bastard "                 => " adulterated ",
        " bastardize "              => " adulterate ",
        " baste "                   => " drip ",
        " bastille "                => " alcove ",
        " bastinado "               => " bastinado ",
        " bastion "                 => " breastwork ",
        " batch "                   => " accumulation ",
        " bateau "                  => " baiter ",
        " bated "                   => " aside ",
        " bath "                    => " ablution ",
        " bathe "                   => " bath ",
        " bathed "                  => " bathed ",
        " bathetic "                => " abstracted ",
        " bathos "                  => " bathos ",
        " bathrobe "                => " bathrobe ",
        " bathroom "                => " bath ",
        " baton "                   => " billy ",
        " batt "                    => " batt ",
        " battalion "               => " army ",
        " batter "                  => " concoction ",
        " battercake "              => " battercake ",
        " battered "                => " aged ",
        " battery "                 => " array ",
        " battle "                  => " action ",
        " battle-scarred "          => " adept ",
        " battlefront "             => " battlefront ",
        " battleground "            => " battlefield ",
        " battlement "              => " barricade ",
        " battler "                 => " adversary ",
        " battling "                => " aggressive ",
        " batty "                   => " absurd ",
        " bauble "                  => " applique ",
        " bawdiness "               => " bawdiness ",
        " bawdy "                   => " blue ",
        " bawl "                    => " bark ",
        " bawling "                 => " bawl ",
        " bayou "                   => " anchorage ",
        " bays "                    => " accolade ",
        " bazaar "                  => " exchange ",
        " bazoo "                   => " adenoids ",
        " bazooka "                 => " arms ",
        " beach "                   => " bank ",
        " beachcomber "             => " angishore ",
        " beached "                 => " abandoned ",
        " beacon "                  => " alarm ",
        " bead "                    => " bean ",
        " beadledom "               => " authority ",
        " beads "                   => " chaplet ",
        " beagle "                  => " advocate ",
        " beak "                    => " bill ",
        " beaker "                  => " alembic ",
        " beal "                    => " aggravate ",
        " beam "                    => " axle ",
        " beaming "                 => " bright ",
        " beanbag "                 => " beanbag ",
        " beanery "                 => " beanery ",
        " beanie "                  => " beanie ",
        " beanstalk "               => " angular ",
        " bear "                    => " buck ",
        " bearable "                => " acceptable ",
        " bearcat "                 => " bearcat ",
        " beard "                   => " bristles ",
        " bearded "                 => " barbate ",
        " bearding "                => " bearding ",
        " beardless "               => " baldheaded ",
        " beardy "                  => " barbate ",
        " bearer "                  => " agent ",
        " bearing "                 => " address ",
        " beast "                   => " barbarian ",
        " beastie "                 => " barbarian ",
        " beastly "                 => " abominable ",
        " beasts "                  => " beasts ",
        " beat "                    => " exhausted ",
        " beaten "                  => " baffled ",
        " beatific "                => " adorable ",
        " beatifically "            => " acquiescently ",
        " beatification "           => " adoration ",
        " beatified "               => " adored ",
        " beatify "                 => " absolve ",
        " beating "                 => " assault ",
        " beatitude "               => " approbation ",
        " beau "                    => " admirer ",
        " beauteous "               => " admirable ",
        " beautician "              => " beautician ",
        " beautification "          => " beautification ",
        " beautiful "               => " admirable ",
        " beautify "                => " adorn ",
        " beautifying "             => " adorning ",
        " beauty "                  => " adorableness ",
        " beaver "                  => " aholic ",
        " becalm "                  => " allay ",
        " becalmed "                => " apoplectic ",
        " bechance "                => " action ",
        " beck "                    => " allure ",
        " beckon "                  => " allure ",
        " beckoning "               => " adorable ",
        " becloud "                 => " becloud ",
        " becoming "                => " acceptable ",
        " becomingness "            => " accordance ",
        " bed-making "              => " bed-making ",
        " bedaub "                  => " adhere ",
        " bedazzle "                => " arrange ",
        " bedazzlement "            => " beam ",
        " bedchamber "              => " bedchamber ",
        " bedding "                 => " bedding ",
        " beddy-bye "               => " beddy-bye ",
        " bedeck "                  => " beautify ",
        " bedecked "                => " adorned ",
        " bedecking "               => " adornment ",
        " bedevil "                 => " abrade ",
        " bedeviled "               => " bedeviled ",
        " bedevilled "              => " accursed ",
        " bedevilment "             => " aggravation ",
        " bedew "                   => " bedew ",
        " bedfast "                 => " bedfast ",
        " bedfellow "               => " acquaintance ",
        " bedim "                   => " becloud ",
        " bedimmed "                => " bedimmed ",
        " bedizen "                 => " accouter ",
        " bedizenment "             => " adornment ",
        " bedlam "                  => " clamor ",
        " bedlamite "               => " absurd ",
        " bedmate "                 => " bedmate ",
        " bedraggle "               => " bedraggle ",
        " bedraggled "              => " decrepit ",
        " bedridden "               => " bedfast ",
        " bedrock "                 => " basement ",
        " bedroom "                 => " bedchamber ",
        " bedspread "               => " batt ",
        " bedstead "                => " bassinet ",
        " beefcake "                => " anatomy ",
        " beefiness "               => " beef ",
        " beefing "                 => " accession ",
        " beefy "                   => " able-bodied ",
        " beeline "                 => " beeline ",
        " beep "                    => " beep ",
        " beeswax "                 => " affair ",
        " beetling "                => " arresting ",
        " beezer "                  => " adenoids ",
        " befall "                  => " action ",
        " befalling "               => " befalling ",
        " befittingly "             => " accurately ",
        " befog "                   => " becloud ",
        " before "                  => " afore ",
        " beforehand "              => " advanced ",
        " befoul "                  => " befoul ",
        " befouled "                => " barn ",
        " befriend "                => " advise ",
        " befuddle "                => " addle ",
        " befuddled "               => " befuddled ",
        " befuddlement "            => " abashing ",
        " befuddling "              => " abashing ",
        " begat "                   => " begat ",
        " beget "                   => " afford ",
        " begetter "                => " architect ",
        " begetting "               => " bearing ",
        " beggared "                => " beggared ",
        " beggarly "                => " abject ",
        " beggary "                 => " abjection ",
        " begging "                 => " allurement ",
        " begild "                  => " adorn ",
        " begin "                   => " activate ",
        " beginner "                => " abecedarian ",
        " beginning "               => " alpha ",
        " beginnings "              => " ancestry ",
        " begird "                  => " band ",
        " begrime "                 => " befoul ",
        " begrimed "                => " begrimed ",
        " begrudging "              => " acrimonious ",
        " beguile "                 => " betray ",
        " beguiled "                => " beguiled ",
        " beguilement "             => " action ",
        " beguiler "                => " actor ",
        " beguiling "               => " artful ",
        " begun "                   => " amorphous ",
        " behalf "                  => " account ",
        " behaviorism "             => " attitude ",
        " behead "                  => " decollate ",
        " beheading "               => " beheading ",
        " beheld "                  => " beheld ",
        " behest "                  => " bidding ",
        " behind "                  => " abaft ",
        " behindhand "              => " backward ",
        " behold "                  => " catch ",
        " beholden "                => " bound ",
        " beholder "                => " beholder ",
        " beholding "               => " attending ",
        " beige "                   => " biscuit ",
        " being "                   => " actuality ",
        " belabor "                 => " belabor ",
        " belch "                   => " discharge ",
        " beleaguer "               => " annoy ",
        " beleaguered "             => " abandoned ",
        " beleaguerment "           => " aloneness ",
        " belie "                   => " confute ",
        " belief "                  => " acceptance ",
        " beliefs "                 => " behavior ",
        " believability "           => " believability ",
        " believably "              => " apparently ",
        " believe "                 => " accept ",
        " believer "                => " accepter ",
        " believing "               => " assertive ",
        " belittlement "            => " abuse ",
        " belittling "              => " analytical ",
        " bell "                    => " alarm ",
        " bell-lyra "               => " angelus ",
        " bell-ringer "             => " afflatus ",
        " bellboy "                 => " attendant ",
        " belled "                  => " belled ",
        " beller "                  => " bark ",
        " belles-lettres "          => " abstract ",
        " belletrist "              => " belletrist ",
        " bellhop "                 => " attendant ",
        " bellicism "               => " bellicism ",
        " bellicose "               => " advancing ",
        " bellicosity "             => " abhorrence ",
        " belligerence "            => " acerbity ",
        " belligerency "            => " altercation ",
        " belligerent "             => " aggressive ",
        " bellow "                  => " bark ",
        " bells "                   => " accretion ",
        " belly "                   => " abdomen ",
        " bellyacher "              => " bear ",
        " bellyaching "             => " annoyed ",
        " belong "                  => " accord ",
        " belonging "               => " acceptance ",
        " belongings "              => " accouterments ",
        " beloved "                 => " admired ",
        " below "                   => " beneath ",
        " belted "                  => " belted ",
        " belvedere "               => " anchor ",
        " bemean "                  => " abase ",
        " bemired "                 => " addled ",
        " bemoan "                  => " bewail ",
        " bemoaning "               => " affliction ",
        " bemuse "                  => " addle ",
        " bemused "                 => " absent ",
        " bemusement "              => " abashing ",
        " bench "                   => " bank ",
        " benchmark "               => " criterion ",
        " bend "                    => " angle ",
        " bendability "             => " bendability ",
        " bendable "                => " bendable ",
        " bendableness "            => " bendability ",
        " bending "                 => " angle ",
        " bends "                   => " aeroembolism ",
        " beneath "                 => " below ",
        " benedicite "              => " absolution ",
        " benedict "                => " backstabber ",
        " benediction "             => " approbation ",
        " benedictus "              => " approbation ",
        " benefaction "             => " advancement ",
        " benefic "                 => " advantageous ",
        " beneficence "             => " alms ",
        " beneficently "            => " accurately ",
        " beneficial "              => " benign ",
        " beneficiary "             => " almsman ",
        " beneficient "             => " adorable ",
        " benefit "                 => " account ",
        " benefits "                => " allowances ",
        " benevolence "             => " altruism ",
        " benevolently "            => " affably ",
        " benighted "               => " benighted ",
        " benightedness "           => " benightedness ",
        " benign "                  => " amiable ",
        " benignancy "              => " benevolence ",
        " benignant "               => " amiable ",
        " benignity "               => " affection ",
        " benignly "                => " accurately ",
        " benison "                 => " approbation ",
        " bent "                    => " angled ",
        " benumb "                  => " attenuate ",
        " benumbed "                => " algid ",
        " bequeath "                => " bestow ",
        " bequeathal "              => " bequeathal ",
        " bequeathed "              => " ancestral ",
        " bequeathment "            => " bequeathal ",
        " bequest "                 => " bequeathal ",
        " berating "                => " accusation ",
        " bereave "                 => " bankrupt ",
        " bereaved "                => " beggared ",
        " bereavement "             => " afflication ",
        " bereft "                  => " beggared ",
        " beret "                   => " beanie ",
        " berg "                    => " berg ",
        " berline "                 => " auto ",
        " berm "                    => " bend ",
        " berry "                   => " drupe ",
        " berserk "                 => " berserk ",
        " berth "                   => " anchorage ",
        " beryl "                   => " azure ",
        " besaint "                 => " apotheosize ",
        " beseech "                 => " adjure ",
        " beseeching "              => " admonition ",
        " beset "                   => " aggress ",
        " besetment "               => " aggravation ",
        " besetting "               => " besetting ",
        " besiege "                 => " assail ",
        " beslaver "                => " adulate ",
        " besmear "                 => " begrime ",
        " besmeared "               => " besmeared ",
        " besmearing "              => " abuse ",
        " besmirch "                => " asperse ",
        " besmirched "              => " besmirched ",
        " besmirching "             => " abuse ",
        " besoil "                  => " begrime ",
        " besom "                   => " besom ",
        " besotted "                => " addled ",
        " bespatter "               => " bespatter ",
        " bespattered "             => " addled ",
        " bespeak "                 => " approach ",
        " bespeckle "               => " bespeckle ",
        " bespray "                 => " begrime ",
        " besprinkle "              => " admit ",
        " best-dressed "            => " best-dressed ",
        " best-liked "              => " advantaged ",
        " best-loved "              => " admired ",
        " best-selling "            => " acknowledged ",
        " bested "                  => " baffled ",
        " bestial "                 => " beastly ",
        " bestiality "              => " animality ",
        " bestialize "              => " adulterate ",
        " bestiary "                => " allegory ",
        " bestow "                  => " accord ",
        " bestowal "                => " acclamation ",
        " bestrew "                 => " bestrew ",
        " bestride "                => " bestride ",
        " bestseller "              => " album ",
        " bethel "                  => " abbey ",
        " bethink "                 => " bethink ",
        " betide "                  => " action ",
        " betimes "                 => " anon ",
        " betoken "                 => " betoken ",
        " betray "                  => " abandon ",
        " betrayer "                => " backstabber ",
        " betraying "               => " betraying ",
        " betrayment "              => " apostasy ",
        " betrothal "               => " affiancing ",
        " betrothed "               => " affianced ",
        " betrothing "              => " affiancing ",
        " betrothment "             => " assurance ",
        " better "                  => " bigger ",
        " bettering "               => " accessible ",
        " betterment "              => " advancement ",
        " betting "                 => " action ",
        " between "                 => " amid ",
        " betwixt "                 => " amid ",
        " bevel "                   => " angle ",
        " beveled "                 => " askew ",
        " beverage "                => " cooler ",
        " bevy "                    => " assembly ",
        " bewail "                  => " bemoan ",
        " bewailing "               => " bawl ",
        " bewhiskered "             => " barbate ",
        " bewilder "                => " addle ",
        " bewildered "              => " addled ",
        " bewildering "             => " amazing ",
        " bewilderment "            => " admiration ",
        " bewitch "                 => " allure ",
        " bewitched "               => " bugged ",
        " bewitchery "              => " attractiveness ",
        " bewitching "              => " adorable ",
        " bewitchment "             => " allure ",
        " beyond "                  => " above ",
        " bi-weekly "               => " bi-weekly ",
        " bias "                    => " bent ",
        " biased "                  => " biased ",
        " bibelot "                 => " anomaly ",
        " bible-beater "            => " abbot ",
        " bibliophile "             => " bibliophile ",
        " bibulous "                => " absorptive ",
        " bicker "                  => " altercate ",
        " bickering "               => " argument ",
        " biconcave "               => " biconcave ",
        " biconvex "                => " arched ",
        " bicycle "                 => " bike ",
        " biddable "                => " acquiescent ",
        " bidder "                  => " applicant ",
        " bidding "                 => " behest ",
        " biddy "                   => " age-old ",
        " bide "                    => " abide ",
        " biff "                    => " advance ",
        " bifid "                   => " angled ",
        " bifold "                  => " bifold ",
        " bifurcated "              => " angled ",
        " bifurcation "             => " bifurcation ",
        " big-eyed "                => " analytical ",
        " big-headed "              => " arrogant ",
        " big-headedness "          => " airs ",
        " big-mouthed "             => " articulate ",
        " big-talking "             => " aureate ",
        " big-ticket "              => " big-ticket ",
        " bigger "                  => " bigger ",
        " biggest "                 => " better ",
        " biggety "                 => " aloof ",
        " biggie "                  => " action ",
        " bigheaded "               => " arrogant ",
        " bighearted "              => " acquiescent ",
        " bight "                   => " anchorage ",
        " bigness "                 => " aggregate ",
        " bigoted "                 => " biased ",
        " biking "                  => " biking ",
        " bilateral "               => " mutual ",
        " bile "                    => " acerbity ",
        " bilge "                   => " balloon ",
        " bilious "                 => " ailing ",
        " biliousness "             => " abhorrence ",
        " bilk "                    => " bamboozle ",
        " bilker "                  => " bilker ",
        " billboard "               => " advance ",
        " billet "                  => " batten ",
        " billing "                 => " announcement ",
        " billingsgate "            => " accusation ",
        " billow "                  => " breaker ",
        " billowing "               => " billowing ",
        " billowy "                 => " bouncing ",
        " billy "                   => " baton ",
        " bimonthly "               => " annual ",
        " binal "                   => " bifold ",
        " binary "                  => " bifold ",
        " binate "                  => " bifold ",
        " binder "                  => " adhesive ",
        " binders "                 => " anchor ",
        " binding "                 => " bounden ",
        " binge "                   => " affair ",
        " biog "                    => " adventures ",
        " biographer "              => " biographer ",
        " biography "               => " adventures ",
        " biologic "                => " biologic ",
        " biology "                 => " analysis ",
        " biosphere "               => " abode ",
        " biotic "                  => " amoebic ",
        " biped "                   => " animal ",
        " bipedal "                 => " animal ",
        " birch "                   => " besom ",
        " bird-brained "            => " apprenticed ",
        " bird-dog "                => " bird-dog ",
        " birdbrained "             => " absurd ",
        " birdcage "                => " abode ",
        " birdie "                  => " baboon ",
        " birdlike "                => " aeriform ",
        " birdlime "                => " adhesive ",
        " birr "                    => " birr ",
        " birth "                   => " bearing ",
        " birthday "                => " altogether ",
        " birthing "                => " bearing ",
        " birthmark "               => " birthmark ",
        " birthplace "              => " birthplace ",
        " birthright "              => " affirmation ",
        " biscuit "                 => " biscuit ",
        " bisect "                  => " bifurcate ",
        " bisected "                => " bisected ",
        " bisection "               => " analysis ",
        " bishop "                  => " abbey ",
        " bister "                  => " amber ",
        " bistered "                => " bistered ",
        " bistro "                  => " alehouse ",
        " bit-by-bit "              => " bit-by-bit ",
        " bitch "                   => " allegation ",
        " bitchiness "              => " abuse ",
        " bitching "                => " bitching ",
        " bitchy "                  => " aggressive ",
        " bite "                    => " chaw ",
        " biting "                  => " bitter ",
        " bits "                    => " $.25 ",
        " bitten "                  => " apathetic ",
        " bitter "                  => " absinthian ",
        " bitterness "              => " acerbity ",
        " bittersweet "             => " apricot ",
        " bivouac "                 => " billet ",
        " biweekly "                => " annual ",
        " bizarre "                 => " camp ",
        " bizarreness "             => " aberancy ",
        " blab "                    => " babble ",
        " blabber "                 => " babble ",
        " black "                   => " atramentous ",
        " black-and-blue "          => " abrasion ",
        " black-hearted "           => " adverse ",
        " black-market "            => " actionable ",
        " blackball "               => " banish ",
        " blackballed "             => " blackballed ",
        " blackcoat "               => " abbey ",
        " blacken "                 => " befoul ",
        " blackened "               => " begrimed ",
        " blackhead "               => " abscess ",
        " blackish "                => " aphotic ",
        " blacklist "               => " banish ",
        " blackmail "               => " bribery ",
        " blackmailer "             => " blackmailer ",
        " blackness "               => " black ",
        " bladder "                 => " float ",
        " blade "                   => " brand ",
        " blah "                    => " banausic ",
        " blah-blah "               => " agitation ",
        " blahs "                   => " abasement ",
        " blain "                   => " abscess ",
        " blamable "                => " amiss ",
        " blame "                   => " accusation ",
        " blamed "                  => " abhorrent ",
        " blameful "                => " amiss ",
        " blameworthiness "         => " answerability ",
        " blameworthy "             => " blameworthy ",
        " blanch "                  => " flinch ",
        " blanched "                => " abashed ",
        " bland "                   => " banal ",
        " blandishment "            => " applause ",
        " blank "                   => " bare ",
        " blanket "                 => " absolute ",
        " blankety-blank "          => " accursed ",
        " blankness "               => " blank ",
        " blare "                   => " bellow ",
        " blaring "                 => " arrant ",
        " blarney "                 => " adulation ",
        " blase "                   => " adult ",
        " blaspheme "               => " abuse ",
        " blaspheming "             => " anathema ",
        " blasphemous "             => " cursing ",
        " blasphemy "               => " abuse ",
        " blast "                   => " bang ",
        " blasted "                 => " accursed ",
        " blasting "                => " announcement ",
        " blastoff "                => " alpha ",
        " blatant "                 => " arrant ",
        " blatantly "               => " aboveboard ",
        " blather "                 => " babble ",
        " blathering "              => " babbling ",
        " blatherskite "            => " babbler ",
        " blaze "                   => " bonfire ",
        " blazing "                 => " afire ",
        " blazon "                  => " acquaint ",
        " blazonry "                => " blazonry ",
        " bleach "                  => " achromatize ",
        " bleached "                => " albino ",
        " bleaching "               => " acerbic ",
        " bleak "                   => " austere ",
        " bleakness "               => " abasement ",
        " blear "                   => " becloud ",
        " bleared "                 => " bleared ",
        " bleat "                   => " bark ",
        " bleb "                    => " abscess ",
        " bleed "                   => " drain ",
        " bleep "                   => " beep ",
        " blemish "                 => " birthmark ",
        " blench "                  => " achromatize ",
        " blenching "               => " backward ",
        " blend "                   => " alloy ",
        " blended "                 => " attenuated ",
        " blending "                => " aggregate ",
        " blendword "               => " blend ",
        " bless "                   => " absolve ",
        " blessed "                 => " adored ",
        " blessedness "             => " beatitude ",
        " blessing "                => " absolution ",
        " blest "                   => " blessed ",
        " blether "                 => " babble ",
        " blight "                  => " bane ",
        " blighted "                => " austere ",
        " blighting "               => " bitter ",
        " blimp "                   => " airship ",
        " blind "                   => " dark ",
        " blinded "                 => " addled ",
        " blinder "                 => " blinder ",
        " blindfold "               => " blinder ",
        " blindness "               => " amaurosis ",
        " blindside "               => " bang ",
        " blinker "                 => " blinder ",
        " blinking "                => " blinking ",
        " blinky "                  => " acerb ",
        " blip "                    => " bleep ",
        " bliss "                   => " beatitude ",
        " blissful "                => " beatific ",
        " blissfully "              => " acquiescently ",
        " blister "                 => " abscess ",
        " blistering "              => " baking ",
        " blithe "                  => " animated ",
        " blithely "                => " blithely ",
        " blitheness "              => " animation ",
        " blithesome "              => " alert ",
        " blitz "                   => " assault ",
        " blitzkrieg "              => " advance ",
        " blizzard "                => " blast ",
        " bloat "                   => " balloon ",
        " bloated "                 => " aggrandized ",
        " blob "                    => " balloon ",
        " blobby "                  => " baggy ",
        " bloc "                    => " affiliation ",
        " blockade "                => " barricade ",
        " blockaded "               => " abandoned ",
        " blockage "                => " blockage ",
        " blocked "                 => " blocked ",
        " blocker "                 => " acquaintance ",
        " blockhead "               => " blockhead ",
        " blockhouse "              => " bastion ",
        " bloke "                   => " adolescent ",
        " blond "                   => " albino ",
        " blonde "                  => " albino ",
        " blood "                   => " claret ",
        " blood-and-thunder "       => " artificial ",
        " blood-relationship "      => " affiliation ",
        " blood-soaked "            => " blood-soaked ",
        " blood-spattered "         => " blood-soaked ",
        " blood-tingling "          => " blood-tingling ",
        " blood-warm "              => " blood-warm ",
        " bloodbath "               => " bloodbath ",
        " bloodcurdling "           => " appalling ",
        " bloodless "               => " anesthetic ",
        " bloodshed "               => " action ",
        " bloodshot "               => " bittersweet ",
        " bloodstained "            => " blood-soaked ",
        " bloodsucker "             => " barnacle ",
        " bloodthirstiness "        => " atrocity ",
        " bloodthirsty "            => " bloodthirsty ",
        " bloody "                  => " blood-soaked ",
        " blooey "                  => " asleep ",
        " bloom "                   => " blossom ",
        " bloomer "                 => " bloomer ",
        " blooming "                => " blooming ",
        " blooper "                 => " boner ",
        " blossom "                 => " bloom ",
        " blossoming "              => " blossom ",
        " blossomy "                => " blooming ",
        " blot "                    => " blemish ",
        " blotch "                  => " blemish ",
        " blotchy "                 => " blotchy ",
        " blotto "                  => " blackmailer ",
        " bloviate "                => " attack ",
        " blow "                    => " draft ",
        " blow-by-blow "            => " abundant ",
        " blow-off "                => " after-effects ",
        " blowing "                 => " alarming ",
        " blown "                   => " absolute ",
        " blowout "                 => " blast ",
        " blows "                   => " assault ",
        " blowsy "                  => " antiquated ",
        " blowup "                  => " argument ",
        " blowy "                   => " aerial ",
        " blub "                    => " bawl ",
        " blubber "                 => " blab ",
        " blubbering "              => " blubbering ",
        " blubbery "                => " blubbery ",
        " bludgeon "                => " badger ",
        " blue "                    => " dejected ",
        " blue-blooded "            => " aloof ",
        " blue-chip "               => " baddest ",
        " blue-eyed "               => " baby ",
        " blue-pencil "             => " abridge ",
        " blue-stocking "           => " able ",
        " blueblood "               => " blueblood ",
        " bluecoat "                => " badge ",
        " bluejacket "              => " bluejacket ",
        " blueness "                => " abomination ",
        " blueprint "               => " adapt ",
        " blues "                   => " dejection ",
        " bluestockings "           => " blueblood ",
        " bluff "                   => " barefaced ",
        " bluffing "                => " backbiting ",
        " blunder "                 => " blooper ",
        " blunderbuss "             => " addle-brain ",
        " blunderer "               => " addle-brain ",
        " blunderhead "             => " addle-brain ",
        " blunderingly "            => " abominably ",
        " blunt "                   => " edgeless ",
        " blunting "                => " abatement ",
        " bluntness "               => " bluntness ",
        " blur "                    => " becloud ",
        " blurred "                 => " blurred ",
        " blurring "                => " abashing ",
        " blurry "                  => " bleared ",
        " blurt "                   => " blab ",
        " blush "                   => " bloom ",
        " blushful "                => " abashed ",
        " blushing "                => " abashed ",
        " bluster "                 => " bluff ",
        " blustering "              => " barefaced ",
        " blusterous "              => " airy ",
        " blustery "                => " airy ",
        " boar "                    => " animal ",
        " board "                   => " lath ",
        " boarded "                 => " boarded ",
        " boarder "                 => " boarder ",
        " boarish "                 => " abandoned ",
        " boast "                   => " avowal ",
        " boastful "                => " arrogant ",
        " boastfulness "            => " arrogance ",
        " boasting "                => " boasting ",
        " boat "                    => " baiter ",
        " boating "                 => " canoeing ",
        " bobbin "                  => " ball ",
        " bobble "                  => " blow ",
        " bobby "                   => " blockhead ",
        " bobby-soxer "             => " babe ",
        " bobcat "                  => " bobcat ",
        " bodacious "               => " assured ",
        " bode "                    => " augur ",
        " bodega "                  => " bodega ",
        " bodement "                => " augury ",
        " bodice "                  => " bodice ",
        " bodies "                  => " bodies ",
        " bodiless "                => " aerial ",
        " bodily "                  => " actual ",
        " boding "                  => " auspice ",
        " body "                    => " anatomy ",
        " body-building "           => " aerobatics ",
        " bodyguard "               => " babysitter ",
        " bodysuit "                => " bodice ",
        " boff "                    => " advance ",
        " boffo "                   => " agreeable ",
        " bogart "                  => " absorb ",
        " bogey "                   => " bogey ",
        " bogeyman "                => " bogeyman ",
        " boggle "                  => " amaze ",
        " boggling "                => " extraordinary ",
        " boggy "                   => " addled ",
        " bogie "                   => " bogie ",
        " bogosity "                => " affected ",
        " bogue "                   => " actor ",
        " bogus "                   => " artificial ",
        " boil "                    => " abscess ",
        " boil-down "               => " abbreviate ",
        " boiled "                  => " above ",
        " boiler "                  => " boiler ",
        " boilerplate "             => " boilerplate ",
        " boiling "                 => " baking ",
        " boisterous "              => " bouncy ",
        " boisterously "            => " actively ",
        " boisterousness "          => " bluff ",
        " bold "                    => " adventurous ",
        " boldfaced "               => " arrant ",
        " boldly "                  => " angrily ",
        " boldness "                => " aggressiveness ",
        " bole "                    => " adobe ",
        " bollix "                  => " blow ",
        " bollixed "                => " balked ",
        " bologna "                 => " bologna ",
        " bolted "                  => " anchored ",
        " bolter "                  => " bolter ",
        " bolus "                   => " bolus ",
        " bombard "                 => " assail ",
        " bombardment "             => " battery ",
        " bombast "                 => " bluff ",
        " bombastic "               => " aureate ",
        " bombed "                  => " austere ",
        " bomber "                  => " adviser ",
        " bombilate "               => " bombilate ",
        " bombinate "               => " bombinate ",
        " bombshell "               => " affliction ",
        " bonanza "                 => " bonanza ",
        " bonbon "                  => " bonbon ",
        " bond "                    => " band ",
        " bondage "                 => " chains ",
        " bonded "                  => " affirmed ",
        " bondman "                 => " bondman ",
        " bonds "                   => " bonds ",
        " bondservant "             => " bondman ",
        " bondsman "                => " bondservant ",
        " bone "                    => " cartilage ",
        " bone-dry "                => " barren ",
        " bone-weary "              => " beat ",
        " bonebreaker "             => " backbreaker ",
        " bonehead "                => " blockhead ",
        " boner "                   => " boner ",
        " bones "                   => " basic ",
        " bonfire "                 => " alarm ",
        " bong "                    => " bell ",
        " bonhomous "               => " accommodating ",
        " bonk "                    => " bang ",
        " bonnet "                  => " beanie ",
        " bonny "                   => " attractive ",
        " bonus "                   => " benefit ",
        " bony "                    => " awkward ",
        " boo-boo "                 => " boner ",
        " booby "                   => " bedlam ",
        " boogie "                  => " ankle ",
        " boohoo "                  => " blubber ",
        " book-learning "           => " account ",
        " bookbuster "              => " adherent ",
        " bookcase "                => " appliance ",
        " booked "                  => " appointed ",
        " bookish "                 => " bookish ",
        " bookishness "             => " bookishness ",
        " bookkeeping "             => " accounting ",
        " booklet "                 => " album ",
        " bookman "                 => " bibliophile ",
        " bookmark "                => " bookmark ",
        " bookwoman "               => " bibliophile ",
        " bookworm "                => " abecedarian ",
        " boom "                    => " bang ",
        " boom-boom "               => " babel ",
        " boomerang "               => " backlash ",
        " boomlet "                 => " abundance ",
        " boon "                    => " benefaction ",
        " boor "                    => " barbarian ",
        " boorish "                 => " awkward ",
        " boorishness "             => " amateurishness ",
        " boost "                   => " addition ",
        " boosted "                 => " additional ",
        " boosting "                => " advocacy ",
        " boot "                    => " cossack ",
        " booth "                   => " berth ",
        " bootlegged "              => " banned ",
        " bootless "                => " bootless ",
        " bootlick "                => " adulate ",
        " bootlicker "              => " ass-kisser ",
        " bootlicking "             => " applause ",
        " booty "                   => " anatomy ",
        " booze "                   => " booze ",
        " boozed "                  => " bashed ",
        " bor-ring "                => " annoying ",
        " borax "                   => " base ",
        " border "                  => " bound ",
        " bordered "                => " belted ",
        " bordering "               => " adjoining ",
        " borderland "              => " abuttals ",
        " borderline "              => " ambiguous ",
        " borders "                 => " borders ",
        " boreal "                  => " algid ",
        " bored "                   => " apathetic ",
        " boredom "                 => " apathy ",
        " borer "                   => " auger ",
        " boresome "                => " annoying ",
        " boring "                  => " arid ",
        " born "                    => " built-in ",
        " borough "                 => " apple ",
        " borrowed "                => " adopted ",
        " borrowing "               => " borrowing ",
        " borsch "                  => " borsch ",
        " boscage "                 => " boscage ",
        " bosky "                   => " blooming ",
        " bosom "                   => " bust ",
        " boss "                    => " bang-up ",
        " bosses "                  => " administration ",
        " bossism "                 => " backroom ",
        " bossy "                   => " absolute ",
        " botanic "                 => " blooming ",
        " botch "                   => " blow ",
        " botched "                 => " adulterated ",
        " botcher "                 => " addle-brain ",
        " botchery "                => " anarchy ",
        " botchy "                  => " blowzy ",
        " botheration "             => " affliction ",
        " bothered "                => " agitated ",
        " bothering "               => " aggravation ",
        " bothersome "              => " aggravating ",
        " bothersomeness "          => " aggravation ",
        " bottle "                  => " canteen ",
        " bottleneck "              => " aqueduct ",
        " bottom "                  => " basal ",
        " bottomless "              => " bottomless ",
        " bottommost "              => " below ",
        " bottoms "                 => " cheers ",
        " bottomward "              => " bottomward ",
        " bough "                   => " bender ",
        " bouillon "                => " borsch ",
        " boulder "                 => " bedrock ",
        " bouldered "               => " bouldered ",
        " boulevard "               => " artery ",
        " bounce "                  => " animation ",
        " bouncer "                 => " bouncer ",
        " bounciness "              => " bounce ",
        " bouncy "                  => " animated ",
        " bound "                   => " apprenticed ",
        " boundaried "              => " belted ",
        " boundary "                => " abuttals ",
        " bounded "                 => " belted ",
        " bounden "                 => " bounden ",
        " bounder "                 => " bastard ",
        " bounding "                => " bonds ",
        " boundless "               => " great ",
        " boundlessness "           => " beyond ",
        " boundness "               => " albatross ",
        " bounds "                  => " bound ",
        " bounteous "               => " abounding ",
        " bountiful "               => " ample ",
        " bountifully "             => " abundantly ",
        " bountifulness "           => " affection ",
        " bounty "                  => " compensation ",
        " bouquet "                 => " boutonniere ",
        " bourgeois "               => " common ",
        " bourgeoisie "             => " ancestry ",
        " bourne "                  => " absolute ",
        " bout "                    => " bender ",
        " boutique "                => " bazaar ",
        " boutonniere "             => " boutonniere ",
        " bow-shaped "              => " bow-shaped ",
        " bowdlerize "              => " abridge ",
        " bowed "                   => " angled ",
        " bowel "                   => " bowel ",
        " bowels "                  => " belly ",
        " bower "                   => " anteroom ",
        " bowing "                  => " accedence ",
        " bowl "                    => " basin ",
        " bowlegs "                 => " army ",
        " bowsprit "                => " beak ",
        " bowstring "               => " asphyxiate ",
        " bowwow "                  => " bitch ",
        " boxing "                  => " battle ",
        " boxlike "                 => " boxlike ",
        " boxy "                    => " boxlike ",
        " boycott "                 => " avoid ",
        " boyfriend "               => " admirer ",
        " boyhood "                 => " adolescence ",
        " boyish "                  => " adolescent ",
        " boylike "                 => " adolescent ",
        " boytoy "                  => " babe ",
        " braced "                  => " anchored ",
        " bracelet "                => " armlet ",
        " bracing "                 => " animating ",
        " bracken "                 => " bracken ",
        " bracketed "               => " affiliated ",
        " brackish "                => " abhorrent ",
        " brackishness "            => " acerbity ",
        " bract "                   => " blade ",
        " brag "                    => " blow ",
        " braggadocio "             => " airs ",
        " bragging "                => " aloof ",
        " braid "                   => " complect ",
        " braiding "                => " braiding ",
        " brain "                   => " academician ",
        " brain-teaser "            => " brain-teaser ",
        " brainchild "              => " abstraction ",
        " brainless "               => " addled ",
        " brains "                  => " accuracy ",
        " brainstorm "              => " begin ",
        " brainteaser "             => " abstruseness ",
        " brainwash "               => " alter ",
        " brainwashing "            => " apprenticeship ",
        " brainwave "               => " afflatus ",
        " brainwork "               => " brainwork ",
        " brainy "                  => " able ",
        " braise "                  => " bake ",
        " brake "                   => " anchor ",
        " bramble "                 => " brier ",
        " brambly "                 => " annoying ",
        " bran-like "               => " abrasive ",
        " branch "                  => " annex ",
        " branched "                => " angled ",
        " branching "               => " aberration ",
        " branchlet "               => " bough ",
        " brand "                   => " cast ",
        " brand-new "               => " aboriginal ",
        " brandish "                => " display ",
        " brannigan "               => " altercation ",
        " branny "                  => " arenaceous ",
        " brash "                   => " audacious ",
        " brashness "               => " assumption ",
        " brass "                   => " assumption ",
        " brass-bound "             => " adamantine ",
        " brassy "                  => " arrant ",
        " bravado "                 => " blowing ",
        " brave "                   => " adventurous ",
        " braveness "               => " backbone ",
        " bravery "                 => " courage ",
        " bravo "                   => " acclaim ",
        " bravura "                 => " adventuresomeness ",
        " brawl "                   => " affray ",
        " brawling "                => " bouncy ",
        " brawn "                   => " beef ",
        " brawniness "              => " backbone ",
        " brawny "                  => " able-bodied ",
        " bray "                    => " bark ",
        " braying "                 => " absonant ",
        " braze "                   => " affix ",
        " brazen "                  => " audacious ",
        " brazenfaced "             => " arrant ",
        " brazenly "                => " aboveboard ",
        " brazenness "              => " audacity ",
        " brazier "                 => " brazier ",
        " breach "                  => " aperture ",
        " bread "                   => " aliment ",
        " bread-and-butter "        => " bread-and-butter ",
        " breadbasket "             => " belly ",
        " breadth "                 => " across ",
        " breadwinner "             => " agent ",
        " break "                   => " breach ",
        " break-off "               => " abeyance ",
        " break-up "                => " alienation ",
        " breakable "               => " brittle ",
        " breakage "                => " accident ",
        " breaker "                 => " breaker ",
        " breakneck "               => " alarming ",
        " breakout "                => " blemish ",
        " breaks "                  => " break ",
        " breakthrough "            => " advance ",
        " breakup "                 => " breakdown ",
        " breakwater "              => " anchorage ",
        " breast-stroke "           => " bathe ",
        " breastwork "              => " breastwork ",
        " breath "                  => " animation ",
        " breather "                => " blow ",
        " breathing "               => " breath ",
        " breathless "              => " asthmatic ",
        " breathtaking "            => " amazing ",
        " breathy "                 => " blatant ",
        " breech "                  => " backside ",
        " breed "                   => " brand ",
        " breeder "                 => " agriculturalist ",
        " breeding "                => " ancestry ",
        " breedy "                  => " abundant ",
        " breezily "                => " agilely ",
        " breezy "                  => " airy ",
        " brethren "                => " aggregation ",
        " brevet "                  => " agency ",
        " breviary "                => " abstract ",
        " breviloquent "            => " barefaced ",
        " brew "                    => " beverage ",
        " brewed "                  => " brewed ",
        " brewis "                  => " aliment ",
        " briar "                   => " backcountry ",
        " bribable "                => " base ",
        " bribe "                   => " allurement ",
        " bribery "                 => " bribery ",
        " bribing "                 => " bribery ",
        " bric-a-brac "             => " bagatelle ",
        " brickbat "                => " abuse ",
        " brickbats "               => " animadversion ",
        " bricks "                  => " artery ",
        " bridal "                  => " conjugal ",
        " bride "                   => " helpmate ",
        " bridegroom "              => " benedict ",
        " bridge "                  => " arch ",
        " bridle "                  => " check ",
        " brief "                   => " abrupt ",
        " briefcase "               => " attache ",
        " briefed "                 => " abreast ",
        " briefing "                => " conference ",
        " briefly "                 => " briefly ",
        " brier "                   => " brier ",
        " briery "                  => " annoying ",
        " brigade "                 => " army ",
        " brigand "                 => " brigand ",
        " bright "                  => " ablaze ",
        " brightening "             => " brightening ",
        " brightly "                => " blithely ",
        " brightness "              => " accuracy ",
        " brilliance "              => " accuracy ",
        " brilliancy "              => " aurora ",
        " brilliant "               => " ablaze ",
        " brilliantly "             => " blithely ",
        " brim "                    => " border ",
        " brimful "                 => " awash ",
        " brimming "                => " awash ",
        " brindle "                 => " brindle ",
        " brindled "                => " brindle ",
        " brine "                   => " alkali ",
        " bring "                   => " accompany ",
        " brininess "               => " acerbity ",
        " brink "                   => " border ",
        " brinksmanship "           => " accident ",
        " briny "                   => " blue ",
        " brio "                    => " action ",
        " brisk "                   => " active ",
        " briskly "                 => " agilely ",
        " briskness "               => " activity ",
        " bristle "                 => " barb ",
        " bristles "                => " bristles ",
        " bristling "               => " bristling ",
        " bristly "                 => " barbate ",
        " brittle "                 => " breakable ",
        " broach "                  => " advance ",
        " broad "                   => " ample ",
        " broad-minded "            => " advanced ",
        " broad-mindedness "        => " broad-mindedness ",
        " broadcast "               => " advertisement ",
        " broadcaster "             => " anchorperson ",
        " broaden "                 => " augment ",
        " broadening "              => " adorning ",
        " broadly "                 => " broadly ",
        " broadness "               => " across ",
        " broadside "               => " battery ",
        " brocade "                 => " adornment ",
        " brocard "                 => " adage ",
        " brochure "                => " advertisement ",
        " brogue "                  => " accent ",
        " broil "                   => " bake ",
        " broiled "                 => " broiled ",
        " broiler "                 => " broiler ",
        " broiling "                => " baking ",
        " broke "                   => " bankrupt ",
        " broken "                  => " burst ",
        " broken-down "             => " aged ",
        " broken-hearted "          => " anxious ",
        " brokenhearted "           => " crestfallen ",
        " broker "                  => " agent ",
        " brokerage "               => " allowance ",
        " bromide "                 => " boiler ",
        " bromidic "                => " blah ",
        " bronco "                  => " bearcat ",
        " bronze "                  => " brownish ",
        " bronzed "                 => " blooming ",
        " brooch "                  => " brooch ",
        " brood "                   => " breed ",
        " brooder "                 => " autist ",
        " brooding "                => " absorption ",
        " broody "                  => " abject ",
        " brook "                   => " beck ",
        " brooklet "                => " brook ",
        " broom "                   => " besom ",
        " broomstick "              => " angular ",
        " broth "                   => " borsch ",
        " brotherhood "             => " alliance ",
        " brotherliness "           => " affiliation ",
        " brotherly "               => " affectionate ",
        " brouhaha "                => " agitation ",
        " brow "                    => " countenance ",
        " browbeat "                => " badger ",
        " browbeaten "              => " beaten ",
        " browbeater "              => " annoyer ",
        " browbeating "             => " browbeating ",
        " brown "                   => " amber ",
        " brown-nose "              => " apple-polish ",
        " brown-nosing "            => " abject ",
        " brownie "                 => " credibility ",
        " brownish "                => " brownish ",
        " brownnose "               => " ass-kisser ",
        " brownnoser "              => " adulator ",
        " brownout "                => " black ",
        " bruise "                  => " abrasion ",
        " bruised "                 => " aching ",
        " bruiser "                 => " able-bodied ",
        " bruising "                => " able-bodied ",
        " brumal "                  => " algid ",
        " brume "                   => " billow ",
        " brummagem "               => " affected ",
        " brunch "                  => " brunch ",
        " brunet "                  => " bistered ",
        " brunette "                => " bistered ",
        " brunt "                   => " burden ",
        " brush "                   => " besom ",
        " brush-off "               => " action ",
        " brushing "                => " abrasion ",
        " brushoff "                => " apathy ",
        " brushwood "               => " bracken ",
        " brusque "                 => " abrupt ",
        " brutal "                  => " barbarous ",
        " brutality "               => " atrocity ",
        " brutalize "               => " adulterate ",
        " brutally "                => " atrociously ",
        " brute "                   => " animal ",
        " brutish "                 => " beastly ",
        " brutishly "               => " atrociously ",
        " brutishness "             => " atrocity ",
        " bubble "                  => " balloon ",
        " bubbleheaded "            => " airheaded ",
        " bubbler "                 => " bubbler ",
        " bubbling "                => " bubbles ",
        " bubbly "                  => " aerated ",
        " buccaneer "               => " bandit ",
        " buck "                    => " blade ",
        " buckboard "               => " agent ",
        " bucked "                  => " airy ",
        " bucket "                  => " brazier ",
        " bucking "                 => " bucking ",
        " buckle "                  => " catch ",
        " buckled "                 => " askance ",
        " buckler "                 => " absorber ",
        " buckling "                => " accedence ",
        " buckram "                 => " annealed ",
        " bucksaw "                 => " apparatus ",
        " buckshot "                => " armament ",
        " buckwheater "             => " abecedarian ",
        " bucolic "                 => " awkward ",
        " budding "                 => " beginning ",
        " buddy "                   => " associate ",
        " buddy-buddy "             => " affable ",
        " budget "                  => " account ",
        " budgetary "               => " bread-and-butter ",
        " budgeted "                => " approaching ",
        " budgeting "               => " allotment ",
        " bueno "                   => " admirable ",
        " buff "                    => " addict ",
        " buffalo "                 => " addle ",
        " buffaloed "               => " agape ",
        " buffer "                  => " absorber ",
        " buffet "                  => " cafe ",
        " buffeted "                => " aching ",
        " buffeting "               => " blow ",
        " buffoon "                 => " antic ",
        " buffoonery "              => " absurdity ",
        " bugaboo "                 => " albatross ",
        " bugbear "                 => " abomination ",
        " bugged "                  => " ashamed ",
        " bugger "                  => " accoutrement ",
        " bughouse "                => " bedlam ",
        " bugle "                   => " adenoids ",
        " build "                   => " body ",
        " build-up "                => " accession ",
        " builder "                 => " architect ",
        " building "                => " architecture ",
        " buildings "               => " barrio ",
        " buildup "                 => " accretion ",
        " built "                   => " congenital ",
        " built-in "                => " congenital ",
        " bulb "                    => " ball ",
        " bulbous "                 => " annular ",
        " bulge "                   => " appendage ",
        " bulged "                  => " arched ",
        " bulging "                 => " billowing ",
        " bulgy "                   => " bouncing ",
        " bulk "                    => " aggregate ",
        " bulkiest "                => " better ",
        " bulkiness "               => " bulkiness ",
        " bulky "                   => " beefy ",
        " bull "                    => " balderdash ",
        " bull-headed "             => " awkward ",
        " bulla "                   => " abscess ",
        " bulldog "                 => " bi-weekly ",
        " bulldogged "              => " assiduous ",
        " bulldoze "                => " drive ",
        " bulldozed "               => " austere ",
        " bulldozer "               => " annoyer ",
        " bullet "                  => " ammo ",
        " bulletin "                => " account ",
        " bullhead "                => " adamant ",
        " bullheaded "              => " blind ",
        " bullheadedness "          => " bloomer ",
        " bullied "                 => " afraid ",
        " bullion "                 => " banknote ",
        " bullpen "                 => " abode ",
        " bulls "                   => " beasts ",
        " bullshit "                => " babble ",
        " bullshitting "            => " aureate ",
        " bullwork "                => " backbreaker ",
        " bully "                   => " annoyer ",
        " bullying "                => " blowing ",
        " bullyrag "                => " alarm ",
        " bulwark "                 => " barrier ",
        " bumble "                  => " blow ",
        " bummed "                  => " abject ",
        " bummer "                  => " affliction ",
        " bumming "                 => " aimless ",
        " bump "                    => " bang ",
        " bump-off "                => " assassination ",
        " bumper "                  => " bonanza ",
        " bumpkin "                 => " barbarian ",
        " bumptious "               => " arrogant ",
        " bumpy "                   => " aflutter ",
        " bunch "                   => " agglomeration ",
        " bunchalliance "           => " amalgamation ",
        " bunched "                 => " bunched ",
        " bunching "                => " appendage ",
        " bunco "                   => " affect ",
        " bundle "                  => " array ",
        " bundled "                 => " arranged ",
        " bung "                    => " arrest ",
        " bungle "                  => " boggle ",
        " bunion "                  => " abscess ",
        " bunk "                    => " applesauce ",
        " bunker "                  => " alembic ",
        " bunko "                   => " bait-and-switch ",
        " bunkum "                  => " balderdash ",
        " bunt "                    => " butt ",
        " bunting "                 => " banderole ",
        " buoy "                    => " beacon ",
        " buoyance "                => " airiness ",
        " buoyancy "                => " airiness ",
        " buoyant "                 => " afloat ",
        " burble "                  => " blubbering ",
        " burbling "                => " barmy ",
        " burden "                  => " accountability ",
        " burdened "                => " abounding ",
        " burdensome "              => " crushing ",
        " burdensomely "            => " agonizingly ",
        " bureau "                  => " agency ",
        " bureaucracy "             => " authority ",
        " bureaucrat "              => " ambassador ",
        " bureaucratic "            => " authoritative ",
        " burette "                 => " basin ",
        " burg "                    => " apple ",
        " burgee "                  => " banderole ",
        " burgeoning "              => " beginning ",
        " burgess "                 => " aborigine ",
        " burghal "                 => " burghal ",
        " burgher "                 => " aborigine ",
        " burglary "                => " break-in ",
        " burgoo "                  => " bouillon ",
        " burgundy "                => " bittersweet ",
        " burial "                  => " burying ",
        " buried "                  => " active ",
        " burl "                    => " bulge ",
        " burlesque "               => " caricatural ",
        " burly "                   => " able-bodied ",
        " burn "                    => " bake ",
        " burnable "                => " burnable ",
        " burned "                  => " austere ",
        " burning "                 => " afire ",
        " burnish "                 => " brighten ",
        " burnished "               => " ablaze ",
        " burnout "                 => " addict ",
        " burr "                    => " brier ",
        " burrow "                  => " couch ",
        " bursa "                   => " atrium ",
        " bursar "                  => " accountant ",
        " burst "                   => " access ",
        " bursting "                => " beginning ",
        " burt "                    => " afflicted ",
        " burthen "                 => " albatross ",
        " bury "                    => " coffin ",
        " burying "                 => " burying ",
        " bush "                    => " backcountry ",
        " bush-league "             => " bush ",
        " bushel "                  => " bassinet ",
        " bushing "                 => " bushing ",
        " bushman "                 => " aborigine ",
        " bushwhack "               => " ambuscade ",
        " bushwhacker "             => " aggressor ",
        " bushy "                   => " bristling ",
        " businesslike "            => " accomplished ",
        " businessman "             => " agent ",
        " businesswoman "           => " baron ",
        " busline "                 => " busline ",
        " bust "                    => " apprehension ",
        " busted "                  => " bankrupt ",
        " bustling "                => " alive ",
        " busty "                   => " ample ",
        " busy "                    => " active ",
        " busyness "                => " assiduity ",
        " butcher "                 => " boner ",
        " butchering "              => " annihilation ",
        " butchery "                => " annihilation ",
        " butt "                    => " base ",
        " butte "                   => " acropolis ",
        " butter "                  => " adulate ",
        " butterball "              => " beefy ",
        " butterflies "             => " collywobbles ",
        " buttery "                 => " buttery ",
        " buttinski "               => " adviser ",
        " button-down "             => " accepted ",
        " buttonhole "              => " address ",
        " buttress "                => " abutment ",
        " buxom "                   => " ample ",
        " buyback "                 => " acknowledgment ",
        " buyer "                   => " client ",
        " buying "                  => " affairs ",
        " buyoff "                  => " allurement ",
        " buzz "                    => " fizz ",
        " buzz-buzz "               => " babel ",
        " buzzard "                 => " banty ",
        " buzzed "                  => " bashed ",
        " buzzing "                 => " active ",
        " buzzword "                => " boiler ",
        " buzzwords "               => " abracadabra ",
        " by-and-by "               => " afterlife ",
        " by-election "             => " acclamation ",
        " by-place "                => " breach ",
        " by-product "              => " by-product ",
        " by-the-way "              => " accidental ",
        " bye-bye "                 => " adieu ",
        " bygone "                  => " ancient ",
        " byname "                  => " byname ",
        " byplay "                  => " accomplishment ",
        " bystander "               => " eyewitness ",
        " bystanding "              => " aloof ",
        " byway "                   => " aisle ",
        " byword "                  => " adage ",
        " cabal "                   => " assembly ",
        " cabalistic "              => " cabalistic ",
        " cabbage "                 => " banknote ",
        " cabin "                   => " berth ",
        " cabinet "                 => " chiffonier ",
        " cabinet-maker "           => " artisan ",
        " cablegram "               => " buzzer ",
        " cablevision "             => " cable ",
        " caboose "                 => " berth ",
        " cache "                   => " accumulation ",
        " cached "                  => " buried ",
        " cachet "                  => " cachet ",
        " cachexia "                => " affliction ",
        " cachinnate "              => " beam ",
        " cachinnation "            => " amusement ",
        " cackle "                  => " babble ",
        " cacographic "             => " cacographic ",
        " cacophonic "              => " cacophonic ",
        " cacophonous "             => " clinking ",
        " cacophony "               => " cacophony ",
        " cadaver "                 => " body ",
        " cadaverous "              => " ashen ",
        " cadence "                 => " accent ",
        " cadency "                 => " cadence ",
        " cadet "                   => " buck ",
        " cadge "                   => " batter ",
        " cadre "                   => " core ",
        " caduceus "                => " baton ",
        " caesar "                  => " absolutist ",
        " caesura "                 => " blow ",
        " cafe "                    => " bistro ",
        " caftan "                  => " bathrobe ",
        " caged "                   => " bound ",
        " cagey "                   => " active ",
        " cahoots "                 => " amalgamation ",
        " cairn "                   => " abundance ",
        " caitiff "                 => " alarmist ",
        " cajolery "                => " adulation ",
        " cake "                    => " block ",
        " caked "                   => " caked ",
        " cakewalk "                => " breeze ",
        " caking "                  => " band ",
        " calamitous "              => " adverse ",
        " calamus "                 => " calamus ",
        " calcified "               => " caked ",
        " calcify "                 => " amalgamate ",
        " calcine "                 => " bake ",
        " calculable "              => " accountable ",
        " calculate "               => " account ",
        " calculated "              => " affected ",
        " calculating "             => " artful ",
        " calculatingly "           => " advisedly ",
        " calculation "             => " adding ",
        " calculous "               => " abrasive ",
        " calefaction "             => " calefaction ",
        " calefactor "              => " boiler ",
        " calembour "               => " ambiguity ",
        " calendar "                => " agenda ",
        " calescent "               => " ardent ",
        " calf "                    => " dogie ",
        " caliber "                 => " ability ",
        " calibration "             => " arrangement ",
        " calidity "                => " calefaction ",
        " caliginosity "            => " caliginosity ",
        " caliginous "              => " aphotic ",
        " caliph "                  => " absolutist ",
        " calisthenics "            => " calisthenics ",
        " call "                    => " alarm ",
        " called "                  => " alleged ",
        " called-for "              => " burning ",
        " caller "                  => " addition ",
        " callibogus "              => " alcohol ",
        " calligraphy "             => " calligraphy ",
        " callous "                 => " apathetic ",
        " callously "               => " atrociously ",
        " callousness "             => " bawdiness ",
        " callow "                  => " green ",
        " callowness "              => " bloom ",
        " calmative "               => " balmy ",
        " calming "                 => " abstracted ",
        " calmly "                  => " calmly ",
        " calmness "                => " calmness ",
        " calumet "                 => " aqueduct ",
        " calumniate "              => " asperse ",
        " calumniating "            => " calumniating ",
        " calumniation "            => " abuse ",
        " calumniator "             => " adversary ",
        " calumniatory "            => " analytical ",
        " calumnious "              => " abusive ",
        " calumny "                 => " abuse ",
        " calvary "                 => " affliction ",
        " calves "                  => " beasts ",
        " camaraderie "             => " brotherhood ",
        " camarilla "               => " assembly ",
        " camel "                   => " biscuit ",
        " camels "                  => " band ",
        " cameo "                   => " adornment ",
        " camera-eye "              => " anamnesis ",
        " camouflage "              => " appearance ",
        " camouflaged "             => " buried ",
        " camp "                    => " affected ",
        " campaign "                => " attack ",
        " campaigner "              => " apostle ",
        " campaigning "             => " advancement ",
        " campanology "             => " campanology ",
        " campers "                 => " band ",
        " campfire "                => " bivouac ",
        " campground "              => " bivouac ",
        " campsite "                => " bivouac ",
        " campy "                   => " apish ",
        " can-opener "              => " apparatus ",
        " canaille "                => " assemblage ",
        " canal "                   => " aqueduct ",
        " canard "                  => " canard ",
        " canary "                  => " bare ",
        " cancel "                  => " abolish ",
        " canceling "               => " abandoning ",
        " cancellation "            => " abandoning ",
        " cancelled "               => " annulled ",
        " cancer "                  => " blight ",
        " cancerous "               => " annihilative ",
        " candelabrum "             => " candelabra ",
        " candescence "             => " agitation ",
        " candid "                  => " aboveboard ",
        " candidacy "               => " antagonism ",
        " candidate "               => " applicant ",
        " candidature "             => " campaigning ",
        " candidly "                => " candidly ",
        " candidness "              => " bluntness ",
        " candleholder "            => " candelabrum ",
        " candor "                  => " artlessness ",
        " candy "                   => " bonbon ",
        " candy-coated "            => " candied ",
        " cane "                    => " pikestaff ",
        " canicule "                => " canicule ",
        " canine "                  => " basset ",
        " canister "                => " brazier ",
        " canker "                  => " bane ",
        " cankerous "               => " abrasive ",
        " cannibal "                => " aborigine ",
        " cannibalistic "           => " baleful ",
        " cannikin "                => " bottle ",
        " canniness "               => " artfulness ",
        " canning "                 => " canning ",
        " cannonade "               => " battery ",
        " cannonball "              => " armament ",
        " canny "                   => " able ",
        " canoeing "                => " canoeing ",
        " canon "                   => " assize ",
        " canonical "               => " approved ",
        " canonist "                => " accepter ",
        " canonization "            => " account ",
        " canonize "                => " apotheosize ",
        " canonizing "              => " canonizing ",
        " canonry "                 => " arms ",
        " canoodle "                => " bundle ",
        " canopy "                  => " awning ",
        " canorous "                => " accordant ",
        " cant "                    => " deceit ",
        " cantankerous "            => " bad-tempered ",
        " canter "                  => " amble ",
        " canticle "                => " canticle ",
        " cantilever "              => " axle ",
        " canting "                 => " apostate ",
        " cantlet "                 => " atom ",
        " canton "                  => " accommodate ",
        " cantonment "              => " billet ",
        " canvass "                 => " agitate ",
        " canvassing "              => " campaigning ",
        " canyon "                  => " coulee ",
        " capability "              => " adequacy ",
        " capable "                 => " able ",
        " capableness "             => " ability ",
        " capably "                 => " abundantly ",
        " capacious "               => " abundant ",
        " capaciously "             => " abundantly ",
        " capaciousness "           => " admeasurement ",
        " capacity "                => " accommodation ",
        " capeesh "                 => " appreciate ",
        " caper "                   => " escapade ",
        " capering "                => " amusing ",
        " capital "                 => " basic ",
        " capitalism "              => " commercialism ",
        " capitalist "              => " backer ",
        " capitalization "          => " assets ",
        " capitulation "            => " accedence ",
        " capon "                   => " banty ",
        " caponize "                => " alter ",
        " capote "                  => " capote ",
        " capper "                  => " acme ",
        " capricious "              => " arbitrary ",
        " capriciousness "          => " aberration ",
        " capsheaf "                => " acme ",
        " capsize "                 => " invert ",
        " capsized "                => " agitated ",
        " capstone "                => " apogee ",
        " capsule "                 => " abridged ",
        " caption "                 => " explanation ",
        " captious "                => " acrimonious ",
        " captivate "               => " allure ",
        " captivated "              => " captivated ",
        " captivating "             => " arresting ",
        " captivatingness "         => " allure ",
        " captivation "             => " captivation ",
        " captive "                 => " bound ",
        " captivity "               => " bondage ",
        " capture "                 => " abduction ",
        " caracole "                => " caper ",
        " carafe "                  => " canteen ",
        " carapace "                => " carapace ",
        " caravan "                 => " band ",
        " caravansary "             => " bivouac ",
        " carbon "                  => " carbon ",
        " carbonize "               => " burn ",
        " carbuncle "               => " abscess ",
        " carcass "                 => " body ",
        " carcinogenic "            => " baleful ",
        " carcinoma "               => " blight ",
        " card "                    => " agenda ",
        " card-carrying "           => " accustomed ",
        " cardboard "               => " agenda ",
        " cardinal "                => " basal ",
        " cardinally "              => " accordingly ",
        " cardsharp "               => " bastard ",
        " cardsharper "             => " bandit ",
        " care "                    => " affliction ",
        " careen "                  => " bend ",
        " carefree "                => " airy ",
        " careful "                 => " accurate ",
        " carefully "               => " anxiously ",
        " carefulness "             => " accurateness ",
        " careless "                => " absent-minded ",
        " carelessly "              => " abominably ",
        " carelessness "            => " carelessness ",
        " caress "                  => " cuddle ",
        " caressible "              => " caressible ",
        " caretaker "               => " babysitter ",
        " caretaking "              => " affectionate ",
        " careworn "                => " ashen ",
        " cargo "                   => " burden ",
        " caricatural "             => " caricatural ",
        " caricature "              => " burlesque ",
        " caricaturist "            => " artist ",
        " caries "                  => " atrium ",
        " carillon "                => " angelus ",
        " cariosity "               => " adulteration ",
        " carious "                 => " addle ",
        " caritas "                 => " affection ",
        " cark "                    => " affront ",
        " carmine "                 => " bittersweet ",
        " carnage "                 => " annihilation ",
        " carnal "                  => " animal ",
        " carnality "               => " animality ",
        " carnivorous "             => " cannibal ",
        " carom "                   => " backlash ",
        " carousal "                => " affair ",
        " carouse "                 => " booze ",
        " carousing "               => " affair ",
        " carp "                    => " bother ",
        " carpet "                  => " carpeting ",
        " carpeting "               => " carpeting ",
        " carping "                 => " acrimonious ",
        " carport "                 => " barn ",
        " carrel "                  => " berth ",
        " carriage "                => " carrying ",
        " carriageable "            => " carriageable ",
        " carried "                 => " agitated ",
        " carrion "                 => " ashes ",
        " carrot "                  => " allotment ",
        " carry "                   => " backpack ",
        " carry-on "                => " attache ",
        " carry-over "              => " butt ",
        " carryall "                => " attache ",
        " carrying "                => " accustomed ",
        " carrying-on "             => " absurdity ",
        " carrying-out "            => " advocacy ",
        " carryover "               => " aftereffect ",
        " cart "                    => " barrow ",
        " cartable "                => " carriageable ",
        " cartage "                 => " cartage ",
        " cartel "                  => " bunch ",
        " cartilage "               => " cartilage ",
        " carting "                 => " carriage ",
        " cartography "             => " cartography ",
        " cartoon "                 => " animation ",
        " cartoonist "              => " artist ",
        " cartouche "               => " ball ",
        " cartridge "               => " armament ",
        " cartulary "               => " archive ",
        " caruncle "                => " aigrette ",
        " carving "                 => " abstraction ",
        " caryatid "                => " brace ",
        " caryopsis "               => " achene ",
        " casa "                    => " address ",
        " cascade "                 => " avalanche ",
        " cascading "               => " bottomward ",
        " case-hardened "           => " apathetic ",
        " caseation "               => " agglomeration ",
        " casework "                => " casework ",
        " cash "                    => " banknote ",
        " casher "                  => " beneficiary ",
        " cashier "                 => " accountant ",
        " casing "                  => " case ",
        " casino "                  => " bank ",
        " cask "                    => " barillet ",
        " casserole "               => " goulash ",
        " casseroles "              => " buffet ",
        " cassock "                 => " abbey ",
        " cast "                    => " casting ",
        " caste "                   => " degree ",
        " caster "                  => " alembic ",
        " castigate "               => " baste ",
        " castigating "             => " calumniating ",
        " castigation "             => " blame ",
        " casting "                 => " casting ",
        " castle "                  => " alcazar ",
        " castle-building "         => " acuteness ",
        " castling "                => " barter ",
        " castoff "                 => " abandoned ",
        " castor "                  => " brush ",
        " castrate "                => " alter ",
        " casual "                  => " accidental ",
        " casually "                => " accidentally ",
        " casualty "                => " blow ",
        " casuist "                 => " actor ",
        " casuistic "               => " ambiguous ",
        " casuistical "             => " ambiguous ",
        " casuistry "               => " chicanery ",
        " cat-and-dog "             => " argumentative ",
        " cat-and-mouse "           => " cat-and-mouse ",
        " catachresis "             => " atrocity ",
        " catachrestic "            => " benighted ",
        " cataclysm "               => " calamity ",
        " cataclysmal "             => " adverse ",
        " cataclysmic "             => " adverse ",
        " catafalque "              => " casket ",
        " catalog "                 => " archive ",
        " catalogue "               => " archive ",
        " cataloguing "             => " allocation ",
        " catalyst "                => " agitator ",
        " catalyze "                => " activate ",
        " catamaran "               => " baiter ",
        " catapult "                => " ballista ",
        " cataract "                => " avalanche ",
        " cataracts "               => " amaurosis ",
        " catastrophe "             => " accident ",
        " catastrophic "            => " adverse ",
        " catatonia "               => " anguish ",
        " catawampus "              => " askance ",
        " catch "                   => " bolt ",
        " catch-all "               => " across-the-board ",
        " catchbasin "              => " catchbasin ",
        " catching "                => " communicable ",
        " catchphrase "             => " adage ",
        " catchpole "               => " agent ",
        " catchword "               => " byword ",
        " catchy "                  => " addictive ",
        " catechism "               => " canon ",
        " catechized "              => " able ",
        " catechizing "             => " analysis ",
        " catechumen "              => " abecedarian ",
        " categorical "             => " absolute ",
        " categorically "           => " actually ",
        " categorization "          => " analysis ",
        " categorize "              => " assort ",
        " categorizing "            => " allocation ",
        " category "                => " class ",
        " catena "                  => " alternation ",
        " catenary "                => " ambit ",
        " catenate "                => " accompany ",
        " catenation "              => " arrangement ",
        " cater "                   => " baby ",
        " cater-corner "            => " aslant ",
        " cater-cornered "          => " askew ",
        " catering "                => " accouterment ",
        " caterwaul "               => " bawl ",
        " caterwauling "            => " acrid ",
        " catfight "                => " affray ",
        " catharsis "               => " ablution ",
        " cathartic "               => " abrasive ",
        " cathedra "                => " administrative ",
        " cathedral "               => " basilica ",
        " catholic "                => " all-embracing ",
        " catlike "                 => " catlike ",
        " catnap "                  => " catnap ",
        " cats "                    => " bodies ",
        " cattiness "               => " abuse ",
        " cattle "                  => " beasts ",
        " catty "                   => " backbiting ",
        " catty-corner "            => " aslant ",
        " catwalk "                 => " balustrade ",
        " caucus "                  => " conclave ",
        " caught "                  => " bent ",
        " cauldron "                => " alembic ",
        " caulk "                   => " barricade ",
        " causality "               => " agent ",
        " causation "               => " account ",
        " causative "               => " adroit ",
        " causatum "                => " after-effects ",
        " cause "                   => " account ",
        " caused "                  => " acquired ",
        " causeless "               => " assumed ",
        " causerie "                => " causerie ",
        " caustic "                 => " abrasive ",
        " causticity "              => " causticity ",
        " causticness "             => " acrimony ",
        " cauterize "               => " bake ",
        " caution "                 => " attention ",
        " cautioning "              => " admonishing ",
        " cautious "                => " alert ",
        " cautiously "              => " carefully ",
        " cavalcade "               => " array ",
        " cavalier "                => " condescending ",
        " cavalry "                 => " army ",
        " cave "                    => " cavern ",
        " caveat "                  => " admonition ",
        " cavern "                  => " cave ",
        " cavernous "               => " alveolate ",
        " cavil "                   => " altercate ",
        " caviling "                => " acrimonious ",
        " cavillous "               => " acrimonious ",
        " cavity "                  => " atrium ",
        " cavort "                  => " caper ",
        " cavorting "               => " antic ",
        " cease-fire "              => " accord ",
        " ceased "                  => " accomplished ",
        " ceasefire "               => " armistice ",
        " ceaseless "               => " amaranthine ",
        " ceasing "                 => " abeyance ",
        " cede "                    => " abalienate ",
        " ceiling "                 => " beam ",
        " celebrate "               => " bless ",
        " celebrated "              => " acclaimed ",
        " celebrating "             => " adulatory ",
        " celebration "             => " anniversary ",
        " celebrative "             => " canonizing ",
        " celebratory "             => " celebratory ",
        " celerity "                => " alacrity ",
        " celestial "               => " angelic ",
        " celestially "             => " alluringly ",
        " celiac "                  => " abdominals ",
        " celibacy "                => " abstention ",
        " celibate "                => " chaste ",
        " cell "                    => " corpuscle ",
        " cellar "                  => " apartment ",
        " cellophane "              => " cellophane ",
        " cells "                   => " beef ",
        " cellulite "               => " blubber ",
        " cellulose "               => " artificial ",
        " cement "                  => " adhesive ",
        " cementation "             => " adherence ",
        " cemented "                => " anchored ",
        " cenobite "                => " abbot ",
        " cenotaph "                => " cairn ",
        " censor "                  => " abridge ",
        " censorious "              => " accusatory ",
        " censurable "              => " amiss ",
        " censure "                 => " admonishment ",
        " censured "                => " accusable ",
        " censuring "               => " analytical ",
        " census "                  => " demography ",
        " centennial "              => " bazaar ",
        " center "                  => " centermost ",
        " centerfold "              => " adorable ",
        " centering "               => " absorption ",
        " centermost "              => " centermost ",
        " central "                 => " axial ",
        " centrality "              => " axis ",
        " centralization "          => " absorption ",
        " centralize "              => " accumulate ",
        " centralized "             => " centralized ",
        " centric "                 => " axial ",
        " centriole "               => " axis ",
        " centroidal "              => " axial ",
        " centrolineal "            => " allied ",
        " centrum "                 => " axis ",
        " century "                 => " aeon ",
        " cephalalgia "             => " cephalalgia ",
        " ceramic "                 => " bowl ",
        " ceramics "                => " ceramics ",
        " cerate "                  => " analgesic ",
        " cereal "                  => " atom ",
        " cereb "                   => " auger ",
        " cerebral "                => " bookish ",
        " cerebrate "               => " brainstorm ",
        " cerebration "             => " brainwork ",
        " cerebus "                 => " babysitter ",
        " ceremonial "              => " august ",
        " ceremonialistic "         => " academic ",
        " ceremonialize "           => " bless ",
        " ceremonious "             => " civil ",
        " ceremoniousness "         => " appropriateness ",
        " ceremony "                => " commemoration ",
        " cerise "                  => " blooming ",
        " cert "                    => " absolutely ",
        " certain "                 => " assertive ",
        " certainly "               => " absolutely ",
        " certainty "               => " authoritativeness ",
        " certifiable "             => " certifiable ",
        " certificate "             => " affidavit ",
        " certification "           => " acceptance ",
        " certify "                 => " accredit ",
        " certitude "               => " aggressiveness ",
        " cerulean "                => " azure ",
        " cess "                    => " assessment ",
        " cessation "               => " abeyance ",
        " cesspool "                => " cesspool ",
        " chafe "                   => " abrade ",
        " chafed "                  => " affronted ",
        " chaff "                   => " crust ",
        " chaffer "                 => " bargain ",
        " chaffing "                => " badinage ",
        " chafing "                 => " abrading ",
        " chagrin "                 => " annoyance ",
        " chagrined "               => " ashamed ",
        " chain "                   => " alternation ",
        " chains "                  => " chains ",
        " chair "                   => " armchair ",
        " chairman "                => " administrator ",
        " chairperson "             => " administrator ",
        " chairwoman "              => " administrator ",
        " chaise "                  => " bassinet ",
        " chalet "                  => " berth ",
        " chalice "                 => " beaker ",
        " chalk "                   => " book ",
        " chalky "                  => " anemic ",
        " challenge "               => " claiming ",
        " challenger "              => " amateur ",
        " challenging "             => " arduous ",
        " chamber "                 => " alcove ",
        " chambered "               => " alveolate ",
        " chambermaid "             => " chambermaid ",
        " chambers "                => " accommodation ",
        " champagne "               => " albino ",
        " champaign "               => " area ",
        " champion "                => " best ",
        " championing "             => " advancement ",
        " chance "                  => " adventitious ",
        " chancel "                 => " basilica ",
        " chancellor "              => " adjudicator ",
        " chances "                 => " affairs ",
        " chanciness "              => " bulkiness ",
        " chancy "                  => " capricious ",
        " chandler "                => " banker ",
        " changeability "           => " airheadedness ",
        " changeable "              => " capricious ",
        " changeabout "             => " changeabout ",
        " changed "                 => " afflicted ",
        " changeful "               => " arbitrary ",
        " changeless "              => " abiding ",
        " changeover "              => " about-face ",
        " changer "                 => " banker ",
        " changing "                => " alteration ",
        " channel "                 => " approach ",
        " channelled "              => " channelled ",
        " chant "                   => " carol ",
        " chanter "                 => " accompanist ",
        " chanteuse "               => " accompanist ",
        " chantry "                 => " chantry ",
        " chaos "                   => " anarchy ",
        " chaotic "                 => " anarchic ",
        " chap "                    => " buck ",
        " chaparral "               => " bracken ",
        " chapel "                  => " abbey ",
        " chaperon "                => " babysitter ",
        " chaperone "               => " babysitter ",
        " chapfallen "              => " blue ",
        " chaplain "                => " clergyman ",
        " chaplet "                 => " chaplet ",
        " chapped "                 => " chapped ",
        " chapter "                 => " affiliate ",
        " chapterhouse "            => " abbey ",
        " chapters "                => " capacity ",
        " char "                    => " burn ",
        " character "               => " appearance ",
        " characteristic "          => " appropriate ",
        " characteristically "      => " artlessly ",
        " characterization "        => " assuming ",
        " characterizing "          => " anecdotic ",
        " characterless "           => " baggy ",
        " charade "                 => " deception ",
        " charcoal "                => " charcoal ",
        " charcoal-broil "          => " barbecue ",
        " charge "                  => " allegation ",
        " chargeable "              => " accountable ",
        " charged "                 => " answerable ",
        " charges "                 => " accuse ",
        " charily "                 => " cautiously ",
        " chariness "               => " acumen ",
        " chariot "                 => " agent ",
        " charisma "                => " allure ",
        " charismatic "             => " absorbing ",
        " charitable "              => " accommodating ",
        " charitableness "          => " candor ",
        " charitably "              => " accurately ",
        " charity "                 => " alms ",
        " charlatan "               => " charlatan ",
        " charm "                   => " agreeableness ",
        " charming "                => " absorbing ",
        " charmingly "              => " affably ",
        " charmingness "            => " allure ",
        " charred "                 => " broiled ",
        " charring "                => " blaze ",
        " chart "                   => " blueprint ",
        " charter "                 => " allotment ",
        " chartered "               => " accountant ",
        " charts "                  => " archive ",
        " charwoman "               => " charwoman ",
        " chary "                   => " cagey ",
        " chase "                   => " hunt ",
        " chaser "                  => " attorney ",
        " chasing "                 => " block ",
        " chasm "                   => " abysm ",
        " chasmal "                 => " alveolate ",
        " chasseurs "               => " army ",
        " chassis "                 => " anatomy ",
        " chaste "                  => " austere ",
        " chasten "                 => " abase ",
        " chastened "               => " apologetic ",
        " chasteness "              => " abstemiousness ",
        " chastening "              => " chastening ",
        " chastise "                => " baste ",
        " chastisement "            => " admonition ",
        " chastity "                => " abstemiousness ",
        " chat "                    => " babble ",
        " chateau "                 => " alcazar ",
        " chattel "                 => " article ",
        " chattels "                => " accouterments ",
        " chatter "                 => " babble ",
        " chatterer "               => " babbler ",
        " chattering "              => " chattering ",
        " chatty "                  => " communicative ",
        " chauffeur "               => " bear ",
        " chauvinism "              => " bellicism ",
        " chauvinistic "            => " antipathetic ",
        " chaw "                    => " chaw ",
        " cheap "                   => " bargain ",
        " cheapen "                 => " abase ",
        " cheapo "                  => " bargain ",
        " cheat "                   => " bluff ",
        " cheat-on "                => " arbitrary ",
        " cheater "                 => " bilker ",
        " cheating "                => " cheating ",
        " check "                   => " analysis ",
        " checked "                 => " arrested ",
        " checkerboard "            => " checkerboard ",
        " checkered "               => " checky ",
        " checking "                => " blockage ",
        " checklist "               => " account ",
        " checkmate "               => " arrest ",
        " checkmated "              => " balked ",
        " checkup "                 => " analysis ",
        " checky "                  => " checky ",
        " cheek "                   => " audacity ",
        " cheekiness "              => " arrogance ",
        " cheeky "                  => " bold ",
        " cheep "                   => " chip ",
        " cheer "                   => " acclamation ",
        " cheered "                 => " animated ",
        " cheerful "                => " airy ",
        " cheerfully "              => " affably ",
        " cheerfulness "            => " animation ",
        " cheerily "                => " acquiescently ",
        " cheeriness "              => " animation ",
        " cheering "                => " auspicious ",
        " cheerio "                 => " adieu ",
        " cheerless "               => " austere ",
        " cheerlessness "           => " abasement ",
        " cheers "                  => " acclaim ",
        " cheery "                  => " animated ",
        " cheesecake "              => " amazon ",
        " cheesy "                  => " abominable ",
        " cheetah "                 => " bobcat ",
        " chef "                    => " chef ",
        " chemical "                => " actinic ",
        " chemistry "               => " allure ",
        " cher "                    => " cher ",
        " cherish "                 => " admire ",
        " cherished "               => " admired ",
        " cherishing "              => " attention ",
        " cherry "                  => " blooming ",
        " cherubic "                => " adorable ",
        " chesterbed "              => " bassinet ",
        " chestnut "                => " chestnut ",
        " chesty "                  => " arrogant ",
        " chew "                    => " bite ",
        " chewing-out "             => " admonishment ",
        " chic "                    => " chichi ",
        " chicane "                 => " artifice ",
        " chicanery "               => " artifice ",
        " chichi "                  => " apish ",
        " chick "                   => " banty ",
        " chickadee "               => " banty ",
        " chicken "                 => " craven ",
        " chicken-heart "           => " alarmist ",
        " chicken-hearted "         => " abashed ",
        " chickenheartedness "      => " abhorrence ",
        " chicks "                  => " breed ",
        " chide "                   => " admonish ",
        " chiding "                 => " accusation ",
        " chief "                   => " arch ",
        " chieftain "               => " administrator ",
        " chiffon "                 => " chiffon ",
        " chiffonier "              => " chiffonier ",
        " chiffre "                 => " chiffre ",
        " child "                   => " adolescent ",
        " child-bearing "           => " changeable ",
        " childbearing "            => " bearing ",
        " childbed "                => " accouchement ",
        " childbirth "              => " accouchement ",
        " childhood "               => " adolescence ",
        " childing "                => " abundant ",
        " childish "                => " baby ",
        " childishness "            => " childishness ",
        " childlike "               => " artless ",
        " children "                => " accouchement ",
        " chill "                   => " arctic ",
        " chilled "                 => " algid ",
        " chiller "                 => " alarming ",
        " chilliness "              => " algidity ",
        " chilling "                => " air-conditioned ",
        " chilly "                  => " arctic ",
        " chime "                   => " bell ",
        " chimera "                 => " bubble ",
        " chimerical "              => " apparent ",
        " chimes "                  => " angelus ",
        " chiming "                 => " agreeable ",
        " chimney "                 => " chase ",
        " chin "                    => " button ",
        " chin-up "                 => " adventurous ",
        " china "                   => " ceramics ",
        " chine "                   => " aigrette ",
        " chinkle "                 => " chime ",
        " chintzy "                 => " chintzy ",
        " chip "                    => " dent ",
        " chipper "                 => " alert ",
        " chippy "                  => " argumentative ",
        " chiral "                  => " chiral ",
        " chirapsia "               => " beating ",
        " chirography "             => " calligraphy ",
        " chirp "                   => " call ",
        " chirpy "                  => " animated ",
        " chirrup "                 => " chip ",
        " chisel "                  => " blade ",
        " chiseled "                => " adamant ",
        " chiselled "               => " categorical ",
        " chiselling "              => " block ",
        " chitchat "                => " badinage ",
        " chivalric "               => " arresting ",
        " chivalrous "              => " benevolent ",
        " chivalry "                => " courage ",
        " chivy "                   => " bird-dog ",
        " choate "                  => " absolute ",
        " chock "                   => " brimming ",
        " chock-a-block "           => " brimming ",
        " chock-full "              => " brimming ",
        " chockablock "             => " abounding ",
        " chocolate "               => " amber ",
        " choice "                  => " best ",
        " choicy "                  => " acute ",
        " choir "                   => " choir ",
        " choke "                   => " asphyxiate ",
        " choked "                  => " afraid ",
        " choker "                  => " chaplet ",
        " choking "                 => " asthmatic ",
        " choky "                   => " airless ",
        " choler "                  => " acrimony ",
        " choleric "                => " affronted ",
        " cholesterol-filled "      => " blubbery ",
        " chomp "                   => " chaw ",
        " choose "                  => " accept ",
        " choosing "                => " allotment ",
        " choosy "                  => " dainty ",
        " chop-chop "               => " apace ",
        " chophouse "               => " bistro ",
        " choppy "                  => " inclement ",
        " choral "                  => " choral ",
        " chorale "                 => " choir ",
        " choralist "               => " accompanist ",
        " chord "                   => " ambit ",
        " chore "                   => " assignment ",
        " chores "                  => " affairs ",
        " chorister "               => " accompanist ",
        " choristers "              => " choir ",
        " chorography "             => " cartography ",
        " chortle "                 => " cackle ",
        " chortling "               => " amusement ",
        " chorus "                  => " choir ",
        " chosen "                  => " called ",
        " chouse "                  => " bamboozle ",
        " chowder "                 => " borsch ",
        " chrism "                  => " chrism ",
        " christen "                => " asperse ",
        " christening "             => " ablution ",
        " chroma "                  => " blush ",
        " chromatic "               => " bright ",
        " chromaticity "            => " blush ",
        " chromatism "              => " blush ",
        " chromism "                => " blush ",
        " chronic "                 => " abiding ",
        " chronicle "               => " account ",
        " chronicled "              => " actual ",
        " chroniker "               => " alarm ",
        " chronograph "             => " alarm ",
        " chronographic "           => " archival ",
        " chronologic "             => " archival ",
        " chronological "           => " archival ",
        " chronology "              => " agenda ",
        " chronometer "             => " alarm ",
        " chronometric "            => " archival ",
        " chronometrical "          => " archival ",
        " chronoscopic "            => " archival ",
        " chthonian "               => " accursed ",
        " chubby "                  => " ample ",
        " chuck "                   => " abandon ",
        " chucking "                => " auctioning ",
        " chuckle "                 => " cackle ",
        " chuckling "               => " amusement ",
        " chuff "                   => " barbarian ",
        " chuffy "                  => " acid ",
        " chug "                    => " choke ",
        " chugalug "                => " belt ",
        " chum "                    => " associate ",
        " chumminess "              => " affiliation ",
        " chummy "                  => " affectionate ",
        " chunk "                   => " block ",
        " chunky "                  => " beefy ",
        " church "                  => " abbey ",
        " churchgoers "             => " aggregation ",
        " churchly "                => " apostolic ",
        " churchman "               => " abbey ",
        " churl "                   => " boor ",
        " churlish "                => " base ",
        " churlishness "            => " acerbity ",
        " churn "                   => " agitate ",
        " churned "                 => " aerated ",
        " churr "                   => " chatter ",
        " chute "                   => " channel ",
        " chutzpah "                => " airs ",
        " cicatrice "               => " blister ",
        " cicatrix "                => " birthmark ",
        " cicerone "                => " adviser ",
        " cilia "                   => " cilia ",
        " cilium "                  => " beard ",
        " cinch "                   => " assert ",
        " cincher "                 => " affirmation ",
        " cinchers "                => " anchor ",
        " cinders "                 => " charcoal ",
        " cinematic "               => " accurate ",
        " cinematics "              => " cine ",
        " cinematograph "           => " cine ",
        " cinerator "               => " boiler ",
        " cinnamon "                => " biscuit ",
        " cipher "                  => " blank ",
        " ciphering "               => " adding ",
        " circa "                   => " about ",
        " circle "                  => " amphitheater ",
        " circlet "                 => " armlet ",
        " circling "                => " ambit ",
        " circuit "                 => " ambit ",
        " circuitry "               => " chip ",
        " circular "                => " annular ",
        " circularize "             => " acquaint ",
        " circulate "               => " broadcast ",
        " circulated "              => " broadcast ",
        " circulation "             => " apportionment ",
        " circulator "              => " babbler ",
        " circumambages "           => " circumambages ",
        " circumcised "             => " beneath ",
        " circumduct "              => " belt ",
        " circumference "           => " ambit ",
        " circumgyration "          => " apogee ",
        " circumlocate "            => " aberrate ",
        " circumlocute "            => " abstain ",
        " circumlocutory "          => " circumlocutory ",
        " circumnavigation "        => " ambit ",
        " circumscribed "           => " belted ",
        " circumscription "         => " abuttals ",
        " circumspect "             => " attentive ",
        " circumspection "          => " caution ",
        " circumspectly "           => " anxiously ",
        " circumstance "            => " accident ",
        " circumstances "           => " affairs ",
        " circumstantial "          => " amplified ",
        " circumstantiate "         => " affirm ",
        " circumstantiated "        => " accurate ",
        " circumvent "              => " avoid ",
        " circumvented "            => " baffled ",
        " circumvention "           => " abstention ",
        " circumvoluted "           => " circling ",
        " circumvolution "          => " ambit ",
        " circumvolve "             => " circle ",
        " circus "                  => " bazaar ",
        " cistern "                 => " alembic ",
        " citadel "                 => " bastion ",
        " citation "                => " commendation ",
        " cite "                    => " adduce ",
        " citified "                => " burghal ",
        " citing "                  => " citation ",
        " citizen "                 => " aborigine ",
        " city "                    => " burghal ",
        " civic "                   => " borough ",
        " civil "                   => " civilian ",
        " civilian "                => " noncombatant ",
        " civilities "              => " amenities ",
        " civility "                => " amenity ",
        " civilization "            => " acculturation ",
        " civilize "                => " acculturate ",
        " civilized "               => " affable ",
        " civilizing "              => " adorning ",
        " civvies "                 => " accouterment ",
        " clabber "                 => " clabber ",
        " clack "                   => " ballyhoo ",
        " claim "                   => " affirmation ",
        " claimant "                => " appellant ",
        " claimed "                 => " claimed ",
        " claiming "                => " claiming ",
        " clairvoyance "            => " acumen ",
        " clairvoyant "             => " clear-sighted ",
        " clam "                    => " mollusk ",
        " clamant "                 => " acute ",
        " clambake "                => " accumulation ",
        " clamber "                 => " ascend ",
        " clambering "              => " ascendance ",
        " clamlike "                => " backstairs ",
        " clamminess "              => " clamminess ",
        " clammy "                  => " close ",
        " clamor "                  => " agitation ",
        " clamorous "               => " boisterous ",
        " clamp "                   => " catch ",
        " clamper "                 => " chunk ",
        " clamping "                => " anchor ",
        " clan "                    => " association ",
        " clandestine "             => " artful ",
        " clandestineness "         => " aloofness ",
        " clang "                   => " blast ",
        " clanging "                => " acute ",
        " clangor "                 => " ballyhoo ",
        " clangorous "              => " cavernous ",
        " clannish "                => " akin ",
        " clap "                    => " applause ",
        " clapboard "               => " board ",
        " clapper "                 => " alarm ",
        " clapping "                => " acclamation ",
        " claps "                   => " catch ",
        " claptrap "                => " balderdash ",
        " claret "                  => " claret ",
        " clarification "           => " description ",
        " clarified "               => " antiseptic ",
        " clarify "                 => " analyze ",
        " clarifying "              => " allegorical ",
        " clarion "                 => " blaring ",
        " clarity "                 => " accuracy ",
        " clash "                   => " affray ",
        " clashing "                => " clashing ",
        " clasp "                   => " brooch ",
        " clasped "                 => " bound ",
        " class "                   => " chic ",
        " classic "                 => " archetypal ",
        " classicality "            => " artlessness ",
        " classicist "              => " archaeologian ",
        " classics "                => " abstract ",
        " classification "          => " allocation ",
        " classificatory "          => " anecdotic ",
        " classify "                => " allocate ",
        " classis "                 => " antiquarian ",
        " classmate "               => " acquaintance ",
        " classy "                  => " chic ",
        " clatter "                 => " ballyhoo ",
        " clattering "              => " blast ",
        " clattery "                => " blatant ",
        " clause "                  => " article ",
        " claviger "                => " babysitter ",
        " claw "                    => " barb ",
        " claws "                   => " claws ",
        " clay "                    => " adobe ",
        " clean "                   => " apple-pie ",
        " clean-cut "               => " categorical ",
        " clean-living "            => " blameless ",
        " clean-shaven "            => " baldheaded ",
        " cleaned "                 => " bankrupt ",
        " cleaning "                => " charwoman ",
        " cleanly "                 => " abundantly ",
        " cleanness "               => " abstemiousness ",
        " cleanse "                 => " absolve ",
        " cleansed "                => " apple-pie ",
        " cleanup "                 => " cleanup ",
        " clear "                   => " bright ",
        " clear-cut "               => " assured ",
        " clear-headed "            => " acute ",
        " clear-sighted "           => " clear-sighted ",
        " clearance "               => " approval ",
        " cleared "                 => " austere ",
        " clearing "                => " allowance ",
        " clearly "                 => " acutely ",
        " clearness "               => " acumen ",
        " cleat "                   => " block ",
        " cleavage "                => " break ",
        " cleave "                  => " carve ",
        " cleaved "                 => " broken ",
        " cleaver "                 => " brier ",
        " clef "                    => " author ",
        " cleft "                   => " broken ",
        " clemency "                => " charity ",
        " clement "                 => " balmy ",
        " clemo "                   => " charity ",
        " clench "                  => " clamp ",
        " clergyman "               => " abbey ",
        " cleric "                  => " apostolic ",
        " clerical "                => " accounting ",
        " clerk "                   => " agent ",
        " clerkish "                => " accounting ",
        " clerkly "                 => " accounting ",
        " clever "                  => " able ",
        " cleverness "              => " ability ",
        " click "                   => " bang ",
        " clicking "                => " beat ",
        " client "                  => " applicant ",
        " clientage "               => " audience ",
        " clientele "               => " audience ",
        " clientry "                => " audience ",
        " clients "                 => " audience ",
        " cliff "                   => " bluff ",
        " cliff-hanging "           => " artificial ",
        " cliffhanger "             => " bewilderment ",
        " climacteric "             => " acute ",
        " climactic "               => " acute ",
        " climactical "             => " acute ",
        " climate "                 => " altitude ",
        " climatic "                => " acute ",
        " climatize "               => " acclimatize ",
        " climax "                  => " acme ",
        " climb "                   => " ascend ",
        " climbing "                => " aggressive ",
        " clime "                   => " altitude ",
        " clinch "                  => " assure ",
        " clincher "                => " blow ",
        " clinching "               => " absolute ",
        " cling "                   => " adhere ",
        " clinging "                => " adhering ",
        " clingy "                  => " adhering ",
        " clinic "                  => " dispensary ",
        " clinical "                => " analytic ",
        " clinician "               => " analyst ",
        " clink "                   => " bang ",
        " clinker "                 => " agitation ",
        " clinking "                => " clinking ",
        " clip "                    => " blow ",
        " clipped "                 => " abrupt ",
        " clipping "                => " abridgement ",
        " clique "                  => " bunch ",
        " cliquish "                => " akin ",
        " cloaca "                  => " cesspool ",
        " cloak "                   => " blind ",
        " cloak-and-dagger "        => " artful ",
        " cloaked "                 => " buried ",
        " clobber "                 => " beat ",
        " clobbering "              => " beating ",
        " clock "                   => " alarm ",
        " clock-watcher "           => " aloof ",
        " clocklike "               => " abundant ",
        " clod "                    => " blockhead ",
        " cloddish "                => " awkward ",
        " clodhopper "              => " barbarian ",
        " clodhopping "             => " awkward ",
        " clogged "                 => " chock-full ",
        " clogging "                => " bottleneck ",
        " cloister "                => " abbey ",
        " cloistered "              => " cloistral ",
        " cloistral "               => " cloistral ",
        " clomp "                   => " barge ",
        " clone "                   => " carbon ",
        " clonk "                   => " bang ",
        " close "                   => " abutting ",
        " close-at-hand "           => " accessible ",
        " close-by "                => " accessible ",
        " close-fisted "            => " acquisitive ",
        " close-fistedness "        => " avidity ",
        " close-fitting "           => " bound ",
        " close-grained "           => " close ",
        " close-knit "              => " close ",
        " close-up "                => " close-up ",
        " closed "                  => " bankrupt ",
        " closed-fisted "           => " acquisitive ",
        " closefisted "             => " chintzy ",
        " closely "                 => " carefully ",
        " closeness "               => " accurateness ",
        " closer "                  => " afterpiece ",
        " closest "                 => " abutting ",
        " closure "                 => " cease ",
        " clot "                    => " array ",
        " cloth "                   => " bolt ",
        " clothe "                  => " accouter ",
        " clothier "                => " clothier ",
        " clothing "                => " accouterment ",
        " clotting "                => " array ",
        " cloud "                   => " billow ",
        " cloudburst "              => " atrophy ",
        " clouded "                 => " atramentous ",
        " cloudiness "              => " black ",
        " cloudless "               => " clement ",
        " cloudy "                  => " blurred ",
        " clough "                  => " abysm ",
        " clout "                   => " ascendancy ",
        " clove "                   => " abysm ",
        " cloven "                  => " broken ",
        " clover "                  => " clover ",
        " cloverleaf "              => " bend ",
        " clown "                   => " antic ",
        " clowning "                => " absurdity ",
        " clownish "                => " awkward ",
        " clownishness "            => " bluffing ",
        " cloy "                    => " disgust ",
        " cloyed "                  => " apathetic ",
        " cloying "                 => " arid ",
        " clubber "                 => " accessory ",
        " clubby "                  => " amiable ",
        " clubhouse "               => " adviser ",
        " cluck "                   => " babble ",
        " clump "                   => " array ",
        " clumped "                 => " airtight ",
        " clumpet "                 => " chunk ",
        " clumsily "                => " clumsily ",
        " clumsiness "              => " awkwardness ",
        " clunch "                  => " adobe ",
        " clunk "                   => " bulky ",
        " clunker "                 => " auto ",
        " clunking "                => " awkward ",
        " clunky "                  => " bulky ",
        " cluster "                 => " array ",
        " clustered "               => " amassed ",
        " clustering "              => " absorption ",
        " clutch "                  => " clamp ",
        " clutched "                => " afraid ",
        " clutches "                => " claws ",
        " clutter "                 => " ataxia ",
        " cluttered "               => " chaotic ",
        " cluttering "              => " abashing ",
        " co-conspirator "          => " abettor ",
        " co-op "                   => " address ",
        " co-operative "            => " branch ",
        " co-operator "             => " accessory ",
        " co-opt "                  => " accept ",
        " co-ordinate "             => " according ",
        " co-ordination "           => " adequation ",
        " co-worker "               => " accessory ",
        " coach "                   => " drillmaster ",
        " coached "                 => " accomplished ",
        " coaching "                => " apprenticeship ",
        " coact "                   => " coact ",
        " coacting "                => " accommodating ",
        " coactive "                => " accommodating ",
        " coadjutant "              => " abettor ",
        " coadjute "                => " affiliate ",
        " coadjutor "               => " abettor ",
        " coadjuvant "              => " accommodating ",
        " coadunate "               => " admix ",
        " coadunation "             => " affiliation ",
        " coagment "                => " admix ",
        " coagulate "               => " coalesce ",
        " coagulation "             => " agglomeration ",
        " coagulum "                => " array ",
        " coal "                    => " atramentous ",
        " coal-and-ice "            => " basal ",
        " coal-black "              => " atramentous ",
        " coalesce "                => " adhere ",
        " coalescence "             => " array ",
        " coalescing "              => " absorption ",
        " coalition "               => " affiliation ",
        " coals "                   => " dress-down ",
        " coarse "                  => " base ",
        " coarse-grained "          => " chapped ",
        " coarsen "                 => " augment ",
        " coarseness "              => " bawdiness ",
        " coast "                   => " bank ",
        " coastal "                 => " littoral ",
        " coasting "                => " benumbed ",
        " coastland "               => " bank ",
        " coastline "               => " bank ",
        " coat "                    => " covering ",
        " coating "                 => " blanket ",
        " coax "                    => " allure ",
        " coaxing "                 => " adulation ",
        " cobalt "                  => " azure ",
        " cobblestone "             => " asphalt ",
        " cobby "                   => " abode ",
        " cobweb "                  => " fiber ",
        " cobwebby "                => " chiffon ",
        " cobweblike "              => " chiffon ",
        " cochlear "                => " circling ",
        " cock "                    => " erect ",
        " cock-a-doodle-do "        => " banty ",
        " cock-a-doodle-doo "       => " blow ",
        " cockalorum "              => " banty ",
        " cockamamie "              => " absurd ",
        " cockcrow "                => " brightening ",
        " cocked "                  => " artsy ",
        " cockerel "                => " banty ",
        " cockeyed "                => " absurd ",
        " cockiness "               => " assurance ",
        " cockle "                  => " bulge ",
        " cockscomb "               => " aigrette ",
        " cocksure "                => " assertive ",
        " cocktails "               => " affair ",
        " cocky "                   => " arrogant ",
        " cocoa "                   => " amber ",
        " coconspirator "           => " abettor ",
        " coconut "                 => " attic ",
        " cocoon "                  => " cushion ",
        " coda "                    => " coda ",
        " coddle "                  => " baby ",
        " coddling "                => " allowance ",
        " code "                    => " cipher ",
        " codex "                   => " album ",
        " codicil "                 => " addendum ",
        " codicillary "             => " codicillary ",
        " codification "            => " allocation ",
        " codified "                => " codification ",
        " codify "                  => " arrange ",
        " coed "                    => " babe ",
        " coefficient "             => " accessory ",
        " coequal "                 => " alike ",
        " coequality "              => " adequation ",
        " coerce "                  => " beset ",
        " coerced "                 => " apprenticed ",
        " coercer "                 => " annoyer ",
        " coercion "                => " browbeating ",
        " coercive "                => " arrogant ",
        " coetaneous "              => " accessory ",
        " coeval "                  => " accessory ",
        " coexistent "              => " accessory ",
        " coexisting "              => " circumstantial ",
        " coextending "             => " alongside ",
        " coextensive "             => " adequate ",
        " coffer "                  => " case ",
        " coffin "                  => " casket ",
        " cofunction "              => " coact ",
        " cogency "                 => " bearing ",
        " cogitable "               => " cogitable ",
        " cogitate "                => " brainstorm ",
        " cogitating "              => " apperception ",
        " cogitation "              => " brainwork ",
        " cogitative "              => " attentive ",
        " cognate "                 => " affiliated ",
        " cognition "               => " acknowledgment ",
        " cognitive "               => " cerebral ",
        " cognizability "           => " accuracy ",
        " cognizable "              => " apparent ",
        " cognizance "              => " cognizance ",
        " cognizant "               => " acquainted ",
        " cognize "                 => " appreciate ",
        " cognomen "                => " appellation ",
        " cognominate "             => " baptize ",
        " cognoscente "             => " adept ",
        " cognoscenti "             => " aristocracy ",
        " cogwheel "                => " cogwheel ",
        " cohabit "                 => " conjugate ",
        " cohere "                  => " adhere ",
        " coherence "               => " adherence ",
        " coherent "                => " articular ",
        " cohesion "                => " accord ",
        " cohesive "                => " adamant ",
        " cohort "                  => " accomplice ",
        " coiffeur "                => " beautician ",
        " coiffeuse "               => " beautician ",
        " coiffure "                => " crew ",
        " coil "                    => " braid ",
        " coiled "                  => " coiled ",
        " coiling "                 => " coil ",
        " coin "                    => " bread ",
        " coinage "                 => " banknote ",
        " coincide "                => " accompany ",
        " coincidence "             => " accompaniment ",
        " coincident "              => " ancillary ",
        " coincidental "            => " casual ",
        " coincidentally "          => " accordingly ",
        " coinciding "              => " ancillary ",
        " coining "                 => " bogus ",
        " coins "                   => " bill ",
        " coition "                 => " coition ",
        " coitus "                  => " coition ",
        " coked "                   => " benumbed ",
        " colander "                => " analyze ",
        " cold "                    => " algid ",
        " cold-blooded "            => " barbarous ",
        " cold-bloodedness "        => " alienation ",
        " cold-footed "             => " afraid ",
        " cold-hearted "            => " aloof ",
        " cold-shoulder "           => " boycott ",
        " coldhearted "             => " anesthetic ",
        " coldish "                 => " air-conditioned ",
        " coldness "                => " aloofness ",
        " coliseum "                => " amphitheater ",
        " coll "                    => " attack ",
        " collaborate "             => " coact ",
        " collaborating "           => " accommodating ",
        " collaboration "           => " accord ",
        " collaborator "            => " assistant ",
        " collapsed "               => " burst ",
        " collapsing "              => " annoyed ",
        " collate "                 => " adduce ",
        " collated "                => " aggregate ",
        " collateral "              => " accessory ",
        " collating "               => " allegory ",
        " collation "               => " accumulating ",
        " colleague "               => " aide ",
        " collect "                 => " aggregate ",
        " collectanea "             => " accumulation ",
        " collected "               => " calm ",
        " collecting "              => " accession ",
        " collection "              => " accumulating ",
        " collective "              => " aggregate ",
        " collectiveness "          => " absoluteness ",
        " collectivity "            => " absoluteness ",
        " collector "               => " beneficiary ",
        " college "                 => " academy ",
        " collegial "               => " accommodating ",
        " collegian "               => " alum ",
        " collegiate "              => " bookish ",
        " collide "                 => " bang ",
        " colligate "               => " abridge ",
        " collimate "               => " accumulate ",
        " collinear "               => " beeline ",
        " collision "               => " blow ",
        " collocate "               => " accumulate ",
        " collocating "             => " accumulation ",
        " collocation "             => " allocation ",
        " collogue "                => " advise ",
        " colloquial "              => " chatty ",
        " colloquialism "           => " argot ",
        " colloquium "              => " academy ",
        " collude "                 => " coact ",
        " collusion "               => " bunco ",
        " collusive "               => " accommodating ",
        " collywobbles "            => " collywobbles ",
        " cologne "                 => " cologne ",
        " colonist "                => " alien ",
        " colonize "                => " arrive ",
        " colonnade "               => " brace ",
        " colony "                  => " antecedents ",
        " colophon "                => " badge ",
        " color "                   => " blush ",
        " color-blind "             => " balanced ",
        " colorant "                => " blush ",
        " coloration "              => " blush ",
        " colored "                 => " black ",
        " colorful "                => " bright ",
        " colorfully "              => " blithely ",
        " colorfulness "            => " animation ",
        " coloring "                => " appearance ",
        " colorless "               => " achromatic ",
        " colorlessness "           => " boredom ",
        " colt "                    => " filly ",
        " coltish "                 => " active ",
        " column "                  => " cavalcade ",
        " columnist "               => " columnist ",
        " colure "                  => " amphitheater ",
        " coma "                    => " blackout ",
        " comate "                  => " associate ",
        " comatose "                => " cold ",
        " comb "                    => " adjust ",
        " combat "                  => " action ",
        " combatant "               => " adversary ",
        " combating "               => " active ",
        " combative "               => " antagonistic ",
        " combativeness "           => " aggressiveness ",
        " comber "                  => " beachcomber ",
        " combination "             => " aggregate ",
        " combine "                 => " amalgamate ",
        " combined "                => " accumulated ",
        " combining "               => " accumulation ",
        " comble "                  => " acme ",
        " combo "                   => " admixture ",
        " comburent "               => " burnable ",
        " combust "                 => " bake ",
        " combustible "             => " burnable ",
        " combustion "              => " agitation ",
        " combustive "              => " burnable ",
        " come "                    => " appear ",
        " come-at-able "            => " accessible ",
        " come-hither "             => " attraction ",
        " come-off "                => " come-off ",
        " come-on "                 => " attraction ",
        " come-through "            => " absolute ",
        " comeback "                => " improvement ",
        " comedian "                => " actor ",
        " comedown "                => " anticlimax ",
        " comedy "                  => " ball ",
        " comeliness "              => " adorableness ",
        " comely "                  => " attractive ",
        " comer "                   => " addition ",
        " comestible "              => " comestible ",
        " comestibles "             => " aliment ",
        " comeuppance "             => " advise ",
        " comfort "                 => " abundance ",
        " comfortable "             => " adequate ",
        " comfortably "             => " calmly ",
        " comforting "              => " abating ",
        " comfortless "             => " black ",
        " comfy "                   => " comfortable ",
        " comic "                   => " banana ",
        " comical "                 => " absurd ",
        " comicality "              => " ball ",
        " comicalness "             => " ball ",
        " coming "                  => " advancing ",
        " coming-out "              => " affair ",
        " comity "                  => " amicableness ",
        " comma "                   => " breach ",
        " commandant "              => " administrator ",
        " commanded "               => " allowable ",
        " commandeer "              => " accroach ",
        " commandeering "           => " abduction ",
        " commander "               => " administrator ",
        " commanding "              => " advantageous ",
        " commandment "             => " bidding ",
        " commeasure "              => " adjust ",
        " commemorate "             => " admire ",
        " commemorated "            => " actual ",
        " commemoration "           => " celebration ",
        " commemoratory "           => " celebratory ",
        " commence "                => " arise ",
        " commencement "            => " admission ",
        " commencing "              => " basic ",
        " commend "                 => " acclaim ",
        " commendable "             => " admirable ",
        " commendation "            => " acclamation ",
        " commendations "           => " commendations ",
        " commendatory "            => " adulatory ",
        " commensurable "           => " commensurable ",
        " commensurate "            => " adequate ",
        " commensurately "          => " abundantly ",
        " commensurateness "        => " capability ",
        " comment "                 => " animadversion ",
        " commentary "              => " annotation ",
        " commentate "              => " comment ",
        " commentator "             => " analyst ",
        " commerce "                => " business ",
        " commercial "              => " bartering ",
        " commercialism "           => " affairs ",
        " comminate "               => " abuse ",
        " comminatory "             => " aggressive ",
        " commingle "               => " amalgamate ",
        " commingling "             => " admixture ",
        " comminute "               => " beat ",
        " commiserable "            => " affecting ",
        " commiserate "             => " ache ",
        " commiserating "           => " affectionate ",
        " commiseration "           => " benevolence ",
        " commish "                 => " allowance ",
        " commissary "              => " bartering ",
        " commission "              => " agency ",
        " commissionaire "          => " agent ",
        " commissioner "            => " abettor ",
        " commissioning "           => " allotment ",
        " commit "                  => " accomplish ",
        " commitment "              => " charge ",
        " committal "               => " bondage ",
        " committed "               => " committed ",
        " committee "               => " board ",
        " commix "                  => " amalgamate ",
        " commixture "              => " alloy ",
        " commode "                 => " chiffonier ",
        " commodious "              => " ample ",
        " commodiously "            => " abundantly ",
        " commodities "             => " bolt ",
        " commodity "               => " article ",
        " common "                  => " accepted ",
        " common-sense "            => " astute ",
        " commonage "               => " collective ",
        " commonalty "              => " commonalty ",
        " commoner "                => " aborigine ",
        " commonition "             => " advise ",
        " commonly "                => " frequently ",
        " commonness "              => " abundance ",
        " commons "                 => " aliment ",
        " commonsense "             => " commonsense ",
        " commonsensical "          => " astute ",
        " commorancy "              => " abode ",
        " commove "                 => " amaze ",
        " commoving "               => " agitative ",
        " communal "                => " common ",
        " commune "                 => " collective ",
        " communicable "            => " catching ",
        " communicate "             => " acquaint ",
        " communicated "            => " announced ",
        " communication "           => " advice ",
        " communicative "           => " candid ",
        " communicator "            => " anchorperson ",
        " communing "               => " accord ",
        " communion "               => " accord ",
        " communist "               => " antipathetic ",
        " communistic "             => " accepted ",
        " community "               => " association ",
        " communize "               => " adjust ",
        " commutable "              => " changeable ",
        " commutation "             => " barter ",
        " commutative "             => " capricious ",
        " commute "                 => " drive ",
        " commuter "                => " driver ",
        " commutual "               => " accepted ",
        " comp "                    => " atone ",
        " compact "                 => " bunched ",
        " compacted "               => " compacted ",
        " compacting "              => " absorption ",
        " compactness "             => " bendability ",
        " compages "                => " architecture ",
        " companion "               => " accompaniment ",
        " companionability "        => " brotherhood ",
        " companionable "           => " affable ",
        " companionably "           => " accordingly ",
        " companionless "           => " abandoned ",
        " companions "              => " assembly ",
        " companionship "           => " accompaniment ",
        " company "                 => " aggregation ",
        " comparability "           => " allegory ",
        " comparable "              => " commensurable ",
        " comparableness "          => " affinity ",
        " comparably "              => " analogously ",
        " comparative "             => " allusive ",
        " comparatively "           => " analogously ",
        " compare "                 => " analyze ",
        " comparison "              => " allegory ",
        " compartment "             => " alcove ",
        " compartmental "           => " apportioned ",
        " compartmented "           => " apportioned ",
        " compass "                 => " ambit ",
        " compassed "               => " belted ",
        " compassion "              => " benevolence ",
        " compassionless "          => " barbarous ",
        " compatibility "           => " affinity ",
        " compatible "              => " accordant ",
        " compatriot "              => " accessory ",
        " compeer "                 => " associate ",
        " compel "                  => " bulldoze ",
        " compellation "            => " appellation ",
        " compelled "               => " accountable ",
        " compelling "              => " acute ",
        " compendiary "             => " abrupt ",
        " compendious "             => " abbreviated ",
        " compendium "              => " abstract ",
        " compensate "              => " atone ",
        " compensation "            => " advantage ",
        " compete "                 => " attempt ",
        " competence "              => " adequacy ",
        " competency "              => " adequacy ",
        " competently "             => " abundantly ",
        " competing "               => " aggressive ",
        " competition "             => " antagonism ",
        " competitive "             => " aggressive ",
        " competitor "              => " adversary ",
        " compilation "             => " accumulation ",
        " compilations "            => " abstracts ",
        " compile "                 => " abridge ",
        " compiled "                => " aggregate ",
        " compiling "               => " accumulation ",
        " complacency "             => " abundance ",
        " complacent "              => " conceited ",
        " complain "                => " accuse ",
        " complaining "             => " accusatory ",
        " complaisance "            => " accommodativeness ",
        " complaisant "             => " accommodating ",
        " complanate "              => " collapsed ",
        " complect "                => " complect ",
        " complement "              => " accompaniment ",
        " complemental "            => " commutual ",
        " complementary "           => " commutual ",
        " completely "              => " absolutely ",
        " completeness "            => " abyss ",
        " completing "              => " commutual ",
        " completion "              => " achievement ",
        " completory "              => " commutual ",
        " complex "                 => " circuitous ",
        " complexion "              => " appearance ",
        " complexity "              => " complication ",
        " compliable "              => " abject ",
        " compliance "              => " acquiescence ",
        " compliant "               => " adjustable ",
        " complication "            => " aggravation ",
        " complicity "              => " abetment ",
        " compliment "              => " acclaim ",
        " complimentary "           => " adulatory ",
        " compliments "             => " adulation ",
        " complot "                 => " abetment ",
        " comply "                  => " accede ",
        " complying "               => " acknowledging ",
        " component "               => " basic ",
        " components "              => " apparatus ",
        " comportment "             => " address ",
        " composer "                => " artisan ",
        " composing "               => " basic ",
        " composite "               => " blended ",
        " composition "             => " agreement ",
        " compost "                 => " admixture ",
        " composure "               => " accord ",
        " compotation "             => " affair ",
        " compound "                => " admixture ",
        " compounded "              => " circuitous ",
        " comprehend "              => " appreciate ",
        " comprehendible "          => " apprehensible ",
        " comprehending "           => " affectionate ",
        " comprehensibility "       => " accuracy ",
        " comprehensible "          => " apprehensible ",
        " comprehension "           => " apperception ",
        " comprehensive "           => " absolute ",
        " comprehensively "         => " assiduously ",
        " comprehensiveness "       => " amplitude ",
        " compress "                => " abbreviate ",
        " compressed "              => " aeroembolism ",
        " compressing "             => " burden ",
        " comprisal "               => " admittance ",
        " comprising "              => " absolute ",
        " compromise "              => " accommodation ",
        " compromiser "             => " adjudicator ",
        " compromising "            => " compromising ",
        " compulsatory "            => " compulsatory ",
        " compulsion "              => " coercion ",
        " compulsive "              => " besetting ",
        " compulsory "              => " compulsatory ",
        " compunction "             => " attrition ",
        " compunctious "            => " atoning ",
        " computable "              => " accountable ",
        " computation "             => " ciphering ",
        " computative "             => " algebraic ",
        " computing "               => " accretion ",
        " comrade "                 => " associate ",
        " comradely "               => " affectionate ",
        " comradery "               => " affability ",
        " comrades "                => " assembly ",
        " comradeship "             => " acquaintance ",
        " conation "                => " action ",
        " concatenate "             => " concatenate ",
        " concatenation "           => " chain ",
        " concave "                 => " biconcave ",
        " conceal "                 => " burrow ",
        " concealed "               => " buried ",
        " concealment "             => " beard ",
        " concedable "              => " acceptable ",
        " concede "                 => " accept ",
        " conceding "               => " acceptance ",
        " conceited "               => " arrogant ",
        " conceitedness "           => " airs ",
        " conceivability "          => " anticipation ",
        " conceivable "             => " believable ",
        " conceive "                => " accept ",
        " conceiving "              => " conceiving ",
        " concenter "               => " attract ",
        " concentrate "             => " apply ",
        " concentrating "           => " apperception ",
        " concentration "           => " absorption ",
        " concentus "               => " accord ",
        " concept "                 => " abstraction ",
        " conception "              => " apperception ",
        " conceptualization "       => " abstraction ",
        " conceptualize "           => " anticipate ",
        " concern "                 => " affair ",
        " concerned "               => " anxious ",
        " concernedly "             => " anxiously ",
        " concerning "              => " apropos ",
        " concernment "             => " affair ",
        " concerns "                => " apropos ",
        " concerto "                => " arrangement ",
        " concession "              => " acknowledgment ",
        " concierge "               => " babysitter ",
        " conciliate "              => " allay ",
        " conciliation "            => " abatement ",
        " conciliator "             => " agent ",
        " conciliatory "            => " appeasing ",
        " concinnity "              => " accord ",
        " concise "                 => " abridged ",
        " conciseness "             => " conciseness ",
        " concision "               => " conciseness ",
        " conclave "                => " assembly ",
        " conclude "                => " achieve ",
        " concluded "               => " assured ",
        " concluding "              => " absolute ",
        " conclusion "              => " cessation ",
        " conclusions "             => " abstracts ",
        " conclusive "              => " absolute ",
        " conclusively "            => " actually ",
        " concocted "               => " affected ",
        " concoction "              => " brew ",
        " concomitance "            => " bond ",
        " concomitant "             => " accessory ",
        " concomitantly "           => " accordingly ",
        " concord "                 => " accord ",
        " concordance "             => " acceding ",
        " concordant "              => " accordant ",
        " concordat "               => " alliance ",
        " concours "                => " antagonism ",
        " concourse "               => " avenue ",
        " concrete "                => " accurate ",
        " concretely "              => " accurately ",
        " concreteness "            => " actuality ",
        " concretion "              => " agglomeration ",
        " concretize "              => " actualize ",
        " concubine "               => " bedmate ",
        " concupiscence "           => " admiration ",
        " concupiscent "            => " amative ",
        " concur "                  => " accede ",
        " concurrence "             => " accedence ",
        " concurrency "             => " accommodation ",
        " concurrent "              => " circumstantial ",
        " concurrently "            => " accordingly ",
        " concurring "              => " acknowledging ",
        " concursion "              => " assemblage ",
        " concuss "                 => " beat ",
        " concussion "              => " blow ",
        " condemn "                 => " adjudge ",
        " condemnable "             => " amiss ",
        " condemnation "            => " accusation ",
        " condemnatory "            => " accusatory ",
        " condemned "               => " accursed ",
        " condemning "              => " accusatory ",
        " condensate "              => " condensate ",
        " condensation "            => " abstract ",
        " condense "                => " abbreviate ",
        " condensed "               => " abridged ",
        " condensing "              => " abbreviating ",
        " condescending "           => " arrogant ",
        " condescension "           => " airs ",
        " condign "                 => " becoming ",
        " condiment "               => " additive ",
        " condition "               => " action ",
        " conditional "             => " codicillary ",
        " conditions "              => " altitude ",
        " condo "                   => " address ",
        " condole "                 => " abate ",
        " condolement "             => " comfort ",
        " condolence "              => " comfort ",
        " condoling "               => " affectionate ",
        " condominium "             => " abode ",
        " condonable "              => " condonable ",
        " condonation "             => " absolution ",
        " condone "                 => " disregard ",
        " condoning "               => " accommodating ",
        " conduce "                 => " cabal ",
        " conducive "               => " accessory ",
        " conducting "              => " administering ",
        " conduction "              => " advice ",
        " conductivity "            => " application ",
        " conductor "               => " aqueduct ",
        " conduit "                 => " aqueduct ",
        " cone-shaped "             => " cone-shaped ",
        " coned "                   => " cone-shaped ",
        " confab "                  => " assay ",
        " confabulate "             => " answer ",
        " confection "              => " cake ",
        " confectionary "           => " bonbon ",
        " confederacy "             => " alliance ",
        " confederate "             => " amalgamated ",
        " confederated "            => " affiliated ",
        " confederation "           => " amalgamation ",
        " confer "                  => " advise ",
        " conferee "                => " addition ",
        " conference "              => " appointment ",
        " conferment "              => " accolade ",
        " conferral "               => " accolade ",
        " conferring "              => " appointment ",
        " confess "                 => " acknowledge ",
        " confessed "               => " accepted ",
        " confession "              => " acknowledgment ",
        " confessions "             => " adventures ",
        " confessor "               => " confessor ",
        " confetti "                => " armament ",
        " confidant "               => " acquaintance ",
        " confidante "              => " acquaintance ",
        " confide "                 => " admit ",
        " confidence "              => " aplomb ",
        " confident "               => " assured ",
        " confidential "            => " arcane ",
        " confidentiality "         => " acquaintance ",
        " confiding "               => " affectionate ",
        " configuration "           => " agreement ",
        " confined "                => " bedfast ",
        " confinement "             => " bonds ",
        " confines "                => " borders ",
        " confining "               => " circumscribed ",
        " confirm "                 => " affirm ",
        " confirmable "             => " absolute ",
        " confirmation "            => " acceptance ",
        " confirmative "            => " acknowledging ",
        " confirmatory "            => " acknowledging ",
        " confirmed "               => " accepted ",
        " confirmedly "             => " absolutely ",
        " confirming "              => " acknowledging ",
        " confiscate "              => " accroach ",
        " confiscation "            => " confiscation ",
        " confit "                  => " bonbon ",
        " conflagrant "             => " afire ",
        " conflagrate "             => " bake ",
        " conflagration "           => " blaze ",
        " conflict "                => " battle ",
        " conflicting "             => " adverse ",
        " conflictingly "           => " abnormally ",
        " confluence "              => " assemblage ",
        " confluent "               => " allied ",
        " conflux "                 => " assemblage ",
        " conform "                 => " accommodate ",
        " conformability "          => " accord ",
        " conformable "             => " adapted ",
        " conformance "             => " acclimation ",
        " conformant "              => " accordant ",
        " conformation "            => " anatomy ",
        " conformed "               => " accommodated ",
        " conforming "              => " befitting ",
        " conformity "              => " acquiescence ",
        " confound "                => " abash ",
        " confounded "              => " ashamed ",
        " confounding "             => " abashing ",
        " confoundment "            => " admiration ",
        " confrere "                => " associate ",
        " confront "                => " accost ",
        " confrontation "           => " battle ",
        " confronting "             => " against ",
        " confuse "                 => " abash ",
        " confused "                => " abashed ",
        " confusing "               => " ambagious ",
        " confusion "               => " abashing ",
        " confutation "             => " bucking ",
        " confute "                 => " break ",
        " conge "                   => " conge ",
        " congeal "                 => " benumb ",
        " congealed "               => " caked ",
        " congelation "             => " agglomeration ",
        " congeneric "              => " affiliated ",
        " congenial "               => " adapted ",
        " congeniality "            => " affinity ",
        " congenialness "           => " affability ",
        " congenital "              => " complete ",
        " congeries "               => " accumulating ",
        " congest "                 => " arrest ",
        " congested "               => " chock-full ",
        " congestion "              => " bottleneck ",
        " conglomerate "            => " amassed ",
        " conglomerated "           => " caked ",
        " conglomeration "          => " agglomeration ",
        " conglutination "          => " array ",
        " congratulatory "          => " adulatory ",
        " congregate "              => " besiege ",
        " congregation "            => " aggregation ",
        " congress "                => " assembly ",
        " congressional "           => " aldermanic ",
        " congressman "             => " agent ",
        " congruence "              => " accordance ",
        " congruency "              => " affiliation ",
        " congruent "               => " coinciding ",
        " congruity "               => " acceding ",
        " congruous "               => " accordant ",
        " congruousness "           => " accommodation ",
        " conic "                   => " cone-shaped ",
        " conjecturable "           => " academic ",
        " conjectural "             => " academic ",
        " conjecture "              => " assumption ",
        " conjectured "             => " accepted ",
        " conjoin "                 => " adjoin ",
        " conjoined "               => " accessory ",
        " conjoint "                => " aggregate ",
        " conjointly "              => " additionally ",
        " conjointment "            => " affiliation ",
        " conjugal "                => " bridal ",
        " conjugality "             => " alliance ",
        " conjugate "               => " conjugate ",
        " conjugation "             => " alliance ",
        " conjunct "                => " accepted ",
        " conjunction "             => " affiliation ",
        " conjunctive "             => " affiliated ",
        " conjuncture "             => " accident ",
        " conjuration "             => " agreeableness ",
        " conjure "                 => " adjure ",
        " conjurer "                => " archimage ",
        " conjuring "               => " abracadabra ",
        " conjuror "                => " archimage ",
        " conjury "                 => " abracadabra ",
        " conk "                    => " break ",
        " conked "                  => " comatose ",
        " conkerbill "              => " addendum ",
        " connate "                 => " affiliated ",
        " connatural "              => " affiliated ",
        " connect "                 => " affix ",
        " connected "               => " affiliated ",
        " connectedly "             => " accordingly ",
        " connecting "              => " abutting ",
        " connection "              => " affiliation ",
        " connections "             => " access ",
        " connective "              => " affiliation ",
        " connector "               => " adapter ",
        " conned "                  => " bamboozled ",
        " conniption "              => " acrimony ",
        " connivance "              => " bunco ",
        " connive "                 => " angle ",
        " conniver "                => " bluff ",
        " connoisseur "             => " adept ",
        " connotation "             => " association ",
        " connotative "             => " apocalyptic ",
        " connote "                 => " betoken ",
        " connoted "                => " accepted ",
        " connubial "               => " conjugal ",
        " connubiality "            => " alliance ",
        " conoid "                  => " cone-shaped ",
        " conoidal "                => " cone-shaped ",
        " conquer "                 => " beat ",
        " conquered "               => " baffled ",
        " conquering "              => " acquisition ",
        " conqueror "               => " conquistador ",
        " conquest "                => " acquisition ",
        " conquistador "            => " conquistador ",
        " consanguine "             => " affiliated ",
        " consanguineous "          => " affiliated ",
        " consanguinity "           => " affiliation ",
        " conscience "              => " censor ",
        " conscience-stricken "     => " abashed ",
        " conscienceless "          => " amoral ",
        " conscientious "           => " careful ",
        " conscientiously "         => " anxiously ",
        " conscionable "            => " conscionable ",
        " conscious "               => " acquainted ",
        " consciously "             => " carefully ",
        " consciousness "           => " alertness ",
        " consciousness-expanding " => " consciousness-expanding ",
        " conscript "               => " called ",
        " conscripted "             => " affected ",
        " conscription "            => " acceptance ",
        " consecrate "              => " anoint ",
        " consecrated "             => " adored ",
        " consecrating "            => " canonizing ",
        " consecration "            => " approbation ",
        " consecrative "            => " canonizing ",
        " consecution "             => " alternation ",
        " consecutive "             => " after ",
        " consecutiveness "         => " arrangement ",
        " consensus "               => " accord ",
        " consent "                 => " accord ",
        " consentient "             => " allied ",
        " consenting "              => " acknowledging ",
        " consequence "             => " aftereffect ",
        " consequences "            => " after-effects ",
        " consequent "              => " consistent ",
        " consequently "            => " appropriately ",
        " conservancy "             => " attention ",
        " conservation "            => " attention ",
        " conservational "          => " careful ",
        " conservatism "            => " abnegation ",
        " conservative "            => " bourgeois ",
        " conserving "              => " attention ",
        " consider "                => " accede ",
        " considerable "            => " ample ",
        " considerably "            => " appreciably ",
        " considerate "             => " accommodating ",
        " considerateness "         => " attentiveness ",
        " consideration "           => " application ",
        " considered "              => " advised ",
        " considering "             => " because ",
        " consign "                 => " address ",
        " consigned "               => " boarded ",
        " consignee "               => " beneficiary ",
        " consigning "              => " appointment ",
        " consignment "             => " assignment ",
        " consist "                 => " abide ",
        " consistency "             => " bendability ",
        " consistent "              => " constant ",
        " consistently "            => " consistently ",
        " consociate "              => " accomplice ",
        " consociation "            => " affiliation ",
        " consolation "             => " alleviation ",
        " consolatory "             => " abating ",
        " console "                 => " animate ",
        " consolidated "            => " circumscribed ",
        " consolidating "           => " accumulation ",
        " consolidation "           => " alliance ",
        " consoling "               => " abating ",
        " consonance "              => " accord ",
        " consonant "               => " accordant ",
        " consonantly "             => " analogously ",
        " consort "                 => " accompaniment ",
        " consortium "              => " bunch ",
        " conspectus "              => " abbreviation ",
        " conspicuous "             => " apparent ",
        " conspicuously "           => " clearly ",
        " conspicuousness "         => " accuracy ",
        " conspiracy "              => " cabal ",
        " conspirator "             => " abettor ",
        " conspiratorial "          => " artful ",
        " conspire "                => " cabal ",
        " constabulary "            => " badge ",
        " constancy "               => " abidingness ",
        " constant "                => " connected ",
        " constantly "              => " consistently ",
        " constate "                => " acknowledge ",
        " constellation "           => " afterlife ",
        " consternate "             => " alarm ",
        " consternation "           => " alarm ",
        " constipate "              => " constipate ",
        " constipation "            => " ache ",
        " constituent "             => " basic ",
        " constituents "            => " capacity ",
        " constitute "              => " aggregate ",
        " constituting "            => " basic ",
        " constitution "            => " architecture ",
        " constitutional "          => " built-in ",
        " constitutionality "       => " amends ",
        " constitutive "            => " basal ",
        " constrained "             => " accountable ",
        " constraining "            => " acute ",
        " constrainment "           => " bonds ",
        " constraint "              => " coercion ",
        " constrict "               => " astringe ",
        " constricted "             => " attenuated ",
        " constriction "            => " binding ",
        " construal "               => " apprehension ",
        " construct "               => " assemble ",
        " constructed "             => " complete ",
        " constructing "            => " amalgam ",
        " construction "            => " architecture ",
        " constructive "            => " effective ",
        " constructor "             => " architect ",
        " construe "                => " analyze ",
        " consubstantial "          => " agnate ",
        " consul "                  => " delegate ",
        " consulate "               => " admiral ",
        " consult "                 => " argue ",
        " consultant "              => " adviser ",
        " consultation "            => " appointment ",
        " consultative "            => " advising ",
        " consultive "              => " advising ",
        " consumable "              => " accessible ",
        " consume "                 => " absorb ",
        " consumed "                => " captivated ",
        " consumer "                => " customer ",
        " consuming "               => " arresting ",
        " consummate "              => " able ",
        " consummately "            => " consummately ",
        " consummation "            => " cleanup ",
        " consumption "             => " burning ",
        " consumptive "             => " ashen ",
        " contact "                 => " acquaintance ",
        " contactual "              => " abutting ",
        " contagion "               => " bane ",
        " contagious "              => " catching ",
        " contain "                 => " accommodate ",
        " contained "               => " independent ",
        " container "               => " alembic ",
        " containing "              => " absolute ",
        " containment "             => " ascendancy ",
        " contaminate "             => " alloy ",
        " contaminated "            => " attenuated ",
        " contaminating "           => " communicable ",
        " contamination "           => " contagion ",
        " conte "                   => " adventure ",
        " contemn "                 => " abuse ",
        " contemning "              => " aloof ",
        " contemplated "            => " advised ",
        " contemplating "           => " advertent ",
        " contemplation "           => " ambition ",
        " contemplative "           => " attentive ",
        " contempo "                => " abreast ",
        " contemporaneous "         => " ancillary ",
        " contemporaries "          => " aeon ",
        " contemporary "            => " abreast ",
        " contempt "                => " antipathy ",
        " contemptible "            => " abhorrent ",
        " contemptuous "            => " audacious ",
        " contemptuousness "        => " airs ",
        " contend "                 => " argue ",
        " contended "               => " arguable ",
        " contender "               => " adversary ",
        " contending "              => " alienated ",
        " content "                 => " agreeable ",
        " contentedly "             => " acquiescently ",
        " contentedness "           => " comfort ",
        " contenting "              => " acceptable ",
        " contention "              => " altercation ",
        " contentious "             => " advancing ",
        " contentment "             => " comfort ",
        " contents "                => " capacity ",
        " conterminous "            => " abutting ",
        " contessa "                => " adult ",
        " contest "                 => " challenge ",
        " contestable "             => " arguable ",
        " contestant "              => " adversary ",
        " contestation "            => " advancement ",
        " contester "               => " adversary ",
        " contesting "              => " battling ",
        " context "                 => " ambience ",
        " contiguity "              => " approximation ",
        " contiguous "              => " abutting ",
        " contiguously "            => " anon ",
        " contiguousness "          => " adjacency ",
        " continence "              => " abandonment ",
        " continent "               => " abstemious ",
        " contingence "             => " approximation ",
        " contingency "             => " accident ",
        " contingent "              => " accidental ",
        " continual "               => " around-the-clock ",
        " continually "             => " always ",
        " continuance "             => " constancy ",
        " continuation "            => " assiduity ",
        " continue "                => " abide ",
        " continued "               => " connected ",
        " continuity "              => " chain ",
        " continuous "              => " connected ",
        " continuousness "          => " chain ",
        " continuum "               => " continuum ",
        " contort "                 => " bend ",
        " contorted "               => " angled ",
        " contortion "              => " anamorphosis ",
        " contortionist "           => " aerialist ",
        " contour "                 => " curve ",
        " contra "                  => " antipode ",
        " contraband "              => " banned ",
        " contract "                => " arrangement ",
        " contracted "              => " apprenticed ",
        " contracting "             => " application ",
        " contraction "             => " abbreviating ",
        " contractor "              => " architect ",
        " contracts "               => " affairs ",
        " contractual "             => " acknowledged ",
        " contradict "              => " belie ",
        " contradiction "           => " bucking ",
        " contradictorily "         => " abnormally ",
        " contradictory "           => " adverse ",
        " contradistinct "          => " altered ",
        " contradistinction "       => " animosity ",
        " contradistinctive "       => " altered ",
        " contraposition "          => " antagonism ",
        " contrapositive "          => " adverse ",
        " contraption "             => " accoutrement ",
        " contraptions "            => " accessories ",
        " contrariant "             => " adverse ",
        " contrariety "             => " animosity ",
        " contrarily "              => " contrarily ",
        " contrariness "            => " affront ",
        " contrariwise "            => " against ",
        " contrary "                => " adverse ",
        " contrast "                => " adverse ",
        " contrasted "              => " assorted ",
        " contrasting "             => " allegory ",
        " contrastingly "           => " abnormally ",
        " contrastive "             => " allusive ",
        " contrastively "           => " abnormally ",
        " contravene "              => " abjure ",
        " contravening "            => " abrogating ",
        " contravention "           => " contravention ",
        " contretemps "             => " affliction ",
        " contribute "              => " accord ",
        " contributed "             => " contributed ",
        " contributing "            => " accidental ",
        " contribution "            => " addition ",
        " contributive "            => " accessory ",
        " contributory "            => " accessory ",
        " contrite "                => " apologetic ",
        " contriteness "            => " contriteness ",
        " contrition "              => " attrition ",
        " contriturate "            => " beat ",
        " contrivance "             => " angle ",
        " contrivances "            => " accessories ",
        " contrive "                => " concoct ",
        " contrived "               => " apish ",
        " contriver "               => " architect ",
        " contriving "              => " artful ",
        " control "                 => " ascendancy ",
        " controllable "            => " controllable ",
        " controller "              => " ambassador ",
        " controlling "             => " authoritative ",
        " controversial "           => " arguable ",
        " controversion "           => " abnegation ",
        " controversy "             => " altercation ",
        " controvert "              => " break ",
        " controvertible "          => " arguable ",
        " controverting "           => " agitation ",
        " contumacious "            => " alienated ",
        " contumacy "               => " affront ",
        " contumelious "            => " calumniating ",
        " contumely "               => " brass ",
        " contuse "                 => " assault ",
        " contused "                => " aching ",
        " contusion "               => " bang ",
        " conundrum "               => " brain-teaser ",
        " conurbation "             => " apple ",
        " convalesce "              => " alleviate ",
        " convalescence "           => " affliction ",
        " convalescent "            => " ambulatory ",
        " convection "              => " alteration ",
        " convenance "              => " breeding ",
        " convene "                 => " assemble ",
        " convenience "             => " accessibility ",
        " convenient "              => " acceptable ",
        " conveniently "            => " calmly ",
        " convent "                 => " abbey ",
        " convention "              => " assemblage ",
        " conventional "            => " accepted ",
        " conventionalism "         => " attitude ",
        " conventionalities "       => " belief ",
        " conventionality "         => " acquiescence ",
        " conventionally "          => " commonly ",
        " converge "                => " assemble ",
        " convergence "             => " aggregation ",
        " convergent "              => " allied ",
        " converging "              => " advancing ",
        " conversable "             => " candid ",
        " conversance "             => " cognizance ",
        " conversant "              => " abreast ",
        " conversation "            => " chat ",
        " conversational "          => " communicative ",
        " converse "                => " antipodal ",
        " conversely "              => " against ",
        " conversible "             => " back-slapping ",
        " conversion "              => " about-face ",
        " convert "                 => " catechumen ",
        " converted "               => " adapted ",
        " converter "               => " advocate ",
        " convex "                  => " arched ",
        " convexedness "            => " bulge ",
        " convexity "               => " appendage ",
        " convey "                  => " back ",
        " conveyable "              => " adaptable ",
        " conveying "               => " carrying ",
        " conveyor "                => " agent ",
        " convict "                 => " captive ",
        " convictable "             => " accusable ",
        " convicted "               => " bedevilled ",
        " conviction "              => " confidence ",
        " convictions "             => " aesthetics ",
        " convince "                => " argue ",
        " convinced "               => " assertive ",
        " convincing "              => " acceptable ",
        " convincingly "            => " assuredly ",
        " convincingness "          => " bearing ",
        " convivial "               => " back-slapping ",
        " conviviality "            => " brotherhood ",
        " convivially "             => " affably ",
        " convocation "             => " assemblage ",
        " convoke "                 => " accumulate ",
        " convolute "               => " convolute ",
        " convoluted "              => " bizarre ",
        " convolution "             => " coil ",
        " convolve "                => " convolute ",
        " convoy "                  => " accompany ",
        " convoying "               => " convoying ",
        " convulse "                => " beat ",
        " convulsed "               => " affronted ",
        " convulsion "              => " attack ",
        " convulsions "             => " amusement ",
        " cook "                    => " baker ",
        " cooked "                  => " adapted ",
        " cooked-up "               => " apocryphal ",
        " cookery "                 => " aliment ",
        " cookies "                 => " accolade ",
        " cooking "                 => " affable ",
        " cool "                    => " air-conditioned ",
        " cool-headed "             => " aloof ",
        " cool-headedness "         => " accord ",
        " cooler "                  => " acknowledgment ",
        " coolheaded "              => " assured ",
        " coolly "                  => " calmly ",
        " coolness "                => " breach ",
        " coop "                    => " accommodation ",
        " cooperate "               => " abet ",
        " cooperating "             => " allied ",
        " cooperative "             => " accommodating ",
        " cooperator "              => " abettor ",
        " coordinate "              => " alike ",
        " coordinated "             => " accommodating ",
        " coordinating "            => " analogous ",
        " coordination "            => " allocation ",
        " coot "                    => " age-old ",
        " cootie "                  => " antibody ",
        " cop-out "                 => " account ",
        " copasetic "               => " acceptable ",
        " copied "                  => " affected ",
        " coping "                  => " arresting ",
        " copiously "               => " abundantly ",
        " copiousness "             => " affluence ",
        " copout "                  => " accommodation ",
        " copper "                  => " chestnut ",
        " copper-colored "          => " brownish ",
        " coppice "                 => " bracken ",
        " coproduce "               => " coact ",
        " copse "                   => " bracken ",
        " copula "                  => " bandage ",
        " copulate "                => " bang ",
        " copulation "              => " coition ",
        " copy "                    => " archetype ",
        " copying "                 => " artful ",
        " copyist "                 => " agent ",
        " copyright "               => " absorb ",
        " coquet "                  => " dally ",
        " coquette "                => " coquette ",
        " coquetting "              => " childishness ",
        " coquettish "              => " backward ",
        " coral "                   => " apricot ",
        " cord "                    => " bond ",
        " cordage "                 => " bond ",
        " cordial "                 => " affable ",
        " cordiality "              => " affability ",
        " cordially "               => " agreeably ",
        " cordon "                  => " award ",
        " core "                    => " amount ",
        " coriaceous "              => " coriaceous ",
        " corker "                  => " aspersion ",
        " corkscrew "               => " braid ",
        " corn "                    => " blah ",
        " corn-fed "                => " blah ",
        " cornball "                => " blah ",
        " corner "                  => " bend ",
        " cornerways "              => " askew ",
        " cornerwise "              => " aslant ",
        " cornucopia "              => " affluence ",
        " corny "                   => " banal ",
        " corollary "               => " aftereffect ",
        " corona "                  => " candelabrum ",
        " coronal "                 => " chaplet ",
        " coronate "                => " adorn ",
        " coronation "              => " accession ",
        " coronet "                 => " chaplet ",
        " corporal "                => " anatomical ",
        " corporate "               => " accumulated ",
        " corporation "             => " association ",
        " corporeal "               => " anatomical ",
        " corporeality "            => " amount ",
        " corporealize "            => " actualize ",
        " corporeity "              => " amount ",
        " corps "                   => " band ",
        " corpse "                  => " body ",
        " corpselike "              => " appalling ",
        " corpulence "              => " blubber ",
        " corpulent "               => " beefy ",
        " corpus "                  => " bulk ",
        " corpuscle "               => " corpuscle ",
        " corpuscles "              => " beef ",
        " corral "                  => " access ",
        " corrasion "               => " abrasion ",
        " correct "                 => " actual ",
        " corrected "               => " adapted ",
        " correcting "              => " acclimation ",
        " correction "              => " alteration ",
        " corrective "              => " antidotal ",
        " correctly "               => " accurately ",
        " correctness "             => " definiteness ",
        " correlate "               => " associate ",
        " correlated "              => " activated ",
        " correlation "             => " alternation ",
        " correlative "             => " allusive ",
        " correspond "              => " accord ",
        " correspondence "          => " accord ",
        " correspondent "           => " contributor ",
        " corresponding "           => " agnate ",
        " correspondingly "         => " appropriately ",
        " corridor "                => " aisle ",
        " corrigendum "             => " blunder ",
        " corrival "                => " adversary ",
        " corroborate "             => " approve ",
        " corroborating "           => " acceptance ",
        " corroboration "           => " acceptance ",
        " corroborative "           => " acknowledging ",
        " corroborator "            => " attestant ",
        " corrode "                 => " bite ",
        " corroded "                => " breakable ",
        " corroding "               => " acerbic ",
        " corrosion "               => " bane ",
        " corrosive "               => " acerb ",
        " corrosiveness "           => " acrimony ",
        " corrugation "             => " bulge ",
        " corrupt "                 => " base ",
        " corrupted "               => " besmirched ",
        " corrupting "              => " allurement ",
        " corruption "              => " bribery ",
        " corsage "                 => " boutonniere ",
        " corsair "                 => " bandit ",
        " cortege "                 => " audience ",
        " cortex "                  => " case ",
        " coruscate "               => " beam ",
        " coruscating "             => " ablaze ",
        " coruscation "             => " beam ",
        " cosign "                  => " authenticate ",
        " cosiness "                => " abundance ",
        " cosmetic "                => " corrective ",
        " cosmetologist "           => " beautician ",
        " cosmic "                  => " catholic ",
        " cosmogonal "              => " catholic ",
        " cosmogonic "              => " catholic ",
        " cosmonaut "               => " cosmonaut ",
        " cosmopolitan "            => " catholic ",
        " cosmopolite "             => " aborigine ",
        " cosmos "                  => " creation ",
        " cossack "                 => " cossack ",
        " cost "                    => " amount ",
        " costive "                 => " cher ",
        " costly "                  => " cher ",
        " costs "                   => " costs ",
        " costume "                 => " apparel ",
        " costumes "                => " apparel ",
        " costumier "               => " clothier ",
        " cote "                    => " berth ",
        " coterie "                 => " assembly ",
        " coterminous "             => " accessory ",
        " cotter "                  => " block ",
        " cotton "                  => " affection ",
        " cotton-mouth "            => " cotton-mouth ",
        " cottony "                 => " cottony ",
        " cougar "                  => " bobcat ",
        " cough "                   => " ahem ",
        " coulee "                  => " coulee ",
        " couloir "                 => " aisle ",
        " council "                 => " board ",
        " councilman "              => " administrator ",
        " councilor "               => " agent ",
        " counsel "                 => " admonition ",
        " counsellor "              => " advocate ",
        " counselor "               => " advisor ",
        " counselors "              => " attorneys ",
        " count "                   => " calculation ",
        " countable "               => " accountable ",
        " countdown "               => " admission ",
        " countenance "             => " aspect ",
        " counter "                 => " adverse ",
        " counter-argument "        => " argument ",
        " counter-claim "           => " acknowledge ",
        " counteract "              => " annul ",
        " counteractant "           => " antitoxin ",
        " counteracting "           => " antidotal ",
        " counteraction "           => " backfire ",
        " counteractive "           => " adverse ",
        " counteragent "            => " antitoxin ",
        " counterattack "           => " argue ",
        " counterbalance "          => " amend ",
        " counterbalanced "         => " counterbalanced ",
        " counterblow "             => " antithesis ",
        " countercheck "            => " abort ",
        " counterclaim "            => " acknowledgment ",
        " counterfactual "          => " apocryphal ",
        " counterfeit "             => " affected ",
        " counterfeited "           => " apish ",
        " counterfeiter "           => " actor ",
        " counterfoil "             => " cancellation ",
        " counterinsurgency "       => " animus ",
        " countermand "             => " annul ",
        " countermanding "          => " abatement ",
        " countermeasure "          => " antitoxin ",
        " countermine "             => " cabal ",
        " counterorder "            => " abjure ",
        " counterpane "             => " batt ",
        " counterpart "             => " analogue ",
        " counterperson "           => " agent ",
        " counterplay "             => " animus ",
        " counterplot "             => " cabal ",
        " counterpoise "            => " abort ",
        " counterpole "             => " antipodal ",
        " counterpose "             => " account ",
        " countersign "             => " adjure ",
        " countersink "             => " auger ",
        " counterstep "             => " antitoxin ",
        " counterstroke "           => " avengement ",
        " countervail "             => " abrogate ",
        " counterweight "           => " balance ",
        " counterword "             => " banality ",
        " counterwork "             => " answer ",
        " countess "                => " adult ",
        " countinghouse "           => " coffer ",
        " countless "               => " endless ",
        " countrified "             => " awkward ",
        " countryman "              => " agriculturist ",
        " countrywide "             => " civic ",
        " county "                  => " canton ",
        " coup "                    => " accomplishment ",
        " coupe "                   => " auto ",
        " couple "                  => " brace ",
        " coupled "                 => " accompanying ",
        " coupler "                 => " articulation ",
        " couplet "                 => " brace ",
        " coupling "                => " coupling ",
        " coupon "                  => " advertisement ",
        " courage "                 => " adventuresomeness ",
        " courageous "              => " adventuresome ",
        " courageousness "          => " backbone ",
        " courier "                 => " bagman ",
        " course "                  => " advance ",
        " coursing "                => " coursing ",
        " court "                   => " cloister ",
        " courteous "               => " affable ",
        " courteously "             => " agreeably ",
        " courteousness "           => " address ",
        " courtesan "               => " coquette ",
        " courtesy "                => " address ",
        " courtiers "               => " associates ",
        " courting "                => " allure ",
        " courtliness "             => " courage ",
        " courtly "                 => " adulatory ",
        " courtroom "               => " attorneys ",
        " courtship "               => " courting ",
        " cousin "                  => " accessory ",
        " couth "                   => " adult ",
        " couturier "               => " clothier ",
        " cove "                    => " anchorage ",
        " covenant "                => " agreement ",
        " cover "                   => " awning ",
        " cover-up "                => " camouflage ",
        " coverage "                => " advantage ",
        " covering "                => " accoutrement ",
        " covert "                  => " buried ",
        " covertness "              => " clandestineness ",
        " covetable "               => " adorable ",
        " coveting "                => " appetent ",
        " covetous "                => " acquisitive ",
        " covetousness "            => " avidity ",
        " covey "                   => " assembly ",
        " covin "                   => " cabal ",
        " coward "                  => " alarmist ",
        " cowardice "               => " abhorrence ",
        " cowardly "                => " afraid ",
        " cowed "                   => " abashed ",
        " cower "                   => " apple-polish ",
        " cowering "                => " afraid ",
        " cowhearted "              => " afraid ",
        " cowing "                  => " abusive ",
        " cowlick "                 => " beard ",
        " coworker "                => " aide ",
        " cows "                    => " beasts ",
        " coxcomb "                 => " coxcomb ",
        " coxswain "                => " accompany ",
        " coyness "                 => " bashfulness ",
        " cozen "                   => " beat ",
        " cozenage "                => " bamboozlement ",
        " cozener "                 => " bluff ",
        " cozening "                => " artifice ",
        " cozy "                    => " comfortable ",
        " crab "                    => " backtalk ",
        " crabbed "                 => " base ",
        " crabbiness "              => " acerbity ",
        " crabbing "                => " annoyed ",
        " crabby "                  => " acid ",
        " crabwise "                => " alongside ",
        " crack "                   => " able ",
        " crack-up "                => " blow ",
        " crackbrained "            => " bananas ",
        " cracked "                 => " absurd ",
        " crackerjack "             => " accomplished ",
        " crackers "                => " absurd ",
        " cracking "                => " arise ",
        " crackle "                 => " burst ",
        " crackpot "                => " beatnik ",
        " cracky "                  => " bitch ",
        " craft "                   => " ability ",
        " craftiness "              => " artfulness ",
        " craftsman "               => " artisan ",
        " craftsmanship "           => " adroitness ",
        " crafty "                  => " adroit ",
        " crag "                    => " bank ",
        " cragged "                 => " broken ",
        " craggy "                  => " broken ",
        " cram "                    => " charge ",
        " crammed "                 => " awash ",
        " crammer "                 => " crammer ",
        " cramming "                => " abstraction ",
        " cramp "                   => " ache ",
        " cramped "                 => " awkward ",
        " cramping "                => " airtight ",
        " cranium "                 => " attic ",
        " crankiness "              => " acerbity ",
        " cranky "                  => " bad-humored ",
        " crannied "                => " broken ",
        " cranny "                  => " breach ",
        " crap "                    => " applesauce ",
        " crapper "                 => " arrogant ",
        " crappy "                  => " abominable ",
        " crash "                   => " blast ",
        " crash-land "              => " bump ",
        " crashed "                 => " comatose ",
        " crasher "                 => " alien ",
        " crashing "                => " abolition ",
        " crasis "                  => " appearance ",
        " crater "                  => " atrium ",
        " craven "                  => " chicken ",
        " craving "                 => " appetite ",
        " crawfish "                => " abjure ",
        " crawl "                   => " clamber ",
        " crawling "                => " ample ",
        " crawlway "                => " adit ",
        " crawly "                  => " awesome ",
        " crayon "                  => " adorn ",
        " craze "                   => " chic ",
        " crazily "                 => " crazily ",
        " craziness "               => " applesauce ",
        " creak "                   => " crepitate ",
        " creaking "                => " acrid ",
        " creaky "                  => " age-old ",
        " cream "                   => " chrism ",
        " creamed "                 => " buttery ",
        " creamy "                  => " buttery ",
        " crease "                  => " bulge ",
        " creased "                 => " channelled ",
        " create "                  => " actualize ",
        " creation "                => " conception ",
        " creative "                => " artistic ",
        " creativeness "            => " apparatus ",
        " creativity "              => " adroitness ",
        " creator "                 => " architect ",
        " creatural "               => " animal ",
        " creature "                => " animal ",
        " credence "                => " acceptance ",
        " credenda "                => " article ",
        " credentials "             => " accreditation ",
        " credibility "             => " believability ",
        " credible "                => " aboveboard ",
        " credit "                  => " acclaim ",
        " creditable "              => " admirable ",
        " creditably "              => " advantageously ",
        " credited "                => " accustomed ",
        " credo "                   => " assumption ",
        " credulity "               => " acceptance ",
        " credulous "               => " accepting ",
        " creed "                   => " canon ",
        " creek "                   => " brook ",
        " creel "                   => " bassinet ",
        " creep "                   => " edge ",
        " creeper "                 => " backcountry ",
        " creeping "                => " bit-by-bit ",
        " creepo "                  => " crank ",
        " creeps "                  => " all-overs ",
        " creepy "                  => " awful ",
        " cremate "                 => " bake ",
        " cremation "               => " burial ",
        " cremator "                => " boiler ",
        " crenel "                  => " cavity ",
        " crenelated "              => " broken ",
        " crepe "                   => " ache ",
        " crepitate "               => " crepitate ",
        " crepitation "             => " crackle ",
        " crepuscular "             => " aphotic ",
        " crepuscule "              => " black ",
        " crescendo "               => " acme ",
        " crescent "                => " bow-shaped ",
        " crescentiform "           => " bow-shaped ",
        " crest "                   => " acme ",
        " crestfallen "             => " blue ",
        " cretinism "               => " asininity ",
        " cretinous "               => " apprenticed ",
        " crevasse "                => " abysm ",
        " crevice "                 => " abyss ",
        " crew "                    => " aggregation ",
        " crewel "                  => " adornment ",
        " crib "                    => " bassinet ",
        " cribber "                 => " bandit ",
        " cribbing "                => " appropriation ",
        " crick "                   => " ache ",
        " cricket "                 => " candid ",
        " crier "                   => " adviser ",
        " crime "                   => " abomination ",
        " criminal "                => " bent ",
        " criminality "             => " abomination ",
        " criminals "               => " abyss ",
        " criminate "               => " allege ",
        " crimp "                   => " coil ",
        " crimped "                 => " coiled ",
        " crimple "                 => " coil ",
        " crimpy "                  => " coiled ",
        " crimson "                 => " blood-soaked ",
        " cringe "                  => " blench ",
        " cringer "                 => " adulator ",
        " cringing "                => " abject ",
        " crinkle "                 => " cockle ",
        " crinkled "                => " channelled ",
        " crinkling "               => " coiled ",
        " crinkly "                 => " coiled ",
        " crip "                    => " adversary ",
        " cripple "                 => " attenuate ",
        " crippled "                => " bedridden ",
        " crisp "                   => " brittle ",
        " crispation "              => " coil ",
        " crispness "               => " conciseness ",
        " crispy "                  => " brittle ",
        " criss-cross "             => " braid ",
        " crisscross "              => " bisect ",
        " criteria "                => " belief ",
        " criterion "               => " archetype ",
        " critic "                  => " analyzer ",
        " critical "                => " analytical ",
        " critically "              => " alarmingly ",
        " criticalness "            => " acuteness ",
        " criticizable "            => " blamable ",
        " critique "                => " appraisal ",
        " critter "                 => " bearcat ",
        " croaking "                => " annihilation ",
        " croaky "                  => " cracked ",
        " crochet "                 => " adornment ",
        " crock "                   => " basin ",
        " crocked "                 => " bashed ",
        " crockery "                => " ceramics ",
        " cronies "                 => " assembly ",
        " crony "                   => " accomplice ",
        " crook "                   => " cheat ",
        " crooked "                 => " agee ",
        " crookedly "               => " askance ",
        " crookedness "             => " anamorphosis ",
        " croon "                   => " carol ",
        " crooner "                 => " accompanist ",
        " crop-raising "            => " agriculture ",
        " cropland "                => " acreage ",
        " cropped "                 => " circumscribed ",
        " cropping "                => " agriculture ",
        " cross "                   => " cantankerous ",
        " cross-examination "       => " assay ",
        " cross-examine "           => " catechize ",
        " cross-eyed "              => " absurd ",
        " cross-fertilize "         => " blend ",
        " cross-hackle "            => " catechize ",
        " cross-mate "              => " blend ",
        " cross-pollinate "         => " blend ",
        " cross-purposes "          => " altercation ",
        " cross-question "          => " catechize ",
        " cross-section "           => " array ",
        " cross-stitch "            => " adornment ",
        " crossbar "                => " batten ",
        " crossbred "               => " alloyed ",
        " crossbreed "              => " blend ",
        " crosscut "                => " bisect ",
        " crossed "                 => " beyond ",
        " crossfire "               => " battery ",
        " crosshatch "              => " bite ",
        " crossing "                => " bridge ",
        " crossness "               => " acerbity ",
        " crosspatch "              => " bear ",
        " crosspiece "              => " batten ",
        " crossroads "              => " capital ",
        " crosswalk "               => " bridge ",
        " crossway "                => " bridge ",
        " crossways "               => " angular ",
        " crosswise "               => " angular ",
        " crotch "                  => " bend ",
        " crouch "                  => " bend ",
        " crouched "                => " below ",
        " crouching "               => " abject ",
        " croupier "                => " broker ",
        " croupy "                  => " blatant ",
        " crow "                    => " babble ",
        " crowd "                   => " army ",
        " crowded "                 => " awash ",
        " crowdedness "             => " bottleneck ",
        " crowding "                => " bottleneck ",
        " crown "                   => " acme ",
        " crowning "                => " consummate ",
        " crucial "                 => " acute ",
        " cruciation "              => " ache ",
        " crucible "                => " affliction ",
        " crucifixion "             => " beheading ",
        " crucify "                 => " excruciate ",
        " cruddy "                  => " abominable ",
        " crude "                   => " awkward ",
        " crudely "                 => " abominably ",
        " crudeness "               => " amateurishness ",
        " crudity "                 => " bawdiness ",
        " crue "                    => " amorphous ",
        " cruel "                   => " atrocious ",
        " cruelly "                 => " actively ",
        " cruelty "                 => " animality ",
        " cruet "                   => " canteen ",
        " cruiser "                 => " cruiser ",
        " cruising "                => " canoeing ",
        " crumb "                   => " atom ",
        " crumbled "                => " burst ",
        " crumbling "               => " crumbling ",
        " crumbly "                 => " breakable ",
        " crumby "                  => " abject ",
        " crummy "                  => " abominable ",
        " crumpled "                => " channelled ",
        " crunch "                  => " crisis ",
        " crunchy "                 => " brittle ",
        " cruor "                   => " claret ",
        " crusade "                 => " cause ",
        " cruse "                   => " amphora ",
        " crush "                   => " drove ",
        " crushed "                 => " ashamed ",
        " crusher "                 => " altercation ",
        " crushing "                => " crushing ",
        " crust "                   => " band ",
        " crusty "                  => " abrupt ",
        " crutch "                  => " accessory ",
        " crux "                    => " body ",
        " crybaby "                 => " baby ",
        " crying "                  => " arrant ",
        " crypt "                   => " catacomb ",
        " cryptogram "              => " bewilderment ",
        " cryptograph "             => " cipher ",
        " crystal "                 => " clear ",
        " crystal-ball "            => " adumbrate ",
        " crystal-clear "           => " bright ",
        " crystalline "             => " apparent ",
        " crystallization "         => " condensate ",
        " crystallize "             => " accumulate ",
        " cubby "                   => " accommodation ",
        " cubbyhole "               => " anteroom ",
        " cubicle "                 => " anteroom ",
        " cuckold "                 => " bedmate ",
        " cuckoldry "               => " affair ",
        " cuddle "                  => " bundle ",
        " cuddlesome "              => " caressible ",
        " cuddly "                  => " caressible ",
        " cudgel "                  => " bastinado ",
        " cuff "                    => " belt ",
        " cuffer "                  => " account ",
        " cuffo "                   => " chargeless ",
        " cuirassiers "             => " army ",
        " culinary "                => " comestible ",
        " cull "                    => " choose ",
        " culled "                  => " adopted ",
        " culling "                 => " alternative ",
        " culmination "             => " acme ",
        " culpability "             => " accountability ",
        " culpable "                => " amiss ",
        " culpatory "               => " accusatory ",
        " cult "                    => " band ",
        " cultism "                 => " appearance ",
        " cultivate "               => " breed ",
        " cultivated "              => " able ",
        " cultivation "             => " agronomics ",
        " cultivator "              => " agriculturalist ",
        " culture "                 => " ability ",
        " cultured "                => " able ",
        " cultus "                  => " admiration ",
        " culvert "                 => " canal ",
        " cumber "                  => " afflict ",
        " cumbersome "              => " bulky ",
        " cumbersomely "            => " agonizingly ",
        " cumbersomeness "          => " bulkiness ",
        " cumbrous "                => " beefy ",
        " cumbrously "              => " agonizingly ",
        " cumulate "                => " accrue ",
        " cumulation "              => " accumulating ",
        " cumulative "              => " accumulative ",
        " cunningness "             => " artifice ",
        " cup-shaped "              => " alveolate ",
        " cupboard "                => " buffet ",
        " cupful "                  => " beaker ",
        " cupidity "                => " acquisitiveness ",
        " cupped "                  => " biconcave ",
        " curate "                  => " abbey ",
        " curative "                => " alleviative ",
        " curator "                 => " babysitter ",
        " curb "                    => " barrier ",
        " curbed "                  => " abstemious ",
        " curbing "                 => " annoyance ",
        " curd "                    => " acerbate ",
        " curdle "                  => " acerbate ",
        " curdling "                => " array ",
        " cure-all "                => " catholicon ",
        " cured "                   => " convalescent ",
        " cureless "                => " absurd ",
        " curfew "                  => " alarm ",
        " curing "                  => " abating ",
        " curio "                   => " anomaly ",
        " curiosity "               => " concern ",
        " curious "                 => " analytical ",
        " curiously "               => " abnormally ",
        " curl "                    => " coil ",
        " curled "                  => " coiled ",
        " curlicue "                => " braid ",
        " curling "                 => " crimper ",
        " curly "                   => " coiled ",
        " curmudgeon "              => " bear ",
        " currency "                => " bill ",
        " current "                 => " accepted ",
        " curricle "                => " barrow ",
        " curriculum "              => " class ",
        " currish "                 => " abhorrent ",
        " curry "                   => " back-scratch ",
        " curse "                   => " anathema ",
        " cursed "                  => " accursed ",
        " curses "                  => " blame ",
        " cursing "                 => " cursing ",
        " cursory "                 => " brief ",
        " curt "                    => " blunt ",
        " curtail "                 => " abbreviate ",
        " curtailed "               => " concise ",
        " curtailing "              => " abbreviating ",
        " curtailment "             => " abbreviation ",
        " curtain "                 => " blind ",
        " curtain-raiser "          => " admission ",
        " curtained "               => " concealed ",
        " curtate "                 => " abbreviate ",
        " curtilage "               => " cloister ",
        " curtness "                => " conciseness ",
        " curtsey "                 => " angle ",
        " curtsy "                  => " angle ",
        " curvaceousness "          => " adequateness ",
        " curvation "               => " arch ",
        " curve "                   => " ambit ",
        " curveball "               => " action ",
        " curved "                  => " arced ",
        " curvilinear "             => " angled ",
        " curving "                 => " arched ",
        " curvy "                   => " ample ",
        " cush "                    => " accretion ",
        " cushion "                 => " beanbag ",
        " cushioned "               => " absorptive ",
        " cushiony "                => " bendable ",
        " cushy "                   => " adequate ",
        " cusp "                    => " bend ",
        " cuspate "                 => " acicular ",
        " cuspidate "               => " acicular ",
        " cuss "                    => " back-bite ",
        " cussed "                  => " base ",
        " cussing "                 => " abuse ",
        " custodial "               => " careful ",
        " custodian "               => " babysitter ",
        " custodianship "           => " aegis ",
        " custody "                 => " aegis ",
        " custom-built "            => " custom-built ",
        " custom-fit "              => " custom-built ",
        " custom-made "             => " custom-built ",
        " customarily "             => " commonly ",
        " customary "               => " accepted ",
        " customer "                => " chump ",
        " customers "               => " barter ",
        " customize "               => " adapt ",
        " customs "                 => " community ",
        " cut-and-dried "           => " advised ",
        " cut-in "                  => " allowance ",
        " cut-off "                 => " absolute ",
        " cut-price "               => " bargain ",
        " cut-rate "                => " bargain ",
        " cut-up "                  => " agreeable ",
        " cutback "                 => " curtailment ",
        " cute "                    => " beautiful ",
        " cutely "                  => " alluringly ",
        " cutie "                   => " amazon ",
        " cutis "                   => " bark ",
        " cutlass "                 => " brand ",
        " cutoff "                  => " blow ",
        " cutout "                  => " agent ",
        " cutthroat "               => " bloodthirsty ",
        " cutting "                 => " acid ",
        " cutup "                   => " actor ",
        " cyberbanking "            => " cyberbanking ",
        " cyberspace "              => " cyberspace ",
        " cyclamates "              => " aspartame ",
        " cycle "                   => " aeon ",
        " cyclic "                  => " circadian ",
        " cyclical "                => " alternate ",
        " cyclopedia "              => " concordance ",
        " cylinder "                => " butt ",
        " cylindrical "             => " annular ",
        " cynic "                   => " carper ",
        " cynical "                 => " contemptuous ",
        " cynicism "                => " acrimony ",
        " cytology "                => " analysis ",
        " czar "                    => " arbiter ",
        " czarism "                 => " absolution ",
        " dabbler "                 => " abecedarian ",
        " dabbling "                => " dabbling ",
        " dachshund "               => " basset ",
        " daddy "                   => " amoroso ",
        " daedal "                  => " abstruse ",
        " daemon "                  => " apparition ",
        " daffodil "                => " adage ",
        " daffy "                   => " cool ",
        " daft "                    => " absurd ",
        " daftness "                => " absurdity ",
        " dagger "                  => " artful ",
        " daggers "                 => " acrimony ",
        " dahlia "                  => " bittersweet ",
        " daily "                   => " circadian ",
        " daintily "                => " cautiously ",
        " daintiness "              => " blemish ",
        " dainty "                  => " airy ",
        " dais "                    => " belvedere ",
        " dale "                    => " basin ",
        " dalliance "               => " dabbling ",
        " dallier "                 => " abecedarian ",
        " dally "                   => " boondoggle ",
        " dallying "                => " adjournment ",
        " damage "                  => " accident ",
        " damages "                 => " amercement ",
        " damask "                  => " bittersweet ",
        " dame "                    => " amazon ",
        " damn "                    => " abuse ",
        " damnable "                => " abhorrent ",
        " damned "                  => " accursed ",
        " damning "                 => " anathema ",
        " damp "                    => " clammy ",
        " dampen "                  => " bedew ",
        " dampened "                => " abject ",
        " dampening "               => " black ",
        " dampish "                 => " clammy ",
        " dampness "                => " clamminess ",
        " damsel "                  => " babe ",
        " dance "                   => " ball ",
        " dancer "                  => " ballerina ",
        " dander "                  => " acrimony ",
        " dandify "                 => " accouter ",
        " dandle "                  => " amuse ",
        " dandy "                   => " capital ",
        " dang "                    => " accursed ",
        " danger "                  => " crisis ",
        " dangerous "               => " alarming ",
        " dangerously "             => " alarmingly ",
        " dangersome "              => " alarming ",
        " dangle "                  => " brandish ",
        " dangling "                => " dangling ",
        " dank "                    => " chilly ",
        " dankness "                => " clamminess ",
        " danseur "                 => " ballerina ",
        " dapper "                  => " active ",
        " dapple "                  => " bespeckle ",
        " dappled "                 => " brindle ",
        " darb "                    => " amazing ",
        " dare "                    => " cartel ",
        " daredevil "               => " charlatan ",
        " daresay "                 => " account ",
        " daring "                  => " adventuresome ",
        " daringly "                => " alarmingly ",
        " dark "                    => " aphotic ",
        " dark-hued "               => " black ",
        " darken "                  => " becloud ",
        " darkened "                => " blurred ",
        " darkening "               => " concealment ",
        " darkish "                 => " bedimmed ",
        " darkness "                => " black ",
        " darling "                 => " angel ",
        " darn "                    => " abuse ",
        " darned "                  => " accursed ",
        " dart "                    => " bound ",
        " dash "                    => " birr ",
        " dashed "                  => " abject ",
        " dashing "                 => " adventurous ",
        " dastard "                 => " craven ",
        " dastardly "               => " afraid ",
        " data "                    => " abstracts ",
        " datal "                   => " archival ",
        " dated "                   => " anachronous ",
        " dateless "                => " around-the-clock ",
        " datum "                   => " accomplishment ",
        " daub "                    => " begrime ",
        " daubed "                  => " anointed ",
        " daughter "                => " babe ",
        " daunt "                   => " alarm ",
        " daunted "                 => " abashed ",
        " daunting "                => " alarming ",
        " dauntless "               => " brave ",
        " dauntlessness "           => " adventurousness ",
        " davenport "               => " bassinet ",
        " dawdle "                  => " amble ",
        " dawdling "                => " adjournment ",
        " dawn "                    => " aurora ",
        " dawning "                 => " alpha ",
        " day-to-day "              => " circadian ",
        " day-tripper "             => " day-tripper ",
        " daybreak "                => " aurora ",
        " daydream "                => " conceiving ",
        " daydreaming "             => " absorbed ",
        " daydreamy "               => " abstract ",
        " daylight "                => " aurora ",
        " days "                    => " canicule ",
        " dayspring "               => " aurora ",
        " daze "                    => " befuddlement ",
        " dazed "                   => " addled ",
        " dazzle "                  => " amaze ",
        " dazzled "                 => " addled ",
        " dazzler "                 => " beauty ",
        " dazzling "                => " admirable ",
        " de-escalate "             => " abate ",
        " deacon "                  => " affect ",
        " deactivate "              => " conciliate ",
        " dead "                    => " asleep ",
        " dead-end "                => " blocked ",
        " dead-eye "                => " anamnesis ",
        " deadbolt "                => " barricade ",
        " deadened "                => " anesthetized ",
        " deadening "               => " analgesic ",
        " deadfall "                => " ambush ",
        " deadline "                => " borderline ",
        " deadliness "              => " accident ",
        " deadlocked "              => " apoplectic ",
        " deadly "                  => " baleful ",
        " deadness "                => " apathy ",
        " deadpan "                 => " deadpan ",
        " deadsville "              => " annoying ",
        " deadweight "              => " accountability ",
        " deaf "                    => " deafened ",
        " deafened "                => " deafened ",
        " deafening "               => " aural ",
        " deal "                    => " accord ",
        " deal-making "             => " banter ",
        " dealer "                  => " banker ",
        " dealie-bob "              => " article ",
        " dealing "                 => " ambidextrous ",
        " dealings "                => " affairs ",
        " dean "                    => " administrator ",
        " dear "                    => " baby ",
        " dearest "                 => " angel ",
        " dearie "                  => " angel ",
        " dearth "                  => " absence ",
        " death "                   => " afterlife ",
        " death-dealing "           => " baleful ",
        " death-defying "           => " atrocious ",
        " deathless "               => " all-knowing ",
        " deathlike "               => " ashen ",
        " deathly "                 => " appalling ",
        " deathwatch "              => " deathwatch ",
        " debacle "                 => " beating ",
        " deball "                  => " alter ",
        " debark "                  => " alight ",
        " debarkation "             => " accession ",
        " debarment "               => " awkwardness ",
        " debase "                  => " abase ",
        " debased "                 => " abashed ",
        " debasement "              => " corruption ",
        " debasing "                => " abasement ",
        " debatable "               => " arguable ",
        " debate "                  => " agitation ",
        " debauch "                 => " abuse ",
        " debauched "               => " abandoned ",
        " debauchery "              => " bender ",
        " debauching "              => " abandoned ",
        " debenture "               => " agreement ",
        " debilitate "              => " attenuate ",
        " debilitation "            => " abrasion ",
        " debility "                => " decrepitude ",
        " debonair "                => " affable ",
        " debouch "                 => " advance ",
        " debrief "                 => " catechize ",
        " debris "                  => " bits ",
        " debug "                   => " alter ",
        " debunk "                  => " deflate ",
        " debut "                   => " admission ",
        " debutante "               => " babe ",
        " decadence "               => " corruption ",
        " decadent "                => " corrupt ",
        " decalescent "             => " ardent ",
        " decampment "              => " abandonment ",
        " decant "                  => " begin ",
        " decanter "                => " canteen ",
        " decapitation "            => " beheading ",
        " decay "                   => " adulteration ",
        " decayed "                 => " addle ",
        " decaying "                => " corrupt ",
        " decease "                 => " curtains ",
        " deceased "                => " asleep ",
        " deceit "                  => " ambidexterity ",
        " deceitful "               => " artful ",
        " deceitfulness "           => " ambidexterity ",
        " deceivable "              => " accommodating ",
        " deceived "                => " bamboozled ",
        " deceiver "                => " bluff ",
        " deceiving "               => " artful ",
        " decelerate "              => " decelerate ",
        " decency "                 => " appropriateness ",
        " decent "                  => " appropriate ",
        " decent-sized "            => " ample ",
        " decently "                => " abundantly ",
        " deception "               => " bamboozlement ",
        " deceptive "               => " ambiguous ",
        " deceptiveness "           => " chicanery ",
        " decern "                  => " anticipate ",
        " decide "                  => " adjudge ",
        " decided "                 => " absitively ",
        " decidedly "               => " absolutely ",
        " decidedness "             => " backbone ",
        " deciding "                => " chief ",
        " decimate "                => " abate ",
        " decimating "              => " bloodthirsty ",
        " decimation "              => " annihilation ",
        " decipher "                => " analyze ",
        " decipherability "         => " accuracy ",
        " decipherable "            => " clear ",
        " decision "                => " accommodation ",
        " decision-making "         => " controlling ",
        " decisive "                => " absolute ",
        " decisively "              => " actually ",
        " decisiveness "            => " backbone ",
        " deck "                    => " accouter ",
        " deckhouse "               => " berth ",
        " decking "                 => " accessory ",
        " declaim "                 => " attack ",
        " declaiming "              => " address ",
        " declamation "             => " declamation ",
        " declamatory "             => " aureate ",
        " declaration "             => " acknowledgment ",
        " declarative "             => " allegorical ",
        " declare "                 => " acknowledge ",
        " declared "                => " declared ",
        " declass "                 => " bankrupt ",
        " declension "              => " coast ",
        " declinate "               => " arced ",
        " declination "             => " atrophy ",
        " declinatory "             => " contumacious ",
        " decline "                 => " abatement ",
        " declined "                => " beneath ",
        " declining "               => " crumbling ",
        " declivitous "             => " abrupt ",
        " declivity "               => " declivity ",
        " decoct "                  => " bubble ",
        " decoction "               => " borsch ",
        " decode "                  => " break ",
        " decoding "                => " adaptation ",
        " decollate "               => " decollate ",
        " decolor "                 => " achromatize ",
        " decolorize "              => " achromatize ",
        " decomposable "            => " decaying ",
        " decomposed "              => " addle ",
        " decomposition "           => " atomization ",
        " decompound "              => " anatomize ",
        " decontaminate "           => " abridge ",
        " decontaminated "          => " antiseptic ",
        " decor "                   => " adornment ",
        " decorate "                => " adorn ",
        " decorated "               => " busy ",
        " decoration "              => " adornment ",
        " decorative "              => " adorning ",
        " decorously "              => " accurately ",
        " decorticate "             => " carve ",
        " decorum "                 => " breeding ",
        " decoy "                   => " allurement ",
        " decrease "                => " abatement ",
        " decreasing "              => " abbreviating ",
        " decreed "                 => " assured ",
        " decreeing "               => " aldermanic ",
        " decrement "               => " cutback ",
        " decrepit "                => " aged ",
        " decrepitude "             => " decrepitude ",
        " decretion "               => " aphorism ",
        " decretum "                => " assize ",
        " decriminalize "           => " approve ",
        " decry "                   => " abuse ",
        " decrying "                => " aspersing ",
        " decrypt "                 => " break ",
        " decumbent "               => " collapsed ",
        " decurtate "               => " abbreviate ",
        " decussate "               => " bisect ",
        " decussation "             => " bridge ",
        " dedicate "                => " address ",
        " dedicated "               => " committed ",
        " dedication "              => " adherence ",
        " dedicatory "              => " celebratory ",
        " dedition "                => " abandonment ",
        " dedomiciling "            => " abatement ",
        " deducing "                => " advertent ",
        " deduct "                  => " abstract ",
        " deduction "               => " answer ",
        " deed "                    => " accomplishment ",
        " deeds "                   => " accomplishments ",
        " deejay "                  => " anchorperson ",
        " deek "                    => " allurement ",
        " deem "                    => " account ",
        " deemed "                  => " accounted ",
        " deep "                    => " abysmal ",
        " deep-down "               => " absolute ",
        " deep-dyed "               => " absolute ",
        " deep-felt "               => " affable ",
        " deep-rooted "             => " abiding ",
        " deep-sea "                => " abyssal ",
        " deep-seated "             => " built-in ",
        " deep-set "                => " alveolate ",
        " deep-toned "              => " beating ",
        " deepening "               => " deepening ",
        " deeper "                  => " added ",
        " deepest "                 => " centermost ",
        " deeply "                  => " acutely ",
        " deepness "                => " abyss ",
        " deescalate "              => " conciliate ",
        " deface "                  => " blemish ",
        " defacement "              => " birthmark ",
        " defacer "                 => " defacer ",
        " defalcate "               => " abstract ",
        " defalcation "             => " defalcation ",
        " defalcator "              => " bandit ",
        " defamation "              => " aspersion ",
        " defamatory "              => " abusive ",
        " defame "                  => " asperse ",
        " defaming "                => " abasing ",
        " default "                 => " absence ",
        " defaultant "              => " behind ",
        " defaulting "              => " behind ",
        " defeasance "              => " beating ",
        " defeasible "              => " abortive ",
        " defeater "                => " conquistador ",
        " defeating "               => " acquisition ",
        " defecate "                => " defecate ",
        " defect "                  => " birthmark ",
        " defecting "               => " abrogation ",
        " defection "               => " alienation ",
        " defective "               => " abnormal ",
        " defectively "             => " afield ",
        " defectiveness "           => " blemish ",
        " defectless "              => " absolute ",
        " defector "                => " backslider ",
        " defend "                  => " avert ",
        " defendable "              => " condonable ",
        " defendant "               => " actor ",
        " defended "                => " dedicated ",
        " defender "                => " apostle ",
        " defending "               => " arresting ",
        " defense "                 => " aegis ",
        " defenseless "             => " caught ",
        " defenselessness "         => " acknowledgment ",
        " defensible "              => " condonable ",
        " defensive "               => " arresting ",
        " defer "                   => " adjourn ",
        " deference "               => " acquiescence ",
        " deferential "             => " civil ",
        " deferment "               => " adjournment ",
        " deferral "                => " cessation ",
        " defiance "                => " affront ",
        " defiant "                 => " aggressive ",
        " deficiency "              => " absence ",
        " deficient "               => " amiss ",
        " deficit "                 => " arrears ",
        " defile "                  => " abuse ",
        " defiled "                 => " besmirched ",
        " defilement "              => " crime ",
        " defiler "                 => " adversary ",
        " defiling "                => " agnostic ",
        " definable "               => " bound ",
        " define "                  => " ascertain ",
        " defined "                 => " authentic ",
        " definite "                => " audible ",
        " definitely "              => " absolutely ",
        " definiteness "            => " accurateness ",
        " definition "              => " analogue ",
        " definitive "              => " absolute ",
        " definitiveness "          => " accurateness ",
        " definitude "              => " accurateness ",
        " deflate "                 => " collapse ",
        " deflated "                => " abandoned ",
        " deflating "               => " abbreviating ",
        " deflation "               => " anticlimax ",
        " deflect "                 => " avert ",
        " deflection "              => " angle ",
        " deflorate "               => " assault ",
        " defloration "             => " abduction ",
        " deflower "                => " assault ",
        " deflowering "             => " abduction ",
        " defoliation "             => " confusion ",
        " deforested "              => " austere ",
        " deform "                  => " batter ",
        " deformation "             => " anamorphosis ",
        " deformed "                => " askew ",
        " deformity "               => " aberration ",
        " defraud "                 => " bamboozle ",
        " defraudation "            => " bamboozlement ",
        " defrauder "               => " bluff ",
        " defrauding "              => " ambidexterity ",
        " defray "                  => " acquit ",
        " defrayal "                => " advantage ",
        " defrayment "              => " allowance ",
        " deft "                    => " able ",
        " deftly "                  => " cautiously ",
        " deftness "                => " adeptness ",
        " defunct "                 => " asleep ",
        " defunction "              => " curtains ",
        " defunctive "              => " appalling ",
        " defy "                    => " baffle ",
        " degeneracy "              => " abasement ",
        " degenerate "              => " base ",
        " degenerated "             => " breakable ",
        " degenerateness "          => " abasement ",
        " degeneration "            => " decline ",
        " degradation "             => " abasement ",
        " degrade "                 => " abase ",
        " degraded "                => " base ",
        " degrading "               => " aspersing ",
        " degree "                  => " amount ",
        " dehiscent "               => " accessible ",
        " dehumidify "              => " anhydrate ",
        " dehydrate "               => " cotton-mouth ",
        " dehydration "             => " aridity ",
        " deific "                  => " all-knowing ",
        " deification "             => " advance ",
        " deify "                   => " adore ",
        " deifying "                => " canonizing ",
        " deign "                   => " condescend ",
        " deistic "                 => " all-powerful ",
        " deity "                   => " celestial ",
        " deject "                  => " cloud ",
        " dejected "                => " abject ",
        " dejecting "               => " austere ",
        " dejection "               => " dejection ",
        " deke "                    => " actor ",
        " delay "                   => " adjournment ",
        " delayed "                 => " delayed ",
        " delaying "                => " dabbling ",
        " dele "                    => " annul ",
        " delectable "              => " adorable ",
        " delectate "               => " allure ",
        " delectation "             => " contentment ",
        " delegate "                => " agent ",
        " delegates "               => " assembly ",
        " delegation "              => " appointment ",
        " delete "                  => " annul ",
        " deleteriousness "         => " abuse ",
        " deletion "                => " abatement ",
        " deli "                    => " cafeteria ",
        " deliberate "              => " advised ",
        " deliberately "            => " advisedly ",
        " deliberating "            => " apperception ",
        " deliberation "            => " application ",
        " delicacy "                => " airiness ",
        " delicate "                => " aerial ",
        " delicately "              => " cautiously ",
        " delicatesse "             => " address ",
        " delicatessen "            => " cafeteria ",
        " delicious "               => " adorable ",
        " delict "                  => " abomination ",
        " delictum "                => " abomination ",
        " delight "                 => " contentment ",
        " delighted "               => " captivated ",
        " delightedly "             => " acquiescently ",
        " delightful "              => " adorable ",
        " delightfully "            => " alluringly ",
        " delightfulness "          => " affability ",
        " delimit "                 => " circumscribe ",
        " delimitate "              => " circumscribe ",
        " delimitation "            => " bonds ",
        " delimited "               => " belted ",
        " delineate "               => " abut ",
        " delineation "             => " curve ",
        " delineative "             => " anecdotic ",
        " delinquency "             => " crime ",
        " delinquent "              => " behind ",
        " deliquesce "              => " adulterate ",
        " deliquescence "           => " condensate ",
        " deliquescent "            => " aqueous ",
        " delirious "               => " aberrant ",
        " deliriously "             => " absurdly ",
        " delirium "                => " aberration ",
        " delish "                  => " aperitive ",
        " deliver "                 => " bear ",
        " deliverance "             => " absolution ",
        " delivering "              => " carrying ",
        " delivery "                => " commitment ",
        " dell "                    => " allowance ",
        " delta "                   => " basin ",
        " deludable "               => " accommodating ",
        " delude "                  => " beguile ",
        " deluded "                 => " bamboozled ",
        " deluder "                 => " cheat ",
        " deluding "                => " ambiguous ",
        " delusion "                => " apparition ",
        " delusive "                => " apparent ",
        " delusory "                => " affected ",
        " deluxe "                  => " choice ",
        " delve "                   => " burrow ",
        " delving "                 => " delving ",
        " demagogic "               => " anarchic ",
        " demagogue "               => " agitator ",
        " demagogy "                => " absolutism ",
        " demand "                  => " appeal ",
        " demanded "                => " accepted ",
        " demanding "               => " ambitious ",
        " demandingness "           => " acuteness ",
        " demarcate "               => " circumscribe ",
        " demarcated "              => " bound ",
        " demarcation "             => " bound ",
        " demarche "                => " action ",
        " demark "                  => " bind ",
        " dematerialization "       => " dematerialization ",
        " dematerialize "           => " abandon ",
        " demean "                  => " abase ",
        " demeaned "                => " abashed ",
        " demeaning "               => " analytical ",
        " demeanor "                => " address ",
        " dement "                  => " bewilder ",
        " demented "                => " bananas ",
        " dementedly "              => " absurdly ",
        " demerit "                 => " bankrupt ",
        " demeritorious "           => " amiss ",
        " demesne "                 => " area ",
        " demijohn "                => " alembic ",
        " demilitarize "            => " conciliate ",
        " demise "                  => " annihilation ",
        " demit "                   => " couch ",
        " demiurgic "               => " artistic ",
        " demo "                    => " audience ",
        " demobilize "              => " conciliate ",
        " democracy "               => " capitalism ",
        " democratic "              => " autonomous ",
        " democratize "             => " adjust ",
        " demography "              => " demography ",
        " demolish "                => " annihilate ",
        " demolished "              => " burst ",
        " demolishing "             => " abolition ",
        " demolishment "            => " blow ",
        " demolition "              => " annihilation ",
        " demoniac "                => " atrocious ",
        " demoniacal "              => " aroused ",
        " demoniacally "            => " atrociously ",
        " demonic "                 => " aroused ",
        " demonology "              => " abracadabra ",
        " demonstrable "            => " ascertainable ",
        " demonstrate "             => " authenticate ",
        " demonstrated "            => " approved ",
        " demonstration "           => " affirmation ",
        " demonstrative "           => " affectionate ",
        " demoralization "          => " abashing ",
        " demoralize "              => " abash ",
        " demoralized "             => " beaten ",
        " demote "                  => " bench ",
        " demotic "                 => " chatty ",
        " demotion "                => " anticlimax ",
        " demperance "              => " abstemiousness ",
        " demulcent "               => " analgesic ",
        " demur "                   => " balk ",
        " demure "                  => " affected ",
        " demureness "              => " abstemiousness ",
        " demurral "                => " adjournment ",
        " demurrer "                => " advancement ",
        " demurring "               => " argument ",
        " demystify "               => " deflate ",
        " denature "                => " alloy ",
        " dendritic "               => " blooming ",
        " dendrology "              => " anatomy ",
        " denial "                  => " abnegation ",
        " denigrate "               => " asperse ",
        " denigrating "             => " abusive ",
        " denigration "             => " abuse ",
        " denizen "                 => " citizen ",
        " denizens "                => " citizenry ",
        " denominate "              => " admit ",
        " denomination "            => " church ",
        " denotation "              => " description ",
        " denotative "              => " allegorical ",
        " denoting "                => " cogent ",
        " denotive "                => " apocalyptic ",
        " denouement "              => " accident ",
        " denounce "                => " accuse ",
        " denouncement "            => " accusation ",
        " denouncing "              => " accusatory ",
        " dense "                   => " close ",
        " densen "                  => " abbreviate ",
        " denseness "               => " concealment ",
        " densify "                 => " abbreviate ",
        " density "                 => " body ",
        " dent "                    => " cavity ",
        " dented "                  => " biconcave ",
        " denticulate "             => " asperous ",
        " denudate "                => " bankrupt ",
        " denudation "              => " acknowledgment ",
        " denude "                  => " bankrupt ",
        " denuded "                 => " bald ",
        " denunciate "              => " admonish ",
        " denunciation "            => " accusation ",
        " deny "                    => " abjure ",
        " denying "                 => " abstinent ",
        " deodorant "               => " abrasive ",
        " deodorize "               => " absterge ",
        " depart "                  => " abandon ",
        " departed "                => " ancient ",
        " departer "                => " alien ",
        " departing "               => " abandonment ",
        " department "              => " administration ",
        " departmental "            => " authoritative ",
        " departmentalizing "       => " analysis ",
        " departure "               => " abandonment ",
        " dependability "           => " abidingness ",
        " dependably "              => " anxiously ",
        " dependant "               => " barnacle ",
        " dependence "              => " assurance ",
        " dependency "              => " annex ",
        " dependent "               => " abased ",
        " dependents "              => " audience ",
        " depict "                  => " characterize ",
        " depiction "               => " delineation ",
        " depictive "               => " anecdotic ",
        " depilated "               => " baldheaded ",
        " deplane "                 => " alight ",
        " deplete "                 => " bankrupt ",
        " depletedness "            => " blank ",
        " depleting "               => " annihilative ",
        " depletion "               => " burning ",
        " deplorable "              => " afflictive ",
        " deplore "                 => " abhor ",
        " deploring "               => " affliction ",
        " deploy "                  => " arrange ",
        " deployable "              => " adaptable ",
        " deponent "                => " attestant ",
        " deportation "             => " displacement ",
        " deported "                => " abandoned ",
        " deportment "              => " actions ",
        " deposal "                 => " adjournment ",
        " deposit "                 => " drop ",
        " deposition "              => " degradation ",
        " depository "              => " archive ",
        " depot "                   => " annex ",
        " depravation "             => " atrophy ",
        " deprave "                 => " bastardize ",
        " depraved "                => " abandoned ",
        " depraving "               => " abandoned ",
        " depravity "               => " abandonment ",
        " deprecate "               => " bemoan ",
        " deprecating "             => " acrimonious ",
        " deprecation "             => " abuse ",
        " deprecatory "             => " aspersing ",
        " depreciate "              => " abate ",
        " depreciated "             => " attenuated ",
        " depreciation "            => " abrasion ",
        " depreciative "            => " aspersing ",
        " depreciatory "            => " adverse ",
        " depredate "               => " assault ",
        " depredation "             => " burglary ",
        " depredatory "             => " bloodthirsty ",
        " depress "                 => " abase ",
        " depressant "              => " biologic ",
        " depressing "              => " black ",
        " depression "              => " abasement ",
        " deprival "                => " denial ",
        " deprivation "             => " denial ",
        " deprive "                 => " bankrupt ",
        " deprived "                => " beggared ",
        " depth "                   => " abyss ",
        " depthless "               => " brief ",
        " depths "                  => " base ",
        " depurate "                => " clean ",
        " depuration "              => " ablution ",
        " deputation "              => " allotment ",
        " depute "                  => " accredit ",
        " deputed "                 => " commissioned ",
        " deputies "                => " assembly ",
        " deputization "            => " appointment ",
        " deputize "                => " accredit ",
        " deputizing "              => " appointment ",
        " deputy "                  => " agent ",
        " derailed "                => " batty ",
        " derange "                 => " confound ",
        " derangement "             => " ataxia ",
        " derelict "                => " behind ",
        " dereliction "             => " contravention ",
        " deride "                  => " banter ",
        " derisive "                => " cheeky ",
        " derisory "                => " audacious ",
        " derivate "                => " acquired ",
        " derivation "              => " ancestry ",
        " derivational "            => " acquired ",
        " derivative "              => " acquired ",
        " derive "                  => " acquire ",
        " derived "                 => " acquired ",
        " deriving "                => " anticipation ",
        " derma "                   => " bark ",
        " dermis "                  => " bark ",
        " derogate "                => " back-bite ",
        " derogation "              => " abasement ",
        " derogative "              => " abasing ",
        " derogatory "              => " aspersing ",
        " derriere "                => " behind ",
        " derring-do "              => " adventurousness ",
        " descant "                 => " carol ",
        " descend "                 => " alight ",
        " descendant "              => " brood ",
        " descendants "             => " birth ",
        " descending "              => " bottomward ",
        " descent "                 => " coast ",
        " describe "                => " call ",
        " described "               => " declared ",
        " describing "              => " anecdotic ",
        " descriptive "             => " anecdotic ",
        " descry "                  => " catch ",
        " desecrate "               => " befoul ",
        " desecrated "              => " besmirched ",
        " desecrating "             => " agnostic ",
        " desecration "             => " abuse ",
        " desecrative "             => " agnostic ",
        " desedimentation "         => " abrasion ",
        " desegregate "             => " accommodate ",
        " desensitize "             => " attenuate ",
        " desert "                  => " arid ",
        " deserted "                => " bare ",
        " desertedness "            => " blank ",
        " desertion "               => " abrogation ",
        " deserts "                 => " chastening ",
        " deserved "                => " adapted ",
        " deservedly "              => " appropriately ",
        " deserving "               => " admirable ",
        " desexualize "             => " castrate ",
        " desiccant "               => " anhydrous ",
        " desiccate "               => " anhydrate ",
        " desiccated "              => " anhydrous ",
        " desiccation "             => " aridity ",
        " desideratum "             => " ambition ",
        " desight "                 => " blend ",
        " design "                  => " architecture ",
        " designate "               => " baptize ",
        " designated "              => " appointed ",
        " designating "             => " anecdotic ",
        " designation "             => " appellation ",
        " designative "             => " apocalyptic ",
        " designed "                => " advised ",
        " designer "                => " artist ",
        " designful "               => " advised ",
        " designless "              => " accidental ",
        " desirability "            => " agreeableness ",
        " desirable "               => " adorable ",
        " desire "                  => " admiration ",
        " desired "                 => " adapted ",
        " desiring "                => " acquisitive ",
        " desirous "                => " acquisitive ",
        " desist "                  => " abandon ",
        " desistance "              => " abeyance ",
        " desk "                    => " board ",
        " desk-bound "              => " desk ",
        " desolate "                => " abandoned ",
        " desolateness "            => " bareness ",
        " desolation "              => " bareness ",
        " despair "                 => " anguish ",
        " despairing "              => " anxious ",
        " desperado "               => " badman ",
        " desperate "               => " atrocious ",
        " desperately "             => " badly ",
        " desperation "             => " agony ",
        " despicable "              => " abject ",
        " despisable "              => " abhorrent ",
        " despisal "                => " antipathy ",
        " despise "                 => " abhor ",
        " despised "                => " abhorred ",
        " despisement "             => " antipathy ",
        " despising "               => " aloof ",
        " despite "                 => " admitting ",
        " despiteful "              => " aspersing ",
        " despitefulness "          => " acerbity ",
        " despoil "                 => " denude ",
        " despoiled "               => " abandoned ",
        " despoiler "               => " bandit ",
        " despoiling "              => " burglary ",
        " despoilment "             => " abduction ",
        " despoliation "            => " abrasion ",
        " despond "                 => " bleed ",
        " despondency "             => " dejection ",
        " despondent "              => " blue ",
        " despot "                  => " autocrat ",
        " despotic "                => " absolutist ",
        " despotism "               => " absolution ",
        " despotize "               => " badger ",
        " dessert "                 => " ambrosia ",
        " destine "                 => " allot ",
        " destiny "                 => " afterlife ",
        " destitute "               => " bankrupt ",
        " destituteness "           => " defalcation ",
        " destitution "             => " defalcation ",
        " destroy "                 => " abort ",
        " destroyer "               => " boner ",
        " destroying "              => " antibacterial ",
        " destructible "            => " decaying ",
        " destruction "             => " abolition ",
        " destructive "             => " annihilative ",
        " destructively "           => " berserk ",
        " destructiveness "         => " aggressiveness ",
        " desuetude "               => " adjournment ",
        " desultory "               => " accidental ",
        " detach "                  => " abstract ",
        " detachable "              => " advertisement ",
        " detached "                => " alone ",
        " detaching "               => " analysis ",
        " detachment "              => " disengagement ",
        " detailed "                => " abundant ",
        " detailing "               => " account ",
        " details "                 => " capacity ",
        " detain "                  => " apprehend ",
        " detained "                => " bedfast ",
        " detainee "                => " bondman ",
        " detainment "              => " apprehension ",
        " detect "                  => " ascertain ",
        " detectable "              => " apparent ",
        " detecting "               => " audition ",
        " detection "               => " apprehension ",
        " detention "               => " apprehension ",
        " deter "                   => " avert ",
        " deterge "                 => " absterge ",
        " detergent "               => " bactericide ",
        " deteriorate "             => " adulterate ",
        " deteriorated "            => " attenuated ",
        " deteriorating "           => " breakable ",
        " deterioration "           => " abasement ",
        " determent "               => " bridle ",
        " determinant "             => " account ",
        " determinate "             => " belted ",
        " determinately "           => " assuredly ",
        " determination "           => " assurance ",
        " determinative "           => " absolute ",
        " determine "               => " actuate ",
        " determined "              => " bent ",
        " determinedly "            => " absolutely ",
        " determining "             => " free ",
        " deterred "                => " beat ",
        " deterrence "              => " aegis ",
        " deterrent "               => " bridle ",
        " deterring "               => " black ",
        " detersion "               => " clarification ",
        " detest "                  => " abhor ",
        " detestable "              => " abhorred ",
        " detestation "             => " abhorrence ",
        " detested "                => " abhorred ",
        " detesting "               => " abhorrence ",
        " dethrone "                => " degrade ",
        " detonate "                => " bang ",
        " detonating "              => " atomic ",
        " detonation "              => " blast ",
        " detonative "              => " atomic ",
        " detract "                 => " backbite ",
        " detracting "              => " abusive ",
        " detraction "              => " abuse ",
        " detractive "              => " abusive ",
        " detractory "              => " abominable ",
        " detrain "                 => " alight ",
        " detriment "               => " damage ",
        " detrimental "             => " adverse ",
        " detritus "                => " bits ",
        " deuce "                   => " brace ",
        " devalorize "              => " abate ",
        " devaluate "               => " abase ",
        " devaluation "             => " abasement ",
        " devalue "                 => " cheapen ",
        " devalued "                => " attenuated ",
        " devastate "               => " demolish ",
        " devastating "             => " adverse ",
        " devastation "             => " confusion ",
        " develop "                 => " advance ",
        " developed "               => " developed ",
        " developmental "           => " adorning ",
        " deviance "                => " aberancy ",
        " deviant "                 => " aberrant ",
        " deviate "                 => " aberrate ",
        " deviating "               => " abnormal ",
        " deviation "               => " aberration ",
        " deviative "               => " aberrant ",
        " device "                  => " accessory ",
        " deviceful "               => " artistic ",
        " devices "                 => " accessories ",
        " devil-may-care "          => " careless ",
        " deviling "                => " brat ",
        " devilkin "                => " brat ",
        " devilment "               => " atrocity ",
        " devilry "                 => " affliction ",
        " devious "                 => " aberrant ",
        " deviousness "             => " artifice ",
        " devirgination "           => " abduction ",
        " devisal "                 => " bequeathal ",
        " devisee "                 => " almsman ",
        " deviser "                 => " architect ",
        " devitalized "             => " debilitated ",
        " devoid "                  => " bare ",
        " devoir "                  => " assignment ",
        " devoirs "                 => " commendations ",
        " devolution "              => " corruption ",
        " devote "                  => " allot ",
        " devoted "                 => " adherent ",
        " devotedly "               => " affectionately ",
        " devotedness "             => " abidingness ",
        " devotee "                 => " addict ",
        " devotees "                => " admirers ",
        " devotement "              => " adherence ",
        " devotion "                => " adherence ",
        " devotional "              => " angelic ",
        " devour "                  => " absorb ",
        " devouring "               => " blaze ",
        " devout "                  => " adherent ",
        " devoutness "              => " adherence ",
        " dewdrop "                 => " bead ",
        " dewiness "                => " bloom ",
        " dewy "                    => " clammy ",
        " dewy-eyed "               => " affected ",
        " dexter "                  => " auspicious ",
        " dexterity "               => " ability ",
        " dexterous "               => " able ",
        " dexterously "             => " calmly ",
        " dextrous "                => " able ",
        " diabolic "                => " atrocious ",
        " diabolical "              => " awful ",
        " diabolically "            => " atrociously ",
        " diabolism "               => " diabolism ",
        " diabolist "               => " archimage ",
        " diacritic "               => " characteristic ",
        " diadem "                  => " chaplet ",
        " diagnose "                => " analyze ",
        " diagnosis "               => " analysis ",
        " diagnostic "              => " analytic ",
        " diagnosticate "           => " analyze ",
        " diagnostics "             => " affection ",
        " diagonal "                => " askew ",
        " diagonally "              => " aslant ",
        " diagrammatic "            => " allegorical ",
        " dial "                    => " punch ",
        " dialect "                 => " accent ",
        " dialectal "               => " chatty ",
        " dialectic "               => " analytic ",
        " dialectical "             => " analytic ",
        " dialectics "              => " acumen ",
        " dialog "                  => " chat ",
        " dialogue "                => " chat ",
        " diameter "                => " bore ",
        " diametric "               => " adverse ",
        " diametrical "             => " adverse ",
        " diamond "                 => " design ",
        " diamonds "                => " chunk ",
        " diapason "                => " area ",
        " diaper "                  => " childhood ",
        " diaphaneity "             => " airiness ",
        " diaphanous "              => " chiffon ",
        " diaphoresis "             => " diaphoresis ",
        " diaries "                 => " affidavit ",
        " diary "                   => " account ",
        " diaspora "                => " banishment ",
        " diatribe "                => " abuse ",
        " dibble "                  => " auger ",
        " dibs "                    => " affirmation ",
        " dicey "                   => " capricious ",
        " dichotomize "             => " bifurcate ",
        " dichotomous "             => " angled ",
        " dickens "                 => " adolescent ",
        " dicker "                  => " bargain ",
        " dictate "                 => " behest ",
        " dictative "               => " absolute ",
        " dictator "                => " absolutist ",
        " dictatorial "             => " absolute ",
        " dictatorship "            => " absolutism ",
        " diction "                 => " delivery ",
        " dictionary "              => " concordance ",
        " dictum "                  => " adage ",
        " didactic "                => " academic ",
        " diddie "                  => " attache ",
        " diddle "                  => " betray ",
        " diddle-daddle "           => " amble ",
        " diddled "                 => " blown ",
        " diddler "                 => " actor ",
        " diddling "                => " bunco ",
        " diddly "                  => " abominable ",
        " dido "                    => " caper ",
        " die-away "                => " apathetic ",
        " diesel "                  => " agent ",
        " dietary "                 => " comestible ",
        " dieting "                 => " dieting ",
        " diff "                    => " animosity ",
        " differ "                  => " alter ",
        " difference "              => " aberration ",
        " different "               => " altered ",
        " differential "            => " cogwheel ",
        " differentiating "         => " appropriate ",
        " differentiation "         => " adverse ",
        " differently "             => " abnormally ",
        " difficultly "             => " agonizingly ",
        " difficulty "              => " adversity ",
        " diffidence "              => " backwardness ",
        " diffident "               => " backward ",
        " diffuse "                 => " broadcast ",
        " diffuseness "             => " circumambages ",
        " diffusion "               => " circulation ",
        " diffusive "               => " deviating ",
        " digenetic "               => " abiogenetic ",
        " digest "                  => " abstract ",
        " digestible "              => " comestible ",
        " digestion "               => " assimilation ",
        " digger "                  => " coquette ",
        " diggings "                => " blasting ",
        " digit "                   => " chiffre ",
        " digital "                 => " agenda ",
        " dignified "               => " aristocratic ",
        " dignify "                 => " adorn ",
        " dignifying "              => " adorning ",
        " dignity "                 => " address ",
        " digress "                 => " aberrate ",
        " digressing "              => " ambagious ",
        " digression "              => " apostrophe ",
        " digressive "              => " circumlocutory ",
        " digressory "              => " ambagious ",
        " digs "                    => " address ",
        " dike "                    => " barricade ",
        " dilapidate "              => " blemish ",
        " dilapidated "             => " battered ",
        " dilapidation "            => " blow ",
        " dilatable "               => " abundant ",
        " dilatant "                => " all-embracing ",
        " dilatation "              => " addendum ",
        " dilate "                  => " amplify ",
        " dilated "                 => " aggrandized ",
        " dilation "                => " aborticide ",
        " dilatoriness "            => " apathy ",
        " dilatory "                => " backward ",
        " dilemma "                 => " bind ",
        " dilettante "              => " artsy ",
        " dilettantish "            => " artsy ",
        " diligence "               => " activity ",
        " diligent "                => " active ",
        " diligently "              => " agilely ",
        " dilly-dallying "          => " adjournment ",
        " dillydally "              => " alternate ",
        " dilute "                  => " adulterate ",
        " diluted "                 => " adulterated ",
        " dilution "                => " concoction ",
        " dim-witted "              => " addled ",
        " dimday "                  => " dark ",
        " dimension "               => " ambit ",
        " dimensionality "          => " ambit ",
        " dimensions "              => " ambit ",
        " dimidiate "               => " bifurcate ",
        " diminish "                => " abate ",
        " diminished "              => " beneath ",
        " diminishing "             => " abbreviating ",
        " diminishment "            => " abbreviation ",
        " diminution "              => " abatement ",
        " dimmet "                  => " dark ",
        " dimming "                 => " concealment ",
        " dimness "                 => " billow ",
        " dimple "                  => " cavity ",
        " dimpled "                 => " biconcave ",
        " dimwit "                  => " blockhead ",
        " dine "                    => " banquet ",
        " diner "                   => " booth ",
        " dinero "                  => " banknote ",
        " ding "                    => " advise ",
        " ding-a-ling "             => " bananas ",
        " dingbat "                 => " accessory ",
        " dingdong "                => " airheaded ",
        " dinger "                  => " alarm ",
        " dinghy "                  => " baiter ",
        " dingle "                  => " bracken ",
        " dingus "                  => " accessory ",
        " dingy "                   => " bedimmed ",
        " dink "                    => " bearcat ",
        " dinky "                   => " bush ",
        " dinner "                  => " banquet ",
        " dinosaur "                => " anachronistic ",
        " dint "                    => " cavity ",
        " diocesan "                => " abbot ",
        " diocese "                 => " area ",
        " diplegic "                => " diplegic ",
        " diploma "                 => " authority ",
        " diplomacy "               => " address ",
        " diplomat "                => " agent ",
        " diplomate "               => " alum ",
        " diplomatic "              => " adept ",
        " dipped "                  => " biconcave ",
        " dippy "                   => " cool ",
        " dire "                    => " acute ",
        " direct "                  => " absolute ",
        " directing "               => " administering ",
        " direction "               => " administration ",
        " directionless "           => " aimless ",
        " directions "              => " admonition ",
        " directive "               => " charge ",
        " directly "                => " anon ",
        " directness "              => " artlessness ",
        " director "                => " administrator ",
        " directorate "             => " advisers ",
        " directorial "             => " authoritative ",
        " directors "               => " admiral ",
        " directorship "            => " administration ",
        " directory "               => " agenda ",
        " direful "                 => " apocalyptic ",
        " dirge "                   => " chant ",
        " dirgeful "                => " afflicted ",
        " dirgelike "               => " black ",
        " dirigible "               => " airship ",
        " dirt "                    => " clay ",
        " dirt-cheap "              => " bargain ",
        " dirtbag "                 => " abject ",
        " dirtiness "               => " blend ",
        " dirtless "                => " apple-pie ",
        " dirty "                   => " bedraggled ",
        " dirty-dealing "           => " clandestine ",
        " dirty-minded "            => " abandoned ",
        " dirtying "                => " contagion ",
        " disability "              => " affliction ",
        " disable "                 => " attenuate ",
        " disablement "             => " affliction ",
        " disabuse "                => " abolish ",
        " disaccord "               => " animosity ",
        " disacknowledge "          => " abjure ",
        " disadvantageous "         => " adverse ",
        " disadvise "               => " avert ",
        " disaffect "               => " agitate ",
        " disaffected "             => " antagonistic ",
        " disaffection "            => " animosity ",
        " disaffiliate "            => " abstract ",
        " disaffirm "               => " confute ",
        " disagreeable "            => " bellicose ",
        " disagreeableness "        => " acerbity ",
        " disagreeing "             => " antagonistic ",
        " disagreement "            => " altercation ",
        " disallow "                => " abjure ",
        " disallowance "            => " abnegation ",
        " disallowing "             => " abrogating ",
        " disallowment "            => " barring ",
        " disannul "                => " abolish ",
        " disappear "               => " abandon ",
        " disappearance "           => " dematerialization ",
        " disappeared "             => " abolished ",
        " disappearing "            => " dematerialization ",
        " disappoint "              => " abort ",
        " disappointed "            => " aghast ",
        " disappointing "           => " black ",
        " disapprobation "          => " acrimony ",
        " disapprove "              => " blame ",
        " disapproved "             => " banned ",
        " disapproving "            => " accusatory ",
        " disarm "                  => " conciliate ",
        " disarming "               => " convincing ",
        " disarranged "             => " blurred ",
        " disarrangement "          => " ataxia ",
        " disarranging "            => " abashing ",
        " disarray "                => " ataxia ",
        " disarrayed "              => " bedraggled ",
        " disarticulate "           => " break ",
        " disarticulation "         => " break ",
        " disassemble "             => " detach ",
        " disassociate "            => " abstract ",
        " disassociated "           => " afar ",
        " disassociation "          => " alienation ",
        " disaster "                => " adversity ",
        " disastrous "              => " adverse ",
        " disavow "                 => " abjure ",
        " disavowal "               => " abnegation ",
        " disavowing "              => " abrogation ",
        " disband "                 => " adjourn ",
        " disbar "                  => " abase ",
        " disbarment "              => " abasement ",
        " disbelief "               => " atheism ",
        " disbelieve "              => " discount ",
        " disbeliever "             => " carper ",
        " disbelieving "            => " aporetic ",
        " disbodied "               => " aerial ",
        " disburse "                => " acquit ",
        " disbursement "            => " cost ",
        " discard "                 => " abandon ",
        " discarded "               => " alone ",
        " discarding "              => " auctioning ",
        " discarnate "              => " aerial ",
        " discept "                 => " agitate ",
        " discern "                 => " anticipate ",
        " discernible "             => " apparent ",
        " discernibly "             => " acutely ",
        " discerning "              => " acute ",
        " discernment "             => " accuracy ",
        " discharge "               => " acquittal ",
        " discharged "              => " absolved ",
        " discharging "             => " absolution ",
        " discinct "                => " behindhand ",
        " disciple "                => " adherent ",
        " disciples "               => " aggregation ",
        " disciplinarian "          => " authoritarian ",
        " disciplinary "            => " antidotal ",
        " discipline "              => " conduct ",
        " disciplined "             => " acclimatized ",
        " disciplining "            => " adorning ",
        " disclaim "                => " abandon ",
        " disclaimer "              => " abnegation ",
        " disclose "                => " acknowledge ",
        " disclosed "               => " appear ",
        " disclosing "              => " advice ",
        " disclosure "              => " acknowledgment ",
        " discoid "                 => " annular ",
        " discolor "                => " besmear ",
        " discoloration "           => " birthmark ",
        " discolored "              => " bedimmed ",
        " discombobulate "          => " abash ",
        " discombobulated "         => " ashamed ",
        " discombobulation "        => " ataxia ",
        " discomfit "               => " abash ",
        " discomfited "             => " ashamed ",
        " discomfiting "            => " abashing ",
        " discomfiture "            => " abashment ",
        " discomfort "              => " ache ",
        " discommend "              => " bemoan ",
        " discommode "              => " bother ",
        " discommoding "            => " awkward ",
        " discommodious "           => " annoying ",
        " discompose "              => " agitate ",
        " discomposed "             => " addled ",
        " discomposure "            => " affliction ",
        " disconcert "              => " abash ",
        " disconcerted "            => " annoyed ",
        " disconcerting "           => " annoying ",
        " disconcertion "           => " abashment ",
        " disconcertment "          => " abashment ",
        " disconfirm "              => " bankrupt ",
        " discongruity "            => " aberration ",
        " disconnect "              => " abstract ",
        " disconnected "            => " broken ",
        " disconnectedly "          => " anyhow ",
        " disconnection "           => " break ",
        " disconsolateness "        => " agony ",
        " disconsolation "          => " abasement ",
        " disconsonant "            => " adverse ",
        " discontent "              => " depression ",
        " discontented "            => " bitching ",
        " discontentment "          => " depression ",
        " discontinuance "          => " adjournment ",
        " discontinuation "         => " cessation ",
        " discontinue "             => " abandon ",
        " discontinuing "           => " alternate ",
        " discontinuity "           => " aperture ",
        " discontinuous "           => " alternate ",
        " disconvenience "          => " bother ",
        " discord "                 => " animosity ",
        " discordance "             => " affray ",
        " discordant "              => " antagonistic ",
        " discordantly "            => " abnormally ",
        " discount "                => " abatement ",
        " discountenance "          => " abash ",
        " discountenancing "        => " abnegation ",
        " discourage "              => " abash ",
        " discouraged "             => " beat ",
        " discouraging "            => " black ",
        " discouragingly "          => " awfully ",
        " discourse "               => " address ",
        " discoursing "             => " address ",
        " discourteous "            => " abrupt ",
        " discourtesy "             => " abasement ",
        " discover "                => " ascertain ",
        " discoverable "            => " accountable ",
        " discovered "              => " apparent ",
        " discovering "             => " advertent ",
        " discovery "               => " analysis ",
        " discreate "               => " blend ",
        " discreditable "           => " aspersing ",
        " discrediting "            => " abrasive ",
        " discreet "                => " alert ",
        " discreetly "              => " carefully ",
        " discreetness "            => " attention ",
        " discrepancy "             => " alterity ",
        " discrete "                => " detached ",
        " discreteness "            => " acumen ",
        " discretion "              => " acumen ",
        " discretional "            => " alternative ",
        " discretionary "           => " arbitrary ",
        " discriminating "          => " acute ",
        " discrimination "          => " bigotry ",
        " discriminative "          => " authentic ",
        " discriminatory "          => " abominable ",
        " disculpate "              => " absolve ",
        " discursion "              => " departure ",
        " discursive "              => " abstruse ",
        " discursiveness "          => " circumambages ",
        " discuss "                 => " altercate ",
        " discussion "              => " altercation ",
        " disdain "                 => " antipathy ",
        " disdainful "              => " aloof ",
        " disdainfulness "          => " airs ",
        " disease "                 => " ache ",
        " disease-free "            => " advantageous ",
        " diseased "                => " afflicted ",
        " diseasedness "            => " affliction ",
        " disedge "                 => " attenuate ",
        " disembalm "               => " disclose ",
        " disembark "               => " alight ",
        " disembarkation "          => " accession ",
        " disembarrassment "        => " accomplishment ",
        " disembodied "             => " aerial ",
        " disembogue "              => " disembogue ",
        " disembowel "              => " bowel ",
        " disenable "               => " attenuate ",
        " disenablement "           => " awkwardness ",
        " disenchant "              => " abort ",
        " disencumber "             => " ameliorate ",
        " disenfranchise "          => " bind ",
        " disenfranchised "         => " blank ",
        " disengage "               => " abstract ",
        " disengaged "              => " able ",
        " disengagement "           => " disengagement ",
        " disentanglement "         => " accomplishment ",
        " disenthrall "             => " affranchise ",
        " disentitlement "          => " awkwardness ",
        " disentomb "               => " disclose ",
        " disentranced "            => " apathetic ",
        " disequilibrium "          => " alternation ",
        " disestablish "            => " abate ",
        " disesteem "               => " antipathy ",
        " disesteemed "             => " abhorred ",
        " disfavor "                => " aversion ",
        " disfavored "              => " abhorred ",
        " disfeature "              => " blemish ",
        " disfigure "               => " blemish ",
        " disfigured "              => " agee ",
        " disfigurement "           => " birthmark ",
        " disgorge "                => " discharge ",
        " disgrace "                => " abasement ",
        " disgraced "               => " ashamed ",
        " disgraceful "             => " blameworthy ",
        " disgracefully "           => " clumsily ",
        " disgracing "              => " abasing ",
        " disgracious "             => " aweless ",
        " disgruntle "              => " abort ",
        " disgruntled "             => " annoyed ",
        " disgruntlement "          => " affliction ",
        " disguise "                => " beard ",
        " disguised "               => " bearded ",
        " disguising "              => " camouflage ",
        " disgust "                 => " abhorrence ",
        " disgusting "              => " abominable ",
        " dish "                    => " bowl ",
        " dishabille "              => " dishabille ",
        " disharmonic "             => " clinking ",
        " disharmonious "           => " cacophonic ",
        " disharmonism "            => " clash ",
        " disharmonize "            => " conflict ",
        " disharmony "              => " clash ",
        " disheartened "            => " abashed ",
        " disheartening "           => " alarming ",
        " disheartenment "          => " anguish ",
        " dishevelled "             => " decrepit ",
        " dishevelment "            => " ataxia ",
        " dishonest "               => " backbiting ",
        " dishonesty "              => " artifice ",
        " dishonor "                => " abasement ",
        " dishonorable "            => " base ",
        " dishonored "              => " abandoned ",
        " dishonoring "             => " aspersing ",
        " dishwater "               => " borsch ",
        " dishy "                   => " ambrosial ",
        " disillusion "             => " abort ",
        " disimprison "             => " absolve ",
        " disimprisonment "         => " acquittal ",
        " disimprove "              => " abate ",
        " disincentive "            => " bridle ",
        " disinclination "          => " alienation ",
        " disincline "              => " check ",
        " disinclined "             => " afraid ",
        " disinfect "               => " antisepticize ",
        " disinfectant "            => " antibacterial ",
        " disinfected "             => " antiseptic ",
        " disinfection "            => " ablution ",
        " disinform "               => " beguile ",
        " disinformation "          => " bamboozlement ",
        " disinformed "             => " bearded ",
        " disingenuous "            => " artful ",
        " disingenuousness "        => " canard ",
        " disinherit "              => " bereave ",
        " disinherited "            => " abandoned ",
        " disinhume "               => " disclose ",
        " disintegrate "            => " atomize ",
        " disintegrated "           => " burst ",
        " disintegrating "          => " abolition ",
        " disintegration "          => " abrasion ",
        " disintegrative "          => " acerbic ",
        " disinter "                => " disclose ",
        " disinterest "             => " aloofness ",
        " disinterested "           => " aloof ",
        " disinterring "            => " blasting ",
        " disject "                 => " advertise ",
        " disjoin "                 => " abstract ",
        " disjoined "               => " disconnected ",
        " disjoining "              => " disengagement ",
        " disjoint "                => " break ",
        " disjointed "              => " aimless ",
        " disjointedness "          => " chaos ",
        " disjointly "              => " alone ",
        " disjunction "             => " breach ",
        " disjuncture "             => " analysis ",
        " disk "                    => " deejay ",
        " disk-shaped "             => " annular ",
        " disklike "                => " annular ",
        " dislikable "              => " abominable ",
        " dislike "                 => " animosity ",
        " disliked "                => " awful ",
        " disliking "               => " afraid ",
        " dislimb "                 => " attenuate ",
        " dislocate "               => " break ",
        " dislocated "              => " confused ",
        " dislocation "             => " break ",
        " dislodgement "            => " boot ",
        " dislodgment "             => " adjournment ",
        " disloyal "                => " alienated ",
        " disloyalty "              => " apostasy ",
        " dismal "                  => " afflictive ",
        " dismals "                 => " apathy ",
        " dismantle "               => " annihilate ",
        " dismay "                  => " agitation ",
        " dismayed "                => " abashed ",
        " dismaying "               => " alarming ",
        " dismember "               => " amputate ",
        " dismembered "             => " burst ",
        " dismemberment "           => " anatomization ",
        " dismiss "                 => " abolish ",
        " dismissal "               => " adjournment ",
        " dismissed "               => " absolved ",
        " dismissing "              => " absolution ",
        " dismount "                => " alight ",
        " dismounting "             => " accession ",
        " disobedience "            => " defiance ",
        " disobedient "             => " contrary ",
        " disobey "                 => " balk ",
        " disobeyed "               => " abandoned ",
        " disoblige "               => " affront ",
        " disobliging "             => " annoying ",
        " disorder "                => " ataxia ",
        " disordered "              => " confused ",
        " disorderliness "          => " ataxia ",
        " disorderly "              => " chaotic ",
        " disorganization "         => " chaos ",
        " disorganized "            => " chaotic ",
        " disorient "               => " addle ",
        " disoriented "             => " adrift ",
        " disown "                  => " abandon ",
        " disownment "              => " alienation ",
        " disparage "               => " abuse ",
        " disparagement "           => " aspersion ",
        " disparaging "             => " calumniating ",
        " disparately "             => " abnormally ",
        " disparateness "           => " annulment ",
        " disparity "               => " alterity ",
        " disparting "              => " analysis ",
        " dispassion "              => " aloofness ",
        " dispassionate "           => " abstract ",
        " dispassionateness "       => " balance ",
        " dispatch "                => " celerity ",
        " dispatched "              => " accomplished ",
        " dispatcher "              => " bagman ",
        " dispatching "             => " auctioning ",
        " dispathy "                => " abhorrence ",
        " dispeace "                => " animosity ",
        " dispel "                  => " allay ",
        " dispelling "              => " dehydration ",
        " dispensable "             => " disposable ",
        " dispensary "              => " berth ",
        " dispensation "            => " allotment ",
        " dispense "                => " allocate ",
        " dispersal "               => " breakdown ",
        " disperse "                => " banish ",
        " dispersed "               => " broadcast ",
        " dispersion "              => " burning ",
        " dispirit "                => " bankrupt ",
        " dispirited "              => " blue ",
        " dispiritedness "          => " abasement ",
        " dispiriting "             => " atrocious ",
        " displacement "            => " displacement ",
        " display "                 => " affectation ",
        " displaying "              => " announcement ",
        " displease "               => " aggravate ",
        " displeased "              => " affronted ",
        " displeasing "             => " adverse ",
        " displeasure "             => " anger ",
        " disport "                 => " display ",
        " disposable "              => " disposable ",
        " disposal "                => " auctioning ",
        " dispose "                 => " actuate ",
        " disposing "               => " administration ",
        " dispossess "              => " bankrupt ",
        " dispossessed "            => " beggared ",
        " dispossession "           => " denial ",
        " dispraise "               => " abuse ",
        " disproof "                => " abnegation ",
        " disproportion "           => " asymmetry ",
        " disproportional "         => " askew ",
        " disproportionate "        => " asymmetric ",
        " disprove "                => " belie ",
        " disputable "              => " arguable ",
        " disputant "               => " adversary ",
        " disputation "             => " argumentation ",
        " disputatious "            => " cantankerous ",
        " disputative "             => " angry ",
        " dispute "                 => " altercation ",
        " disputed "                => " acknowledged ",
        " disputing "               => " against ",
        " disqualification "        => " awkwardness ",
        " disqualified "            => " butterfingers ",
        " disquiet "                => " ailment ",
        " disquieted "              => " afraid ",
        " disquieting "             => " annoying ",
        " disquietude "             => " all-overs ",
        " disquisition "            => " address ",
        " disquisitional "          => " critical ",
        " disquisitive "            => " analytical ",
        " disrate "                 => " bench ",
        " disregard "               => " apathy ",
        " disregardance "           => " carelessness ",
        " disregarded "             => " abandoned ",
        " disregardful "            => " absent-minded ",
        " disregarding "            => " behindhand ",
        " disrelation "             => " break ",
        " disrelish "               => " alienation ",
        " disremember "             => " balloon ",
        " disremembered "           => " abandoned ",
        " disrepair "               => " busted ",
        " disreputable "            => " abject ",
        " disreputably "            => " clumsily ",
        " disrepute "               => " blemish ",
        " disrespect "              => " boldness ",
        " disrespectful "           => " aweless ",
        " disrespectfulness "       => " assurance ",
        " disrobe "                 => " bankrupt ",
        " disrobed "                => " bare ",
        " disrupt "                 => " agitate ",
        " disrupter "               => " advocate ",
        " disrupting "              => " abolition ",
        " disruptive "              => " confusing ",
        " disruptiveness "          => " aggro ",
        " dissatisfaction "         => " annoyance ",
        " dissatisfactory "         => " abominable ",
        " dissatisfied "            => " annoyed ",
        " dissatisfy "              => " abash ",
        " dissect "                 => " anatomize ",
        " dissecting "              => " analytic ",
        " dissection "              => " anatomization ",
        " dissemblance "            => " ambidexterity ",
        " dissemble "               => " affect ",
        " dissembled "              => " buried ",
        " dissembler "              => " actor ",
        " dissembling "             => " ambiguous ",
        " disseminate "             => " advertise ",
        " disseminated "            => " broadcast ",
        " dissemination "           => " broadcasting ",
        " dissension "              => " altercation ",
        " dissent "                 => " bone ",
        " dissenter "               => " backslider ",
        " dissentient "             => " adverse ",
        " dissenting "              => " agnostic ",
        " dissention "              => " altercation ",
        " dissentious "             => " damaging ",
        " dissentive "              => " agnostic ",
        " dissert "                 => " argue ",
        " dissertate "              => " argue ",
        " dissertation "            => " argument ",
        " disserve "                => " abuse ",
        " disseverance "            => " analysis ",
        " dissidence "              => " clinker ",
        " dissident "               => " agitator ",
        " dissimilar "              => " antithetical ",
        " dissimilarity "           => " contrast ",
        " dissimilarly "            => " abnormally ",
        " dissimilation "           => " affectation ",
        " dissimilitude "           => " adverse ",
        " dissimulate "             => " camouflage ",
        " dissimulated "            => " affected ",
        " dissimulation "           => " appearance ",
        " dissimulator "            => " actor ",
        " dissipate "               => " blow ",
        " dissipated "              => " blown ",
        " dissipating "             => " administration ",
        " dissipation "             => " amusement ",
        " dissipative "             => " careless ",
        " dissociate "              => " abstract ",
        " dissociation "            => " break ",
        " dissolute "               => " abandoned ",
        " dissoluteness "           => " bender ",
        " dissolvable "             => " aqueous ",
        " dissolve "                => " deliquesce ",
        " dissolved "               => " attenuated ",
        " dissolvent "              => " acerbic ",
        " dissolving "              => " abandoning ",
        " dissonance "              => " antagonism ",
        " dissonancy "              => " clash ",
        " dissonant "               => " anomalous ",
        " dissuading "              => " black ",
        " dissuasion "              => " admonition ",
        " distance "                => " ambit ",
        " distancing "              => " break ",
        " distant "                 => " abroad ",
        " distaste "                => " abhorrence ",
        " distasteful "             => " abominable ",
        " distemper "               => " acrimony ",
        " distend "                 => " amplify ",
        " distended "               => " beefy ",
        " distensible "             => " abundant ",
        " distension "              => " amplification ",
        " distent "                 => " bouncing ",
        " distention "              => " appendage ",
        " distillate "              => " alcohol ",
        " distillation "            => " beverage ",
        " distinct "                => " audible ",
        " distinction "             => " acumen ",
        " distinctive "             => " characteristic ",
        " distinctively "           => " abnormally ",
        " distinctiveness "         => " acumen ",
        " distinctly "              => " audibly ",
        " distinctness "            => " accuracy ",
        " distingue "               => " able ",
        " distinguish "             => " analyze ",
        " distinguishable "         => " apparent ",
        " distinguished "           => " acclaimed ",
        " distinguishing "          => " appropriate ",
        " distort "                 => " alter ",
        " distorted "               => " adulterated ",
        " distortion "              => " baloney ",
        " distract "                => " abstract ",
        " distracted "              => " absent ",
        " distractedly "            => " absurdly ",
        " distracting "             => " confusing ",
        " distraction "             => " aberration ",
        " distrait "                => " absent ",
        " distraught "              => " addled ",
        " distress "                => " ache ",
        " distressed "              => " afflicted ",
        " distressing "             => " cutting ",
        " distressingly "           => " acutely ",
        " distribute "              => " administer ",
        " distributed "             => " broadcast ",
        " distribution "            => " administration ",
        " distributor "             => " benefactor ",
        " district "                => " commune ",
        " distrust "                => " disbelief ",
        " distrustful "             => " cagey ",
        " distrusting "             => " cagey ",
        " disturb "                 => " afflict ",
        " disturbance "             => " agitation ",
        " disturbed "               => " abashed ",
        " disturbing "              => " advancing ",
        " disturbingly "            => " awfully ",
        " disunify "                => " agitate ",
        " disunion "                => " disengagement ",
        " disunited "               => " aimless ",
        " disuniting "              => " analysis ",
        " disunity "                => " alienation ",
        " disuse "                  => " decay ",
        " disused "                 => " anachronistic ",
        " ditch "                   => " canal ",
        " dithering "               => " ambivalent ",
        " dithers "                 => " collywobbles ",
        " ditsy "                   => " apparent ",
        " ditto "                   => " akin ",
        " ditty "                   => " carol ",
        " diurnal "                 => " circadian ",
        " diuturnal "               => " abiding ",
        " divagate "                => " aberrate ",
        " divagation "              => " apostrophe ",
        " divan "                   => " bassinet ",
        " divarication "            => " contrast ",
        " diverge "                 => " bend ",
        " divergence "              => " alteration ",
        " divergency "              => " clash ",
        " divergent "               => " aberrant ",
        " divergently "             => " abnormally ",
        " diverging "               => " deviating ",
        " divers "                  => " defined ",
        " diverse "                 => " assorted ",
        " diversely "               => " abnormally ",
        " diverseness "             => " alterity ",
        " diversification "         => " about-face ",
        " diversified "             => " adapted ",
        " diversiform "             => " anthologized ",
        " diversify "               => " alter ",
        " diversion "               => " aberration ",
        " diversity "               => " assortment ",
        " divert "                  => " alter ",
        " diverted "                => " absent ",
        " diverting "               => " breach ",
        " divertisement "           => " amusement ",
        " divertissement "          => " amusement ",
        " divest "                  => " bankrupt ",
        " divested "                => " bald ",
        " divestiture "             => " denial ",
        " divestment "              => " denial ",
        " divide "                  => " bisect ",
        " divided "                 => " disconnected ",
        " dividend "                => " allotment ",
        " dividends "               => " assets ",
        " divider "                 => " affiliate ",
        " dividing "                => " adding ",
        " divination "              => " divination ",
        " divine "                  => " all-powerful ",
        " divinely "                => " alluringly ",
        " divineness "              => " asceticism ",
        " diviner "                 => " diviner ",
        " division "                => " analysis ",
        " divisional "              => " bounded ",
        " divisions "               => " capacity ",
        " divisive "                => " alienated ",
        " divisiveness "            => " altercation ",
        " divorce "                 => " annulment ",
        " divorced "                => " afar ",
        " divorcement "             => " disengagement ",
        " divulgation "             => " acknowledgment ",
        " divulge "                 => " admit ",
        " divulged "                => " appear ",
        " divulgement "             => " adumbration ",
        " divulgence "              => " accession ",
        " divulging "               => " acknowledgment ",
        " divvy "                   => " admeasure ",
        " dizen "                   => " accouter ",
        " dizziness "               => " blackout ",
        " dizzy "                   => " addled ",
        " dizzying "                => " boundless ",
        " do-nothingness "          => " apathy ",
        " doable "                  => " achievable ",
        " docent "                  => " adviser ",
        " docile "                  => " accommodating ",
        " docility "                => " acquiescence ",
        " docious "                 => " accommodating ",
        " dock "                    => " berth ",
        " dockage "                 => " abatement ",
        " docket "                  => " calendar ",
        " docking "                 => " advancing ",
        " doctored "                => " adapted ",
        " doctoring "               => " adulteration ",
        " doctrinaire "             => " authoritarian ",
        " doctrine "                => " article ",
        " document "                => " certificate ",
        " documentation "           => " affidavit ",
        " documented "              => " accurate ",
        " documents "               => " abstracts ",
        " dodder "                  => " clump ",
        " doddering "               => " aged ",
        " doddery "                 => " aged ",
        " dodge "                   => " contrivance ",
        " dodging "                 => " abstention ",
        " dodo "                    => " airhead ",
        " doer "                    => " abettor ",
        " doff "                    => " bankrupt ",
        " dog-ear "                 => " bulge ",
        " dog-eared "               => " ailing ",
        " dog-eat-dog "             => " aggressive ",
        " dog-end "                 => " butt ",
        " dog-eye "                 => " abhorrence ",
        " dog-hungry "              => " dog-hungry ",
        " dog-tired "               => " beat ",
        " dogcatcher "              => " administrator ",
        " doge "                    => " artifice ",
        " dogface "                 => " airedale ",
        " dogfight "                => " action ",
        " dogged "                  => " adamant ",
        " doggedly "                => " adamantly ",
        " doggedness "              => " abidingness ",
        " doggerel "                => " balladry ",
        " doggone "                 => " accursed ",
        " doggy "                   => " active ",
        " doghouse "                => " aversion ",
        " dogie "                   => " dogie ",
        " dogies "                  => " beasts ",
        " dogleg "                  => " bend ",
        " dogma "                   => " article ",
        " dogmas "                  => " behavior ",
        " dogmatic "                => " arbitrary ",
        " dogmatist "               => " advocate ",
        " dogsbody "                => " crammer ",
        " dohickey "                => " accoutrement ",
        " doing "                   => " accomplishing ",
        " doings "                  => " affairs ",
        " dojigger "                => " commodity ",
        " dojiggy "                 => " accoutrement ",
        " doldrums "                => " apathy ",
        " dole "                    => " allotment ",
        " doleful "                 => " afflicted ",
        " dolefulness "             => " abasement ",
        " dolent "                  => " afflicted ",
        " dolesome "                => " afflicted ",
        " doll "                    => " baby ",
        " dollop "                  => " atom ",
        " dolly "                   => " barrow ",
        " dolman "                  => " capote ",
        " dolor "                   => " agony ",
        " dolorous "                => " afflicted ",
        " dolt "                    => " airhead ",
        " domain "                  => " area ",
        " dome "                    => " arch ",
        " domestic "                => " calm ",
        " domesticate "             => " acclimatize ",
        " domesticated "            => " calm ",
        " domestication "           => " conduct ",
        " domesticize "             => " acclimatize ",
        " domical "                 => " annular ",
        " domicile "                => " abode ",
        " domiciliary "             => " calm ",
        " domiciliate "             => " acclimatize ",
        " domicilic "               => " domiciliary ",
        " dominance "               => " ascendancy ",
        " dominant "                => " ascendant ",
        " dominate "                => " boss ",
        " dominated "               => " bedeviled ",
        " dominating "              => " assertive ",
        " domination "              => " ascendancy ",
        " dominator "               => " administrator ",
        " domineer "                => " bend ",
        " domineering "             => " arrogant ",
        " dominion "                => " ascendancy ",
        " donate "                  => " accord ",
        " donating "                => " altruistic ",
        " donee "                   => " almsman ",
        " dong "                    => " bell ",
        " donjon "                  => " alcazar ",
        " donnish "                 => " academic ",
        " donnybrook "              => " altercation ",
        " dons "                    => " advisers ",
        " doodad "                  => " accessory ",
        " doodle "                  => " blow ",
        " doohickey "               => " abscess ",
        " doomed "                  => " bedevilled ",
        " doomful "                 => " acute ",
        " door "                    => " aperture ",
        " doorkeeper "              => " attendant ",
        " doorknob "                => " bulge ",
        " doorman "                 => " attendant ",
        " doormat "                 => " chump ",
        " doorpost "                => " column ",
        " doorstep "                => " doorstep ",
        " doorway "                 => " aperture ",
        " doozer "                  => " ample ",
        " dope "                    => " blockhead ",
        " doped "                   => " benumbed ",
        " dopehead "                => " addict ",
        " doper "                   => " addict ",
        " dopey "                   => " comatose ",
        " dopy "                    => " comatose ",
        " dork "                    => " bang ",
        " dorky "                   => " abhorrent ",
        " dorm "                    => " abode ",
        " dormancy "                => " cessation ",
        " dormant "                 => " abeyant ",
        " dormer "                  => " attic ",
        " dormitory "               => " billet ",
        " dorsal "                  => " after ",
        " dory "                    => " adequate ",
        " dosage "                  => " dosage ",
        " dose "                    => " dosage ",
        " doss "                    => " berth ",
        " dossier "                 => " abstracts ",
        " dotard "                  => " aged ",
        " doting "                  => " adoring ",
        " dotterel "                => " brainless ",
        " dottiness "               => " absurdity ",
        " dotty "                   => " amorous ",
        " double "                  => " bifold ",
        " double-barreled "         => " bifold ",
        " double-checked "          => " accurate ",
        " double-cross "            => " bluff ",
        " double-crosser "          => " backstabber ",
        " double-crossing "         => " cheating ",
        " double-dealer "           => " bluff ",
        " double-dealing "          => " ambidextrous ",
        " double-dip "              => " bifold ",
        " double-edged "            => " acrid ",
        " double-take "             => " acknowledgment ",
        " double-talk "             => " amphibiology ",
        " double-whammy "           => " abracadabra ",
        " doubled "                 => " angled ",
        " doublespeak "             => " affect ",
        " doublet "                 => " brace ",
        " doubletalk "              => " absurd ",
        " doubling "                => " acceleration ",
        " doubt "                   => " agnosticism ",
        " doubtable "               => " arguable ",
        " doubter "                 => " agnostic ",
        " doubtful "                => " ambiguous ",
        " doubting "                => " carper ",
        " doubtless "               => " absolutely ",
        " doubtlessly "             => " absolutely ",
        " douche "                  => " ablution ",
        " dough "                   => " chef ",
        " doughboy "                => " chef ",
        " doughtiness "             => " boldness ",
        " doughty "                 => " adventurous ",
        " doughy "                  => " achromatic ",
        " dour "                    => " bleak ",
        " doused "                  => " abolished ",
        " dousing "                 => " ablution ",
        " dove "                    => " affable ",
        " dove-like "               => " affable ",
        " dovetail "                => " accord ",
        " dovetailing "             => " chain ",
        " dowdy "                   => " antiquated ",
        " dower "                   => " bequeathal ",
        " down "                    => " bottomward ",
        " down-and-out "            => " beggared ",
        " down-at-heel "            => " base ",
        " down-covered "            => " down-covered ",
        " down-hearted "            => " dejected ",
        " down-to-earth "           => " common ",
        " downbeat "                => " beat ",
        " downcastness "            => " anguish ",
        " downcry "                 => " abuse ",
        " downer "                  => " affliction ",
        " downfall "                => " atrophy ",
        " downgrade "               => " decline ",
        " downgrading "             => " abasement ",
        " downhearted "             => " blue ",
        " downheartedness "         => " depression ",
        " downhill "                => " decline ",
        " downpour "                => " cloudburst ",
        " downreaching "            => " abysmal ",
        " downright "               => " absolute ",
        " downrush "                => " avalanche ",
        " downside-up "             => " chaotic ",
        " downsize "                => " abbreviate ",
        " downslide "               => " declivity ",
        " downstairs "              => " bench ",
        " downstream "              => " after ",
        " downswing "               => " declivity ",
        " downtime "                => " blow ",
        " downtown "                => " city ",
        " downtrend "               => " declivity ",
        " downtrodden "             => " abject ",
        " downturn "                => " abatement ",
        " downward "                => " bottomward ",
        " downy "                   => " featherlike ",
        " dowry "                   => " affairs ",
        " doxologize "              => " carol ",
        " doxy "                    => " canon ",
        " doyen "                   => " administrator ",
        " doze "                    => " catnap ",
        " dozing "                  => " comatose ",
        " dozy "                    => " comatose ",
        " drab "                    => " arid ",
        " drabness "                => " banality ",
        " draconian "               => " callous ",
        " draft "                   => " abstract ",
        " draftsman "               => " artist ",
        " drafty "                  => " aerial ",
        " drag "                    => " annoyance ",
        " dragged "                 => " abject ",
        " dragger "                 => " baiter ",
        " dragging "                => " boring ",
        " draggle "                 => " begrime ",
        " draggy "                  => " blah ",
        " dragoon "                 => " badger ",
        " dragoons "                => " army ",
        " dragway "                 => " alley ",
        " drain "                   => " cesspool ",
        " drainage "                => " arising ",
        " draining "                => " clarification ",
        " dram "                    => " atom ",
        " drama "                   => " ball ",
        " dramatic "                => " affecting ",
        " dramatically "            => " badly ",
        " dramatics "               => " assuming ",
        " dramatist "               => " author ",
        " dramatizing "             => " assuming ",
        " dramaturge "              => " author ",
        " dramaturgic "             => " affected ",
        " dramaturgist "            => " author ",
        " drape "                   => " array ",
        " drapery "                 => " accoutrement ",
        " drapes "                  => " apparel ",
        " drastic "                 => " desperate ",
        " drastically "             => " acutely ",
        " drat "                    => " abuse ",
        " dratted "                 => " abhorrent ",
        " draught "                 => " beaker ",
        " drawback "                => " check ",
        " drawing "                 => " cartoon ",
        " drawings "                => " assets ",
        " drawl "                   => " chant ",
        " drawn "                   => " fatigued ",
        " drawn-out "               => " boring ",
        " dray "                    => " barrow ",
        " dread "                   => " alarming ",
        " dreaded "                 => " alarming ",
        " dreadful "                => " abominable ",
        " dreadfully "              => " clumsily ",
        " dreading "                => " afraid ",
        " dreamboat "               => " attractive ",
        " dreaming "                => " absent ",
        " dreamland "               => " comatose ",
        " dreamlike "               => " abstracted ",
        " dreamy "                  => " abstracted ",
        " drear "                   => " black ",
        " dreariness "              => " abasement ",
        " drearisome "              => " austere ",
        " dreary "                  => " black ",
        " dreck "                   => " clay ",
        " drecky "                  => " base ",
        " dredge "                  => " absterge ",
        " dreggy "                  => " bedraggled ",
        " drench "                  => " deluge ",
        " drenched "                => " decrepit ",
        " drenching "               => " bath ",
        " dress-down "              => " dress-down ",
        " dresser "                 => " chiffonier ",
        " dressing "                => " bathrobe ",
        " dressing-down "           => " castigation ",
        " dressmaker "              => " clothier ",
        " dressmaking "             => " dressmaking ",
        " dressy "                  => " chic ",
        " dribble "                 => " distill ",
        " driblet "                 => " bean ",
        " dried "                   => " broiled ",
        " dried-out "               => " aged ",
        " drift "                   => " alluvion ",
        " drifting "                => " afloat ",
        " driftless "               => " accidental ",
        " drill "                   => " assignment ",
        " drilled "                 => " accomplished ",
        " drilling "                => " conduct ",
        " drillmaster "             => " drillmaster ",
        " drink "                   => " alcohol ",
        " drinkable "               => " cooler ",
        " drinkery "                => " alehouse ",
        " drinking "                => " bubbler ",
        " drip "                    => " dribble ",
        " dripping "                => " decrepit ",
        " drippy "                  => " blah ",
        " driveling "               => " abused ",
        " driven "                  => " apprenticed ",
        " driver "                  => " disciplinarian ",
        " driving "                 => " active ",
        " drizzle "                 => " dribble ",
        " drizzling "               => " aqueous ",
        " drizzly "                 => " close ",
        " drogher "                 => " agent ",
        " droid "                   => " adherent ",
        " droit "                   => " advantage ",
        " droll "                   => " absurd ",
        " drollery "                => " ball ",
        " drollness "               => " ball ",
        " drone "                   => " bombinate ",
        " droning "                 => " dawdling ",
        " drony "                   => " blah ",
        " drool "                   => " dribble ",
        " drooly "                  => " alluring ",
        " droop "                   => " bend ",
        " drooping "                => " angled ",
        " droopy "                  => " bent ",
        " drop "                    => " bead ",
        " drop-dead "               => " adorable ",
        " drop-off "                => " declivity ",
        " droplet "                 => " atom ",
        " droplets "                => " aerosol ",
        " dropped "                 => " alone ",
        " dropping "                => " bottomward ",
        " droppings "               => " debris ",
        " dropsical "               => " aggrandized ",
        " dross "                   => " bits ",
        " drought "                 => " aridity ",
        " droughty "                => " anhydrous ",
        " drove "                   => " collection ",
        " drown "                   => " asphyxiate ",
        " drowse "                  => " catnap ",
        " drowsiness "              => " blackout ",
        " drowsy "                  => " comatose ",
        " drub "                    => " batter ",
        " drubbing "                => " beating ",
        " drudge "                  => " crammer ",
        " drudgery "                => " backbreaker ",
        " drudging "                => " arid ",
        " drug "                    => " biologic ",
        " drugged "                 => " benumbed ",
        " druggie "                 => " addict ",
        " drugstore "               => " angishore ",
        " druid "                   => " astrologer ",
        " drum "                    => " boom ",
        " drumfire "                => " bang ",
        " drummer "                 => " bagman ",
        " drumming "                => " boot ",
        " drung "                   => " access ",
        " drunk "                   => " bashed ",
        " drunkard "                => " alcoholic ",
        " drunken "                 => " bashed ",
        " drunkenness "             => " abandonment ",
        " drupe "                   => " drupe ",
        " drupelet "                => " drupe ",
        " druthers "                => " affection ",
        " dry-rot "                 => " atrophy ",
        " dryad "                   => " damsel ",
        " drying "                  => " dehydration ",
        " dryness "                 => " boredom ",
        " dual "                    => " bifold ",
        " dualistic "               => " bifold ",
        " dualize "                 => " augment ",
        " dubiosity "               => " apprehension ",
        " dubious "                 => " arguable ",
        " dubitable "               => " ambiguous ",
        " ducat "                   => " accreditation ",
        " duce "                    => " autocrat ",
        " duchess "                 => " amazon ",
        " duck "                    => " avoid ",
        " ducking "                 => " bath ",
        " ducky "                   => " adequate ",
        " duct "                    => " aqueduct ",
        " ductile "                 => " adaptable ",
        " ductus "                  => " autography ",
        " dudes "                   => " bodies ",
        " dudgeon "                 => " anger ",
        " duds "                    => " accoutrement ",
        " duel "                    => " bound ",
        " duenna "                  => " babysitter ",
        " dues "                    => " ante ",
        " duet "                    => " affiliation ",
        " duffel "                  => " attache ",
        " duffer "                  => " addle-brain ",
        " duke "                    => " battle ",
        " dulcet "                  => " adapted ",
        " dulcify "                 => " abate ",
        " dull "                    => " addled ",
        " dullard "                 => " dodo ",
        " dulled "                  => " blah ",
        " dulling "                 => " analgesic ",
        " dullness "                => " aloofness ",
        " dullsville "              => " boiler ",
        " duly "                    => " appropriately ",
        " dumb "                    => " impaired ",
        " dumbbell "                => " dodo ",
        " dumbfound "               => " amaze ",
        " dumbfounded "             => " agape ",
        " dumbfounding "            => " abashing ",
        " dumbfoundment "           => " amazement ",
        " dumbhead "                => " blockhead ",
        " dumbness "                => " benightedness ",
        " dumbo "                   => " dense ",
        " dumbstruck "              => " addled ",
        " dumdum "                  => " airhead ",
        " dumfound "                => " abort ",
        " dummy "                   => " copy ",
        " dumping "                 => " auctioning ",
        " dumps "                   => " depression ",
        " dumpy "                   => " beefy ",
        " dungeon "                 => " alcove ",
        " dungy "                   => " bedraggled ",
        " dunk "                    => " douse ",
        " dunking "                 => " ablution ",
        " duodenal "                => " belly ",
        " duologue "                => " chat ",
        " dupable "                 => " accepting ",
        " dupe "                    => " butt ",
        " duped "                   => " bamboozled ",
        " dupery "                  => " artifice ",
        " duping "                  => " artifice ",
        " duple "                   => " bifold ",
        " duplex "                  => " bifold ",
        " duplicate "               => " alike ",
        " duplicated "              => " bifold ",
        " duplicating "             => " accompanying ",
        " duplicitous "             => " adroit ",
        " duplify "                 => " augment ",
        " durability "              => " backbone ",
        " durable "                 => " abiding ",
        " durableness "             => " backbone ",
        " durably "                 => " durably ",
        " durance "                 => " bondage ",
        " duration "                => " continuance ",
        " duress "                  => " bondage ",
        " dusk "                    => " dark ",
        " duskiness "               => " caliginosity ",
        " duskish "                 => " aphotic ",
        " dusky "                   => " adusk ",
        " dust-off "                => " annihilation ",
        " dust-up "                 => " altercation ",
        " dustbin "                 => " dustbin ",
        " duster "                  => " besom ",
        " dusting "                 => " blanket ",
        " dustup "                  => " altercation ",
        " dusty "                   => " arenaceous ",
        " duteous "                 => " civil ",
        " duteously "               => " accurately ",
        " duteousness "             => " accordance ",
        " dutiful "                 => " binding ",
        " dutifully "               => " accurately ",
        " dutifulness "             => " accordance ",
        " duty "                    => " assignment ",
        " duty-bound "              => " apprenticed ",
        " duvet "                   => " bedding ",
        " dwall "                   => " catnap ",
        " dwarfed "                 => " askew ",
        " dwell "                   => " abide ",
        " dweller "                 => " aborigine ",
        " dwellers "                => " citizenry ",
        " dwelling "                => " abode ",
        " dwindle "                 => " abate ",
        " dwindling "               => " abbreviating ",
        " dyad "                    => " brace ",
        " dyed "                    => " absolute ",
        " dyed-in-the-wool "        => " absolute ",
        " dyestuff "                => " color ",
        " dynamic "                 => " activating ",
        " dynamism "                => " action ",
        " dynamite "                => " bang ",
        " dynamize "                => " amaze ",
        " dynamo "                  => " agent ",
        " dynasty "                 => " absolutism ",
        " dysfunctional "           => " abortive ",
        " dyslogistic "             => " adverse ",
        " dyspeptic "               => " bitchy ",
        " dysphoria "               => " anguish ",
        " e-banking "               => " cyberbanking ",
        " each "                    => " anniversary ",
        " eager "                   => " acquisitive ",
        " eagerly "                 => " agilely ",
        " eagerness "               => " alacrity ",
        " eagle "                   => " hawkeye ",
        " eagle-eye "               => " beam ",
        " eagle-eyed "              => " advertent ",
        " ear-popping "             => " blatant ",
        " ear-splitting "           => " boisterous ",
        " earful "                  => " account ",
        " earl "                    => " aristocrat ",
        " earless "                 => " deafened ",
        " earlier "                 => " beforehand ",
        " earliest "                => " ancient ",
        " earliness "               => " antecedence ",
        " early "                   => " aboriginal ",
        " earmark "                 => " attribute ",
        " earmarked "               => " appropriate ",
        " earmarking "              => " allotment ",
        " earn "                    => " acquire ",
        " earned "                  => " becoming ",
        " earnest "                 => " ardent ",
        " earnestly "               => " agilely ",
        " earnestness "             => " absorption ",
        " earnings "                => " balance ",
        " earring "                 => " adornment ",
        " ears "                    => " aerial ",
        " earshot "                 => " aural ",
        " earsplitting "            => " acrid ",
        " earth "                   => " apple ",
        " earth-shaking "           => " all-important ",
        " earth-shattering "        => " all-important ",
        " earthbound "              => " earthbound ",
        " earthenware "             => " ceramics ",
        " earthiness "              => " bawdiness ",
        " earthlike "               => " earthbound ",
        " earthly "                 => " alluvial ",
        " earthly-minded "          => " acquisitive ",
        " earthquake "              => " convulsion ",
        " earthward "               => " bottomward ",
        " earthwork "               => " barricade ",
        " earthy "                  => " bawdy ",
        " ease "                    => " affluence ",
        " easeful "                 => " comfortable ",
        " easel "                   => " board ",
        " easement "                => " alleviation ",
        " easily "                  => " calmly ",
        " easiness "                => " affluence ",
        " easing "                  => " abatement ",
        " easy "                    => " accessible ",
        " easy-going "              => " adjustable ",
        " easy-moving "             => " active ",
        " easygoing "               => " amenable ",
        " easygoingness "           => " adroitness ",
        " eatable "                 => " comestible ",
        " eatables "                => " commons ",
        " eatery "                  => " beanery ",
        " eating "                  => " bistro ",
        " eaves "                   => " bump ",
        " eavesdropping "           => " eavesdropping ",
        " ebanking "                => " cyberbanking ",
        " ebbing "                  => " abatement ",
        " ebon "                    => " atramentous ",
        " ebonize "                 => " befoul ",
        " ebony "                   => " atramentous ",
        " ebullience "              => " agitation ",
        " ebullient "               => " agitated ",
        " ebullition "              => " bubbles ",
        " eccentric "               => " aberrant ",
        " eccentrically "           => " anyhow ",
        " eccentricity "            => " aberration ",
        " ecclesiast "              => " abbey ",
        " ecclesiastic "            => " abbey ",
        " echelon "                 => " degree ",
        " echinated "               => " annoying ",
        " echo "                    => " answer ",
        " echoic "                  => " artful ",
        " echoing "                 => " alveolate ",
        " echoism "                 => " adumbration ",
        " eclectic "                => " all-embracing ",
        " eclipse "                 => " concealment ",
        " ecliptic "                => " amphitheater ",
        " ecology "                 => " anatomy ",
        " economic "                => " bread-and-butter ",
        " economy "                 => " abridgement ",
        " economy-size "            => " bargain ",
        " ecru "                    => " biscuit ",
        " ecstasize "               => " absorb ",
        " ecstasy "                 => " beatitude ",
        " ecstatic "                => " athrill ",
        " ecstatically "            => " acquiescently ",
        " ectoderm "                => " covering ",
        " ectoplasm "               => " corpuscle ",
        " ectype "                  => " archetype ",
        " ecumenical "              => " all-comprehensive ",
        " edacious "                => " acquisitive ",
        " edacity "                 => " acquisitiveness ",
        " eddy "                    => " boil ",
        " edge "                    => " bend ",
        " edged "                   => " belted ",
        " edgeless "                => " edgeless ",
        " edger "                   => " edger ",
        " edgeways "                => " crabbed ",
        " edginess "                => " agitation ",
        " edging "                  => " binding ",
        " edgy "                    => " anxious ",
        " edible "                  => " comestible ",
        " edibles "                 => " aliment ",
        " edification "             => " betterment ",
        " edifice "                 => " building ",
        " edify "                   => " abridge ",
        " edifying "                => " adorning ",
        " edit "                    => " adapt ",
        " editing "                 => " alteration ",
        " edition "                 => " copy ",
        " editorial "               => " beat ",
        " educate "                 => " brainwash ",
        " educated "                => " accomplished ",
        " education "               => " apprenticeship ",
        " educative "               => " adorning ",
        " educator "                => " drillmaster ",
        " edulcorate "              => " absterge ",
        " eerie "                   => " awesome ",
        " efface "                  => " abate ",
        " effect "                  => " aftereffect ",
        " effected "                => " accomplished ",
        " effecting "               => " ability ",
        " effective "               => " able ",
        " effectively "             => " finer ",
        " effectiveness "           => " capability ",
        " effects "                 => " furnishings ",
        " effectual "               => " accomplishing ",
        " effectually "             => " around ",
        " effectualness "           => " ability ",
        " effectuate "              => " accomplish ",
        " effectuated "             => " accomplished ",
        " effectuation "            => " accomplishment ",
        " effeminate "              => " chichi ",
        " effeminateness "          => " delicacy ",
        " effeminize "              => " alter ",
        " efferent "                => " deviating ",
        " effervesce "              => " bubble ",
        " effervescence "           => " bubbles ",
        " effervescent "            => " airy ",
        " effeteness "              => " debility ",
        " efficacious "             => " active ",
        " efficaciousness "         => " ability ",
        " efficacy "                => " ability ",
        " efficiency "              => " ability ",
        " efficient "               => " able ",
        " efficiently "             => " calmly ",
        " effigy "                  => " figure ",
        " efflorescence "           => " blossom ",
        " efflorescent "            => " appearing ",
        " effluence "               => " address ",
        " effluent "                => " arising ",
        " effluvious "              => " aromatic ",
        " effluvium "               => " address ",
        " efflux "                  => " address ",
        " effort "                  => " accomplishment ",
        " effortlessly "            => " calmly ",
        " effortlessness "          => " ability ",
        " effrontery "              => " arrogance ",
        " effulgence "              => " brightness ",
        " effulgent "               => " beaming ",
        " effuse "                  => " abate ",
        " effusion "                => " address ",
        " effusiveness "            => " agitation ",
        " egalitarian "             => " autonomous ",
        " egalitarianism "          => " capitalism ",
        " egest "                   => " defecate ",
        " egg-shaped "              => " egg-shaped ",
        " egghead "                 => " arbiter ",
        " egocentric "              => " egoistic ",
        " egocentricity "           => " arrogance ",
        " egoism "                  => " arrogance ",
        " egoist "                  => " carper ",
        " egoistic "                => " conceited ",
        " egoistical "              => " egoistic ",
        " egomania "                => " arrogance ",
        " egomaniacal "             => " egoistic ",
        " egotism "                 => " airs ",
        " egotistic "               => " affected ",
        " egotistical "             => " arrogant ",
        " egregious "               => " arrant ",
        " egress "                  => " departure ",
        " egression "               => " abandonment ",
        " eiderdown "               => " batt ",
        " eidolic "                 => " apparitional ",
        " eidolon "                 => " apparition ",
        " ejaculate "               => " accrue ",
        " ejaculation "             => " acclamation ",
        " ejaculatory "             => " articulate ",
        " eject "                   => " banish ",
        " ejection "                => " casting ",
        " elaborate "               => " busy ",
        " elaborated "              => " abundant ",
        " elaboration "             => " addition ",
        " elapse "                  => " expire ",
        " elapsed "                 => " delayed ",
        " elapsing "                => " duration ",
        " elastic "                 => " adaptable ",
        " elasticity "              => " animation ",
        " elate "                   => " animate ",
        " elated "                  => " animated ",
        " elation "                 => " bliss ",
        " elbow "                   => " bend ",
        " elbowroom "               => " admeasurement ",
        " elder "                   => " ancient ",
        " elderliness "             => " adolescence ",
        " elderly "                 => " aged ",
        " eldership "               => " advantage ",
        " eldest "                  => " earlier ",
        " elect "                   => " accept ",
        " elected "                 => " adopted ",
        " election "                => " acclamation ",
        " electioneer "             => " agitate ",
        " electioneering "          => " backroom ",
        " elective "                => " constituent ",
        " electoral "               => " balloter ",
        " electrify "               => " amaze ",
        " electrifying "            => " absorbing ",
        " electrocute "             => " assassinate ",
        " electrocution "           => " beheading ",
        " electrolier "             => " candelabrum ",
        " electrolyze "             => " anatomize ",
        " electronic "              => " cyberbanking ",
        " eleemosynary "            => " accommodating ",
        " elegance "                => " breeding ",
        " elegant "                 => " affected ",
        " elegantly "               => " alluringly ",
        " elegiac "                 => " black ",
        " elegy "                   => " chant ",
        " element "                 => " aspect ",
        " elemental "               => " basal ",
        " elementariness "          => " artlessness ",
        " elephant "                => " albatross ",
        " elevate "                 => " drag ",
        " elevated "                => " animated ",
        " elevating "               => " adorning ",
        " elevation "               => " acclivity ",
        " elfin "                   => " brownie ",
        " elicit "                  => " arm-twist ",
        " elicitation "             => " abstract ",
        " eligibility "             => " accommodation ",
        " eligible "                => " acceptable ",
        " eliminate "               => " annihilate ",
        " eliminated "              => " alone ",
        " elimination "             => " abolishment ",
        " eliminator "              => " apache ",
        " elision "                 => " abbreviating ",
        " elite "                   => " aristocratic ",
        " elixir "                  => " borsch ",
        " ellipse "                 => " ambit ",
        " ellipsis "                => " adumbration ",
        " ellipsoidal "             => " egg-shaped ",
        " elliptic "                => " egg-shaped ",
        " elliptical "              => " egg-shaped ",
        " elocution "               => " declamation ",
        " elongated "               => " continued ",
        " elongation "              => " addendum ",
        " eloquence "               => " ability ",
        " eloquent "                => " affecting ",
        " else "                    => " abroad ",
        " elseways "                => " contrarily ",
        " elsewhere "               => " abroad ",
        " elucidate "               => " annotate ",
        " elucidation "             => " comment ",
        " elucidative "             => " critical ",
        " elucidatory "             => " allegorical ",
        " elude "                   => " baffle ",
        " eluding "                 => " abstract ",
        " elusion "                 => " abstention ",
        " elusive "                 => " ambiguous ",
        " elusory "                 => " ambiguous ",
        " elutriate "               => " absterge ",
        " elvish "                  => " casual ",
        " elysian "                 => " angelic ",
        " emaciated "               => " atrophied ",
        " emanant "                 => " appearing ",
        " emanate "                 => " arise ",
        " emanating "               => " appearing ",
        " emanation "               => " arising ",
        " emancipate "              => " affranchise ",
        " emancipation "            => " capitalism ",
        " emasculate "              => " alter ",
        " emasculated "             => " aged ",
        " embalm "                  => " anoint ",
        " embankment "              => " beach ",
        " embark "                  => " commence ",
        " embarkation "             => " abandonment ",
        " embarked "                => " boarded ",
        " embarkment "              => " berth ",
        " embarrass "               => " abash ",
        " embarrassed "             => " ashamed ",
        " embarrassing "            => " awkward ",
        " embassy "                 => " admiral ",
        " embattled "               => " active ",
        " embattlement "            => " barricade ",
        " embed "                   => " bury ",
        " embedded "                => " anchored ",
        " embellish "               => " adorn ",
        " embellished "             => " bizarre ",
        " embellishing "            => " adorning ",
        " embellishment "           => " adornment ",
        " embers "                  => " charcoal ",
        " embezzle "                => " abstract ",
        " embezzlement "            => " abstraction ",
        " embezzler "               => " bandit ",
        " embitter "                => " acerbate ",
        " embittered "              => " acrimonious ",
        " embittering "             => " arduous ",
        " emblaze "                 => " adorn ",
        " emblazon "                => " adorn ",
        " emblazonry "              => " blazonry ",
        " emblem "                  => " adumbration ",
        " emblematic "              => " emblematic ",
        " emblematical "            => " allegorical ",
        " emblematize "             => " actualize ",
        " embodied "                => " embodied ",
        " embodiment "              => " apotheosis ",
        " embody "                  => " actualize ",
        " embolden "                => " activate ",
        " embolism "                => " array ",
        " embolus "                 => " barricade ",
        " embossed "                => " arresting ",
        " embouchement "            => " aperture ",
        " embowed "                 => " arced ",
        " embraceable "             => " caressible ",
        " embraced "                => " accepted ",
        " embracement "             => " acceptance ",
        " embracing "               => " all-embracing ",
        " embracive "               => " all-embracing ",
        " embrasure "               => " cavity ",
        " embrocate "               => " bless ",
        " embrocation "             => " analgesic ",
        " embroider "               => " beautify ",
        " embroidered "             => " abstract ",
        " embroidering "            => " adornment ",
        " embroidery "              => " adornment ",
        " embroiled "               => " affected ",
        " embroiling "              => " abashing ",
        " embroilment "             => " argument ",
        " embryo "                  => " antecedent ",
        " embryology "              => " analysis ",
        " embryonic "               => " beginning ",
        " emend "                   => " alter ",
        " emendate "                => " alter ",
        " emendation "              => " alteration ",
        " emerge "                  => " appear ",
        " emergence "               => " actualization ",
        " emergent "                => " appearing ",
        " emerging "                => " arising ",
        " emigrant "                => " alien ",
        " emigrate "                => " immigrate ",
        " emigrating "              => " casual ",
        " emigration "              => " abandonment ",
        " eminence "                => " authority ",
        " eminency "                => " ability ",
        " eminently "               => " conspicuously ",
        " emir "                    => " absolutist ",
        " emissary "                => " agent ",
        " emission "                => " discharge ",
        " emit "                    => " afford ",
        " emitting "                => " abounding ",
        " emollient "               => " analgesic ",
        " emolument "               => " balance ",
        " emoluments "              => " allowance ",
        " emotion "                 => " affect ",
        " emotionable "             => " acute ",
        " emotional "               => " affecting ",
        " emotionalism "            => " affect ",
        " emotionless "             => " blank ",
        " emotionlessness "         => " aloofness ",
        " emotions "                => " affections ",
        " emotive "                 => " affecting ",
        " empathetic "              => " compassionate ",
        " empathic "                => " accordant ",
        " empathy "                 => " affinity ",
        " empennage "               => " appendage ",
        " emphasis "                => " accent ",
        " emphasize "               => " accent ",
        " emphatic "                => " absolute ",
        " emphatically "            => " absolutely ",
        " emphysematous "           => " asthmatic ",
        " empire "                  => " authority ",
        " empiric "                 => " empiric ",
        " empirical "               => " empiric ",
        " empiricism "              => " analysis ",
        " employ "                  => " apply ",
        " employable "              => " attainable ",
        " employed "                => " active ",
        " employee "                => " agent ",
        " employees "               => " advisers ",
        " employers "               => " administration ",
        " employment "              => " application ",
        " emporium "                => " bazaar ",
        " empowering "              => " allotment ",
        " emprise "                 => " chance ",
        " emptiness "               => " blank ",
        " empty "                   => " abandoned ",
        " empty-headed "            => " brainless ",
        " empty-headedness "        => " benightedness ",
        " emptying "                => " elimination ",
        " empyreal "                => " angelic ",
        " empyrean "                => " angelic ",
        " emulate "                 => " challenge ",
        " emulating "               => " battling ",
        " emulation "               => " appetite ",
        " emulative "               => " artful ",
        " emulator "                => " adversary ",
        " emulous "                 => " aggressive ",
        " emulsified "              => " blurred ",
        " emulsion "                => " chrism ",
        " enable "                  => " accredit ",
        " enact "                   => " achieve ",
        " enacted "                 => " allowable ",
        " enacting "                => " assuming ",
        " enactment "               => " achievement ",
        " enamel "                  => " apply ",
        " enamor "                  => " attract ",
        " enamored "                => " amorous ",
        " enamoring "               => " absorbing ",
        " enamour "                 => " allure ",
        " enamoured "               => " ardent ",
        " encampment "              => " billet ",
        " encapsulate "             => " abbreviate ",
        " encarmine "               => " bloody ",
        " encase "                  => " adhere ",
        " enceinte "                => " alert ",
        " enchain "                 => " adhere ",
        " enchant "                 => " allure ",
        " enchanted "               => " bugged ",
        " enchantedly "             => " acquiescently ",
        " enchanter "               => " archimage ",
        " enchanting "              => " alluring ",
        " enchantment "             => " attraction ",
        " enchase "                 => " bite ",
        " enchasing "               => " block ",
        " encircle "                => " band ",
        " encircled "               => " belted ",
        " encirclement "            => " barricade ",
        " enclave "                 => " ascendancy ",
        " enclosed "                => " amid ",
        " enclosing "               => " anchor ",
        " enclosure "               => " asylum ",
        " encomiastic "             => " adulatory ",
        " encomiastical "           => " adulatory ",
        " encomium "                => " bidding ",
        " encompass "               => " beset ",
        " encompassed "             => " amid ",
        " encompassment "           => " accomplishment ",
        " encore "                  => " acclamation ",
        " encounter "               => " appointment ",
        " encourage "               => " animate ",
        " encouragement "           => " advance ",
        " encourager "              => " administrator ",
        " encouraging "             => " auspicious ",
        " encroach "                => " appropriate ",
        " encroaching "             => " advancing ",
        " encroachment "            => " assailment ",
        " encrust "                 => " begrime ",
        " encrustation "            => " blanket ",
        " encumber "                => " block ",
        " encumbered "              => " burdened ",
        " encumbering "             => " busy ",
        " encumbrance "             => " barricade ",
        " encyclopedia "            => " album ",
        " encyclopedic "            => " all-embracing ",
        " endangerment "            => " chance ",
        " endear "                  => " attach ",
        " endeared "                => " admired ",
        " endearing "               => " alluring ",
        " endearment "              => " amore ",
        " endeavoring "             => " ambitious ",
        " ended "                   => " concluded ",
        " endemic "                 => " ancient ",
        " ending "                  => " catastrophe ",
        " endless "                 => " amaranthine ",
        " endlessness "             => " aeon ",
        " endmost "                 => " closing ",
        " endogenous "              => " autogenous ",
        " endorsed "                => " accustomed ",
        " endorser "                => " advocate ",
        " endorsing "               => " acknowledging ",
        " endow "                   => " accord ",
        " endowed "                 => " able ",
        " endowing "                => " allotment ",
        " endowment "               => " award ",
        " endue "                   => " accouter ",
        " endurable "               => " bearable ",
        " endurance "               => " ability ",
        " endure "                  => " abide ",
        " enduring "                => " constant ",
        " enduringly "              => " assuredly ",
        " enema "                   => " bang ",
        " enemy "                   => " adversary ",
        " energetic "               => " active ",
        " energetically "           => " agilely ",
        " energize "                => " animate ",
        " energized "               => " activated ",
        " energizer "               => " analeptic ",
        " energizing "              => " animating ",
        " energy "                  => " activity ",
        " energy-consuming "        => " arduous ",
        " energy-giving "           => " advantageous ",
        " energyless "              => " abstracted ",
        " enervate "                => " bush ",
        " enervated "               => " debilitated ",
        " enervating "              => " demanding ",
        " enervation "              => " decrepitude ",
        " enervative "              => " annoying ",
        " enfeeble "                => " attenuate ",
        " enfeeblement "            => " decrepitude ",
        " enfetter "                => " adhere ",
        " enfilade "                => " battery ",
        " enforce "                 => " accomplish ",
        " enforceable "             => " acknowledged ",
        " enforced "                => " activated ",
        " enforcement "             => " administration ",
        " enforcer "                => " apache ",
        " enforcing "               => " administration ",
        " enfranchise "             => " affranchise ",
        " enfranchisement "         => " abolition ",
        " engage "                  => " appoint ",
        " engaged "                 => " affianced ",
        " engagement "              => " assurance ",
        " engaging "                => " agreeable ",
        " engagingness "            => " allure ",
        " engender "                => " arouse ",
        " engendering "             => " alpha ",
        " engenderment "            => " bearing ",
        " engild "                  => " adorn ",
        " engine "                  => " agent ",
        " engineer "                => " architect ",
        " englut "                  => " consume ",
        " engraft "                 => " brainwash ",
        " engrave "                 => " bite ",
        " engraving "               => " block ",
        " engross "                 => " absorb ",
        " engrossed "               => " absorbed ",
        " engrossing "              => " absorbing ",
        " engrossment "             => " captivation ",
        " engulf "                  => " absorb ",
        " enhanced "                => " added ",
        " enhancement "             => " accessory ",
        " enhancing "               => " acceptable ",
        " enhearten "               => " animate ",
        " enigma "                  => " bewilderment ",
        " enigmatic "               => " ambiguous ",
        " enigmatical "             => " cryptic ",
        " enisle "                  => " cloister ",
        " enjoin "                  => " adjure ",
        " enjoinder "               => " affront ",
        " enjoined "                => " allowable ",
        " enjoinment "              => " abnegation ",
        " enjoy "                   => " adore ",
        " enjoyable "               => " agreeable ",
        " enjoyableness "           => " affability ",
        " enjoying "                => " adequate ",
        " enjoyment "               => " amusement ",
        " enkindle "                => " bake ",
        " enkindled "               => " afire ",
        " enkindling "              => " awakening ",
        " enlarged "                => " continued ",
        " enlargement "             => " amplification ",
        " enlarging "               => " accretion ",
        " enlighten "               => " acquaint ",
        " enlightened "             => " aware ",
        " enlightening "            => " candid ",
        " enlightenment "           => " broad-mindedness ",
        " enlist "                  => " admit ",
        " enlistment "              => " application ",
        " enliven "                 => " animate ",
        " enlivened "               => " aggressive ",
        " enlivening "              => " activation ",
        " enmeshed "                => " affected ",
        " enmeshment "              => " affair ",
        " enmity "                  => " acrimony ",
        " ennoble "                 => " acclaim ",
        " ennoblement "             => " advance ",
        " ennobling "               => " adorning ",
        " ennui "                   => " apathy ",
        " enormity "                => " abomination ",
        " enormous "                => " astronomic ",
        " enormously "              => " awfully ",
        " enormousness "            => " bigness ",
        " enough "                  => " abundant ",
        " enounce "                 => " advance ",
        " enraged "                 => " affronted ",
        " enrapt "                  => " alert ",
        " enrapture "               => " allure ",
        " enraptured "              => " bugged ",
        " enrich "                  => " adorn ",
        " enriched "                => " accomplished ",
        " enriching "               => " adorning ",
        " enrichment "              => " accessory ",
        " enring "                  => " band ",
        " enroll "                  => " accept ",
        " enrollment "              => " acceptance ",
        " enroot "                  => " advance ",
        " ensample "                => " archetype ",
        " ensanguined "             => " blood-soaked ",
        " ensconce "                => " bury ",
        " ensembles "               => " apparel ",
        " ensepulcher "             => " coffin ",
        " enshrine "                => " apotheosize ",
        " enshrined "               => " anointed ",
        " enshrinement "            => " altar ",
        " enshrining "              => " canonizing ",
        " enshroud "                => " cache ",
        " enshrouded "              => " buried ",
        " ensign "                  => " blazonry ",
        " enslave "                 => " bind ",
        " enslaved "                => " apprenticed ",
        " ensnared "                => " bound ",
        " ensnarement "             => " allurement ",
        " ensnaring "               => " abduction ",
        " ensorcell "               => " allure ",
        " ensorcelled "             => " bugged ",
        " ensphere "                => " belt ",
        " ensue "                   => " appear ",
        " ensuing "                 => " after ",
        " ensuingly "               => " after ",
        " enswathe "                => " array ",
        " entailed "                => " basic ",
        " entangled "               => " circuitous ",
        " entanglement "            => " affair ",
        " entente "                 => " alliance ",
        " enter "                   => " access ",
        " enterable "               => " absorbent ",
        " enterprise "              => " action ",
        " enterprising "            => " active ",
        " entertain "               => " absorb ",
        " entertainer "             => " amateur ",
        " entertaining "            => " absorbing ",
        " entertainment "           => " ball ",
        " enthrall "                => " absorb ",
        " enthralled "              => " alert ",
        " enthralling "             => " arresting ",
        " enthrallment "            => " captivation ",
        " enthrone "                => " adorn ",
        " enthroned "               => " adored ",
        " enthusiasm "              => " activity ",
        " enthusiastic "            => " agog ",
        " enthusiastically "        => " agilely ",
        " entice "                  => " attract ",
        " enticed "                 => " absorbed ",
        " enticement "              => " attraction ",
        " enticer "                 => " bluff ",
        " enticing "                => " adorable ",
        " entify "                  => " actualize ",
        " entire "                  => " absolute ",
        " entirely "                => " absolutely ",
        " entireness "              => " absoluteness ",
        " entirety "                => " absoluteness ",
        " entitle "                 => " baptize ",
        " entitled "                => " advantaged ",
        " entitlement "             => " alms ",
        " entity "                  => " article ",
        " entomb "                  => " coffin ",
        " entombment "              => " bondage ",
        " entourage "               => " associates ",
        " entrada "                 => " campaign ",
        " entrails "                => " belly ",
        " entrance "                => " access ",
        " entranced "               => " absorption ",
        " entranceway "             => " aisle ",
        " entrancing "              => " adorable ",
        " entrancingly "            => " alluringly ",
        " entrant "                 => " aspirant ",
        " entrap "                  => " allure ",
        " entrapment "              => " affair ",
        " entrapping "              => " ambidexterity ",
        " entreating "              => " affecting ",
        " entreatment "             => " appeal ",
        " entreaty "                => " appeal ",
        " entree "                  => " access ",
        " entrench "                => " anchor ",
        " entrenched "              => " accepted ",
        " entrenchment "            => " barricade ",
        " entrepreneur "            => " administrator ",
        " entrepreneurial "         => " ambitious ",
        " entropy "                 => " anarchy ",
        " entrust "                 => " allocate ",
        " entrustment "             => " appointment ",
        " entry "                   => " access ",
        " entryway "                => " aperture ",
        " entwine "                 => " braid ",
        " enucleate "               => " annotate ",
        " enucleation "             => " account ",
        " enumerated "              => " abundant ",
        " enumeration "             => " archive ",
        " enunciate "               => " advance ",
        " enunciated "              => " audible ",
        " enunciation "             => " accentuation ",
        " envelop "                 => " blanket ",
        " enveloped "               => " belted ",
        " envenom "                 => " animalize ",
        " envious "                 => " appetent ",
        " enviousness "             => " backbiting ",
        " environ "                 => " aggress ",
        " environment "             => " ambiance ",
        " environmental "           => " ecology ",
        " environmentology "        => " ecology ",
        " environs "                => " bound ",
        " envisage "                => " brainstorm ",
        " envision "                => " anticipate ",
        " envoy "                   => " agent ",
        " envy "                    => " backbiting ",
        " envying "                 => " abominable ",
        " enwrap "                  => " accouter ",
        " enzyme "                  => " agitator ",
        " eolith "                  => " deposit ",
        " epee "                    => " brand ",
        " ephemeral "               => " brief ",
        " ephemerality "            => " conciseness ",
        " epic "                    => " ballsy ",
        " epical "                  => " anapestic ",
        " epicarp "                 => " bark ",
        " epicene "                 => " chichi ",
        " epicurean "               => " gluttonous ",
        " epidemic "                => " catching ",
        " epidermis "               => " covering ",
        " epigastrium "             => " abdomen ",
        " epigram "                 => " aphorism ",
        " epilepsy "                => " attack ",
        " epilogue "                => " coda ",
        " episcopal "               => " apostolic ",
        " episode "                 => " adventure ",
        " episodic "                => " anecdotal ",
        " epistler "                => " contributor ",
        " epistolarian "            => " contributor ",
        " epithalamic "             => " conjugal ",
        " epithet "                 => " appellation ",
        " epitome "                 => " apotheosis ",
        " epitomize "               => " abridge ",
        " epitomized "              => " abridged ",
        " epizootic "               => " communicable ",
        " epoch "                   => " aeon ",
        " epochal "                 => " alternate ",
        " epodic "                  => " anapestic ",
        " epoxy "                   => " adhesive ",
        " equability "              => " aplomb ",
        " equable "                 => " agreeable ",
        " equal "                   => " according ",
        " equal-sided "             => " boxlike ",
        " equalitarianism "         => " capitalism ",
        " equality "                => " adequation ",
        " equalize "                => " adjust ",
        " equalized "               => " alike ",
        " equalizer "               => " blaster ",
        " equally "                 => " appropriately ",
        " equanimity "              => " aplomb ",
        " equanimous "              => " composed ",
        " equatability "            => " adequation ",
        " equate "                  => " agree ",
        " equation "                => " blueprint ",
        " equator "                 => " equator ",
        " equatorial "              => " close ",
        " equerry "                 => " equerry ",
        " equidistance "            => " axis ",
        " equidistant "             => " centermost ",
        " equilateral "             => " boxlike ",
        " equilibrium "             => " calm ",
        " equinoctial "             => " equator ",
        " equip "                   => " accouter ",
        " equipage "                => " accoutrement ",
        " equipment "               => " accessories ",
        " equipoise "               => " agree ",
        " equipollent "             => " commensurable ",
        " equiponderate "           => " agree ",
        " equipotential "           => " commensurable ",
        " equipped "                => " able ",
        " equipping "               => " accouterment ",
        " equitable "               => " candid ",
        " equitableness "           => " charity ",
        " equitably "               => " deservedly ",
        " equity "                  => " disinterestedness ",
        " equivalence "             => " adequation ",
        " equivalency "             => " adequation ",
        " equivalent "              => " agnate ",
        " equivalently "            => " analogously ",
        " equivocal "               => " ambiguous ",
        " equivocating "            => " artifice ",
        " equivocation "            => " ambiguity ",
        " equivocator "             => " cheat ",
        " equivoque "               => " ambiguity ",
        " eradication "             => " abolishment ",
        " eradicative "             => " annihilative ",
        " erase "                   => " abolish ",
        " erased "                  => " asleep ",
        " erasing "                 => " abatement ",
        " erasure "                 => " abandoning ",
        " erect "                   => " arrect ",
        " erectile "                => " arrect ",
        " erecting "                => " architecture ",
        " erection "                => " adjustment ",
        " erector "                 => " architect ",
        " eremite "                 => " anchoress ",
        " eremitic "                => " alienated ",
        " erewhile "                => " aforetime ",
        " ergo "                    => " appropriately ",
        " eristic "                 => " bellicose ",
        " erode "                   => " abrade ",
        " eroded "                  => " breakable ",
        " eroding "                 => " acerbic ",
        " erogenous "               => " amative ",
        " erosion "                 => " abrasion ",
        " erosive "                 => " cutting ",
        " erotic "                  => " amative ",
        " eroticism "               => " aphrodisia ",
        " errable "                 => " aberrant ",
        " errand "                  => " assignment ",
        " errant "                  => " aberrant ",
        " erratic "                 => " aberrant ",
        " erratically "             => " accidental ",
        " erratum "                 => " absurdity ",
        " erring "                  => " awry ",
        " erringly "                => " afield ",
        " erroneously "             => " afield ",
        " erroneousness "           => " aberration ",
        " error "                   => " absurdity ",
        " errorless "               => " absolute ",
        " ersatz "                  => " bogus ",
        " erstwhile "               => " bygone ",
        " erubescent "              => " blooming ",
        " eruct "                   => " discharge ",
        " eructate "                => " discharge ",
        " erudite "                 => " brainy ",
        " erudition "               => " bookishness ",
        " erupt "                   => " appear ",
        " eruption "                => " access ",
        " eruptive "                => " atomic ",
        " erythrocyte "             => " corpuscle ",
        " escalade "                => " ascend ",
        " escalate "                => " amplify ",
        " escalating "              => " ascent ",
        " escalation "              => " accretion ",
        " escallop "                => " bake ",
        " escamotage "              => " conjuration ",
        " escapade "                => " antic ",
        " escaped "                 => " able ",
        " escapement "              => " beat ",
        " escaping "                => " artifice ",
        " escapism "                => " abstention ",
        " escarpment "              => " bank ",
        " eschew "                  => " abandon ",
        " eschewal "                => " abandonment ",
        " eschewing "               => " abandonment ",
        " escorting "               => " convoying ",
        " escritoire "              => " chiffonier ",
        " esculent "                => " comestible ",
        " escutcheon "              => " blazonry ",
        " esker "                   => " acropolis ",
        " esophoric "               => " absurd ",
        " esoteric "                => " abstruse ",
        " especial "                => " chief ",
        " especially "              => " abnormally ",
        " espial "                  => " apprehension ",
        " esplanade "               => " esplanade ",
        " espousal "                => " acceptance ",
        " espouse "                 => " accept ",
        " espoused "                => " consort ",
        " esprit "                  => " camaraderie ",
        " espy "                    => " ascertain ",
        " essay "                   => " article ",
        " essayist "                => " columnist ",
        " essence "                 => " aspect ",
        " essentia "                => " character ",
        " essential "               => " capital ",
        " essentiality "            => " character ",
        " essentially "             => " about ",
        " establish "               => " authorize ",
        " establishable "           => " absolute ",
        " established "             => " accustomed ",
        " establisher "             => " architect ",
        " establishment "           => " enactment ",
        " estate "                  => " acreage ",
        " esteem "                  => " admire ",
        " esteemed "                => " admired ",
        " esthetic "                => " artful ",
        " estimable "               => " admirable ",
        " estimate "                => " appraisal ",
        " estimated "               => " estimated ",
        " estimating "              => " ciphering ",
        " estimation "              => " admiration ",
        " estrange "                => " alien ",
        " estranged "               => " conflicting ",
        " estrangement "            => " alienation ",
        " estuary "                 => " branch ",
        " esurience "               => " acquisitiveness ",
        " esurient "                => " acquisitive ",
        " etch "                    => " compose ",
        " etched "                  => " categorical ",
        " etching "                 => " carving ",
        " eternal "                 => " abiding ",
        " eternalize "              => " bolster ",
        " eternally "               => " always ",
        " eternity "                => " aeon ",
        " eternize "                => " bolster ",
        " ethanol "                 => " booze ",
        " ethereal "                => " aerial ",
        " ethereality "             => " airiness ",
        " ethereally "              => " agilely ",
        " etherealness "            => " airiness ",
        " ethic "                   => " belief ",
        " ethicality "              => " advantage ",
        " ethics "                  => " belief ",
        " ethnic "                  => " indigenous ",
        " ethnologic "              => " animal ",
        " ethological "             => " animal ",
        " ethos "                   => " appearance ",
        " etiolate "                => " achromatize ",
        " etiolated "               => " achromatic ",
        " etiolation "              => " debility ",
        " etiology "                => " analysis ",
        " etiquette "               => " amenities ",
        " etymology "               => " ancestry ",
        " eugenic "                 => " abiogenetic ",
        " eugenics "                => " ancestry ",
        " eulogistic "              => " adulatory ",
        " eulogize "                => " acclaim ",
        " eulogizing "              => " acclamation ",
        " eulogy "                  => " acclaim ",
        " eunuchize "               => " alter ",
        " eupepsia "                => " bloom ",
        " euphemism "               => " delicacy ",
        " euphemistic "             => " aureate ",
        " euphonic "                => " accordant ",
        " euphonious "              => " adapted ",
        " euphony "                 => " accord ",
        " euphoria "                => " bliss ",
        " euphoric "                => " beatific ",
        " euphuism "                => " adumbration ",
        " euphuistic "              => " aureate ",
        " eupnea "                  => " animation ",
        " euthanasia "              => " afterlife ",
        " evacuate "                => " abandon ",
        " evacuated "               => " abandoned ",
        " evacuation "              => " aborticide ",
        " evacuee "                 => " alien ",
        " evade "                   => " balk ",
        " evading "                 => " artifice ",
        " evaluate "                => " appraise ",
        " evaluation "              => " appraisal ",
        " evaluator "               => " analyzer ",
        " evanesce "                => " abandon ",
        " evanescence "             => " dematerialization ",
        " evanescent "              => " ambiguous ",
        " evangelism "              => " cause ",
        " evangelist "              => " advocate ",
        " evangelize "              => " deliver ",
        " evanish "                 => " abandon ",
        " evaporate "               => " clear ",
        " evaporating "             => " abbreviating ",
        " evaporation "             => " dehydration ",
        " evasion "                 => " artifice ",
        " evasive "                 => " ambiguous ",
        " even "                    => " alike ",
        " even-handed "             => " balanced ",
        " even-handedness "         => " disinterestedness ",
        " even-steven "             => " antithesis ",
        " even-tempered "           => " amenable ",
        " evened "                  => " counterbalanced ",
        " evenhandedly "            => " accurately ",
        " evenhandedness "          => " bluntness ",
        " evening "                 => " black ",
        " evenly "                  => " analogously ",
        " evenness "                => " antithesis ",
        " evensong "                => " aria ",
        " event "                   => " accident ",
        " eventful "                => " active ",
        " eventide "                => " dark ",
        " events "                  => " contest ",
        " eventual "                => " closing ",
        " eventuality "             => " aftereffect ",
        " eventualize "             => " appear ",
        " ever "                    => " anytime ",
        " ever-present "            => " abiding ",
        " evergreen "               => " beloved ",
        " everlasting "             => " abiding ",
        " everlastingly "           => " consistently ",
        " everlastingness "         => " aeon ",
        " evermore "                => " consistently ",
        " evert "                   => " belie ",
        " everyday "                => " accustomed ",
        " everyone "                => " anybody ",
        " everything "              => " aggregate ",
        " evict "                   => " adios ",
        " eviction "                => " boot ",
        " evidence "                => " affirmation ",
        " evidenced "               => " apparent ",
        " evident "                 => " axiomatic ",
        " evidential "              => " apocalyptic ",
        " evidently "               => " clearly ",
        " evil "                    => " angry ",
        " evil-doing "              => " anger ",
        " evildoing "               => " abomination ",
        " evilness "                => " abomination ",
        " evince "                  => " appeal ",
        " evinced "                 => " apparent ",
        " evincible "               => " ascertainable ",
        " evincive "                => " affectionate ",
        " eviscerate "              => " attenuate ",
        " evocation "               => " abstraction ",
        " evocative "               => " evocative ",
        " evocator "                => " astrologer ",
        " evocatory "               => " evocative ",
        " evoke "                   => " arm-twist ",
        " evolution "               => " change ",
        " evolutionism "            => " adaptation ",
        " evolve "                  => " advance ",
        " evolved "                 => " acquired ",
        " evulse "                  => " avulse ",
        " evulsion "                => " abstraction ",
        " ex-con "                  => " blackmailer ",
        " exacerbate "              => " aggravate ",
        " exacerbated "             => " affronted ",
        " exacerbation "            => " deepening ",
        " exacting "                => " burdensome ",
        " exactingness "            => " acerbity ",
        " exaction "                => " bribery ",
        " exactitude "              => " accurateness ",
        " exactly "                 => " absolutely ",
        " exactness "               => " carefulness ",
        " exaggerate "              => " amplify ",
        " exaggerated "             => " abstract ",
        " exalt "                   => " acclaim ",
        " exaltation "              => " acclaim ",
        " exalted "                 => " astral ",
        " exaltedness "             => " advance ",
        " exalting "                => " animating ",
        " exam "                    => " assay ",
        " examination "             => " assay ",
        " examine "                 => " appraise ",
        " examined "                => " advised ",
        " examining "               => " analytical ",
        " example "                 => " archetype ",
        " exanimate "               => " asleep ",
        " exasperated "             => " affronted ",
        " exasperating "            => " aggravating ",
        " exasperation "            => " aggravation ",
        " excavate "                => " burrow ",
        " excavated "               => " biconcave ",
        " excavation "              => " blasting ",
        " excavator "               => " archaeologian ",
        " exceed "                  => " beat ",
        " exceeding "               => " beyond ",
        " exceedingly "             => " awfully ",
        " excellence "              => " arete ",
        " excellency "              => " arete ",
        " excellent "               => " accomplished ",
        " excellently "             => " alluringly ",
        " excelling "               => " absolute ",
        " excepted "                => " absolved ",
        " exception "               => " barring ",
        " exceptionable "           => " exceptionable ",
        " exceptional "             => " aberrant ",
        " exceptionally "           => " awfully ",
        " exceptive "               => " acrimonious ",
        " excerpt "                 => " extract ",
        " excess "                  => " balance ",
        " excessive "               => " boundless ",
        " excessively "             => " badly ",
        " excessiveness "           => " abundance ",
        " exchange "                => " barter ",
        " exchangeability "         => " adequation ",
        " exchangeable "            => " changeable ",
        " exchequer "               => " coffer ",
        " excise "                  => " customs ",
        " excision "                => " abatement ",
        " excitability "            => " affect ",
        " excitable "               => " agitable ",
        " excitant "                => " actuation ",
        " excitation "              => " action ",
        " excite "                  => " accelerate ",
        " excited "                 => " aflame ",
        " excitedly "               => " absurdly ",
        " excitedness "             => " animation ",
        " excitement "              => " action ",
        " exciting "                => " agitative ",
        " exclaim "                 => " assert ",
        " exclamation "             => " assertion ",
        " exclave "                 => " area ",
        " excluded "                => " afar ",
        " exclusionary "            => " absolute ",
        " exclusive "               => " absolute ",
        " exclusively "             => " alone ",
        " exclusory "               => " absolute ",
        " excogitate "              => " conceive ",
        " excogitation "            => " belief ",
        " excommunicate "           => " anathematize ",
        " excoriate "               => " abrade ",
        " excoriation "             => " abhorrence ",
        " excrement "               => " clay ",
        " excrescence "             => " abscess ",
        " excrete "                 => " defecate ",
        " excretion "               => " elimination ",
        " excruciate "              => " afflict ",
        " excruciating "            => " acute ",
        " excruciation "            => " affliction ",
        " exculpate "               => " absolve ",
        " exculpated "              => " absolved ",
        " exculpation "             => " absolution ",
        " excurse "                 => " aberrate ",
        " excursion "               => " circuit ",
        " excursionist "            => " commuter ",
        " excursive "               => " abstruse ",
        " excursus "                => " addendum ",
        " excuse "                  => " alibi ",
        " excused "                 => " absolved ",
        " excusing "                => " answer ",
        " execrable "               => " abhorrent ",
        " execrate "                => " abhor ",
        " execrated "               => " abhorred ",
        " execration "              => " abhorrence ",
        " execs "                   => " advisers ",
        " execute "                 => " assassinate ",
        " executed "                => " accomplished ",
        " executing "               => " active ",
        " execution "               => " beheading ",
        " executioner "             => " apache ",
        " executive "               => " controlling ",
        " executives "              => " admiral ",
        " executor "                => " abettor ",
        " exegesis "                => " comment ",
        " exegetic "                => " allegorical ",
        " exegetical "              => " allegorical ",
        " exemplar "                => " archetype ",
        " exemplary "               => " admirable ",
        " exemplify "               => " body ",
        " exemplifying "            => " allegorical ",
        " exempt "                  => " absolved ",
        " exemption "               => " absolution ",
        " exenterate "              => " bowel ",
        " exequies "                => " burying ",
        " exercised "               => " acclimatized ",
        " exercises "               => " contest ",
        " exercising "              => " appliance ",
        " exert "                   => " apply ",
        " exerting "                => " advance ",
        " exertion "                => " action ",
        " exertive "                => " alive ",
        " exfiltrate "              => " abjure ",
        " exfiltration "            => " beat ",
        " exfoliate "               => " blister ",
        " exhalation "              => " animation ",
        " exhale "                  => " breathe ",
        " exhaust "                 => " bankrupt ",
        " exhausted "               => " beat ",
        " exhaustible "             => " accessible ",
        " exhausting "              => " backbreaking ",
        " exhaustingly "            => " agonizingly ",
        " exhaustion "              => " burnout ",
        " exhaustive "              => " all-embracing ",
        " exhaustively "            => " absolutely ",
        " exhibit "                 => " display ",
        " exhibited "               => " apparent ",
        " exhibiting "              => " announcement ",
        " exhibitionism "           => " exhibitionism ",
        " exhibitionistic "         => " boastful ",
        " exhibitor "               => " adviser ",
        " exhilarant "              => " agitative ",
        " exhilarate "              => " animate ",
        " exhilarated "             => " agitated ",
        " exhilarating "            => " animating ",
        " exhilarative "            => " animating ",
        " exhilaratory "            => " animating ",
        " exhort "                  => " admonish ",
        " exhortation "             => " admonition ",
        " exhortative "             => " academic ",
        " exhortatory "             => " admonishing ",
        " exhumate "                => " disclose ",
        " exhume "                  => " disclose ",
        " exigence "                => " acuteness ",
        " exigency "                => " acuteness ",
        " exigent "                 => " acute ",
        " exiguity "                => " abridgement ",
        " exiguous "                => " bare ",
        " exiguousness "            => " absence ",
        " exile "                   => " banishment ",
        " exiled "                  => " adopted ",
        " exist "                   => " abide ",
        " existence "               => " actuality ",
        " existent "                => " exact ",
        " existing "                => " absolute ",
        " exit "                    => " avenue ",
        " exiting "                 => " departure ",
        " exocarp "                 => " bark ",
        " exodus "                  => " departure ",
        " exonerate "               => " absolve ",
        " exonerated "              => " absolved ",
        " exoneration "             => " absolution ",
        " exorable "                => " austere ",
        " exorbitance "             => " balance ",
        " exorbitant "              => " absonant ",
        " exorbitantly "            => " acutely ",
        " exorcise "                => " bewitch ",
        " exorciser "               => " archimage ",
        " exorcism "                => " adjournment ",
        " exorcist "                => " archimage ",
        " exordium "                => " exordium ",
        " exoteric "                => " exoteric ",
        " exotic "                  => " alien ",
        " exoticism "               => " anomaly ",
        " expand "                  => " aggrandize ",
        " expandable "              => " abundant ",
        " expanded "                => " broadcast ",
        " expanding "               => " accretion ",
        " expanse "                 => " amplitude ",
        " expansile "               => " all-embracing ",
        " expansion "               => " amplification ",
        " expansive "               => " all-embracing ",
        " expansively "             => " abundantly ",
        " expansiveness "           => " amplitude ",
        " expatiation "             => " addition ",
        " expatriate "              => " departer ",
        " expatriation "            => " abandonment ",
        " expect "                  => " apprehend ",
        " expectancy "              => " assumption ",
        " expectant "               => " alert ",
        " expectation "             => " apprehension ",
        " expected "                => " accepted ",
        " expecting "               => " assured ",
        " expectorate "             => " bark ",
        " expedience "              => " address ",
        " expediency "              => " advantage ",
        " expediently "             => " apparently ",
        " expedite "                => " accelerate ",
        " expedition "              => " campaign ",
        " expeditionist "           => " adventurer ",
        " expeditious "             => " active ",
        " expeditiously "           => " agilely ",
        " expeditiousness "         => " alacrity ",
        " expel "                   => " belch ",
        " expendable "              => " dispensable ",
        " expenditure "             => " amount ",
        " expense "                 => " amount ",
        " expenses "                => " costs ",
        " expensive "               => " big-ticket ",
        " experience "              => " acquaintance ",
        " experienced "             => " accomplished ",
        " experiences "             => " adventures ",
        " experient "               => " empiric ",
        " experiential "            => " empiric ",
        " experiment "              => " agreement ",
        " experimental "            => " beginning ",
        " experimentation "         => " analysis ",
        " experiments "             => " abstracts ",
        " expert "                  => " able ",
        " expertise "               => " ability ",
        " expertism "               => " ability ",
        " expertness "              => " adeptness ",
        " expiate "                 => " absolve ",
        " expiation "               => " apology ",
        " expiatory "               => " atoning ",
        " expiration "              => " cessation ",
        " expired "                 => " asleep ",
        " expiry "                  => " accomplishment ",
        " explaining "              => " answer ",
        " explanation "             => " account ",
        " explanatory "             => " allegorical ",
        " expletive "               => " curse ",
        " explicability "           => " accuracy ",
        " explicate "               => " amplify ",
        " explication "             => " comment ",
        " explicative "             => " anecdotic ",
        " explicatory "             => " critical ",
        " explicit "                => " absolute ",
        " explicitly "              => " absolutely ",
        " explicitness "            => " accuracy ",
        " explode "                 => " backfire ",
        " exploit "                 => " accomplishment ",
        " exploitable "             => " accommodating ",
        " exploitation "            => " corruption ",
        " exploitative "            => " arrant ",
        " exploited "               => " exploited ",
        " exploiting "              => " base ",
        " exploration "             => " analysis ",
        " exploratory "             => " basic ",
        " explore "                 => " analyze ",
        " explorer "                => " charlatan ",
        " explorers "               => " campaign ",
        " explosion "               => " access ",
        " explosive "               => " atomic ",
        " expo "                    => " bazaar ",
        " exponent "                => " backer ",
        " export "                  => " consign ",
        " exposal "                 => " acknowledgment ",
        " expose "                  => " betrayal ",
        " exposed "                 => " apparent ",
        " exposedness "             => " accident ",
        " exposing "                => " advertisement ",
        " exposition "              => " account ",
        " expositional "            => " allegorical ",
        " expositor "               => " analyst ",
        " expository "              => " critical ",
        " expostulate "             => " argue ",
        " expostulation "           => " argumentation ",
        " exposure "                => " acknowledgment ",
        " expound "                 => " clarify ",
        " expounder "               => " apostle ",
        " expounding "              => " analogue ",
        " express "                 => " accurate ",
        " expressed "               => " bidding ",
        " expressing "              => " cogent ",
        " expression "              => " announcement ",
        " expressionless "          => " dead ",
        " expressive "              => " alive ",
        " expressiveness "          => " ability ",
        " expressivity "            => " ability ",
        " expressly "               => " especially ",
        " expressway "              => " freeway ",
        " exprobate "               => " abuse ",
        " exprobation "             => " accusation ",
        " expropriate "             => " accroach ",
        " expropriation "           => " confiscation ",
        " expulsion "               => " banishment ",
        " expurgate "               => " bleep ",
        " expurgated "              => " abridged ",
        " expurgation "             => " ablution ",
        " exquisite "               => " admirable ",
        " exquisitely "             => " alluringly ",
        " exquisiteness "           => " adorableness ",
        " exsanguinous "            => " ashen ",
        " exscind "                 => " abridge ",
        " exsect "                  => " carve ",
        " exsiccate "               => " cotton-mouth ",
        " extant "                  => " actual ",
        " extempore "               => " extemporaneous ",
        " extemporization "         => " actuation ",
        " extemporize "             => " ad-lib ",
        " extemporized "            => " extemporaneous ",
        " extended "                => " continued ",
        " extendible "              => " adaptable ",
        " extensibility "           => " adaptability ",
        " extensible "              => " adaptable ",
        " extensile "               => " adaptable ",
        " extension "               => " addendum ",
        " extensional "             => " analytic ",
        " extensity "               => " ambit ",
        " extensive "               => " all-encompassing ",
        " extensively "             => " abundantly ",
        " extensiveness "           => " amplitude ",
        " extent "                  => " admeasurement ",
        " extenuate "               => " abate ",
        " extenuated "              => " angular ",
        " extenuation "             => " acknowledgment ",
        " extenuative "             => " extenuative ",
        " exterior "                => " exoteric ",
        " exteriorize "             => " actualize ",
        " exteriorized "            => " embodied ",
        " exterminate "             => " abate ",
        " exterminated "            => " abolished ",
        " extermination "           => " annihilation ",
        " external "                => " alien ",
        " externalize "             => " actualize ",
        " externalized "            => " embodied ",
        " externally "              => " evidently ",
        " extinct "                 => " abolished ",
        " extinction "              => " afterlife ",
        " extinguished "            => " abolished ",
        " extinguishing "           => " abolition ",
        " extinguishment "          => " concealment ",
        " extirpate "               => " abate ",
        " extirpation "             => " abolishment ",
        " extirpative "             => " annihilative ",
        " extol "                   => " acclaim ",
        " extolled "                => " acclaimed ",
        " extolment "               => " acclaim ",
        " extort "                  => " blackmail ",
        " extorting "               => " acquisitive ",
        " extortionate "            => " base ",
        " extra "                   => " added ",
        " extract "                 => " abstract ",
        " extraction "              => " abstraction ",
        " extradite "               => " abandon ",
        " extradition "             => " displacement ",
        " extralegal "              => " actionable ",
        " extralocal "              => " adopted ",
        " extramundane "            => " airy ",
        " extramural "              => " alfresco ",
        " extraneous "              => " accidental ",
        " extraneously "            => " apparently ",
        " extraordinarily "         => " abnormally ",
        " extraordinariness "       => " aberancy ",
        " extraordinary "           => " amazing ",
        " extras "                  => " account ",
        " extraterrestrial "        => " exoteric ",
        " extraterritorial "        => " exoteric ",
        " extravagance "            => " absurdity ",
        " extravagant "             => " absurd ",
        " extravagantly "           => " abundantly ",
        " extravaganza "            => " caricature ",
        " extravagate "             => " change ",
        " extravasate "             => " appear ",
        " extreme "                 => " acute ",
        " extremely "               => " acutely ",
        " extremism "               => " abandonment ",
        " extremist "               => " agitator ",
        " extremity "               => " acme ",
        " extrinsic "               => " acquired ",
        " extrovert "               => " character ",
        " extroverted "             => " affable ",
        " extrude "                 => " boot ",
        " extrusion "               => " banishment ",
        " extrusive "               => " arresting ",
        " exuberance "              => " abandon ",
        " exuberancy "              => " agitation ",
        " exuberant "               => " animated ",
        " exudate "                 => " address ",
        " exudation "               => " elimination ",
        " exude "                   => " bleed ",
        " exultance "               => " celebration ",
        " exultation "              => " crowing ",
        " exuviate "                => " afford ",
        " eye-catching "            => " clear ",
        " eye-opener "              => " account ",
        " eye-opening "             => " abrupt ",
        " eye-popping "             => " agitative ",
        " eyebrow "                 => " countenance ",
        " eyeful "                  => " beauty ",
        " eyelash "                 => " beard ",
        " eyeless "                 => " dark ",
        " eyelet "                  => " aperture ",
        " eyeshot "                 => " afterimage ",
        " eyesight "                => " apparition ",
        " eyesore "                 => " atrocity ",
        " eyewash "                 => " adulation ",
        " eyewitness "              => " beholder ",
        " fable "                   => " allegory ",
        " fabled "                  => " fabulous ",
        " fabler "                  => " cheat ",
        " fabric "                  => " bolt ",
        " fabricate "               => " assemble ",
        " fabricated "              => " bogus ",
        " fabricating "             => " architecture ",
        " fabrication "             => " artifact ",
        " fabricator "              => " architect ",
        " fabulist "                => " cheat ",
        " fabulous "                => " aces ",
        " facade "                  => " bluff ",
        " face-lift "               => " anaplasty ",
        " face-lifting "            => " face-lifting ",
        " face-off "                => " altercation ",
        " face-to-face "            => " contiguous ",
        " facet "                   => " angle ",
        " facetious "               => " amusing ",
        " facetiousness "           => " ball ",
        " facile "                  => " accomplished ",
        " facilely "                => " calmly ",
        " facilitation "            => " abetment ",
        " facilities "              => " accessories ",
        " facility "                => " ability ",
        " facing "                  => " adverse ",
        " fact "                    => " actuality ",
        " faction "                 => " band ",
        " factional "               => " aberrant ",
        " factionalism "            => " animosity ",
        " factious "                => " alienated ",
        " factiousness "            => " affront ",
        " factitious "              => " bogus ",
        " factor "                  => " agency ",
        " factorage "               => " allowance ",
        " factory "                 => " branch ",
        " factory-made "            => " automated ",
        " factotum "                => " abettor ",
        " factual "                 => " absolute ",
        " factualism "              => " accuracy ",
        " factuality "              => " accuracy ",
        " factually "               => " absolutely ",
        " factualness "             => " accuracy ",
        " facultative "             => " arbitrary ",
        " faculties "               => " commonsense ",
        " faculty "                 => " adroitness ",
        " facund "                  => " affecting ",
        " facundity "               => " ability ",
        " faddish "                 => " chichi ",
        " faddism "                 => " admiration ",
        " faddy "                   => " accepted ",
        " fade "                    => " achromatize ",
        " faded "                   => " achromatic ",
        " fading "                  => " crumbling ",
        " faggy "                   => " chichi ",
        " fail "                    => " abort ",
        " failed "                  => " bootless ",
        " failing "                 => " declining ",
        " failure "                 => " abortion ",
        " faineance "               => " apathy ",
        " faineancy "               => " apathy ",
        " faint "                   => " aside ",
        " faint-hearted "           => " abashed ",
        " faint-of-heart "          => " alarmist ",
        " faintheartedness "        => " abhorrence ",
        " fainting "                => " amazement ",
        " faintness "               => " decrepitude ",
        " fair-and-square "         => " aboveboard ",
        " fair-haired "             => " angel ",
        " fair-minded "             => " candid ",
        " fair-mindedness "         => " disinterestedness ",
        " fair-skinned "            => " blanched ",
        " fair-spoken "             => " adulatory ",
        " fair-weather "            => " capricious ",
        " fairground "              => " amphitheater ",
        " fairing "                 => " allowance ",
        " fairish "                 => " adequate ",
        " fairly "                  => " adequately ",
        " fairness "                => " candor ",
        " fairy "                   => " bogie ",
        " fairy-tale "              => " absurd ",
        " fairylike "               => " active ",
        " faith "                   => " acceptance ",
        " faithful "                => " affectionate ",
        " faithfully "              => " anxiously ",
        " faithfulness "            => " adherence ",
        " faithless "               => " agnostic ",
        " faithlessness "           => " agnosticism ",
        " fake "                    => " affected ",
        " faked "                   => " apish ",
        " faker "                   => " actor ",
        " fakery "                  => " canard ",
        " faking "                  => " appearance ",
        " falcate "                 => " bow-shaped ",
        " fall "                    => " abatement ",
        " fallacious "              => " beguiling ",
        " fallaciousness "          => " canard ",
        " fallacy "                 => " aberration ",
        " fallen "                  => " collapsed ",
        " fallibility "             => " blemish ",
        " fallible "                => " careless ",
        " falling-out "             => " altercation ",
        " falloff "                 => " declivity ",
        " fallow "                  => " dormant ",
        " falls "                   => " avalanche ",
        " false "                   => " apocryphal ",
        " false-hearted "           => " apostate ",
        " falsehood "               => " canard ",
        " falsie "                  => " bogus ",
        " falsification "           => " adulteration ",
        " falsified "               => " biased ",
        " falsifier "               => " adversary ",
        " falsify "                 => " adulterate ",
        " falsity "                 => " canard ",
        " faltering "               => " aged ",
        " fame "                    => " acclaim ",
        " famed "                   => " acclaimed ",
        " familiar "                => " accustomed ",
        " familiarity "             => " acquaintance ",
        " familiarization "         => " acclimatization ",
        " familiarize "             => " accustom ",
        " familiarized "            => " acclimatized ",
        " family "                  => " ancestors ",
        " famine "                  => " dearth ",
        " famished "                => " dog-hungry ",
        " famishing "               => " athirst ",
        " famishment "              => " ache ",
        " famous "                  => " acclaimed ",
        " famously "                => " abundantly ",
        " famousness "              => " authority ",
        " fanatic "                 => " activist ",
        " fanatical "               => " biased ",
        " fanaticism "              => " abandonment ",
        " fancied "                 => " absurd ",
        " fancier "                 => " adherent ",
        " fanciful "                => " absurd ",
        " fanciness "               => " adornment ",
        " fancy "                   => " adorned ",
        " fancy-free "              => " footloose ",
        " fancying "                => " apperception ",
        " fandangle "               => " accessory ",
        " fanfare "                 => " alarum ",
        " fang "                    => " barb ",
        " fanion "                  => " banderole ",
        " fans "                    => " admirers ",
        " fantasize "               => " daydream ",
        " fantasized "              => " acted ",
        " fantasmo "                => " arbitrary ",
        " fantastic "               => " absurd ",
        " fantastical "             => " absurd ",
        " far-extending "           => " extensive ",
        " far-fetched "             => " adopted ",
        " far-flung "               => " extensive ",
        " far-going "               => " extensive ",
        " far-off "                 => " abroad ",
        " far-out "                 => " avant-garde ",
        " far-ranging "             => " extensive ",
        " far-reaching "            => " extensive ",
        " far-removed "             => " afar ",
        " far-seeing "              => " acute ",
        " far-sighted "             => " clear-sighted ",
        " far-sightedness "         => " anticipation ",
        " far-spread "              => " extensive ",
        " far-stretched "           => " extensive ",
        " faraway "                 => " absent ",
        " farce "                   => " absurdity ",
        " farceur "                 => " antic ",
        " farcical "                => " amusing ",
        " fardel "                  => " bales ",
        " fare "                    => " book ",
        " farewell "                => " adieu ",
        " farfetched "              => " bizarre ",
        " farm "                    => " acreage ",
        " farmer "                  => " agriculturalist ",
        " farming "                 => " agriculture ",
        " farmstead "               => " acreage ",
        " farness "                 => " ambit ",
        " farrago "                 => " assortment ",
        " farseeing "               => " clear-sighted ",
        " farsighted "              => " acute ",
        " farsightedness "          => " accuracy ",
        " farther "                 => " further ",
        " farthermost "             => " extreme ",
        " farthest "                => " extreme ",
        " farthing "                => " division ",
        " fascicle "                => " agglomeration ",
        " fascinate "               => " absorb ",
        " fascinated "              => " absorbed ",
        " fascinating "             => " alluring ",
        " fascination "             => " allure ",
        " fascism "                 => " absolutism ",
        " fascist "                 => " absolutist ",
        " fascistic "               => " arbitrary ",
        " fashion "                 => " appearance ",
        " fashionableness "         => " acceptance ",
        " fashioned "               => " ancient ",
        " fast-approaching "        => " approaching ",
        " fasten "                  => " adhere ",
        " fastened "                => " attached ",
        " fastener "                => " ballast ",
        " fasteners "               => " accouterments ",
        " fastening "               => " band ",
        " fasthold "                => " alcazar ",
        " fastidious "              => " captious ",
        " fastidiously "            => " anxiously ",
        " fastigium "               => " acme ",
        " fasting "                 => " abnegation ",
        " fastness "                => " alcazar ",
        " fatal "                   => " baleful ",
        " fatalistic "              => " bleak ",
        " fatality "                => " accident ",
        " fated "                   => " blighted ",
        " fateful "                 => " acute ",
        " fatheaded "               => " doltish ",
        " father "                  => " ancestor ",
        " fatherland "              => " citizenry ",
        " fatherless "              => " adulterated ",
        " fatherlike "              => " benevolent ",
        " fatherly "                => " affectionate ",
        " fathom "                  => " appreciate ",
        " fathomable "              => " apprehensible ",
        " fathomage "               => " abyss ",
        " fathomless "              => " bottomless ",
        " fatiguing "               => " backbreaking ",
        " fatlike "                 => " adipose ",
        " fatness "                 => " adiposity ",
        " fatso "                   => " abundant ",
        " fatten "                  => " augment ",
        " fattish "                 => " beefy ",
        " fatty "                   => " blubbery ",
        " fatuous "                 => " absurd ",
        " fatuousness "             => " asininity ",
        " fault "                   => " accountability ",
        " fault-finding "           => " acrimonious ",
        " faultfinder "             => " bear ",
        " faultfinding "            => " animadversion ",
        " faultily "                => " afield ",
        " faultiness "              => " aberration ",
        " faultlessly "             => " absolutely ",
        " faultlessness "           => " accurateness ",
        " faulty "                  => " adulterated ",
        " fave "                    => " beloved ",
        " favorably "               => " agreeably ",
        " favored "                 => " advantaged ",
        " favoring "                => " benign ",
        " favorite "                => " admired ",
        " favoritism "              => " discrimination ",
        " fawn "                    => " abase ",
        " fawner "                  => " ass-kisser ",
        " fawning "                 => " abject ",
        " faze "                    => " abash ",
        " fazed "                   => " ashamed ",
        " fealty "                  => " adherence ",
        " fear "                    => " abhorrence ",
        " fearful "                 => " aflutter ",
        " fearfully "               => " appallingly ",
        " fearfulness "             => " affliction ",
        " fearless "                => " assured ",
        " fearlessness "            => " adventurousness ",
        " fearsome "                => " alarming ",
        " feasibility "             => " achievability ",
        " feasible "                => " achievable ",
        " feasibly "                => " conceivably ",
        " feast "                   => " barbecue ",
        " feat "                    => " accomplishment ",
        " feather "                 => " calamus ",
        " feather-brained "         => " airheaded ",
        " featherbed "              => " bypass ",
        " featherbrain "            => " addle-brain ",
        " featherbrained "          => " asinine ",
        " featherlike "             => " featherlike ",
        " feathers "                => " accoutrement ",
        " featherweight "           => " agile ",
        " feathery "                => " bristling ",
        " feature "                 => " affection ",
        " featureless "             => " characterless ",
        " features "                => " appearance ",
        " febrile "                 => " delirious ",
        " fecal "                   => " begrimed ",
        " feces "                   => " carrion ",
        " feckless "                => " aimless ",
        " feculence "               => " clay ",
        " feculent "                => " begrimed ",
        " fecund "                  => " breeding ",
        " fecundate "               => " beget ",
        " fecundation "             => " evolution ",
        " fecundity "               => " abundance ",
        " federacy "                => " alliance ",
        " federate "                => " affiliate ",
        " federated "               => " amalgamated ",
        " federation "              => " alliance ",
        " feds "                    => " admiral ",
        " feeble "                  => " aged ",
        " feeble-minded "           => " addled ",
        " feebleminded "            => " arrested ",
        " feebleness "              => " debility ",
        " feeblest "                => " atomic ",
        " feed "                    => " augment ",
        " feedback "                => " acknowledgment ",
        " feedbag "                 => " banquet ",
        " feeder "                  => " agriculturalist ",
        " feeding "                 => " agriculture ",
        " feeler "                  => " advance ",
        " feelers "                 => " aerial ",
        " feelgood "                => " animation ",
        " feeling "                 => " activity ",
        " feelingless "             => " aloof ",
        " feelingly "               => " acutely ",
        " feelings "                => " animosity ",
        " feet "                    => " anxiety ",
        " feigned "                 => " affected ",
        " feigning "                => " affectation ",
        " feint "                   => " artifice ",
        " feisty "                  => " angry ",
        " felicitation "            => " acclaim ",
        " felicitous "              => " applicable ",
        " felicitously "            => " acquiescently ",
        " felicity "                => " beatitude ",
        " feline "                  => " artful ",
        " fellow "                  => " adolescent ",
        " fellow-feeling "          => " accord ",
        " fellows "                 => " advisers ",
        " fellowship "              => " acquaintance ",
        " felonious "               => " bent ",
        " felonry "                 => " abyss ",
        " felony "                  => " abomination ",
        " felt "                    => " acquainted ",
        " female "                  => " changeable ",
        " feminality "              => " delicacy ",
        " feminate "                => " chichi ",
        " femineity "               => " delicacy ",
        " feminineness "            => " delicacy ",
        " femininity "              => " delicacy ",
        " femme "                   => " coquette ",
        " fence-hanger "            => " beholder ",
        " fence-sitting "           => " candid ",
        " fenced "                  => " belted ",
        " fencing "                 => " angry ",
        " fend "                    => " bulwark ",
        " fender-bender "           => " blow ",
        " feracious "               => " abundant ",
        " feracity "                => " abundance ",
        " feral "                   => " beastly ",
        " ferally "                 => " atrociously ",
        " ferine "                  => " abominable ",
        " ferment "                 => " agitate ",
        " fermentation "            => " beverage ",
        " fermented "               => " brewed ",
        " fermenting "              => " crumbling ",
        " fern "                    => " bracken ",
        " ferocious "               => " barbaric ",
        " ferociously "             => " berserk ",
        " ferociousness "           => " acuteness ",
        " ferocity "                => " atrocity ",
        " ferret "                  => " ascertain ",
        " ferric "                  => " adamant ",
        " ferried "                 => " alien ",
        " ferrous "                 => " adamant ",
        " ferry "                   => " bear ",
        " fertile "                 => " abundant ",
        " fertility "               => " abundance ",
        " fertilize "               => " beget ",
        " fertilizing "             => " agriculture ",
        " ferule "                  => " baste ",
        " fervency "                => " animation ",
        " fervent "                 => " animated ",
        " fervently "               => " agilely ",
        " fervid "                  => " agog ",
        " fervor "                  => " animation ",
        " fess "                    => " acknowledge ",
        " festal "                  => " back-slapping ",
        " fester "                  => " aggravate ",
        " festival "                => " anniversary ",
        " festive "                 => " blithe ",
        " festivities "             => " anniversary ",
        " festivity "               => " amusement ",
        " festoon "                 => " boutonniere ",
        " festooned "               => " accessory ",
        " festooning "              => " adornment ",
        " fetch "                   => " back ",
        " fetching "                => " attractive ",
        " fete "                    => " ball ",
        " feticide "                => " aborticide ",
        " fetid "                   => " corrupt ",
        " fetish "                  => " amulet ",
        " fetor "                   => " effluvium ",
        " fetter "                  => " bind ",
        " fettered "                => " amenable ",
        " feud "                    => " altercation ",
        " feudalism "               => " bullwork ",
        " feudatory "               => " feudatory ",
        " feuding "                 => " altercation ",
        " fever "                   => " agitation ",
        " fevered "                 => " delirious ",
        " feverishness "            => " agitation ",
        " feverous "                => " ardent ",
        " fewer "                   => " beneath ",
        " fewest "                  => " atomic ",
        " fewness "                 => " absence ",
        " fiasco "                  => " abortion ",
        " fiat "                    => " authorization ",
        " fibber "                  => " cheat ",
        " fibbery "                 => " canard ",
        " fibbing "                 => " ambiguity ",
        " fiber "                   => " cilia ",
        " fiberboard "              => " agenda ",
        " fibril "                  => " cilia ",
        " fibroid "                 => " coarse ",
        " fibrous "                 => " coarse ",
        " fichu "                   => " capote ",
        " fickle "                  => " arbitrary ",
        " fictile "                 => " artificial ",
        " fictional "               => " fabulous ",
        " fictitious "              => " apocryphal ",
        " fictive "                 => " absurd ",
        " fiddle "                  => " dabble ",
        " fiddle-faddle "           => " absurdity ",
        " fiddlesticks "            => " absurdity ",
        " fiddling "                => " bribery ",
        " fidelity "                => " allegiance ",
        " fidgeting "               => " active ",
        " fidgets "                 => " all-overs ",
        " fidgety "                 => " antsy ",
        " fido "                    => " bitch ",
        " field "                   => " acreage ",
        " fiendish "                => " awful ",
        " fiendishness "            => " atrociousness ",
        " fier "                    => " besom ",
        " fierce "                  => " angry ",
        " fiercely "                => " angrily ",
        " fierceness "              => " avidity ",
        " fieriness "               => " activity ",
        " fiery "                   => " ablaze ",
        " fife "                    => " blare ",
        " fifty-fifty "             => " accommodation ",
        " figger "                  => " adjudge ",
        " fight "                   => " action ",
        " fighting "                => " angry ",
        " figment "                 => " bubble ",
        " figmental "               => " apocryphal ",
        " figurant "                => " ballerina ",
        " figurante "               => " ballerina ",
        " figuration "              => " apologue ",
        " figurative "              => " allegorical ",
        " figure "                  => " amount ",
        " figured "                 => " ample ",
        " figures "                 => " abstracts ",
        " figurine "                => " baby ",
        " figuring "                => " addition ",
        " filament "                => " fiber ",
        " filch "                   => " abstract ",
        " filching "                => " break-in ",
        " file "                    => " book ",
        " filial "                  => " binding ",
        " filiation "               => " affiliation ",
        " filibuster "              => " delay ",
        " filigree "                => " applique ",
        " fill "                    => " ample ",
        " fill-in "                 => " backup ",
        " filled "                  => " abounding ",
        " filler "                  => " accompaniment ",
        " fillet "                  => " bandage ",
        " filling "                 => " bushing ",
        " fillip "                  => " bang ",
        " filly "                   => " filly ",
        " film "                    => " blur ",
        " filmic "                  => " accurate ",
        " filmy "                   => " chiffon ",
        " filter "                  => " clarify ",
        " filtering "               => " clarification ",
        " filth "                   => " carrion ",
        " filthify "                => " abuse ",
        " filthiness "              => " clay ",
        " filthy "                  => " begrimed ",
        " filtrate "                => " clarify ",
        " finagle "                 => " bamboozle ",
        " finale "                  => " afterpiece ",
        " finality "                => " certitude ",
        " finalization "            => " achievement ",
        " finalize "                => " agree ",
        " finalized "               => " accomplished ",
        " finally "                 => " assuredly ",
        " finance "                 => " accounts ",
        " financer "                => " angel ",
        " finances "                => " affairs ",
        " financial "               => " banking ",
        " financing "               => " costs ",
        " find "                    => " acquisition ",
        " finding "                 => " award ",
        " findings "                => " allegation ",
        " fine "                    => " accomplished ",
        " fine-grained "            => " aerial ",
        " fine-tooth-comb "         => " beat ",
        " finely "                  => " cautiously ",
        " fineness "                => " airiness ",
        " finer "                   => " bigger ",
        " finespun "                => " aerial ",
        " finesse "                 => " acumen ",
        " finger "                  => " feel ",
        " fingernail "              => " barb ",
        " fini "                    => " accomplished ",
        " finical "                 => " dainty ",
        " finicking "               => " acute ",
        " finicky "                 => " choosy ",
        " finis "                   => " accomplishment ",
        " finish "                  => " accomplishment ",
        " finished "                => " accomplished ",
        " finite "                  => " bound ",
        " fink "                    => " backstabber ",
        " fiord "                   => " anchorage ",
        " fire "                    => " blaze ",
        " fire-eater "              => " belligerent ",
        " fire-eating "             => " attentive ",
        " firearms "                => " accoutrements ",
        " fireball "                => " aggressive ",
        " firebrand "               => " agitator ",
        " firebug "                 => " agitator ",
        " fired "                   => " accursed ",
        " fireman "                 => " advocate ",
        " fireplace "               => " broiler ",
        " fireside "                => " abode ",
        " firewater "               => " booze ",
        " firing "                  => " battlefront ",
        " firkin "                  => " butt ",
        " firm "                    => " close ",
        " firmament "               => " empyrean ",
        " firmly "                  => " durably ",
        " firmness "                => " compactness ",
        " first "                   => " aboriginal ",
        " first-born "              => " ancient ",
        " first-class "             => " capital ",
        " first-hand "              => " contiguous ",
        " first-string "            => " accomplished ",
        " firsthand "               => " immediate ",
        " firth "                   => " branch ",
        " fiscal "                  => " budgetary ",
        " fish "                    => " angle ",
        " fishy "                   => " ambiguous ",
        " fissure "                 => " abysm ",
        " fist "                    => " anchor ",
        " fisticuff "               => " bang ",
        " fisticuffs "              => " battle ",
        " fit-out "                 => " accoutrement ",
        " fitful "                  => " broken ",
        " fitfully "                => " anyhow ",
        " fitly "                   => " appropriately ",
        " fitness "                 => " fettle ",
        " fitted "                  => " adapted ",
        " fitter "                  => " bigger ",
        " fitting "                 => " applicable ",
        " fittingly "               => " abundantly ",
        " fittingness "             => " appropriateness ",
        " fittings "                => " accessories ",
        " five "                    => " bristles ",
        " five-and-dime "           => " five-and-dime ",
        " five-star "               => " best ",
        " fixate "                  => " apply ",
        " fixated "                 => " bedeviled ",
        " fixed "                   => " anchored ",
        " fixedly "                 => " durably ",
        " fixedness "               => " compactness ",
        " fixer "                   => " adjudicator ",
        " fixing "                  => " acclimation ",
        " fixings "                 => " constituent ",
        " fixity "                  => " constancy ",
        " fixture "                 => " accoutrement ",
        " fixtures "                => " accessories ",
        " fizz "                    => " buzz ",
        " fizzing "                 => " bubbles ",
        " fizzle "                  => " abort ",
        " fizzy "                   => " airy ",
        " fjord "                   => " basin ",
        " flab "                    => " blubber ",
        " flabbergast "             => " abash ",
        " flabbergasted "           => " addled ",
        " flabby "                  => " baggy ",
        " flaccid "                 => " debilitated ",
        " flaccidity "              => " adaptability ",
        " flack "                   => " affliction ",
        " flacon "                  => " bota ",
        " flag "                    => " banderole ",
        " flag-bearer "             => " agent ",
        " flagellate "              => " bang ",
        " flagging "                => " abatement ",
        " flagitious "              => " abandoned ",
        " flagman "                 => " caretaker ",
        " flagon "                  => " canteen ",
        " flagrancy "               => " abomination ",
        " flagrant "                => " arrant ",
        " flagrantly "              => " aboveboard ",
        " flagstone "               => " asphalt ",
        " flail "                   => " bang ",
        " flair "                   => " ability ",
        " flak "                    => " abuse ",
        " flake "                   => " cell ",
        " flaked "                  => " comatose ",
        " flaky "                   => " cool ",
        " flam "                    => " bunco ",
        " flambeau "                => " aurora ",
        " flamboyance "             => " affectation ",
        " flamboyant "              => " baroque ",
        " flamboyantly "            => " blithely ",
        " flame "                   => " blaze ",
        " flames "                  => " bonfire ",
        " flaming "                 => " ablaze ",
        " flammable "               => " combustible ",
        " flange "                  => " border ",
        " flank "                   => " abut ",
        " flanked "                 => " belted ",
        " flanking "                => " crabbed ",
        " flap "                    => " accessory ",
        " flapcake "                => " battercake ",
        " flapdoodle "              => " applesauce ",
        " flapjack "                => " battercake ",
        " flapper "                 => " bender ",
        " flapping "                => " aerial ",
        " flare "                   => " blaze ",
        " flare-up "                => " blast ",
        " flaring "                 => " afire ",
        " flash "                   => " beam ",
        " flashback "               => " anamnesis ",
        " flashily "                => " blithely ",
        " flashiness "              => " adornment ",
        " flashing "                => " aflame ",
        " flashy "                  => " blatant ",
        " flask "                   => " alembic ",
        " flasket "                 => " bota ",
        " flat "                    => " collapsed ",
        " flat-hat "                => " aviate ",
        " flat-out "                => " apace ",
        " flatness "                => " apathy ",
        " flatten "                 => " abrade ",
        " flattened "               => " bedfast ",
        " flatter "                 => " adulate ",
        " flatterer "               => " ass-kisser ",
        " flattering "              => " adulatory ",
        " flattery "                => " adulation ",
        " flatulent "               => " bombastic ",
        " flatus "                  => " aroma ",
        " flaunt "                  => " advertise ",
        " flaunted "                => " boastful ",
        " flaunting "               => " affected ",
        " flavor "                  => " acidity ",
        " flavorful "               => " aged ",
        " flavoring "               => " additive ",
        " flavorless "              => " banal ",
        " flavorsome "              => " aperitive ",
        " flavory "                 => " appetizing ",
        " flaw "                    => " blemish ",
        " flawed "                  => " awry ",
        " flawless "                => " absolute ",
        " flax "                    => " beat ",
        " flaxen "                  => " albino ",
        " flaxen-haired "           => " blanched ",
        " flay "                    => " attack ",
        " fleabag "                 => " berth ",
        " flecked "                 => " brindle ",
        " flection "                => " bend ",
        " fledgling "               => " apprentice ",
        " flee "                    => " abscond ",
        " fleece "                  => " bleed ",
        " fleeceable "              => " accommodating ",
        " fleeced "                 => " beggared ",
        " fleecer "                 => " bilker ",
        " fleecy "                  => " downy ",
        " fleeing "                 => " beat ",
        " fleer "                   => " banter ",
        " fleet "                   => " agile ",
        " fleet-footed "            => " abrupt ",
        " fleeting "                => " cursory ",
        " fleetly "                 => " apace ",
        " fleetness "               => " activity ",
        " flesh "                   => " beef ",
        " flesh-eating "            => " cannibal ",
        " fleshiness "              => " adiposity ",
        " fleshly "                 => " animal ",
        " fleshy "                  => " ample ",
        " flex "                    => " angle ",
        " flexed "                  => " channelled ",
        " flexibility "             => " adaptability ",
        " flexible "                => " adjustable ",
        " flexibleness "            => " adaptability ",
        " flexile "                 => " adjustable ",
        " flexing "                 => " coil ",
        " flexuous "                => " ambagious ",
        " flexure "                 => " bend ",
        " flibbertigibbet "         => " babbler ",
        " flicker "                 => " beam ",
        " flickering "              => " ablaze ",
        " flightiness "             => " airheadedness ",
        " flighty "                 => " airheaded ",
        " flimflam "                => " baffle ",
        " flimflammed "             => " bamboozled ",
        " flimflammer "             => " bilker ",
        " flimsily "                => " apparently ",
        " flimsiness "              => " debility ",
        " flimsy "                  => " chiffon ",
        " flinch "                  => " avoid ",
        " flinching "               => " backward ",
        " fling "                   => " cast ",
        " flinging "                => " casting ",
        " flintlock "               => " blaster ",
        " flinty "                  => " adamantine ",
        " flip "                    => " cast ",
        " flippancy "               => " archness ",
        " flippant "                => " brassy ",
        " flippantly "              => " agilely ",
        " flipped "                 => " addled ",
        " flipper "                 => " bender ",
        " flippo "                  => " certifiable ",
        " flipside "                => " another ",
        " flirt "                   => " coquette ",
        " flirtation "              => " amour ",
        " flirtatious "             => " amorous ",
        " flirty "                  => " amorous ",
        " flit "                    => " dance ",
        " flitter "                 => " accumulate ",
        " flitting "                => " brief ",
        " floatability "            => " airiness ",
        " floatable "               => " afloat ",
        " floater "                 => " accommodation ",
        " floating "                => " amphibian ",
        " floaty "                  => " chiffon ",
        " floccose "                => " downy ",
        " flocculent "              => " downy ",
        " flock "                   => " army ",
        " flocking "                => " absorption ",
        " floe "                    => " berg ",
        " flog "                    => " beat ",
        " flooded "                 => " abounding ",
        " flooding "                => " calamity ",
        " floodlight "              => " brighten ",
        " floor "                   => " attic ",
        " floored "                 => " addled ",
        " flooring "                => " attic ",
        " floozy "                  => " damsel ",
        " flop "                    => " bomb ",
        " flophouse "               => " auberge ",
        " floppy "                  => " billowing ",
        " floption "                => " abashing ",
        " floret "                  => " blossom ",
        " floricultural "           => " agronomical ",
        " florid "                  => " aureate ",
        " floridity "               => " adornment ",
        " floridness "              => " delicacy ",
        " floristics "              => " anatomy ",
        " floss "                   => " accessory ",
        " flossy "                  => " creamy ",
        " flotation "               => " abutment ",
        " flotilla "                => " fleet ",
        " flounce "                 => " camp ",
        " flounderer "              => " addle-brain ",
        " flour "                   => " abrade ",
        " flourish "                => " curl ",
        " flourishing "             => " blooming ",
        " floury "                  => " arenaceous ",
        " flout "                   => " affront ",
        " flouter "                 => " carper ",
        " flouting "                => " acrimony ",
        " flow "                    => " breeze ",
        " flower "                  => " annual ",
        " flower-patterned "        => " blooming ",
        " floweret "                => " blossom ",
        " flowering "               => " beginning ",
        " flowery "                 => " aureate ",
        " flowing "                 => " abounding ",
        " flown "                   => " aureate ",
        " flub "                    => " blooper ",
        " flub-up "                 => " blooper ",
        " fluctuant "               => " capricious ",
        " fluctuate "               => " alter ",
        " fluctuating "             => " clashing ",
        " fluctuation "             => " aberration ",
        " fluency "                 => " delivery ",
        " fluent "                  => " chatty ",
        " fluently "                => " calmly ",
        " fluff "                   => " boner ",
        " fluffed "                 => " amiss ",
        " fluffy "                  => " creamy ",
        " fluid "                   => " aqueous ",
        " fluidic "                 => " abounding ",
        " fluidify "                => " deliquesce ",
        " fluidity "                => " alteration ",
        " fluke "                   => " accident ",
        " flukey "                  => " capricious ",
        " fluky "                   => " accidental ",
        " flume "                   => " abysm ",
        " flummery "                => " adulation ",
        " flummox "                 => " flop ",
        " flummoxed "               => " abashed ",
        " flunkey "                 => " also-ran ",
        " flunky "                  => " ass-kisser ",
        " fluorescent "             => " beaming ",
        " flurrying "               => " animated ",
        " flush "                   => " even ",
        " flushed "                 => " ablaze ",
        " flushing "                => " bloom ",
        " fluster "                 => " agitation ",
        " flustered "               => " abashed ",
        " flustering "              => " animated ",
        " flute "                   => " canal ",
        " fluted "                  => " channelled ",
        " fluting "                 => " approach ",
        " flutter "                 => " agitate ",
        " fluttering "              => " aerial ",
        " flux "                    => " alteration ",
        " fly-by-night "            => " brief ",
        " flying "                  => " aerial ",
        " flyspeck "                => " atom ",
        " foal "                    => " filly ",
        " foam "                    => " cream ",
        " foaming "                 => " bubbles ",
        " foamy "                   => " barmy ",
        " focalize "                => " attract ",
        " focusing "                => " absorption ",
        " fogginess "               => " billow ",
        " foggy "                   => " blurred ",
        " fogyish "                 => " bourgeois ",
        " foible "                  => " characteristic ",
        " foil "                    => " antithesis ",
        " foiled "                  => " aghast ",
        " foiling "                 => " arresting ",
        " foison "                  => " bonanza ",
        " foist "                   => " appoint ",
        " fold "                    => " bend ",
        " folded "                  => " bankrupt ",
        " folder "                  => " binder ",
        " foliate "                 => " blooming ",
        " folio "                   => " album ",
        " foliole "                 => " blade ",
        " folklore "                => " ballad ",
        " folkloric "               => " allegorical ",
        " folks "                   => " association ",
        " folksy "                  => " aloof ",
        " folktale "                => " adventure ",
        " follicle "                => " corpuscle ",
        " follow "                  => " chase ",
        " follow-up "               => " aftereffect ",
        " follower "                => " addict ",
        " following "               => " afterward ",
        " folly "                   => " absurdity ",
        " foment "                  => " abet ",
        " fomenter "                => " advocate ",
        " fond "                    => " addicted ",
        " fondling "                => " cuddle ",
        " fondly "                  => " affectionately ",
        " fondness "                => " affection ",
        " font "                    => " chantry ",
        " food "                    => " aliment ",
        " foodstuff "               => " aliment ",
        " foodstuffs "              => " food ",
        " fool-headed "             => " absurd ",
        " fooled "                  => " bamboozled ",
        " foolery "                 => " absurdity ",
        " foolhardiness "           => " carelessness ",
        " foolhardy "               => " adventuresome ",
        " fooling "                 => " bluffing ",
        " foolish "                 => " absurd ",
        " foolishly "               => " absurdly ",
        " foolishness "             => " absurdity ",
        " foot "                    => " bottom ",
        " footboy "                 => " attendant ",
        " footfall "                => " footfall ",
        " foothill "                => " acropolis ",
        " foothold "                => " ballast ",
        " footing "                 => " basement ",
        " footlet "                 => " cilia ",
        " footlicker "              => " adulator ",
        " footloose "               => " footloose ",
        " footnote "                => " comment ",
        " footpath "                => " aisle ",
        " footprint "               => " brand ",
        " footprints "              => " aisle ",
        " footslog "                => " clump ",
        " footslogger "             => " ambler ",
        " footstep "                => " clip ",
        " footstone "               => " cairn ",
        " footwear "                => " cossack ",
        " footwork "                => " able ",
        " foppery "                 => " amenity ",
        " foppish "                 => " chichi ",
        " forage "                  => " beat ",
        " forager "                 => " brigand ",
        " foramen "                 => " aperture ",
        " foray "                   => " attack ",
        " forbear "                 => " abstain ",
        " forbearance "             => " abstinence ",
        " forbearant "              => " amiable ",
        " forbears "                => " birth ",
        " forbidden "               => " banned ",
        " forbidding "              => " abhorrent ",
        " forced "                  => " affected ",
        " forceful "                => " bull ",
        " forcefully "              => " angrily ",
        " forcefulness "            => " bearing ",
        " forceless "               => " barren ",
        " forces "                  => " armament ",
        " forcible "                => " active ",
        " forcibleness "            => " ability ",
        " forcing "                 => " banishment ",
        " fore "                    => " ahead ",
        " forearm "                 => " acquaint ",
        " forebear "                => " antecedent ",
        " forebears "               => " ancestor ",
        " forebode "                => " augur ",
        " foreboding "              => " anxiety ",
        " forecast "                => " anticipation ",
        " forecaster "              => " diviner ",
        " foreclosed "              => " bankrupt ",
        " foredestined "            => " agreed ",
        " foredoomed "              => " accursed ",
        " forefather "              => " ancestor ",
        " forefathers "             => " antecedents ",
        " forefeel "                => " anticipate ",
        " forefront "               => " beginning ",
        " forego "                  => " abandon ",
        " foregoer "                => " antecedent ",
        " foregoing "               => " above ",
        " foreground "              => " beginning ",
        " forehandedness "          => " avarice ",
        " foreign "                 => " adopted ",
        " foreigner "               => " greenhorn ",
        " foreknow "                => " anticipate ",
        " foreknowledge "           => " acumen ",
        " forensic "                => " argumentative ",
        " foreordain "              => " destinate ",
        " foreordination "          => " afterlife ",
        " forepart "                => " beak ",
        " forerun "                 => " augur ",
        " forerunner "              => " advertiser ",
        " forerunners "             => " antecedents ",
        " forerunning "             => " above-mentioned ",
        " foresee "                 => " apprehend ",
        " foreseeable "             => " accountable ",
        " foreseeing "              => " apprehension ",
        " foreseen "                => " advancing ",
        " foreshadow "              => " adumbrate ",
        " foreshadowed "            => " adumbrated ",
        " foreshadowing "           => " anxiety ",
        " foreshow "                => " augur ",
        " foresight "               => " anticipation ",
        " foresighted "             => " accurate ",
        " forespeak "               => " adumbrate ",
        " forest "                  => " backwoods ",
        " forestall "               => " apprehend ",
        " forestalling "            => " arresting ",
        " forester "                => " forester ",
        " foresworn "               => " adulterine ",
        " foretaste "               => " ahead ",
        " foretell "                => " adumbrate ",
        " foretelling "             => " anticipation ",
        " forethought "             => " anticipation ",
        " forethoughtful "          => " alert ",
        " foretime "                => " bygone ",
        " foretoken "               => " auspice ",
        " forever "                 => " always ",
        " forevermore "             => " consistently ",
        " forewarn "                => " admonish ",
        " forewarning "             => " admonition ",
        " forewisdom "              => " anticipation ",
        " foreword "                => " exordium ",
        " forfeit "                 => " cost ",
        " forfeited "               => " absent ",
        " forfeiture "              => " damage ",
        " forfend "                 => " avert ",
        " forgather "               => " besiege ",
        " forge "                   => " coin ",
        " forged "                  => " artificial ",
        " forger "                  => " bastard ",
        " forgery "                 => " bogus ",
        " forget "                  => " balloon ",
        " forgetful "               => " absent ",
        " forgetfulness "           => " absent-mindedness ",
        " forgetive "               => " adroit ",
        " forgetting "              => " apathy ",
        " forging "                 => " accomplishment ",
        " forgive "                 => " absolve ",
        " forgiveness "             => " absolution ",
        " forgiving "               => " affectionate ",
        " forgo "                   => " abandon ",
        " forgoing "                => " abnegating ",
        " forgotten "               => " abandoned ",
        " fork "                    => " angle ",
        " forked "                  => " angled ",
        " forking "                 => " bifurcation ",
        " forlorn "                 => " abandoned ",
        " forlornness "             => " bareness ",
        " form "                    => " anatomy ",
        " formable "                => " adjustable ",
        " formal "                  => " academic ",
        " formalism "               => " ceremonial ",
        " formalist "               => " authoritarian ",
        " formalistic "             => " abstract ",
        " formality "               => " academism ",
        " formalization "           => " analogue ",
        " formalize "               => " ascertain ",
        " formalness "              => " acerbity ",
        " format "                  => " architecture ",
        " formation "               => " accumulation ",
        " formative "               => " determinative ",
        " formed "                  => " formed ",
        " former "                  => " above ",
        " formerly "                => " aforetime ",
        " formidable "              => " appalling ",
        " forming "                 => " basic ",
        " formless "                => " amorphous ",
        " formula "                 => " blueprint ",
        " formularization "         => " approach ",
        " formularized "            => " abstract ",
        " formulary "               => " blueprint ",
        " formulate "               => " codify ",
        " formulation "             => " conception ",
        " fornicate "               => " bang ",
        " fornication "             => " affair ",
        " forsake "                 => " abdicate ",
        " forsaking "               => " alienation ",
        " forswear "                => " abjure ",
        " forswearing "             => " abnegation ",
        " forsworn "                => " apostate ",
        " fort "                    => " acropolis ",
        " forte "                   => " ability ",
        " forth "                   => " alternating ",
        " forthcoming "             => " accessible ",
        " forthright "              => " aboveboard ",
        " forthrightly "            => " aboveboard ",
        " forthrightness "          => " artlessness ",
        " forthwith "               => " abruptly ",
        " fortification "           => " barricade ",
        " fortified "               => " adherent ",
        " fortifying "              => " animating ",
        " fortitude "               => " backbone ",
        " fortress "                => " breastwork ",
        " fortuitous "              => " accidental ",
        " fortuitously "            => " accidentally ",
        " fortuity "                => " adventure ",
        " fortunate "               => " advantageous ",
        " fortunately "             => " auspiciously ",
        " fortunateness "           => " accident ",
        " fortune "                 => " affluence ",
        " fortune-hunter "          => " charlatan ",
        " fortune-teller "          => " augur ",
        " fortune-telling "         => " abracadabra ",
        " fortuneteller "           => " augur ",
        " forty-five "              => " blaster ",
        " forum "                   => " appointment ",
        " forward "                 => " advanced ",
        " forward-looking "         => " advanced ",
        " forwardness "             => " assurance ",
        " forwards "                => " assiduously ",
        " fosse "                   => " arroyo ",
        " fossil "                  => " deposit ",
        " fossilize "               => " amalgamate ",
        " fossilized "              => " anachronistic ",
        " foster "                  => " advance ",
        " fosterage "               => " adopting ",
        " fostering "               => " adopting ",
        " foul "                    => " abhorrent ",
        " foul-mouthed "            => " base ",
        " foul-up "                 => " addle-brain ",
        " fouled "                  => " befuddled ",
        " fouled-up "               => " bedraggled ",
        " fouling "                 => " abuse ",
        " foulmouthed "             => " blue ",
        " foulness "                => " contagion ",
        " found "                   => " begin ",
        " foundational "            => " basal ",
        " foundationless "          => " bottomless ",
        " founder "                 => " architect ",
        " foundered "               => " ashore ",
        " foundling "               => " drop ",
        " foundry "                 => " branch ",
        " fount "                   => " bubbler ",
        " fountain "                => " bubbler ",
        " fountainhead "            => " antecedent ",
        " four-flush "              => " affect ",
        " four-flusher "            => " actor ",
        " four-lane "               => " artery ",
        " four-wheeler "            => " auto ",
        " fourberie "               => " artifice ",
        " foursome "                => " aggregation ",
        " foursquare "              => " boxlike ",
        " foxed "                   => " bamboozled ",
        " foxhole "                 => " arroyo ",
        " foxy "                    => " artful ",
        " foyer "                   => " antechamber ",
        " fracas "                  => " affray ",
        " fraction "                => " atom ",
        " fractional "              => " apportioned ",
        " fractionary "             => " apportioned ",
        " fractious "               => " awkward ",
        " fracturable "             => " brittle ",
        " fracture "                => " breach ",
        " fractured "               => " burst ",
        " fragile "                 => " brittle ",
        " fragility "               => " airiness ",
        " fragmentalize "           => " abrade ",
        " fragmentary "             => " bitty ",
        " fragmentation "           => " breach ",
        " fragmented "              => " burst ",
        " fragmentize "             => " abrade ",
        " fragments "               => " bits ",
        " fragrance "               => " aroma ",
        " fragrancy "               => " aroma ",
        " fragrant "                => " ambrosial ",
        " frail "                   => " breakable ",
        " frailness "               => " airiness ",
        " frailty "                 => " blemish ",
        " frame "                   => " anatomy ",
        " frame-up "                => " adjustment ",
        " framed "                  => " affected ",
        " framer "                  => " architect ",
        " franchise "               => " authorization ",
        " franchiser "              => " baron ",
        " frangible "               => " brittle ",
        " frank "                   => " aboveboard ",
        " frankincense "            => " aroma ",
        " frankly "                 => " bluntly ",
        " frankness "               => " artlessness ",
        " frantic "                 => " agitated ",
        " frantically "             => " aimlessly ",
        " fraternal "               => " congenial ",
        " fraternalism "            => " accord ",
        " fraternization "          => " accord ",
        " fraternize "              => " associate ",
        " fraternizer "             => " assistant ",
        " fraud "                   => " artifice ",
        " fraudulence "             => " ambidexterity ",
        " fraudulency "             => " bribery ",
        " fraudulent "              => " counterfeit ",
        " fraught "                 => " abounding ",
        " fray "                    => " affray ",
        " frazzle "                 => " exhaust ",
        " frazzled "                => " beat ",
        " freak "                   => " aberration ",
        " freaked "                 => " cool ",
        " freakish "                => " aberrant ",
        " freakishness "            => " aberration ",
        " freaky "                  => " cool ",
        " freckle "                 => " blemish ",
        " freckled "                => " brindle ",
        " free "                    => " chargeless ",
        " free-for-all "            => " affray ",
        " free-living "             => " abandonment ",
        " free-minded "             => " blithe ",
        " free-spirited "           => " able ",
        " free-spiritedness "       => " carelessness ",
        " free-thinking "           => " advanced ",
        " free-wheeling "           => " able ",
        " free-willed "             => " autonomous ",
        " freebie "                 => " chargeless ",
        " freedom "                 => " abandon ",
        " freehold "                => " acreage ",
        " freeholder "              => " freeholder ",
        " freeing "                 => " absolution ",
        " freelancer "              => " contributor ",
        " freeload "                => " batter ",
        " freely "                  => " advisedly ",
        " freeman "                 => " aborigine ",
        " freemartin "              => " dogie ",
        " freestyle "               => " bathe ",
        " freethinker "             => " doubter ",
        " freethinking "            => " agnostic ",
        " freeway "                 => " freeway ",
        " freewill "                => " contributed ",
        " freeze "                  => " benumb ",
        " freeze-dry "              => " anhydrate ",
        " freight "                 => " bales ",
        " freightage "              => " carriage ",
        " freighting "              => " commitment ",
        " frenetic "                => " corybantic ",
        " frenzied "                => " agitated ",
        " frenziedly "              => " berserk ",
        " frenzy "                  => " aberration ",
        " frequency "               => " abundance ",
        " frequent "                => " common ",
        " frequenter "              => " bedfellow ",
        " frequenting "             => " acquaintance ",
        " frequentness "            => " abundance ",
        " fresco "                  => " adorn ",
        " fresh "                   => " beginning ",
        " freshen "                 => " activate ",
        " freshened "               => " active ",
        " freshening "              => " awakening ",
        " freshet "                 => " deluge ",
        " freshie "                 => " amateur ",
        " freshly "                 => " afresh ",
        " freshman "                => " apprentice ",
        " freshness "               => " bloom ",
        " fret "                    => " affront ",
        " fretful "                 => " captious ",
        " fretfulness "             => " all-overs ",
        " fretted "                 => " ashen ",
        " fretting "                => " annoyed ",
        " fretwork "                => " applique ",
        " friable "                 => " brittle ",
        " friar "                   => " abbot ",
        " friary "                  => " abbey ",
        " fribble "                 => " best-dressed ",
        " fricassee "               => " bake ",
        " fricative "               => " affricate ",
        " friction "                => " abrasion ",
        " frictionless "            => " bland ",
        " fried "                   => " absurd ",
        " friend "                  => " acquaintance ",
        " friendless "              => " abandoned ",
        " friendliness "            => " affability ",
        " friendly "                => " affable ",
        " friends "                 => " accompany ",
        " friendship "              => " accord ",
        " fries "                   => " chips ",
        " fright "                  => " alarm ",
        " frighten "                => " affright ",
        " frightened "              => " abashed ",
        " frightening "             => " alarming ",
        " frighteningly "           => " angrily ",
        " frightful "               => " alarming ",
        " frightfully "             => " awfully ",
        " frigidity "               => " abstention ",
        " frill "                   => " amenity ",
        " frills "                  => " basic ",
        " frilly "                  => " adorned ",
        " fringe "                  => " binding ",
        " fringed "                 => " belted ",
        " fringes "                 => " bound ",
        " frippery "                => " adornment ",
        " frisk "                   => " bounce ",
        " friskiness "              => " abandon ",
        " frisking "                => " coursing ",
        " frisky "                  => " active ",
        " frith "                   => " anchorage ",
        " fritter "                 => " blow ",
        " frittering "              => " dabbling ",
        " frivol "                  => " caress ",
        " frivolity "               => " childishness ",
        " frivolling "              => " dabbling ",
        " frivolous "               => " barmy ",
        " frivolously "             => " agilely ",
        " frivolousness "           => " childishness ",
        " frizz "                   => " coil ",
        " frizzed "                 => " coiled ",
        " frizzies "                => " beard ",
        " frizzled "                => " coiled ",
        " frizzy "                  => " coiled ",
        " frock "                   => " apron ",
        " frolic "                  => " antic ",
        " frolicsome "              => " antic ",
        " frolicsomeness "          => " atrocity ",
        " frond "                   => " blade ",
        " frondescence "            => " frondescence ",
        " frons "                   => " countenance ",
        " front "                   => " advanced ",
        " front-runner "            => " beloved ",
        " frontal "                 => " aboveboard ",
        " frontier "                => " borderland ",
        " fronting "                => " against ",
        " frore "                   => " algid ",
        " frosh "                   => " apprentice ",
        " frostbite "               => " algidity ",
        " frostburn "               => " abrasion ",
        " frosted "                 => " arctic ",
        " frostiness "              => " algidity ",
        " frosty "                  => " chill ",
        " froth "                   => " barm ",
        " frothing "                => " bubbles ",
        " frothy "                  => " bubbling ",
        " frou-frou "               => " adorned ",
        " froufrou "                => " adornment ",
        " froward "                 => " adverse ",
        " frowning "                => " afflictive ",
        " frozen "                  => " arctic ",
        " frozenness "              => " algidity ",
        " fructiferous "            => " breeding ",
        " fructification "          => " assembly ",
        " fructify "                => " beget ",
        " fructifying "             => " bearing ",
        " frugality "               => " avarice ",
        " fruit "                   => " bake-apple ",
        " fruitful "                => " abounding ",
        " fruitfulness "            => " abundance ",
        " fruition "                => " accomplishment ",
        " fruitless "               => " abortive ",
        " frump "                   => " bother ",
        " frumpy "                  => " antiquated ",
        " frustrate "               => " annul ",
        " frustrated "              => " balked ",
        " frustrating "             => " arresting ",
        " frustration "             => " annoyance ",
        " fuchsia "                 => " blush ",
        " fuddle "                  => " abash ",
        " fuddled "                 => " ashamed ",
        " fuddy-duddy "             => " dotard ",
        " fudge "                   => " avoid ",
        " fudging "                 => " artifice ",
        " fuel "                    => " ammunition ",
        " fugacious "               => " ambiguous ",
        " fugitive "                => " avoiding ",
        " fugue "                   => " beat ",
        " fulcrum "                 => " blueprint ",
        " fulfill "                 => " accomplish ",
        " fulfilled "               => " accomplished ",
        " fulfilling "              => " accomplishing ",
        " fulfillment "             => " accomplishment ",
        " fulgent "                 => " bright ",
        " fulgid "                  => " ablaze ",
        " fulgor "                  => " aurora ",
        " fulgurate "               => " beam ",
        " fuliginous "              => " bleared ",
        " full "                    => " abounding ",
        " full-blooded "            => " ablaze ",
        " full-blown "              => " absolute ",
        " full-bodied "             => " concentrated ",
        " full-bosomed "            => " ample ",
        " full-figured "            => " ample ",
        " full-flavored "           => " concentrated ",
        " full-grown "              => " adult ",
        " full-length "             => " feature ",
        " full-out "                => " all-encompassing ",
        " full-scale "              => " all-encompassing ",
        " full-toned "              => " bass ",
        " fullness "                => " adequateness ",
        " fully "                   => " absolutely ",
        " fulminant "               => " atomic ",
        " fulminate "               => " animadvert ",
        " fulminating "             => " atomic ",
        " fulmination "             => " blast ",
        " fulsome "                 => " adulatory ",
        " fulsomeness "             => " balance ",
        " fumble "                  => " bollix ",
        " fumbler "                 => " addle-brain ",
        " fumbling "                => " averseness ",
        " fume "                    => " anger ",
        " fumes "                   => " effluvium ",
        " fumigant "                => " abrasive ",
        " fumigate "                => " antisepticize ",
        " fuming "                  => " angry ",
        " fumy "                    => " bleared ",
        " fun-loving "              => " alert ",
        " funambulist "             => " aerialist ",
        " function "                => " action ",
        " functional "              => " anatomic ",
        " functionary "             => " abettor ",
        " functioning "             => " activity ",
        " fund "                    => " armamentarium ",
        " fundament "               => " backside ",
        " fundamental "             => " axiological ",
        " funded "                  => " adjourned ",
        " funding "                 => " allotment ",
        " funeral "                 => " burial ",
        " funeration "              => " burial ",
        " funereal "                => " black ",
        " funfair "                 => " carnival ",
        " fungible "                => " changeable ",
        " fungus "                  => " bane ",
        " funk "                    => " alarm ",
        " funky "                   => " blue ",
        " funnel "                  => " carry ",
        " funnel-shaped "           => " cone-shaped ",
        " funniness "               => " ball ",
        " funnyman "                => " antic ",
        " furbelow "                => " adornment ",
        " furbish "                 => " brighten ",
        " furbishing "              => " accessory ",
        " furcate "                 => " bifurcate ",
        " furcated "                => " angled ",
        " furibund "                => " corybantic ",
        " furious "                 => " bent ",
        " furiously "               => " angrily ",
        " furl "                    => " adhere ",
        " furnace "                 => " boiler ",
        " furnish "                 => " accouter ",
        " furnishing "              => " capacity ",
        " furnishings "             => " accoutrement ",
        " furnishments "            => " furnishings ",
        " furniture "               => " appliance ",
        " furrow "                  => " channel ",
        " furrowed "                => " channelled ",
        " furry "                   => " bristling ",
        " further "                 => " added ",
        " furtherance "             => " advocacy ",
        " furthermore "             => " along ",
        " furthermost "             => " far-off ",
        " furthest "                => " extreme ",
        " furtive "                 => " artful ",
        " furtiveness "             => " artifice ",
        " furuncle "                => " abscess ",
        " fury "                    => " acerbity ",
        " furze "                   => " brier ",
        " fuse "                    => " agglutinate ",
        " fused "                   => " alloyed ",
        " fuselage "                => " assembly ",
        " fusible "                 => " aqueous ",
        " fusillade "               => " battery ",
        " fusion "                  => " admixture ",
        " fussbudgety "             => " captious ",
        " fussed "                  => " agitated ",
        " fussiness "               => " adornment ",
        " fusspot "                 => " dotard ",
        " fussy "                   => " careful ",
        " fustian "                 => " aureate ",
        " fustigate "               => " bash ",
        " fusty "                   => " aged ",
        " futile "                  => " abortive ",
        " futon "                   => " daybed ",
        " future "                  => " approaching ",
        " futuristic "              => " affected ",
        " fuzz "                    => " down ",
        " fuzzy "                   => " down-covered ",
        " gabardine "               => " capote ",
        " gabble "                  => " blubbering ",
        " gabbling "                => " articulate ",
        " gabby "                   => " chattering ",
        " gadabout "                => " bawdy ",
        " gadget "                  => " apparatus ",
        " gadgets "                 => " accessories ",
        " gaff "                    => " accoutrement ",
        " gaffe "                   => " bloomer ",
        " gaffed "                  => " able ",
        " gaffer "                  => " ancestor ",
        " gaga "                    => " arbitrary ",
        " gage "                    => " cuff ",
        " gaggle "                  => " army ",
        " gagman "                  => " antic ",
        " gagster "                 => " artist ",
        " gaiety "                  => " animation ",
        " gaily "                   => " blithely ",
        " gain "                    => " accretion ",
        " gained "                  => " acquired ",
        " gainful "                 => " advantageous ",
        " gainfully "               => " active ",
        " gaining "                 => " accepting ",
        " gainless "                => " abortive ",
        " gains "                   => " assets ",
        " gainsay "                 => " combat ",
        " gainsaying "              => " bucking ",
        " gait "                    => " amble ",
        " gala "                    => " bright ",
        " gall "                    => " acrimony ",
        " gallant "                 => " attentive ",
        " gallantness "             => " address ",
        " gallantry "               => " address ",
        " galled "                  => " affronted ",
        " galleria "                => " bazaar ",
        " gallery "                 => " arcade ",
        " galleys "                 => " abuse ",
        " gallimaufry "             => " assortment ",
        " galling "                 => " afflictive ",
        " gallivanter "             => " adventurer ",
        " gallop "                  => " amble ",
        " gally "                   => " cheeky ",
        " galoot "                  => " bad-mannered ",
        " galore "                  => " abounding ",
        " galoshes "                => " cossack ",
        " galumph "                 => " barge ",
        " galumphing "              => " bulky ",
        " galvanic "                => " active ",
        " galvanize "               => " animate ",
        " gambit "                  => " artifice ",
        " gamble "                  => " action ",
        " gambler "                 => " charlatan ",
        " gambling "                => " bank ",
        " gambol "                  => " bound ",
        " game "                    => " bold ",
        " gamekeeper "              => " administrator ",
        " gameness "                => " adventuresomeness ",
        " games "                   => " amateur ",
        " gamesome "                => " active ",
        " gamin "                   => " buck ",
        " gamut "                   => " area ",
        " gander "                  => " ankle ",
        " gang "                    => " assemblage ",
        " gangling "                => " awkward ",
        " gangly "                  => " angular ",
        " gangplank "               => " arch ",
        " gangrene "                => " adulteration ",
        " gangrenous "              => " addle ",
        " gangster "                => " bandit ",
        " gangsters "               => " abyss ",
        " gape "                    => " beam ",
        " gaper "                   => " eyewitness ",
        " gaping "                  => " broad ",
        " garage "                  => " barn ",
        " garb "                    => " apparel ",
        " garbage "                 => " debris ",
        " garble "                  => " belie ",
        " garbled "                 => " broken ",
        " garden-variety "          => " boilerplate ",
        " gardener "                => " agriculturalist ",
        " gardening "               => " agronomical ",
        " gardens "                 => " area ",
        " gargle "                  => " irrigate ",
        " gargoyle "                => " barbarian ",
        " garish "                  => " blatant ",
        " garishness "              => " affectation ",
        " garland "                 => " album ",
        " garment "                 => " apparel ",
        " garments "                => " apparel ",
        " garner "                  => " accumulate ",
        " garnering "               => " accumulation ",
        " garnet "                  => " bittersweet ",
        " garnish "                 => " adornment ",
        " garnished "               => " busy ",
        " garnishing "              => " adornment ",
        " garniture "               => " applique ",
        " garret "                  => " attic ",
        " garrison "                => " billet ",
        " garrote "                 => " asphyxiate ",
        " garrotte "                => " asphyxiate ",
        " gars "                    => " bloke ",
        " garter "                  => " accolade ",
        " gasconade "               => " avowal ",
        " gaseous "                 => " aerial ",
        " gash "                    => " cleft ",
        " gashed "                  => " broken ",
        " gasolier "                => " candelabrum ",
        " gasp "                    => " blow ",
        " gasping "                 => " asthmatic ",
        " gassed "                  => " bashed ",
        " gassing "                 => " beheading ",
        " gassy "                   => " baroque ",
        " gastric "                 => " belly ",
        " gastronome "              => " aficionado ",
        " gastronomist "            => " aficionado ",
        " gate "                    => " aboideau ",
        " gate-crasher "            => " alien ",
        " gatehouse "               => " abode ",
        " gatekeeper "              => " attendant ",
        " gateway "                 => " aperture ",
        " gather "                  => " accumulate ",
        " gathered "                => " aggregate ",
        " gathering "               => " acquisition ",
        " gaucherie "               => " blooper ",
        " gaudiness "               => " adornment ",
        " gaudy "                   => " blatant ",
        " gauge "                   => " barometer ",
        " gaugeable "               => " assessable ",
        " gauging "                 => " appraisal ",
        " gaunt "                   => " angular ",
        " gauze "                   => " cast ",
        " gauzy "                   => " delicate ",
        " gawk "                    => " bore ",
        " gawker "                  => " attestant ",
        " gawkiness "               => " amateurishness ",
        " gawky "                   => " awkward ",
        " gayness "                 => " abandon ",
        " gaze "                    => " boring ",
        " gazette "                 => " archive ",
        " gazetteer "               => " archive ",
        " gear "                    => " accessory ",
        " gears "                   => " apparatus ",
        " geek "                    => " beatnik ",
        " geeky "                   => " aberrant ",
        " gelastic "                => " absurd ",
        " gelate "                  => " clabber ",
        " gelatinate "              => " benumb ",
        " gelatination "            => " agglomeration ",
        " gelatinize "              => " clabber ",
        " gelatinous "              => " gelled ",
        " geld "                    => " castrate ",
        " gelid "                   => " chill ",
        " gelidity "                => " bite ",
        " gelidness "               => " algidity ",
        " gelled "                  => " gelled ",
        " geminate "                => " bifold ",
        " gendarme "                => " badge ",
        " genealogical "            => " affiliated ",
        " genealogy "               => " ancestry ",
        " general "                 => " accepted ",
        " generalized "             => " ambiguous ",
        " generally "               => " about ",
        " generalship "             => " approach ",
        " generate "                => " accomplish ",
        " generating "              => " breeding ",
        " generation "              => " bearing ",
        " generations "             => " ancestors ",
        " generative "              => " abundant ",
        " generator "               => " architect ",
        " generic "                 => " all-encompassing ",
        " generous "                => " acceptable ",
        " generously "              => " abundantly ",
        " genesiological "          => " abiogenetic ",
        " genesiology "             => " ancestry ",
        " genesis "                 => " alpha ",
        " genetic "                 => " abiogenetic ",
        " genetics "                => " analysis ",
        " genial "                  => " affable ",
        " geniality "               => " affability ",
        " genially "                => " affably ",
        " genie "                   => " bogie ",
        " genital "                 => " animal ",
        " genitalia "               => " ballocks ",
        " genitive "                => " animal ",
        " genius "                  => " ability ",
        " genre "                   => " brand ",
        " gentile "                 => " agnostic ",
        " gentility "               => " aristocracy ",
        " gentle "                  => " affable ",
        " gentlefolk "              => " aristocracy ",
        " gentleman "               => " admirer ",
        " gentlemanlike "           => " benevolent ",
        " gentlemanliness "         => " courage ",
        " gentlemanly "             => " civil ",
        " gentleness "              => " charity ",
        " gentleperson "            => " blueblood ",
        " gentlewoman "             => " amazon ",
        " gently "                  => " acclaim ",
        " gentry "                  => " elite ",
        " genuflection "            => " angle ",
        " genuine "                 => " 18-carat ",
        " genuinely "               => " absolutely ",
        " genuineness "             => " actuality ",
        " genus "                   => " brand ",
        " geographical "            => " bounded ",
        " geography "               => " cartography ",
        " geology "                 => " cartography ",
        " geopolitics "             => " cartography ",
        " geoponics "               => " agriculture ",
        " geotic "                  => " alluvial ",
        " geranium "                => " bittersweet ",
        " gerent "                  => " baron ",
        " geriatric "               => " aged ",
        " geriatrics "              => " elderliness ",
        " germ "                    => " antibody ",
        " germ-destroying "         => " antibacterial ",
        " germ-free "               => " antibacterial ",
        " germaneness "             => " appliance ",
        " germicidal "              => " antibacterial ",
        " germicide "               => " bactericide ",
        " germinal "                => " beginning ",
        " germinating "             => " beginning ",
        " germination "             => " formation ",
        " germs "                   => " bacilli ",
        " gestating "               => " abundant ",
        " gestation "               => " evolution ",
        " gesticulate "             => " allure ",
        " gesticulation "           => " action ",
        " gesture "                 => " action ",
        " get-together "            => " accumulation ",
        " get-up "                  => " accouterment ",
        " get-up-and-go "           => " action ",
        " getable "                 => " attainable ",
        " getalong "                => " amble ",
        " getaway "                 => " break ",
        " gettable "                => " accessible ",
        " getting "                 => " accepting ",
        " getup "                   => " accoutrement ",
        " gewgaw "                  => " amenity ",
        " gewgaws "                 => " applique ",
        " geyser "                  => " bubbler ",
        " ghastly "                 => " abhorrent ",
        " ghost "                   => " apparition ",
        " ghostlike "               => " apparitional ",
        " ghostly "                 => " apparitional ",
        " ghostwrite "              => " author ",
        " ghostwriter "             => " columnist ",
        " ghoulish "                => " awful ",
        " giant "                   => " behemothic ",
        " gibber "                  => " blab ",
        " gibbet "                  => " asphyxiate ",
        " gibbosity "               => " appendage ",
        " gibbous "                 => " arched ",
        " gibe "                    => " brickbat ",
        " giddiness "               => " airheadedness ",
        " giddy "                   => " bemused ",
        " gift "                    => " allowance ",
        " gift-wrap "               => " clean ",
        " gifted "                  => " able ",
        " gifting "                 => " alms ",
        " gifts "                   => " ability ",
        " giggle "                  => " cackle ",
        " giggling "                => " amusement ",
        " gild "                    => " adorn ",
        " gilding "                 => " beautification ",
        " gills "                   => " aspect ",
        " gilly "                   => " bazaar ",
        " gilt "                    => " bizarre ",
        " gilt-edged "              => " aristocratic ",
        " gimcrack "                => " accoutrement ",
        " gimcracks "               => " applique ",
        " gimlet "                  => " auger ",
        " gimme "                   => " bear ",
        " gimmicky "                => " contemporary ",
        " gimp "                    => " bedridden ",
        " gimpy "                   => " bedridden ",
        " ginger "                  => " amber ",
        " gingerbread "             => " applique ",
        " gingerly "                => " calculating ",
        " gingery "                 => " animated ",
        " gird "                    => " band ",
        " girder "                  => " axle ",
        " girdled "                 => " belted ",
        " girl "                    => " babe ",
        " girlfriend "              => " adherent ",
        " girlhood "                => " boyhood ",
        " girlish "                 => " boyish ",
        " girllike "                => " adolescent ",
        " girly "                   => " changeable ",
        " girth "                   => " ambit ",
        " gist "                    => " basis ",
        " give "                    => " accord ",
        " give-and-take "           => " banter ",
        " giveaway "                => " betrayal ",
        " giveback "                => " acknowledgment ",
        " given "                   => " accustomed ",
        " gizmo "                   => " accoutrement ",
        " glabrate "                => " baldheaded ",
        " glabrescent "             => " baldheaded ",
        " glabrous "                => " baldheaded ",
        " glace "                   => " bright ",
        " glacial "                 => " arctic ",
        " glaciate "                => " benumb ",
        " glaciation "              => " algidity ",
        " glacier "                 => " berg ",
        " glad "                    => " animated ",
        " glad-hander "             => " back-slapping ",
        " gladden "                 => " charm ",
        " gladdened "               => " captivated ",
        " gladdening "              => " action ",
        " glade "                   => " allowance ",
        " gladiatorial "            => " antagonistic ",
        " gladly "                  => " acquiescently ",
        " gladness "                => " animation ",
        " gladsome "                => " animated ",
        " glamorize "               => " adorn ",
        " glamorous "               => " alluring ",
        " glamour "                 => " allure ",
        " glancing "                => " casual ",
        " glare "                   => " blaze ",
        " glaring "                 => " audacious ",
        " glaringly "               => " abundantly ",
        " glass "                   => " bottle ",
        " glassy "                  => " burnished ",
        " glassy-eyed "             => " abashed ",
        " glaum "                   => " catch ",
        " glaze "                   => " coat ",
        " glazed "                  => " anesthetized ",
        " glazing "                 => " ceramics ",
        " glazy "                   => " burnished ",
        " gleam "                   => " beam ",
        " gleaming "                => " aflame ",
        " glean "                   => " accumulate ",
        " gleaner "                 => " agriculturalist ",
        " gleanings "               => " accumulation ",
        " glebe "                   => " alluvium ",
        " glee "                    => " blitheness ",
        " gleeful "                 => " blithe ",
        " gleefully "               => " blithely ",
        " glen "                    => " coulee ",
        " glibness "                => " affectation ",
        " glide "                   => " coast ",
        " glim "                    => " catch ",
        " glimmer "                 => " blink ",
        " glimmering "              => " adumbration ",
        " glinting "                => " bright ",
        " glissade "                => " coast ",
        " glisten "                 => " coruscate ",
        " glistening "              => " bright ",
        " glitch "                  => " annihilate ",
        " glitched "                => " awry ",
        " glitter "                 => " beam ",
        " glitterati "              => " aristocracy ",
        " glittering "              => " bright ",
        " glittery "                => " blatant ",
        " glitz "                   => " amaze ",
        " glitzy "                  => " arrant ",
        " gloaming "                => " dark ",
        " gloat "                   => " celebrate ",
        " gloating "                => " crowing ",
        " glob "                    => " block ",
        " global "                  => " all-around ",
        " globby "                  => " adhesive ",
        " globe "                   => " apple ",
        " globe-trotter "           => " adventurer ",
        " globe-trotting "          => " drifting ",
        " globetrotter "            => " charlatan ",
        " globetrotting "           => " biking ",
        " globose "                 => " annular ",
        " globular "                => " annular ",
        " globule "                 => " apple ",
        " glockenspiel "            => " angelus ",
        " gloom "                   => " anguish ",
        " gloominess "              => " dejection ",
        " gloomy "                  => " black ",
        " glop "                    => " coalesce ",
        " gloppy "                  => " buttery ",
        " glorification "           => " account ",
        " glorified "               => " adored ",
        " glorify "                 => " acclaim ",
        " glorious "                => " august ",
        " gloriously "              => " advantageously ",
        " glory "                   => " celebrity ",
        " gloss "                   => " appearance ",
        " glossary "                => " comment ",
        " glossiness "              => " appearance ",
        " glossy "                  => " bright ",
        " glottal "                 => " glottal ",
        " glove "                   => " cuff ",
        " glow "                    => " afterglow ",
        " glowering "               => " austere ",
        " glowing "                 => " aglow ",
        " glowingly "               => " blithely ",
        " gloze "                   => " babble ",
        " glue "                    => " cement ",
        " glue-like "               => " adhesive ",
        " glued "                   => " alert ",
        " gluey "                   => " gelled ",
        " glum "                    => " dejected ",
        " glume "                   => " bark ",
        " glumness "                => " dejection ",
        " glut "                    => " excess ",
        " glutinous "               => " adhering ",
        " glutted "                 => " apathetic ",
        " glutton "                 => " crammer ",
        " gluttonous "              => " abominable ",
        " gluttony "                => " appetence ",
        " gnarled "                 => " bent ",
        " gnarr "                   => " bark ",
        " gnaw "                    => " champ ",
        " gnomic "                  => " adage ",
        " gnostic "                 => " acute ",
        " go-ahead "                => " ambitious ",
        " go-between "              => " agent ",
        " go-by "                   => " bounce ",
        " go-cart "                 => " auto ",
        " go-down "                 => " aftereffect ",
        " go-getter "               => " activating ",
        " go-getting "              => " activating ",
        " go-go "                   => " acquainted ",
        " go-with-the-flow "        => " adaptable ",
        " goad "                    => " catalyst ",
        " goading "                 => " admonition ",
        " goal "                    => " ambition ",
        " goal-oriented "           => " aggressive ",
        " goalless "                => " aimless ",
        " goat "                    => " dupe ",
        " goatee "                  => " bristles ",
        " goateed "                 => " barbate ",
        " gobbet "                  => " break ",
        " gobble "                  => " bolt ",
        " gobbledegook "            => " abracadabra ",
        " gobbler "                 => " crammer ",
        " gobbling "                => " acquisitive ",
        " goblet "                  => " beaker ",
        " gobs "                    => " endless ",
        " god-awful "               => " awful ",
        " godfather "               => " asperse ",
        " godhead "                 => " celestial ",
        " godless "                 => " agnostic ",
        " godlike "                 => " angelic ",
        " godsend "                 => " advantage ",
        " gofer "                   => " abettor ",
        " goggle "                  => " beam ",
        " going "                   => " activity ",
        " going-over "              => " castigation ",
        " goings-on "               => " affaire ",
        " golden "                  => " aureate ",
        " golden-haired "           => " albino ",
        " gonfalon "                => " banderole ",
        " gonzo "                   => " abashed ",
        " good "                    => " acceptable ",
        " good-fellowship "         => " brotherhood ",
        " good-hearted "            => " amiable ",
        " good-humored "            => " affable ",
        " good-humoredly "          => " affably ",
        " good-looking "            => " attractive ",
        " good-natured "            => " acquiescent ",
        " good-naturedly "          => " affably ",
        " good-sized "              => " apparent ",
        " good-tasting "            => " acceptable ",
        " good-tempered "           => " accommodating ",
        " goodhearted "             => " accommodating ",
        " goodie "                  => " admirable ",
        " goodies "                 => " aliment ",
        " goodly "                  => " apparent ",
        " goodness "                => " advantage ",
        " goods "                   => " appurtenances ",
        " goodwill "                => " amicableness ",
        " goody "                   => " benefit ",
        " goody-goody "             => " adherent ",
        " gooey "                   => " adhesive ",
        " goof "                    => " fail ",
        " goof-up "                 => " blooper ",
        " goofball "                => " addle-brain ",
        " goofed "                  => " amiss ",
        " goofus "                  => " absurd ",
        " goofy "                   => " cool ",
        " googol "                  => " cardinal ",
        " gook "                    => " clay ",
        " gooky "                   => " corrective ",
        " goombah "                 => " accompaniment ",
        " goon "                    => " aggressor ",
        " goony "                   => " aberrant ",
        " goop "                    => " broth ",
        " goopy "                   => " buttery ",
        " goosy "                   => " bad-tempered ",
        " gopher "                  => " bagman ",
        " gordian "                 => " clear ",
        " gore "                    => " claret ",
        " gorged "                  => " chock-full ",
        " gorgeous "                => " attractive ",
        " gorgeously "              => " alluringly ",
        " gorgeousness "            => " brightness ",
        " gorger "                  => " crammer ",
        " gorging "                 => " avid ",
        " gorilla "                 => " apache ",
        " gorked "                  => " cold ",
        " gorm "                    => " belt ",
        " gormandize "              => " absorb ",
        " gormandizer "             => " crammer ",
        " gormandizing "            => " acquisitiveness ",
        " gorp "                    => " bite ",
        " gorse "                   => " brier ",
        " gory "                    => " bleeding ",
        " gospel "                  => " actuality ",
        " gossamer "                => " airy ",
        " gossameriness "           => " airiness ",
        " gossamery "               => " aerial ",
        " gossip "                  => " account ",
        " gossiped "                => " accounted ",
        " gossiping "               => " chattering ",
        " gossipmonger "            => " babbler ",
        " gossipy "                 => " communicative ",
        " gotcha "                  => " antic ",
        " gotchie "                 => " antic ",
        " gouge "                   => " burrow ",
        " gouger "                  => " absconder ",
        " goulash "                 => " goulash ",
        " gourd "                   => " alembic ",
        " gourmand "                => " aficionado ",
        " gourmandizing "           => " gluttonous ",
        " govern "                  => " administer ",
        " governable "              => " accommodating ",
        " governance "              => " babyminding ",
        " governed "                => " absolute ",
        " governess "               => " babysitter ",
        " governing "               => " administering ",
        " governmental "            => " authoritative ",
        " gown "                    => " clothes ",
        " grabbed "                 => " affective ",
        " grabber "                 => " affliction ",
        " grabbiness "              => " avidity ",
        " grabbing "                => " avaricious ",
        " grabble "                 => " bollix ",
        " grabby "                  => " avaricious ",
        " grace "                   => " adroitness ",
        " graceful "                => " adroit ",
        " gracefully "              => " alluringly ",
        " gracefulness "            => " breeding ",
        " graceless "               => " awkward ",
        " gracelessness "           => " amateurishness ",
        " gracious "                => " accommodating ",
        " graciously "              => " affably ",
        " graciousness "            => " address ",
        " grad "                    => " alum ",
        " gradation "               => " arrangement ",
        " grade "                   => " brand ",
        " gradient "                => " acclivity ",
        " grading "                 => " allocation ",
        " gradual "                 => " bit-by-bit ",
        " graduand "                => " apprentice ",
        " graduate "                => " alum ",
        " graduated "               => " accelerating ",
        " graduating "              => " admission ",
        " graft "                   => " affix ",
        " grafter "                 => " bastard ",
        " grail "                   => " beaker ",
        " grain "                   => " atom ",
        " grainy "                  => " chapped ",
        " gramercy "                => " acknowledgment ",
        " grand "                   => " admirable ",
        " grander "                 => " above ",
        " grandeur "                => " amplitude ",
        " grandfather "             => " grandfathering ",
        " grandiloquence "          => " avowal ",
        " grandiloquent "           => " aureate ",
        " grandiose "               => " affected ",
        " grandiosity "             => " blowing ",
        " grandly "                 => " abundantly ",
        " grandstand "              => " alarm ",
        " grandstanding "           => " blowhard ",
        " grange "                  => " acreage ",
        " grant "                   => " admission ",
        " granted "                 => " accepted ",
        " grantee "                 => " almsman ",
        " granting "                => " acceding ",
        " granular "                => " diminutive ",
        " granulate "               => " comminute ",
        " granule "                 => " atom ",
        " grapevine "               => " comment ",
        " graph "                   => " blueprint ",
        " graphic "                 => " clear ",
        " graphics "                => " cartoon ",
        " grapnel "                 => " ballast ",
        " grapple "                 => " attack ",
        " grappler "                => " barb ",
        " grasp "                   => " butt ",
        " graspable "               => " apprehensible ",
        " grasping "                => " acquisitive ",
        " graspingness "            => " acquisitiveness ",
        " grassland "               => " acreage ",
        " grassplot "               => " common ",
        " grassy "                  => " blooming ",
        " grate "                   => " abrade ",
        " grateful "                => " beholden ",
        " gratefully "              => " acquiescently ",
        " gratefulness "            => " affability ",
        " gratification "           => " delight ",
        " gratified "               => " adequate ",
        " gratify "                 => " appease ",
        " gratifying "              => " acceptable ",
        " grating "                 => " annoying ",
        " gratis "                  => " chargeless ",
        " gratitude "               => " acknowledgment ",
        " gratuitous "              => " chargeless ",
        " gratuitously "            => " chargeless ",
        " gratuity "                => " alms ",
        " gravamen "                => " assembly ",
        " gravel "                  => " alluvium ",
        " gravelly "                => " abrasive ",
        " gravely "                 => " acutely ",
        " gravestone "              => " cairn ",
        " gravid "                  => " alert ",
        " gravidity "               => " abundance ",
        " gravitate "               => " approach ",
        " gravitating "             => " bottomward ",
        " gravitation "             => " allure ",
        " gravity "                 => " force ",
        " gray-haired "             => " aging ",
        " graybeard "               => " ancestor ",
        " grayout "                 => " blackout ",
        " graze "                   => " abrade ",
        " grazed "                  => " aching ",
        " grazer "                  => " agriculturalist ",
        " grazing "                 => " agriculture ",
        " greased "                 => " anointed ",
        " greasepaint "             => " blackface ",
        " greasy "                  => " anointed ",
        " great "                   => " abundant ",
        " great-hearted "           => " benevolent ",
        " greatcoat "               => " cape ",
        " greathearted "            => " altruistic ",
        " greatly "                 => " abundantly ",
        " greatness "               => " abundance ",
        " greed "                   => " acquisitiveness ",
        " greediness "              => " avidity ",
        " greedy "                  => " acquisitive ",
        " greedy-gut "              => " crammer ",
        " green "                   => " blooming ",
        " green-eyed "              => " envy ",
        " greenbacks "              => " cash ",
        " greengrocery "            => " aftermath ",
        " greenhorn "               => " amateur ",
        " greenish-yellow "         => " anemic ",
        " greenness "               => " boyhood ",
        " greeny "                  => " butt ",
        " greet "                   => " accost ",
        " gregarious "              => " affable ",
        " gregariousness "          => " brotherhood ",
        " gremlin "                 => " abecedarian ",
        " gremlins "                => " abnormal ",
        " grenade "                 => " armament ",
        " grey "                    => " blah ",
        " greyish "                 => " ashen ",
        " grid "                    => " filigree ",
        " griddle "                 => " battercake ",
        " griddlecake "             => " battercake ",
        " gridiron "                => " amphitheatre ",
        " gridlocked "              => " chock-full ",
        " grief "                   => " affliction ",
        " grief-stricken "          => " crestfallen ",
        " grievance "               => " affliction ",
        " grieve "                  => " ache ",
        " grieved "                 => " afflicted ",
        " grieving "                => " afflicted ",
        " grievous "                => " afflicting ",
        " griffonage "              => " autography ",
        " grift "                   => " acumen ",
        " grill "                   => " barbecue ",
        " grilled "                 => " broiled ",
        " grilling "                => " assay ",
        " grillwork "               => " arrangement ",
        " grim "                    => " austere ",
        " grimace "                 => " face ",
        " grimalkin "               => " bobcat ",
        " grime "                   => " crud ",
        " grimness "                => " acerbity ",
        " grimy "                   => " begrimed ",
        " grin "                    => " beam ",
        " grind "                   => " bullwork ",
        " grinding "                => " cutting ",
        " grinning "                => " animated ",
        " grins "                   => " cool ",
        " grip "                    => " anchor ",
        " gripe "                   => " ache ",
        " griper "                  => " bear ",
        " griping "                 => " bitching ",
        " gripped "                 => " absorbed ",
        " gripping "                => " arresting ",
        " grisly "                  => " abominable ",
        " grist "                   => " affair ",
        " gristly "                 => " fibrous ",
        " grit "                    => " dust ",
        " gritty "                  => " abrasive ",
        " grizzle "                 => " blanch ",
        " grizzled "                => " aged ",
        " groan "                   => " beef ",
        " groaner "                 => " accompanist ",
        " groceries "               => " advantage ",
        " grocerteria "             => " bazaar ",
        " grody "                   => " alarming ",
        " groggy "                  => " befuddled ",
        " groin "                   => " beam ",
        " grommet "                 => " adolescent ",
        " groom "                   => " benedict ",
        " groomed "                 => " clean-cut ",
        " grooming "                => " admonishment ",
        " groove "                  => " canal ",
        " grooved "                 => " acclimatized ",
        " grooving "                => " allure ",
        " groovy "                  => " adequate ",
        " groping "                 => " dark ",
        " grossness "               => " atrocity ",
        " grotesque "               => " aberrant ",
        " grotto "                  => " cave ",
        " grouch "                  => " bear ",
        " grouchy "                 => " cantankerous ",
        " ground "                  => " arena ",
        " ground-level "            => " below ",
        " grounded "                => " ashore ",
        " grounding "               => " accomplishments ",
        " groundless "              => " baseless ",
        " grounds "                 => " area ",
        " groundward "              => " bottomward ",
        " groundwork "              => " background ",
        " group "                   => " accumulation ",
        " grouped "                 => " aggregate ",
        " groupie "                 => " adherent ",
        " grouping "                => " alignment ",
        " grouse "                  => " bickering ",
        " grouser "                 => " bear ",
        " grousing "                => " annoyed ",
        " grout "                   => " adhesive ",
        " grove "                   => " bracken ",
        " grovel "                  => " abase ",
        " groveler "                => " ass-kisser ",
        " groveling "               => " base ",
        " grovelling "              => " abject ",
        " grow "                    => " abound ",
        " grower "                  => " agriculturalist ",
        " growl "                   => " bark ",
        " growler "                 => " bear ",
        " growling "                => " glottal ",
        " grown "                   => " developed ",
        " grown-up "                => " developed ",
        " growth "                  => " advance ",
        " grub "                    => " chow ",
        " grub-bag "                => " attache ",
        " grubber "                 => " drudge ",
        " grubbery "                => " aliment ",
        " grubbing "                => " acquisitive ",
        " grubby "                  => " besmeared ",
        " grubstake "               => " accommodation ",
        " grubstreet "              => " drudge ",
        " grubwork "                => " bullwork ",
        " grudge "                  => " animosity ",
        " grudging "                => " acquisitive ",
        " grudgingness "            => " backbiting ",
        " grueling "                => " arduous ",
        " gruelingly "              => " agonizingly ",
        " gruelling "               => " backbreaking ",
        " gruesome "                => " abominable ",
        " gruff "                   => " abrupt ",
        " grumble "                 => " beef ",
        " grumbler "                => " bear ",
        " grumbling "               => " annoyed ",
        " grume "                   => " array ",
        " grump "                   => " bear ",
        " grumpy "                  => " bad-tempered ",
        " grungy "                  => " abominable ",
        " grunt "                   => " balance ",
        " gruntwork "               => " backbreaker ",
        " guarantee "               => " agreement ",
        " guaranteed "              => " affirmed ",
        " guarantor "               => " angel ",
        " guaranty "                => " agreement ",
        " guard "                   => " bouncer ",
        " guarded "                 => " attentive ",
        " guardedly "               => " anxiously ",
        " guardhouse "              => " bastille ",
        " guardianship "            => " administration ",
        " guarding "                => " attention ",
        " gudgeon "                 => " arbor ",
        " guerdon "                 => " atone ",
        " guerilla "                => " blackmailer ",
        " guess "                   => " assumption ",
        " guessed "                 => " estimated ",
        " guessing "                => " academic ",
        " guesstimate "             => " adjudge ",
        " guesstimated "            => " academic ",
        " guesstimation "           => " appraisal ",
        " guesswork "               => " assumption ",
        " guest "                   => " bedfellow ",
        " guff "                    => " acknowledgment ",
        " guffawing "               => " amusement ",
        " guidance "                => " advice ",
        " guide "                   => " adviser ",
        " guidepost "               => " alarm ",
        " guiding "                 => " allegorical ",
        " guild "                   => " brotherhood ",
        " guileful "                => " artful ",
        " guileless "               => " above-board ",
        " guilelessly "             => " artlessly ",
        " guilelessness "           => " artlessness ",
        " guillotine "              => " decollate ",
        " guillotining "            => " beheading ",
        " guilt "                   => " answerability ",
        " guilt-ridden "            => " apologetic ",
        " guiltiness "              => " bunco ",
        " guiltless "               => " clean ",
        " guiltlessness "           => " chastity ",
        " guilty "                  => " accusable ",
        " gulch "                   => " coulee ",
        " gulf "                    => " abysm ",
        " gull "                    => " dupe ",
        " gullible "                => " believing ",
        " gulp "                    => " choke ",
        " gulping "                 => " asthmatic ",
        " gum-up "                  => " blooper ",
        " gumbo "                   => " borsch ",
        " gumboot "                 => " cossack ",
        " gummed "                  => " adhering ",
        " gummy "                   => " adhering ",
        " gump "                    => " banty ",
        " gumption "                => " ability ",
        " gumptious "               => " active ",
        " gumshoe "                 => " ankle ",
        " gunboat "                 => " bottle ",
        " gunfire "                 => " battery ",
        " gung-ho "                 => " assertive ",
        " gunk "                    => " band ",
        " gunkhole "                => " boat ",
        " gunky "                   => " buttery ",
        " gunman "                  => " apache ",
        " gunnery "                 => " arms ",
        " gunnysack "               => " cheap ",
        " gunpowder "               => " armament ",
        " guns "                    => " accoutrements ",
        " gurgle "                  => " babble ",
        " gurney "                  => " barrow ",
        " guru "                    => " authority ",
        " gush "                    => " burst ",
        " gushing "                 => " blubbering ",
        " gusset "                  => " bond ",
        " gust "                    => " access ",
        " gustative "               => " acoustic ",
        " gustatory "               => " acoustic ",
        " gusto "                   => " appetite ",
        " gusty "                   => " airy ",
        " gut-busting "             => " agreeable ",
        " gutbucket "               => " bottle ",
        " gutiness "                => " assurance ",
        " gutless "                 => " abject ",
        " guts "                    => " audacity ",
        " gutsiness "               => " assurance ",
        " gutsy "                   => " bold ",
        " gutter "                  => " approach ",
        " guttiness "               => " application ",
        " guttural "                => " glottal ",
        " gutty "                   => " adventurous ",
        " guzzle "                  => " bolt ",
        " guzzler "                 => " auto ",
        " guzzling "                => " acquisitive ",
        " gymnasium "               => " amphitheater ",
        " gymnast "                 => " aerialist ",
        " gypsum "                  => " adhesive ",
        " gyrate "                  => " circle ",
        " gyrating "                => " ambagious ",
        " gyration "                => " ambit ",
        " gyre "                    => " belt ",
        " ha-ha "                   => " antic ",
        " habiliment "              => " accoutrement ",
        " habiliments "             => " accoutrement ",
        " habilitate "              => " accouter ",
        " habilitation "            => " ability ",
        " habit "                   => " addiction ",
        " habitable "               => " accouter ",
        " habitant "                => " citizen ",
        " habitat "                 => " abode ",
        " habitation "              => " address ",
        " habitual "                => " accepted ",
        " habitually "              => " commonly ",
        " habituate "               => " acclimate ",
        " habituated "              => " acclimatized ",
        " habituation "             => " acclimatization ",
        " habitus "                 => " body ",
        " hack "                    => " drudge ",
        " hackamore "               => " check ",
        " hacked "                  => " afraid ",
        " hackle "                  => " break ",
        " hackneyed "               => " antiquated ",
        " haematid "                => " corpuscle ",
        " haggard "                 => " ashen ",
        " haggle "                  => " argue ",
        " haglike "                 => " animal ",
        " hail "                    => " barrage ",
        " hailing "                 => " acclamation ",
        " hailstone "               => " chunk ",
        " hailstorm "               => " barrage ",
        " hair "                    => " beard ",
        " hair-comb "               => " crew ",
        " hair-raising "            => " amazing ",
        " hair-trigger "            => " critical ",
        " hairbrush "               => " besom ",
        " haircut "                 => " crew ",
        " hairdo "                  => " crew ",
        " hairdresser "             => " beautician ",
        " hairless "                => " baldheaded ",
        " hairline "                => " aerial ",
        " hairpin "                 => " ambit ",
        " hairsplitting "           => " analytical ",
        " hairy "                   => " bearded ",
        " halation "                => " aura ",
        " halcyon "                 => " advantageous ",
        " hale "                    => " able-bodied ",
        " haleness "                => " bloom ",
        " half "                    => " bisected ",
        " half-assed "              => " brief ",
        " half-baked "              => " backward ",
        " half-blood "              => " amalgam ",
        " half-breed "              => " amalgam ",
        " half-caste "              => " amalgam ",
        " half-cocked "             => " artsy ",
        " half-cooked "             => " bloody ",
        " half-done "               => " abridged ",
        " half-formed "             => " blooming ",
        " half-grown "              => " adolescent ",
        " half-hearted "            => " apathetic ",
        " half-knowledge "          => " benightedness ",
        " half-lift "               => " afterglow ",
        " half-moon "               => " arch ",
        " half-pint "               => " buck ",
        " half-price "              => " bargain ",
        " half-priced "             => " bargain ",
        " half-raw "                => " bloody ",
        " half-sighted "            => " astigmatic ",
        " half-witted "             => " doltish ",
        " halfheartedness "         => " aloofness ",
        " halfway "                 => " center ",
        " halfwit "                 => " blockhead ",
        " hall "                    => " anteroom ",
        " hallmark "                => " authentication ",
        " hallow "                  => " bless ",
        " hallowed "                => " anointed ",
        " hallucinate "             => " daydream ",
        " hallucination "           => " aberration ",
        " hallucinatory "           => " aberrant ",
        " hallucinogenic "          => " consciousness-expanding ",
        " hallway "                 => " alley ",
        " halo "                    => " aura ",
        " halt "                    => " arrest ",
        " halted "                  => " apoplectic ",
        " halter "                  => " check ",
        " halting "                 => " awkward ",
        " halve "                   => " bisect ",
        " halved "                  => " bisected ",
        " halves "                  => " behindhand ",
        " hambone "                 => " amateur ",
        " hamlet "                  => " apple ",
        " hammer "                  => " bang ",
        " hammered "                => " formed ",
        " hammering "               => " beating ",
        " hamming "                 => " assuming ",
        " hammock "                 => " anchorage ",
        " hammy "                   => " apish ",
        " hamper "                  => " bassinet ",
        " hampered "                => " bedfast ",
        " hampering "               => " arrest ",
        " hamstrung "               => " bedridden ",
        " hand "                    => " duke ",
        " hand-carry "              => " bear ",
        " hand-clapping "           => " acclaim ",
        " hand-me-downs "           => " accouterment ",
        " hand-operated "           => " chiral ",
        " hand-out "                => " advancement ",
        " hand-picked "             => " best ",
        " hand-walk "               => " accelerate ",
        " handbag "                 => " backpack ",
        " handbill "                => " advertisement ",
        " handcart "                => " barrow ",
        " handclap "                => " applause ",
        " handclapping "            => " clap ",
        " handclasp "               => " anchor ",
        " handcuff "                => " adhere ",
        " handcuffed "              => " abandoned ",
        " handed-down "             => " allegorical ",
        " handful "                 => " scattering ",
        " handgrip "                => " anchor ",
        " handgun "                 => " blaster ",
        " handhold "                => " anchor ",
        " handicap "                => " affliction ",
        " handicapped "             => " bedridden ",
        " handicraft "              => " achievement ",
        " handicraftsman "          => " artisan ",
        " handily "                 => " calmly ",
        " handiness "               => " adeptness ",
        " handiwork "               => " accomplishment ",
        " handler "                 => " abettor ",
        " handling "                => " administration ",
        " handout "                 => " advertisement ",
        " handpicked "              => " adopted ",
        " hands "                   => " easily ",
        " handshaker "              => " applicant ",
        " handsomely "              => " amply ",
        " handsomeness "            => " adorableness ",
        " handwriting "             => " autography ",
        " handy "                   => " accessible ",
        " hang "                    => " adhere ",
        " hang-loose "              => " amenable ",
        " hang-up "                 => " block ",
        " hangar "                  => " aerodrome ",
        " hangdog "                 => " base ",
        " hanger-on "               => " barnacle ",
        " hangers-on "              => " associates ",
        " hanging "                 => " blind ",
        " hangout "                 => " alliance ",
        " hanker "                  => " ache ",
        " hankering "               => " ache ",
        " hankie-pankie "           => " amour ",
        " hanky-panky "             => " chicane ",
        " haphazard "               => " accidental ",
        " haphazardly "             => " about ",
        " happen "                  => " appear ",
        " happening "               => " accident ",
        " happenings "              => " affairs ",
        " happenstance "            => " accident ",
        " happify "                 => " allure ",
        " happily "                 => " appropriately ",
        " happiness "               => " beatitude ",
        " happy "                   => " blessed ",
        " happy-go-lucky "          => " blithe ",
        " har-de-har "              => " amusement ",
        " har-har "                 => " amusing ",
        " harangue "                => " address ",
        " haranguer "               => " agitator ",
        " harass "                  => " annoy ",
        " harassed "                => " addled ",
        " harassing "               => " afflictive ",
        " harassment "              => " aggravation ",
        " harbinger "               => " augury ",
        " harbor "                  => " anchorage ",
        " harborage "               => " asylum ",
        " hard "                    => " adamantine ",
        " hard-bitten "             => " apathetic ",
        " hard-boiled "             => " above ",
        " hard-core "               => " determined ",
        " hard-driving "            => " active ",
        " hard-featured "           => " animal ",
        " hard-headed "             => " astute ",
        " hard-hearted "            => " above ",
        " hard-hitting "            => " accent ",
        " hard-line "               => " awkward ",
        " hard-nosed "              => " determined ",
        " hard-shell "              => " accepted ",
        " hard-surface "            => " asphalt ",
        " hard-wearing "            => " advantageous ",
        " hard-working "            => " aggressive ",
        " hardboiled "              => " bent ",
        " hardcover "               => " album ",
        " harden "                  => " amalgamate ",
        " hardened "                => " accustomed ",
        " hardheaded "              => " astute ",
        " hardhearted "             => " brutish ",
        " hardheartedly "           => " atrociously ",
        " hardheartedness "         => " animality ",
        " hardihood "               => " courage ",
        " hardiness "               => " assurance ",
        " hardness "                => " acerbity ",
        " hardrock "                => " asperous ",
        " hardship "                => " accident ",
        " hardtop "                 => " auto ",
        " hardware "                => " accouterments ",
        " hardwood "                => " balk ",
        " hardworking "             => " accomplished ",
        " hardy "                   => " able ",
        " hare-brained "            => " asinine ",
        " harebrain "               => " addle-brain ",
        " harebrained "             => " absurd ",
        " hark "                    => " apprehend ",
        " harken "                  => " accept ",
        " harlequin "               => " antic ",
        " harm "                    => " abuse ",
        " harmed "                  => " afflicted ",
        " harmful "                 => " adverse ",
        " harmfully "               => " alarmingly ",
        " harmless "                => " controllable ",
        " harmonics "               => " accord ",
        " harmonious "              => " adapted ",
        " harmoniously "            => " accordingly ",
        " harmonize "               => " accord ",
        " harmonizing "             => " adapted ",
        " harmony "                 => " accord ",
        " harness "                 => " accouter ",
        " harnessed "               => " acclimatized ",
        " harrier "                 => " annoyer ",
        " harrow "                  => " agonize ",
        " harrowed "                => " fatigued ",
        " harrowing "               => " agonizing ",
        " harry "                   => " annoy ",
        " harsh "                   => " acrid ",
        " harsh-sounding "          => " annoying ",
        " harshly "                 => " agonizingly ",
        " harshness "               => " acerbity ",
        " harum-scarum "            => " anarchic ",
        " haruspex "                => " augur ",
        " harvest "                 => " autumn ",
        " harvest-time "            => " autumn ",
        " harvester "               => " agriculturalist ",
        " harvesting "              => " agriculture ",
        " has-been "                => " back-number ",
        " hash "                    => " assortment ",
        " hasher "                  => " baker ",
        " hashery "                 => " beanery ",
        " hasp "                    => " catch ",
        " hassle "                  => " altercation ",
        " hassock "                 => " beanbag ",
        " haste "                   => " alacrity ",
        " hasten "                  => " accelerate ",
        " hastening "               => " dispatch ",
        " hastily "                 => " agilely ",
        " hastiness "               => " alacrity ",
        " hatch "                   => " bear ",
        " hatchback "               => " auto ",
        " hatchel "                 => " adjust ",
        " hatchery "                => " birthplace ",
        " hatchway "                => " aperture ",
        " hate "                    => " abhorrence ",
        " hateable "                => " abhorred ",
        " hateful "                 => " abhorrent ",
        " hatefulness "             => " abhorrence ",
        " hater "                   => " cynic ",
        " hating "                  => " antisocial ",
        " hatred "                  => " abhorrence ",
        " haughtiness "             => " airs ",
        " haughty "                 => " assuming ",
        " haul "                    => " booty ",
        " haulable "                => " carriageable ",
        " haulage "                 => " absorption ",
        " hauling "                 => " carriage ",
        " haunt "                   => " abode ",
        " haunted "                 => " apparitional ",
        " haunting "                => " addictive ",
        " hauteur "                 => " affectedness ",
        " have "                    => " accept ",
        " haven "                   => " anchorage ",
        " haversack "               => " haversack ",
        " having "                  => " accepting ",
        " havoc "                   => " calamity ",
        " hawk "                    => " militarist ",
        " hawker "                  => " bell-ringer ",
        " hawkeye "                 => " hawkeye ",
        " hawkish "                 => " advancing ",
        " hawser "                  => " braiding ",
        " hayloft "                 => " attic ",
        " haymaker "                => " bang ",
        " hayseed "                 => " barbarian ",
        " haywire "                 => " awry ",
        " hazardous "               => " chancy ",
        " hazardously "             => " alarmingly ",
        " hazardousness "           => " bulkiness ",
        " haze "                    => " brume ",
        " hazel "                   => " chestnut ",
        " haziness "                => " billow ",
        " hazy "                    => " bleared ",
        " head "                    => " arch ",
        " head-on "                 => " bang ",
        " headache "                => " cephalalgia ",
        " headband "                => " chaplet ",
        " headdress "               => " chaplet ",
        " header "                  => " attack ",
        " heading "                 => " branch ",
        " headland "                => " bank ",
        " headline "                => " banderole ",
        " headlined "               => " accent ",
        " headliner "               => " amateur ",
        " headlines "               => " account ",
        " headlong "                => " abrupt ",
        " headmaster "              => " administrator ",
        " headmost "                => " aboriginal ",
        " headpeeper "              => " analyst ",
        " headquarters "            => " address ",
        " headrest "                => " beanbag ",
        " headroom "                => " allowance ",
        " heads "                   => " active ",
        " headset "                 => " angle ",
        " headshaker "              => " agnostic ",
        " headshrinker "            => " analyst ",
        " headstall "               => " check ",
        " headstrong "              => " bullheaded ",
        " headway "                 => " advance ",
        " headwork "                => " cerebration ",
        " heady "                   => " exciting ",
        " heal "                    => " alleviate ",
        " health "                  => " bloom ",
        " health-giving "           => " abating ",
        " healthful "               => " benign ",
        " healthfulness "           => " bloom ",
        " healthier "               => " convalescent ",
        " healthiness "             => " bloom ",
        " healthy "                 => " advantageous ",
        " healthy-looking "         => " aflush ",
        " heap "                    => " abundance ",
        " heaped "                  => " aggregate ",
        " heaps "                   => " abundance ",
        " hear "                    => " apprehend ",
        " hearable "                => " aural ",
        " hearers "                 => " admirers ",
        " hearing "                 => " audition ",
        " hearken "                 => " catch ",
        " hearsay "                 => " buzz ",
        " heart "                   => " affection ",
        " heart-breaking "          => " affecting ",
        " heart-rending "           => " afflicted ",
        " heart-searching "         => " brooding ",
        " heart-sick "              => " crestfallen ",
        " heart-stirring "          => " amazing ",
        " heart-warming "           => " abating ",
        " heartache "               => " affliction ",
        " heartbeat "               => " baby ",
        " heartbreak "              => " affliction ",
        " heartbreaking "           => " affecting ",
        " heartbroken "             => " crestfallen ",
        " heartburn "               => " annoyance ",
        " hearten "                 => " animate ",
        " heartening "              => " auspicious ",
        " heartfelt "               => " ardent ",
        " hearth "                  => " address ",
        " heartily "                => " agreeably ",
        " heartiness "              => " affability ",
        " heartless "               => " brutal ",
        " heartlessly "             => " atrociously ",
        " heartlessness "           => " animality ",
        " heartrending "            => " afflictive ",
        " heartsick "               => " beaten ",
        " heartsickness "           => " affliction ",
        " heartsore "               => " crestfallen ",
        " heartthrob "              => " baby ",
        " hearty "                  => " affable ",
        " heat "                    => " calefaction ",
        " heated "                  => " acrimonious ",
        " heater "                  => " boiler ",
        " heathen "                 => " agnostic ",
        " heathenish "              => " agnostic ",
        " heave "                   => " boost ",
        " heavenly "                => " adorable ",
        " heavens "                 => " blast ",
        " heaver "                  => " ballista ",
        " heavier "                 => " added ",
        " heaviness "               => " depression ",
        " heaving "                 => " bouncing ",
        " heavy "                   => " abundant ",
        " heavy-duty "              => " able ",
        " heavy-footed "            => " apathetic ",
        " heavy-hearted "           => " blue ",
        " heavyhearted "            => " abject ",
        " heavyheartedness "        => " abasement ",
        " heavyset "                => " beefy ",
        " heavyweight "             => " ample ",
        " hebetic "                 => " abundant ",
        " hebetude "                => " blackout ",
        " hebetudinous "            => " cold ",
        " hecatomb "                => " annihilation ",
        " heckle "                  => " badger ",
        " heckler "                 => " annoyance ",
        " hectic "                  => " animated ",
        " hector "                  => " badger ",
        " hedge "                   => " barrier ",
        " hedged "                  => " belted ",
        " hedgerow "                => " barrier ",
        " hedging "                 => " ambiguity ",
        " hedonic "                 => " animal ",
        " hedonism "                => " amusement ",
        " hedonistic "              => " gluttonous ",
        " hee-haw "                 => " cackle ",
        " heebie-jeebies "          => " all-overs ",
        " heedful "                 => " active ",
        " heedfully "               => " anxiously ",
        " heedfulness "             => " absorption ",
        " heeding "                 => " acknowledgment ",
        " heedless "                => " daydreaming ",
        " heedlessly "              => " foolishly ",
        " heedlessness "            => " aloofness ",
        " heeler "                  => " banty ",
        " heft "                    => " backpack ",
        " hefty "                   => " ample ",
        " hegemony "                => " administration ",
        " hegira "                  => " abandonment ",
        " heifer "                  => " dogie ",
        " height "                  => " acme ",
        " heightened "              => " acute ",
        " heightening "             => " deepening ",
        " heinie "                  => " backside ",
        " heinous "                 => " abhorrent ",
        " heinousness "             => " atrociousness ",
        " heir "                    => " beneficiary ",
        " heir-apparent "           => " buyer ",
        " heiress "                 => " almsman ",
        " heirloom "                => " antique ",
        " heirs "                   => " brood ",
        " heirship "                => " ancestry ",
        " heist "                   => " break-in ",
        " heister "                 => " bandit ",
        " held "                    => " captivated ",
        " helical "                 => " circling ",
        " helicoid "                => " circling ",
        " heliograph "              => " alarm ",
        " heliotrope "              => " amethyst ",
        " helipad "                 => " aerodrome ",
        " heliport "                => " aerodrome ",
        " helix "                   => " braid ",
        " hell-raising "            => " disorderly ",
        " hellacious "              => " able ",
        " hellish "                 => " abhorrent ",
        " hello "                   => " accost ",
        " helm "                    => " captain ",
        " helmsmanship "            => " aeronautics ",
        " helotry "                 => " chains ",
        " help "                    => " advice ",
        " helper "                  => " abettor ",
        " helpers "                 => " cadre ",
        " helpful "                 => " accessible ",
        " helpfully "               => " agreeably ",
        " helping "                 => " allowance ",
        " helpless "                => " abandoned ",
        " helpmate "                => " abettor ",
        " helpmeet "                => " consort ",
        " helter-skelter "          => " arbitrary ",
        " hemangioma "              => " hemangioma ",
        " hematic "                 => " blood-soaked ",
        " hemic "                   => " blood-soaked ",
        " hemicrania "              => " cephalalgia ",
        " hemisect "                => " bifurcate ",
        " hemocyte "                => " corpuscle ",
        " hemoglobin "              => " claret ",
        " hemorrhage "              => " drain ",
        " hence "                   => " appropriately ",
        " henceforth "              => " afterward ",
        " henchman "                => " abettor ",
        " henna "                   => " chestnut ",
        " henpeck "                 => " abrade ",
        " henpecked "               => " abject ",
        " herald "                  => " adviser ",
        " heraldry "                => " blazonry ",
        " herb "                    => " assemble ",
        " herbaceous "              => " blooming ",
        " herbage "                 => " frondescence ",
        " herculean "               => " able-bodied ",
        " herd "                    => " assemblage ",
        " herder "                  => " bouncer ",
        " here "                    => " actuality ",
        " hereafter "               => " afterlife ",
        " hereditary "              => " ancestral ",
        " heredity "                => " ancestry ",
        " heresy "                  => " agnosticism ",
        " heretic "                 => " advocate ",
        " heretical "               => " agnostic ",
        " hereupon "                => " anon ",
        " heritable "               => " ancestral ",
        " heritage "                => " ancestry ",
        " heritance "               => " bequest ",
        " heritor "                 => " beneficiary ",
        " herky-jerky "             => " broken ",
        " hermeneutic "             => " allegorical ",
        " hermetic "                => " abstruse ",
        " hermit "                  => " anchoress ",
        " hermit-like "             => " antisocial ",
        " hermitage "               => " abbey ",
        " hermitess "               => " anchoress ",
        " hermitic "                => " cloistral ",
        " hermitical "              => " aloof ",
        " hernia "                  => " breach ",
        " herniation "              => " breach ",
        " hero-worship "            => " admire ",
        " heroic "                  => " ballsy ",
        " heroics "                 => " avowal ",
        " heroine "                 => " charlatan ",
        " heroism "                 => " boldness ",
        " herolike "                => " adventurous ",
        " herpes "                  => " canker ",
        " hers "                    => " chastening ",
        " hesitance "               => " alienation ",
        " hesitancy "               => " agnosticism ",
        " hesitant "                => " afraid ",
        " hesitantly "              => " cautiously ",
        " hesitate "                => " alternate ",
        " hesitating "              => " afraid ",
        " hesitation "              => " averseness ",
        " heteroclite "             => " aberrant ",
        " heterodox "               => " agnostic ",
        " heterodoxy "              => " bone ",
        " heterogeneity "           => " adverse ",
        " heterogeneous "           => " amalgamate ",
        " heteromorphic "           => " aberrant ",
        " hiatus "                  => " aperture ",
        " hibernal "                => " biting ",
        " hibernate "               => " hide ",
        " hibernating "             => " comatose ",
        " hibernation "             => " dawdling ",
        " hiccup "                  => " discharge ",
        " hick "                    => " barbarian ",
        " hickey "                  => " birthmark ",
        " hide "                    => " adumbrate ",
        " hide-out "                => " beard ",
        " hideaway "                => " cover ",
        " hidebound "               => " common ",
        " hideous "                 => " abominable ",
        " hideousness "             => " aberration ",
        " hideout "                 => " cover ",
        " hiding "                  => " ambuscade ",
        " hiemal "                  => " algid ",
        " hierarchize "             => " adapt ",
        " hierarchy "               => " bureaucracy ",
        " hieroglyph "              => " cipher ",
        " hieroglyphic "            => " cacographic ",
        " hieroglyphics "           => " autography ",
        " hifalutin "               => " arrogant ",
        " higgledy-piggledy "       => " arbitrary ",
        " high "                    => " aerial ",
        " high-and-mighty "         => " condescending ",
        " high-bred "               => " adulatory ",
        " high-brow "               => " aesthetic ",
        " high-class "              => " chic ",
        " high-colored "            => " blowzy ",
        " high-dive "               => " bathe ",
        " high-flown "              => " aureate ",
        " high-handed "             => " absolute ",
        " high-handedness "         => " airs ",
        " high-hat "                => " high-hat ",
        " high-income "             => " advantageous ",
        " high-living "             => " affluence ",
        " high-minded "             => " baronial ",
        " high-pitched "            => " acute ",
        " high-powered "            => " activating ",
        " high-priced "             => " cher ",
        " high-principled "         => " conscionable ",
        " high-priority "           => " acute ",
        " high-ranking "            => " baronial ",
        " high-reaching "           => " aerial ",
        " high-sounding "           => " arty ",
        " high-speed "              => " accelerated ",
        " high-spirited "           => " aggressive ",
        " high-spiritedness "       => " agitation ",
        " high-strung "             => " choked ",
        " high-wrought "            => " adorned ",
        " highball "                => " bottle ",
        " highborn "                => " blue-blooded ",
        " highboy "                 => " chiffonier ",
        " highbrow "                => " academician ",
        " highbrowed "              => " bookish ",
        " higher "                  => " college ",
        " highest "                 => " accomplished ",
        " highest-ranking "         => " astral ",
        " highfalutin "             => " apish ",
        " highjack "                => " accroach ",
        " highland "                => " altitude ",
        " highlighted "             => " accent ",
        " highliner "               => " baiter ",
        " highly "                  => " awful ",
        " highly-priced "           => " cher ",
        " highly-seasoned "         => " appealing ",
        " highly-wrought "          => " busy ",
        " highness "                => " altitude ",
        " highway "                 => " artery ",
        " highwayman "              => " brigand ",
        " hijack "                  => " annex ",
        " hijacker "                => " brigand ",
        " hike "                    => " backpack ",
        " hiker "                   => " ambler ",
        " hilarious "               => " amusing ",
        " hilarity "                => " alertness ",
        " hill "                    => " acropolis ",
        " hillock "                 => " acclivity ",
        " hilltop "                 => " acropolis ",
        " hilly "                   => " arresting ",
        " hilt "                    => " base ",
        " hind "                    => " afterwards ",
        " hinder "                  => " arrest ",
        " hindering "               => " adverse ",
        " hindmost "                => " afterwards ",
        " hindrance "               => " albatross ",
        " hinge "                   => " articulation ",
        " hint "                    => " adumbration ",
        " hip-wader "               => " cossack ",
        " hippo "                   => " adipose ",
        " hippodrome "              => " amphitheatre ",
        " hips "                    => " achievement ",
        " hire "                    => " appoint ",
        " hired "                   => " assassin ",
        " hireling "                => " agent ",
        " hirsuite "                => " furry ",
        " hirsute "                 => " barbate ",
        " histology "               => " analysis ",
        " historic "                => " celebrated ",
        " historical "              => " actual ",
        " histrionic "              => " aureate ",
        " histrionics "             => " assuming ",
        " hit-and-run "             => " arrest ",
        " hit-or-miss "             => " accidental ",
        " hitch "                   => " block ",
        " hitched "                 => " anchored ",
        " hitchhiker "              => " commuter ",
        " hitherto "                => " ahead ",
        " hive "                    => " accumulate ",
        " hizzoner "                => " adjudicator ",
        " ho-hum "                  => " blah ",
        " hoar "                    => " chill ",
        " hoard "                   => " abundance ",
        " hoarded "                 => " aggregate ",
        " hoarding "                => " accession ",
        " hoarse "                  => " blatant ",
        " hoary "                   => " age-old ",
        " hoaxer "                  => " bastard ",
        " hoaxing "                 => " artifice ",
        " hobble "                  => " clump ",
        " hobbling "                => " bruised ",
        " hobby "                   => " amusement ",
        " hobnail "                 => " barbarian ",
        " hobnob "                  => " accompany ",
        " hock "                    => " bound ",
        " hocus "                   => " abracadabra ",
        " hocus-pocus "             => " abracadabra ",
        " hodgepodge "              => " collection ",
        " hoedown "                 => " altercation ",
        " hog-tied "                => " belted ",
        " hogback "                 => " aigrette ",
        " hogging "                 => " acquisitive ",
        " hoggish "                 => " acquisitive ",
        " hogshead "                => " butt ",
        " hogtie "                  => " compel ",
        " hogwash "                 => " absurdity ",
        " hoist "                   => " elevate ",
        " hoity-toity "             => " aloof ",
        " hoke "                    => " assemble ",
        " hokey "                   => " blah ",
        " hokey-pokey "             => " amour ",
        " hokum "                   => " blah ",
        " hold "                    => " authority ",
        " hold-up "                 => " adjournment ",
        " holdall "                 => " attache ",
        " holding "                 => " captivation ",
        " holdings "                => " backing ",
        " holdout "                 => " adjudicator ",
        " holdup "                  => " bottleneck ",
        " hole "                    => " aperture ",
        " hole-and-corner "         => " clandestine ",
        " holiday "                 => " anniversary ",
        " holiness "                => " asceticism ",
        " holler "                  => " bark ",
        " hollow "                  => " alveolate ",
        " hollow-eyed "             => " ashen ",
        " hollowed "                => " biconcave ",
        " hollowness "              => " abyss ",
        " holocaust "               => " bonfire ",
        " holy "                    => " angelic ",
        " homage "                  => " admiration ",
        " home-grown "              => " civil ",
        " home-loving "             => " calm ",
        " homebody "                => " acquaintance ",
        " homecoming "              => " accession ",
        " homegrown "               => " acquaintance ",
        " homeland "                => " citizenry ",
        " homeless "                => " abandoned ",
        " homelike "                => " calm ",
        " homely "                  => " airedale ",
        " homemade "                => " bootleg ",
        " homemaking "              => " bed-making ",
        " homer "                   => " adjudicator ",
        " homeroom "                => " academy ",
        " homesick "                => " alone ",
        " homesickness "            => " homesickness ",
        " homespun "                => " chapped ",
        " homestead "               => " address ",
        " homesteader "             => " agriculturalist ",
        " homesteading "            => " agriculture ",
        " homework "                => " appointment ",
        " homey "                   => " aloof ",
        " homicidal "               => " bloodthirsty ",
        " homicide "                => " assassination ",
        " homiletic "               => " academic ",
        " homilize "                => " deliver ",
        " homily "                  => " address ",
        " hominal "                 => " animal ",
        " hominid "                 => " animal ",
        " hominine "                => " animal ",
        " homogeneity "             => " accord ",
        " homogeneous "             => " constant ",
        " homogeneousness "         => " accord ",
        " homogenize "              => " acclimatize ",
        " homogenous "              => " akin ",
        " homologize "              => " acclimatize ",
        " homologous "              => " akin ",
        " homology "                => " affinity ",
        " honcho "                  => " ambassador ",
        " honed "                   => " acid ",
        " honest-to-goodness "      => " 18-carat ",
        " honestly "                => " candidly ",
        " honestness "              => " character ",
        " honesty "                 => " bluntness ",
        " honeybunch "              => " angel ",
        " honeycomb "               => " bore ",
        " honeyed "                 => " adulatory ",
        " honeymoon "               => " amusement ",
        " honk "                    => " bellow ",
        " honker "                  => " adenoids ",
        " honky-tonk "              => " bank ",
        " honor "                   => " account ",
        " honor-bound "             => " accountable ",
        " honorable "               => " atonement ",
        " honorableness "           => " candor ",
        " honorably "               => " advantageously ",
        " honored "                 => " accustomed ",
        " honoree "                 => " honoree ",
        " honoring "                => " anniversary ",
        " honors "                  => " ceremoniousness ",
        " hoo-ha "                  => " agitation ",
        " hooch "                   => " bootleg ",
        " hood "                    => " awning ",
        " hoodang "                 => " brawl ",
        " hoodlum "                 => " blackmailer ",
        " hoodlumism "              => " aggro ",
        " hoodoo "                  => " agitate ",
        " hoodwink "                => " baffle ",
        " hoodwinking "             => " backbiting ",
        " hooey "                   => " applesauce ",
        " hoof "                    => " ankle ",
        " hoofer "                  => " ballerina ",
        " hook "                    => " angle ",
        " hook-up "                 => " affiliation ",
        " hooked "                  => " absorbed ",
        " hookup "                  => " amalgamation ",
        " hooligan "                => " brigand ",
        " hooliganism "             => " aggro ",
        " hoop "                    => " bandage ",
        " hoopla "                  => " activity ",
        " hoot "                    => " agreeable ",
        " hootch "                  => " booze ",
        " hope "                    => " achievement ",
        " hoped-for "               => " -to-be ",
        " hopefulness "             => " animation ",
        " hopelessness "            => " abasement ",
        " hophead "                 => " addict ",
        " hoping "                  => " acquisitive ",
        " hopped-up "               => " benumbed ",
        " hopper "                  => " alembic ",
        " hopping "                 => " bent ",
        " hopscotch "               => " aberrate ",
        " horde "                   => " band ",
        " horizon "                 => " border ",
        " horizontal "              => " accumbent ",
        " horizontally "            => " angular ",
        " hornswoggle "             => " baffle ",
        " hornswoggled "            => " bamboozled ",
        " horny "                   => " amative ",
        " horological "             => " archival ",
        " horometrical "            => " archival ",
        " horoscope "               => " astrometry ",
        " horoscopist "             => " augur ",
        " horoscopy "               => " abracadabra ",
        " horrendous "              => " abominable ",
        " horrible "                => " abhorrent ",
        " horribly "                => " angrily ",
        " horrid "                  => " alarming ",
        " horrific "                => " alarming ",
        " horrified "               => " abashed ",
        " horrify "                 => " affright ",
        " horrifying "              => " appalling ",
        " horror "                  => " abhorrence ",
        " horse-trade "             => " argue ",
        " horsefeathers "           => " applesauce ",
        " horsemen "                => " army ",
        " horsepower "              => " application ",
        " horseshoe "               => " ambit ",
        " horsewhip "               => " baste ",
        " hortative "               => " academic ",
        " horticultural "           => " agronomical ",
        " horticulture "            => " agronomics ",
        " horticulturist "          => " agriculturalist ",
        " hosanna "                 => " aria ",
        " hose "                    => " corrupt ",
        " hosed "                   => " bashed ",
        " hoser "                   => " bilker ",
        " hospice "                 => " auberge ",
        " hospitable "              => " accessible ",
        " hospitableness "          => " accommodation ",
        " hospitality "             => " accommodation ",
        " hospitalization "         => " analysis ",
        " hospitalized "            => " ailing ",
        " hostage "                 => " earnest ",
        " hostel "                  => " auberge ",
        " hostelry "                => " auberge ",
        " hostile "                 => " adverse ",
        " hostilely "               => " abnormally ",
        " hostility "               => " abhorrence ",
        " hostler "                 => " equerry ",
        " hot-air "                 => " gasbag ",
        " hot-blooded "             => " affecting ",
        " hot-dogging "             => " blowhard ",
        " hot-headed "              => " audacious ",
        " hot-tempered "            => " aggressive ",
        " hotbed "                  => " axis ",
        " hotcake "                 => " battercake ",
        " hotchpotch "              => " assortment ",
        " hotdog "                  => " alarm ",
        " hotel "                   => " auberge ",
        " hotelier "                => " freeholder ",
        " hotelkeeper "             => " freeholder ",
        " hotfoot "                 => " abscond ",
        " hothead "                 => " agitator ",
        " hotheaded "               => " brash ",
        " hotness "                 => " acidity ",
        " hots "                    => " ambition ",
        " hotshot "                 => " accomplished ",
        " hound "                   => " basset ",
        " hounding "                => " coursing ",
        " hourglass "               => " alarm ",
        " hourly "                  => " alternate ",
        " house "                   => " abode ",
        " house-sitter "            => " babysitter ",
        " housebound "              => " bedridden ",
        " houseboy "                => " chambermaid ",
        " housebreak "              => " abduct ",
        " housebroken "             => " acclimatized ",
        " housecleaner "            => " charwoman ",
        " housecleaning "           => " adjournment ",
        " housecoat "               => " bathrobe ",
        " housecraft "              => " bed-making ",
        " household "               => " domiciliary ",
        " householder "             => " aborigine ",
        " housekeeper "             => " charwoman ",
        " houseless "               => " abandoned ",
        " housemaid "               => " charwoman ",
        " housemother "             => " administrator ",
        " housesitter "             => " babysitter ",
        " housetop "                => " beam ",
        " housetrain "              => " acclimatize ",
        " housewares "              => " accouterments ",
        " housewifely "             => " calm ",
        " housewifery "             => " bed-making ",
        " housework "               => " bed-making ",
        " housing "                 => " apartment ",
        " hovel "                   => " couch ",
        " hovering "                => " aerial ",
        " however "                 => " about ",
        " howitzer "                => " blaster ",
        " howl "                    => " bark ",
        " howling "                 => " bawl ",
        " hubba-hubba "             => " agitation ",
        " hubbub "                  => " babel ",
        " hubby "                   => " bedmate ",
        " hubris "                  => " airs ",
        " hubristic "               => " arrogant ",
        " huckster "                => " bargain ",
        " huddle "                  => " ataxia ",
        " huddled "                 => " awash ",
        " huddling "                => " absorption ",
        " hued "                    => " brave ",
        " huff "                    => " anger ",
        " huffish "                 => " angered ",
        " huffy "                   => " angered ",
        " hugely "                  => " badly ",
        " hugeness "                => " bigness ",
        " hugging "                 => " adhering ",
        " hulk "                    => " blob ",
        " hulking "                 => " ample ",
        " hull "                    => " bark ",
        " hullabaloo "              => " anniversary ",
        " human "                   => " animal ",
        " humane "                  => " accommodating ",
        " humaneness "              => " affection ",
        " humanitarian "            => " altruistic ",
        " humanities "              => " abstract ",
        " humanity "                => " altruism ",
        " humanize "                => " acculturate ",
        " humanizing "              => " adorning ",
        " humans "                  => " bodies ",
        " humble "                  => " apprehensive ",
        " humbled "                 => " ashamed ",
        " humbleness "              => " bashfulness ",
        " humbling "                => " base ",
        " humbug "                  => " braggadocio ",
        " humdrum "                 => " arid ",
        " humectation "             => " clamminess ",
        " humid "                   => " boiling ",
        " humidify "                => " bedew ",
        " humidity "                => " clamminess ",
        " humidness "               => " clamminess ",
        " humidor "                 => " alembic ",
        " humiliate "               => " abase ",
        " humiliated "              => " ashamed ",
        " humiliating "             => " base ",
        " humiliation "             => " abasement ",
        " humility "                => " abasement ",
        " humming "                 => " bustling ",
        " hummock "                 => " acropolis ",
        " humor "                   => " amusement ",
        " humoring "                => " accommodating ",
        " humorist "                => " antic ",
        " humorous "                => " amusing ",
        " humorousness "            => " ball ",
        " humorsome "               => " arbitrary ",
        " hump "                    => " bulge ",
        " humpback "                => " bulge ",
        " humpbacked "              => " askew ",
        " humped "                  => " angled ",
        " humungous "               => " ample ",
        " humus "                   => " admixture ",
        " hunch "                   => " anticipation ",
        " hunch-backed "            => " askew ",
        " hunchback "               => " bulge ",
        " hunched "                 => " angled ",
        " hundred-to-one "          => " doubtful ",
        " hung "                    => " afraid ",
        " hunger "                  => " ache ",
        " hungered "                => " athirst ",
        " hungering "               => " dog-hungry ",
        " hungriness "              => " ache ",
        " hungry "                  => " athirst ",
        " hunker "                  => " crouch ",
        " hunky-dory "              => " adequate ",
        " hunt "                    => " coursing ",
        " hunted "                  => " bolter ",
        " hurl "                    => " bung ",
        " hurler "                  => " ballista ",
        " hurling "                 => " casting ",
        " hurrah "                  => " acclamation ",
        " hurrahs "                 => " acclaim ",
        " hurray "                  => " acclamation ",
        " hurricane "               => " blow ",
        " hurried "                 => " abrupt ",
        " hurriedly "               => " agilely ",
        " hurriedness "             => " alacrity ",
        " hurry "                   => " bustle ",
        " hurry-scurry "            => " arbitrary ",
        " hurry-up "                => " burning ",
        " hurrying "                => " dispatch ",
        " hurt "                    => " aching ",
        " hurtful "                 => " aching ",
        " hurting "                 => " affliction ",
        " hurtle "                  => " bump ",
        " hurtless "                => " controllable ",
        " husband "                 => " bedmate ",
        " husbanding "              => " attention ",
        " husbandless "             => " bachelor ",
        " husbandman "              => " agriculturist ",
        " hush "                    => " calm ",
        " hush-hush "               => " clandestine ",
        " hush-up "                 => " camouflage ",
        " hushful "                 => " hushed ",
        " husk "                    => " bark ",
        " husks "                   => " crust ",
        " husky "                   => " croaking ",
        " hussars "                 => " army ",
        " hussy "                   => " amazon ",
        " hustler "                 => " aerial ",
        " hustling "                => " active ",
        " hutch "                   => " berth ",
        " hyaline "                 => " burnished ",
        " hyaloid "                 => " burnished ",
        " hybrid "                  => " amalgam ",
        " hybridization "           => " admixture ",
        " hybridize "               => " blend ",
        " hybridized "              => " alloyed ",
        " hydra "                   => " blight ",
        " hydrographic "            => " abyssal ",
        " hydrolyzed "              => " anatomize ",
        " hydrophobic "             => " berserk ",
        " hydroponics "             => " agriculture ",
        " hygienic "                => " aseptic ",
        " hylic "                   => " actual ",
        " hymeneal "                => " conjugal ",
        " hymn "                    => " aria ",
        " hype "                    => " advertising ",
        " hyped "                   => " absorbed ",
        " hyper "                   => " aggressive ",
        " hyperbola "               => " ambit ",
        " hyperbolic "              => " abstract ",
        " hyperbolize "             => " aggrandize ",
        " hyperborean "             => " algid ",
        " hypercritical "           => " acrimonious ",
        " hypercriticize "          => " bother ",
        " hypersensitive "          => " acute ",
        " hyphen "                  => " abutment ",
        " hypnosis "                => " analgesic ",
        " hypnotic "                => " anesthetic ",
        " hypnotism "               => " allure ",
        " hypnotist "               => " astrologer ",
        " hypnotize "               => " anesthetize ",
        " hypnotized "              => " beguiled ",
        " hypo "                    => " bang ",
        " hypocrisy "               => " affectation ",
        " hypocrite "               => " actor ",
        " hypocriticalness "        => " deceit ",
        " hypomnesia "              => " absent-mindedness ",
        " hypostatize "             => " actualize ",
        " hypothesis "              => " antecedent ",
        " hypothesize "             => " accept ",
        " hypothesized "            => " accepted ",
        " hypothetical "            => " academic ",
        " hypothetically "          => " apparently ",
        " hysteria "                => " agitation ",
        " hysteric "                => " aberrant ",
        " hysterical "              => " agitated ",
        " hysterically "            => " absurdly ",
        " hysterics "               => " agitation ",
        " ice-capped "              => " chill ",
        " ice-covered "             => " arctic ",
        " iceberg "                 => " abstract ",
        " icebound "                => " arctic ",
        " icecap "                  => " berg ",
        " iced "                    => " algid ",
        " iceman "                  => " assertive ",
        " ichorous "                => " aqueous ",
        " icicle "                  => " chunk ",
        " icicled "                 => " chill ",
        " iciness "                 => " bite ",
        " icky "                    => " disgusting ",
        " icon "                    => " figure ",
        " iconoclastic "            => " agnostic ",
        " idea "                    => " abstraction ",
        " idealism "                => " celebrity ",
        " idealistic "              => " abstracted ",
        " ideality "                => " acuteness ",
        " idealization "            => " ballad ",
        " idealize "                => " acculturate ",
        " idealized "               => " arcadian ",
        " ideally "                 => " alluringly ",
        " ideals "                  => " ethics ",
        " ideas "                   => " account ",
        " ideation "                => " anticipation ",
        " ideational "              => " abstract ",
        " identically "             => " analogously ",
        " identicalness "           => " accord ",
        " identified "              => " articular ",
        " identify "                => " analyze ",
        " identifying "             => " anecdotic ",
        " identity "                => " character ",
        " ideological "             => " brainy ",
        " ideology "                => " credo ",
        " idiocracy "               => " aberration ",
        " idiocy "                  => " asininity ",
        " idiom "                   => " argot ",
        " idiomatic "               => " chatty ",
        " idiosyncrasy "            => " affectation ",
        " idiosyncratic "           => " appropriate ",
        " idiotic "                 => " asinine ",
        " idiotically "             => " absurdly ",
        " idle "                    => " abandoned ",
        " idleness "                => " dawdling ",
        " idling "                  => " dabbling ",
        " idolatrize "              => " apotheosize ",
        " idolatrous "              => " agnostic ",
        " idolatry "                => " account ",
        " idolism "                 => " apparition ",
        " idolist "                 => " agnostic ",
        " idolization "             => " account ",
        " idolize "                 => " admire ",
        " idolized "                => " admired ",
        " idyll "                   => " break ",
        " idyllic "                 => " arcadian ",
        " iffy "                    => " capricious ",
        " igneous "                 => " ablaze ",
        " ignitable "               => " burnable ",
        " ignite "                  => " burn ",
        " ignited "                 => " afire ",
        " ignition "                => " agitation ",
        " ignoble "                 => " abject ",
        " ignominious "             => " abhorrent ",
        " ignominy "                => " discredit ",
        " ignoramus "               => " beast ",
        " ignorance "               => " benightedness ",
        " ignorant "                => " apprenticed ",
        " ignorantly "              => " apparently ",
        " ignore "                  => " avoid ",
        " ignored "                 => " abandoned ",
        " ignoring "                => " blank ",
        " ill-adapted "             => " awkward ",
        " ill-advised "             => " brash ",
        " ill-advisedly "           => " absurdly ",
        " ill-at-ease "             => " affected ",
        " ill-behaved "             => " disobedient ",
        " ill-boding "              => " apocalyptic ",
        " ill-bred "                => " awkward ",
        " ill-chosen "              => " contrary ",
        " ill-conceived "           => " absurd ",
        " ill-considered "          => " absurd ",
        " ill-defined "             => " aside ",
        " ill-disposed "            => " afraid ",
        " ill-disposedness "        => " animosity ",
        " ill-famed "               => " abominable ",
        " ill-fated "               => " blighted ",
        " ill-favored "             => " exceptionable ",
        " ill-fitted "              => " ill-fitted ",
        " ill-fitting "             => " billowing ",
        " ill-formed "              => " abnormal ",
        " ill-humor "               => " annoyance ",
        " ill-humored "             => " bad-tempered ",
        " ill-judged "              => " brash ",
        " ill-lighted "             => " aphotic ",
        " ill-made "                => " askew ",
        " ill-mannered "            => " bad-mannered ",
        " ill-matched "             => " ill-fitted ",
        " ill-natured "             => " bitchy ",
        " ill-omened "              => " bedevilled ",
        " ill-starred "             => " adverse ",
        " ill-suited "              => " ill-fitted ",
        " ill-tempered "            => " affronted ",
        " ill-timed "               => " awkward ",
        " ill-treat "               => " corrupt ",
        " ill-treatment "           => " ache ",
        " illahie "                 => " citizenry ",
        " illation "                => " agreement ",
        " illegal "                 => " actionable ",
        " illegality "              => " abomination ",
        " illegalize "              => " banish ",
        " illegible "               => " cacographic ",
        " illegitimate "            => " adulterine ",
        " illiberal "               => " common ",
        " illiberality "            => " bent ",
        " illicit "                 => " adulterous ",
        " illimitable "             => " bottomless ",
        " illiteracy "              => " benightedness ",
        " illiterate "              => " benighted ",
        " illness "                 => " affliction ",
        " illogical "               => " casuistic ",
        " illogicality "            => " applesauce ",
        " illogicalness "           => " applesauce ",
        " illude "                  => " affect ",
        " illume "                  => " acquaint ",
        " illuminate "              => " brighten ",
        " illuminated "             => " aflame ",
        " illuminating "            => " anecdotic ",
        " illumination "            => " beam ",
        " illuminative "            => " anecdotic ",
        " illumine "                => " beam ",
        " illumined "               => " ablaze ",
        " illusion "                => " apparition ",
        " illusionist "             => " archimage ",
        " illusive "                => " credible ",
        " illusory "                => " apparent ",
        " illustrate "              => " allegorize ",
        " illustration "            => " analogy ",
        " illustrative "            => " allegorical ",
        " illustratory "            => " allegorical ",
        " illustriously "           => " advantageously ",
        " illustriousness "         => " accolade ",
        " image "                   => " angel ",
        " imaged "                  => " beheld ",
        " imagery "                 => " adumbration ",
        " imaginable "              => " apprehensible ",
        " imaginary "               => " abstract ",
        " imagination "             => " acuteness ",
        " imaginative "             => " artistic ",
        " imagine "                 => " brainstorm ",
        " imagined "                => " absurd ",
        " imagining "               => " apperception ",
        " imagistic "               => " allegorical ",
        " imbalance "               => " alterity ",
        " imbathe "                 => " bath ",
        " imbecile "                => " asinine ",
        " imbecilic "               => " doltish ",
        " imbed "                   => " attach ",
        " imbibe "                  => " absorb ",
        " imbibing "                => " absorptive ",
        " imbricate "               => " cover ",
        " imbroglio "               => " altercation ",
        " imbrue "                  => " deluge ",
        " imbrued "                 => " blood-soaked ",
        " imbue "                   => " bathe ",
        " imbued "                  => " absorbed ",
        " imitated "                => " apish ",
        " imitating "               => " assuming ",
        " imitation "               => " apery ",
        " imitative "               => " artful ",
        " imitator "                => " addict ",
        " immaculacy "              => " abstemiousness ",
        " immaculate "              => " bright ",
        " immalleable "             => " hard ",
        " immature "                => " adolescent ",
        " immaturity "              => " adolescence ",
        " immeasurability "         => " beyond ",
        " immeasurably "            => " abundantly ",
        " immediacy "               => " adjacency ",
        " immediate "               => " actual ",
        " immediately "             => " anon ",
        " immedicable "             => " cureless ",
        " immemorial "              => " age-old ",
        " immensely "               => " badly ",
        " immensity "               => " aggregate ",
        " immerge "                 => " absorb ",
        " immerse "                 => " asperse ",
        " immersed "                => " absorbed ",
        " immersion "               => " captivation ",
        " immigrate "               => " arrive ",
        " immigrating "             => " casual ",
        " immigration "             => " clearing ",
        " imminent "                => " approaching ",
        " immingle "                => " amalgamate ",
        " immix "                   => " amalgamate ",
        " immixture "               => " amalgam ",
        " immobile "                => " anchored ",
        " immobility "              => " apathy ",
        " immobilization "          => " apathy ",
        " immobilize "              => " attenuate ",
        " immobilized "             => " anchored ",
        " immoderacy "              => " debauchery ",
        " immoderate "              => " dizzying ",
        " immoderately "            => " awfully ",
        " immoderation "            => " debauchery ",
        " immodest "                => " apparent ",
        " immodesty "               => " barbarism ",
        " immolate "                => " absolve ",
        " immolation "              => " affliction ",
        " immoral "                 => " abandoned ",
        " immorality "              => " affair ",
        " immortal "                => " abiding ",
        " immortality "             => " aeon ",
        " immortalization "         => " advance ",
        " immortalize "             => " admire ",
        " immortally "              => " always ",
        " immotile "                => " anchored ",
        " immovability "            => " durability ",
        " immovable "               => " adamant ",
        " immoveable "              => " adherent ",
        " immune "                  => " allowed ",
        " immunity "                => " amnesty ",
        " immuration "              => " bonds ",
        " immured "                 => " bedfast ",
        " immurement "              => " apprehension ",
        " immusical "               => " clinking ",
        " immutable "               => " abiding ",
        " impact "                  => " appulse ",
        " impair "                  => " blemish ",
        " impaired "                => " broken ",
        " impairment "              => " crime ",
        " impale "                  => " kill ",
        " impalement "              => " beheading ",
        " impalpable "              => " airy ",
        " imparity "                => " alterity ",
        " impart "                  => " admit ",
        " impartance "              => " acknowledgment ",
        " impartation "             => " acknowledgment ",
        " impartial "               => " candid ",
        " impartiality "            => " artlessness ",
        " impartially "             => " deservedly ",
        " impartible "              => " catching ",
        " impartment "              => " commitment ",
        " impassable "              => " blocked ",
        " impassible "              => " anesthetic ",
        " impassioned "             => " animated ",
        " impassive "               => " apathetic ",
        " impassiveness "           => " alienation ",
        " impassivity "             => " calmness ",
        " impatience "              => " agitation ",
        " impatient "               => " abrupt ",
        " impavid "                 => " adventuresome ",
        " impeach "                 => " accuse ",
        " impeachable "             => " amiss ",
        " impeached "               => " accusable ",
        " impeachment "             => " allegation ",
        " impeccability "           => " bluntness ",
        " impeccable "              => " categorical ",
        " impecunious "             => " broke ",
        " impecuniousness "         => " deprivation ",
        " impedimenta "             => " accoutrements ",
        " impediments "             => " accouterments ",
        " impeding "                => " adverse ",
        " impel "                   => " actuate ",
        " impelled "                => " apprenticed ",
        " impellent "               => " ambition ",
        " impelling "               => " alive ",
        " impend "                  => " advance ",
        " impendence "              => " blackmail ",
        " impendent "               => " aggressive ",
        " impending "               => " approaching ",
        " impenetrability "         => " body ",
        " impenetrable "            => " bulletproof ",
        " impenitent "              => " apathetic ",
        " imperative "              => " acute ",
        " imperativeness "          => " acuteness ",
        " imperator "               => " baron ",
        " imperceptible "           => " ephemeral ",
        " imperceptive "            => " careless ",
        " imperfect "               => " amiss ",
        " imperfection "            => " blemish ",
        " imperfectly "             => " abominably ",
        " imperial "                => " administrative ",
        " imperious "               => " arrogant ",
        " imperiousness "           => " airs ",
        " imperishability "         => " backbone ",
        " imperishable "            => " abiding ",
        " impermanence "            => " conciseness ",
        " impermanent "             => " brief ",
        " impermeability "          => " compactness ",
        " impermeable "             => " closed ",
        " impermissible "           => " blamable ",
        " impersonal "              => " abstract ",
        " impersonation "           => " clothing ",
        " impersonator "            => " amateur ",
        " impertinence "            => " assurance ",
        " impertinent "             => " arrogant ",
        " imperturbability "        => " accord ",
        " imperturbable "           => " assured ",
        " imperturbation "          => " calmness ",
        " imperviousness "          => " compactness ",
        " impetrate "               => " abjure ",
        " impetration "             => " appeal ",
        " impetuosity "             => " carelessness ",
        " impetuous "               => " abrupt ",
        " impetuously "             => " angrily ",
        " impetus "                 => " catalyst ",
        " impinge "                 => " affect ",
        " impingement "             => " approximation ",
        " impinging "               => " abutting ",
        " impious "                 => " agnostic ",
        " impiousness "             => " abuse ",
        " impish "                  => " casual ",
        " impishness "              => " archness ",
        " implacability "           => " acerbity ",
        " implacable "              => " cruel ",
        " implantation "            => " article ",
        " implanted "               => " built-in ",
        " implausible "             => " doubtful ",
        " implement "               => " apparatus ",
        " implementation "          => " accomplishing ",
        " implements "              => " accouterments ",
        " impliability "            => " compactness ",
        " impliable "               => " hard ",
        " implicate "               => " accuse ",
        " implicated "              => " active ",
        " implication "             => " association ",
        " implicative "             => " absolute ",
        " implicit "                => " absolute ",
        " implicitly "              => " around ",
        " implied "                 => " adumbrated ",
        " implode "                 => " blast ",
        " imploration "             => " address ",
        " implore "                 => " appeal ",
        " imploring "               => " affecting ",
        " implosion "               => " abortion ",
        " implosive "               => " affricate ",
        " imply "                   => " betoken ",
        " impolite "                => " boorish ",
        " impoliteness "            => " boldness ",
        " impolitic "               => " brash ",
        " imponderable "            => " ambiguous ",
        " imponderous "             => " agile ",
        " import "                  => " acceptation ",
        " importance "              => " accent ",
        " importantly "             => " chiefly ",
        " importation "             => " access ",
        " imported "                => " alien ",
        " importunate "             => " burning ",
        " importune "               => " appeal ",
        " importunity "             => " address ",
        " impose "                  => " appoint ",
        " imposing "                => " arty ",
        " imposingly "              => " abundantly ",
        " imposition "              => " artifice ",
        " impossible "              => " absurd ",
        " impost "                  => " assessment ",
        " imposter "                => " actor ",
        " impostor "                => " actor ",
        " impostrous "              => " artful ",
        " imposture "               => " artifice ",
        " imposturous "             => " ambiguous ",
        " impotence "               => " abstention ",
        " impotency "               => " affliction ",
        " impotent "                => " barren ",
        " impoundment "             => " bondage ",
        " impoverish "              => " blackmail ",
        " impoverished "            => " bankrupt ",
        " impoverishing "           => " annihilative ",
        " impoverishment "          => " deprivation ",
        " impracticable "           => " absurd ",
        " impractical "             => " abstract ",
        " impracticality "          => " absurdity ",
        " imprecate "               => " abuse ",
        " imprecise "               => " estimated ",
        " imprecision "             => " blunder ",
        " impregnability "          => " assurance ",
        " impregnable "             => " alarming ",
        " impregnate "              => " charge ",
        " impregnated "             => " abounding ",
        " impregnation "            => " assimilation ",
        " impresario "              => " administrator ",
        " impress "                 => " affect ",
        " impressed "               => " afflicted ",
        " impressible "             => " determinative ",
        " impression "              => " consequence ",
        " impressionability "       => " acuteness ",
        " impressionable "          => " affectable ",
        " impressionist "           => " actor ",
        " impressive "              => " absorbing ",
        " impressiveness "          => " animation ",
        " imprint "                 => " banner ",
        " imprison "                => " apprehend ",
        " imprisoned "              => " confined ",
        " improbability "           => " applesauce ",
        " improbable "              => " doubtful ",
        " improbity "               => " artifice ",
        " impromptu "               => " ad-lib ",
        " improper "                => " abnormal ",
        " improperly "              => " break ",
        " impropriety "             => " barbarism ",
        " improv "                  => " ad-lib ",
        " improve "                 => " advance ",
        " improved "                => " bigger ",
        " improvement "             => " advance ",
        " improvidence "            => " diffusion ",
        " improvident "             => " extravagant ",
        " improving "               => " convalescent ",
        " improvisate "             => " extemporize ",
        " improvisation "           => " architecture ",
        " improvise "               => " ad-lib ",
        " imprudence "              => " absurdity ",
        " imprudent "               => " brash ",
        " imprudently "             => " absurdly ",
        " impudence "               => " aggressiveness ",
        " impudent "                => " arrant ",
        " impugn "                  => " assail ",
        " impugnable "              => " ambiguous ",
        " impugning "               => " abrogating ",
        " impugnment "              => " abuse ",
        " impuissant "              => " clumsy ",
        " impulse "                 => " actuation ",
        " impulsion "               => " coercion ",
        " impulsive "               => " abrupt ",
        " impulsively "             => " foolishly ",
        " impulsiveness "           => " carelessness ",
        " impunity "                => " dispensation ",
        " impure "                  => " admixed ",
        " impurities "              => " algae ",
        " impurity "                => " birthmark ",
        " imputation "              => " allegation ",
        " impute "                  => " accredit ",
        " imputed "                 => " accepted ",
        " in-between "              => " average ",
        " in-built "                => " congenital ",
        " in-crowd "                => " aristocracy ",
        " in-depth "                => " all-embracing ",
        " in-house "                => " centralized ",
        " in-laws "                 => " ancestors ",
        " in-thing "                => " chic ",
        " inability "               => " disability ",
        " inaccessible "            => " aloof ",
        " inaccuracy "              => " blunder ",
        " inaction "                => " cessation ",
        " inactive "                => " abeyant ",
        " inactivity "              => " cessation ",
        " inadept "                 => " awkward ",
        " inadequacy "              => " blemish ",
        " inadequate "              => " bare ",
        " inadequately "            => " clumsily ",
        " inadequateness "          => " blemish ",
        " inadmissible "            => " exceptionable ",
        " inadvertence "            => " apathy ",
        " inadvertency "            => " blank ",
        " inadvertent "             => " careless ",
        " inadvertently "           => " aback ",
        " inadvisability "          => " absurdity ",
        " inadvisable "             => " careless ",
        " inaffable "               => " abrupt ",
        " inalienable "             => " basic ",
        " inalterable "             => " abiding ",
        " inamorata "               => " affection ",
        " inamorato "               => " admirer ",
        " inanimate "               => " azoic ",
        " inanition "               => " blank ",
        " inanity "                 => " applesauce ",
        " inapplicable "            => " extraneous ",
        " inapposite "              => " accidental ",
        " inappreciable "           => " airy ",
        " inappreciably "           => " hardly ",
        " inapprehensible "         => " doubtful ",
        " inappropriately "         => " afield ",
        " inapropos "               => " extraneous ",
        " inapt "                   => " awkward ",
        " inaptitude "              => " disability ",
        " inaptness "               => " blemish ",
        " inarguable "              => " accurate ",
        " inarticulate "            => " blurred ",
        " inarticulateness "        => " blackout ",
        " inattention "             => " apathy ",
        " inattentive "             => " absent ",
        " inaudible "               => " aside ",
        " inaugural "               => " countdown ",
        " inauguration "            => " commencement ",
        " inborn "                  => " congenital ",
        " inbound "                 => " entering ",
        " inbred "                  => " affiliated ",
        " inbuilt "                 => " built-in ",
        " incalculable "            => " boundless ",
        " incalculably "            => " abundantly ",
        " incalescence "            => " calefaction ",
        " incandesce "              => " beam ",
        " incandescence "           => " blaze ",
        " incandescent "            => " beaming ",
        " incantation "             => " abracadabra ",
        " incapability "            => " disability ",
        " incapable "               => " butterfingers ",
        " incapacious "             => " attenuated ",
        " incapacitated "           => " bedridden ",
        " incapacitation "          => " awkwardness ",
        " incapacity "              => " affliction ",
        " incarcerate "             => " bastille ",
        " incarcerated "            => " confined ",
        " incarnadine "             => " blooming ",
        " incarnate "               => " embodied ",
        " incarnated "              => " actual ",
        " incarnation "             => " apotheosis ",
        " incautious "              => " bold ",
        " incautiously "            => " absurdly ",
        " incautiousness "          => " alacrity ",
        " incendiary "              => " damaging ",
        " incense "                 => " aroma ",
        " incensement "             => " anger ",
        " incensing "               => " annoying ",
        " incentive "               => " allurement ",
        " inception "               => " birth ",
        " inceptive "               => " aboriginal ",
        " incessant "               => " ceaseless ",
        " incessantly "             => " endlessly ",
        " inchoate "                => " amorphous ",
        " incidence "               => " accident ",
        " incident "                => " adventure ",
        " incidental "              => " accidental ",
        " incinerate "              => " bake ",
        " incinerator "             => " boiler ",
        " incipience "              => " access ",
        " incipient "               => " basic ",
        " incision "                => " cavity ",
        " incisive "                => " acute ",
        " incisiveness "            => " accurateness ",
        " incitation "              => " agitator ",
        " incite "                  => " abet ",
        " incitement "              => " activation ",
        " inciter "                 => " advocate ",
        " inciting "                => " annoying ",
        " incitive "                => " anarchic ",
        " incivility "              => " boldness ",
        " inclemency "              => " acerbity ",
        " inclement "               => " brutal ",
        " inclination "             => " affection ",
        " inclinatory "             => " askew ",
        " incline "                 => " acclivity ",
        " inclined "                => " absorbed ",
        " inclining "               => " ability ",
        " inclose "                 => " agree ",
        " include "                 => " accommodate ",
        " inclusion "               => " admittance ",
        " inclusive "               => " across-the-board ",
        " inclusiveness "           => " amplitude ",
        " incog "                   => " anonymous ",
        " incogitable "             => " extraordinary ",
        " incognito "               => " anonymous ",
        " incognizable "            => " arcane ",
        " incognizant "             => " absent ",
        " incoherence "             => " chaos ",
        " incoherent "              => " breathless ",
        " incohesive "              => " broken ",
        " income "                  => " assets ",
        " incomer "                 => " face ",
        " incoming "                => " admission ",
        " incommensurable "         => " altered ",
        " incommensurateness "      => " asperity ",
        " incommode "               => " affront ",
        " incommodious "            => " annoying ",
        " incommunicable "          => " impossible ",
        " incommunicado "           => " bound ",
        " incomparability "         => " contrast ",
        " incomparably "            => " decidedly ",
        " incompatibility "         => " abhorrence ",
        " incompatible "            => " adverse ",
        " incompatibly "            => " abnormally ",
        " incompetence "            => " amateurishness ",
        " incompetency "            => " affliction ",
        " incompetent "             => " amateur ",
        " incompetently "           => " abominably ",
        " incomplete "              => " abridged ",
        " incompletely "            => " clumsily ",
        " incompleteness "          => " blemish ",
        " incompletion "            => " blunder ",
        " incompliant "             => " awkward ",
        " incomprehension "         => " blindness ",
        " incomputable "            => " boundless ",
        " inconceivable "           => " extraordinary ",
        " inconclusive "            => " ambiguous ",
        " inconformable "           => " adverse ",
        " incongruent "             => " adverse ",
        " incongruity "             => " applesauce ",
        " incongruous "             => " alien ",
        " incongruously "           => " abnormally ",
        " incongruousness "         => " adverse ",
        " inconscient "             => " absent ",
        " inconscious "             => " cold ",
        " inconsiderable "          => " accessible ",
        " inconsiderably "          => " hardly ",
        " inconsiderate "           => " boorish ",
        " inconsiderately "         => " foolishly ",
        " inconsideration "         => " carelessness ",
        " inconsistency "           => " aberration ",
        " inconsolable "            => " comfortless ",
        " inconsonance "            => " contrast ",
        " inconsonant "             => " adverse ",
        " inconspicuous "           => " camouflaged ",
        " inconstant "              => " arbitrary ",
        " incontestable "           => " incontestable ",
        " incontestably "           => " acutely ",
        " incontinence "            => " bender ",
        " incontinent "             => " amoral ",
        " incontrovertible "        => " absitively ",
        " incontrovertibly "        => " acutely ",
        " inconvenience "           => " aggravation ",
        " inconvenient "            => " annoying ",
        " inconveniently "          => " agonizingly ",
        " inconversable "           => " bashful ",
        " inconversant "            => " absent ",
        " incorporate "             => " absorb ",
        " incorporated "            => " congenital ",
        " incorporating "           => " accumulation ",
        " incorporation "           => " assimilation ",
        " incorporeal "             => " apparition ",
        " incorrectly "             => " afield ",
        " incorrectness "           => " barbarism ",
        " incorrigibility "         => " abandonment ",
        " incorrigible "            => " abandoned ",
        " incorrupt "               => " admirable ",
        " incorruptibility "        => " bluntness ",
        " incorruption "            => " character ",
        " incorruptness "           => " character ",
        " increase "                => " access ",
        " increased "               => " added ",
        " increasing "              => " accretion ",
        " increasingly "            => " more ",
        " incredible "              => " absurd ",
        " incredibly "              => " abundantly ",
        " incredulity "             => " atheism ",
        " incredulous "             => " aporetic ",
        " increment "               => " accession ",
        " increscent "              => " accumulative ",
        " incriminate "             => " allege ",
        " incriminated "            => " accusable ",
        " incrimination "           => " allegation ",
        " incross "                 => " amalgam ",
        " incrust "                 => " apply ",
        " incrustation "            => " band ",
        " incubate "                => " bear ",
        " incubation "              => " evolution ",
        " incubus "                 => " affliction ",
        " inculcate "               => " brainwash ",
        " inculcation "             => " conduct ",
        " inculpability "           => " chastity ",
        " inculpate "               => " allege ",
        " inculpation "             => " accusation ",
        " incult "                  => " base ",
        " incumbency "              => " incumbency ",
        " incumbent "               => " bounden ",
        " incur "                   => " acquire ",
        " incurable "               => " cureless ",
        " incuriosity "             => " apathy ",
        " incurious "               => " above ",
        " incursion "               => " aggression ",
        " incurvature "             => " ambit ",
        " incurved "                => " biconcave ",
        " incurving "               => " agee ",
        " indebt "                  => " astrict ",
        " indebted "                => " accountable ",
        " indebtedness "            => " acknowledgment ",
        " indecency "               => " bawdiness ",
        " indecent "                => " blue ",
        " indecipherable "          => " awkward ",
        " indecision "              => " agnosticism ",
        " indecisive "              => " changeable ",
        " indecisiveness "          => " averseness ",
        " indecorous "              => " blue ",
        " indecorum "               => " boner ",
        " indeed "                  => " absolutely ",
        " indefatigability "        => " backbone ",
        " indefatigable "           => " active ",
        " indefatigably "           => " agilely ",
        " indefinable "             => " ambiguous ",
        " indefinite "              => " broad ",
        " indelible "               => " enduring ",
        " indelicacy "              => " bawdiness ",
        " indelicate "              => " base ",
        " indemnification "         => " apology ",
        " indemnify "               => " atone ",
        " indemnity "               => " apology ",
        " indent "                  => " bash ",
        " indentation "             => " angle ",
        " indented "                => " biconcave ",
        " indenture "               => " acknowledgment ",
        " indentured "              => " attached ",
        " independence "            => " ability ",
        " independent "             => " absolute ",
        " independently "           => " apart ",
        " indescribable "           => " impossible ",
        " indestructible "          => " abiding ",
        " indeterminable "          => " broad ",
        " indeterminate "           => " general ",
        " index "                   => " basis ",
        " indicant "                => " basis ",
        " indicate "                => " announce ",
        " indicated "               => " adumbrated ",
        " indicating "              => " advertence ",
        " indication "              => " adumbration ",
        " indications "             => " break ",
        " indicative "              => " apocalyptic ",
        " indicatively "            => " accurately ",
        " indicatory "              => " apocalyptic ",
        " indicia "                 => " affirmation ",
        " indicial "                => " apocalyptic ",
        " indict "                  => " arraign ",
        " indictable "              => " bent ",
        " indicted "                => " accusable ",
        " indictment "              => " allegation ",
        " indifference "            => " alienation ",
        " indifferent "             => " aloof ",
        " indifferently "           => " agilely ",
        " indigence "               => " defalcation ",
        " indigenous "              => " aboriginal ",
        " indigent "                => " busted ",
        " indigestible "            => " boxy ",
        " indignant "               => " acrimonious ",
        " indignation "             => " animus ",
        " indignity "               => " abuse ",
        " indigo "                  => " azure ",
        " indirect "                => " aberrant ",
        " indirectly "              => " alongside ",
        " indirectness "            => " circumambages ",
        " indiscipline "            => " ataxia ",
        " indisciplined "           => " boisterous ",
        " indiscreet "              => " audacious ",
        " indiscreetly "            => " absurdly ",
        " indiscreetness "          => " bloomer ",
        " indiscrete "              => " complete ",
        " indiscretion "            => " bloomer ",
        " indiscriminate "          => " aimless ",
        " indispensability "        => " call ",
        " indispensable "           => " basal ",
        " indispose "               => " acquire ",
        " indisposed "              => " ailing ",
        " indisputable "            => " absolute ",
        " indisputably "            => " absolutely ",
        " indissoluble "            => " bounden ",
        " indistinct "              => " ambiguous ",
        " indistinctness "          => " brume ",
        " indistinguishability "    => " adequation ",
        " indistinguishable "       => " duplicate ",
        " indite "                  => " author ",
        " individual "              => " alone ",
        " individualism "           => " appearance ",
        " individualist "           => " egoistic ",
        " individualistic "         => " appropriate ",
        " individualistically "     => " alone ",
        " individualized "          => " abundant ",
        " individualizing "         => " appropriate ",
        " individually "            => " alone ",
        " individuation "           => " analogue ",
        " indivisibility "          => " accord ",
        " indivisible "             => " alone ",
        " indocile "                => " awkward ",
        " indoctrination "          => " conduct ",
        " indolence "               => " dawdling ",
        " indolent "                => " blah ",
        " indomitability "          => " courage ",
        " indomitable "             => " dogged ",
        " indomitableness "         => " backbone ",
        " indoor "                  => " calm ",
        " indoors "                 => " central ",
        " indubitable "             => " absolute ",
        " indubitableness "         => " authoritativeness ",
        " indubitably "             => " clearly ",
        " induce "                  => " abet ",
        " inducement "              => " attraction ",
        " induct "                  => " conscript ",
        " induction "               => " consecration ",
        " inductive "               => " anterior ",
        " indulge "                 => " allow ",
        " indulged "                => " advantaged ",
        " indulgence "              => " allowance ",
        " indurate "                => " caked ",
        " indurated "               => " apathetic ",
        " industrial "              => " automated ",
        " industrialism "           => " affairs ",
        " industrialist "           => " baron ",
        " industrialized "          => " automated ",
        " industrious "             => " active ",
        " industriously "           => " agilely ",
        " indwell "                 => " abide ",
        " indweller "               => " citizen ",
        " indwelling "              => " congenital ",
        " inearth "                 => " coffin ",
        " inebriant "               => " brewed ",
        " inebriating "             => " brewed ",
        " ineffaceable "            => " enduring ",
        " ineffective "             => " abortive ",
        " ineffectively "           => " abominably ",
        " ineffectiveness "         => " disability ",
        " ineffectual "             => " bootless ",
        " ineffectualness "         => " debility ",
        " inefficacious "           => " abstract ",
        " inefficiency "            => " disability ",
        " inelaborate "             => " apathetic ",
        " inelastic "               => " breakable ",
        " inelasticity "            => " compactness ",
        " inelegance "              => " amateurishness ",
        " inelegant "               => " awkward ",
        " ineligibility "           => " awkwardness ",
        " ineligible "              => " disqualified ",
        " ineludible "              => " assured ",
        " ineptitude "              => " amateurishness ",
        " ineptly "                 => " abominably ",
        " ineptness "               => " amateurishness ",
        " inequality "              => " asperity ",
        " inequitable "             => " caitiff ",
        " inequity "                => " bigotry ",
        " ineradicable "            => " abiding ",
        " inerasable "              => " enduring ",
        " inerrable "               => " acceptable ",
        " inerrant "                => " acceptable ",
        " inert "                   => " apathetic ",
        " inertia "                 => " apathy ",
        " inertness "               => " affluence ",
        " inerudite "               => " benighted ",
        " inescapable "             => " assured ",
        " inescapably "             => " assuredly ",
        " inessential "             => " disposable ",
        " inestimable "             => " costive ",
        " inevasible "              => " approaching ",
        " inevitability "           => " authoritativeness ",
        " inevitable "              => " assured ",
        " inevitableness "          => " certitude ",
        " inevitably "              => " accordingly ",
        " inexactness "             => " aberration ",
        " inexcitable "             => " apathetic ",
        " inexcusable "             => " blamable ",
        " inexecutable "            => " absurd ",
        " inexhaustible "           => " great ",
        " inexorable "              => " adamant ",
        " inexorableness "          => " call ",
        " inexorably "              => " atrociously ",
        " inexpedient "             => " adverse ",
        " inexpensive "             => " bargain ",
        " inexperience "            => " affliction ",
        " inexperienced "           => " amateur ",
        " inexpertness "            => " amateurishness ",
        " inexplainable "           => " baffling ",
        " inexplicable "            => " baffling ",
        " inexplicit "              => " cryptic ",
        " inexpressible "           => " impossible ",
        " inexpressive "            => " deadpan ",
        " inexpungible "            => " enduring ",
        " inexterminable "          => " abiding ",
        " inextirpable "            => " enduring ",
        " inextricable "            => " adherent ",
        " inextricably "            => " accordingly ",
        " infallibility "           => " accuracy ",
        " infallible "              => " acceptable ",
        " infallibly "              => " absolutely ",
        " infamous "                => " abominable ",
        " infamy "                  => " abomination ",
        " infancy "                 => " adolescence ",
        " infant "                  => " baby ",
        " infantile "               => " baby ",
        " infantine "               => " baby ",
        " infants "                 => " breed ",
        " infarct "                 => " barricade ",
        " infatuate "               => " allure ",
        " infatuated "              => " beguiled ",
        " infatuating "             => " absorbing ",
        " infatuation "             => " admiration ",
        " infeasible "              => " absurd ",
        " infect "                  => " affect ",
        " infected "                => " adulterated ",
        " infectious "              => " communicable ",
        " infective "               => " communicable ",
        " infecund "                => " arid ",
        " infelicitous "            => " awkward ",
        " infelicity "              => " affliction ",
        " inferential "             => " amplified ",
        " infernal "                => " accursed ",
        " inferno "                 => " blaze ",
        " inferred "                => " accepted ",
        " inferring "               => " answer ",
        " infertile "               => " barren ",
        " infest "                  => " abound ",
        " infestation "             => " bane ",
        " infestive "               => " alarming ",
        " infidel "                 => " agnostic ",
        " infidelity "              => " adultery ",
        " infiltrate "              => " access ",
        " infiltrating "            => " entering ",
        " infiltration "            => " aggression ",
        " infiltrator "             => " burglar ",
        " infinite "                => " absolute ",
        " infinitely "              => " always ",
        " infiniteness "            => " aeon ",
        " infinitesimal "           => " atomic ",
        " infinitude "              => " aeon ",
        " infinity "                => " beyond ",
        " infirm "                  => " ailing ",
        " infirmary "               => " dispensary ",
        " infirmity "               => " affliction ",
        " infirmness "              => " debility ",
        " infix "                   => " bury ",
        " infixed "                 => " absolute ",
        " inflame "                 => " aggravate ",
        " inflamed "                => " affronted ",
        " inflamer "                => " agitator ",
        " inflaming "               => " anarchic ",
        " inflammable "             => " burnable ",
        " inflammation "            => " deepening ",
        " inflammatory "            => " anarchic ",
        " inflate "                 => " aerate ",
        " inflated "                => " aggrandized ",
        " inflation "               => " aggrandizement ",
        " inflatus "                => " afflatus ",
        " inflection "              => " articulation ",
        " inflexibility "           => " acerbity ",
        " inflexible "              => " adamant ",
        " inflexibly "              => " durably ",
        " inflict "                 => " administer ",
        " infliction "              => " accident ",
        " inflorescence "           => " bloom ",
        " inflow "                  => " arrival ",
        " inflowing "               => " flood ",
        " influence "               => " access ",
        " influenceable "           => " affectable ",
        " influenced "              => " afflicted ",
        " influencible "            => " acquiescent ",
        " influential "             => " affecting ",
        " influenza "               => " affliction ",
        " influx "                  => " arrival ",
        " info "                    => " advice ",
        " inform "                  => " acquaint ",
        " informal "                => " breezy ",
        " informality "             => " adroitness ",
        " informally "              => " artlessly ",
        " informant "               => " adviser ",
        " information "             => " advice ",
        " informational "           => " advisory ",
        " informative "             => " advisory ",
        " informed "                => " abreast ",
        " informer "                => " accuser ",
        " informing "               => " allegorical ",
        " infract "                 => " breach ",
        " infraction "              => " breach ",
        " infrangible "             => " adamantine ",
        " infrared "                => " bittersweet ",
        " infrastructure "          => " basement ",
        " infrequency "             => " absence ",
        " infrequent "              => " exceptional ",
        " infringe "                => " borrow ",
        " infringed "               => " abandoned ",
        " infringement "            => " contravention ",
        " infringing "              => " anarchic ",
        " infundibular "            => " alveolate ",
        " infuriated "              => " affronted ",
        " infuriation "             => " acrimony ",
        " infuse "                  => " animate ",
        " infused "                 => " alloyed ",
        " infusion "                => " beverage ",
        " ingather "                => " crop ",
        " ingathering "             => " autumn ",
        " ingemination "            => " alliteration ",
        " ingenerate "              => " built-in ",
        " ingenious "               => " able ",
        " ingeniousness "           => " ability ",
        " ingenue "                 => " amateur ",
        " ingenuity "               => " adeptness ",
        " ingenuous "               => " artless ",
        " ingenuously "             => " aboveboard ",
        " ingenuousness "           => " artlessness ",
        " ingest "                  => " blot ",
        " ingestion "               => " assimilation ",
        " inglenook "               => " alcove ",
        " inglorious "              => " blameworthy ",
        " ingloriousness "          => " abasement ",
        " ingoing "                 => " acid ",
        " ingot "                   => " batten ",
        " ingraft "                 => " affix ",
        " ingrain "                 => " bury ",
        " ingrained "               => " built-in ",
        " ingratiating "            => " attractive ",
        " ingratiation "            => " adulation ",
        " ingratiatory "            => " civil ",
        " ingredient "              => " additive ",
        " ingredients "             => " capacity ",
        " ingress "                 => " admission ",
        " ingression "              => " access ",
        " ingurgitate "             => " blot ",
        " inhabit "                 => " abide ",
        " inhabitable "             => " adequate ",
        " inhabitance "             => " control ",
        " inhabitancy "             => " control ",
        " inhabitant "              => " aborigine ",
        " inhabitants "             => " citizenry ",
        " inhabitation "            => " habitation ",
        " inhabiter "               => " citizen ",
        " inhabitually "            => " hardly ",
        " inhalant "                => " analgesic ",
        " inhalation "              => " assimilation ",
        " inhale "                  => " drag ",
        " inharmonic "              => " cacophonic ",
        " inharmonious "            => " clinking ",
        " inharmoniousness "        => " clash ",
        " inharmony "               => " animosity ",
        " inhere "                  => " accord ",
        " inherit "                 => " accede ",
        " inheritable "             => " ancestral ",
        " inheritance "             => " bequest ",
        " inherited "               => " affiliated ",
        " inheritor "               => " almsman ",
        " inheritress "             => " beneficiary ",
        " inheritrix "              => " beneficiary ",
        " inhibit "                 => " arrest ",
        " inhospitable "            => " brusque ",
        " inhuman "                 => " barbaric ",
        " inhumane "                => " atrocious ",
        " inhumanely "              => " atrociously ",
        " inhumanity "              => " abomination ",
        " inhumanly "               => " atrociously ",
        " inhumation "              => " burying ",
        " inhume "                  => " coffin ",
        " inimical "                => " adverse ",
        " inimicality "             => " abhorrence ",
        " inimitable "              => " consummate ",
        " inimitably "              => " abundantly ",
        " iniquitous "              => " base ",
        " iniquity "                => " abomination ",
        " initial "                 => " antecedent ",
        " initialism "              => " abridgement ",
        " initials "                => " brand ",
        " initiate "                => " admit ",
        " initiated "               => " accomplished ",
        " initiation "              => " admission ",
        " initiative "              => " action ",
        " initiator "               => " architect ",
        " initiatory "              => " basic ",
        " injection "               => " bang ",
        " injudicious "             => " approximate ",
        " injudiciously "           => " absurdly ",
        " injunction "              => " admonition ",
        " injure "                  => " abuse ",
        " injured "                 => " afflicted ",
        " injuring "                => " abasing ",
        " injurious "               => " abusive ",
        " injury "                  => " abrasion ",
        " injustice "               => " abuse ",
        " inked "                   => " active ",
        " inklike "                 => " atramentous ",
        " inkling "                 => " clue ",
        " inky "                    => " aphotic ",
        " inland "                  => " civil ",
        " inlay "                   => " applique ",
        " inlet "                   => " basin ",
        " inmate "                  => " bedfellow ",
        " inmost "                  => " centermost ",
        " innards "                 => " belly ",
        " innate "                  => " congenital ",
        " inner "                   => " close ",
        " inner-city "              => " burghal ",
        " inner-directed "          => " affected ",
        " innermore "               => " close ",
        " innermost "               => " centermost ",
        " innervate "               => " animate ",
        " innervation "             => " activity ",
        " innerve "                 => " actuate ",
        " innocence "               => " chastity ",
        " innocently "              => " artlessly ",
        " innocuous "               => " banal ",
        " innominate "              => " bearding ",
        " innovation "              => " addition ",
        " innovational "            => " artistic ",
        " innovative "              => " avant-garde ",
        " innovativeness "          => " bloom ",
        " innovatory "              => " artistic ",
        " innoxious "               => " controllable ",
        " innuendo "                => " allusion ",
        " innumerous "              => " endless ",
        " inobnoxious "             => " artless ",
        " inobservant "             => " absent ",
        " inobtrusive "             => " conservative ",
        " inoculable "              => " catching ",
        " inoculate "               => " bathe ",
        " inoculation "             => " bang ",
        " inoffensive "             => " calm ",
        " inoperable "              => " busted ",
        " inoperative "             => " barren ",
        " inopportune "             => " contrary ",
        " inopportuneness "         => " delicacy ",
        " inordinate "              => " disproportionate ",
        " inordinately "            => " awfully ",
        " inordinateness "          => " debauchery ",
        " inorganic "               => " asleep ",
        " inpouring "               => " arrival ",
        " input "                   => " ascribe ",
        " inquest "                 => " delving ",
        " inquietude "              => " ache ",
        " inquire "                 => " analyze ",
        " inquirer "                => " appellant ",
        " inquiringness "           => " concern ",
        " inquiry "                 => " analysis ",
        " inquisition "             => " assay ",
        " inquisitive "             => " analytical ",
        " inquisitiveness "         => " concern ",
        " inquisitorial "           => " analytical ",
        " inquisitory "             => " eavesdropping ",
        " inquisiturient "          => " analytical ",
        " inroad "                  => " encroachment ",
        " inroads "                 => " appropriate ",
        " inrush "                  => " arrival ",
        " insane "                  => " batty ",
        " insanely "                => " crazily ",
        " insanity "                => " aberration ",
        " insatiable "              => " clamorous ",
        " insatiableness "          => " acquisitiveness ",
        " insatiate "               => " acquisitive ",
        " inscience "               => " benightedness ",
        " inscribe "                => " book ",
        " inscribing "              => " block ",
        " inscrutability "          => " concealment ",
        " inscrutable "             => " ambiguous ",
        " inscrutableness "         => " abstruseness ",
        " insecure "                => " afraid ",
        " insecurity "              => " crisis ",
        " inseminate "              => " beget ",
        " insemination "            => " formation ",
        " insensate "               => " apathetic ",
        " insensibility "           => " aloofness ",
        " insensible "              => " blah ",
        " insensibleness "          => " abeyance ",
        " insensitive "             => " aloof ",
        " insensitiveness "         => " animality ",
        " insensitivity "           => " aloofness ",
        " insentience "             => " asleep ",
        " insentient "              => " apathetic ",
        " inseparability "          => " adherence ",
        " inseparableness "         => " adherence ",
        " inseparably "             => " accordingly ",
        " insert "                  => " admit ",
        " inserted "                => " amid ",
        " insertion "               => " admittance ",
        " inside "                  => " central ",
        " inside-out "              => " chaotic ",
        " insider "                 => " cabal ",
        " insiders "                => " assembly ",
        " insides "                 => " abdomen ",
        " insidiousness "           => " artifice ",
        " insight "                 => " acumen ",
        " insighted "               => " acute ",
        " insightful "              => " astute ",
        " insignia "                => " badge ",
        " insignificance "          => " debility ",
        " insignificancy "          => " blank ",
        " insignificant "           => " bush ",
        " insignificantly "         => " hardly ",
        " insinuate "               => " allude ",
        " insinuated "              => " adumbrated ",
        " insinuating "             => " civil ",
        " insinuation "             => " allegation ",
        " insinuative "             => " civil ",
        " insinuendo "              => " allusion ",
        " insipid "                 => " anemic ",
        " insipidity "              => " asininity ",
        " insist "                  => " assert ",
        " insistence "              => " affirmation ",
        " insistent "               => " assertive ",
        " insistive "               => " absolute ",
        " insolate "                => " insolate ",
        " insolence "               => " abuse ",
        " insolency "               => " boldness ",
        " insolent "                => " abusive ",
        " insolentness "            => " boldness ",
        " insoluble "               => " baffling ",
        " insolvency "              => " defalcation ",
        " insolvent "               => " bankrupt ",
        " insomnia "                => " indisposition ",
        " insomniac "               => " alive ",
        " insomnious "              => " alive ",
        " insomnolence "            => " indisposition ",
        " insouciance "             => " aloofness ",
        " insouciant "              => " airy ",
        " inspect "                 => " audit ",
        " inspecting "              => " analytical ",
        " inspection "              => " analysis ",
        " inspector "               => " ambassador ",
        " inspiration "             => " afflatus ",
        " inspirational "           => " adorning ",
        " inspire "                 => " affect ",
        " inspired "                => " aggressive ",
        " inspiring "               => " alarming ",
        " inspirit "                => " activate ",
        " inspiriting "             => " abating ",
        " inspiritment "            => " advance ",
        " inspissate "              => " coalesce ",
        " inspissation "            => " agglomeration ",
        " instability "             => " alternation ",
        " installation "            => " accession ",
        " installment "             => " chapter ",
        " instanced "               => " abstract ",
        " instant "                 => " burning ",
        " instantaneous "           => " direct ",
        " instantaneously "         => " anon ",
        " instanter "               => " anon ",
        " instatement "             => " consecration ",
        " instigate "               => " abet ",
        " instigation "             => " account ",
        " instigative "             => " anarchic ",
        " instigator "              => " agitator ",
        " instill "                 => " brainwash ",
        " instillation "            => " beverage ",
        " instilled "               => " absolute ",
        " instinct "                => " aptitude ",
        " instinctive "             => " accustomed ",
        " instinctively "           => " aimlessly ",
        " instinctual "             => " autogenetic ",
        " institute "               => " convention ",
        " institution "             => " academy ",
        " institutionalize "        => " allocate ",
        " institutor "              => " architect ",
        " instruct "                => " acquaint ",
        " instruction "             => " apprenticeship ",
        " instructional "           => " advisory ",
        " instructive "             => " adorning ",
        " instructor "              => " adviser ",
        " instructors "             => " advisers ",
        " instructorship "          => " captain ",
        " instrument "              => " apparatus ",
        " instrumental "            => " active ",
        " instrumentality "         => " action ",
        " instrumentation "         => " chart ",
        " insubmission "            => " defiance ",
        " insubmissive "            => " aggressive ",
        " insubordinate "           => " contrary ",
        " insubordination "         => " affront ",
        " insubstantial "           => " aerial ",
        " insufferable "            => " detestable ",
        " insufficience "           => " absence ",
        " insufficiency "           => " dearth ",
        " insufficient "            => " bereft ",
        " insufficiently "          => " comparatively ",
        " insufflation "            => " animation ",
        " insular "                 => " alone ",
        " insulated "               => " cloistral ",
        " insulating "              => " careful ",
        " insulted "                => " angered ",
        " insulting "               => " calumniating ",
        " insults "                 => " blame ",
        " insuperable "             => " dogged ",
        " insupposable "            => " extraordinary ",
        " insurance "               => " allowance ",
        " insure "                  => " assure ",
        " insurgency "              => " affront ",
        " insurgent "               => " anarchical ",
        " insurrect "               => " balk ",
        " insurrection "            => " coup ",
        " insurrectionary "         => " alienated ",
        " insurrectionist "         => " agitator ",
        " insusceptible "           => " allowed ",
        " intact "                  => " complete ",
        " intactness "              => " absoluteness ",
        " intaglio "                => " bite ",
        " intake "                  => " assimilation ",
        " intaking "                => " acceptance ",
        " intangible "              => " abstract ",
        " intangibles "             => " affluence ",
        " integer "                 => " accumulation ",
        " integral "                => " basic ",
        " integrality "             => " absoluteness ",
        " integrant "               => " affection ",
        " integrate "               => " accommodate ",
        " integrated "              => " chip ",
        " integrating "             => " amalgam ",
        " integration "             => " affiliation ",
        " integrative "             => " commutual ",
        " integrity "               => " candor ",
        " intellect "               => " ability ",
        " intellection "            => " abstraction ",
        " intellective "            => " bookish ",
        " intellectual "            => " bookish ",
        " intellectuality "         => " bookishness ",
        " intelligencer "           => " bagman ",
        " intelligent "             => " able ",
        " intelligentsia "          => " ancestry ",
        " intelligibility "         => " accuracy ",
        " intelligible "            => " apprehensible ",
        " intelligibly "            => " audibly ",
        " intemerate "              => " austere ",
        " intemperance "            => " carelessness ",
        " intemperate "             => " afflictive ",
        " intemperateness "         => " allowance ",
        " intendance "              => " care ",
        " intended "                => " advised ",
        " intendment "              => " action ",
        " intensate "               => " aggravate ",
        " intense "                 => " acute ",
        " intensely "               => " acutely ",
        " intenseness "             => " acuteness ",
        " intensification "         => " accession ",
        " intensified "             => " agitated ",
        " intensify "               => " accent ",
        " intensifying "            => " accumulative ",
        " intensity "               => " acuteness ",
        " intensive "               => " accelerated ",
        " intensively "             => " assiduously ",
        " intent "                  => " absorbed ",
        " intention "               => " ambition ",
        " intentional "             => " advised ",
        " intentionally "           => " carefully ",
        " intentive "               => " advertent ",
        " intently "                => " attentively ",
        " intentness "              => " captivation ",
        " interact "                => " collaborate ",
        " interaction "             => " alternation ",
        " interactive "             => " alternate ",
        " interagent "              => " agent ",
        " interblend "              => " amalgamate ",
        " interbred "               => " alloyed ",
        " interbreed "              => " blend ",
        " intercalate "             => " admit ",
        " intercede "               => " advocate ",
        " interceder "              => " agent ",
        " intercept "               => " ambush ",
        " intercession "            => " action ",
        " intercessor "             => " agent ",
        " interchange "             => " altering ",
        " interchangeability "      => " adequation ",
        " interchangeable "         => " changeable ",
        " interchangeableness "     => " adequation ",
        " interchanged "            => " alternate ",
        " intercommunication "      => " advice ",
        " interconnected "          => " commutual ",
        " interconnecting "         => " abutting ",
        " interconnection "         => " alternation ",
        " interconnections "        => " arrangement ",
        " interconvertible "        => " changeable ",
        " intercourse "             => " action ",
        " intercross "              => " bisect ",
        " interdenominational "     => " alloyed ",
        " interdependence "         => " alternation ",
        " interdependency "         => " assurance ",
        " interdependent "          => " commutual ",
        " interdict "               => " banish ",
        " interdicted "             => " banned ",
        " interdiction "            => " boycott ",
        " interest "                => " absorption ",
        " interested "              => " absorbed ",
        " interestedness "          => " absorption ",
        " interesting "             => " absorbing ",
        " interestingness "         => " allure ",
        " interfere "               => " baffle ",
        " interference "            => " arrest ",
        " interferer "              => " burglar ",
        " interfold "               => " braid ",
        " interfusion "             => " alloy ",
        " interim "                 => " acting ",
        " interior "                => " autogenous ",
        " interjection "            => " assertion ",
        " interknit "               => " complect ",
        " interlace "               => " complect ",
        " interlacing "             => " cobweb ",
        " interlard "               => " bestrew ",
        " interlineate "            => " accentuate ",
        " interlink "               => " braid ",
        " interlock "               => " accord ",
        " interlocking "            => " chain ",
        " interlocution "           => " chat ",
        " interlope "               => " encroach ",
        " interloper "              => " alien ",
        " interlude "               => " break ",
        " intermeddle "             => " baffle ",
        " intermeddling "           => " arrest ",
        " intermediacy "            => " axis ",
        " intermediary "            => " agent ",
        " intermediate "            => " average ",
        " intermediator "           => " agent ",
        " intermedium "             => " adjudicator ",
        " interment "               => " burying ",
        " interminable "            => " boring ",
        " interminate "             => " ceaseless ",
        " intermingle "             => " amalgamate ",
        " intermission "            => " abeyance ",
        " intermittent "            => " alternate ",
        " intermix "                => " alloy ",
        " intermixture "            => " admixture ",
        " intermutual "             => " accepted ",
        " internal "                => " centralized ",
        " international "           => " all-embracing ",
        " internecine "             => " baleful ",
        " internecion "             => " annihilation ",
        " internee "                => " bondman ",
        " internment "              => " bondage ",
        " internuncio "             => " agent ",
        " interplay "               => " coaction ",
        " interpolate "             => " admit ",
        " interpolated "            => " amid ",
        " interpolation "           => " departure ",
        " interpose "               => " adjudge ",
        " interposed "              => " average ",
        " interposing "             => " busy ",
        " interposition "           => " departure ",
        " interpret "               => " adapt ",
        " interpretation "          => " estimation ",
        " interpreter "             => " analyst ",
        " interpretive "            => " analytic ",
        " interreact "              => " collaborate ",
        " interregnum "             => " breach ",
        " interrelated "            => " commutual ",
        " interrelating "           => " commutual ",
        " interrelation "           => " accord ",
        " interrelationship "       => " affiliation ",
        " interrogate "             => " catechize ",
        " interrogation "           => " claiming ",
        " interrogatory "           => " analysis ",
        " interrupt "               => " arrest ",
        " interrupted "             => " disconnected ",
        " interrupter "             => " burglar ",
        " interrupting "            => " arresting ",
        " interruption "            => " abeyance ",
        " intersect "               => " bisect ",
        " intersection "            => " circle ",
        " intersow "                => " bestrew ",
        " interspace "              => " aperture ",
        " intersperse "             => " bestrew ",
        " intersprinkle "           => " bestrew ",
        " interstate "              => " artery ",
        " interstice "              => " aperture ",
        " intertwine "              => " associate ",
        " intertwist "              => " associate ",
        " interurban "              => " burghal ",
        " interval "                => " breach ",
        " intervene "               => " arbitrate ",
        " intervening "             => " amid ",
        " intervention "            => " action ",
        " interview "               => " account ",
        " interviewer "             => " accuser ",
        " intervolve "              => " convolute ",
        " interwind "               => " associate ",
        " interwoven "              => " abstruse ",
        " interwreathe "            => " associate ",
        " intestinal "              => " abdominal ",
        " intestine "               => " civil ",
        " intestines "              => " belly ",
        " intimacy "                => " acquaintance ",
        " intimate "                => " affectionate ",
        " intimately "              => " carefully ",
        " intimates "               => " assembly ",
        " intimation "              => " allusion ",
        " intimidate "              => " alarm ",
        " intimidated "             => " abashed ",
        " intimidating "            => " alarming ",
        " intimidation "            => " browbeating ",
        " intimidator "             => " annoyer ",
        " intimidatory "            => " alarming ",
        " intolerance "             => " bent ",
        " intolerant "              => " antipathetic ",
        " intonated "               => " articulate ",
        " intonation "              => " accentuation ",
        " intone "                  => " carol ",
        " intoner "                 => " accompanist ",
        " intorsion "               => " baloney ",
        " intoxicant "              => " booze ",
        " intoxicate "              => " addle ",
        " intoxicated "             => " bagged ",
        " intoxicating "            => " exhilarant ",
        " intoxication "            => " beatitude ",
        " intra "                   => " after ",
        " intractable "             => " awkward ",
        " intractableness "         => " affront ",
        " intramural "              => " civil ",
        " intransigence "           => " attrition ",
        " intransigent "            => " determined ",
        " intraurban "              => " burghal ",
        " intrepid "                => " audacious ",
        " intrepidity "             => " adventurousness ",
        " intricacy "               => " complication ",
        " intricateness "           => " ataxia ",
        " intrigue "                => " artifice ",
        " intrigued "               => " absorbed ",
        " intriguing "              => " arresting ",
        " intrinsic "               => " built-in ",
        " intrique "                => " amour ",
        " intro "                   => " addition ",
        " introduce "               => " acquaint ",
        " introduced "              => " alien ",
        " introducer "              => " administrator ",
        " introduction "            => " addition ",
        " introductory "            => " anterior ",
        " introspection "           => " brooding ",
        " introspective "           => " attentive ",
        " introversion "            => " brooding ",
        " introvert "               => " autist ",
        " introverted "             => " alienated ",
        " introvertive "            => " abstracted ",
        " intruder "                => " burglar ",
        " intruding "               => " advancing ",
        " intrusion "               => " advance ",
        " intrusive "               => " advancing ",
        " intrusiveness "           => " concern ",
        " intrust "                 => " allocate ",
        " intrusting "              => " commitment ",
        " intuit "                  => " adjudge ",
        " intuitional "             => " accustomed ",
        " intuitive "               => " automatic ",
        " intuitively "             => " allegedly ",
        " intumescence "            => " appendage ",
        " inundate "                => " deluge ",
        " inundation "              => " barrage ",
        " inurbane "                => " abrupt ",
        " inure "                   => " accustom ",
        " inured "                  => " acclimatized ",
        " inurn "                   => " coffin ",
        " inutile "                 => " abortive ",
        " invade "                  => " access ",
        " invader "                 => " face ",
        " invading "                => " advancing ",
        " invalidating "            => " abandoning ",
        " invalidation "            => " abolishment ",
        " invalided "               => " bedfast ",
        " invalidity "              => " affliction ",
        " invariability "           => " accord ",
        " invariable "              => " changeless ",
        " invariably "              => " consistently ",
        " invasion "                => " aggression ",
        " invective "               => " accusation ",
        " inveigh "                 => " admonish ",
        " inveigle "                => " allure ",
        " inveiglement "            => " attraction ",
        " inveigling "              => " convincing ",
        " invent "                  => " ad-lib ",
        " invention "               => " apparatus ",
        " inventive "               => " adroit ",
        " inventiveness "           => " adroitness ",
        " inventor "                => " artist ",
        " inventory "               => " account ",
        " inverse "                 => " changed ",
        " inversion "               => " antagonism ",
        " invert "                  => " alter ",
        " invertebrate "            => " bearcat ",
        " inverted "                => " astern ",
        " invest "                  => " advance ",
        " investigated "            => " advised ",
        " investigation "           => " analysis ",
        " investigative "           => " analytic ",
        " investigators "           => " board ",
        " investing "               => " advance ",
        " investment "              => " advance ",
        " investor "                => " broker ",
        " inveterate "              => " abiding ",
        " invidious "               => " abominable ",
        " invidiousness "           => " backbiting ",
        " invigilator "             => " adviser ",
        " invigorate "              => " activate ",
        " invigorated "             => " active ",
        " invigorating "            => " aesthetic ",
        " invigoration "            => " advance ",
        " invigorator "             => " analeptic ",
        " invincibility "           => " backbone ",
        " invincible "              => " bulletproof ",
        " inviolability "           => " asceticism ",
        " inviolable "              => " adored ",
        " invisible "               => " airy ",
        " invitation "              => " allurement ",
        " invite "                  => " allure ",
        " invited "                 => " arrive ",
        " invitee "                 => " honoree ",
        " inviting "                => " agreeable ",
        " invocate "                => " adjure ",
        " invocation "              => " abracadabra ",
        " invoice "                 => " balance ",
        " invoke "                  => " adjure ",
        " involuntary "             => " automatic ",
        " involute "                => " anfractuous ",
        " involution "              => " braid ",
        " involve "                 => " absorb ",
        " involved "                => " complex ",
        " involvement "             => " captivation ",
        " invulnerability "         => " amnesty ",
        " invulnerable "            => " incontestable ",
        " inward "                  => " entering ",
        " inward-looking "          => " alone ",
        " inwardness "              => " acquaintance ",
        " inwrought "               => " built-in ",
        " iota "                    => " atom ",
        " ipseity "                 => " character ",
        " irascibility "            => " acerbity ",
        " irascible "               => " angry ",
        " irate "                   => " angered ",
        " ireful "                  => " acerbic ",
        " irenic "                  => " appeasing ",
        " iridescence "             => " blush ",
        " iridescent "              => " irised ",
        " irised "                  => " irised ",
        " irked "                   => " annoyed ",
        " irking "                  => " aggravation ",
        " irksome "                 => " arid ",
        " irksomeness "             => " apathy ",
        " iron "                    => " adamant ",
        " iron-fisted "             => " barbarous ",
        " iron-handed "             => " absolute ",
        " iron-hearted "            => " anesthetized ",
        " ironclad "                => " active ",
        " ironfisted "              => " cruel ",
        " ironhanded "              => " backbreaking ",
        " ironic "                  => " acrid ",
        " ironical "                => " caricatural ",
        " ironing "                 => " bed-making ",
        " irons "                   => " band ",
        " ironware "                => " accouterments ",
        " irradiant "               => " beaming ",
        " irradiate "               => " brighten ",
        " irradiated "              => " ablaze ",
        " irradiation "             => " betterment ",
        " irrational "              => " aberrant ",
        " irrationality "           => " applesauce ",
        " irrationally "            => " crazily ",
        " irrebuttable "            => " accurate ",
        " irreconcilable "          => " clashing ",
        " irreflective "            => " daydreaming ",
        " irrefragable "            => " abiding ",
        " irrefrangible "           => " absolute ",
        " irrefutable "             => " accurate ",
        " irrefutably "             => " absolutely ",
        " irregular "               => " aberrant ",
        " irregularity "            => " abnormality ",
        " irregularly "             => " anyhow ",
        " irrelative "              => " accidental ",
        " irrelevant "              => " extraneous ",
        " irreligious "             => " cursing ",
        " irremissible "            => " binding ",
        " irresilient "             => " baggy ",
        " irresistible "            => " alluring ",
        " irresistibly "            => " angrily ",
        " irresolute "              => " changing ",
        " irresolution "            => " agnosticism ",
        " irresolvable "            => " baffling ",
        " irresponsibility "        => " absurdity ",
        " irresponsible "           => " capricious ",
        " irreverence "             => " blasphemy ",
        " irreverent "              => " aweless ",
        " irreverential "           => " abusive ",
        " irrevocability "          => " certitude ",
        " irrevocable "             => " certain ",
        " irrevocably "             => " assuredly ",
        " irrigate "                => " adulterate ",
        " irrigated "               => " anhydrous ",
        " irriguous "               => " clammy ",
        " irritability "            => " causticity ",
        " irritable "               => " annoyed ",
        " irritableness "           => " agitation ",
        " irritate "                => " abrade ",
        " irritated "               => " affronted ",
        " irritating "              => " acid ",
        " irritation "              => " affliction ",
        " irrupt "                  => " discharge ",
        " irruption "               => " advance ",
        " islander "                => " aborigine ",
        " isochronal "              => " accessory ",
        " isochronism "             => " aeon ",
        " isochronous "             => " accessory ",
        " isolate "                 => " abstract ",
        " isolated "                => " abandoned ",
        " isolation "               => " abreast ",
        " isolationism "            => " alienation ",
        " isolationist "            => " bourgeois ",
        " isonomy "                 => " adequation ",
        " issuance "                => " arising ",
        " issue "                   => " affair ",
        " issuing "                 => " arising ",
        " italicize "               => " accent ",
        " itch "                    => " crawling ",
        " itchiness "               => " crawling ",
        " itching "                 => " agog ",
        " itchy "                   => " acquisitive ",
        " item "                    => " account ",
        " itemization "             => " analysis ",
        " itemize "                 => " catalog ",
        " iteracy "                 => " alliteration ",
        " iterance "                => " alliteration ",
        " iterant "                 => " alternate ",
        " iterated "                => " common ",
        " iterating "               => " bombastic ",
        " iteration "               => " abundance ",
        " iterative "               => " accepted ",
        " itinerant "               => " afoot ",
        " itinerary "               => " beat ",
        " itinerate "               => " drifting ",
        " itsy-bitsy "              => " atom ",
        " jabbering "               => " blubbering ",
        " jackass "                 => " blockhead ",
        " jacket "                  => " anorak ",
        " jackhammer "              => " auger ",
        " jackleg "                 => " abecedarian ",
        " jacklight "               => " aurora ",
        " jade "                    => " afflict ",
        " jaded "                   => " blah ",
        " jadedness "               => " apathy ",
        " jading "                  => " annoying ",
        " jagged "                  => " asperous ",
        " jaguar "                  => " bobcat ",
        " jail "                    => " bastille ",
        " jailbait "                => " jailbait ",
        " jailbird "                => " captive ",
        " jailed "                  => " confined ",
        " jailhouse "               => " bastille ",
        " jailor "                  => " administrator ",
        " jake "                    => " boor ",
        " jalopy "                  => " auto ",
        " jalousie "                => " blind ",
        " jam-pack "                => " charge ",
        " jam-packed "              => " accommodation ",
        " jamb "                    => " axle ",
        " jammed "                  => " awash ",
        " jangle "                  => " babel ",
        " jangling "                => " antagonistic ",
        " jangly "                  => " clinking ",
        " janitor "                 => " attendant ",
        " japan "                   => " adorn ",
        " jape "                    => " banter ",
        " jargon "                  => " abracadabra ",
        " jarring "                 => " arrant ",
        " jaundiced "               => " biased ",
        " jaunt "                   => " adventure ",
        " jauntiness "              => " animation ",
        " jaunty "                  => " airy ",
        " jawbone "                 => " accommodation ",
        " jawbreaker "              => " bonbon ",
        " jaws "                    => " aperture ",
        " jaywalker "               => " ambler ",
        " jazz "                    => " applesauce ",
        " jazzed "                  => " active ",
        " jazzy "                   => " animated ",
        " jealous "                 => " anxious ",
        " jealousy "                => " annoyance ",
        " jeep "                    => " auto ",
        " jeer "                    => " banter ",
        " jeering "                 => " badinage ",
        " jejune "                  => " green ",
        " jell "                    => " clot ",
        " jelled "                  => " close ",
        " jellied "                 => " gelled ",
        " jellification "           => " agglomeration ",
        " jellified "               => " close ",
        " jellify "                 => " clabber ",
        " jelly "                   => " clabber ",
        " jelly-belly "             => " beefy ",
        " jelly-like "              => " gelled ",
        " jellybean "               => " green ",
        " jellyfish "               => " afraid ",
        " jellylike "               => " all-a-quiver ",
        " jeopardize "              => " attempt ",
        " jeopardous "              => " alarming ",
        " jeopardy "                => " accident ",
        " jerkily "                 => " anyhow ",
        " jerky "                   => " hasty ",
        " jeroboam "                => " alembic ",
        " jerry-built "             => " broken-down ",
        " jest "                    => " banter ",
        " jestee "                  => " chump ",
        " jesting "                 => " badinage ",
        " jesuitic "                => " abstract ",
        " jet-set "                 => " adult ",
        " jet-setter "              => " day-tripper ",
        " jet-setting "             => " drifting ",
        " jettison "                => " abandon ",
        " jettisoning "             => " auctioning ",
        " jetty "                   => " anchorage ",
        " jeweled "                 => " adorned ",
        " jewelry "                 => " adornment ",
        " jibe "                    => " accord ",
        " jibing "                  => " acrid ",
        " jiff "                    => " breath ",
        " jiffy "                   => " breath ",
        " jigger "                  => " accoutrement ",
        " jiggle "                  => " agitate ",
        " jillion "                 => " bulk ",
        " jilt "                    => " betray ",
        " jilted "                  => " alone ",
        " jimmy "                   => " assault ",
        " jingle "                  => " chime ",
        " jingo "                   => " angry ",
        " jingoism "                => " bellicism ",
        " jingoistic "              => " angry ",
        " jitters "                 => " anxiety ",
        " jittery "                 => " afraid ",
        " jive "                    => " applesauce ",
        " jivey "                   => " ambiguous ",
        " jiving "                  => " braggadocio ",
        " job-hunter "              => " applicant ",
        " jobbery "                 => " bribery ",
        " jobbie "                  => " commodity ",
        " jobby "                   => " apparatus ",
        " jobholder "               => " agent ",
        " jobless "                 => " abandoned ",
        " joblessness "             => " dawdling ",
        " jock "                    => " amateur ",
        " jockstrap "               => " audacious ",
        " jocose "                  => " amusing ",
        " jocoseness "              => " amusement ",
        " jocular "                 => " amusing ",
        " jocularity "              => " absurdity ",
        " jocund "                  => " animated ",
        " jocundity "               => " animation ",
        " jocundly "                => " acquiescently ",
        " johnny "                  => " head ",
        " join "                    => " accompany ",
        " joined "                  => " abutting ",
        " joiner "                  => " accessory ",
        " joining "                 => " abutting ",
        " joint "                   => " collective ",
        " jointly "                 => " accordingly ",
        " joist "                   => " axle ",
        " joke "                    => " antic ",
        " joker "                   => " actor ",
        " jokesmith "               => " antic ",
        " jokester "                => " antic ",
        " jokey "                   => " cool ",
        " joking "                  => " badinage ",
        " jollies "                 => " bliss ",
        " jollity "                 => " animation ",
        " jolly "                   => " blithe ",
        " jollying "                => " affable ",
        " jolt "                    => " blow ",
        " jolting "                 => " blow ",
        " josh "                    => " chaff ",
        " josher "                  => " actor ",
        " joshing "                 => " cool ",
        " jotter "                  => " block ",
        " jotting "                 => " account ",
        " jounce "                  => " agitate ",
        " journal "                 => " account ",
        " journalist "              => " announcer ",
        " journey "                 => " adventure ",
        " journeyer "               => " day-tripper ",
        " journeying "              => " afoot ",
        " journeyman "              => " artisan ",
        " joust "                   => " assault ",
        " jousting "                => " angry ",
        " jovial "                  => " affable ",
        " joviality "               => " anniversary ",
        " jovially "                => " acquiescently ",
        " joyance "                 => " contentment ",
        " joyful "                  => " blithesome ",
        " joyfully "                => " blithely ",
        " joyfulness "              => " beatitude ",
        " joyless "                 => " black ",
        " joyous "                  => " blissful ",
        " joyously "                => " acquiescently ",
        " joyousness "              => " alertness ",
        " jubilance "               => " crowing ",
        " jubilant "                => " celebrating ",
        " jubilate "                => " bless ",
        " jubilation "              => " acclaim ",
        " jubilee "                 => " ceremony ",
        " judder "                  => " beating ",
        " judge "                   => " adjudicator ",
        " judgeable "               => " accountable ",
        " judged "                  => " advised ",
        " judgelike "               => " administrative ",
        " judges "                  => " board ",
        " judging "                 => " anticipation ",
        " judgmatic "               => " advisable ",
        " judgment "                => " acumen ",
        " judicatory "              => " amends ",
        " judicial "                => " administrative ",
        " judiciary "               => " attorneys ",
        " judicious "               => " accurate ",
        " judiciousness "           => " acumen ",
        " jugged "                  => " bashed ",
        " juggle "                  => " alter ",
        " jugglery "                => " conjuration ",
        " juggling "                => " bamboozlement ",
        " juice "                   => " abstract ",
        " juiced "                  => " bashed ",
        " juiceless "               => " anhydrous ",
        " juicy "                   => " dank ",
        " juju "                    => " amulet ",
        " jumble "                  => " assortment ",
        " jumbled "                 => " abstruse ",
        " jumbo "                   => " colossal ",
        " jumpiness "               => " activity ",
        " jumps "                   => " all-overs ",
        " jumpy "                   => " agitated ",
        " junction "                => " alliance ",
        " junctural "               => " archival ",
        " juncture "                => " choice ",
        " jungle "                  => " boscage ",
        " junior "                  => " inferior ",
        " juniority "               => " adolescence ",
        " junk "                    => " clutter ",
        " junker "                  => " auto ",
        " junket "                  => " circuit ",
        " junketer "                => " adventurer ",
        " junketing "               => " absurdity ",
        " junkie "                  => " aficionado ",
        " junking "                 => " auctioning ",
        " junky "                   => " abominable ",
        " junque "                  => " actor ",
        " junta "                   => " band ",
        " jural "                   => " allowable ",
        " juridical "               => " argumentative ",
        " jurisdiction "            => " administration ",
        " jurisdictional "          => " authoritative ",
        " jurisdictive "            => " aldermanic ",
        " jurisprudent "            => " allowable ",
        " jurist "                  => " advocate ",
        " juristic "                => " argumentative ",
        " jurists "                 => " attorneys ",
        " jury "                    => " board ",
        " just "                    => " aloof ",
        " justice "                 => " amends ",
        " justifiable "             => " acceptable ",
        " justification "           => " absolution ",
        " justify "                 => " absolve ",
        " justifying "              => " answer ",
        " justle "                  => " bear ",
        " justly "                  => " accurately ",
        " justness "                => " charity ",
        " jutting "                 => " bulging ",
        " juvenescence "            => " adolescence ",
        " juvenile "                => " adolescent ",
        " juvenility "              => " boyhood ",
        " juxtapose "               => " analyze ",
        " juxtaposed "              => " abutting ",
        " juxtaposition "           => " bond ",
        " juxtapositional "         => " abutting ",
        " kablooey "                => " bang ",
        " kaiser "                  => " absolutist ",
        " kaleidoscopic "           => " capricious ",
        " kaolin "                  => " adobe ",
        " kapti "                   => " apparel ",
        " kaput "                   => " busted ",
        " karma "                   => " afterlife ",
        " kedge "                   => " ballast ",
        " keen "                    => " agog ",
        " keen-edged "              => " aciculate ",
        " keen-witted "             => " active ",
        " keening "                 => " bawl ",
        " keenly "                  => " actively ",
        " keenness "                => " accuracy ",
        " keep "                    => " accumulate ",
        " keeper "                  => " babysitter ",
        " keeping "                 => " befitting ",
        " keepsake "                => " emblem ",
        " kegger "                  => " affair ",
        " keister "                 => " accoutrements ",
        " kelpie "                  => " apparition ",
        " kennel "                  => " abode ",
        " kerf "                    => " carving ",
        " kernel "                  => " atom ",
        " ketch "                   => " baiter ",
        " keystone "                => " antecedent ",
        " khaki "                   => " biscuit ",
        " khan "                    => " baron ",
        " kibble "                  => " abrade ",
        " kibitz "                  => " admonition ",
        " kibitzer "                => " adviser ",
        " kibitzing "               => " arrest ",
        " kibosh "                  => " anathema ",
        " kick "                    => " bang ",
        " kick-off "                => " admission ",
        " kicker "                  => " article ",
        " kicking "                 => " blame ",
        " kickoff "                 => " alpha ",
        " kicks "                   => " bliss ",
        " kickshaw "                => " bagatelle ",
        " kickup "                  => " activity ",
        " kicky "                   => " blood-tingling ",
        " kidder "                  => " actor ",
        " kiddie "                  => " adolescent ",
        " kidding "                 => " badinage ",
        " kidney "                  => " branch ",
        " kill "                    => " annihilate ",
        " killed "                  => " dead ",
        " killer "                  => " analgesic ",
        " kiln "                    => " anhydrate ",
        " kilowatts "               => " application ",
        " kilter "                  => " appearance ",
        " kimono "                  => " bathrobe ",
        " kind "                    => " affectionate ",
        " kind-hearted "            => " altruistic ",
        " kind-heartedness "        => " altruism ",
        " kindhearted "             => " acceptable ",
        " kindle "                  => " blaze ",
        " kindled "                 => " afire ",
        " kindliness "              => " amicableness ",
        " kindling "                => " activation ",
        " kindly "                  => " attentive ",
        " kindness "                => " affection ",
        " kindred "                 => " affiliated ",
        " kindredship "             => " affiliation ",
        " kinesthesia "             => " faculty ",
        " kinetic "                 => " active ",
        " kinfolks "                => " association ",
        " king "                    => " baron ",
        " kingdom "                 => " commonwealth ",
        " kingfish "                => " arbiter ",
        " kingly "                  => " baronial ",
        " kingpin "                 => " arbiter ",
        " kingship "                => " ascendancy ",
        " kink "                    => " coil ",
        " kinky "                   => " coiled ",
        " kinsfolk "                => " affinity ",
        " kinship "                 => " alikeness ",
        " kinsmen "                 => " affinity ",
        " kinswoman "               => " affinity ",
        " kipe "                    => " annex ",
        " kismet "                  => " accident ",
        " kiss-off "                => " adjournment ",
        " kissable "                => " caressible ",
        " kisser "                  => " ass-kisser ",
        " kitchenware "             => " accouterments ",
        " kite "                    => " aeroplane ",
        " kitschy "                 => " blatant ",
        " kitten "                  => " babe ",
        " kittenish "               => " childish ",
        " kitty "                   => " backing ",
        " kitty-corner "            => " aslant ",
        " kitty-cornered "          => " askew ",
        " kleptomaniac "            => " bandit ",
        " kleptomaniacal "          => " crooked ",
        " kludge "                  => " agglomeration ",
        " klutz "                   => " addle-brain ",
        " knack "                   => " adroitness ",
        " knap "                    => " bulge ",
        " knapsack "                => " haversack ",
        " knave "                   => " bastard ",
        " knavery "                 => " artifice ",
        " knavish "                 => " base ",
        " knavishness "             => " artifice ",
        " knead "                   => " aerate ",
        " kneaded "                 => " alloyed ",
        " kneading "                => " abrasion ",
        " knee-bending "            => " angelic ",
        " kneeling "                => " admiration ",
        " knell "                   => " bell ",
        " knickknack "              => " bagatelle ",
        " knife-edge "              => " bend ",
        " knife-edged "             => " aciculate ",
        " knifelike "               => " acute ",
        " knifing "                 => " blame ",
        " knight "                  => " charlatan ",
        " knight-errantry "         => " courage ",
        " knighthood "              => " courage ",
        " knightly "                => " chivalry ",
        " knit "                    => " affiliate ",
        " knob "                    => " bulge ",
        " knobby "                  => " asperous ",
        " knock "                   => " beating ",
        " knock-down-drag-out "     => " affray ",
        " knockdown "               => " altercation ",
        " knocked "                 => " agape ",
        " knocking "                => " animadversion ",
        " knoll "                   => " altitude ",
        " knot "                    => " bond ",
        " knotted "                 => " askance ",
        " knotty "                  => " baffling ",
        " know "                    => " apperceive ",
        " know-how "                => " ability ",
        " know-it-all "             => " brain ",
        " know-nothing "            => " brainless ",
        " knowable "                => " apprehensible ",
        " knowing "                 => " alive ",
        " knowingly "               => " advisedly ",
        " knowledge "               => " ability ",
        " knowledgeable "           => " abreast ",
        " known "                   => " accepted ",
        " knuckle "                 => " address ",
        " knuckles "                => " duke ",
        " knurl "                   => " bulge ",
        " knurled "                 => " bent ",
        " knurly "                  => " agee ",
        " kook "                    => " crackpot ",
        " kooky "                   => " cool ",
        " kosher "                  => " adequate ",
        " kossack "                 => " anorak ",
        " kowtow "                  => " apple-polish ",
        " kowtowing "               => " abject ",
        " kudize "                  => " acclaim ",
        " kudos "                   => " acclaim ",
        " kumtux "                  => " accept ",
        " kvetching "               => " bitching ",
        " kvetchy "                 => " bad-tempered ",
        " kyphosis "                => " bulge ",
        " la-la-land "              => " befuddlement ",
        " label "                   => " characterization ",
        " labium "                  => " border ",
        " labor "                   => " activity ",
        " laboratory "              => " class ",
        " labored "                 => " affected ",
        " laboring "                => " active ",
        " laborious "               => " arduous ",
        " laboriously "             => " agilely ",
        " laboriousness "           => " adversity ",
        " laborsaving "             => " automated ",
        " labrum "                  => " border ",
        " labyrinth "               => " coil ",
        " lace "                    => " applique ",
        " laced "                   => " abstemious ",
        " lacelike "                => " delicate ",
        " lacerate "                => " claw ",
        " lacerated "               => " aching ",
        " laceration "              => " chaw ",
        " lacery "                  => " adornment ",
        " lacework "                => " cloth ",
        " lachrymose "              => " bathetic ",
        " lack "                    => " abridgement ",
        " lackadaisical "           => " abstracted ",
        " lackadaisicalness "       => " apathy ",
        " lackey "                  => " ass-kisser ",
        " lacking "                 => " defective ",
        " lackluster "              => " blah ",
        " laconic "                 => " breviloquent ",
        " laconism "                => " blackout ",
        " lacquer "                 => " bark ",
        " lacteal "                 => " alabaster ",
        " lacteous "                => " alabaster ",
        " lactescent "              => " alabaster ",
        " lacuna "                  => " blow ",
        " lacy "                    => " delicate ",
        " lade "                    => " afflict ",
        " laden "                   => " burdened ",
        " lading "                  => " burden ",
        " ladle "                   => " bail ",
        " lady "                    => " adult ",
        " lady-killer "             => " coxcomb ",
        " ladylike "                => " courtly ",
        " ladylove "                => " affection ",
        " laffer "                  => " absurd ",
        " laggard "                 => " backward ",
        " lagging "                 => " backward ",
        " lagniappe "               => " added ",
        " laic "                    => " believer ",
        " laical "                  => " civil ",
        " laid-back "               => " above ",
        " laid-off "                => " abandoned ",
        " laidback "                => " animated ",
        " lair "                    => " burrow ",
        " laity "                   => " aggregation ",
        " lake "                    => " basin ",
        " lakefront "               => " beach ",
        " lakelet "                 => " basin ",
        " lakeshore "               => " beach ",
        " lakeside "                => " beach ",
        " lama "                    => " absolutist ",
        " lamasery "                => " abbey ",
        " lambaste "                => " assail ",
        " lambency "                => " afterglow ",
        " lambent "                 => " bright ",
        " lame "                    => " bruised ",
        " lame-brain "              => " blockhead ",
        " lamebrain "               => " blockhead ",
        " lamebrained "             => " absurd ",
        " lamella "                 => " cell ",
        " lameness "                => " debility ",
        " lament "                  => " complaining ",
        " lamentable "              => " afflictive ",
        " lamentation "             => " bawl ",
        " lamentatory "             => " beefing ",
        " lamenting "               => " black ",
        " lamina "                  => " cell ",
        " laminate "                => " coat ",
        " lamination "              => " bark ",
        " lamister "                => " avoiding ",
        " lampoon "                 => " burlesque ",
        " lampoonery "              => " caricature ",
        " lampooning "              => " acrimony ",
        " lanate "                  => " bearded ",
        " lance "                   => " carve ",
        " lancers "                 => " army ",
        " lanch "                   => " booty ",
        " lancination "             => " ache ",
        " land "                    => " acreage ",
        " landlady "                => " feudatory ",
        " landlord "                => " freeholder ",
        " landmark "                => " battleground ",
        " landowner "               => " backer ",
        " landprop "                => " freeholder ",
        " lands "                   => " acreage ",
        " landscape "               => " mural ",
        " landscaping "             => " agriculture ",
        " landslide "               => " barrage ",
        " landslip "                => " barrage ",
        " landsman "                => " agriculturist ",
        " language "                => " accent ",
        " languid "                 => " apathetic ",
        " languidness "             => " apathy ",
        " languishing "             => " admiring ",
        " languor "                 => " blackout ",
        " languorous "              => " bent ",
        " languorousness "          => " apathy ",
        " lank "                    => " awkward ",
        " lanky "                   => " angular ",
        " lanose "                  => " downy ",
        " lanugo "                  => " down ",
        " lanyard "                 => " braiding ",
        " lap-dog "                 => " adulator ",
        " lapel "                   => " accessory ",
        " lapidarian "              => " bouldered ",
        " lapidate "                => " assail ",
        " lapidify "                => " calcify ",
        " lapse "                   => " blooper ",
        " lapsed "                  => " accomplished ",
        " laptop "                  => " laptop ",
        " larboard "                => " larboard ",
        " larcener "                => " bandit ",
        " larcenist "               => " bandit ",
        " larcenous "               => " crooked ",
        " larceny "                 => " burglary ",
        " lard "                    => " drip ",
        " lardaceous "              => " blubbery ",
        " larder "                  => " aliment ",
        " lardy "                   => " blubbery ",
        " large "                   => " ample ",
        " large-scale "             => " all-embracing ",
        " largely "                 => " abundantly ",
        " largeness "               => " amplitude ",
        " larger "                  => " beyond ",
        " largess "                 => " benefaction ",
        " largesse "                => " alms ",
        " largest "                 => " better ",
        " largish "                 => " ample ",
        " lariat "                  => " braiding ",
        " lark "                    => " distraction ",
        " larking "                 => " blithe ",
        " larkish "                 => " active ",
        " larrup "                  => " beat ",
        " larval "                  => " abecedarian ",
        " lasciviousness "          => " bender ",
        " lash "                    => " baste ",
        " lass "                    => " damsel ",
        " lassie "                  => " babe ",
        " lassitude "               => " aloofness ",
        " lassitudinous "           => " bent ",
        " lasso "                   => " apprehend ",
        " last "                    => " aftermost ",
        " last-mentioned "          => " closing ",
        " lasting "                 => " abiding ",
        " lastingly "               => " always ",
        " lastingness "             => " backbone ",
        " lastly "                  => " after ",
        " late "                    => " backward ",
        " lated "                   => " behind ",
        " lately "                  => " afresh ",
        " latency "                 => " cessation ",
        " latent "                  => " abeyant ",
        " later "                   => " after ",
        " lateral "                 => " crabbed ",
        " laterally "               => " alongside ",
        " latex "                   => " acrylic ",
        " lath "                    => " axle ",
        " lather "                  => " cream ",
        " lathery "                 => " barmy ",
        " latitude "                => " breadth ",
        " latitudinarian "          => " advanced ",
        " latitudinous "            => " ample ",
        " latrine "                 => " head ",
        " latter "                  => " closing ",
        " latterly "                => " after ",
        " lattermost "              => " extreme ",
        " lattice "                 => " filigree ",
        " latticework "             => " filigree ",
        " laud "                    => " acclaim ",
        " laudable "                => " commendable ",
        " laudation "               => " acclaim ",
        " laudative "               => " acclamatory ",
        " laudatory "               => " acclamatory ",
        " lauded "                  => " acclaimed ",
        " laugh "                   => " beam ",
        " laughable "               => " amusing ",
        " laughing "                => " bedlam ",
        " laughingly "              => " blithely ",
        " laughs "                  => " action ",
        " laughter "                => " amusement ",
        " launch "                  => " barrage ",
        " launching "               => " ablution ",
        " launder "                 => " acquit ",
        " laundered "               => " apple-pie ",
        " laundering "              => " bed-making ",
        " laundromat "              => " beard ",
        " laureate "                => " laureate ",
        " laurel "                  => " account ",
        " laurels "                 => " acclaim ",
        " lava "                    => " bedrock ",
        " lavaliere "               => " adornment ",
        " lavation "                => " ablution ",
        " lavatory "                => " bathroom ",
        " lave "                    => " absterge ",
        " lavender "                => " lavender ",
        " laving "                  => " ablution ",
        " lavish "                  => " abundant ",
        " lavishly "                => " abundantly ",
        " lavishness "              => " affluence ",
        " lawbook "                 => " codification ",
        " lawbreaker "              => " blackmailer ",
        " lawful "                  => " allowable ",
        " lawfully "                => " accurately ",
        " lawfulness "              => " correctness ",
        " lawgiver "                => " administrator ",
        " lawgiving "               => " aldermanic ",
        " lawless "                 => " anarchic ",
        " lawlessness "             => " anarchy ",
        " lawmaker "                => " administrator ",
        " lawmakers "               => " assembly ",
        " lawmaking "               => " code ",
        " lawman "                  => " constable ",
        " lawn "                    => " backyard ",
        " lawsuit "                 => " accusation ",
        " lawwoman "                => " constable ",
        " lawyer "                  => " advocate ",
        " lawyers "                 => " attorneys ",
        " laxity "                  => " abandon ",
        " laxness "                 => " absent-mindedness ",
        " layer "                   => " band ",
        " layman "                  => " believer ",
        " layoff "                  => " blow ",
        " layout "                  => " blueprint ",
        " layover "                 => " layover ",
        " laze "                    => " insolate ",
        " laziness "                => " apathy ",
        " lazing "                  => " dawdling ",
        " lazy "                    => " apathetic ",
        " leach "                   => " bleed ",
        " lead "                    => " advance ",
        " lead-footed "             => " abundant ",
        " lead-in "                 => " countdown ",
        " leaden "                  => " blurred ",
        " leadenness "              => " apathy ",
        " leader "                  => " baton ",
        " leadership "              => " administration ",
        " leading "                 => " arch ",
        " leaf "                    => " blade ",
        " leafage "                 => " frondescence ",
        " leafed "                  => " abounding ",
        " leaflet "                 => " advertisement ",
        " leafy "                   => " abounding ",
        " league "                  => " alliance ",
        " leagued "                 => " amalgamated ",
        " leak "                    => " aperture ",
        " leakage "                 => " arising ",
        " leaking "                 => " aperture ",
        " leaky "                   => " adulterated ",
        " lean "                    => " angular ",
        " lean-to "                 => " bivouac ",
        " leaner "                  => " bacteria ",
        " leaning "                 => " aptitude ",
        " leanness "                => " curtailment ",
        " leap "                    => " bound ",
        " learn "                   => " apprentice ",
        " learned "                 => " abstruse ",
        " learnedness "             => " apprenticeship ",
        " learner "                 => " abecedarian ",
        " learning "                => " acquirements ",
        " lease "                   => " charter ",
        " leased "                  => " busy ",
        " leaseholder "             => " addressee ",
        " leash "                   => " bridle ",
        " least "                   => " atomic ",
        " leather "                 => " covering ",
        " leather-colored "         => " beige ",
        " leatherlike "             => " coriaceous ",
        " leathery "                => " coriaceous ",
        " leave-taking "            => " conge ",
        " leaved "                  => " abounding ",
        " leaven "                  => " account ",
        " leaving "                 => " abrogation ",
        " leavings "                => " balance ",
        " lecherous "               => " carnal ",
        " lechery "                 => " bender ",
        " lecture "                 => " address ",
        " lecturer "                => " academician ",
        " lecturers "               => " advisers ",
        " ledger "                  => " balance ",
        " leech "                   => " drain ",
        " leery "                   => " careful ",
        " lees "                    => " alluvium ",
        " leeway "                  => " elbowroom ",
        " left "                    => " larboard ",
        " left-handed "             => " awkward ",
        " left-wing "               => " left-wing ",
        " leftist "                 => " advocate ",
        " leftover "                => " extra ",
        " leftovers "               => " assortment ",
        " leftward "                => " larboard ",
        " legacy "                  => " bequest ",
        " legal "                   => " acknowledged ",
        " legalistic "              => " administrative ",
        " legality "                => " amends ",
        " legalization "            => " amends ",
        " legalize "                => " approve ",
        " legally "                 => " accurately ",
        " legate "                  => " agent ",
        " legatee "                 => " almsman ",
        " legation "                => " commission ",
        " legend "                  => " fable ",
        " legendary "               => " allegorical ",
        " legerdemain "             => " bamboozlement ",
        " legerity "                => " alacrity ",
        " leggy "                   => " gangling ",
        " legibility "              => " accuracy ",
        " legible "                 => " clear ",
        " legion "                  => " countless ",
        " legislate "               => " appoint ",
        " legislated "              => " allowable ",
        " legislational "           => " aldermanic ",
        " legislative "             => " aldermanic ",
        " legislator "              => " administrator ",
        " legislatorial "           => " aldermanic ",
        " legislature "             => " assembly ",
        " legist "                  => " advocate ",
        " legit "                   => " accepted ",
        " legiter "                 => " actor ",
        " legitimacy "              => " angary ",
        " legitimate "              => " accepted ",
        " legitimately "            => " accurately ",
        " legitimatize "            => " approve ",
        " legitimatized "           => " allowable ",
        " legman "                  => " anchorman ",
        " legwork "                 => " airing ",
        " leisured "                => " abandoned ",
        " leisureliness "           => " apathy ",
        " leisurely "               => " comfortable ",
        " leitmotiv "               => " affair ",
        " lemma "                   => " antecedent ",
        " lemon "                   => " auto ",
        " lend "                    => " accommodate ",
        " lend-lease "              => " accommodate ",
        " length "                  => " breadth ",
        " lengthen "                => " amplify ",
        " lengthened "              => " diffuse ",
        " lengthening "             => " addition ",
        " lengthiness "             => " breadth ",
        " lengthy "                 => " diffuse ",
        " lenience "                => " charity ",
        " leniency "                => " charity ",
        " lenient "                 => " allowing ",
        " leniently "               => " agilely ",
        " lenitive "                => " anesthetic ",
        " lenity "                  => " affection ",
        " lentigo "                 => " birthmark ",
        " leopard "                 => " bobcat ",
        " leprechaun "              => " brownie ",
        " lesion "                  => " bane ",
        " less "                    => " beneath ",
        " lessee "                  => " aborigine ",
        " lessen "                  => " abate ",
        " lessening "               => " abbreviation ",
        " lesser "                  => " bottom ",
        " lesson "                  => " assignment ",
        " lessons "                 => " acquaint ",
        " lessor "                  => " freeholder ",
        " let-off "                 => " absolution ",
        " let-up "                  => " blow ",
        " letdown "                 => " anticlimax ",
        " lethal "                  => " baleful ",
        " lethality "               => " accident ",
        " lethalness "              => " accident ",
        " lethargic "               => " apathetic ",
        " lethargy "                => " apathy ",
        " lethe "                   => " absent-mindedness ",
        " lettered "                => " able ",
        " letterhead "              => " card ",
        " lettering "               => " book ",
        " letters "                 => " belletrist ",
        " letting "                 => " absolution ",
        " lettuce "                 => " bill ",
        " letup "                   => " abatement ",
        " leucous "                 => " albino ",
        " leukocyte "               => " corpuscle ",
        " levee "                   => " beach ",
        " level "                   => " akin ",
        " level-headedness "        => " acumen ",
        " leveled "                 => " collapsed ",
        " levelheaded "             => " calm ",
        " levelheadedness "         => " experience ",
        " levelness "               => " boredom ",
        " lever "                   => " batten ",
        " leverage "                => " advantage ",
        " levigate "                => " abrade ",
        " levitate "                => " bewitch ",
        " levitation "              => " acclivity ",
        " levity "                  => " absurdity ",
        " levy "                    => " burden ",
        " lewd "                    => " bawdy ",
        " lewdness "                => " abuse ",
        " lexicon "                 => " dictionary ",
        " liability "               => " accountability ",
        " liable "                  => " accountable ",
        " liaison "                 => " communication ",
        " liar "                    => " cheat ",
        " libation "                => " cooler ",
        " libel "                   => " aspersion ",
        " libeling "                => " abuse ",
        " libelous "                => " aspersive ",
        " liberal "                 => " advanced ",
        " liberalism "              => " capitalism ",
        " liberality "              => " accommodation ",
        " liberalizing "            => " adorning ",
        " liberally "               => " abundantly ",
        " liberalness "             => " altruism ",
        " liberate "                => " deliver ",
        " liberated "               => " absolved ",
        " libertarian "             => " autonomous ",
        " libertine "               => " abandoned ",
        " liberty "                 => " alternative ",
        " libidinous "              => " carnal ",
        " libidinousness "          => " carnality ",
        " libido "                  => " admiration ",
        " librettist "              => " author ",
        " license "                 => " authorization ",
        " licensed "                => " accountant ",
        " licentiate "              => " alum ",
        " licentious "              => " abandoned ",
        " licentiousness "          => " bender ",
        " licit "                   => " acceptable ",
        " licked "                  => " baffled ",
        " lickerish "               => " abandoned ",
        " licking "                 => " beating ",
        " lickspittle "             => " ass-kisser ",
        " lied "                    => " aria ",
        " liege "                   => " aristocrat ",
        " lien "                    => " affirmation ",
        " lieutenant "              => " abettor ",
        " life "                    => " activity ",
        " life-or-death "           => " basic ",
        " lifeblood "               => " aspect ",
        " lifeboat "                => " acquit ",
        " lifeless "                => " asleep ",
        " lifelessness "            => " banality ",
        " lifelike "                => " conscientious ",
        " lifeline "                => " buoy ",
        " lifelong "                => " constant ",
        " lifesaver "               => " charity ",
        " lifestyle "               => " affairs ",
        " lifework "                => " business ",
        " lifing "                  => " actuality ",
        " liftable "                => " adaptable ",
        " lifted "                  => " aerial ",
        " lifter "                  => " countdown ",
        " lifting "                 => " appropriation ",
        " liftoff "                 => " ascent ",
        " ligament "                => " bond ",
        " ligation "                => " articulation ",
        " ligature "                => " band ",
        " light "                   => " ablaze ",
        " light-fingered "          => " crooked ",
        " light-footed "            => " agile ",
        " light-headed "            => " addled ",
        " light-hearted "           => " animated ",
        " light-heartedly "         => " blithely ",
        " light-heartedness "       => " animation ",
        " light-minded "            => " barmy ",
        " lighted "                 => " afire ",
        " lightening "              => " abating ",
        " lightheaded "             => " bird-brained ",
        " lighthearted "            => " blithe ",
        " lightheartedness "        => " childishness ",
        " lighthouse "              => " alarm ",
        " lightless "               => " aphotic ",
        " lightlessness "           => " black ",
        " lightly "                 => " agilely ",
        " lightness "               => " animation ",
        " lightsome "               => " blithe ",
        " lightweight "             => " failing ",
        " ligneous "                => " board ",
        " likable "                 => " agreeable ",
        " like-minded "             => " agreeing ",
        " like-mindedness "         => " accord ",
        " likeable "                => " absorbing ",
        " liked "                   => " admired ",
        " likely "                  => " acceptable ",
        " liken "                   => " allegorize ",
        " likeness "                => " affinity ",
        " likening "                => " allegory ",
        " likes "                   => " brand ",
        " likewise "                => " additionally ",
        " liking "                  => " affection ",
        " lilac "                   => " lavender ",
        " lilt "                    => " accent ",
        " lilting "                 => " agreeable ",
        " lily "                    => " afraid ",
        " lily-liver "              => " alarmist ",
        " lily-livered "            => " afraid ",
        " lily-white "              => " admirable ",
        " limber "                  => " agile ",
        " limberness "              => " bendability ",
        " lime "                    => " adhesive ",
        " limelight "               => " accent ",
        " limerick "                => " composition ",
        " limey "                   => " bluejacket ",
        " limit "                   => " absolute ",
        " limitary "                => " belted ",
        " limited "                 => " bound ",
        " limiting "                => " attached ",
        " limitless "               => " bottomless ",
        " limitlessness "           => " beyond ",
        " limits "                  => " banned ",
        " limn "                    => " carbon ",
        " limousine "               => " auto ",
        " limp "                    => " bending ",
        " limpid "                  => " bright ",
        " limpidity "               => " accuracy ",
        " limpidness "              => " accuracy ",
        " limping "                 => " awkward ",
        " line "                    => " band ",
        " line-up "                 => " agency ",
        " lineage "                 => " birth ",
        " lineal "                  => " affiliated ",
        " lineament "               => " curve ",
        " linear "                  => " beeline ",
        " linearity "               => " breadth ",
        " lineation "               => " band ",
        " lines "                   => " curve ",
        " lineup "                  => " calendar ",
        " linger "                  => " amble ",
        " lingering "               => " abiding ",
        " lingo "                   => " argot ",
        " lingual "                 => " articulate ",
        " liniment "                => " chrism ",
        " link "                    => " articulation ",
        " linkage "                 => " bond ",
        " linked "                  => " affiliated ",
        " linking "                 => " bond ",
        " lintel "                  => " axle ",
        " linty "                   => " creamy ",
        " lion "                    => " bobcat ",
        " lion-hearted "            => " assured ",
        " lion-heartedness "        => " adventuresomeness ",
        " lionhearted "             => " adventurous ",
        " lionization "             => " advance ",
        " lionize "                 => " bless ",
        " lionized "                => " acclaimed ",
        " lippy "                   => " brassy ",
        " lips "                    => " aperture ",
        " liquefaction "            => " condensate ",
        " liquefied "               => " abounding ",
        " liquefy "                 => " adulterate ",
        " liquesce "                => " deliquesce ",
        " liquescent "              => " aqueous ",
        " liquid "                  => " aqueous ",
        " liquidate "               => " cash ",
        " liquidated "              => " asleep ",
        " liquidation "             => " defalcation ",
        " liquidator "              => " apache ",
        " liquidity "               => " clamminess ",
        " liquification "           => " admixture ",
        " liquiform "               => " aqueous ",
        " lissome "                 => " adroit ",
        " lissomeness "             => " adroitness ",
        " list "                    => " account ",
        " listen "                  => " accept ",
        " listener "                => " adviser ",
        " listeners "               => " admirers ",
        " listening "               => " alert ",
        " listing "                 => " advertisement ",
        " listless "                => " absent ",
        " listlessness "            => " aloofness ",
        " litany "                  => " account ",
        " literacy "                => " articulacy ",
        " literal "                 => " accurate ",
        " literally "               => " actually ",
        " literary "                => " arcane ",
        " literate "                => " community ",
        " literati "                => " advisers ",
        " literatim "               => " actually ",
        " literature "              => " abstract ",
        " lithe "                   => " agile ",
        " litheness "               => " activity ",
        " lithesome "               => " agile ",
        " lithesomeness "           => " adroitness ",
        " lithic "                  => " bouldered ",
        " lithograph "              => " bite ",
        " litigant "                => " adversary ",
        " litigate "                => " appeal ",
        " litigation "              => " action ",
        " litigious "               => " belligerent ",
        " litotes "                 => " adumbration ",
        " litter "                  => " clutter ",
        " litterateur "             => " belletrist ",
        " littered "                => " blowzy ",
        " little-known "            => " abstruse ",
        " littoral "                => " bank ",
        " liturgical "              => " august ",
        " liturgy "                 => " celebration ",
        " livable "                 => " adequate ",
        " live "                    => " alive ",
        " live-in "                 => " chambermaid ",
        " lived-in "                => " busy ",
        " livelihood "              => " alimentation ",
        " liveliness "              => " activity ",
        " livelong "                => " constant ",
        " lively "                  => " active ",
        " liven "                   => " activate ",
        " livener "                 => " analeptic ",
        " liver "                   => " alarmist ",
        " livery "                  => " accouter ",
        " livid "                   => " ashen ",
        " living "                  => " active ",
        " lizard "                  => " cadger ",
        " load "                    => " amount ",
        " loads "                   => " endless ",
        " loafer "                  => " angishore ",
        " loafing "                 => " dabbling ",
        " loam "                    => " adobe ",
        " loamy "                   => " abundant ",
        " loan "                    => " accommodation ",
        " loath "                   => " afraid ",
        " loathe "                  => " abhor ",
        " loathed "                 => " abominable ",
        " loathing "                => " abhorrence ",
        " loathness "               => " alienation ",
        " loathsome "               => " abhorrent ",
        " lobbing "                 => " casting ",
        " lobby "                   => " antechamber ",
        " lobe "                    => " affiliate ",
        " local "                   => " bounded ",
        " locale "                  => " area ",
        " localism "                => " atrocity ",
        " locality "                => " belt ",
        " located "                 => " amid ",
        " locating "                => " analysis ",
        " location "                => " area ",
        " loch "                    => " anchorage ",
        " locked "                  => " bound ",
        " locket "                  => " adornment ",
        " lockup "                  => " alcove ",
        " locomotive "              => " adaptable ",
        " locution "                => " declamation ",
        " lodestar "                => " alarm ",
        " lodge "                   => " abode ",
        " lodgeable "               => " adequate ",
        " lodger "                  => " bedfellow ",
        " lodging "                 => " abode ",
        " lodgment "                => " apartment ",
        " loess "                   => " adobe ",
        " loft "                    => " attic ",
        " loftier "                 => " high ",
        " loftiest "                => " absolute ",
        " loftiness "               => " distance ",
        " lofty "                   => " aerial ",
        " logan "                   => " cossack ",
        " loggia "                  => " arcade ",
        " logic "                   => " argumentation ",
        " logical "                 => " analytic ",
        " logistics "               => " acumen ",
        " logjam "                  => " adjournment ",
        " logroller "               => " fixer ",
        " loiter "                  => " amble ",
        " loitering "               => " dabbling ",
        " lollygag "                => " clamber ",
        " lollygagger "             => " angishore ",
        " lone "                    => " abandoned ",
        " loneliness "              => " bareness ",
        " lonely "                  => " abandoned ",
        " loner "                   => " beatnik ",
        " lonesome "                => " alone ",
        " long "                    => " continued ",
        " long-continued "          => " abiding ",
        " long-drawn-out "          => " aberrant ",
        " long-established "        => " accepted ",
        " long-haired "             => " accomplished ",
        " long-lasting "            => " abiding ",
        " long-legged "             => " gangling ",
        " long-limbed "             => " gangling ",
        " long-liner "              => " barge ",
        " long-lived "              => " abiding ",
        " long-nose "               => " babbler ",
        " long-nosed "              => " analytical ",
        " long-range "              => " all-embracing ",
        " long-serving "            => " adept ",
        " long-sighted "            => " clear-sighted ",
        " long-sightedness "        => " anticipation ",
        " long-standing "           => " abiding ",
        " long-suffering "          => " ability ",
        " long-term "               => " abiding ",
        " long-time "               => " adept ",
        " long-winded "             => " circumlocutory ",
        " longanimity "             => " abstinence ",
        " longer "                  => " best ",
        " longevity "               => " constancy ",
        " longhand "                => " calligraphy ",
        " longhorn "                => " beasts ",
        " longing "                 => " anxious ",
        " longish "                 => " diffuse ",
        " longitude "               => " breadth ",
        " longness "                => " breadth ",
        " longways "                => " angular ",
        " longwinded "              => " abused ",
        " look "                    => " attending ",
        " look-in "                 => " break ",
        " look-over "               => " analysis ",
        " looked-for "              => " -to-be ",
        " looker "                  => " beholder ",
        " looker-on "               => " eyewitness ",
        " looking "                 => " attractive ",
        " lookout "                 => " anchor ",
        " loom "                    => " approach ",
        " loon "                    => " blockhead ",
        " loonie "                  => " bread ",
        " loonshit "                => " arena ",
        " loony "                   => " bedlam ",
        " loop "                    => " bend ",
        " looped "                  => " angled ",
        " loophole "                => " artifice ",
        " loopy "                   => " arced ",
        " loose "                   => " apart ",
        " loose-fitting "           => " adequate ",
        " loose-lipped "            => " communicative ",
        " loosely "                 => " about ",
        " loosen "                  => " alleviate ",
        " loosened "                => " alone ",
        " looseness "               => " atrocity ",
        " loosening "               => " alleviation ",
        " loot "                    => " boodle ",
        " looter "                  => " bandit ",
        " looting "                 => " annexation ",
        " lope "                    => " amble ",
        " lopper "                  => " clabber ",
        " lopping "                 => " abbreviating ",
        " lopsided "                => " askew ",
        " lopsidedness "            => " asymmetry ",
        " loquacious "              => " babbling ",
        " loquacity "               => " ability ",
        " lord "                    => " aristocrat ",
        " lordliness "              => " airs ",
        " lordly "                  => " affected ",
        " lordship "                => " ascendancy ",
        " lore "                    => " belief ",
        " lorn "                    => " abandoned ",
        " loser "                   => " also-ran ",
        " losing "                  => " accident ",
        " loss "                    => " accident ",
        " lost "                    => " absent ",
        " lotion "                  => " balm ",
        " lotsa "                   => " abundant ",
        " lottery "                 => " action ",
        " loud-mouthed "            => " awkward ",
        " loudly "                  => " audibly ",
        " loudmouth "               => " arrogant ",
        " loudmouthed "             => " boisterous ",
        " louring "                 => " alarming ",
        " loury "                   => " aggressive ",
        " louse "                   => " blow ",
        " lousy "                   => " awful ",
        " lout "                    => " beast ",
        " loutish "                 => " awkward ",
        " lovable "                 => " adorable ",
        " love "                    => " adulation ",
        " loved "                   => " admired ",
        " loveliness "              => " adorableness ",
        " loveling "                => " angel ",
        " lovely "                  => " admirable ",
        " lovemaking "              => " courting ",
        " lovesick "                => " admiring ",
        " lovesome "                => " adherent ",
        " loving "                  => " admiring ",
        " lovingly "                => " acquiescently ",
        " low-born "                => " base ",
        " low-cost "                => " bargain ",
        " low-down "                => " abhorrent ",
        " low-hanging "             => " below ",
        " low-key "                 => " easygoing ",
        " low-lying "               => " below ",
        " low-minded "              => " blue ",
        " low-pitched "             => " aside ",
        " low-pressure "            => " airy ",
        " low-priced "              => " bargain ",
        " low-profile "             => " humble ",
        " low-ranking "             => " base ",
        " low-set "                 => " below ",
        " low-spirited "            => " abject ",
        " lowborn "                 => " base ",
        " lowbred "                 => " awkward ",
        " lowbrow "                 => " barbaric ",
        " lowdown "                 => " annual ",
        " lowerclassman "           => " apprentice ",
        " lowered "                 => " bargain ",
        " lowering "                => " blurred ",
        " lowermost "               => " basal ",
        " lowery "                  => " aggressive ",
        " lowest "                  => " everyman ",
        " lowlife "                 => " bastard ",
        " lowliness "               => " abasement ",
        " lowly "                   => " average ",
        " lowness "                 => " depression ",
        " loyally "                 => " absolutely ",
        " loyalty "                 => " adherence ",
        " lozenge "                 => " bolus ",
        " lubber "                  => " barbarian ",
        " lubberly "                => " awkward ",
        " lube "                    => " bless ",
        " lubricant "               => " adipose ",
        " lubricate "               => " anoint ",
        " lubricated "              => " anointed ",
        " lubricative "             => " adipose ",
        " lubricious "              => " arbitrary ",
        " lubricity "               => " atrocity ",
        " lucent "                  => " clear-cut ",
        " lucid "                   => " apprehensible ",
        " lucidity "                => " accuracy ",
        " lucidly "                 => " acutely ",
        " lucidness "               => " acumen ",
        " luckiness "               => " accident ",
        " luckless "                => " adverse ",
        " lucky "                   => " advantageous ",
        " lucrative "               => " advantageous ",
        " lucre "                   => " balance ",
        " luculent "                => " bright ",
        " ludicrous "               => " antic ",
        " ludicrously "             => " absurdly ",
        " ludicrousness "           => " applesauce ",
        " luggage "                 => " baggage ",
        " lugubriosity "            => " abasement ",
        " lukewarm "                => " blood-warm ",
        " lull "                    => " abeyance ",
        " lullaby "                 => " abate ",
        " lulling "                 => " abatement ",
        " lulu "                    => " attractive ",
        " lumber "                  => " barge ",
        " lumbering "               => " awkward ",
        " luminescence "            => " brilliance ",
        " luminescent "             => " bright ",
        " luminosity "              => " blush ",
        " luminous "                => " beaming ",
        " luminousness "            => " afterglow ",
        " lummox "                  => " baboon ",
        " lump "                    => " agglomeration ",
        " lumpkin "                 => " barbarian ",
        " lumps "                   => " chastening ",
        " lumpy "                   => " chapped ",
        " lunacy "                  => " aberration ",
        " lunatic "                 => " absurd ",
        " lunch "                   => " cafeteria ",
        " luncheon "                => " bologna ",
        " luncheonette "            => " bistro ",
        " lunchmeat "               => " bologna ",
        " lunchroom "               => " bistro ",
        " lunge "                   => " bound ",
        " lunkhead "                => " airhead ",
        " lupine "                  => " barbaric ",
        " lurch "                   => " blunder ",
        " lure "                    => " allurement ",
        " lured "                   => " absorbed ",
        " lurid "                   => " ashen ",
        " luring "                  => " adorable ",
        " lurking "                 => " ambuscade ",
        " luscious "                => " adorable ",
        " lush "                    => " abundant ",
        " lushness "                => " breeding ",
        " lust "                    => " animalism ",
        " luster "                  => " afterglow ",
        " lusterless "              => " arid ",
        " lustful "                 => " amative ",
        " lustfulness "             => " aphrodisia ",
        " lustily "                 => " audibly ",
        " lustiness "               => " bloom ",
        " lusting "                 => " active ",
        " lustrate "                => " absolve ",
        " lustration "              => " ablution ",
        " lustrous "                => " bright ",
        " lusty "                   => " brawny ",
        " lute "                    => " adhesive ",
        " luxation "                => " break ",
        " luxuriance "              => " affluence ",
        " luxuriant "               => " abundant ",
        " luxuriate "               => " abound ",
        " luxurious "               => " comfortable ",
        " luxuriousness "           => " amplitude ",
        " luxury "                  => " affluence ",
        " lyceum "                  => " academy ",
        " lying-in "                => " accouchement ",
        " lymphatic "               => " aqueous ",
        " lynching "                => " annihilation ",
        " lynx "                    => " bobcat ",
        " lyrical "                 => " agreeable ",
        " lyricist "                => " artist ",
        " lyrist "                  => " artist ",
        " macabre "                 => " cadaverous ",
        " macadamize "              => " asphalt ",
        " mace "                    => " billy ",
        " macerate "                => " absorb ",
        " macerated "               => " diminished ",
        " machinate "               => " cogitate ",
        " machination "             => " artifice ",
        " machinations "            => " chicane ",
        " machine "                 => " apparatus ",
        " machine-driven "          => " automated ",
        " machine-made "            => " automated ",
        " machinery "               => " accouterment ",
        " machinist "               => " artisan ",
        " machismo "                => " adulthood ",
        " macho "                   => " blowing ",
        " macrobiotic "             => " alimentative ",
        " macrocosm "               => " creation ",
        " macrocosmos "             => " creation ",
        " macroscopic "             => " arresting ",
        " macroseism "              => " convulsion ",
        " macula "                  => " birthmark ",
        " maculate "                => " abuse ",
        " maculation "              => " birthmark ",
        " macule "                  => " blemish ",
        " mad-dog "                 => " berserk ",
        " madam "                   => " amazon ",
        " madcap "                  => " brash ",
        " madden "                  => " anger ",
        " maddened "                => " affronted ",
        " made "                    => " fabricated ",
        " made-to-measure "         => " custom-built ",
        " made-up "                 => " fabricated ",
        " mademoiselle "            => " babe ",
        " madhouse "                => " asylum ",
        " madly "                   => " absurdly ",
        " madman "                  => " dement ",
        " madness "                 => " carelessness ",
        " madstone "                => " amulet ",
        " madwoman "                => " dement ",
        " maelstrom "               => " clamor ",
        " maestro "                 => " ability ",
        " mafioso "                 => " bandit ",
        " magazine "                => " annual ",
        " magenta "                 => " amethyst ",
        " maggot "                  => " bastard ",
        " magic "                   => " abracadabra ",
        " magical "                 => " bewitched ",
        " magician "                => " archimage ",
        " magister "                => " adjudicator ",
        " magisterial "             => " absolute ",
        " magistracy "              => " administration ",
        " magistrate "              => " court ",
        " magnanimity "             => " affection ",
        " magnanimously "           => " advantageously ",
        " magnet "                  => " allurement ",
        " magnetic "                => " alluring ",
        " magnetism "               => " allure ",
        " magnetize "               => " attract ",
        " magnetizing "             => " absorbing ",
        " magnific "                => " arresting ",
        " magnification "           => " deepening ",
        " magnificence "            => " breeding ",
        " magnificent "             => " arresting ",
        " magnificently "           => " alluringly ",
        " magnified "               => " abstract ",
        " magnify "                 => " aggrandize ",
        " magnifying "              => " accumulative ",
        " magniloquence "           => " address ",
        " magniloquent "            => " aureate ",
        " magnitude "               => " consequence ",
        " magpie "                  => " babbler ",
        " magus "                   => " astrologer ",
        " maharajah "               => " baron ",
        " maharishi "               => " authority ",
        " mahogany "                => " amber ",
        " maiden "                  => " beginning ",
        " maidenhood "              => " abstention ",
        " maidenly "                => " austere ",
        " maidservant "             => " charwoman ",
        " mailing "                 => " commitment ",
        " maim "                    => " batter ",
        " maimed "                  => " bedridden ",
        " main "                    => " capital ",
        " mainland "                => " acreage ",
        " mainspring "              => " base ",
        " mainstream "              => " boilerplate ",
        " maintain "                => " advance ",
        " maintainable "            => " arguable ",
        " maintaining "             => " advancement ",
        " maintenance "             => " aliment ",
        " major "                   => " above ",
        " make "                    => " accomplish ",
        " make-believe "            => " acted ",
        " make-peace "              => " appeaser ",
        " make-up "                 => " composition ",
        " makeup "                  => " architecture ",
        " making "                  => " authoritative ",
        " makings "                 => " adequacy ",
        " maladjustment "           => " aberration ",
        " maladminister "           => " abuse ",
        " maladroitly "             => " abominably ",
        " maladroitness "           => " amateurishness ",
        " malaise "                 => " angst ",
        " malapropism "             => " atrocity ",
        " malapropos "              => " ill-fitted ",
        " malconformation "         => " aberration ",
        " malcontent "              => " advocate ",
        " malcontented "            => " bitching ",
        " malcontentment "          => " annoyance ",
        " male "                    => " macho ",
        " malediction "             => " anathema ",
        " malefaction "             => " abomination ",
        " malefactor "              => " captive ",
        " malefic "                 => " baleful ",
        " maleficence "             => " carnality ",
        " maleficent "              => " angry ",
        " maleficiently "           => " angrily ",
        " malevolence "             => " crime ",
        " malevolent "              => " bad-natured ",
        " malevolently "            => " basely ",
        " malfeasance "             => " bribery ",
        " malform "                 => " batter ",
        " malformation "            => " aberancy ",
        " malformed "               => " abnormal ",
        " malfunctioning "          => " adulterated ",
        " malice "                  => " acerbity ",
        " malicious "               => " awful ",
        " maliciousness "           => " backbiting ",
        " malign "                  => " antagonistic ",
        " malignance "              => " abhorrence ",
        " malignancy "              => " blight ",
        " malignant "               => " cancerous ",
        " maligning "               => " calumniating ",
        " malignity "               => " acrimony ",
        " malignly "                => " angrily ",
        " malinger "                => " circumlocute ",
        " malingerer "              => " alarmist ",
        " malkin "                  => " bobcat ",
        " mall "                    => " capital ",
        " malleability "            => " acquiescence ",
        " malleable "               => " adaptable ",
        " malleate "                => " fashion ",
        " malnourished "            => " angular ",
        " malodor "                 => " fetor ",
        " malpractice "             => " abuse ",
        " maltreat "                => " corrupt ",
        " maltreated "              => " abject ",
        " maltreatment "            => " crime ",
        " malversation "            => " delinquency ",
        " mama "                    => " astronomic ",
        " mammalian "               => " beastly ",
        " mammoth "                 => " behemothic ",
        " mammy "                   => " assistant ",
        " man-eater "               => " aborigine ",
        " man-made "                => " counterfeit ",
        " man-to-man "              => " absolute ",
        " mana "                    => " backbone ",
        " manacle "                 => " bandage ",
        " manage "                  => " administer ",
        " manageability "           => " accordance ",
        " manageable "              => " acquiescent ",
        " management "              => " administration ",
        " manager "                 => " administrator ",
        " managerial "              => " authoritative ",
        " mandate "                 => " authorization ",
        " mandated "                => " allowable ",
        " mandatory "               => " binding ",
        " mandible "                => " bill ",
        " mandrel "                 => " arbor ",
        " manducate "               => " bite ",
        " mane "                    => " aigrette ",
        " manes "                   => " apparition ",
        " maneuver "                => " action ",
        " maneuvering "             => " action ",
        " maneuvers "               => " assignment ",
        " manful "                  => " bull ",
        " manfulness "              => " adulthood ",
        " manger "                  => " bassinet ",
        " mangle "                  => " batter ",
        " mangled "                 => " burst ",
        " mangy "                   => " decrepit ",
        " manhandle "               => " abuse ",
        " manhandling "             => " crime ",
        " manhood "                 => " adulthood ",
        " mania "                   => " aberration ",
        " maniac "                  => " bedlamite ",
        " maniacally "              => " berserk ",
        " manic "                   => " berserk ",
        " manifest "                => " apparent ",
        " manifestation "           => " appearance ",
        " manifested "              => " embodied ",
        " manifestly "              => " clearly ",
        " manifestness "            => " accuracy ",
        " manifesto "               => " acclamation ",
        " manifold "                => " assorted ",
        " manikin "                 => " baby ",
        " manipulable "             => " bendable ",
        " manipulate "              => " dispense ",
        " manipulation "            => " abetment ",
        " manipulative "            => " artful ",
        " manipulator "             => " architect ",
        " mankind "                 => " flesh ",
        " manlike "                 => " macho ",
        " manliness "               => " adventuresomeness ",
        " manly "                   => " audacious ",
        " manna "                   => " blessing ",
        " manner "                  => " address ",
        " mannered "                => " airish ",
        " mannerism "               => " affectation ",
        " mannerless "              => " barbarian ",
        " mannerliness "            => " aristocracy ",
        " mannerly "                => " charming ",
        " manners "                 => " amenities ",
        " mannish "                 => " adult ",
        " mannism "                 => " beefcake ",
        " manor "                   => " estate ",
        " mansion "                 => " abode ",
        " manslaughter "            => " assassination ",
        " manteau "                 => " capote ",
        " mantelletta "             => " capote ",
        " mantilla "                => " capote ",
        " mantle "                  => " crimson ",
        " mantling "                => " bloom ",
        " manual "                  => " chiral ",
        " manufactory "             => " branch ",
        " manufacture "             => " accomplish ",
        " manufactured "            => " bogus ",
        " manufacturer "            => " architect ",
        " manufactures "            => " articles ",
        " manufacturing "           => " accomplishment ",
        " manumission "             => " abolition ",
        " manumit "                 => " absolve ",
        " manure "                  => " admixture ",
        " manus "                   => " barb ",
        " manuscript "              => " arrangement ",
        " manuscription "           => " autography ",
        " many "                    => " abounding ",
        " many-colored "            => " irised ",
        " many-faceted "            => " busy ",
        " many-sided "              => " able ",
        " many-sidedness "          => " array ",
        " marathon "                => " chase ",
        " maraud "                  => " despoil ",
        " marauder "                => " brigand ",
        " marauding "               => " burglary ",
        " marbled "                 => " blotchy ",
        " march "                   => " advance ",
        " march-past "              => " array ",
        " marching "                => " boot ",
        " mare "                    => " adult ",
        " margin "                  => " allowance ",
        " marginal "                => " bordering ",
        " marginalia "              => " agenda ",
        " marginally "              => " hardly ",
        " marina "                  => " berth ",
        " marinade "                => " alkali ",
        " marine "                  => " abyssal ",
        " mariner "                 => " bluejacket ",
        " marionette "              => " baby ",
        " marital "                 => " conjugal ",
        " maritime "                => " amphibian ",
        " marked "                  => " apparent ",
        " markedly "                => " clearly ",
        " markedness "              => " bulge ",
        " marker "                  => " brand ",
        " market "                  => " bazaar ",
        " marketable "              => " bankable ",
        " marketer "                => " banker ",
        " marketing "               => " business ",
        " marketplace "             => " exchange ",
        " marking "                 => " appearance ",
        " markings "                => " arrangement ",
        " marl "                    => " adobe ",
        " maroon "                  => " beach ",
        " marooned "                => " ashore ",
        " marquee "                 => " covering ",
        " marquis "                 => " aristocrat ",
        " marred "                  => " bedridden ",
        " marriage "                => " alliance ",
        " marriageable "            => " adulthood ",
        " married "                 => " affiliated ",
        " marring "                 => " accident ",
        " marrow "                  => " bottom ",
        " marry "                   => " ally ",
        " marshal "                 => " align ",
        " marshmallow "             => " acquiescent ",
        " marshy "                  => " littoral ",
        " mart "                    => " exchange ",
        " martial "                 => " aggressive ",
        " martinet "                => " absolutist ",
        " martyr "                  => " agonize ",
        " martyrdom "               => " affliction ",
        " martyrize "               => " excruciate ",
        " marv "                    => " amazing ",
        " marvel "                  => " curiosity ",
        " marveling "               => " account ",
        " marvelous "               => " astonishing ",
        " mascot "                  => " amulet ",
        " masculine "               => " adult ",
        " masculinity "             => " adulthood ",
        " mash "                    => " brew ",
        " mashy "                   => " doughy ",
        " mask "                    => " affectation ",
        " masking "                 => " appearance ",
        " masklike "                => " deadpan ",
        " masochism "               => " animality ",
        " mason "                   => " architect ",
        " masquerader "             => " bluff ",
        " mass "                    => " accumulation ",
        " mass-produce "            => " accomplish ",
        " mass-produced "           => " banal ",
        " mass-production "         => " accomplishment ",
        " massacre "                => " annihilation ",
        " massage "                 => " beating ",
        " massed "                  => " aggregate ",
        " massing "                 => " absorption ",
        " massiveness "             => " aggregate ",
        " master "                  => " adept ",
        " masterdom "               => " ascendancy ",
        " mastered "                => " baffled ",
        " masterful "               => " adept ",
        " mastering "               => " arrive ",
        " masterliness "            => " ability ",
        " masterly "                => " accomplished ",
        " mastermind "              => " administrator ",
        " mastership "              => " ability ",
        " masterstroke "            => " achievement ",
        " mastery "                 => " ability ",
        " masticate "               => " champ ",
        " match "                   => " bout ",
        " matched "                 => " akin ",
        " matching "                => " analogous ",
        " matchless "               => " alone ",
        " matchmaker "              => " agent ",
        " matchup "                 => " antagonism ",
        " mate "                    => " acquaintance ",
        " mated "                   => " akin ",
        " mater "                   => " academy ",
        " material "                => " actual ",
        " materialist "             => " agnostic ",
        " materialistic "           => " acquisitive ",
        " materiality "             => " achievement ",
        " materialization "         => " achievement ",
        " materialize "             => " actualize ",
        " materialized "            => " embodied ",
        " materialness "            => " amount ",
        " materials "               => " abstracts ",
        " materiel "                => " armament ",
        " maternal "                => " affectionate ",
        " maternity "               => " maternology ",
        " math "                    => " algebraic ",
        " mathematical "            => " algebraic ",
        " mating "                  => " alliance ",
        " matriarch "               => " dame ",
        " matriclinous "            => " abiogenetic ",
        " matriculate "             => " begin ",
        " matriculation "           => " class ",
        " matrimonial "             => " betrothed ",
        " matrimony "               => " alliance ",
        " matrix "                  => " cast ",
        " matron "                  => " administrator ",
        " matronly "                => " changeable ",
        " matted "                  => " disordered ",
        " matter "                  => " amount ",
        " matter-of-face "          => " apathetic ",
        " matter-of-fact "          => " apathetic ",
        " matter-of-factly "        => " artlessly ",
        " matters "                 => " affairs ",
        " matting "                 => " carpeting ",
        " matty "                   => " coiled ",
        " maturate "                => " advance ",
        " mature "                  => " complete ",
        " matured "                 => " accomplished ",
        " matureness "              => " adultness ",
        " maturescence "            => " ability ",
        " maturing "                => " crumbling ",
        " maturity "                => " ability ",
        " matutinal "               => " advanced ",
        " maudlin "                 => " bathetic ",
        " maul "                    => " bang ",
        " mauled "                  => " aching ",
        " maundering "              => " blurred ",
        " mausoleum "               => " catacomb ",
        " mauve "                   => " lavender ",
        " maven "                   => " adjudicator ",
        " maverick "                => " bohemian ",
        " mawkish "                 => " bathetic ",
        " maxi "                    => " best ",
        " maxilla "                 => " bone ",
        " maxim "                   => " adage ",
        " maximal "                 => " acute ",
        " maximization "            => " access ",
        " maximize "                => " aerate ",
        " maximum "                 => " best ",
        " mayhem "                  => " commotion ",
        " mayor "                   => " ambassador ",
        " maze "                    => " bewilderment ",
        " mazed "                   => " dazed ",
        " mazuma "                  => " cash ",
        " mazy "                    => " abstruse ",
        " meager "                  => " bare ",
        " meagerness "              => " absence ",
        " meals "                   => " commons ",
        " mealy "                   => " abject ",
        " mealy-mouthed "           => " abject ",
        " mean "                    => " beggarly ",
        " mean-spirited "           => " chicken ",
        " meander "                 => " change ",
        " meanderer "               => " adventurer ",
        " meandrous "               => " anfractuous ",
        " meanest "                 => " aftermost ",
        " meaning "                 => " acceptation ",
        " meaningful "              => " allusive ",
        " meaningfully "            => " advisedly ",
        " meaningfulness "          => " ability ",
        " meaningless "             => " absurd ",
        " meanly "                  => " atrociously ",
        " meanness "                => " abasement ",
        " means "                   => " agency ",
        " meantime "                => " concurrently ",
        " measly "                  => " beggarly ",
        " measurable "              => " assessable ",
        " measure "                 => " admeasurement ",
        " measured "                => " abstinent ",
        " measureless "             => " great ",
        " measurement "             => " altitude ",
        " measurements "            => " abstracts ",
        " measuring "               => " barometer ",
        " meat-and-potatoes "       => " axiological ",
        " meathead "                => " amateur ",
        " meaty "                   => " compact ",
        " mechanic "                => " artisan ",
        " mechanical "              => " automated ",
        " mechanism "               => " apparatus ",
        " mechanized "              => " automatic ",
        " medal "                   => " badge ",
        " medalist "                => " advocate ",
        " medallion "               => " brand ",
        " medallist "               => " champ ",
        " meddlesome "              => " busy ",
        " meddlesomeness "          => " concern ",
        " medial "                  => " centermost ",
        " medialize "               => " attract ",
        " medially "                => " amid ",
        " median "                  => " average ",
        " mediary "                 => " abettor ",
        " mediate "                 => " arbitrate ",
        " mediated "                => " advised ",
        " mediation "               => " arbitration ",
        " mediator "                => " advocate ",
        " medicable "               => " alleviative ",
        " medicate "                => " alleviate ",
        " medicated "               => " antibacterial ",
        " medicating "              => " alleviative ",
        " medicative "              => " alleviative ",
        " medicinal "               => " alleviative ",
        " medicine "                => " anesthetic ",
        " mediocre "                => " characterless ",
        " meditated "               => " advised ",
        " meditating "              => " apperception ",
        " meditation "              => " brainwork ",
        " meditative "              => " attentive ",
        " medium "                  => " average ",
        " medley "                  => " assortment ",
        " meed "                    => " advantage ",
        " meek "                    => " acquiescent ",
        " meekness "                => " backwardness ",
        " meet "                    => " accommodated ",
        " meeting "                 => " affair ",
        " meetings "                => " affairs ",
        " meetness "                => " advantage ",
        " megacorp "                => " cartel ",
        " megacosm "                => " creation ",
        " megalomania "             => " arrogance ",
        " megalomaniac "            => " egoistic ",
        " megalopolis "             => " apple ",
        " megalopolitan "           => " burghal ",
        " melancholia "             => " abasement ",
        " melancholic "             => " black ",
        " melancholy "              => " blue ",
        " melanoid "                => " atramentous ",
        " meld "                    => " amalgamate ",
        " melding "                 => " affiliation ",
        " melee "                   => " affray ",
        " meliorate "               => " alleviate ",
        " melioration "             => " advancement ",
        " meliority "               => " ahead ",
        " mellifluent "             => " chatty ",
        " mellifluous "             => " chatty ",
        " mellifluousness "         => " ability ",
        " mellow "                  => " aged ",
        " mellowed "                => " complete ",
        " mellowing "               => " crumbling ",
        " mellowness "              => " ability ",
        " melodic "                 => " adapted ",
        " melodious "               => " accordant ",
        " melodiousness "           => " accord ",
        " melodist "                => " accompanist ",
        " melodrama "               => " action ",
        " melodramatic "            => " artificial ",
        " melon "                   => " allotment ",
        " melt "                    => " cook ",
        " meltable "                => " aqueous ",
        " meltdown "                => " accident ",
        " melted "                  => " broiled ",
        " member "                  => " affiliate ",
        " members "                 => " associates ",
        " membership "              => " associates ",
        " membrane "                => " film ",
        " membranous "              => " bleary ",
        " memento "                 => " keepsake ",
        " memo "                    => " announcement ",
        " memoir "                  => " account ",
        " memoranda "               => " affairs ",
        " memorandum "              => " announcement ",
        " memorandums "             => " abstracts ",
        " memorial "                => " canonizing ",
        " memorialization "         => " anniversary ",
        " memorialize "             => " approach ",
        " memorializing "           => " canonizing ",
        " memorization "            => " anamnesis ",
        " memorize "                => " acquire ",
        " memorizing "              => " abstraction ",
        " memory "                  => " anamnesis ",
        " menace "                  => " annoyance ",
        " menaced "                 => " bedevilled ",
        " menacing "                => " alarming ",
        " menagerie "               => " assembly ",
        " mendacious "              => " deceitful ",
        " mendacity "               => " bamboozlement ",
        " mendicate "               => " batter ",
        " mending "                 => " acclimation ",
        " menial "                  => " abject ",
        " menology "                => " agenda ",
        " mensurable "              => " assessable ",
        " mensuration "             => " appraisal ",
        " mental "                  => " brainy ",
        " mentalist "               => " clairvoyant ",
        " mention "                 => " acknowledgment ",
        " mentioning "              => " advertence ",
        " mentor "                  => " coach ",
        " mentors "                 => " advisers ",
        " menu "                    => " card ",
        " menus "                   => " airheaded ",
        " meow "                    => " acclamation ",
        " mephitic "                => " corrupt ",
        " mephitis "                => " effluvium ",
        " mercantile "              => " bartering ",
        " mercantilism "            => " commercialism ",
        " mercenary "               => " acquisitive ",
        " merchandisable "          => " bankable ",
        " merchandise "             => " commodity ",
        " merchandiser "            => " baron ",
        " merchandising "           => " affairs ",
        " merchantable "            => " bankable ",
        " merchantry "              => " business ",
        " mercifulness "            => " charity ",
        " merciless "               => " barbarous ",
        " mercilessly "             => " atrociously ",
        " mercilessness "           => " animality ",
        " mercurial "               => " active ",
        " mercurialness "           => " airheadedness ",
        " mercy "                   => " benevolence ",
        " mere "                    => " bald ",
        " merely "                  => " alone ",
        " meretricious "            => " blatant ",
        " meretriciousness "        => " adornment ",
        " merge "                   => " absorb ",
        " merged "                  => " alloyed ",
        " mergence "                => " affiliation ",
        " merger "                  => " alliance ",
        " merging "                 => " amalgamation ",
        " meridian "                => " acme ",
        " meringued "               => " aerated ",
        " merit "                   => " arete ",
        " merited "                 => " becoming ",
        " meritorious "             => " admirable ",
        " merits "                  => " claim ",
        " mermaid "                 => " bogie ",
        " merrily "                 => " blithely ",
        " merriment "               => " brawl ",
        " merry "                   => " amusing ",
        " merry-andrew "            => " antic ",
        " merry-go-round "          => " ball ",
        " merrymaker "              => " antic ",
        " mesa "                    => " acropolis ",
        " mesh "                    => " cobweb ",
        " meshing "                 => " coaction ",
        " meshwork "                => " cobweb ",
        " meshy "                   => " delicate ",
        " mesmeric "                => " adorable ",
        " mesmerism "               => " attractiveness ",
        " mesmerized "              => " bugged ",
        " mesmerizing "             => " anesthetic ",
        " mesne "                   => " feudatory ",
        " mesomorphic "             => " chunky ",
        " mess "                    => " blend ",
        " mess-up "                 => " chaos ",
        " message "                 => " bulletin ",
        " messages "                => " letters ",
        " messed-up "               => " bedraggled ",
        " messenger "               => " agent ",
        " messy "                   => " blowzy ",
        " metacarpus "              => " duke ",
        " metachronism "            => " antedate ",
        " metage "                  => " altitude ",
        " metallic "                => " brownish ",
        " metalware "               => " accouterments ",
        " metamorphosis "           => " alteration ",
        " metanoia "                => " about-face ",
        " metaphor "                => " allegory ",
        " metaphoric "              => " allegorical ",
        " metaphorical "            => " emblematic ",
        " metaphrase "              => " construe ",
        " metaphysical "            => " abstract ",
        " metaphysics "             => " aesthetics ",
        " metasis "                 => " about-face ",
        " metastasis "              => " alteration ",
        " metastasize "             => " clarify ",
        " mete "                    => " admeasure ",
        " meteoric "                => " brief ",
        " meteorologist "           => " astrologer ",
        " meter "                   => " beat ",
        " methanol "                => " booze ",
        " method "                  => " adjustment ",
        " methodically "            => " absolutely ",
        " methodize "               => " accord ",
        " methodological "          => " abstruse ",
        " methodology "             => " alignment ",
        " meticulous "              => " accurate ",
        " meticulously "            => " anxiously ",
        " meticulousness "          => " accurateness ",
        " metonymy "                => " adumbration ",
        " metre "                   => " accent ",
        " metrical "                => " alike ",
        " metrist "                 => " artist ",
        " metro "                   => " busline ",
        " metropolis "              => " city ",
        " metropolitan "            => " city ",
        " mettle "                  => " animation ",
        " mettlesome "              => " courageous ",
        " mewl "                    => " bawl ",
        " mewling "                 => " acclamation ",
        " mezzanine "               => " balustrade ",
        " mezzo "                   => " average ",
        " mezzotint "               => " bite ",
        " miasma "                  => " bane ",
        " miasmatic "               => " communicable ",
        " miasmic "                 => " communicable ",
        " microbe "                 => " bacillus ",
        " microbes "                => " bacilli ",
        " microburst "              => " microburst ",
        " microchip "               => " chip ",
        " microcircuit "            => " chip ",
        " microcosm "               => " apple ",
        " microcosmic "             => " atomic ",
        " microelectronics "        => " chip ",
        " micronize "               => " abrade ",
        " microorganism "           => " bacillus ",
        " microprocessor "          => " chip ",
        " microscopic "             => " diminutive ",
        " microseism "              => " convulsion ",
        " microsleep "              => " break ",
        " microwave "               => " bake ",
        " mid-point "               => " balance ",
        " middle "                  => " average ",
        " middle-class "            => " common ",
        " middle-of-the-road "      => " bourgeois ",
        " middleman "               => " agent ",
        " middlemost "              => " centermost ",
        " middy "                   => " bodice ",
        " midmost "                 => " axial ",
        " midpoint "                => " mean ",
        " midriff "                 => " belly ",
        " midsection "              => " belly ",
        " midst "                   => " bosom ",
        " midway "                  => " amid ",
        " miff "                    => " aggrieve ",
        " miffed "                  => " afflicted ",
        " might "                   => " ability ",
        " mighty "                  => " boss ",
        " migraine "                => " cephalalgia ",
        " migrant "                 => " casual ",
        " migrate "                 => " drift ",
        " migrating "               => " brief ",
        " migration "               => " clearing ",
        " migrative "               => " casual ",
        " migrator "                => " alien ",
        " migratorial "             => " casual ",
        " migratory "               => " afoot ",
        " mikado "                  => " baron ",
        " mild "                    => " balmy ",
        " mild-mannered "           => " amiable ",
        " mild-tempered "           => " accommodating ",
        " mildew "                  => " bane ",
        " mildewed "                => " aged ",
        " mildewy "                 => " aged ",
        " mildly "                  => " agilely ",
        " mildness "                => " affability ",
        " mileage "                 => " breadth ",
        " milepost "                => " battleground ",
        " miles "                   => " afar ",
        " milestone "               => " anniversary ",
        " milieu "                  => " ambience ",
        " militancy "               => " aggression ",
        " militant "                => " active ",
        " militarist "              => " militarist ",
        " militaristic "            => " angry ",
        " military "                => " aggressive ",
        " milk-and-water "          => " banal ",
        " milk-fed "                => " adolescent ",
        " milk-toast "              => " afraid ",
        " milk-warm "               => " blood-warm ",
        " milk-white "              => " alabaster ",
        " milking "                 => " bribery ",
        " milksop "                 => " alarmist ",
        " milky "                   => " alabaster ",
        " mill "                    => " comminute ",
        " milldam "                 => " bank ",
        " milled "                  => " formed ",
        " million "                 => " actor ",
        " millpond "                => " bank ",
        " millstone "               => " accountability ",
        " milquetoast "             => " alarmist ",
        " mimeo "                   => " carbon ",
        " mimeograph "              => " archetype ",
        " mimetic "                 => " artful ",
        " mimic "                   => " actor ",
        " mimicking "               => " artful ",
        " mimicry "                 => " assuming ",
        " minacious "               => " alarming ",
        " minatory "                => " alarming ",
        " mince "                   => " chip ",
        " mincing "                 => " artificial ",
        " mind "                    => " apperception ",
        " mind-bending "            => " affective ",
        " mind-blowing "            => " alarming ",
        " mind-boggler "            => " bewilderment ",
        " mind-boggling "           => " extraordinary ",
        " mind-changing "           => " consciousness-expanding ",
        " mind-expanding "          => " consciousness-expanding ",
        " minded "                  => " absent ",
        " minder "                  => " assistant ",
        " mindful "                 => " alert ",
        " mindfully "               => " carefully ",
        " mindfulness "             => " amenity ",
        " minding "                 => " absorbed ",
        " mindless "                => " asinine ",
        " mine "                    => " abundance ",
        " mineralize "              => " calcify ",
        " minge "                   => " alloy ",
        " mingle "                  => " admix ",
        " mingled "                 => " circuitous ",
        " mingling "                => " assortment ",
        " mini-mall "               => " arcade ",
        " miniaturize "             => " abbreviate ",
        " minify "                  => " abbreviate ",
        " minimal "                 => " basal ",
        " minimization "            => " abuse ",
        " minimize "                => " abbreviate ",
        " minimizing "              => " aspersing ",
        " minion "                  => " beloved ",
        " minister "                => " abbot ",
        " ministerial "             => " apostolic ",
        " ministration "            => " advancement ",
        " ministry "                => " admiral ",
        " mink "                    => " cape ",
        " minor "                   => " accessory ",
        " minor-league "            => " bush ",
        " minority "                => " boyhood ",
        " minors "                  => " amateur ",
        " minster "                 => " basilica ",
        " minstrel "                => " accompanist ",
        " mint "                    => " excellent ",
        " mintage "                 => " bread ",
        " minus "                   => " bare ",
        " minuscule "               => " atomic ",
        " minutely "                => " carefully ",
        " minutes "                 => " account ",
        " minutest "                => " atomic ",
        " minutiae "                => " development ",
        " minx "                    => " babe ",
        " miracle "                 => " phenomenon ",
        " miraculous "              => " amazing ",
        " mirage "                  => " delusion ",
        " mirroring "               => " apery ",
        " mirrorlike "              => " ablaze ",
        " mirth "                   => " amusement ",
        " mirthful "                => " animated ",
        " mirthless "               => " blue ",
        " miry "                    => " begrimed ",
        " misadventure "            => " accident ",
        " misanthrope "             => " cynic ",
        " misanthropic "            => " antisocial ",
        " misanthropical "          => " contemptuous ",
        " misanthropist "           => " carper ",
        " misapplication "          => " corruption ",
        " misapply "                => " blow ",
        " misapprehend "            => " blunder ",
        " misapprehension "         => " apparition ",
        " misappropriate "          => " appropriate ",
        " misappropriation "        => " confiscation ",
        " misbegotten "             => " baseborn ",
        " misbehaved "              => " aweless ",
        " misbehaving "             => " disobedient ",
        " misbelief "               => " apparition ",
        " misbeliever "             => " agitator ",
        " misbelieving "            => " agnostic ",
        " misborn "                 => " adulterated ",
        " miscalculate "            => " blow ",
        " miscalculated "           => " blurred ",
        " miscarriage "             => " abortion ",
        " miscarried "              => " bootless ",
        " miscarry "                => " expel ",
        " miscegenation "           => " amalgam ",
        " miscellaneous "           => " assorted ",
        " miscellany "              => " accumulation ",
        " mischief "                => " atrocity ",
        " mischievous "             => " arch ",
        " mischievousness "         => " archness ",
        " miscolor "                => " color ",
        " miscompute "              => " blow ",
        " miscompute "              => " blow ",
        " misconceive "             => " blunder ",
        " misconceived "            => " askew ",
        " misconception "           => " delusion ",
        " misconduct "              => " delinquency ",
        " misconjecture "           => " blow ",
        " misconstrual "            => " aberration ",
        " misconstruction "         => " delusion ",
        " misconstrue "             => " distort ",
        " miscount "                => " blow ",
        " miscreancy "              => " abomination ",
        " miscreant "               => " corrupt ",
        " miscreated "              => " aberrant ",
        " miscreation "             => " aberration ",
        " miscue "                  => " absurdity ",
        " misdate "                 => " antedate ",
        " misdeed "                 => " criminality ",
        " misdemeanor "             => " abomination ",
        " misdirect "               => " abuse ",
        " misdoubt "                => " disbelief ",
        " mise "                    => " ambience ",
        " mise-en-scene "           => " ambience ",
        " misemploy "               => " dissipate ",
        " misemployment "           => " abusage ",
        " miserable "               => " afflicted ",
        " miserliness "             => " avidity ",
        " miserly "                 => " abject ",
        " misery "                  => " ache ",
        " misfield "                => " bollix ",
        " misfigured "              => " amiss ",
        " misfile "                 => " confuse ",
        " misfire "                 => " abort ",
        " misfit "                  => " misfit ",
        " misfortunate "            => " blighted ",
        " misfortune "              => " accident ",
        " misgiving "               => " anxiety ",
        " misgovern "               => " abuse ",
        " misguide "                => " beguile ",
        " misguided "               => " bearded ",
        " mishandle "               => " abuse ",
        " mishandled "              => " amiss ",
        " mishandling "             => " corruption ",
        " mishap "                  => " blow ",
        " mishmash "                => " hodgepodge ",
        " misidentify "             => " abash ",
        " misimpression "           => " apparition ",
        " misinformed "             => " apprenticed ",
        " misinterpret "            => " alter ",
        " misinterpretation "       => " baloney ",
        " misjudgment "             => " absurdity ",
        " misknow "                 => " addle ",
        " mislaid "                 => " confused ",
        " mislaying "               => " accident ",
        " misleader "               => " cheat ",
        " misleading "              => " ambiguous ",
        " misled "                  => " addled ",
        " mislike "                 => " animosity ",
        " mismanage "               => " blow ",
        " mismanagement "           => " corruption ",
        " mismanager "              => " addle-brain ",
        " mismatch "                => " conflict ",
        " mismatched "              => " altered ",
        " mismated "                => " altered ",
        " misogamist "              => " available ",
        " misogynic "               => " antisocial ",
        " misogynist "              => " available ",
        " misplace "                => " confuse ",
        " misplaced "               => " confused ",
        " misplacement "            => " antedate ",
        " misplacing "              => " accident ",
        " misprint "                => " aberration ",
        " misprize "                => " abhor ",
        " misproportion "           => " anamorphosis ",
        " misproportioned "         => " askew ",
        " misquote "                => " amplify ",
        " misreckon "               => " blow ",
        " misreckoning "            => " confounding ",
        " misrecollect "            => " balloon ",
        " misreport "               => " amplify ",
        " misrepresent "            => " adulterate ",
        " misrepresentation "       => " bribery ",
        " misrepresentative "       => " apocryphal ",
        " misrepresented "          => " biased ",
        " misrule "                 => " anarchy ",
        " miss "                    => " absence ",
        " missed "                  => " absent ",
        " misshape "                => " bend ",
        " misshapen "               => " agee ",
        " misshapenness "           => " aberration ",
        " missive "                 => " cannonball ",
        " misspeak "                => " bloomer ",
        " misspend "                => " blow ",
        " misstate "                => " color ",
        " misstatement "            => " baloney ",
        " missus "                  => " adult ",
        " missy "                   => " babe ",
        " mist "                    => " brume ",
        " mistake "                 => " aberration ",
        " mistakenly "              => " afield ",
        " mistimed "                => " awkward ",
        " mistiness "               => " blur ",
        " mistreat "                => " abuse ",
        " mistreated "              => " abject ",
        " mistreatment "            => " abusage ",
        " mistress "                => " bedmate ",
        " mistrust "                => " apprehension ",
        " mistrustful "             => " afraid ",
        " misty "                   => " bleary ",
        " misunderstanding "        => " confounding ",
        " misunderstood "           => " blurred ",
        " misusage "                => " atrocity ",
        " misuse "                  => " abusage ",
        " misused "                 => " abolished ",
        " miter "                   => " alliance ",
        " mitigate "                => " abate ",
        " mitigation "              => " acknowledgment ",
        " mitigative "              => " advantageous ",
        " mitt "                    => " acclaim ",
        " mitten "                  => " cuff ",
        " mitzvah "                 => " account ",
        " mix-up "                  => " botch ",
        " mixed "                   => " alloyed ",
        " mixed-up "                => " annoyed ",
        " mixing "                  => " bond ",
        " mixmaster "               => " circle ",
        " mixture "                 => " admixture ",
        " mizzle "                  => " dribble ",
        " mnemonic "                => " catchword ",
        " moan "                    => " beef ",
        " moaner "                  => " bear ",
        " moaning "                 => " complaining ",
        " mobbed "                  => " chock-full ",
        " mobile "                  => " adaptable ",
        " mobility "                => " advancement ",
        " mobilize "                => " activate ",
        " mobocracy "               => " anarchy ",
        " mobster "                 => " brigand ",
        " mock "                    => " apish ",
        " mock-heroic "             => " apology ",
        " mock-up "                 => " cartoon ",
        " mocker "                  => " carper ",
        " mockery "                 => " apology ",
        " mocking "                 => " biting ",
        " mode "                    => " approach ",
        " model "                   => " archetypal ",
        " modelable "               => " adjustable ",
        " modeling "                => " clay ",
        " moderate "                => " abstinent ",
        " moderated "               => " chastened ",
        " moderateness "            => " balance ",
        " moderating "              => " abstinent ",
        " moderation "              => " balance ",
        " moderatism "              => " abnegation ",
        " moderator "               => " adjudicator ",
        " modern "                  => " avant-garde ",
        " modernism "               => " addition ",
        " modernistic "             => " avant-garde ",
        " modernity "               => " change ",
        " modernization "           => " addition ",
        " modernize "               => " improve ",
        " modernized "              => " avant-garde ",
        " modest "                  => " bashful ",
        " modestly "                => " abundantly ",
        " modesty "                 => " bashfulness ",
        " modicum "                 => " atom ",
        " modifiable "              => " adjustable ",
        " modified "                => " adapted ",
        " modify "                  => " adapt ",
        " modish "                  => " chic ",
        " modulate "                => " attune ",
        " modulated "               => " articulate ",
        " modulation "              => " accentuation ",
        " module "                  => " bore ",
        " moiety "                  => " atom ",
        " moil "                    => " boil ",
        " moiling "                 => " agitated ",
        " moira "                   => " accident ",
        " moist "                   => " clammy ",
        " moisten "                 => " bathe ",
        " moistened "               => " aqueous ",
        " moistness "               => " clamminess ",
        " moisture "                => " damp ",
        " moistureless "            => " barren ",
        " moisturize "              => " bathe ",
        " mold "                    => " cast ",
        " moldability "             => " bendability ",
        " moldable "                => " adaptable ",
        " moldered "                => " addle ",
        " molding "                 => " abstraction ",
        " moldy "                   => " aged ",
        " mole "                    => " birthmark ",
        " molecular "               => " atomic ",
        " molecule "                => " atom ",
        " molest "                  => " accost ",
        " molestation "             => " agitation ",
        " molested "                => " confused ",
        " moll "                    => " blackmailer ",
        " mollification "           => " abatement ",
        " mollify "                 => " abate ",
        " mollifying "              => " balmy ",
        " mollusk "                 => " mollusk ",
        " mollycoddle "             => " baby ",
        " mollycoddling "           => " accommodating ",
        " molt "                    => " afford ",
        " molten "                  => " aqueous ",
        " momentarily "             => " briefly ",
        " momentary "               => " cursory ",
        " momentousness "           => " account ",
        " momentum "                => " drive ",
        " monarch "                 => " autocrat ",
        " monarchal "               => " absolute ",
        " monarchial "              => " august ",
        " monarchical "             => " august ",
        " monarchy "                => " absolution ",
        " monastery "               => " abbey ",
        " monastic "                => " apostolic ",
        " mondaine "                => " apathetic ",
        " monetary "                => " budgetary ",
        " money-grubbing "          => " acquisitive ",
        " money-lender "            => " broker ",
        " money-making "            => " exploited ",
        " moneybags "               => " backer ",
        " moneyed "                 => " affluent ",
        " moneyless "               => " bankrupt ",
        " moneymaking "             => " advantageous ",
        " monger "                  => " canvass ",
        " mongrelize "              => " blend ",
        " monish "                  => " admonish ",
        " monition "                => " advise ",
        " monitor "                 => " adviser ",
        " monitorial "              => " admonishing ",
        " monitoring "              => " ecology ",
        " monitory "                => " admonishing ",
        " monk "                    => " abbot ",
        " monkeyshine "             => " antic ",
        " monkeyshines "            => " escapade ",
        " monkhood "                => " aloneness ",
        " monkish "                 => " apostolic ",
        " mono "                    => " address ",
        " monochrome "              => " connected ",
        " monocracy "               => " absolution ",
        " monocrat "                => " autocrat ",
        " monocratic "              => " absolutist ",
        " monody "                  => " chant ",
        " monogamist "              => " bedmate ",
        " monogamous "              => " austere ",
        " monogamy "                => " abstemiousness ",
        " monogram "                => " cipher ",
        " monograph "               => " album ",
        " monogynist "              => " bedmate ",
        " monolith "                => " brace ",
        " monolithic "              => " caked ",
        " monologue "               => " address ",
        " monomania "               => " chic ",
        " monomaniacal "            => " biased ",
        " monophonic "              => " connected ",
        " monopolize "              => " absorb ",
        " monopolized "             => " absorbed ",
        " monopolizing "            => " arresting ",
        " monopoly "                => " cartel ",
        " monotone "                => " banausic ",
        " monotonous "              => " banausic ",
        " monotonousness "          => " boredom ",
        " monotony "                => " boredom ",
        " monsignor "               => " abbey ",
        " monsoon "                 => " cloudburst ",
        " monstrosity "             => " blunder ",
        " monstrous "               => " aberrant ",
        " monstrousness "           => " atrociousness ",
        " month "                   => " ages ",
        " monthly "                 => " account ",
        " monument "                => " cairn ",
        " monumental "              => " awe-inspiring ",
        " monumentalization "       => " celebration ",
        " monumentalize "           => " admire ",
        " mooch "                   => " angle ",
        " mooching "                => " aimless ",
        " mood "                    => " affection ",
        " moodiness "               => " dejection ",
        " moody "                   => " angry ",
        " moolah "                  => " bill ",
        " mooning "                 => " absent ",
        " moonlight "               => " annex ",
        " moonlighter "             => " bandit ",
        " moonlighting "            => " cheating ",
        " moonlit "                 => " ablaze ",
        " moonman "                 => " cosmonaut ",
        " moonshine "               => " booze ",
        " moony "                   => " absent ",
        " moor "                    => " berth ",
        " moored "                  => " anchored ",
        " mooring "                 => " ballast ",
        " moorland "                => " acreage ",
        " moot "                    => " arguable ",
        " mootable "                => " arguable ",
        " mooting "                 => " agitation ",
        " mop-up "                  => " cleanup ",
        " mope "                    => " ache ",
        " mopes "                   => " apathy ",
        " mopey "                   => " austere ",
        " moping "                  => " blue ",
        " mopish "                  => " abject ",
        " moppet "                  => " amateur ",
        " mopping "                 => " bed-making ",
        " mora "                    => " beat ",
        " moraine "                 => " backbone ",
        " morale "                  => " assurance ",
        " moralism "                => " castigation ",
        " morality "                => " chastity ",
        " moralizing "              => " academic ",
        " morally "                 => " about ",
        " morals "                  => " behavior ",
        " moratorium "              => " adjournment ",
        " moratory "                => " backward ",
        " morbid "                  => " aberrant ",
        " morbidity "               => " anguish ",
        " mordacious "              => " belittling ",
        " mordacity "               => " acerbity ",
        " mordancy "                => " acidity ",
        " mordant "                 => " acerbic ",
        " more "                    => " added ",
        " moreover "                => " also ",
        " mores "                   => " community ",
        " morgue "                  => " antipathy ",
        " moribund "                => " corrupt ",
        " moron "                   => " addle-pate ",
        " moronic "                 => " arrested ",
        " morose "                  => " acrimonious ",
        " moroseness "              => " acerbity ",
        " morphology "              => " analysis ",
        " morphon "                 => " animal ",
        " morsel "                  => " bait ",
        " mort "                    => " body ",
        " mortal "                  => " bitter ",
        " mortality "               => " bloodshed ",
        " mortally "                => " acutely ",
        " mortals "                 => " bodies ",
        " mortar "                  => " adhesive ",
        " mortiferous "             => " deadly ",
        " mortification "           => " annoyance ",
        " mortified "               => " ashamed ",
        " mortify "                 => " abase ",
        " mortifying "              => " awkward ",
        " mortise "                 => " accord ",
        " mosaic "                  => " circuitous ",
        " mosey "                   => " ankle ",
        " mosque "                  => " abbey ",
        " most "                    => " best ",
        " mostest "                 => " able ",
        " motel "                   => " cabin ",
        " moth-eaten "              => " age-old ",
        " mothball "                => " bottle ",
        " mothballed "              => " abandoned ",
        " motherland "              => " citizenry ",
        " motherly "                => " affectionate ",
        " motif "                   => " burden ",
        " motile "                  => " adaptable ",
        " motility "                => " activity ",
        " motionless "              => " apoplectic ",
        " motionlessly "            => " durably ",
        " motionlessness "          => " blow ",
        " motivate "                => " actuate ",
        " motivating "              => " affective ",
        " motivation "              => " action ",
        " motiveless "              => " aimless ",
        " motley "                  => " assorted ",
        " motorcade "               => " celebration ",
        " motorcar "                => " auto ",
        " motorized "               => " automatic ",
        " motorman "                => " architect ",
        " mottle "                  => " bespeckle ",
        " mottled "                 => " blotchy ",
        " mottling "                => " blemish ",
        " motto "                   => " adage ",
        " moue "                    => " face ",
        " mound "                   => " bank ",
        " mount "                   => " arise ",
        " mountain "                => " abundance ",
        " mountaineer "             => " backwoodsman ",
        " mountainous "             => " aerial ",
        " mountebank "              => " antic ",
        " mounted "                 => " army ",
        " mounting "                => " ascent ",
        " mourn "                   => " ache ",
        " mournful "                => " atrocious ",
        " mournfully "              => " acutely ",
        " mournfulness "            => " dejection ",
        " mourning "                => " aching ",
        " mouse "                   => " abrasion ",
        " mouser "                  => " bobcat ",
        " mousetrap "               => " allure ",
        " mousiness "               => " backwardness ",
        " moustache "               => " beard ",
        " mousy "                   => " bashful ",
        " mouth "                   => " aperture ",
        " mouth-watering "          => " adorable ",
        " mouthful "                => " affirmation ",
        " mouthing "                => " face ",
        " mouthpiece "              => " advocate ",
        " mouthwatering "           => " aperitive ",
        " mouthy "                  => " chattering ",
        " movable "                 => " adaptable ",
        " movables "                => " appliance ",
        " moved "                   => " confused ",
        " movie "                   => " cine ",
        " moviegoer "               => " beholder ",
        " moviegoers "              => " admirers ",
        " moving "                  => " affective ",
        " movingly "                => " acutely ",
        " moxie "                   => " appetite ",
        " much "                    => " abundant ",
        " much-publicized "         => " acclaimed ",
        " mucho "                   => " abounding ",
        " mucid "                   => " close ",
        " mucilage "                => " adhesive ",
        " mucilaginous "            => " adhering ",
        " muckamuck "               => " aliment ",
        " mucker "                  => " barbarian ",
        " muckrake "                => " agitate ",
        " mucky "                   => " blurred ",
        " mucosa "                  => " film ",
        " mucous "                  => " close ",
        " mucronate "               => " acicular ",
        " muculent "                => " close ",
        " mucus "                   => " fungus ",
        " mud-slinging "            => " aspersion ",
        " muddied "                 => " decrepit ",
        " muddle "                  => " ataxia ",
        " muddle-headed "           => " asinine ",
        " muddled "                 => " abashed ",
        " muddledness "             => " befuddlement ",
        " muddlement "              => " alarm ",
        " muddler "                 => " addle-brain ",
        " muddy "                   => " addled ",
        " mudlark "                 => " drop ",
        " mudsling "                => " agitate ",
        " muff "                    => " blooper ",
        " muffer "                  => " addle-brain ",
        " muffle "                  => " conceal ",
        " muffled "                 => " deadened ",
        " mufti "                   => " accouterment ",
        " mugger "                  => " aggressor ",
        " mugginess "               => " clamminess ",
        " mugging "                 => " advance ",
        " muggy "                   => " clammy ",
        " mugwumpian "              => " ambiguous ",
        " mukluk "                  => " cossack ",
        " muktuk "                  => " bark ",
        " mulch "                   => " admixture ",
        " mulct "                   => " blackmail ",
        " muliebral "               => " changeable ",
        " muliebrity "              => " delicacy ",
        " mulish "                  => " authoritarian ",
        " mulling "                 => " answer ",
        " multeity "                => " assortment ",
        " multi-colored "           => " consciousness-expanding ",
        " multicolor "              => " checkered ",
        " multicolored "            => " checkered ",
        " multifaceted "            => " able ",
        " multifarious "            => " circuitous ",
        " multifariousness "        => " assortment ",
        " multifold "               => " assorted ",
        " multiform "               => " circuitous ",
        " multiformity "            => " assortment ",
        " multihued "               => " brindle ",
        " multiloquent "            => " communicative ",
        " multinational "           => " bunch ",
        " multiple "                => " assorted ",
        " multiplex "               => " circuitous ",
        " multiplicity "            => " complication ",
        " multiplied "              => " assorted ",
        " multiply "                => " accumulate ",
        " multiplying "             => " adding ",
        " multitude "               => " aggregation ",
        " multitudinal "            => " countless ",
        " multitudinous "           => " abounding ",
        " multivarious "            => " assorted ",
        " mumble "                  => " grumble ",
        " mumbled "                 => " decrepit ",
        " mumbling "                => " blurred ",
        " mumbo-jumbo "             => " abracadabra ",
        " mummer "                  => " amateur ",
        " mummery "                 => " ceremoniousness ",
        " mummified "               => " diminished ",
        " mummify "                 => " coffin ",
        " mummy "                   => " casket ",
        " mumpish "                 => " acid ",
        " munch "                   => " bite ",
        " munchies "                => " antipasto ",
        " mundane "                 => " banal ",
        " mung "                    => " clay ",
        " mungo "                   => " ample ",
        " municipal "               => " borough ",
        " municipality "            => " city ",
        " munificently "            => " amply ",
        " munition "                => " armament ",
        " munitions "               => " ammunition ",
        " mural "                   => " mural ",
        " murder "                  => " annihilation ",
        " murderer "                => " assassin ",
        " murderous "               => " arduous ",
        " murderously "             => " berserk ",
        " murderousness "           => " animality ",
        " murk "                    => " billow ",
        " murkiness "               => " caliginosity ",
        " murky "                   => " black ",
        " murmur "                  => " babble ",
        " murmuration "             => " babble ",
        " murmuring "               => " aside ",
        " muscle "                  => " beef ",
        " muscles "                 => " anatomy ",
        " muscular "                => " able-bodied ",
        " muscularity "             => " beef ",
        " musculature "             => " anchor ",
        " muse "                    => " brood ",
        " museum "                  => " building ",
        " mush "                    => " concoction ",
        " mushroom "                => " augment ",
        " mushrooming "             => " blooming ",
        " mushy "                   => " doughy ",
        " musical "                 => " agreeable ",
        " musician "                => " artist ",
        " musing "                  => " absorption ",
        " musket "                  => " blaster ",
        " muss "                    => " chaos ",
        " mussed-up "               => " beat-up ",
        " mussel "                  => " mollusk ",
        " must "                    => " charge ",
        " mustard "                 => " alacrity ",
        " muster "                  => " aggregation ",
        " musty "                   => " aged ",
        " mutability "              => " alteration ",
        " mutable "                 => " arbitrary ",
        " mutant "                  => " aberrant ",
        " mutate "                  => " adapt ",
        " mutation "                => " alteration ",
        " mute "                    => " aphasiac ",
        " muted "                   => " aerial ",
        " muteness "                => " blackout ",
        " mutilate "                => " adulterate ",
        " mutilated "               => " burst ",
        " mutilation "              => " anamorphosis ",
        " mutineer "                => " agitator ",
        " mutinous "                => " alienated ",
        " mutiny "                  => " disobedience ",
        " mutt "                    => " bearcat ",
        " mutter "                  => " complain ",
        " muttered "                => " decrepit ",
        " muttering "               => " blubbering ",
        " muttonchops "             => " bristles ",
        " muttonhead "              => " addle-pate ",
        " mutual "                  => " alternate ",
        " mutuality "               => " accord ",
        " muzzle "                  => " cage ",
        " muzzled "                 => " acclimatized ",
        " muzzy "                   => " befuddled ",
        " myopia "                  => " amaurosis ",
        " myopic "                  => " astigmatic ",
        " myriad "                  => " countless ",
        " myrmidon "                => " accomplice ",
        " myrrh "                   => " aroma ",
        " mysterial "               => " ambiguous ",
        " mysterious "              => " abstruse ",
        " mystery "                 => " abstruseness ",
        " mystic "                  => " abstruse ",
        " mystification "           => " abashing ",
        " mystified "               => " addled ",
        " mystify "                 => " baffle ",
        " mystique "                => " attitude ",
        " myth "                    => " allegory ",
        " mythic "                  => " allegorical ",
        " mythical "                => " allegorical ",
        " mythicism "               => " belief ",
        " mythological "            => " fabulous ",
        " mythology "               => " belief ",
        " mythomaniac "             => " apostate ",
        " mythos "                  => " ballad ",
        " myths "                   => " belief ",
        " nabe "                    => " ambience ",
        " nacelle "                 => " bassinet ",
        " nacreous "                => " irised ",
        " nada "                    => " aught ",
        " nadir "                   => " base ",
        " nagging "                 => " acrimonious ",
        " naiad "                   => " damsel ",
        " naif "                    => " amateur ",
        " nail "                    => " attach ",
        " nail-biter "              => " all-overs ",
        " naive "                   => " aboveboard ",
        " naively "                 => " aboveboard ",
        " naivety "                 => " artlessness ",
        " nakedness "               => " dishabille ",
        " namby-pamby "             => " banal ",
        " name-dropper "            => " high-hat ",
        " name-of-the-game "        => " basic ",
        " named "                   => " called ",
        " naming "                  => " allotment ",
        " nana "                    => " assistant ",
        " nancy "                   => " chichi ",
        " nanny "                   => " assistant ",
        " napalm "                  => " armament ",
        " napped "                  => " down-covered ",
        " napping "                 => " comatose ",
        " nappy "                   => " bristling ",
        " narc "                    => " badge ",
        " narcissist "              => " autist ",
        " narcissistic "            => " egotistic ",
        " narcoleptic "             => " annoyed ",
        " narcosis "                => " befuddlement ",
        " narcotic "                => " analgesic ",
        " narcotize "               => " adulterate ",
        " narcotized "              => " benumbed ",
        " nares "                   => " adenoids ",
        " nark "                    => " allurement ",
        " narrate "                 => " characterize ",
        " narrated "                => " anecdotal ",
        " narrating "               => " address ",
        " narration "               => " account ",
        " narrative "               => " anecdotal ",
        " narrow "                  => " attenuated ",
        " narrow-minded "           => " bigoted ",
        " narrow-mindedness "       => " bent ",
        " narrowing "               => " absorption ",
        " narrowly "                => " almost ",
        " narrows "                 => " anchorage ",
        " narthex "                 => " antechamber ",
        " nasalize "                => " chant ",
        " nascency "                => " bearing ",
        " nascent "                 => " beginning ",
        " nastiness "               => " carrion ",
        " nasty "                   => " awful ",
        " nasty-tempered "          => " acid ",
        " natality "                => " bearing ",
        " natatorial "              => " abyssal ",
        " natatorium "              => " basin ",
        " natatory "                => " amphibian ",
        " natch "                   => " artlessly ",
        " national "                => " civic ",
        " nationalism "             => " bellicism ",
        " nationality "             => " allegiance ",
        " nationwide "              => " civic ",
        " native "                  => " built-in ",
        " natives "                 => " citizenry ",
        " nativity "                => " bearing ",
        " natter "                  => " chatter ",
        " nattering "               => " argot ",
        " natty "                   => " chichi ",
        " natural "                 => " accustomed ",
        " naturalism "              => " accuracy ",
        " naturalization "          => " acclimatization ",
        " naturalize "              => " choose ",
        " naturalized "             => " aborigine ",
        " naturalizing "            => " adopting ",
        " naturally "               => " artlessly ",
        " naturalness "             => " adroitness ",
        " nature "                  => " attributes ",
        " nature-loving "           => " alfresco ",
        " naughty "                 => " annoying ",
        " nausea "                  => " abhorrence ",
        " nauseate "                => " bother ",
        " nauseating "              => " abhorrent ",
        " nauseation "              => " abhorrence ",
        " nauseous "                => " abhorrent ",
        " nautical "                => " abyssal ",
        " nautics "                 => " aeronautics ",
        " naval "                   => " argosy ",
        " nave "                    => " axis ",
        " navel "                   => " axis ",
        " navigable "               => " accessible ",
        " navigate "                => " cross ",
        " navigating "              => " abyssal ",
        " navigation "              => " aeronautics ",
        " navigational "            => " abyssal ",
        " navy "                    => " fleet ",
        " naysaying "               => " abrogating ",
        " nazism "                  => " absolutism ",
        " near "                    => " abreast ",
        " near-at-hand "            => " abutting ",
        " near-sighted "            => " astigmatic ",
        " nearabout "               => " about ",
        " nearby "                  => " adjacent ",
        " nearest "                 => " abutting ",
        " nearing "                 => " advancing ",
        " nearly "                  => " about ",
        " nearness "                => " approximation ",
        " nearsighted "             => " careless ",
        " neat "                    => " accurate ",
        " neaten "                  => " absterge ",
        " neath "                   => " beneath ",
        " neato "                   => " admirable ",
        " nebbish "                 => " chicken ",
        " nebula "                  => " billow ",
        " nebulosity "              => " billow ",
        " nebulous "                => " ambiguous ",
        " necessary "               => " all-important ",
        " necessitated "            => " apprenticed ",
        " necessitation "           => " administration ",
        " necessities "             => " aliment ",
        " necessitous "             => " bankrupt ",
        " necessitousness "         => " abjection ",
        " necessity "               => " call ",
        " neck "                    => " close ",
        " neck-and-neck "           => " close ",
        " necklace "                => " chaplet ",
        " necklet "                 => " chaplet ",
        " necromancer "             => " archimage ",
        " necromancy "              => " diabolism ",
        " necromantic "             => " bewitched ",
        " necropsy "                => " dissection ",
        " necrosis "                => " afterlife ",
        " necrotic "                => " baleful ",
        " nectar "                  => " ambrosia ",
        " nectareous "              => " adorable ",
        " nectarous "               => " adorable ",
        " need "                    => " charge ",
        " needed "                  => " bare ",
        " needfulness "             => " acuteness ",
        " neediness "               => " deprivation ",
        " needing "                 => " defective ",
        " needle "                  => " aggravate ",
        " needle-pointed "          => " aciculate ",
        " needlelike "              => " aciculate ",
        " needlepoint "             => " adornment ",
        " needles "                 => " all-overs ",
        " needless "                => " causeless ",
        " needlework "              => " adornment ",
        " needy "                   => " beggared ",
        " nefarious "               => " abominable ",
        " nefariousness "           => " atrociousness ",
        " negate "                  => " abate ",
        " negating "                => " adverse ",
        " negation "                => " antithesis ",
        " negative "                => " abrogating ",
        " negatively "              => " abnormally ",
        " negativistic "            => " averse ",
        " negator "                 => " antitoxin ",
        " negatory "                => " antithesis ",
        " neglect "                 => " carelessness ",
        " neglected "               => " alone ",
        " neglectful "              => " behindhand ",
        " neglectfulness "          => " apathy ",
        " neglecting "              => " apathy ",
        " negligence "              => " apathy ",
        " negligent "               => " behindhand ",
        " negligently "             => " abominably ",
        " negotiate "               => " accommodate ",
        " negotiated "              => " adjourned ",
        " negotiation "             => " agreement ",
        " negotiator "              => " adjudicator ",
        " neighbor "                => " acquaintance ",
        " neighborhood "            => " adjacency ",
        " neighboring "             => " adjoining ",
        " neighborliness "          => " amicableness ",
        " neighborly "              => " amiable ",
        " neolith "                 => " deposit ",
        " neonate "                 => " adolescent ",
        " neophyte "                => " abecedarian ",
        " neoplasm "                => " bump ",
        " neoteric "                => " beginning ",
        " nepotism "                => " bribery ",
        " nerd "                    => " alarmist ",
        " nerdy "                   => " banal ",
        " nerve "                   => " assumption ",
        " nerve-racking "           => " agonizing ",
        " nerveless "               => " collected ",
        " nerves "                  => " fretfulness ",
        " nervous "                 => " afraid ",
        " nervousness "             => " agitation ",
        " nervy "                   => " cheeky ",
        " nescience "               => " benightedness ",
        " nescient "                => " apprenticed ",
        " nest "                    => " backup ",
        " nestle "                  => " bundle ",
        " nestling "                => " adolescent ",
        " nethermost "              => " basal ",
        " netting "                 => " applique ",
        " nettle "                  => " annoy ",
        " nettled "                 => " affronted ",
        " nettlesome "              => " afflictive ",
        " nettling "                => " anger ",
        " network "                 => " arrangement ",
        " neurasthenia "            => " fretfulness ",
        " neurasthenic "            => " arthritic ",
        " neurological "            => " acoustic ",
        " neurosis "                => " aberration ",
        " neurotic "                => " aberrant ",
        " neuroticism "             => " agitation ",
        " neuter "                  => " alter ",
        " neutral "                 => " aloof ",
        " neutralist "              => " isolationist ",
        " neutralization "          => " abatement ",
        " neutralize "              => " abrogate ",
        " neutralized "             => " abortive ",
        " neutralizer "             => " antitoxin ",
        " neutralizing "            => " acrid ",
        " never-ceasing "           => " abiding ",
        " never-ending "            => " amaranthine ",
        " never-failing "           => " abiding ",
        " nevertheless "            => " about ",
        " nevus "                   => " birthmark ",
        " new-fashioned "           => " avant-garde ",
        " newborn "                 => " bairn ",
        " newel "                   => " column ",
        " newfangled "              => " contemporary ",
        " newie "                   => " amateur ",
        " newish "                  => " adolescent ",
        " newly "                   => " anew ",
        " newlyweds "               => " brace ",
        " newness "                 => " addition ",
        " news "                    => " account ",
        " newscast "                => " advertisement ",
        " newscaster "              => " anchorperson ",
        " newshawk "                => " anchorman ",
        " newshound "               => " anchorman ",
        " newsman "                 => " accuser ",
        " newspaper "               => " bi-weekly ",
        " newspaperman "            => " announcer ",
        " newspaperwoman "          => " anchorman ",
        " newspeak "                => " abracadabra ",
        " newsprint "               => " card ",
        " newsworthy "              => " contemporary ",
        " newsy "                   => " advisory ",
        " next "                    => " abutting ",
        " nexus "                   => " antecedent ",
        " nibble "                  => " crumb ",
        " nicely "                  => " accurately ",
        " niche "                   => " alcove ",
        " nicked "                  => " aching ",
        " nicker "                  => " acclamation ",
        " nickname "                => " appellation ",
        " nifty "                   => " chic ",
        " niggard "                 => " boor ",
        " niggardliness "           => " avidity ",
        " niggardly "               => " chintzy ",
        " niggle "                  => " atom ",
        " niggling "                => " analytical ",
        " nigh "                    => " about ",
        " nightcap "                => " nightcap ",
        " nightclub "               => " bistro ",
        " nightfall "               => " black ",
        " nighthawk "               => " abandoned ",
        " nightingale "             => " accompanist ",
        " nightmare "               => " daydream ",
        " nightmarish "             => " awful ",
        " nightstick "              => " billy ",
        " nighttime "               => " caliginosity ",
        " nigrescent "              => " atramentous ",
        " nigrify "                 => " befoul ",
        " nigritude "               => " caliginosity ",
        " nigrous "                 => " atramentous ",
        " nihilism "                => " abnegation ",
        " nihilist "                => " agitator ",
        " nihilistic "              => " anarchic ",
        " nihility "                => " abyss ",
        " nimble "                  => " active ",
        " nimble-fingered "         => " able ",
        " nimble-footed "           => " agile ",
        " nimble-witted "           => " able ",
        " nimbleness "              => " ability ",
        " nimbly "                  => " agilely ",
        " nimbus "                  => " aura ",
        " nimiety "                 => " balance ",
        " nimrod "                  => " blockhead ",
        " nincompoop "              => " blockhead ",
        " nine-to-fiver "           => " artisan ",
        " nipping "                 => " bitter ",
        " nippy "                   => " chill ",
        " nirvanic "                => " absent ",
        " nisse "                   => " brownie ",
        " nit-picking "             => " acrimonious ",
        " nitpick "                 => " bother ",
        " nitpicking "              => " animadversion ",
        " nitpicky "                => " captious ",
        " nitwit "                  => " blockhead ",
        " nitwitted "               => " asinine ",
        " no-account "              => " base ",
        " no-brainer "              => " breeze ",
        " no-frills "               => " basic ",
        " no-go "                   => " extraordinary ",
        " no-good "                 => " abject ",
        " no-no "                   => " boycott ",
        " no-nonsense "             => " common ",
        " nobby "                   => " active ",
        " nobiliary "               => " blue-blooded ",
        " nobility "                => " dignity ",
        " noble "                   => " blue-blooded ",
        " noble-minded "            => " benevolent ",
        " nobleman "                => " blueblood ",
        " nobleness "               => " address ",
        " noblesse "                => " elite ",
        " noblewoman "              => " adult ",
        " nobly "                   => " amply ",
        " nobody "                  => " cipher ",
        " nock "                    => " cleft ",
        " nodding "                 => " comatose ",
        " noddle "                  => " attic ",
        " noddy "                   => " aliment ",
        " node "                    => " bulge ",
        " nodular "                 => " asperous ",
        " nodulation "              => " appendage ",
        " nodule "                  => " birthmark ",
        " noggin "                  => " alembic ",
        " noise "                   => " babble ",
        " noiseless "               => " hushed ",
        " noiselessness "           => " calm ",
        " noisily "                 => " audibly ",
        " noisomeness "             => " fetor ",
        " noisy "                   => " blatant ",
        " nomad "                   => " itinerant ",
        " nomadic "                 => " drifting ",
        " nomadize "                => " drift ",
        " nomen "                   => " appellation ",
        " nomenclature "            => " classification ",
        " nominate "                => " appoint ",
        " nomination "              => " choice ",
        " nominee "                 => " appointee ",
        " non-animal "              => " azoic ",
        " non-expert "              => " amateurish ",
        " non-fiction "             => " book ",
        " non-germane "             => " abstracted ",
        " non-indulgent "           => " abstaining ",
        " non-irritating "          => " balmy ",
        " non-negotiable "          => " basic ",
        " non-public "              => " clandestine ",
        " non-stop "                => " ceaseless ",
        " non-transferable "        => " basic ",
        " non-vegetable "           => " azoic ",
        " nonacceptance "           => " abnegation ",
        " nonage "                  => " adolescence ",
        " nonagreement "            => " bone ",
        " nonaligned "              => " isolationist ",
        " nonbeing "                => " annihilation ",
        " nonbelligerent "          => " aloof ",
        " nonbreakable "            => " adamantine ",
        " nonchalance "             => " accord ",
        " nonchalant "              => " airy ",
        " noncitizen "              => " face ",
        " noncivil "                => " aggressive ",
        " nonclerical "             => " inexpert ",
        " noncombatant "            => " noncombatant ",
        " noncombative "            => " noncombatant ",
        " noncommital "             => " deadpan ",
        " noncommittal "            => " ambiguous ",
        " noncompliance "           => " contravention ",
        " noncompliant "            => " contumacious ",
        " noncompulsory "           => " alternative ",
        " nonconcrete "             => " abstruse ",
        " nonconcurrence "          => " bone ",
        " nonconformably "          => " abnormally ",
        " nonconforming "           => " adverse ",
        " nonconformism "           => " bone ",
        " noncooperator "           => " agitator ",
        " nondescript "             => " characterless ",
        " nondiscriminating "       => " candid ",
        " nondiscriminatory "       => " abstract ",
        " nonemotional "            => " blank ",
        " nonentity "               => " blank ",
        " nonesuch "                => " anomaly ",
        " nonevent "                => " nonevent ",
        " nonexclusive "            => " all-encompassing ",
        " nonexistence "            => " antithesis ",
        " nonexistent "             => " absent ",
        " nonfiction "              => " album ",
        " nonflexible "             => " hard ",
        " nonfulfillment "          => " annoyance ",
        " nonfunctional "           => " adorning ",
        " nongermane "              => " absurd ",
        " nongovernment "           => " chaos ",
        " nongregarious "           => " backward ",
        " noninclusion "            => " barring ",
        " noninterference "         => " alienation ",
        " nonirritant "             => " balmy ",
        " nonirritating "           => " controllable ",
        " nonliability "            => " dispensation ",
        " nonmandatory "            => " arbitrary ",
        " nonmaterial "             => " aerial ",
        " nonmaterialistic "        => " abstract ",
        " nonmilitant "             => " noncombatant ",
        " nonnative "               => " adopted ",
        " nonobjective "            => " abstract ",
        " nonobligatory "           => " arbitrary ",
        " nonobservance "           => " contravention ",
        " nonobservant "            => " contrary ",
        " nonpareil "               => " epitome ",
        " nonparticipating "        => " aloof ",
        " nonparticipation "        => " abstention ",
        " nonpartisan "             => " detached ",
        " nonpayment "              => " defalcation ",
        " nonperformance "          => " abortion ",
        " nonperishable "           => " abiding ",
        " nonphysical "             => " aerial ",
        " nonplus "                 => " astonish ",
        " nonplussed "              => " awestruck ",
        " nonpoisonous "            => " certain ",
        " nonporous "               => " close ",
        " nonproductive "           => " barren ",
        " nonprofessional "         => " abecedarian ",
        " nonprovocative "          => " calm ",
        " nonrational "             => " abstruse ",
        " nonreligious "            => " agnostic ",
        " nonrepresentative "       => " abstract ",
        " nonresident "             => " adopted ",
        " nonresistance "           => " abasement ",
        " nonresistant "            => " acquiescent ",
        " nonresisting "            => " accommodated ",
        " nonrural "                => " burghal ",
        " nonsacred "               => " banausic ",
        " nonsensical "             => " cool ",
        " nonsensically "           => " blab ",
        " nonserious "              => " barmy ",
        " nonspecialist "           => " inexpert ",
        " nonspecific "             => " all-embracing ",
        " nonspiritual "            => " alluvial ",
        " nonstandard "             => " abnormal ",
        " nonstop "                 => " ceaseless ",
        " nonsymmetrical "          => " asymmetric ",
        " nontoxic "                => " controllable ",
        " nontranslucent "          => " blurred ",
        " nontransparent "          => " blurred ",
        " nonuniform "              => " aberrant ",
        " nonuniformity "           => " contrast ",
        " nonviable "               => " abstract ",
        " nonviolent "              => " irenic ",
        " nonvocal "                => " bashful ",
        " noodge "                  => " abrade ",
        " noodle "                  => " brainstorm ",
        " nook "                    => " alcove ",
        " nookie "                  => " action ",
        " noon "                    => " apex ",
        " nooner "                  => " affair ",
        " noose "                   => " asphyxiate ",
        " nope "                    => " bone ",
        " noplace "                 => " annoying ",
        " norm "                    => " barometer ",
        " normal "                  => " accustomed ",
        " normalcy "                => " course ",
        " normality "               => " course ",
        " normalize "               => " adapt ",
        " normally "                => " commonly ",
        " north "                   => " arctic ",
        " northbound "              => " arctic ",
        " northerly "               => " arctic ",
        " northern "                => " arctic ",
        " northmost "               => " arctic ",
        " northward "               => " arctic ",
        " nose "                    => " adenoids ",
        " nose-dive "               => " bend ",
        " nosegay "                 => " boutonniere ",
        " nosey "                   => " acid ",
        " nosh "                    => " absorb ",
        " noshery "                 => " bistro ",
        " nosiness "                => " concern ",
        " nostalgia "               => " homesickness ",
        " nostalgic "               => " cornball ",
        " nostrils "                => " adenoids ",
        " nosy "                    => " eavesdropping ",
        " notability "              => " credibility ",
        " notably "                 => " conspicuously ",
        " notary "                  => " agent ",
        " notation "                => " characters ",
        " notch "                   => " cleft ",
        " notched "                 => " alveolate ",
        " note "                    => " agenda ",
        " notebook "                => " anthology ",
        " noted "                   => " acclaimed ",
        " notepad "                 => " block ",
        " notes "                   => " addendum ",
        " nothing "                 => " annihilation ",
        " nothingness "             => " pettiness ",
        " notice "                  => " apprehension ",
        " noticeable "              => " apparent ",
        " noticeably "              => " acutely ",
        " noticing "                => " acquainted ",
        " notifier "                => " accuser ",
        " notify "                  => " acquaint ",
        " notifying "               => " advice ",
        " noting "                  => " acquainted ",
        " notion "                  => " angle ",
        " notional "                => " abstract ",
        " notoriety "               => " ballyhoo ",
        " notorious "               => " belled ",
        " notoriously "             => " awfully ",
        " notoriousness "           => " abomination ",
        " notwithstanding "         => " admitting ",
        " nought "                  => " blank ",
        " nourish "                 => " attend ",
        " nourishing "              => " alimentative ",
        " nourishment "             => " aliment ",
        " nous "                    => " commonsense ",
        " novel "                   => " atypical ",
        " novelist "                => " biographer ",
        " novelty "                 => " change ",
        " novice "                  => " amateur ",
        " novitiate "               => " amateur ",
        " nowhere "                 => " boilerplate ",
        " noxious "                 => " baneful ",
        " noxiousness "             => " adulteration ",
        " nozzle "                  => " bill ",
        " nuance "                  => " dash ",
        " nubbin "                  => " atom ",
        " nubile "                  => " conjugal ",
        " nubilous "                => " blurred ",
        " nucleus "                 => " basis ",
        " nudity "                  => " dishabille ",
        " nugatory "                => " aimless ",
        " nugget "                  => " asset ",
        " null "                    => " absent ",
        " nullification "           => " abolishment ",
        " nullified "               => " annulled ",
        " nullifier "               => " antitoxin ",
        " nullify "                 => " abate ",
        " nullifying "              => " adverse ",
        " nullity "                 => " abyss ",
        " numb "                    => " aloof ",
        " numbed "                  => " algid ",
        " number "                  => " cardinal ",
        " numbering "               => " calculation ",
        " numberless "              => " bags ",
        " numbing "                 => " algid ",
        " numbness "                => " asleep ",
        " numbnuts "                => " baboon ",
        " numbskull "               => " backward ",
        " numen "                   => " ability ",
        " numeral "                 => " character ",
        " numerical "               => " after ",
        " numerous "                => " abundant ",
        " numerousness "            => " advantage ",
        " numinous "                => " abstract ",
        " numismatic "              => " budgetary ",
        " numskull "                => " blockhead ",
        " numskulled "              => " doltish ",
        " nunatak "                 => " abundance ",
        " nunch "                   => " bite ",
        " nuncio "                  => " agent ",
        " nunnery "                 => " abbey ",
        " nunny-bag "               => " haversack ",
        " nuptial "                 => " bridal ",
        " nuptials "                => " bridal ",
        " nurse "                   => " assistant ",
        " nurserymaid "             => " assistant ",
        " nurture "                 => " breeding ",
        " nurtured "                => " accomplished ",
        " nurturing "               => " adorning ",
        " nutcake "                 => " beatnik ",
        " nutcase "                 => " case ",
        " nutmeg "                  => " absurd ",
        " nutrient "                => " comestible ",
        " nutriment "               => " aliment ",
        " nutrimental "             => " alimentative ",
        " nutrition "               => " diet ",
        " nutritional "             => " comestible ",
        " nutritious "              => " alimental ",
        " nutritive "               => " comestible ",
        " nuts "                    => " basics ",
        " nuts-and-bolts "          => " all-important ",
        " nutshell "                => " abridge ",
        " nutsy "                   => " animated ",
        " nutter "                  => " dement ",
        " nutty "                   => " absurd ",
        " nuzzle "                  => " bundle ",
        " nymph "                   => " damsel ",
        " nymphet "                 => " babe ",
        " nymphomaniac "            => " amorous ",
        " oafishness "              => " amateurishness ",
        " oasis "                   => " haven ",
        " oath "                    => " adjuration ",
        " oatmeal "                 => " biscuit ",
        " obduracy "                => " acerbity ",
        " obdurate "                => " adamant ",
        " obedience "               => " accordance ",
        " obedient "                => " acquiescent ",
        " obeisance "               => " allegiance ",
        " obeisant "                => " civil ",
        " obelisk "                 => " brace ",
        " obese "                   => " adipose ",
        " obesity "                 => " blubber ",
        " obeying "                 => " abject ",
        " obfuscate "               => " conceal ",
        " obfuscated "              => " bleared ",
        " obit "                    => " announcement ",
        " obiter "                  => " animadversion ",
        " object "                  => " article ",
        " object-oriented "         => " acquisitive ",
        " objectify "               => " actualize ",
        " objecting "               => " aghast ",
        " objection "               => " argument ",
        " objectionable "           => " abhorrent ",
        " objective "               => " cold ",
        " objectively "             => " considerately ",
        " objectless "              => " accidental ",
        " objector "                => " activist ",
        " objects "                 => " altar ",
        " objuration "              => " anathema ",
        " objurgate "               => " bother ",
        " objurgation "             => " accusation ",
        " oblate "                  => " collapsed ",
        " oblation "                => " alms ",
        " obligate "                => " astrict ",
        " obligated "               => " answerable ",
        " obligatoriness "          => " albatross ",
        " obligatory "              => " binding ",
        " oblige "                  => " bind ",
        " obliged "                 => " answerable ",
        " obliging "                => " accommodating ",
        " obligingly "              => " affably ",
        " obligingness "            => " accommodativeness ",
        " oblique "                 => " angled ",
        " obliquely "               => " askance ",
        " obliqueness "             => " artifice ",
        " obliquitous "             => " aberrant ",
        " obliquity "               => " bend ",
        " obliterated "             => " abandoned ",
        " obliteration "            => " abolishment ",
        " oblivion "                => " abeyance ",
        " oblivious "               => " absent ",
        " obliviousness "           => " absent-mindedness ",
        " oblong "                  => " ellipsoidal ",
        " obloquious "              => " calumniating ",
        " obloquy "                 => " abuse ",
        " obnoxious "               => " abhorrent ",
        " obscene "                 => " atrocious ",
        " obscenity "               => " abomination ",
        " obscuration "             => " beard ",
        " obscure "                 => " abstruse ",
        " obscured "                => " blocked ",
        " obscuring "               => " abashing ",
        " obsecrate "               => " abjure ",
        " obsequies "               => " burying ",
        " obsequious "              => " abject ",
        " obsequiousness "          => " adulation ",
        " observable "              => " appreciable ",
        " observance "              => " acknowledgment ",
        " observant "               => " advertent ",
        " observation "             => " ascertainment ",
        " observational "           => " empiric ",
        " observative "             => " alert ",
        " observatory "             => " anchor ",
        " observe "                 => " beam ",
        " observed "                => " empiric ",
        " observer "                => " eyewitness ",
        " observers "               => " assemblage ",
        " observing "               => " celebratory ",
        " obsess "                  => " captivate ",
        " obsessed "                => " bedeviled ",
        " obsessing "               => " absorbing ",
        " obsession "               => " attraction ",
        " obsessive "               => " affected ",
        " obsessiveness "           => " abandonment ",
        " obsidian "                => " atramentous ",
        " obsolescent "             => " aged ",
        " obsolete "                => " anachronistic ",
        " obstinacy "               => " backbone ",
        " obstinance "              => " backbone ",
        " obstinate "               => " adamant ",
        " obstreperous "            => " boisterous ",
        " obstruct "                => " arrest ",
        " obstructed "              => " blocked ",
        " obstructive "             => " adverse ",
        " obstructiveness "         => " action ",
        " obtain "                  => " access ",
        " obtainable "              => " achievable ",
        " obtained "                => " acquired ",
        " obtaining "               => " accepting ",
        " obtest "                  => " abjure ",
        " obtruder "                => " alien ",
        " obtrusion "               => " breach ",
        " obtrusive "               => " bulging ",
        " obtund "                  => " attenuate ",
        " obtuse "                  => " birdbrained ",
        " obtusely "                => " foolishly ",
        " obtuseness "              => " benightedness ",
        " obverse "                 => " antipode ",
        " obviate "                 => " anticipate ",
        " obvious "                 => " accessible ",
        " obviously "               => " acutely ",
        " obviousness "             => " accuracy ",
        " occasion "                => " break ",
        " occasional "              => " casual ",
        " occlude "                 => " choke ",
        " occluded "                => " chock-full ",
        " occludent "               => " blockade ",
        " occlusion "               => " occlusion ",
        " occult "                  => " abstruse ",
        " occultation "             => " beard ",
        " occultism "               => " abracadabra ",
        " occupancy "               => " control ",
        " occupant "                => " addressee ",
        " occupation "              => " activity ",
        " occupational "            => " anatomic ",
        " occupied "                => " active ",
        " occupier "                => " aborigine ",
        " occupy "                  => " absorb ",
        " occupying "               => " application ",
        " occur "                   => " action ",
        " occurrence "              => " accident ",
        " ocean-going "             => " abyssal ",
        " oceanfront "              => " beach ",
        " oceangoing "              => " abyssal ",
        " oceanic "                 => " amphibian ",
        " oceanographic "           => " abyssal ",
        " ocelot "                  => " bobcat ",
        " ochre "                   => " amber ",
        " ochroid "                 => " aureate ",
        " octavo "                  => " album ",
        " oddball "                 => " camp ",
        " oddity "                  => " anomaly ",
        " oddly "                   => " abnormally ",
        " oddment "                 => " butt ",
        " oddments "                => " debris ",
        " oddness "                 => " aberration ",
        " odds "                    => " allowance ",
        " odeum "                   => " amphitheater ",
        " odic "                    => " anapestic ",
        " odious "                  => " abhorrent ",
        " odist "                   => " artist ",
        " odium "                   => " abhorrence ",
        " odoriferous "             => " ambrosial ",
        " odorous "                 => " aromatic ",
        " odyl "                    => " attractiveness ",
        " odyssey "                 => " adventure ",
        " oeuvre "                  => " bulk ",
        " off-balance "             => " asymmetric ",
        " off-base "                => " aberrant ",
        " off-beam "                => " adrift ",
        " off-beat "                => " camp ",
        " off-center "              => " askance ",
        " off-color "               => " blue ",
        " off-course "              => " adrift ",
        " off-key "                 => " abnormal ",
        " off-lying "               => " afar ",
        " off-putting "             => " black ",
        " off-target "              => " astray ",
        " off-the-wall "            => " camp ",
        " off-time "                => " answer ",
        " off-track "               => " absent ",
        " off-white "               => " fair ",
        " offal "                   => " bits ",
        " offed "                   => " asleep ",
        " offence "                 => " answerability ",
        " offend "                  => " affront ",
        " offended "                => " affronted ",
        " offender "                => " blackmailer ",
        " offending "               => " behind ",
        " offense "                 => " breach ",
        " offenseless "             => " artless ",
        " offensive "               => " abhorrent ",
        " offensiveness "           => " abomination ",
        " offer "                   => " action ",
        " offering "                => " alms ",
        " offertory "               => " allowance ",
        " offgoing "                => " adieu ",
        " offhand "                 => " abrupt ",
        " office "                  => " appointment ",
        " office-seeker "           => " applicant ",
        " officeholder "            => " administrator ",
        " officer "                 => " administrator ",
        " officers "                => " admiral ",
        " officialdom "             => " authority ",
        " officialism "             => " academism ",
        " officially "              => " clearly ",
        " officials "               => " admiral ",
        " officious "               => " busy ",
        " officiousness "           => " concern ",
        " offing "                  => " annihilation ",
        " offish "                  => " above ",
        " offprint "                => " album ",
        " offset "                  => " account ",
        " offshoot "                => " adjunct ",
        " offshore "                => " adopted ",
        " offspring "               => " baby ",
        " oft-repeated "            => " around-the-clock ",
        " often "                   => " generally ",
        " ogee "                    => " ambit ",
        " ogling "                  => " boring ",
        " ogre "                    => " bogey ",
        " ogress "                  => " aborigine ",
        " oil-soaked "              => " adipose ",
        " oiled "                   => " bashed ",
        " oily "                    => " adipose ",
        " oink "                    => " badge ",
        " ointment "                => " balm ",
        " okay "                    => " accept ",
        " okayed "                  => " accustomed ",
        " okey-dokey "              => " acceptable ",
        " old-fangled "             => " aged ",
        " old-fashioned "           => " ancient ",
        " old-line "                => " common ",
        " old-maidish "             => " careful ",
        " old-womanish "            => " careful ",
        " olden "                   => " antiquarian ",
        " older "                   => " earlier ",
        " oldfangled "              => " ancient ",
        " oldie "                   => " age-old ",
        " oldish "                  => " aged ",
        " oldness "                 => " elderliness ",
        " oleaginous "              => " adipose ",
        " oleo "                    => " blind ",
        " olfactive "               => " aromatic ",
        " olfactory "               => " adenoids ",
        " oligarch "                => " absolutist ",
        " oligopoly "               => " cartel ",
        " olio "                    => " accumulation ",
        " olive-brown "             => " beige ",
        " omen "                    => " augury ",
        " omination "               => " anticipation ",
        " ominous "                 => " apocalyptic ",
        " omission "                => " blank ",
        " omitted "                 => " bare ",
        " omitting "                => " abbreviating ",
        " omneity "                 => " absoluteness ",
        " omnibus "                 => " album ",
        " omnifarious "             => " anthologized ",
        " omniform "                => " anthologized ",
        " omnipotent "              => " almighty ",
        " omnipresence "            => " attendance ",
        " omnipresent "             => " all-knowing ",
        " omniscient "              => " all-seeing ",
        " omnitude "                => " absoluteness ",
        " omnivorous "              => " cannibal ",
        " on-again-off-again "      => " broken ",
        " once "                    => " already ",
        " once-over "               => " assay ",
        " oncoming "                => " advancing ",
        " one-act "                 => " comedy ",
        " one-dimensional "         => " apparent ",
        " one-fourth "              => " division ",
        " one-liner "               => " crack ",
        " one-party "               => " absolutism ",
        " one-piece "               => " jumpsuit ",
        " one-sided "               => " biased ",
        " one-sidedness "           => " bent ",
        " one-time "                => " ancient ",
        " one-upmanship "           => " artfulness ",
        " oneness "                 => " absoluteness ",
        " onerous "                 => " arduous ",
        " onfall "                  => " access ",
        " ongoing "                 => " advancing ",
        " onliest "                 => " abandoned ",
        " onlooker "                => " beholder ",
        " onlookers "               => " assemblage ",
        " only "                    => " alone ",
        " onomatopoeia "            => " answer ",
        " onomatopoeic "            => " artful ",
        " onrush "                  => " advance ",
        " onrushing "               => " advancing ",
        " onset "                   => " access ",
        " onslaught "               => " aggression ",
        " onto "                    => " assimilate ",
        " ontology "                => " aesthetics ",
        " onward "                  => " alee ",
        " onwards "                 => " advanced ",
        " onyx "                    => " atramentous ",
        " oodles "                  => " bulk ",
        " oofy "                    => " affluent ",
        " ooid "                    => " egg-shaped ",
        " oomph "                   => " action ",
        " ooze "                    => " alluvium ",
        " oozing "                  => " arising ",
        " oozy "                    => " clammy ",
        " opacity "                 => " caliginosity ",
        " opalescence "             => " afterglow ",
        " opalescent "              => " bleary ",
        " opaline "                 => " irised ",
        " opaque "                  => " blurred ",
        " open "                    => " accessible ",
        " open-air "                => " amphitheater ",
        " open-and-shut "           => " apparent ",
        " open-door "               => " admissible ",
        " open-ended "              => " advancing ",
        " open-eyed "               => " acute ",
        " open-handedly "           => " abundantly ",
        " open-minded "             => " advanced ",
        " open-mindedness "         => " broad-mindedness ",
        " open-mouthed "            => " agog ",
        " open-sesame "             => " abracadabra ",
        " opening "                 => " aperture ",
        " openly "                  => " aboveboard ",
        " openness "                => " artlessness ",
        " openwork "                => " applique ",
        " operable "                => " applicable ",
        " operate "                 => " accomplish ",
        " operative "               => " accessible ",
        " operativeness "           => " activity ",
        " operatives "              => " agents ",
        " operator "                => " abettor ",
        " opiate "                  => " analgesic ",
        " opine "                   => " admonish ",
        " opinion "                 => " assessment ",
        " opinionated "             => " adamant "