<?php
$this->load->view('admin/comman/header');
?>
<div class="clearfix"></div>
<div class="content-wrapper">
    <div class="container-fluid">
        <!-- Breadcrumb-->
        <div class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Magazine List</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/magazine">Magazine</a></li>
                    <li class="breadcrumb-item active" aria-current="page">List</li>
                </ol>
            </div>
            <div class="col-sm-3">
                <div class="btn-group float-sm-right">
                    <a href="<?php echo base_url(); ?>admin/magazine/add"
                        class="btn btn-outline-primary waves-effect waves-light">Add</a>

                </div>
            </div>
        </div>
        <!-- End Breadcrumb-->
        <div class="">
            <div class="card">
                <div class="card-header"><i class="fa fa-table"></i> Magazine Record</div>
                <div class="card-body">
                    <div class="">
                        <table id="magazine-datatable" class="table-sm table-striped table-bordered" width="100%">
                            <thead class="badge-secondary">
                                <tr>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Author Name</th>
                                    <th>Price</th>
                                    <th>Total Sales</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- End Row-->

    <?php $this->load->view('admin/comman/footerpage');?>
    <script>
    $(document).ready(function() {
        var dataTable = $('#magazine-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                url: "<?php echo base_url() . 'admin/magazine/fetch_data'; ?>",
                type: "POST"
            },
            "columnDefs": [{
                //  "targets":[0, 3, 4],
                "orderable": false,
            }, ],
        });
    });
    </script>