<?php
$this->load->view('admin/comman/header');
?>
<div class="content-wrapper">
    <div class="container-fluid">
        <!-- Breadcrumb-->
        <div class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Books list</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo base_url()?>admin/dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo base_url()?>admin/book">Books</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Books list</li>
                </ol>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header"><i class="fa fa-table"></i> Book Chapter</div>
                    <div class="card-body">

                        <form id="books_chapter" enctype="multipart/form-data">
                            <div class="row col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label class="pull-left">Chapter Name</label>
                                    <input type="text" required value="" class="form-control" name="title" id="title">
                                </div>
                                <input type="hidden" name="book_id" value="<?php echo $book_id;?>">
                                <div class="form-group col-lg-6">
                                    <label class="pull-left">Chapter price</label>
                                    <input type="text" required value="" class="form-control" name="price" id="price"
                                        placeholder="Enter Book Price">
                                </div>
                            </div>
                            <div class="form-group col-lg-6">
                                <label class="pull-left"> Upload Full Chapter</label>
                                <input type="file" required class="form-control" name="url" id="url"
                                    placeholder="select Full Book">
                            </div>
                            <div class="row col-lg-12 pull-left">
                                <button type="button" onclick="saveBookChapter()" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Breadcrumb-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header"><i class="fa fa-table"></i> Books Chapter</div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="book-datatable" class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Price</th>
                                        <th>Action</th>
                                    </tr>
                                    <?php foreach ($book_chapter as $key => $value) {
                                        ?>
                                    <tr>
                                        <td><a target="_blank"
                                                href="<?php echo base_url().'assets/images/books_chapte/'.$value->url;?>"><?php echo $value->title;?></a>
                                        </td>
                                        <td><?php echo $value->price;?></td>
                                        <td><a href="javaScript:void(0)"
                                                onclick="delete_record('<?php echo $value->id;?>','book_chapter','<?php echo $value->title;?>')">Delete</a>
                                        </td>
                                    </tr>
                                    <?php } ?>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- End Row-->
    </div>
</div>
<?php $this->load->view('admin/comman/footerpage'); ?>
<script type="text/javascript">
function saveBookChapter() {
    $("#dvloader").show();
    var formData = new FormData($("#books_chapter")[0]);

    $.ajax({
        type: 'POST',
        url: '<?php echo base_url(); ?>admin/book/saveBookChapter',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(resp) {
            $("#dvloader").hide();
            if (resp.status == '200') {
                document.getElementById("books_chapter").reset();
                toastr.success(resp.message, 'success');
                setTimeout(function() {
                    window.location.replace('<?php echo base_url(); ?>admin/book/chapter_list/' +
                        resp.id);
                }, 500);
            } else {
                var obj = resp.message;
                if (typeof obj === 'string') {
                    toastr.error(obj);
                } else {
                    $.each(obj, function(i, e) {
                        toastr.error(e);
                    });

                }
            }
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            $("#dvloader").hide();
            toastr.error(errorThrown.msg, 'failed');
        }
    });
}
</script>